/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import kafka.security.authorizer.AclAuthorizer;
import kafka.server.KafkaConfig;
import kafka.server.link.AclBindingFilterTransformer;
import kafka.server.link.ClusterLinkAdminClient;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTestUtils$;
import kafka.server.link.IdentityAclBindingFilterTransformer;
import kafka.utils.Implicits;
import kafka.utils.TestUtils$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ClusterLinkPausedException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.authorizer.Authorizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ue\u0001B\u000e\u001d\u0001\rBQA\u000b\u0001\u0005\u0002-BqA\f\u0001C\u0002\u0013\u0005q\u0006\u0003\u00044\u0001\u0001\u0006I\u0001\r\u0005\ni\u0001\u0001\r\u00111A\u0005\u0002UB\u0011\"\u000f\u0001A\u0002\u0003\u0007I\u0011\u0001\u001e\t\u0013\u0001\u0003\u0001\u0019!A!B\u00131\u0004bB!\u0001\u0005\u0004%\tA\u0011\u0005\u0007\u0015\u0002\u0001\u000b\u0011B\"\t\u000f-\u0003!\u0019!C\u0001\u0019\"1\u0001\u000b\u0001Q\u0001\n5Cq!\u0015\u0001C\u0002\u0013\u0005!\u000b\u0003\u0004a\u0001\u0001\u0006Ia\u0015\u0005\bC\u0002\u0011\r\u0011\"\u0001c\u0011\u00191\u0007\u0001)A\u0005G\")q\r\u0001C\u0001Q\")A\u000f\u0001C\u0001Q\")a\u000f\u0001C\u0001Q\")\u0001\u0010\u0001C\u0001Q\")!\u0010\u0001C\u0001w\"1\u0011\u0011\u0005\u0001\u0005\u0002!Da!!\n\u0001\t\u0003A\u0007bBA\u0015\u0001\u0011%\u00111\u0006\u0005\n\u0003G\u0002\u0011\u0013!C\u0005\u0003KBq!a\u001f\u0001\t\u0013\ti\bC\u0004\u0002>\u0001!I!a!\t\u000f\u0005\u001d\u0005\u0001\"\u0003\u0002\n\n\u00013\t\\;ti\u0016\u0014H*\u001b8l\t\u0016\u001cHo\u00117jK:$X*\u00198bO\u0016\u0014H+Z:u\u0015\tib$\u0001\u0003mS:\\'BA\u0010!\u0003\u0019\u0019XM\u001d<fe*\t\u0011%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001!\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002YA\u0011Q\u0006A\u0007\u00029\u0005I1o\u00195fIVdWM]\u000b\u0002aA\u0011Q&M\u0005\u0003eq\u0011Ac\u00117vgR,'\u000fT5oWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018AC:dQ\u0016$W\u000f\\3sA\u0005i1\r\\5f]Rl\u0015M\\1hKJ,\u0012A\u000e\t\u0003[]J!\u0001\u000f\u000f\u00039\rcWo\u001d;fe2Kgn\u001b#fgR\u001cE.[3oi6\u000bg.Y4fe\u0006\t2\r\\5f]Rl\u0015M\\1hKJ|F%Z9\u0015\u0005mr\u0004CA\u0013=\u0013\tidE\u0001\u0003V]&$\bbB \u0006\u0003\u0003\u0005\rAN\u0001\u0004q\u0012\n\u0014AD2mS\u0016tG/T1oC\u001e,'\u000fI\u0001\u000bCV$\bn\u001c:ju\u0016\u0014X#A\"\u0011\u0005\u0011CU\"A#\u000b\u0005\u00053%BA$!\u0003!\u0019XmY;sSRL\u0018BA%F\u00055\t5\r\\!vi\"|'/\u001b>fe\u0006Y\u0011-\u001e;i_JL'0\u001a:!\u0003I\u0019G.^:uKJd\u0015N\\6NC:\fw-\u001a:\u0016\u00035\u0003\"!\f(\n\u0005=c\"AE\"mkN$XM\u001d'j].l\u0015M\\1hKJ\f1c\u00197vgR,'\u000fT5oW6\u000bg.Y4fe\u0002\n\u0011\u0002Z3ti\u0006#W.\u001b8\u0016\u0003M\u0003\"\u0001\u00160\u000e\u0003US!AV,\u0002\u000b\u0005$W.\u001b8\u000b\u0005aK\u0016aB2mS\u0016tGo\u001d\u0006\u0003CiS!a\u0017/\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0016aA8sO&\u0011q,\u0016\u0002\u000f\u0007>tg\r\\;f]R\fE-\\5o\u0003)!Wm\u001d;BI6Lg\u000eI\u0001\b[\u0016$(/[2t+\u0005\u0019\u0007CA\u0017e\u0013\t)GD\u0001\nDYV\u001cH/\u001a:MS:\\W*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002\u001fQ,7\u000f\u001e*fG>tg-[4ve\u0016$\u0012a\u000f\u0015\u0003\u001f)\u0004\"a\u001b:\u000e\u00031T!!\u001c8\u0002\u0007\u0005\u0004\u0018N\u0003\u0002pa\u00069!.\u001e9ji\u0016\u0014(BA9]\u0003\u0015QWO\\5u\u0013\t\u0019HN\u0001\u0003UKN$\u0018A\u0003;fgR$v\u000e]5dg\"\u0012\u0001C[\u0001\u0017i\u0016\u001cH/Q2m'ft7\rV1tWN#\u0018M\u001d;va\"\u0012\u0011C[\u0001,i\u0016\u001cH/Q2m'ft7\rV1tWN#\u0018M\u001d;va^KG\u000f\u001b*fg>,(oY3JI\u0016s\u0017M\u00197fI\"\u0012!C[\u0001,m\u0016\u0014\u0018NZ=BG24\u0015\u000e\u001c;feN\u001cuN\u001c4jO^KG\u000f\u001b*fg>,(oY3JI\u0016s\u0017M\u00197fIR11\b`A\n\u0003;AQ!`\nA\u0002y\f!#\\5he\u0006$X-\u00117m\u0003\u000ed7OS:p]B\u0019q0!\u0004\u000f\t\u0005\u0005\u0011\u0011\u0002\t\u0004\u0003\u00071SBAA\u0003\u0015\r\t9AI\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005-a%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001f\t\tB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u00171\u0003bBA\u000b'\u0001\u0007\u0011qC\u0001\u0012e\u0016\u001cx.\u001e:dK&#g)\u001b7uKJ\u001c\bcA\u0013\u0002\u001a%\u0019\u00111\u0004\u0014\u0003\u000f\t{w\u000e\\3b]\"9\u0011qD\nA\u0002\u0005]\u0011aD3ya\u0016\u001cG/\u001a3GC&dWO]3\u0002MQ,7\u000f^!dYNKhn\u0019+bg.\u001cF/\u0019:ukB<\u0016\u000e\u001e5O_\u0006+H\u000f[8sSj,'\u000f\u000b\u0002\u0015U\u0006AB/Z:u\u0003\u000ed7+\u001f8d)\u0006\u001c8NT8Ti\u0006\u0014H/\u001e9)\u0005UQ\u0017\u0001\u00058fo\u000ec\u0017.\u001a8u\u001b\u0006t\u0017mZ3s)-1\u0014QFA\u0019\u0003w\tY%a\u0018\t\r\u0005=b\u00031\u0001\u007f\u0003!a\u0017N\\6OC6,\u0007bBA\u001a-\u0001\u0007\u0011QG\u0001\u0007G>tg-[4\u0011\u00075\n9$C\u0002\u0002:q\u0011\u0011c\u00117vgR,'\u000fT5oW\u000e{gNZ5h\u0011\u001d\tiD\u0006a\u0001\u0003\u007f\tA\"\u00193nS:4\u0015m\u0019;pef\u0004r!JA!\u0003k\t)%C\u0002\u0002D\u0019\u0012\u0011BR;oGRLwN\\\u0019\u0011\u00075\n9%C\u0002\u0002Jq\u0011ac\u00117vgR,'\u000fT5oW\u0006#W.\u001b8DY&,g\u000e\u001e\u0005\u0007\u0003Z\u0001\r!!\u0014\u0011\u000b\u0015\ny%a\u0015\n\u0007\u0005EcE\u0001\u0004PaRLwN\u001c\t\u0005\u0003+\nY&\u0004\u0002\u0002X)\u0019\u0011)!\u0017\u000b\u0005}I\u0016\u0002BA/\u0003/\u0012!\"Q;uQ>\u0014\u0018N_3s\u0011!\t\tG\u0006I\u0001\u0002\u0004q\u0018\u0001\u0007:fg>,(oY3JIN+\b\u000f]8si\u0016s\u0017M\u00197fI\u0006Qb.Z<DY&,g\u000e^'b]\u0006<WM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011q\r\u0016\u0004}\u0006%4FAA6!\u0011\ti'a\u001e\u000e\u0005\u0005=$\u0002BA9\u0003g\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005Ud%\u0001\u0006b]:|G/\u0019;j_:LA!!\u001f\u0002p\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001b\rdwn]3NC:\fw-\u001a:t)\rY\u0014q\u0010\u0005\u0007\u0003\u0003C\u0002\u0019\u0001\u001c\u00021\rdWo\u001d;fe2Kgn[\"mS\u0016tG/T1oC\u001e,'\u000f\u0006\u0003\u0002F\u0005\u0015\u0005bBA\u001a3\u0001\u0007\u0011QG\u0001\n]\u0016<8i\u001c8gS\u001e$B!!\u000e\u0002\f\"9\u0011Q\u0012\u000eA\u0002\u0005=\u0015aB2p]\u001aLwm\u001d\t\u0006\u007f\u0006EeP`\u0005\u0005\u0003'\u000b\tBA\u0002NCB\u0004")
public class ClusterLinkDestClientManagerTest {
    private final ClusterLinkScheduler scheduler = (ClusterLinkScheduler)Mockito.mock(ClusterLinkScheduler.class);
    private ClusterLinkDestClientManager clientManager;
    private final AclAuthorizer authorizer = (AclAuthorizer)Mockito.mock(AclAuthorizer.class);
    private final ClusterLinkManager clusterLinkManager = (ClusterLinkManager)Mockito.mock(ClusterLinkManager.class);
    private final ConfluentAdmin destAdmin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
    private final ClusterLinkMetrics metrics = (ClusterLinkMetrics)Mockito.mock(ClusterLinkMetrics.class);

    public ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    public ClusterLinkDestClientManager clientManager() {
        return this.clientManager;
    }

    public void clientManager_$eq(ClusterLinkDestClientManager x$1) {
        this.clientManager = x$1;
    }

    public AclAuthorizer authorizer() {
        return this.authorizer;
    }

    public ClusterLinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    public ConfluentAdmin destAdmin() {
        return this.destAdmin;
    }

    public ClusterLinkMetrics metrics() {
        return this.metrics;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReconfigure() {
        void newClientManager_adminFactory;
        void newClientManager_authorizer;
        void newClientManager_resourceIdSupportEnabled;
        String linkName = "test-link";
        IntRef factoryCalled = IntRef.create((int)0);
        ObjectRef factoryConfig = ObjectRef.create((Object)this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:1234")})))));
        ObjectRef factoryAdmin = ObjectRef.create((Object)((KafkaAdminClient)Mockito.mock(KafkaAdminClient.class)));
        String string = "false";
        Some some = new Some((Object)this.authorizer());
        Function1 & Serializable intersect = (Function1 & Serializable)config -> ClusterLinkDestClientManagerTest.adminFactoryWithCount$1(config, factoryCalled, factoryConfig, factoryAdmin);
        ClusterLinkConfig newClientManager_config = (ClusterLinkConfig)factoryConfig.elem;
        Mockito.when((Object)this.scheduler().schedule(ArgumentMatchers.anyString(), (Runnable)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn(null);
        ClusterLinkData newClientManager_linkData = new ClusterLinkData(linkName, Uuid.randomUuid(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        ClusterLinkFetcherManager newClientManager_fetcherManager = (ClusterLinkFetcherManager)Mockito.mock(ClusterLinkFetcherManager.class);
        ClusterLinkMetadataManager newClientManager_metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
        Mockito.when((Object)this.clusterLinkManager().metadataManager()).thenReturn((Object)newClientManager_metadataManager);
        Properties newClientManager_brokerConfig = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        newClientManager_brokerConfig.put("multitenant.authorizer.support.resource.ids", (Object)newClientManager_resourceIdSupportEnabled);
        Object var7_8 = null;
        intersect = null;
        some = null;
        string = null;
        Object var11_9 = null;
        Object var12_10 = null;
        Object var13_11 = null;
        Object var14_12 = null;
        ClusterLinkDestClientManager clientManager = new ClusterLinkDestClientManager(this.clusterLinkManager(), new KafkaConfig((Map)newClientManager_brokerConfig), newClientManager_linkData, newClientManager_fetcherManager, this.scheduler(), newClientManager_config, (Option)newClientManager_authorizer, (Option)None$.MODULE$, this.metrics(), (Function1)newClientManager_adminFactory, (Function0 & Serializable)() -> this.destAdmin(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer());
        Assertions.assertEquals((int)0, (int)factoryCalled.elem);
        clientManager.startup();
        try {
            Assertions.assertEquals((int)1, (int)factoryCalled.elem);
            Assertions.assertTrue(((KafkaAdminClient)factoryAdmin.elem == clientManager.getAdmin() ? 1 : 0) != 0);
            factoryAdmin.elem = (KafkaAdminClient)Mockito.mock(KafkaAdminClient.class);
            factoryConfig.elem = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:2345")}))));
            clientManager.reconfigure((ClusterLinkConfig)factoryConfig.elem, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bootstrap.servers"})));
            Assertions.assertEquals((int)2, (int)factoryCalled.elem);
            Assertions.assertTrue(((KafkaAdminClient)factoryAdmin.elem == clientManager.getAdmin() ? 1 : 0) != 0);
            factoryConfig.elem = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:2345"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.NumClusterLinkFetchersProp()), (Object)"5")}))));
            clientManager.reconfigure((ClusterLinkConfig)factoryConfig.elem, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ClusterLinkConfig$.MODULE$.NumClusterLinkFetchersProp()})));
            Assertions.assertEquals((int)2, (int)factoryCalled.elem);
            factoryConfig.elem = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:3456"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"true")}))));
            clientManager.reconfigure((ClusterLinkConfig)factoryConfig.elem, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ClusterLinkConfig$.MODULE$.NumClusterLinkFetchersProp(), "bootstrap.servers", ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()})));
            Assertions.assertEquals((int)2, (int)factoryCalled.elem);
            Assertions$.MODULE$.intercept((Function0 & Serializable)() -> clientManager.getAdmin(), ClassTag$.MODULE$.apply(ClusterLinkPausedException.class), new Position("ClusterLinkDestClientManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
            factoryConfig.elem = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:4567"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"true")}))));
            clientManager.reconfigure((ClusterLinkConfig)factoryConfig.elem, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bootstrap.servers"})));
            Assertions.assertEquals((int)2, (int)factoryCalled.elem);
            Assertions$.MODULE$.intercept((Function0 & Serializable)() -> clientManager.getAdmin(), ClassTag$.MODULE$.apply(ClusterLinkPausedException.class), new Position("ClusterLinkDestClientManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            factoryAdmin.elem = (KafkaAdminClient)Mockito.mock(KafkaAdminClient.class);
            factoryConfig.elem = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:4567")}))));
            clientManager.reconfigure((ClusterLinkConfig)factoryConfig.elem, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()})));
            Assertions.assertEquals((int)3, (int)factoryCalled.elem);
            Assertions.assertTrue(((KafkaAdminClient)factoryAdmin.elem == clientManager.getAdmin() ? 1 : 0) != 0);
        }
        finally {
            this.closeManagers(clientManager);
        }
        Assertions.assertEquals((int)3, (int)factoryCalled.elem);
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> clientManager.getAdmin(), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ClusterLinkDestClientManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopics() {
        void newClientManager_authorizer;
        void newClientManager_resourceIdSupportEnabled;
        String linkName = "test-link";
        ClusterLinkConfig config2 = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:1234")}))));
        String string = "false";
        Some some = new Some((Object)this.authorizer());
        Function1 & Serializable newClientManager_adminFactory = (Function1 & Serializable)config -> this.adminFactory((ClusterLinkConfig)config);
        Mockito.when((Object)this.scheduler().schedule(ArgumentMatchers.anyString(), (Runnable)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn(null);
        ClusterLinkData newClientManager_linkData = new ClusterLinkData(linkName, Uuid.randomUuid(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        ClusterLinkFetcherManager newClientManager_fetcherManager = (ClusterLinkFetcherManager)Mockito.mock(ClusterLinkFetcherManager.class);
        ClusterLinkMetadataManager newClientManager_metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
        Mockito.when((Object)this.clusterLinkManager().metadataManager()).thenReturn((Object)newClientManager_metadataManager);
        Properties newClientManager_brokerConfig = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        newClientManager_brokerConfig.put("multitenant.authorizer.support.resource.ids", (Object)newClientManager_resourceIdSupportEnabled);
        Object var6_5 = null;
        some = null;
        string = null;
        Object var9_6 = null;
        Object var10_7 = null;
        Object var11_8 = null;
        Object var12_9 = null;
        ClusterLinkDestClientManager clientManager = new ClusterLinkDestClientManager(this.clusterLinkManager(), new KafkaConfig((Map)newClientManager_brokerConfig), newClientManager_linkData, newClientManager_fetcherManager, this.scheduler(), config2, (Option)newClientManager_authorizer, (Option)None$.MODULE$, this.metrics(), (Function1)newClientManager_adminFactory, (Function0 & Serializable)() -> this.destAdmin(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer());
        .colon.colon topics = new .colon.colon((Object)"topic0", (List)new .colon.colon((Object)"topic1", (List)new .colon.colon((Object)"topic2", (List)Nil$.MODULE$)));
        clientManager.startup();
        try {
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)clientManager.getTopics());
            clientManager.addTopics((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.head(), (String)topics.apply(1)})));
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.head(), (String)topics.apply(1)})), (Object)clientManager.getTopics());
            clientManager.addTopics((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.apply(1), (String)topics.apply(2)})));
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.head(), (String)topics.apply(1), (String)topics.apply(2)})), (Object)clientManager.getTopics());
            clientManager.removeTopics((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.apply(2), (String)topics.head()})));
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.apply(1)})), (Object)clientManager.getTopics());
            clientManager.removeTopics((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.apply(1), "unknown"})));
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)clientManager.getTopics());
        }
        finally {
            this.closeManagers(clientManager);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAclSyncTaskStartup() {
        void newClientManager_authorizer;
        void newClientManager_resourceIdSupportEnabled;
        String linkName = "test-link";
        String migrateAllAclsJson = ClusterLinkTestUtils$.MODULE$.AllAclsFilter();
        ClusterLinkConfig config2 = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:1234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)migrateAllAclsJson)}))));
        String string = "false";
        Some some = new Some((Object)this.authorizer());
        Function1 & Serializable newClientManager_adminFactory = (Function1 & Serializable)config -> this.adminFactory((ClusterLinkConfig)config);
        Mockito.when((Object)this.scheduler().schedule(ArgumentMatchers.anyString(), (Runnable)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn(null);
        ClusterLinkData newClientManager_linkData = new ClusterLinkData(linkName, Uuid.randomUuid(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        ClusterLinkFetcherManager newClientManager_fetcherManager = (ClusterLinkFetcherManager)Mockito.mock(ClusterLinkFetcherManager.class);
        ClusterLinkMetadataManager newClientManager_metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
        Mockito.when((Object)this.clusterLinkManager().metadataManager()).thenReturn((Object)newClientManager_metadataManager);
        Properties newClientManager_brokerConfig = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        newClientManager_brokerConfig.put("multitenant.authorizer.support.resource.ids", (Object)newClientManager_resourceIdSupportEnabled);
        Object var6_6 = null;
        some = null;
        string = null;
        Object var9_7 = null;
        Object var10_8 = null;
        Object var11_9 = null;
        Object var12_10 = null;
        ClusterLinkDestClientManager clientManager = new ClusterLinkDestClientManager(this.clusterLinkManager(), new KafkaConfig((Map)newClientManager_brokerConfig), newClientManager_linkData, newClientManager_fetcherManager, this.scheduler(), config2, (Option)newClientManager_authorizer, (Option)None$.MODULE$, this.metrics(), (Function1)newClientManager_adminFactory, (Function0 & Serializable)() -> this.destAdmin(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer());
        clientManager.startup();
        try {
            Predef$.MODULE$.assert(clientManager.getSyncAclTask().isDefined());
        }
        finally {
            this.closeManagers(clientManager);
        }
    }

    @Test
    public void testAclSyncTaskStartupWithResourceIdEnabled() {
        String filterWithNullAndResourceId = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"aclFilters\": [\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |  \"accessFilter\": {\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        | },\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |   \"accessFilter\": {\n        |     \"principal\": \"User:pool-1\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        | },\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |  \"accessFilter\": {\n        |     \"principal\": \"User:u-4\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }}]\n        | }"));
        this.verifyAclFiltersConfigWithResourceIdEnabled(filterWithNullAndResourceId, false, true);
        String filterWithIntegerAndResourceId = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"aclFilters\": [\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |  \"accessFilter\": {\n        |     \"principal\": \"User:4\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        | },\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |   \"accessFilter\": {\n        |     \"principal\": \"User:pool-1\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        | },\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |  \"accessFilter\": {\n        |     \"principal\": \"User:u-4\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }}]\n        | }"));
        this.verifyAclFiltersConfigWithResourceIdEnabled(filterWithIntegerAndResourceId, false, true);
        String filterWithResourceIdAndPoolId = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"aclFilters\": [\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |  \"accessFilter\": {\n        |     \"principal\": \"UserV2:*\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        | },\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |   \"accessFilter\": {\n        |     \"principal\": \"User:pool-1\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        | },\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |  \"accessFilter\": {\n        |     \"principal\": \"User:u-4\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }}]\n        | }"));
        this.verifyAclFiltersConfigWithResourceIdEnabled(filterWithResourceIdAndPoolId, true, false);
        String filterWithIntegerIdAndPoolId = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"aclFilters\": [\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |  \"accessFilter\": {\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        | },\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |   \"accessFilter\": {\n        |     \"principal\": \"User:pool-1\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        | },\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |  \"accessFilter\": {\n        |     \"principal\": \"User:4\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }}]\n        | }"));
        this.verifyAclFiltersConfigWithResourceIdEnabled(filterWithIntegerIdAndPoolId, false, false);
        this.verifyAclFiltersConfigWithResourceIdEnabled("", false, false);
        String filterWithPoolId = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"aclFilters\": [\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |   \"accessFilter\": {\n        |     \"principal\": \"User:pool-1\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        | },\n        | { \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |  \"accessFilter\": {\n        |     \"principal\": \"User:pool-4\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }}]\n        | }"));
        this.verifyAclFiltersConfigWithResourceIdEnabled(filterWithPoolId, true, false);
    }

    /*
     * WARNING - void declaration
     */
    public void verifyAclFiltersConfigWithResourceIdEnabled(String migrateAllAclsJson, boolean resourceIdFilters, boolean expectedFailure) {
        void newClientManager_authorizer;
        void newClientManager_resourceIdSupportEnabled;
        String linkName = "test-link";
        ClusterLinkConfig config2 = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:1234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)migrateAllAclsJson)}))));
        String string = "true";
        Some some = new Some((Object)this.authorizer());
        Function1 & Serializable newClientManager_adminFactory = (Function1 & Serializable)config -> this.adminFactory((ClusterLinkConfig)config);
        Mockito.when((Object)this.scheduler().schedule(ArgumentMatchers.anyString(), (Runnable)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn(null);
        ClusterLinkData newClientManager_linkData = new ClusterLinkData(linkName, Uuid.randomUuid(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        ClusterLinkFetcherManager newClientManager_fetcherManager = (ClusterLinkFetcherManager)Mockito.mock(ClusterLinkFetcherManager.class);
        ClusterLinkMetadataManager newClientManager_metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
        Mockito.when((Object)this.clusterLinkManager().metadataManager()).thenReturn((Object)newClientManager_metadataManager);
        Properties newClientManager_brokerConfig = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        newClientManager_brokerConfig.put("multitenant.authorizer.support.resource.ids", (Object)newClientManager_resourceIdSupportEnabled);
        Object var7_8 = null;
        some = null;
        string = null;
        Object var10_9 = null;
        Object var11_10 = null;
        Object var12_11 = null;
        Object var13_12 = null;
        ClusterLinkDestClientManager clientManager = new ClusterLinkDestClientManager(this.clusterLinkManager(), new KafkaConfig((Map)newClientManager_brokerConfig), newClientManager_linkData, newClientManager_fetcherManager, this.scheduler(), config2, (Option)newClientManager_authorizer, (Option)None$.MODULE$, this.metrics(), (Function1)newClientManager_adminFactory, (Function0 & Serializable)() -> this.destAdmin(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer());
        if (!expectedFailure) {
            clientManager.startup();
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)clientManager.aclFilterWithResourceId()), (Object)BoxesRunTime.boxToBoolean((boolean)resourceIdFilters));
        } else {
            Assertions.assertEquals((Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> clientManager.startup())).getMessage(), (Object)new StringBuilder(177).append("If kafka.config.authorizer.resource.id.support.enable flag is enabled, aclFilters in cluster link").append("should contain filters either in old or new format, but got mix of both format. ").append(config2.aclFilters().get()).toString());
        }
        this.closeManagers(clientManager);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAclSyncTaskStartupWithNoAuthorizer() {
        void newClientManager_authorizer;
        void newClientManager_resourceIdSupportEnabled;
        String linkName = "test-link";
        String migrateAllAclsJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"aclFilters\": [{\n        |  \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |  \"accessFilter\": {\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        |  }]\n        | }"));
        ClusterLinkConfig config2 = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:1234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)migrateAllAclsJson)}))));
        String string = "false";
        None$ none$ = None$.MODULE$;
        Function1 & Serializable newClientManager_adminFactory = (Function1 & Serializable)config -> this.adminFactory((ClusterLinkConfig)config);
        Mockito.when((Object)this.scheduler().schedule(ArgumentMatchers.anyString(), (Runnable)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn(null);
        ClusterLinkData newClientManager_linkData = new ClusterLinkData(linkName, Uuid.randomUuid(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        ClusterLinkFetcherManager newClientManager_fetcherManager = (ClusterLinkFetcherManager)Mockito.mock(ClusterLinkFetcherManager.class);
        ClusterLinkMetadataManager newClientManager_metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
        Mockito.when((Object)this.clusterLinkManager().metadataManager()).thenReturn((Object)newClientManager_metadataManager);
        Properties newClientManager_brokerConfig = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        newClientManager_brokerConfig.put("multitenant.authorizer.support.resource.ids", (Object)newClientManager_resourceIdSupportEnabled);
        Object var6_6 = null;
        none$ = null;
        string = null;
        Object var9_7 = null;
        Object var10_8 = null;
        Object var11_9 = null;
        Object var12_10 = null;
        ClusterLinkDestClientManager clientManager = new ClusterLinkDestClientManager(this.clusterLinkManager(), new KafkaConfig((Map)newClientManager_brokerConfig), newClientManager_linkData, newClientManager_fetcherManager, this.scheduler(), config2, (Option)newClientManager_authorizer, (Option)None$.MODULE$, this.metrics(), (Function1)newClientManager_adminFactory, (Function0 & Serializable)() -> this.destAdmin(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer());
        try {
            try {
                clientManager.startup();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Assertions.assertEquals((Object)illegalArgumentException.getMessage(), (Object)"ACL migration is enabled but authorizer.class.name is not set. Please set authorizer.class.name to proceed with ACL migration.");
            }
        }
        finally {
            this.closeManagers(clientManager);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAclSyncTaskNoStartup() {
        void newClientManager_authorizer;
        void newClientManager_resourceIdSupportEnabled;
        String linkName = "test-link";
        ClusterLinkConfig config2 = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:1234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"false")}))));
        String string = "false";
        Some some = new Some((Object)this.authorizer());
        Function1 & Serializable newClientManager_adminFactory = (Function1 & Serializable)config -> this.adminFactory((ClusterLinkConfig)config);
        Mockito.when((Object)this.scheduler().schedule(ArgumentMatchers.anyString(), (Runnable)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn(null);
        ClusterLinkData newClientManager_linkData = new ClusterLinkData(linkName, Uuid.randomUuid(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        ClusterLinkFetcherManager newClientManager_fetcherManager = (ClusterLinkFetcherManager)Mockito.mock(ClusterLinkFetcherManager.class);
        ClusterLinkMetadataManager newClientManager_metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
        Mockito.when((Object)this.clusterLinkManager().metadataManager()).thenReturn((Object)newClientManager_metadataManager);
        Properties newClientManager_brokerConfig = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        newClientManager_brokerConfig.put("multitenant.authorizer.support.resource.ids", (Object)newClientManager_resourceIdSupportEnabled);
        Object var5_5 = null;
        some = null;
        string = null;
        Object var8_6 = null;
        Object var9_7 = null;
        Object var10_8 = null;
        Object var11_9 = null;
        ClusterLinkDestClientManager clientManager = new ClusterLinkDestClientManager(this.clusterLinkManager(), new KafkaConfig((Map)newClientManager_brokerConfig), newClientManager_linkData, newClientManager_fetcherManager, this.scheduler(), config2, (Option)newClientManager_authorizer, (Option)None$.MODULE$, this.metrics(), (Function1)newClientManager_adminFactory, (Function0 & Serializable)() -> this.destAdmin(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer());
        clientManager.startup();
        try {
            Predef$.MODULE$.assert(clientManager.getSyncAclTask().isEmpty());
        }
        finally {
            this.closeManagers(clientManager);
        }
    }

    private ClusterLinkDestClientManager newClientManager(String linkName, ClusterLinkConfig config, Function1<ClusterLinkConfig, ClusterLinkAdminClient> adminFactory, Option<Authorizer> authorizer, String resourceIdSupportEnabled) {
        Mockito.when((Object)this.scheduler().schedule(ArgumentMatchers.anyString(), (Runnable)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn(null);
        ClusterLinkData linkData = new ClusterLinkData(linkName, Uuid.randomUuid(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        ClusterLinkFetcherManager fetcherManager = (ClusterLinkFetcherManager)Mockito.mock(ClusterLinkFetcherManager.class);
        ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
        Mockito.when((Object)this.clusterLinkManager().metadataManager()).thenReturn((Object)metadataManager);
        Properties brokerConfig = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        brokerConfig.put("multitenant.authorizer.support.resource.ids", resourceIdSupportEnabled);
        return new ClusterLinkDestClientManager(this.clusterLinkManager(), new KafkaConfig((Map)brokerConfig), linkData, fetcherManager, this.scheduler(), config, authorizer, (Option)None$.MODULE$, this.metrics(), adminFactory, (Function0 & Serializable)() -> this.destAdmin(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer());
    }

    private String newClientManager$default$5() {
        return "false";
    }

    private void closeManagers(ClusterLinkDestClientManager clusterLinkClientManager) {
        this.destAdmin().close(Duration.ZERO);
        Mockito.when((Object)BoxedUnit.UNIT);
        clusterLinkClientManager.shutdown();
        Mockito.reset((Object[])new ConfluentAdmin[]{this.destAdmin()});
        Mockito.reset((Object[])new ClusterLinkManager[]{this.clusterLinkManager()});
        clusterLinkClientManager.scheduler().shutdown();
        Mockito.reset((Object[])new ClusterLinkScheduler[]{this.scheduler()});
    }

    private ClusterLinkAdminClient adminFactory(ClusterLinkConfig config) {
        return (ClusterLinkAdminClient)Mockito.mock(ClusterLinkAdminClient.class);
    }

    private ClusterLinkConfig newConfig(scala.collection.immutable.Map<String, String> configs) {
        Properties props = new Properties();
        new Implicits.PropertiesOps(props).$plus$plus$eq(configs);
        return ClusterLinkConfig$.MODULE$.create((Map)props, true);
    }

    private static final ClusterLinkAdminClient adminFactoryWithCount$1(ClusterLinkConfig config, IntRef factoryCalled$1, ObjectRef factoryConfig$1, ObjectRef factoryAdmin$1) {
        ++factoryCalled$1.elem;
        Assertions.assertTrue(((ClusterLinkConfig)factoryConfig$1.elem == config ? 1 : 0) != 0);
        return new ClusterLinkAdminClient((ConfluentAdmin)((KafkaAdminClient)factoryAdmin$1.elem), null, null, "");
    }
}

