/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kafka.server.link.ClusterLinkClearLinkReference;
import kafka.server.link.ClusterLinkClearLinkReference$;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetadataManagerWithKRaftSupport;
import kafka.server.link.ClusterLinkMetadataManagerWithZkSupport;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DeleteClusterLinksOptions;
import org.apache.kafka.clients.admin.DeleteClusterLinksResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.Authorizer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005mh\u0001B\u0015+\u0001EBQ\u0001\u000f\u0001\u0005\u0002eBq\u0001\u0010\u0001C\u0002\u0013%Q\b\u0003\u0004G\u0001\u0001\u0006IA\u0010\u0005\b\u000f\u0002\u0011\r\u0011\"\u0003I\u0011\u0019!\u0006\u0001)A\u0005\u0013\"9Q\u000b\u0001b\u0001\n\u0013A\u0005B\u0002,\u0001A\u0003%\u0011\nC\u0004X\u0001\t\u0007I\u0011\u0002-\t\rq\u0003\u0001\u0015!\u0003Z\u0011\u001di\u0006A1A\u0005\nyCaA\u001a\u0001!\u0002\u0013y\u0006bB4\u0001\u0005\u0004%I\u0001\u001b\u0005\u0007Y\u0002\u0001\u000b\u0011B5\t\u000f5\u0004!\u0019!C\u0005]\"1Q\u000f\u0001Q\u0001\n=DqA\u001e\u0001C\u0002\u0013%q\u000f\u0003\u0004\u007f\u0001\u0001\u0006I\u0001\u001f\u0005\u0007\u007f\u0002!\t!!\u0001\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\u0002!9\u0011\u0011\u0006\u0001\u0005\u0002\u0005\u0005\u0001bBA\u001a\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003o\u0001A\u0011AA\u0001\u0011\u001d\tY\u0004\u0001C\u0001\u0003\u0003Aq!a\u0010\u0001\t\u0003\t\t\u0001C\u0004\u0002D\u0001!\t!!\u0001\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u0002\u0002!9\u00111\n\u0001\u0005\u0002\u0005\u0005\u0001bBA(\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003'\u0002A\u0011AA\u0001\u0011\u001d\t9\u0006\u0001C\u0001\u0003\u0003Aq!a\u0017\u0001\t\u0003\t\t\u0001C\u0004\u0002`\u0001!\t!!\u0001\t\u000f\u0005\r\u0004\u0001\"\u0001\u0002\u0002!9\u0011q\r\u0001\u0005\u0002\u0005\u0005\u0001bBA6\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003_\u0002A\u0011BA9\u0011\u001d\t\u0019\u000b\u0001C\u0005\u0003KC\u0011\"a6\u0001#\u0003%I!!7\t\u000f\u0005=\b\u0001\"\u0003\u0002r\"I\u0011\u0011 \u0001\u0012\u0002\u0013%\u0011\u0011\u001c\u0002\"\u00072,8\u000f^3s\u0019&t7n\u00117fCJd\u0015N\\6SK\u001a,'/\u001a8dKR+7\u000f\u001e\u0006\u0003W1\nA\u0001\\5oW*\u0011QFL\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003=\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001eA\u00111GN\u0007\u0002i)\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028i\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u001e\u0011\u0005m\u0002Q\"\u0001\u0016\u0002\u00111Lgn\u001b(b[\u0016,\u0012A\u0010\t\u0003\u007f\u0011k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000bA\u0001\\1oO*\t1)\u0001\u0003kCZ\f\u0017BA#A\u0005\u0019\u0019FO]5oO\u0006IA.\u001b8l\u001d\u0006lW\rI\u0001\u0007Y&t7.\u00133\u0016\u0003%\u0003\"A\u0013*\u000e\u0003-S!\u0001T'\u0002\r\r|W.\\8o\u0015\tycJ\u0003\u0002P!\u00061\u0011\r]1dQ\u0016T\u0011!U\u0001\u0004_J<\u0017BA*L\u0005\u0011)V/\u001b3\u0002\u000f1Lgn[%eA\u0005i1o\\;sG\u0016$v\u000e]5d\u0013\u0012\fab]8ve\u000e,Gk\u001c9jG&#\u0007%A\u0005tG\",G-\u001e7feV\t\u0011\f\u0005\u0002<5&\u00111L\u000b\u0002\u0015\u00072,8\u000f^3s\u0019&t7nU2iK\u0012,H.\u001a:\u0002\u0015M\u001c\u0007.\u001a3vY\u0016\u0014\b%A\u0003bI6Lg.F\u0001`!\t\u0001G-D\u0001b\u0015\ti&M\u0003\u0002d\u001b\u000691\r\\5f]R\u001c\u0018BA3b\u00059\u0019uN\u001c4mk\u0016tG/\u00113nS:\fa!\u00193nS:\u0004\u0013aD7fi\u0006$\u0017\r^1NC:\fw-\u001a:\u0016\u0003%\u0004\"a\u000f6\n\u0005-T#AG\"mkN$XM\u001d'j].lU\r^1eCR\fW*\u00198bO\u0016\u0014\u0018\u0001E7fi\u0006$\u0017\r^1NC:\fw-\u001a:!\u0003!a\u0017N\\6ECR\fW#A8\u0011\u0005A\u001cX\"A9\u000b\u0005It\u0013A\u0001>l\u0013\t!\u0018OA\bDYV\u001cH/\u001a:MS:\\G)\u0019;b\u0003%a\u0017N\\6ECR\f\u0007%\u0001\bfqB,7\r^3e\r&dG/\u001a:\u0016\u0003a\u0004\"!\u001f?\u000e\u0003iT!a_&\u0002\u0007\u0005\u001cG.\u0003\u0002~u\nA\u0012iY2fgN\u001cuN\u001c;s_2,e\u000e\u001e:z\r&dG/\u001a:\u0002\u001f\u0015D\b/Z2uK\u00124\u0015\u000e\u001c;fe\u0002\nQa]3u+B$\"!a\u0001\u0011\u0007M\n)!C\u0002\u0002\bQ\u0012A!\u00168ji\"\u001a!#a\u0003\u0011\t\u00055\u00111D\u0007\u0003\u0003\u001fQA!!\u0005\u0002\u0014\u0005\u0019\u0011\r]5\u000b\t\u0005U\u0011qC\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\tI\u0002U\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003;\tyA\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004'\u0005\r\u0002\u0003BA\u0007\u0003KIA!a\n\u0002\u0010\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u001bi\u0016\u001cHo\u00117fCJl\u0015N\u001d:peR{\u0007/[2t\u000b6\u0004H/\u001f\u0015\u0004)\u00055\u0002\u0003BA\u0007\u0003_IA!!\r\u0002\u0010\t!A+Z:u\u0003e!Xm\u001d;IC:$G.Z:F[B$\u0018\u0010T8dC2\f5\r\\:)\u0007U\ti#A\u000fuKN$\b*\u00198eY\u0016\u001cHj\\2bY\u0006\u001bGn\u001d+p\u001b&<'/\u0019;fQ\r1\u0012QF\u00010i\u0016\u001cH\u000fS1oI2,7I]3bi\u0016\f5\r\\:SKN,H\u000e\u001e$viV\u0014X\r\u00165s_^\u001cX\t_2faRLwN\u001c\u0015\u0004/\u00055\u0012a\f;fgRD\u0015M\u001c3mK\u0012+G.\u001a;f\u0003\u000ed7OU3tk2$h)\u001e;ve\u0016$\u0006N]8xg\u0016C8-\u001a9uS>t\u0007f\u0001\r\u0002.\u0005\u0019D/Z:u\u0011\u0006tG\r\\3EK2,G/Z!dYN\u0014Vm];miJ+7\u000f]8og\u0016\u001cuN\u001c;bS:\u001cX\t_2faRLwN\u001c\u0015\u00043\u00055\u0012!\b;fgR\u001cE.Z1s\u001b&\u0014(o\u001c:U_BL7m]%t\u001b&\u0014(o\u001c:)\u0007i\ti#\u0001\u0017uKN$8\t\\3be6K'O]8s)>\u0004\u0018nY:Jg6K'O]8s\t&4g-\u001a:f]Rd\u0015N\\6JI\"\u001a1$!\f\u0002OQ,7\u000f^\"mK\u0006\u0014X*\u001b:s_J$v\u000e]5dg&\u001bX*\u001b:s_J,%O]8s%\u0016$(/\u001f\u0015\u00049\u00055\u0012A\n;fgR\u001cE.Z1s\u001b&\u0014(o\u001c:U_BL7m]%t\u001b&\u0014(o\u001c:FeJ|'oU6ja\"\u001aQ$!\f\u0002=Q,7\u000f^\"mK\u0006\u0014X*\u001b:s_J$v\u000e]5dg:{G/T5se>\u0014\bf\u0001\u0010\u0002.\u0005!C/Z:u\u00072,\u0017M]'jeJ|'\u000fV8qS\u000e\u001cH*\u001b8l\t>,7O\u001c;Fq&\u001cH\u000fK\u0002 \u0003[\t!\u0006^3ti\u000ecW-\u0019:NSJ\u0014xN\u001d+pa&\u001c7oQ8oiJ|G\u000e\\3s\u001b\u0006t\u00170\u00128ue&,7\u000fK\u0002!\u0003[\tQ\u0005^3ti.\u0013\u0018M\u001a;N_\u0012,7\u000b[8vY\u0012\u001cE.Z1s\u0019&t7NU3gKJ,gnY3)\u0007\u0005\ni#\u0001\u0012uKN$(l['pI\u0016\u001c\u0006n\\;mI\u000ecW-\u0019:MS:\\'+\u001a4fe\u0016t7-\u001a\u0015\u0004E\u00055\u0012!\u000f;fgR$U\r\\3uK\u000ecWo\u001d;fe2Kgn['fi\u0006$\u0017\r^1XQ\u0016tG*\u001b8l\u0007>|'\u000fZ5oCR|'/S:F]\u0006\u0014G.\u001a3)\u0007\r\ni#A\u000boK^\fE\u000e^3s\u001b&\u0014(o\u001c:t%\u0016\u001cX\u000f\u001c;\u0015\t\u0005M\u0014\u0011\u0010\t\u0004A\u0006U\u0014bAA<C\n\u0011\u0012\t\u001c;fe6K'O]8sgJ+7/\u001e7u\u0011\u001d\tY\b\na\u0001\u0003{\na\u0001^8qS\u000e\u001c\bCBA@\u0003\u001f\u000b)J\u0004\u0003\u0002\u0002\u0006-e\u0002BAB\u0003\u0013k!!!\"\u000b\u0007\u0005\u001d\u0005'\u0001\u0004=e>|GOP\u0005\u0002k%\u0019\u0011Q\u0012\u001b\u0002\u000fA\f7m[1hK&!\u0011\u0011SAJ\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u001b#\u0004\u0003BAL\u0003?sA!!'\u0002\u001cB\u0019\u00111\u0011\u001b\n\u0007\u0005uE'\u0001\u0004Qe\u0016$WMZ\u0005\u0004\u000b\u0006\u0005&bAAOi\u0005\u0019c.Z<DY\u0016\f'\u000fT5oWJ+g-\u001a:f]\u000e,w+\u001b;i\u0003V$\bn\u001c:ju\u0016\u0014H\u0003CAT\u0003[\u000b9,!4\u0011\u0007m\nI+C\u0002\u0002,*\u0012Qd\u00117vgR,'\u000fT5oW\u000ecW-\u0019:MS:\\'+\u001a4fe\u0016t7-\u001a\u0005\b\u0003_+\u0003\u0019AAY\u0003I\u0019w.\u001c9mKRLwN\\\"bY2\u0014\u0017mY6\u0011\u000bM\n\u0019,a\u0001\n\u0007\u0005UFGA\u0005Gk:\u001cG/[8oa!9\u0011\u0011X\u0013A\u0002\u0005m\u0016AC1vi\"|'/\u001b>feB)1'!0\u0002B&\u0019\u0011q\u0018\u001b\u0003\r=\u0003H/[8o!\u0011\t\u0019-!3\u000e\u0005\u0005\u0015'\u0002BA]\u0003\u000fT!!L'\n\t\u0005-\u0017Q\u0019\u0002\u000b\u0003V$\bn\u001c:ju\u0016\u0014\b\"CAhKA\u0005\t\u0019AAi\u0003A!x\u000e]5dg\u001e\u0013x.\u001e9t'&TX\rE\u00024\u0003'L1!!65\u0005\rIe\u000e^\u0001.]\u0016<8\t\\3be2Kgn\u001b*fM\u0016\u0014XM\\2f/&$\b.Q;uQ>\u0014\u0018N_3sI\u0011,g-Y;mi\u0012\u001aTCAAnU\u0011\t\t.!8,\u0005\u0005}\u0007\u0003BAq\u0003Wl!!a9\u000b\t\u0005\u0015\u0018q]\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!;5\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003[\f\u0019OA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQC\\3x\u00072,\u0017M\u001d'j].\u0014VMZ3sK:\u001cW\r\u0006\u0004\u0002(\u0006M\u0018Q\u001f\u0005\b\u0003_;\u0003\u0019AAY\u0011%\t9p\nI\u0001\u0002\u0004\t\t.\u0001\bu_BL7m\u0012:pkB\u001c\u0016N_3\u0002?9,wo\u00117fCJd\u0015N\\6SK\u001a,'/\u001a8dK\u0012\"WMZ1vYR$#\u0007")
public class ClusterLinkClearLinkReferenceTest {
    private final String linkName;
    private final Uuid linkId = Uuid.randomUuid();
    private final Uuid sourceTopicId = Uuid.randomUuid();
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler();
    private final ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
    private final ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManagerWithZkSupport.class);
    private final ClusterLinkData linkData = new ClusterLinkData(this.linkName(), this.linkId(), (Option)None$.MODULE$, (Option)None$.MODULE$, true);
    private final AccessControlEntryFilter expectedFilter = new AccessControlEntryFilter(null, null, AclOperation.ANY, AclPermissionType.ANY, Collections.singleton(this.linkId()));

    private String linkName() {
        return this.linkName;
    }

    private Uuid linkId() {
        return this.linkId;
    }

    private Uuid sourceTopicId() {
        return this.sourceTopicId;
    }

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private ConfluentAdmin admin() {
        return this.admin;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private ClusterLinkData linkData() {
        return this.linkData;
    }

    private AccessControlEntryFilter expectedFilter() {
        return this.expectedFilter;
    }

    @BeforeEach
    public void setUp() {
        this.scheduler().startup();
    }

    @AfterEach
    public void tearDown() {
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{this.metadataManager()});
        this.scheduler().shutdown();
    }

    @Test
    public void testClearMirrorTopicsEmpty() {
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)this.linkData()));
        Mockito.when((Object)this.metadataManager().getAllTopicsInCluster()).thenReturn((Object)Predef$.MODULE$.Set().empty());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinatorEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        CompletableFuture done = new CompletableFuture();
        int newClearLinkReference_topicGroupSize = 10;
        JFunction0.mcV.sp & Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable)() -> done.complete(null);
        Object var2_3 = null;
        new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), (Option)None$.MODULE$, this.admin(), (Function0)newClearLinkReference_completionCallback, newClearLinkReference_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getClusterLinkData(this.linkId());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getAllTopicsInCluster();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinatorEnabled();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHandlesEmptyLocalAcls() {
        void newClearLinkReferenceWithAuthorizer_topicsGroupsSize;
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)this.linkData()));
        Mockito.when((Object)this.metadataManager().getAllTopicsInCluster()).thenReturn((Object)Predef$.MODULE$.Set().empty());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinatorEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Authorizer mockAuthorizer = (Authorizer)Mockito.mock(Authorizer.class);
        Some authorizer = new Some((Object)mockAuthorizer);
        AclBindingFilter aclBindingFilter = new AclBindingFilter(ResourcePatternFilter.ANY, this.expectedFilter());
        Mockito.when((Object)mockAuthorizer.acls(aclBindingFilter)).thenReturn((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Nil$.MODULE$).asJava());
        CompletableFuture done = new CompletableFuture();
        int n = 10;
        JFunction0.mcV.sp & Serializable newClearLinkReferenceWithAuthorizer_completionCallback = (JFunction0.mcV.sp & Serializable)() -> done.complete(null);
        Object var6_6 = null;
        ClusterLinkClearLinkReference clearMirrorTopics = new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), (Option)authorizer, this.admin(), (Function0)newClearLinkReferenceWithAuthorizer_completionCallback, (int)newClearLinkReferenceWithAuthorizer_topicsGroupsSize, 10, 10);
        clearMirrorTopics.runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        Mockito.reset((Object[])new ConfluentAdmin[]{this.admin()});
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getClusterLinkData(this.linkId());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getAllTopicsInCluster();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinatorEnabled();
        ((Authorizer)Mockito.verify((Object)mockAuthorizer)).acls(aclBindingFilter);
        Assertions.assertTrue((boolean)clearMirrorTopics.getUpdatedAcls());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHandlesLocalAclsToMigrate() {
        void newClearLinkReferenceWithAuthorizer_topicsGroupsSize;
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)this.linkData()));
        Mockito.when((Object)this.metadataManager().getAllTopicsInCluster()).thenReturn((Object)Predef$.MODULE$.Set().empty());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinatorEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Authorizer mockAuthorizer = (Authorizer)Mockito.mock(Authorizer.class);
        Some authorizer = new Some((Object)mockAuthorizer);
        String host = "10.0.0.1";
        String principal = "User:user";
        String resourceName = "foo";
        AclOperation operation = AclOperation.ALL;
        PatternType patternType = PatternType.LITERAL;
        ResourceType resourceType = ResourceType.TOPIC;
        AclPermissionType permissionType = AclPermissionType.ALLOW;
        AclBinding aclBindingWithLink = new AclBinding(new ResourcePattern(resourceType, resourceName, patternType), new AccessControlEntry(principal, host, operation, permissionType, Collections.singleton(this.linkId())));
        AclBinding aclBindingWithLinkAndLocal = new AclBinding(new ResourcePattern(resourceType, resourceName, patternType), new AccessControlEntry(principal, host, operation, permissionType, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.linkId(), (List)new .colon.colon((Object)Uuid.ZERO_UUID, (List)Nil$.MODULE$))).asJava()));
        AclBindingFilter aclBindingFilter = new AclBindingFilter(ResourcePatternFilter.ANY, this.expectedFilter());
        Mockito.when((Object)mockAuthorizer.acls(aclBindingFilter)).thenReturn((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)aclBindingWithLink, (List)Nil$.MODULE$)).asJava()).thenReturn((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)aclBindingWithLinkAndLocal, (List)Nil$.MODULE$)).asJava()).thenReturn((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Nil$.MODULE$).asJava());
        Mockito.reset((Object[])new ConfluentAdmin[]{this.admin()});
        KafkaFutureImpl createAclsFuture = new KafkaFutureImpl();
        createAclsFuture.complete(null);
        CreateAclsResult createAclsResult = (CreateAclsResult)Mockito.mock(CreateAclsResult.class);
        AclBinding aclBindingWithoutLink = new AclBinding(new ResourcePattern(resourceType, resourceName, patternType), new AccessControlEntry(principal, host, operation, permissionType));
        Mockito.when((Object)createAclsResult.values()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)aclBindingWithoutLink), (Object)createAclsFuture)}))).asJava());
        Mockito.when((Object)this.admin().createAcls(Collections.singletonList(aclBindingWithoutLink))).thenReturn((Object)createAclsResult);
        DeleteAclsResult.FilterResult filterResult = (DeleteAclsResult.FilterResult)Mockito.mock(DeleteAclsResult.FilterResult.class);
        Mockito.when((Object)filterResult.binding()).thenReturn((Object)aclBindingWithLink);
        Mockito.when((Object)((Object)filterResult.exception())).thenReturn(null);
        DeleteAclsResult.FilterResults filterResults = (DeleteAclsResult.FilterResults)Mockito.mock(DeleteAclsResult.FilterResults.class);
        Mockito.when((Object)filterResults.values()).thenReturn(Collections.singletonList(filterResult));
        KafkaFutureImpl deleteAclsFuture = new KafkaFutureImpl();
        deleteAclsFuture.complete((Object)filterResults);
        DeleteAclsResult deleteAclsResult = (DeleteAclsResult)Mockito.mock(DeleteAclsResult.class);
        Mockito.when((Object)deleteAclsResult.values()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)aclBindingWithLink.toFilter()), (Object)deleteAclsFuture)}))).asJava());
        Mockito.when((Object)this.admin().deleteAcls(Collections.singletonList(aclBindingWithLink.toFilter()))).thenReturn((Object)deleteAclsResult);
        CompletableFuture done = new CompletableFuture();
        int n = 10;
        JFunction0.mcV.sp & Serializable newClearLinkReferenceWithAuthorizer_completionCallback = (JFunction0.mcV.sp & Serializable)() -> done.complete(null);
        Object var22_22 = null;
        ClusterLinkClearLinkReference clearMirrorTopics = new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), (Option)authorizer, this.admin(), (Function0)newClearLinkReferenceWithAuthorizer_completionCallback, (int)newClearLinkReferenceWithAuthorizer_topicsGroupsSize, 10, 10);
        clearMirrorTopics.runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getClusterLinkData(this.linkId());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getAllTopicsInCluster();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinatorEnabled();
        ((Authorizer)Mockito.verify((Object)mockAuthorizer, (VerificationMode)Mockito.times((int)3))).acls(aclBindingFilter);
        ((Admin)Mockito.verify((Object)this.admin())).createAcls(Collections.singletonList(aclBindingWithoutLink));
        ((Admin)Mockito.verify((Object)this.admin())).deleteAcls(Collections.singletonList(aclBindingWithLink.toFilter()));
        Assertions.assertTrue((boolean)clearMirrorTopics.getUpdatedAcls());
        ((DeleteAclsResult.FilterResult)Mockito.verify((Object)filterResult)).exception();
        ((DeleteAclsResult.FilterResults)Mockito.verify((Object)filterResults)).values();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHandleCreateAclsResultFutureThrowsException() {
        void var13_13;
        void var12_12;
        String host = "10.0.0.1";
        String principal = "User:user";
        String resourceName = "foo";
        AclOperation operation = AclOperation.ALL;
        PatternType patternType = PatternType.LITERAL;
        ResourceType resourceType = ResourceType.TOPIC;
        AclPermissionType permissionType = AclPermissionType.ALLOW;
        KafkaFutureImpl createAclsFuture = new KafkaFutureImpl();
        createAclsFuture.completeExceptionally((Throwable)new Exception("Internal error"));
        CreateAclsResult createAclsResult = (CreateAclsResult)Mockito.mock(CreateAclsResult.class);
        AclBinding aclBinding = new AclBinding(new ResourcePattern(resourceType, resourceName, patternType), new AccessControlEntry(principal, host, operation, permissionType, Collections.singleton(this.linkId())));
        Mockito.when((Object)createAclsResult.values()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)aclBinding), (Object)createAclsFuture)}))).asJava());
        Tuple2 tuple2 = ClusterLinkClearLinkReference$.MODULE$.handleCreateAclsResult(createAclsResult);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean success = tuple2._1$mcZ$sp();
        int numAclsFailedToCreate = tuple2._2$mcI$sp();
        Assertions.assertFalse((boolean)var12_12);
        Assertions.assertEquals((int)1, (int)var13_13);
        ((CreateAclsResult)Mockito.verify((Object)createAclsResult)).values();
    }

    @Test
    public void testHandleDeleteAclsResultFutureThrowsException() {
        String host = "10.0.0.1";
        String principal = "User:user";
        String resourceName = "foo";
        AclOperation operation = AclOperation.ALL;
        PatternType patternType = PatternType.LITERAL;
        ResourceType resourceType = ResourceType.TOPIC;
        AclPermissionType permissionType = AclPermissionType.ALLOW;
        AclBinding aclBinding = new AclBinding(new ResourcePattern(resourceType, resourceName, patternType), new AccessControlEntry(principal, host, operation, permissionType));
        KafkaFutureImpl deleteAclsFuture = new KafkaFutureImpl();
        deleteAclsFuture.completeExceptionally((Throwable)new Exception("Internal error"));
        DeleteAclsResult deleteAclsResult = (DeleteAclsResult)Mockito.mock(DeleteAclsResult.class);
        Mockito.when((Object)deleteAclsResult.values()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)aclBinding.toFilter()), (Object)deleteAclsFuture)}))).asJava());
        Assertions.assertFalse((boolean)ClusterLinkClearLinkReference$.MODULE$.handleDeleteAclsResult(deleteAclsResult));
        ((DeleteAclsResult)Mockito.verify((Object)deleteAclsResult)).values();
    }

    @Test
    public void testHandleDeleteAclsResultResponseContainsException() {
        String host = "10.0.0.1";
        String principal = "User:user";
        String resourceName = "foo";
        AclOperation operation = AclOperation.ALL;
        PatternType patternType = PatternType.LITERAL;
        ResourceType resourceType = ResourceType.TOPIC;
        AclPermissionType permissionType = AclPermissionType.ALLOW;
        AclBinding aclBinding = new AclBinding(new ResourcePattern(resourceType, resourceName, patternType), new AccessControlEntry(principal, host, operation, permissionType));
        DeleteAclsResult.FilterResult filterResult = (DeleteAclsResult.FilterResult)Mockito.mock(DeleteAclsResult.FilterResult.class);
        Mockito.when((Object)filterResult.binding()).thenReturn((Object)aclBinding);
        Mockito.when((Object)((Object)filterResult.exception())).thenReturn((Object)new ApiException((Throwable)new Exception("Internal error")));
        DeleteAclsResult.FilterResults filterResults = (DeleteAclsResult.FilterResults)Mockito.mock(DeleteAclsResult.FilterResults.class);
        Mockito.when((Object)filterResults.values()).thenReturn(Collections.singletonList(filterResult));
        KafkaFutureImpl deleteAclsFuture = new KafkaFutureImpl();
        deleteAclsFuture.complete((Object)filterResults);
        DeleteAclsResult deleteAclsResult = (DeleteAclsResult)Mockito.mock(DeleteAclsResult.class);
        Mockito.when((Object)deleteAclsResult.values()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)aclBinding.toFilter()), (Object)deleteAclsFuture)}))).asJava());
        Assertions.assertFalse((boolean)ClusterLinkClearLinkReference$.MODULE$.handleDeleteAclsResult(deleteAclsResult));
        ((DeleteAclsResult.FilterResult)Mockito.verify((Object)filterResult, (VerificationMode)Mockito.times((int)2))).exception();
        ((DeleteAclsResult.FilterResults)Mockito.verify((Object)filterResults)).values();
        ((DeleteAclsResult)Mockito.verify((Object)deleteAclsResult)).values();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearMirrorTopicsIsMirror() {
        void newClearLinkReference_topicGroupSize;
        String topic = "topic";
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)this.linkData()));
        Mockito.when((Object)this.metadataManager().getAllTopicsInCluster()).thenReturn(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty()));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).thenReturn(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        KafkaFuture future = KafkaFuture.completedFuture(null);
        AlterMirrorsResult ret = new AlterMirrorsResult(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)future)}))).asJava());
        Mockito.reset((Object[])new ConfluentAdmin[]{this.admin()});
        Mockito.when((Object)this.admin().alterMirrors((java.util.Map)ArgumentMatchers.eq(Collections.singletonMap(topic, AlterMirrorOp.CLEAR)), (AlterMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)ret);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinatorEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        CompletableFuture done = new CompletableFuture();
        int n = 10;
        JFunction0.mcV.sp & Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable)() -> done.complete(null);
        Object var5_6 = null;
        new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), (Option)None$.MODULE$, this.admin(), (Function0)newClearLinkReference_completionCallback, (int)newClearLinkReference_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        ((ConfluentAdmin)Mockito.verify((Object)this.admin())).alterMirrors((java.util.Map)ArgumentMatchers.eq(Collections.singletonMap(topic, AlterMirrorOp.CLEAR)), (AlterMirrorsOptions)ArgumentMatchers.any());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getClusterLinkData(this.linkId());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getAllTopicsInCluster();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinatorEnabled();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearMirrorTopicsIsMirrorDifferentLinkId() {
        void newClearLinkReference_topicGroupSize;
        String topic = "topic";
        String otherLinkName = "other-link-name";
        Uuid otherLinkId = Uuid.randomUuid();
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)this.linkData()));
        Mockito.when((Object)this.metadataManager().getAllTopicsInCluster()).thenReturn(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)new ClusterLinkTopicState.Mirror(otherLinkName, otherLinkId, this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty()));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).thenReturn(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinatorEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        CompletableFuture done = new CompletableFuture();
        int n = 10;
        JFunction0.mcV.sp & Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable)() -> done.complete(null);
        Object var5_6 = null;
        new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), (Option)None$.MODULE$, this.admin(), (Function0)newClearLinkReference_completionCallback, (int)newClearLinkReference_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getClusterLinkData(this.linkId());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getAllTopicsInCluster();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinatorEnabled();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearMirrorTopicsIsMirrorErrorRetry() {
        void newClearLinkReference_topicGroupSize;
        String topic = "topic";
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)this.linkData()));
        Mockito.when((Object)this.metadataManager().getAllTopicsInCluster()).thenReturn(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty()));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).thenReturn(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinatorEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        scala.collection.immutable.Map expectedOps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)AlterMirrorOp.CLEAR)}));
        KafkaFutureImpl future1 = new KafkaFutureImpl();
        future1.completeExceptionally((Throwable)new TimeoutException());
        AlterMirrorsResult ret1 = new AlterMirrorsResult(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)future1)}))).asJava());
        AlterMirrorsResult ret2 = this.newAlterMirrorsResult((scala.collection.immutable.Seq<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$));
        Mockito.reset((Object[])new ConfluentAdmin[]{this.admin()});
        Mockito.when((Object)this.admin().alterMirrors((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)expectedOps).asJava()), (AlterMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)ret1).thenReturn((Object)ret2);
        CompletableFuture done = new CompletableFuture();
        int n = 10;
        JFunction0.mcV.sp & Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable)() -> done.complete(null);
        Object var7_8 = null;
        new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), (Option)None$.MODULE$, this.admin(), (Function0)newClearLinkReference_completionCallback, (int)newClearLinkReference_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        ((ConfluentAdmin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).alterMirrors((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)expectedOps).asJava()), (AlterMirrorsOptions)ArgumentMatchers.any());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getClusterLinkData(this.linkId());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getAllTopicsInCluster();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinatorEnabled();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearMirrorTopicsIsMirrorErrorSkip() {
        void newClearLinkReference_topicGroupSize;
        String topic = "topic";
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)this.linkData()));
        Mockito.when((Object)this.metadataManager().getAllTopicsInCluster()).thenReturn(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty()));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).thenReturn(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinatorEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        scala.collection.immutable.Map expectedOps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)AlterMirrorOp.CLEAR)}));
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException());
        AlterMirrorsResult ret = new AlterMirrorsResult(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)future)}))).asJava());
        Mockito.reset((Object[])new ConfluentAdmin[]{this.admin()});
        Mockito.when((Object)this.admin().alterMirrors((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)expectedOps).asJava()), (AlterMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)ret);
        CompletableFuture done = new CompletableFuture();
        int n = 10;
        JFunction0.mcV.sp & Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable)() -> done.complete(null);
        Object var6_7 = null;
        new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), (Option)None$.MODULE$, this.admin(), (Function0)newClearLinkReference_completionCallback, (int)newClearLinkReference_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        ((ConfluentAdmin)Mockito.verify((Object)this.admin())).alterMirrors((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)expectedOps).asJava()), (AlterMirrorsOptions)ArgumentMatchers.any());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getClusterLinkData(this.linkId());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getAllTopicsInCluster();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinatorEnabled();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearMirrorTopicsNotMirror() {
        void newClearLinkReference_topicGroupSize;
        String topic = "topic";
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)this.linkData()));
        Mockito.when((Object)this.metadataManager().getAllTopicsInCluster()).thenReturn(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).thenReturn((Object)Predef$.MODULE$.Map().empty());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinatorEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        CompletableFuture done = new CompletableFuture();
        int n = 10;
        JFunction0.mcV.sp & Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable)() -> done.complete(null);
        Object var3_4 = null;
        new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), (Option)None$.MODULE$, this.admin(), (Function0)newClearLinkReference_completionCallback, (int)newClearLinkReference_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getClusterLinkData(this.linkId());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getAllTopicsInCluster();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinatorEnabled();
    }

    @Test
    public void testClearMirrorTopicsLinkDoesntExist() {
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{this.metadataManager()});
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)None$.MODULE$);
        CompletableFuture done = new CompletableFuture();
        int newClearLinkReference_topicGroupSize = 10;
        JFunction0.mcV.sp & Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable)() -> done.complete(null);
        Object var2_3 = null;
        new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), (Option)None$.MODULE$, this.admin(), (Function0)newClearLinkReference_completionCallback, newClearLinkReference_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getClusterLinkData(this.linkId());
    }

    @Test
    public void testClearMirrorTopicsControllerManyEntries() {
        String otherLinkName = "other-link-name";
        Uuid otherLinkId = Uuid.randomUuid();
        int topicGroupSize = 2;
        Set topics = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)idx -> ClusterLinkClearLinkReferenceTest.$anonfun$testClearMirrorTopicsControllerManyEntries$1(BoxesRunTime.unboxToInt((Object)idx))).toSet();
        List topicGroups = topics.grouped(topicGroupSize).toList();
        Assertions.assertEquals((int)3, (int)topicGroups.size());
        Assertions.assertEquals((int)2, (int)((IterableOnceOps)topicGroups.apply(0)).size());
        Assertions.assertEquals((int)2, (int)((IterableOnceOps)topicGroups.apply(1)).size());
        Assertions.assertEquals((int)1, (int)((IterableOnceOps)topicGroups.apply(2)).size());
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)this.linkData()));
        Mockito.when((Object)this.metadataManager().getAllTopicsInCluster()).thenReturn((Object)topics);
        Object[] objectArray = new Tuple2[2];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((IterableOps)topicGroups.head()).head()), (Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty()));
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((IterableOps)topicGroups.head()).last()), (Object)new ClusterLinkTopicState.Mirror(otherLinkName, otherLinkId, this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty()));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)topicGroups.head())).thenReturn(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        Object[] objectArray2 = new Tuple2[2];
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((IterableOps)topicGroups.apply(1)).head()), (Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty()));
        objectArray2[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((IterableOps)topicGroups.apply(1)).last()), (Object)new ClusterLinkTopicState.FailedMirror(this.linkName(), this.linkId(), this.sourceTopicId(), MirrorTopicError.SOURCE_TOPIC_ID_CHANGED, Time.SYSTEM.milliseconds()));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)topicGroups.apply(1))).thenReturn(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set)topicGroups.apply(2))).thenReturn((Object)Predef$.MODULE$.Map().empty());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinatorEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        scala.collection.immutable.Map expectedOps1 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((IterableOps)topicGroups.apply(0)).head()), (Object)AlterMirrorOp.CLEAR)}));
        scala.collection.immutable.Map expectedOps2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((IterableOps)topicGroups.apply(1)).head()), (Object)AlterMirrorOp.CLEAR), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((IterableOps)topicGroups.apply(1)).last()), (Object)AlterMirrorOp.CLEAR)}));
        AlterMirrorsResult ret1 = this.newAlterMirrorsResult((scala.collection.immutable.Seq<String>)new .colon.colon((Object)((String)((IterableOps)topicGroups.apply(0)).head()), (List)Nil$.MODULE$));
        AlterMirrorsResult ret2 = this.newAlterMirrorsResult((scala.collection.immutable.Seq<String>)new .colon.colon((Object)((String)((IterableOps)topicGroups.apply(1)).head()), (List)new .colon.colon((Object)((String)((IterableOps)topicGroups.apply(1)).last()), (List)Nil$.MODULE$)));
        Mockito.reset((Object[])new ConfluentAdmin[]{this.admin()});
        Mockito.when((Object)this.admin().alterMirrors((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)expectedOps1).asJava()), (AlterMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)ret1);
        Mockito.when((Object)this.admin().alterMirrors((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)expectedOps2).asJava()), (AlterMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)ret2);
        CompletableFuture done = new CompletableFuture();
        JFunction0.mcV.sp & Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable)() -> done.complete(null);
        Object var11_11 = null;
        new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), (Option)None$.MODULE$, this.admin(), (Function0)newClearLinkReference_completionCallback, topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        ((ConfluentAdmin)Mockito.verify((Object)this.admin())).alterMirrors((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)expectedOps1).asJava()), (AlterMirrorsOptions)ArgumentMatchers.any());
        ((ConfluentAdmin)Mockito.verify((Object)this.admin())).alterMirrors((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)expectedOps2).asJava()), (AlterMirrorsOptions)ArgumentMatchers.any());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getClusterLinkData(this.linkId());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getAllTopicsInCluster();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).mirrorTopicStatesFromMetadataStore((Set)topicGroups.apply(1));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).mirrorTopicStatesFromMetadataStore((Set)topicGroups.apply(2));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinatorEnabled();
    }

    @Test
    public void testKraftModeShouldClearLinkReference() {
        ClusterLinkMetadataManager kraftMetadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManagerWithKRaftSupport.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)kraftMetadataManager.clusterLinkExists(this.linkId()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Assertions.assertFalse((boolean)ClusterLinkClearLinkReference$.MODULE$.shouldClearLinkReference(this.linkId(), kraftMetadataManager));
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{kraftMetadataManager});
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)kraftMetadataManager.clusterLinkExists(this.linkId()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Assertions.assertFalse((boolean)ClusterLinkClearLinkReference$.MODULE$.shouldClearLinkReference(this.linkId(), kraftMetadataManager));
    }

    @Test
    public void testZkModeShouldClearLinkReference() {
        ClusterLinkMetadataManager zkMetadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManagerWithZkSupport.class);
        ClusterLinkData linkDataIsDeleted = new ClusterLinkData(this.linkName(), this.linkId(), (Option)None$.MODULE$, (Option)None$.MODULE$, true);
        Mockito.when((Object)zkMetadataManager.getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)linkDataIsDeleted));
        Assertions.assertTrue((boolean)ClusterLinkClearLinkReference$.MODULE$.shouldClearLinkReference(this.linkId(), zkMetadataManager));
        ClusterLinkData linkDataIsNotDeleted = new ClusterLinkData(this.linkName(), this.linkId(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{zkMetadataManager});
        Mockito.when((Object)zkMetadataManager.getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)linkDataIsNotDeleted));
        Assertions.assertFalse((boolean)ClusterLinkClearLinkReference$.MODULE$.shouldClearLinkReference(this.linkId(), zkMetadataManager));
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{zkMetadataManager});
        Mockito.when((Object)zkMetadataManager.getClusterLinkData(this.linkId())).thenReturn((Object)None$.MODULE$);
        Assertions.assertFalse((boolean)ClusterLinkClearLinkReference$.MODULE$.shouldClearLinkReference(this.linkId(), zkMetadataManager));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteClusterLinkMetadataWhenLinkCoordinatorIsEnabled() {
        void newClearLinkReference_topicGroupSize;
        Mockito.when((Object)this.metadataManager().getClusterLinkData(this.linkId())).thenReturn((Object)new Some((Object)this.linkData()));
        Mockito.when((Object)this.metadataManager().getAllTopicsInCluster()).thenReturn((Object)Predef$.MODULE$.Set().empty());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinatorEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        KafkaFutureImpl featureCompletedWithEx = new KafkaFutureImpl();
        featureCompletedWithEx.completeExceptionally((Throwable)new InvalidRequestException(""));
        Mockito.when((Object)this.admin().deleteClusterLinks((Collection)ArgumentMatchers.eq(Collections.singletonList(this.linkName())), (DeleteClusterLinksOptions)ArgumentMatchers.any())).thenThrow(new Throwable[]{new InvalidRequestException("")}).thenReturn((Object)new DeleteClusterLinksResult(Collections.singletonMap(this.linkName(), featureCompletedWithEx))).thenReturn((Object)new DeleteClusterLinksResult(Collections.singletonMap(this.linkName(), KafkaFuture.completedFuture(null))));
        CompletableFuture done = new CompletableFuture();
        int n = 10;
        JFunction0.mcV.sp & Serializable newClearLinkReference_completionCallback = (JFunction0.mcV.sp & Serializable)() -> done.complete(null);
        Object var3_4 = null;
        new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), (Option)None$.MODULE$, this.admin(), (Function0)newClearLinkReference_completionCallback, (int)newClearLinkReference_topicGroupSize, 10, 10).startup();
        done.get();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)3))).getClusterLinkData(this.linkId());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)1))).getAllTopicsInCluster();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)3))).isLinkCoordinatorEnabled();
        ((ConfluentAdmin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)3))).deleteClusterLinks((Collection)ArgumentMatchers.eq(Collections.singletonList(this.linkName())), (DeleteClusterLinksOptions)ArgumentMatchers.any());
    }

    private AlterMirrorsResult newAlterMirrorsResult(scala.collection.immutable.Seq<String> topics) {
        return new AlterMirrorsResult(CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)topics.map((Function1 & Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), (Object)KafkaFuture.completedFuture(null)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava());
    }

    private ClusterLinkClearLinkReference newClearLinkReferenceWithAuthorizer(Function0<BoxedUnit> completionCallback, Option<Authorizer> authorizer, int topicsGroupsSize) {
        return new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), authorizer, this.admin(), completionCallback, topicsGroupsSize, 10, 10);
    }

    private ClusterLinkClearLinkReference newClearLinkReference(Function0<BoxedUnit> completionCallback, int topicGroupSize) {
        return new ClusterLinkClearLinkReference(this.linkId(), this.linkName(), this.scheduler(), this.metadataManager(), (Option)None$.MODULE$, this.admin(), completionCallback, topicGroupSize, 10, 10);
    }

    private int newClearLinkReferenceWithAuthorizer$default$3() {
        return 10;
    }

    private int newClearLinkReference$default$2() {
        return 10;
    }

    public static final /* synthetic */ String $anonfun$testClearMirrorTopicsControllerManyEntries$1(int idx) {
        return new StringBuilder(6).append("topic-").append(idx).toString();
    }

    public ClusterLinkClearLinkReferenceTest() {
        this.linkName = "link-name";
    }
}

