/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.cluster.EndPoint;
import kafka.server.KafkaConfig;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaQuota;
import kafka.server.link.ClusterLinkAdminClient;
import kafka.server.link.ClusterLinkAdminManager;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkConnectionManager;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkTestUtils$;
import kafka.server.link.ConnectionMode;
import kafka.utils.TestUtils$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeClusterLinksOptions;
import org.apache.kafka.clients.admin.DescribeClusterLinksResult;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.ListClusterLinksOptions;
import org.apache.kafka.clients.admin.ListClusterLinksResult;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.CreateClusterLinksRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.CreateClusterLinksRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0011Mb\u0001\u0002,X\u0001yCQ!\u001a\u0001\u0005\u0002\u0019Dq!\u001b\u0001C\u0002\u0013%!\u000e\u0003\u0004p\u0001\u0001\u0006Ia\u001b\u0005\ba\u0002\u0011\r\u0011\"\u0003r\u0011\u0019Q\b\u0001)A\u0005e\"91\u0010\u0001a\u0001\n\u0013\t\bb\u0002?\u0001\u0001\u0004%I! \u0005\b\u0003\u000f\u0001\u0001\u0015)\u0003s\u0011!\tI\u0001\u0001a\u0001\n\u0013\t\b\"CA\u0006\u0001\u0001\u0007I\u0011BA\u0007\u0011\u001d\t\t\u0002\u0001Q!\nID\u0011\"a\u0005\u0001\u0005\u0004%I!!\u0006\t\u0011\u0005E\u0002\u0001)A\u0005\u0003/A\u0011\"a\r\u0001\u0005\u0004%I!!\u000e\t\u0011\u0005u\u0002\u0001)A\u0005\u0003oA\u0011\"a\u0010\u0001\u0005\u0004%I!!\u0011\t\u0011\u00055\u0003\u0001)A\u0005\u0003\u0007B\u0011\"a\u0014\u0001\u0005\u0004%I!!\u0015\t\u0011\u0005}\u0003\u0001)A\u0005\u0003'B1\"!\u0019\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002d!Y\u00111\u000e\u0001A\u0002\u0003\u0007I\u0011BA7\u0011-\t\t\b\u0001a\u0001\u0002\u0003\u0006K!!\u001a\t\u0017\u0005M\u0004\u00011AA\u0002\u0013%\u0011Q\u000f\u0005\f\u0003{\u0002\u0001\u0019!a\u0001\n\u0013\ty\bC\u0006\u0002\u0004\u0002\u0001\r\u0011!Q!\n\u0005]\u0004\"CAC\u0001\t\u0007I\u0011BAD\u0011!\ty\t\u0001Q\u0001\n\u0005%\u0005\"CAI\u0001\t\u0007I\u0011BAJ\u0011!\t\t\u000b\u0001Q\u0001\n\u0005U\u0005\"CAR\u0001\t\u0007I\u0011BAS\u0011!\t\t\f\u0001Q\u0001\n\u0005\u001d\u0006\"CAZ\u0001\u0001\u0007I\u0011BA[\u0011%\t\t\u000e\u0001a\u0001\n\u0013\t\u0019\u000e\u0003\u0005\u0002X\u0002\u0001\u000b\u0015BA\\\u0011%\tI\u000e\u0001b\u0001\n\u0013\tY\u000e\u0003\u0005\u0002z\u0002\u0001\u000b\u0011BAo\u0011\u001d\tY\u0010\u0001C\u0001\u0003{DqA!\u0006\u0001\t\u0003\ti\u0010C\u0004\u0003 \u0001!\t!!@\t\u000f\t%\u0002\u0001\"\u0001\u0002~\"9!Q\u0006\u0001\u0005\u0002\u0005u\bb\u0002B\u0019\u0001\u0011\u0005\u0011Q \u0005\b\u0005k\u0001A\u0011AA\u007f\u0011\u001d\u0011I\u0004\u0001C\u0001\u0003{DqA!\u0010\u0001\t\u0003\ti\u0010C\u0004\u0003B\u0001!\t!!@\t\u000f\t\u0015\u0003\u0001\"\u0001\u0002~\"9!\u0011\n\u0001\u0005\u0002\u0005u\bb\u0002B'\u0001\u0011\u0005\u0011Q \u0005\b\u0005#\u0002A\u0011AA\u007f\u0011\u001d\u0011)\u0006\u0001C\u0001\u0003{DqA!\u0017\u0001\t\u0003\ti\u0010C\u0004\u0003^\u0001!\t!!@\t\u000f\t\u0005\u0004\u0001\"\u0001\u0002~\"9!Q\r\u0001\u0005\u0002\u0005u\bb\u0002B5\u0001\u0011\u0005\u0011Q \u0005\b\u0005[\u0002A\u0011AA\u007f\u0011\u001d\u0011\t\b\u0001C\u0001\u0003{DqA!\u001e\u0001\t\u0003\ti\u0010C\u0004\u0003z\u0001!\t!!@\t\u000f\tu\u0004\u0001\"\u0001\u0002~\"9!\u0011\u0011\u0001\u0005\n\t\r\u0005b\u0002Bh\u0001\u0011%!\u0011\u001b\u0005\b\u0005g\u0004A\u0011\u0002B{\u0011\u001d\u0011i\u0010\u0001C\u0005\u0005\u007fD\u0011b!\u0007\u0001#\u0003%Iaa\u0007\t\u0013\rE\u0002!%A\u0005\n\rM\u0002bBB\u001c\u0001\u0011%1\u0011\b\u0005\n\u0007#\u0002\u0011\u0013!C\u0005\u00077A\u0011ba\u0015\u0001#\u0003%Iaa\r\t\u000f\rU\u0003\u0001\"\u0003\u0004X!91Q\f\u0001\u0005\n\r}\u0003bBB<\u0001\u0011%1\u0011\u0010\u0005\n\u0007\u0003\u0003\u0011\u0013!C\u0005\u0007\u0007C\u0011ba\"\u0001#\u0003%Iaa!\t\u000f\r%\u0005\u0001\"\u0003\u0004\f\"I1Q\u0017\u0001\u0012\u0002\u0013%11\u0011\u0005\n\u0007o\u0003\u0011\u0013!C\u0005\u0007\u0007C\u0011b!/\u0001#\u0003%Iaa/\t\u0013\r}\u0006!%A\u0005\n\r\u0005\u0007\"CBc\u0001E\u0005I\u0011BBd\u0011\u001d\u0019Y\r\u0001C\u0005\u0007\u001bDq\u0001b\u0001\u0001\t\u0013!)\u0001C\u0004\u0005\u0018\u0001!I\u0001\"\u0007\t\u000f\u0011-\u0002\u0001\"\u0003\u0005.\tY2\t\\;ti\u0016\u0014H*\u001b8l\u0003\u0012l\u0017N\\'b]\u0006<WM\u001d+fgRT!\u0001W-\u0002\t1Lgn\u001b\u0006\u00035n\u000baa]3sm\u0016\u0014(\"\u0001/\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0018\t\u0003A\u000el\u0011!\u0019\u0006\u0002E\u0006)1oY1mC&\u0011A-\u0019\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00059\u0007C\u00015\u0001\u001b\u00059\u0016\u0001\u00042s_.,'oQ8oM&<W#A6\u0011\u00051lW\"A-\n\u00059L&aC&bM.\f7i\u001c8gS\u001e\fQB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u0004\u0013A\u00047pG\u0006d7\t\\;ti\u0016\u0014\u0018\nZ\u000b\u0002eB\u00111\u000f_\u0007\u0002i*\u0011QO^\u0001\u0005Y\u0006twMC\u0001x\u0003\u0011Q\u0017M^1\n\u0005e$(AB*ue&tw-A\bm_\u000e\fGn\u00117vgR,'/\u00133!\u0003=\u0011X-\\8uK\u000ecWo\u001d;fe&#\u0017a\u0005:f[>$Xm\u00117vgR,'/\u00133`I\u0015\fHc\u0001@\u0002\u0004A\u0011\u0001m`\u0005\u0004\u0003\u0003\t'\u0001B+oSRD\u0001\"!\u0002\b\u0003\u0003\u0005\rA]\u0001\u0004q\u0012\n\u0014\u0001\u0005:f[>$Xm\u00117vgR,'/\u00133!\u0003!a\u0017N\\6OC6,\u0017\u0001\u00047j].t\u0015-\\3`I\u0015\fHc\u0001@\u0002\u0010!A\u0011Q\u0001\u0006\u0002\u0002\u0003\u0007!/A\u0005mS:\\g*Y7fA\u0005aA.[:uK:,'OT1nKV\u0011\u0011q\u0003\t\u0005\u00033\ti#\u0004\u0002\u0002\u001c)!\u0011QDA\u0010\u0003\u001dqW\r^<pe.TA!!\t\u0002$\u000511m\\7n_:T1\u0001XA\u0013\u0015\u0011\t9#!\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\tY#A\u0002pe\u001eLA!a\f\u0002\u001c\taA*[:uK:,'OT1nK\u0006iA.[:uK:,'OT1nK\u0002\n\u0011c\u0019:fCR,G*\u001b8l-\u0016\u00148/[8o+\t\t9\u0004E\u0002a\u0003sI1!a\u000fb\u0005\u0015\u0019\u0006n\u001c:u\u0003I\u0019'/Z1uK2Kgn\u001b,feNLwN\u001c\u0011\u0002\u000f5,GO]5dgV\u0011\u00111\t\t\u0005\u0003\u000b\nI%\u0004\u0002\u0002H)!\u0011qHA\u0010\u0013\u0011\tY%a\u0012\u0003\u000f5+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%\u0001\u0003uS6,WCAA*!\u0011\t)&a\u0017\u000e\u0005\u0005]#\u0002BA-\u0003?\tQ!\u001e;jYNLA!!\u0018\u0002X\tAQj\\2l)&lW-A\u0003uS6,\u0007%\u0001\ndYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014XCAA3!\rA\u0017qM\u0005\u0004\u0003S:&AE\"mkN$XM\u001d'j].l\u0015M\\1hKJ\fac\u00197vgR,'\u000fT5oW6\u000bg.Y4fe~#S-\u001d\u000b\u0004}\u0006=\u0004\"CA\u0003+\u0005\u0005\t\u0019AA3\u0003M\u0019G.^:uKJd\u0015N\\6NC:\fw-\u001a:!\u00031\tG-\\5o\u001b\u0006t\u0017mZ3s+\t\t9\bE\u0002i\u0003sJ1!a\u001fX\u0005]\u0019E.^:uKJd\u0015N\\6BI6Lg.T1oC\u001e,'/\u0001\tbI6Lg.T1oC\u001e,'o\u0018\u0013fcR\u0019a0!!\t\u0013\u0005\u0015\u0001$!AA\u0002\u0005]\u0014!D1e[&tW*\u00198bO\u0016\u0014\b%\u0001\fdYV\u001cH/\u001a:MS:\\\u0017\tZ7j]\u000ec\u0017.\u001a8u+\t\tI\tE\u0002i\u0003\u0017K1!!$X\u0005Y\u0019E.^:uKJd\u0015N\\6BI6Lgn\u00117jK:$\u0018aF2mkN$XM\u001d'j].\fE-\\5o\u00072LWM\u001c;!\u00035qW\r^<pe.\u001cE.[3oiV\u0011\u0011Q\u0013\t\u0005\u0003/\u000bi*\u0004\u0002\u0002\u001a*!\u00111TA\u0012\u0003\u001d\u0019G.[3oiNLA!a(\u0002\u001a\nia*\u001a;x_J\\7\t\\5f]R\faB\\3uo>\u00148n\u00117jK:$\b%A\u0003bI6Lg.\u0006\u0002\u0002(B!\u0011\u0011VAW\u001b\t\tYK\u0003\u0003\u0002$\u0006e\u0015\u0002BAX\u0003W\u0013abQ8oM2,XM\u001c;BI6Lg.\u0001\u0004bI6Lg\u000eI\u0001\ri\u0016t\u0017M\u001c;Qe\u00164\u0017\u000e_\u000b\u0003\u0003o\u0003R\u0001YA]\u0003{K1!a/b\u0005\u0019y\u0005\u000f^5p]B!\u0011qXAg\u001d\u0011\t\t-!3\u0011\u0007\u0005\r\u0017-\u0004\u0002\u0002F*\u0019\u0011qY/\u0002\rq\u0012xn\u001c;?\u0013\r\tY-Y\u0001\u0007!J,G-\u001a4\n\u0007e\fyMC\u0002\u0002L\u0006\f\u0001\u0003^3oC:$\bK]3gSb|F%Z9\u0015\u0007y\f)\u000eC\u0005\u0002\u0006\u0005\n\t\u00111\u0001\u00028\u0006iA/\u001a8b]R\u0004&/\u001a4jq\u0002\nA\u0002\\5oWN\u001c%/Z1uK\u0012,\"!!8\u0011\r\u0005}\u0017\u0011^Aw\u001b\t\t\tO\u0003\u0003\u0002d\u0006\u0015\u0018aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003O\f\u0017AC2pY2,7\r^5p]&!\u00111^Aq\u0005\u0019\u0011UO\u001a4feB!\u0011q^A{\u001b\t\t\tPC\u0002\u0002tn\u000b!A_6\n\t\u0005]\u0018\u0011\u001f\u0002\u0010\u00072,8\u000f^3s\u0019&t7\u000eR1uC\u0006iA.\u001b8lg\u000e\u0013X-\u0019;fI\u0002\nQa]3u+B$\u0012A \u0015\u0004K\t\u0005\u0001\u0003\u0002B\u0002\u0005#i!A!\u0002\u000b\t\t\u001d!\u0011B\u0001\u0004CBL'\u0002\u0002B\u0006\u0005\u001b\tqA[;qSR,'O\u0003\u0003\u0003\u0010\u0005%\u0012!\u00026v]&$\u0018\u0002\u0002B\n\u0005\u000b\u0011!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007f\u0001\u0014\u0003\u001aA!!1\u0001B\u000e\u0013\u0011\u0011iB!\u0002\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\r;fgR\u001c%/Z1uK\u0012+7\u000f^5oCRLwN\\(vi\n|WO\u001c3MS:\\g+\u00197jI\u0006$X\rT5oW\u001a\u000bGn]3)\u0007\u001d\u0012\u0019\u0003\u0005\u0003\u0003\u0004\t\u0015\u0012\u0002\u0002B\u0014\u0005\u000b\u0011A\u0001V3ti\u0006\tD/Z:u\u0007J,\u0017\r^3EKN$\u0018N\\1uS>tw*\u001e;c_VtG\rT5oWZ\u000bG.\u001b3bi\u0016d\u0015N\\6UeV,\u0007f\u0001\u0015\u0003$\u0005YB/Z:u\u0007J,\u0017\r^3T_V\u00148-\u001a'j].LeNY8v]\u0012D3!\u000bB\u0012\u00035\"Xm\u001d;De\u0016\fG/Z*pkJ\u001cW\rT5oW>+HOY8v]\u00124\u0016\r\\5eCR,G*\u001b8l\r\u0006d7/\u001a\u0015\u0004U\t\r\u0012\u0001\f;fgR\u001c%/Z1uKN{WO]2f\u001fV$(m\\;oI2Kgn\u001b,bY&$\u0017\r^3MS:\\GK];fQ\rY#1E\u0001)i\u0016\u001cHo\u0011:fCR,7k\\;sG\u0016d\u0015N\\6O_\u000ecWo\u001d;fe\u0006cG/\u001a:BG\u000e,7o\u001d\u0015\u0004Y\t\r\u0012\u0001\t;fgR\u001c%/Z1uKN{WO]2f\u0019&t7NT8SK6|G/\u001a'j].D3!\fB\u0012\u0003-\"Xm\u001d;De\u0016\fG/Z*pkJ\u001cW\rT5oW^KG\u000f['jg6\fGo\u00195fI\u000ecWo\u001d;fe&#\u0007f\u0001\u0018\u0003$\u0005!D/Z:u\u0007J,\u0017\r^3CS\u0012L'/Z2uS>t\u0017\r\u001c'j].|U\u000f\u001e2pk:$g+\u00197jI\u0006$X\rT5oW\u001a\u000bGn]3)\u0007=\u0012\u0019#A\u001auKN$8I]3bi\u0016\u0014\u0015\u000eZ5sK\u000e$\u0018n\u001c8bY2Kgn[(vi\n|WO\u001c3WC2LG-\u0019;f\u0019&t7\u000e\u0016:vK\"\u001a\u0001Ga\t\u0002gQ,7\u000f^\"sK\u0006$XMQ5eSJ,7\r^5p]\u0006dG*\u001b8l\u0013:\u0014w.\u001e8e-\u0006d\u0017\u000eZ1uK2Kgn\u001b$bYN,\u0007fA\u0019\u0003$\u0005\u0011D/Z:u\u0007J,\u0017\r^3CS\u0012L'/Z2uS>t\u0017\r\u001c'j].LeNY8v]\u00124\u0016\r\\5eCR,G*\u001b8l)J,X\rK\u00023\u0005G\tQ\u0007^3ti\u000e\u0013X-\u0019;f\u0005&$\u0017N]3di&|g.\u00197MS:\\w*\u001e;c_VtGmV5uQ>+HOY8v]\u0012\u0014V-\\8uK\"\u001a1Ga\t\u0002iQ,7\u000f^\"sK\u0006$XMQ5eSJ,7\r^5p]\u0006dG*\u001b8l\u001fV$(m\\;oI^KG\u000f[%oE>,h\u000e\u001a*f[>$X\rK\u00025\u0005G\ta\u0006^3ti\u000e\u0013X-\u0019;f\u0005&$\u0017N]3di&|g.\u00197MS:\\w+\u001b;i\u0019&t7.\u00133Ta\u0016\u001c\u0017NZ5fI\"\u001aQGa\t\u0002cQ,7\u000f^\"sK\u0006$XMQ5eSJ,7\r^5p]\u0006dG*\u001b8l+:l\u0017M\\1hK\u0012\u001cv.\u001e:dK&;gn\u001c:fI\"\u001aaGa\t\u0002sQ,7\u000f^\"sK\u0006$XMQ5eSJ,7\r^5p]\u0006dG*\u001b8l/&$\bNT8o\u000bbL7\u000f^3oi2Kgn[%e'B,7-\u001b4jK\u0012D3a\u000eB\u0012\u0003a\"Xm\u001d;De\u0016\fG/\u001a\"jI&\u0014Xm\u0019;j_:\fG\u000eT5oW^KG\u000f['jg6\fGo\u00195fI2Kgn[%e'B,7-\u001b4jK\u0012D3\u0001\u000fB\u0012\u0003I\"Xm\u001d;De\u0016\fG/\u001a\"jI&\u0014Xm\u0019;j_:\fG\u000eT5oW^KG\u000f['jg6\fGo\u00195fI\u000ecWo\u001d;fe&#\u0007fA\u001d\u0003$\u0005\u0019D/Z:u\u0007J,\u0017\r^3CS\u0012L'/Z2uS>t\u0017\r\u001c'j].$vNT8o\u0005&$\u0017N]3di&|g.\u00197SK6|G/\u001a\u0015\u0004u\t\r\u0012a\f;fgR\u001c%/Z1uK\nKG-\u001b:fGRLwN\\1m\u0019&t7NT8DYV\u001cH/\u001a:BYR,'/Q2dKN\u001c\bfA\u001e\u0003$\u0005qB/Z:u\u0007J,\u0017\r^3MS:\\w+\u001b;i)\u0016t\u0017M\u001c;Qe\u00164\u0017\u000e\u001f\u0015\u0004y\t\r\u0012A\u0006;fgR\u001c%/Z1uK\u000eK'oY;mCJd\u0015N\\6)\u0007u\u0012\u0019#A\bde\u0016\fG/\u001a,bY&$G*\u001b8l)!\u0011)I!$\u0003<\n\u0015\u0007\u0003\u0002BD\u0005\u0013k!!a\b\n\t\t-\u0015q\u0004\u0002\u0005+VLG\rC\u0004\u0003\u0010z\u0002\rA!%\u0002\u00111Lgn['pI\u0016\u0004BAa%\u00036:!!Q\u0013BX\u001d\u0011\u00119Ja+\u000f\t\te%q\u0015\b\u0005\u00057\u0013\tK\u0004\u0003\u0002D\nu\u0015B\u0001BP\u0003\tIw.\u0003\u0003\u0003$\n\u0015\u0016!C2p]\u001adW/\u001a8u\u0015\t\u0011y*C\u0002]\u0005SSAAa)\u0003&&\u0019\u0001L!,\u000b\u0007q\u0013I+\u0003\u0003\u00032\nM\u0016!E\"mkN$XM\u001d'j].\u001cuN\u001c4jO*\u0019\u0001L!,\n\t\t]&\u0011\u0018\u0002\t\u0019&t7.T8eK*!!\u0011\u0017BZ\u0011\u001d\u0011iL\u0010a\u0001\u0005\u007f\u000babY8o]\u0016\u001cG/[8o\u001b>$W\rE\u0002i\u0005\u0003L1Aa1X\u00059\u0019uN\u001c8fGRLwN\\'pI\u0016DqAa2?\u0001\u0004\u0011I-\u0001\u0007wC2LG-\u0019;f\u0019&t7\u000eE\u0002a\u0005\u0017L1A!4b\u0005\u001d\u0011un\u001c7fC:\f\u0011c\u0019:fCR,7\t\\;ti\u0016\u0014H*\u001b8l)!\u0011\u0019Na9\u0003n\nE\bC\u0002Bk\u0005?\u0014))\u0004\u0002\u0003X*!!\u0011\u001cBn\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0005;4\u0018\u0001B;uS2LAA!9\u0003X\n\t2i\\7qY\u0016$\u0018M\u00197f\rV$XO]3\t\u000f\t\u0015x\b1\u0001\u0003h\u00069a.Z<MS:\\\u0007\u0003BAU\u0005SLAAa;\u0002,\nqa*Z<DYV\u001cH/\u001a:MS:\\\u0007b\u0002Bx\u007f\u0001\u0007!\u0011Z\u0001\rm\u0006d\u0017\u000eZ1uK>sG.\u001f\u0005\b\u0005\u000f|\u0004\u0019\u0001Be\u0003]1XM]5gsZ\u000bG.\u001b3MS:\\gi\u001c:Le\u00064G\u000fF\u0004\u007f\u0005o\u0014IPa?\t\u000f\t=\u0005\t1\u0001\u0003\u0012\"9!Q\u0018!A\u0002\t}\u0006b\u0002Bd\u0001\u0002\u0007!\u0011Z\u0001\u000f]\u0016<8\t\\;ti\u0016\u0014H*\u001b8l))\u00119o!\u0001\u0004\u0006\r\u001d11\u0003\u0005\b\u0007\u0007\t\u0005\u0019\u0001BI\u0003\u0011iw\u000eZ3\t\u000f\tu\u0016\t1\u0001\u0003@\"I1\u0011B!\u0011\u0002\u0003\u000711B\u0001\n_Z,'O]5eKN\u0004\u0002b!\u0004\u0004\u0010\u0005u\u0016QX\u0007\u0003\u0003KLAa!\u0005\u0002f\n\u0019Q*\u00199\t\u0013\rU\u0011\t%AA\u0002\r]\u0011\u0001\u0004:f[>$X\rT5oW&#\u0007#\u00021\u0002:\n\u0015\u0015\u0001\u00078fo\u000ecWo\u001d;fe2Kgn\u001b\u0013eK\u001a\fW\u000f\u001c;%gU\u00111Q\u0004\u0016\u0005\u0007\u0017\u0019yb\u000b\u0002\u0004\"A!11EB\u0017\u001b\t\u0019)C\u0003\u0003\u0004(\r%\u0012!C;oG\",7m[3e\u0015\r\u0019Y#Y\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB\u0018\u0007K\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003aqWm^\"mkN$XM\u001d'j].$C-\u001a4bk2$H\u0005N\u000b\u0003\u0007kQCaa\u0006\u0004 \u0005)b.Z<DYV\u001cH/\u001a:MS:\\'+Z9vKN$H\u0003DB\u001e\u0007\u000f\u001aIea\u0013\u0004N\r=\u0003\u0003BB\u001f\u0007\u0007j!aa\u0010\u000b\t\r\u0005\u0013qD\u0001\te\u0016\fX/Z:ug&!1QIB \u0005e\u0019%/Z1uK\u000ecWo\u001d;fe2Kgn[:SKF,Xm\u001d;\t\u000f\r\rA\t1\u0001\u0003\u0012\"9!Q\u0018#A\u0002\t}\u0006\"CB\u0005\tB\u0005\t\u0019AB\u0006\u0011%\u0019)\u0002\u0012I\u0001\u0002\u0004\u00199\u0002C\u0004\u0003H\u0012\u0003\rA!3\u0002?9,wo\u00117vgR,'\u000fT5oWJ+\u0017/^3ti\u0012\"WMZ1vYR$3'A\u0010oK^\u001cE.^:uKJd\u0015N\\6SKF,Xm\u001d;%I\u00164\u0017-\u001e7uIQ\n\u0001C\\3x\u0019&t7\u000eV8SKF,Xm\u001d;\u0015\r\rm2\u0011LB.\u0011\u0019Av\t1\u0001\u0003h\"9!qY$A\u0002\t%\u0017!F3oC\ndW\rR3tGJL'-Z\"mkN$XM\u001d\u000b\u0004}\u000e\u0005\u0004bBB2\u0011\u0002\u00071QM\u0001\u0005C\u000ed7\u000fE\u0003a\u0007O\u001aY'C\u0002\u0004j\u0005\u0014!\u0002\u0010:fa\u0016\fG/\u001a3?!\u0011\u0019iga\u001d\u000e\u0005\r=$\u0002BB9\u0003?\t1!Y2m\u0013\u0011\u0019)ha\u001c\u0003\u0019\u0005\u001bGn\u00149fe\u0006$\u0018n\u001c8\u0002\u001f\u0015t\u0017M\u00197f\u0019&\u001cH\u000fT5oWN$rA`B>\u0007{\u001ay\bC\u0004\u0004\u0016%\u0003\raa\u0006\t\u0011AL\u0005\u0013!a\u0001\u0003{C\u0001b_%\u0011\u0002\u0003\u0007\u0011QX\u0001\u001aK:\f'\r\\3MSN$H*\u001b8lg\u0012\"WMZ1vYR$#'\u0006\u0002\u0004\u0006*\"\u0011QXB\u0010\u0003e)g.\u00192mK2K7\u000f\u001e'j].\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0002'\u0015t\u0017M\u00197f\t\u0016\u001c8M]5cK2Kgn[:\u0015\u001by\u001ciia$\u0004\u0012\u000eM51UBV\u0011\u001d\u0019)\u0002\u0014a\u0001\u0007/A\u0001\u0002\u001d'\u0011\u0002\u0003\u0007\u0011Q\u0018\u0005\tw2\u0003\n\u00111\u0001\u0002>\"I1Q\u0013'\u0011\u0002\u0003\u00071qS\u0001\u000fe\u0016lw\u000e^3MS:\\Wj\u001c3f!\u0011\u0019Ija(\u000f\t\u0005%61T\u0005\u0005\u0007;\u000bY+\u0001\fDYV\u001cH/\u001a:MS:\\G)Z:de&\u0004H/[8o\u0013\u0011\u00119l!)\u000b\t\ru\u00151\u0016\u0005\n\u0007Kc\u0005\u0013!a\u0001\u0007O\u000bAC]3n_R,7i\u001c8oK\u000e$\u0018n\u001c8N_\u0012,\u0007\u0003BBM\u0007SKAAa1\u0004\"\"I1Q\u0016'\u0011\u0002\u0003\u00071qV\u0001\u0010e\u0016lw\u000e^3MS:\\7\u000b^1uKB!1\u0011TBY\u0013\u0011\u0019\u0019l!)\u0003\u00131Kgn[*uCR,\u0017!H3oC\ndW\rR3tGJL'-\u001a'j].\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0002;\u0015t\u0017M\u00197f\t\u0016\u001c8M]5cK2Kgn[:%I\u00164\u0017-\u001e7uIM\nQ$\u001a8bE2,G)Z:de&\u0014W\rT5oWN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0007{SCaa&\u0004 \u0005iRM\\1cY\u0016$Um]2sS\n,G*\u001b8lg\u0012\"WMZ1vYR$S'\u0006\u0002\u0004D*\"1qUB\u0010\u0003u)g.\u00192mK\u0012+7o\u0019:jE\u0016d\u0015N\\6tI\u0011,g-Y;mi\u00122TCABeU\u0011\u0019yka\b\u0002=Y,'/\u001b4z\u00072,8\u000f^3s\u0019&t7n\u0011:fCR,g)Y5mkJ,Gc\u0002@\u0004P\u000eE7q \u0005\b\u0005K\u0014\u0006\u0019\u0001Bt\u0011\u001d\u0019\u0019N\u0015a\u0001\u0007+\fa\"\u001a=dKB$\u0018n\u001c8DY\u0006\u001c8\u000f\r\u0003\u0004X\u000e\u0005\bCBA`\u00073\u001ci.\u0003\u0003\u0004\\\u0006='!B\"mCN\u001c\b\u0003BBp\u0007Cd\u0001\u0001\u0002\u0007\u0004d\u000eE\u0017\u0011!A\u0001\u0006\u0003\u0019)OA\u0002`IE\nBaa:\u0004nB\u0019\u0001m!;\n\u0007\r-\u0018MA\u0004O_RD\u0017N\\4\u0011\t\r=8\u0011 \b\u0005\u0007c\u001c)P\u0004\u0003\u0002D\u000eM\u0018\"\u00012\n\u0007\r]\u0018-A\u0004qC\u000e\\\u0017mZ3\n\t\rm8Q \u0002\n)\"\u0014xn^1cY\u0016T1aa>b\u0011\u001d!\tA\u0015a\u0001\u0003{\u000bq!\\3tg\u0006<W-A\u0013wKJLg-_\"mkN$XM\u001d'j].\u001c%/Z1uKJ+\u0017/^3ti\u001a\u000b\u0017\u000e\\;sKR9a\u0010b\u0002\u0005\n\u0011U\u0001b\u0002Bs'\u0002\u0007!q\u001d\u0005\b\u0007'\u001c\u0006\u0019\u0001C\u0006a\u0011!i\u0001\"\u0005\u0011\r\u0005}6\u0011\u001cC\b!\u0011\u0019y\u000e\"\u0005\u0005\u0019\u0011MA\u0011BA\u0001\u0002\u0003\u0015\ta!:\u0003\u0007}##\u0007C\u0004\u0005\u0002M\u0003\r!!0\u0002KY,'/\u001b4z\u0017J\u000bg\r^\"mkN$XM\u001d'j].4\u0016\r\\5eCR,g)Y5mkJ,Gc\u0002@\u0005\u001c\u0011uA\u0011\u0006\u0005\b\u0005K$\u0006\u0019\u0001Bt\u0011\u001d\u0019\u0019\u000e\u0016a\u0001\t?\u0001D\u0001\"\t\u0005&A1\u0011qXBm\tG\u0001Baa8\u0005&\u0011aAq\u0005C\u000f\u0003\u0003\u0005\tQ!\u0001\u0004f\n\u0019q\fJ\u001a\t\u000f\u0011\u0005A\u000b1\u0001\u0002>\u0006\tb/\u001a:jMfd\u0015N\\6De\u0016\fG/\u001a3\u0015\u0007y$y\u0003C\u0004\u00052U\u0003\rA!\"\u0002\r1Lgn[%e\u0001")
public class ClusterLinkAdminManagerTest {
    private final KafkaConfig kafka$server$link$ClusterLinkAdminManagerTest$$brokerConfig;
    private final String kafka$server$link$ClusterLinkAdminManagerTest$$localClusterId;
    private String remoteClusterId;
    private String linkName;
    private final ListenerName listenerName;
    private final short createLinkVersion;
    private final Metrics kafka$server$link$ClusterLinkAdminManagerTest$$metrics;
    private final MockTime kafka$server$link$ClusterLinkAdminManagerTest$$time;
    private ClusterLinkManager kafka$server$link$ClusterLinkAdminManagerTest$$clusterLinkManager;
    private ClusterLinkAdminManager adminManager;
    private final ClusterLinkAdminClient kafka$server$link$ClusterLinkAdminManagerTest$$clusterLinkAdminClient;
    private final NetworkClient networkClient;
    private final ConfluentAdmin admin;
    private Option<String> tenantPrefix;
    private final Buffer<ClusterLinkData> kafka$server$link$ClusterLinkAdminManagerTest$$linksCreated;

    public KafkaConfig kafka$server$link$ClusterLinkAdminManagerTest$$brokerConfig() {
        return this.kafka$server$link$ClusterLinkAdminManagerTest$$brokerConfig;
    }

    public String kafka$server$link$ClusterLinkAdminManagerTest$$localClusterId() {
        return this.kafka$server$link$ClusterLinkAdminManagerTest$$localClusterId;
    }

    private String remoteClusterId() {
        return this.remoteClusterId;
    }

    private void remoteClusterId_$eq(String x$1) {
        this.remoteClusterId = x$1;
    }

    private String linkName() {
        return this.linkName;
    }

    private void linkName_$eq(String x$1) {
        this.linkName = x$1;
    }

    private ListenerName listenerName() {
        return this.listenerName;
    }

    private short createLinkVersion() {
        return this.createLinkVersion;
    }

    public Metrics kafka$server$link$ClusterLinkAdminManagerTest$$metrics() {
        return this.kafka$server$link$ClusterLinkAdminManagerTest$$metrics;
    }

    public MockTime kafka$server$link$ClusterLinkAdminManagerTest$$time() {
        return this.kafka$server$link$ClusterLinkAdminManagerTest$$time;
    }

    public ClusterLinkManager kafka$server$link$ClusterLinkAdminManagerTest$$clusterLinkManager() {
        return this.kafka$server$link$ClusterLinkAdminManagerTest$$clusterLinkManager;
    }

    private void clusterLinkManager_$eq(ClusterLinkManager x$1) {
        this.kafka$server$link$ClusterLinkAdminManagerTest$$clusterLinkManager = x$1;
    }

    private ClusterLinkAdminManager adminManager() {
        return this.adminManager;
    }

    private void adminManager_$eq(ClusterLinkAdminManager x$1) {
        this.adminManager = x$1;
    }

    public ClusterLinkAdminClient kafka$server$link$ClusterLinkAdminManagerTest$$clusterLinkAdminClient() {
        return this.kafka$server$link$ClusterLinkAdminManagerTest$$clusterLinkAdminClient;
    }

    private NetworkClient networkClient() {
        return this.networkClient;
    }

    private ConfluentAdmin admin() {
        return this.admin;
    }

    private Option<String> tenantPrefix() {
        return this.tenantPrefix;
    }

    private void tenantPrefix_$eq(Option<String> x$1) {
        this.tenantPrefix = x$1;
    }

    public Buffer<ClusterLinkData> kafka$server$link$ClusterLinkAdminManagerTest$$linksCreated() {
        return this.kafka$server$link$ClusterLinkAdminManagerTest$$linksCreated;
    }

    @BeforeEach
    public void setUp() {
        Mockito.when((Object)this.kafka$server$link$ClusterLinkAdminManagerTest$$clusterLinkAdminClient().networkClient()).thenReturn((Object)this.networkClient());
        Mockito.when((Object)this.kafka$server$link$ClusterLinkAdminManagerTest$$clusterLinkAdminClient().admin()).thenReturn((Object)this.admin());
        this.clusterLinkManager_$eq(new ClusterLinkManager(this){
            private final /* synthetic */ ClusterLinkAdminManagerTest $outer;

            public ClusterLinkAdminClient newRemoteAdmin(String linkName, ClusterLinkConfig config, ClusterLinkConnectionManager connectionManager, String clientType) {
                return this.$outer.kafka$server$link$ClusterLinkAdminManagerTest$$clusterLinkAdminClient();
            }

            public void createClusterLink(ClusterLinkData clusterLinkData, ClusterLinkConfig clusterLinkConfig, Properties persistentProps) {
                this.$outer.kafka$server$link$ClusterLinkAdminManagerTest$$linksCreated().$plus$eq((Object)clusterLinkData);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.kafka$server$link$ClusterLinkAdminManagerTest$$brokerConfig(), $outer.kafka$server$link$ClusterLinkAdminManagerTest$$localClusterId(), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, $outer.kafka$server$link$ClusterLinkAdminManagerTest$$metrics(), (Time)$outer.kafka$server$link$ClusterLinkAdminManagerTest$$time(), true, (Option)None$.MODULE$);
            }
        });
        ClusterLinkTestUtils$.MODULE$.setupClusterLinkManager((ClusterLinkFactory.LinkManager)this.kafka$server$link$ClusterLinkAdminManagerTest$$clusterLinkManager(), MetadataVersion.latest());
        this.adminManager_$eq(new ClusterLinkAdminManager(this){
            private final /* synthetic */ ClusterLinkAdminManagerTest $outer;

            public ClusterLinkAdminClient createRemoteAdmin(String linkName, ClusterLinkConfig linkConfig) {
                return this.$outer.kafka$server$link$ClusterLinkAdminManagerTest$$clusterLinkAdminClient();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.kafka$server$link$ClusterLinkAdminManagerTest$$brokerConfig(), $outer.kafka$server$link$ClusterLinkAdminManagerTest$$localClusterId(), $outer.kafka$server$link$ClusterLinkAdminManagerTest$$clusterLinkManager(), $outer.kafka$server$link$ClusterLinkAdminManagerTest$$metrics(), (Time)$outer.kafka$server$link$ClusterLinkAdminManagerTest$$time(), true);
            }
        });
    }

    @AfterEach
    public void tearDown() {
        if (this.adminManager() != null) {
            this.adminManager().shutdown();
        }
        if (this.kafka$server$link$ClusterLinkAdminManagerTest$$clusterLinkManager() != null) {
            this.kafka$server$link$ClusterLinkAdminManagerTest$$clusterLinkManager().shutdown();
            return;
        }
    }

    @Test
    public void testCreateDestinationOutboundLinkValidateLinkFalse() {
        this.enableDescribeCluster((Seq<AclOperation>)Nil$.MODULE$);
        Uuid linkId = this.createValidLink(ClusterLinkConfig.LinkMode.DESTINATION, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, false);
        this.verifyLinkCreated(linkId);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)0))).describeCluster((DescribeClusterOptions)ArgumentMatchers.any());
        this.verifyValidLinkForKraft(ClusterLinkConfig.LinkMode.DESTINATION, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, false);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)0))).describeCluster((DescribeClusterOptions)ArgumentMatchers.any());
    }

    @Test
    public void testCreateDestinationOutboundLinkValidateLinkTrue() {
        this.enableDescribeCluster((Seq<AclOperation>)Nil$.MODULE$);
        Uuid linkId = this.createValidLink(ClusterLinkConfig.LinkMode.DESTINATION, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, true);
        this.verifyLinkCreated(linkId);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeCluster((DescribeClusterOptions)ArgumentMatchers.any());
        this.verifyValidLinkForKraft(ClusterLinkConfig.LinkMode.DESTINATION, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, true);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)3))).describeCluster((DescribeClusterOptions)ArgumentMatchers.any());
    }

    @Test
    public void testCreateSourceLinkInbound() {
        NewClusterLink newLink = this.newClusterLink(ClusterLinkConfig.LinkMode.SOURCE, (ConnectionMode)ConnectionMode.Inbound$.MODULE$, (Map<String, String>)((Map)Map$.MODULE$.empty()), (Option<Uuid>)None$.MODULE$);
        this.verifyClusterLinkCreateRequestFailure(newLink, InvalidRequestException.class, "SOURCE is currently supported only with connection mode Outbound");
    }

    @Test
    public void testCreateSourceLinkOutboundValidateLinkFalse() {
        Uuid destLinkId = Uuid.randomUuid();
        this.enableListLinks((Option<Uuid>)new Some((Object)destLinkId), this.enableListLinks$default$2(), this.kafka$server$link$ClusterLinkAdminManagerTest$$localClusterId());
        this.enableDescribeCluster((Seq<AclOperation>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE, AclOperation.ALTER}));
        Uuid linkId = this.createValidLink(ClusterLinkConfig.LinkMode.SOURCE, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, false);
        Assertions.assertEquals((Object)destLinkId, (Object)linkId);
        this.verifyLinkCreated(linkId);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeCluster((DescribeClusterOptions)ArgumentMatchers.any());
        this.verifyValidLinkForKraft(ClusterLinkConfig.LinkMode.SOURCE, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, false);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)3))).describeCluster((DescribeClusterOptions)ArgumentMatchers.any());
    }

    @Test
    public void testCreateSourceOutboundLinkValidateLinkTrue() {
        Uuid destLinkId = Uuid.randomUuid();
        this.enableListLinks((Option<Uuid>)new Some((Object)destLinkId), this.enableListLinks$default$2(), this.kafka$server$link$ClusterLinkAdminManagerTest$$localClusterId());
        this.enableDescribeCluster((Seq<AclOperation>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE, AclOperation.ALTER}));
        Uuid linkId = this.createValidLink(ClusterLinkConfig.LinkMode.SOURCE, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, true);
        Assertions.assertEquals((Object)destLinkId, (Object)linkId);
        this.verifyLinkCreated(linkId);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeCluster((DescribeClusterOptions)ArgumentMatchers.any());
        this.verifyValidLinkForKraft(ClusterLinkConfig.LinkMode.SOURCE, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, true);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)3))).describeCluster((DescribeClusterOptions)ArgumentMatchers.any());
    }

    @Test
    public void testCreateSourceLinkNoClusterAlterAccess() {
        this.enableListLinks((Option<Uuid>)new Some((Object)Uuid.randomUuid()), this.enableListLinks$default$2(), this.kafka$server$link$ClusterLinkAdminManagerTest$$localClusterId());
        this.enableDescribeCluster((Seq<AclOperation>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}));
        NewClusterLink newLink = this.newClusterLink(ClusterLinkConfig.LinkMode.SOURCE, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, (Map<String, String>)((Map)Map$.MODULE$.empty()), (Option<Uuid>)None$.MODULE$);
        this.verifyClusterLinkCreateFailure(newLink, ClusterAuthorizationException.class, "Link credentials don't have ALTER access");
    }

    @Test
    public void testCreateSourceLinkNoRemoteLink() {
        this.enableListLinks((Option<Uuid>)None$.MODULE$, this.enableListLinks$default$2(), this.kafka$server$link$ClusterLinkAdminManagerTest$$localClusterId());
        this.enableDescribeCluster((Seq<AclOperation>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE, AclOperation.ALTER}));
        NewClusterLink newLink = this.newClusterLink(ClusterLinkConfig.LinkMode.SOURCE, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, (Map<String, String>)((Map)Map$.MODULE$.empty()), (Option<Uuid>)None$.MODULE$);
        this.verifyClusterLinkCreateFailure(newLink, InvalidConfigurationException.class, "destination cluster does not have a link");
    }

    @Test
    public void testCreateSourceLinkWithMismatchedClusterId() {
        this.enableDescribeCluster((Seq<AclOperation>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE, AclOperation.ALTER}));
        NewClusterLink newLink = this.newClusterLink(ClusterLinkConfig.LinkMode.SOURCE, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, (Map<String, String>)((Map)Map$.MODULE$.empty()), (Option<Uuid>)None$.MODULE$);
        Some x$1 = new Some((Object)Uuid.randomUuid());
        String x$3 = this.enableListLinks$default$2();
        this.enableListLinks((Option<Uuid>)x$1, x$3, "other.cluster.id");
        this.verifyClusterLinkCreateFailure(newLink, InvalidRequestException.class, "Source cluster id 'local.cluster.id' does not match the cluster id 'other.cluster.id' of the destination link.");
        this.enableListLinks((Option<Uuid>)new Some((Object)Uuid.randomUuid()), "other.cluster.id", this.kafka$server$link$ClusterLinkAdminManagerTest$$localClusterId());
        this.verifyClusterLinkCreateFailure(newLink, InvalidRequestException.class, "Cluster id 'remote.cluster.id' configured on the source link does not match the destination cluster id 'other.cluster.id'");
        this.enableListLinks((Option<Uuid>)new Some((Object)Uuid.randomUuid()), null, this.kafka$server$link$ClusterLinkAdminManagerTest$$localClusterId());
        this.verifyClusterLinkCreateFailure(newLink, InvalidRequestException.class, "Destination cluster id could not be determined for the cluster link");
    }

    @Test
    public void testCreateBidirectionalLinkOutboundValidateLinkFalse() {
        this.enableDescribeLinks((Option<Uuid>)None$.MODULE$, this.enableDescribeLinks$default$2(), this.kafka$server$link$ClusterLinkAdminManagerTest$$localClusterId(), ClusterLinkDescription.LinkMode.BIDIRECTIONAL, ClusterLinkDescription.ConnectionMode.OUTBOUND, ClusterLinkDescription.LinkState.ACTIVE);
        this.enableDescribeCluster((Seq<AclOperation>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}));
        Uuid linkId = this.createValidLink(ClusterLinkConfig.LinkMode.BIDIRECTIONAL, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, false);
        this.verifyLinkCreated(linkId);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeCluster((DescribeClusterOptions)ArgumentMatchers.any());
        this.verifyValidLinkForKraft(ClusterLinkConfig.LinkMode.BIDIRECTIONAL, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, false);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)3))).describeCluster((DescribeClusterOptions)ArgumentMatchers.any());
    }

    @Test
    public void testCreateBidirectionalLinkOutboundValidateLinkTrue() {
        this.enableDescribeLinks((Option<Uuid>)None$.MODULE$, this.enableDescribeLinks$default$2(), this.kafka$server$link$ClusterLinkAdminManagerTest$$localClusterId(), ClusterLinkDescription.LinkMode.BIDIRECTIONAL, ClusterLinkDescription.ConnectionMode.OUTBOUND, ClusterLinkDescription.LinkState.ACTIVE);
        this.enableDescribeCluster((Seq<AclOperation>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}));
        Uuid linkId = this.createValidLink(ClusterLinkConfig.LinkMode.BIDIRECTIONAL, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, true);
        this.verifyLinkCreated(linkId);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeCluster((DescribeClusterOptions)ArgumentMatchers.any());
        this.verifyValidLinkForKraft(ClusterLinkConfig.LinkMode.BIDIRECTIONAL, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, true);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)3))).describeCluster((DescribeClusterOptions)ArgumentMatchers.any());
    }

    @Test
    public void testCreateBidirectionalLinkInboundValidateLinkFalse() {
        this.enableDescribeCluster((Seq<AclOperation>)Nil$.MODULE$);
        Uuid linkId = this.createValidLink(ClusterLinkConfig.LinkMode.BIDIRECTIONAL, (ConnectionMode)ConnectionMode.Inbound$.MODULE$, false);
        this.verifyLinkCreated(linkId);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)0))).describeCluster((DescribeClusterOptions)ArgumentMatchers.any());
        this.verifyValidLinkForKraft(ClusterLinkConfig.LinkMode.BIDIRECTIONAL, (ConnectionMode)ConnectionMode.Inbound$.MODULE$, false);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)0))).describeCluster((DescribeClusterOptions)ArgumentMatchers.any());
    }

    @Test
    public void testCreateBidirectionalLinkInboundValidateLinkTrue() {
        this.enableDescribeCluster((Seq<AclOperation>)Nil$.MODULE$);
        Uuid linkId = this.createValidLink(ClusterLinkConfig.LinkMode.BIDIRECTIONAL, (ConnectionMode)ConnectionMode.Inbound$.MODULE$, true);
        this.verifyLinkCreated(linkId);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)0))).describeCluster((DescribeClusterOptions)ArgumentMatchers.any());
        this.verifyValidLinkForKraft(ClusterLinkConfig.LinkMode.BIDIRECTIONAL, (ConnectionMode)ConnectionMode.Inbound$.MODULE$, true);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)0))).describeCluster((DescribeClusterOptions)ArgumentMatchers.any());
    }

    @Test
    public void testCreateBidirectionalLinkOutboundWithOutboundRemote() {
        Uuid remoteLinkId = Uuid.randomUuid();
        Some x$1 = new Some((Object)remoteLinkId);
        String x$3 = this.enableDescribeLinks$default$2();
        String x$4 = this.kafka$server$link$ClusterLinkAdminManagerTest$$localClusterId();
        ClusterLinkDescription.LinkMode x$5 = ClusterLinkDescription.LinkMode.BIDIRECTIONAL;
        ClusterLinkDescription.LinkState x$6 = ClusterLinkDescription.LinkState.ACTIVE;
        this.enableDescribeLinks((Option<Uuid>)x$1, x$3, x$4, x$5, ClusterLinkDescription.ConnectionMode.OUTBOUND, x$6);
        this.enableDescribeCluster((Seq<AclOperation>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}));
        Uuid linkId = this.createValidLink(ClusterLinkConfig.LinkMode.BIDIRECTIONAL, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, true);
        Assertions.assertEquals((Object)remoteLinkId, (Object)linkId);
        this.verifyLinkCreated(linkId);
        this.verifyValidLinkForKraft(ClusterLinkConfig.LinkMode.BIDIRECTIONAL, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, true);
    }

    @Test
    public void testCreateBidirectionalLinkOutboundWithInboundRemote() {
        Uuid remoteLinkId = Uuid.randomUuid();
        Some x$1 = new Some((Object)remoteLinkId);
        String x$3 = this.enableDescribeLinks$default$2();
        String x$4 = this.kafka$server$link$ClusterLinkAdminManagerTest$$localClusterId();
        ClusterLinkDescription.LinkMode x$5 = ClusterLinkDescription.LinkMode.BIDIRECTIONAL;
        ClusterLinkDescription.LinkState x$6 = ClusterLinkDescription.LinkState.ACTIVE;
        this.enableDescribeLinks((Option<Uuid>)x$1, x$3, x$4, x$5, ClusterLinkDescription.ConnectionMode.INBOUND, x$6);
        this.enableDescribeCluster((Seq<AclOperation>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE, AclOperation.ALTER}));
        Uuid linkId = this.createValidLink(ClusterLinkConfig.LinkMode.BIDIRECTIONAL, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, true);
        Assertions.assertEquals((Object)remoteLinkId, (Object)linkId);
        this.verifyLinkCreated(linkId);
        this.verifyValidLinkForKraft(ClusterLinkConfig.LinkMode.BIDIRECTIONAL, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, true);
    }

    @Test
    public void testCreateBidirectionalLinkWithLinkIdSpecified() {
        Uuid remoteLinkId = Uuid.randomUuid();
        this.enableDescribeCluster((Seq<AclOperation>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}));
        Some x$1 = new Some((Object)remoteLinkId);
        String x$3 = this.enableDescribeLinks$default$2();
        String x$4 = this.kafka$server$link$ClusterLinkAdminManagerTest$$localClusterId();
        ClusterLinkDescription.LinkMode x$5 = ClusterLinkDescription.LinkMode.BIDIRECTIONAL;
        ClusterLinkDescription.LinkState x$6 = ClusterLinkDescription.LinkState.ACTIVE;
        this.enableDescribeLinks((Option<Uuid>)x$1, x$3, x$4, x$5, ClusterLinkDescription.ConnectionMode.OUTBOUND, x$6);
        ConnectionMode.Outbound$ x$8 = ConnectionMode.Outbound$.MODULE$;
        Some x$9 = new Some((Object)remoteLinkId);
        Map x$10 = (Map)Map$.MODULE$.empty();
        NewClusterLink newLink = this.newClusterLink(ClusterLinkConfig.LinkMode.BIDIRECTIONAL, (ConnectionMode)x$8, (Map<String, String>)x$10, (Option<Uuid>)x$9);
        Uuid linkId = this.createClusterLink(newLink, false, true).get(10L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)remoteLinkId, (Object)linkId);
        this.verifyLinkCreated(linkId);
        this.verifyValidLinkForKraft(ClusterLinkConfig.LinkMode.BIDIRECTIONAL, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, true);
    }

    @Test
    public void testCreateBidirectionalLinkUnmanagedSourceIgnored() {
        Uuid remoteLinkId = Uuid.randomUuid();
        this.enableDescribeCluster((Seq<AclOperation>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}));
        Some x$1 = new Some((Object)remoteLinkId);
        String x$5 = this.enableDescribeLinks$default$2();
        String x$6 = this.kafka$server$link$ClusterLinkAdminManagerTest$$localClusterId();
        this.enableDescribeLinks((Option<Uuid>)x$1, x$5, x$6, ClusterLinkDescription.LinkMode.SOURCE, ClusterLinkDescription.ConnectionMode.INBOUND, ClusterLinkDescription.LinkState.UNMANAGED_SOURCE);
        NewClusterLink newLink = this.newClusterLink(ClusterLinkConfig.LinkMode.BIDIRECTIONAL, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, (Map<String, String>)((Map)Map$.MODULE$.empty()), (Option<Uuid>)None$.MODULE$);
        Uuid linkId = this.createClusterLink(newLink, false, true).get(10L, TimeUnit.SECONDS);
        Assertions.assertNotEquals((Object)remoteLinkId, (Object)linkId);
        this.verifyLinkCreated(linkId);
        this.verifyValidLinkForKraft(ClusterLinkConfig.LinkMode.BIDIRECTIONAL, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, true);
    }

    @Test
    public void testCreateBidirectionalLinkWithNonExistentLinkIdSpecified() {
        Uuid remoteLinkId = Uuid.randomUuid();
        this.enableDescribeCluster((Seq<AclOperation>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}));
        this.enableDescribeLinks((Option<Uuid>)None$.MODULE$, this.enableDescribeLinks$default$2(), this.kafka$server$link$ClusterLinkAdminManagerTest$$localClusterId(), ClusterLinkDescription.LinkMode.BIDIRECTIONAL, ClusterLinkDescription.ConnectionMode.OUTBOUND, ClusterLinkDescription.LinkState.ACTIVE);
        ConnectionMode.Outbound$ x$2 = ConnectionMode.Outbound$.MODULE$;
        Some x$3 = new Some((Object)remoteLinkId);
        Map x$4 = (Map)Map$.MODULE$.empty();
        NewClusterLink newLink = this.newClusterLink(ClusterLinkConfig.LinkMode.BIDIRECTIONAL, (ConnectionMode)x$2, (Map<String, String>)x$4, (Option<Uuid>)x$3);
        this.verifyClusterLinkCreateFailure(newLink, InvalidConfigurationException.class, "remote cluster does not have a link");
    }

    @Test
    public void testCreateBidirectionalLinkWithMismatchedLinkIdSpecified() {
        Uuid remoteLinkId = Uuid.randomUuid();
        this.enableDescribeCluster((Seq<AclOperation>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}));
        this.enableDescribeLinks((Option<Uuid>)new Some((Object)Uuid.randomUuid()), this.enableDescribeLinks$default$2(), this.kafka$server$link$ClusterLinkAdminManagerTest$$localClusterId(), ClusterLinkDescription.LinkMode.BIDIRECTIONAL, ClusterLinkDescription.ConnectionMode.OUTBOUND, ClusterLinkDescription.LinkState.ACTIVE);
        ConnectionMode.Outbound$ x$2 = ConnectionMode.Outbound$.MODULE$;
        Some x$3 = new Some((Object)remoteLinkId);
        Map x$4 = (Map)Map$.MODULE$.empty();
        NewClusterLink newLink = this.newClusterLink(ClusterLinkConfig.LinkMode.BIDIRECTIONAL, (ConnectionMode)x$2, (Map<String, String>)x$4, (Option<Uuid>)x$3);
        this.verifyClusterLinkCreateFailure(newLink, InvalidConfigurationException.class, "does not match requested link id");
    }

    @Test
    public void testCreateBidirectionalLinkWithMismatchedClusterId() {
        Uuid remoteLinkId = Uuid.randomUuid();
        this.enableDescribeCluster((Seq<AclOperation>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}));
        ConnectionMode.Outbound$ x$2 = ConnectionMode.Outbound$.MODULE$;
        Some x$3 = new Some((Object)remoteLinkId);
        Map x$4 = (Map)Map$.MODULE$.empty();
        NewClusterLink newLink = this.newClusterLink(ClusterLinkConfig.LinkMode.BIDIRECTIONAL, (ConnectionMode)x$2, (Map<String, String>)x$4, (Option<Uuid>)x$3);
        Some x$5 = new Some((Object)remoteLinkId);
        String x$7 = this.enableDescribeLinks$default$2();
        ClusterLinkDescription.LinkMode x$8 = ClusterLinkDescription.LinkMode.BIDIRECTIONAL;
        ClusterLinkDescription.ConnectionMode x$9 = ClusterLinkDescription.ConnectionMode.OUTBOUND;
        ClusterLinkDescription.LinkState x$10 = ClusterLinkDescription.LinkState.ACTIVE;
        this.enableDescribeLinks((Option<Uuid>)x$5, x$7, "other.cluster.id", x$8, x$9, x$10);
        this.verifyClusterLinkCreateFailure(newLink, InvalidRequestException.class, "Local cluster id 'local.cluster.id' does not match the cluster id 'other.cluster.id' of the remote link");
        this.enableDescribeLinks((Option<Uuid>)new Some((Object)remoteLinkId), "other.cluster.id", this.kafka$server$link$ClusterLinkAdminManagerTest$$localClusterId(), ClusterLinkDescription.LinkMode.BIDIRECTIONAL, ClusterLinkDescription.ConnectionMode.OUTBOUND, ClusterLinkDescription.LinkState.ACTIVE);
        this.verifyClusterLinkCreateFailure(newLink, InvalidRequestException.class, "Cluster id 'remote.cluster.id' configured on the local link does not match the local cluster id 'other.cluster.id' of the remote link");
        this.enableDescribeLinks((Option<Uuid>)new Some((Object)remoteLinkId), null, this.kafka$server$link$ClusterLinkAdminManagerTest$$localClusterId(), ClusterLinkDescription.LinkMode.BIDIRECTIONAL, ClusterLinkDescription.ConnectionMode.OUTBOUND, ClusterLinkDescription.LinkState.ACTIVE);
        this.verifyClusterLinkCreateFailure(newLink, InvalidRequestException.class, "Local cluster id could not be determined for the remote cluster link");
    }

    @Test
    public void testCreateBidirectionalLinkToNonBidirectionalRemote() {
        Uuid remoteLinkId = Uuid.randomUuid();
        this.enableDescribeCluster((Seq<AclOperation>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE, AclOperation.ALTER}));
        Some x$1 = new Some((Object)remoteLinkId);
        String x$3 = this.enableDescribeLinks$default$2();
        String x$4 = this.kafka$server$link$ClusterLinkAdminManagerTest$$localClusterId();
        ClusterLinkDescription.ConnectionMode x$5 = ClusterLinkDescription.ConnectionMode.OUTBOUND;
        ClusterLinkDescription.LinkState x$6 = ClusterLinkDescription.LinkState.ACTIVE;
        this.enableDescribeLinks((Option<Uuid>)x$1, x$3, x$4, ClusterLinkDescription.LinkMode.DESTINATION, x$5, x$6);
        ConnectionMode.Outbound$ x$8 = ConnectionMode.Outbound$.MODULE$;
        Some x$9 = new Some((Object)remoteLinkId);
        Map x$10 = (Map)Map$.MODULE$.empty();
        NewClusterLink newLink = this.newClusterLink(ClusterLinkConfig.LinkMode.BIDIRECTIONAL, (ConnectionMode)x$8, (Map<String, String>)x$10, (Option<Uuid>)x$9);
        this.verifyClusterLinkCreateFailure(newLink, InvalidConfigurationException.class, "remote link with link mode DESTINATION is not bi-directional");
        Some x$11 = new Some((Object)remoteLinkId);
        String x$13 = this.enableDescribeLinks$default$2();
        String x$14 = this.kafka$server$link$ClusterLinkAdminManagerTest$$localClusterId();
        ClusterLinkDescription.ConnectionMode x$15 = ClusterLinkDescription.ConnectionMode.OUTBOUND;
        ClusterLinkDescription.LinkState x$16 = ClusterLinkDescription.LinkState.ACTIVE;
        this.enableDescribeLinks((Option<Uuid>)x$11, x$13, x$14, ClusterLinkDescription.LinkMode.SOURCE, x$15, x$16);
        this.verifyClusterLinkCreateFailure(newLink, InvalidConfigurationException.class, "remote link with link mode SOURCE is not bi-directional");
    }

    @Test
    public void testCreateBidirectionalLinkNoClusterAlterAccess() {
        Uuid remoteLinkId = Uuid.randomUuid();
        this.enableDescribeCluster((Seq<AclOperation>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}));
        Some x$1 = new Some((Object)remoteLinkId);
        String x$3 = this.enableDescribeLinks$default$2();
        String x$4 = this.kafka$server$link$ClusterLinkAdminManagerTest$$localClusterId();
        ClusterLinkDescription.LinkMode x$5 = ClusterLinkDescription.LinkMode.BIDIRECTIONAL;
        ClusterLinkDescription.LinkState x$6 = ClusterLinkDescription.LinkState.ACTIVE;
        this.enableDescribeLinks((Option<Uuid>)x$1, x$3, x$4, x$5, ClusterLinkDescription.ConnectionMode.INBOUND, x$6);
        NewClusterLink newLink = this.newClusterLink(ClusterLinkConfig.LinkMode.BIDIRECTIONAL, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, (Map<String, String>)((Map)Map$.MODULE$.empty()), (Option<Uuid>)None$.MODULE$);
        this.verifyClusterLinkCreateFailure(newLink, ClusterAuthorizationException.class, "Link credentials don't have ALTER access");
        Some x$7 = new Some((Object)remoteLinkId);
        String x$9 = this.enableDescribeLinks$default$2();
        String x$10 = this.kafka$server$link$ClusterLinkAdminManagerTest$$localClusterId();
        ClusterLinkDescription.LinkMode x$11 = ClusterLinkDescription.LinkMode.BIDIRECTIONAL;
        ClusterLinkDescription.LinkState x$12 = ClusterLinkDescription.LinkState.ACTIVE;
        this.enableDescribeLinks((Option<Uuid>)x$7, x$9, x$10, x$11, ClusterLinkDescription.ConnectionMode.OUTBOUND, x$12);
        Uuid linkId = this.createValidLink(ClusterLinkConfig.LinkMode.BIDIRECTIONAL, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, true);
        Assertions.assertEquals((Object)remoteLinkId, (Object)linkId);
        this.verifyLinkCreated(linkId);
        this.verifyValidLinkForKraft(ClusterLinkConfig.LinkMode.BIDIRECTIONAL, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, true);
    }

    @Test
    public void testCreateLinkWithTenantPrefix() {
        this.tenantPrefix_$eq((Option<String>)new Some((Object)"prefix_"));
        this.linkName_$eq(new StringBuilder(7).append("prefix_").append(this.linkName()).toString());
        this.enableDescribeCluster((Seq<AclOperation>)Nil$.MODULE$);
        Uuid linkId = this.createValidLink(ClusterLinkConfig.LinkMode.DESTINATION, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, false);
        this.verifyLinkCreated(linkId);
        this.verifyValidLinkForKraft(ClusterLinkConfig.LinkMode.DESTINATION, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, false);
    }

    @Test
    public void testCreateCircularLink() {
        this.remoteClusterId_$eq(this.kafka$server$link$ClusterLinkAdminManagerTest$$localClusterId());
        NewClusterLink newLink = this.newClusterLink(ClusterLinkConfig.LinkMode.DESTINATION, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, (Map<String, String>)((Map)Map$.MODULE$.empty()), (Option<Uuid>)None$.MODULE$);
        this.verifyClusterLinkCreateRequestFailure(newLink, InvalidRequestException.class, "cannot create cluster link to self");
    }

    private Uuid createValidLink(ClusterLinkConfig.LinkMode linkMode, ConnectionMode connectionMode, boolean validateLink) {
        NewClusterLink newLink = this.newClusterLink(linkMode, connectionMode, (Map<String, String>)((Map)Map$.MODULE$.empty()), (Option<Uuid>)None$.MODULE$);
        Assertions.assertNotNull((Object)this.createClusterLink(newLink, true, validateLink).get(10L, TimeUnit.SECONDS));
        Assertions.assertEquals((Object)Seq$.MODULE$.empty(), (Object)this.kafka$server$link$ClusterLinkAdminManagerTest$$linksCreated().toSeq());
        Uuid linkId = this.createClusterLink(newLink, false, validateLink).get(10L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)linkId);
        return linkId;
    }

    private CompletableFuture<Uuid> createClusterLink(NewClusterLink newLink, boolean validateOnly, boolean validateLink) {
        return this.adminManager().createClusterLink(newLink, this.tenantPrefix(), this.listenerName(), validateOnly, validateLink, 1000, (int)this.createLinkVersion());
    }

    private void verifyValidLinkForKraft(ClusterLinkConfig.LinkMode linkMode, ConnectionMode connectionMode, boolean validateLink) {
        Map x$42 = (Map)Map$.MODULE$.empty();
        None$ x$5 = None$.MODULE$;
        CreateClusterLinksRequest createRequest = this.newClusterLinkRequest(linkMode, connectionMode, (Map<String, String>)x$42, (Option<Uuid>)x$5, validateLink);
        ((CompletableFuture)this.adminManager().validateLinksWithCreateClusterLinkRequestForKraft(createRequest, this.tenantPrefix(), this.listenerName(), (Function2 & Serializable)(x$3, x$4) -> {
            ClusterLinkAdminManagerTest.$anonfun$verifyValidLinkForKraft$1(x$3, x$4);
            return BoxedUnit.UNIT;
        }).apply((Object)this.linkName())).get(15L, TimeUnit.SECONDS);
    }

    private NewClusterLink newClusterLink(ClusterLinkConfig.LinkMode mode, ConnectionMode connectionMode, Map<String, String> overrides, Option<Uuid> remoteLinkId) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(ClusterLinkConfig$.MODULE$.LinkModeProp(), mode.name());
        props.put(ClusterLinkConfig$.MODULE$.ConnectionModeProp(), connectionMode.name());
        overrides.foreach((Function1 & Serializable)e -> (String)props.put((String)e._1(), (String)e._2()));
        if (remoteLinkId instanceof Some) {
            Uuid id = (Uuid)((Some)remoteLinkId).value();
            return new NewClusterLink(this.linkName(), this.remoteClusterId(), props, id);
        }
        if (None$.MODULE$.equals(remoteLinkId)) {
            return new NewClusterLink(this.linkName(), this.remoteClusterId(), props);
        }
        throw new MatchError(remoteLinkId);
    }

    private Map<String, String> newClusterLink$default$3() {
        return (Map)Map$.MODULE$.empty();
    }

    private Option<Uuid> newClusterLink$default$4() {
        return None$.MODULE$;
    }

    private CreateClusterLinksRequest newClusterLinkRequest(ClusterLinkConfig.LinkMode mode, ConnectionMode connectionMode, Map<String, String> overrides, Option<Uuid> remoteLinkId, boolean validateLink) {
        NewClusterLink link = this.newClusterLink(mode, connectionMode, overrides, remoteLinkId);
        return this.newLinkToRequest(link, validateLink);
    }

    private Map<String, String> newClusterLinkRequest$default$3() {
        return (Map)Map$.MODULE$.empty();
    }

    private Option<Uuid> newClusterLinkRequest$default$4() {
        return None$.MODULE$;
    }

    private CreateClusterLinksRequest newLinkToRequest(NewClusterLink link, boolean validateLink) {
        ArrayList configData = new ArrayList();
        link.configs().forEach((k, v) -> configData.add(new CreateClusterLinksRequestData.ConfigData().setKey(k).setValue(v)));
        CreateClusterLinksRequestData.EntryData entry = new CreateClusterLinksRequestData.EntryData().setConfigs(configData).setLinkName(link.linkName()).setLinkId(link.linkId()).setClusterId(link.clusterId());
        CreateClusterLinksRequestData data = new CreateClusterLinksRequestData().setEntries(Collections.singletonList(entry)).setValidateOnly(true).setValidateLink(validateLink);
        return (CreateClusterLinksRequest)new CreateClusterLinksRequest.Builder(data).build();
    }

    private void enableDescribeCluster(Seq<AclOperation> acls) {
        HashSet aclSet = new HashSet();
        acls.foreach((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)aclSet.add(x$1)));
        DescribeClusterResult describeResult = (DescribeClusterResult)Mockito.mock(DescribeClusterResult.class);
        Mockito.when((Object)describeResult.clusterId()).thenReturn((Object)KafkaFuture.completedFuture((Object)this.remoteClusterId()));
        Mockito.when((Object)describeResult.authorizedOperations()).thenReturn((Object)KafkaFuture.completedFuture(aclSet));
        Mockito.when((Object)this.admin().describeCluster((DescribeClusterOptions)ArgumentMatchers.any())).thenReturn((Object)describeResult);
    }

    private void enableListLinks(Option<Uuid> remoteLinkId, String localClusterId, String remoteClusterId) {
        ListClusterLinksResult listResult = (ListClusterLinksResult)Mockito.mock(ListClusterLinksResult.class);
        HashSet links = new HashSet();
        remoteLinkId.foreach((Function1 & Serializable)linkId -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkAdminManagerTest.$anonfun$enableListLinks$1(this, remoteClusterId, localClusterId, links, linkId)));
        Mockito.when((Object)listResult.result()).thenReturn((Object)KafkaFuture.completedFuture(links));
        Mockito.when((Object)this.admin().listClusterLinks((ListClusterLinksOptions)ArgumentMatchers.any())).thenReturn((Object)listResult);
    }

    private String enableListLinks$default$2() {
        return this.remoteClusterId();
    }

    private String enableListLinks$default$3() {
        return this.kafka$server$link$ClusterLinkAdminManagerTest$$localClusterId();
    }

    private void enableDescribeLinks(Option<Uuid> remoteLinkId, String localClusterId, String remoteClusterId, ClusterLinkDescription.LinkMode remoteLinkMode, ClusterLinkDescription.ConnectionMode remoteConnectionMode, ClusterLinkDescription.LinkState remoteLinkState) {
        DescribeClusterLinksResult describeResult = (DescribeClusterLinksResult)Mockito.mock(DescribeClusterLinksResult.class);
        HashSet links = new HashSet();
        remoteLinkId.foreach((Function1 & Serializable)linkId -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkAdminManagerTest.$anonfun$enableDescribeLinks$1(this, remoteClusterId, localClusterId, remoteLinkState, remoteLinkMode, remoteConnectionMode, links, linkId)));
        Mockito.when((Object)describeResult.result()).thenReturn((Object)KafkaFuture.completedFuture(links));
        Mockito.when((Object)this.admin().describeClusterLinks((DescribeClusterLinksOptions)ArgumentMatchers.any())).thenReturn((Object)describeResult);
    }

    private String enableDescribeLinks$default$2() {
        return this.remoteClusterId();
    }

    private String enableDescribeLinks$default$3() {
        return this.kafka$server$link$ClusterLinkAdminManagerTest$$localClusterId();
    }

    private ClusterLinkDescription.LinkMode enableDescribeLinks$default$4() {
        return ClusterLinkDescription.LinkMode.BIDIRECTIONAL;
    }

    private ClusterLinkDescription.ConnectionMode enableDescribeLinks$default$5() {
        return ClusterLinkDescription.ConnectionMode.OUTBOUND;
    }

    private ClusterLinkDescription.LinkState enableDescribeLinks$default$6() {
        return ClusterLinkDescription.LinkState.ACTIVE;
    }

    private void verifyClusterLinkCreateFailure(NewClusterLink newLink, Class<? extends Throwable> exceptionClass, String message) {
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> this.createClusterLink(newLink, true, true).get(15L, TimeUnit.SECONDS));
        Assertions.assertEquals(exceptionClass, e.getCause().getClass());
        Assertions.assertTrue((boolean)e.getMessage().contains(message), (String)new StringBuilder(20).append("Unexpected message: ").append(e.getMessage()).toString());
        this.verifyKRaftClusterLinkValidateFailure(newLink, exceptionClass, message);
    }

    private void verifyClusterLinkCreateRequestFailure(NewClusterLink newLink, Class<? extends Throwable> exceptionClass, String message) {
        Throwable e = Assertions.assertThrows(exceptionClass, () -> this.createClusterLink(newLink, true, true).get(15L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)e.getMessage().contains(message), (String)new StringBuilder(20).append("Unexpected message: ").append(e.getMessage()).toString());
        this.verifyKRaftClusterLinkValidateFailure(newLink, exceptionClass, message);
    }

    private void verifyKRaftClusterLinkValidateFailure(NewClusterLink newLink, Class<? extends Throwable> exceptionClass, String message) {
        CreateClusterLinksRequest createRequest = this.newLinkToRequest(newLink, true);
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((CompletableFuture)this.adminManager().validateLinksWithCreateClusterLinkRequestForKraft(createRequest, this.tenantPrefix(), this.listenerName(), (Function2 & Serializable)(x$5, x$6) -> {
            ClusterLinkAdminManagerTest.$anonfun$verifyKRaftClusterLinkValidateFailure$2(x$5, x$6);
            return BoxedUnit.UNIT;
        }).apply((Object)this.linkName())).get(15L, TimeUnit.SECONDS));
        Assertions.assertEquals(exceptionClass, e.getCause().getClass());
        Assertions.assertTrue((boolean)e.getMessage().contains(message), (String)new StringBuilder(20).append("Unexpected message: ").append(e.getMessage()).toString());
    }

    private void verifyLinkCreated(Uuid linkId) {
        Assertions.assertEquals((Object)new .colon.colon((Object)new ClusterLinkData(this.linkName(), linkId, (Option)new Some((Object)this.remoteClusterId()), this.tenantPrefix(), false), (List)Nil$.MODULE$), (Object)this.kafka$server$link$ClusterLinkAdminManagerTest$$linksCreated().toSeq());
    }

    public static final /* synthetic */ void $anonfun$verifyValidLinkForKraft$1(ConfigResource x$3, Map x$4) {
    }

    public static final /* synthetic */ boolean $anonfun$enableListLinks$1(ClusterLinkAdminManagerTest $this, String remoteClusterId$1, String localClusterId$1, HashSet links$1, Uuid linkId) {
        ClusterLinkListing link = new ClusterLinkListing($this.linkName(), linkId, remoteClusterId$1, localClusterId$1, Optional.empty(), true, ClusterLinkError.NO_ERROR, null, ClusterLinkDescription.LinkState.ACTIVE);
        return links$1.add(link);
    }

    public static final /* synthetic */ boolean $anonfun$enableDescribeLinks$1(ClusterLinkAdminManagerTest $this, String remoteClusterId$2, String localClusterId$2, ClusterLinkDescription.LinkState remoteLinkState$1, ClusterLinkDescription.LinkMode remoteLinkMode$1, ClusterLinkDescription.ConnectionMode remoteConnectionMode$1, HashSet links$2, Uuid linkId) {
        ClusterLinkDescription link = new ClusterLinkDescription($this.linkName(), linkId, remoteClusterId$2, localClusterId$2, Collections.emptySet(), remoteLinkState$1, remoteLinkMode$1, remoteConnectionMode$1, ClusterLinkError.NO_ERROR, null, Node.noNode());
        return links$2.add(link);
    }

    public static final /* synthetic */ void $anonfun$verifyKRaftClusterLinkValidateFailure$2(ConfigResource x$5, Map x$6) {
    }

    /*
     * WARNING - void declaration
     */
    public ClusterLinkAdminManagerTest() {
        void apply_doLog;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var22_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var23_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var24_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        boolean bl = true;
        Properties apply_props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        Object var20_24 = null;
        this.kafka$server$link$ClusterLinkAdminManagerTest$$brokerConfig = new KafkaConfig((java.util.Map)apply_props, (boolean)apply_doLog);
        this.kafka$server$link$ClusterLinkAdminManagerTest$$localClusterId = "local.cluster.id";
        this.remoteClusterId = "remote.cluster.id";
        this.linkName = "testLink";
        this.listenerName = ((EndPoint)this.kafka$server$link$ClusterLinkAdminManagerTest$$brokerConfig().listeners().head()).listenerName();
        this.createLinkVersion = ApiKeys.CREATE_CLUSTER_LINKS.latestVersion();
        this.kafka$server$link$ClusterLinkAdminManagerTest$$metrics = new Metrics();
        this.kafka$server$link$ClusterLinkAdminManagerTest$$time = new MockTime();
        this.kafka$server$link$ClusterLinkAdminManagerTest$$clusterLinkAdminClient = (ClusterLinkAdminClient)Mockito.mock(ClusterLinkAdminClient.class);
        this.networkClient = (NetworkClient)Mockito.mock(NetworkClient.class);
        this.admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        this.tenantPrefix = None$.MODULE$;
        this.kafka$server$link$ClusterLinkAdminManagerTest$$linksCreated = (Buffer)Buffer$.MODULE$.empty();
    }
}

