/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.File;
import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkScheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.TestInstance;
import org.mockito.Mockito;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@ScalaSignature(bytes="\u0006\u0005\u0005md\u0001B\f\u0019\u0001}AQA\n\u0001\u0005\u0002\u001dBqA\u000b\u0001C\u0002\u0013E1\u0006\u0003\u00041\u0001\u0001\u0006I\u0001\f\u0005\bc\u0001\u0011\r\u0011\"\u00053\u0011\u00191\u0004\u0001)A\u0005g!Iq\u0007\u0001a\u0001\u0002\u0004%\t\u0002\u000f\u0005\ny\u0001\u0001\r\u00111A\u0005\u0012uB\u0011b\u0011\u0001A\u0002\u0003\u0005\u000b\u0015B\u001d\t\u000f\u0011\u0003!\u0019!C\t\u000b\"11\u000b\u0001Q\u0001\n\u0019Cq\u0001\u0016\u0001A\u0002\u0013EQ\u000bC\u0004Z\u0001\u0001\u0007I\u0011\u0003.\t\rq\u0003\u0001\u0015)\u0003W\r\u0011i\u0006\u0001\u00010\t\u0011\tt!\u0011!Q\u0001\n\rDaA\n\b\u0005\u0002\u0005\u001d\u0001bBA\b\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003S\u0001A\u0011AA\t\u0011\u001d\t\u0019\u0004\u0001C\u0005\u0003kAq!a\u000e\u0001\t#\tI\u0004C\u0004\u0002B\u0001!\t\"!\u0005\t\u000f\u0005\r\u0003\u0001\"\u0005\u0002F\t1\u0013IY:ue\u0006\u001cGo\u00117vgR,'\u000fT5oW6+G/\u00193bi\u0006l\u0015M\\1hKJ$Vm\u001d;\u000b\u0005eQ\u0012\u0001\u00027j].T!a\u0007\u000f\u0002\rM,'O^3s\u0015\u0005i\u0012!B6bM.\f7\u0001A\n\u0003\u0001\u0001\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001)!\tI\u0003!D\u0001\u0019\u00031\u0011'o\\6fe\u000e{gNZ5h+\u0005a\u0003CA\u0017/\u001b\u0005Q\u0012BA\u0018\u001b\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u001b\t\u0014xn[3s\u0007>tg-[4!\u0003I\u0019G.^:uKJd\u0015N\\6NC:\fw-\u001a:\u0016\u0003M\u0002\"!\u000b\u001b\n\u0005UB\"AE\"mkN$XM\u001d'j].l\u0015M\\1hKJ\f1c\u00197vgR,'\u000fT5oW6\u000bg.Y4fe\u0002\nq\"\\3uC\u0012\fG/Y'b]\u0006<WM]\u000b\u0002sA\u0011\u0011FO\u0005\u0003wa\u0011!d\u00117vgR,'\u000fT5oW6+G/\u00193bi\u0006l\u0015M\\1hKJ\f1#\\3uC\u0012\fG/Y'b]\u0006<WM]0%KF$\"AP!\u0011\u0005\u0005z\u0014B\u0001!#\u0005\u0011)f.\u001b;\t\u000f\t;\u0011\u0011!a\u0001s\u0005\u0019\u0001\u0010J\u0019\u0002!5,G/\u00193bi\u0006l\u0015M\\1hKJ\u0004\u0013!\u00033fgR\fE-\\5o+\u00051\u0005CA$R\u001b\u0005A%BA%K\u0003\u0015\tG-\\5o\u0015\tYE*A\u0004dY&,g\u000e^:\u000b\u0005ui%B\u0001(P\u0003\u0019\t\u0007/Y2iK*\t\u0001+A\u0002pe\u001eL!A\u0015%\u0003\u000b\u0005#W.\u001b8\u0002\u0015\u0011,7\u000f^!e[&t\u0007%A\u0005tG\",G-\u001e7feV\ta\u000b\u0005\u0002*/&\u0011\u0001\f\u0007\u0002\u0015\u00072,8\u000f^3s\u0019&t7nU2iK\u0012,H.\u001a:\u0002\u001bM\u001c\u0007.\u001a3vY\u0016\u0014x\fJ3r)\tq4\fC\u0004C\u0019\u0005\u0005\t\u0019\u0001,\u0002\u0015M\u001c\u0007.\u001a3vY\u0016\u0014\bE\u0001\fN_\u000e\\7I]3bi\u0016$v\u000e]5dgJ+7/\u001e7u'\tqq\f\u0005\u0002HA&\u0011\u0011\r\u0013\u0002\u0013\u0007J,\u0017\r^3U_BL7m\u001d*fgVdG/A\u0004gkR,(/Z:\u0011\t\u0011L7N^\u0007\u0002K*\u0011amZ\u0001\u0005kRLGNC\u0001i\u0003\u0011Q\u0017M^1\n\u0005),'aA'baB\u0011An\u001d\b\u0003[F\u0004\"A\u001c\u0012\u000e\u0003=T!\u0001\u001d\u0010\u0002\rq\u0012xn\u001c;?\u0013\t\u0011(%\u0001\u0004Qe\u0016$WMZ\u0005\u0003iV\u0014aa\u0015;sS:<'B\u0001:#!\r9(\u0010`\u0007\u0002q*\u0011\u0011\u0010T\u0001\u0007G>lWn\u001c8\n\u0005mD(aC&bM.\fg)\u001e;ve\u0016\u00042!`A\u0001\u001d\t9e0\u0003\u0002\u0000\u0011\u0006\u00112I]3bi\u0016$v\u000e]5dgJ+7/\u001e7u\u0013\u0011\t\u0019!!\u0002\u0003-Q{\u0007/[2NKR\fG-\u0019;b\u0003:$7i\u001c8gS\u001eT!a %\u0015\t\u0005%\u0011Q\u0002\t\u0004\u0003\u0017qQ\"\u0001\u0001\t\u000b\t\u0004\u0002\u0019A2\u0002\u000fM$\u0018M\u001d;VaR\ta\bK\u0002\u0012\u0003+\u0001B!a\u0006\u0002&5\u0011\u0011\u0011\u0004\u0006\u0005\u00037\ti\"A\u0002ba&TA!a\b\u0002\"\u00059!.\u001e9ji\u0016\u0014(bAA\u0012\u001f\u0006)!.\u001e8ji&!\u0011qEA\r\u0005%\u0011UMZ8sK\u0006cG.A\u0007uK\u0006\u0014Hi\\<o\u00072\f7o\u001d\u0015\u0004%\u00055\u0002\u0003BA\f\u0003_IA!!\r\u0002\u001a\tA\u0011I\u001a;fe\u0006cG.\u0001\nde\u0016\fG/\u001a\"s_.,'oQ8oM&<G#\u0001\u0017\u0002-%\u001cX*\u001a;bI\u0006$\u0018\rV8qS\u000e\u001c%/Z1uK\u0012,\"!a\u000f\u0011\u0007\u0005\ni$C\u0002\u0002@\t\u0012qAQ8pY\u0016\fg.\u0001\u000exC&$\u0018I\u001c3De\u0016\fG/Z'fi\u0006$\u0017\r^1U_BL7-A\rde\u0016\fG/Z'fi\u0006$\u0017\r^1U_BL7MU3tk2$HcA0\u0002H!9\u0011\u0011\n\fA\u0002\u0005-\u0013A\u0004;ie><X\t_2faRLwN\u001c\t\u0006C\u00055\u0013\u0011K\u0005\u0004\u0003\u001f\u0012#AB(qi&|g\u000e\u0005\u0003\u0002T\u0005uc\u0002BA+\u00033r1A\\A,\u0013\u0005\u0019\u0013bAA.E\u00059\u0001/Y2lC\u001e,\u0017\u0002BA0\u0003C\u0012\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005m#\u0005K\u0004\u0001\u0003K\nY'!\u001c\u0011\t\u0005]\u0011qM\u0005\u0005\u0003S\nIB\u0001\u0007UKN$\u0018J\\:uC:\u001cW-A\u0003wC2,X\r\n\u0002\u0002p%!\u0011\u0011OA:\u0003%\u0001VIU0D\u0019\u0006\u001b6K\u0003\u0003\u0002v\u0005]\u0014!\u0003'jM\u0016\u001c\u0017p\u00197f\u0015\u0011\tI(!\u0007\u0002\u0019Q+7\u000f^%ogR\fgnY3")
public class AbstractClusterLinkMetadataManagerTest {
    private final KafkaConfig brokerConfig = this.createBrokerConfig();
    private final ClusterLinkManager clusterLinkManager = (ClusterLinkManager)Mockito.mock(ClusterLinkManager.class);
    private ClusterLinkMetadataManager metadataManager;
    private final Admin destAdmin = (Admin)Mockito.mock(KafkaAdminClient.class);
    private ClusterLinkScheduler scheduler = new ClusterLinkScheduler();

    public KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    public ClusterLinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    public ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    public void metadataManager_$eq(ClusterLinkMetadataManager x$1) {
        this.metadataManager = x$1;
    }

    public Admin destAdmin() {
        return this.destAdmin;
    }

    public ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    public void scheduler_$eq(ClusterLinkScheduler x$1) {
        this.scheduler = x$1;
    }

    @BeforeAll
    public void startUp() {
        this.scheduler().startup();
        Mockito.when((Object)this.clusterLinkManager().listClusterLinks()).thenReturn((Object)package$.MODULE$.Seq().empty());
    }

    @AfterAll
    public void tearDownClass() {
        this.scheduler().shutdown();
        this.scheduler_$eq(null);
    }

    private KafkaConfig createBrokerConfig() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "true");
        props.put("confluent.cluster.link.metadata.topic.enable", "true");
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    public boolean isMetadataTopicCreated() {
        Field field = this.metadataManager().getClass().getSuperclass().getDeclaredField("initialized");
        field.setAccessible(true);
        return BoxesRunTime.unboxToBoolean((Object)field.get(this.metadataManager()));
    }

    public void waitAndCreateMetadataTopic() {
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!this.isMetadataTopicCreated()) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"MetadataTopic not created");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), waitUntilTrue_pause));
        }
    }

    public CreateTopicsResult createMetadataTopicResult(Option<Throwable> throwException) {
        KafkaFutureImpl createTopicFuture = new KafkaFutureImpl();
        if (throwException instanceof Some) {
            Throwable exception = (Throwable)((Some)throwException).value();
            createTopicFuture.completeExceptionally(exception);
            Map.Entry[] entryArray = new Map.Entry[1];
            String mkEntry_k = "_confluent-link-metadata";
            Object var4_4 = null;
            entryArray[0] = new AbstractMap.SimpleEntry<String, KafkaFutureImpl>(mkEntry_k, createTopicFuture);
            return new MockCreateTopicsResult(Utils.mkMap((Map.Entry[])entryArray));
        }
        if (None$.MODULE$.equals(throwException)) {
            createTopicFuture.complete((Object)new CreateTopicsResult.TopicMetadataAndConfig(Uuid.randomUuid(), Predef$.MODULE$.Integer2int(this.brokerConfig().clusterLinkMetadataTopicPartitions()), 2, new Config(Collections.emptyList())));
            Map.Entry[] entryArray = new Map.Entry[1];
            String mkEntry_k = "_confluent-link-metadata";
            Object var5_5 = null;
            entryArray[0] = new AbstractMap.SimpleEntry<String, KafkaFutureImpl>(mkEntry_k, createTopicFuture);
            return new MockCreateTopicsResult(Utils.mkMap((Map.Entry[])entryArray));
        }
        throw new MatchError(throwException);
    }

    public static final /* synthetic */ boolean $anonfun$waitAndCreateMetadataTopic$1(AbstractClusterLinkMetadataManagerTest $this) {
        return $this.isMetadataTopicCreated();
    }

    public static final /* synthetic */ String $anonfun$waitAndCreateMetadataTopic$2() {
        return "MetadataTopic not created";
    }

    public class MockCreateTopicsResult
    extends CreateTopicsResult {
        public /* synthetic */ AbstractClusterLinkMetadataManagerTest kafka$server$link$AbstractClusterLinkMetadataManagerTest$MockCreateTopicsResult$$$outer() {
            return AbstractClusterLinkMetadataManagerTest.this;
        }

        public MockCreateTopicsResult(Map<String, KafkaFuture<CreateTopicsResult.TopicMetadataAndConfig>> futures) {
            if (AbstractClusterLinkMetadataManagerTest.this == null) {
                throw null;
            }
            super(futures);
        }
    }
}

