/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpoint;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpointFile;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.EpochEntry;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\u0015b\u0001B\u001f?\u0001\u0015CQ\u0001\u0014\u0001\u0005\u00025Cq\u0001\u0015\u0001C\u0002\u0013\u0005\u0011\u000b\u0003\u0004^\u0001\u0001\u0006IA\u0015\u0005\b=\u0002\u0011\r\u0011\"\u0003`\u0011\u0019I\u0007\u0001)A\u0005A\"9!\u000e\u0001b\u0001\n\u0013Y\u0007BB9\u0001A\u0003%A\u000eC\u0003s\u0001\u0011\u00051\u000f\u0003\u0004\u0002\u0006\u0001!\ta\u001d\u0005\u0007\u0003\u001f\u0001A\u0011A:\t\r\u0005M\u0001\u0001\"\u0001t\u0011\u0019\t9\u0002\u0001C\u0001g\"1\u00111\u0004\u0001\u0005\u0002MDa!a\b\u0001\t\u0003\u0019\bBBA\u0012\u0001\u0011\u00051\u000f\u0003\u0004\u0002(\u0001!\ta\u001d\u0005\u0007\u0003W\u0001A\u0011A:\t\r\u0005=\u0002\u0001\"\u0001t\u0011\u0019\t\u0019\u0004\u0001C\u0001g\"1\u0011q\u0007\u0001\u0005\u0002MDa!a\u000f\u0001\t\u0003\u0019\bBBA \u0001\u0011\u00051\u000f\u0003\u0004\u0002D\u0001!\ta\u001d\u0005\u0007\u0003\u000f\u0002A\u0011A:\t\r\u0005-\u0003\u0001\"\u0001t\u0011\u0019\ty\u0005\u0001C\u0001g\"1\u00111\u000b\u0001\u0005\u0002MDq!a\u0016\u0001\t\u0013\tI\u0006\u0003\u0004\u0002(\u0002!\ta\u001d\u0005\u0007\u0003W\u0003A\u0011A:\t\r\u0005=\u0006\u0001\"\u0001t\u0011\u0019\t\u0019\f\u0001C\u0001g\"1\u0011q\u0017\u0001\u0005\u0002MDa!a/\u0001\t\u0003\u0019\bBBA`\u0001\u0011\u00051\u000f\u0003\u0004\u0002D\u0002!\ta\u001d\u0005\u0007\u0003\u000f\u0004A\u0011A:\t\r\u0005-\u0007\u0001\"\u0001t\u0011\u0019\ty\r\u0001C\u0001g\"1\u00111\u001b\u0001\u0005\u0002MDa!a6\u0001\t\u0003\u0019\bBBAn\u0001\u0011\u00051\u000f\u0003\u0004\u0002`\u0002!\ta\u001d\u0005\u0007\u0003G\u0004A\u0011A:\t\r\u0005\u001d\b\u0001\"\u0001t\u0011\u0019\tY\u000f\u0001C\u0001g\"1\u0011q\u001e\u0001\u0005\u0002MDa!a=\u0001\t\u0003\u0019\bBBA|\u0001\u0011\u00051\u000f\u0003\u0004\u0002|\u0002!\ta\u001d\u0005\u0007\u0003\u007f\u0004A\u0011A:\t\r\t\r\u0001\u0001\"\u0001t\u0011\u0019\u00119\u0001\u0001C\u0001g\"1!1\u0002\u0001\u0005\u0002MDaAa\u0004\u0001\t\u0003\u0019\bB\u0002B\n\u0001\u0011\u00051\u000f\u0003\u0004\u0003\u0018\u0001!\ta\u001d\u0005\u0007\u00053\u0001A\u0011A:\t\r\tu\u0001\u0001\"\u0001t\u0011\u0019\u0011\t\u0003\u0001C\u0001g\nAB*Z1eKJ,\u0005o\\2i\r&dWmQ1dQ\u0016$Vm\u001d;\u000b\u0005}\u0002\u0015!B3q_\u000eD'BA!C\u0003\u0019\u0019XM\u001d<fe*\t1)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00011\u0005CA$K\u001b\u0005A%\"A%\u0002\u000bM\u001c\u0017\r\\1\n\u0005-C%AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u001dB\u0011q\nA\u0007\u0002}\u0005\u0011A\u000f]\u000b\u0002%B\u00111kW\u0007\u0002)*\u0011QKV\u0001\u0007G>lWn\u001c8\u000b\u0005\r;&B\u0001-Z\u0003\u0019\t\u0007/Y2iK*\t!,A\u0002pe\u001eL!\u0001\u0018+\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u0019A\u000f\u001d\u0011\u0002\u0015\rDWmY6q_&tG/F\u0001a!\t\tw-D\u0001c\u0015\tq6M\u0003\u0002eK\u0006I\u0011N\u001c;fe:\fGn\u001d\u0006\u0003MZ\u000bqa\u001d;pe\u0006<W-\u0003\u0002iE\n)B*Z1eKJ,\u0005o\\2i\u0007\",7m\u001b9pS:$\u0018aC2iK\u000e\\\u0007o\\5oi\u0002\nQaY1dQ\u0016,\u0012\u0001\u001c\t\u0003[>l\u0011A\u001c\u0006\u0003\u007f\rL!\u0001\u001d8\u0003)1+\u0017\rZ3s\u000bB|7\r\u001b$jY\u0016\u001c\u0015m\u00195f\u0003\u0019\u0019\u0017m\u00195fA\u0005AA/Z1s\t><h\u000eF\u0001u!\t9U/\u0003\u0002w\u0011\n!QK\\5uQ\tA\u0001\u0010E\u0002z\u0003\u0003i\u0011A\u001f\u0006\u0003wr\f1!\u00199j\u0015\tih0A\u0004kkBLG/\u001a:\u000b\u0005}L\u0016!\u00026v]&$\u0018bAA\u0002u\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0012i\u0016\u001cH\u000f\u0015:fm&|Wo]#q_\u000eD\u0007fA\u0005\u0002\nA\u0019\u00110a\u0003\n\u0007\u00055!P\u0001\u0003UKN$\u0018!J:i_VdG-\u00113e\u000bB|7\r[!oI6+7o]1hK>3gm]3u)>\u001c\u0015m\u00195fQ\rQ\u0011\u0011B\u0001 g\"|W\u000f\u001c3TKR\u0014Vm]3u\r2\fw\rR5sif|e.Q:tS\u001et\u0007fA\u0006\u0002\n\u0005q3\u000f[8vY\u0012\u0014V\r^;s]2{w-\u00128e\u001f\u001a47/\u001a;JM2\u000bG/Z:u\u000bB|7\r\u001b*fcV,7\u000f^3eQ\ra\u0011\u0011B\u00015g\"|W\u000f\u001c3SKR,(O\\+oI\u00164\u0017N\\3e\u001f\u001a47/\u001a;JMVsG-\u001a4j]\u0016$W\t]8dQJ+\u0017/^3ti\u0016$\u0007fA\u0007\u0002\n\u0005\u00115\u000f[8vY\u0012tu\u000e^(wKJ<(/\u001b;f\u0019><WI\u001c3PM\u001a\u001cX\r\u001e$pe\u0006cU-\u00193fe\u0016\u0003xn\u00195P]\u000e,\u0017\n\u001e%bg\n+WM\\!tg&<g.\u001a3)\u00079\tI!\u0001\u0019tQ>,H\u000eZ#oM>\u00148-Z'p]>$xN\\5dC2d\u00170\u00138de\u0016\f7/\u001b8h'R\f'\u000f^(gMN,Go\u001d\u0015\u0004\u001f\u0005%\u0011\u0001P:i_VdGMT8u\u001fZ,'o\u001e:ji\u0016|eMZ:fi\u001a{'/\u0011'fC\u0012,'/\u00129pG\"|enY3Ji\"\u000b7OQ3f]\u0006\u001b8/[4oK\u0012D3\u0001EA\u0005\u0003!\u001a\bn\\;mIJ+G/\u001e:o+:\u001cX\u000f\u001d9peR,G-\u00134O_\u0016\u0003xn\u00195SK\u000e|'\u000fZ3eQ\r\t\u0012\u0011B\u0001Cg\"|W\u000f\u001c3SKR,(O\\+ogV\u0004\bo\u001c:uK\u0012LeMT8Fa>\u001c\u0007NU3d_J$W\rZ!oIVsG-\u001a4j]\u0016$W\t]8dQJ+\u0017/^3ti\u0016$\u0007f\u0001\n\u0002\n\u0005A4\u000f[8vY\u0012\u0014V\r^;s]\u001aK'o\u001d;Fa>\u001c\u0007.\u00134SKF,Xm\u001d;fI\u0016\u0003xn\u00195MKN\u001cH\u000b[1o\r&\u00148\u000f^#q_\u000eD\u0007fA\n\u0002\n\u0005)4\u000f[8vY\u0012$&/\u001e8dCR,\u0017JZ'bi\u000eD\u0017N\\4Fa>\u001c\u0007NQ;u\u000b\u0006\u0014H.[3s'R\f'\u000f^5oO>3gm]3uQ\r!\u0012\u0011B\u0001Ig\"|W\u000f\u001c3HKR4\u0015N]:u\u001f\u001a47/\u001a;PMN+(m]3rk\u0016tG/\u00129pG\"<\u0006.\u001a8PM\u001a\u001cX\r\u001e*fcV,7\u000f^3e\r>\u0014\bK]3wS>,8/\u00129pG\"D3!FA\u0005\u0003\u0015\u001b\bn\\;mIJ+G/\u001e:o\u001d\u0016DH/\u0011<bS2\f'\r\\3Fa>\u001c\u0007.\u00134UQ\u0016\u0014X-S:O_\u0016C\u0018m\u0019;Fa>\u001c\u0007NR8s)\",wJ\\3SKF,Xm\u001d;fI\"\u001aa#!\u0003\u0002eMDw.\u001e7e\u001d>$X\u000b\u001d3bi\u0016,\u0005o\\2i\u0003:$7\u000b^1si>3gm]3u\u0013\u001aLE\u000fR5e\u001d>$8\t[1oO\u0016D3aFA\u0005\u0003\u0015\u001b\bn\\;mIJ+G/\u001e:o\u0013:4\u0018\r\\5e\u001f\u001a47/\u001a;JM\u0016\u0003xn\u00195JgJ+\u0017/^3ti\u0016$w\u000b[5dQ&\u001bhj\u001c;DkJ\u0014XM\u001c;msR\u0013\u0018mY6fI\"\u001a\u0001$!\u0003\u0002SMDw.\u001e7e'V\u0004\bo\u001c:u\u000bB|7\r[:UQ\u0006$Hi\u001c(piN#\u0018M\u001d;Ge>l',\u001a:pQ\rI\u0012\u0011B\u0001$g\"|W\u000f\u001c3QKJ\u001c\u0018n\u001d;Fa>\u001c\u0007n\u001d\"fi^,WM\\%ogR\fgnY3tQ\rQ\u0012\u0011B\u0001+g\"|W\u000f\u001c3F]\u001a|'oY3N_:|Go\u001c8jG\u0006dG._%oGJ,\u0017m]5oO\u0016\u0003xn\u00195tQ\rY\u0012\u0011B\u0001\bi>$V\u000f\u001d7f+\u0019\tY&a\u001a\u0002|Q!\u0011QLA@!\u001d9\u0015qLA2\u0003sJ1!!\u0019I\u0005\u0019!V\u000f\u001d7feA!\u0011QMA4\u0019\u0001!q!!\u001b\u001d\u0005\u0004\tYGA\u0001L#\u0011\ti'a\u001d\u0011\u0007\u001d\u000by'C\u0002\u0002r!\u0013qAT8uQ&tw\rE\u0002H\u0003kJ1!a\u001eI\u0005\r\te.\u001f\t\u0005\u0003K\nY\bB\u0004\u0002~q\u0011\r!a\u001b\u0003\u0003YCq!!!\u001d\u0001\u0004\t\u0019)A\u0003f]R\u0014\u0018\u0010\u0005\u0005\u0002\u0006\u0006\u0005\u00161MA=\u001d\u0011\t9)a'\u000f\t\u0005%\u0015Q\u0013\b\u0005\u0003\u0017\u000b\t*\u0004\u0002\u0002\u000e*\u0019\u0011q\u0012#\u0002\rq\u0012xn\u001c;?\u0013\t\t\u0019*\u0001\u0003kCZ\f\u0017\u0002BAL\u00033\u000bA!\u001e;jY*\u0011\u00111S\u0005\u0005\u0003;\u000by*A\u0002NCBTA!a&\u0002\u001a&!\u00111UAS\u0005\u0015)e\u000e\u001e:z\u0015\u0011\ti*a(\u0002SMDw.\u001e7e\u000b:4wN]2f\u001f\u001a47/\u001a;t\u0013:\u001c'/Z1tK6{gn\u001c;p]&\u001c\u0017\r\u001c7zQ\ri\u0012\u0011B\u00015g\"|W\u000f\u001c3J]\u000e\u0014X-Y:f\u0003:$GK]1dW\u0016\u0003xn\u00195t\u0003NdU-\u00193feN\u001c\u0005.\u00198hK6\u000bg.\u001f+j[\u0016\u001c\bf\u0001\u0010\u0002\n\u0005Q4\u000f[8vY\u0012Len\u0019:fCN,\u0017I\u001c3Ue\u0006\u001c7.\u00129pG\"\u001c\u0018i\u001d$pY2|w/\u001a:SK\u000e,\u0017N^3t\u001b\u0006t\u00170T3tg\u0006<Wm\u001d\u0015\u0004?\u0005%\u0011!O:i_VdG\r\u0012:pa\u0016sGO]5fg>sW\t]8dQ\n{WO\u001c3bef<\u0006.\u001a8SK6|g/\u001b8h\u0019\u0006$Xm\u001d;F]R\u0014\u0018.Z:)\u0007\u0001\nI!A\u001atQ>,H\u000e\u001a)sKN,'O^3SKN,Go\u00144gg\u0016$xJ\\\"mK\u0006\u0014X)\u0019:mS\u0016\u001cH/\u00134P]\u0016,\u00050[:ug\"\u001a\u0011%!\u0003\u0002sMDw.\u001e7e+B$\u0017\r^3TCZ,Gm\u00144gg\u0016$x\u000b[3o\u001f\u001a47/\u001a;U_\u000ecW-\u0019:U_&\u001b()\u001a;xK\u0016tW\t]8dQND3AIA\u0005\u0003\u0015\u001a\bn\\;mI:{Go\u00117fCJ\fe.\u001f;iS:<\u0017JZ(gMN,G\u000fV8FCJd\u0017\u0010K\u0002$\u0003\u0013\t1f\u001d5pk2$gj\u001c;DY\u0016\f'/\u00118zi\"LgnZ%g\u001f\u001a47/\u001a;U_\u001aK'o\u001d;PM\u001a\u001cX\r\u001e\u0015\u0004I\u0005%\u0011!K:i_VdGMU3uC&tG*\u0019;fgR,\u0005o\\2i\u001f:\u001cE.Z1s\u00032dW)\u0019:mS\u0016\u001cH\u000fK\u0002&\u0003\u0013\tqg\u001d5pk2$W\u000b\u001d3bi\u0016|eMZ:fi\n+Go^3f]\u0016\u0003xn\u00195C_VtG-\u0019:jKN|en\u00117fCJ,\u0015M\u001d7jKN$\bf\u0001\u0014\u0002\n\u0005A4\u000f[8vY\u0012,\u0006\u000fZ1uK>3gm]3u\u0005\u0016$x/Z3o\u000bB|7\r\u001b\"pk:$\u0017M]5fg>s7\t\\3be\u0016\u000b'\u000f\\5fgR\u0014\u0004fA\u0014\u0002\n\u0005Y4\u000f[8vY\u0012\u0014V\r^1j]2\u000bG/Z:u\u000bB|7\r[(o\u00072,\u0017M]!mY\u0016\u000b'\u000f\\5fgR\fe\u000eZ+qI\u0006$X-\u0013;t\u001f\u001a47/\u001a;)\u0007!\nI!\u0001\u0011uKN$HK];oG\u0006$XM\u0012:p[N#\u0018M\u001d;XSRDgj\u001c$mkND\u0007fA\u0015\u0002\n\u000594\u000f[8vY\u0012$%o\u001c9F]R\u0014\u0018.Z:CKR<X-\u001a8Fa>\u001c\u0007NQ8v]\u0012\f'/_,iK:\u0014V-\\8wS:<g*Z<fgRD3AKA\u0005\u0003u\u0019\bn\\;mI\u000ecW-\u0019:B]\u00124E.^:i\u00032dWI\u001c;sS\u0016\u001c\bfA\u0016\u0002\n\u0005)2\u000f[8vY\u0012\u001cE.Z1s\u00032dWI\u001c;sS\u0016\u001c\bf\u0001\u0017\u0002\n\u0005y3\u000f[8vY\u0012tu\u000e\u001e*fg\u0016$X\t]8dQ\"K7\u000f^8ss\"+\u0017\rZ%g+:$WMZ5oK\u0012\u0004\u0016m]:fI\"\u001aQ&!\u0003\u0002_MDw.\u001e7e\u001d>$(+Z:fi\u0016\u0003xn\u00195ISN$xN]=UC&d\u0017JZ+oI\u00164\u0017N\\3e!\u0006\u001c8/\u001a3)\u00079\nI!\u0001\u0012tQ>,H\u000eZ\"peJ,7\r\u001e7z%\u0016\u001cHo\u001c:f\rVdGn\u00158baNDw\u000e\u001e\u0015\u0004_\u0005%\u0011AI:i_VdGMR3uG\"d\u0015\r^3ti\u0016\u0003xn\u00195PM\u0016k\u0007\u000f^=DC\u000eDW\rK\u00021\u0003\u0013\t\u0001e\u001d5pk2$g)\u001a;dQ\u0016sGm\u00144gg\u0016$xJZ#naRL8)Y2iK\"\u001a\u0011'!\u0003\u0002?MDw.\u001e7e\u00072,\u0017M]#be2LWm\u001d;P]\u0016k\u0007\u000f^=DC\u000eDW\rK\u00023\u0003\u0013\tQd\u001d5pk2$7\t\\3be2\u000bG/Z:u\u001f:,U\u000e\u001d;z\u0007\u0006\u001c\u0007.\u001a\u0015\u0004g\u0005%\u0011AJ:i_VdGMU3ukJt7i\u001c:sK\u000e$8\u000b^1si>3gm]3u\r>\u0014X\t]8dQ\"\u001aA'!\u0003\u00021QLWM]3e\u000bB|7\r[\"bG\",7K\\1qg\"|G\u000fK\u00026\u0003\u0013\t\u0011f\u001d5pk2$gj\u001c;SKB|'\u000f\u001e#jm\u0016\u0014x-\u001a8dK^CWM\u001c(p\t&4XM]4f]\u000e,\u0007f\u0001\u001c\u0002\n\u0005\u00193\u000f[8vY\u0012\u0014V\r]8si\u0012Kg/\u001a:hK:\u001cWm\u00165f]\u0012Kg/\u001a:hS:<\u0007fA\u001c\u0002\n\u0005)3\u000f[8vY\u0012\u001cuN\u001c;j]V,wK]5uKR{7)Y2iK>sG)[:l!\u0006,8/\u001a\u0015\u0004q\u0005%\u0011!\u0006;fgR4\u0015N\u001c3Qe\u00164\u0018n\\;t\u000bB|7\r[\u0001\u0012i\u0016\u001cHOR5oI:+\u0007\u0010^#q_\u000eD\u0007f\u0001\u001e\u0002\n\u0005\tB/Z:u\u000f\u0016$X\t]8dQ\u0016sGO]=)\u0007m\nI!\u0001\u0010tQ>,H\u000e\u001a$fi\u000eDW\t]8dQ\u001a{'oR5wK:|eMZ:fi\"\u001aA(!\u0003")
public class LeaderEpochFileCacheTest {
    private final TopicPartition tp = new TopicPartition("TestTopic", 5);
    private final LeaderEpochCheckpoint checkpoint = new LeaderEpochCheckpoint(null){
        private Seq<EpochEntry> epochs;
        private final File file;

        private Seq<EpochEntry> epochs() {
            return this.epochs;
        }

        private void epochs_$eq(Seq<EpochEntry> x$1) {
            this.epochs = x$1;
        }

        public File file() {
            return this.file;
        }

        public void write(Collection<EpochEntry> epochs) {
            this.epochs_$eq((Seq<EpochEntry>)CollectionConverters$.MODULE$.CollectionHasAsScala(epochs).asScala().toSeq());
        }

        public byte[] toByteArray(java.util.List<EpochEntry> epochs) {
            throw new UnsupportedOperationException("toByteArray is currently unused and is not implemented for the test checkpoint implementation");
        }

        public java.util.List<EpochEntry> read() {
            return CollectionConverters$.MODULE$.SeqHasAsJava(this.epochs()).asJava();
        }
        {
            this.epochs = (Seq)Seq$.MODULE$.empty();
            this.file = TestUtils.tempFile((String)"kafka", (String)".tmp");
        }
    };
    private final LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), this.checkpoint());

    public TopicPartition tp() {
        return this.tp;
    }

    private LeaderEpochCheckpoint checkpoint() {
        return this.checkpoint;
    }

    private LeaderEpochFileCache cache() {
        return this.cache;
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.checkpoint().file(), (boolean)false);
    }

    @Test
    public void testPreviousEpoch() {
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().previousEpoch());
        this.cache().assign(2, 10L);
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().previousEpoch());
        this.cache().assign(4, 15L);
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().previousEpoch());
        this.cache().assign(10, 20L);
        Assertions.assertEquals((Object)OptionalInt.of(4), (Object)this.cache().previousEpoch());
        this.cache().truncateFromEnd(18L);
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().previousEpoch());
    }

    @Test
    public void shouldAddEpochAndMessageOffsetToCache() {
        this.cache().assign(2, 10L);
        int logEndOffset = 11;
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new EpochEntry(2, 10L), this.cache().epochEntries().get(0));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), this.toTuple(this.cache().endOffsetFor(2, (long)logEndOffset)));
    }

    @Test
    public void shouldSetResetFlagDirtyOnAssign() {
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)this.cache().isDirty()));
        this.cache().assign(2, 10L);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)this.cache().isDirty()));
        this.cache().maybeFlush();
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)this.cache().isDirty()));
    }

    @Test
    public void shouldReturnLogEndOffsetIfLatestEpochRequested() {
        this.cache().assign(2, 11L);
        this.cache().assign(2, 12L);
        int logEndOffset = 14;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), this.toTuple(this.cache().endOffsetFor(2, (long)logEndOffset)));
    }

    @Test
    public void shouldReturnUndefinedOffsetIfUndefinedEpochRequested() {
        Tuple2.mcIJ.sp expectedEpochEndOffset = new Tuple2.mcIJ.sp(-1, -1L);
        this.cache().assign(2, 11L);
        this.cache().assign(3, 12L);
        Tuple2 epochAndOffsetFor = this.toTuple(this.cache().endOffsetFor(-1, 0L));
        Assertions.assertEquals((Object)expectedEpochEndOffset, epochAndOffsetFor, (String)"Expected undefined epoch and offset if undefined epoch requested. Cache not empty.");
    }

    @Test
    public void shouldNotOverwriteLogEndOffsetForALeaderEpochOnceItHasBeenAssigned() {
        int logEndOffset = 9;
        this.cache().assign(2, (long)logEndOffset);
        this.cache().assign(2, 10L);
        Assertions.assertEquals((long)logEndOffset, (long)((EpochEntry)this.cache().epochEntries().get((int)0)).startOffset);
        Assertions.assertEquals(Arrays.asList(new EpochEntry(2, 9L)), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldEnforceMonotonicallyIncreasingStartOffsets() {
        this.cache().assign(2, 9L);
        this.cache().assign(3, 9L);
        Assertions.assertEquals(Arrays.asList(new EpochEntry(3, 9L)), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldNotOverwriteOffsetForALeaderEpochOnceItHasBeenAssigned() {
        this.cache().assign(2, 6L);
        this.cache().assign(2, 10L);
        Assertions.assertEquals((long)6L, (long)((EpochEntry)this.cache().epochEntries().get((int)0)).startOffset);
    }

    @Test
    public void shouldReturnUnsupportedIfNoEpochRecorded() {
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), this.toTuple(this.cache().endOffsetFor(0, 0L)));
    }

    @Test
    public void shouldReturnUnsupportedIfNoEpochRecordedAndUndefinedEpochRequested() {
        Tuple2 offsetFor = this.toTuple(this.cache().endOffsetFor(-1, 73L));
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), offsetFor, (String)"Expected undefined epoch and offset if undefined epoch requested. Empty cache.");
    }

    @Test
    public void shouldReturnFirstEpochIfRequestedEpochLessThanFirstEpoch() {
        this.cache().assign(5, 11L);
        this.cache().assign(6, 12L);
        this.cache().assign(7, 13L);
        Tuple2 epochAndOffset = this.toTuple(this.cache().endOffsetFor(4, 0L));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(4, 11), epochAndOffset);
    }

    @Test
    public void shouldTruncateIfMatchingEpochButEarlierStartingOffset() {
        this.cache().assign(5, 11L);
        this.cache().assign(6, 12L);
        this.cache().assign(7, 13L);
        this.cache().assign(7, 12L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(5, 12), this.toTuple(this.cache().endOffsetFor(5, 0L)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(5, 12), this.toTuple(this.cache().endOffsetFor(6, 0L)));
    }

    @Test
    public void shouldGetFirstOffsetOfSubsequentEpochWhenOffsetRequestedForPreviousEpoch() {
        this.cache().assign(1, 11L);
        this.cache().assign(1, 12L);
        this.cache().assign(2, 13L);
        this.cache().assign(2, 14L);
        this.cache().assign(3, 15L);
        this.cache().assign(3, 16L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 15), this.toTuple(this.cache().endOffsetFor(2, 17L)));
    }

    @Test
    public void shouldReturnNextAvailableEpochIfThereIsNoExactEpochForTheOneRequested() {
        this.cache().assign(0, 10L);
        this.cache().assign(2, 13L);
        this.cache().assign(4, 17L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 13), this.toTuple(this.cache().endOffsetFor(1, 0L)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 17), this.toTuple(this.cache().endOffsetFor(2, 0L)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 17), this.toTuple(this.cache().endOffsetFor(3, 0L)));
    }

    @Test
    public void shouldNotUpdateEpochAndStartOffsetIfItDidNotChange() {
        this.cache().assign(2, 6L);
        this.cache().assign(2, 7L);
        Assertions.assertEquals((int)1, (int)this.cache().epochEntries().size());
        Assertions.assertEquals((Object)new EpochEntry(2, 6L), this.cache().epochEntries().get(0));
    }

    @Test
    public void shouldReturnInvalidOffsetIfEpochIsRequestedWhichIsNotCurrentlyTracked() {
        int logEndOffset = 100;
        this.cache().assign(2, 100L);
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), this.toTuple(this.cache().endOffsetFor(3, (long)logEndOffset)));
    }

    @Test
    public void shouldSupportEpochsThatDoNotStartFromZero() {
        this.cache().assign(2, 6L);
        int logEndOffset = 7;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), this.toTuple(this.cache().endOffsetFor(2, (long)logEndOffset)));
        Assertions.assertEquals((int)1, (int)this.cache().epochEntries().size());
        Assertions.assertEquals((Object)new EpochEntry(2, 6L), this.cache().epochEntries().get(0));
    }

    @Test
    public void shouldPersistEpochsBetweenInstances() {
        String checkpointPath = TestUtils.tempFile((String)"kafka", (String)".tmp").getAbsolutePath();
        LeaderEpochCheckpointFile checkpoint = new LeaderEpochCheckpointFile(new File(checkpointPath), new LogDirFailureChannel(1));
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (LeaderEpochCheckpoint)checkpoint);
        cache.assign(2, 6L);
        cache.maybeFlush();
        LeaderEpochCheckpointFile checkpoint2 = new LeaderEpochCheckpointFile(new File(checkpointPath), new LogDirFailureChannel(1));
        LeaderEpochFileCache cache2 = new LeaderEpochFileCache(this.tp(), (LeaderEpochCheckpoint)checkpoint2);
        Assertions.assertEquals((int)1, (int)cache2.epochEntries().size());
        Assertions.assertEquals((Object)new EpochEntry(2, 6L), cache2.epochEntries().get(0));
    }

    @Test
    public void shouldEnforceMonotonicallyIncreasingEpochs() {
        this.cache().assign(1, 5L);
        this.cache().assign(2, 6L);
        this.cache().assign(1, 7L);
        int logEndOffset = 8;
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 8), this.toTuple(this.cache().endOffsetFor(1, (long)logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), this.toTuple(this.cache().endOffsetFor(2, (long)logEndOffset)));
        Assertions.assertEquals((Object)new EpochEntry(1, 7L), this.cache().epochEntries().get(0));
    }

    private <K, V> Tuple2<K, V> toTuple(Map.Entry<K, V> entry) {
        return new Tuple2(entry.getKey(), entry.getValue());
    }

    @Test
    public void shouldEnforceOffsetsIncreaseMonotonically() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 5L);
        Assertions.assertEquals((Object)new EpochEntry(3, 5L), this.cache().epochEntries().get(0));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsLeadersChangeManyTimes() {
        long logEndOffset = 0L;
        this.cache().assign(0, 0L);
        this.cache().assign(1, 0L);
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 0), this.toTuple(this.cache().endOffsetFor(1, logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), this.toTuple(this.cache().endOffsetFor(0, logEndOffset)));
        logEndOffset = 5L;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 5), this.toTuple(this.cache().endOffsetFor(1, logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), this.toTuple(this.cache().endOffsetFor(0, logEndOffset)));
        this.cache().assign(2, 5L);
        logEndOffset = 10L;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 10), this.toTuple(this.cache().endOffsetFor(2, logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 5), this.toTuple(this.cache().endOffsetFor(1, logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), this.toTuple(this.cache().endOffsetFor(0, logEndOffset)));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsFollowerReceivesManyMessages() {
        this.cache().assign(0, 0L);
        this.cache().assign(0, 1L);
        this.cache().assign(0, 2L);
        int logEndOffset = 3;
        Assertions.assertEquals((Object)OptionalInt.of(0), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, logEndOffset), this.toTuple(this.cache().endOffsetFor(0, (long)logEndOffset)));
        this.cache().assign(1, 3L);
        this.cache().assign(1, 4L);
        this.cache().assign(1, 5L);
        logEndOffset = 6;
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, logEndOffset), this.toTuple(this.cache().endOffsetFor(1, (long)logEndOffset)));
        this.cache().assign(2, 6L);
        this.cache().assign(2, 7L);
        this.cache().assign(2, 8L);
        logEndOffset = 9;
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), this.toTuple(this.cache().endOffsetFor(2, (long)logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 3), this.toTuple(this.cache().endOffsetFor(0, (long)logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 6), this.toTuple(this.cache().endOffsetFor(1, (long)logEndOffset)));
    }

    @Test
    public void shouldDropEntriesOnEpochBoundaryWhenRemovingLatestEntries() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(8L);
        Assertions.assertEquals(Arrays.asList(new EpochEntry(2, 6L)), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldPreserveResetOffsetOnClearEarliestIfOneExists() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(8L, true);
        Assertions.assertEquals(Arrays.asList(new EpochEntry(3, 8L), new EpochEntry(4, 11L)), (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
    }

    @Test
    public void shouldUpdateSavedOffsetWhenOffsetToClearToIsBetweenEpochs() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(9L, true);
        Assertions.assertEquals(Arrays.asList(new EpochEntry(3, 9L), new EpochEntry(4, 11L)), (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToEarly() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        Assertions.assertTrue((boolean)this.cache().isDirty());
        this.cache().truncateFromStart(1L, true);
        Assertions.assertEquals(Arrays.asList(new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)), (Object)this.cache().epochEntries());
        Assertions.assertTrue((boolean)this.cache().isDirty());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToFirstOffset() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(6L, true);
        Assertions.assertEquals(Arrays.asList(new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)), (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(11L, true);
        Assertions.assertEquals(Collections.singletonList(new EpochEntry(4, 11L)), (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(9L, true);
        Assertions.assertEquals(Arrays.asList(new EpochEntry(3, 9L), new EpochEntry(4, 11L)), (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest2() {
        this.cache().assign(0, 0L);
        this.cache().assign(1, 7L);
        this.cache().assign(2, 10L);
        this.cache().truncateFromStart(5L, true);
        Assertions.assertEquals(Arrays.asList(new EpochEntry(0, 5L), new EpochEntry(1, 7L), new EpochEntry(2, 10L)), (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliestAndUpdateItsOffset() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(15L, true);
        Assertions.assertEquals(Collections.singletonList(new EpochEntry(4, 15L)), (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
    }

    @Test
    public void testTruncateFromStartWithNoFlush() {
        java.util.List<EpochEntry> epochs = Arrays.asList(new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L));
        epochs.forEach(epoch -> this.cache().assign(epoch.epoch, epoch.startOffset));
        Assertions.assertTrue((boolean)this.cache().isDirty());
        this.cache().maybeFlush();
        Assertions.assertFalse((boolean)this.cache().isDirty());
        this.cache().truncateFromStart(8L, false);
        java.util.List<EpochEntry> updatedEpochs = epochs.subList(1, epochs.size());
        Assertions.assertTrue((boolean)this.cache().isDirty());
        Assertions.assertEquals(updatedEpochs, (Object)this.cache().epochEntries());
        Assertions.assertEquals(epochs, (Object)new LeaderEpochFileCache(this.tp(), this.checkpoint()).epochEntries());
        this.cache().maybeFlush();
        Assertions.assertFalse((boolean)this.cache().isDirty());
        Assertions.assertEquals(updatedEpochs, (Object)this.cache().epochEntries());
        Assertions.assertEquals(updatedEpochs, (Object)new LeaderEpochFileCache(this.tp(), this.checkpoint()).epochEntries());
    }

    @Test
    public void shouldDropEntriesBetweenEpochBoundaryWhenRemovingNewest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(9L);
        Assertions.assertEquals((Object)OptionalInt.of(3), (Object)this.cache().latestEpoch());
        Assertions.assertEquals(Arrays.asList(new EpochEntry(2, 6L), new EpochEntry(3, 8L)), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldClearAndFlushAllEntries() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().clearAndFlush();
        Assertions.assertEquals((int)0, (int)this.cache().epochEntries().size());
    }

    @Test
    public void shouldClearAllEntries() {
        java.util.List<EpochEntry> epochs = Arrays.asList(new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L));
        epochs.forEach(epoch -> this.cache().assign(epoch.epoch, epoch.startOffset));
        Assertions.assertTrue((boolean)this.cache().isDirty());
        this.cache().maybeFlush();
        Assertions.assertFalse((boolean)this.cache().isDirty());
        this.cache().clear();
        Assertions.assertEquals(Collections.emptyList(), (Object)this.cache().epochEntries());
        Assertions.assertTrue((boolean)this.cache().isDirty());
        Assertions.assertEquals(epochs, (Object)new LeaderEpochFileCache(this.tp(), this.checkpoint()).epochEntries());
        this.cache().maybeFlush();
        Assertions.assertEquals(Collections.emptyList(), (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
        Assertions.assertEquals(Collections.emptyList(), (Object)new LeaderEpochFileCache(this.tp(), this.checkpoint()).epochEntries());
    }

    @Test
    public void shouldNotResetEpochHistoryHeadIfUndefinedPassed() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(-1L, true);
        Assertions.assertEquals((int)3, (int)this.cache().epochEntries().size());
    }

    @Test
    public void shouldNotResetEpochHistoryTailIfUndefinedPassed() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(-1L);
        Assertions.assertEquals((int)3, (int)this.cache().epochEntries().size());
    }

    @Test
    public void shouldCorrectlyRestoreFullSnapshot() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        java.util.List<EpochEntry> snapshot = Arrays.asList(new EpochEntry(3, 8L), new EpochEntry(4, 11L), new EpochEntry(5, 14L));
        this.cache().restore(snapshot);
        Assertions.assertEquals(snapshot, (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldFetchLatestEpochOfEmptyCache() {
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().latestEpoch());
    }

    @Test
    public void shouldFetchEndOffsetOfEmptyCache() {
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), this.toTuple(this.cache().endOffsetFor(7, 0L)));
    }

    @Test
    public void shouldClearEarliestOnEmptyCache() {
        this.cache().truncateFromStart(7L, true);
    }

    @Test
    public void shouldClearLatestOnEmptyCache() {
        this.cache().truncateFromEnd(7L);
    }

    @Test
    public void shouldReturnCorrectStartOffsetForEpoch() {
        this.cache().assign(1, 10L);
        this.cache().assign(2, 20L);
        this.cache().assign(3, 30L);
        int requestedEpoch = 0;
        Assertions.assertEquals((long)-1L, (long)this.cache().offsetForEpoch(requestedEpoch), (String)new StringBuilder(39).append("Returned wrong start offset for epoch: ").append(requestedEpoch).toString());
        requestedEpoch = 4;
        Assertions.assertEquals((long)-1L, (long)this.cache().offsetForEpoch(requestedEpoch), (String)new StringBuilder(39).append("Returned wrong start offset for epoch: ").append(requestedEpoch).toString());
        requestedEpoch = 1;
        Assertions.assertEquals((long)10L, (long)this.cache().offsetForEpoch(requestedEpoch), (String)new StringBuilder(39).append("Returned wrong start offset for epoch: ").append(requestedEpoch).toString());
        this.cache().clearAndFlush();
        Assertions.assertEquals((long)-1L, (long)this.cache().offsetForEpoch(requestedEpoch), (String)new StringBuilder(39).append("Returned wrong start offset for epoch: ").append(requestedEpoch).toString());
    }

    @Test
    public void tieredEpochCacheSnapshot() {
        File checkpointFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        LeaderEpochCheckpointFile checkpoint = new LeaderEpochCheckpointFile(checkpointFile, null);
        LeaderEpochFileCache newCache = new LeaderEpochFileCache(this.tp(), (LeaderEpochCheckpoint)checkpoint);
        newCache.assign(3, 43L);
        newCache.assign(5, 50L);
        newCache.assign(7, 70L);
        newCache.assign(8, 80L);
        byte[] bytesOut = newCache.snapshotForSegment(70L);
        java.util.List epochEntries = LeaderEpochCheckpoint.read((String)"frombuffer", (BufferedReader)new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bytesOut))));
        Assertions.assertEquals(Arrays.asList(new EpochEntry(3, 43L), new EpochEntry(5, 50L), new EpochEntry(7, 70L)), (Object)epochEntries);
    }

    @Test
    public void shouldNotReportDivergenceWhenNoDivergence() {
        this.cache().assign(5, 50L);
        this.cache().assign(6, 60L);
        this.cache().assign(7, 70L);
        this.cache().assign(8, 80L);
        java.util.List<Object> tieredEpochState = this.cache().epochEntries();
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache((java.util.List)tieredEpochState, 50L, 89L, 50L, 89L), (String)"False positive for divergence while comparing with identical tier state");
        this.cache().clearAndFlush();
        this.cache().assign(6, 60L);
        this.cache().assign(7, 70L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache((java.util.List)tieredEpochState, 50L, 89L, 60L, 79L), (String)"False positive for divergence while comparing with an identical but superset tier state");
        this.cache().clearAndFlush();
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache((java.util.List)tieredEpochState, 50L, 89L, 0L, -1L), (String)"False positive for divergence when epoch cache is empty");
        tieredEpochState = Collections.emptyList();
        this.cache().clearAndFlush();
        this.cache().assign(10, 100L);
        this.cache().assign(11, 110L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, -1L, 100L, 119L), (String)"False positive for divergence when epoch cache is empty");
        tieredEpochState = Arrays.asList(new EpochEntry(5, 50L), new EpochEntry(6, 60L), new EpochEntry(7, 70L), new EpochEntry(8, 80L));
        this.cache().clearAndFlush();
        this.cache().assign(10, 100L);
        this.cache().assign(11, 110L);
        this.cache().assign(12, 120L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 50L, 89L, 100L, 129L), (String)"False positive for divergence while comparing with a disjointed epoch cache");
        this.cache().clearAndFlush();
        this.cache().assign(0, 0L);
        this.cache().assign(1, 10L);
        this.cache().assign(2, 20L);
        this.cache().assign(3, 30L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 50L, 89L, 0L, 39L), (String)"False positive for divergence while comparing with a disjointed epoch cache");
        tieredEpochState = Arrays.asList(new EpochEntry(0, 0L), new EpochEntry(1, 10L), new EpochEntry(2, 20L), new EpochEntry(3, 30L), new EpochEntry(4, 40L), new EpochEntry(5, 40L), new EpochEntry(6, 40L));
        this.cache().clearAndFlush();
        this.cache().assign(0, 0L);
        this.cache().assign(1, 10L);
        this.cache().assign(2, 20L);
        this.cache().assign(3, 30L);
        this.cache().assign(6, 40L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 49L, 0L, 49L), (String)"False positive for divergence when follower had not recorded leader with no messages");
        tieredEpochState = Arrays.asList(new EpochEntry(0, 0L), new EpochEntry(1, 10L), new EpochEntry(2, 20L), new EpochEntry(3, 30L));
        this.cache().clearAndFlush();
        this.cache().assign(0, 5L);
        this.cache().assign(1, 10L);
        this.cache().assign(2, 20L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 39L, 5L, 29L), (String)"False positive for divergence when local log had been incremented");
        tieredEpochState = Arrays.asList(new EpochEntry(0, 0L));
        this.cache().clearAndFlush();
        this.cache().assign(0, 100L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 899L, 100L, 999L), (String)"False positive for divergence when single entry in leaderCache, local log incremented and lastLocalOffset != lastTieredOffset");
        tieredEpochState = Arrays.asList(new EpochEntry(0, 0L));
        this.cache().clearAndFlush();
        this.cache().assign(0, 0L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 899L, 0L, 999L), (String)"False positive for divergence when end offset for an epoch mismatch due to lastLocalOffset != lastTieredOffset");
        tieredEpochState = Arrays.asList(new EpochEntry(0, 0L));
        this.cache().clearAndFlush();
        this.cache().assign(0, 0L);
        this.cache().assign(1, 100L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 49L, 0L, 149L), (String)"False negative when end offset for an epoch mismatches");
        tieredEpochState = Arrays.asList(new EpochEntry(0, 0L), new EpochEntry(1, 100L));
        this.cache().clearAndFlush();
        this.cache().assign(0, 0L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 199L, 0L, 49L), (String)"False negative when end offset for an epoch mismatches");
    }

    @Test
    public void shouldReportDivergenceWhenDiverging() {
        java.util.List<EpochEntry> tieredEpochState = Arrays.asList(new EpochEntry(0, 0L), new EpochEntry(1, 10L), new EpochEntry(2, 20L), new EpochEntry(3, 30L));
        this.cache().assign(2, 20L);
        this.cache().assign(3, 25L);
        this.cache().assign(4, 40L);
        this.cache().assign(5, 50L);
        Assertions.assertEquals((long)25L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 39L, 20L, 59L), (String)"False negative for an overlapping but diverging tier state");
        this.cache().clearAndFlush();
        this.cache().assign(2, 20L);
        this.cache().assign(3, 35L);
        this.cache().assign(4, 40L);
        this.cache().assign(5, 50L);
        Assertions.assertEquals((long)30L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 39L, 20L, 59L), (String)"False negative for an overlapping but diverging tier state");
        tieredEpochState = Arrays.asList(new EpochEntry(1, 10L), new EpochEntry(2, 20L), new EpochEntry(3, 30L));
        this.cache().clearAndFlush();
        this.cache().assign(1, 5L);
        this.cache().assign(2, 20L);
        this.cache().assign(3, 30L);
        Assertions.assertEquals((long)5L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 10L, 39L, 5L, 39L), (String)"False negative when first local epoch has offset lower than tiered offset for the same epoch");
        tieredEpochState = Arrays.asList(new EpochEntry(0, 0L), new EpochEntry(1, 10L), new EpochEntry(2, 20L), new EpochEntry(3, 30L));
        this.cache().clearAndFlush();
        this.cache().assign(3, 25L);
        this.cache().assign(4, 40L);
        this.cache().assign(5, 50L);
        Assertions.assertEquals((long)20L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 39L, 25L, 59L), (String)"False negative when local cache misses an epoch but includes the corresponding offset");
        tieredEpochState = Arrays.asList(new EpochEntry(3, 30L), new EpochEntry(4, 40L), new EpochEntry(5, 50L));
        this.cache().clearAndFlush();
        this.cache().assign(2, 20L);
        this.cache().assign(3, 35L);
        this.cache().assign(4, 40L);
        Assertions.assertEquals((long)30L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 30L, 59L, 20L, 49L), (String)"False negative when divergence at first matching epoch but it is not the first local epoch");
        this.cache().clearAndFlush();
        this.cache().assign(2, 20L);
        this.cache().assign(3, 25L);
        this.cache().assign(4, 40L);
        Assertions.assertEquals((long)25L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 30L, 59L, 20L, 49L), (String)"False negative when divergence at first matching epoch but it is not the first local epoch");
        tieredEpochState = Arrays.asList(new EpochEntry(5, 50L), new EpochEntry(6, 60L), new EpochEntry(7, 70L));
        this.cache().clearAndFlush();
        this.cache().assign(2, 60L);
        this.cache().assign(3, 70L);
        this.cache().assign(4, 80L);
        Assertions.assertEquals((long)60L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 50L, 79L, 60L, 89L), (String)"False negative when offsets at tieredEpochState and localCache do not increase monotonically");
        tieredEpochState = Arrays.asList(new EpochEntry(1, 100L), new EpochEntry(2, 150L));
        this.cache().clearAndFlush();
        this.cache().assign(1, 100L);
        Assertions.assertEquals((long)150L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 100L, 179L, 100L, 199L), (String)"False negative when localCache is missing an epoch but the corresponding offsets are written to by a different epoch");
        tieredEpochState = Arrays.asList(new EpochEntry(0, 0L), new EpochEntry(1, 100L));
        this.cache().clearAndFlush();
        this.cache().assign(0, 50L);
        this.cache().assign(1, 75L);
        Assertions.assertEquals((long)75L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 199L, 50L, 199L), (String)"False negative when end offset for start epoch mismatches");
        tieredEpochState = Arrays.asList(new EpochEntry(0, 0L), new EpochEntry(1, 100L));
        this.cache().clearAndFlush();
        this.cache().assign(0, 0L);
        Assertions.assertEquals((long)100L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 149L, 0L, 149L), (String)"False negative when end offset for an epoch mismatches");
        tieredEpochState = Arrays.asList(new EpochEntry(0, 0L));
        this.cache().clearAndFlush();
        this.cache().assign(0, 0L);
        this.cache().assign(1, 50L);
        Assertions.assertEquals((long)50L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 99L, 0L, 199L), (String)"False negative when end offset for an epoch mismatches");
    }

    @Test
    public void shouldContinueWriteToCacheOnDiskPause() {
        TopicPartition tp = new TopicPartition("TestTopic", 5);
        LeaderEpochCheckpoint pausedDiskCheckpoint = new LeaderEpochCheckpoint(null){
            private Seq<EpochEntry> epochs;
            private final File file;

            private Seq<EpochEntry> epochs() {
                return this.epochs;
            }

            private void epochs_$eq(Seq<EpochEntry> x$1) {
                this.epochs = x$1;
            }

            public File file() {
                return this.file;
            }

            public void write(Collection<EpochEntry> epochs) {
                Thread.sleep(100L);
                this.epochs_$eq((Seq<EpochEntry>)CollectionConverters$.MODULE$.CollectionHasAsScala(epochs).asScala().toSeq());
            }

            public byte[] toByteArray(java.util.List<EpochEntry> epochs) {
                throw new UnsupportedOperationException("toByteArray is currently unused and is not implemented for the test checkpoint implementation");
            }

            public java.util.List<EpochEntry> read() {
                return CollectionConverters$.MODULE$.SeqHasAsJava(this.epochs()).asJava();
            }
            {
                this.epochs = (Seq)Seq$.MODULE$.empty();
                this.file = TestUtils.tempFile((String)"kafka", (String)".tmp");
            }
        };
        LeaderEpochFileCache cache = new LeaderEpochFileCache(tp, pausedDiskCheckpoint);
        cache.assign(1, 10L);
        cache.assign(2, 20L);
        cache.assign(3, 30L);
        ExecutionContextExecutor ec = ExecutionContext$.MODULE$.fromExecutor((Executor)Executors.newFixedThreadPool(3));
        Future maybeFlushTask = Future$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            long tBefore = System.currentTimeMillis();
            cache.maybeFlush();
            return System.currentTimeMillis() - tBefore < 100L;
        }, (ExecutionContext)ec);
        Future assignTask = Future$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            long tBefore = System.currentTimeMillis();
            cache.assign(4, 40L);
            return System.currentTimeMillis() - tBefore < 100L;
        }, (ExecutionContext)ec);
        Future endOffsetForEpochTask = Future$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            long tBefore = System.currentTimeMillis();
            cache.endOffsetFor(3, 50L);
            return System.currentTimeMillis() - tBefore < 100L;
        }, (ExecutionContext)ec);
        Future tasks = Future$.MODULE$.sequence((IterableOnce)new .colon.colon((Object)maybeFlushTask, (List)new .colon.colon((Object)assignTask, (List)new .colon.colon((Object)endOffsetForEpochTask, (List)Nil$.MODULE$))), BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)ec);
        Seq res = (Seq)Await$.MODULE$.result((Awaitable)tasks, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true, true})), (Object)res);
    }

    public void testFindPreviousEpoch() {
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().previousEpoch(2));
        this.cache().assign(2, 10L);
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().previousEpoch(2));
        this.cache().assign(4, 15L);
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().previousEpoch(4));
        this.cache().assign(10, 20L);
        Assertions.assertEquals((Object)OptionalInt.of(4), (Object)this.cache().previousEpoch(10));
        this.cache().truncateFromEnd(18L);
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().previousEpoch(this.cache().latestEpoch().getAsInt()));
    }

    @Test
    public void testFindNextEpoch() {
        this.cache().assign(0, 0L);
        this.cache().assign(1, 100L);
        this.cache().assign(2, 200L);
        Assertions.assertEquals((Object)OptionalInt.of(0), (Object)this.cache().nextEpoch(-1));
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)this.cache().nextEpoch(0));
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().nextEpoch(1));
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().nextEpoch(2));
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().nextEpoch(100));
    }

    @Test
    public void testGetEpochEntry() {
        this.cache().assign(2, 100L);
        this.cache().assign(3, 500L);
        this.cache().assign(5, 1000L);
        Assertions.assertEquals((Object)new EpochEntry(2, 100L), this.cache().epochEntry(2).get());
        Assertions.assertEquals((Object)new EpochEntry(3, 500L), this.cache().epochEntry(3).get());
        Assertions.assertEquals((Object)new EpochEntry(5, 1000L), this.cache().epochEntry(5).get());
    }

    @Test
    public void shouldFetchEpochForGivenOffset() {
        this.cache().assign(0, 10L);
        this.cache().assign(1, 20L);
        this.cache().assign(5, 30L);
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)this.cache().epochForOffset(25L));
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)this.cache().epochForOffset(20L));
        Assertions.assertEquals((Object)OptionalInt.of(5), (Object)this.cache().epochForOffset(30L));
        Assertions.assertEquals((Object)OptionalInt.of(5), (Object)this.cache().epochForOffset(50L));
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().epochForOffset(5L));
    }
}

