/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.server.ConfigHelper;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.ZkAdminManager$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.ZkConfigRepository;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.DescribeConfigsRequestData;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ma\u0001\u0002\u000b\u0016\u0001iAQ!\t\u0001\u0005\u0002\tBq!\n\u0001C\u0002\u0013%a\u0005\u0003\u0004.\u0001\u0001\u0006Ia\n\u0005\b]\u0001\u0011\r\u0011\"\u00030\u0011\u0019a\u0004\u0001)A\u0005a!9Q\b\u0001b\u0001\n\u0013q\u0004B\u0002\"\u0001A\u0003%q\bC\u0004D\u0001\t\u0007I\u0011\u0002#\t\r5\u0003\u0001\u0015!\u0003F\u0011\u001dq\u0005A1A\u0005\n=Caa\u0015\u0001!\u0002\u0013\u0001\u0006\"\u0002+\u0001\t\u0003)\u0006\"\u00023\u0001\t\u0003)\u0007\"B6\u0001\t\u0003)\u0006\"\u00029\u0001\t\u0003)\u0006\"\u0002:\u0001\t\u0003)\u0006\"\u0002;\u0001\t\u0003)\u0006\"\u0002<\u0001\t\u0003)\u0006\"\u0002=\u0001\t\u0013I(A\u0005.l\u0003\u0012l\u0017N\\'b]\u0006<WM\u001d+fgRT!AF\f\u0002\rM,'O^3s\u0015\u0005A\u0012!B6bM.\f7\u0001A\n\u0003\u0001m\u0001\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001$!\t!\u0003!D\u0001\u0016\u0003!Q8n\u00117jK:$X#A\u0014\u0011\u0005!ZS\"A\u0015\u000b\u0005):\u0012A\u0001>l\u0013\ta\u0013FA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001\nu.\u001cE.[3oi\u0002\nq!\\3ue&\u001c7/F\u00011!\t\t$(D\u00013\u0015\tq3G\u0003\u00025k\u000511m\\7n_:T!\u0001\u0007\u001c\u000b\u0005]B\u0014AB1qC\u000eDWMC\u0001:\u0003\ry'oZ\u0005\u0003wI\u0012q!T3ue&\u001c7/\u0001\u0005nKR\u0014\u0018nY:!\u0003!\u0011'o\\6fe&#W#A \u0011\u0005q\u0001\u0015BA!\u001e\u0005\rIe\u000e^\u0001\nEJ|7.\u001a:JI\u0002\nQ\u0001^8qS\u000e,\u0012!\u0012\t\u0003\r.k\u0011a\u0012\u0006\u0003\u0011&\u000bA\u0001\\1oO*\t!*\u0001\u0003kCZ\f\u0017B\u0001'H\u0005\u0019\u0019FO]5oO\u00061Ao\u001c9jG\u0002\nQ\"\\3uC\u0012\fG/Y\"bG\",W#\u0001)\u0011\u0005\u0011\n\u0016B\u0001*\u0016\u00055iU\r^1eCR\f7)Y2iK\u0006qQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004\u0013\u0001\u0003;fCJ$un\u001e8\u0015\u0003Y\u0003\"\u0001H,\n\u0005ak\"\u0001B+oSRD#\u0001\u0004.\u0011\u0005m\u0013W\"\u0001/\u000b\u0005us\u0016aA1qS*\u0011q\fY\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\t\u0007(A\u0003kk:LG/\u0003\u0002d9\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0013GJ,\u0017\r^3D_:4\u0017n\u001a%fYB,'\u000fF\u0002gS*\u0004\"\u0001J4\n\u0005!,\"\u0001D\"p]\u001aLw\rS3ma\u0016\u0014\b\"\u0002(\u000e\u0001\u0004\u0001\u0006\"B\u0013\u000e\u0001\u00049\u0013a\u0006;fgR\u001cE.[3oiF+x\u000e^1t)>\u0004&o\u001c9tQ\tqQ\u000e\u0005\u0002\\]&\u0011q\u000e\u0018\u0002\u0005)\u0016\u001cH/\u0001\u0017uKN$H)Z:de&\u0014WmQ8oM&<7oV5uQ:+H\u000e\\\"p]\u001aLw-\u001e:bi&|gnS3zg\"\u0012q\"\\\u0001.i\u0016\u001cH\u000fR3tGJL'-Z\"p]\u001aLwm],ji\",U\u000e\u001d;z\u0007>tg-[4ve\u0006$\u0018n\u001c8LKf\u001c\bF\u0001\tn\u0003!\"Xm\u001d;EKN\u001c'/\u001b2f\u0007>tg-[4t/&$\bnQ8oM&<WO]1uS>t7*Z=tQ\t\tR.\u0001\u0013uKN$H)Z:de&\u0014WmQ8oM&<7oV5uQ\u0012{7-^7f]R\fG/[8oQ\t\u0011R.A\u0007jO:|'/\u001a3D_:4\u0017n\u001a\u000b\u0003uv\u0004\"\u0001H>\n\u0005ql\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006}N\u0001\ra`\u0001\u0005]\u0006lW\r\u0005\u0003\u0002\u0002\u0005=a\u0002BA\u0002\u0003\u0017\u00012!!\u0002\u001e\u001b\t\t9AC\u0002\u0002\ne\ta\u0001\u0010:p_Rt\u0014bAA\u0007;\u00051\u0001K]3eK\u001aL1\u0001TA\t\u0015\r\ti!\b")
public class ZkAdminManagerTest {
    private final KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
    private final Metrics metrics = new Metrics();
    private final int brokerId;
    private final String topic;
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);

    private KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private String topic() {
        return this.topic;
    }

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    @AfterEach
    public void tearDown() {
        this.metrics().close();
    }

    public ConfigHelper createConfigHelper(MetadataCache metadataCache, KafkaZkClient zkClient) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zk", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        return new ConfigHelper(metadataCache, KafkaConfig$.MODULE$.fromProps(props), (ConfigRepository)new ZkConfigRepository(new AdminZkClient(zkClient)), (Option)None$.MODULE$, (ClusterLinkFactory.LinkManager)Mockito.mock(ClusterLinkFactory.LinkManager.class));
    }

    @Test
    public void testClientQuotasToProps() {
        Map emptyProps = ZkAdminManager$.MODULE$.clientQuotaPropsToDoubleMap((Map)Predef$.MODULE$.Map().empty());
        Assertions.assertEquals((int)0, (int)emptyProps.size());
        Map oneProp = ZkAdminManager$.MODULE$.clientQuotaPropsToDoubleMap((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"1234")})));
        Assertions.assertEquals((int)1, (int)oneProp.size());
        Assertions.assertEquals((double)1234.0, (double)BoxesRunTime.unboxToDouble((Object)oneProp.apply((Object)"foo")));
        Map emptyKey = ZkAdminManager$.MODULE$.clientQuotaPropsToDoubleMap((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)"-42.1")})));
        Assertions.assertEquals((int)1, (int)emptyKey.size());
        Assertions.assertEquals((double)-42.1, (double)BoxesRunTime.unboxToDouble((Object)emptyKey.apply((Object)"")));
        Map manyProps = ZkAdminManager$.MODULE$.clientQuotaPropsToDoubleMap((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"1234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spam"), (Object)"-1234.56")})));
        Assertions.assertEquals((int)3, (int)manyProps.size());
        Assertions.assertThrows(NullPointerException.class, () -> ZkAdminManager$.MODULE$.clientQuotaPropsToDoubleMap((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), null)}))));
        Assertions.assertThrows(IllegalStateException.class, () -> ZkAdminManager$.MODULE$.clientQuotaPropsToDoubleMap((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"bar")}))));
        Assertions.assertThrows(IllegalStateException.class, () -> ZkAdminManager$.MODULE$.clientQuotaPropsToDoubleMap((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"")}))));
    }

    @Test
    public void testDescribeConfigsWithNullConfigurationKeys() {
        Mockito.when((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic())).thenReturn((Object)TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zk", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataCache().contains(this.topic()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        .colon.colon resources = new .colon.colon((Object)new DescribeConfigsRequestData.DescribeConfigsResource().setResourceName(this.topic()).setResourceType(ConfigResource.Type.TOPIC.id()).setConfigurationKeys(null), (List)Nil$.MODULE$);
        List results = this.createConfigHelper(this.metadataCache(), this.zkClient()).describeConfigs((List)resources, true, KafkaPrincipal.ANONYMOUS, true);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((DescribeConfigsResponseData.DescribeConfigsResult)results.head()).errorCode());
        Assertions.assertFalse((boolean)((DescribeConfigsResponseData.DescribeConfigsResult)results.head()).configs().isEmpty(), (String)"Should return configs");
    }

    @Test
    public void testDescribeConfigsWithEmptyConfigurationKeys() {
        Mockito.when((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic())).thenReturn((Object)TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zk", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataCache().contains(this.topic()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        .colon.colon resources = new .colon.colon((Object)new DescribeConfigsRequestData.DescribeConfigsResource().setResourceName(this.topic()).setResourceType(ConfigResource.Type.TOPIC.id()), (List)Nil$.MODULE$);
        List results = this.createConfigHelper(this.metadataCache(), this.zkClient()).describeConfigs((List)resources, true, KafkaPrincipal.ANONYMOUS, true);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((DescribeConfigsResponseData.DescribeConfigsResult)results.head()).errorCode());
        Assertions.assertFalse((boolean)((DescribeConfigsResponseData.DescribeConfigsResult)results.head()).configs().isEmpty(), (String)"Should return configs");
    }

    @Test
    public void testDescribeConfigsWithConfigurationKeys() {
        Mockito.when((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic())).thenReturn((Object)TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zk", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataCache().contains(this.topic()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        .colon.colon resources = new .colon.colon((Object)new DescribeConfigsRequestData.DescribeConfigsResource().setResourceName(this.topic()).setResourceType(ConfigResource.Type.TOPIC.id()).setConfigurationKeys(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"retention.ms", (List)new .colon.colon((Object)"retention.bytes", (List)new .colon.colon((Object)"segment.bytes", (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$);
        List results = this.createConfigHelper(this.metadataCache(), this.zkClient()).describeConfigs((List)resources, true, KafkaPrincipal.ANONYMOUS, true);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((DescribeConfigsResponseData.DescribeConfigsResult)results.head()).errorCode());
        Set resultConfigKeys = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(((DescribeConfigsResponseData.DescribeConfigsResult)results.head()).configs()).asScala().map((Function1 & Serializable)r -> r.name())).toSet();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"retention.ms", "retention.bytes", "segment.bytes"})), (Object)resultConfigKeys);
    }

    @Test
    public void testDescribeConfigsWithDocumentation() {
        Mockito.when((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic())).thenReturn((Object)new Properties());
        Mockito.when((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Broker(), Integer.toString(this.brokerId()))).thenReturn((Object)new Properties());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataCache().contains(this.topic()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        ConfigHelper configHelper = this.createConfigHelper(this.metadataCache(), this.zkClient());
        .colon.colon resources = new .colon.colon((Object)new DescribeConfigsRequestData.DescribeConfigsResource().setResourceName(this.topic()).setResourceType(ConfigResource.Type.TOPIC.id()), (List)new .colon.colon((Object)new DescribeConfigsRequestData.DescribeConfigsResource().setResourceName(Integer.toString(this.brokerId())).setResourceType(ConfigResource.Type.BROKER.id()), (List)Nil$.MODULE$));
        List results = configHelper.describeConfigs((List)resources, true, KafkaPrincipal.ANONYMOUS, true);
        Assertions.assertEquals((int)2, (int)results.size());
        results.foreach((Function1 & Serializable)r -> {
            ZkAdminManagerTest.$anonfun$testDescribeConfigsWithDocumentation$1(this, r);
            return BoxedUnit.UNIT;
        });
    }

    private boolean ignoredConfig(String name) {
        return name.equals("confluent.license.topic.replication.factor");
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeConfigsWithDocumentation$2(ZkAdminManagerTest $this, DescribeConfigsResponseData.DescribeConfigsResourceResult c) {
        return !c.name().equals("confluent.license.topic.replication.factor");
    }

    public static final /* synthetic */ void $anonfun$testDescribeConfigsWithDocumentation$3(DescribeConfigsResponseData.DescribeConfigsResourceResult c) {
        Assertions.assertNotNull((Object)c.documentation(), (String)new StringBuilder(42).append("Config ").append(c.name()).append(" should have non null documentation").toString());
        Assertions.assertNotEquals((Object)new StringBuilder(43).append("Config ").append(c.name()).append(" should have non blank documentation").toString(), (Object)"", (String)c.documentation().trim());
    }

    public static final /* synthetic */ void $anonfun$testDescribeConfigsWithDocumentation$1(ZkAdminManagerTest $this, DescribeConfigsResponseData.DescribeConfigsResult r) {
        Assertions.assertEquals((short)Errors.NONE.code(), (short)r.errorCode());
        Assertions.assertFalse((boolean)r.configs().isEmpty(), (String)"Should return configs");
        ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(r.configs()).asScala().filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)ZkAdminManagerTest.$anonfun$testDescribeConfigsWithDocumentation$2($this, c)))).foreach((Function1 & Serializable)c -> {
            ZkAdminManagerTest.$anonfun$testDescribeConfigsWithDocumentation$3(c);
            return BoxedUnit.UNIT;
        });
    }

    public ZkAdminManagerTest() {
        this.brokerId = 1;
        this.topic = "topic-1";
    }
}

