/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.Defaults$;
import kafka.server.QuotaType;
import kafka.server.ThrottleCallback;
import kafka.server.ThrottledChannel;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005%4A!\u0005\n\u0001/!)a\u0004\u0001C\u0001?!9!\u0005\u0001b\u0001\n\u0013\u0019\u0003BB\u0019\u0001A\u0003%A\u0005C\u00043\u0001\u0001\u0007I\u0011B\u001a\t\u000f]\u0002\u0001\u0019!C\u0005q!1a\b\u0001Q!\nQBqa\u0010\u0001A\u0002\u0013%1\u0007C\u0004A\u0001\u0001\u0007I\u0011B!\t\r\r\u0003\u0001\u0015)\u00035\u0011\u001d!\u0005A1A\u0005\n\u0015Caa\u0013\u0001!\u0002\u00131\u0005b\u0002'\u0001\u0005\u0004%I!\u0014\u0005\u0007#\u0002\u0001\u000b\u0011\u0002(\t\u000bU\u0003A\u0011\u0001,\t\u000b\t\u0004A\u0011\u0001,\t\u000b\u001d\u0004A\u0011\u0001,\u0003=QC'o\u001c;uY\u0016$7\t[1o]\u0016dW\t\u001f9je\u0006$\u0018n\u001c8UKN$(BA\n\u0015\u0003\u0019\u0019XM\u001d<fe*\tQ#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002AA\u0011\u0011\u0005A\u0007\u0002%\u0005!A/[7f+\u0005!\u0003CA\u00130\u001b\u00051#BA\u0014)\u0003\u0015)H/\u001b7t\u0015\tI#&\u0001\u0004d_6lwN\u001c\u0006\u0003+-R!\u0001L\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0013aA8sO&\u0011\u0001G\n\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005qb.^7DC2d'-Y2lg\u001a{'o\u0015;beR$\u0006N]8ui2LgnZ\u000b\u0002iA\u0011\u0011$N\u0005\u0003mi\u00111!\u00138u\u0003\trW/\\\"bY2\u0014\u0017mY6t\r>\u00148\u000b^1siRC'o\u001c;uY&twm\u0018\u0013fcR\u0011\u0011\b\u0010\t\u00033iJ!a\u000f\u000e\u0003\tUs\u0017\u000e\u001e\u0005\b{\u0015\t\t\u00111\u00015\u0003\rAH%M\u0001 ]Vl7)\u00197mE\u0006\u001c7n\u001d$peN#\u0018M\u001d;UQJ|G\u000f\u001e7j]\u001e\u0004\u0013\u0001\b8v[\u000e\u000bG\u000e\u001c2bG.\u001chi\u001c:F]\u0012$\u0006N]8ui2LgnZ\u0001!]Vl7)\u00197mE\u0006\u001c7n\u001d$pe\u0016sG\r\u00165s_R$H.\u001b8h?\u0012*\u0017\u000f\u0006\u0002:\u0005\"9Q\bCA\u0001\u0002\u0004!\u0014!\b8v[\u000e\u000bG\u000e\u001c2bG.\u001chi\u001c:F]\u0012$\u0006N]8ui2Lgn\u001a\u0011\u0002\u000f5,GO]5dgV\ta\t\u0005\u0002H\u00136\t\u0001J\u0003\u0002EQ%\u0011!\n\u0013\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013\u0001C2bY2\u0014\u0017mY6\u0016\u00039\u00132a\u0014\rS\r\u0011\u0001V\u0002\u0001(\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0002\u0013\r\fG\u000e\u001c2bG.\u0004\u0003CA\u0011T\u0013\t!&C\u0001\tUQJ|G\u000f\u001e7f\u0007\u0006dGNY1dW\u0006a!-\u001a4pe\u0016lU\r\u001e5pIR\t\u0011\b\u000b\u0002\u000f1B\u0011\u0011\fY\u0007\u00025*\u00111\fX\u0001\u0004CBL'BA/_\u0003\u001dQW\u000f]5uKJT!aX\u0017\u0002\u000b),h.\u001b;\n\u0005\u0005T&A\u0003\"fM>\u0014X-R1dQ\u0006)C/Z:u\u0007\u0006dGNY1dW&sgo\\2bi&|g.\u00114uKJ,\u0005\u0010]5sCRLwN\u001c\u0015\u0003\u001f\u0011\u0004\"!W3\n\u0005\u0019T&\u0001\u0002+fgR\f\u0011\u0004^3tiRC'o\u001c;uY\u0016$7\t[1o]\u0016dG)\u001a7bs\"\u0012\u0001\u0003\u001a")
public class ThrottledChannelExpirationTest {
    private final MockTime time = new MockTime();
    private int kafka$server$ThrottledChannelExpirationTest$$numCallbacksForStartThrottling = 0;
    private int kafka$server$ThrottledChannelExpirationTest$$numCallbacksForEndThrottling = 0;
    private final Metrics metrics = new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.time());
    private final ThrottleCallback callback = new ThrottleCallback(this){
        private final /* synthetic */ ThrottledChannelExpirationTest $outer;

        public void startThrottling() {
            this.$outer.kafka$server$ThrottledChannelExpirationTest$$numCallbacksForStartThrottling_$eq(this.$outer.kafka$server$ThrottledChannelExpirationTest$$numCallbacksForStartThrottling() + 1);
        }

        public void endThrottling() {
            this.$outer.kafka$server$ThrottledChannelExpirationTest$$numCallbacksForEndThrottling_$eq(this.$outer.kafka$server$ThrottledChannelExpirationTest$$numCallbacksForEndThrottling() + 1);
        }
        {
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    };

    private MockTime time() {
        return this.time;
    }

    public int kafka$server$ThrottledChannelExpirationTest$$numCallbacksForStartThrottling() {
        return this.kafka$server$ThrottledChannelExpirationTest$$numCallbacksForStartThrottling;
    }

    public void kafka$server$ThrottledChannelExpirationTest$$numCallbacksForStartThrottling_$eq(int x$1) {
        this.kafka$server$ThrottledChannelExpirationTest$$numCallbacksForStartThrottling = x$1;
    }

    public int kafka$server$ThrottledChannelExpirationTest$$numCallbacksForEndThrottling() {
        return this.kafka$server$ThrottledChannelExpirationTest$$numCallbacksForEndThrottling;
    }

    public void kafka$server$ThrottledChannelExpirationTest$$numCallbacksForEndThrottling_$eq(int x$1) {
        this.kafka$server$ThrottledChannelExpirationTest$$numCallbacksForEndThrottling = x$1;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private ThrottleCallback callback() {
        return this.callback;
    }

    @BeforeEach
    public void beforeMethod() {
        this.kafka$server$ThrottledChannelExpirationTest$$numCallbacksForStartThrottling_$eq(0);
        this.kafka$server$ThrottledChannelExpirationTest$$numCallbacksForEndThrottling_$eq(0);
    }

    @Test
    public void testCallbackInvocationAfterExpiration() {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(new ClientQuotaManagerConfig(Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L, 0), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        DelayQueue<ThrottledChannel> delayQueue = new DelayQueue<ThrottledChannel>();
        ClientQuotaManager.ThrottledChannelReaper reaper = new ClientQuotaManager.ThrottledChannelReaper(clientMetrics, delayQueue, "");
        try {
            ThrottledChannel channel1 = new ThrottledChannel((Time)this.time(), 10, this.callback());
            ThrottledChannel channel2 = new ThrottledChannel((Time)this.time(), 30, this.callback());
            ThrottledChannel channel3 = new ThrottledChannel((Time)this.time(), 30, this.callback());
            ThrottledChannel channel4 = new ThrottledChannel((Time)this.time(), 20, this.callback());
            delayQueue.add(channel1);
            delayQueue.add(channel2);
            delayQueue.add(channel3);
            delayQueue.add(channel4);
            Assertions.assertEquals((int)4, (int)this.kafka$server$ThrottledChannelExpirationTest$$numCallbacksForStartThrottling());
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)itr -> {
                this.time().sleep(10L);
                reaper.doWork();
                Assertions.assertEquals((int)itr, (int)this.kafka$server$ThrottledChannelExpirationTest$$numCallbacksForEndThrottling());
            });
            reaper.doWork();
            Assertions.assertEquals((int)4, (int)this.kafka$server$ThrottledChannelExpirationTest$$numCallbacksForEndThrottling());
            Assertions.assertEquals((int)0, (int)delayQueue.size());
            reaper.doWork();
            Assertions.assertEquals((int)4, (int)this.kafka$server$ThrottledChannelExpirationTest$$numCallbacksForEndThrottling());
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    @Test
    public void testThrottledChannelDelay() {
        ThrottledChannel t1 = new ThrottledChannel((Time)this.time(), 10, this.callback());
        ThrottledChannel t2 = new ThrottledChannel((Time)this.time(), 20, this.callback());
        ThrottledChannel t3 = new ThrottledChannel((Time)this.time(), 20, this.callback());
        Assertions.assertEquals((int)10, (int)t1.throttleTimeMs());
        Assertions.assertEquals((int)20, (int)t2.throttleTimeMs());
        Assertions.assertEquals((int)20, (int)t3.throttleTimeMs());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)itr -> {
            Assertions.assertEquals((long)(10 - 10 * itr), (long)t1.getDelay(TimeUnit.MILLISECONDS));
            Assertions.assertEquals((long)(20 - 10 * itr), (long)t2.getDelay(TimeUnit.MILLISECONDS));
            Assertions.assertEquals((long)(20 - 10 * itr), (long)t3.getDelay(TimeUnit.MILLISECONDS));
            this.time().sleep(10L);
        });
    }
}

