/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.server.ConfigType$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\u0005ec\u0001B\u0010!\u0001\u0015BQ\u0001\f\u0001\u0005\u00025Bq\u0001\r\u0001C\u0002\u0013%\u0011\u0007\u0003\u00049\u0001\u0001\u0006IA\r\u0005\bs\u0001\u0011\r\u0011\"\u0003;\u0011\u0019\u0019\u0005\u0001)A\u0005w!9A\t\u0001b\u0001\n\u0013)\u0005BB)\u0001A\u0003%a\tC\u0004S\u0001\t\u0007I\u0011\u0002\u001e\t\rM\u0003\u0001\u0015!\u0003<\u0011\u001d!\u0006A1A\u0005\niBa!\u0016\u0001!\u0002\u0013Y\u0004b\u0002,\u0001\u0005\u0004%IA\u000f\u0005\u0007/\u0002\u0001\u000b\u0011B\u001e\t\u000fa\u0003!\u0019!C\u00053\"1A\r\u0001Q\u0001\niCq!\u001a\u0001C\u0002\u0013%\u0011\u0007\u0003\u0004g\u0001\u0001\u0006IA\r\u0005\bO\u0002\u0011\r\u0011\"\u00032\u0011\u0019A\u0007\u0001)A\u0005e!)\u0011\u000e\u0001C)c!)!\u000e\u0001C!W\")a\u0010\u0001C\u0001\u007f\"1\u0011\u0011\u0002\u0001\u0005\u0002}Da!!\u0004\u0001\t\u0003y\bBBA\t\u0001\u0011\u0005q\u0010\u0003\u0004\u0002\u0016\u0001!\ta \u0005\b\u00033\u0001A\u0011BA\u000e\u0011\u001d\t)\u0003\u0001C\u0005\u0003OAq!a\u000e\u0001\t\u0013\tI\u0004C\u0004\u0002J\u0001!I!a\u0013\u0003;M#(/Y=QCJ$\u0018\u000e^5p]&sG/Z4sCRLwN\u001c+fgRT!!\t\u0012\u0002\rM,'O^3s\u0015\u0005\u0019\u0013!B6bM.\f7\u0001A\n\u0003\u0001\u0019\u0002\"a\n\u0016\u000e\u0003!R!!\u000b\u0012\u0002\u0007\u0005\u0004\u0018.\u0003\u0002,Q\t1\u0012J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002]A\u0011q\u0006A\u0007\u0002A\u0005Qa.^7Ce>\\WM]:\u0016\u0003I\u0002\"a\r\u001c\u000e\u0003QR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\u00121!\u00138u\u0003-qW/\u001c\"s_.,'o\u001d\u0011\u0002\u000bQ|\u0007/[2\u0016\u0003m\u0002\"\u0001P!\u000e\u0003uR!AP \u0002\t1\fgn\u001a\u0006\u0002\u0001\u0006!!.\u0019<b\u0013\t\u0011UH\u0001\u0004TiJLgnZ\u0001\u0007i>\u0004\u0018n\u0019\u0011\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\ta\t\u0005\u0002H\u001f6\t\u0001J\u0003\u0002J\u0015\u000611m\\7n_:T!aI&\u000b\u00051k\u0015AB1qC\u000eDWMC\u0001O\u0003\ry'oZ\u0005\u0003!\"\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\bu_BL7\rU1si&$\u0018n\u001c8!\u000311\u0018\r\\5e)>\u0004\u0018nY02\u000351\u0018\r\\5e)>\u0004\u0018nY02A\u0005aa/\u00197jIR{\u0007/[2`e\u0005ia/\u00197jIR{\u0007/[2`e\u0001\nAb\u001d;sCf$v\u000e]5d?F\nQb\u001d;sCf$v\u000e]5d?F\u0002\u0013\u0001D:ue\u0006LHk\u001c9jG~\u0013T#\u0001.\u0011\u0005m\u0013gB\u0001/a!\tiF'D\u0001_\u0015\tyF%\u0001\u0004=e>|GOP\u0005\u0003CR\na\u0001\u0015:fI\u00164\u0017B\u0001\"d\u0015\t\tG'A\u0007tiJ\f\u0017\u0010V8qS\u000e|&\u0007I\u0001\u0012e\u0016\u0004H.[2bi&|gNR1di>\u0014\u0018A\u0005:fa2L7-\u0019;j_:4\u0015m\u0019;pe\u0002\nQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\u0018A\u00048v[B\u000b'\u000f^5uS>t7\u000fI\u0001\fEJ|7.\u001a:D_VtG/A\u0003tKR,\u0006\u000f\u0006\u0002m_B\u00111'\\\u0005\u0003]R\u0012A!\u00168ji\")\u0001/\u0006a\u0001c\u0006AA/Z:u\u0013:4w\u000e\u0005\u0002sq6\t1O\u0003\u0002*i*\u0011QO^\u0001\bUV\u0004\u0018\u000e^3s\u0015\t9X*A\u0003kk:LG/\u0003\u0002zg\nAA+Z:u\u0013:4w\u000e\u000b\u0002\u0016wB\u0011!\u000f`\u0005\u0003{N\u0014!BQ3g_J,W)Y2i\u0003%\"Xm\u001d;TiJ\f\u0017\u0010U1si&$\u0018n\u001c8EK2,G/[8o\u001f:\u0014%o\\6feJ+7\u000f^1siR\tA\u000eK\u0002\u0017\u0003\u0007\u00012A]A\u0003\u0013\r\t9a\u001d\u0002\u0005)\u0016\u001cH/A\u0015uKN$8\u000b\u001e:bsB\u000b'\u000f^5uS>tG)\u001a7fi&|gn\u00148Ce>\\WM]*uCJ$X\u000f\u001d\u0015\u0004/\u0005\r\u0011A\f;fgR\u001cFO]1z!\u0006\u0014H/\u001b;j_:$U\r\\3uS>twJ\\\"p]R\u0014x\u000e\u001c7fe\u001a\u000b\u0017\u000e\\8wKJD3\u0001GA\u0002\u0003\u001d\"Xm\u001d;QCJ$\u0018\u000e^5p]:{Go\u0015;sCf$UO]5oOJ+\u0017m]:jO:lWM\u001c;)\u0007e\t\u0019!\u0001 uKN$8\u000b\u001e:bsB\u000b'\u000f^5uS>tG)\u001a;fGRLwN\\(o\u0005J|7.\u001a:Ti\u0006\u0014H/\u001e9XSRDG)\u001a7fi&|g\u000eR5tC\ndW\r\u001a\u0015\u00045\u0005\r\u0011A\u0006<fe&4\u0017p\u0015;sCfdun\u001a#fY\u0016$\u0018n\u001c8\u0015\u00071\fi\u0002\u0003\u0004\"7\u0001\u0007\u0011q\u0004\t\u0004_\u0005\u0005\u0012bAA\u0012A\tY1*\u00194lCN+'O^3s\u00035\u0019'/Z1uKN+w-\\3oiR\u0019A.!\u000b\t\u000f\u0005-B\u00041\u0001\u0002.\u0005\u0019An\\4\u0011\t\u0005=\u00121G\u0007\u0003\u0003cQ1!a\u000b#\u0013\u0011\t)$!\r\u0003\u0017\u0005\u00137\u000f\u001e:bGRdunZ\u0001\u001cm\u0016\u0014\u0018NZ=TiJ\f\u0017\u0010U1si&$\u0018n\u001c8NKR\u0014\u0018nY:\u0015\u000b1\fY$a\u0010\t\r\u0005uR\u00041\u00013\u0003M\u0019HO]1z!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u\u0011\u001d\t\t%\ba\u0001\u0003\u0007\nqc\u001d;sCf\u0004\u0016M\u001d;ji&|g\u000eV8uC2\u001c\u0016N_3\u0011\u0007M\n)%C\u0002\u0002HQ\u0012A\u0001T8oO\u00061An\\4PaR$b!!\u0014\u0002T\u0005]\u0003#B\u001a\u0002P\u00055\u0012bAA)i\t1q\n\u001d;j_:Da!!\u0016\u001f\u0001\u0004\u0011\u0014A\u00022s_.,'\u000fC\u0003E=\u0001\u0007a\t")
public class StrayPartitionIntegrationTest
extends IntegrationTestHarness {
    private final int numBrokers;
    private final String topic;
    private final TopicPartition topicPartition = new TopicPartition(this.topic(), 0);
    private final String validTopic_1;
    private final String validTopic_2;
    private final String strayTopic_1;
    private final String strayTopic_2 = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("a"), 253);
    private final int replicationFactor;
    private final int numPartitions;

    private int numBrokers() {
        return this.numBrokers;
    }

    private String topic() {
        return this.topic;
    }

    private TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private String validTopic_1() {
        return this.validTopic_1;
    }

    private String validTopic_2() {
        return this.validTopic_2;
    }

    private String strayTopic_1() {
        return this.strayTopic_1;
    }

    private String strayTopic_2() {
        return this.strayTopic_2;
    }

    private int replicationFactor() {
        return this.replicationFactor;
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    @Override
    public int brokerCount() {
        return this.numBrokers();
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        String string = ((Method)testInfo.getTestMethod().get()).getName();
        String string2 = "testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled";
        if (string != null && string.equals(string2)) {
            this.serverConfig().setProperty("confluent.enable.stray.partition.deletion", "false");
        } else {
            this.serverConfig().setProperty("confluent.enable.stray.partition.deletion", "true");
        }
        String string3 = ((Method)testInfo.getTestMethod().get()).getName();
        String string4 = "testStrayPartitionDeletionOnBrokerRestart";
        if (string3 != null && string3.equals(string4)) {
            this.serverConfig().setProperty("confluent.stray.log.delete.delay.ms", "1200000");
        } else {
            this.serverConfig().setProperty("confluent.stray.log.delete.delay.ms", "5000");
        }
        super.setUp(testInfo);
    }

    @Test
    public void testStrayPartitionDeletionOnBrokerRestart() {
        this.createTopic(this.validTopic_1(), this.numPartitions(), this.replicationFactor(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(this.validTopic_2(), this.numPartitions(), this.replicationFactor(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.servers().foreach((Function1 & Serializable)server -> {
            LogManager logManager = server.logManager();
            TopicPartition x$1 = new TopicPartition(this.strayTopic_1(), Random$.MODULE$.nextInt(10));
            None$ x$2 = None$.MODULE$;
            boolean x$3 = logManager.getOrCreateLog$default$2();
            boolean x$4 = logManager.getOrCreateLog$default$3();
            logManager.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
            TopicPartition x$5 = new TopicPartition(this.strayTopic_2(), Random$.MODULE$.nextInt(10));
            None$ x$6 = None$.MODULE$;
            boolean x$7 = logManager.getOrCreateLog$default$2();
            boolean x$8 = logManager.getOrCreateLog$default$3();
            return logManager.getOrCreateLog(x$5, x$7, x$8, (Option)x$6);
        });
        this.servers().foreach((Function1 & Serializable)server -> {
            StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnBrokerRestart$2(this, server);
            return BoxedUnit.UNIT;
        });
        Properties newConfig = new Properties();
        newConfig.setProperty("confluent.stray.log.delete.delay.ms", "5000");
        Thread.sleep(3000L);
        this.servers().foreach((Function1 & Serializable)server -> {
            StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnBrokerRestart$5(this, newConfig, server);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testStrayPartitionDeletionOnBrokerStartup() {
        this.createTopic(this.validTopic_1(), this.numPartitions(), this.replicationFactor(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(this.validTopic_2(), this.numPartitions(), this.replicationFactor(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.servers().foreach((Function1 & Serializable)server -> {
            LogManager logManager = server.logManager();
            TopicPartition x$1 = new TopicPartition(this.strayTopic_1(), Random$.MODULE$.nextInt(10));
            None$ x$2 = None$.MODULE$;
            boolean x$3 = logManager.getOrCreateLog$default$2();
            boolean x$4 = logManager.getOrCreateLog$default$3();
            logManager.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
            TopicPartition x$5 = new TopicPartition(this.strayTopic_2(), Random$.MODULE$.nextInt(10));
            None$ x$6 = None$.MODULE$;
            boolean x$7 = logManager.getOrCreateLog$default$2();
            boolean x$8 = logManager.getOrCreateLog$default$3();
            return logManager.getOrCreateLog(x$5, x$7, x$8, (Option)x$6);
        });
        ObjectRef controllerServer = ObjectRef.create((Object)((KafkaServer)this.servers().last()));
        this.servers().foreach((Function1 & Serializable)server -> {
            StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnBrokerStartup$2(this, controllerServer, server);
            return BoxedUnit.UNIT;
        });
        this.killBroker(((KafkaServer)controllerServer.elem).config().brokerId());
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!((KafkaServer)controllerServer.elem).logManager().hasStrayLogsToBeDeleted()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timeout waiting stray logs queue up for deletion");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.verifyStrayLogDeletion((KafkaServer)controllerServer.elem);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testStrayPartitionDeletionOnControllerFailover() {
        this.createTopic(this.validTopic_1(), this.numPartitions(), this.replicationFactor(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(this.validTopic_2(), this.numPartitions(), this.replicationFactor(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.servers().foreach((Function1 & Serializable)server -> {
            LogManager logManager = server.logManager();
            TopicPartition x$1 = new TopicPartition(this.strayTopic_1(), Random$.MODULE$.nextInt(10));
            None$ x$2 = None$.MODULE$;
            boolean x$3 = logManager.getOrCreateLog$default$2();
            boolean x$4 = logManager.getOrCreateLog$default$3();
            logManager.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
            TopicPartition x$5 = new TopicPartition(this.strayTopic_2(), Random$.MODULE$.nextInt(10));
            None$ x$6 = None$.MODULE$;
            boolean x$7 = logManager.getOrCreateLog$default$2();
            boolean x$8 = logManager.getOrCreateLog$default$3();
            return logManager.getOrCreateLog(x$5, x$7, x$8, (Option)x$6);
        });
        this.zkClient().deleteController(((Tuple2)this.zkClient().getControllerEpoch().get())._1$mcI$sp());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnControllerFailover$2(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for controller election");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().get());
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnControllerFailover$4(this, controllerId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Timed out waiting for controller initialization");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        this.servers().foreach((Function1 & Serializable)server -> {
            this.verifyStrayLogDeletion(server);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionNotStrayDuringReassignment() {
        Properties topicConfig = new Properties();
        topicConfig.setProperty("segment.bytes", Integer.toString(100));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), (Seq<KafkaBroker>)this.servers(), topicConfig);
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"message".getBytes());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable)x$1 -> StrayPartitionIntegrationTest.$anonfun$testPartitionNotStrayDuringReassignment$1(producer, record, BoxesRunTime.unboxToInt((Object)x$1)));
        ConfluentAdmin adminClient = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());
        int newLeader = 2;
        scala.collection.immutable.Seq newReplicas = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 1}));
        NewPartitionReassignment newAssignment = new NewPartitionReassignment(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)newReplicas.map((Function1 & Serializable)x -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)x)))).asJava());
        adminClient.alterPartitionReassignments(Collections.singletonMap(this.topicPartition(), Optional.of(newAssignment))).all().get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testPartitionNotStrayDuringReassignment$3(this, newLeader)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for reassignment to initiate");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testPartitionNotStrayDuringReassignment$5(this, newLeader)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Timed out waiting for segments to roll");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        ((LogSegment)((AbstractLog)this.logOpt(newLeader, this.topicPartition()).get()).localLogSegments().head()).lastModified_$eq(System.currentTimeMillis() + 100000L);
        Iterable lastModified = (Iterable)((IterableOps)((AbstractLog)this.logOpt(newLeader, this.topicPartition()).get()).localLogSegments().dropRight(1)).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.lastModified()));
        this.killBroker(newLeader);
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable)x$3 -> StrayPartitionIntegrationTest.$anonfun$testPartitionNotStrayDuringReassignment$8(producer, record, BoxesRunTime.unboxToInt((Object)x$3)));
        this.servers().foreach((Function1 & Serializable)server -> {
            StrayPartitionIntegrationTest.$anonfun$testPartitionNotStrayDuringReassignment$9(this, server);
            return BoxedUnit.UNIT;
        });
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testPartitionNotStrayDuringReassignment$10(this, adminClient)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Timed out waiting for reassignment to complete");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs4 = 15000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testPartitionNotStrayDuringReassignment$12(this, newLeader)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)StrayPartitionIntegrationTest.$anonfun$testPartitionNotStrayDuringReassignment$14(this, newLeader));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)lastModified, (Object)((IterableOps)((AbstractLog)this.logOpt(newLeader, this.topicPartition()).get()).localLogSegments().take(lastModified.size())).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.lastModified())));
    }

    @Test
    public void testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled() {
        this.createTopic(this.validTopic_1(), 3, 3, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(this.validTopic_2(), 5, 3, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.servers().foreach((Function1 & Serializable)server -> {
            StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$1(this, server);
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable)server -> {
            StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$2(this, server);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private void verifyStrayLogDeletion(KafkaServer server) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$verifyStrayLogDeletion$2(this, server)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for stray topic deletion");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)this.numPartitions(), (int)((IterableOnceOps)StrayPartitionIntegrationTest.allLogs$2(server).filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)StrayPartitionIntegrationTest.$anonfun$verifyStrayLogDeletion$5(this, x$11)))).size());
        Assertions.assertEquals((int)this.numPartitions(), (int)((IterableOnceOps)StrayPartitionIntegrationTest.allLogs$2(server).filter((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)StrayPartitionIntegrationTest.$anonfun$verifyStrayLogDeletion$6(this, x$12)))).size());
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 60000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$verifyStrayLogDeletion$7(server)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Timed out waiting for stray log deletion");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 60000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$verifyStrayLogDeletion$9(server)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Timed out waiting for stray partitions count metric to clear");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)0L, (long)server.replicaManager().strayPartitionsTotalSize());
        this.verifyStrayPartitionMetrics(0, 0L);
    }

    /*
     * WARNING - void declaration
     */
    private void createSegment(AbstractLog log) {
        void builder_baseOffset;
        void builder_timestampType;
        long l = 0L;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        CompressionType builder_compressionType = CompressionType.NONE;
        Object var3_4 = null;
        timestampType = null;
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (byte)2, (CompressionType)builder_compressionType, (TimestampType)builder_timestampType, (long)builder_baseOffset);
        builder.append(System.currentTimeMillis(), (byte[])Array$.MODULE$.fill(3, (Function0)(JFunction0.mcB.sp & Serializable)() -> 32, (ClassTag)ClassTag$.MODULE$.Byte()), (byte[])Array$.MODULE$.fill(10, (Function0)(JFunction0.mcB.sp & Serializable)() -> 31, (ClassTag)ClassTag$.MODULE$.Byte()));
        log.appendAsLeader(builder.build(), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    private void verifyStrayPartitionMetrics(int strayPartitionCount, long strayPartitionTotalSize) {
        Assertions.assertEquals((int)strayPartitionCount, (int)BoxesRunTime.unboxToInt((Object)((Gauge)StrayPartitionIntegrationTest.replicaMetric$1("StrayPartitionsCount")).value()));
        Assertions.assertEquals((long)strayPartitionTotalSize, (long)BoxesRunTime.unboxToLong((Object)((Gauge)StrayPartitionIntegrationTest.replicaMetric$1("StrayPartitionsTotalSize")).value()));
    }

    private Option<AbstractLog> logOpt(int broker, TopicPartition topicPartition) {
        LogManager qual$1 = ((KafkaServer)this.servers().apply(broker)).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition, x$2);
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDeletionOnBrokerRestart$3(KafkaServer server$1) {
        return server$1.logManager().hasStrayLogsToBeDeleted();
    }

    public static final /* synthetic */ String $anonfun$testStrayPartitionDeletionOnBrokerRestart$4() {
        return "Timeout waiting stray logs queue up for deletion";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testStrayPartitionDeletionOnBrokerRestart$2(StrayPartitionIntegrationTest $this, KafkaServer server) {
        $this.killBroker(server.config().brokerId());
        $this.restartDeadBrokers($this.restartDeadBrokers$default$1());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnBrokerRestart$3(server)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timeout waiting stray logs queue up for deletion");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDeletionOnBrokerRestart$6(KafkaServer server$2) {
        return server$2.logManager().hasStrayLogsToBeDeleted();
    }

    public static final /* synthetic */ String $anonfun$testStrayPartitionDeletionOnBrokerRestart$7() {
        return "Timeout waiting stray logs queue up for deletion";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testStrayPartitionDeletionOnBrokerRestart$5(StrayPartitionIntegrationTest $this, Properties newConfig$1, KafkaServer server) {
        Assertions.assertTrue((boolean)server.logManager().hasStrayLogsToBeDeleted(), (String)"Stray logs were deleted early.");
        $this.killBroker(server.config().brokerId());
        $this.restartDeadBrokers($this.restartDeadBrokers$default$1());
        AdminZkClient qual$1 = server.dynamicConfigManager().adminZkClient();
        String x$9 = ConfigType$.MODULE$.Broker();
        String x$10 = Integer.toString(server.config().brokerId());
        boolean x$12 = qual$1.changeConfigs$default$4();
        qual$1.changeConfigs(x$9, x$10, newConfig$1, x$12);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 2500L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnBrokerRestart$6(server)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timeout waiting stray logs queue up for deletion");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        $this.verifyStrayLogDeletion(server);
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDeletionOnBrokerStartup$3(KafkaServer server$3) {
        return server$3.logManager().hasStrayLogsToBeDeleted();
    }

    public static final /* synthetic */ String $anonfun$testStrayPartitionDeletionOnBrokerStartup$4() {
        return "Timeout waiting stray logs queue up for deletion";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testStrayPartitionDeletionOnBrokerStartup$2(StrayPartitionIntegrationTest $this, ObjectRef controllerServer$1, KafkaServer server) {
        if (!server.kafkaController().isActive()) {
            $this.killBroker(server.config().brokerId());
            $this.restartDeadBrokers($this.restartDeadBrokers$default$1());
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnBrokerStartup$3(server)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timeout waiting stray logs queue up for deletion");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            $this.verifyStrayLogDeletion(server);
            return;
        }
        controllerServer$1.elem = server;
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDeletionOnBrokerStartup$5(ObjectRef controllerServer$1) {
        return ((KafkaServer)controllerServer$1.elem).logManager().hasStrayLogsToBeDeleted();
    }

    public static final /* synthetic */ String $anonfun$testStrayPartitionDeletionOnBrokerStartup$6() {
        return "Timeout waiting stray logs queue up for deletion";
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDeletionOnControllerFailover$2(StrayPartitionIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testStrayPartitionDeletionOnControllerFailover$3() {
        return "Timed out waiting for controller election";
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDeletionOnControllerFailover$4(StrayPartitionIntegrationTest $this, int controllerId$1) {
        return ((KafkaServer)$this.servers().apply(controllerId$1)).kafkaController().isActive();
    }

    public static final /* synthetic */ String $anonfun$testStrayPartitionDeletionOnControllerFailover$5() {
        return "Timed out waiting for controller initialization";
    }

    public static final /* synthetic */ RecordMetadata $anonfun$testPartitionNotStrayDuringReassignment$1(KafkaProducer producer$1, ProducerRecord record$1, int x$1) {
        return (RecordMetadata)producer$1.send(record$1).get();
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionNotStrayDuringReassignment$3(StrayPartitionIntegrationTest $this, int newLeader$1) {
        return $this.logOpt(newLeader$1, $this.topicPartition()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testPartitionNotStrayDuringReassignment$4() {
        return "Timed out waiting for reassignment to initiate";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionNotStrayDuringReassignment$5(StrayPartitionIntegrationTest $this, int newLeader$1) {
        return ((AbstractLog)$this.logOpt(newLeader$1, $this.topicPartition()).get()).numberOfSegments() > 1;
    }

    public static final /* synthetic */ String $anonfun$testPartitionNotStrayDuringReassignment$6() {
        return "Timed out waiting for segments to roll";
    }

    public static final /* synthetic */ RecordMetadata $anonfun$testPartitionNotStrayDuringReassignment$8(KafkaProducer producer$1, ProducerRecord record$1, int x$3) {
        return (RecordMetadata)producer$1.send(record$1).get();
    }

    public static final /* synthetic */ void $anonfun$testPartitionNotStrayDuringReassignment$9(StrayPartitionIntegrationTest $this, KafkaServer server) {
        Assertions.assertEquals((int)0, (int)server.replicaManager().strayPartitionsCount());
        Assertions.assertEquals((long)0L, (long)server.replicaManager().strayPartitionsTotalSize());
        $this.verifyStrayPartitionMetrics(0, 0L);
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionNotStrayDuringReassignment$10(StrayPartitionIntegrationTest $this, ConfluentAdmin adminClient$1) {
        return ((java.util.Map)adminClient$1.listPartitionReassignments(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{$this.topicPartition()}))).asJava()).reassignments().get()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testPartitionNotStrayDuringReassignment$11() {
        return "Timed out waiting for reassignment to complete";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionNotStrayDuringReassignment$12(StrayPartitionIntegrationTest $this, int newLeader$1) {
        return ((KafkaServer)$this.servers().apply(newLeader$1)).replicaManager().leaderPartitionsIterator().map((Function1 & Serializable)x$4 -> x$4.topicPartition()).contains((Object)$this.topicPartition());
    }

    public static final /* synthetic */ String $anonfun$testPartitionNotStrayDuringReassignment$14(StrayPartitionIntegrationTest $this, int newLeader$1) {
        return new StringBuilder(75).append("Timed out waiting for ").append(newLeader$1).append(" to become the new leader of ").append($this.topicPartition()).append(" after it was reassigned").toString();
    }

    public static final /* synthetic */ void $anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$1(StrayPartitionIntegrationTest $this, KafkaServer server) {
        LogManager logManager = server.logManager();
        TopicPartition x$1 = new TopicPartition($this.strayTopic_1(), server.config().brokerId() * 2);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = logManager.getOrCreateLog$default$2();
        boolean x$4 = logManager.getOrCreateLog$default$3();
        AbstractLog strayLog1 = logManager.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        TopicPartition x$5 = new TopicPartition($this.strayTopic_2(), server.config().brokerId() * 2 + 1);
        None$ x$6 = None$.MODULE$;
        boolean x$7 = logManager.getOrCreateLog$default$2();
        boolean x$8 = logManager.getOrCreateLog$default$3();
        AbstractLog strayLog2 = logManager.getOrCreateLog(x$5, x$7, x$8, (Option)x$6);
        $this.createSegment(strayLog1);
        $this.createSegment(strayLog2);
    }

    private static final Iterable allLogs$1(KafkaServer server$4) {
        return (Iterable)server$4.logManager().allLogs().map((Function1 & Serializable)x$6 -> x$6.topicPartition());
    }

    private static final long logSize$1(TopicPartition topicPartition, KafkaServer server$4) {
        LogManager qual$1 = server$4.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        return BoxesRunTime.unboxToLong((Object)qual$1.getLog(topicPartition, x$2).map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.size())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$6(KafkaServer server$4) {
        return server$4.replicaManager().strayPartitionsCount() == 2;
    }

    public static final /* synthetic */ String $anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$7() {
        return "Timed out waiting for stray partition detection";
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$8(KafkaServer server$4, long totalLogSize$1) {
        return server$4.replicaManager().strayPartitionsTotalSize() == totalLogSize$1;
    }

    public static final /* synthetic */ String $anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$9() {
        return "Timed out waiting for stray partition total size detection";
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$10(StrayPartitionIntegrationTest $this, TopicPartition x$8) {
        String string = x$8.topic();
        String string2 = $this.validTopic_1();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$11(StrayPartitionIntegrationTest $this, TopicPartition x$9) {
        String string = x$9.topic();
        String string2 = $this.validTopic_2();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$2(StrayPartitionIntegrationTest $this, KafkaServer server) {
        $this.killBroker(server.config().brokerId());
        $this.restartDeadBrokers($this.restartDeadBrokers$default$1());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$6(server)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for stray partition detection");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long totalLogSize = StrayPartitionIntegrationTest.logSize$1(new TopicPartition($this.strayTopic_1(), server.config().brokerId() * 2), server) + StrayPartitionIntegrationTest.logSize$1(new TopicPartition($this.strayTopic_2(), server.config().brokerId() * 2 + 1), server);
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$8(server, totalLogSize)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Timed out waiting for stray partition total size detection");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        $this.verifyStrayPartitionMetrics(2, totalLogSize);
        Assertions.assertEquals((int)3, (int)((IterableOnceOps)StrayPartitionIntegrationTest.allLogs$1(server).filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$10($this, x$8)))).size());
        Assertions.assertEquals((int)5, (int)((IterableOnceOps)StrayPartitionIntegrationTest.allLogs$1(server).filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$11($this, x$9)))).size());
    }

    private static final Iterable allLogs$2(KafkaServer server$5) {
        return (Iterable)server$5.logManager().allLogs().map((Function1 & Serializable)x$10 -> x$10.topicPartition());
    }

    public static final /* synthetic */ boolean $anonfun$verifyStrayLogDeletion$3(StrayPartitionIntegrationTest $this, TopicPartition tp) {
        block3: {
            block2: {
                String string = tp.topic();
                String string2 = $this.strayTopic_1();
                if (!(string == null ? string2 != null : !string.equals(string2))) break block2;
                String string3 = tp.topic();
                String string4 = $this.strayTopic_2();
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block3;
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$verifyStrayLogDeletion$2(StrayPartitionIntegrationTest $this, KafkaServer server$5) {
        return ((IterableOnceOps)StrayPartitionIntegrationTest.allLogs$2(server$5).filter((Function1 & Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)StrayPartitionIntegrationTest.$anonfun$verifyStrayLogDeletion$3($this, tp)))).size() == 0;
    }

    public static final /* synthetic */ String $anonfun$verifyStrayLogDeletion$4() {
        return "Timed out waiting for stray topic deletion";
    }

    public static final /* synthetic */ boolean $anonfun$verifyStrayLogDeletion$5(StrayPartitionIntegrationTest $this, TopicPartition x$11) {
        String string = x$11.topic();
        String string2 = $this.validTopic_1();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyStrayLogDeletion$6(StrayPartitionIntegrationTest $this, TopicPartition x$12) {
        String string = x$12.topic();
        String string2 = $this.validTopic_2();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyStrayLogDeletion$7(KafkaServer server$5) {
        return !server$5.logManager().hasStrayLogsToBeDeleted();
    }

    public static final /* synthetic */ String $anonfun$verifyStrayLogDeletion$8() {
        return "Timed out waiting for stray log deletion";
    }

    public static final /* synthetic */ boolean $anonfun$verifyStrayLogDeletion$9(KafkaServer server$5) {
        return 0 == server$5.replicaManager().strayPartitionsCount();
    }

    public static final /* synthetic */ String $anonfun$verifyStrayLogDeletion$10() {
        return "Timed out waiting for stray partitions count metric to clear";
    }

    public static final /* synthetic */ boolean $anonfun$verifyStrayPartitionMetrics$1(String metricName$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName m = (MetricName)x0$1._1();
            String string = m.getName();
            if (!(string != null ? !string.equals(metricName$1) : metricName$1 != null)) {
                String string2 = m.getType();
                String string3 = "ReplicaManager";
                if (string2 != null && string2.equals(string3)) {
                    return true;
                }
            }
            return false;
        }
        throw new MatchError(null);
    }

    private static final Metric replicaMetric$1(String metricName) {
        return (Metric)((Tuple2)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)StrayPartitionIntegrationTest.$anonfun$verifyStrayPartitionMetrics$1(metricName, x0$1)))).head())._2();
    }

    public StrayPartitionIntegrationTest() {
        this.numBrokers = 3;
        this.topic = "topic_1";
        this.validTopic_1 = "valid-1";
        this.validTopic_2 = "valid-2";
        this.strayTopic_1 = "stray-1";
        this.replicationFactor = 3;
        this.numPartitions = 3;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LeaderImbalancePerBrokerPercentageProp(), "0");
        Predef$.MODULE$.locally(this.serverConfig().setProperty(KafkaConfig$.MODULE$.LeaderImbalanceCheckIntervalSecondsProp(), "1"));
    }
}

