/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.common.InconsistentBrokerIdException;
import kafka.server.BrokerMetadataCheckpoint;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.server.RawMetaProperties;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.apache.zookeeper.KeeperException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\rd\u0001\u0002\u000f\u001e\u0001\tBQa\n\u0001\u0005\u0002!B\u0011B\u000b\u0001A\u0002\u0003\u0007I\u0011A\u0016\t\u0013Q\u0002\u0001\u0019!a\u0001\n\u0003)\u0004\"\u0003 \u0001\u0001\u0004\u0005\t\u0015)\u0003-\u0011%y\u0004\u00011AA\u0002\u0013\u0005\u0001\tC\u0005E\u0001\u0001\u0007\t\u0019!C\u0001\u000b\"Iq\t\u0001a\u0001\u0002\u0003\u0006K!\u0011\u0005\n\u0011\u0002\u0001\r\u00111A\u0005\u0002-B\u0011\"\u0013\u0001A\u0002\u0003\u0007I\u0011\u0001&\t\u00131\u0003\u0001\u0019!A!B\u0013a\u0003\"C'\u0001\u0001\u0004\u0005\r\u0011\"\u0001A\u0011%q\u0005\u00011AA\u0002\u0013\u0005q\nC\u0005R\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\"9!\u000b\u0001b\u0001\n\u0003\u0019\u0006B\u0002.\u0001A\u0003%A\u000bC\u0004\\\u0001\u0001\u0007I\u0011\u0001/\t\u000f1\u0004\u0001\u0019!C\u0001[\"1q\u000e\u0001Q!\nuCQ\u0001\u001d\u0001\u0005BEDq!!\u0003\u0001\t\u0003\nY\u0001C\u0004\u0002\u0016\u0001!\t!a\u0003\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\f!9\u00111\u0005\u0001\u0005\u0002\u0005-\u0001bBA\u0014\u0001\u0011\u0005\u00111\u0002\u0005\b\u0003W\u0001A\u0011AA\u0006\u0011\u001d\ty\u0003\u0001C\u0001\u0003\u0017Aq!a\r\u0001\t\u0003\t)D\u0001\u000eTKJ4XM]$f]\u0016\u0014\u0018\r^3Ce>\\WM]%e)\u0016\u001cHO\u0003\u0002\u001f?\u000511/\u001a:wKJT\u0011\u0001I\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\u0005\u0005\u0002%K5\tQ$\u0003\u0002';\t\t\u0012+^8sk6$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005I\u0003C\u0001\u0013\u0001\u0003\u0019\u0001(o\u001c9tcU\tA\u0006\u0005\u0002.e5\taF\u0003\u00020a\u0005!Q\u000f^5m\u0015\u0005\t\u0014\u0001\u00026bm\u0006L!a\r\u0018\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\u0006qe>\u00048/M0%KF$\"A\u000e\u001f\u0011\u0005]RT\"\u0001\u001d\u000b\u0003e\nQa]2bY\u0006L!a\u000f\u001d\u0003\tUs\u0017\u000e\u001e\u0005\b{\r\t\t\u00111\u0001-\u0003\rAH%M\u0001\baJ|\u0007o]\u0019!\u0003\u001d\u0019wN\u001c4jOF*\u0012!\u0011\t\u0003I\tK!aQ\u000f\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\fG>tg-[42?\u0012*\u0017\u000f\u0006\u00027\r\"9QHBA\u0001\u0002\u0004\t\u0015\u0001C2p]\u001aLw-\r\u0011\u0002\rA\u0014x\u000e]:3\u0003)\u0001(o\u001c9te}#S-\u001d\u000b\u0003m-Cq!P\u0005\u0002\u0002\u0003\u0007A&A\u0004qe>\u00048O\r\u0011\u0002\u000f\r|gNZ5he\u0005Y1m\u001c8gS\u001e\u0014t\fJ3r)\t1\u0004\u000bC\u0004>\u0019\u0005\u0005\t\u0019A!\u0002\u0011\r|gNZ5he\u0001\n1C\u0019:pW\u0016\u0014X*\u001a;b!J|\u0007o\u001d$jY\u0016,\u0012\u0001\u0016\t\u0003+bk\u0011A\u0016\u0006\u0003/B\nA\u0001\\1oO&\u0011\u0011L\u0016\u0002\u0007'R\u0014\u0018N\\4\u0002)\t\u0014xn[3s\u001b\u0016$\u0018\r\u0015:paN4\u0015\u000e\\3!\u0003\u001d\u0019XM\u001d<feN,\u0012!\u0018\t\u0004=\u001aLgBA0e\u001d\t\u00017-D\u0001b\u0015\t\u0011\u0017%\u0001\u0004=e>|GOP\u0005\u0002s%\u0011Q\rO\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0007NA\u0002TKFT!!\u001a\u001d\u0011\u0005\u0011R\u0017BA6\u001e\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002\u0017M,'O^3sg~#S-\u001d\u000b\u0003m9Dq!P\t\u0002\u0002\u0003\u0007Q,\u0001\u0005tKJ4XM]:!\u0003\u0015\u0019X\r^+q)\t1$\u000fC\u0003t'\u0001\u0007A/\u0001\u0005uKN$\u0018J\u001c4p!\t)h0D\u0001w\u0015\t9\b0A\u0002ba&T!!\u001f>\u0002\u000f),\b/\u001b;fe*\u00111\u0010`\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002{\u0006\u0019qN]4\n\u0005}4(\u0001\u0003+fgRLeNZ8)\u0007M\t\u0019\u0001E\u0002v\u0003\u000bI1!a\u0002w\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]R\ta\u0007K\u0002\u0015\u0003\u001f\u00012!^A\t\u0013\r\t\u0019B\u001e\u0002\n\u0003\u001a$XM]#bG\"\f\u0001\u0004^3ti\u0006+Ho\\$f]\u0016\u0014\u0018\r^3Ce>\\WM]%eQ\r)\u0012\u0011\u0004\t\u0004k\u0006m\u0011bAA\u000fm\n!A+Z:u\u0003\t\"Xm\u001d;Vg\u0016\u00148i\u001c8gS\u001e\fe\u000eZ$f]\u0016\u0014\u0018\r^3e\u0005J|7.\u001a:JI\"\u001aa#!\u0007\u00029Q,7\u000f\u001e#jg\u0006\u0014G.Z$f]\u0016\u0014\u0018\r^3e\u0005J|7.\u001a:JI\"\u001aq#!\u0007\u00029Q,7\u000f^'vYRL\u0007\u000f\\3M_\u001e$\u0015N]:NKR\f\u0007K]8qg\"\u001a\u0001$!\u0007\u0002aQ,7\u000f^\"p]NL7\u000f^3oi\n\u0013xn[3s\u0013\u00124%o\\7Vg\u0016\u00148i\u001c8gS\u001e\fe\u000eZ'fi\u0006\u0004&o\u001c9tQ\rI\u0012\u0011D\u0001 i\u0016\u001cHO\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018m\u00148JI\u000e{G\u000e\\5tS>t\u0007f\u0001\u000e\u0002\u001a\u0005!b/\u001a:jMf\u0014%o\\6fe6+G/\u00193bi\u0006$b!a\u000e\u0002>\u0005e\u0003cA\u001c\u0002:%\u0019\u00111\b\u001d\u0003\u000f\t{w\u000e\\3b]\"9\u0011qH\u000eA\u0002\u0005\u0005\u0013a\u00027pO\u0012K'o\u001d\t\u0007\u0003\u0007\nI%a\u0013\u000e\u0005\u0005\u0015#bAA$q\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0007\u001d\f)\u0005\u0005\u0003\u0002N\u0005Uc\u0002BA(\u0003#\u0002\"\u0001\u0019\u001d\n\u0007\u0005M\u0003(\u0001\u0004Qe\u0016$WMZ\u0005\u00043\u0006]#bAA*q!9\u00111L\u000eA\u0002\u0005u\u0013\u0001\u00032s_.,'/\u00133\u0011\u0007]\ny&C\u0002\u0002ba\u00121!\u00138u\u0001")
public class ServerGenerateBrokerIdTest
extends QuorumTestHarness {
    private Properties props1;
    private KafkaConfig config1;
    private Properties props2;
    private KafkaConfig config2;
    private final String brokerMetaPropsFile;
    private scala.collection.immutable.Seq<KafkaServer> servers = Nil$.MODULE$;

    public Properties props1() {
        return this.props1;
    }

    public void props1_$eq(Properties x$1) {
        this.props1 = x$1;
    }

    public KafkaConfig config1() {
        return this.config1;
    }

    public void config1_$eq(KafkaConfig x$1) {
        this.config1 = x$1;
    }

    public Properties props2() {
        return this.props2;
    }

    public void props2_$eq(Properties x$1) {
        this.props2 = x$1;
    }

    public KafkaConfig config2() {
        return this.config2;
    }

    public void config2_$eq(KafkaConfig x$1) {
        this.config2 = x$1;
    }

    public String brokerMetaPropsFile() {
        return this.brokerMetaPropsFile;
    }

    public scala.collection.immutable.Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(scala.collection.immutable.Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.props1_$eq(TestUtils$.MODULE$.createBrokerConfig(-1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(this.props1()));
        this.props2_$eq(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        this.config2_$eq(KafkaConfig$.MODULE$.fromProps(this.props2()));
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers(), true);
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAutoGenerateBrokerId() {
        void createServer_createServer_createServer_startup;
        void createServer_threadNamePrefix;
        void createServer_config;
        KafkaConfig x$1 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = Time.SYSTEM;
        boolean x$4 = false;
        KafkaServer server1 = new KafkaServer(x$1, x$3, x$2, x$4);
        server1.startup();
        server1.shutdown();
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)this.config1().logDirs(), 1001));
        Option option = Option$.MODULE$.apply((Object)this.getClass().getName());
        KafkaConfig kafkaConfig = this.config1();
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        Time createServer_createServer_time = Time.SYSTEM;
        boolean bl = true;
        int createServer_createServer_createServer_licenseTopicReplicationFactor = 0;
        Object var9_9 = null;
        Object var6_8 = null;
        kafkaConfig = null;
        option = null;
        server1 = createServer_this.createServer((KafkaConfig)createServer_config, createServer_createServer_time, (Option<String>)createServer_threadNamePrefix, createServer_createServer_createServer_licenseTopicReplicationFactor, (boolean)createServer_createServer_createServer_startup, false);
        this.servers_$eq((scala.collection.immutable.Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        Assertions.assertEquals((int)server1.config().brokerId(), (int)1001);
        server1.shutdown();
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testUserConfigAndGeneratedBrokerId() {
        KafkaConfig x$1 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = Time.SYSTEM;
        boolean x$4 = false;
        KafkaServer server1 = new KafkaServer(x$1, x$3, x$2, x$4);
        KafkaConfig x$52 = this.config2();
        Option x$6 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$7 = Time.SYSTEM;
        boolean x$8 = false;
        KafkaServer server2 = new KafkaServer(x$52, x$7, x$6, x$8);
        Properties props3 = TestUtils$.MODULE$.createBrokerConfig(-1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        KafkaConfig x$9 = KafkaConfig$.MODULE$.fromProps(props3);
        Option x$10 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$11 = Time.SYSTEM;
        boolean x$12 = false;
        KafkaServer server3 = new KafkaServer(x$9, x$11, x$10, x$12);
        server1.startup();
        Assertions.assertEquals((int)server1.config().brokerId(), (int)1001);
        server2.startup();
        Assertions.assertEquals((int)server2.config().brokerId(), (int)0);
        server3.startup();
        Assertions.assertEquals((int)server3.config().brokerId(), (int)1002);
        this.servers_$eq((scala.collection.immutable.Seq<KafkaServer>)new .colon.colon((Object)server1, (List)new .colon.colon((Object)server2, (List)new .colon.colon((Object)server3, (List)Nil$.MODULE$))));
        this.servers().foreach((Function1 & Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server1.config().logDirs(), 1001));
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server2.config().logDirs(), 0));
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server3.config().logDirs(), 1002));
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDisableGeneratedBrokerId() {
        void createServer_createServer_createServer_startup;
        void createServer_threadNamePrefix;
        Properties props3 = TestUtils$.MODULE$.createBrokerConfig(3, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props3.put(KafkaConfig$.MODULE$.BrokerIdGenerationEnableProp(), "false");
        props3.put(KafkaConfig$.MODULE$.MaxReservedBrokerIdProp(), "0");
        KafkaConfig config3 = KafkaConfig$.MODULE$.fromProps(props3);
        Option option = Option$.MODULE$.apply((Object)this.getClass().getName());
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        Time createServer_createServer_time = Time.SYSTEM;
        boolean bl = true;
        int createServer_createServer_createServer_licenseTopicReplicationFactor = 0;
        Object var6_5 = null;
        Object var4_4 = null;
        option = null;
        KafkaServer server3 = createServer_this.createServer(config3, createServer_createServer_time, (Option<String>)createServer_threadNamePrefix, createServer_createServer_createServer_licenseTopicReplicationFactor, (boolean)createServer_createServer_createServer_startup, false);
        this.servers_$eq((scala.collection.immutable.Seq<KafkaServer>)new .colon.colon((Object)server3, (List)Nil$.MODULE$));
        Assertions.assertEquals((int)server3.config().brokerId(), (int)3);
        server3.shutdown();
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server3.config().logDirs(), 3));
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testMultipleLogDirsMetaProps() {
        String logDirs = new StringBuilder(2).append(this.props1().getProperty("log.dir")).append(",").append(TestUtils.tempDirectory(null, null).getAbsolutePath()).append(",").append(TestUtils.tempDirectory(null, null).getAbsolutePath()).toString();
        this.props1().setProperty("log.dir", logDirs);
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(this.props1()));
        KafkaConfig x$1 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = Time.SYSTEM;
        boolean x$4 = false;
        KafkaServer server1 = new KafkaServer(x$1, x$3, x$2, x$4);
        server1.startup();
        this.servers_$eq((scala.collection.immutable.Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        server1.shutdown();
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)this.config1().logDirs(), 1001));
        String newLogDirs = new StringBuilder(1).append(this.props1().getProperty("log.dir")).append(",").append(TestUtils.tempDirectory(null, null).getAbsolutePath()).toString();
        this.props1().setProperty("log.dir", newLogDirs);
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(this.props1()));
        KafkaConfig x$5 = this.config1();
        Option x$6 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$7 = Time.SYSTEM;
        boolean x$8 = false;
        server1 = new KafkaServer(x$5, x$7, x$6, x$8);
        server1.startup();
        this.servers_$eq((scala.collection.immutable.Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        server1.shutdown();
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)this.config1().logDirs(), 1001));
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testConsistentBrokerIdFromUserConfigAndMetaProps() {
        KafkaConfig x$1 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = Time.SYSTEM;
        boolean x$4 = false;
        KafkaServer server1 = new KafkaServer(x$1, x$3, x$2, x$4);
        server1.startup();
        this.servers_$eq((scala.collection.immutable.Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        server1.shutdown();
        KafkaConfig x$5 = this.config2();
        Option x$6 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$7 = Time.SYSTEM;
        boolean x$8 = false;
        server1 = new KafkaServer(x$5, x$7, x$6, x$8);
        try {
            server1.startup();
        }
        catch (InconsistentBrokerIdException inconsistentBrokerIdException) {}
        server1.shutdown();
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerMetadataOnIdCollision() {
        void createServer_createServer_createServer_startup;
        void createServer_threadNamePrefix;
        void createServer_createServer_createServer_startup2;
        void createServer_threadNamePrefix2;
        Properties propsA = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        KafkaConfig configA = KafkaConfig$.MODULE$.fromProps(propsA);
        Option option = Option$.MODULE$.apply((Object)this.getClass().getName());
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        Time createServer_createServer_time = Time.SYSTEM;
        boolean bl = true;
        int createServer_createServer_createServer_licenseTopicReplicationFactor = 0;
        Object var14_5 = null;
        Object var12_4 = null;
        option = null;
        KafkaServer serverA = createServer_this.createServer(configA, createServer_createServer_time, (Option<String>)createServer_threadNamePrefix2, createServer_createServer_createServer_licenseTopicReplicationFactor, (boolean)createServer_createServer_createServer_startup2, false);
        Properties propsB = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        KafkaConfig configB = KafkaConfig$.MODULE$.fromProps(propsB);
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = Time.SYSTEM;
        boolean x$4 = false;
        KafkaServer serverB = new KafkaServer(configB, x$3, x$2, x$4);
        Assertions.assertThrows(KeeperException.NodeExistsException.class, () -> serverB.startup());
        this.servers_$eq((scala.collection.immutable.Seq<KafkaServer>)new .colon.colon((Object)serverA, (List)Nil$.MODULE$));
        serverB.config().logDirs().foreach((Function1 & Serializable)logDir -> {
            ServerGenerateBrokerIdTest.$anonfun$testBrokerMetadataOnIdCollision$2(this, logDir);
            return BoxedUnit.UNIT;
        });
        propsB.setProperty(KafkaConfig$.MODULE$.BrokerIdProp(), "2");
        KafkaConfig newConfigB = KafkaConfig$.MODULE$.fromProps(propsB);
        Option option2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        TestUtils$ createServer_this2 = TestUtils$.MODULE$;
        Time createServer_createServer_time2 = Time.SYSTEM;
        boolean bl2 = true;
        int createServer_createServer_createServer_licenseTopicReplicationFactor2 = 0;
        Object var19_18 = null;
        Object var17_17 = null;
        option2 = null;
        KafkaServer newServerB = createServer_this2.createServer(newConfigB, createServer_createServer_time2, (Option<String>)createServer_threadNamePrefix, createServer_createServer_createServer_licenseTopicReplicationFactor2, (boolean)createServer_createServer_createServer_startup, false);
        this.servers_$eq((scala.collection.immutable.Seq<KafkaServer>)new .colon.colon((Object)serverA, (List)new .colon.colon((Object)newServerB, (List)Nil$.MODULE$)));
        serverA.shutdown();
        newServerB.shutdown();
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)serverA.config().logDirs(), 1));
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)newServerB.config().logDirs(), 2));
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    public boolean verifyBrokerMetadata(Seq<String> logDirs, int brokerId) {
        Object object = new Object();
        try {
            logDirs.foreach((Function1 & Serializable)logDir -> {
                ServerGenerateBrokerIdTest.$anonfun$verifyBrokerMetadata$1(this, brokerId, object, logDir);
                return BoxedUnit.UNIT;
            });
            return true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ void $anonfun$testBrokerMetadataOnIdCollision$2(ServerGenerateBrokerIdTest $this, String logDir) {
        Assertions.assertFalse((boolean)new File(new StringBuilder(0).append(logDir).append(File.separator).append($this.brokerMetaPropsFile()).toString()).exists());
    }

    public static final /* synthetic */ void $anonfun$verifyBrokerMetadata$1(ServerGenerateBrokerIdTest $this, int brokerId$1, Object nonLocalReturnKey1$1, String logDir) {
        Option brokerMetadataOpt = new BrokerMetadataCheckpoint(new File(new StringBuilder(0).append(logDir).append(File.separator).append($this.brokerMetaPropsFile()).toString())).read();
        if (brokerMetadataOpt instanceof Some) {
            Properties properties = (Properties)((Some)brokerMetadataOpt).value();
            if (new RawMetaProperties(properties).brokerId().exists((Function1)(JFunction1.mcZI.sp & Serializable)x$6 -> x$6 != brokerId$1)) {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
            }
            return;
        }
        throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
    }

    public ServerGenerateBrokerIdTest() {
        this.brokerMetaPropsFile = "meta.properties";
    }
}

