/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import kafka.cluster.BrokerEndPoint;
import kafka.server.BlockingSend;
import kafka.server.FollowerFetchThrottler;
import kafka.server.FollowerThrottler;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LeaderEndPoint;
import kafka.server.QuotaFactory;
import kafka.server.RemoteLeaderEndPoint;
import kafka.server.RemoteLeaderRequestBuilder;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.RequestBuilder;
import kafka.server.TierOffsetInfo;
import kafka.server.TierOffsetInfo$;
import kafka.server.epoch.util.MockBlockingSender;
import kafka.utils.CoreUtils$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.UnknownLeaderEpochException;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005y4AAG\u000e\u0001A!)q\u0005\u0001C\u0001Q!91\u0006\u0001b\u0001\n\u0003a\u0003B\u0002\u001d\u0001A\u0003%Q\u0006C\u0004:\u0001\t\u0007I\u0011\u0001\u001e\t\ry\u0002\u0001\u0015!\u0003<\u0011\u001dy\u0004A1A\u0005\u0002iBa\u0001\u0011\u0001!\u0002\u0013Y\u0004bB!\u0001\u0005\u0004%\tA\u000f\u0005\u0007\u0005\u0002\u0001\u000b\u0011B\u001e\t\u000f\r\u0003!\u0019!C\u0001u!1A\t\u0001Q\u0001\nmB\u0011\"\u0012\u0001A\u0002\u0003\u0007I\u0011\u0001$\t\u0013=\u0003\u0001\u0019!a\u0001\n\u0003\u0001\u0006\"\u0003,\u0001\u0001\u0004\u0005\t\u0015)\u0003H\u0011%9\u0006\u00011AA\u0002\u0013\u0005\u0001\fC\u0005]\u0001\u0001\u0007\t\u0019!C\u0001;\"Iq\f\u0001a\u0001\u0002\u0003\u0006K!\u0017\u0005\u0006A\u0002!\t!\u0019\u0005\u0006[\u0002!\t!\u0019\u0005\u0006e\u0002!\t!\u0019\u0005\u0006i\u0002!\t!\u0019\u0005\u0006m\u0002!\t!\u0019\u0005\u0006q\u0002!\t!\u0019\u0005\u0006u\u0002!\t!\u0019\u0005\u0006y\u0002!\t!\u0019\u0002\u0019%\u0016lw\u000e^3MK\u0006$WM]#oIB{\u0017N\u001c;UKN$(B\u0001\u000f\u001e\u0003\u0019\u0019XM\u001d<fe*\ta$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\t\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002SA\u0011!\u0006A\u0007\u00027\u0005qAo\u001c9jGB\u000b'\u000f^5uS>tW#A\u0017\u0011\u000592T\"A\u0018\u000b\u0005A\n\u0014AB2p[6|gN\u0003\u0002\u001fe)\u00111\u0007N\u0001\u0007CB\f7\r[3\u000b\u0003U\n1a\u001c:h\u0013\t9tF\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\n!cY;se\u0016tG\u000fT3bI\u0016\u0014X\t]8dQV\t1\b\u0005\u0002#y%\u0011Qh\t\u0002\u0004\u0013:$\u0018aE2veJ,g\u000e\u001e'fC\u0012,'/\u00129pG\"\u0004\u0013A\u00047pON#\u0018M\u001d;PM\u001a\u001cX\r^\u0001\u0010Y><7\u000b^1si>3gm]3uA\u0005\u0019Bn\\2bY2{wm\u0015;beR|eMZ:fi\u0006!Bn\\2bY2{wm\u0015;beR|eMZ:fi\u0002\nA\u0002\\8h\u000b:$wJ\u001a4tKR\fQ\u0002\\8h\u000b:$wJ\u001a4tKR\u0004\u0013\u0001\u00042m_\u000e\\\u0017N\\4TK:$W#A$\u0011\u0005!kU\"A%\u000b\u0005)[\u0015\u0001B;uS2T!\u0001T\u000e\u0002\u000b\u0015\u0004xn\u00195\n\u00059K%AE'pG.\u0014En\\2lS:<7+\u001a8eKJ\f\u0001C\u00197pG.LgnZ*f]\u0012|F%Z9\u0015\u0005E#\u0006C\u0001\u0012S\u0013\t\u00196E\u0001\u0003V]&$\bbB+\u000e\u0003\u0003\u0005\raR\u0001\u0004q\u0012\n\u0014!\u00042m_\u000e\\\u0017N\\4TK:$\u0007%\u0001\u0005f]\u0012\u0004v.\u001b8u+\u0005I\u0006C\u0001\u0016[\u0013\tY6D\u0001\bMK\u0006$WM]#oIB{\u0017N\u001c;\u0002\u0019\u0015tG\rU8j]R|F%Z9\u0015\u0005Es\u0006bB+\u0011\u0003\u0003\u0005\r!W\u0001\nK:$\u0007k\\5oi\u0002\nQa]3u+B$\u0012!\u0015\u0015\u0003%\r\u0004\"\u0001Z6\u000e\u0003\u0015T!AZ4\u0002\u0007\u0005\u0004\u0018N\u0003\u0002iS\u00069!.\u001e9ji\u0016\u0014(B\u000165\u0003\u0015QWO\\5u\u0013\taWM\u0001\u0006CK\u001a|'/Z#bG\"\fQ\u0003^3ti\u001a+Go\u00195MCR,7\u000f^(gMN,G\u000f\u000b\u0002\u0014_B\u0011A\r]\u0005\u0003c\u0016\u0014A\u0001V3ti\u00069B/Z:u\r\u0016$8\r[#be2LWm\u001d;PM\u001a\u001cX\r\u001e\u0015\u0003)=\fA\u0004^3ti\u001a+Go\u00195FCJd\u0017.Z:u\u0019>\u001c\u0017\r\\(gMN,G\u000f\u000b\u0002\u0016_\u0006qB/Z:u\r\u0016$8\r['bi\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8UCJ<W\r\u001e\u0015\u0003-=\f\u0001\u0004^3ti\u001a+Go\u00195Fa>\u001c\u0007.\u00128e\u001f\u001a47/\u001a;tQ\t9r.\u0001\u0013uKN$H\u000b\u001b:poN4UM\\2fI2+\u0017\rZ3s\u000bB|7\r[#yG\u0016\u0004H/[8oQ\tAr.A\u0013uKN$H\u000b\u001b:poN,fn\u001b8po:dU-\u00193fe\u0016\u0003xn\u00195Fq\u000e,\u0007\u000f^5p]\"\u0012\u0011d\u001c")
public class RemoteLeaderEndPointTest {
    private final TopicPartition topicPartition = new TopicPartition("test", 0);
    private final int currentLeaderEpoch;
    private final int logStartOffset;
    private final int localLogStartOffset;
    private final int logEndOffset;
    private MockBlockingSender blockingSend;
    private LeaderEndPoint endPoint;

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public int currentLeaderEpoch() {
        return this.currentLeaderEpoch;
    }

    public int logStartOffset() {
        return this.logStartOffset;
    }

    public int localLogStartOffset() {
        return this.localLogStartOffset;
    }

    public int logEndOffset() {
        return this.logEndOffset;
    }

    public MockBlockingSender blockingSend() {
        return this.blockingSend;
    }

    public void blockingSend_$eq(MockBlockingSender x$1) {
        this.blockingSend = x$1;
    }

    public LeaderEndPoint endPoint() {
        return this.endPoint;
    }

    public void endPoint_$eq(LeaderEndPoint x$1) {
        this.endPoint = x$1;
    }

    @BeforeEach
    public void setUp() {
        MockTime time = new MockTime();
        String logPrefix = "remote-leader-endpoint";
        BrokerEndPoint sourceBroker = new BrokerEndPoint(0, "localhost", 9092);
        int x$1 = sourceBroker.id();
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = sourceBroker.port();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var31_14 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var32_17 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var33_20 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        props.put(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        props.put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        FetchSessionHandler fetchSessionHandler = new FetchSessionHandler(new LogContext(logPrefix), sourceBroker.id());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        RemoteLeaderRequestBuilder requestBuilder = new RemoteLeaderRequestBuilder(config, (Function0 & Serializable)() -> config.interBrokerProtocolVersion(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L);
        FollowerFetchThrottler throttler = new FollowerFetchThrottler();
        this.blockingSend_$eq(new MockBlockingSender(new HashMap<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset>(), sourceBroker, (Time)time));
        this.endPoint_$eq((LeaderEndPoint)new RemoteLeaderEndPoint(logPrefix, (BlockingSend)this.blockingSend(), fetchSessionHandler, (RequestBuilder)requestBuilder, (FollowerThrottler)throttler, config, replicaManager, (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, (Function0 & Serializable)() -> MetadataVersion.MINIMUM_KRAFT_VERSION));
    }

    @Test
    public void testFetchLatestOffset() {
        this.blockingSend().setListOffsetsDataForNextResponse((Map<TopicPartition, ListOffsetsResponseData.ListOffsetsPartitionResponse>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new ListOffsetsResponseData.ListOffsetsPartitionResponse().setLeaderEpoch(7).setOffset((long)this.logEndOffset()))}))));
        Assertions.assertEquals((Object)new OffsetAndEpoch((long)this.logEndOffset(), 7), (Object)this.endPoint().fetchLatestOffset(this.topicPartition(), this.currentLeaderEpoch()));
    }

    @Test
    public void testFetchEarliestOffset() {
        this.blockingSend().setListOffsetsDataForNextResponse((Map<TopicPartition, ListOffsetsResponseData.ListOffsetsPartitionResponse>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new ListOffsetsResponseData.ListOffsetsPartitionResponse().setLeaderEpoch(5).setOffset((long)this.logStartOffset()))}))));
        Assertions.assertEquals((Object)new OffsetAndEpoch((long)this.logStartOffset(), 5), (Object)this.endPoint().fetchEarliestOffset(this.topicPartition(), this.currentLeaderEpoch()));
    }

    @Test
    public void testFetchEarliestLocalOffset() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.endPoint().fetchEarliestLocalOffset(this.topicPartition(), 1));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFetchMaterializationTarget() {
        void apply_tierRestorePoint;
        void apply_tierRestorePoint2;
        this.blockingSend().setListOffsetsDataForNextResponse((Map<TopicPartition, ListOffsetsResponseData.ListOffsetsPartitionResponse>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new ListOffsetsResponseData.ListOffsetsPartitionResponse().setLeaderEpoch(6).setOffset((long)this.localLogStartOffset()))}))));
        None$ none$ = None$.MODULE$;
        long apply_localLogStartOffset = 100L;
        none$ = null;
        Assertions.assertEquals((Object)new TierOffsetInfo(apply_localLogStartOffset, (Option)apply_tierRestorePoint2), (Object)this.endPoint().fetchTierMaterializationTarget(this.topicPartition(), this.currentLeaderEpoch()));
        this.blockingSend().setListOffsetsDataForNextResponse((Map<TopicPartition, ListOffsetsResponseData.ListOffsetsPartitionResponse>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new ListOffsetsResponseData.ListOffsetsPartitionResponse().setLeaderEpoch(6).setOffset((long)this.localLogStartOffset()).setFollowerRestorePointObjectId(Uuid.ZERO_UUID))}))));
        None$ none$2 = None$.MODULE$;
        long apply_localLogStartOffset2 = 100L;
        none$2 = null;
        Assertions.assertEquals((Object)new TierOffsetInfo(apply_localLogStartOffset2, (Option)apply_tierRestorePoint), (Object)this.endPoint().fetchTierMaterializationTarget(this.topicPartition(), this.currentLeaderEpoch()));
        Uuid followerRestorePointObjectID = Uuid.randomUuid();
        this.blockingSend().setListOffsetsDataForNextResponse((Map<TopicPartition, ListOffsetsResponseData.ListOffsetsPartitionResponse>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new ListOffsetsResponseData.ListOffsetsPartitionResponse().setLeaderEpoch(6).setOffset((long)this.localLogStartOffset()).setFollowerRestorePointObjectId(followerRestorePointObjectID).setFollowerRestorePointEpoch(5))}))));
        Assertions.assertEquals((Object)TierOffsetInfo$.MODULE$.apply(100L, CoreUtils$.MODULE$.toJavaUUID(followerRestorePointObjectID), 5), (Object)this.endPoint().fetchTierMaterializationTarget(this.topicPartition(), this.currentLeaderEpoch()));
    }

    @Test
    public void testFetchEpochEndOffsets() {
        Map expected = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(0).setEndOffset((long)this.logEndOffset()))}));
        this.blockingSend().setOffsetsForNextResponse(CollectionConverters$.MODULE$.MapHasAsJava(expected).asJava());
        Map result = this.endPoint().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.topicPartition().partition()).setLeaderEpoch(this.currentLeaderEpoch()))})));
        Assertions.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testThrowsFencedLeaderEpochException() {
        this.blockingSend().setListOffsetsDataForNextResponse((Map<TopicPartition, ListOffsetsResponseData.ListOffsetsPartitionResponse>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new ListOffsetsResponseData.ListOffsetsPartitionResponse().setErrorCode(Errors.FENCED_LEADER_EPOCH.code()))}))));
        Assertions.assertThrows(FencedLeaderEpochException.class, () -> this.endPoint().fetchEarliestOffset(this.topicPartition(), this.currentLeaderEpoch() - 1));
        Assertions.assertThrows(FencedLeaderEpochException.class, () -> this.endPoint().fetchLatestOffset(this.topicPartition(), this.currentLeaderEpoch() - 1));
    }

    @Test
    public void testThrowsUnknownLeaderEpochException() {
        this.blockingSend().setListOffsetsDataForNextResponse((Map<TopicPartition, ListOffsetsResponseData.ListOffsetsPartitionResponse>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new ListOffsetsResponseData.ListOffsetsPartitionResponse().setErrorCode(Errors.UNKNOWN_LEADER_EPOCH.code()))}))));
        Assertions.assertThrows(UnknownLeaderEpochException.class, () -> this.endPoint().fetchEarliestOffset(this.topicPartition(), this.currentLeaderEpoch() + 1));
        Assertions.assertThrows(UnknownLeaderEpochException.class, () -> this.endPoint().fetchLatestOffset(this.topicPartition(), this.currentLeaderEpoch() + 1));
    }

    public RemoteLeaderEndPointTest() {
        this.currentLeaderEpoch = 10;
        this.logStartOffset = 20;
        this.localLogStartOffset = 100;
        this.logEndOffset = 300;
    }
}

