/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import kafka.server.BaseRequestTest;
import kafka.server.BrokerTopicStats$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.message.ProduceResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.record.BrokerCompressionType;
import org.apache.kafka.test.InterceptorUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005=b\u0001\u0002\t\u0012\u0001YAQa\u0007\u0001\u0005\u0002qAqA\b\u0001C\u0002\u0013\u0005q\u0004\u0003\u00047\u0001\u0001\u0006I\u0001\t\u0005\u0006o\u0001!\t\u0001\u000f\u0005\u0006\u0015\u0002!\t\u0001\u000f\u0005\u0006\u0019\u0002!\t\u0001\u000f\u0005\u0006\u001d\u0002!\t\u0001\u000f\u0005\u0006!\u0002!I!\u0015\u0005\u0006K\u0002!\t\u0001\u000f\u0005\u0006O\u0002!\t\u0001\u000f\u0005\u0006S\u0002!\t\u0001\u000f\u0005\u0006W\u0002!\t\u0001\u000f\u0005\u0006[\u0002!IA\u001c\u0005\u0007\u00033\u0001A\u0011\u0001\u001d\t\u000f\u0005u\u0001\u0001\"\u0003\u0002 \t\u0011\u0002K]8ek\u000e,'+Z9vKN$H+Z:u\u0015\t\u00112#\u0001\u0004tKJ4XM\u001d\u0006\u0002)\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0018!\tA\u0012$D\u0001\u0012\u0013\tQ\u0012CA\bCCN,'+Z9vKN$H+Z:u\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u0019\u0001\u0005iQ.\u001a;sS\u000e\u001c8*Z=TKR,\u0012\u0001\t\t\u0004C!RS\"\u0001\u0012\u000b\u0005\r\"\u0013aB7vi\u0006\u0014G.\u001a\u0006\u0003K\u0019\n!bY8mY\u0016\u001cG/[8o\u0015\u00059\u0013!B:dC2\f\u0017BA\u0015#\u0005\r\u0019V\r\u001e\t\u0003WQj\u0011\u0001\f\u0006\u0003[9\nAaY8sK*\u0011q\u0006M\u0001\b[\u0016$(/[2t\u0015\t\t$'\u0001\u0004zC6lWM\u001d\u0006\u0002g\u0005\u00191m\\7\n\u0005Ub#AC'fiJL7MT1nK\u0006qQ.\u001a;sS\u000e\u001c8*Z=TKR\u0004\u0013\u0001\u0007;fgR\u001c\u0016.\u001c9mKB\u0013x\u000eZ;dKJ+\u0017/^3tiR\t\u0011\b\u0005\u0002;w5\ta%\u0003\u0002=M\t!QK\\5uQ\t!a\b\u0005\u0002@\u00116\t\u0001I\u0003\u0002B\u0005\u0006\u0019\u0011\r]5\u000b\u0005\r#\u0015a\u00026va&$XM\u001d\u0006\u0003\u000b\u001a\u000bQA[;oSRT\u0011aR\u0001\u0004_J<\u0017BA%A\u0005\u0011!Vm\u001d;\u0002\u0007R,7\u000f\u001e)s_\u0012,8-\u001a*fcV,7\u000f\u001e#ve&tw\rU1si&$\u0018n\u001c8SK\u000e|g/\u001a:z\u0003\u001a$XM]+oG2,\u0017M\u001c'fC\u0012,'/\u00127fGRLwN\u001c\u0015\u0003\u000by\nq\u0004^3tiB\u0013x\u000eZ;dK^KG\u000f[%om\u0006d\u0017\u000e\u001a+j[\u0016\u001cH/Y7qQ\t1a(A\fuKN$\bK]8ek\u000e,Gk\u001c(p]J+\u0007\u000f\\5dC\"\u0012qAP\u0001&GJ,\u0017\r^3U_BL7-\u00118e\r&tG\rU1si&$\u0018n\u001c8XSRDG*Z1eKJ$\"A\u0015-\u0011\ti\u001aV+V\u0005\u0003)\u001a\u0012a\u0001V;qY\u0016\u0014\u0004C\u0001\u001eW\u0013\t9fEA\u0002J]RDQ!\u0017\u0005A\u0002i\u000bQ\u0001^8qS\u000e\u0004\"a\u00172\u000f\u0005q\u0003\u0007CA/'\u001b\u0005q&BA0\u0016\u0003\u0019a$o\\8u}%\u0011\u0011MJ\u0001\u0007!J,G-\u001a4\n\u0005\r$'AB*ue&twM\u0003\u0002bM\u0005aB/Z:u\u0007>\u0014(/\u001e9u\u0019j$\u0004K]8ek\u000e,'+Z9vKN$\bFA\u0005?\u0003Y!Xm\u001d;['R#\u0005K]8ek\u000e,'+Z9vKN$\bF\u0001\u0006?\u0003u\"Xm\u001d;Qe>$WoY3SKF,Xm\u001d;J]\u000edW\u000fZ3t%\u0016\u001cwN\u001d3t%\u0016TWm\u0019;fI\nKH\u000b[3TC6,\u0017J\u001c;fe\u000e,\u0007\u000f^8sQ\tYa(\u0001!uKN$\bK]8ek\u000e,'+Z9vKN$\u0018J\\2mk\u0012,7OU3d_J$7OU3kK\u000e$X\r\u001a\"z\t&4g-\u001a:f]RLe\u000e^3sG\u0016\u0004Ho\u001c:tQ\taa(A\nck&dG\r\u0015:pIV\u001cWMU3rk\u0016\u001cH\u000f\u0006\u0005pu\u0006\u0005\u0011QAA\u0005!\t\u0001\b0D\u0001r\u0015\t\u00118/\u0001\u0005sKF,Xm\u001d;t\u0015\t!X/\u0001\u0004d_6lwN\u001c\u0006\u0003)YT!a\u001e$\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tI\u0018O\u0001\bQe>$WoY3SKF,Xm\u001d;\t\u000bml\u0001\u0019\u0001?\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B\u0011QP`\u0007\u0002g&\u0011qp\u001d\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\t\u0019!\u0004a\u0001+\u0006!\u0011mY6t\u0011\u0019\t9!\u0004a\u0001+\u0006IA/[7f_V$Xj\u001d\u0005\b\u0003\u0017i\u0001\u0019AA\u0007\u0003\u001d\u0011XmY8sIN\u0004B!a\u0004\u0002\u00165\u0011\u0011\u0011\u0003\u0006\u0004\u0003'\u0019\u0018A\u0002:fG>\u0014H-\u0003\u0003\u0002\u0018\u0005E!a\u0002*fG>\u0014Hm]\u0001@i\u0016\u001cH\u000f\u0015:pIV\u001cWMU3rk\u0016\u001cH/\u00138dYV$Wm]%om\u0006d\u0017\u000e\u001a+j[\u0016\u001cH/Y7q\u0003:$\u0017J\u001c;fe\u000e,\u0007\u000f^3e%\u0016\u001cwN\u001d3tQ\tqa(\u0001\ntK:$\u0007K]8ek\u000e,'+Z9vKN$HCBA\u0011\u0003O\tY\u0003E\u0002q\u0003GI1!!\nr\u0005=\u0001&o\u001c3vG\u0016\u0014Vm\u001d9p]N,\u0007BBA\u0015\u001f\u0001\u0007Q+\u0001\u0005mK\u0006$WM]%e\u0011\u0019\tic\u0004a\u0001_\u00069!/Z9vKN$\b")
public class ProduceRequestTest
extends BaseRequestTest {
    private final Set<MetricName> metricsKeySet = CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala();

    public Set<MetricName> metricsKeySet() {
        return this.metricsKeySet;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSimpleProduceRequest() {
        void withRecords_records;
        void withRecords_timestampType;
        void var3_3;
        void var2_2;
        void withRecords_records2;
        void withRecords_timestampType2;
        Tuple2<Object, Object> tuple2 = this.createTopicAndFindPartitionWithLeader("topic");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int partition = tuple2._1$mcI$sp();
        int leader = tuple2._2$mcI$sp();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var4_5 = null;
        simpleRecordArray = null;
        this.sendAndCheck$1(MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType2, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records2), 0L, (int)var2_2, (int)var3_3);
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key1".getBytes(), "value1".getBytes()), new SimpleRecord(System.currentTimeMillis(), "key2".getBytes(), "value2".getBytes())};
        CompressionType withRecords_compressionType2 = CompressionType.GZIP;
        byte withRecords_magic2 = 2;
        TimestampType timestampType2 = TimestampType.CREATE_TIME;
        long withRecords_initialOffset2 = 0L;
        timestampType2 = null;
        Object var6_10 = null;
        simpleRecordArray2 = null;
        this.sendAndCheck$1(MemoryRecords.withRecords((byte)withRecords_magic2, (long)withRecords_initialOffset2, (CompressionType)withRecords_compressionType2, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records), 1L, (int)var2_2, (int)var3_3);
    }

    @Test
    public void testProduceRequestDuringPartitionRecoveryAfterUncleanLeaderElection() {
        String topic = "test-topic";
        Properties topicConfig = new Properties();
        topicConfig.put("message.timestamp.type", "LogAppendTime");
        Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 2, (Seq<KafkaBroker>)this.servers(), topicConfig);
        TopicPartition partition = new TopicPartition(topic, 0);
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition.partition())));
        scala.collection.immutable.Set replicas = this.zkClient().getReplicasForPartition(partition).toSet();
        int follower = BoxesRunTime.unboxToInt((Object)replicas.find((Function1)(JFunction1.mcZI.sp & Serializable)x$2 -> x$2 != leader).get());
        int nonReplica = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.servers().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)ProduceRequestTest.$anonfun$testProduceRequestDuringPartitionRecoveryAfterUncleanLeaderElection$2(x$3)))).find((Function1)(JFunction1.mcZI.sp & Serializable)x$4 -> !replicas.contains((Object)BoxesRunTime.boxToInteger((int)x$4))).get());
        TestUtils$.MODULE$.forceOverrideLeaderRecoveryState(((KafkaServer)this.servers().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ProduceRequestTest.$anonfun$testProduceRequestDuringPartitionRecoveryAfterUncleanLeaderElection$4(leader, x$5))).get()).replicaManager().getPartitionOrException(partition), LeaderRecoveryState.RECOVERED);
        this.produceRecordsAndValidateResponse$1(leader, Errors.NONE, 0, partition);
        this.produceRecordsAndValidateResponse$1(follower, Errors.NOT_LEADER_OR_FOLLOWER, -1, partition);
        this.produceRecordsAndValidateResponse$1(nonReplica, Errors.NOT_LEADER_OR_FOLLOWER, -1, partition);
        TestUtils$.MODULE$.forceOverrideLeaderRecoveryState(((KafkaServer)this.servers().find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ProduceRequestTest.$anonfun$testProduceRequestDuringPartitionRecoveryAfterUncleanLeaderElection$5(leader, x$6))).get()).replicaManager().getPartitionOrException(partition), LeaderRecoveryState.RECOVERING);
        this.produceRecordsAndValidateResponse$1(leader, Errors.NOT_LEADER_OR_FOLLOWER, -1, partition);
        this.produceRecordsAndValidateResponse$1(follower, Errors.NOT_LEADER_OR_FOLLOWER, -1, partition);
        this.produceRecordsAndValidateResponse$1(nonReplica, Errors.NOT_LEADER_OR_FOLLOWER, -1, partition);
        TestUtils$.MODULE$.forceOverrideLeaderRecoveryState(((KafkaServer)this.servers().find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ProduceRequestTest.$anonfun$testProduceRequestDuringPartitionRecoveryAfterUncleanLeaderElection$6(leader, x$7))).get()).replicaManager().getPartitionOrException(partition), LeaderRecoveryState.RECOVERED);
        this.produceRecordsAndValidateResponse$1(leader, Errors.NONE, 1, partition);
        this.produceRecordsAndValidateResponse$1(follower, Errors.NOT_LEADER_OR_FOLLOWER, -1, partition);
        this.produceRecordsAndValidateResponse$1(nonReplica, Errors.NOT_LEADER_OR_FOLLOWER, -1, partition);
    }

    @Test
    public void testProduceWithInvalidTimestamp() {
        String topic = "topic";
        int partition = 0;
        Properties topicConfig = new Properties();
        topicConfig.setProperty("message.timestamp.difference.max.ms", "1000");
        int leader = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaBroker>)this.servers(), topicConfig).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        MemoryRecords records = ProduceRequestTest.createRecords$1((byte)2, System.currentTimeMillis() - 1001L, CompressionType.GZIP);
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        ProduceRequestData forCurrentMagic_data = new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(topicPartition.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)records)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null);
        Object var12_7 = null;
        ProduceResponse produceResponse = this.sendProduceRequest(leader, (ProduceRequest)ProduceRequest.forMagic((byte)2, (ProduceRequestData)forCurrentMagic_data).build());
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse.data().responses()).asScala().head();
        Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicProduceResponse.partitionResponses()).asScala().head();
        TopicPartition tp = new TopicPartition(topicProduceResponse.name(), partitionProduceResponse.index());
        Assertions.assertEquals((Object)topicPartition, (Object)tp);
        Assertions.assertEquals((Object)Errors.INVALID_TIMESTAMP, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
        Assertions.assertEquals((int)3, (int)partitionProduceResponse.recordErrors().size());
        Buffer recordErrors = CollectionConverters$.MODULE$.ListHasAsScala(partitionProduceResponse.recordErrors()).asScala();
        recordErrors.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Assertions.assertEquals((int)i, (int)((ProduceResponseData.BatchIndexAndErrorMessage)recordErrors.apply(i)).batchIndex()));
        recordErrors.foreach((Function1 & Serializable)recordError -> {
            ProduceRequestTest.$anonfun$testProduceWithInvalidTimestamp$2(recordError);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)"One or more records have been rejected due to invalid timestamp", (Object)partitionProduceResponse.errorMessage());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testProduceToNonReplica() {
        void withRecords_records;
        void withRecords_timestampType;
        String topic = "topic";
        int partition = 0;
        int leader = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaBroker>)this.servers(), new Properties()).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        Option nonReplicaOpt = this.servers().find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ProduceRequestTest.$anonfun$testProduceToNonReplica$1(leader, x$8)));
        Assertions.assertTrue((boolean)nonReplicaOpt.isDefined());
        int nonReplicaId = ((KafkaServer)nonReplicaOpt.get()).config().brokerId();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("key".getBytes(), "value".getBytes())};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var12_7 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        ProduceRequestData forCurrentMagic_data = new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(topicPartition.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)records)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null);
        Object var14_13 = null;
        ProduceRequest produceRequest = (ProduceRequest)ProduceRequest.forMagic((byte)2, (ProduceRequestData)forCurrentMagic_data).build();
        ProduceResponse produceResponse = this.sendProduceRequest(nonReplicaId, produceRequest);
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse.data().responses()).asScala().head();
        Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicProduceResponse.partitionResponses()).asScala().head();
        Assertions.assertEquals((Object)Errors.NOT_LEADER_OR_FOLLOWER, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
    }

    private Tuple2<Object, Object> createTopicAndFindPartitionWithLeader(String topic) {
        return (Tuple2)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 3, 2, (Seq<KafkaBroker>)this.servers(), new Properties()).collectFirst((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 != null) {
                    int partition = x1._1$mcI$sp();
                    int leader = x1._2$mcI$sp();
                    if (leader != -1) {
                        return (B1)new Tuple2.mcII.sp(partition, leader);
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Object, Object> x1) {
                return x1 != null && x1._2$mcI$sp() != -1;
            }
        }).getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(28).append("No leader elected for topic ").append(topic).toString());
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCorruptLz4ProduceRequest() {
        void var3_3;
        void var2_2;
        void withRecords_records;
        void withRecords_timestampType;
        Tuple2<Object, Object> tuple2 = this.createTopicAndFindPartitionWithLeader("topic");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int partition = tuple2._1$mcI$sp();
        int leader = tuple2._2$mcI$sp();
        int timestamp = 1000000;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(Int$.MODULE$.int2long(timestamp), "key".getBytes(), "value".getBytes())};
        CompressionType withRecords_compressionType = CompressionType.LZ4;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var12_6 = null;
        simpleRecordArray = null;
        MemoryRecords memoryRecords = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        int lz4ChecksumOffset = 6;
        memoryRecords.buffer().array()[61 + lz4ChecksumOffset] = 0;
        TopicPartition topicPartition = new TopicPartition("topic", (int)var2_2);
        ProduceRequestData forCurrentMagic_data = new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(topicPartition.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)memoryRecords)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null);
        Object var14_13 = null;
        ProduceResponse produceResponse = this.sendProduceRequest((int)var3_3, (ProduceRequest)ProduceRequest.forMagic((byte)2, (ProduceRequestData)forCurrentMagic_data).build());
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse.data().responses()).asScala().head();
        Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicProduceResponse.partitionResponses()).asScala().head();
        TopicPartition tp = new TopicPartition(topicProduceResponse.name(), partitionProduceResponse.index());
        Assertions.assertEquals((Object)topicPartition, (Object)tp);
        Assertions.assertEquals((Object)Errors.CORRUPT_MESSAGE, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
        Assertions.assertEquals((long)-1L, (long)partitionProduceResponse.baseOffset());
        Assertions.assertEquals((long)-1L, (long)partitionProduceResponse.logAppendTimeMs());
        Assertions.assertEquals((int)this.metricsKeySet().count((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ProduceRequestTest.$anonfun$testCorruptLz4ProduceRequest$1(x$10))), (int)1);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMessageCrcRecordsPerSec())) > 0L ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZSTDProduceRequest() {
        void withRecords_records;
        void withRecords_timestampType;
        String topic = "topic";
        int partition = 0;
        Properties topicConfig = new Properties();
        topicConfig.setProperty("compression.type", BrokerCompressionType.ZSTD.name);
        int leader = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaBroker>)this.servers(), topicConfig).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())};
        CompressionType withRecords_compressionType = CompressionType.ZSTD;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var16_6 = null;
        simpleRecordArray = null;
        MemoryRecords memoryRecords = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        ProduceRequestData partitionRecords = new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName("topic").setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(partition).setRecords((BaseRecords)memoryRecords)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null);
        ProduceResponse produceResponse1 = this.sendProduceRequest(leader, (ProduceRequest)new ProduceRequest.Builder(7, 7, partitionRecords).build());
        ProduceResponseData.TopicProduceResponse topicProduceResponse1 = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse1.data().responses()).asScala().head();
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse1 = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicProduceResponse1.partitionResponses()).asScala().head();
        TopicPartition tp1 = new TopicPartition(topicProduceResponse1.name(), partitionProduceResponse1.index());
        Assertions.assertEquals((Object)topicPartition, (Object)tp1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)partitionProduceResponse1.errorCode()));
        Assertions.assertEquals((long)0L, (long)partitionProduceResponse1.baseOffset());
        Assertions.assertEquals((long)-1L, (long)partitionProduceResponse1.logAppendTimeMs());
        ProduceResponse produceResponse2 = this.sendProduceRequest(leader, new ProduceRequest.Builder(3, 3, partitionRecords).buildUnsafe((short)3));
        ProduceResponseData.TopicProduceResponse topicProduceResponse2 = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse2.data().responses()).asScala().head();
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse2 = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicProduceResponse2.partitionResponses()).asScala().head();
        TopicPartition tp2 = new TopicPartition(topicProduceResponse2.name(), partitionProduceResponse2.index());
        Assertions.assertEquals((Object)topicPartition, (Object)tp2);
        Assertions.assertEquals((Object)Errors.UNSUPPORTED_COMPRESSION_TYPE, (Object)Errors.forCode((short)partitionProduceResponse2.errorCode()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testProduceRequestIncludesRecordsRejectedByTheSameInterceptor() {
        void withRecords_records;
        void withRecords_timestampType;
        String topic = "topic";
        int partition = 0;
        Properties topicConfig = new Properties();
        topicConfig.setProperty("confluent.append.record.interceptor.classes", InterceptorUtils.MockRecordInterceptor.class.getName());
        int leader = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaBroker>)this.servers(), topicConfig).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key0".getBytes(), "reject me".getBytes()), new SimpleRecord(System.currentTimeMillis(), "key1".getBytes(), "reject me".getBytes()), new SimpleRecord(System.currentTimeMillis(), "key2".getBytes(), "value".getBytes()), new SimpleRecord(System.currentTimeMillis(), "key3".getBytes(), "value".getBytes()), new SimpleRecord(System.currentTimeMillis(), "key4".getBytes(), "reject me".getBytes()), new SimpleRecord(System.currentTimeMillis(), "key5".getBytes(), "value".getBytes())};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var11_6 = null;
        simpleRecordArray = null;
        MemoryRecords memoryRecords = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        ProduceResponse produceResponse = this.sendProduceRequest(leader, this.buildProduceRequest(topicPartition, -1, 3000, (Records)memoryRecords));
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicResponse = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse.data().responses()).asScala().head();
        Assertions.assertEquals((int)1, (int)topicResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionResponse = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicResponse.partitionResponses()).asScala().head();
        Assertions.assertEquals((Object)topicPartition.topic(), (Object)topicResponse.name());
        Assertions.assertEquals((int)topicPartition.partition(), (int)partitionResponse.index());
        Assertions.assertEquals((short)Errors.INVALID_RECORD.code(), (short)partitionResponse.errorCode());
        Assertions.assertEquals((long)-1L, (long)partitionResponse.baseOffset());
        Assertions.assertEquals((long)-1L, (long)partitionResponse.logAppendTimeMs());
        Assertions.assertNotNull((Object)partitionResponse.recordErrors());
        java.util.List recordErrors = partitionResponse.recordErrors();
        Assertions.assertEquals((int)3, (int)recordErrors.size());
        Assertions.assertEquals((int)0, (int)((ProduceResponseData.BatchIndexAndErrorMessage)recordErrors.get(0)).batchIndex());
        Assertions.assertTrue((boolean)((ProduceResponseData.BatchIndexAndErrorMessage)recordErrors.get(0)).batchIndexErrorMessage().endsWith(new StringBuilder(35).append("rejected by the record interceptor ").append(InterceptorUtils.MockRecordInterceptor.class.getName()).toString()));
        Assertions.assertEquals((int)1, (int)((ProduceResponseData.BatchIndexAndErrorMessage)recordErrors.get(1)).batchIndex());
        Assertions.assertTrue((boolean)((ProduceResponseData.BatchIndexAndErrorMessage)recordErrors.get(1)).batchIndexErrorMessage().endsWith(new StringBuilder(35).append("rejected by the record interceptor ").append(InterceptorUtils.MockRecordInterceptor.class.getName()).toString()));
        Assertions.assertEquals((int)4, (int)((ProduceResponseData.BatchIndexAndErrorMessage)recordErrors.get(2)).batchIndex());
        Assertions.assertTrue((boolean)((ProduceResponseData.BatchIndexAndErrorMessage)recordErrors.get(2)).batchIndexErrorMessage().endsWith(new StringBuilder(35).append("rejected by the record interceptor ").append(InterceptorUtils.MockRecordInterceptor.class.getName()).toString()));
        Assertions.assertTrue((boolean)partitionResponse.errorMessage().startsWith("One or more records have been rejected due to 3 record errors in total"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testProduceRequestIncludesRecordsRejectedByDifferentInterceptors() {
        void withRecords_records;
        void withRecords_timestampType;
        String topic = "topic";
        int partition = 0;
        Properties topicConfig = new Properties();
        topicConfig.setProperty("confluent.append.record.interceptor.classes", new StringBuilder(1).append(InterceptorUtils.MockRecordInterceptor.class.getName()).append(",").append(InterceptorUtils.AnotherMockRecordInterceptor.class.getName()).toString());
        int leader = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaBroker>)this.servers(), topicConfig).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key0".getBytes(), "reject me".getBytes()), new SimpleRecord(System.currentTimeMillis(), "key1".getBytes(), "value".getBytes()), new SimpleRecord(System.currentTimeMillis(), "key2".getBytes(), "reject me please".getBytes()), new SimpleRecord(System.currentTimeMillis(), "key3".getBytes(), "value".getBytes())};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var11_6 = null;
        simpleRecordArray = null;
        MemoryRecords memoryRecords = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        ProduceResponse produceResponse = this.sendProduceRequest(leader, this.buildProduceRequest(topicPartition, -1, 3000, (Records)memoryRecords));
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicResponse = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse.data().responses()).asScala().head();
        Assertions.assertEquals((int)1, (int)topicResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionResponse = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicResponse.partitionResponses()).asScala().head();
        Assertions.assertEquals((Object)topicPartition.topic(), (Object)topicResponse.name());
        Assertions.assertEquals((int)topicPartition.partition(), (int)partitionResponse.index());
        Assertions.assertEquals((short)Errors.INVALID_RECORD.code(), (short)partitionResponse.errorCode());
        Assertions.assertEquals((long)-1L, (long)partitionResponse.baseOffset());
        Assertions.assertEquals((long)-1L, (long)partitionResponse.logAppendTimeMs());
        Assertions.assertNotNull((Object)partitionResponse.recordErrors());
        java.util.List recordErrors = partitionResponse.recordErrors();
        Assertions.assertEquals((int)2, (int)recordErrors.size());
        Assertions.assertEquals((int)0, (int)((ProduceResponseData.BatchIndexAndErrorMessage)recordErrors.get(0)).batchIndex());
        Assertions.assertTrue((boolean)((ProduceResponseData.BatchIndexAndErrorMessage)partitionResponse.recordErrors().get(0)).batchIndexErrorMessage().endsWith(new StringBuilder(35).append("rejected by the record interceptor ").append(InterceptorUtils.MockRecordInterceptor.class.getName()).toString()));
        Assertions.assertEquals((int)2, (int)((ProduceResponseData.BatchIndexAndErrorMessage)recordErrors.get(1)).batchIndex());
        Assertions.assertTrue((boolean)((ProduceResponseData.BatchIndexAndErrorMessage)partitionResponse.recordErrors().get(1)).batchIndexErrorMessage().endsWith(new StringBuilder(35).append("rejected by the record interceptor ").append(InterceptorUtils.AnotherMockRecordInterceptor.class.getName()).toString()));
        Assertions.assertTrue((boolean)partitionResponse.errorMessage().startsWith("One or more records have been rejected due to 2 record errors in total"));
    }

    private ProduceRequest buildProduceRequest(TopicPartition topicPartition, int acks, int timeoutMs, Records records) {
        ProduceRequestData.PartitionProduceData partitionData = new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)records);
        ProduceRequestData.TopicProduceData topicData = new ProduceRequestData.TopicProduceData().setName(topicPartition.topic()).setPartitionData(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)partitionData, (List)Nil$.MODULE$)).asJava());
        ProduceRequestData produceData = new ProduceRequestData().setAcks((short)acks).setTimeoutMs(timeoutMs);
        produceData.topicData().add((ImplicitLinkedHashCollection.Element)topicData);
        return (ProduceRequest)ProduceRequest.forMagic((byte)2, (ProduceRequestData)produceData).build();
    }

    @Test
    public void testProduceRequestIncludesInvalidTimestampAndInterceptedRecords() {
        String topic = "topic";
        int partition = 0;
        Properties topicConfig = new Properties();
        topicConfig.setProperty("message.timestamp.difference.max.ms", "1000");
        topicConfig.setProperty("confluent.append.record.interceptor.classes", InterceptorUtils.MockRecordInterceptor.class.getName());
        int leader = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaBroker>)this.servers(), topicConfig).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        long timestamp = System.currentTimeMillis() - 1001L;
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(512), (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(1L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "beautiful".getBytes());
        builder.appendWithOffset(3L, System.currentTimeMillis(), null, "reject me".getBytes());
        MemoryRecords records = builder.build();
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        ProduceResponse produceResponse = this.sendProduceRequest(leader, this.buildProduceRequest(topicPartition, -1, 3000, (Records)records));
        ProduceResponseData.TopicProduceResponse topicResponse = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse.data().responses()).asScala().head();
        ProduceResponseData.PartitionProduceResponse partitionResponse = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicResponse.partitionResponses()).asScala().head();
        Assertions.assertEquals((Object)topicPartition.topic(), (Object)topicResponse.name());
        Assertions.assertEquals((int)topicPartition.partition(), (int)partitionResponse.index());
        Assertions.assertEquals((short)Errors.INVALID_TIMESTAMP.code(), (short)partitionResponse.errorCode());
        Assertions.assertEquals((int)4, (int)partitionResponse.recordErrors().size());
        Assertions.assertTrue((boolean)((ProduceResponseData.BatchIndexAndErrorMessage)partitionResponse.recordErrors().get(3)).batchIndexErrorMessage().endsWith(new StringBuilder(35).append("rejected by the record interceptor ").append(InterceptorUtils.MockRecordInterceptor.class.getName()).toString()));
        Assertions.assertEquals((Object)"One or more records have been rejected due to invalid timestamp", (Object)partitionResponse.errorMessage());
    }

    private ProduceResponse sendProduceRequest(int leaderId, ProduceRequest request) {
        return (ProduceResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ProduceResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private final void sendAndCheck$1(MemoryRecords memoryRecords, long expectedOffset, int partition$1, int leader$1) {
        TopicPartition topicPartition = new TopicPartition("topic", partition$1);
        ProduceRequestData forCurrentMagic_data = new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(topicPartition.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)memoryRecords)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null);
        Object var11_6 = null;
        ProduceResponse produceResponse = this.sendProduceRequest(leader$1, (ProduceRequest)ProduceRequest.forMagic((byte)2, (ProduceRequestData)forCurrentMagic_data).build());
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse.data().responses()).asScala().head();
        Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicProduceResponse.partitionResponses()).asScala().head();
        TopicPartition tp = new TopicPartition(topicProduceResponse.name(), partitionProduceResponse.index());
        Assertions.assertEquals((Object)topicPartition, (Object)tp);
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
        Assertions.assertEquals((long)expectedOffset, (long)partitionProduceResponse.baseOffset());
        Assertions.assertEquals((long)-1L, (long)partitionProduceResponse.logAppendTimeMs());
        Assertions.assertTrue((boolean)partitionProduceResponse.recordErrors().isEmpty());
    }

    public static final /* synthetic */ int $anonfun$testProduceRequestDuringPartitionRecoveryAfterUncleanLeaderElection$2(KafkaServer x$3) {
        return x$3.config().brokerId();
    }

    /*
     * WARNING - void declaration
     */
    private final void produceRecordsAndValidateResponse$1(int brokerId, Errors error, int expectedOffset, TopicPartition partition$2) {
        void withRecords_records;
        void withRecords_timestampType;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var9_6 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        ProduceResponse produceResponse = this.sendProduceRequest(brokerId, this.buildProduceRequest(partition$2, -1, 3000, (Records)records));
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicResponse = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse.data().responses()).asScala().head();
        Assertions.assertEquals((int)1, (int)topicResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionResponse = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicResponse.partitionResponses()).asScala().head();
        Assertions.assertEquals((Object)partition$2.topic(), (Object)topicResponse.name());
        Assertions.assertEquals((int)partition$2.partition(), (int)partitionResponse.index());
        Assertions.assertEquals((long)expectedOffset, (long)partitionResponse.baseOffset(), (String)"Unexpected base Offset");
        Assertions.assertEquals((short)error.code(), (short)partitionResponse.errorCode(), (String)"Unexpected error");
        if (Errors.NONE.equals(error)) {
            Assertions.assertNotEquals((long)-1L, (long)partitionResponse.logAppendTimeMs(), (String)"Unexpected logAppendTime");
            Assertions.assertNotEquals((long)-1L, (long)partitionResponse.logStartOffset(), (String)"No error; Unexpected logStartOffset");
        } else {
            Assertions.assertEquals((long)-1L, (long)partitionResponse.logAppendTimeMs(), (String)"Unexpected logAppendTime during error condition");
            Assertions.assertEquals((long)-1L, (long)partitionResponse.logStartOffset(), (String)"Unexpected logStartOffset during error condition");
        }
        Assertions.assertTrue((boolean)partitionResponse.recordErrors().isEmpty());
    }

    public static final /* synthetic */ boolean $anonfun$testProduceRequestDuringPartitionRecoveryAfterUncleanLeaderElection$4(int leader$2, KafkaServer x$5) {
        return x$5.config().brokerId() == leader$2;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceRequestDuringPartitionRecoveryAfterUncleanLeaderElection$5(int leader$2, KafkaServer x$6) {
        return x$6.config().brokerId() == leader$2;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceRequestDuringPartitionRecoveryAfterUncleanLeaderElection$6(int leader$2, KafkaServer x$7) {
        return x$7.config().brokerId() == leader$2;
    }

    private static final MemoryRecords createRecords$1(byte magicValue, long timestamp, CompressionType codec) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(512), (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(1L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    public static final /* synthetic */ void $anonfun$testProduceWithInvalidTimestamp$2(ProduceResponseData.BatchIndexAndErrorMessage recordError) {
        Assertions.assertNotNull((Object)recordError.batchIndexErrorMessage());
    }

    public static final /* synthetic */ boolean $anonfun$testProduceToNonReplica$1(int leader$3, KafkaServer x$8) {
        return x$8.config().brokerId() != leader$3;
    }

    public static final /* synthetic */ boolean $anonfun$testCorruptLz4ProduceRequest$1(MetricName x$10) {
        return x$10.getMBeanName().endsWith(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMessageCrcRecordsPerSec()));
    }
}

