/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import java.util.OptionalInt;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.Fetching$;
import kafka.server.InitialFetchState;
import kafka.server.LeaderEndPoint;
import kafka.server.MockFetcherThread$;
import kafka.server.MockLeaderEndPoint;
import kafka.server.MockTierStateMachine;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionState;
import kafka.server.TierStateMachine;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.junit.jupiter.api.Assertions;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\u0005a\u0001\u0002\u0014(\u00011B\u0001\"\r\u0001\u0003\u0006\u0004%\tA\r\u0005\tm\u0001\u0011\t\u0011)A\u0005g!Aq\u0007\u0001BC\u0002\u0013\u0005\u0001\b\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003:\u0011!i\u0004A!b\u0001\n\u0003q\u0004\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011B \t\u0011\u0019\u0003!Q1A\u0005\u0002yB\u0001b\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0013\"Aa\u000b\u0001B\u0001B\u0003%q\u000bC\u0003[\u0001\u0011\u00051\fC\u0004d\u0001\t\u0007I\u0011\u00023\t\rQ\u0004\u0001\u0015!\u0003f\u0011\u001d)\b\u00011A\u0005\nYDqA\u001f\u0001A\u0002\u0013%1\u0010C\u0004\u0002\u0004\u0001\u0001\u000b\u0015B<\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\b!9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0001bBA\f\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u0003O\u0001A\u0011AA\u0015\u0011\u001d\tY\u0005\u0001C!\u0003\u001bBq!a\u001e\u0001\t\u0003\nI\bC\u0004\u0002\b\u0002!\t%!#\t\u000f\u0005E\u0005\u0001\"\u0011\u0002\u0014\"9\u0011q\u0013\u0001\u0005B\u0005e\u0005bBAO\u0001\u0011\u0005\u0013q\u0014\u0005\b\u0003G\u0003A\u0011IAS\u0011%\tY\f\u0001b\u0001\n#\ni\f\u0003\u0005\u0002@\u0002\u0001\u000b\u0011BA#\u0011\u001d\t\t\r\u0001C\u0001\u0003\u0007<\u0011\"!4(\u0003\u0003E\t!a4\u0007\u0011\u0019:\u0013\u0011!E\u0001\u0003#DaA\u0017\u0011\u0005\u0002\u0005e\u0007\"CAnAE\u0005I\u0011AAo\u0011%\t\u0019\u0010II\u0001\n\u0003\ti\u000eC\u0005\u0002v\u0002\n\n\u0011\"\u0001\u0002x\"I\u00111 \u0011\u0012\u0002\u0013\u0005\u0011Q \u0002\u0012\u001b>\u001c7NR3uG\",'\u000f\u00165sK\u0006$'B\u0001\u0015*\u0003\u0019\u0019XM\u001d<fe*\t!&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001i\u0003C\u0001\u00180\u001b\u00059\u0013B\u0001\u0019(\u0005U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\f!\"\\8dW2+\u0017\rZ3s+\u0005\u0019\u0004C\u0001\u00185\u0013\t)tE\u0001\nN_\u000e\\G*Z1eKJ,e\u000e\u001a)pS:$\u0018aC7pG.dU-\u00193fe\u0002\nA#\\8dWRKWM]*uCR,W*Y2iS:,W#A\u001d\u0011\u00059R\u0014BA\u001e(\u0005QiunY6US\u0016\u00148\u000b^1uK6\u000b7\r[5oK\u0006)Rn\\2l)&,'o\u0015;bi\u0016l\u0015m\u00195j]\u0016\u0004\u0013!\u0003:fa2L7-Y%e+\u0005y\u0004C\u0001!D\u001b\u0005\t%\"\u0001\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\u000b%aA%oi\u0006Q!/\u001a9mS\u000e\f\u0017\n\u001a\u0011\u0002\u00111,\u0017\rZ3s\u0013\u0012\f\u0011\u0002\\3bI\u0016\u0014\u0018\n\u001a\u0011\u0002%\u0015D\bo\u001c8f]RL\u0017\r\u001c\"bG.|gM\u001a\t\u0003\u0015Rk\u0011a\u0013\u0006\u0003\u00196\u000bQ!\u001e;jYNT!AT(\u0002\r\r|W.\\8o\u0015\tQ\u0003K\u0003\u0002R%\u00061\u0011\r]1dQ\u0016T\u0011aU\u0001\u0004_J<\u0017BA+L\u0005I)\u0005\u0010]8oK:$\u0018.\u00197CC\u000e\\wN\u001a4\u0002!\u0019\f\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001c\bC\u0001\u0018Y\u0013\tIvE\u0001\tGC&dW\r\u001a)beRLG/[8og\u00061A(\u001b8jiz\"r\u0001X/_?\u0002\f'\r\u0005\u0002/\u0001!)\u0011g\u0003a\u0001g!)qg\u0003a\u0001s!9Qh\u0003I\u0001\u0002\u0004y\u0004b\u0002$\f!\u0003\u0005\ra\u0010\u0005\b\u0011.\u0001\n\u00111\u0001J\u0011\u001d16\u0002%AA\u0002]\u000baC]3qY&\u001c\u0017\rU1si&$\u0018n\u001c8Ti\u0006$Xm]\u000b\u0002KB!am[7r\u001b\u00059'B\u00015j\u0003\u001diW\u000f^1cY\u0016T!A[!\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002mO\n\u0019Q*\u00199\u0011\u00059|W\"A'\n\u0005Al%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003]IL!a]\u0014\u0003\u001dA\u000b'\u000f^5uS>t7\u000b^1uK\u00069\"/\u001a9mS\u000e\f\u0007+\u0019:uSRLwN\\*uCR,7\u000fI\u0001\u0013Y\u0006$Xm\u001d;Fa>\u001c\u0007\u000eR3gCVdG/F\u0001x!\r\u0001\u0005pP\u0005\u0003s\u0006\u0013aa\u00149uS>t\u0017A\u00067bi\u0016\u001cH/\u00129pG\"$UMZ1vYR|F%Z9\u0015\u0005q|\bC\u0001!~\u0013\tq\u0018I\u0001\u0003V]&$\b\u0002CA\u0001\u001f\u0005\u0005\t\u0019A<\u0002\u0007a$\u0013'A\nmCR,7\u000f^#q_\u000eDG)\u001a4bk2$\b%A\btKR\u0014V\r\u001d7jG\u0006\u001cF/\u0019;f)\u0015a\u0018\u0011BA\u0007\u0011\u0019\tY!\u0005a\u0001[\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007BBA\b#\u0001\u0007\u0011/A\u0003ti\u0006$X-A\u000bsKBd\u0017nY1QCJ$\u0018\u000e^5p]N#\u0018\r^3\u0015\u0007E\f)\u0002\u0003\u0004\u0002\fI\u0001\r!\\\u0001\u0011e\u0016\u001cHo\u001c:f)&,'o\u0015;bi\u0016$R\u0001`A\u000e\u0003;Aa!a\u0003\u0014\u0001\u0004i\u0007bBA\u0010'\u0001\u0007\u0011\u0011E\u0001\u0016aJ|\u0007o\\:fI2{7-\u00197M_\u001e\u001cF/\u0019:u!\r\u0001\u00151E\u0005\u0004\u0003K\t%\u0001\u0002'p]\u001e\fQ\"\u00193e!\u0006\u0014H/\u001b;j_:\u001cHCBA\u0016\u0003g\t\t\u0005E\u0003\u0002.\u0005=R.D\u0001j\u0013\r\t\t$\u001b\u0002\u0004'\u0016$\bbBA\u001b)\u0001\u0007\u0011qG\u0001\u0013S:LG/[1m\r\u0016$8\r[*uCR,7\u000fE\u0004\u0002.\u0005eR.a\u000f\n\u00051L\u0007c\u0001\u0018\u0002>%\u0019\u0011qH\u0014\u0003#%s\u0017\u000e^5bY\u001a+Go\u00195Ti\u0006$X\rC\u0004\u0002DQ\u0001\r!!\u0012\u0002\u001f\u0019|'oY3UeVt7-\u0019;j_:\u00042\u0001QA$\u0013\r\tI%\u0011\u0002\b\u0005>|G.Z1o\u0003Q\u0001(o\\2fgN\u0004\u0016M\u001d;ji&|g\u000eR1uCRA\u0011qJA3\u0003O\nY\u0007\u0005\u0003Aq\u0006E\u0003\u0003BA*\u0003Cj!!!\u0016\u000b\t\u0005]\u0013\u0011L\u0001\u0004Y><'\u0002BA.\u0003;\n\u0011\"\u001b8uKJt\u0017\r\\:\u000b\u0007\u0005}s*A\u0004ti>\u0014\u0018mZ3\n\t\u0005\r\u0014Q\u000b\u0002\u000e\u0019><\u0017\t\u001d9f]\u0012LeNZ8\t\r\u0005-Q\u00031\u0001n\u0011\u001d\tI'\u0006a\u0001\u0003C\t1BZ3uG\"|eMZ:fi\"9\u0011QN\u000bA\u0002\u0005=\u0014!\u00049beRLG/[8o\t\u0006$\u0018\r\u0005\u0003\u0002r\u0005MT\"\u0001\u0001\n\u0007\u0005UtFA\u0005GKR\u001c\u0007\u000eR1uC\u0006AAO];oG\u0006$X\r\u0006\u0004\u0002F\u0005m\u0014Q\u0010\u0005\u0007\u0003\u00171\u0002\u0019A7\t\u000f\u0005}d\u00031\u0001\u0002\u0002\u0006yAO];oG\u0006$\u0018n\u001c8Ti\u0006$X\rE\u0002/\u0003\u0007K1!!\"(\u0005UyeMZ:fiR\u0013XO\\2bi&|gn\u0015;bi\u0016\fq\u0003\u001e:v]\u000e\fG/\u001a$vY2L\u0018I\u001c3Ti\u0006\u0014H/\u0011;\u0015\u000bq\fY)!$\t\r\u0005-q\u00031\u0001n\u0011\u001d\tyi\u0006a\u0001\u0003C\taa\u001c4gg\u0016$\u0018a\u00037bi\u0016\u001cH/\u00129pG\"$2a^AK\u0011\u0019\tY\u0001\u0007a\u0001[\u0006qAn\\4Ti\u0006\u0014Ho\u00144gg\u0016$H\u0003BA\u0011\u00037Ca!a\u0003\u001a\u0001\u0004i\u0017\u0001\u00047pO\u0016sGm\u00144gg\u0016$H\u0003BA\u0011\u0003CCa!a\u0003\u001b\u0001\u0004i\u0017!E3oI>3gm]3u\r>\u0014X\t]8dQR1\u0011qUA[\u0003o\u0003B\u0001\u0011=\u0002*B!\u00111VAY\u001b\t\tiKC\u0002O\u0003_S!\u0001K(\n\t\u0005M\u0016Q\u0016\u0002\u000f\u001f\u001a47/\u001a;B]\u0012,\u0005o\\2i\u0011\u0019\tYa\u0007a\u0001[\"1\u0011\u0011X\u000eA\u0002}\nQ!\u001a9pG\"\fq$[:PM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s\u000bB|7\r[*vaB|'\u000f^3e+\t\t)%\u0001\u0011jg>3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i'V\u0004\bo\u001c:uK\u0012\u0004\u0013A\u0006<fe&4\u0017\u0010T1ti\u001a+Go\u00195fI\u0016\u0003xn\u00195\u0015\u000bq\f)-!3\t\r\u0005\u001dg\u00041\u0001n\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0003\u0004\u0002Lz\u0001\ra^\u0001\u000eKb\u0004Xm\u0019;fI\u0016\u0003xn\u00195\u0002#5{7m\u001b$fi\u000eDWM\u001d+ie\u0016\fG\r\u0005\u0002/AM\u0019\u0001%a5\u0011\u0007\u0001\u000b).C\u0002\u0002X\u0006\u0013a!\u00118z%\u00164GCAAh\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\u001c\u0016\u0004\u007f\u0005\u00058FAAr!\u0011\t)/a<\u000e\u0005\u0005\u001d(\u0002BAu\u0003W\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u00055\u0018)\u0001\u0006b]:|G/\u0019;j_:LA!!=\u0002h\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011\u0011 \u0016\u0004\u0013\u0006\u0005\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$c'\u0006\u0002\u0002\u0000*\u001aq+!9")
public class MockFetcherThread
extends AbstractFetcherThread {
    private final MockLeaderEndPoint mockLeader;
    private final MockTierStateMachine mockTierStateMachine;
    private final int replicaId;
    private final int leaderId;
    private final scala.collection.mutable.Map<TopicPartition, PartitionState> replicaPartitionStates;
    private Option<Object> latestEpochDefault;
    private final boolean isOffsetForLeaderEpochSupported;

    public static FailedPartitions $lessinit$greater$default$6() {
        return new FailedPartitions();
    }

    public static ExponentialBackoff $lessinit$greater$default$5() {
        return MockFetcherThread$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return 1;
    }

    public static int $lessinit$greater$default$3() {
        return 0;
    }

    public MockLeaderEndPoint mockLeader() {
        return this.mockLeader;
    }

    public MockTierStateMachine mockTierStateMachine() {
        return this.mockTierStateMachine;
    }

    public int replicaId() {
        return this.replicaId;
    }

    public int leaderId() {
        return this.leaderId;
    }

    private scala.collection.mutable.Map<TopicPartition, PartitionState> replicaPartitionStates() {
        return this.replicaPartitionStates;
    }

    private Option<Object> latestEpochDefault() {
        return this.latestEpochDefault;
    }

    private void latestEpochDefault_$eq(Option<Object> x$1) {
        this.latestEpochDefault = x$1;
    }

    public void setReplicaState(TopicPartition topicPartition, PartitionState state) {
        this.replicaPartitionStates().put((Object)topicPartition, (Object)state);
    }

    public PartitionState replicaPartitionState(TopicPartition topicPartition) {
        return (PartitionState)this.replicaPartitionStates().getOrElse((Object)topicPartition, (Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(18).append("Unknown partition ").append(topicPartition).toString());
        });
    }

    public void restoreTierState(TopicPartition topicPartition, long proposedLocalLogStart) {
        this.replicaPartitionState(topicPartition).logEndOffset_$eq(proposedLocalLogStart);
        this.replicaPartitionState(topicPartition).highWatermark_$eq(proposedLocalLogStart);
    }

    public Set<TopicPartition> addPartitions(Map<TopicPartition, InitialFetchState> initialFetchStates, boolean forceTruncation) {
        this.latestEpochDefault_$eq((Option<Object>)(forceTruncation ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)0))));
        Set partitions = super.addPartitions(initialFetchStates);
        this.latestEpochDefault_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)));
        return partitions;
    }

    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
        PartitionState state = this.replicaPartitionState(topicPartition);
        if (this.mockLeader().isTruncationOnFetchSupported() && FetchResponse.isDivergingEpoch((FetchResponseData.PartitionData)partitionData)) {
            FetchResponseData.EpochEndOffset divergingEpoch = partitionData.divergingEpoch();
            this.truncateOnFetchResponse((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(topicPartition.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(divergingEpoch.epoch()).setEndOffset(divergingEpoch.endOffset()))})));
            return None$.MODULE$;
        }
        if (fetchOffset != state.logEndOffset()) {
            throw new RuntimeException(new StringBuilder(69).append("Offset mismatch for partition ").append(topicPartition).append(": ").append("fetched offset = ").append(fetchOffset).append(", log end offset = ").append(state.logEndOffset()).append(".").toString());
        }
        Iterable batches = CollectionConverters$.MODULE$.IterableHasAsScala(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData).batches()).asScala();
        LongRef maxTimestamp = LongRef.create((long)-1L);
        LongRef offsetOfMaxTimestamp = LongRef.create((long)-1L);
        LongRef lastOffset = LongRef.create((long)state.logEndOffset());
        ObjectRef lastEpoch = ObjectRef.create((Object)OptionalInt.empty());
        batches.foreach((Function1 & Serializable)batch -> {
            MockFetcherThread.$anonfun$processPartitionData$1(maxTimestamp, offsetOfMaxTimestamp, state, lastOffset, lastEpoch, batch);
            return BoxedUnit.UNIT;
        });
        state.logStartOffset_$eq(partitionData.logStartOffset());
        state.highWatermark_$eq(partitionData.highWatermark());
        return new Some((Object)new LogAppendInfo(Optional.of(new LogOffsetMetadata(fetchOffset)), lastOffset.elem, (OptionalInt)lastEpoch.elem, maxTimestamp.elem, offsetOfMaxTimestamp.elem, Time.SYSTEM.milliseconds(), state.logStartOffset(), RecordConversionStats.EMPTY, CompressionType.NONE, CompressionType.NONE, batches.size(), FetchResponse.recordsSize((FetchResponseData.PartitionData)partitionData), true, BoxesRunTime.unboxToLong((Object)batches.headOption().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.lastOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L))));
    }

    public boolean truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        PartitionState state = this.replicaPartitionState(topicPartition);
        state.log_$eq((Buffer<RecordBatch>)((Buffer)state.log().takeWhile((Function1 & Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)MockFetcherThread.$anonfun$truncate$1(truncationState, batch)))));
        state.logEndOffset_$eq(BoxesRunTime.unboxToLong((Object)state.log().lastOption().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)MockFetcherThread.$anonfun$truncate$2(x$2))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> state.logStartOffset())));
        state.highWatermark_$eq(package$.MODULE$.min(state.highWatermark(), state.logEndOffset()));
        return true;
    }

    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        PartitionState state = this.replicaPartitionState(topicPartition);
        state.log().clear();
        state.logStartOffset_$eq(offset);
        state.logEndOffset_$eq(offset);
        state.highWatermark_$eq(offset);
    }

    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaPartitionState(topicPartition).log().lastOption().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.partitionLeaderEpoch())).orElse((Function0 & Serializable)() -> this.latestEpochDefault());
    }

    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaPartitionState(topicPartition).logStartOffset();
    }

    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaPartitionState(topicPartition).logEndOffset();
    }

    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        OffsetForLeaderEpochRequestData.OffsetForLeaderPartition epochData = new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(topicPartition.partition()).setLeaderEpoch(epoch);
        OffsetForLeaderEpochResponseData.EpochEndOffset result = this.mockLeader().lookupEndOffsetForEpoch(topicPartition, epochData, this.replicaPartitionState(topicPartition));
        if (result.endOffset() == -1L) {
            return None$.MODULE$;
        }
        return new Some((Object)new OffsetAndEpoch(result.endOffset(), result.leaderEpoch()));
    }

    public boolean isOffsetForLeaderEpochSupported() {
        return this.isOffsetForLeaderEpochSupported;
    }

    public void verifyLastFetchedEpoch(TopicPartition partition, Option<Object> expectedEpoch) {
        if (this.mockLeader().isTruncationOnFetchSupported()) {
            Assertions.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)this.fetchState(partition).map((Function1 & Serializable)x$4 -> x$4.state()));
            Assertions.assertEquals(expectedEpoch, (Object)this.fetchState(partition).flatMap((Function1 & Serializable)x$5 -> x$5.lastFetchedEpoch()));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$processPartitionData$1(LongRef maxTimestamp$1, LongRef offsetOfMaxTimestamp$1, PartitionState state$1, LongRef lastOffset$1, ObjectRef lastEpoch$1, RecordBatch batch) {
        batch.ensureValid();
        if (batch.maxTimestamp() > maxTimestamp$1.elem) {
            maxTimestamp$1.elem = batch.maxTimestamp();
            offsetOfMaxTimestamp$1.elem = batch.baseOffset();
        }
        state$1.log().append((Object)batch);
        state$1.logEndOffset_$eq(batch.nextOffset());
        lastOffset$1.elem = batch.lastOffset();
        lastEpoch$1.elem = OptionalInt.of(batch.partitionLeaderEpoch());
    }

    public static final /* synthetic */ boolean $anonfun$truncate$1(OffsetTruncationState truncationState$1, RecordBatch batch) {
        return batch.lastOffset() < truncationState$1.offset();
    }

    public static final /* synthetic */ long $anonfun$truncate$2(RecordBatch x$2) {
        return x$2.lastOffset() + 1L;
    }

    public MockFetcherThread(MockLeaderEndPoint mockLeader, MockTierStateMachine mockTierStateMachine, int replicaId, int leaderId, ExponentialBackoff exponentialBackoff, FailedPartitions failedPartitions) {
        this.mockLeader = mockLeader;
        this.mockTierStateMachine = mockTierStateMachine;
        this.replicaId = replicaId;
        this.leaderId = leaderId;
        BrokerTopicStats x$7 = new BrokerTopicStats();
        boolean x$8 = true;
        Map x$9 = (Map)scala.collection.Map$.MODULE$.empty();
        super("mock-fetcher", "mock-fetcher", (LeaderEndPoint)mockLeader, failedPartitions, exponentialBackoff, (TierStateMachine)mockTierStateMachine, x$8, x$7, x$9);
        this.replicaPartitionStates = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.latestEpochDefault = new Some((Object)BoxesRunTime.boxToInteger((int)0));
        this.isOffsetForLeaderEpochSupported = true;
    }
}

