/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.stream.Stream;
import kafka.admin.BrokerMetadata;
import kafka.api.LeaderAndIsr$;
import kafka.server.MetadataCache;
import kafka.server.MetadataCacheTest$;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.ZkMetadataCache;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.ConfluentNode;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataProvenance;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t]r!\u0002\u0010 \u0011\u0003!c!\u0002\u0014 \u0011\u00039\u0003\"\u0002\u0018\u0002\t\u0003y\u0003\"\u0002\u0019\u0002\t\u0003\t\u0004\"B \u0002\t\u0003\t\u0004\"\u0002!\u0002\t\u0003\t\u0004\"B!\u0002\t\u0003\u0011e\u0001\u0002\u0014 \u0001]CQAL\u0004\u0005\u0002aCqAW\u0004C\u0002\u0013\u00051\f\u0003\u0004`\u000f\u0001\u0006I\u0001\u0018\u0005\u0006A\u001e!\t!\u0019\u0005\u0006w\u001e!\t\u0001 \u0005\b\u0003\u00079A\u0011AA\u0003\u0011\u001d\tya\u0002C\u0001\u0003#Aq!a\u0007\b\t\u0013\ti\u0002C\u0004\u0002\u0016\u001e!\t!a&\t\u000f\u0005\u0005v\u0001\"\u0001\u0002$\"9\u0011QV\u0004\u0005\u0002\u0005=\u0006bBA]\u000f\u0011\u0005\u00111\u0018\u0005\b\u0003\u000b<A\u0011AAd\u0011\u001d\t\u0019n\u0002C\u0001\u0003+Dq!!9\b\t\u0003\t\u0019\u000fC\u0004\u0002n\u001e!\t!a<\t\u000f\u0005ex\u0001\"\u0001\u0002|\"9!QA\u0004\u0005\u0002\t\u001d\u0001b\u0002B\t\u000f\u0011\u0005!1\u0003\u0005\b\u0005G9A\u0011\u0001B\n\u0011\u001d\u00119c\u0002C\u0001\u0005'AqAa\u000b\b\t\u0003\u0011i#A\tNKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a+fgRT!\u0001I\u0011\u0002\rM,'O^3s\u0015\u0005\u0011\u0013!B6bM.\f7\u0001\u0001\t\u0003K\u0005i\u0011a\b\u0002\u0012\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3UKN$8CA\u0001)!\tIC&D\u0001+\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001J\u0001\u0010u.\u001c\u0015m\u00195f!J|g/\u001b3feR\t!\u0007E\u00024uqj\u0011\u0001\u000e\u0006\u0003kY\naa\u001d;sK\u0006l'BA\u001c9\u0003\u0011)H/\u001b7\u000b\u0003e\nAA[1wC&\u00111\b\u000e\u0002\u0007'R\u0014X-Y7\u0011\u0005\u0015j\u0014B\u0001  \u00055iU\r^1eCR\f7)Y2iK\u0006i1-Y2iKB\u0013xN^5eKJ\f\u0001$\\;mi&$VM\\1oi\u000e\u000b7\r[3Qe>4\u0018\u000eZ3s\u0003-)\b\u000fZ1uK\u000e\u000b7\r[3\u0015\u0007\r3\u0005\n\u0005\u0002*\t&\u0011QI\u000b\u0002\u0005+:LG\u000fC\u0003H\r\u0001\u0007A(A\u0003dC\u000eDW\rC\u0003J\r\u0001\u0007!*A\u0004sKF,Xm\u001d;\u0011\u0005-+V\"\u0001'\u000b\u00055s\u0015\u0001\u0003:fcV,7\u000f^:\u000b\u0005=\u0003\u0016AB2p[6|gN\u0003\u0002##*\u0011!kU\u0001\u0007CB\f7\r[3\u000b\u0003Q\u000b1a\u001c:h\u0013\t1FJA\u000bVa\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;\u0014\u0005\u001dAC#A-\u0011\u0005\u0015:\u0011a\u00032s_.,'/\u00129pG\",\u0012\u0001\u0018\t\u0003SuK!A\u0018\u0016\u0003\t1{gnZ\u0001\rEJ|7.\u001a:Fa>\u001c\u0007\u000eI\u0001\"O\u0016$Hk\u001c9jG6+G/\u00193bi\u0006tuN\\#ySN$\u0018N\\4U_BL7m\u001d\u000b\u0003\u0007\nDQaR\u0006A\u0002qBCa\u00033qcB\u0011QM\\\u0007\u0002M*\u0011q\r[\u0001\taJ|g/\u001b3fe*\u0011\u0011N[\u0001\u0007a\u0006\u0014\u0018-\\:\u000b\u0005-d\u0017a\u00026va&$XM\u001d\u0006\u0003[N\u000bQA[;oSRL!a\u001c4\u0003\u00195+G\u000f[8e'>,(oY3\u0002\u000bY\fG.^3-\u0003I\f\u0013a\u0010\u0015\u0005\u0017QD\u0018\u0010\u0005\u0002vm6\t\u0001.\u0003\u0002xQ\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u0002u\u0006A2\u0010Z5ta2\f\u0017PT1nKvt\u0013/^8sk6l4\u0010M?\u0002!\u001d,G\u000fV8qS\u000elU\r^1eCR\fGCA\"~\u0011\u00159E\u00021\u0001=Q\u0011aA\r]@-\u0003IDC\u0001\u0004;ys\u0006Ys-\u001a;U_BL7-T3uC\u0012\fG/\u0019)beRLG/[8o\u0019\u0016\fG-\u001a:O_R\fe/Y5mC\ndW\rF\u0002D\u0003\u000fAQaR\u0007A\u0002qBS!\u00043q\u0003\u0017a\u0013A\u001d\u0015\u0005\u001bQD\u00180A\u001bhKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uCB\u000b'\u000f^5uS>tG*[:uK:,'OT8u\u0003Z\f\u0017\u000e\\1cY\u0016|e\u000eT3bI\u0016\u0014HcA\"\u0002\u0014!)qI\u0004a\u0001y!*a\u0002\u001a9\u0002\u00181\n!\u000f\u000b\u0003\u000fibL\u0018\u0001\u000f<fe&4\u0017\u0010V8qS\u000elU\r^1eCR\f\u0007+\u0019:uSRLwN\u001c'fC\u0012,'o\u0014:F]\u0012\u0004x.\u001b8u\u001d>$\u0018I^1jY\u0006\u0014G.\u001a\u000b\u0010\u0007\u0006}\u0011\u0011EA\u0016\u0003O\n9(a\u001f\u0002\f\")qi\u0004a\u0001y!9\u00111E\bA\u0002\u0005\u0015\u0012!F7fi\u0006$\u0017\r^1DC\u000eDWM\u0011:pW\u0016\u0014\u0018\n\u001a\t\u0004S\u0005\u001d\u0012bAA\u0015U\t\u0019\u0011J\u001c;\t\u000f\u00055r\u00021\u0001\u00020\u00059!M]8lKJ\u001c\bCBA\u0019\u0003o\tY$\u0004\u0002\u00024)\u0019\u0011Q\u0007\u0016\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002:\u0005M\"aA*fcB!\u0011QHA1\u001d\u0011\ty$a\u0017\u000f\t\u0005\u0005\u0013q\u000b\b\u0005\u0003\u0007\n)F\u0004\u0003\u0002F\u0005Mc\u0002BA$\u0003#rA!!\u0013\u0002P5\u0011\u00111\n\u0006\u0004\u0003\u001b\u001a\u0013A\u0002\u001fs_>$h(C\u0001U\u0013\t\u00116+\u0003\u0002##&\u0011q\nU\u0005\u0004\u00033r\u0015aB7fgN\fw-Z\u0005\u0005\u0003;\ny&A\rVa\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;ECR\f'bAA-\u001d&!\u00111MA3\u0005Q)\u0006\u000fZ1uK6+G/\u00193bi\u0006\u0014%o\\6fe*!\u0011QLA0\u0011\u001d\tIg\u0004a\u0001\u0003W\nA\u0002\\5ti\u0016tWM\u001d(b[\u0016\u0004B!!\u001c\u0002t5\u0011\u0011q\u000e\u0006\u0004\u0003cr\u0015a\u00028fi^|'o[\u0005\u0005\u0003k\nyG\u0001\u0007MSN$XM\\3s\u001d\u0006lW\rC\u0004\u0002z=\u0001\r!!\n\u0002\r1,\u0017\rZ3s\u0011\u001d\tih\u0004a\u0001\u0003\u007f\nQ\"\u001a=qK\u000e$X\rZ#se>\u0014\b\u0003BAA\u0003\u000fk!!a!\u000b\u0007\u0005\u0015e*\u0001\u0005qe>$xnY8m\u0013\u0011\tI)a!\u0003\r\u0015\u0013(o\u001c:t\u0011\u001d\tii\u0004a\u0001\u0003\u001f\u000b\u0011$\u001a:s_J,f.\u0019<bS2\f'\r\\3MSN$XM\\3sgB\u0019\u0011&!%\n\u0007\u0005M%FA\u0004C_>dW-\u00198\u0002G\u001d,G\u000fV8qS\u000elU\r^1eCR\f'+\u001a9mS\u000e\fgj\u001c;Bm\u0006LG.\u00192mKR\u00191)!'\t\u000b\u001d\u0003\u0002\u0019\u0001\u001f)\u000bA!\u0007/!(-\u0003IDC\u0001\u0005;ys\u0006yr-\u001a;U_BL7-T3uC\u0012\fG/Y%te:{G/\u0011<bS2\f'\r\\3\u0015\u0007\r\u000b)\u000bC\u0003H#\u0001\u0007A\bK\u0003\u0012IB\fI\u000bL\u0001sQ\u0011\tB\u000f_=\u0002a\u001d,G\u000fV8qS\u000elU\r^1eCR\fw+\u001b;i\u001d>t7+\u001e9q_J$X\rZ*fGV\u0014\u0018\u000e^=Qe>$xnY8m)\r\u0019\u0015\u0011\u0017\u0005\u0006\u000fJ\u0001\r\u0001\u0010\u0015\u0006%\u0011\u0004\u0018Q\u0017\u0017\u0002e\"\"!\u0003\u001e=z\u00039:W\r^!mSZ,'I]8lKJ\u001c8\u000b[8vY\u0012tu\u000e\u001e\"f\u001bV$\u0018\r^3e\u0005f,\u0006\u000fZ1uK\u000e\u000b7\r[3\u0015\u0007\r\u000bi\fC\u0003H'\u0001\u0007A\bK\u0003\u0014IB\f\t\rL\u0001sQ\u0011\u0019B\u000f_=\u0002)\u001d,G/\u00117m)>\u0004\u0018nY:CsR+g.\u00198u)\r\u0019\u0015\u0011\u001a\u0005\u0006\u000fR\u0001\r\u0001\u0010\u0015\u0006)\u0011\u0004\u0018Q\u001a\u0017\u0003\u0003\u001f\f\u0013\u0001\u0011\u0015\u0005)QD\u00180A\u001bhKR\fE\u000e\u001c+pa&\u001c7OQ=UK:\fg\u000e^*i_VdGMR1jY&37)Y2iK&\u001bhj\u001c;Nk2$\u0018\u000eV3oC:$HcA\"\u0002X\")q)\u0006a\u0001y!*Q\u0003\u001a9\u0002\\2\u0012\u0011Q\\\u0011\u0002a!\"Q\u0003\u001e=z\u0003\u0001:W\r^!mSZ,'O\u0011:pW\u0016\u00148o\u00155pk2$'+\u001a;ve:$\u0016mZ:\u0015\u0007\r\u000b)\u000fC\u0003H-\u0001\u0007A\bK\u0003\u0017IB\fI\u000f\f\u0002\u0002^\"\"a\u0003\u001e=z\u0003%\"Xm\u001d;HKR\u001cE.^:uKJlU\r^1eCR\fw+\u001b;i\u001f\u001a4G.\u001b8f%\u0016\u0004H.[2bgR\u00191)!=\t\u000b\u001d;\u0002\u0019\u0001\u001f)\u000b]!\u0007/!>-\u0005\u0005u\u0007\u0006B\fuqf\fA\u0003^3ti&\u001b(I]8lKJ$Um\u001a:bI\u0016$GcA\"\u0002~\")q\t\u0007a\u0001y!*\u0001\u0004\u001a9\u0003\u00021\u0012\u0011Q\u001c\u0015\u00051QD\u00180A\u000fuKN$\u0018j\u001d\"s_.,'oQ8na>tWM\u001c;EK\u001e\u0014\u0018\rZ3e)\r\u0019%\u0011\u0002\u0005\u0006\u000ff\u0001\r\u0001\u0010\u0015\u00063\u0011\u0004(Q\u0002\u0017\u0003\u0003;DC!\u0007;ys\u0006\u0011B/Z:u\u0013N\u0014%o\\6fe\u001a+gnY3e)\u0005\u0019\u0005f\u0001\u000e\u0003\u0018A!!\u0011\u0004B\u0010\u001b\t\u0011YBC\u0002\u0003\u001e)\f1!\u00199j\u0013\u0011\u0011\tCa\u0007\u0003\tQ+7\u000f^\u0001!i\u0016\u001cH/S:Ce>\\WM]%o\u0007>tGO]8mY\u0016$7\u000b[;uI><h\u000eK\u0002\u001c\u0005/\ta\u0003^3ti\u001e+G\u000fT5wK\n\u0013xn[3s\u000bB|7\r\u001b\u0015\u00049\t]\u0011\u0001\u0006;fgR<U\r\u001e)beRLG/[8o\u0013:4w\u000eF\u0002D\u0005_AQaR\u000fA\u0002qBS!\b3q\u0005ga\u0013A\u001d\u0015\u0005;QD\u0018\u0010")
public class MetadataCacheTest {
    private final long brokerEpoch;

    public static void updateCache(MetadataCache cache, UpdateMetadataRequest request) {
        MetadataCacheTest$.MODULE$.updateCache(cache, request);
    }

    public static Stream<MetadataCache> multiTenantCacheProvider() {
        return MetadataCacheTest$.MODULE$.multiTenantCacheProvider();
    }

    public static Stream<MetadataCache> cacheProvider() {
        return MetadataCacheTest$.MODULE$.cacheProvider();
    }

    public static Stream<MetadataCache> zkCacheProvider() {
        return MetadataCacheTest$.MODULE$.zkCacheProvider();
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataNonExistingTopics(MetadataCache cache) {
        String topic = "topic";
        Assertions.assertTrue((boolean)cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), cache.getTopicMetadata$default$3(), cache.getTopicMetadata$default$4()).isEmpty());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadata(MetadataCache cache) {
        String topic0 = "topic-0";
        String topic1 = "topic-1";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        IndexedSeq brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)brokerId -> MetadataCacheTest.$anonfun$getTopicMetadata$1(BoxesRunTime.unboxToInt((Object)brokerId)));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic0).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(0).setLeaderEpoch(0).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3))).setZkVersion(zkVersion).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3))).setObservers(Arrays.asList(Predef$.MODULE$.int2Integer(3))), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic0).setPartitionIndex(1).setControllerEpoch(controllerEpoch).setLeader(1).setLeaderEpoch(1).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0))).setZkVersion(zkVersion).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(4))).setObservers(Arrays.asList(Predef$.MODULE$.int2Integer(4))), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic1).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(2).setLeaderEpoch(2).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1))).setZkVersion(zkVersion).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3))), (List)Nil$.MODULE$)));
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        topicIds.put(topic0, Uuid.randomUuid());
        topicIds.put(topic1, Uuid.randomUuid());
        java.util.List<UpdateMetadataRequestData.UpdateMetadataCell> cells = Arrays.asList(new UpdateMetadataRequestData.UpdateMetadataCell().setCellId(0).setBrokers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 15).map((Function1 & Serializable)x -> MetadataCacheTest.$anonfun$getTopicMetadata$2(BoxesRunTime.unboxToInt((Object)x)))).asJava()), new UpdateMetadataRequestData.UpdateMetadataCell().setCellId(1).setBrokers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(15), 30).map((Function1 & Serializable)x -> MetadataCacheTest.$anonfun$getTopicMetadata$3(BoxesRunTime.unboxToInt((Object)x)))).asJava()));
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), Collections.emptyList(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), topicIds, cells, false).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        new .colon.colon((Object)SecurityProtocol.PLAINTEXT, (List)new .colon.colon((Object)SecurityProtocol.SSL, (List)Nil$.MODULE$)).foreach(arg_0 -> MetadataCacheTest.$anonfun$getTopicMetadata$4$adapted(cache, topicIds, (Seq)partitionStates, topic0, topic1, cells, arg_0));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataPartitionLeaderNotAvailable(MetadataCache cache) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int metadataCacheBrokerId = 0;
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, listenerName, 1, Errors.LEADER_NOT_AVAILABLE, false);
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, listenerName, 1, Errors.LEADER_NOT_AVAILABLE, true);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataPartitionListenerNotAvailableOnLeader(MetadataCache cache) {
        ListenerName plaintextListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        ListenerName sslListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL);
        .colon.colon broker0Endpoints = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host0").setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(plaintextListenerName.value()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host0").setPort(9093).setSecurityProtocol(SecurityProtocol.SSL.id).setListener(sslListenerName.value()), (List)Nil$.MODULE$));
        .colon.colon broker1Endpoints = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host1").setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(plaintextListenerName.value()), (List)Nil$.MODULE$);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)broker0Endpoints).asJava()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(1).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)broker1Endpoints).asJava()), (List)Nil$.MODULE$));
        int metadataCacheBrokerId = 0;
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, sslListenerName, 1, Errors.LISTENER_NOT_FOUND, true);
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, sslListenerName, 1, Errors.LEADER_NOT_AVAILABLE, false);
    }

    private void verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(MetadataCache cache, int metadataCacheBrokerId, Seq<UpdateMetadataRequestData.UpdateMetadataBroker> brokers, ListenerName listenerName, int leader, Errors expectedError, boolean errorUnavailableListeners) {
        String topic = "topic";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        int leaderEpoch = 1;
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0))).setZkVersion(zkVersion).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(0))), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), Collections.emptyList(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava(brokers).asJava(), Collections.emptyMap(), Collections.emptyList(), false).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        scala.collection.immutable.Set x$1 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}));
        boolean x$4 = cache.getTopicMetadata$default$3();
        Seq topicMetadatas = cache.getTopicMetadata((Set)x$1, listenerName, x$4, errorUnavailableListeners);
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadata.partitionIndex());
        Assertions.assertEquals((short)expectedError.code(), (short)partitionMetadata.errorCode());
        Assertions.assertFalse((boolean)partitionMetadata.isrNodes().isEmpty());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.replicaNodes()).asScala());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataReplicaNotAvailable(MetadataCache cache) {
        String topic = "topic";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(zkVersion).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), Collections.emptyList(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), Collections.emptyMap(), Collections.emptyList(), false).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Seq topicMetadatas = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, false, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadata.partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionMetadata.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.isrNodes()).asScala().toSet());
        Seq topicMetadatasWithError = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, true, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatasWithError.size());
        MetadataResponseData.MetadataResponseTopic topicMetadataWithError = (MetadataResponseData.MetadataResponseTopic)topicMetadatasWithError.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadataWithError.errorCode());
        java.util.List partitionMetadatasWithError = topicMetadataWithError.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatasWithError.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadataWithError = (MetadataResponseData.MetadataResponsePartition)partitionMetadatasWithError.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadataWithError.partitionIndex());
        Assertions.assertEquals((short)Errors.REPLICA_NOT_AVAILABLE.code(), (short)partitionMetadataWithError.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.isrNodes()).asScala().toSet());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataIsrNotAvailable(MetadataCache cache) {
        String topic = "topic";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("rack1").setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(zkVersion).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), Collections.emptyList(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), Collections.emptyMap(), Collections.emptyList(), false).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Seq topicMetadatas = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, false, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadata.partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionMetadata.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.isrNodes()).asScala().toSet());
        Seq topicMetadatasWithError = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, true, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatasWithError.size());
        MetadataResponseData.MetadataResponseTopic topicMetadataWithError = (MetadataResponseData.MetadataResponseTopic)topicMetadatasWithError.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadataWithError.errorCode());
        java.util.List partitionMetadatasWithError = topicMetadataWithError.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatasWithError.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadataWithError = (MetadataResponseData.MetadataResponsePartition)partitionMetadatasWithError.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadataWithError.partitionIndex());
        Assertions.assertEquals((short)Errors.REPLICA_NOT_AVAILABLE.code(), (short)partitionMetadataWithError.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.isrNodes()).asScala().toSet());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataWithNonSupportedSecurityProtocol(MetadataCache cache) {
        String topic = "topic";
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("").setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int controllerEpoch = 1;
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(3).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), Collections.emptyList(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), Collections.emptyMap(), Collections.emptyList(), false).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Seq topicMetadata = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL), cache.getTopicMetadata$default$3(), cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadata.size());
        Assertions.assertEquals((int)1, (int)((MetadataResponseData.MetadataResponseTopic)topicMetadata.head()).partitions().size());
        Assertions.assertEquals((int)-1, (int)((MetadataResponseData.MetadataResponsePartition)((MetadataResponseData.MetadataResponseTopic)topicMetadata.head()).partitions().get(0)).leaderId());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @MethodSource(value={"cacheProvider"})
    public void getAliveBrokersShouldNotBeMutatedByUpdateCache(MetadataCache cache) {
        String topic = "topic";
        Range.Inclusive initialBrokerIds = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2);
        this.updateCache$1((Seq)initialBrokerIds, topic, cache);
        Iterable aliveBrokersFromCache = cache.getAliveBrokers();
        this.updateCache$1((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3), topic, cache);
        Assertions.assertEquals((Object)initialBrokerIds.toSet(), (Object)((IterableOnceOps)aliveBrokersFromCache.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()))).toSet());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @MethodSource(value={"multiTenantCacheProvider"})
    public void getAllTopicsByTenant(MetadataCache cache) {
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        IndexedSeq brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)brokerId -> MetadataCacheTest.$anonfun$getAllTopicsByTenant$1(BoxesRunTime.unboxToInt((Object)brokerId)));
        int numTenants = 10;
        int numTopics = 10;
        int numPartitions = 10;
        ListBuffer partitionStates = new ListBuffer();
        HashMap topicIds = new HashMap();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numTenants).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)tenant -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numTopics).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)topic -> {
            String topicName = new StringBuilder(10).append("lkc-").append(tenant).append("_topic").append(topic).toString();
            topicIds.put(topicName, Uuid.randomUuid());
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions).foreach((Function1 & Serializable)part -> MetadataCacheTest.$anonfun$getAllTopicsByTenant$4(partitionStates, topicName, controllerEpoch, zkVersion, BoxesRunTime.unboxToInt((Object)part)));
        }));
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), Collections.emptyList(), CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), topicIds, Collections.emptyList(), false).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numTenants).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)tenant -> {
            String tenantName = new StringBuilder(5).append("lkc-").append(tenant).append("_").toString();
            Set topicNames = cache.getAllTopics((Option)new Some((Object)tenantName));
            Assertions.assertEquals((int)numTopics, (int)topicNames.size());
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numTopics).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)topic -> {
                String topicName = new StringBuilder(10).append("lkc-").append(tenant).append("_topic").append(topic).toString();
                Assertions.assertTrue((boolean)topicNames.contains((Object)topicName));
            });
        });
        ListBuffer partitionStates2 = new ListBuffer();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numTenants).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)tenant -> {
            String topicName = new StringBuilder(10).append("lkc-").append(tenant).append("_topic").append(numTopics).toString();
            topicIds.put(topicName, Uuid.randomUuid());
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions).foreach((Function1 & Serializable)part -> MetadataCacheTest.$anonfun$getAllTopicsByTenant$8(partitionStates2, topicName, controllerEpoch, zkVersion, BoxesRunTime.unboxToInt((Object)part)));
        });
        UpdateMetadataRequest updateMetadataRequest2 = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), Collections.emptyList(), CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)partitionStates2).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), topicIds, Collections.emptyList(), false).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest2);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numTenants).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)tenant -> {
            String tenantName = new StringBuilder(5).append("lkc-").append(tenant).append("_").toString();
            Set topicNames = cache.getAllTopics((Option)new Some((Object)tenantName));
            Assertions.assertEquals((int)(numTopics + 1), (int)topicNames.size());
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numTopics + 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)topic -> {
                String topicName = new StringBuilder(10).append("lkc-").append(tenant).append("_topic").append(topic).toString();
                Assertions.assertTrue((boolean)topicIds.containsKey(topicName));
                Assertions.assertTrue((boolean)topicNames.contains((Object)topicName));
            });
        });
        ListBuffer partitionStates3 = new ListBuffer();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numTenants).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)tenant -> {
            String topicName = new StringBuilder(11).append("lkc-").append(tenant).append("_topic2").toString();
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions).foreach((Function1 & Serializable)part -> MetadataCacheTest.$anonfun$getAllTopicsByTenant$12(partitionStates3, topicName, controllerEpoch, zkVersion, BoxesRunTime.unboxToInt((Object)part)));
        });
        UpdateMetadataRequest updateMetadataRequest3 = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), Collections.emptyList(), CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)partitionStates3).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), topicIds, Collections.emptyList(), false).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest3);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numTenants).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)tenant -> {
            String tenantName = new StringBuilder(5).append("lkc-").append(tenant).append("_").toString();
            Set topicNames = cache.getAllTopics((Option)new Some((Object)tenantName));
            Assertions.assertEquals((int)numTopics, (int)topicNames.size());
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numTopics + 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)topic -> {
                if (topic != 2) {
                    String topicName = new StringBuilder(10).append("lkc-").append(tenant).append("_topic").append(topic).toString();
                    topicIds.put(topicName, Uuid.randomUuid());
                    Assertions.assertTrue((boolean)topicNames.contains((Object)topicName));
                    return;
                }
            });
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @MethodSource(value={"zkCacheProvider"})
    public void getAllTopicsByTenantShouldFailIfCacheIsNotMultiTenant(MetadataCache cache) {
        Assertions.assertTrue((boolean)((IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> cache.getAllTopics((Option)new Some((Object)"foo")))).getMessage().startsWith("Multi-tenant getAllTopics but metadataCache is not multitenant"));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @MethodSource(value={"zkCacheProvider"})
    public void getAliverBrokersShouldReturnTags(MetadataCache cache) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        IndexedSeq brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)brokerId -> MetadataCacheTest.$anonfun$getAliverBrokersShouldReturnTags$1(securityProtocol, listenerName, BoxesRunTime.unboxToInt((Object)brokerId)));
        HashMap topicIds = new HashMap();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(ApiKeys.UPDATE_METADATA.latestVersion(), 0, 0, 0L, Collections.emptyList(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), topicIds, Collections.emptyList(), false).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Iterable liveBrokers = cache.getAliveBrokers();
        Assertions.assertEquals((Object)((IterableOnceOps)brokers.map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id()))).toSet(), (Object)((IterableOnceOps)liveBrokers.map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id()))).toSet());
        liveBrokers.foreach((Function1 & Serializable)broker -> {
            MetadataCacheTest.$anonfun$getAliverBrokersShouldReturnTags$4(cache, listenerName, broker);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @MethodSource(value={"zkCacheProvider"})
    public void testGetClusterMetadataWithOfflineReplicas(MetadataCache cache) {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("r").setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(1).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava()), (List)Nil$.MODULE$));
        int controllerEpoch = 1;
        int leader = 1;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        java.util.List<Integer> offline = Arrays.asList(Predef$.MODULE$.int2Integer(1));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(topicPartition.partition()).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(3).setReplicas(replicas).setOfflineReplicas(offline), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), Collections.emptyList(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), Collections.emptyMap(), Collections.emptyList(), false).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Node expectedNode0 = new Node(0, "foo", 9092, "r");
        Node expectedNode1 = new Node(1, "", -1);
        Cluster cluster = cache.getClusterMetadata("clusterId", listenerName);
        Assertions.assertEquals((Object)expectedNode0, (Object)cluster.nodeById(0));
        Assertions.assertNull((Object)cluster.nodeById(1));
        Assertions.assertEquals((Object)expectedNode1, (Object)cluster.leaderFor(topicPartition));
        PartitionInfo partitionInfo = cluster.partition(topicPartition);
        Assertions.assertEquals((Object)expectedNode1, (Object)partitionInfo.leader());
        Assertions.assertEquals((Object)new .colon.colon((Object)expectedNode0, (List)new .colon.colon((Object)expectedNode1, (List)Nil$.MODULE$)), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.replicas())));
        Assertions.assertEquals((Object)new .colon.colon((Object)expectedNode0, (List)new .colon.colon((Object)expectedNode1, (List)Nil$.MODULE$)), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.inSyncReplicas())));
        Assertions.assertEquals((Object)new .colon.colon((Object)expectedNode1, (List)Nil$.MODULE$), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.offlineReplicas())));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @MethodSource(value={"zkCacheProvider"})
    public void testIsBrokerDegraded(MetadataCache cache) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        IndexedSeq brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)brokerId -> MetadataCacheTest.$anonfun$testIsBrokerDegraded$1(securityProtocol, listenerName, BoxesRunTime.unboxToInt((Object)brokerId)));
        HashMap topicIds = new HashMap();
        IndexedSeq brokerHealthStates = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(3), 5).map((Function1 & Serializable)brokerId -> MetadataCacheTest.$anonfun$testIsBrokerDegraded$2(BoxesRunTime.unboxToInt((Object)brokerId)));
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(ApiKeys.UPDATE_METADATA.latestVersion(), 0, 0, 0L, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokerHealthStates.toList()).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), topicIds, Collections.emptyList(), false).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        package$.MODULE$.Range().apply(0, 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)cache.isBrokerDegraded(brokerId))));
        package$.MODULE$.Range().apply(3, 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)cache.isBrokerDegraded(brokerId))));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @MethodSource(value={"zkCacheProvider"})
    public void testIsBrokerComponentDegraded(MetadataCache cache) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        IndexedSeq brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)brokerId -> MetadataCacheTest.$anonfun$testIsBrokerComponentDegraded$1(securityProtocol, listenerName, BoxesRunTime.unboxToInt((Object)brokerId)));
        HashMap topicIds = new HashMap();
        .colon.colon brokerHealthStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBrokerHealthState().setBrokerId(3).setDegradedComponents(Collections.singletonList(Predef$.MODULE$.byte2Byte(BrokerComponent.UNSPECIFIED.id()))), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBrokerHealthState().setBrokerId(4).setDegradedComponents(Collections.singletonList(Predef$.MODULE$.byte2Byte(BrokerComponent.STORAGE.id()))), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBrokerHealthState().setBrokerId(5).setDegradedComponents(Collections.singletonList(Predef$.MODULE$.byte2Byte(BrokerComponent.NETWORK.id()))), (List)Nil$.MODULE$)));
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(ApiKeys.UPDATE_METADATA.latestVersion(), 0, 0, 0L, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokerHealthStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), topicIds, Collections.emptyList(), false).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        package$.MODULE$.Range().apply(0, 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> {
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)cache.isBrokerComponentDegraded(brokerId, BrokerComponent.UNSPECIFIED)));
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)cache.isBrokerComponentDegraded(brokerId, BrokerComponent.STORAGE)));
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)cache.isBrokerComponentDegraded(brokerId, BrokerComponent.NETWORK)));
        });
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)cache.isBrokerComponentDegraded(3, BrokerComponent.UNSPECIFIED)));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)cache.isBrokerComponentDegraded(4, BrokerComponent.STORAGE)));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)cache.isBrokerComponentDegraded(5, BrokerComponent.NETWORK)));
    }

    @Test
    public void testIsBrokerFenced() {
        int kRaftMetadataCache_brokerId = 0;
        KRaftMetadataCache metadataCache = new KRaftMetadataCache(kRaftMetadataCache_brokerId);
        MetadataDelta delta = new MetadataDelta.Builder().build();
        delta.replay(new RegisterBrokerRecord().setBrokerId(0).setFenced(false));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertFalse((boolean)metadataCache.isBrokerFenced(0));
        delta.replay(new BrokerRegistrationChangeRecord().setBrokerId(0).setFenced((byte)1));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertTrue((boolean)metadataCache.isBrokerFenced(0));
    }

    @Test
    public void testIsBrokerInControlledShutdown() {
        int kRaftMetadataCache_brokerId = 0;
        KRaftMetadataCache metadataCache = new KRaftMetadataCache(kRaftMetadataCache_brokerId);
        MetadataDelta delta = new MetadataDelta.Builder().build();
        delta.replay(new RegisterBrokerRecord().setBrokerId(0).setInControlledShutdown(false));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertFalse((boolean)metadataCache.isBrokerShuttingDown(0));
        delta.replay(new BrokerRegistrationChangeRecord().setBrokerId(0).setInControlledShutdown((byte)1));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertTrue((boolean)metadataCache.isBrokerShuttingDown(0));
    }

    @Test
    public void testGetLiveBrokerEpoch() {
        int kRaftMetadataCache_brokerId = 0;
        KRaftMetadataCache metadataCache = new KRaftMetadataCache(kRaftMetadataCache_brokerId);
        MetadataDelta delta = new MetadataDelta.Builder().build();
        delta.replay(new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(100L).setFenced(false));
        delta.replay(new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(101L).setFenced(true));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertEquals((long)100L, (long)BoxesRunTime.unboxToLong((Object)metadataCache.getAliveBrokerEpoch(0).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)));
        Assertions.assertEquals((long)-1L, (long)BoxesRunTime.unboxToLong((Object)metadataCache.getAliveBrokerEpoch(1).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @MethodSource(value={"cacheProvider"})
    public void testGetPartitionInfo(MetadataCache cache) {
        String topic = "topic";
        int partitionIndex = 0;
        int controllerEpoch = 1;
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(0));
        int zkVersion = 3;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(4));
        java.util.List<Integer> observers = Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(4));
        java.util.List<Integer> offlineReplicas = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(partitionIndex).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(zkVersion).setReplicas(replicas).setObservers(observers).setOfflineReplicas(offlineReplicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        int controllerId = 2;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("rack1").setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), Collections.emptyList(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), Collections.emptyMap(), Collections.emptyList(), false).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)cache.getPartitionInfo(topic, partitionIndex).get();
        Assertions.assertEquals((Object)topic, (Object)partitionState.topicName());
        Assertions.assertEquals((int)partitionIndex, (int)partitionState.partitionIndex());
        if (cache instanceof ZkMetadataCache) {
            Assertions.assertEquals((int)controllerEpoch, (int)partitionState.controllerEpoch());
        } else {
            Assertions.assertEquals((int)-1, (int)partitionState.controllerEpoch());
        }
        Assertions.assertEquals((int)leader, (int)partitionState.leader());
        Assertions.assertEquals((int)leaderEpoch, (int)partitionState.leaderEpoch());
        Assertions.assertEquals(isr, (Object)partitionState.isr());
        Assertions.assertEquals((int)zkVersion, (int)partitionState.zkVersion());
        Assertions.assertEquals(replicas, (Object)partitionState.replicas());
        Assertions.assertEquals(observers, (Object)partitionState.observers());
        if (cache instanceof ZkMetadataCache) {
            Assertions.assertEquals(offlineReplicas, (Object)partitionState.offlineReplicas());
            return;
        }
    }

    private static final Seq endpoints$2(int brokerId) {
        String host = new StringBuilder(4).append("foo-").append(brokerId).toString();
        return new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(host).setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT).value()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(host).setPort(9093).setSecurityProtocol(SecurityProtocol.SSL.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL).value()), (List)Nil$.MODULE$));
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$getTopicMetadata$1(int brokerId) {
        return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava(MetadataCacheTest.endpoints$2(brokerId)).asJava()).setRack("rack1");
    }

    public static final /* synthetic */ Integer $anonfun$getTopicMetadata$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$getTopicMetadata$3(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$5(String topic$2, UpdateMetadataRequestData.UpdateMetadataPartitionState ps) {
        String string = ps.topicName();
        return !(string != null ? !string.equals(topic$2) : topic$2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$8(int partitionId$1, UpdateMetadataRequestData.UpdateMetadataPartitionState x$3) {
        return x$3.partitionIndex() == partitionId$1;
    }

    public static final /* synthetic */ void $anonfun$getTopicMetadata$7(Seq topicPartitionStates$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)x0$1._1();
            int partitionId = x0$1._2$mcI$sp();
            Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionMetadata.errorCode());
            Assertions.assertEquals((int)partitionId, (int)partitionMetadata.partitionIndex());
            UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)topicPartitionStates$1.find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$getTopicMetadata$8(partitionId, x$3))).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(45).append("Unable to find partition state for partition ").append(partitionId).toString()));
            Assertions.assertEquals((int)partitionState.leader(), (int)partitionMetadata.leaderId());
            Assertions.assertEquals((int)partitionState.leaderEpoch(), (int)partitionMetadata.leaderEpoch());
            Assertions.assertEquals((Object)partitionState.isr(), (Object)partitionMetadata.isrNodes());
            Assertions.assertEquals((Object)partitionState.replicas(), (Object)partitionMetadata.replicaNodes());
            Assertions.assertEquals((Object)partitionState.observers(), (Object)partitionMetadata.observers());
            return;
        }
        throw new MatchError(null);
    }

    private static final void checkTopicMetadata$1(String topic, MetadataCache cache$1, ListenerName listenerName$1, HashMap topicIds$1, Seq partitionStates$1) {
        Seq topicMetadatas = cache$1.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName$1, cache$1.getTopicMetadata$default$3(), cache$1.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        Assertions.assertEquals((Object)topic, (Object)topicMetadata.name());
        Assertions.assertEquals(topicIds$1.get(topic), (Object)topicMetadata.topicId());
        Seq topicPartitionStates = (Seq)partitionStates$1.filter((Function1 & Serializable)ps -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$getTopicMetadata$5(topic, ps)));
        Buffer partitionMetadatas = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(topicMetadata.partitions()).asScala().sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.partitionIndex()), (Ordering)Ordering.Int$.MODULE$);
        Assertions.assertEquals((int)topicPartitionStates.size(), (int)partitionMetadatas.size(), (String)new StringBuilder(37).append("Unexpected partition count for topic ").append(topic).toString());
        ((IterableOnceOps)partitionMetadatas.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            MetadataCacheTest.$anonfun$getTopicMetadata$7(topicPartitionStates, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$getTopicMetadata$4(MetadataCache cache$1, HashMap topicIds$1, Seq partitionStates$1, String topic0$1, String topic1$1, java.util.List cells$1, SecurityProtocol securityProtocol) {
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        MetadataCacheTest.checkTopicMetadata$1(topic0$1, cache$1, listenerName, topicIds$1, partitionStates$1);
        MetadataCacheTest.checkTopicMetadata$1(topic1$1, cache$1, listenerName, topicIds$1, partitionStates$1);
        cells$1.forEach(cell -> cell.brokers().forEach(b -> Assertions.assertEquals((int)cell.cellId(), (int)cache$1.getBrokerCellId(Predef$.MODULE$.Integer2int(b)))));
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$getAliveBrokersShouldNotBeMutatedByUpdateCache$1(int brokerId) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setRack("").setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).value()), (List)Nil$.MODULE$)).asJava());
    }

    private final void updateCache$1(Seq brokerIds, String topic$3, MetadataCache cache$2) {
        Seq brokers = (Seq)brokerIds.map((Function1 & Serializable)brokerId -> MetadataCacheTest.$anonfun$getAliveBrokersShouldNotBeMutatedByUpdateCache$1(BoxesRunTime.unboxToInt((Object)brokerId)));
        int controllerEpoch = 1;
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic$3).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(3).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), Collections.emptyList(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava(brokers).asJava(), Collections.emptyMap(), Collections.emptyList(), false).build();
        MetadataCacheTest$.MODULE$.updateCache(cache$2, updateMetadataRequest);
    }

    private static final Seq endpoints$3(int brokerId) {
        String host = new StringBuilder(4).append("foo-").append(brokerId).toString();
        return new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(host).setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT).value()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(host).setPort(9093).setSecurityProtocol(SecurityProtocol.SSL.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL).value()), (List)Nil$.MODULE$));
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$getAllTopicsByTenant$1(int brokerId) {
        return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava(MetadataCacheTest.endpoints$3(brokerId)).asJava()).setRack("rack1");
    }

    private static final UpdateMetadataRequestData.UpdateMetadataPartitionState createPartition$1(String topicName, int partition, int controllerEpoch$1, int zkVersion$1) {
        return new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topicName).setPartitionIndex(partition).setControllerEpoch(controllerEpoch$1).setLeader(0).setLeaderEpoch(0).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3))).setZkVersion(zkVersion$1).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3)));
    }

    public static final /* synthetic */ ListBuffer $anonfun$getAllTopicsByTenant$4(ListBuffer partitionStates$2, String topicName$1, int controllerEpoch$1, int zkVersion$1, int part) {
        return (ListBuffer)partitionStates$2.append((Object)MetadataCacheTest.createPartition$1(topicName$1, part, controllerEpoch$1, zkVersion$1));
    }

    public static final /* synthetic */ ListBuffer $anonfun$getAllTopicsByTenant$8(ListBuffer partitionStates2$1, String topicName$2, int controllerEpoch$1, int zkVersion$1, int part) {
        return (ListBuffer)partitionStates2$1.append((Object)MetadataCacheTest.createPartition$1(topicName$2, part, controllerEpoch$1, zkVersion$1));
    }

    public static final /* synthetic */ ListBuffer $anonfun$getAllTopicsByTenant$12(ListBuffer partitionStates3$1, String topicName$3, int controllerEpoch$1, int zkVersion$1, int part) {
        return (ListBuffer)partitionStates3$1.append((Object)MetadataCacheTest.createPartition$1(topicName$3, part, controllerEpoch$1, zkVersion$1).setLeader(LeaderAndIsr$.MODULE$.LeaderDuringDelete()));
    }

    private static final scala.collection.immutable.Map tags$1(int brokerId) {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.cell"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.broker"), (Object)Integer.toString(brokerId))}));
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$getAliverBrokersShouldReturnTags$1(SecurityProtocol securityProtocol$1, ListenerName listenerName$2, int brokerId) {
        return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setRack("").setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(new StringBuilder(5).append("host-").append(brokerId).toString()).setPort(9092).setSecurityProtocol(securityProtocol$1.id).setListener(listenerName$2.value()), (List)Nil$.MODULE$)).asJava()).setTags(UpdateMetadataRequest.brokerTagCollectionFromTagMap((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)MetadataCacheTest.tags$1(brokerId)).asJava()));
    }

    public static final /* synthetic */ void $anonfun$getAliverBrokersShouldReturnTags$4(MetadataCache cache$5, ListenerName listenerName$2, BrokerMetadata broker) {
        Option node = cache$5.getAliveBrokerNode(broker.id(), listenerName$2);
        Assertions.assertEquals((Object)MetadataCacheTest.tags$1(broker.id()), (Object)CollectionConverters$.MODULE$.MapHasAsScala(ConfluentNode.tags((Node)((Node)node.get()))).asScala());
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$testIsBrokerDegraded$1(SecurityProtocol securityProtocol$2, ListenerName listenerName$3, int brokerId) {
        return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setRack(null).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(new StringBuilder(5).append("host-").append(brokerId).toString()).setPort(9092).setSecurityProtocol(securityProtocol$2.id).setListener(listenerName$3.value()), (List)Nil$.MODULE$)).asJava());
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBrokerHealthState $anonfun$testIsBrokerDegraded$2(int brokerId) {
        return new UpdateMetadataRequestData.UpdateMetadataBrokerHealthState().setBrokerId(brokerId).setDegradedComponents(Collections.singletonList(Predef$.MODULE$.byte2Byte(BrokerComponent.UNSPECIFIED.id())));
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$testIsBrokerComponentDegraded$1(SecurityProtocol securityProtocol$3, ListenerName listenerName$4, int brokerId) {
        return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setRack(null).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(new StringBuilder(5).append("host-").append(brokerId).toString()).setPort(9092).setSecurityProtocol(securityProtocol$3.id).setListener(listenerName$4.value()), (List)Nil$.MODULE$)).asJava());
    }

    public MetadataCacheTest() {
        this.brokerEpoch = 0L;
    }

    public static final /* synthetic */ Object $anonfun$getTopicMetadata$4$adapted(MetadataCache cache$1, HashMap topicIds$1, Seq partitionStates$1, String topic0$1, String topic1$1, java.util.List cells$1, SecurityProtocol securityProtocol) {
        MetadataCacheTest.$anonfun$getTopicMetadata$4(cache$1, topicIds$1, partitionStates$1, topic0$1, topic1$1, cells$1, securityProtocol);
        return BoxedUnit.UNIT;
    }
}

