/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.common.FetchedTimestampAndOffset;
import kafka.common.MaybeResolvedTimestampAndOffset;
import kafka.common.TierUnfetchedTimestampAndOffset;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.LazyZip2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.View;
import scala.collection.WithFilter;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;

@Timeout(value=300L)
@ScalaSignature(bytes="\u0006\u0005\t-d\u0001\u0002\f\u0018\u0001qAQ!\t\u0001\u0005\u0002\tBQ\u0001\n\u0001\u0005B\u0015BQ\u0001\f\u0001\u0005R5BQa\u000f\u0001\u0005\u0002qBQA\u001c\u0001\u0005\u0002=DQ!\u001e\u0001\u0005\u0002YDQa\u001f\u0001\u0005\u0002qDq!a\u0001\u0001\t\u0003\t)\u0001C\u0004\u0002\u0010\u0001!\t!!\u0005\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e!9\u0011q\u0005\u0001\u0005\u0002\u0005%\u0002bBA\u001d\u0001\u0011\u0005\u00111\b\u0005\b\u0003\u000f\u0002A\u0011AA%\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+Bq!a\u0018\u0001\t\u0013\t\t\u0007C\u0004\u0002j\u0001!I!a\u001b\t\u000f\u00055\u0005\u0001\"\u0003\u0002\u0010\"9\u0011q\u0014\u0001\u0005\n\u0005\u0005\u0006bBAz\u0001\u0011%\u0011Q\u001f\u0005\b\u0005C\u0001A\u0011\u0002B\u0012\u0011\u001d\u0011I\u0004\u0001C\u0005\u0005w\u0011Q\u0002T8h\u001f\u001a47/\u001a;UKN$(B\u0001\r\u001a\u0003\u0019\u0019XM\u001d<fe*\t!$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001i\u0002C\u0001\u0010 \u001b\u00059\u0012B\u0001\u0011\u0018\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u0001$!\tq\u0002!A\u0006ce>\\WM]\"pk:$X#\u0001\u0014\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\u0007%sG/A\fce>\\WM\u001d)s_B,'\u000f^=Pm\u0016\u0014(/\u001b3fgR\u0011a&\r\t\u0003O=J!\u0001\r\u0015\u0003\tUs\u0017\u000e\u001e\u0005\u0006e\r\u0001\raM\u0001\u0006aJ|\u0007o\u001d\t\u0003iej\u0011!\u000e\u0006\u0003m]\nA!\u001e;jY*\t\u0001(\u0001\u0003kCZ\f\u0017B\u0001\u001e6\u0005)\u0001&o\u001c9feRLWm]\u0001\u001ei\u0016\u001cHoR3u\u001f\u001a47/\u001a;t\r>\u0014XK\\6o_^tGk\u001c9jGR\u0011a&\u0010\u0005\u0006}\u0011\u0001\raP\u0001\u0007cV|'/^7\u0011\u0005\u0001;eBA!F!\t\u0011\u0005&D\u0001D\u0015\t!5$\u0001\u0004=e>|GOP\u0005\u0003\r\"\na\u0001\u0015:fI\u00164\u0017B\u0001%J\u0005\u0019\u0019FO]5oO*\u0011a\t\u000b\u0015\u0005\t-K&\f\u0005\u0002M/6\tQJ\u0003\u0002O\u001f\u0006A\u0001O]8wS\u0012,'O\u0003\u0002Q#\u00061\u0001/\u0019:b[NT!AU*\u0002\u000f),\b/\u001b;fe*\u0011A+V\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002-\u0006\u0019qN]4\n\u0005ak%a\u0003,bYV,7k\\;sG\u0016\fqa\u001d;sS:<7\u000f\f\u0002\\;\u0006\nA,\u0001\u0002{W\u0006\na,A\u0003le\u00064G\u000f\u000b\u0002\u0005AB\u0011\u0011MY\u0007\u0002\u001f&\u00111m\u0014\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\bF\u0002\u0003fQ&\\G\u000e\u0005\u0002(M&\u0011q\r\u000b\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017aB7fgN\fw-Z\u0011\u0002U\u0006)B*[:u\u001f\u001a47/\u001a;t%\u0016\fX/Z:uAY\u0003\u0014!B:j]\u000e,\u0017%A7\u0002\u0001\u0005\u0001C/Z:u\u000f\u0016$xJ\u001a4tKR\u001c\u0018I\u001a;fe\u0012+G.\u001a;f%\u0016\u001cwN\u001d3t)\tq\u0003\u000fC\u0003?\u000b\u0001\u0007q\b\u000b\u0003\u0006\u0017f\u0013HFA.^Q\t)\u0001\r\u000b\u0004\u0006K\"L7\u000e\\\u00017i\u0016\u001cHOR3uG\"|eMZ:fi\nKH+[7fgR\fW\u000e\u001d$pe6\u000b\u0007\u0010V5nKN$\u0018-\u001c9BMR,'\u000f\u0016:v]\u000e\fG/\u001a\u000b\u0003]]DQA\u0010\u0004A\u0002}BCAB&Zs2\u00121,\u0018\u0015\u0003\r\u0001\f\u0001\t^3ti\u001a+Go\u00195PM\u001a\u001cX\r\u001e\"z)&lWm\u001d;b[B4uN]'bqRKW.Z:uC6\u0004x+\u001b;i+:|'\u000fZ3sK\u0012$\u0016.\\3ti\u0006l\u0007o\u001d\u000b\u0003]uDQAP\u0004A\u0002}BCaB&Z\u007f2\u00121,\u0018\u0015\u0003\u000f\u0001\fa\u0004^3ti\u001e+Go\u00144gg\u0016$8OQ3g_J,G*\u0019;fgR$\u0016.\\3\u0015\u00079\n9\u0001C\u0003?\u0011\u0001\u0007q\bK\u0003\t\u0017f\u000bY\u0001\f\u0002\\;\"\u0012\u0001\u0002Y\u0001\u0018i\u0016\u001cH/R7qifdunZ:HKR|eMZ:fiN$2ALA\n\u0011\u0015q\u0014\u00021\u0001@Q\u0015I1*WA\fY\tYV\f\u000b\u0002\nA\u0006)D/Z:u\r\u0016$8\r[(gMN,GOQ=US6,7\u000f^1na\u001a{'/T1y)&lWm\u001d;b[B<\u0016\u000e\u001e5F[B$\u0018\u0010T8h)\rq\u0013q\u0004\u0005\u0006})\u0001\ra\u0010\u0015\u0006\u0015-K\u00161\u0005\u0017\u00037vC#A\u00031\u0002/Q,7\u000f^$fi>3gm]3ug\n+gm\u001c:f\u001d><Hc\u0001\u0018\u0002,!)ah\u0003a\u0001\u007f!*1bS-\u000201\u00121,\u0018\u0015\u0003\u0017\u0001DsaC3i\u0003kYG.\t\u0002\u00028\u0005AB.Z4bGf4U\r^2i\u001f\u001a47/\u001a;t\u0005\u00164wN]3\u0002AQ,7\u000f^$fi>3gm]3ug\n+gm\u001c:f\u000b\u0006\u0014H.[3tiRKW.\u001a\u000b\u0004]\u0005u\u0002\"\u0002 \r\u0001\u0004y\u0004&\u0002\u0007L3\u0006\u0005CFA.^Q\ta\u0001\rK\u0004\rK\"\f)d\u001b7\u0002[Q,7\u000f\u001e$fi\u000eDwJ\u001a4tKR\u001c()\u001a4pe\u0016<\u0016\u000e\u001e5DQ\u0006tw-\u001b8h'\u0016<W.\u001a8u'&TX\rF\u0002/\u0003\u0017BQAP\u0007A\u0002}BS!D&Z\u0003\u001fb#aW/)\u00055\u0001\u0017A\u000b;fgR4U\r^2i\u001f\u001a47/\u001a;t\u0005\u00164wN]3XSRD7\t[1oO&twmU3h[\u0016tGo\u001d\u000b\u0004]\u0005]\u0003\"\u0002 \u000f\u0001\u0004y\u0004&\u0002\bL3\u0006mCFA.^Q\tq\u0001-\u0001\u0004ce>\\WM]\u000b\u0003\u0003G\u00022AHA3\u0013\r\t9g\u0006\u0002\f\u0017\u000647.\u0019\"s_.,'/\u0001\ftK:$G*[:u\u001f\u001a47/\u001a;t%\u0016\fX/Z:u)\u0011\ti'a!\u0011\t\u0005=\u0014qP\u0007\u0003\u0003cRA!a\u001d\u0002v\u0005A!/Z9vKN$8O\u0003\u0003\u0002x\u0005e\u0014AB2p[6|gNC\u0002\u001b\u0003wR1!! V\u0003\u0019\t\u0007/Y2iK&!\u0011\u0011QA9\u0005Ma\u0015n\u001d;PM\u001a\u001cX\r^:SKN\u0004xN\\:f\u0011\u001d\t)\t\u0005a\u0001\u0003\u000f\u000bqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0002p\u0005%\u0015\u0002BAF\u0003c\u0012!\u0003T5ti>3gm]3ugJ+\u0017/^3ti\u0006\u00012/\u001a8e\r\u0016$8\r\u001b*fcV,7\u000f\u001e\u000b\u0005\u0003#\u000b9\n\u0005\u0003\u0002p\u0005M\u0015\u0002BAK\u0003c\u0012QBR3uG\"\u0014Vm\u001d9p]N,\u0007bBAC#\u0001\u0007\u0011\u0011\u0014\t\u0005\u0003_\nY*\u0003\u0003\u0002\u001e\u0006E$\u0001\u0004$fi\u000eD'+Z9vKN$\u0018\u0001\u00052vS2$G+\u0019:hKR$\u0016.\\3t)!\t\u0019+!7\u0002f\u0006=\bCBAS\u0003_\u000b)L\u0004\u0003\u0002(\u0006-fb\u0001\"\u0002*&\t\u0011&C\u0002\u0002.\"\nq\u0001]1dW\u0006<W-\u0003\u0003\u00022\u0006M&\u0001\u0002'jgRT1!!,)!\u0011\t9,a5\u000f\t\u0005e\u0016Q\u001a\b\u0005\u0003w\u000bYM\u0004\u0003\u0002>\u0006%g\u0002BA`\u0003\u000ftA!!1\u0002F:\u0019!)a1\n\u0003YK1!! V\u0013\rQ\u00121P\u0005\u0005\u0003o\nI(C\u0002i\u0003kJA!a4\u0002R\u00061B*[:u\u001f\u001a47/\u001a;t%\u0016\fX/Z:u\t\u0006$\u0018MC\u0002i\u0003kJA!!6\u0002X\n\u0001B*[:u\u001f\u001a47/\u001a;t)>\u0004\u0018n\u0019\u0006\u0005\u0003\u001f\f\t\u000eC\u0004\u0002\\J\u0001\r!!8\u0002\u0005Q\u0004\b\u0003BAp\u0003Cl!!!\u001e\n\t\u0005\r\u0018Q\u000f\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\t9O\u0005a\u0001\u0003S\f\u0011\u0002^5nKN$\u0018-\u001c9\u0011\u0007\u001d\nY/C\u0002\u0002n\"\u0012A\u0001T8oO\"1\u0011\u0011\u001f\nA\u0002\u0019\nQ\"\\1y\u001dVlwJ\u001a4tKR\u001c\u0018!\u00044j]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0004\u0002x\n\u0015!q\u0004\t\u0005\u0003s\fyP\u0004\u0003\u0002:\u0006m\u0018\u0002BA\u007f\u0003#\fq\u0003T5ti>3gm]3ugJ+7\u000f]8og\u0016$\u0015\r^1\n\t\t\u0005!1\u0001\u0002\u001d\u0019&\u001cHo\u00144gg\u0016$8\u000fU1si&$\u0018n\u001c8SKN\u0004xN\\:f\u0015\u0011\ti0!5\t\u000f\t\u001d1\u00031\u0001\u0003\n\u00051Ao\u001c9jGN\u0004bAa\u0003\u0003\u0016\teQB\u0001B\u0007\u0015\u0011\u0011yA!\u0005\u0002\u000f5,H/\u00192mK*\u0019!1\u0003\u0015\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u0018\t5!A\u0002\"vM\u001a,'\u000f\u0005\u0003\u0002z\nm\u0011\u0002\u0002B\u000f\u0005\u0007\u0011\u0001\u0004T5ti>3gm]3ugR{\u0007/[2SKN\u0004xN\\:f\u0011\u001d\tYn\u0005a\u0001\u0003;\fAc\u0019:fCR,Gk\u001c9jG\u0006sGmR3u\u0019><GC\u0002B\u0013\u0005c\u0011)\u0004\u0005\u0003\u0003(\t5RB\u0001B\u0015\u0015\r\u0011Y#G\u0001\u0004Y><\u0017\u0002\u0002B\u0018\u0005S\u00111\"\u00112tiJ\f7\r\u001e'pO\"1!1\u0007\u000bA\u0002}\nQ\u0001^8qS\u000eDqAa\u000e\u0015\u0001\u0004\ti.\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u00021\u0005\u001c8/\u001a:u)&lWm\u001d;b[B\fe\u000eZ(gMN,G\u000fF\u0004/\u0005{\u0011\tF!\u0016\t\u000f\t}R\u00031\u0001\u0003B\u0005\u0011B/[7fgR\fW\u000e]!oI>3gm]3u!\u00159#1\tB$\u0013\r\u0011)\u0005\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\t%#QJ\u0007\u0003\u0005\u0017R1!a\u001e\u001a\u0013\u0011\u0011yEa\u0013\u0003?5\u000b\u0017PY3SKN|GN^3e)&lWm\u001d;b[B\fe\u000eZ(gMN,G\u000fC\u0004\u0003TU\u0001\r!!;\u0002#\u0015D\b/Z2uK\u0012$\u0016.\\3ti\u0006l\u0007\u000fC\u0004\u0003XU\u0001\r!!;\u0002\u001d\u0015D\b/Z2uK\u0012|eMZ:fi\":\u0001Aa\u0017\u0003h\t%\u0004\u0003\u0002B/\u0005Gj!Aa\u0018\u000b\u0007\t\u0005\u0014+A\u0002ba&LAA!\u001a\u0003`\t9A+[7f_V$\u0018!\u0002<bYV,gDA\u0001-\u0001")
public class LogOffsetTest
extends BaseRequestTest {
    @Override
    public int brokerCount() {
        return 1;
    }

    @Override
    public void brokerPropertyOverrides(Properties props) {
        props.put("log.flush.interval.messages", "1");
        props.put("num.partitions", "20");
        props.put("log.retention.hours", "10");
        props.put("log.retention.check.interval.ms", Integer.toString(300000));
        props.put("log.segment.bytes", "140");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGetOffsetsForUnknownTopic(String quorum) {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        ListOffsetsRequest request = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -1L, 10)).asJava()).build((short)0);
        ListOffsetsResponse response = this.sendListOffsetsRequest(request);
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(response.topics()).asScala(), topicPartition).errorCode());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGetOffsetsAfterDeleteRecords(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        AbstractLog log = this.createTopicAndGetLog(topic, topicPartition);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$1 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
        log.updateHighWatermark(log.logEndOffset());
        log.maybeIncrementLogStartOffset(3L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        log.deleteOldSegments();
        Seq offsets = log.legacyFetchOffsetsBefore(-1L, 15);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)offsets);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.broker())) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Leader should be elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -1L, 15)).asJava()).build();
        Buffer consumerOffsets = CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)consumerOffsets);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchOffsetByTimestampForMaxTimestampAfterTruncate(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        AbstractLog log = this.createTopicAndGetLog(topic, topicPartition);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)timestamp -> LogOffsetTest.$anonfun$testFetchOffsetByTimestampForMaxTimestampAfterTruncate$1(log, BoxesRunTime.unboxToInt((Object)timestamp)));
        log.flush(false);
        log.updateHighWatermark(log.logEndOffset());
        Option firstOffset = log.fetchOffsetByTimestamp(-3L);
        this.assertTimestampAndOffset((Option<MaybeResolvedTimestampAndOffset>)firstOffset, 19L, 19L);
        log.truncateTo(0L);
        Option secondOffset = log.fetchOffsetByTimestamp(-3L);
        this.assertTimestampAndOffset((Option<MaybeResolvedTimestampAndOffset>)secondOffset, -1L, 0L);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        AbstractLog log = this.createTopicAndGetLog(topic, topicPartition);
        ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L, 1L, 2L, 3L, 4L, 6L, 5L}))).foreach((Function1 & Serializable)timestamp -> LogOffsetTest.$anonfun$testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps$1(log, BoxesRunTime.unboxToLong((Object)timestamp)));
        log.flush(false);
        log.updateHighWatermark(log.logEndOffset());
        Option maxTimestampOffset = log.fetchOffsetByTimestamp(-3L);
        Assertions.assertEquals((long)7L, (long)log.logEndOffset());
        this.assertTimestampAndOffset((Option<MaybeResolvedTimestampAndOffset>)maxTimestampOffset, 6L, 5L);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGetOffsetsBeforeLatestTime(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        AbstractLog log = this.createTopicAndGetLog(topic, topicPartition);
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds((Seq<String>)new .colon.colon((Object)"kafka-", (List)Nil$.MODULE$))).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$2 -> x$2.swap())).asJava();
        Uuid topicId = (Uuid)topicIds.get(topic);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$3 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
        Seq offsets = log.legacyFetchOffsetsBefore(-1L, 15);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, 0, this.broker())) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Leader should be elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -1L, 15)).asJava()).build();
        Buffer consumerOffsets = CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((short)ApiKeys.FETCH.latestVersion(), (int)0, (int)1, (java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new FetchRequest.PartitionData(topicId, Predef$.MODULE$.Long2long((Long)consumerOffsets.head()), -1L, 307200, Optional.empty()))}))).asJava()).build();
        Assertions.assertFalse((boolean)FetchResponse.recordsOrFail((FetchResponseData.PartitionData)((FetchResponseData.PartitionData)this.sendFetchRequest(fetchRequest).responseData(topicNames, ApiKeys.FETCH.latestVersion()).get(topicPartition))).batches().iterator().hasNext());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testEmptyLogsGetOffsets(String quorum) {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(10));
        String topicPartitionPath = new java.lang.StringBuilder(2).append(TestUtils.tempDirectory(null, null).getAbsolutePath()).append("/").append(topic).append("-").append(topicPartition.partition()).toString();
        new File(topicPartitionPath).mkdir();
        this.createTopic(topic, 1, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        BooleanRef offsetChanged = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 14).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> {
            TopicPartition topicPartition = new TopicPartition(topic, 0);
            ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -2L, 1)).asJava()).build();
            if (BoxesRunTime.equals((Object)CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala().head(), (Object)BoxesRunTime.boxToInteger((int)1))) {
                offsetChanged$1.elem = true;
                return;
            }
        });
        Assertions.assertFalse((boolean)offsetChanged.elem);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchOffsetByTimestampForMaxTimestampWithEmptyLog(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        AbstractLog log = this.createTopicAndGetLog(topic, topicPartition);
        log.updateHighWatermark(log.logEndOffset());
        Option maxTimestampOffset = log.fetchOffsetByTimestamp(-3L);
        Assertions.assertEquals((long)0L, (long)log.logEndOffset());
        this.assertTimestampAndOffset((Option<MaybeResolvedTimestampAndOffset>)maxTimestampOffset, -1L, 0L);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGetOffsetsBeforeNow(String quorum) {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        LogManager logManager = this.broker().logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = logManager.getOrCreateLog$default$2();
        boolean x$4 = logManager.getOrCreateLog$default$3();
        AbstractLog log = logManager.getOrCreateLog(topicPartition, x$3, x$4, (Option)x$2);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$5 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
        long now = Time.SYSTEM.milliseconds() + 30000L;
        Seq offsets = log.legacyFetchOffsetsBefore(now, 15);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.broker())) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Leader should be elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, now, 15)).asJava()).build();
        Buffer consumerOffsets = CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGetOffsetsBeforeEarliestTime(String quorum) {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        LogManager logManager = this.broker().logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = logManager.getOrCreateLog$default$2();
        boolean x$4 = logManager.getOrCreateLog$default$3();
        AbstractLog log = logManager.getOrCreateLog(topicPartition, x$3, x$4, (Option)x$2);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$6 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
        package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{-2L, -4L})).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)timestamp -> {
            Seq offsets = log.legacyFetchOffsetsBefore(timestamp, 10);
            Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L})), (Object)offsets);
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.broker())) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Leader should be elected");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, timestamp, 10)).asJava()).build();
            Buffer consumerOffsets = CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
            Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L})), (Object)consumerOffsets);
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchOffsetsBeforeWithChangingSegmentSize(String quorum) {
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        LogSegment logSegment = (LogSegment)Mockito.mock(LogSegment.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)logSegment.size())).thenAnswer((Answer)new Answer<Object>(null){
            private final AtomicInteger value;

            public int answer(InvocationOnMock invocation) {
                return this.value.getAndIncrement();
            }
            {
                this.value = new AtomicInteger(0);
            }
        });
        .colon.colon logSegments = new .colon.colon((Object)logSegment, (List)Nil$.MODULE$);
        Mockito.when((Object)log.localLogSegments()).thenReturn((Object)logSegments);
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchOffsetsBeforeWithChangingSegments(String quorum) {
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        LogSegment logSegment = (LogSegment)Mockito.mock(LogSegment.class);
        Mockito.when((Object)log.localLogSegments()).thenReturn((Object)new Iterable<LogSegment>(null, logSegment){
            private final LogSegment logSegment$1;

            public final Iterable<LogSegment> toIterable() {
                return Iterable.toIterable$((Iterable)this);
            }

            public final Iterable<LogSegment> coll() {
                return Iterable.coll$((Iterable)this);
            }

            public IterableFactory<Iterable> iterableFactory() {
                return Iterable.iterableFactory$((Iterable)this);
            }

            public Iterable<LogSegment> seq() {
                return Iterable.seq$((Iterable)this);
            }

            public String className() {
                return Iterable.className$((Iterable)this);
            }

            public final String collectionClassName() {
                return Iterable.collectionClassName$((Iterable)this);
            }

            public String stringPrefix() {
                return Iterable.stringPrefix$((Iterable)this);
            }

            public String toString() {
                return Iterable.toString$((Iterable)this);
            }

            public <B> LazyZip2<LogSegment, B, Iterable> lazyZip(Iterable<B> that) {
                return Iterable.lazyZip$((Iterable)this, that);
            }

            public IterableOps fromSpecific(IterableOnce coll) {
                return IterableFactoryDefaults.fromSpecific$((IterableFactoryDefaults)this, (IterableOnce)coll);
            }

            public Builder<LogSegment, Iterable<LogSegment>> newSpecificBuilder() {
                return IterableFactoryDefaults.newSpecificBuilder$((IterableFactoryDefaults)this);
            }

            public IterableOps empty() {
                return IterableFactoryDefaults.empty$((IterableFactoryDefaults)this);
            }

            public final Iterable<LogSegment> toTraversable() {
                return IterableOps.toTraversable$((IterableOps)this);
            }

            public boolean isTraversableAgain() {
                return IterableOps.isTraversableAgain$((IterableOps)this);
            }

            public final Object repr() {
                return IterableOps.repr$((IterableOps)this);
            }

            public IterableFactory<Iterable> companion() {
                return IterableOps.companion$((IterableOps)this);
            }

            public Object head() {
                return IterableOps.head$((IterableOps)this);
            }

            public Option<LogSegment> headOption() {
                return IterableOps.headOption$((IterableOps)this);
            }

            public Object last() {
                return IterableOps.last$((IterableOps)this);
            }

            public Option<LogSegment> lastOption() {
                return IterableOps.lastOption$((IterableOps)this);
            }

            public View<LogSegment> view() {
                return IterableOps.view$((IterableOps)this);
            }

            public int sizeCompare(int otherSize) {
                return IterableOps.sizeCompare$((IterableOps)this, (int)otherSize);
            }

            public final IterableOps sizeIs() {
                return IterableOps.sizeIs$((IterableOps)this);
            }

            public int sizeCompare(Iterable<?> that) {
                return IterableOps.sizeCompare$((IterableOps)this, that);
            }

            public View<LogSegment> view(int from, int until) {
                return IterableOps.view$((IterableOps)this, (int)from, (int)until);
            }

            public Object transpose(Function1 asIterable) {
                return IterableOps.transpose$((IterableOps)this, (Function1)asIterable);
            }

            public Object filter(Function1 pred) {
                return IterableOps.filter$((IterableOps)this, (Function1)pred);
            }

            public Object filterNot(Function1 pred) {
                return IterableOps.filterNot$((IterableOps)this, (Function1)pred);
            }

            public WithFilter<LogSegment, Iterable> withFilter(Function1<LogSegment, Object> p) {
                return IterableOps.withFilter$((IterableOps)this, p);
            }

            public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> partition(Function1<LogSegment, Object> p) {
                return IterableOps.partition$((IterableOps)this, p);
            }

            public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> splitAt(int n) {
                return IterableOps.splitAt$((IterableOps)this, (int)n);
            }

            public Object take(int n) {
                return IterableOps.take$((IterableOps)this, (int)n);
            }

            public Object takeRight(int n) {
                return IterableOps.takeRight$((IterableOps)this, (int)n);
            }

            public Object takeWhile(Function1 p) {
                return IterableOps.takeWhile$((IterableOps)this, (Function1)p);
            }

            public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> span(Function1<LogSegment, Object> p) {
                return IterableOps.span$((IterableOps)this, p);
            }

            public Object drop(int n) {
                return IterableOps.drop$((IterableOps)this, (int)n);
            }

            public Object dropRight(int n) {
                return IterableOps.dropRight$((IterableOps)this, (int)n);
            }

            public Object dropWhile(Function1 p) {
                return IterableOps.dropWhile$((IterableOps)this, (Function1)p);
            }

            public Iterator<Iterable<LogSegment>> grouped(int size) {
                return IterableOps.grouped$((IterableOps)this, (int)size);
            }

            public Iterator<Iterable<LogSegment>> sliding(int size) {
                return IterableOps.sliding$((IterableOps)this, (int)size);
            }

            public Iterator<Iterable<LogSegment>> sliding(int size, int step) {
                return IterableOps.sliding$((IterableOps)this, (int)size, (int)step);
            }

            public Object tail() {
                return IterableOps.tail$((IterableOps)this);
            }

            public Object init() {
                return IterableOps.init$((IterableOps)this);
            }

            public Object slice(int from, int until) {
                return IterableOps.slice$((IterableOps)this, (int)from, (int)until);
            }

            public <K> scala.collection.immutable.Map<K, Iterable<LogSegment>> groupBy(Function1<LogSegment, K> f) {
                return IterableOps.groupBy$((IterableOps)this, f);
            }

            public <K, B> scala.collection.immutable.Map<K, Iterable<B>> groupMap(Function1<LogSegment, K> key, Function1<LogSegment, B> f) {
                return IterableOps.groupMap$((IterableOps)this, key, f);
            }

            public <K, B> scala.collection.immutable.Map<K, B> groupMapReduce(Function1<LogSegment, K> key, Function1<LogSegment, B> f, Function2<B, B, B> reduce) {
                return IterableOps.groupMapReduce$((IterableOps)this, key, f, reduce);
            }

            public Object scan(Object z, Function2 op) {
                return IterableOps.scan$((IterableOps)this, (Object)z, (Function2)op);
            }

            public Object scanLeft(Object z, Function2 op) {
                return IterableOps.scanLeft$((IterableOps)this, (Object)z, (Function2)op);
            }

            public Object scanRight(Object z, Function2 op) {
                return IterableOps.scanRight$((IterableOps)this, (Object)z, (Function2)op);
            }

            public Object map(Function1 f) {
                return IterableOps.map$((IterableOps)this, (Function1)f);
            }

            public Object flatMap(Function1 f) {
                return IterableOps.flatMap$((IterableOps)this, (Function1)f);
            }

            public Object flatten(Function1 asIterable) {
                return IterableOps.flatten$((IterableOps)this, (Function1)asIterable);
            }

            public Object collect(PartialFunction pf) {
                return IterableOps.collect$((IterableOps)this, (PartialFunction)pf);
            }

            public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> partitionMap(Function1<LogSegment, Either<A1, A2>> f) {
                return IterableOps.partitionMap$((IterableOps)this, f);
            }

            public Object concat(IterableOnce suffix) {
                return IterableOps.concat$((IterableOps)this, (IterableOnce)suffix);
            }

            public final Object $plus$plus(IterableOnce suffix) {
                return IterableOps.$plus$plus$((IterableOps)this, (IterableOnce)suffix);
            }

            public Object zip(IterableOnce that) {
                return IterableOps.zip$((IterableOps)this, (IterableOnce)that);
            }

            public Object zipWithIndex() {
                return IterableOps.zipWithIndex$((IterableOps)this);
            }

            public Object zipAll(Iterable that, Object thisElem, Object thatElem) {
                return IterableOps.zipAll$((IterableOps)this, (Iterable)that, (Object)thisElem, (Object)thatElem);
            }

            public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<LogSegment, Tuple2<A1, A2>> asPair) {
                return IterableOps.unzip$((IterableOps)this, asPair);
            }

            public <A1, A2, A3> Tuple3<Iterable<A1>, Iterable<A2>, Iterable<A3>> unzip3(Function1<LogSegment, Tuple3<A1, A2, A3>> asTriple) {
                return IterableOps.unzip3$((IterableOps)this, asTriple);
            }

            public Iterator<Iterable<LogSegment>> tails() {
                return IterableOps.tails$((IterableOps)this);
            }

            public Iterator<Iterable<LogSegment>> inits() {
                return IterableOps.inits$((IterableOps)this);
            }

            public Object tapEach(Function1 f) {
                return IterableOps.tapEach$((IterableOps)this, (Function1)f);
            }

            public Object $plus$plus$colon(IterableOnce that) {
                return IterableOps.$plus$plus$colon$((IterableOps)this, (IterableOnce)that);
            }

            public boolean hasDefiniteSize() {
                return IterableOnceOps.hasDefiniteSize$((IterableOnceOps)this);
            }

            public <U> void foreach(Function1<LogSegment, U> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<LogSegment, Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<LogSegment, Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<LogSegment, Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<LogSegment> find(Function1<LogSegment, Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B> B foldLeft(B z, Function2<B, LogSegment, B> op) {
                return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B> B foldRight(B z, Function2<LogSegment, B, B> op) {
                return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B> B $div$colon(B z, Function2<B, LogSegment, B> op) {
                return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B> B $colon$bslash(B z, Function2<LogSegment, B, B> op) {
                return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, LogSegment, B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<LogSegment, B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, LogSegment, B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<LogSegment, B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean isEmpty() {
                return IterableOnceOps.isEmpty$((IterableOnceOps)this);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object xs) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
            }

            public <B> int copyToArray(Object xs, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
            }

            public <B> int copyToArray(Object xs, int start, int len) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public Object min(Ordering ord) {
                return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<LogSegment> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public Object max(Ordering ord) {
                return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<LogSegment> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<LogSegment> maxByOption(Function1<LogSegment, B> f, Ordering<B> cmp) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<LogSegment> minByOption(Function1<LogSegment, B> f, Ordering<B> cmp) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, cmp);
            }

            public <B> Option<B> collectFirst(PartialFunction<LogSegment, B> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, LogSegment, B> seqop, Function2<B, B, B> combop) {
                return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B> boolean corresponds(IterableOnce<B> that, Function2<LogSegment, B, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<LogSegment, C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<LogSegment> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<LogSegment> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public Vector<LogSegment> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K, V> scala.collection.immutable.Map<K, V> toMap(.less.colon.less<LogSegment, Tuple2<K, V>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public scala.collection.immutable.Seq<LogSegment> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<LogSegment> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<LogSegment> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<LogSegment> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S extends Stepper<?>> S stepper(StepperShape<LogSegment, S> shape) {
                return (S)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            public int size() {
                return 2;
            }

            public Iterator<LogSegment> iterator() {
                return new .colon.colon((Object)this.logSegment$1, (List)Nil$.MODULE$).iterator();
            }
            {
                this.logSegment$1 = logSegment$1;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                IterableOps.$init$((IterableOps)this);
                IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
                Iterable.$init$((Iterable)this);
            }
        });
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    private KafkaBroker broker() {
        return (KafkaBroker)this.brokers().head();
    }

    private ListOffsetsResponse sendListOffsetsRequest(ListOffsetsRequest request) {
        return (ListOffsetsResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ListOffsetsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private FetchResponse sendFetchRequest(FetchRequest request) {
        return (FetchResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private List<ListOffsetsRequestData.ListOffsetsTopic> buildTargetTimes(TopicPartition tp, long timestamp, int maxNumOffsets) {
        return new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(tp.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(tp.partition()).setTimestamp(timestamp).setMaxNumOffsets(maxNumOffsets), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
    }

    private ListOffsetsResponseData.ListOffsetsPartitionResponse findPartition(Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse> topics, TopicPartition tp) {
        return (ListOffsetsResponseData.ListOffsetsPartitionResponse)CollectionConverters$.MODULE$.ListHasAsScala(((ListOffsetsResponseData.ListOffsetsTopicResponse)topics.find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$findPartition$1(tp, x$7))).get()).partitions()).asScala().find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$findPartition$2(tp, x$8))).get();
    }

    /*
     * WARNING - void declaration
     */
    private AbstractLog createTopicAndGetLog(String topic, TopicPartition topicPartition) {
        this.createTopic(topic, 1, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        LogManager logManager = this.broker().logManager();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogOffsetTest.$anonfun$createTopicAndGetLog$1(logManager, topicPartition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Log for partition [topic,0] should be created");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return (AbstractLog)logManager.getLog(topicPartition, logManager.getLog$default$2()).get();
    }

    private void assertTimestampAndOffset(Option<MaybeResolvedTimestampAndOffset> timestampAndOffset, long expectedTimestamp, long expectedOffset) {
        MaybeResolvedTimestampAndOffset maybeResolvedTimestampAndOffset = (MaybeResolvedTimestampAndOffset)timestampAndOffset.get();
        if (maybeResolvedTimestampAndOffset instanceof FetchedTimestampAndOffset) {
            FetchedTimestampAndOffset fetchedTimestampAndOffset = (FetchedTimestampAndOffset)maybeResolvedTimestampAndOffset;
            Assertions.assertEquals((long)expectedOffset, (long)fetchedTimestampAndOffset.offset());
            Assertions.assertEquals((long)expectedTimestamp, (long)fetchedTimestampAndOffset.timestamp());
            return;
        }
        if (maybeResolvedTimestampAndOffset instanceof TierUnfetchedTimestampAndOffset) {
            throw new AssertionError((Object)"unexpected ListOffset result from the tier portion of the log");
        }
        throw new AssertionError((Object)"unexpected ListOffset result from max timestamp query");
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsAfterDeleteRecords$3() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testFetchOffsetByTimestampForMaxTimestampAfterTruncate$1(AbstractLog log$2, int timestamp) {
        byte[] x$1 = Integer.toString(42).getBytes();
        long x$2 = timestamp;
        CompressionType x$4 = CompressionType.NONE;
        byte x$5 = 2;
        return log$2.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, null, x$4, x$2, x$5), 0, log$2.appendAsLeader$default$3(), log$2.appendAsLeader$default$4(), log$2.appendAsLeader$default$5());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps$1(AbstractLog log$3, long timestamp) {
        byte[] x$1 = Integer.toString(42).getBytes();
        CompressionType x$4 = CompressionType.NONE;
        byte x$5 = 2;
        return log$3.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, null, x$4, timestamp, x$5), 0, log$3.appendAsLeader$default$3(), log$3.appendAsLeader$default$4(), log$3.appendAsLeader$default$5());
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeLatestTime$4() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeNow$3() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeEarliestTime$4() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ boolean $anonfun$findPartition$1(TopicPartition tp$1, ListOffsetsResponseData.ListOffsetsTopicResponse x$7) {
        String string = x$7.name();
        String string2 = tp$1.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findPartition$2(TopicPartition tp$1, ListOffsetsResponseData.ListOffsetsPartitionResponse x$8) {
        return x$8.partitionIndex() == tp$1.partition();
    }

    public static final /* synthetic */ boolean $anonfun$createTopicAndGetLog$1(LogManager logManager$1, TopicPartition topicPartition$4) {
        return logManager$1.getLog(topicPartition$4, logManager$1.getLog$default$2()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$createTopicAndGetLog$2() {
        return "Log for partition [topic,0] should be created";
    }
}

