/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.FileStore;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import kafka.cluster.BrokerEndPoint;
import kafka.log.LogManager;
import kafka.log.SegmentDeletionThrottlerConfig;
import kafka.log.TierLogComponents$;
import kafka.server.ActionQueue;
import kafka.server.AlterPartitionManager;
import kafka.server.BrokerFeatures;
import kafka.server.BrokerFeatures$;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LeaderEndPoint;
import kafka.server.LocalLeaderEndPoint;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaQuota;
import kafka.server.TierReplicaComponents;
import kafka.server.TierReplicaComponents$;
import kafka.server.checkpoints.LazyOffsetCheckpoints;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.MockTime;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tmb\u0001\u0002\u0015*\u00019BQ!\u000e\u0001\u0005\u0002YBq!\u000f\u0001C\u0002\u0013\u0005!\b\u0003\u0004B\u0001\u0001\u0006Ia\u000f\u0005\b\u0005\u0002\u0011\r\u0011\"\u0001D\u0011\u0019y\u0005\u0001)A\u0005\t\"9\u0001\u000b\u0001b\u0001\n\u0003\t\u0006B\u0002.\u0001A\u0003%!\u000bC\u0004\\\u0001\t\u0007I\u0011\u0001/\t\r\u0001\u0004\u0001\u0015!\u0003^\u0011\u001d\t\u0007A1A\u0005\u0002\tDa!\u001b\u0001!\u0002\u0013\u0019\u0007\"\u00036\u0001\u0001\u0004\u0005\r\u0011\"\u0001l\u0011%y\u0007\u00011AA\u0002\u0013\u0005\u0001\u000fC\u0005w\u0001\u0001\u0007\t\u0011)Q\u0005Y\"Iq\u000f\u0001a\u0001\u0002\u0004%\t\u0001\u001f\u0005\ny\u0002\u0001\r\u00111A\u0005\u0002uD\u0011b \u0001A\u0002\u0003\u0005\u000b\u0015B=\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0004!9\u00111\u0004\u0001\u0005\u0002\u0005\r\u0001bBA\u0013\u0001\u0011\u0005\u00111\u0001\u0005\b\u0003S\u0001A\u0011AA\u0002\u0011\u001d\ti\u0003\u0001C\u0001\u0003\u00071a!!\r\u0001\t\u0005M\u0002BB\u001b\u0018\t\u0003\t9\u0004C\u0005\u0002T]\u0001\r\u0011\"\u0003\u0002V!I\u0011QL\fA\u0002\u0013%\u0011q\f\u0005\t\u0003G:\u0002\u0015)\u0003\u0002X!I\u0011QM\fA\u0002\u0013%\u0011q\r\u0005\n\u0003c:\u0002\u0019!C\u0005\u0003gB\u0001\"a\u001e\u0018A\u0003&\u0011\u0011\u000e\u0005\b\u0003s:B\u0011AA>\u0011\u001d\t\u0019i\u0006C\u0001\u0003\u000bCq!!#\u0018\t\u0003\tY\tC\u0004\u0002\u0010\u0002!I!!%\t\u000f\u0005%\u0006\u0001\"\u0003\u0002,\"I!q\u0002\u0001\u0012\u0002\u0013%!\u0011\u0003\u0005\n\u0005O\u0001\u0011\u0013!C\u0005\u0005SAqA!\f\u0001\t\u0013\u0011y\u0003C\u0004\u0002`\u0002!IA!\u000f\u0003/1{7-\u00197MK\u0006$WM]#oIB{\u0017N\u001c;UKN$(B\u0001\u0016,\u0003\u0019\u0019XM\u001d<fe*\tA&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001y\u0003C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002oA\u0011\u0001\bA\u0007\u0002S\u0005!A/[7f+\u0005Y\u0004C\u0001\u001f@\u001b\u0005i$B\u0001 ,\u0003\u0015)H/\u001b7t\u0013\t\u0001UH\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003\u001d!x\u000e]5d\u0013\u0012,\u0012\u0001\u0012\t\u0003\u000b6k\u0011A\u0012\u0006\u0003\u000f\"\u000baaY8n[>t'B\u0001\u0017J\u0015\tQ5*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0019\u0006\u0019qN]4\n\u000593%\u0001B+vS\u0012\f\u0001\u0002^8qS\u000eLE\rI\u0001\u0006i>\u0004\u0018nY\u000b\u0002%B\u00111\u000bW\u0007\u0002)*\u0011QKV\u0001\u0005Y\u0006twMC\u0001X\u0003\u0011Q\u0017M^1\n\u0005e#&AB*ue&tw-\u0001\u0004u_BL7\rI\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o+\u0005i\u0006CA#_\u0013\tyfI\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\nAb]8ve\u000e,'I]8lKJ,\u0012a\u0019\t\u0003I\u001el\u0011!\u001a\u0006\u0003M.\nqa\u00197vgR,'/\u0003\u0002iK\nq!I]8lKJ,e\u000e\u001a)pS:$\u0018!D:pkJ\u001cWM\u0011:pW\u0016\u0014\b%\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0016\u00031\u0004\"\u0001O7\n\u00059L#A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0013e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0002riB\u0011\u0001G]\u0005\u0003gF\u0012A!\u00168ji\"9Q/DA\u0001\u0002\u0004a\u0017a\u0001=%c\u0005y!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b%\u0001\u0005f]\u0012\u0004v.\u001b8u+\u0005I\bC\u0001\u001d{\u0013\tY\u0018F\u0001\bMK\u0006$WM]#oIB{\u0017N\u001c;\u0002\u0019\u0015tG\rU8j]R|F%Z9\u0015\u0005Et\bbB;\u0011\u0003\u0003\u0005\r!_\u0001\nK:$\u0007k\\5oi\u0002\nQa]3u+B$\u0012!\u001d\u0015\u0004%\u0005\u001d\u0001\u0003BA\u0005\u0003/i!!a\u0003\u000b\t\u00055\u0011qB\u0001\u0004CBL'\u0002BA\t\u0003'\tqA[;qSR,'OC\u0002\u0002\u0016-\u000bQA[;oSRLA!!\u0007\u0002\f\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002+Q,7\u000f\u001e$fi\u000eDG*\u0019;fgR|eMZ:fi\"\u001a1#a\b\u0011\t\u0005%\u0011\u0011E\u0005\u0005\u0003G\tYA\u0001\u0003UKN$\u0018a\u0006;fgR4U\r^2i\u000b\u0006\u0014H.[3ti>3gm]3uQ\r!\u0012qD\u0001\u001fi\u0016\u001cHOR3uG\"l\u0015\r^3sS\u0006d\u0017N_1uS>tG+\u0019:hKRD3!FA\u0010\u0003a!Xm\u001d;GKR\u001c\u0007.\u00129pG\",e\u000eZ(gMN,Go\u001d\u0015\u0004-\u0005}!AD\"bY2\u0014\u0017mY6SKN,H\u000e^\u000b\u0005\u0003k\t\te\u0005\u0002\u0018_Q\u0011\u0011\u0011\b\t\u0006\u0003w9\u0012QH\u0007\u0002\u0001A!\u0011qHA!\u0019\u0001!q!a\u0011\u0018\u0005\u0004\t)EA\u0001U#\u0011\t9%!\u0014\u0011\u0007A\nI%C\u0002\u0002LE\u0012qAT8uQ&tw\rE\u00021\u0003\u001fJ1!!\u00152\u0005\r\te._\u0001\u0006m\u0006dW/Z\u000b\u0003\u0003/\u0002R\u0001MA-\u0003{I1!a\u00172\u0005\u0019y\u0005\u000f^5p]\u0006Ia/\u00197vK~#S-\u001d\u000b\u0004c\u0006\u0005\u0004\u0002C;\u001b\u0003\u0003\u0005\r!a\u0016\u0002\rY\fG.^3!\u0003\r1WO\\\u000b\u0003\u0003S\u0002R\u0001MA-\u0003W\u0002b\u0001MA7\u0003{\t\u0018bAA8c\tIa)\u001e8di&|g.M\u0001\bMVtw\fJ3r)\r\t\u0018Q\u000f\u0005\tkv\t\t\u00111\u0001\u0002j\u0005!a-\u001e8!\u0003!A\u0017m\u001d$je\u0016$WCAA?!\r\u0001\u0014qP\u0005\u0004\u0003\u0003\u000b$a\u0002\"p_2,\u0017M\\\u0001\u0005M&\u0014X\rF\u0002r\u0003\u000fCq!a\u0015!\u0001\u0004\ti$\u0001\u0004p]\u001aK'/\u001a\u000b\u0005\u0003s\ti\tC\u0004\u0002f\u0005\u0002\r!a\u001b\u00021\t,\u0018\u000e\u001c3MK\u0006$WM]!oI&\u001b(OU3rk\u0016\u001cH\u000f\u0006\u0003\u0002\u0014\u0006}\u0005\u0003BAK\u00037k!!a&\u000b\u0007\u0005ee)\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\ti*a&\u0003'1+\u0017\rZ3s\u0003:$\u0017j\u001d:SKF,Xm\u001d;\t\u000f\u0005\u0005&\u00051\u0001\u0002$\u0006YA.Z1eKJ,\u0005o\\2i!\r\u0001\u0014QU\u0005\u0004\u0003O\u000b$aA%oi\u0006i\u0011\r\u001d9f]\u0012\u0014VmY8sIN$B\"!,\u0002X\u0006e\u0017Q\\Aw\u0005\u000b\u0001R!a\u000f\u0018\u0003_\u0003B!!-\u0002R:!\u00111WAg\u001d\u0011\t),a3\u000f\t\u0005]\u0016\u0011\u001a\b\u0005\u0003s\u000b9M\u0004\u0003\u0002<\u0006\u0015g\u0002BA_\u0003\u0007l!!a0\u000b\u0007\u0005\u0005W&\u0001\u0004=e>|GOP\u0005\u0002\u0019&\u0011!jS\u0005\u0003Y%K!a\u0012%\n\u0007\u0005ee)\u0003\u0003\u0002P\u0006]\u0015a\u0004)s_\u0012,8-\u001a*fgB|gn]3\n\t\u0005M\u0017Q\u001b\u0002\u0012!\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9p]N,'\u0002BAh\u0003/CQA[\u0012A\u00021Da!a7$\u0001\u0004i\u0016!\u00039beRLG/[8o\u0011\u001d\tyn\ta\u0001\u0003C\fqA]3d_J$7\u000f\u0005\u0003\u0002d\u0006%XBAAs\u0015\r\t9OR\u0001\u0007e\u0016\u001cwN\u001d3\n\t\u0005-\u0018Q\u001d\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\u0013\u0005=8\u0005%AA\u0002\u0005E\u0018AB8sS\u001eLg\u000e\u0005\u0003\u0002t\n\u0005QBAA{\u0015\u0011\t90!?\u0002\u00071|wM\u0003\u0003\u0002|\u0006u\u0018!C5oi\u0016\u0014h.\u00197t\u0015\r\ty\u0010S\u0001\bgR|'/Y4f\u0013\u0011\u0011\u0019!!>\u0003\u0019\u0005\u0003\b/\u001a8e\u001fJLw-\u001b8\t\u0013\t\u001d1\u0005%AA\u0002\t%\u0011\u0001\u0004:fcVL'/\u001a3BG.\u001c\bc\u0001\u0019\u0003\f%\u0019!QB\u0019\u0003\u000bMCwN\u001d;\u0002/\u0005\u0004\b/\u001a8e%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\"TC\u0001B\nU\u0011\t\tP!\u0006,\u0005\t]\u0001\u0003\u0002B\r\u0005Gi!Aa\u0007\u000b\t\tu!qD\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\t2\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005K\u0011YBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fq#\u00199qK:$'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\t-\"\u0006\u0002B\u0005\u0005+\tAA\\8eKR!!\u0011\u0007B\u001c!\r)%1G\u0005\u0004\u0005k1%\u0001\u0002(pI\u0016DQa\u001e\u0014A\u0002\r,\"!!9")
public class LocalLeaderEndPointTest {
    private final MockTime time = new MockTime();
    private final Uuid topicId = Uuid.randomUuid();
    private final String topic;
    private final TopicPartition topicPartition = new TopicPartition(this.topic(), 5);
    private final BrokerEndPoint sourceBroker = new BrokerEndPoint(0, "localhost", 9092);
    private ReplicaManager replicaManager;
    private LeaderEndPoint endPoint;

    public MockTime time() {
        return this.time;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public String topic() {
        return this.topic;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public BrokerEndPoint sourceBroker() {
        return this.sourceBroker;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public LeaderEndPoint endPoint() {
        return this.endPoint;
    }

    public void endPoint_$eq(LeaderEndPoint x$1) {
        this.endPoint = x$1;
    }

    /*
     * WARNING - void declaration
     */
    @BeforeEach
    public void setUp() {
        void zkMetadataCache_isMultiTenant;
        void zkMetadataCache_kraftControllerNodes;
        void zkMetadataCache_brokerFeatures;
        void zkMetadataCache_metadataVersion;
        int x$1 = this.sourceBroker().id();
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$32 = this.sourceBroker().port();
        boolean x$42 = true;
        boolean x$52 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var52_11 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var53_14 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var54_17 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$42, x$52, x$32, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable)x$3 -> new File((String)x$3))), TestUtils$.MODULE$.createLogManager$default$2(), new MockConfigRepository(), new CleanerConfig(false), TestUtils$.MODULE$.defaultMockTime(), new Metrics(), new SegmentDeletionThrottlerConfig(){

            public Seq<FileStore> fileStores(Seq<File> logDirs) {
                return (Seq)logDirs.map((Function1 & Serializable)x$32 -> new TestUtils.DeterministicFileStore(TestUtils$.MODULE$.DefaultTotalAvailableBytes(), TestUtils$.MODULE$.DefaultInitialUsableBytes()));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$fileStores$1(java.io.File )}, serializedLambda);
            }
        }, MetadataVersion.latest(), TierLogComponents$.MODULE$.EMPTY(), 4);
        AlterPartitionManager alterPartitionManager = (AlterPartitionManager)Mockito.mock(AlterPartitionManager.class);
        Metrics metrics = new Metrics();
        QuotaFactory.QuotaManagers quotaManager = QuotaFactory$.MODULE$.instantiate(config, metrics, (Time)this.time(), "", (Option)None$.MODULE$);
        MockTime x$24 = this.time();
        MockScheduler x$25 = new MockScheduler((Time)this.time());
        boolean bl = false;
        Seq seq = (Seq)Seq$.MODULE$.empty();
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createEmpty();
        MetadataVersion metadataVersion = config.interBrokerProtocolVersion();
        int zkMetadataCache_brokerId = config.brokerId();
        metadataVersion = null;
        brokerFeatures = null;
        seq = null;
        ZkMetadataCache x$28 = new ZkMetadataCache(zkMetadataCache_brokerId, (MetadataVersion)zkMetadataCache_metadataVersion, (BrokerFeatures)zkMetadataCache_brokerFeatures, (Seq)zkMetadataCache_kraftControllerNodes, (boolean)zkMetadataCache_isMultiTenant);
        LogDirFailureChannel x$29 = new LogDirFailureChannel(config.logDirs().size());
        ActionQueue x$31 = new ActionQueue();
        BrokerTopicStats x$322 = new BrokerTopicStats();
        Function0 x$33 = ReplicaManager$.MODULE$.$lessinit$greater$default$12();
        None$ x$34 = None$.MODULE$;
        None$ x$35 = None$.MODULE$;
        None$ x$36 = None$.MODULE$;
        None$ x$37 = None$.MODULE$;
        None$ x$38 = None$.MODULE$;
        None$ x$39 = None$.MODULE$;
        TierReplicaComponents x$40 = TierReplicaComponents$.MODULE$.EMPTY();
        None$ x$41 = None$.MODULE$;
        None$ x$422 = None$.MODULE$;
        None$ x$43 = None$.MODULE$;
        Function0 x$44 = ReplicaManager$.MODULE$.$lessinit$greater$default$23();
        this.replicaManager_$eq(new ReplicaManager(config, metrics, (Time)x$24, (Scheduler)x$25, mockLogMgr, quotaManager, (MetadataCache)x$28, x$29, alterPartitionManager, x$31, x$322, x$33, (Option)x$34, (Option)x$35, (Option)x$36, (Option)x$37, (Option)x$38, (Option)x$39, x$40, (Option)x$41, (Option)x$422, (Option)x$43, x$44));
        this.replicaManager().createPartition(this.topicPartition()).createLogIfNotExists(false, false, (OffsetCheckpoints)new LazyOffsetCheckpoints(this.replicaManager().highWatermarkCheckpoints()), (Option)None$.MODULE$);
        LeaderAndIsrRequest leaderAndIsrRequest = this.buildLeaderAndIsrRequest(0);
        this.replicaManager().becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2 & Serializable)(x$4, x$5) -> {
            LocalLeaderEndPointTest.$anonfun$setUp$2(x$4, x$5);
            return BoxedUnit.UNIT;
        });
        this.replicaManager().getPartitionOrException(this.topicPartition()).localLogOrException();
        this.endPoint_$eq((LeaderEndPoint)new LocalLeaderEndPoint(this.sourceBroker(), config, this.replicaManager(), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$));
    }

    @Test
    public void testFetchLatestOffset() {
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchLatestOffset$1(response);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(3L, 0), (Object)this.endPoint().fetchLatestOffset(this.topicPartition(), 0));
        LeaderAndIsrRequest leaderAndIsrRequest = this.buildLeaderAndIsrRequest(4);
        this.replicaManager().becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2 & Serializable)(x$6, x$7) -> {
            LocalLeaderEndPointTest.$anonfun$testFetchLatestOffset$2(x$6, x$7);
            return BoxedUnit.UNIT;
        });
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchLatestOffset$3(response);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(6L, 4), (Object)this.endPoint().fetchLatestOffset(this.topicPartition(), 7));
    }

    @Test
    public void testFetchEarliestOffset() {
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestOffset$1(response);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(0L, 0), (Object)this.endPoint().fetchEarliestOffset(this.topicPartition(), 0));
        LeaderAndIsrRequest leaderAndIsrRequest = this.buildLeaderAndIsrRequest(4);
        this.replicaManager().becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2 & Serializable)(x$8, x$9) -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestOffset$2(x$8, x$9);
            return BoxedUnit.UNIT;
        });
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestOffset$3(response);
            return BoxedUnit.UNIT;
        });
        this.replicaManager().deleteRecords(1000L, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)3L))})), (Function1 & Serializable)x$10 -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestOffset$4(x$10);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(3L, 4), (Object)this.endPoint().fetchEarliestOffset(this.topicPartition(), 7));
    }

    @Test
    public void testFetchMaterializationTarget() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.endPoint().fetchTierMaterializationTarget(this.topicPartition(), 1));
    }

    @Test
    public void testFetchEpochEndOffsets() {
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEpochEndOffsets$1(response);
            return BoxedUnit.UNIT;
        });
        Map result = this.endPoint().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.topicPartition().partition()).setLeaderEpoch(0))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(0).setEndOffset(3L))}))), (Object)result);
        LeaderAndIsrRequest leaderAndIsrRequest = this.buildLeaderAndIsrRequest(4);
        this.replicaManager().becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2 & Serializable)(x$11, x$12) -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEpochEndOffsets$2(x$11, x$12);
            return BoxedUnit.UNIT;
        });
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEpochEndOffsets$3(response);
            return BoxedUnit.UNIT;
        });
        result = this.endPoint().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.topicPartition().partition()).setLeaderEpoch(4))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(4).setEndOffset(6L))}))), (Object)result);
        result = this.endPoint().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.topicPartition().partition()).setLeaderEpoch(3))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(0).setEndOffset(3L))}))), (Object)result);
        result = this.endPoint().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.topicPartition().partition()).setLeaderEpoch(5))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(-1).setEndOffset(-1L))}))), (Object)result);
    }

    private LeaderAndIsrRequest buildLeaderAndIsrRequest(int leaderEpoch) {
        java.util.List brokerList = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.sourceBroker().id()), (List)Nil$.MODULE$)).asJava();
        java.util.Map<String, Uuid> topicIds = Collections.singletonMap(this.topic(), this.topicId());
        return (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, 0L, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(this.topicPartition().partition()).setControllerEpoch(0).setLeader(this.sourceBroker().id()).setLeaderEpoch(leaderEpoch).setIsr(brokerList).setPartitionEpoch(0).setReplicas(brokerList).setIsNew(false), (List)Nil$.MODULE$)).asJava(), topicIds, true, (Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[]{this.node(this.sourceBroker())}))).asJava(), false).build();
    }

    private CallbackResult<ProduceResponse.PartitionResponse> appendRecords(ReplicaManager replicaManager, TopicPartition partition, MemoryRecords records, AppendOrigin origin, short requiredAcks) {
        CallbackResult<ProduceResponse.PartitionResponse> result = new CallbackResult<ProduceResponse.PartitionResponse>();
        replicaManager.appendRecords(1000L, requiredAcks, false, origin, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)records)})), (Function1 & Serializable)responses -> {
            LocalLeaderEndPointTest.appendCallback$1(responses, partition, result);
            return BoxedUnit.UNIT;
        }, replicaManager.appendRecords$default$7(), replicaManager.appendRecords$default$8(), replicaManager.appendRecords$default$9(), replicaManager.appendRecords$default$10());
        return result;
    }

    private AppendOrigin appendRecords$default$4() {
        return AppendOrigin.CLIENT;
    }

    private short appendRecords$default$5() {
        return -1;
    }

    private Node node(BrokerEndPoint endPoint) {
        return new Node(endPoint.id(), endPoint.host(), endPoint.port());
    }

    /*
     * WARNING - void declaration
     */
    private MemoryRecords records() {
        void withRecords_timestampType;
        SimpleRecord[] withRecords_records = new SimpleRecord[]{new SimpleRecord("first message".getBytes()), new SimpleRecord("second message".getBytes()), new SimpleRecord("third message".getBytes())};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        return MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
    }

    public static final /* synthetic */ void $anonfun$setUp$2(Iterable x$4, Iterable x$5) {
    }

    public static final /* synthetic */ void $anonfun$testFetchLatestOffset$1(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchLatestOffset$2(Iterable x$6, Iterable x$7) {
    }

    public static final /* synthetic */ void $anonfun$testFetchLatestOffset$3(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestOffset$1(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestOffset$2(Iterable x$8, Iterable x$9) {
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestOffset$3(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestOffset$4(Map x$10) {
    }

    public static final /* synthetic */ void $anonfun$testFetchEpochEndOffsets$1(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEpochEndOffsets$2(Iterable x$11, Iterable x$12) {
    }

    public static final /* synthetic */ void $anonfun$testFetchEpochEndOffsets$3(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    private static final void appendCallback$1(Map responses, TopicPartition partition$1, CallbackResult result$1) {
        Option response = responses.get((Object)partition$1);
        Assertions.assertTrue((boolean)response.isDefined());
        result$1.fire(response.get());
    }

    public LocalLeaderEndPointTest() {
        this.topic = "test";
    }

    private class CallbackResult<T> {
        private Option<T> value;
        private Option<Function1<T, BoxedUnit>> fun;

        private Option<T> value() {
            return this.value;
        }

        private void value_$eq(Option<T> x$1) {
            this.value = x$1;
        }

        private Option<Function1<T, BoxedUnit>> fun() {
            return this.fun;
        }

        private void fun_$eq(Option<Function1<T, BoxedUnit>> x$1) {
            this.fun = x$1;
        }

        public boolean hasFired() {
            return this.value().isDefined();
        }

        public void fire(T value) {
            this.value_$eq((Option<T>)new Some(value));
            this.fun().foreach((Function1 & Serializable)f -> {
                f.apply(value);
                return BoxedUnit.UNIT;
            });
        }

        public CallbackResult<T> onFire(Function1<T, BoxedUnit> fun) {
            this.fun_$eq((Option<Function1<T, BoxedUnit>>)new Some(fun));
            if (this.hasFired()) {
                this.fire(this.value().get());
            }
            return this;
        }

        public /* synthetic */ LocalLeaderEndPointTest kafka$server$LocalLeaderEndPointTest$CallbackResult$$$outer() {
            return LocalLeaderEndPointTest.this;
        }

        public CallbackResult() {
            if (LocalLeaderEndPointTest.this == null) {
                throw null;
            }
            this.value = None$.MODULE$;
            this.fun = None$.MODULE$;
        }
    }
}

