/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005e\u0001B\n\u0015\u0001eAQA\b\u0001\u0005\u0002}Aq!\t\u0001C\u0002\u0013\u0005!\u0005\u0003\u0004,\u0001\u0001\u0006Ia\t\u0005\bY\u0001\u0011\r\u0011\"\u0001.\u0011\u0019I\u0004\u0001)A\u0005]!)!\b\u0001C\u0001w!)Q\n\u0001C\u0001w!)q\n\u0001C\u0001w!)\u0011\u000b\u0001C\u0001%\")1\u000e\u0001C\u0001w!)Q\u000e\u0001C\u0001w!1q\u000e\u0001Q\u0005\nAD\u0001\"a\n\u0001A\u0013%\u0011\u0011\u0006\u0005\u0007\u0003o\u0001A\u0011A\u001e\t\r\u0005m\u0002\u0001\"\u0001<\u0011\u001d\ty\u0004\u0001C\u0005\u0003\u0003Baa\u001c\u0001\u0005\n\u0005]\u0003bBA3\u0001\u0011\u0005\u0011q\r\u0002\u0017\u0019&\u001cHo\u00144gg\u0016$8OU3rk\u0016\u001cH\u000fV3ti*\u0011QCF\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003]\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00015A\u00111\u0004H\u0007\u0002)%\u0011Q\u0004\u0006\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\u00061A(\u001b8jiz\"\u0012\u0001\t\t\u00037\u0001\tQ\u0001^8qS\u000e,\u0012a\t\t\u0003I%j\u0011!\n\u0006\u0003M\u001d\nA\u0001\\1oO*\t\u0001&\u0001\u0003kCZ\f\u0017B\u0001\u0016&\u0005\u0019\u0019FO]5oO\u00061Ao\u001c9jG\u0002\n\u0011\u0002]1si&$\u0018n\u001c8\u0016\u00039\u0002\"aL\u001c\u000e\u0003AR!!\r\u001a\u0002\r\r|W.\\8o\u0015\t92G\u0003\u00025k\u00051\u0011\r]1dQ\u0016T\u0011AN\u0001\u0004_J<\u0017B\u0001\u001d1\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f!\u0002]1si&$\u0018n\u001c8!\u0003-\"Xm\u001d;MSN$xJ\u001a4tKR\u001c(+Z9vKN$hi\u001c:O_:$\u0016.\u001a:fIB\u000b'\u000f^5uS>tG#\u0001\u001f\u0011\u0005u\u0002U\"\u0001 \u000b\u0003}\nQa]2bY\u0006L!!\u0011 \u0003\tUs\u0017\u000e\u001e\u0015\u0003\r\r\u0003\"\u0001R&\u000e\u0003\u0015S!AR$\u0002\u0007\u0005\u0004\u0018N\u0003\u0002I\u0013\u00069!.\u001e9ji\u0016\u0014(B\u0001&6\u0003\u0015QWO\\5u\u0013\taUI\u0001\u0003UKN$\u0018!\u0007;fgRd\u0015n\u001d;PM\u001a\u001cX\r^:FeJ|'oQ8eKND#aB\"\u0002QQ,7\u000f\u001e'jgR|eMZ:fiNl\u0015\r\u001f+j[\u0016\u001cF/Y7q\u001f2$Wm\u001d;WKJ\u001c\u0018n\u001c8)\u0005!\u0019\u0015aG1tg\u0016\u0014HOU3ta>t7/Z#se>\u0014hi\u001c:Fa>\u001c\u0007\u000e\u0006\u0003='n\u0003\u0007\"\u0002+\n\u0001\u0004)\u0016!B3se>\u0014\bC\u0001,Z\u001b\u00059&B\u0001-1\u0003!\u0001(o\u001c;pG>d\u0017B\u0001.X\u0005\u0019)%O]8sg\")A,\u0003a\u0001;\u0006A!M]8lKJLE\r\u0005\u0002>=&\u0011qL\u0010\u0002\u0004\u0013:$\b\"B1\n\u0001\u0004\u0011\u0017AE2veJ,g\u000e\u001e'fC\u0012,'/\u00129pG\"\u00042a\u00194i\u001b\u0005!'BA3(\u0003\u0011)H/\u001b7\n\u0005\u001d$'\u0001C(qi&|g.\u00197\u0011\u0005\u0011J\u0017B\u00016&\u0005\u001dIe\u000e^3hKJ\fq\t^3ti2K7\u000f^(gMN,Go\u001d*fcV,7\u000f\u001e#ve&tw\rU1si&$\u0018n\u001c8SK\u000e|g/\u001a:z\u0003\u001a$XM]+oG2,\u0017M\u001c'fC\u0012,'/\u00127fGRLwN\u001c\u0015\u0003\u0015\r\u000b!\u0004^3ti\u000e+(O]3oi\u0016\u0003xn\u00195WC2LG-\u0019;j_:D#aC\"\u0002\u0017M,g\u000e\u001a*fcV,7\u000f\u001e\u000b\bc\u0006=\u00111CA\u000f!\r\u0011\u0018\u0011\u0002\b\u0004g\u0006\raB\u0001;\u0000\u001d\t)hP\u0004\u0002w{:\u0011q\u000f \b\u0003qnl\u0011!\u001f\u0006\u0003ub\ta\u0001\u0010:p_Rt\u0014\"\u0001\u001c\n\u0005Q*\u0014BA\f4\u0013\t\t$'C\u0002\u0002\u0002A\nq!\\3tg\u0006<W-\u0003\u0003\u0002\u0006\u0005\u001d\u0011a\u0006'jgR|eMZ:fiN\u0014Vm\u001d9p]N,G)\u0019;b\u0015\r\t\t\u0001M\u0005\u0005\u0003\u0017\tiA\u0001\u000fMSN$xJ\u001a4tKR\u001c\b+\u0019:uSRLwN\u001c*fgB|gn]3\u000b\t\u0005\u0015\u0011q\u0001\u0005\u0007\u0003#a\u0001\u0019A/\u0002\u0011M,'O^3s\u0013\u0012Dq!!\u0006\r\u0001\u0004\t9\"A\u0005uS6,7\u000f^1naB\u0019Q(!\u0007\n\u0007\u0005maH\u0001\u0003M_:<\u0007bBA\u0010\u0019\u0001\u0007\u0011\u0011E\u0001\bm\u0016\u00148/[8o!\ri\u00141E\u0005\u0004\u0003Kq$!B*i_J$\u0018a\u00054fi\u000eDwJ\u001a4tKR\fe\u000eZ#q_\u000eDG\u0003CA\u0016\u0003c\t\u0019$!\u000e\u0011\ru\ni#a\u0006^\u0013\r\tyC\u0010\u0002\u0007)V\u0004H.\u001a\u001a\t\r\u0005EQ\u00021\u0001^\u0011\u001d\t)\"\u0004a\u0001\u0003/Aq!a\b\u000e\u0001\u0004\t\t#A\u0010uKN$(+Z:q_:\u001cX-\u00138dYV$Wm\u001d'fC\u0012,'/\u00129pG\"D#AD\"\u0002kQ,7\u000f\u001e*fgB|gn]3EK\u001a\fW\u000f\u001c;PM\u001a\u001cX\r^!oI2+\u0017\rZ3s\u000bB|7\r\u001b$pe\u0006cGNV3sg&|gn\u001d\u0015\u0003\u001f\r\u000b1#Y:tKJ$(+Z:q_:\u001cX-\u0012:s_J$r\u0001PA\"\u0003\u000b\n9\u0005C\u0003U!\u0001\u0007Q\u000bC\u0003]!\u0001\u0007Q\fC\u0004\u0002JA\u0001\r!a\u0013\u0002\u000fI,\u0017/^3tiB!\u0011QJA*\u001b\t\tyEC\u0002\u0002RA\n\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003+\nyE\u0001\nMSN$xJ\u001a4tKR\u001c(+Z9vKN$HCBA-\u0003?\n\u0019\u0007\u0005\u0003\u0002N\u0005m\u0013\u0002BA/\u0003\u001f\u00121\u0003T5ti>3gm]3ugJ+7\u000f]8og\u0016Da!!\u0019\u0012\u0001\u0004i\u0016\u0001\u00037fC\u0012,'/\u00133\t\u000f\u0005%\u0013\u00031\u0001\u0002L\u0005Y1M]3bi\u0016$v\u000e]5d)\u0019\tI'!\u001f\u0002~A1\u00111NA:;vsA!!\u001c\u0002pA\u0011\u0001PP\u0005\u0004\u0003cr\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002v\u0005]$aA'ba*\u0019\u0011\u0011\u000f \t\r\u0005m$\u00031\u0001^\u00035qW/\u001c)beRLG/[8og\"1\u0011q\u0010\nA\u0002u\u000b\u0011C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s\u0001")
public class ListOffsetsRequestTest
extends BaseRequestTest {
    private final String topic;
    private final TopicPartition partition = new TopicPartition(this.topic(), 0);

    public String topic() {
        return this.topic;
    }

    public TopicPartition partition() {
        return this.partition;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListOffsetsRequestForNonTieredPartition() {
        String topicName = "test-topic";
        Properties props = new Properties();
        props.put("segment.bytes", "16384");
        props.put("retention.bytes", "-1");
        Map<Object, Object> partitionToLeaderMap = this.createTopic(topicName, 1, 1, props, this.createTopic$default$5(), this.createTopic$default$6());
        int numMessages = 3000;
        TestUtils$.MODULE$.generateAndProduceMessages(this.servers().toSeq(), topicName, numMessages, -1);
        TopicPartition topicPartition = new TopicPartition(topicName, 0);
        int leaderId = BoxesRunTime.unboxToInt((Object)partitionToLeaderMap.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        LogManager qual$1 = ((KafkaServer)this.serverForId(leaderId).get()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$1.getLog(topicPartition, x$2).get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 180000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ListOffsetsRequestTest.$anonfun$testListOffsetsRequestForNonTieredPartition$1(log, numMessages)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timeout waiting for all records to be produced");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.makeListOffsetsRequestAndValidateResponse(topicPartition, -1L, leaderId, log, (short)0);
        log.maybeIncrementHighWatermark(new LogOffsetMetadata(log.logStartOffset() + 100L));
        log.maybeIncrementLogStartOffset(log.logStartOffset() + 100L, LogStartOffsetIncrementReason.LeaderOffsetIncremented);
        this.makeListOffsetsRequestAndValidateResponse(topicPartition, -1L, leaderId, log, (short)0);
        this.makeListOffsetsRequestAndValidateResponse(topicPartition, -2L, leaderId, log, (short)0);
    }

    @Test
    public void testListOffsetsErrorCodes() {
        java.util.List targetTimes = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(this.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(this.partition().partition()).setTimestamp(-2L).setCurrentLeaderEpoch(0), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava();
        ListOffsetsRequest consumerRequest = (ListOffsetsRequest)ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false).setTargetTimes(targetTimes).build();
        ListOffsetsRequest replicaRequest = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)((KafkaServer)this.servers().head()).config().brokerId()).setTargetTimes(targetTimes).build();
        ListOffsetsRequest debugReplicaRequest = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)-2).setTargetTimes(targetTimes).build();
        int randomBrokerId = ((KafkaServer)this.servers().head()).config().brokerId();
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, consumerRequest);
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, replicaRequest);
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, debugReplicaRequest);
        Map<Object, Object> partitionToLeader = this.createTopic(1, 2);
        Set replicas = this.zkClient().getReplicasForPartition(this.partition()).toSet();
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)this.partition().partition())));
        int follower = BoxesRunTime.unboxToInt((Object)replicas.find((Function1)(JFunction1.mcZI.sp & Serializable)x$1 -> x$1 != leader).get());
        int nonReplica = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.servers().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)ListOffsetsRequestTest.$anonfun$testListOffsetsErrorCodes$2(x$2)))).find((Function1)(JFunction1.mcZI.sp & Serializable)x$3 -> !replicas.contains((Object)BoxesRunTime.boxToInteger((int)x$3))).get());
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, follower, consumerRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, follower, replicaRequest);
        this.assertResponseError(Errors.NONE, follower, debugReplicaRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, consumerRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, replicaRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, debugReplicaRequest);
    }

    @Test
    public void testListOffsetsMaxTimeStampOldestVersion() {
        ListOffsetsRequest.Builder consumerRequestBuilder = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false);
        ListOffsetsRequest.Builder maxTimestampRequestBuilder = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)true);
        Assertions.assertEquals((short)((short)0), (short)consumerRequestBuilder.oldestAllowedVersion());
        Assertions.assertEquals((short)((short)7), (short)maxTimestampRequestBuilder.oldestAllowedVersion());
    }

    public void assertResponseErrorForEpoch(Errors error, int brokerId, Optional<Integer> currentLeaderEpoch) {
        ListOffsetsRequestData.ListOffsetsPartition listOffsetPartition = new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(this.partition().partition()).setTimestamp(-2L);
        if (currentLeaderEpoch.isPresent()) {
            listOffsetPartition.setCurrentLeaderEpoch(Predef$.MODULE$.Integer2int(currentLeaderEpoch.get()));
        }
        java.util.List targetTimes = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(this.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)listOffsetPartition, (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava();
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false).setTargetTimes(targetTimes).build();
        this.assertResponseError(error, brokerId, request);
    }

    @Test
    public void testListOffsetsRequestDuringPartitionRecoveryAfterUncleanLeaderElection() {
        String topic = "topic";
        TopicPartition partition = new TopicPartition(topic, 0);
        Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 2, (Seq<KafkaBroker>)this.servers(), new Properties());
        Set replicas = this.zkClient().getReplicasForPartition(partition).toSet();
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition.partition())));
        int follower = BoxesRunTime.unboxToInt((Object)replicas.find((Function1)(JFunction1.mcZI.sp & Serializable)x$4 -> x$4 != leader).get());
        int nonReplica = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.servers().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)ListOffsetsRequestTest.$anonfun$testListOffsetsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$2(x$5)))).find((Function1)(JFunction1.mcZI.sp & Serializable)x$6 -> !replicas.contains((Object)BoxesRunTime.boxToInteger((int)x$6))).get());
        TestUtils$.MODULE$.forceOverrideLeaderRecoveryState(((KafkaServer)this.servers().find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTest.$anonfun$testListOffsetsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$5(leader, x$7))).get()).replicaManager().getPartitionOrException(partition), LeaderRecoveryState.RECOVERED);
        this.sendListOffsetsRequestAndValidateResponse$1(Errors.NONE, Errors.NONE, leader, topic, partition);
        this.sendListOffsetsRequestAndValidateResponse$1(Errors.NOT_LEADER_OR_FOLLOWER, Errors.NONE, follower, topic, partition);
        this.sendListOffsetsRequestAndValidateResponse$1(Errors.NOT_LEADER_OR_FOLLOWER, Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, topic, partition);
        TestUtils$.MODULE$.forceOverrideLeaderRecoveryState(((KafkaServer)this.servers().find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTest.$anonfun$testListOffsetsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$6(leader, x$8))).get()).replicaManager().getPartitionOrException(partition), LeaderRecoveryState.RECOVERING);
        this.sendListOffsetsRequestAndValidateResponse$1(Errors.NOT_LEADER_OR_FOLLOWER, Errors.NOT_LEADER_OR_FOLLOWER, leader, topic, partition);
        this.sendListOffsetsRequestAndValidateResponse$1(Errors.NOT_LEADER_OR_FOLLOWER, Errors.NONE, follower, topic, partition);
        this.sendListOffsetsRequestAndValidateResponse$1(Errors.NOT_LEADER_OR_FOLLOWER, Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, topic, partition);
        TestUtils$.MODULE$.forceOverrideLeaderRecoveryState(((KafkaServer)this.servers().find((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTest.$anonfun$testListOffsetsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$7(leader, x$9))).get()).replicaManager().getPartitionOrException(partition), LeaderRecoveryState.RECOVERED);
        this.sendListOffsetsRequestAndValidateResponse$1(Errors.NONE, Errors.NONE, leader, topic, partition);
        this.sendListOffsetsRequestAndValidateResponse$1(Errors.NOT_LEADER_OR_FOLLOWER, Errors.NONE, follower, topic, partition);
        this.sendListOffsetsRequestAndValidateResponse$1(Errors.NOT_LEADER_OR_FOLLOWER, Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, topic, partition);
    }

    @Test
    public void testCurrentEpochValidation() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(1, 3).apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange(this.servers(), topicPartition, firstLeaderId, 15000L);
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaBroker>)this.servers());
        this.assertResponseErrorForEpoch(Errors.NONE, secondLeaderId, Optional.empty());
        this.assertResponseErrorForEpoch(Errors.NONE, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)));
        this.assertResponseErrorForEpoch(Errors.FENCED_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)));
        this.assertResponseErrorForEpoch(Errors.UNKNOWN_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)));
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaBroker>)this.servers());
        this.assertResponseErrorForEpoch(Errors.NOT_LEADER_OR_FOLLOWER, followerId, Optional.empty());
        this.assertResponseErrorForEpoch(Errors.NOT_LEADER_OR_FOLLOWER, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)));
        this.assertResponseErrorForEpoch(Errors.UNKNOWN_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)));
        this.assertResponseErrorForEpoch(Errors.FENCED_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)));
    }

    private ListOffsetsResponseData.ListOffsetsPartitionResponse sendRequest(int serverId, long timestamp, short version) {
        java.util.List targetTimes = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(this.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(this.partition().partition()).setTimestamp(timestamp), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava();
        ListOffsetsRequest.Builder builder = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false).setTargetTimes(targetTimes);
        ListOffsetsRequest request = version == -1 ? (ListOffsetsRequest)builder.build() : builder.build(version);
        return (ListOffsetsResponseData.ListOffsetsPartitionResponse)CollectionConverters$.MODULE$.ListHasAsScala(((ListOffsetsResponseData.ListOffsetsTopicResponse)CollectionConverters$.MODULE$.ListHasAsScala(this.sendRequest(serverId, request).topics()).asScala().find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTest.$anonfun$sendRequest$1(this, x$10))).get()).partitions()).asScala().find((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTest.$anonfun$sendRequest$2(this, x$11))).get();
    }

    private Tuple2<Object, Object> fetchOffsetAndEpoch(int serverId, long timestamp, short version) {
        ListOffsetsResponseData.ListOffsetsPartitionResponse partitionData = this.sendRequest(serverId, timestamp, version);
        if (version == 0) {
            if (partitionData.oldStyleOffsets().isEmpty()) {
                return new Tuple2.mcJI.sp(-1L, partitionData.leaderEpoch());
            }
            return new Tuple2.mcJI.sp(Predef$.MODULE$.Long2long((Long)CollectionConverters$.MODULE$.ListHasAsScala(partitionData.oldStyleOffsets()).asScala().head()), partitionData.leaderEpoch());
        }
        return new Tuple2.mcJI.sp(partitionData.offset(), partitionData.leaderEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testResponseIncludesLeaderEpoch() {
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(1, 3).apply((Object)BoxesRunTime.boxToInteger((int)this.partition().partition())));
        TestUtils$.MODULE$.generateAndProduceMessages(this.servers(), this.topic(), 9, -1);
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "test-10", Predef$.MODULE$.long2Long(System.currentTimeMillis() + 10L), 30000, 20000);
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -4L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(9L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -3L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -10000L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -10001L, (short)-1));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange(this.servers(), this.partition(), firstLeaderId, 15000L);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ListOffsetsRequestTest.$anonfun$testResponseIncludesLeaderEpoch$1(this, secondLeaderId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"the second leader does not sync to follower");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, this.partition(), (Iterable<KafkaBroker>)this.servers());
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(secondLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(secondLeaderId, -4L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(secondLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(secondLeaderId, -2L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(secondLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(secondLeaderId, -2L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, secondLeaderEpoch), this.fetchOffsetAndEpoch(secondLeaderId, -1L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(9L, secondLeaderEpoch), this.fetchOffsetAndEpoch(secondLeaderId, -3L, (short)-1));
    }

    @Test
    public void testResponseDefaultOffsetAndLeaderEpochForAllVersions() {
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(1, 3).apply((Object)BoxesRunTime.boxToInteger((int)this.partition().partition())));
        TestUtils$.MODULE$.generateAndProduceMessages(this.servers(), this.topic(), 9, -1);
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "test-10", Predef$.MODULE$.long2Long(System.currentTimeMillis() + 10L), 30000, 20000);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ApiKeys.LIST_OFFSETS.oldestVersion()), (int)ApiKeys.LIST_OFFSETS.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> {
            if (version == 0) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(-1L, -1), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -4L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                return;
            }
            if (version >= 1 && version <= 3) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -4L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                return;
            }
            if (version >= 4 && version <= 6) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -4L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                return;
            }
            if (version >= 7) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -4L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(9L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -3L, (short)version));
                return;
            }
        });
    }

    private void assertResponseError(Errors error, int brokerId, ListOffsetsRequest request) {
        ListOffsetsResponse response = this.sendRequest(brokerId, request);
        Assertions.assertEquals((int)request.topics().size(), (int)response.topics().size());
        CollectionConverters$.MODULE$.ListHasAsScala(response.topics()).asScala().foreach((Function1 & Serializable)topic -> {
            ListOffsetsRequestTest.$anonfun$assertResponseError$1(error, topic);
            return BoxedUnit.UNIT;
        });
    }

    private ListOffsetsResponse sendRequest(int leaderId, ListOffsetsRequest request) {
        return (ListOffsetsResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ListOffsetsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    public Map<Object, Object> createTopic(int numPartitions, int replicationFactor) {
        return TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), numPartitions, replicationFactor, (Seq<KafkaBroker>)this.servers(), new Properties());
    }

    public static final /* synthetic */ boolean $anonfun$testListOffsetsRequestForNonTieredPartition$1(AbstractLog log$1, int numMessages$1) {
        return log$1.logEndOffset() == (long)numMessages$1;
    }

    public static final /* synthetic */ String $anonfun$testListOffsetsRequestForNonTieredPartition$2() {
        return "Timeout waiting for all records to be produced";
    }

    public static final /* synthetic */ int $anonfun$testListOffsetsErrorCodes$2(KafkaServer x$2) {
        return x$2.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testListOffsetsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$2(KafkaServer x$5) {
        return x$5.config().brokerId();
    }

    private final void sendListOffsetsRequestAndValidateResponse$1(Errors error, Errors debugRequestError, int brokerId, String topic$1, TopicPartition partition$1) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ApiKeys.LIST_OFFSETS.oldestVersion()), (int)ApiKeys.LIST_OFFSETS.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)ver -> {
            int currentLeaderEpoch = ver >= 4 ? 0 : -1;
            java.util.List targetTimes = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(topic$1).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(partition$1.partition()).setTimestamp(-2L).setCurrentLeaderEpoch(currentLeaderEpoch), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava();
            ListOffsetsRequest consumerRequest = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false).setTargetTimes(targetTimes).build((short)ver);
            this.assertResponseError(error, brokerId, consumerRequest);
            ListOffsetsRequest replicaRequest = ListOffsetsRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)((KafkaServer)this.servers().head()).config().brokerId()).setTargetTimes(targetTimes).build((short)ver);
            this.assertResponseError(error, brokerId, replicaRequest);
            ListOffsetsRequest debugReplicaRequest = ListOffsetsRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)-2).setTargetTimes(targetTimes).build((short)ver);
            this.assertResponseError(debugRequestError, brokerId, debugReplicaRequest);
        });
    }

    public static final /* synthetic */ boolean $anonfun$testListOffsetsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$5(int leader$2, KafkaServer x$7) {
        return x$7.config().brokerId() == leader$2;
    }

    public static final /* synthetic */ boolean $anonfun$testListOffsetsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$6(int leader$2, KafkaServer x$8) {
        return x$8.config().brokerId() == leader$2;
    }

    public static final /* synthetic */ boolean $anonfun$testListOffsetsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$7(int leader$2, KafkaServer x$9) {
        return x$9.config().brokerId() == leader$2;
    }

    public static final /* synthetic */ boolean $anonfun$sendRequest$1(ListOffsetsRequestTest $this, ListOffsetsResponseData.ListOffsetsTopicResponse x$10) {
        String string = x$10.name();
        String string2 = $this.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$sendRequest$2(ListOffsetsRequestTest $this, ListOffsetsResponseData.ListOffsetsPartitionResponse x$11) {
        return x$11.partitionIndex() == $this.partition().partition();
    }

    public static final /* synthetic */ boolean $anonfun$testResponseIncludesLeaderEpoch$1(ListOffsetsRequestTest $this, int secondLeaderId$1) {
        return $this.sendRequest(secondLeaderId$1, 0L, (short)-1).errorCode() != Errors.OFFSET_NOT_AVAILABLE.code();
    }

    public static final /* synthetic */ String $anonfun$testResponseIncludesLeaderEpoch$2() {
        return "the second leader does not sync to follower";
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$2(Errors error$2, ListOffsetsResponseData.ListOffsetsPartitionResponse partition) {
        Assertions.assertEquals((short)error$2.code(), (short)partition.errorCode());
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$1(Errors error$2, ListOffsetsResponseData.ListOffsetsTopicResponse topic) {
        CollectionConverters$.MODULE$.ListHasAsScala(topic.partitions()).asScala().foreach((Function1 & Serializable)partition -> {
            ListOffsetsRequestTest.$anonfun$assertResponseError$2(error$2, partition);
            return BoxedUnit.UNIT;
        });
    }

    public ListOffsetsRequestTest() {
        this.topic = "topic";
    }
}

