/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.server.DefaultAlterPartitionManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.server.QuorumTestHarness;
import kafka.server.ZkAlterPartitionManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.BrokerState;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005ma\u0001B\n\u0015\u0001eAQA\b\u0001\u0005\u0002}Aq!\t\u0001C\u0002\u0013\u0005!\u0005\u0003\u00040\u0001\u0001\u0006Ia\t\u0005\u0006a\u0001!\t%\r\u0005\u0006\u0015\u0002!\te\u0013\u0005\u0006!\u0002!\ta\u0013\u0005\u0006+\u0002!\ta\u0013\u0005\u0006/\u0002!I\u0001\u0017\u0005\u0006S\u0002!\ta\u0013\u0005\u0006W\u0002!\ta\u0013\u0005\u0006[\u0002!\ta\u0013\u0005\u0006_\u0002!\ta\u0013\u0005\u0006c\u0002!\ta\u0013\u0005\u0006g\u0002!\ta\u0013\u0005\u0006k\u0002!\ta\u0013\u0005\u0006o\u0002!\ta\u0013\u0005\u0006{\u0002!\tA \u0005\u0007\u0003/\u0001A\u0011A&\u0003\u001f-\u000bgm[1TKJ4XM\u001d+fgRT!!\u0006\f\u0002\rM,'O^3s\u0015\u00059\u0012!B6bM.\f7\u0001A\n\u0003\u0001i\u0001\"a\u0007\u000f\u000e\u0003QI!!\b\u000b\u0003#E+xN];n)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002AA\u00111\u0004A\u0001\u0007KbLG/\u001a3\u0016\u0003\r\u0002\"\u0001J\u0017\u000e\u0003\u0015R!AJ\u0014\u0002\r\u0005$x.\\5d\u0015\tA\u0013&\u0001\u0006d_:\u001cWO\u001d:f]RT!AK\u0016\u0002\tU$\u0018\u000e\u001c\u0006\u0002Y\u0005!!.\u0019<b\u0013\tqSEA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\bKbLG/\u001a3!\u0003\u0015\u0019X\r^+q)\t\u0011\u0004\b\u0005\u00024m5\tAGC\u00016\u0003\u0015\u00198-\u00197b\u0013\t9DG\u0001\u0003V]&$\b\"B\u001d\u0005\u0001\u0004Q\u0014\u0001\u0003;fgRLeNZ8\u0011\u0005m\"U\"\u0001\u001f\u000b\u0005ur\u0014aA1qS*\u0011q\bQ\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\t%)A\u0003kk:LGOC\u0001D\u0003\ry'oZ\u0005\u0003\u000br\u0012\u0001\u0002V3ti&sgm\u001c\u0015\u0003\t\u001d\u0003\"a\u000f%\n\u0005%c$A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eF\u00013Q\t)Q\n\u0005\u0002<\u001d&\u0011q\n\u0010\u0002\n\u0003\u001a$XM]#bG\"\fA\u0002^3tiNCW\u000f\u001e3po:D#A\u0002*\u0011\u0005m\u001a\u0016B\u0001+=\u0005\u0011!Vm\u001d;\u0002OQ,7\u000f\u001e+x_\u000e{gn]3dkRLg/Z*ikR$wn\u001e8DC2dW\t_5u)^L7-\u001a\u0015\u0003\u000fI\u000b1\"\\3ue&\u001cg+\u00197vKR\u0011\u0011\f\u0018\t\u0003giK!a\u0017\u001b\u0003\t1{gn\u001a\u0005\u0006;\"\u0001\rAX\u0001\u0005]\u0006lW\r\u0005\u0002`M:\u0011\u0001\r\u001a\t\u0003CRj\u0011A\u0019\u0006\u0003Gb\ta\u0001\u0010:p_Rt\u0014BA35\u0003\u0019\u0001&/\u001a3fM&\u0011q\r\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0015$\u0014\u0001\u000b;fgR\fEN]3bIf\u0014VmZ5ti\u0016\u0014X\rZ!em\u0016\u0014H/[:fI2K7\u000f^3oKJ\u001c\bFA\u0005S\u0003%\"Xm\u001d;De\u0016\fG/Z:Qe>\u0004XM\u001d.l\u0007>tg-[4XQ\u0016t7+Y:m\t&\u001c\u0018M\u00197fI\"\u0012!BU\u0001)i\u0016\u001cHo\u0011:fCR,7\u000f\u0015:pa\u0016\u0014(l\u001b+mg\u000e{gNZ5h/\",g\u000eR5tC\ndW\r\u001a\u0015\u0003\u0017I\u000b!\u0006^3ti\u000e\u0013X-\u0019;fgB\u0013x\u000e]3s5.$Fn]\"p]\u001aLwmV5uQR\u0013X/\u001a,bYV,7\u000f\u000b\u0002\r%\u0006\u0011D/Z:u\u0007J,\u0017\r^3t!J|\u0007/\u001a:[WRc7oQ8oM&<w+\u001b;i\r\u0006d7/Z!oI2K7\u000f\u001e,bYV,7\u000f\u000b\u0002\u000e%\u0006\u0001B/Z:u5.L5O]'b]\u0006<WM\u001d\u0015\u0003\u001dI\u000b1\u0003^3ti\u0006cG/\u001a:JgJl\u0015M\\1hKJD#a\u0004*\u0002CQ,7\u000f\u001e*f[>$X\rT8h\u001b\u0006t\u0017mZ3s\u0013:\u001cH/\u00198uS\u0006$\u0018n\u001c8)\u0005A\u0011\u0006F\u0001\t{!\tY40\u0003\u0002}y\tAA)[:bE2,G-\u0001\u0007de\u0016\fG/Z*feZ,'\u000fF\u0004\u0000\u0003\u000b\ty!a\u0005\u0011\u0007m\t\t!C\u0002\u0002\u0004Q\u00111bS1gW\u0006\u001cVM\u001d<fe\"9\u0011qA\tA\u0002\u0005%\u0011A\u00028pI\u0016LE\rE\u00024\u0003\u0017I1!!\u00045\u0005\rIe\u000e\u001e\u0005\u0007\u0003#\t\u0002\u0019\u00010\u0002\u0011!|7\u000f\u001e(b[\u0016Dq!!\u0006\u0012\u0001\u0004\tI!\u0001\u0003q_J$\u0018!\u0006;fgRd\u0015NZ3ds\u000edWm\u00155vi\u0012|wO\u001c\u0015\u0003%I\u0003")
public class KafkaServerTest
extends QuorumTestHarness {
    private final AtomicBoolean exited = new AtomicBoolean(false);

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        KafkaServer$.MODULE$.externalShutdownInitiations().set(0L);
        Exit.setExitProcedure((x$1, x$2) -> {
            this.exited().set(true);
            throw new Exception();
        });
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        Exit.resetExitProcedure();
        KafkaServer$.MODULE$.externalShutdownInitiations().set(0L);
    }

    @Test
    public void testShutdown() {
        new KafkaServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false)), Time.SYSTEM, (Option)None$.MODULE$, false);
        Assertions.assertFalse((boolean)this.exited().get(), (String)"Exit produce should not have been executed yet");
        KafkaServer$.MODULE$.initiateShutdown().join();
        Assertions.assertTrue((boolean)this.exited().get(), (String)"Exit produce should have been executed");
        Assertions.assertEquals((long)1L, (long)KafkaServer$.MODULE$.externalShutdownInitiations().get());
        Assertions.assertEquals((long)1L, (long)this.metricValue("ExternalShutdownInitiations"));
    }

    @Test
    public void testTwoConsecutiveShutdownCallExitTwice() {
        new KafkaServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false)), Time.SYSTEM, (Option)None$.MODULE$, false);
        Assertions.assertFalse((boolean)this.exited().get(), (String)"Exit produce should not have been executed yet");
        Thread th1 = KafkaServer$.MODULE$.initiateShutdown();
        Thread th2 = KafkaServer$.MODULE$.initiateShutdown();
        th1.join();
        th2.join();
        Assertions.assertTrue((boolean)this.exited().get(), (String)"Exit produce should have been executed");
        Assertions.assertEquals((long)2L, (long)KafkaServer$.MODULE$.externalShutdownInitiations().get());
        Assertions.assertEquals((long)2L, (long)this.metricValue("ExternalShutdownInitiations"));
    }

    private long metricValue(String name) {
        return BoxesRunTime.unboxToLong((Object)((Gauge)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTest.$anonfun$metricValue$1(name, x$3)))).values().headOption().getOrElse((Function0 & Serializable)() -> {
            throw new Exception(new StringBuilder(22).append("Could not find metric ").append(name).toString());
        })).value());
    }

    @Test
    public void testAlreadyRegisteredAdvertisedListeners() {
        KafkaServer server1 = this.createServer(1, "myhost", TestUtils$.MODULE$.RandomPort());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.createServer(2, "myhost", TestUtils$.MODULE$.boundPort((KafkaBroker)server1, SecurityProtocol.PLAINTEXT)));
        KafkaServer server2 = this.createServer(2, "myhost", TestUtils$.MODULE$.RandomPort());
        TestUtils$.MODULE$.shutdownServers(new .colon.colon((Object)server1, (List)new .colon.colon((Object)server2, (List)Nil$.MODULE$)), true);
    }

    @Test
    public void testCreatesProperZkConfigWhenSaslDisabled() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), false);
        Assertions.assertEquals((Object)"false", (Object)zkClientConfig.getProperty("zookeeper.sasl.client"));
    }

    @Test
    public void testCreatesProperZkTlsConfigWhenDisabled() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        props.put(KafkaConfig$.MODULE$.ZkSslClientEnableProp(), "false");
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), false);
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)propName -> {
            KafkaServerTest.$anonfun$testCreatesProperZkTlsConfigWhenDisabled$1(zkClientConfig, propName);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreatesProperZkTlsConfigWithTrueValues() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        String someValue = "some_value";
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)kafkaProp -> props.put(kafkaProp, KafkaServerTest.kafkaConfigValueToSet$1(kafkaProp, someValue)));
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), false);
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)kafkaProp -> {
            KafkaServerTest.$anonfun$testCreatesProperZkTlsConfigWithTrueValues$2(zkClientConfig, someValue, kafkaProp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreatesProperZkTlsConfigWithFalseAndListValues() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        String someValue = "some_value";
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)kafkaProp -> props.put(kafkaProp, KafkaServerTest.kafkaConfigValueToSet$2(kafkaProp, someValue)));
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), false);
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)kafkaProp -> {
            KafkaServerTest.$anonfun$testCreatesProperZkTlsConfigWithFalseAndListValues$2(zkClientConfig, someValue, kafkaProp);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkIsrManager() {
        void createServer_createServer_createServer_startup;
        void createServer_time;
        void createServer_config;
        Properties props = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).head();
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "2.7-IV1");
        Time time = Time.SYSTEM;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        boolean bl = true;
        int createServer_createServer_createServer_licenseTopicReplicationFactor = 0;
        Object var6_5 = null;
        Object var3_4 = null;
        kafkaConfig = null;
        time = null;
        KafkaServer server = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_licenseTopicReplicationFactor, (boolean)createServer_createServer_createServer_startup, false);
        if (!(server.replicaManager().alterPartitionManager() instanceof ZkAlterPartitionManager)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Should use ZK for ISR manager in versions before 2.7-IV2");
        }
        server.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterIsrManager() {
        void createServer_createServer_createServer_startup;
        void createServer_time;
        void createServer_config;
        Properties props = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).head();
        MetadataVersion metadataVersion = MetadataVersion.latest();
        if (metadataVersion == null) {
            throw null;
        }
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), metadataVersion.version());
        Time time = Time.SYSTEM;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        boolean bl = true;
        int createServer_createServer_createServer_licenseTopicReplicationFactor = 0;
        Object var6_5 = null;
        Object var3_4 = null;
        kafkaConfig = null;
        time = null;
        KafkaServer server = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_licenseTopicReplicationFactor, (boolean)createServer_createServer_createServer_startup, false);
        if (!(server.replicaManager().alterPartitionManager() instanceof DefaultAlterPartitionManager)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Should use AlterIsr for ISR manager in versions after 2.7-IV2");
        }
        server.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Disabled
    @Test
    public void testRemoteLogManagerInstantiation() {
        void createServer_createServer_createServer_startup;
        void createServer_time;
        void createServer_config;
        Properties props = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).head();
        props.put("remote.log.storage.system.enable", Boolean.toString(true));
        props.put("remote.log.metadata.manager.class.name", "org.apache.kafka.server.log.remote.storage.NoOpRemoteLogMetadataManager");
        props.put("remote.log.storage.manager.class.name", "org.apache.kafka.server.log.remote.storage.NoOpRemoteStorageManager");
        Time time = Time.SYSTEM;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        boolean bl = true;
        int createServer_createServer_createServer_licenseTopicReplicationFactor = 0;
        Object var7_5 = null;
        Object var4_4 = null;
        kafkaConfig = null;
        time = null;
        KafkaServer server = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_licenseTopicReplicationFactor, (boolean)createServer_createServer_createServer_startup, false);
        Option option = server.remoteLogManager();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"RemoteLogManager should be initialized");
            } else {
                throw new MatchError((Object)option);
            }
        }
        server.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    public KafkaServer createServer(int nodeId, String hostName, int port) {
        void createServer_createServer_createServer_startup;
        void createServer_time;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(nodeId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.AdvertisedListenersProp(), new StringBuilder(13).append("PLAINTEXT://").append(hostName).append(":").append(port).toString());
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        Time time = Time.SYSTEM;
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        boolean bl = true;
        int createServer_createServer_createServer_licenseTopicReplicationFactor = 0;
        return createServer_this.createServer(kafkaConfig, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_licenseTopicReplicationFactor, (boolean)createServer_createServer_createServer_startup, false);
    }

    @Test
    public void testLifecycleShutdown() {
        KafkaServer server = this.createServer(1, "myhost", TestUtils$.MODULE$.RandomPort());
        Assertions.assertEquals((Object)BrokerState.RUNNING, (Object)server.brokerState());
        server.shutdown();
        Assertions.assertFalse((boolean)server.brokerState().isShutdownInitiated());
        server = this.createServer(2, "myhost", TestUtils$.MODULE$.RandomPort());
        server.beginShutdown(server.brokerEpoch());
        Assertions.assertTrue((boolean)server.brokerState().isShutdownInitiated());
        server.shutdown();
    }

    public static final /* synthetic */ boolean $anonfun$metricValue$1(String name$1, Tuple2 x$3) {
        String string = ((MetricName)x$3._1()).getName();
        return !(string != null ? !string.equals(name$1) : name$1 != null);
    }

    public static final /* synthetic */ void $anonfun$testCreatesProperZkTlsConfigWhenDisabled$1(ZKClientConfig zkClientConfig$1, String propName) {
        Assertions.assertNull((Object)zkClientConfig$1.getProperty(propName));
    }

    private static final String kafkaConfigValueToSet$1(String kafkaProp, String someValue$1) {
        boolean bl;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(kafkaProp) : kafkaProp != null)) {
            bl = true;
        } else {
            String string2 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
                bl = true;
            } else {
                String string3 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null);
            }
        }
        if (bl) {
            return "true";
        }
        String string4 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
        if (!(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null)) {
            return "HTTPS";
        }
        return someValue$1;
    }

    private static final String zkClientValueToExpect$1(String kafkaProp, String someValue$1) {
        boolean bl;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(kafkaProp) : kafkaProp != null)) {
            bl = true;
        } else {
            String string2 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
                bl = true;
            } else {
                String string3 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null);
            }
        }
        if (bl) {
            return "true";
        }
        String string4 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
        if (!(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null)) {
            return "true";
        }
        return someValue$1;
    }

    public static final /* synthetic */ void $anonfun$testCreatesProperZkTlsConfigWithTrueValues$2(ZKClientConfig zkClientConfig$2, String someValue$1, String kafkaProp) {
        Assertions.assertEquals((Object)KafkaServerTest.zkClientValueToExpect$1(kafkaProp, someValue$1), (Object)zkClientConfig$2.getProperty((String)KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().apply((Object)kafkaProp)));
    }

    private static final String kafkaConfigValueToSet$2(String kafkaProp, String someValue$2) {
        boolean bl;
        boolean bl2;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(kafkaProp) : kafkaProp != null)) {
            return "true";
        }
        String string2 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
        if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
            bl2 = true;
        } else {
            String string3 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
            bl2 = !(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null);
        }
        if (bl2) {
            return "false";
        }
        String string4 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
        if (!(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null)) {
            return "";
        }
        String string5 = KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp();
        if (!(string5 != null ? !string5.equals(kafkaProp) : kafkaProp != null)) {
            bl = true;
        } else {
            String string6 = KafkaConfig$.MODULE$.ZkSslCipherSuitesProp();
            bl = !(string6 != null ? !string6.equals(kafkaProp) : kafkaProp != null);
        }
        if (bl) {
            return "A,B";
        }
        return someValue$2;
    }

    private static final String zkClientValueToExpect$2(String kafkaProp, String someValue$2) {
        boolean bl;
        boolean bl2;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(kafkaProp) : kafkaProp != null)) {
            return "true";
        }
        String string2 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
        if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
            bl2 = true;
        } else {
            String string3 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
            bl2 = !(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null);
        }
        if (bl2) {
            return "false";
        }
        String string4 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
        if (!(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null)) {
            return "false";
        }
        String string5 = KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp();
        if (!(string5 != null ? !string5.equals(kafkaProp) : kafkaProp != null)) {
            bl = true;
        } else {
            String string6 = KafkaConfig$.MODULE$.ZkSslCipherSuitesProp();
            bl = !(string6 != null ? !string6.equals(kafkaProp) : kafkaProp != null);
        }
        if (bl) {
            return "A,B";
        }
        return someValue$2;
    }

    public static final /* synthetic */ void $anonfun$testCreatesProperZkTlsConfigWithFalseAndListValues$2(ZKClientConfig zkClientConfig$3, String someValue$2, String kafkaProp) {
        Assertions.assertEquals((Object)KafkaServerTest.zkClientValueToExpect$2(kafkaProp, someValue$2), (Object)zkClientConfig$3.getProperty((String)KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().apply((Object)kafkaProp)));
    }
}

