/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Meter;
import io.confluent.kafka.availability.ThreadCountersManager;
import io.confluent.kafka.availability.ThreadLocalCounters;
import io.confluent.telemetry.api.events.NoOpEventEmitter;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.network.RequestChannel;
import kafka.network.RequestChannel$;
import kafka.server.ApiRequestHandler;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRequestHandler;
import kafka.server.RequestLocal;
import kafka.server.RequestLogger;
import kafka.utils.Log4jController$;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestLogFilter;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogAction;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.server.audit.NoOpAuditLogProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\ra\u0001B\u0006\r\u0001EAQ\u0001\u0007\u0001\u0005\u0002eAq\u0001\b\u0001C\u0002\u0013\u0005Q\u0004\u0003\u0004,\u0001\u0001\u0006IA\b\u0005\u0006Y\u0001!\t!\f\u0005\u0006y\u0001!\t!\u0010\u0005\u0006+\u0002!IA\u0016\u0005\bI\u0002\t\n\u0011\"\u0003f\u0011\u001d\u0001\b!%A\u0005\n\u0015DQ!\u001d\u0001\u0005\nIDaa \u0001\u0005\n\u0005\u0005!aF&bM.\f'+Z9vKN$\b*\u00198eY\u0016\u0014H+Z:u\u0015\tia\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u001f\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0013!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u0007\t\u00037\u0001i\u0011\u0001D\u0001\u0005i&lW-F\u0001\u001f!\ty\u0012&D\u0001!\u0015\t\t#%A\u0003vi&d7O\u0003\u0002$I\u000511m\\7n_:T!aD\u0013\u000b\u0005\u0019:\u0013AB1qC\u000eDWMC\u0001)\u0003\ry'oZ\u0005\u0003U\u0001\u0012\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\u0012i\u0016\u001cH/\u00128hS:,W*\u001a;sS\u000e\u001cH#\u0001\u0018\u0011\u0005My\u0013B\u0001\u0019\u0015\u0005\u0011)f.\u001b;)\u0005\u0011\u0011\u0004CA\u001a;\u001b\u0005!$BA\u001b7\u0003\r\t\u0007/\u001b\u0006\u0003oa\nqA[;qSR,'O\u0003\u0002:O\u0005)!.\u001e8ji&\u00111\b\u000e\u0002\u0005)\u0016\u001cH/A\ruKN$H)\u001a4bk2$(+Z9vKN$Hj\\4hS:<GC\u0001\u0018?\u0011\u0015yT\u00011\u0001A\u0003%\u0019\bn\\;mI2{w\r\u0005\u0002\u0014\u0003&\u0011!\t\u0006\u0002\b\u0005>|G.Z1oQ\u0011)A\tT'\u0011\u0005\u0015SU\"\u0001$\u000b\u0005\u001dC\u0015\u0001\u00039s_ZLG-\u001a:\u000b\u0005%3\u0014A\u00029be\u0006l7/\u0003\u0002L\r\nYa+\u00197vKN{WO]2f\u0003!\u0011wn\u001c7fC:\u001cHF\u0001(P3\u0005\t\u0011$\u0001\u0001)\u0005\u0015\t\u0006C\u0001*T\u001b\u0005A\u0015B\u0001+I\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0015]\u0016<Xj\\2lK\u0012\\\u0015MZ6b\u0007>tg-[4\u0015\u0007]S&\r\u0005\u0002\u001c1&\u0011\u0011\f\u0004\u0002\f\u0017\u000647.Y\"p]\u001aLw\rC\u0004\\\rA\u0005\t\u0019\u0001/\u0002!I,\u0017/^3ti2{wMR5mi\u0016\u0014\bCA/a\u001b\u0005q&BA0#\u0003!\u0011X-];fgR\u001c\u0018BA1_\u0005A\u0011V-];fgRdun\u001a$jYR,'\u000fC\u0004d\rA\u0005\t\u0019\u0001/\u0002\u001d\u0005,H-\u001b;M_\u001e4\u0015\u000e\u001c;fe\u0006qb.Z<N_\u000e\\W\rZ&bM.\f7i\u001c8gS\u001e$C-\u001a4bk2$H%M\u000b\u0002M*\u0012AlZ\u0016\u0002QB\u0011\u0011N\\\u0007\u0002U*\u00111\u000e\\\u0001\nk:\u001c\u0007.Z2lK\u0012T!!\u001c\u000b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002pU\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002=9,w/T8dW\u0016$7*\u00194lC\u000e{gNZ5hI\u0011,g-Y;mi\u0012\u0012\u0014A\u0004:fG\u0016Lg/\u001a*fcV,7\u000f\u001e\u000b\u0003gv\u0004\"\u0001\u001e>\u000f\u0005UDX\"\u0001<\u000b\u0005]t\u0011a\u00028fi^|'o[\u0005\u0003sZ\faBU3rk\u0016\u001cHo\u00115b]:,G.\u0003\u0002|y\n9!+Z9vKN$(BA=w\u0011\u0015q\u0018\u00021\u0001X\u0003\u0019\u0019wN\u001c4jO\u0006\u0001\"-^5mIR+7\u000f\u001e*fcV,7\u000f\u001e\u000b\u0002g\u0002")
public class KafkaRequestHandlerTest {
    private final MockTime time = new MockTime();

    public MockTime time() {
        return this.time;
    }

    @Test
    public void testEngineMetrics() {
        ThreadCountersManager.threadCountersManagerEnabled = true;
        Thread thread = new Thread(() -> {
            ThreadCountersManager.LocalCounters.setThreadType((ThreadLocalCounters.ThreadGroupType)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
            this.receiveRequest(this.newMockedKafkaConfig(RequestLogFilter.MATCH_NONE, RequestLogFilter.MATCH_NONE));
        });
        thread.start();
        thread.join();
        Map threadLocalCountersForAllThreads = ThreadCountersManager.getThreadLocalCounterSnapshotForAllKnownThreads();
        Assertions.assertTrue((boolean)threadLocalCountersForAllThreads.containsKey(thread));
        ((List)threadLocalCountersForAllThreads.get(thread)).forEach(counter -> {
            block7: {
                block6: {
                    ThreadLocalCounters.MetricComponentType metricComponentType;
                    ThreadLocalCounters.MetricComponentType metricComponentType2;
                    block5: {
                        Assertions.assertEquals((Object)counter.threadGroupType, (Object)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
                        metricComponentType2 = counter.metricComponentType;
                        metricComponentType = ThreadLocalCounters.MetricComponentType.ENGINE;
                        if (metricComponentType2 != null) break block5;
                        if (metricComponentType != null) {
                            return;
                        }
                        break block6;
                    }
                    if (!metricComponentType2.equals(metricComponentType)) break block7;
                }
                Assertions.assertEquals((long)1L, (long)counter.numSuccessOps);
                return;
            }
        });
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDefaultRequestLogging(boolean shouldLog) {
        Log4jController$.MODULE$.logLevel(RequestChannel$.MODULE$.RequestLoggerName(), "INFO");
        this.assertRequestLogAction$1(shouldLog ? LogAction.LOGGED : LogAction.NOT_LOGGED, shouldLog);
        Log4jController$.MODULE$.logLevel(RequestChannel$.MODULE$.RequestLoggerName(), "DEBUG");
        this.assertRequestLogAction$1(LogAction.LOGGED, shouldLog);
    }

    private KafkaConfig newMockedKafkaConfig(RequestLogFilter requestLogFilter, RequestLogFilter auditLogFilter) {
        KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        Mockito.when((Object)config.newRequestLogFilter()).thenReturn((Object)requestLogFilter);
        Mockito.when((Object)config.newDetailedRequestAuditLogFilter()).thenReturn((Object)auditLogFilter);
        return config;
    }

    private RequestLogFilter newMockedKafkaConfig$default$1() {
        return RequestLogFilter.MATCH_NONE;
    }

    private RequestLogFilter newMockedKafkaConfig$default$2() {
        return RequestLogFilter.MATCH_NONE;
    }

    private RequestChannel.Request receiveRequest(KafkaConfig config) {
        Meter aggregateIdleMeter = (Meter)Mockito.mock(Meter.class);
        RequestChannel requestChannel = (RequestChannel)Mockito.mock(RequestChannel.class);
        ApiRequestHandler apiHandler = (ApiRequestHandler)Mockito.mock(ApiRequestHandler.class);
        KafkaRequestHandler handler = new KafkaRequestHandler(0, config, "cluster", 0, aggregateIdleMeter, new AtomicInteger(1), requestChannel, apiHandler, (Time)this.time());
        RequestChannel.Request request = this.buildTestRequest();
        Mockito.when((Object)requestChannel.receiveRequest(0L)).thenReturn((Object)request);
        apiHandler.handle((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (RequestLogger)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> {
            KafkaRequestHandlerTest.$anonfun$receiveRequest$1(invocation);
            return BoxedUnit.UNIT;
        });
        handler.poll(0);
        ((ApiRequestHandler)Mockito.verify((Object)apiHandler)).handle((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (RequestLogger)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        return request;
    }

    private RequestChannel.Request buildTestRequest() {
        RequestHeader requestHeader = new RequestHeader(ApiKeys.METADATA, ApiKeys.METADATA.latestVersion(), "clientId", 1379);
        RequestContext requestContext = new RequestContext(requestHeader, "connectionId", InetAddress.getLoopbackAddress(), KafkaPrincipal.ANONYMOUS, new ListenerName("PLAINTEXT"), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, null, false);
        ByteBuffer buffer = ((MetadataRequest)MetadataRequest.Builder.allTopics((boolean)false).build()).serialize();
        RequestChannel.Metrics requestMetrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
        return new RequestChannel.Request(0, requestContext, this.time().nanoseconds(), MemoryPool.NONE, buffer, requestMetrics, (Option)None$.MODULE$, NoOpEventEmitter.INSTANCE, (AuditLogProvider)NoOpAuditLogProvider.INSTANCE, RequestLogFilter.MATCH_NONE, 0L);
    }

    private final void assertRequestLogAction$1(LogAction expectedLogAction, boolean shouldLog$1) {
        RequestLogFilter requestLogFilter = shouldLog$1 ? RequestLogFilter.MATCH_ALL : RequestLogFilter.MATCH_NONE;
        KafkaConfig config = this.newMockedKafkaConfig(requestLogFilter, RequestLogFilter.MATCH_NONE);
        RequestChannel.Request request = this.receiveRequest(config);
        Assertions.assertEquals((Object)expectedLogAction, (Object)request.logAction());
    }

    public static final /* synthetic */ void $anonfun$receiveRequest$1(InvocationOnMock invocation) {
        RequestChannel.Request req = (RequestChannel.Request)invocation.getArgument(0);
        ((RequestLogger)invocation.getArgument(1)).maybeSetRequestLogAction(req);
    }
}

