/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.admin.BrokerMetadata;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.ActionQueue;
import kafka.server.AlterPartitionManager;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.TierReplicaComponents;
import kafka.server.TierReplicaComponents$;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.utils.MockTime;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.verification.VerificationMode;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005%h\u0001B\u0015+\u0001=BQA\u000e\u0001\u0005\u0002]BqA\u000f\u0001C\u0002\u0013\u00051\b\u0003\u0004@\u0001\u0001\u0006I\u0001\u0010\u0005\b\u0001\u0002\u0011\r\u0011\"\u0001B\u0011\u0019)\u0005\u0001)A\u0005\u0005\"9a\t\u0001b\u0001\n\u0003Y\u0004BB$\u0001A\u0003%A\bC\u0004I\u0001\u0001\u0007I\u0011A\u001e\t\u000f%\u0003\u0001\u0019!C\u0001\u0015\"1\u0001\u000b\u0001Q!\nqBq!\u0015\u0001C\u0002\u0013\u00051\b\u0003\u0004S\u0001\u0001\u0006I\u0001\u0010\u0005\b'\u0002\u0011\r\u0011\"\u0001U\u0011\u0019i\u0006\u0001)A\u0005+\"9a\f\u0001b\u0001\n\u0003y\u0006BB5\u0001A\u0003%\u0001\rC\u0004k\u0001\t\u0007I\u0011A6\t\rI\u0004\u0001\u0015!\u0003m\u0011\u001d\u0019\bA1A\u0005\u0002QDaa\u001f\u0001!\u0002\u0013)\bb\u0002?\u0001\u0005\u0004%\t! \u0005\b\u0003+\u0001\u0001\u0015!\u0003\u007f\u0011-\t9\u0002\u0001a\u0001\u0002\u0004%\t!!\u0007\t\u0017\u0005]\u0002\u00011AA\u0002\u0013\u0005\u0011\u0011\b\u0005\f\u0003{\u0001\u0001\u0019!A!B\u0013\tY\u0002C\u0006\u0002@\u0001\u0001\r\u00111A\u0005\u0002\u0005\u0005\u0003bCA%\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0017B1\"a\u0014\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002D!Y\u0011\u0011\u000b\u0001A\u0002\u0003\u0007I\u0011AA*\u0011-\t9\u0007\u0001a\u0001\u0002\u0004%\t!!\u001b\t\u0017\u00055\u0004\u00011A\u0001B\u0003&\u0011Q\u000b\u0005\b\u0003_\u0002A\u0011AA9\u0011\u001d\tI\t\u0001C\u0001\u0003cBq!a%\u0001\t\u0003\t\t\bC\u0004\u0002\u001e\u0002!\t!!\u001d\t\u000f\u0005\u0005\u0006\u0001\"\u0001\u0002r!9\u0011Q\u0015\u0001\u0005\u0002\u0005E\u0004bBAU\u0001\u0011\u0005\u0011\u0011\u000f\u0005\b\u0003[\u0003A\u0011BAX\u0011\u001d\t)\u000f\u0001C\u0005\u0003O\u0014\u0011#S:s\u000bb\u0004\u0018N]1uS>tG+Z:u\u0015\tYC&\u0001\u0004tKJ4XM\u001d\u0006\u0002[\u0005)1.\u00194lC\u000e\u00011C\u0001\u00011!\t\tD'D\u00013\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b3\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\u000f\t\u0003s\u0001i\u0011AK\u0001\u0014%\u0016\u0004H.[2b\u0019\u0006<G+[7f\u001b\u0006DXj]\u000b\u0002yA\u0011\u0011'P\u0005\u0003}I\u0012A\u0001T8oO\u0006!\"+\u001a9mS\u000e\fG*Y4US6,W*\u0019=Ng\u0002\nQCU3qY&\u001c\u0017MR3uG\"<\u0016-\u001b;NCbl5/F\u0001C!\t\t4)\u0003\u0002Ee\t\u0019\u0011J\u001c;\u0002-I+\u0007\u000f\\5dC\u001a+Go\u00195XC&$X*\u0019=Ng\u0002\nA\u0003T3bI\u0016\u0014Hj\\4Ti\u0006\u0014Ho\u00144gg\u0016$\u0018!\u0006'fC\u0012,'\u000fT8h'R\f'\u000f^(gMN,G\u000fI\u0001\u0013\u0019\u0016\fG-\u001a:M_\u001e,e\u000eZ(gMN,G/\u0001\fMK\u0006$WM\u001d'pO\u0016sGm\u00144gg\u0016$x\fJ3r)\tYe\n\u0005\u00022\u0019&\u0011QJ\r\u0002\u0005+:LG\u000fC\u0004P\u0013\u0005\u0005\t\u0019\u0001\u001f\u0002\u0007a$\u0013'A\nMK\u0006$WM\u001d'pO\u0016sGm\u00144gg\u0016$\b%\u0001\fMK\u0006$WM\u001d'pO\"Kw\r[,bi\u0016\u0014X.\u0019:l\u0003]aU-\u00193fe2{w\rS5hQ^\u000bG/\u001a:nCJ\\\u0007%A\bpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9t+\u0005)\u0006C\u0001,\\\u001b\u00059&B\u0001-Z\u0003\u0011)H/\u001b7\u000b\u0003i\u000bAA[1wC&\u0011Al\u0016\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018\u0001E8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:!\u0003\u001d\u0019wN\u001c4jON,\u0012\u0001\u0019\t\u0004C\u00124W\"\u00012\u000b\u0005\r\u0014\u0014AC2pY2,7\r^5p]&\u0011QM\u0019\u0002\u0004'\u0016\f\bCA\u001dh\u0013\tA'FA\u0006LC\u001a\\\u0017mQ8oM&<\u0017\u0001C2p]\u001aLwm\u001d\u0011\u0002\u000bQ|\u0007/[2\u0016\u00031\u0004\"!\u001c9\u000e\u00039T!a\\-\u0002\t1\fgnZ\u0005\u0003c:\u0014aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%\u0001\u0003uS6,W#A;\u0011\u0005YLX\"A<\u000b\u0005ad\u0013!B;uS2\u001c\u0018B\u0001>x\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013aB7fiJL7m]\u000b\u0002}B\u0019q0!\u0005\u000e\u0005\u0005\u0005!b\u0001?\u0002\u0004)!\u0011QAA\u0004\u0003\u0019\u0019w.\\7p]*\u0019Q&!\u0003\u000b\t\u0005-\u0011QB\u0001\u0007CB\f7\r[3\u000b\u0005\u0005=\u0011aA8sO&!\u00111CA\u0001\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\rcV|G/Y'b]\u0006<WM]\u000b\u0003\u00037\u0001B!!\b\u000229!\u0011qDA\u0017\u001d\u0011\t\t#a\u000b\u000f\t\u0005\r\u0012\u0011F\u0007\u0003\u0003KQ1!a\n/\u0003\u0019a$o\\8u}%\tQ&\u0003\u0002,Y%\u0019\u0011q\u0006\u0016\u0002\u0019E+x\u000e^1GC\u000e$xN]=\n\t\u0005M\u0012Q\u0007\u0002\u000e#V|G/Y'b]\u0006<WM]:\u000b\u0007\u0005=\"&\u0001\trk>$\u0018-T1oC\u001e,'o\u0018\u0013fcR\u00191*a\u000f\t\u0011=C\u0012\u0011!a\u0001\u00037\tQ\"];pi\u0006l\u0015M\\1hKJ\u0004\u0013A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0003\u0003\u0007\u00022!OA#\u0013\r\t9E\u000b\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003I\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ|F%Z9\u0015\u0007-\u000bi\u0005\u0003\u0005P7\u0005\u0005\t\u0019AA\"\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0013aD1mi\u0016\u0014\u0018j\u001d:NC:\fw-\u001a:\u0016\u0005\u0005U\u0003\u0003BA,\u0003CrA!!\u0017\u0002^9!\u0011\u0011EA.\u0013\tAH&C\u0002\u0002`]\f\u0011\u0002V3tiV#\u0018\u000e\\:\n\t\u0005\r\u0014Q\r\u0002\u001a\u001b>\u001c7.\u00117uKJ\u0004\u0016M\u001d;ji&|g.T1oC\u001e,'OC\u0002\u0002`]\f1#\u00197uKJL5O]'b]\u0006<WM]0%KF$2aSA6\u0011!ye$!AA\u0002\u0005U\u0013\u0001E1mi\u0016\u0014\u0018j\u001d:NC:\fw-\u001a:!\u0003\u0015\u0019X\r^+q)\u0005Y\u0005f\u0001\u0011\u0002vA!\u0011qOAC\u001b\t\tIH\u0003\u0003\u0002|\u0005u\u0014aA1qS*!\u0011qPAA\u0003\u001dQW\u000f]5uKJTA!a!\u0002\u000e\u0005)!.\u001e8ji&!\u0011qQA=\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u001a\u0011%!$\u0011\t\u0005]\u0014qR\u0005\u0005\u0003#\u000bIHA\u0005BMR,'/R1dQ\u0006\u0011C/Z:u\u0013N\u0014X\t\u001f9je\u0006$\u0018n\u001c8G_J\u001cF/^2l\r>dGn\\<feND3AIAL!\u0011\t9(!'\n\t\u0005m\u0015\u0011\u0010\u0002\u0005)\u0016\u001cH/A\u0013uKN$\u0018j\u001d:FqBL'/\u0019;j_:LeMT8GKR\u001c\u0007NU3rk\u0016\u001cH/T1eK\"\u001a1%a&\u0002CQ,7\u000f^%te\u0016C\b/\u001b:bi&|gNR8s'2|wOR8mY><XM]:)\u0007\u0011\n9*A\u0013uKN$\u0018j\u001d:FqBL'/\u0019;j_:4uN]\"bk\u001eDG/\u00169G_2dwn^3sg\"\u001aQ%a&\u0002wQ,7\u000f^%te\u0016C\b/\u001b:bi&|gNR8s\u0007\u0006,x\r\u001b;Va\u001a{G\u000e\\8xKJ\u001cx\u000b[3o\u0019\u0016\fG-\u001a:BaB,g\u000eZ:U_2{w\rK\u0002'\u0003/\u000b\u0001eZ3u!\u0006\u0014H/\u001b;j_:<\u0016\u000e\u001e5BY2\u0014V\r\u001d7jG\u0006\u001c\u0018J\\%teRQ\u0011\u0011WA_\u0003\u001b\f\t.!6\u0011\t\u0005M\u0016\u0011X\u0007\u0003\u0003kS1!a.-\u0003\u001d\u0019G.^:uKJLA!a/\u00026\nI\u0001+\u0019:uSRLwN\u001c\u0005\u0007U\u001e\u0002\r!a0\u0011\t\u0005\u0005\u0017\u0011\u001a\b\u0005\u0003\u0007\f)\rE\u0002\u0002$IJ1!a23\u0003\u0019\u0001&/\u001a3fM&\u0019\u0011/a3\u000b\u0007\u0005\u001d'\u0007\u0003\u0004\u0002P\u001e\u0002\rAQ\u0001\fa\u0006\u0014H/\u001b;j_:LE\r\u0003\u0004\u0002T\u001e\u0002\rAZ\u0001\u0007G>tg-[4\t\u000f\u0005]w\u00051\u0001\u0002Z\u0006AAn\\2bY2{w\r\u0005\u0003\u0002\\\u0006\u0005XBAAo\u0015\r\ty\u000eL\u0001\u0004Y><\u0017\u0002BAr\u0003;\u00141\"\u00112tiJ\f7\r\u001e'pO\u00069An\\4N_\u000e\\WCAAm\u0001")
public class IsrExpirationTest {
    private final long ReplicaLagTimeMaxMs;
    private final int ReplicaFetchWaitMaxMs;
    private final long LeaderLogStartOffset;
    private long LeaderLogEndOffset = 20L;
    private final long LeaderLogHighWatermark;
    private final Properties overridingProps = new Properties();
    private final Seq<KafkaConfig> configs;
    private final String topic;
    private final MockTime time;
    private final Metrics metrics;
    private QuotaFactory.QuotaManagers quotaManager;
    private ReplicaManager replicaManager;
    private TestUtils.MockAlterPartitionManager alterIsrManager;

    public long ReplicaLagTimeMaxMs() {
        return this.ReplicaLagTimeMaxMs;
    }

    public int ReplicaFetchWaitMaxMs() {
        return this.ReplicaFetchWaitMaxMs;
    }

    public long LeaderLogStartOffset() {
        return this.LeaderLogStartOffset;
    }

    public long LeaderLogEndOffset() {
        return this.LeaderLogEndOffset;
    }

    public void LeaderLogEndOffset_$eq(long x$1) {
        this.LeaderLogEndOffset = x$1;
    }

    public long LeaderLogHighWatermark() {
        return this.LeaderLogHighWatermark;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public String topic() {
        return this.topic;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public QuotaFactory.QuotaManagers quotaManager() {
        return this.quotaManager;
    }

    public void quotaManager_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManager = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public TestUtils.MockAlterPartitionManager alterIsrManager() {
        return this.alterIsrManager;
    }

    public void alterIsrManager_$eq(TestUtils.MockAlterPartitionManager x$1) {
        this.alterIsrManager = x$1;
    }

    @BeforeEach
    public void setUp() {
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)logManager.liveLogDirs()).thenReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class))));
        MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        Seq aliveBrokers = (Seq)this.configs().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.brokerId()));
        Mockito.when((Object)metadataCache.getAliveBrokers()).thenReturn(aliveBrokers.map((Function1 & Serializable)id -> IsrExpirationTest.$anonfun$setUp$2(BoxesRunTime.unboxToInt((Object)id))));
        Mockito.when((Object)metadataCache.getBrokerTags(BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()))).thenReturn((Object)Predef$.MODULE$.Map().empty());
        aliveBrokers.foreach((Function1 & Serializable)id -> IsrExpirationTest.$anonfun$setUp$3(metadataCache, BoxesRunTime.unboxToInt((Object)id)));
        this.alterIsrManager_$eq(new TestUtils.MockAlterPartitionManager());
        this.quotaManager_$eq(QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), "", (Option)None$.MODULE$));
        Metrics x$1 = this.metrics();
        KafkaConfig x$2 = (KafkaConfig)this.configs().head();
        MockTime x$3 = this.time();
        QuotaFactory.QuotaManagers x$6 = this.quotaManager();
        LogDirFailureChannel x$8 = new LogDirFailureChannel(((KafkaConfig)this.configs().head()).logDirs().size());
        TestUtils.MockAlterPartitionManager x$9 = this.alterIsrManager();
        ActionQueue x$10 = new ActionQueue();
        BrokerTopicStats x$11 = new BrokerTopicStats();
        Function0 x$12 = ReplicaManager$.MODULE$.$lessinit$greater$default$12();
        None$ x$13 = None$.MODULE$;
        None$ x$14 = None$.MODULE$;
        None$ x$15 = None$.MODULE$;
        None$ x$16 = None$.MODULE$;
        None$ x$17 = None$.MODULE$;
        None$ x$18 = None$.MODULE$;
        TierReplicaComponents x$19 = TierReplicaComponents$.MODULE$.EMPTY();
        None$ x$20 = None$.MODULE$;
        None$ x$21 = None$.MODULE$;
        None$ x$22 = None$.MODULE$;
        Function0 x$23 = ReplicaManager$.MODULE$.$lessinit$greater$default$23();
        this.replicaManager_$eq(new ReplicaManager(x$2, x$1, (Time)x$3, null, logManager, x$6, metadataCache, x$8, (AlterPartitionManager)x$9, x$10, x$11, x$12, (Option)x$13, (Option)x$14, (Option)x$15, (Option)x$16, (Option)x$17, (Option)x$18, x$19, (Option)x$20, (Option)x$21, (Option)x$22, x$23));
    }

    @AfterEach
    public void tearDown() {
        Option$.MODULE$.apply((Object)this.replicaManager()).foreach((Function1 & Serializable)x$6 -> {
            x$6.shutdown(false);
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply((Object)this.quotaManager()).foreach((Function1 & Serializable)x$7 -> {
            x$7.shutdown();
            return BoxedUnit.UNIT;
        });
        this.metrics().close();
    }

    @Test
    public void testIsrExpirationForStuckFollowers() {
        AbstractLog log = this.logMock();
        Partition partition = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (KafkaConfig)this.configs().head(), log);
        Assertions.assertEquals((Object)((IterableOnceOps)this.configs().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.brokerId()))).toSet(), (Object)partition.inSyncReplicaIds(), (String)"All replicas should be in ISR");
        partition.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.updateFetchState(new LogOffsetMetadata(this.LeaderLogEndOffset() - 1L), 0L, this.time().milliseconds(), this.LeaderLogEndOffset(), 1L);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"No replica should be out of sync");
        this.time().sleep(this.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"Replica 1 should be out of sync");
        ((AbstractLog)Mockito.verify((Object)log, (VerificationMode)Mockito.atLeastOnce())).logEndOffset();
    }

    @Test
    public void testIsrExpirationIfNoFetchRequestMade() {
        AbstractLog log = this.logMock();
        Partition partition = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (KafkaConfig)this.configs().head(), log);
        Assertions.assertEquals((Object)((IterableOnceOps)this.configs().map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.brokerId()))).toSet(), (Object)partition.inSyncReplicaIds(), (String)"All replicas should be in ISR");
        this.time().sleep(this.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"Replica 1 should be out of sync");
        ((AbstractLog)Mockito.verify((Object)log, (VerificationMode)Mockito.atLeastOnce())).logEndOffset();
    }

    @Test
    public void testIsrExpirationForSlowFollowers() {
        AbstractLog log = this.logMock();
        Partition partition = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (KafkaConfig)this.configs().head(), log);
        Assertions.assertEquals((Object)((IterableOnceOps)this.configs().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.brokerId()))).toSet(), (Object)partition.inSyncReplicaIds(), (String)"All replicas should be in ISR");
        partition.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.updateFetchState(new LogOffsetMetadata(this.LeaderLogEndOffset() - 2L), 0L, this.time().milliseconds(), this.LeaderLogEndOffset(), 1L);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"No replica should be out of sync");
        this.time().sleep(75L);
        partition.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.updateFetchState(new LogOffsetMetadata(this.LeaderLogEndOffset() - 1L), 0L, this.time().milliseconds(), this.LeaderLogEndOffset(), 1L);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"No replica should be out of sync");
        this.time().sleep(75L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"Replica 1 should be out of sync");
        partition.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.updateFetchState(new LogOffsetMetadata(this.LeaderLogEndOffset()), 0L, this.time().milliseconds(), this.LeaderLogEndOffset(), 1L);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"No replica should be out of sync");
        ((AbstractLog)Mockito.verify((Object)log, (VerificationMode)Mockito.atLeastOnce())).logEndOffset();
    }

    @Test
    public void testIsrExpirationForCaughtUpFollowers() {
        AbstractLog log = this.logMock();
        Partition partition = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (KafkaConfig)this.configs().head(), log);
        Assertions.assertEquals((Object)((IterableOnceOps)this.configs().map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.brokerId()))).toSet(), (Object)partition.inSyncReplicaIds(), (String)"All replicas should be in ISR");
        partition.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.updateFetchState(new LogOffsetMetadata(this.LeaderLogEndOffset()), 0L, this.time().milliseconds(), this.LeaderLogEndOffset(), 1L);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"No replica should be out of sync");
        this.time().sleep(this.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"No replica should be out of sync");
        ((AbstractLog)Mockito.verify((Object)log, (VerificationMode)Mockito.atLeastOnce())).logEndOffset();
    }

    @Test
    public void testIsrExpirationForCaughtUpFollowersWhenLeaderAppendsToLog() {
        AbstractLog log = this.logMock();
        Partition partition = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (KafkaConfig)this.configs().head(), log);
        Assertions.assertEquals((Object)((IterableOnceOps)this.configs().map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.brokerId()))).toSet(), (Object)partition.inSyncReplicaIds(), (String)"All replicas should be in ISR");
        partition.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.updateFetchState(new LogOffsetMetadata(this.LeaderLogEndOffset()), 0L, this.time().milliseconds(), this.LeaderLogEndOffset(), 1L);
            return BoxedUnit.UNIT;
        });
        this.time().sleep(this.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"No replica should be out of sync");
        this.LeaderLogEndOffset_$eq(this.LeaderLogEndOffset() + 1L);
        partition.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.maybeResetLastCaughtUpTime(this.time().milliseconds(), this.LeaderLogEndOffset());
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"No replica should be out of sync");
        this.time().sleep(this.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"Replica 1 should be out of sync");
        ((AbstractLog)Mockito.verify((Object)log, (VerificationMode)Mockito.atLeastOnce())).logEndOffset();
    }

    private Partition getPartitionWithAllReplicasInIsr(String topic, int partitionId, KafkaConfig config, AbstractLog localLog) {
        int leaderId = config.brokerId();
        TopicPartition tp = new TopicPartition(topic, partitionId);
        Partition partition = this.replicaManager().createPartition(tp);
        partition.setLog(localLog, false);
        OffsetCheckpoints highWatermarkCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
        partition.makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setPartitionIndex(partitionId).setLeader(leaderId).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)((IterableOps)this.configs().map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.brokerId()))).map((Function1 & Serializable)x -> IsrExpirationTest.$anonfun$getPartitionWithAllReplicasInIsr$2(BoxesRunTime.unboxToInt((Object)x)))).toList()).asJava()).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)((IterableOps)this.configs().map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.brokerId()))).map((Function1 & Serializable)x -> IsrExpirationTest.$anonfun$getPartitionWithAllReplicasInIsr$4(BoxesRunTime.unboxToInt((Object)x)))).toList()).asJava()), highWatermarkCheckpoints, (Option)None$.MODULE$);
        partition.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.updateFetchState(new LogOffsetMetadata(0L), 0L, this.time().milliseconds(), 0L, 1L);
            return BoxedUnit.UNIT;
        });
        partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)leaderId)));
        return partition;
    }

    private AbstractLog logMock() {
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        LogConfig logConfig = new LogConfig((java.util.Map)new Properties());
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenAnswer(x$15 -> BoxesRunTime.boxToLong((long)this.LeaderLogEndOffset()));
        Mockito.when((Object)log.maybeIncrementHighWatermark((LogOffsetMetadata)ArgumentMatchers.any())).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)this.LeaderLogStartOffset()));
        Mockito.when((Object)log.logEndOffsetMetadata()).thenAnswer(x$16 -> new LogOffsetMetadata(this.LeaderLogEndOffset()));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)this.LeaderLogHighWatermark()));
        Mockito.when((Object)log.config()).thenReturn((Object)logConfig);
        Mockito.when((Object)log.topicId()).thenReturn((Object)None$.MODULE$);
        return log;
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$setUp$2(int id) {
        return new BrokerMetadata(id, (Option)None$.MODULE$, (Map)Map$.MODULE$.empty());
    }

    public static final /* synthetic */ OngoingStubbing $anonfun$setUp$3(MetadataCache metadataCache$1, int id) {
        return Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)metadataCache$1.hasAliveBroker(id))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public static final /* synthetic */ Integer $anonfun$getPartitionWithAllReplicasInIsr$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$getPartitionWithAllReplicasInIsr$4(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public IsrExpirationTest() {
        this.ReplicaLagTimeMaxMs = 100L;
        this.ReplicaFetchWaitMaxMs = 100;
        this.LeaderLogStartOffset = 0L;
        this.LeaderLogHighWatermark = 20L;
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), Long.toString(this.ReplicaLagTimeMaxMs()));
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), Integer.toString(this.ReplicaFetchWaitMaxMs()));
        this.configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
        this.topic = "foo";
        this.time = new MockTime();
        this.metrics = new Metrics();
    }
}

