/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.kafka.http.server.KafkaHttpServer;
import io.confluent.kafka.security.auth.plain.DynamicPlainCredential;
import io.confluent.kafka.security.auth.plain.DynamicPlainLoginCallbackHandler;
import io.confluent.kafka.security.auth.plain.DynamicPlainLoginModule;
import io.confluent.kafka.security.auth.plain.FileBasedDynamicPlainLoginCallbackHandler;
import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import kafka.admin.BrokerMetadata;
import kafka.controller.KafkaController;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.log.LogManager;
import kafka.log.SegmentDeletionThrottlerConfig;
import kafka.log.SegmentDeletionThrottlerConfig$;
import kafka.network.DataPlaneAcceptor;
import kafka.network.SocketServer;
import kafka.network.SocketServer$;
import kafka.server.ApiVersionManager;
import kafka.server.BrokerDynamicThreadPool;
import kafka.server.BrokerReconfigurable;
import kafka.server.ControllerServer;
import kafka.server.Defaults$;
import kafka.server.DynamicBalancerConfig;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicBrokerConfigTest;
import kafka.server.DynamicDurabilityAuditConfig;
import kafka.server.DynamicListenerConfig;
import kafka.server.DynamicLogConfig;
import kafka.server.DynamicLoginContext;
import kafka.server.DynamicLoginManager;
import kafka.server.DynamicMetricsReporters;
import kafka.server.DynamicTransactionCoordinator;
import kafka.server.DynamicZkControllerConfig;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRequestHandlerPool;
import kafka.server.KafkaServer;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.TestDynamicThreadPool;
import kafka.server.TestQuotaCallback;
import kafka.server.ZkAdminManager;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclState;
import org.apache.kafka.common.acl.AclUpdateListener;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.LoginManager;
import org.apache.kafka.common.security.plain.PlainLoginModule;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.test.MockMetricsReporter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0011\u0005a\u0001\u0002*T\u0001aCQa\u0018\u0001\u0005\u0002\u0001DQa\u0019\u0001\u0005\u0002\u0011DQ!\u001e\u0001\u0005\u0002\u0011DQA\u001f\u0001\u0005\u0002\u0011DQ\u0001 \u0001\u0005\u0002\u0011DQA \u0001\u0005\u0002\u0011Da!!\u0001\u0001\t\u0003!\u0007BBA\u0003\u0001\u0011\u0005A\r\u0003\u0004\u0002\n\u0001!\t\u0001\u001a\u0005\u0007\u0003\u001b\u0001A\u0011\u00013\t\r\u0005E\u0001\u0001\"\u0001e\u0011\u0019\t)\u0002\u0001C\u0001I\"1\u0011\u0011\u0004\u0001\u0005\u0002\u0011Da!!\b\u0001\t\u0003!\u0007BBA\u0011\u0001\u0011\u0005A\r\u0003\u0004\u0002&\u0001!\t\u0001\u001a\u0005\u0007\u0003S\u0001A\u0011\u00013\t\r\u00055\u0002\u0001\"\u0001e\u0011\u0019\t\t\u0004\u0001C\u0001I\"1\u0011Q\u0007\u0001\u0005\u0002\u0011Da!!\u000f\u0001\t\u0003!\u0007BBA\u001f\u0001\u0011\u0005A\r\u0003\u0004\u0002B\u0001!\t\u0001\u001a\u0005\u0007\u0003\u000b\u0002A\u0011\u00013\t\r\u0005%\u0003\u0001\"\u0001e\u0011\u0019\ti\u0005\u0001C\u0001I\"1\u0011\u0011\u000b\u0001\u0005\u0002\u0011Da!!\u0016\u0001\t\u0003!\u0007BBA-\u0001\u0011\u0005A\r\u0003\u0004\u0002^\u0001!\t\u0001\u001a\u0005\u0007\u0003C\u0002A\u0011\u00013\t\r\u0005\u0015\u0004\u0001\"\u0001e\u0011\u001d\tI\u0007\u0001C\u0005\u0003WBq!!+\u0001\t\u0013\tY\u000b\u0003\u0004\u0002\\\u0002!\t\u0001\u001a\u0005\u0007\u0003?\u0004A\u0011\u00013\t\r\u0005\r\b\u0001\"\u0001e\r\u0019\t9\u000f\u0001\u0001\u0002j\"1qL\nC\u0001\u0005\u0017A\u0011B!\u0005'\u0001\u0004%\tAa\u0005\t\u0013\tea\u00051A\u0005\u0002\tm\u0001\u0002\u0003B\u0011M\u0001\u0006KA!\u0006\t\u000f\t-b\u0005\"\u0011\u0003.!9!q\r\u0014\u0005B\t%\u0004b\u0002BGM\u0011\u0005#q\u0012\u0005\b\u0005s3C\u0011\tB^\u0011\u001d\u0011yN\nC!\u0005CDaA!<'\t\u0003\"\u0007b\u0002BxM\u0011\u0005#\u0011\u001f\u0005\b\u0007\u00131C\u0011IB\u0006\u0011\u001d\u0019\u0019B\nC!\u0007+Aqaa\t'\t\u0003\u001a)\u0003\u0003\u0004\u00044\u0001!\t\u0001\u001a\u0005\b\u0007o\u0001A\u0011BB\u001d\u0011\u0019\u0019I\u0005\u0001C\u0001I\"11Q\n\u0001\u0005\u0002\u0011Dqa!\u0015\u0001\t\u0013\u0019\u0019\u0006\u0003\u0004\u0004Z\u0001!\t\u0001\u001a\u0005\u0007\u0007;\u0002A\u0011\u00013\t\r\r\u0005\u0004\u0001\"\u0001e\u0011\u0019\u0019)\u0007\u0001C\u0001I\"11\u0011\u000e\u0001\u0005\u0002\u0011Daa!\u001c\u0001\t\u0003!\u0007BBB9\u0001\u0011\u0005A\r\u0003\u0004\u0004v\u0001!\t\u0001\u001a\u0005\u0007\u0007s\u0002A\u0011\u00013\t\r\ru\u0004\u0001\"\u0001e\u0011\u0019\u0019\t\t\u0001C\u0001I\"11Q\u0011\u0001\u0005\u0002\u0011Daa!#\u0001\t\u0003!\u0007BBBG\u0001\u0011\u0005A\r\u0003\u0004\u0004\u0012\u0002!\t\u0001\u001a\u0005\b\u0007+\u0003A\u0011BBL\u0011\u0019\u0019\t\u000b\u0001C\u0001I\"91Q\u0015\u0001\u0005\n\r\u001d\u0006\"CB[\u0001E\u0005I\u0011BB\\\u0011\u001d\u0019i\r\u0001C\u0005\u0007\u001fDqa!9\u0001\t\u0013\u0019\u0019\u000f\u0003\u0004\u0004x\u0002!\t\u0001\u001a\u0005\u0007\u0007s\u0004A\u0011\u00013\t\r\ru\b\u0001\"\u0001e\u0005]!\u0015P\\1nS\u000e\u0014%o\\6fe\u000e{gNZ5h)\u0016\u001cHO\u0003\u0002U+\u000611/\u001a:wKJT\u0011AV\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\f\u0005\u0002[;6\t1LC\u0001]\u0003\u0015\u00198-\u00197b\u0013\tq6L\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\u0004\"A\u0019\u0001\u000e\u0003M\u000b\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002KB\u0011!LZ\u0005\u0003On\u0013A!\u00168ji\"\u0012!!\u001b\t\u0003UNl\u0011a\u001b\u0006\u0003Y6\f1!\u00199j\u0015\tqw.A\u0004kkBLG/\u001a:\u000b\u0005A\f\u0018!\u00026v]&$(\"\u0001:\u0002\u0007=\u0014x-\u0003\u0002uW\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0011i\u0016\u001cHoQ8oM&<W\u000b\u001d3bi\u0016D#aA<\u0011\u0005)D\u0018BA=l\u0005\u0011!Vm\u001d;\u0002IQ,7\u000f\u001e+sC:\u001c\u0018m\u0019;j_:4VM\u001d2pg&$\u0018pQ8oM&<W\u000b\u001d3bi\u0016D#\u0001B<\u0002_Q,7\u000f\u001e+sC:\u001c\u0018m\u0019;j_:dunZ4j]\u001e4VM\u001d2pg&$\u0018pQ8oM&<g+\u00197jI\u0006$\u0018n\u001c8)\u0005\u00159\u0018!\u0007;fgR$UO]1cS2LG/_!vI&$8i\u001c8gS\u001eD#AB<\u0002GQ,7\u000f^#mS\u001eL'\r\\3D_:$(o\u001c7mKJ\u001c8i\u001c8gS\u001e,\u0006\u000fZ1uK\"\u0012qa^\u0001(i\u0016\u001cH/\u00127jO&\u0014G.Z\"p]R\u0014x\u000e\u001c7feN\u001cuN\u001c4jOZ\u000bG.\u001b3bi&|g\u000e\u000b\u0002\to\u00061C/Z:u\u000b:\f'\r\\3EK\u001a\fW\u000f\u001c;V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8)\u0005%9\u0018a\u0007;fgR,\u0006\u000fZ1uK\u0012Kh.Y7jGRC'/Z1e!>|G\u000e\u000b\u0002\u000bo\u00061C/Z:u\u0007>tg-[4Va\u0012\fG/Z,ji\"\u001cv.\\3J]Z\fG.\u001b3D_:4\u0017nZ:)\u0005-9\u0018a\r;fgR\u001cuN\u001c4jOV\u0003H-\u0019;f/&$\bNU3d_:4\u0017nZ;sC\ndWMV1mS\u0012\fG/[8o\r\u0006LG.\u001e:fQ\taq/\u0001\u000fuKN$(+Z2p]\u001aLw-\u001e:bE2,g+\u00197jI\u0006$\u0018n\u001c8)\u000559\u0018a\u0005;fgR\u001cVmY;sSRL8i\u001c8gS\u001e\u001c\bF\u0001\bx\u0003M!Xm\u001d;D_:tWm\u0019;j_:\fVo\u001c;bQ\tyq/\u0001\u0016uKN$8\u000b^8sC\u001e,\u0007K]8cKNcwn^,sSR,G\u000b\u001b:fg\"|G\u000eZ't\u0007>tg-[4)\u0005A9\u0018A\t;fgR\u001cVmZ7f]R$U\r\\3uS>tG\u000b\u001b:piRdWM]\"p]\u001aLw\r\u000b\u0002\u0012o\u0006QC/Z:u)&,'\u000fR3mKR,G\rU1si&$\u0018n\u001c8t\u0007>|'\u000fZ5oCR|'oQ8oM&<\u0007F\u0001\nx\u0003u!Xm\u001d;US\u0016\u0014H+Y:lg\u000e{W\u000e]1di&|gnQ8oM&<\u0007FA\nx\u0003q!Xm\u001d;US\u0016\u0014Hk\u001c9jGNs\u0017\r]:i_R\u001c8i\u001c8gS\u001eD#\u0001F<\u0002'Q,7\u000f\u001e\"bY\u0006t7-\u001a:D_:4\u0017nZ:)\u0005U9\u0018a\t;fgR\u0014\u0015\r\\1oG\u0016\u0014h+\u00197jI\u0006$XMU3d_:4\u0017nZ;sCRLwN\u001c\u0015\u0003-]\fq\u0005^3ti\n\u000bG.\u00198dKJ\u0014VmY8oM&<WO]3OK\u001e\fG/\u001b<f)\"\u0014x\u000e\u001e;mK\"\u0012qc^\u0001\u0018i\u0016\u001cHoQ8o]\u0016\u001cG/[8o%\u0006$X-U;pi\u0006D#\u0001G<\u00029Q,7\u000f^\"p]:,7\r^5p]J\u000bG/Z)v_R\fg\t\\8pe\"\u0012\u0011d^\u0001\u0013i\u0016\u001cH\u000f\u0015:pIV\u001cWM]%e%\u0006$X\r\u000b\u0002\u001bo\u0006\u0019B/Z:u#V|G/Y'vYRL\u0007\u000f\\5fe\"\u00121d^\u0001\u0015i\u0016\u001cH/V:feF+x\u000e^1t\u000b:\f'\r\\3)\u0005q9\u0018A\u0006;fgR$\u0015P\\1nS\u000e\fVo\u001c;b\u000b:\f'\r\\3)\u0005u9\u0018a\u0004;fgR\u001cU\r\u001c7t\u000b:\f'\r\\3)\u0005y9\u0018!\u0007;fgR$\u0015P\\1nS\u000e\u001cFO]1z\u0019><7i\u001c8gS\u001eD#aH<\u0002;Q,7\u000f\u001e#z]\u0006l\u0017nY'j]N+w-\\3oi6\u001b8i\u001c8gS\u001eD#\u0001I<\u0002%Y,'/\u001b4z\u0007>tg-[4Va\u0012\fG/\u001a\u000b\nK\u00065\u0014qQAN\u0003KCq!a\u001c\"\u0001\u0004\t\t(\u0001\u0003oC6,\u0007\u0003BA:\u0003\u0003sA!!\u001e\u0002~A\u0019\u0011qO.\u000e\u0005\u0005e$bAA>/\u00061AH]8pizJ1!a \\\u0003\u0019\u0001&/\u001a3fM&!\u00111QAC\u0005\u0019\u0019FO]5oO*\u0019\u0011qP.\t\u000f\u0005%\u0015\u00051\u0001\u0002\f\u0006)a/\u00197vKB!\u0011QRAL\u001b\t\tyI\u0003\u0003\u0002\u0012\u0006M\u0015\u0001\u00027b]\u001eT!!!&\u0002\t)\fg/Y\u0005\u0005\u00033\u000byI\u0001\u0004PE*,7\r\u001e\u0005\b\u0003;\u000b\u0003\u0019AAP\u0003=\u0001XM\u001d\"s_.,'oQ8oM&<\u0007c\u0001.\u0002\"&\u0019\u00111U.\u0003\u000f\t{w\u000e\\3b]\"9\u0011qU\u0011A\u0002\u0005}\u0015!D3ya\u0016\u001cGOR1jYV\u0014X-A\u0012wKJLg-_\"p]\u001aLw-\u00169eCR,w+\u001b;i\u0013:4\u0018\r\\5e\u0007>tg-[4\u0015\u0013\u0015\fi+a.\u0002H\u0006]\u0007bBAXE\u0001\u0007\u0011\u0011W\u0001\u0007G>tg-[4\u0011\u0007\t\f\u0019,C\u0002\u00026N\u00131bS1gW\u0006\u001cuN\u001c4jO\"9\u0011\u0011\u0018\u0012A\u0002\u0005m\u0016!C8sS\u001e\u0004&o\u001c9t!\u0011\ti,a1\u000e\u0005\u0005}&\u0002BAa\u0003'\u000bA!\u001e;jY&!\u0011QYA`\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b\u0003\u0013\u0014\u0003\u0019AAf\u0003)1\u0018\r\\5e!J|\u0007o\u001d\t\t\u0003\u001b\f\u0019.!\u001d\u0002r5\u0011\u0011q\u001a\u0006\u0004\u0003#\\\u0016AC2pY2,7\r^5p]&!\u0011Q[Ah\u0005\ri\u0015\r\u001d\u0005\b\u00033\u0014\u0003\u0019AAf\u00031IgN^1mS\u0012\u0004&o\u001c9t\u0003q!Xm\u001d;QCN\u001cxo\u001c:e\u0007>tg-[4F]\u000e\u0014\u0018\u0010\u001d;j_:D#aI<\u0002KQ,7\u000f\u001e)bgN<xN\u001d3D_:4\u0017nZ#oG>$WM]*fGJ,Go\u00115b]\u001e,\u0007F\u0001\u0013x\u0003e!Xm\u001d;Es:\fW.[2MSN$XM\\3s\u0007>tg-[4)\u0005\u0015:(A\u0004+fgR\fU\u000f\u001e5pe&TXM]\n\bM\u0005-\u00151^A\u0000!\u0011\ti/a?\u000e\u0005\u0005=(\u0002BAy\u0003g\f!\"Y;uQ>\u0014\u0018N_3s\u0015\r!\u0016Q\u001f\u0006\u0004-\u0006](bAA}c\u00061\u0011\r]1dQ\u0016LA!!@\u0002p\nQ\u0011)\u001e;i_JL'0\u001a:\u0011\t\t\u0005!qA\u0007\u0003\u0005\u0007QAA!\u0002\u0002v\u000611m\\7n_:LAA!\u0003\u0003\u0004\tq!+Z2p]\u001aLw-\u001e:bE2,GC\u0001B\u0007!\r\u0011yAJ\u0007\u0002\u0001\u0005Q1/\u001e9feV\u001bXM]:\u0016\u0005\tU\u0001\u0003BAG\u0005/IA!a!\u0002\u0010\u0006q1/\u001e9feV\u001bXM]:`I\u0015\fHcA3\u0003\u001e!I!qD\u0015\u0002\u0002\u0003\u0007!QC\u0001\u0004q\u0012\n\u0014aC:va\u0016\u0014Xk]3sg\u0002B3A\u000bB\u0013!\rQ&qE\u0005\u0004\u0005SY&\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u000bM$\u0018M\u001d;\u0015\t\t=\"Q\f\u0019\u0005\u0005c\u0011y\u0004\u0005\u0005\u0002>\nM\"Q\u0007B\u001e\u0013\u0011\t).a0\u0011\t\t\u0005!qG\u0005\u0005\u0005s\u0011\u0019A\u0001\u0005F]\u0012\u0004x.\u001b8u!\u0011\u0011iDa\u0010\r\u0001\u0011Y!\u0011I\u0016\u0002\u0002\u0003\u0005)\u0011\u0001B\"\u0005\ryF\u0005O\t\u0005\u0005\u000b\u0012Y\u0005E\u0002[\u0005\u000fJ1A!\u0013\\\u0005\u001dqu\u000e\u001e5j]\u001e\u0004bA!\u0014\u0003T\t]SB\u0001B(\u0015\u0011\u0011\t&a0\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0003V\t=#aD\"p[BdW\r^5p]N#\u0018mZ3\u0011\t\u00055%\u0011L\u0005\u0005\u00057\nyI\u0001\u0003W_&$\u0007b\u0002B0W\u0001\u0007!\u0011M\u0001\u000bg\u0016\u0014h/\u001a:J]\u001a|\u0007\u0003BAw\u0005GJAA!\u001a\u0002p\n!\u0012)\u001e;i_JL'0\u001a:TKJ4XM]%oM>\f\u0011\"Y;uQ>\u0014\u0018N_3\u0015\r\t-$q\u000fBA!\u0019\tiL!\u001c\u0003r%!!qNA`\u0005\u0011a\u0015n\u001d;\u0011\t\u00055(1O\u0005\u0005\u0005k\nyOA\nBkRDwN]5{CRLwN\u001c*fgVdG\u000fC\u0004\u0003z1\u0002\rAa\u001f\u0002\u001dI,\u0017/^3ti\u000e{g\u000e^3yiB!\u0011Q\u001eB?\u0013\u0011\u0011y(a<\u00035\u0005+H\u000f[8sSj\f'\r\\3SKF,Xm\u001d;D_:$X\r\u001f;\t\u000f\t\rE\u00061\u0001\u0003\u0006\u00069\u0011m\u0019;j_:\u001c\bCBA_\u0005[\u00129\t\u0005\u0003\u0002n\n%\u0015\u0002\u0002BF\u0003_\u0014a!Q2uS>t\u0017AC2sK\u0006$X-Q2mgR1!\u0011\u0013BS\u0005O\u0003DAa%\u0003\u0018B1\u0011Q\u0018B7\u0005+\u0003BA!\u0010\u0003\u0018\u0012Y!\u0011T\u0017\u0002\u0002\u0003\u0005)\u0011\u0001BN\u0005\ryF%O\t\u0005\u0005\u000b\u0012i\n\u0005\u0004\u0003N\tM#q\u0014\t\u0005\u0003[\u0014\t+\u0003\u0003\u0003$\u0006=(aD!dY\u000e\u0013X-\u0019;f%\u0016\u001cX\u000f\u001c;\t\u000f\teT\u00061\u0001\u0003|!9!\u0011V\u0017A\u0002\t-\u0016aC1dY\nKg\u000eZ5oON\u0004b!!0\u0003n\t5\u0006\u0003\u0002BX\u0005kk!A!-\u000b\t\tM&1A\u0001\u0004C\u000ed\u0017\u0002\u0002B\\\u0005c\u0013!\"Q2m\u0005&tG-\u001b8h\u0003)!W\r\\3uK\u0006\u001bGn\u001d\u000b\u0007\u0005{\u0013\tNa51\t\t}&1\u0019\t\u0007\u0003{\u0013iG!1\u0011\t\tu\"1\u0019\u0003\f\u0005\u000bt\u0013\u0011!A\u0001\u0006\u0003\u00119M\u0001\u0003`IE\u0002\u0014\u0003\u0002B#\u0005\u0013\u0004bA!\u0014\u0003T\t-\u0007\u0003BAw\u0005\u001bLAAa4\u0002p\ny\u0011i\u00197EK2,G/\u001a*fgVdG\u000fC\u0004\u0003z9\u0002\rAa\u001f\t\u000f\tUg\u00061\u0001\u0003X\u0006\t\u0012m\u00197CS:$\u0017N\\4GS2$XM]:\u0011\r\u0005u&Q\u000eBm!\u0011\u0011yKa7\n\t\tu'\u0011\u0017\u0002\u0011\u0003\u000ed')\u001b8eS:<g)\u001b7uKJ\fA!Y2mgR!!1\u001dBu!\u0019\tiI!:\u0003.&!!q]AH\u0005!IE/\u001a:bE2,\u0007b\u0002Bv_\u0001\u0007!\u0011\\\u0001\u0007M&dG/\u001a:\u0002\u000b\rdwn]3\u0002\u0013\r|gNZ5hkJ,GcA3\u0003t\"9!Q_\u0019A\u0002\t]\u0018aB2p]\u001aLwm\u001d\u0019\u0005\u0005s\u0014i\u0010\u0005\u0005\u0002>\nM\u0012\u0011\u000fB~!\u0011\u0011iD!@\u0005\u0019\t}(1_A\u0001\u0002\u0003\u0015\ta!\u0001\u0003\t}#\u0013'M\t\u0005\u0005\u000b\u001a\u0019\u0001E\u0002[\u0007\u000bI1aa\u0002\\\u0005\r\te._\u0001\u0016e\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t)\t\u0019i\u0001\u0005\u0004\u0002>\u000e=\u0011\u0011O\u0005\u0005\u0007#\tyLA\u0002TKR\fqC^1mS\u0012\fG/\u001a*fG>tg-[4ve\u0006$\u0018n\u001c8\u0015\u0007\u0015\u001c9\u0002C\u0004\u0003vN\u0002\ra!\u00071\t\rm1q\u0004\t\t\u0003{\u0013\u0019$!\u001d\u0004\u001eA!!QHB\u0010\t1\u0019\tca\u0006\u0002\u0002\u0003\u0005)\u0011AB\u0001\u0005\u0011yF%\r\u001a\u0002\u0017I,7m\u001c8gS\u001e,(/\u001a\u000b\u0004K\u000e\u001d\u0002b\u0002B{i\u0001\u00071\u0011\u0006\u0019\u0005\u0007W\u0019y\u0003\u0005\u0005\u0002>\nM\u0012\u0011OB\u0017!\u0011\u0011ida\f\u0005\u0019\rE2qEA\u0001\u0002\u0003\u0015\ta!\u0001\u0003\t}#\u0013gM\u0001\u0015i\u0016\u001cH/Q;uQ>\u0014\u0018N_3s\u0007>tg-[4)\u0005U:\u0018AH2sK\u0006$XmQ8nE&tW\rZ\"p]R\u0014x\u000e\u001c7fe\u000e{gNZ5h)\u0019\tYla\u000f\u0004F!91Q\b\u001cA\u0002\r}\u0012A\u00028pI\u0016LE\rE\u0002[\u0007\u0003J1aa\u0011\\\u0005\rIe\u000e\u001e\u0005\b\u0007\u000f2\u0004\u0019AB \u0003\u0011\u0001xN\u001d;\u0002MQ,7\u000f^\"p[\nLg.\u001a3D_:$(o\u001c7mKJ\fU\u000f\u001e5pe&TXM]\"p]\u001aLw\r\u000b\u00028o\u0006\tC/Z:u\u001b\u0006D8i\u001c8oK\u000e$\u0018n\u001c8t!\u0016\u0014H+\u001a8b]R\u001cuN\u001c4jO\"\u0012\u0001h^\u0001\u001fGJ,\u0017\r^3Jg>d\u0017\r^3e\u0007>tGO]8mY\u0016\u00148i\u001c8gS\u001e$b!a/\u0004V\r]\u0003bBB\u001fs\u0001\u00071q\b\u0005\b\u0007\u000fJ\u0004\u0019AB \u0003\u0019\"Xm\u001d;Jg>d\u0017\r^3e\u0007>tGO]8mY\u0016\u0014\u0018)\u001e;i_JL'0\u001a:D_:4\u0017n\u001a\u0015\u0003u]\fA\u0003^3ti\"#H\u000f]*feZ,'oQ8oM&<\u0007FA\u001ex\u00031!Xm\u001d;Ts:|g._7tQ\tat/A\u0019uKN$H)\u001f8b[&\u001c7i\u001c8gS\u001eLe.\u001b;jC2L'0\u0019;j_:<\u0016\u000e\u001e5pkR\u001cuN\u001c4jONLeNW&)\u0005u:\u0018A\r;fgR\u001cuN\u001c4jOV\u0014X\rZ%ogR\fgnY3J]&$\u0018.\u00197ju\u0016$w+\u001b;i\tft\u0017-\\5d\u0007>tg-[4)\u0005y:\u0018!\n;fgR\u0014V\r\u001d7jG\u0006l\u0015M\\1hKJ4U\r^2i\u001b\u0006D()\u001f;fg\u000eC\u0017M\\4fQ\tyt/A\u0010uKN$H)\u001f8b[&\u001c\u0007K]8ek\u000e,'/Q2lg>3XM\u001d:jI\u0016D#\u0001Q<\u0002iQ,7\u000f\u001e*fa2L7-Y'b]\u0006<WM\u001d+jKJl\u0015\r\u001f)beRLG/[8o\r\u0016$8\r\u001b\"zi\u0016\u001cxJ^3se&$W\r\u000b\u0002Bo\u0006iB/Z:u\u00136\u0004(o\u001c9fe\u000e{gNZ5hg\u0006\u0013XMU3n_Z,G\r\u000b\u0002Co\u0006!B/Z:u\u00072LWM\u001c;KC\u0006\u001c8i\u001c8gS\u001eD#aQ<\u0002+Q,7\u000f\u001e'pO&t7i\u001c8gS\u001e\u001c\u0005.\u00198hK\"\u0012Ai^\u00012i\u0016\u001cHoU1tY\u000e\u0013X\rZ3oi&\fGNU8uCRLwN\\,ji\"\u0004&/\u001a4jq\u0016$7I]3eK:$\u0018.\u00197tQ\t)u/A\u001auKN$8+Y:m\u0007J,G-\u001a8uS\u0006d'k\u001c;bi&|gnV5uQVs\u0007O]3gSb,Gm\u0011:fI\u0016tG/[1mg\"\u0012ai^\u0001/i\u0016\u001cHoU1tY\u000e\u0013X\rZ3oi&\fGNU8uCRLwN\\,ji\"\u001c\u0006.\u0019:fI*\u000b\u0017m]\"p]\u001aLw\r\u000b\u0002Ho\u00061B/Z:u\u001d\u0016<8+Y:m\u0007J,G-\u001a8uS\u0006d7\u000f\u000b\u0002Io\u0006Ab/\u001a:jMf\u001c%/\u001a3f]RL\u0017\r\u001c*pi\u0006$\u0018n\u001c8\u0015\u000b\u0015\u001cIj!(\t\u000f\rm\u0015\n1\u0001\u0002r\u0005qQo]3s]\u0006lWmQ8oM&<\u0007bBBP\u0013\u0002\u0007\u0011\u0011O\u0001\u000fa\u0006\u001c8o^8sI\u000e{gNZ5h\u0003-\"Xm\u001d;GS2,')Y:fI2{w-\u001b8O_RD\u0015M\u001c3mK\u0012\f5\u000fR=oC6L7mQ8oM&<\u0007F\u0001&x\u0003iY\u0017MZ6b!J|\u0007o],ji\"$\u0015P\\1nS\u000edunZ5o)!\tYl!+\u0004,\u000e5\u0006bBBN\u0017\u0002\u0007\u0011\u0011\u000f\u0005\b\u0007?[\u0005\u0019AA9\u0011%\u0019yk\u0013I\u0001\u0002\u0004\u0019\t,\u0001\bqYV<\u0017N\u001c)sK\u001aL\u00070Z:\u0011\r\u0005571WA9\u0013\u0011\u0019\t\"a4\u0002I-\fgm[1Qe>\u00048oV5uQ\u0012Kh.Y7jG2{w-\u001b8%I\u00164\u0017-\u001e7uIM*\"a!/+\t\rE61X\u0016\u0003\u0007{\u0003Baa0\u0004J6\u00111\u0011\u0019\u0006\u0005\u0007\u0007\u001c)-A\u0005v]\u000eDWmY6fI*\u00191qY.\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004L\u000e\u0005'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\t3M]3bi\u0016\\\u0015MZ6b\u0007>tg-[4XSRDG)\u001f8b[&\u001cGj\\4j]R!1\u0011[Bo!\u001dQ61[AY\u0007/L1a!6\\\u0005\u0019!V\u000f\u001d7feA\u0019!m!7\n\u0007\rm7KA\nEs:\fW.[2M_\u001eLg.T1oC\u001e,'\u000fC\u0004\u0004`6\u0003\r!a/\u0002\u000bA\u0014x\u000e]:\u0002!Y,'/\u001b4z\u0007J,G-\u001a8uS\u0006dGcB3\u0004f\u000e=81\u001f\u0005\b\u0007Ot\u0005\u0019ABu\u0003\u001d\u0019wN\u001c;fqR\u00042AYBv\u0013\r\u0019io\u0015\u0002\u0014\tft\u0017-\\5d\u0019><\u0017N\\\"p]R,\u0007\u0010\u001e\u0005\b\u0007ct\u0005\u0019AA9\u0003!)8/\u001a:oC6,\u0007bBB{\u001d\u0002\u0007\u0011\u0011O\u0001\ta\u0006\u001c8o^8sI\u0006IB/Z:u+B$\u0017\r^3NKR\u0014\u0018n\u0019*fa>\u0014H/\u001a:t\u0003\u0019\"Xm\u001d;Va\u0012\fG/Z'fiJL7MU3q_J$XM]:O_*k\u0007PU3q_J$XM\u001d\u0015\u0003!^\f\u0011\u0007^3ti:{g.\u00138uKJt\u0017\r\u001c,bYV,7\u000fR8fg:{G/\u0012=q_N,\u0017J\u001c;fe:\fGnQ8oM&<7\u000f\u000b\u0002Ro\u0002")
public class DynamicBrokerConfigTest {
    @AfterEach
    public void tearDown() {
        LoginManager.closeAll();
    }

    @Test
    public void testConfigUpdate() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var25_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var26_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var27_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        String oldKeystore = "oldKs.jks";
        props.put("ssl.keystore.location", oldKeystore);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        DynamicBrokerConfig dynamicConfig = config.dynamicConfig();
        dynamicConfig.initialize((Option)None$.MODULE$);
        Assertions.assertEquals((Object)config, (Object)dynamicConfig.currentKafkaConfig());
        Assertions.assertEquals((Object)oldKeystore, config.values().get("ssl.keystore.location"));
        Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfigWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
        Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Properties props1 = new Properties();
            String newKeystore = new StringBuilder(6).append("ks").append(i).append(".jks").toString();
            props1.put(new StringBuilder(44).append("listener.name.external.").append("ssl.keystore.location").toString(), newKeystore);
            dynamicConfig.updateBrokerConfig(0, props1, dynamicConfig.updateBrokerConfig$default$3());
            Assertions.assertNotSame((Object)config, (Object)dynamicConfig.currentKafkaConfig());
            Assertions.assertEquals((Object)newKeystore, config.valuesWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.originalsWithPrefix("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.valuesWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.originalsWithPrefix("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, (Object)config.getString(KafkaConfig$.MODULE$.SslKeystoreLocationProp()));
            Assertions.assertEquals((Object)oldKeystore, config.originals().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.values().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsStrings().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfigWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfig().get("ssl.keystore.location"));
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTransactionVerbosityConfigUpdate() {
        void apply_doLog;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var26_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var27_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var28_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        boolean bl = true;
        Properties apply_props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        Object var24_24 = null;
        KafkaConfig config = new KafkaConfig((java.util.Map)apply_props, (boolean)apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Assertions.assertEquals((int)0, (int)config.confluentConfig().transactionLoggingVerbosity());
        TransactionCoordinator txnCoordinatorMock = (TransactionCoordinator)Mockito.mock(TransactionCoordinator.class);
        DynamicTransactionCoordinator dynamicTxnCoordinatorConfig = new DynamicTransactionCoordinator(txnCoordinatorMock);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicTxnCoordinatorConfig);
        Properties props = new Properties();
        props.put("confluent.transaction.logging.verbosity", "1");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)1, (int)config.confluentConfig().transactionLoggingVerbosity());
        ((TransactionCoordinator)Mockito.verify((Object)txnCoordinatorMock)).setLoggingVerbosity(1);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTransactionLoggingVerbosityConfigValidation() {
        void apply_doLog;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var26_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var27_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var28_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        boolean bl = true;
        Properties apply_props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        Object var24_24 = null;
        KafkaConfig config = new KafkaConfig((java.util.Map)apply_props, (boolean)apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Assertions.assertEquals((int)0, (int)config.confluentConfig().transactionLoggingVerbosity());
        TransactionCoordinator txnCoordinatorMock = (TransactionCoordinator)Mockito.mock(TransactionCoordinator.class);
        DynamicTransactionCoordinator dynamicTxnCoordinatorConfig = new DynamicTransactionCoordinator(txnCoordinatorMock);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicTxnCoordinatorConfig);
        Properties props = new Properties();
        props.put("confluent.transaction.logging.verbosity", "-11");
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(props, false));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDurabilityAuditConfig() {
        void apply_doLog;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var26_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var27_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var28_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        boolean bl = true;
        Properties apply_props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        Object var24_24 = null;
        KafkaConfig config = new KafkaConfig((java.util.Map)apply_props, (boolean)apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Assertions.assertEquals((Object)"PeriodicalAudit,ChecksumAudit", (Object)config.confluentConfig().auditConfigChecks());
        KafkaBroker kafkaBrokerMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        DynamicDurabilityAuditConfig dynamicDurabilityAuditConfig = new DynamicDurabilityAuditConfig(kafkaBrokerMock);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicDurabilityAuditConfig);
        Properties props = new Properties();
        props.put("confluent.durability.audit.checks", "");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((Object)"", (Object)config.confluentConfig().auditConfigChecks());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testEligibleControllersConfigUpdate() {
        void apply_doLog;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var27_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var28_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var29_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        boolean bl = true;
        Properties apply_props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        Object var25_24 = null;
        KafkaConfig config = new KafkaConfig((java.util.Map)apply_props, (boolean)apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Assertions.assertEquals((Object)Set$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)config.confluentConfig().eligibleControllers());
        KafkaController controllerMock = (KafkaController)Mockito.mock(KafkaController.class);
        MetadataCache metadataCacheMock = (MetadataCache)Mockito.mock(MetadataCache.class);
        DynamicZkControllerConfig dynamicControllerConfig = new DynamicZkControllerConfig(controllerMock, metadataCacheMock);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicControllerConfig);
        Mockito.when((Object)metadataCacheMock.getAliveBrokers()).thenReturn((Object)new .colon.colon((Object)new BrokerMetadata(0, (Option)None$.MODULE$, (Map)Map$.MODULE$.empty()), (List)new .colon.colon((Object)new BrokerMetadata(1, (Option)None$.MODULE$, (Map)Map$.MODULE$.empty()), (List)Nil$.MODULE$)));
        Properties props = new Properties();
        props.put("confluent.eligible.controllers", "0");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        ((KafkaController)Mockito.verify((Object)controllerMock)).updateEligibleControllers((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})));
        Mockito.reset((Object[])new KafkaController[]{controllerMock});
        Assertions.assertEquals((Object)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)config.confluentConfig().eligibleControllers());
        props.put("confluent.eligible.controllers", "");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        ((KafkaController)Mockito.verify((Object)controllerMock)).updateEligibleControllers((Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$));
        Assertions.assertEquals((Object)Set$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)config.confluentConfig().eligibleControllers());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testEligibleControllersConfigValidation() {
        void apply_doLog;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var27_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var28_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var29_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        boolean bl = true;
        Properties apply_props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        Object var25_24 = null;
        KafkaConfig config = new KafkaConfig((java.util.Map)apply_props, (boolean)apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        KafkaController controllerMock = (KafkaController)Mockito.mock(KafkaController.class);
        MetadataCache metadataCacheMock = (MetadataCache)Mockito.mock(MetadataCache.class);
        DynamicZkControllerConfig dynamicControllerConfig = new DynamicZkControllerConfig(controllerMock, metadataCacheMock);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicControllerConfig);
        Mockito.when((Object)metadataCacheMock.getAliveBrokers()).thenReturn((Object)new .colon.colon((Object)new BrokerMetadata(0, (Option)None$.MODULE$, (Map)Map$.MODULE$.empty()), (List)new .colon.colon((Object)new BrokerMetadata(1, (Option)None$.MODULE$, (Map)Map$.MODULE$.empty()), (List)Nil$.MODULE$)));
        Properties props = new Properties();
        props.put("confluent.eligible.controllers", "0,1");
        config.dynamicConfig().validate(props, false);
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(props, true));
        props.put("confluent.eligible.controllers", "1,2,3");
        config.dynamicConfig().validate(props, false);
        props.put("confluent.eligible.controllers", "2,3");
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(props, false));
        props.put("confluent.eligible.controllers", "");
        config.dynamicConfig().validate(props, false);
    }

    @Test
    public void testEnableDefaultUncleanLeaderElection() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var28_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var29_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var30_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "false");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        KafkaServer serverMock = (KafkaServer)Mockito.mock(KafkaServer.class);
        KafkaController controllerMock = (KafkaController)Mockito.mock(KafkaController.class);
        LogManager logManagerMock = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.kafkaController()).thenReturn((Object)controllerMock);
        Mockito.when((Object)serverMock.logManager()).thenReturn((Object)logManagerMock);
        Mockito.when((Object)logManagerMock.allLogs()).thenReturn(Iterable$.MODULE$.empty());
        AtomicReference<LogConfig> currentDefaultLogConfig = new AtomicReference<LogConfig>(new LogConfig((java.util.Map)new Properties()));
        Mockito.when((Object)logManagerMock.currentDefaultConfig()).thenAnswer(x$1 -> (LogConfig)currentDefaultLogConfig.get());
        logManagerMock.reconfigureDefaultLogConfig((LogConfig)ArgumentMatchers.any(LogConfig.class));
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> {
            currentDefaultLogConfig.set(invocation.getArgument(0));
            return BoxedUnit.UNIT;
        });
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicLogConfig(logManagerMock, (KafkaBroker)serverMock));
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(config.uncleanLeaderElectionEnable()));
        ((KafkaController)Mockito.verify((Object)controllerMock)).enableDefaultUncleanLeaderElection();
    }

    @Test
    public void testUpdateDynamicThreadPool() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var32_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var33_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var34_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put(KafkaConfig$.MODULE$.NumIoThreadsProp(), "4");
        origProps.put(KafkaConfig$.MODULE$.NumNetworkThreadsProp(), "2");
        origProps.put(KafkaConfig$.MODULE$.NumReplicaFetchersProp(), "1");
        origProps.put(KafkaConfig$.MODULE$.NumRecoveryThreadsPerDataDirProp(), "1");
        origProps.put(KafkaConfig$.MODULE$.BackgroundThreadsProp(), "3");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        DataPlaneAcceptor acceptorMock = (DataPlaneAcceptor)Mockito.mock(DataPlaneAcceptor.class);
        KafkaRequestHandlerPool handlerPoolMock = (KafkaRequestHandlerPool)Mockito.mock(KafkaRequestHandlerPool.class);
        SocketServer socketServerMock = (SocketServer)Mockito.mock(SocketServer.class);
        ReplicaManager replicaManagerMock = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        LogManager logManagerMock = (LogManager)Mockito.mock(LogManager.class);
        KafkaScheduler schedulerMock = (KafkaScheduler)Mockito.mock(KafkaScheduler.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.dataPlaneRequestHandlerPool()).thenReturn((Object)handlerPoolMock);
        Mockito.when((Object)acceptorMock.listenerName()).thenReturn((Object)new ListenerName("plaintext"));
        Mockito.when((Object)acceptorMock.reconfigurableConfigs()).thenCallRealMethod();
        Mockito.when((Object)serverMock.socketServer()).thenReturn((Object)socketServerMock);
        Mockito.when((Object)socketServerMock.dataPlaneAcceptor(ArgumentMatchers.anyString())).thenReturn((Object)new Some((Object)acceptorMock));
        Mockito.when((Object)serverMock.replicaManager()).thenReturn((Object)replicaManagerMock);
        Mockito.when((Object)serverMock.logManager()).thenReturn((Object)logManagerMock);
        Mockito.when((Object)serverMock.kafkaScheduler()).thenReturn((Object)schedulerMock);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new BrokerDynamicThreadPool(serverMock));
        config.dynamicConfig().addReconfigurable((Reconfigurable)acceptorMock);
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.NumIoThreadsProp(), "8");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)8, (Integer)config.numIoThreads());
        ((KafkaRequestHandlerPool)Mockito.verify((Object)handlerPoolMock)).resizeThreadPool(8);
        props.put(KafkaConfig$.MODULE$.NumNetworkThreadsProp(), "4");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)4, (Integer)config.numNetworkThreads());
        ArgumentCaptor captor = ArgumentCaptor.forClass(java.util.Map.class);
        ((DataPlaneAcceptor)Mockito.verify((Object)acceptorMock)).reconfigure((java.util.Map)captor.capture());
        Assertions.assertTrue((boolean)((java.util.Map)captor.getValue()).containsKey(KafkaConfig$.MODULE$.NumNetworkThreadsProp()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)4), ((java.util.Map)captor.getValue()).get(KafkaConfig$.MODULE$.NumNetworkThreadsProp()));
        props.put(KafkaConfig$.MODULE$.NumReplicaFetchersProp(), "2");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)2, (Integer)config.numReplicaFetchers());
        ((ReplicaManager)Mockito.verify((Object)replicaManagerMock)).resizeFetcherThreadPool(2);
        props.put(KafkaConfig$.MODULE$.NumRecoveryThreadsPerDataDirProp(), "2");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)2, (Integer)config.numRecoveryThreadsPerDataDir());
        ((LogManager)Mockito.verify((Object)logManagerMock)).resizeRecoveryThreadPool(2);
        props.put(KafkaConfig$.MODULE$.BackgroundThreadsProp(), "6");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)6, (Integer)config.backgroundThreads());
        ((KafkaScheduler)Mockito.verify((Object)schedulerMock)).resizeThreadPool(6);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handlerPoolMock, socketServerMock, replicaManagerMock, logManagerMock, schedulerMock});
    }

    @Test
    public void testConfigUpdateWithSomeInvalidConfigs() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var28_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var29_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var30_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put("ssl.keystore.type", "JKS");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Map validProps = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(44).append("listener.name.external.").append("ssl.keystore.location").toString()), (Object)"ks.p12")}));
        Map securityPropsWithoutListenerPrefix = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.type"), (Object)"PKCS12")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (Map<String, String>)validProps, (Map<String, String>)securityPropsWithoutListenerPrefix);
        Map nonDynamicProps = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkConnectProp()), (Object)"somehost:2181")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (Map<String, String>)validProps, (Map<String, String>)nonDynamicProps);
        Map invalidProps = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogCleanerThreadsProp()), (Object)"invalid")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (Map<String, String>)validProps, (Map<String, String>)invalidProps);
        Map excludedTopicConfig = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogMessageFormatVersionProp()), (Object)"0.10.2")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (Map<String, String>)validProps, (Map<String, String>)excludedTopicConfig);
    }

    @Test
    public void testConfigUpdateWithReconfigurableValidationFailure() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var27_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var28_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var29_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), "100000000");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Map validProps = (Map)Map$.MODULE$.empty();
        Map invalidProps = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogCleanerThreadsProp()), (Object)"20")}));
        Reconfigurable reconfigurable = new Reconfigurable(this){
            private final /* synthetic */ DynamicBrokerConfigTest $outer;

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return CollectionConverters$.MODULE$.SetHasAsJava((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp()}))).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
                DynamicBrokerConfigTest.kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(configs);
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        config.dynamicConfig().addReconfigurable(reconfigurable);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (Map<String, String>)validProps, (Map<String, String>)invalidProps);
        config.dynamicConfig().removeReconfigurable(reconfigurable);
        BrokerReconfigurable brokerReconfigurable = new BrokerReconfigurable(this){
            private final /* synthetic */ DynamicBrokerConfigTest $outer;

            public Set<String> reconfigurableConfigs() {
                return (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp()}));
            }

            public void validateReconfiguration(KafkaConfig newConfig) {
                DynamicBrokerConfigTest.kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(newConfig.originals());
            }

            public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        config.dynamicConfig().addBrokerReconfigurable(brokerReconfigurable);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (Map<String, String>)validProps, (Map<String, String>)invalidProps);
    }

    @Test
    public void testReconfigurableValidation() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var25_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var26_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var27_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        Set invalidReconfigurableProps = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp(), KafkaConfig$.MODULE$.BrokerIdProp(), "some.prop"}));
        Set validReconfigurableProps = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp(), KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), "some.prop"}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.dynamicConfig().addReconfigurable(new Reconfigurable(null, invalidReconfigurableProps){
            private final Set configs$1;

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return CollectionConverters$.MODULE$.SetHasAsJava(this.configs$1).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
            }
            {
                this.configs$1 = configs$1;
            }
        }));
        config.dynamicConfig().addReconfigurable(new /* invalid duplicate definition of identical inner class */);
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.dynamicConfig().addBrokerReconfigurable(new BrokerReconfigurable(null, invalidReconfigurableProps){
            private final Set configs$2;

            public Set<String> reconfigurableConfigs() {
                return this.configs$2;
            }

            public void validateReconfiguration(KafkaConfig newConfig) {
            }

            public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
            }
            {
                this.configs$2 = configs$2;
            }
        }));
        config.dynamicConfig().addBrokerReconfigurable(new /* invalid duplicate definition of identical inner class */);
    }

    @Test
    public void testSecurityConfigs() {
        this.verifyUpdate$1("ssl.keystore.location", "ks.jks");
        this.verifyUpdate$1("ssl.keystore.type", "JKS");
        this.verifyUpdate$1("ssl.keystore.password", "password");
        this.verifyUpdate$1("ssl.key.password", "password");
    }

    @Test
    public void testConnectionQuota() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "100", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "100", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "0", false, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName1:100,hostName2:0", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName1:100,hostName2:0", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName#:100", true, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsProp(), "100", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsProp(), "100", false, false);
        String listenerMaxConnectionsProp = new StringBuilder(23).append("listener.name.external.").append(KafkaConfig$.MODULE$.MaxConnectionsProp()).toString();
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "10", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "10", false, false);
    }

    @Test
    public void testStorageProbeSlowWriteThresholdMsConfig() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.StorageProbeSlowWriteThresholdMsProp(), "7000", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.StorageProbeSlowWriteThresholdMsProp(), "50", false, false);
    }

    @Test
    public void testSegmentDeletionThrottlerConfig() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "-1", true, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "-1", false, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "0", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "0", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "100", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "100", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionThrottlerDiskFreeHeadroomBytesProp(), "-1", true, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionThrottlerDiskFreeHeadroomBytesProp(), "-1", false, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionThrottlerDiskFreeHeadroomBytesProp(), "0", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionThrottlerDiskFreeHeadroomBytesProp(), "0", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionThrottlerDiskFreeHeadroomBytesProp(), "100", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionThrottlerDiskFreeHeadroomBytesProp(), "100", true, false);
    }

    @Test
    public void testTierDeletedPartitionsCoordinatorConfig() {
        ((IterableOnceOps)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.TierTopicDeleteCheckIntervalMsProp(), KafkaConfig$.MODULE$.TierTopicDeleteMaxInprogressPartitionsProp(), KafkaConfig$.MODULE$.TierTopicDeleteBackoffMsProp()}))).foreach((Function1 & Serializable)config -> {
            DynamicBrokerConfigTest.$anonfun$testTierDeletedPartitionsCoordinatorConfig$1(this, config);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testTierTasksCompactionConfig() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.TierCleanerNumThreadsProp(), "-1", true, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.TierCleanerNumThreadsProp(), "-1", false, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.TierCleanerNumThreadsProp(), "0", true, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.TierCleanerNumThreadsProp(), "0", false, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.TierCleanerNumThreadsProp(), "1", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.TierCleanerNumThreadsProp(), "1", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.TierCleanerNumThreadsProp(), "4", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.TierCleanerNumThreadsProp(), "4", false, false);
    }

    @Test
    public void testTierTopicSnapshotsConfig() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.TierTopicSnapshotsEnableProp(), Boolean.toString(false), true, false);
    }

    @Test
    public void testBalancerConfigs() {
        this.verifyConfigUpdate("confluent.balancer.throttle.bytes.per.second", "200", false, false);
        this.verifyConfigUpdate("confluent.balancer.enable", Boolean.toString(true), false, false);
        this.verifyConfigUpdate("confluent.balancer.enable", "PAUSED", false, true);
    }

    @Test
    public void testBalancerValidateReconfiguration() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var25_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var26_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var27_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 9092, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        KafkaServer kafkaServer = (KafkaServer)Mockito.mock(KafkaServer.class);
        Mockito.when((Object)kafkaServer.config()).thenReturn((Object)oldConfig);
        props.put("confluent.balancer.throttle.bytes.per.second", "200");
        boolean apply_doLog = true;
        KafkaConfig newConfig = new KafkaConfig((java.util.Map)props, apply_doLog);
        new DynamicBalancerConfig((KafkaBroker)kafkaServer).validateReconfiguration(newConfig);
    }

    @Test
    public void testBalancerReconfigureNegativeThrottle() {
        this.verifyConfigUpdate("confluent.balancer.throttle.bytes.per.second", ConfluentConfigs.BALANCER_THROTTLE_AUTO_THROTTLE.toString(), false, false);
        this.verifyConfigUpdate("confluent.balancer.throttle.bytes.per.second", ConfluentConfigs.BALANCER_THROTTLE_MIN.toString(), false, false);
    }

    @Test
    public void testConnectionRateQuota() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), "110", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), "120", false, false);
        String listenerMaxConnectionsProp = new StringBuilder(23).append("listener.name.external.").append(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()).toString();
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "20", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "30", false, false);
    }

    @Test
    public void testConnectionRateQuotaFloor() {
        String listenerMaxConnectionCreationFloorProp = new StringBuilder(23).append("listener.name.external.").append(KafkaConfig$.MODULE$.MaxConnectionCreationRateFloorProp()).toString();
        this.verifyConfigUpdate(listenerMaxConnectionCreationFloorProp, "20", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionCreationFloorProp, "30", false, false);
    }

    @Test
    public void testProducerIdRate() {
        String producerIdRateProp = "Producer id quota count per tenant per broker";
        this.verifyConfigUpdate(producerIdRateProp, "20", false, false);
        this.verifyConfigUpdate(producerIdRateProp, "30", false, false);
    }

    @Test
    public void testQuotaMultiplier() {
        String produceMultiplierProp = "confluent.quota.tenant.produce.multiplier";
        this.verifyConfigUpdate(produceMultiplierProp, "1.5", true, false);
        this.verifyConfigUpdate(produceMultiplierProp, "2.0", false, false);
        String fetchMultiplierProp = "confluent.quota.tenant.fetch.multiplier";
        this.verifyConfigUpdate(fetchMultiplierProp, "1.5", true, false);
        this.verifyConfigUpdate(fetchMultiplierProp, "2.0", false, false);
        this.verifyConfigUpdate(produceMultiplierProp, "0.5", true, true);
        this.verifyConfigUpdate(fetchMultiplierProp, "0.5", true, true);
        this.verifyConfigUpdate(produceMultiplierProp, "1.0", true, false);
        this.verifyConfigUpdate(fetchMultiplierProp, "1.0", true, false);
    }

    @Test
    public void testUserQuotasEnable() {
        this.verifyConfigUpdate("confluent.quota.tenant.user.quotas.enable", Boolean.toString(true), false, false);
    }

    @Test
    public void testDynamicQuotaEnable() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.DynamicQuotaEnabledProp(), Boolean.toString(true), false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.DynamicQuotaEnabledProp(), Boolean.toString(false), false, false);
    }

    @Test
    public void testCellsEnable() {
        this.verifyConfigUpdate("confluent.cells.enable", Boolean.toString(true), false, false);
    }

    @Test
    public void testDynamicStrayLogConfig() {
        this.verifyConfigUpdate("confluent.stray.log.delete.delay.ms", "60000", true, false);
        this.verifyConfigUpdate("confluent.stray.log.max.deletions.per.run", "36", true, false);
        this.verifyConfigUpdate("confluent.stray.log.delete.delay.ms", "60000", false, false);
        this.verifyConfigUpdate("confluent.stray.log.max.deletions.per.run", "36", false, false);
        this.verifyConfigUpdate("confluent.stray.log.delete.delay.ms", "-1", true, true);
        this.verifyConfigUpdate("confluent.stray.log.max.deletions.per.run", "0", true, true);
        this.verifyConfigUpdate("confluent.stray.log.delete.delay.ms", "-1", false, true);
        this.verifyConfigUpdate("confluent.stray.log.max.deletions.per.run", "0", false, true);
    }

    @Test
    public void testDynamicMinSegmentMsConfig() {
        this.verifyConfigUpdate("confluent.min.segment.ms", "144000000", true, false);
        this.verifyConfigUpdate("confluent.min.segment.ms", "144000000", false, false);
        this.verifyConfigUpdate("confluent.min.segment.ms", "0", true, true);
        this.verifyConfigUpdate("confluent.min.segment.ms", "0", false, true);
    }

    private void verifyConfigUpdate(String name, Object value, boolean perBrokerConfig, boolean expectFailure) {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var29_13 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var30_16 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var31_19 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties configProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        configProps.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "broker.secret");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)configProps, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Properties props = new Properties();
        props.put(name, value);
        Object oldValue = config.originals().get(name);
        if (!expectFailure) {
            config.dynamicConfig().validate(props, perBrokerConfig);
            DynamicBrokerConfigTest.updateConfig$1(perBrokerConfig, config, props);
            Assertions.assertEquals((Object)value, config.originals().get(name));
            return;
        }
        Assertions.assertThrows(Exception.class, () -> config.dynamicConfig().validate(props, perBrokerConfig));
        DynamicBrokerConfigTest.updateConfig$1(perBrokerConfig, config, props);
        Assertions.assertEquals(oldValue, config.originals().get(name));
    }

    private void verifyConfigUpdateWithInvalidConfig(KafkaConfig config, Properties origProps, Map<String, String> validProps, Map<String, String> invalidProps) {
        Properties props = new Properties();
        validProps.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return props.put(k, v);
            }
            throw new MatchError(null);
        });
        invalidProps.foreach((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                String k = (String)x0$2._1();
                String v = (String)x0$2._2();
                return props.put(k, v);
            }
            throw new MatchError(null);
        });
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(props, true));
        config.dynamicConfig().updateBrokerConfig(0, props, config.dynamicConfig().updateBrokerConfig$default$3());
        validProps.foreach((Function1 & Serializable)x0$3 -> {
            DynamicBrokerConfigTest.$anonfun$verifyConfigUpdateWithInvalidConfig$4(config, x0$3);
            return BoxedUnit.UNIT;
        });
        invalidProps.keySet().foreach((Function1 & Serializable)name -> {
            DynamicBrokerConfigTest.$anonfun$verifyConfigUpdateWithInvalidConfig$5(origProps, config, name);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPasswordConfigEncryption() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var28_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var29_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var30_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        boolean apply_doLog = true;
        KafkaConfig configWithoutSecret = new KafkaConfig((java.util.Map)props, apply_doLog);
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "config-encoder-secret");
        boolean apply_doLog2 = true;
        KafkaConfig configWithSecret = new KafkaConfig((java.util.Map)props, apply_doLog2);
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "myLoginModule required;");
        try {
            configWithoutSecret.dynamicConfig().toPersistentProps(dynamicProps, true);
        }
        catch (ConfigException configException) {}
        Properties persistedProps = configWithSecret.dynamicConfig().toPersistentProps(dynamicProps, true);
        Assertions.assertFalse((boolean)persistedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()).contains("myLoginModule"), (String)"Password not encoded");
        Properties decodedProps = configWithSecret.dynamicConfig().fromPersistentProps(persistedProps, true);
        Assertions.assertEquals((Object)"myLoginModule required;", (Object)decodedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()));
    }

    @Test
    public void testPasswordConfigEncoderSecretChange() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var31_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var32_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var33_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        props.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "staticLoginModule required;");
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "config-encoder-secret");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "dynamicLoginModule required;");
        Properties persistedProps = config.dynamicConfig().toPersistentProps(dynamicProps, true);
        Assertions.assertFalse((boolean)persistedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()).contains("LoginModule"), (String)"Password not encoded");
        config.dynamicConfig().updateBrokerConfig(0, persistedProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)config.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        boolean apply_doLog2 = true;
        KafkaConfig newConfigWithSameSecret = new KafkaConfig((java.util.Map)props, apply_doLog2);
        newConfigWithSameSecret.dynamicConfig().initialize((Option)None$.MODULE$);
        newConfigWithSameSecret.dynamicConfig().updateBrokerConfig(0, persistedProps, newConfigWithSameSecret.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)newConfigWithSameSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "new-encoder-secret");
        props.put(KafkaConfig$.MODULE$.PasswordEncoderOldSecretProp(), "config-encoder-secret");
        boolean apply_doLog3 = true;
        KafkaConfig newConfigWithNewAndOldSecret = new KafkaConfig((java.util.Map)props, apply_doLog3);
        newConfigWithNewAndOldSecret.dynamicConfig().updateBrokerConfig(0, persistedProps, newConfigWithNewAndOldSecret.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)newConfigWithSameSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "another-new-encoder-secret");
        boolean apply_doLog4 = true;
        KafkaConfig newConfigWithNewSecret = new KafkaConfig((java.util.Map)props, apply_doLog4);
        newConfigWithNewSecret.dynamicConfig().updateBrokerConfig(0, persistedProps, newConfigWithNewSecret.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"staticLoginModule required;", (Object)((Password)newConfigWithNewSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
    }

    @Test
    public void testDynamicListenerConfig() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var25_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var26_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var27_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 9092, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        KafkaServer kafkaServer = (KafkaServer)Mockito.mock(KafkaServer.class);
        Mockito.when((Object)kafkaServer.config()).thenReturn((Object)oldConfig);
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://hostname:9092,SASL_PLAINTEXT://hostname:9093");
        boolean apply_doLog = true;
        new DynamicListenerConfig((KafkaBroker)kafkaServer).validateReconfiguration(new KafkaConfig((java.util.Map)props, apply_doLog));
        props.put("listener.name.plaintext.you.should.not.pass", "failure");
        DynamicListenerConfig dynamicListenerConfig = new DynamicListenerConfig((KafkaBroker)kafkaServer);
        Assertions.assertThrows(ConfigException.class, () -> {
            boolean apply_doLog = true;
            dynamicListenerConfig.validateReconfiguration(new KafkaConfig((java.util.Map)props, apply_doLog));
        });
    }

    @Test
    public void testAuthorizerConfig() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var32_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var33_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var34_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 9092, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        oldConfig.dynamicConfig().initialize((Option)None$.MODULE$);
        KafkaServer kafkaServer = (KafkaServer)Mockito.mock(KafkaServer.class);
        Mockito.when((Object)kafkaServer.config()).thenReturn((Object)oldConfig);
        Mockito.when((Object)kafkaServer.kafkaYammerMetrics()).thenReturn((Object)KafkaYammerMetrics.INSTANCE);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)kafkaServer.metrics()).thenReturn((Object)metrics);
        QuotaFactory.QuotaManagers quotaManagers = (QuotaFactory.QuotaManagers)Mockito.mock(QuotaFactory.QuotaManagers.class);
        Mockito.when((Object)quotaManagers.clientQuotaCallback()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)kafkaServer.quotaManagers()).thenReturn((Object)quotaManagers);
        SocketServer socketServer = (SocketServer)Mockito.mock(SocketServer.class);
        Mockito.when((Object)socketServer.reconfigurableConfigs()).thenReturn((Object)SocketServer$.MODULE$.ReconfigurableConfigs());
        Mockito.when((Object)kafkaServer.socketServer()).thenReturn((Object)socketServer);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ProducerStateManagerConfig producerStateManagerConfig = (ProducerStateManagerConfig)Mockito.mock(ProducerStateManagerConfig.class);
        Mockito.when((Object)logManager.producerStateManagerConfig()).thenReturn((Object)producerStateManagerConfig);
        SegmentDeletionThrottlerConfig segmentDeletionThrottlerConfig = (SegmentDeletionThrottlerConfig)Mockito.mock(SegmentDeletionThrottlerConfig.class);
        Mockito.when((Object)segmentDeletionThrottlerConfig.reconfigurableConfigs()).thenReturn((Object)SegmentDeletionThrottlerConfig$.MODULE$.ReconfigurableConfigs());
        Mockito.when((Object)logManager.segmentDeletionThrottlerConfig()).thenReturn((Object)segmentDeletionThrottlerConfig);
        Mockito.when((Object)kafkaServer.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)kafkaServer.httpServer()).thenReturn((Object)None$.MODULE$);
        ZkAdminManager zkAdminManager = (ZkAdminManager)Mockito.mock(ZkAdminManager.class);
        Mockito.when((Object)zkAdminManager.createTopicPolicy()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)kafkaServer.adminManager()).thenReturn((Object)zkAdminManager);
        Mockito.when((Object)kafkaServer.tierDeletedPartitionsCoordinatorOpt()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)kafkaServer.tierFetcherOpt()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)kafkaServer.tierTasksOpt()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)kafkaServer.quotaCoordinatorOpt()).thenReturn((Object)None$.MODULE$);
        KafkaController kafkaController = (KafkaController)Mockito.mock(KafkaController.class);
        Mockito.when((Object)kafkaController.metadataCollector()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)kafkaServer.kafkaController()).thenReturn((Object)kafkaController);
        Mockito.when((Object)kafkaServer.backupObjectLifecycleManagerCoordinatorOpt()).thenReturn((Object)None$.MODULE$);
        TestAuthorizer authorizer = new TestAuthorizer();
        Mockito.when((Object)kafkaServer.authorizer()).thenReturn((Object)new Some((Object)authorizer));
        kafkaServer.config().dynamicConfig().addReconfigurables((KafkaBroker)kafkaServer);
        props.put("super.users", "User:admin");
        kafkaServer.config().dynamicConfig().updateBrokerConfig(0, props, kafkaServer.config().dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"User:admin", (Object)authorizer.superUsers());
    }

    private Properties createCombinedControllerConfig(int nodeId, int port) {
        Properties retval = TestUtils$.MODULE$.createBrokerConfig(nodeId, null, true, true, port, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        retval.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker,controller");
        retval.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
        retval.put(KafkaConfig$.MODULE$.ListenersProp(), new StringBuilder(25).append(retval.get(KafkaConfig$.MODULE$.ListenersProp())).append(",CONTROLLER://localhost:0").toString());
        retval.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(12).append(nodeId).append("@localhost:0").toString());
        return retval;
    }

    @Test
    public void testCombinedControllerAuthorizerConfig() {
        Properties props = this.createCombinedControllerConfig(0, 9092);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        oldConfig.dynamicConfig().initialize((Option)None$.MODULE$);
        ControllerServer controllerServer = (ControllerServer)Mockito.mock(ControllerServer.class);
        Mockito.when((Object)controllerServer.config()).thenReturn((Object)oldConfig);
        Mockito.when((Object)controllerServer.kafkaYammerMetrics()).thenReturn((Object)KafkaYammerMetrics.INSTANCE);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)controllerServer.metrics()).thenReturn((Object)metrics);
        QuotaFactory.QuotaManagers quotaManagers = (QuotaFactory.QuotaManagers)Mockito.mock(QuotaFactory.QuotaManagers.class);
        Mockito.when((Object)quotaManagers.clientQuotaCallback()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)controllerServer.quotaManagers()).thenReturn((Object)quotaManagers);
        SocketServer socketServer = (SocketServer)Mockito.mock(SocketServer.class);
        Mockito.when((Object)socketServer.reconfigurableConfigs()).thenReturn((Object)SocketServer$.MODULE$.ReconfigurableConfigs());
        Mockito.when((Object)controllerServer.socketServer()).thenReturn((Object)socketServer);
        TestAuthorizer authorizer = new TestAuthorizer();
        Mockito.when((Object)controllerServer.authorizer()).thenReturn((Object)new Some((Object)authorizer));
        controllerServer.config().dynamicConfig().addReconfigurables(controllerServer);
        props.put("super.users", "User:admin");
        controllerServer.config().dynamicConfig().updateBrokerConfig(0, props, controllerServer.config().dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"User:admin", (Object)authorizer.superUsers());
    }

    @Test
    public void testMaxConnectionsPerTenantConfig() {
        Properties props = this.createCombinedControllerConfig(0, 9092);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        oldConfig.dynamicConfig().initialize((Option)None$.MODULE$);
        ControllerServer controllerServer = (ControllerServer)Mockito.mock(ControllerServer.class);
        Mockito.when((Object)controllerServer.config()).thenReturn((Object)oldConfig);
        Mockito.when((Object)controllerServer.kafkaYammerMetrics()).thenReturn((Object)KafkaYammerMetrics.INSTANCE);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)controllerServer.metrics()).thenReturn((Object)metrics);
        QuotaFactory.QuotaManagers quotaManagers = (QuotaFactory.QuotaManagers)Mockito.mock(QuotaFactory.QuotaManagers.class);
        Mockito.when((Object)quotaManagers.clientQuotaCallback()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)controllerServer.quotaManagers()).thenReturn((Object)quotaManagers);
        SocketServer socketServer = (SocketServer)Mockito.mock(SocketServer.class);
        Mockito.when((Object)socketServer.reconfigurableConfigs()).thenReturn((Object)SocketServer$.MODULE$.ReconfigurableConfigs());
        Mockito.when((Object)controllerServer.socketServer()).thenReturn((Object)socketServer);
        TestAuthorizer authorizer = new TestAuthorizer();
        Mockito.when((Object)controllerServer.authorizer()).thenReturn((Object)new Some((Object)authorizer));
        controllerServer.config().dynamicConfig().addReconfigurables(controllerServer);
        props.put("confluent.tenant.connection.creation.rate.map", "lkc-1234:35,default:20");
        controllerServer.config().dynamicConfig().updateBrokerConfig(0, props, controllerServer.config().dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((double)35.0, (double)BoxesRunTime.unboxToDouble((Object)controllerServer.config().tenantConnectionRateMap().get((Object)"lkc-1234").get()));
    }

    private Properties createIsolatedControllerConfig(int nodeId, int port) {
        Properties retval = TestUtils$.MODULE$.createBrokerConfig(nodeId, null, true, true, port, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        retval.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
        retval.remove(KafkaConfig$.MODULE$.AdvertisedListenersProp());
        retval.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
        retval.put(KafkaConfig$.MODULE$.ListenersProp(), "CONTROLLER://localhost:0");
        retval.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(12).append(nodeId).append("@localhost:0").toString());
        return retval;
    }

    @Test
    public void testIsolatedControllerAuthorizerConfig() {
        Properties props = this.createIsolatedControllerConfig(0, 9092);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        oldConfig.dynamicConfig().initialize((Option)None$.MODULE$);
        ControllerServer controllerServer = (ControllerServer)Mockito.mock(ControllerServer.class);
        Mockito.when((Object)controllerServer.config()).thenReturn((Object)oldConfig);
        Mockito.when((Object)controllerServer.kafkaYammerMetrics()).thenReturn((Object)KafkaYammerMetrics.INSTANCE);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)controllerServer.metrics()).thenReturn((Object)metrics);
        QuotaFactory.QuotaManagers quotaManagers = (QuotaFactory.QuotaManagers)Mockito.mock(QuotaFactory.QuotaManagers.class);
        Mockito.when((Object)quotaManagers.clientQuotaCallback()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)controllerServer.quotaManagers()).thenReturn((Object)quotaManagers);
        SocketServer socketServer = (SocketServer)Mockito.mock(SocketServer.class);
        Mockito.when((Object)socketServer.reconfigurableConfigs()).thenReturn((Object)SocketServer$.MODULE$.ReconfigurableConfigs());
        ApiVersionManager apiVersionManager = (ApiVersionManager)Mockito.mock(ApiVersionManager.class);
        Mockito.when((Object)apiVersionManager.listenerType()).thenReturn((Object)ApiMessageType.ListenerType.CONTROLLER);
        Mockito.when((Object)socketServer.apiVersionManager()).thenReturn((Object)apiVersionManager);
        Mockito.when((Object)controllerServer.socketServer()).thenReturn((Object)socketServer);
        TestAuthorizer authorizer = new TestAuthorizer();
        Mockito.when((Object)controllerServer.authorizer()).thenReturn((Object)new Some((Object)authorizer));
        controllerServer.config().dynamicConfig().addReconfigurables(controllerServer);
        props.put("super.users", "User:admin");
        controllerServer.config().dynamicConfig().updateBrokerConfig(0, props, controllerServer.config().dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"User:admin", (Object)authorizer.superUsers());
    }

    @Test
    public void testHttpServerConfig() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var24_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var25_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var26_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 9092, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        oldConfig.dynamicConfig().initialize((Option)None$.MODULE$);
        KafkaServer kafkaServer = (KafkaServer)Mockito.mock(KafkaServer.class);
        public class Kafka_server_DynamicBrokerConfigTest$TestKafkaHttpServer$1
        implements KafkaHttpServer,
        Reconfigurable {
            private volatile String foobar;

            public boolean isNew() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public boolean isStarting() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public boolean isRunning() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public boolean isStopping() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public boolean isTerminated() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public boolean isFailed() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public void start() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public void stop() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public Optional<Throwable> getError() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public void awaitStarted() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public boolean awaitStarted(Duration timeout) {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public void awaitStopped() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public boolean awaitStopped(Duration timeout) {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public String foobar() {
                return this.foobar;
            }

            public void foobar_$eq(String x$1) {
                this.foobar = x$1;
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return CollectionConverters$.MODULE$.SetHasAsJava((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo.bar"}))).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
                this.foobar_$eq(configs.get("foo.bar").toString());
            }

            public void configure(java.util.Map<String, ?> configs) {
            }

            public Kafka_server_DynamicBrokerConfigTest$TestKafkaHttpServer$1(DynamicBrokerConfigTest $outer) {
                this.foobar = "";
            }
        }
        Kafka_server_DynamicBrokerConfigTest$TestKafkaHttpServer$1 httpServer = new Kafka_server_DynamicBrokerConfigTest$TestKafkaHttpServer$1(null);
        Mockito.when((Object)kafkaServer.config()).thenReturn((Object)oldConfig);
        Mockito.when((Object)kafkaServer.authorizer()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)kafkaServer.httpServer()).thenReturn((Object)new Some((Object)httpServer));
        try {
            kafkaServer.config().dynamicConfig().addReconfigurables((KafkaBroker)kafkaServer);
        }
        catch (Throwable throwable) {}
        props.put("foo.bar", "fozbaz");
        kafkaServer.config().dynamicConfig().updateBrokerConfig(0, props, kafkaServer.config().dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"fozbaz", (Object)httpServer.foobar());
    }

    @Test
    public void testSynonyms() {
        Assertions.assertEquals((Object)new .colon.colon((Object)"listener.name.secure.ssl.keystore.type", (List)new .colon.colon((Object)"ssl.keystore.type", (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("listener.name.secure.ssl.keystore.type", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)"listener.name.sasl_ssl.plain.sasl.jaas.config", (List)new .colon.colon((Object)"sasl.jaas.config", (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("listener.name.sasl_ssl.plain.sasl.jaas.config", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)"some.config", (List)Nil$.MODULE$), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("some.config", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)KafkaConfig$.MODULE$.LogRollTimeMillisProp(), (List)new .colon.colon((Object)KafkaConfig$.MODULE$.LogRollTimeHoursProp(), (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(KafkaConfig$.MODULE$.LogRollTimeMillisProp(), true));
    }

    @Test
    public void testDynamicConfigInitializationWithoutConfigsInZK() {
        KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        Mockito.when((Object)zkClient.getEntityConfigs(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)new Properties());
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var25_10 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var26_13 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var27_16 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties initialProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 9092, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        initialProps.remove(KafkaConfig$.MODULE$.BackgroundThreadsProp());
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(initialProps);
        DynamicBrokerConfig dynamicBrokerConfig = new DynamicBrokerConfig(oldConfig);
        dynamicBrokerConfig.initialize((Option)new Some((Object)zkClient));
        dynamicBrokerConfig.addBrokerReconfigurable((BrokerReconfigurable)new TestDynamicThreadPool());
        Properties newprops = new Properties();
        newprops.put(KafkaConfig$.MODULE$.NumIoThreadsProp(), "10");
        newprops.put(KafkaConfig$.MODULE$.BackgroundThreadsProp(), "100");
        dynamicBrokerConfig.updateBrokerConfig(0, newprops, dynamicBrokerConfig.updateBrokerConfig$default$3());
    }

    @Test
    public void testConfiguredInstanceInitializedWithDynamicConfig() {
        String quotaProp = "quota";
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var26_10 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var27_13 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var28_16 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        props.put(quotaProp, "static_quota");
        props.put(KafkaConfig$.MODULE$.ClientQuotaCallbackClassProp(), TestQuotaCallback.class.getName());
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Properties updatedProps = new Properties();
        updatedProps.put(quotaProp, "dynamic_quota");
        config.dynamicConfig().updateDefaultConfig(updatedProps, config.dynamicConfig().updateDefaultConfig$default$2());
        ClientQuotaCallback quotaCallback = (ClientQuotaCallback)config.getConfiguredInstance(KafkaConfig$.MODULE$.ClientQuotaCallbackClassProp(), ClientQuotaCallback.class);
        Assertions.assertEquals((Object)"dynamic_quota", (Object)((TestQuotaCallback)quotaCallback).defaultQuota());
    }

    @Test
    public void testReplicaManagerFetchMaxBytesChange() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var25_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var26_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var27_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        props.put(KafkaConfig$.MODULE$.FetchMaxBytes(), "1024");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.FetchMaxBytes(), "2048");
        Properties persistedProps = config.dynamicConfig().toPersistentProps(dynamicProps, true);
        config.dynamicConfig().updateBrokerConfig(0, persistedProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)2048), config.values().get(KafkaConfig$.MODULE$.FetchMaxBytes()));
    }

    @Test
    public void testDynamicProducerAcksOverride() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var25_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var26_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var27_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        props.put(KafkaConfig$.MODULE$.ProducerMinAcksProp(), "0");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.ProducerMinAcksProp(), "-1");
        Properties persistedProps = config.dynamicConfig().toPersistentProps(dynamicProps, true);
        config.dynamicConfig().updateBrokerConfig(0, persistedProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)BoxesRunTime.boxToShort((short)-1), config.values().get(KafkaConfig$.MODULE$.ProducerMinAcksProp()));
    }

    @Test
    public void testReplicaManagerTierMaxPartitionFetchBytesOverride() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var25_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var26_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var27_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        props.put(KafkaConfig$.MODULE$.TierMaxPartitionFetchBytesOverrideProp(), "1024000");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.TierMaxPartitionFetchBytesOverrideProp(), "2048000");
        Properties persistedProps = config.dynamicConfig().toPersistentProps(dynamicProps, true);
        config.dynamicConfig().updateBrokerConfig(0, persistedProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)2048000), config.values().get(KafkaConfig$.MODULE$.TierMaxPartitionFetchBytesOverrideProp()));
    }

    @Test
    public void testImproperConfigsAreRemoved() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Assertions.assertEquals((int)Defaults$.MODULE$.MaxConnections(), (Integer)config.maxConnections());
        Assertions.assertEquals((int)0x10000C, (Integer)config.messageMaxBytes());
        Properties newProps = new Properties();
        newProps.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), "9999");
        newProps.put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), "2222");
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)9999, (Integer)config.maxConnections());
        Assertions.assertEquals((int)2222, (Integer)config.messageMaxBytes());
        newProps = new Properties();
        newProps.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), "INVALID_INT");
        newProps.put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), "1111");
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)Defaults$.MODULE$.MaxConnections(), (Integer)config.maxConnections());
        Assertions.assertEquals((int)1111, (Integer)config.messageMaxBytes());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClientJaasConfig() {
        void var3_3;
        Properties props = this.kafkaPropsWithDynamicLogin("test.dynamic.login.username", "test.dynamic.login.password", this.kafkaPropsWithDynamicLogin$default$3());
        Tuple2<KafkaConfig, DynamicLoginManager> tuple2 = this.createKafkaConfigWithDynamicLogin(props);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        DynamicLoginManager dynamicLogin = (DynamicLoginManager)tuple2._2();
        Assertions.assertFalse((boolean)var3_3.isClientSaslJaasConfig("sasl.jaas.config"));
        Assertions.assertFalse((boolean)var3_3.isClientSaslJaasConfig("listener.name.sasl_ssl.sasl.jaas.config"));
        Assertions.assertTrue((boolean)var3_3.isClientSaslJaasConfig("test.dynamic.login.sasl.jaas.config"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLoginConfigChange() {
        void var3_3;
        Properties props = this.kafkaPropsWithDynamicLogin("test.dynamic.login.username", "test.dynamic.login.password", this.kafkaPropsWithDynamicLogin$default$3());
        Tuple2<KafkaConfig, DynamicLoginManager> tuple2 = this.createKafkaConfigWithDynamicLogin(props);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        DynamicLoginManager dynamicLogin = (DynamicLoginManager)tuple2._2();
        DynamicLoginContext context = (DynamicLoginContext)var3_3.reconfigurableContexts().head();
        HashMap<String, String> oldConfigs = new HashMap<String, String>();
        HashMap<String, String> newConfigs = new HashMap<String, String>();
        oldConfigs.put("test.dynamic.login.username", "alice");
        oldConfigs.put("test.dynamic.login.password", "alice-password");
        newConfigs.put("test.dynamic.login.username", "alice");
        newConfigs.put("test.dynamic.login.password", "alice-password");
        Assertions.assertFalse((boolean)context.needsReconfigure(oldConfigs, newConfigs));
        Assertions.assertFalse((boolean)context.needsReconfigure(Collections.emptyMap(), Collections.emptyMap()));
        Assertions.assertTrue((boolean)context.needsReconfigure(Collections.emptyMap(), newConfigs));
        Assertions.assertTrue((boolean)context.needsReconfigure(oldConfigs, Collections.emptyMap()));
        newConfigs.put("test.dynamic.login.password", "alice-new-password");
        Assertions.assertTrue((boolean)context.needsReconfigure(oldConfigs, newConfigs));
        newConfigs.put("test.dynamic.login.username", "bob");
        newConfigs.put("test.dynamic.login.password", "bob-password");
        Assertions.assertTrue((boolean)context.needsReconfigure(oldConfigs, newConfigs));
        Assertions.assertTrue((boolean)context.needsReconfigure(oldConfigs, Collections.singletonMap("test.dynamic.login.username", "alice")));
        Assertions.assertTrue((boolean)context.needsReconfigure(Collections.singletonMap("test.dynamic.login.username", "alice"), newConfigs));
    }

    @Test
    public void testSaslCredentialRotationWithPrefixedCredentials() {
        this.verifyCredentialRotation("test.dynamic.login.username", "test.dynamic.login.password");
    }

    @Test
    public void testSaslCredentialRotationWithUnprefixedCredentials() {
        this.verifyCredentialRotation("login.username", "login.password");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSaslCredentialRotationWithSharedJaasConfig() {
        void var6_6;
        void var7_7;
        String usernameConfig = "login.username";
        String passwordConfig = "login.password";
        Set pluginPrefixes = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test.plugin1.", "test.plugin2."}));
        Properties props = this.kafkaPropsWithDynamicLogin(usernameConfig, passwordConfig, (Set<String>)pluginPrefixes);
        Tuple2<KafkaConfig, DynamicLoginManager> tuple2 = this.createKafkaConfigWithDynamicLogin(props);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KafkaConfig config = (KafkaConfig)tuple2._1();
        DynamicLoginManager dynamicLogin = (DynamicLoginManager)tuple2._2();
        Set credentialConfigs = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{usernameConfig, passwordConfig}));
        Assertions.assertEquals((Object)credentialConfigs, (Object)var7_7.reconfigurableConfigNames().toSet());
        Assertions.assertEquals((int)2, (int)var7_7.reconfigurableContexts().size());
        scala.collection.mutable.Set contexts = var7_7.reconfigurableContexts();
        Assertions.assertEquals((Object)pluginPrefixes, (Object)((IterableOnceOps)contexts.map((Function1 & Serializable)x$3 -> x$3.prefix())).toSet());
        Assertions.assertEquals((Object)pluginPrefixes.map((Function1 & Serializable)x$4 -> new StringBuilder(16).append((String)x$4).append("sasl.jaas.config").toString()), (Object)contexts.map((Function1 & Serializable)x$5 -> x$5.saslJaasConfigName()));
        contexts.foreach((Function1 & Serializable)context -> {
            DynamicBrokerConfigTest.$anonfun$testSaslCredentialRotationWithSharedJaasConfig$4(this, credentialConfigs, context);
            return BoxedUnit.UNIT;
        });
        Properties dynamicProps = new Properties();
        dynamicProps.setProperty(usernameConfig, "alice");
        dynamicProps.setProperty(passwordConfig, "alice-new-password");
        DynamicBrokerConfigTest.updateConfig$2((KafkaConfig)var6_6, dynamicProps);
        contexts.foreach((Function1 & Serializable)context -> {
            this.verifyCredential(context, "alice", "alice-new-password");
            return BoxedUnit.UNIT;
        });
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> DynamicBrokerConfigTest.$anonfun$testSaslCredentialRotationWithSharedJaasConfig$6(this, dynamicProps, usernameConfig, passwordConfig, contexts, (KafkaConfig)var6_6, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNewSaslCredentials() {
        void var3_3;
        void var4_4;
        Properties props = this.kafkaPropsWithDynamicLogin("test.dynamic.login.username", "test.dynamic.login.password", this.kafkaPropsWithDynamicLogin$default$3());
        Tuple2<KafkaConfig, DynamicLoginManager> tuple2 = this.createKafkaConfigWithDynamicLogin(props);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KafkaConfig config = (KafkaConfig)tuple2._1();
        DynamicLoginManager dynamicLogin = (DynamicLoginManager)tuple2._2();
        this.verifyCredential((DynamicLoginContext)var4_4.reconfigurableContexts().head(), "alice", "alice-password");
        Properties dynamicProps = new Properties();
        dynamicProps.setProperty("test.another.login.security.protocol", "SASL_PLAINTEXT");
        dynamicProps.setProperty("test.another.login.sasl.mechanism", "PLAIN");
        dynamicProps.setProperty("test.another.login.username", "another");
        dynamicProps.setProperty(new StringBuilder(35).append("test.another.login.").append("sasl.jaas.config").toString(), new StringBuilder(64).append(DynamicPlainLoginModule.class.getName()).append(" required username_config=\"username\" password_config=\"password\";").toString());
        dynamicProps.setProperty(new StringBuilder(52).append("test.another.login.").append("sasl.login.callback.handler.class").toString(), DynamicPlainLoginCallbackHandler.class.getName());
        dynamicProps.setProperty("test.another.login.password", "another-password");
        DynamicBrokerConfigTest.updateConfig$3((KafkaConfig)var3_3, dynamicProps);
        Assertions.assertEquals((int)2, (int)var4_4.reconfigurableContexts().size());
        DynamicLoginContext oldContext = (DynamicLoginContext)((IterableOps)var4_4.reconfigurableContexts().filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfigTest.$anonfun$testNewSaslCredentials$1(x$8)))).head();
        this.verifyCredential(oldContext, "alice", "alice-password");
        DynamicLoginContext newContext = (DynamicLoginContext)((IterableOps)var4_4.reconfigurableContexts().filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfigTest.$anonfun$testNewSaslCredentials$2(x$9)))).head();
        this.verifyCredential(newContext, "another", "another-password");
        dynamicProps.remove("test.another.login.password");
        Assertions$.MODULE$.intercept((Function0)((JFunction0.mcV.sp & Serializable)() -> DynamicBrokerConfigTest.$anonfun$testNewSaslCredentials$3((KafkaConfig)var3_3, dynamicProps)), ClassTag$.MODULE$.apply(ConfigException.class), new Position("DynamicBrokerConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1229));
    }

    /*
     * WARNING - void declaration
     */
    private void verifyCredentialRotation(String usernameConfig, String passwordConfig) {
        void var5_5;
        void var6_6;
        Properties props = this.kafkaPropsWithDynamicLogin(usernameConfig, passwordConfig, this.kafkaPropsWithDynamicLogin$default$3());
        props.setProperty("test.static.login.security.protocol", "SASL_SSL");
        props.setProperty("test.static.login.sasl.mechanism", "PLAIN");
        props.setProperty(new StringBuilder(34).append("test.static.login.").append("sasl.jaas.config").toString(), new StringBuilder(55).append(PlainLoginModule.class.getName()).append(" required username=\"static\" password=\"static-password\";").toString());
        Tuple2<KafkaConfig, DynamicLoginManager> tuple2 = this.createKafkaConfigWithDynamicLogin(props);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KafkaConfig config = (KafkaConfig)tuple2._1();
        DynamicLoginManager dynamicLogin = (DynamicLoginManager)tuple2._2();
        Set credentialConfigs = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{usernameConfig, passwordConfig}));
        Assertions.assertEquals((Object)credentialConfigs, (Object)var6_6.reconfigurableConfigNames().toSet());
        Assertions.assertEquals((int)1, (int)var6_6.reconfigurableContexts().size());
        DynamicLoginContext context = (DynamicLoginContext)var6_6.reconfigurableContexts().head();
        Assertions.assertEquals((Object)"test.dynamic.login.", (Object)context.prefix());
        Assertions.assertEquals((Object)"test.dynamic.login.sasl.jaas.config", (Object)context.saslJaasConfigName());
        Assertions.assertEquals((Object)credentialConfigs, (Object)context.dynamicConfigs());
        this.verifyCredential(context, "alice", "alice-password");
        Properties dynamicProps = new Properties();
        dynamicProps.setProperty(usernameConfig, "alice");
        dynamicProps.setProperty(passwordConfig, "alice-new-password");
        DynamicBrokerConfigTest.updateConfig$4((KafkaConfig)var5_5, dynamicProps);
        this.verifyCredential(context, "alice", "alice-new-password");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> DynamicBrokerConfigTest.$anonfun$verifyCredentialRotation$1(this, dynamicProps, usernameConfig, passwordConfig, context, (KafkaConfig)var5_5, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFileBasedLoginNotHandledAsDynamicConfig() {
        void var3_3;
        Properties props = this.kafkaPropsWithDynamicLogin("test.dynamic.login.username", "test.dynamic.login.password", this.kafkaPropsWithDynamicLogin$default$3());
        props.setProperty(new StringBuilder(35).append("test.dynamic.login.").append("sasl.jaas.config").toString(), new StringBuilder(50).append(DynamicPlainLoginModule.class.getName()).append(" required credentials_path=\"/tmp/credentials.txt\";").toString());
        props.setProperty(new StringBuilder(52).append("test.dynamic.login.").append("sasl.login.callback.handler.class").toString(), FileBasedDynamicPlainLoginCallbackHandler.class.getName());
        Tuple2<KafkaConfig, DynamicLoginManager> tuple2 = this.createKafkaConfigWithDynamicLogin(props);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        DynamicLoginManager dynamicLogin = (DynamicLoginManager)tuple2._2();
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), (Object)var3_3.reconfigurableContexts());
    }

    private Properties kafkaPropsWithDynamicLogin(String usernameConfig, String passwordConfig, Set<String> pluginPrefixes) {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var24_12 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var25_15 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var26_18 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        props.setProperty(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "encoder-secret");
        props.setProperty(usernameConfig, "alice");
        props.setProperty(passwordConfig, "alice-password");
        pluginPrefixes.foreach((Function1 & Serializable)prefix -> {
            props.setProperty(new StringBuilder(17).append((String)prefix).append("security.protocol").toString(), "SASL_SSL");
            props.setProperty(new StringBuilder(14).append((String)prefix).append("sasl.mechanism").toString(), "PLAIN");
            props.setProperty(new StringBuilder(16).append((String)prefix).append("sasl.jaas.config").toString(), new StringBuilder(48).append(DynamicPlainLoginModule.class.getName()).append(" required username_config=\"").append(usernameConfig).append("\" password_config=\"").append(passwordConfig).append("\";").toString());
            return props.setProperty(new StringBuilder(33).append((String)prefix).append("sasl.login.callback.handler.class").toString(), DynamicPlainLoginCallbackHandler.class.getName());
        });
        return props;
    }

    private Set<String> kafkaPropsWithDynamicLogin$default$3() {
        return (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test.dynamic.login."}));
    }

    private Tuple2<KafkaConfig, DynamicLoginManager> createKafkaConfigWithDynamicLogin(Properties props) {
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        Mockito.when((Object)zkClient.getEntityConfigs(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)new Properties());
        config.dynamicConfig().initialize((Option)new Some((Object)zkClient));
        return new Tuple2((Object)config, (Object)config.dynamicConfig().dynamicLoginManager());
    }

    private void verifyCredential(DynamicLoginContext context, String username, String password) {
        Assertions.assertEquals((Object)new DynamicPlainCredential(username, password.toCharArray()), (Object)context.loginManager().subject().getPrivateCredentials().iterator().next());
    }

    public void testUpdateMetricReporters() {
        int brokerId = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var29_10 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var30_13 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var31_16 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(brokerId, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        SocketServer socketServerMock = (SocketServer)Mockito.mock(SocketServer.class);
        Mockito.when((Object)serverMock.socketServer()).thenReturn((Object)socketServerMock);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        DynamicMetricsReporters m = new DynamicMetricsReporters(brokerId, config, metrics, "clusterId", socketServerMock);
        config.dynamicConfig().addReconfigurable((Reconfigurable)m);
        Assertions.assertEquals((int)1, (int)m.currentReporters().size());
        Assertions.assertEquals((Object)JmxReporter.class.getName(), (Object)m.currentReporters().keySet().head());
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.MetricReporterClassesProp(), MockMetricsReporter.class.getName());
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)2, (int)m.currentReporters().size());
        Assertions.assertEquals((Object)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{JmxReporter.class.getName(), MockMetricsReporter.class.getName()})), (Object)m.currentReporters().keySet());
    }

    @Test
    public void testUpdateMetricReportersNoJmxReporter() {
        int brokerId = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var29_10 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var30_13 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var31_16 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(brokerId, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put(KafkaConfig$.MODULE$.AutoIncludeJmxReporterProp(), "false");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        SocketServer socketServerMock = (SocketServer)Mockito.mock(SocketServer.class);
        Mockito.when((Object)serverMock.socketServer()).thenReturn((Object)socketServerMock);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        DynamicMetricsReporters m = new DynamicMetricsReporters(brokerId, config, metrics, "clusterId", socketServerMock);
        config.dynamicConfig().addReconfigurable((Reconfigurable)m);
        Assertions.assertTrue((boolean)m.currentReporters().isEmpty());
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.MetricReporterClassesProp(), MockMetricsReporter.class.getName());
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)1, (int)m.currentReporters().size());
        Assertions.assertEquals((Object)MockMetricsReporter.class.getName(), (Object)m.currentReporters().keySet().head());
        props.remove(KafkaConfig$.MODULE$.MetricReporterClassesProp());
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertTrue((boolean)m.currentReporters().isEmpty());
    }

    @Test
    public void testNonInternalValuesDoesNotExposeInternalConfigs() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        props.put(KafkaConfig$.MODULE$.MetadataLogSegmentMinBytesProp(), "1024");
        KafkaConfig config = new KafkaConfig((java.util.Map)props);
        Assertions.assertFalse((boolean)config.nonInternalValues().containsKey(KafkaConfig$.MODULE$.MetadataLogSegmentMinBytesProp()));
        config.updateCurrentConfig(new KafkaConfig((java.util.Map)props));
        Assertions.assertFalse((boolean)config.nonInternalValues().containsKey(KafkaConfig$.MODULE$.MetadataLogSegmentMinBytesProp()));
    }

    public static final void kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(java.util.Map configs) {
        int cleanerThreads = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(configs.get(KafkaConfig$.MODULE$.LogCleanerThreadsProp()).toString()));
        if (cleanerThreads <= 0 || cleanerThreads >= 5) {
            throw new ConfigException(new StringBuilder(24).append("Invalid cleaner threads ").append(cleanerThreads).toString());
        }
    }

    private static final Reconfigurable createReconfigurable$1(Set configs) {
        return new /* invalid duplicate definition of identical inner class */;
    }

    private static final BrokerReconfigurable createBrokerReconfigurable$1(Set configs) {
        return new /* invalid duplicate definition of identical inner class */;
    }

    private final void verifyUpdate$1(String name, Object value) {
        this.verifyConfigUpdate(name, value, true, true);
        this.verifyConfigUpdate(new StringBuilder(23).append("listener.name.external.").append(name).toString(), value, true, false);
        this.verifyConfigUpdate(name, value, false, true);
        this.verifyConfigUpdate(new StringBuilder(23).append("listener.name.external.").append(name).toString(), value, false, true);
    }

    public static final /* synthetic */ void $anonfun$testTierDeletedPartitionsCoordinatorConfig$1(DynamicBrokerConfigTest $this, String config) {
        $this.verifyConfigUpdate(config, "-1", true, true);
        $this.verifyConfigUpdate(config, "-1", false, true);
        $this.verifyConfigUpdate(config, "0", true, true);
        $this.verifyConfigUpdate(config, "0", false, true);
        $this.verifyConfigUpdate(config, "10000", false, false);
        $this.verifyConfigUpdate(config, "20000", true, false);
    }

    private static final void updateConfig$1(boolean perBrokerConfig$1, KafkaConfig config$5, Properties props$3) {
        if (perBrokerConfig$1) {
            config$5.dynamicConfig().updateBrokerConfig(0, config$5.dynamicConfig().toPersistentProps(props$3, perBrokerConfig$1), config$5.dynamicConfig().updateBrokerConfig$default$3());
            return;
        }
        config$5.dynamicConfig().updateDefaultConfig(props$3, config$5.dynamicConfig().updateDefaultConfig$default$2());
    }

    public static final /* synthetic */ void $anonfun$verifyConfigUpdateWithInvalidConfig$4(KafkaConfig config$6, Tuple2 x0$3) {
        if (x0$3 != null) {
            String name = (String)x0$3._1();
            Assertions.assertEquals((Object)((String)x0$3._2()), config$6.originals().get(name));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyConfigUpdateWithInvalidConfig$5(Properties origProps$1, KafkaConfig config$6, String name) {
        Assertions.assertEquals((Object)origProps$1.get(name), config$6.originals().get(name));
    }

    public static final /* synthetic */ void $anonfun$testSaslCredentialRotationWithSharedJaasConfig$4(DynamicBrokerConfigTest $this, Set credentialConfigs$1, DynamicLoginContext context) {
        Assertions.assertEquals((Object)credentialConfigs$1, (Object)context.dynamicConfigs());
        $this.verifyCredential(context, "alice", "alice-password");
    }

    private static final void updateConfig$2(KafkaConfig config$7, Properties dynamicProps$1) {
        config$7.dynamicConfig().updateBrokerConfig(0, config$7.dynamicConfig().toPersistentProps(dynamicProps$1, true), config$7.dynamicConfig().updateBrokerConfig$default$3());
    }

    public static final /* synthetic */ void $anonfun$testSaslCredentialRotationWithSharedJaasConfig$6(DynamicBrokerConfigTest $this, Properties dynamicProps$1, String usernameConfig$1, String passwordConfig$1, scala.collection.mutable.Set contexts$1, KafkaConfig config$7, int x$6) {
        dynamicProps$1.setProperty(usernameConfig$1, "bob");
        dynamicProps$1.setProperty(passwordConfig$1, "bob-password");
        DynamicBrokerConfigTest.updateConfig$2(config$7, dynamicProps$1);
        contexts$1.foreach((Function1 & Serializable)context -> {
            $this.verifyCredential(context, "bob", "bob-password");
            return BoxedUnit.UNIT;
        });
    }

    private static final void updateConfig$3(KafkaConfig config$8, Properties dynamicProps$2) {
        config$8.dynamicConfig().updateBrokerConfig(0, config$8.dynamicConfig().toPersistentProps(dynamicProps$2, true), config$8.dynamicConfig().updateBrokerConfig$default$3());
    }

    public static final /* synthetic */ boolean $anonfun$testNewSaslCredentials$1(DynamicLoginContext x$8) {
        String string = x$8.saslJaasConfigName();
        String string2 = "test.dynamic.login.sasl.jaas.config";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testNewSaslCredentials$2(DynamicLoginContext x$9) {
        String string = x$9.saslJaasConfigName();
        String string2 = "test.another.login.sasl.jaas.config";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$testNewSaslCredentials$3(KafkaConfig config$8, Properties dynamicProps$2) {
        config$8.dynamicConfig().validate(dynamicProps$2, true);
    }

    private static final void updateConfig$4(KafkaConfig config$9, Properties dynamicProps$3) {
        config$9.dynamicConfig().updateBrokerConfig(0, config$9.dynamicConfig().toPersistentProps(dynamicProps$3, true), config$9.dynamicConfig().updateBrokerConfig$default$3());
    }

    public static final /* synthetic */ void $anonfun$verifyCredentialRotation$1(DynamicBrokerConfigTest $this, Properties dynamicProps$3, String usernameConfig$2, String passwordConfig$2, DynamicLoginContext context$1, KafkaConfig config$9, int x$11) {
        dynamicProps$3.setProperty(usernameConfig$2, "bob");
        dynamicProps$3.setProperty(passwordConfig$2, "bob-password");
        DynamicBrokerConfigTest.updateConfig$4(config$9, dynamicProps$3);
        $this.verifyCredential(context$1, "bob", "bob-password");
    }

    public class TestAuthorizer
    implements Authorizer,
    Reconfigurable {
        private volatile String superUsers;

        public java.util.List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext x$1, java.util.List<AclBinding> x$2, Optional<String> x$3) {
            return super.createAcls(x$1, x$2, x$3);
        }

        public java.util.List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext x$1, java.util.List<AclBindingFilter> x$2, Optional<String> x$3, AclState x$4) {
            return super.deleteAcls(x$1, x$2, x$3, x$4);
        }

        public Iterable<AclBinding> acls(AclBindingFilter x$1, AclState x$2) {
            return super.acls(x$1, x$2);
        }

        public int aclCount() {
            return super.aclCount();
        }

        public AuthorizationResult authorizeByResourceType(AuthorizableRequestContext x$1, AclOperation x$2, ResourceType x$3) {
            return super.authorizeByResourceType(x$1, x$2, x$3);
        }

        public void registerAclUpdateListener(AclUpdateListener x$1) {
            super.registerAclUpdateListener(x$1);
        }

        public String superUsers() {
            return this.superUsers;
        }

        public void superUsers_$eq(String x$1) {
            this.superUsers = x$1;
        }

        public java.util.Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
            return CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.empty()).asJava();
        }

        public java.util.List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, java.util.List<Action> actions) {
            return null;
        }

        public java.util.List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, java.util.List<AclBinding> aclBindings) {
            return null;
        }

        public java.util.List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, java.util.List<AclBindingFilter> aclBindingFilters) {
            return null;
        }

        public Iterable<AclBinding> acls(AclBindingFilter filter) {
            return null;
        }

        public void close() {
        }

        public void configure(java.util.Map<String, ?> configs) {
        }

        public java.util.Set<String> reconfigurableConfigs() {
            return CollectionConverters$.MODULE$.SetHasAsJava((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"super.users"}))).asJava();
        }

        public void validateReconfiguration(java.util.Map<String, ?> configs) {
        }

        public void reconfigure(java.util.Map<String, ?> configs) {
            this.superUsers_$eq(configs.get("super.users").toString());
        }

        public /* synthetic */ DynamicBrokerConfigTest kafka$server$DynamicBrokerConfigTest$TestAuthorizer$$$outer() {
            return DynamicBrokerConfigTest.this;
        }

        public TestAuthorizer() {
            if (DynamicBrokerConfigTest.this == null) {
                throw null;
            }
            this.superUsers = "";
        }
    }
}

