/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.server.BaseClientQuotaManagerTest;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ControllerMutationQuotaManager;
import kafka.server.ControllerMutationQuotaManager$;
import kafka.server.PermissiveControllerMutationQuota;
import kafka.server.StrictControllerMutationQuota;
import kafka.server.UnboundedControllerMutationQuota$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.TokenBucket;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005e3Aa\u0004\t\u0001+!)!\u0004\u0001C\u00017!9Q\u0004\u0001b\u0001\n\u0013q\u0002BB\u0014\u0001A\u0003%q\u0004C\u0004)\u0001\t\u0007I\u0011\u0002\u0010\t\r%\u0002\u0001\u0015!\u0003 \u0011\u001dQ\u0003A1A\u0005\n-Baa\f\u0001!\u0002\u0013a\u0003\"\u0002\u0019\u0001\t\u0013\t\u0004\"\u0002!\u0001\t\u0003\t\u0005\"B(\u0001\t\u0003\t\u0005\"B)\u0001\t\u0003\t\u0005\"B*\u0001\t\u0003\t\u0005\"B+\u0001\t\u0003\t\u0005\"B,\u0001\t\u0003\t%AI\"p]R\u0014x\u000e\u001c7fe6+H/\u0019;j_:\fVo\u001c;b\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002\u0012%\u000511/\u001a:wKJT\u0011aE\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\u0003\u0005\u0002\u001815\t\u0001#\u0003\u0002\u001a!\tQ\")Y:f\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'\u000fV3ti\u00061A(\u001b8jiz\"\u0012\u0001\b\t\u0003/\u0001\tA!V:feV\tq\u0004\u0005\u0002!K5\t\u0011E\u0003\u0002#G\u0005!A.\u00198h\u0015\u0005!\u0013\u0001\u00026bm\u0006L!AJ\u0011\u0003\rM#(/\u001b8h\u0003\u0015)6/\u001a:!\u0003!\u0019E.[3oi&#\u0017!C\"mS\u0016tG/\u00133!\u0003\u0019\u0019wN\u001c4jOV\tA\u0006\u0005\u0002\u0018[%\u0011a\u0006\u0005\u0002\u0019\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'oQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\u0011o&$\b.U;pi\u0006l\u0015M\\1hKJ$\"A\r\u001d\u0011\u0005M2T\"\u0001\u001b\u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0003\tUs\u0017\u000e\u001e\u0005\u0006s!\u0001\rAO\u0001\u0002MB!1gO\u001f3\u0013\taDGA\u0005Gk:\u001cG/[8ocA\u0011qCP\u0005\u0003\u007fA\u0011adQ8oiJ|G\u000e\\3s\u001bV$\u0018\r^5p]F+x\u000e^1NC:\fw-\u001a:\u0002!Q,7\u000f\u001e+ie>$H\u000f\\3US6,G#\u0001\u001a)\u0005%\u0019\u0005C\u0001#N\u001b\u0005)%B\u0001$H\u0003\r\t\u0007/\u001b\u0006\u0003\u0011&\u000bqA[;qSR,'O\u0003\u0002K\u0017\u0006)!.\u001e8ji*\tA*A\u0002pe\u001eL!AT#\u0003\tQ+7\u000f^\u0001%i\u0016\u001cHoQ8oiJ|G\u000e\\3s\u001bV$\u0018\r^5p]F+x\u000e^1WS>d\u0017\r^5p]\"\u0012!bQ\u0001>i\u0016\u001cHOT3x'R\u0014\u0018n\u0019;Rk>$\u0018MR8s%\u0016$XO\u001d8t+:\u0014w.\u001e8eK\u0012\fVo\u001c;b/\",g.U;pi\u0006L5\u000fR5tC\ndW\r\u001a\u0015\u0003\u0017\r\u000b\u0011\b^3ti:+wo\u0015;sS\u000e$\u0018+^8uC\u001a{'OU3ukJt7o\u0015;sS\u000e$\u0018+^8uC^CWM\\)v_R\f\u0017j]#oC\ndW\r\u001a\u0015\u0003\u0019\r\u000b\u0011\t^3ti:+w\u000fU3s[&\u001c8/\u001b<f#V|G/\u0019$peJ+G/\u001e:ogVs'm\\;oI\u0016$\u0017+^8uC^CWM\\)v_R\f\u0017j\u001d#jg\u0006\u0014G.\u001a3)\u00055\u0019\u0015!\u0010;fgRtUm\u001e)fe6L7o]5wKF+x\u000e^1G_J\u0014V\r^;s]N\u001cFO]5diF+x\u000e^1XQ\u0016t\u0017+^8uC&\u001bXI\\1cY\u0016$\u0007F\u0001\bD\u0001")
public class ControllerMutationQuotaManagerTest
extends BaseClientQuotaManagerTest {
    private final String User;
    private final String ClientId;
    private final ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(10, 1, ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L, 0);

    private String User() {
        return this.User;
    }

    private String ClientId() {
        return this.ClientId;
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private void withQuotaManager(Function1<ControllerMutationQuotaManager, BoxedUnit> f) {
        ControllerMutationQuotaManager quotaManager = new ControllerMutationQuotaManager(this.config(), this.metrics(), (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            f.apply((Object)quotaManager);
        }
        finally {
            quotaManager.shutdown();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testThrottleTime() {
        void add_stat;
        MockTime time = new MockTime(0L, System.currentTimeMillis(), 0L);
        Metrics metrics = new Metrics((Time)time);
        Sensor sensor = metrics.sensor("sensor");
        MetricName metricName = metrics.metricName("tokens", "test-group");
        TokenBucket tokenBucket = new TokenBucket();
        if (sensor == null) {
            throw null;
        }
        sensor.add(metricName, (MeasurableStat)add_stat, null);
        tokenBucket = null;
        KafkaMetric metric = metrics.metric(metricName);
        Assertions.assertEquals((long)0L, (long)ControllerMutationQuotaManager$.MODULE$.throttleTimeMs(new QuotaViolationException(metric, 0.0, 10.0)));
        Assertions.assertEquals((long)500L, (long)ControllerMutationQuotaManager$.MODULE$.throttleTimeMs(new QuotaViolationException(metric, -5.0, 10.0)));
        Assertions.assertEquals((long)1000L, (long)ControllerMutationQuotaManager$.MODULE$.throttleTimeMs(new QuotaViolationException(metric, -10.0, 10.0)));
    }

    @Test
    public void testControllerMutationQuotaViolation() {
        ControllerMutationQuotaManager withQuotaManager_quotaManager = new ControllerMutationQuotaManager(this.config(), this.metrics(), (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            ControllerMutationQuotaManagerTest.$anonfun$testControllerMutationQuotaViolation$2(this, withQuotaManager_quotaManager);
        }
        finally {
            withQuotaManager_quotaManager.shutdown();
        }
    }

    @Test
    public void testNewStrictQuotaForReturnsUnboundedQuotaWhenQuotaIsDisabled() {
        ControllerMutationQuotaManager withQuotaManager_quotaManager = new ControllerMutationQuotaManager(this.config(), this.metrics(), (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            ControllerMutationQuotaManagerTest.$anonfun$testNewStrictQuotaForReturnsUnboundedQuotaWhenQuotaIsDisabled$1(this, withQuotaManager_quotaManager);
        }
        finally {
            withQuotaManager_quotaManager.shutdown();
        }
    }

    @Test
    public void testNewStrictQuotaForReturnsStrictQuotaWhenQuotaIsEnabled() {
        ControllerMutationQuotaManager withQuotaManager_quotaManager = new ControllerMutationQuotaManager(this.config(), this.metrics(), (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            ControllerMutationQuotaManagerTest.$anonfun$testNewStrictQuotaForReturnsStrictQuotaWhenQuotaIsEnabled$1(this, withQuotaManager_quotaManager);
        }
        finally {
            withQuotaManager_quotaManager.shutdown();
        }
    }

    @Test
    public void testNewPermissiveQuotaForReturnsUnboundedQuotaWhenQuotaIsDisabled() {
        ControllerMutationQuotaManager withQuotaManager_quotaManager = new ControllerMutationQuotaManager(this.config(), this.metrics(), (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            ControllerMutationQuotaManagerTest.$anonfun$testNewPermissiveQuotaForReturnsUnboundedQuotaWhenQuotaIsDisabled$1(this, withQuotaManager_quotaManager);
        }
        finally {
            withQuotaManager_quotaManager.shutdown();
        }
    }

    @Test
    public void testNewPermissiveQuotaForReturnsStrictQuotaWhenQuotaIsEnabled() {
        ControllerMutationQuotaManager withQuotaManager_quotaManager = new ControllerMutationQuotaManager(this.config(), this.metrics(), (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            ControllerMutationQuotaManagerTest.$anonfun$testNewPermissiveQuotaForReturnsStrictQuotaWhenQuotaIsEnabled$1(this, withQuotaManager_quotaManager);
        }
        finally {
            withQuotaManager_quotaManager.shutdown();
        }
    }

    public static final /* synthetic */ void $anonfun$testControllerMutationQuotaViolation$2(ControllerMutationQuotaManagerTest $this, ControllerMutationQuotaManager quotaManager) {
        double upperBound_upperBound = 10.0;
        quotaManager.updateQuota((Option)new Some((Object)$this.User()), (Option)new Some((Object)$this.ClientId()), (Option)new Some((Object)$this.ClientId()), (Option)new Some((Object)new Quota(upperBound_upperBound, true)));
        KafkaMetric queueSizeMetric = (KafkaMetric)$this.metrics().metrics().get($this.metrics().metricName("queue-size", "ControllerMutation", ""));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
            Assertions.assertEquals((int)0, (int)$this.maybeRecord((ClientQuotaManager)quotaManager, $this.User(), $this.ClientId(), 10.0));
            $this.time().sleep(1000L);
        });
        Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
        int throttleTime = $this.maybeRecord((ClientQuotaManager)quotaManager, $this.User(), $this.ClientId(), 110.0);
        Assertions.assertEquals((int)0, (int)throttleTime, (String)"Should not be throttled");
        throttleTime = $this.maybeRecord((ClientQuotaManager)quotaManager, $this.User(), $this.ClientId(), 110.0);
        Assertions.assertEquals((int)1000, (int)throttleTime, (String)"Should be throttled");
        $this.throttle((ClientQuotaManager)quotaManager, $this.User(), $this.ClientId(), throttleTime, $this.callback());
        Assertions.assertEquals((int)1, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
        quotaManager.throttledChannelReaper().doWork();
        Assertions.assertEquals((int)0, (int)$this.numCallbacks());
        $this.time().sleep((long)throttleTime);
        quotaManager.throttledChannelReaper().doWork();
        Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
        Assertions.assertEquals((int)1, (int)$this.numCallbacks());
        throttleTime = $this.maybeRecord((ClientQuotaManager)quotaManager, $this.User(), $this.ClientId(), 110.0);
        Assertions.assertEquals((int)0, (int)throttleTime, (String)"Should be throttled");
    }

    public static final /* synthetic */ void $anonfun$testNewStrictQuotaForReturnsUnboundedQuotaWhenQuotaIsDisabled$1(ControllerMutationQuotaManagerTest $this, ControllerMutationQuotaManager quotaManager) {
        Assertions.assertEquals((Object)UnboundedControllerMutationQuota$.MODULE$, (Object)quotaManager.newStrictQuotaFor($this.buildSession($this.User()), $this.ClientId()));
    }

    public static final /* synthetic */ void $anonfun$testNewStrictQuotaForReturnsStrictQuotaWhenQuotaIsEnabled$1(ControllerMutationQuotaManagerTest $this, ControllerMutationQuotaManager quotaManager) {
        double upperBound_upperBound = 10.0;
        quotaManager.updateQuota((Option)new Some((Object)$this.User()), (Option)new Some((Object)$this.ClientId()), (Option)new Some((Object)$this.ClientId()), (Option)new Some((Object)new Quota(upperBound_upperBound, true)));
        Assertions.assertTrue((boolean)(quotaManager.newStrictQuotaFor($this.buildSession($this.User()), $this.ClientId()) instanceof StrictControllerMutationQuota));
    }

    public static final /* synthetic */ void $anonfun$testNewPermissiveQuotaForReturnsUnboundedQuotaWhenQuotaIsDisabled$1(ControllerMutationQuotaManagerTest $this, ControllerMutationQuotaManager quotaManager) {
        Assertions.assertEquals((Object)UnboundedControllerMutationQuota$.MODULE$, (Object)quotaManager.newPermissiveQuotaFor($this.buildSession($this.User()), $this.ClientId()));
    }

    public static final /* synthetic */ void $anonfun$testNewPermissiveQuotaForReturnsStrictQuotaWhenQuotaIsEnabled$1(ControllerMutationQuotaManagerTest $this, ControllerMutationQuotaManager quotaManager) {
        double upperBound_upperBound = 10.0;
        quotaManager.updateQuota((Option)new Some((Object)$this.User()), (Option)new Some((Object)$this.ClientId()), (Option)new Some((Object)$this.ClientId()), (Option)new Some((Object)new Quota(upperBound_upperBound, true)));
        Assertions.assertTrue((boolean)(quotaManager.newPermissiveQuotaFor($this.buildSession($this.User()), $this.ClientId()) instanceof PermissiveControllerMutationQuota));
    }

    public ControllerMutationQuotaManagerTest() {
        this.User = "ANONYMOUS";
        this.ClientId = "test-client";
    }

    public static final /* synthetic */ Object $anonfun$testControllerMutationQuotaViolation$2$adapted(ControllerMutationQuotaManagerTest $this, ControllerMutationQuotaManager quotaManager) {
        ControllerMutationQuotaManagerTest.$anonfun$testControllerMutationQuotaViolation$2($this, quotaManager);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testNewStrictQuotaForReturnsUnboundedQuotaWhenQuotaIsDisabled$1$adapted(ControllerMutationQuotaManagerTest $this, ControllerMutationQuotaManager quotaManager) {
        ControllerMutationQuotaManagerTest.$anonfun$testNewStrictQuotaForReturnsUnboundedQuotaWhenQuotaIsDisabled$1($this, quotaManager);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testNewStrictQuotaForReturnsStrictQuotaWhenQuotaIsEnabled$1$adapted(ControllerMutationQuotaManagerTest $this, ControllerMutationQuotaManager quotaManager) {
        ControllerMutationQuotaManagerTest.$anonfun$testNewStrictQuotaForReturnsStrictQuotaWhenQuotaIsEnabled$1($this, quotaManager);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testNewPermissiveQuotaForReturnsUnboundedQuotaWhenQuotaIsDisabled$1$adapted(ControllerMutationQuotaManagerTest $this, ControllerMutationQuotaManager quotaManager) {
        ControllerMutationQuotaManagerTest.$anonfun$testNewPermissiveQuotaForReturnsUnboundedQuotaWhenQuotaIsDisabled$1($this, quotaManager);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testNewPermissiveQuotaForReturnsStrictQuotaWhenQuotaIsEnabled$1$adapted(ControllerMutationQuotaManagerTest $this, ControllerMutationQuotaManager quotaManager) {
        ControllerMutationQuotaManagerTest.$anonfun$testNewPermissiveQuotaForReturnsStrictQuotaWhenQuotaIsEnabled$1($this, quotaManager);
        return BoxedUnit.UNIT;
    }
}

