/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import kafka.server.ConfluentObserverTest;
import kafka.server.KafkaBroker;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.PartitionResult;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.ReplicaStatusResult;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.junit.jupiter.api.Assertions;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

public final class ConfluentObserverTest$ {
    public static final ConfluentObserverTest$ MODULE$ = new ConfluentObserverTest$();

    public AlterConfigsResult alterTopicConfigs(Admin adminClient, String topic, Properties topicConfigs) {
        List configEntries = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.PropertiesHasAsScala(topicConfigs).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return new ConfigEntry(k, v);
            }
            throw new MatchError(null);
        })).toList()).asJava();
        Config newConfig = new Config((Collection)configEntries);
        java.util.Map configs = CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, topic)), (Object)newConfig)}))).asJava();
        return adminClient.alterConfigs(configs);
    }

    public Map<String, Object> createConfig(Seq<KafkaBroker> brokers) {
        return (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.bootstrapServers(brokers)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request.timeout.ms"), (Object)"20000")}));
    }

    public Optional<NewPartitionReassignment> reassignmentEntry(Seq<Object> replicas, Seq<Object> observers) {
        return Optional.of(NewPartitionReassignment.ofReplicasAndObservers((List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1 & Serializable)r -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)r)))).asJava(), (List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)observers.map((Function1 & Serializable)o -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)o)))).asJava()));
    }

    public void waitForAllReassignmentsToComplete(AdminClient client) {
        long x$4 = 15000L;
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConfluentObserverTest$.$anonfun$waitForAllReassignmentsToComplete$1(client)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                Assertions.fail((String)"There still are ongoing reassignments");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$4), waitUntilTrue_pause));
        }
    }

    public void waitForAllReassignmentsToComplete(ConfluentAdmin client) {
        long x$4 = 15000L;
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConfluentObserverTest$.$anonfun$waitForAllReassignmentsToComplete$3(client)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                Assertions.fail((String)"There still are ongoing reassignments");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$4), waitUntilTrue_pause));
        }
    }

    public Option<TopicPartitionInfo> describeTopicPartition(AdminClient client, TopicPartition topicPartition) {
        return Option$.MODULE$.apply(((TopicDescription)((java.util.Map)client.describeTopics(Arrays.asList(topicPartition.topic())).allTopicNames().get()).get(topicPartition.topic())).partitions().get(topicPartition.partition()));
    }

    public String bootstrapServers(Seq<KafkaBroker> brokers) {
        return Option$.MODULE$.option2Iterable(((IterableOps)brokers.map((Function1 & Serializable)broker -> {
            int port = broker.socketServer().boundPort(ListenerName.normalised((String)"PLAINTEXT"));
            return new StringBuilder(10).append("localhost:").append(port).toString();
        })).headOption()).mkString(",");
    }

    public String basicTopicPlacement(ConfluentObserverTest.BasicConstraint replicaConstraint, Option<ConfluentObserverTest.BasicConstraint> observerConstraint) {
        String observers = (String)observerConstraint.fold((Function0 & Serializable)() -> "", (Function1 & Serializable)constraint -> new StringBuilder(53).append(",\"observers\":[{\"count\": ").append(constraint.count()).append(", \"constraints\":{\"rack\":\"").append(constraint.rack()).append("\"}}]").toString());
        return new StringBuilder(65).append("{\"version\":1,\"replicas\":[{\"count\": ").append(replicaConstraint.count()).append(", \"constraints\":{\"rack\":\"").append(replicaConstraint.rack()).append("\"}}]").append(observers).append("}").toString();
    }

    public String v2TopicPlacement(String observerPromotionPolicy, ConfluentObserverTest.BasicConstraint replicaConstraint, Option<ConfluentObserverTest.BasicConstraint> observerConstraint) {
        String observers = (String)observerConstraint.fold((Function0 & Serializable)() -> "", (Function1 & Serializable)constraint -> new StringBuilder(53).append(",\"observers\":[{\"count\": ").append(constraint.count()).append(", \"constraints\":{\"rack\":\"").append(constraint.rack()).append("\"}}]").toString());
        return new StringBuilder(94).append("{\"version\":2,\"observerPromotionPolicy\":\"").append(observerPromotionPolicy).append("\",\"replicas\":[{\"count\": ").append(replicaConstraint.count()).append(", \"constraints\":{\"rack\":\"").append(replicaConstraint.rack()).append("\"}}]").append(observers).append("}").toString();
    }

    public final void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition tp) {
        try {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)i -> ConfluentObserverTest$.$anonfun$sendRecords$1(tp, producer, BoxesRunTime.unboxToInt((Object)i))).foreach((Function1 & Serializable)x$11 -> (RecordMetadata)x$11.get());
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void assertNoDataLossAcrossAllReplicas(int numRecords, ConfluentAdmin client, TopicPartition topicPartition, int numSyncReplicas, int numObservers) {
        AtomicReference errorResponseFuture = new AtomicReference();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConfluentObserverTest$.$anonfun$assertNoDataLossAcrossAllReplicas$1(client, topicPartition, errorResponseFuture, numSyncReplicas, numObservers, numRecords)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ConfluentObserverTest$.$anonfun$assertNoDataLossAcrossAllReplicas$5(numRecords, errorResponseFuture));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$waitForAllReassignmentsToComplete$1(AdminClient client$7) {
        return ((java.util.Map)client$7.listPartitionReassignments().reassignments().get()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$waitForAllReassignmentsToComplete$2() {
        return "There still are ongoing reassignments";
    }

    public static final /* synthetic */ boolean $anonfun$waitForAllReassignmentsToComplete$3(ConfluentAdmin client$8) {
        return ((java.util.Map)client$8.listPartitionReassignments().reassignments().get()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$waitForAllReassignmentsToComplete$4() {
        return "There still are ongoing reassignments";
    }

    public static final /* synthetic */ Future $anonfun$sendRecords$1(TopicPartition tp$1, KafkaProducer producer$1, int i) {
        ProducerRecord record = new ProducerRecord(tp$1.topic(), Predef$.MODULE$.int2Integer(tp$1.partition()), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes(), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
        return producer$1.send(record);
    }

    public static final /* synthetic */ boolean $anonfun$assertNoDataLossAcrossAllReplicas$2(ReplicaStatus replicaStatus) {
        return !replicaStatus.isObserver();
    }

    public static final /* synthetic */ boolean $anonfun$assertNoDataLossAcrossAllReplicas$4(int numRecords$1, ReplicaStatus replicaStatus) {
        return replicaStatus.logEndOffset() >= (long)numRecords$1;
    }

    public static final /* synthetic */ boolean $anonfun$assertNoDataLossAcrossAllReplicas$1(ConfluentAdmin client$9, TopicPartition topicPartition$6, AtomicReference errorResponseFuture$1, int numSyncReplicas$1, int numObservers$1, int numRecords$1) {
        ReplicaStatusResult replicaStatus2 = client$9.replicaStatus(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition$6}))).asJava(), new ReplicaStatusOptions());
        Buffer replicas = CollectionConverters$.MODULE$.ListHasAsScala(((PartitionResult)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)replicaStatus2.allResults().get()).asScala().get((Object)topicPartition$6).get()).replicas()).asScala();
        errorResponseFuture$1.set(replicas);
        Buffer syncReplicas = (Buffer)replicas.filter((Function1 & Serializable)replicaStatus -> BoxesRunTime.boxToBoolean((boolean)ConfluentObserverTest$.$anonfun$assertNoDataLossAcrossAllReplicas$2(replicaStatus)));
        Buffer observers = (Buffer)replicas.filter((Function1 & Serializable)replicaStatus -> BoxesRunTime.boxToBoolean((boolean)replicaStatus.isObserver()));
        return syncReplicas.size() == numSyncReplicas$1 && observers.size() == numObservers$1 && replicas.forall((Function1 & Serializable)replicaStatus -> BoxesRunTime.boxToBoolean((boolean)ConfluentObserverTest$.$anonfun$assertNoDataLossAcrossAllReplicas$4(numRecords$1, replicaStatus)));
    }

    public static final /* synthetic */ String $anonfun$assertNoDataLossAcrossAllReplicas$5(int numRecords$1, AtomicReference errorResponseFuture$1) {
        return new StringBuilder(77).append("Replicas did not replicate data as expected. Expected log end offset up to ").append(numRecords$1).append(". ").append(errorResponseFuture$1.get()).toString();
    }

    private ConfluentObserverTest$() {
    }
}

