/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Properties;
import kafka.server.BaseFetchRequestTest;
import kafka.server.DummyReplicaSelector;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.annotation.ApiKeyVersionsSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005U4Aa\u0002\u0005\u0001\u001b!)!\u0003\u0001C\u0001'!)Q\u0003\u0001C!-!)Q\u0004\u0001C!=!)A\u0006\u0001C\u0005[!)Q\n\u0001C\u0001\u001d\")\u0001\u000f\u0001C\u0001c\nq2i\u001c8gYV,g\u000e\u001e$fi\u000eDgI]8n\r>dGn\\<feR+7\u000f\u001e\u0006\u0003\u0013)\taa]3sm\u0016\u0014(\"A\u0006\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fAi\u0011\u0001C\u0005\u0003#!\u0011ACQ1tK\u001a+Go\u00195SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u0001\u0015!\ty\u0001!A\u0006ce>\\WM]\"pk:$X#A\f\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\u0007%sG/A\fce>\\WM\u001d)s_B,'\u000f^=Pm\u0016\u0014(/\u001b3fgR\u0011qD\t\t\u00031\u0001J!!I\r\u0003\tUs\u0017\u000e\u001e\u0005\u0006G\r\u0001\r\u0001J\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\bCA\u0013+\u001b\u00051#BA\u0014)\u0003\u0011)H/\u001b7\u000b\u0003%\nAA[1wC&\u00111F\n\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018aC2sK\u0006$X\rV8qS\u000e$\"A\f%\u0011\tay\u0013\u0007P\u0005\u0003ae\u0011a\u0001V;qY\u0016\u0014\u0004C\u0001\u001a;\u001b\u0005\u0019$B\u0001\u001b6\u0003\u0019\u0019w.\\7p]*\u00111B\u000e\u0006\u0003oa\na!\u00199bG\",'\"A\u001d\u0002\u0007=\u0014x-\u0003\u0002<g\t!Q+^5e!\riTi\u0006\b\u0003}\rs!a\u0010\"\u000e\u0003\u0001S!!\u0011\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0012B\u0001#\u001a\u0003\u001d\u0001\u0018mY6bO\u0016L!AR$\u0003\u0007M+\u0017O\u0003\u0002E3!)\u0011\n\u0002a\u0001\u0015\u0006\u0011A\u000f\u001d\t\u0003e-K!\u0001T\u001a\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006qD/Z:u\r\u0016$8\r\u001b$s_6dU-\u00193fe\u0012{Wm\u001d(piJ+hNU3qY&\u001c\u0017mU3mK\u000e$xN],ji\"|W\u000f\u001e'fC\u0012,'/\u00129pG\"$\"aH(\t\u000bA+\u0001\u0019A)\u0002\u000fY,'o]5p]B\u0011\u0001DU\u0005\u0003'f\u0011Qa\u00155peRDC!B+^=B\u0011akW\u0007\u0002/*\u0011\u0001,W\u0001\u000bC:tw\u000e^1uS>t'B\u0001.4\u0003\u0015)H/\u001b7t\u0013\tavK\u0001\u000bBa&\\U-\u001f,feNLwN\\:T_V\u00148-Z\u0001\u0007CBL7*Z=%\u0003}K!\u0001Y1\u0002\u000b\u0019+Ek\u0011%\u000b\u0005\t\u001c\u0017aB!qS.+\u0017p\u001d\u0006\u0003IN\n\u0001\u0002\u001d:pi>\u001cw\u000e\u001c\u0015\u0003\u000b\u0019\u0004\"a\u001a8\u000e\u0003!T!!\u001b6\u0002\rA\f'/Y7t\u0015\tYG.A\u0004kkBLG/\u001a:\u000b\u00055D\u0014!\u00026v]&$\u0018BA8i\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u00010i\u0016\u001cHOR3uG\"4%o\\7G_2dwn^3s%\u0016TWm\u0019;fI^KG\u000f[8vi2+\u0017\rZ3s\u000bB|7\r\u001b\u000b\u0003?IDQ\u0001\u0015\u0004A\u0002ECCAB+^=\"\u0012aA\u001a")
public class ConfluentFetchFromFollowerTest
extends BaseFetchRequestTest {
    @Override
    public int brokerCount() {
        return 2;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.FetchFromFollowerRequireLeaderEpochProp(), Boolean.toString(true));
        properties.put(KafkaConfig$.MODULE$.ReplicaSelectorClassProp(), DummyReplicaSelector.class.getName());
    }

    private Tuple2<Uuid, scala.collection.immutable.Seq<Object>> createTopic(TopicPartition tp) {
        Buffer replicaIds = (Buffer)this.brokers().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)ConfluentFetchFromFollowerTest.$anonfun$createTopic$1(x$2)));
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$22 = tp.topic();
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)replicaIds)}));
        int x$4 = 1;
        int x$5 = 1;
        Properties x$6 = new Properties();
        Uuid topicId = TestUtils$.MODULE$.createTopicWithAdminRaw(admin, x$22, x$4, x$5, (Map<Object, Seq<Object>>)x$3, x$6);
        TestUtils$.MODULE$.waitForAllPartitionsMetadata(this.servers(), tp.topic(), 1);
        return new Tuple2((Object)topicId, (Object)replicaIds.toSeq());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.FETCH)
    public void testFetchFromLeaderDoesNotRunReplicaSelectorWithoutLeaderEpoch(short version) {
        void var4_4;
        void var5_5;
        TopicPartition tp = new TopicPartition("foo", 0);
        Tuple2<Uuid, scala.collection.immutable.Seq<Object>> tuple2 = this.createTopic(tp);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Uuid topicId = (Uuid)tuple2._1();
        scala.collection.immutable.Seq replicaIds = (scala.collection.immutable.Seq)tuple2._2();
        int leaderId = BoxesRunTime.unboxToInt((Object)var5_5.head());
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> fetchResponse = this.sendFetch(leaderId, (Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), (scala.collection.immutable.Map<String, Uuid>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topic()), (Object)var4_4)}))), version, (Option<Object>)None$.MODULE$);
        Assertions.assertEquals((int)-1, (int)fetchResponse.get(tp).preferredReadReplica());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)fetchResponse.get(tp).errorCode());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.FETCH)
    public void testFetchFromFollowerRejectedWithoutLeaderEpoch(short version) {
        void var4_4;
        void var5_5;
        TopicPartition tp = new TopicPartition("foo", 0);
        Tuple2<Uuid, scala.collection.immutable.Seq<Object>> tuple2 = this.createTopic(tp);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Uuid topicId = (Uuid)tuple2._1();
        scala.collection.immutable.Seq replicaIds = (scala.collection.immutable.Seq)tuple2._2();
        int followerId = BoxesRunTime.unboxToInt((Object)var5_5.last());
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> fetchResponse = this.sendFetch(followerId, (Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), (scala.collection.immutable.Map<String, Uuid>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topic()), (Object)var4_4)}))), version, (Option<Object>)None$.MODULE$);
        Assertions.assertEquals((int)-1, (int)fetchResponse.get(tp).preferredReadReplica());
        Assertions.assertEquals((short)Errors.NOT_LEADER_OR_FOLLOWER.code(), (short)fetchResponse.get(tp).errorCode());
    }

    public static final /* synthetic */ int $anonfun$createTopic$1(KafkaBroker x$2) {
        return x$2.config().brokerId();
    }
}

