/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.kafka.clients.CloudAdmin;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.BrokerServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterBrokerHealthOptions;
import org.apache.kafka.clients.admin.AlterBrokerHealthSpec;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.clients.admin.ComponentHealthStatus;
import org.apache.kafka.clients.admin.DegradedBroker;
import org.apache.kafka.clients.admin.DegradedBrokerComponent;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.message.AlterBrokerHealthRequestData;
import org.apache.kafka.common.message.AlterBrokerHealthResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterBrokerHealthRequest;
import org.apache.kafka.common.requests.AlterBrokerHealthResponse;
import org.apache.kafka.common.requests.DescribeBrokerHealthRequest;
import org.apache.kafka.common.requests.DescribeBrokerHealthResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\rEe\u0001\u0002\u001c8\u0001qBQ!\u0011\u0001\u0005\u0002\tCq\u0001\u0012\u0001A\u0002\u0013\u0005Q\tC\u0004R\u0001\u0001\u0007I\u0011\u0001*\t\rm\u0003\u0001\u0015)\u0003G\u0011\u001da\u0006A1A\u0005\u0002uCaA\u001a\u0001!\u0002\u0013q\u0006bB4\u0001\u0005\u0004%\t\u0001\u001b\u0005\u0007Y\u0002\u0001\u000b\u0011B5\t\u000f5\u0004!\u0019!C\u0001Q\"1a\u000e\u0001Q\u0001\n%Dqa\u001c\u0001C\u0002\u0013\u0005\u0001\u000e\u0003\u0004q\u0001\u0001\u0006I!\u001b\u0005\u0006c\u0002!\tE\u001d\u0005\b\u0003\u0017\u0001A\u0011IA\u0007\u0011\u001d\ti\u0003\u0001C\u0005\u0003_Aq!!\u000e\u0001\t\u0003\t9\u0004C\u0004\u0002z\u0001!\t!a\u001f\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002\b\"9\u0011\u0011\u0013\u0001\u0005\u0002\u0005M\u0005bBAO\u0001\u0011\u0005\u0011q\u0014\u0005\b\u0003S\u0003A\u0011AAV\u0011\u001d\t)\f\u0001C\u0001\u0003oCq!!1\u0001\t\u0003\t\u0019\rC\u0004\u0002N\u0002!\t!a4\t\u000f\u0005e\u0007\u0001\"\u0001\u0002\\\"9\u0011Q\u001d\u0001\u0005\u0002\u0005\u001d\bbBAy\u0001\u0011\u0005\u00111\u001f\u0005\b\u0003{\u0004A\u0011AA\u0000\u0011\u001d\u0011I\u0001\u0001C\u0001\u0005\u0017AqA!\u0006\u0001\t\u0013\u00119\u0002C\u0005\u0003~\u0001\t\n\u0011\"\u0003\u0003\u0000!I!Q\u0013\u0001\u0012\u0002\u0013%!q\u0013\u0005\n\u00057\u0003\u0011\u0013!C\u0005\u0005;C\u0011B!)\u0001#\u0003%IAa)\t\u000f\t\u001d\u0006\u0001\"\u0003\u0003*\"9!q\u0017\u0001\u0005\n\te\u0006\"\u0003B}\u0001E\u0005I\u0011\u0002B~\u0011%\u0011y\u0010AI\u0001\n\u0013\u0011\u0019\u000bC\u0005\u0004\u0002\u0001\t\n\u0011\"\u0003\u0003\u0000!I11\u0001\u0001\u0012\u0002\u0013%!q\u0013\u0005\n\u0007\u000b\u0001\u0011\u0013!C\u0005\u0007\u000fA\u0011ba\u0003\u0001#\u0003%Ia!\u0004\t\u0013\rE\u0001!%A\u0005\n\rM\u0001bBB\f\u0001\u0011%1\u0011\u0004\u0005\b\u0007{\u0001A\u0011BB \u0011%\u0019)\u0005AI\u0001\n\u0013\u00199\u0001C\u0004\u0004H\u0001!Ia!\u0013\t\u0013\r=\u0003!%A\u0005\n\r\u001d\u0001bBB)\u0001\u0011%11\u000b\u0005\b\u0007C\u0002A\u0011BB2\u0011\u001d\u0019I\u0007\u0001C\u0005\u0007WBqaa\u001d\u0001\t\u0013\u0019)\bC\u0005\u0004\u0010\u0002\t\n\u0011\"\u0003\u0004\u000e\t\u0001\"I]8lKJDU-\u00197uQR+7\u000f\u001e\u0006\u0003qe\naa]3sm\u0016\u0014(\"\u0001\u001e\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0010\t\u0003}}j\u0011aN\u0005\u0003\u0001^\u0012qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r\u0003\"A\u0010\u0001\u0002\u0017\u0005$W.\u001b8DY&,g\u000e^\u000b\u0002\rB\u0011qiT\u0007\u0002\u0011*\u0011\u0011JS\u0001\bG2LWM\u001c;t\u0015\tQ4J\u0003\u0002M\u001b\u0006I1m\u001c8gYV,g\u000e\u001e\u0006\u0002\u001d\u0006\u0011\u0011n\\\u0005\u0003!\"\u0013!b\u00117pk\u0012\fE-\\5o\u0003=\tG-\\5o\u00072LWM\u001c;`I\u0015\fHCA*Z!\t!v+D\u0001V\u0015\u00051\u0016!B:dC2\f\u0017B\u0001-V\u0005\u0011)f.\u001b;\t\u000fi\u001b\u0011\u0011!a\u0001\r\u0006\u0019\u0001\u0010J\u0019\u0002\u0019\u0005$W.\u001b8DY&,g\u000e\u001e\u0011\u0002\u0013Q|\u0007/[2OC6,W#\u00010\u0011\u0005}#W\"\u00011\u000b\u0005\u0005\u0014\u0017\u0001\u00027b]\u001eT\u0011aY\u0001\u0005U\u00064\u0018-\u0003\u0002fA\n11\u000b\u001e:j]\u001e\f!\u0002^8qS\u000et\u0015-\\3!\u0003\t\u0001\b'F\u0001j!\t!&.\u0003\u0002l+\n\u0019\u0011J\u001c;\u0002\u0007A\u0004\u0004%\u0001\u0002qc\u0005\u0019\u0001/\r\u0011\u0002\u0005A\u0014\u0014a\u000193A\u0005)1/\u001a;VaR\u00111k\u001d\u0005\u0006i6\u0001\r!^\u0001\ti\u0016\u001cH/\u00138g_B\u0011ao`\u0007\u0002o*\u0011\u00010_\u0001\u0004CBL'B\u0001>|\u0003\u001dQW\u000f]5uKJT!\u0001`?\u0002\u000b),h.\u001b;\u000b\u0003y\f1a\u001c:h\u0013\r\t\ta\u001e\u0002\t)\u0016\u001cH/\u00138g_\"\u001aQ\"!\u0002\u0011\u0007Y\f9!C\u0002\u0002\n]\u0014!BQ3g_J,W)Y2i\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cXCAA\b!\u0019\t\t\"!\t\u0002(9!\u00111CA\u000f\u001d\u0011\t)\"a\u0007\u000e\u0005\u0005]!bAA\rw\u00051AH]8pizJ\u0011AV\u0005\u0004\u0003?)\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003G\t)CA\u0002TKFT1!a\bV!\rq\u0014\u0011F\u0005\u0004\u0003W9$aC&bM.\f7i\u001c8gS\u001e\fAb\u0019:fCR,7i\u001c8gS\u001e$B!a\n\u00022!1\u00111G\bA\u0002%\faA\\8eK&#\u0017a\u0006;fgR$U-\\8uS>t7oV5uQR{\u0007/[2t)\r\u0019\u0016\u0011\b\u0005\b\u0003w\u0001\u0002\u0019AA\u001f\u0003\u0019\tXo\u001c:v[B!\u0011qHA$\u001d\u0011\t\t%a\u0011\u0011\u0007\u0005UQ+C\u0002\u0002FU\u000ba\u0001\u0015:fI\u00164\u0017bA3\u0002J)\u0019\u0011QI+)\u000fA\ti%!\u0018\u0002`A!\u0011qJA-\u001b\t\t\tF\u0003\u0003\u0002T\u0005U\u0013\u0001\u00039s_ZLG-\u001a:\u000b\u0007\u0005]\u00130\u0001\u0004qCJ\fWn]\u0005\u0005\u00037\n\tFA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0005\u0003C\n)'\t\u0002\u0002d\u0005\u0011!p[\u0011\u0003\u0003O\nQa\u001b:bMRDs\u0001EA6\u0003g\n)\b\u0005\u0003\u0002n\u0005=TBAA+\u0013\u0011\t\t(!\u0016\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017EAA<\u0003aYH-[:qY\u0006Lh*Y7f{:\nXo\u001c:v[vZ\b'`\u0001$i\u0016\u001cH\u000fR3n_RLwN\\:XSRD7i\u001c8ue>dG.\u001a:GC&dwN^3s)\r\u0019\u0016Q\u0010\u0005\b\u0003w\t\u0002\u0019AA\u001fQ\u001d\t\u0012QJA/\u0003\u0003c#!!\u0019)\u000fE\tY'a\u001d\u0002v\u0005AC/Z:u\t\u0016lw\u000e^5p]N<\u0016\u000e\u001e5L%\u00064GoQ8oiJ|G\u000e\\3s\r\u0006LGn\u001c<feR\u00191+!#\t\u000f\u0005m\"\u00031\u0001\u0002>!:!#!\u0014\u0002^\u00055EFAA3Q\u001d\u0011\u00121NA:\u0003k\n!\u0007^3ti\u000e{g\u000e\u001e:pY2,'OR1jY>4XM]%n[\u0016$\u0017.\u0019;fYf\fe\r^3s\t\u0016lw\u000e^3Ce>\\WM\u001d\u000b\u0004'\u0006U\u0005bBA\u001e'\u0001\u0007\u0011Q\b\u0015\b'\u00055\u0013QLAMY\t\t\t\u0007K\u0004\u0014\u0003W\n\u0019(!\u001e\u0002+Q,7\u000f^!mi\u0016\u0014(I]8lKJDU-\u00197uQR\u00191+!)\t\u000f\u0005mB\u00031\u0001\u0002>!:A#!\u0014\u0002^\u0005\u0015F\u0006BA1\u0003KBs\u0001FA6\u0003g\n)(\u0001\u0016uKN$\u0018\t\u001c;fe\n\u0013xn[3s\u0011\u0016\fG\u000e\u001e5P]Vs'/Z4jgR,'/\u001a3Ce>\\WM]:\u0015\u0007M\u000bi\u000bC\u0004\u0002<U\u0001\r!!\u0010)\u000fU\ti%!\u0018\u000222\u0012\u0011\u0011\r\u0015\b+\u0005-\u00141OA;\u0003=\"Xm\u001d;L%\u00064G/\u00117uKJ\u0014%o\\6fe\"+\u0017\r\u001c;i\u001f:,fN]3hSN$XM]3e\u0005J|7.\u001a:t)\r\u0019\u0016\u0011\u0018\u0005\b\u0003w1\u0002\u0019AA\u001fQ\u001d1\u0012QJA/\u0003{c#!!\u001a)\u000fY\tY'a\u001d\u0002v\u0005QC/Z:u\u00032$XM\u001d\"s_.,'\u000fS3bYRD\u0007K]8qC\u001e\fG/Z:IK\u0006dG\u000f[*uCR,GcA*\u0002F\"9\u00111H\fA\u0002\u0005u\u0002fB\f\u0002N\u0005u\u0013\u0011\u001a\u0017\u0005\u0003C\n)\u0007K\u0004\u0018\u0003W\n\u0019(!\u001e\u0002=Q,7\u000f\u001e#f[>$\u0018n\u001c8t\u000bb\u001cW-\u001a3t\u001b\u0006D(I]8lKJ\u001cHcA*\u0002R\"9\u00111\b\rA\u0002\u0005u\u0002f\u0002\r\u0002N\u0005u\u0013Q\u001b\u0017\u0005\u0003C\n)\u0007K\u0004\u0019\u0003W\n\u0019(!\u001e\u0002EQ,7\u000f\u001e#f[>$\u0018n\u001c8t/\",g\u000eV8p\r\u0016<H*\u001b<f\u0005J|7.\u001a:t)\r\u0019\u0016Q\u001c\u0005\b\u0003wI\u0002\u0019AA\u001fQ\u001dI\u0012QJA/\u0003CdC!!\u0019\u0002f!:\u0011$a\u001b\u0002t\u0005U\u0014\u0001\t;fgR\fE\u000e^3s\u0005J|7.\u001a:IK\u0006dG\u000f[%eK6\u0004x\u000e^3oG\u0016$2aUAu\u0011\u001d\tYD\u0007a\u0001\u0003{AsAGA'\u0003;\ni\u000f\f\u0003\u0002b\u0005\u0015\u0004f\u0002\u000e\u0002l\u0005M\u0014QO\u00013i\u0016\u001cH/\u00117uKJ\u0014%o\\6fe\"+\u0017\r\u001c;i\u0011\u0006tG\r\\3t\u001d>$8i\u001c8ue>dG.\u001a:Fq\u000e,\u0007\u000f^5p]R\u00191+!>\t\u000f\u0005m2\u00041\u0001\u0002>!:1$!\u0014\u0002^\u0005eHFAA1Q\u001dY\u00121NA:\u0003k\n1\u0007^3ti\u0006cG/\u001a:Ce>\\WM\u001d%fC2$\b\u000eS1oI2,7/\u00138wC2LGMU3rk\u0016\u001cH/\u0012=dKB$\u0018n\u001c8\u0015\u0007M\u0013\t\u0001C\u0004\u0002<q\u0001\r!!\u0010)\u000fq\ti%!\u0018\u0003\u00061\"\u0011\u0011MA3Q\u001da\u00121NA:\u0003k\nQ\u0007^3ti\u0012+7o\u0019:jE\u0016\u0014%o\\6fe\"+\u0017\r\u001c;i\u0011\u0006tG\r\\3t\u001d>$8i\u001c8ue>dG.\u001a:Fq\u000e,\u0007\u000f^5p]R\u00191K!\u0004\t\u000f\u0005mR\u00041\u0001\u0002>!:Q$!\u0014\u0002^\tEAFAA1Q\u001di\u00121NA:\u0003k\nad\u0019:fCR,'I]8lKJDU-\u00197uQN#\u0018\r^;t%\u0016\u001cX\u000f\u001c;\u0015\u0019\te!\u0011\nB'\u0005?\u0012IG!\u001f\u0011\t\tm!1\t\b\u0005\u0005;\u0011iD\u0004\u0003\u0003 \t]b\u0002\u0002B\u0011\u0005cqAAa\t\u0003.9!!Q\u0005B\u0015\u001d\u0011\t)Ba\n\n\u0003yL1Aa\u000b~\u0003\u0019\t\u0007/Y2iK&\u0019!Ha\f\u000b\u0007\t-R0\u0003\u0003\u00034\tU\u0012AB2p[6|gNC\u0002;\u0005_IAA!\u000f\u0003<\u00059Q.Z:tC\u001e,'\u0002\u0002B\u001a\u0005kIAAa\u0010\u0003B\u0005i\u0012\t\u001c;fe\n\u0013xn[3s\u0011\u0016\fG\u000e\u001e5SKN\u0004xN\\:f\t\u0006$\u0018M\u0003\u0003\u0003:\tm\u0012\u0002\u0002B#\u0005\u000f\u0012\u0001D\u0011:pW\u0016\u0014\b*Z1mi\"\u001cF/\u0019;vgJ+7/\u001e7u\u0015\u0011\u0011yD!\u0011\t\r\t-c\u00041\u0001j\u0003!\u0011'o\\6fe&#\u0007\"\u0003B(=A\u0005\t\u0019\u0001B)\u0003%\u0019w.\u001c9p]\u0016tG\u000f\u0005\u0003\u0003T\tmSB\u0001B+\u0015\u0011\u00119F!\u0017\u0002\u000b\u0005$W.\u001b8\u000b\u0007%\u0013)$\u0003\u0003\u0003^\tU#a\u0004\"s_.,'oQ8na>tWM\u001c;\t\u0013\t\u0005d\u0004%AA\u0002\t\r\u0014\u0001\u00045fC2$\bn\u0015;biV\u001c\b\u0003\u0002B*\u0005KJAAa\u001a\u0003V\t)2i\\7q_:,g\u000e\u001e%fC2$\bn\u0015;biV\u001c\b\"\u0003B6=A\u0005\t\u0019\u0001B7\u0003\u0015)'O]8s!\u0011\u0011yG!\u001e\u000e\u0005\tE$\u0002\u0002B:\u0005w\t\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0005o\u0012\tH\u0001\u0004FeJ|'o\u001d\u0005\n\u0005wr\u0002\u0013!a\u0001\u0003{\t\u0001\"\u001a:s_Jl5oZ\u0001)GJ,\u0017\r^3Ce>\\WM\u001d%fC2$\bn\u0015;biV\u001c(+Z:vYR$C-\u001a4bk2$HEM\u000b\u0003\u0005\u0003SCA!\u0015\u0003\u0004.\u0012!Q\u0011\t\u0005\u0005\u000f\u0013\t*\u0004\u0002\u0003\n*!!1\u0012BG\u0003%)hn\u00195fG.,GMC\u0002\u0003\u0010V\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\u0019J!#\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0015de\u0016\fG/\u001a\"s_.,'\u000fS3bYRD7\u000b^1ukN\u0014Vm];mi\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u001a*\"!1\rBB\u0003!\u001a'/Z1uK\n\u0013xn[3s\u0011\u0016\fG\u000e\u001e5Ti\u0006$Xo\u001d*fgVdG\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011yJ\u000b\u0003\u0003n\t\r\u0015\u0001K2sK\u0006$XM\u0011:pW\u0016\u0014\b*Z1mi\"\u001cF/\u0019;vgJ+7/\u001e7uI\u0011,g-Y;mi\u0012*TC\u0001BSU\u0011\tiDa!\u0002%\u001d,GO\u0011:pW\u0016\u0014\b*Z1mi\"l\u0015\r]\u000b\u0003\u0005W\u0003r!a\u0010\u0003.&\u0014\t,\u0003\u0003\u00030\u0006%#aA'baB!!1\u000bBZ\u0013\u0011\u0011)L!\u0016\u0003\u001d\u0011+wM]1eK\u0012\u0014%o\\6fe\u0006y\u0012\r\u001c;fe\n\u0013xn[3s\u0011\u0016\fG\u000e\u001e5B]\u0012<U\r\u001e*fgB|gn]3\u0015!\tm&q\u0019Bg\u0005#\u0014\u0019N!6\u0003`\n%\b\u0003\u0002B_\u0005\u0007l!Aa0\u000b\t\t\u0005'1H\u0001\te\u0016\fX/Z:ug&!!Q\u0019B`\u0005e\tE\u000e^3s\u0005J|7.\u001a:IK\u0006dG\u000f\u001b*fgB|gn]3\t\u0013\t%G\u0005%AA\u0002\t-\u0017!\u00032s_.,'/\u00133t!\u0015\t\t\"!\tj\u0011%\u0011y\r\nI\u0001\u0002\u0004\ti$\u0001\u0004sK\u0006\u001cxN\u001c\u0005\n\u0005\u001f\"\u0003\u0013!a\u0001\u0005#B\u0011B!\u0019%!\u0003\u0005\rAa\u0019\t\u0013\t]G\u0005%AA\u0002\te\u0017!\u00024pe\u000e,\u0007c\u0001+\u0003\\&\u0019!Q\\+\u0003\u000f\t{w\u000e\\3b]\"I!\u0011\u001d\u0013\u0011\u0002\u0003\u0007!1]\u0001\bm\u0016\u00148/[8o!\r!&Q]\u0005\u0004\u0005O,&!B*i_J$\b\"\u0003BvIA\u0005\t\u0019\u0001Bw\u00031\u0019xnY6fiN+'O^3s!\u0011\u0011yO!>\u000e\u0005\tE(b\u0001Bzs\u00059a.\u001a;x_J\\\u0017\u0002\u0002B|\u0005c\u0014AbU8dW\u0016$8+\u001a:wKJ\f\u0011&\u00197uKJ\u0014%o\\6fe\"+\u0017\r\u001c;i\u0003:$w)\u001a;SKN\u0004xN\\:fI\u0011,g-Y;mi\u0012\nTC\u0001B\u007fU\u0011\u0011YMa!\u0002S\u0005dG/\u001a:Ce>\\WM\u001d%fC2$\b.\u00118e\u000f\u0016$(+Z:q_:\u001cX\r\n3fM\u0006,H\u000e\u001e\u00133\u0003%\nG\u000e^3s\u0005J|7.\u001a:IK\u0006dG\u000f[!oI\u001e+GOU3ta>t7/\u001a\u0013eK\u001a\fW\u000f\u001c;%g\u0005I\u0013\r\u001c;fe\n\u0013xn[3s\u0011\u0016\fG\u000e\u001e5B]\u0012<U\r\u001e*fgB|gn]3%I\u00164\u0017-\u001e7uIQ\n\u0011&\u00197uKJ\u0014%o\\6fe\"+\u0017\r\u001c;i\u0003:$w)\u001a;SKN\u0004xN\\:fI\u0011,g-Y;mi\u0012*TCAB\u0005U\u0011\u0011INa!\u0002S\u0005dG/\u001a:Ce>\\WM\u001d%fC2$\b.\u00118e\u000f\u0016$(+Z:q_:\u001cX\r\n3fM\u0006,H\u000e\u001e\u00137+\t\u0019yA\u000b\u0003\u0003d\n\r\u0015!K1mi\u0016\u0014(I]8lKJDU-\u00197uQ\u0006sGmR3u%\u0016\u001c\bo\u001c8tK\u0012\"WMZ1vYR$s'\u0006\u0002\u0004\u0016)\"!Q\u001eBB\u0003-\u0019'/Z1uKR{\u0007/[2\u0015\u000fM\u001bYba\t\u0004&!1A\t\fa\u0001\u0007;\u0001BAa\u0015\u0004 %!1\u0011\u0005B+\u0005\u0015\tE-\\5o\u0011\u0019aF\u00061\u0001\u0002>!91q\u0005\u0017A\u0002\r%\u0012a\u0004;pa&\u001c\u0017i]:jO:lWM\u001c;\u0011\u000f\r-2QG5\u000485\u00111Q\u0006\u0006\u0005\u0007_\u0019\t$A\u0005j[6,H/\u00192mK*\u001911G+\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00030\u000e5\u0002#BB\u0016\u0007sI\u0017\u0002BB\u001e\u0007[\u0011A\u0001T5ti\u0006aA-Z7pi\u0016\u0014%o\\6feR)1k!\u0011\u0004D!1!1J\u0017A\u0002%D\u0011Ba6.!\u0003\u0005\rA!7\u0002-\u0011,Wn\u001c;f\u0005J|7.\u001a:%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:p[>$XM\u0011:pW\u0016\u0014H#B*\u0004L\r5\u0003B\u0002B&_\u0001\u0007\u0011\u000eC\u0005\u0003X>\u0002\n\u00111\u0001\u0003Z\u00069\u0002O]8n_R,'I]8lKJ$C-\u001a4bk2$HEM\u0001\"m\u0006d\u0017\u000eZ1uK:{G*Z1eKJ\u001cxJ\u001c#f[>$X\r\u001a\"s_.,'o\u001d\u000b\u0006'\u000eU3q\u000b\u0005\u00079F\u0002\r!!\u0010\t\u000f\re\u0013\u00071\u0001\u0004\\\u0005\u0001B-Z7pi\u0016$'I]8lKJLEm\u001d\t\u0006\u0003\u007f\u0019i&[\u0005\u0005\u0007?\nIEA\u0002TKR\faE^1mS\u0012\fG/\u001a'fC\u0012,'o\u001d)sKN,g\u000e^(o!J|Wn\u001c;fI\n\u0013xn[3s)\u0015\u00196QMB4\u0011\u0019a&\u00071\u0001\u0002>!1!1\n\u001aA\u0002%\f!E^1mS\u0012\fG/\u001a'fC\u0012,'o\u001d)sKN,g\u000e^(o\u00032d'I]8lKJ\u001cH#B*\u0004n\r=\u0004B\u0002/4\u0001\u0004\ti\u0004\u0003\u0004\u0004rM\u0002\r![\u0001\u0010]Vl'-\u001a:PM\n\u0013xn[3sg\u0006i1\r[3dWJ+7\u000f]8og\u0016$raUB<\u0007\u007f\u001aY\tC\u0004\u0004zQ\u0002\raa\u001f\u0002\u001f\u0015D\b/Z2uK\u0012\u0014Vm];miN\u0004b!!\u0005\u0004~\te\u0011\u0002BB\u001e\u0003KAqa!!5\u0001\u0004\u0019\u0019)\u0001\bbGR,\u0018\r\u001c*fgB|gn]3\u0011\t\r\u00155qQ\u0007\u0003\u0005\u0003JAa!#\u0003B\ti\u0012\t\u001c;fe\n\u0013xn[3s\u0011\u0016\fG\u000e\u001e5SKN\u0004xN\\:f\t\u0006$\u0018\rC\u0005\u0004\u000eR\u0002\n\u00111\u0001\u0003d\u0006IQM\u001d:pe\u000e{G-Z\u0001\u0018G\",7m\u001b*fgB|gn]3%I\u00164\u0017-\u001e7uIM\u0002")
public class BrokerHealthTest
extends BaseRequestTest {
    private CloudAdmin adminClient;
    private final String topicName;
    private final int p0;
    private final int p1;
    private final int p2;

    public CloudAdmin adminClient() {
        return this.adminClient;
    }

    public void adminClient_$eq(CloudAdmin x$1) {
        this.adminClient = x$1;
    }

    public String topicName() {
        return this.topicName;
    }

    public int p0() {
        return this.p0;
    }

    public int p1() {
        return this.p1;
    }

    public int p2() {
        return this.p2;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        if (this.isKRaftTest()) {
            this.brokers().foreach((Function1 & Serializable)broker -> (Void)((BrokerServer)broker).lifecycleManager().initialUnfenceFuture().get());
        }
        this.adminClient_$eq(this.createCloudAdminClient(this.createCloudAdminClient$default$1()));
        scala.collection.immutable.Map validAssignment = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.p0())), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.p1())), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.p2())), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 0, 1})))}));
        this.createTopic((Admin)this.adminClient(), this.topicName(), (scala.collection.immutable.Map<Object, List<Object>>)validAssignment);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)p -> this.waitUntilLogCreatedOnBrokers(this.topicName(), p));
    }

    public scala.collection.immutable.Seq<KafkaConfig> generateConfigs() {
        return package$.MODULE$.Range().apply(0, this.brokerCount()).map((Function1 & Serializable)x$1 -> this.createConfig(BoxesRunTime.unboxToInt((Object)x$1)));
    }

    private KafkaConfig createConfig(int nodeId) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(nodeId, this.zkConnectOrNull(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.AlterBrokerHealthMaxDemotedBrokersPercentageProp(), "67");
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDemotionsWithTopics(String quorum) {
        this.demoteBroker(0, false);
        this.validateNoLeadersOnDemotedBrokers(this.topicName(), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
        this.promoteBroker(0, false);
        this.validateLeadersPresentOnPromotedBroker(this.topicName(), 0);
        this.demoteBroker(0, false);
        this.demoteBroker(1, false);
        this.validateNoLeadersOnDemotedBrokers(this.topicName(), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}))));
        this.demoteBroker(2, true);
        this.validateLeadersPresentOnAllBrokers(this.topicName(), 3);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testDemotionsWithControllerFailover(String quorum) {
        this.demoteBroker(0, false);
        KafkaServer controller = this.getController();
        controller.shutdown();
        this.validateNoLeadersOnDemotedBrokers(this.topicName(), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
        controller.startup();
        TestUtils$.MODULE$.waitForOnlineBroker((Admin)this.adminClient(), controller.config().brokerId());
        this.validateNoLeadersOnDemotedBrokers(this.topicName(), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testDemotionsWithKRaftControllerFailover(String quorum) {
        this.demoteBroker(0, false);
        this.validateNoLeadersOnDemotedBrokers(this.topicName(), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
        Integer prevPort = this.shutdownControllerServer();
        this.restartControllerServer(prevPort);
        TestUtils$.MODULE$.waitForOnlineController((Admin)this.adminClient());
        this.validateNoLeadersOnDemotedBrokers(this.topicName(), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testControllerFailoverImmediatelyAfterDemoteBroker(String quorum) {
        this.killAllBrokers();
        scala.collection.immutable.Set degradedBrokerComponents = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{new DegradedBrokerComponent("reason", BrokerComponent.UNSPECIFIED.id())}));
        this.zkClient().setBrokerHealthState((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)degradedBrokerComponents), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)degradedBrokerComponents)})));
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        this.adminClientConfig().put("bootstrap.servers", TestUtils$.MODULE$.bootstrapServers(this.servers(), this.listenerName()));
        this.adminClient_$eq(this.createCloudAdminClient(this.createCloudAdminClient$default$1()));
        TestUtils$.MODULE$.waitForOnlineBroker((Admin)this.adminClient(), 2);
        TestUtils$.MODULE$.waitForOnlineBroker((Admin)this.adminClient(), 1);
        TestUtils$.MODULE$.waitForOnlineBroker((Admin)this.adminClient(), 0);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerHealthTest.$anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthTest.$anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$4(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterBrokerHealth(String quorum) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), this.getBrokerHealthMap());
        scala.collection.immutable.Seq x$1 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}));
        ComponentHealthStatus x$5 = this.alterBrokerHealthAndGetResponse$default$4();
        short x$6 = ApiKeys.ALTER_BROKER_HEALTH.latestVersion();
        SocketServer x$7 = this.alterBrokerHealthAndGetResponse$default$7();
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(0, BrokerComponent.STORAGE, this.createBrokerHealthStatusResult$default$3(), this.createBrokerHealthStatusResult$default$4(), this.createBrokerHealthStatusResult$default$5()), (List)new .colon.colon((Object)this.createBrokerHealthStatusResult(1, BrokerComponent.STORAGE, this.createBrokerHealthStatusResult$default$3(), this.createBrokerHealthStatusResult$default$4(), this.createBrokerHealthStatusResult$default$5()), (List)Nil$.MODULE$)), this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$1, "reason", BrokerComponent.STORAGE, x$5, true, x$6, x$7).data(), this.checkResponse$default$3());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new DegradedBroker(0, Collections.singleton(new DegradedBrokerComponent("reason", BrokerComponent.STORAGE.id())))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new DegradedBroker(1, Collections.singleton(new DegradedBrokerComponent("reason", BrokerComponent.STORAGE.id()))))})), this.getBrokerHealthMap());
        scala.collection.immutable.Seq x$8 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
        BrokerComponent x$11 = this.alterBrokerHealthAndGetResponse$default$3();
        ComponentHealthStatus x$12 = this.alterBrokerHealthAndGetResponse$default$4();
        short x$13 = this.alterBrokerHealthAndGetResponse$default$6();
        SocketServer x$14 = this.alterBrokerHealthAndGetResponse$default$7();
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(1, this.createBrokerHealthStatusResult$default$2(), this.createBrokerHealthStatusResult$default$3(), this.createBrokerHealthStatusResult$default$4(), this.createBrokerHealthStatusResult$default$5()), (List)new .colon.colon((Object)this.createBrokerHealthStatusResult(2, this.createBrokerHealthStatusResult$default$2(), this.createBrokerHealthStatusResult$default$3(), this.createBrokerHealthStatusResult$default$4(), this.createBrokerHealthStatusResult$default$5()), (List)Nil$.MODULE$)), this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$8, "reason2", x$11, x$12, true, x$13, x$14).data(), this.checkResponse$default$3());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new DegradedBroker(0, Collections.singleton(new DegradedBrokerComponent("reason", BrokerComponent.STORAGE.id())))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new DegradedBroker(1, CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{new DegradedBrokerComponent("reason", BrokerComponent.STORAGE.id()), new DegradedBrokerComponent("reason2", BrokerComponent.UNSPECIFIED.id())}))).asJava())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new DegradedBroker(2, Collections.singleton(new DegradedBrokerComponent("reason2", BrokerComponent.UNSPECIFIED.id()))))})), this.getBrokerHealthMap());
        scala.collection.immutable.Seq x$15 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
        ComponentHealthStatus x$19 = this.alterBrokerHealthAndGetResponse$default$4();
        short x$20 = this.alterBrokerHealthAndGetResponse$default$6();
        SocketServer x$21 = this.alterBrokerHealthAndGetResponse$default$7();
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(1, BrokerComponent.STORAGE, this.createBrokerHealthStatusResult$default$3(), this.createBrokerHealthStatusResult$default$4(), this.createBrokerHealthStatusResult$default$5()), (List)new .colon.colon((Object)this.createBrokerHealthStatusResult(2, BrokerComponent.STORAGE, this.createBrokerHealthStatusResult$default$3(), this.createBrokerHealthStatusResult$default$4(), this.createBrokerHealthStatusResult$default$5()), (List)Nil$.MODULE$)), this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$15, "reason", BrokerComponent.STORAGE, x$19, true, x$20, x$21).data(), this.checkResponse$default$3());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new DegradedBroker(0, Collections.singleton(new DegradedBrokerComponent("reason", BrokerComponent.STORAGE.id())))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new DegradedBroker(1, CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{new DegradedBrokerComponent("reason", BrokerComponent.STORAGE.id()), new DegradedBrokerComponent("reason2", BrokerComponent.UNSPECIFIED.id())}))).asJava())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new DegradedBroker(2, CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{new DegradedBrokerComponent("reason2", BrokerComponent.UNSPECIFIED.id()), new DegradedBrokerComponent("reason", BrokerComponent.STORAGE.id())}))).asJava()))})), this.getBrokerHealthMap());
        BrokerComponent x$24 = this.createBrokerHealthStatusResult$default$2();
        Errors x$25 = this.createBrokerHealthStatusResult$default$4();
        String x$26 = this.createBrokerHealthStatusResult$default$5();
        BrokerComponent x$29 = this.createBrokerHealthStatusResult$default$2();
        Errors x$30 = this.createBrokerHealthStatusResult$default$4();
        String x$31 = this.createBrokerHealthStatusResult$default$5();
        scala.collection.immutable.Seq x$32 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
        BrokerComponent x$35 = this.alterBrokerHealthAndGetResponse$default$3();
        boolean x$36 = this.alterBrokerHealthAndGetResponse$default$5();
        short x$37 = this.alterBrokerHealthAndGetResponse$default$6();
        SocketServer x$38 = this.alterBrokerHealthAndGetResponse$default$7();
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(1, x$24, ComponentHealthStatus.HEALTHY, x$25, x$26), (List)new .colon.colon((Object)this.createBrokerHealthStatusResult(2, x$29, ComponentHealthStatus.HEALTHY, x$30, x$31), (List)Nil$.MODULE$)), this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$32, "reason2", x$35, ComponentHealthStatus.HEALTHY, x$36, x$37, x$38).data(), this.checkResponse$default$3());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new DegradedBroker(0, Collections.singleton(new DegradedBrokerComponent("reason", BrokerComponent.STORAGE.id())))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new DegradedBroker(1, Collections.singleton(new DegradedBrokerComponent("reason", BrokerComponent.STORAGE.id())))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new DegradedBroker(2, Collections.singleton(new DegradedBrokerComponent("reason", BrokerComponent.STORAGE.id()))))})), this.getBrokerHealthMap());
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(0, BrokerComponent.STORAGE, ComponentHealthStatus.HEALTHY, this.createBrokerHealthStatusResult$default$4(), this.createBrokerHealthStatusResult$default$5()), (List)new .colon.colon((Object)this.createBrokerHealthStatusResult(2, BrokerComponent.STORAGE, ComponentHealthStatus.HEALTHY, this.createBrokerHealthStatusResult$default$4(), this.createBrokerHealthStatusResult$default$5()), (List)Nil$.MODULE$)), this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2}))), "reason", BrokerComponent.STORAGE, ComponentHealthStatus.HEALTHY, true, this.alterBrokerHealthAndGetResponse$default$6(), this.alterBrokerHealthAndGetResponse$default$7()).data(), this.checkResponse$default$3());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new DegradedBroker(1, Collections.singleton(new DegradedBrokerComponent("reason", BrokerComponent.STORAGE.id()))))})), this.getBrokerHealthMap());
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(1, BrokerComponent.STORAGE, ComponentHealthStatus.HEALTHY, this.createBrokerHealthStatusResult$default$4(), this.createBrokerHealthStatusResult$default$5()), (List)Nil$.MODULE$), this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}))), "reason", BrokerComponent.STORAGE, ComponentHealthStatus.HEALTHY, this.alterBrokerHealthAndGetResponse$default$5(), this.alterBrokerHealthAndGetResponse$default$6(), this.alterBrokerHealthAndGetResponse$default$7()).data(), this.checkResponse$default$3());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), this.getBrokerHealthMap());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testAlterBrokerHealthOnUnregisteredBrokers(String quorum) {
        scala.collection.immutable.Seq x$1 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3}));
        ComponentHealthStatus x$5 = ComponentHealthStatus.DEGRADED;
        short x$6 = ApiKeys.ALTER_BROKER_HEALTH.latestVersion();
        SocketServer x$7 = this.adminSocketServer();
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(1, BrokerComponent.STORAGE, ComponentHealthStatus.DEGRADED, Errors.NONE, ""), (List)new .colon.colon((Object)this.createBrokerHealthStatusResult(3, BrokerComponent.STORAGE, ComponentHealthStatus.DEGRADED, Errors.NONE, ""), (List)Nil$.MODULE$)), this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$1, "reason", BrokerComponent.STORAGE, x$5, true, x$6, x$7).data(), Errors.NONE.code());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new DegradedBroker(1, Collections.singleton(new DegradedBrokerComponent("reason", BrokerComponent.STORAGE.id())))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)new DegradedBroker(3, Collections.singleton(new DegradedBrokerComponent("reason", BrokerComponent.STORAGE.id()))))})), this.getBrokerHealthMap());
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(1, BrokerComponent.STORAGE, ComponentHealthStatus.HEALTHY, Errors.NONE, ""), (List)new .colon.colon((Object)this.createBrokerHealthStatusResult(3, BrokerComponent.STORAGE, ComponentHealthStatus.HEALTHY, Errors.NONE, ""), (List)Nil$.MODULE$)), this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3}))), "reason", BrokerComponent.STORAGE, ComponentHealthStatus.HEALTHY, false, ApiKeys.ALTER_BROKER_HEALTH.latestVersion(), this.adminSocketServer()).data(), Errors.NONE.code());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), this.getBrokerHealthMap());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testKRaftAlterBrokerHealthOnUnregisteredBrokers(String quorum) {
        scala.collection.immutable.Seq x$1 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3}));
        ComponentHealthStatus x$5 = ComponentHealthStatus.DEGRADED;
        short x$6 = ApiKeys.ALTER_BROKER_HEALTH.latestVersion();
        SocketServer x$7 = this.adminSocketServer();
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)package$.MODULE$.List().empty(), this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$1, "reason", BrokerComponent.STORAGE, x$5, true, x$6, x$7).data(), Errors.INVALID_REQUEST.code());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), this.getBrokerHealthMap());
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)package$.MODULE$.List().empty(), this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3}))), "reason", BrokerComponent.STORAGE, ComponentHealthStatus.HEALTHY, false, ApiKeys.ALTER_BROKER_HEALTH.latestVersion(), this.adminSocketServer()).data(), Errors.INVALID_REQUEST.code());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), this.getBrokerHealthMap());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterBrokerHealthPropagatesHealthState(String quorum) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), this.getBrokerHealthMap());
        scala.collection.immutable.Seq x$1 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        ComponentHealthStatus x$5 = ComponentHealthStatus.DEGRADED;
        short x$6 = ApiKeys.ALTER_BROKER_HEALTH.latestVersion();
        SocketServer x$7 = this.adminSocketServer();
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(0, BrokerComponent.STORAGE, ComponentHealthStatus.DEGRADED, Errors.NONE, ""), (List)Nil$.MODULE$), this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$1, "reason", BrokerComponent.STORAGE, x$5, true, x$6, x$7).data(), Errors.NONE.code());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new DegradedBroker(0, Collections.singleton(new DegradedBrokerComponent("reason", BrokerComponent.STORAGE.id()))))})), this.getBrokerHealthMap());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerHealthTest.$anonfun$testAlterBrokerHealthPropagatesHealthState$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Broker 0 should be degraded on all brokers.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDemotionsExceedsMaxBrokers(String quorum) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), this.getBrokerHealthMap());
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(0, BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, Errors.NONE, ""), (List)new .colon.colon((Object)this.createBrokerHealthStatusResult(1, BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, Errors.NONE, ""), (List)Nil$.MODULE$)), this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}))), "reason", BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, false, ApiKeys.ALTER_BROKER_HEALTH.latestVersion(), this.adminSocketServer()).data(), Errors.NONE.code());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new DegradedBroker(0, Collections.singleton(new DegradedBrokerComponent("reason", BrokerComponent.UNSPECIFIED.id())))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new DegradedBroker(1, Collections.singleton(new DegradedBrokerComponent("reason", BrokerComponent.UNSPECIFIED.id()))))})), this.getBrokerHealthMap());
        scala.collection.immutable.Seq x$1 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3}));
        ComponentHealthStatus x$4 = ComponentHealthStatus.DEGRADED;
        boolean x$5 = false;
        short x$6 = ApiKeys.ALTER_BROKER_HEALTH.latestVersion();
        SocketServer x$7 = this.adminSocketServer();
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)Nil$.MODULE$, this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$1, "reason", BrokerComponent.STORAGE, x$4, x$5, x$6, x$7).data(), Errors.DEMOTION_LIMIT_REACHED.code());
        BrokerComponent x$10 = BrokerComponent.UNSPECIFIED;
        Errors x$11 = Errors.NONE;
        String x$12 = "";
        BrokerComponent x$15 = BrokerComponent.UNSPECIFIED;
        Errors x$16 = Errors.NONE;
        String x$17 = "";
        scala.collection.immutable.Seq x$18 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}));
        BrokerComponent x$22 = BrokerComponent.UNSPECIFIED;
        short x$23 = ApiKeys.ALTER_BROKER_HEALTH.latestVersion();
        SocketServer x$24 = this.adminSocketServer();
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(0, x$10, ComponentHealthStatus.HEALTHY, x$11, x$12), (List)new .colon.colon((Object)this.createBrokerHealthStatusResult(1, x$15, ComponentHealthStatus.HEALTHY, x$16, x$17), (List)Nil$.MODULE$)), this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$18, "reason", x$22, ComponentHealthStatus.HEALTHY, true, x$23, x$24).data(), Errors.NONE.code());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), this.getBrokerHealthMap());
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)Nil$.MODULE$, this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), "reason", BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, false, ApiKeys.ALTER_BROKER_HEALTH.latestVersion(), this.adminSocketServer()).data(), Errors.DEMOTION_LIMIT_REACHED.code());
        scala.collection.immutable.Seq x$25 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        BrokerComponent x$28 = BrokerComponent.UNSPECIFIED;
        ComponentHealthStatus x$29 = ComponentHealthStatus.DEGRADED;
        boolean x$30 = false;
        SocketServer x$31 = this.adminSocketServer();
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(0, BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, Errors.NONE, ""), (List)new .colon.colon((Object)this.createBrokerHealthStatusResult(1, BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, Errors.NONE, ""), (List)new .colon.colon((Object)this.createBrokerHealthStatusResult(2, BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, Errors.NONE, ""), (List)Nil$.MODULE$))), this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$25, "reason", x$28, x$29, x$30, (short)0, x$31).data(), Errors.NONE.code());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDemotionsWhenTooFewLiveBrokers(String quorum) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), this.getBrokerHealthMap());
        this.killBroker(1);
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)Nil$.MODULE$, this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))), "reason", BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, false, ApiKeys.ALTER_BROKER_HEALTH.latestVersion(), this.adminSocketServer()).data(), Errors.DEMOTION_LIMIT_REACHED.code());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterBrokerHealthIdempotence(String quorum) {
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(0, BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, Errors.NONE, ""), (List)new .colon.colon((Object)this.createBrokerHealthStatusResult(1, BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, Errors.NONE, ""), (List)Nil$.MODULE$)), this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}))), "reason", BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, false, ApiKeys.ALTER_BROKER_HEALTH.latestVersion(), this.adminSocketServer()).data(), Errors.NONE.code());
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(0, BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, Errors.NONE, ""), (List)new .colon.colon((Object)this.createBrokerHealthStatusResult(1, BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, Errors.NONE, ""), (List)Nil$.MODULE$)), this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}))), "reason", BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, false, ApiKeys.ALTER_BROKER_HEALTH.latestVersion(), this.adminSocketServer()).data(), Errors.NONE.code());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new DegradedBroker(0, Collections.singleton(new DegradedBrokerComponent("reason", BrokerComponent.UNSPECIFIED.id())))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new DegradedBroker(1, Collections.singleton(new DegradedBrokerComponent("reason", BrokerComponent.UNSPECIFIED.id()))))})), this.getBrokerHealthMap());
        BrokerComponent x$3 = BrokerComponent.UNSPECIFIED;
        Errors x$4 = Errors.NONE;
        String x$5 = "";
        scala.collection.immutable.Seq x$6 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        BrokerComponent x$9 = BrokerComponent.UNSPECIFIED;
        boolean x$10 = false;
        short x$11 = ApiKeys.ALTER_BROKER_HEALTH.latestVersion();
        SocketServer x$12 = this.adminSocketServer();
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(0, x$3, ComponentHealthStatus.HEALTHY, x$4, x$5), (List)Nil$.MODULE$), this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$6, "reason", x$9, ComponentHealthStatus.HEALTHY, x$10, x$11, x$12).data(), Errors.NONE.code());
        BrokerComponent x$15 = BrokerComponent.UNSPECIFIED;
        Errors x$16 = Errors.NONE;
        String x$17 = "";
        scala.collection.immutable.Seq x$18 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        BrokerComponent x$21 = BrokerComponent.UNSPECIFIED;
        boolean x$22 = false;
        short x$23 = ApiKeys.ALTER_BROKER_HEALTH.latestVersion();
        SocketServer x$24 = this.adminSocketServer();
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(0, x$15, ComponentHealthStatus.HEALTHY, x$16, x$17), (List)Nil$.MODULE$), this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$18, "reason", x$21, ComponentHealthStatus.HEALTHY, x$22, x$23, x$24).data(), Errors.NONE.code());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new DegradedBroker(1, Collections.singleton(new DegradedBrokerComponent("reason", BrokerComponent.UNSPECIFIED.id()))))})), this.getBrokerHealthMap());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testAlterBrokerHealthHandlesNotControllerException(String quorum) {
        scala.collection.immutable.Seq x$1 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        SocketServer x$3 = this.notControllerSocketServer();
        BrokerComponent x$4 = BrokerComponent.UNSPECIFIED;
        ComponentHealthStatus x$5 = ComponentHealthStatus.DEGRADED;
        boolean x$6 = false;
        short x$7 = ApiKeys.ALTER_BROKER_HEALTH.latestVersion();
        AlterBrokerHealthResponse response = this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$1, "reason", x$4, x$5, x$6, x$7, x$3);
        Assertions.assertEquals((short)Errors.NOT_CONTROLLER.code(), (short)response.data().errorCode());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterBrokerHealthHandlesInvalidRequestException(String quorum) {
        Assertions.assertEquals((short)Errors.INVALID_REQUEST.code(), (short)this.alterBrokerHealthAndGetResponse(this.alterBrokerHealthAndGetResponse$default$1(), "", BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, false, ApiKeys.ALTER_BROKER_HEALTH.latestVersion(), this.adminSocketServer()).data().errorCode());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testDescribeBrokerHealthHandlesNotControllerException(String quorum) {
        DescribeBrokerHealthRequest request = (DescribeBrokerHealthRequest)new DescribeBrokerHealthRequest.Builder().build();
        DescribeBrokerHealthResponse response = (DescribeBrokerHealthResponse)this.connectAndReceive((AbstractRequest)request, this.notControllerSocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeBrokerHealthResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((short)Errors.NOT_CONTROLLER.code(), (short)response.data().errorCode());
    }

    private AlterBrokerHealthResponseData.BrokerHealthStatusResult createBrokerHealthStatusResult(int brokerId, BrokerComponent component, ComponentHealthStatus healthStatus, Errors error, String errorMsg) {
        String string;
        String string2 = errorMsg;
        String string3 = "";
        if (string2 == null || !string2.equals(string3)) {
            string = errorMsg;
        } else {
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            string = !(errors != null ? !errors.equals(errors2) : errors2 != null) ? "" : error.message();
        }
        String msg = string;
        return new AlterBrokerHealthResponseData.BrokerHealthStatusResult().setBrokerId(brokerId).setComponentCode(component.id()).setStatusCode(healthStatus.id()).setErrorCode(error.code()).setErrorMessage(Optional.ofNullable(msg).orElse(""));
    }

    private BrokerComponent createBrokerHealthStatusResult$default$2() {
        return BrokerComponent.UNSPECIFIED;
    }

    private ComponentHealthStatus createBrokerHealthStatusResult$default$3() {
        return ComponentHealthStatus.DEGRADED;
    }

    private Errors createBrokerHealthStatusResult$default$4() {
        return Errors.NONE;
    }

    private String createBrokerHealthStatusResult$default$5() {
        return "";
    }

    private scala.collection.immutable.Map<Object, DegradedBroker> getBrokerHealthMap() {
        DescribeBrokerHealthRequest request = (DescribeBrokerHealthRequest)new DescribeBrokerHealthRequest.Builder().build();
        DescribeBrokerHealthResponse response = (DescribeBrokerHealthResponse)this.connectAndReceive((AbstractRequest)request, this.adminSocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeBrokerHealthResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((short)Errors.NONE.code(), (short)response.data().errorCode());
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        response.data().degradedBrokers().forEach(degradedBroker -> result.put((Object)BoxesRunTime.boxToInteger((int)degradedBroker.brokerId()), (Object)new DegradedBroker(degradedBroker.brokerId(), CollectionConverters$.MODULE$.SetHasAsJava((Set)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(degradedBroker.degradedBrokerComponents()).asScala().map((Function1 & Serializable)degradedBrokerComponent -> new DegradedBrokerComponent(degradedBrokerComponent.reason(), degradedBrokerComponent.componentCode()))).toSet()).asJava())));
        return result.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private AlterBrokerHealthResponse alterBrokerHealthAndGetResponse(scala.collection.immutable.Seq<Object> brokerIds, String reason, BrokerComponent component, ComponentHealthStatus healthStatus, boolean force, short version, SocketServer socketServer) {
        AlterBrokerHealthRequest request = new AlterBrokerHealthRequest.Builder(new AlterBrokerHealthRequestData().setBrokerIds(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokerIds.map((Function1 & Serializable)x -> BoxesRunTime.unboxToInt((Object)x))).asJava()).setReason(reason).setComponentCode(component.id()).setStatusCode(healthStatus.id()).setForce(force)).build(version);
        return (AlterBrokerHealthResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AlterBrokerHealthResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private scala.collection.immutable.Seq<Object> alterBrokerHealthAndGetResponse$default$1() {
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    }

    private String alterBrokerHealthAndGetResponse$default$2() {
        return "";
    }

    private BrokerComponent alterBrokerHealthAndGetResponse$default$3() {
        return BrokerComponent.UNSPECIFIED;
    }

    private ComponentHealthStatus alterBrokerHealthAndGetResponse$default$4() {
        return ComponentHealthStatus.DEGRADED;
    }

    private boolean alterBrokerHealthAndGetResponse$default$5() {
        return false;
    }

    private short alterBrokerHealthAndGetResponse$default$6() {
        return ApiKeys.ALTER_BROKER_HEALTH.latestVersion();
    }

    private SocketServer alterBrokerHealthAndGetResponse$default$7() {
        return this.adminSocketServer();
    }

    private void createTopic(Admin adminClient, String topicName, scala.collection.immutable.Map<Object, List<Object>> topicAssignment) {
        java.util.Map replicasAssignments = CollectionConverters$.MODULE$.MapHasAsJava((Map)topicAssignment.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int key = x0$1._1$mcI$sp();
                List value = (List)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)value.map((Function1 & Serializable)x -> BrokerHealthTest.$anonfun$createTopic$2(BoxesRunTime.unboxToInt((Object)x)))).asJava());
            }
            throw new MatchError(null);
        })).asJava();
        adminClient.createTopics(Collections.singletonList(new NewTopic(topicName, replicasAssignments))).all().get();
    }

    private void demoteBroker(int brokerId, boolean force) {
        this.adminClient().alterBrokerHealth(new AlterBrokerHealthSpec(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)brokerId)}))).asJava(), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, "testing", force), new AlterBrokerHealthOptions()).all().get();
    }

    private boolean demoteBroker$default$2() {
        return false;
    }

    private void promoteBroker(int brokerId, boolean force) {
        this.adminClient().alterBrokerHealth(new AlterBrokerHealthSpec(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)brokerId)}))).asJava(), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.HEALTHY, "testing", force), new AlterBrokerHealthOptions()).all().get();
    }

    private boolean promoteBroker$default$2() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void validateNoLeadersOnDemotedBrokers(String topicName, scala.collection.immutable.Set<Object> demotedBrokerIds) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerHealthTest.$anonfun$validateNoLeadersOnDemotedBrokers$1(this, topicName, demotedBrokerIds)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthTest.$anonfun$validateNoLeadersOnDemotedBrokers$4(topicName));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void validateLeadersPresentOnPromotedBroker(String topicName, int brokerId) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerHealthTest.$anonfun$validateLeadersPresentOnPromotedBroker$1(this, topicName, brokerId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthTest.$anonfun$validateLeadersPresentOnPromotedBroker$4(topicName));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void validateLeadersPresentOnAllBrokers(String topicName, int numberOfBrokers) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerHealthTest.$anonfun$validateLeadersPresentOnAllBrokers$1(this, topicName, numberOfBrokers)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthTest.$anonfun$validateLeadersPresentOnAllBrokers$3(topicName));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void checkResponse(List<AlterBrokerHealthResponseData.BrokerHealthStatusResult> expectedResults, AlterBrokerHealthResponseData actualResponse, short errorCode) {
        Assertions.assertEquals((short)errorCode, (short)actualResponse.errorCode());
        Assertions.assertEquals((int)expectedResults.size(), (int)actualResponse.brokerHealthStatusResults().size());
        expectedResults.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Assertions.assertEquals((Object)expectedResults.apply(i), actualResponse.brokerHealthStatusResults().get(i)));
    }

    private short checkResponse$default$3() {
        return Errors.NONE.code();
    }

    public static final /* synthetic */ boolean $anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$2(TopicPartitionInfo p) {
        return p.leader().id() == 2;
    }

    public static final /* synthetic */ boolean $anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$3(boolean x, boolean y) {
        return x && y;
    }

    public static final /* synthetic */ boolean $anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$1(BrokerHealthTest $this) {
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)$this.adminClient().describeTopics(Collections.singletonList($this.topicName())).topicNameValues().get($this.topicName())).get();
        return BoxesRunTime.unboxToBoolean((Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(topicDescription.partitions()).asScala().map((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)BrokerHealthTest.$anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$2(p)))).reduce((Function2 & Serializable)(x, y) -> BoxesRunTime.boxToBoolean((boolean)BrokerHealthTest.$anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$3(BoxesRunTime.unboxToBoolean((Object)x), BoxesRunTime.unboxToBoolean((Object)y)))));
    }

    public static final /* synthetic */ String $anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$4(BrokerHealthTest $this) {
        return new StringBuilder(45).append("Topic ").append($this.topicName()).append(" does not have all leaders on broker 2.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testAlterBrokerHealthPropagatesHealthState$2(KafkaBroker x$2) {
        return x$2.metadataCache().isBrokerDegraded(0);
    }

    public static final /* synthetic */ boolean $anonfun$testAlterBrokerHealthPropagatesHealthState$3(boolean x, boolean y) {
        return x && y;
    }

    public static final /* synthetic */ boolean $anonfun$testAlterBrokerHealthPropagatesHealthState$1(BrokerHealthTest $this) {
        return BoxesRunTime.unboxToBoolean((Object)((IterableOnceOps)$this.brokers().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)BrokerHealthTest.$anonfun$testAlterBrokerHealthPropagatesHealthState$2(x$2)))).reduce((Function2 & Serializable)(x, y) -> BoxesRunTime.boxToBoolean((boolean)BrokerHealthTest.$anonfun$testAlterBrokerHealthPropagatesHealthState$3(BoxesRunTime.unboxToBoolean((Object)x), BoxesRunTime.unboxToBoolean((Object)y)))));
    }

    public static final /* synthetic */ String $anonfun$testAlterBrokerHealthPropagatesHealthState$4() {
        return "Broker 0 should be degraded on all brokers.";
    }

    public static final /* synthetic */ Integer $anonfun$createTopic$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ boolean $anonfun$validateNoLeadersOnDemotedBrokers$2(scala.collection.immutable.Set demotedBrokerIds$1, TopicPartitionInfo p) {
        return !demotedBrokerIds$1.contains((Object)BoxesRunTime.boxToInteger((int)p.leader().id()));
    }

    public static final /* synthetic */ boolean $anonfun$validateNoLeadersOnDemotedBrokers$3(boolean x, boolean y) {
        return x && y;
    }

    public static final /* synthetic */ boolean $anonfun$validateNoLeadersOnDemotedBrokers$1(BrokerHealthTest $this, String topicName$1, scala.collection.immutable.Set demotedBrokerIds$1) {
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)$this.adminClient().describeTopics(Collections.singletonList(topicName$1)).topicNameValues().get(topicName$1)).get();
        return BoxesRunTime.unboxToBoolean((Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(topicDescription.partitions()).asScala().map((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)BrokerHealthTest.$anonfun$validateNoLeadersOnDemotedBrokers$2(demotedBrokerIds$1, p)))).reduce((Function2 & Serializable)(x, y) -> BoxesRunTime.boxToBoolean((boolean)BrokerHealthTest.$anonfun$validateNoLeadersOnDemotedBrokers$3(BoxesRunTime.unboxToBoolean((Object)x), BoxesRunTime.unboxToBoolean((Object)y)))));
    }

    public static final /* synthetic */ String $anonfun$validateNoLeadersOnDemotedBrokers$4(String topicName$1) {
        return new StringBuilder(38).append("Topic ").append(topicName$1).append(" has a demoted broker as leader.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$validateLeadersPresentOnPromotedBroker$2(int brokerId$1, TopicPartitionInfo p) {
        return p.leader().id() == brokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$validateLeadersPresentOnPromotedBroker$3(boolean x, boolean y) {
        return x || y;
    }

    public static final /* synthetic */ boolean $anonfun$validateLeadersPresentOnPromotedBroker$1(BrokerHealthTest $this, String topicName$2, int brokerId$1) {
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)$this.adminClient().describeTopics(Collections.singletonList(topicName$2)).topicNameValues().get(topicName$2)).get();
        return BoxesRunTime.unboxToBoolean((Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(topicDescription.partitions()).asScala().map((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)BrokerHealthTest.$anonfun$validateLeadersPresentOnPromotedBroker$2(brokerId$1, p)))).reduce((Function2 & Serializable)(x, y) -> BoxesRunTime.boxToBoolean((boolean)BrokerHealthTest.$anonfun$validateLeadersPresentOnPromotedBroker$3(BoxesRunTime.unboxToBoolean((Object)x), BoxesRunTime.unboxToBoolean((Object)y)))));
    }

    public static final /* synthetic */ String $anonfun$validateLeadersPresentOnPromotedBroker$4(String topicName$2) {
        return new StringBuilder(41).append("Topic ").append(topicName$2).append(" has no leaders on promoted broker.").toString();
    }

    public static final /* synthetic */ int $anonfun$validateLeadersPresentOnAllBrokers$2(TopicPartitionInfo p) {
        return p.leader().id();
    }

    public static final /* synthetic */ boolean $anonfun$validateLeadersPresentOnAllBrokers$1(BrokerHealthTest $this, String topicName$3, int numberOfBrokers$1) {
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)$this.adminClient().describeTopics(Collections.singletonList(topicName$3)).topicNameValues().get(topicName$3)).get();
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(topicDescription.partitions()).asScala().map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)BrokerHealthTest.$anonfun$validateLeadersPresentOnAllBrokers$2(p)))).toSet().size() == numberOfBrokers$1;
    }

    public static final /* synthetic */ String $anonfun$validateLeadersPresentOnAllBrokers$3(String topicName$3) {
        return new StringBuilder(44).append("Topic ").append(topicName$3).append(" does not have leaders on all brokers.").toString();
    }

    public BrokerHealthTest() {
        this.controllerConfig().setProperty(KafkaConfig$.MODULE$.AlterBrokerHealthMaxDemotedBrokersPercentageProp(), "67");
        this.adminClient = null;
        this.topicName = "topic";
        this.p0 = 0;
        this.p1 = 1;
        this.p2 = 2;
    }
}

