/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.rest.BeginShutdownControllerStatus;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import kafka.server.BeginShutdownControllerHandleAdapter;
import kafka.server.ControllerStatusHandleAdapter$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeMetadataQuorumOptions;
import org.apache.kafka.clients.admin.DescribeMetadataQuorumResult;
import org.apache.kafka.clients.admin.QuorumInfo;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.None$;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005Y4AAD\b\u0001)!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0003\u0001\u0003BB\u0015\u0001A\u0003%\u0011\u0005C\u0004+\u0001\t\u0007I\u0011A\u0016\t\r=\u0002\u0001\u0015!\u0003-\u0011\u0015\u0001\u0004\u0001\"\u00012\u0011\u0015\u0011\u0005\u0001\"\u00012\u0011\u0015!\u0005\u0001\"\u00012\u0011\u00151\u0005\u0001\"\u00012\u0011\u0015A\u0005\u0001\"\u00012\u0011\u0015Q\u0005\u0001\"\u0003L\u0011\u0015Q\u0005\u0001\"\u0003a\u0011\u0015y\u0007\u0001\"\u0003q\u0005!\u0012UmZ5o'\",H\u000fZ8x]\u000e{g\u000e\u001e:pY2,'\u000fS1oI2,\u0017\tZ1qi\u0016\u0014H+Z:u\u0015\t\u0001\u0012#\u0001\u0004tKJ4XM\u001d\u0006\u0002%\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0016!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011aD\u0001\u0006aJ|\u0007o]\u000b\u0002CA\u0011!eJ\u0007\u0002G)\u0011A%J\u0001\u0005kRLGNC\u0001'\u0003\u0011Q\u0017M^1\n\u0005!\u001a#A\u0003)s_B,'\u000f^5fg\u00061\u0001O]8qg\u0002\naaY8oM&<W#\u0001\u0017\u0011\u0005yi\u0013B\u0001\u0018\u0010\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u0005)B/Z:u%>dG.\u00192mK^KG\u000f\u001b(p\u0019\u0006<G#\u0001\u001a\u0011\u0005Y\u0019\u0014B\u0001\u001b\u0018\u0005\u0011)f.\u001b;)\u0005\u00191\u0004CA\u001cA\u001b\u0005A$BA\u001d;\u0003\r\t\u0007/\u001b\u0006\u0003wq\nqA[;qSR,'O\u0003\u0002>}\u0005)!.\u001e8ji*\tq(A\u0002pe\u001eL!!\u0011\u001d\u0003\tQ+7\u000f^\u0001'i\u0016\u001cHOU8mY\u0006\u0014G.Z,ji\",\u00050Y2uYfl\u0015\r_!mY><\u0018M\u00197f\u0019\u0006<\u0007FA\u00047\u0003U\"Xm\u001d;O_R\u0014v\u000e\u001c7bE2,w\u000b[3o'>lWMT8eK2\u000bwm\u001d\"z\u001b>\u0014X\r\u00165b]6\u000b\u00070\u00117m_^\f'\r\\3)\u0005!1\u0014A\n;fgRtu\u000e\u001e*pY2\f'\r\\3XQ\u0016t7k\\7f\u001d>$W\rS1t\u001d>|eMZ:fi\"\u0012\u0011BN\u0001 i\u0016\u001cHOT8u%\u0016\fG-_,iK:,\u0005pY3qi&|gnT2dkJ\u001c\bF\u0001\u00067\u0003=\u0019'/Z1uK6{7m[!e[&tG\u0003\u0002'X9z\u0003\"!T+\u000e\u00039S!a\u0014)\u0002\u000b\u0005$W.\u001b8\u000b\u0005E\u0013\u0016aB2mS\u0016tGo\u001d\u0006\u0003%MS!\u0001\u0016 \u0002\r\u0005\u0004\u0018m\u00195f\u0013\t1fJ\u0001\bD_:4G.^3oi\u0006#W.\u001b8\t\u000ba[\u0001\u0019A-\u0002)I,\u0007\u000f\\5dCFbunZ#oI>3gm]3u!\t1\",\u0003\u0002\\/\t!Aj\u001c8h\u0011\u0015i6\u00021\u0001Z\u0003Q\u0011X\r\u001d7jG\u0006\u0014Dj\\4F]\u0012|eMZ:fi\")ql\u0003a\u00013\u0006!\"/\u001a9mS\u000e\f7\u0007T8h\u000b:$wJ\u001a4tKR$\"\u0001T1\t\u000b\td\u0001\u0019A2\u0002\u0003\u0015\u0004\"\u0001\u001a7\u000f\u0005\u0015TgB\u00014j\u001b\u00059'B\u00015\u0014\u0003\u0019a$o\\8u}%\t\u0001$\u0003\u0002l/\u00059\u0001/Y2lC\u001e,\u0017BA7o\u0005%)\u0005pY3qi&|gN\u0003\u0002l/\u00059s-\u001a8fe\u0006$XMU8mY\u0006\u0014G.Z*uCR,8/\u00118e\u0003N\u001cXM\u001d;S_2d\u0017M\u00197f)\t\u0011\u0014\u000fC\u0003s\u001b\u0001\u00071/A\u0004bI\u0006\u0004H/\u001a:\u0011\u0005y!\u0018BA;\u0010\u0005\u0011\u0012UmZ5o'\",H\u000fZ8x]\u000e{g\u000e\u001e:pY2,'\u000fS1oI2,\u0017\tZ1qi\u0016\u0014\b")
public class BeginShutdownControllerHandleAdapterTest {
    private final Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2121", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
    private final KafkaConfig config;

    public Properties props() {
        return this.props;
    }

    public KafkaConfig config() {
        return this.config;
    }

    @Test
    public void testRollableWithNoLag() {
        ConfluentAdmin admin = this.createMockAdmin(100L, 200L, 300L);
        BeginShutdownControllerHandleAdapter adapter = new BeginShutdownControllerHandleAdapter("", this.config(), admin);
        this.generateRollableStatusAndAssertRollable(adapter);
    }

    @Test
    public void testRollableWithExactlyMaxAllowableLag() {
        ConfluentAdmin admin = this.createMockAdmin(ControllerStatusHandleAdapter$.MODULE$.MaxAllowedOffsetLag(), ControllerStatusHandleAdapter$.MODULE$.MaxAllowedOffsetLag() + 1, ControllerStatusHandleAdapter$.MODULE$.MaxAllowedOffsetLag() * 2);
        BeginShutdownControllerHandleAdapter adapter = new BeginShutdownControllerHandleAdapter("", this.config(), admin);
        this.generateRollableStatusAndAssertRollable(adapter);
    }

    @Test
    public void testNotRollableWhenSomeNodeLagsByMoreThanMaxAllowable() {
        ConfluentAdmin admin = this.createMockAdmin(1L, ControllerStatusHandleAdapter$.MODULE$.MaxAllowedOffsetLag(), ControllerStatusHandleAdapter$.MODULE$.MaxAllowedOffsetLag() + 2);
        BeginShutdownControllerStatus status = new BeginShutdownControllerHandleAdapter("", this.config(), admin).generateRollableStatus();
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)status.rollable()));
        Assertions.assertEquals((Object)new StringBuilder(110).append("Found at least one quorum voter with an offset 1 while the highest offset was ").append(ControllerStatusHandleAdapter$.MODULE$.MaxAllowedOffsetLag() + 2).append(". The max allowed offset lag is ").append(ControllerStatusHandleAdapter$.MODULE$.MaxAllowedOffsetLag()).toString(), (Object)status.reason());
    }

    @Test
    public void testNotRollableWhenSomeNodeHasNoOffset() {
        ConfluentAdmin admin = this.createMockAdmin(-1L, 1L, 1L);
        BeginShutdownControllerStatus status = new BeginShutdownControllerHandleAdapter("", this.config(), admin).generateRollableStatus();
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)status.rollable()));
        Assertions.assertEquals((Object)ControllerStatusHandleAdapter$.MODULE$.UnreachableQuorumMemberMsg(), (Object)status.reason());
    }

    @Test
    public void testNotReadyWhenExceptionOccurs() {
        ConfluentAdmin admin = this.createMockAdmin(new UnsupportedOperationException());
        BeginShutdownControllerStatus status = new BeginShutdownControllerHandleAdapter("", this.config(), admin).generateRollableStatus();
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)status.rollable()));
        Assertions.assertTrue((boolean)status.reason().contains("There was an exception"));
    }

    private ConfluentAdmin createMockAdmin(long replica1LogEndOffset, long replica2LogEndOffset, long replica3LogEndOffset) {
        QuorumInfo.ReplicaState repl1 = (QuorumInfo.ReplicaState)Mockito.mock(QuorumInfo.ReplicaState.class);
        QuorumInfo.ReplicaState repl2 = (QuorumInfo.ReplicaState)Mockito.mock(QuorumInfo.ReplicaState.class);
        QuorumInfo.ReplicaState repl3 = (QuorumInfo.ReplicaState)Mockito.mock(QuorumInfo.ReplicaState.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)repl1.replicaId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)repl2.replicaId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)2));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)repl3.replicaId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)3));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)repl1.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)replica1LogEndOffset));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)repl2.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)replica2LogEndOffset));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)repl3.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)replica3LogEndOffset));
        Buffer voters = (Buffer)Buffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QuorumInfo.ReplicaState[]{repl1, repl2, repl3}));
        QuorumInfo quorumInfo = (QuorumInfo)Mockito.mock(QuorumInfo.class);
        Mockito.when((Object)quorumInfo.voters()).thenReturn((Object)CollectionConverters$.MODULE$.BufferHasAsJava(voters).asJava());
        KafkaFuture quorumFuture = (KafkaFuture)Mockito.mock(KafkaFuture.class);
        Mockito.when((Object)quorumFuture.get()).thenReturn((Object)quorumInfo);
        DescribeMetadataQuorumResult metadataQuorumResult = (DescribeMetadataQuorumResult)Mockito.mock(DescribeMetadataQuorumResult.class);
        Mockito.when((Object)metadataQuorumResult.quorumInfo()).thenReturn((Object)quorumFuture);
        ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        Mockito.when((Object)admin.describeMetadataQuorum((DescribeMetadataQuorumOptions)ArgumentMatchers.any())).thenReturn((Object)metadataQuorumResult);
        return admin;
    }

    private ConfluentAdmin createMockAdmin(Exception e) {
        KafkaFuture quorumFuture = (KafkaFuture)Mockito.mock(KafkaFuture.class);
        Mockito.when((Object)quorumFuture.get()).thenThrow(new Throwable[]{e});
        DescribeMetadataQuorumResult metadataQuorumResult = (DescribeMetadataQuorumResult)Mockito.mock(DescribeMetadataQuorumResult.class);
        Mockito.when((Object)metadataQuorumResult.quorumInfo()).thenReturn((Object)quorumFuture);
        ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        Mockito.when((Object)admin.describeMetadataQuorum((DescribeMetadataQuorumOptions)ArgumentMatchers.any())).thenReturn((Object)metadataQuorumResult);
        return admin;
    }

    private void generateRollableStatusAndAssertRollable(BeginShutdownControllerHandleAdapter adapter) {
        BeginShutdownControllerStatus status = adapter.generateRollableStatus();
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)status.rollable()));
        Assertions.assertEquals((Object)"", (Object)status.reason());
    }

    public BeginShutdownControllerHandleAdapterTest() {
        this.props().put(KafkaConfig$.MODULE$.RequestTimeoutMsProp(), "10000");
        boolean apply_doLog = true;
        Properties apply_props = this.props();
        this.config = new KafkaConfig((Map)apply_props, apply_doLog);
    }
}

