/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.controller.KafkaController;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.server.AutoTopicCreationManager;
import kafka.server.AutoTopicCreationManager$;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerMutationQuota;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.DefaultAutoTopicCreationManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.UnboundedControllerMutationQuota$;
import kafka.server.ZkAdminManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.EnvelopeResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\rh\u0001B A\u0001\u0015CQ\u0001\u0014\u0001\u0005\u00025Cq\u0001\u0015\u0001C\u0002\u0013%\u0011\u000b\u0003\u0004V\u0001\u0001\u0006IA\u0015\u0005\n-\u0002\u0001\r\u00111A\u0005\n]C\u0011b\u0017\u0001A\u0002\u0003\u0007I\u0011\u0002/\t\u0013\t\u0004\u0001\u0019!A!B\u0013A\u0006bB2\u0001\u0005\u0004%I\u0001\u001a\u0005\u0007Q\u0002\u0001\u000b\u0011B3\t\u000f%\u0004!\u0019!C\u0005U\"1a\u000e\u0001Q\u0001\n-Dqa\u001c\u0001C\u0002\u0013%\u0001\u000f\u0003\u0004u\u0001\u0001\u0006I!\u001d\u0005\bk\u0002\u0011\r\u0011\"\u0003w\u0011\u0019a\b\u0001)A\u0005o\"9Q\u0010\u0001b\u0001\n\u0013q\bbBA\r\u0001\u0001\u0006Ia \u0005\n\u00037\u0001!\u0019!C\u0005\u0003;A\u0001\"!\f\u0001A\u0003%\u0011q\u0004\u0005\f\u0003_\u0001\u0001\u0019!a\u0001\n\u0013\t\t\u0004C\u0006\u0002:\u0001\u0001\r\u00111A\u0005\n\u0005m\u0002bCA \u0001\u0001\u0007\t\u0011)Q\u0005\u0003gA\u0001\"!\u0011\u0001\u0005\u0004%I!\u0015\u0005\b\u0003\u0007\u0002\u0001\u0015!\u0003S\u0011%\t)\u0005\u0001b\u0001\n\u0013\t9\u0005\u0003\u0005\u0002P\u0001\u0001\u000b\u0011BA%\u0011%\t\t\u0006\u0001b\u0001\n\u0013\t\u0019\u0006\u0003\u0005\u0002l\u0001\u0001\u000b\u0011BA+\u0011\u001d\ti\u0007\u0001C\u0001\u0003_Bq!a\"\u0001\t\u0003\ty\u0007C\u0004\u0002\u0012\u0002!\t!a\u001c\t\u000f\u0005U\u0005\u0001\"\u0001\u0002p!9\u0011\u0011\u0014\u0001\u0005\u0002\u0005=\u0004bBAO\u0001\u0011\u0005\u0011q\u000e\u0005\b\u0003C\u0003A\u0011BAR\u0011%\ty\rAI\u0001\n\u0013\t\t\u000eC\u0005\u0002h\u0002\t\n\u0011\"\u0003\u0002j\"I\u0011Q\u001e\u0001\u0012\u0002\u0013%\u0011q\u001e\u0005\b\u0003g\u0004A\u0011AA8\u0011\u001d\t9\u0010\u0001C\u0001\u0003_Bq!a?\u0001\t\u0003\ty\u0007C\u0004\u0002\u0000\u0002!\t!a\u001c\t\u000f\t\r\u0001\u0001\"\u0001\u0002p!9!q\u0001\u0001\u0005\u0002\u0005=\u0004b\u0002B\u0006\u0001\u0011\u0005\u0011q\u000e\u0005\b\u0005\u001f\u0001A\u0011AA8\u0011\u001d\u0011\u0019\u0002\u0001C\u0001\u0003_BqAa\u0006\u0001\t\u0003\ty\u0007C\u0004\u0003\u001c\u0001!\t!a\u001c\t\u000f\t}\u0001\u0001\"\u0001\u0002p!9!1\u0005\u0001\u0005\u0002\u0005=\u0004b\u0002B\u0014\u0001\u0011\u0005\u0011q\u000e\u0005\b\u0005W\u0001A\u0011AA8\u0011\u001d\u0011y\u0003\u0001C\u0001\u0003_BqAa\r\u0001\t\u0013\u0011)\u0004C\u0004\u0003n\u0001!IAa\u001c\t\u0013\t=\u0005!%A\u0005\n\tE\u0005b\u0002BK\u0001\u0011%!q\u0013\u0005\n\u0005K\u0003\u0011\u0013!C\u0005\u0005OCqAa+\u0001\t\u0013\u0011i\u000bC\u0005\u0003^\u0002\t\n\u0011\"\u0003\u0002R\"I!q\u001c\u0001\u0012\u0002\u0013%\u0011\u0011\u001e\u0005\n\u0005C\u0004\u0011\u0013!C\u0005\u0003_\u0014A$Q;u_R{\u0007/[2De\u0016\fG/[8o\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002B\u0005\u000611/\u001a:wKJT\u0011aQ\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\t\u0005\u0002H\u00156\t\u0001JC\u0001J\u0003\u0015\u00198-\u00197b\u0013\tY\u0005J\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00039\u0003\"a\u0014\u0001\u000e\u0003\u0001\u000baB]3rk\u0016\u001cH\u000fV5nK>,H/F\u0001S!\t95+\u0003\u0002U\u0011\n\u0019\u0011J\u001c;\u0002\u001fI,\u0017/^3tiRKW.Z8vi\u0002\naaY8oM&<W#\u0001-\u0011\u0005=K\u0016B\u0001.A\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0015\r|gNZ5h?\u0012*\u0017\u000f\u0006\u0002^AB\u0011qIX\u0005\u0003?\"\u0013A!\u00168ji\"9\u0011-BA\u0001\u0002\u0004A\u0016a\u0001=%c\u000591m\u001c8gS\u001e\u0004\u0013!D7fi\u0006$\u0017\r^1DC\u000eDW-F\u0001f!\tye-\u0003\u0002h\u0001\niQ*\u001a;bI\u0006$\u0018mQ1dQ\u0016\fa\"\\3uC\u0012\fG/Y\"bG\",\u0007%\u0001\nce>\\WM\u001d+p\u0007>tGO]8mY\u0016\u0014X#A6\u0011\u0005=c\u0017BA7A\u0005\u0001\u0012%o\\6feR{7i\u001c8ue>dG.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\u0002'\t\u0014xn[3s)>\u001cuN\u001c;s_2dWM\u001d\u0011\u0002\u0019\u0005$W.\u001b8NC:\fw-\u001a:\u0016\u0003E\u0004\"a\u0014:\n\u0005M\u0004%A\u0004.l\u0003\u0012l\u0017N\\'b]\u0006<WM]\u0001\u000eC\u0012l\u0017N\\'b]\u0006<WM\u001d\u0011\u0002\u0015\r|g\u000e\u001e:pY2,'/F\u0001x!\tA(0D\u0001z\u0015\t)()\u0003\u0002|s\ny1*\u00194lC\u000e{g\u000e\u001e:pY2,'/A\u0006d_:$(o\u001c7mKJ\u0004\u0013\u0001E4s_V\u00048i\\8sI&t\u0017\r^8s+\u0005y\b\u0003BA\u0001\u0003+i!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\u0006OJ|W\u000f\u001d\u0006\u0005\u0003\u0013\tY!A\u0006d_>\u0014H-\u001b8bi>\u0014(bA\"\u0002\u000e)!\u0011qBA\t\u0003\u0019\t\u0007/Y2iK*\u0011\u00111C\u0001\u0004_J<\u0017\u0002BA\f\u0003\u0007\u0011\u0001c\u0012:pkB\u001cun\u001c:eS:\fGo\u001c:\u0002#\u001d\u0014x.\u001e9D_>\u0014H-\u001b8bi>\u0014\b%\u0001\fue\u0006t7/Y2uS>t7i\\8sI&t\u0017\r^8s+\t\ty\u0002\u0005\u0003\u0002\"\u0005%RBAA\u0012\u0015\u0011\t)#a\n\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0004\u0003\u0013\u0011\u0015\u0002BA\u0016\u0003G\u0011a\u0003\u0016:b]N\f7\r^5p]\u000e{wN\u001d3j]\u0006$xN]\u0001\u0018iJ\fgn]1di&|gnQ8pe\u0012Lg.\u0019;pe\u0002\n\u0001$Y;u_R{\u0007/[2De\u0016\fG/[8o\u001b\u0006t\u0017mZ3s+\t\t\u0019\u0004E\u0002P\u0003kI1!a\u000eA\u0005a\tU\u000f^8U_BL7m\u0011:fCRLwN\\'b]\u0006<WM]\u0001\u001dCV$x\u000eV8qS\u000e\u001c%/Z1uS>tW*\u00198bO\u0016\u0014x\fJ3r)\ri\u0016Q\b\u0005\tCR\t\t\u00111\u0001\u00024\u0005I\u0012-\u001e;p)>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8NC:\fw-\u001a:!\u0003]Ig\u000e^3s]\u0006dGk\u001c9jGB\u000b'\u000f^5uS>t7/\u0001\rj]R,'O\\1m)>\u0004\u0018n\u0019)beRLG/[8og\u0002\na$\u001b8uKJt\u0017\r\u001c+pa&\u001c'+\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:\u0016\u0005\u0005%\u0003cA$\u0002L%\u0019\u0011Q\n%\u0003\u000bMCwN\u001d;\u0002?%tG/\u001a:oC2$v\u000e]5d%\u0016\u0004H.[2bi&|gNR1di>\u0014\b%A\u000eqY\u0006\u001cW-\\3oi*\u001bxN\\%oi\u0016\u0014h.\u00197U_BL7m]\u000b\u0003\u0003+\u0002B!a\u0016\u0002f9!\u0011\u0011LA1!\r\tY\u0006S\u0007\u0003\u0003;R1!a\u0018E\u0003\u0019a$o\\8u}%\u0019\u00111\r%\u0002\rA\u0013X\rZ3g\u0013\u0011\t9'!\u001b\u0003\rM#(/\u001b8h\u0015\r\t\u0019\u0007S\u0001\u001da2\f7-Z7f]RT5o\u001c8J]R,'O\\1m)>\u0004\u0018nY:!\u0003\u0015\u0019X\r^;q)\u0005i\u0006f\u0001\u000f\u0002tA!\u0011QOAB\u001b\t\t9H\u0003\u0003\u0002z\u0005m\u0014aA1qS*!\u0011QPA@\u0003\u001dQW\u000f]5uKJTA!!!\u0002\u0012\u0005)!.\u001e8ji&!\u0011QQA<\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u0016i\u0016\u001cHo\u0011:fCR,wJ\u001a4tKR$v\u000e]5dQ\ri\u00121\u0012\t\u0005\u0003k\ni)\u0003\u0003\u0002\u0010\u0006]$\u0001\u0002+fgR\fQ\u0006^3ti\u000e\u0013X-\u0019;f\u001f\u001a47/\u001a;U_BL7mV5uQBc\u0017mY3nK:$8i\u001c8tiJ\f\u0017N\u001c;tQ\rq\u00121R\u0001\u0013i\u0016\u001cHo\u0011:fCR,G\u000b\u001f8U_BL7\rK\u0002 \u0003\u0017\u000b!\u0006^3ti\u000e\u0013X-\u0019;f)btGk\u001c9jG^KG\u000f\u001b)mC\u000e,W.\u001a8u\u0007>t7\u000f\u001e:bS:$8\u000fK\u0002!\u0003\u0017\u000b!\u0004^3ti\u000e\u0013X-\u0019;f\u001d>t\u0017J\u001c;fe:\fG\u000eV8qS\u000eD3!IAF\u0003=!Xm\u001d;De\u0016\fG/\u001a+pa&\u001cGcC/\u0002&\u0006%\u00161WA\\\u0003wCq!a*#\u0001\u0004\t)&A\u0005u_BL7MT1nK\"9\u00111\u0016\u0012A\u0002\u00055\u0016AC5t\u0013:$XM\u001d8bYB\u0019q)a,\n\u0007\u0005E\u0006JA\u0004C_>dW-\u00198\t\u0011\u0005U&\u0005%AA\u0002I\u000bQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b\"CA]EA\u0005\t\u0019AA%\u0003E\u0011X\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u0005\n\u0003{\u0013\u0003\u0013!a\u0001\u0003\u007f\u000bA\u0002^8qS\u000e\u001cuN\u001c4jON\u0004B!!1\u0002L6\u0011\u00111\u0019\u0006\u0005\u0003\u000b\f9-\u0001\u0003vi&d'BAAe\u0003\u0011Q\u0017M^1\n\t\u00055\u00171\u0019\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!\u0007;fgR\u001c%/Z1uKR{\u0007/[2%I\u00164\u0017-\u001e7uIM*\"!a5+\u0007I\u000b)n\u000b\u0002\u0002XB!\u0011\u0011\\Ar\u001b\t\tYN\u0003\u0003\u0002^\u0006}\u0017!C;oG\",7m[3e\u0015\r\t\t\u000fS\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAs\u00037\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003e!Xm\u001d;De\u0016\fG/\u001a+pa&\u001cG\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005-(\u0006BA%\u0003+\f\u0011\u0004^3ti\u000e\u0013X-\u0019;f)>\u0004\u0018n\u0019\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011\u0011\u001f\u0016\u0005\u0003\u007f\u000b).\u0001\u0014uKN$8I]3bi\u0016$v\u000e]5dg^KG\u000f\u001b$pe^\f'\u000fZ5oO\u0012K7/\u00192mK\u0012D3AJAF\u0003A\"Xm\u001d;J]Z\fG.\u001b3SKBd\u0017nY1uS>tg)Y2u_J4uN\u001d(p]&sG/\u001a:oC2$v\u000e]5dg\"\u001aq%a#\u0002gQ,7\u000f^%om\u0006d\u0017\u000e\u001a*fa2L7-\u0019;j_:4\u0015m\u0019;pe\u001a{'oQ8ogVlWM](gMN,Go\u001d+pa&\u001c\u0007f\u0001\u0015\u0002\f\u0006iC/Z:u\u0013:4\u0018\r\\5e%\u0016\u0004H.[2bi&|gNR1di>\u0014hi\u001c:Uq:|eMZ:fiR{\u0007/[2)\u0007%\nY)\u0001\u0017uKN$Hk\u001c9jG\u0016C\u0018n\u001d;t\u000bJ\u0014xN]*xCB4uN\u001d(p]&sG/\u001a:oC2$v\u000e]5dg\"\u001a!&a#\u0002_Q,7\u000f\u001e+pa&\u001cW\t_5tiN,%O]8s'^\f\u0007OR8s\u0007>t7/^7fe>3gm]3ugR{\u0007/[2)\u0007-\nY)A\u0015uKN$Hk\u001c9jG\u0016C\u0018n\u001d;t\u000bJ\u0014xN]*xCB4uN\u001d+y]>3gm]3u)>\u0004\u0018n\u0019\u0015\u0004Y\u0005-\u0015a\f;fgR\u0014V-];fgR$\u0016.\\3pkR,%O]8s'^\f\u0007OR8s\u001d>t\u0017J\u001c;fe:\fG\u000eV8qS\u000e\u001c\bfA\u0017\u0002\f\u0006\tD/Z:u%\u0016\fX/Z:u)&lWm\\;u\u000bJ\u0014xN]*xCB4uN]\"p]N,X.\u001a:PM\u001a\u001cX\r\u001e+pa&\u001c\u0007f\u0001\u0018\u0002\f\u0006aC/Z:u%\u0016\fX/Z:u)&lWm\\;u\u000bJ\u0014xN]*xCB4uN\u001d+y]>3gm]3u)>\u0004\u0018n\u0019\u0015\u0004_\u0005-\u0015\u0001\f;fgR,fn\u001b8po:$v\u000e]5d!\u0006\u0014H/\u001b;j_:4uN\u001d(p]&sG/\u001a:wC2$v\u000e]5dQ\r\u0001\u00141R\u00010i\u0016\u001cH/\u00168l]><h\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|gNR8s\u0007>t7/^7fe>3gm]3u)>\u0004\u0018n\u0019\u0015\u0004c\u0005-\u0015A\u000b;fgR,fn\u001b8po:$v\u000e]5d!\u0006\u0014H/\u001b;j_:4uN\u001d+y]>3gm]3u)>\u0004\u0018n\u0019\u0015\u0004e\u0005-\u0015!\r;fgR$v\u000e]5d\u0007J,\u0017\r^5p]^KG\u000f['fi\u0006$\u0017\r^1D_:$X\r\u001f;QCN\u001c\bK]5oG&\u0004\u0018\r\u001c\u0015\u0004g\u0005-\u0015\u0001\u0011;fgR$v\u000e]5d\u0007J,\u0017\r^5p]^KG\u000f['fi\u0006$\u0017\r^1D_:$X\r\u001f;XQ\u0016t\u0007K]5oG&\u0004\u0018\r\\*fe\u0012,gj\u001c;EK\u001aLg.\u001a3)\u0007Q\nY)A!uKN$Hk\u001c9jG\u000e\u0013X-\u0019;j_:<\u0016\u000e\u001e5NKR\fG-\u0019;b\u0007>tG/\u001a=u\u001d>\u0014V\r\u001e:z+B|g.\u00168tkB\u0004xN\u001d;fIZ+'o]5p]\"\u001aQ'a#\u00021%t\u0017\u000e^5bY&TXMU3rk\u0016\u001cHoQ8oi\u0016DH\u000f\u0006\u0005\u00038\t\u001d#\u0011\nB/!\u0011\u0011IDa\u0011\u000e\u0005\tm\"\u0002\u0002B\u001f\u0005\u007f\t\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0005\u0005\u0003\nY!\u0001\u0004d_6lwN\\\u0005\u0005\u0005\u000b\u0012YD\u0001\bSKF,Xm\u001d;D_:$X\r\u001f;\t\u000f\u0005\u001df\u00071\u0001\u0002V!9!1\n\u001cA\u0002\t5\u0013AD6bM.\f\u0007K]5oG&\u0004\u0018\r\u001c\t\u0005\u0005\u001f\u0012I&\u0004\u0002\u0003R)!!1\u000bB+\u0003\u0011\tW\u000f\u001e5\u000b\t\t]#qH\u0001\tg\u0016\u001cWO]5us&!!1\fB)\u00059Y\u0015MZ6b!JLgnY5qC2DqAa\u00187\u0001\u0004\u0011\t'\u0001\bqe&t7-\u001b9bYN+'\u000fZ3\u0011\r\u0005\u0005'1\rB4\u0013\u0011\u0011)'a1\u0003\u0011=\u0003H/[8oC2\u0004BAa\u0014\u0003j%!!1\u000eB)\u0005MY\u0015MZ6b!JLgnY5qC2\u001cVM\u001d3f\u0003e!Xm\u001d;FeJ|'oV5uQ\u000e\u0013X-\u0019;j_:LeNW6\u0015\u0013u\u0013\tH!!\u0003\u0004\n\u0015\u0005b\u0002B:o\u0001\u0007!QO\u0001\u0006KJ\u0014xN\u001d\t\u0005\u0005o\u0012i(\u0004\u0002\u0003z)!!1\u0010B \u0003!\u0001(o\u001c;pG>d\u0017\u0002\u0002B@\u0005s\u0012a!\u0012:s_J\u001c\bbBATo\u0001\u0007\u0011Q\u000b\u0005\b\u0003W;\u0004\u0019AAW\u0011%\u00119i\u000eI\u0001\u0002\u0004\u0011I)A\u0007fqB,7\r^3e\u000bJ\u0014xN\u001d\t\u0006\u000f\n-%QO\u0005\u0004\u0005\u001bC%AB(qi&|g.A\u0012uKN$XI\u001d:pe^KG\u000f[\"sK\u0006$\u0018n\u001c8J]j[G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\tM%\u0006\u0002BE\u0003+\f!d\u0019:fCR,Gk\u001c9jG\u0006sGMV3sS\u001aL(+Z:vYR$\u0012\"\u0018BM\u00057\u0013iJa(\t\u000f\tM\u0014\b1\u0001\u0003v!9\u0011qU\u001dA\u0002\u0005U\u0003bBAVs\u0001\u0007\u0011Q\u0016\u0005\n\u0005CK\u0004\u0013!a\u0001\u0005G\u000bq\"\\3uC\u0012\fG/Y\"p]R,\u0007\u0010\u001e\t\u0006\u000f\n-%qG\u0001%GJ,\u0017\r^3U_BL7-\u00118e-\u0016\u0014\u0018NZ=SKN,H\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!\u0011\u0016\u0016\u0005\u0005G\u000b).A\u0006hKRtUm\u001e+pa&\u001cGC\u0003BX\u0005+\u00149N!7\u0003\\B!!\u0011\u0017Bh\u001d\u0011\u0011\u0019L!3\u000f\t\tU&Q\u0019\b\u0005\u0005o\u0013\u0019M\u0004\u0003\u0003:\n\u0005g\u0002\u0002B^\u0005\u007fsA!a\u0017\u0003>&\u0011\u00111C\u0005\u0005\u0003\u001f\t\t\"C\u0002D\u0003\u001bIAA!\u0011\u0002\f%!!q\u0019B \u0003\u001diWm]:bO\u0016LAAa3\u0003N\u000692I]3bi\u0016$v\u000e]5dgJ+\u0017/^3ti\u0012\u000bG/\u0019\u0006\u0005\u0005\u000f\u0014y$\u0003\u0003\u0003R\nM'AD\"sK\u0006$\u0018M\u00197f)>\u0004\u0018n\u0019\u0006\u0005\u0005\u0017\u0014i\rC\u0004\u0002(n\u0002\r!!\u0016\t\u0011\u0005U6\b%AA\u0002IC\u0011\"!/<!\u0003\u0005\r!!\u0013\t\u0013\u0005u6\b%AA\u0002\u0005}\u0016!F4fi:+w\u000fV8qS\u000e$C-\u001a4bk2$HEM\u0001\u0016O\u0016$h*Z<U_BL7\r\n3fM\u0006,H\u000e\u001e\u00134\u0003U9W\r\u001e(foR{\u0007/[2%I\u00164\u0017-\u001e7uIQ\u0002")
public class AutoTopicCreationManagerTest {
    private final int requestTimeout;
    private KafkaConfig config;
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final BrokerToControllerChannelManager brokerToController = (BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class);
    private final ZkAdminManager adminManager = (ZkAdminManager)Mockito.mock(ZkAdminManager.class);
    private final KafkaController controller = (KafkaController)Mockito.mock(KafkaController.class);
    private final GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
    private final TransactionCoordinator transactionCoordinator = (TransactionCoordinator)Mockito.mock(TransactionCoordinator.class);
    private AutoTopicCreationManager autoTopicCreationManager;
    private final int internalTopicPartitions;
    private final short internalTopicReplicationFactor = (short)2;
    private final String placementJsonInternalTopics = Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |{\n      | \"version\": 1,\n      | \"replicas\": [{\n      |   \"count\": 1,\n      |   \"constraints\": {\n      |     \"rack\": \"rack0\"\n      |   }\n      | },\n      | {\n      |   \"count\": 1,\n      |   \"constraints\": {\n      |     \"rack\": \"rack1\"\n      |   }\n      | }],\n      | \"observers\": []\n      |}\n      |")).split("\\s+")).mkString();

    private int requestTimeout() {
        return this.requestTimeout;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private BrokerToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    private ZkAdminManager adminManager() {
        return this.adminManager;
    }

    private KafkaController controller() {
        return this.controller;
    }

    private GroupCoordinator groupCoordinator() {
        return this.groupCoordinator;
    }

    private TransactionCoordinator transactionCoordinator() {
        return this.transactionCoordinator;
    }

    private AutoTopicCreationManager autoTopicCreationManager() {
        return this.autoTopicCreationManager;
    }

    private void autoTopicCreationManager_$eq(AutoTopicCreationManager x$1) {
        this.autoTopicCreationManager = x$1;
    }

    private int internalTopicPartitions() {
        return this.internalTopicPartitions;
    }

    private short internalTopicReplicationFactor() {
        return this.internalTopicReplicationFactor;
    }

    private String placementJsonInternalTopics() {
        return this.placementJsonInternalTopics;
    }

    @BeforeEach
    public void setup() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.setProperty(KafkaConfig$.MODULE$.RequestTimeoutMsProp(), Integer.toString(this.requestTimeout()));
        props.setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), Short.toString(this.internalTopicReplicationFactor()));
        props.setProperty(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), Short.toString(this.internalTopicReplicationFactor()));
        props.setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), Integer.toString(this.internalTopicPartitions()));
        props.setProperty(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), Integer.toString(this.internalTopicPartitions()));
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        .colon.colon aliveBrokers = new .colon.colon((Object)new Node(0, "host0", 0, "rack0"), (List)new .colon.colon((Object)new Node(1, "host1", 1, "rack1"), (List)Nil$.MODULE$));
        Mockito.reset((Object[])new Object[]{this.metadataCache(), this.controller(), this.brokerToController(), this.groupCoordinator(), this.transactionCoordinator()});
        Mockito.when((Object)this.metadataCache().getAliveBrokerNodes((ListenerName)ArgumentMatchers.any(ListenerName.class))).thenReturn((Object)aliveBrokers);
        Mockito.when((Object)this.groupCoordinator().groupMetadataTopicConfigs()).thenReturn((Object)new Properties());
        Mockito.when((Object)this.transactionCoordinator().transactionTopicConfigs()).thenReturn((Object)new Properties());
        Mockito.when((Object)this.transactionCoordinator().placementConstraints()).thenReturn((Object)"");
    }

    @Test
    public void testCreateOffsetTopic() {
        this.testCreateTopic("__consumer_offsets", true, this.internalTopicPartitions(), this.internalTopicReplicationFactor(), new Properties());
    }

    @Test
    public void testCreateOffsetTopicWithPlacementConstraints() {
        Properties properties = new Properties();
        properties.setProperty("confluent.placement.constraints", this.placementJsonInternalTopics());
        Mockito.when((Object)this.groupCoordinator().groupMetadataTopicConfigs()).thenReturn((Object)properties);
        this.testCreateTopic("__consumer_offsets", true, this.internalTopicPartitions(), (short)-1, properties);
    }

    @Test
    public void testCreateTxnTopic() {
        this.testCreateTopic("__transaction_state", true, this.internalTopicPartitions(), this.internalTopicReplicationFactor(), new Properties());
    }

    @Test
    public void testCreateTxnTopicWithPlacementConstraints() {
        Mockito.when((Object)this.transactionCoordinator().placementConstraints()).thenReturn((Object)this.placementJsonInternalTopics());
        this.testCreateTopic("__transaction_state", true, this.internalTopicPartitions(), (short)-1, new Properties());
    }

    @Test
    public void testCreateNonInternalTopic() {
        this.testCreateTopic("topic", false, 1, (short)1, new Properties());
    }

    private void testCreateTopic(String topicName, boolean isInternal, int numPartitions, short replicationFactor, Properties topicConfigs) {
        this.autoTopicCreationManager_$eq((AutoTopicCreationManager)new DefaultAutoTopicCreationManager(this.config(), (Option)new Some((Object)this.brokerToController()), (Option)new Some((Object)this.adminManager()), (Option)new Some((Object)this.controller()), this.groupCoordinator(), this.transactionCoordinator()));
        CreateTopicsRequestData.CreatableTopicCollection topicsCollection = new CreateTopicsRequestData.CreatableTopicCollection();
        topicsCollection.add((ImplicitLinkedHashCollection.Element)this.getNewTopic(topicName, numPartitions, replicationFactor, topicConfigs));
        CreateTopicsRequest.Builder requestBody = new CreateTopicsRequest.Builder(new CreateTopicsRequestData().setTopics(topicsCollection).setTimeoutMs(this.requestTimeout()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.createTopicAndVerifyResult(Errors.UNKNOWN_TOPIC_OR_PARTITION, topicName, isInternal, (Option<RequestContext>)None$.MODULE$);
        this.createTopicAndVerifyResult(Errors.UNKNOWN_TOPIC_OR_PARTITION, topicName, isInternal, (Option<RequestContext>)None$.MODULE$);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.eq((Object)requestBody), (ControllerRequestCompletionHandler)ArgumentMatchers.any(ControllerRequestCompletionHandler.class));
    }

    private int testCreateTopic$default$3() {
        return 1;
    }

    private short testCreateTopic$default$4() {
        return 1;
    }

    private Properties testCreateTopic$default$5() {
        return new Properties();
    }

    @Test
    public void testCreateTopicsWithForwardingDisabled() {
        this.autoTopicCreationManager_$eq((AutoTopicCreationManager)new DefaultAutoTopicCreationManager(this.config(), (Option)None$.MODULE$, (Option)new Some((Object)this.adminManager()), (Option)new Some((Object)this.controller()), this.groupCoordinator(), this.transactionCoordinator()));
        String topicName = "topic";
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.createTopicAndVerifyResult(Errors.UNKNOWN_TOPIC_OR_PARTITION, topicName, false, (Option<RequestContext>)None$.MODULE$);
        ((ZkAdminManager)Mockito.verify((Object)this.adminManager())).createTopics(ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((boolean)false), (Map)ArgumentMatchers.eq((Object)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)this.getNewTopic(topicName, 1, (short)1, new Properties()))}))), (Map)ArgumentMatchers.eq((Object)Map$.MODULE$.empty()), (ControllerMutationQuota)ArgumentMatchers.any(ControllerMutationQuota.class), (Option)ArgumentMatchers.eq((Object)None$.MODULE$), (Function1)ArgumentMatchers.any(Function1.class));
    }

    @Test
    public void testInvalidReplicationFactorForNonInternalTopics() {
        this.testErrorWithCreationInZk(Errors.INVALID_REPLICATION_FACTOR, "topic", false, (Option<Errors>)None$.MODULE$);
    }

    @Test
    public void testInvalidReplicationFactorForConsumerOffsetsTopic() {
        this.testErrorWithCreationInZk(Errors.INVALID_REPLICATION_FACTOR, "__consumer_offsets", true, (Option<Errors>)None$.MODULE$);
    }

    @Test
    public void testInvalidReplicationFactorForTxnOffsetTopic() {
        this.testErrorWithCreationInZk(Errors.INVALID_REPLICATION_FACTOR, "__transaction_state", true, (Option<Errors>)None$.MODULE$);
    }

    @Test
    public void testTopicExistsErrorSwapForNonInternalTopics() {
        this.testErrorWithCreationInZk(Errors.TOPIC_ALREADY_EXISTS, "topic", false, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testTopicExistsErrorSwapForConsumerOffsetsTopic() {
        this.testErrorWithCreationInZk(Errors.TOPIC_ALREADY_EXISTS, "__consumer_offsets", true, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testTopicExistsErrorSwapForTxnOffsetTopic() {
        this.testErrorWithCreationInZk(Errors.TOPIC_ALREADY_EXISTS, "__transaction_state", true, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testRequestTimeoutErrorSwapForNonInternalTopics() {
        this.testErrorWithCreationInZk(Errors.REQUEST_TIMED_OUT, "topic", false, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testRequestTimeoutErrorSwapForConsumerOffsetTopic() {
        this.testErrorWithCreationInZk(Errors.REQUEST_TIMED_OUT, "__consumer_offsets", true, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testRequestTimeoutErrorSwapForTxnOffsetTopic() {
        this.testErrorWithCreationInZk(Errors.REQUEST_TIMED_OUT, "__transaction_state", true, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testUnknownTopicPartitionForNonIntervalTopic() {
        this.testErrorWithCreationInZk(Errors.UNKNOWN_TOPIC_OR_PARTITION, "topic", false, (Option<Errors>)None$.MODULE$);
    }

    @Test
    public void testUnknownTopicPartitionForConsumerOffsetTopic() {
        this.testErrorWithCreationInZk(Errors.UNKNOWN_TOPIC_OR_PARTITION, "__consumer_offsets", true, (Option<Errors>)None$.MODULE$);
    }

    @Test
    public void testUnknownTopicPartitionForTxnOffsetTopic() {
        this.testErrorWithCreationInZk(Errors.UNKNOWN_TOPIC_OR_PARTITION, "__transaction_state", true, (Option<Errors>)None$.MODULE$);
    }

    @Test
    public void testTopicCreationWithMetadataContextPassPrincipal() {
        String topicName = "topic";
        KafkaPrincipal userPrincipal = new KafkaPrincipal("User", "user");
        AtomicBoolean serializeIsCalled = new AtomicBoolean(false);
        KafkaPrincipalSerde principalSerde = new KafkaPrincipalSerde(null, userPrincipal, serializeIsCalled){
            private final KafkaPrincipal userPrincipal$1;
            private final AtomicBoolean serializeIsCalled$1;

            public byte[] serialize(KafkaPrincipal principal) {
                Assertions.assertEquals((Object)principal, (Object)this.userPrincipal$1);
                this.serializeIsCalled$1.set(true);
                return principal.toString().getBytes(StandardCharsets.UTF_8);
            }

            public KafkaPrincipal deserialize(byte[] bytes) {
                return SecurityUtils.parseKafkaPrincipal((String)new String(bytes, StandardCharsets.UTF_8));
            }
            {
                this.userPrincipal$1 = userPrincipal$1;
                this.serializeIsCalled$1 = serializeIsCalled$1;
            }
        };
        RequestContext requestContext = this.initializeRequestContext(topicName, userPrincipal, Optional.of(principalSerde));
        this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, (Option)new Some((Object)requestContext));
        Assertions.assertTrue((boolean)serializeIsCalled.get());
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)argumentCaptor.capture(), (ControllerRequestCompletionHandler)ArgumentMatchers.any(ControllerRequestCompletionHandler.class));
        EnvelopeRequest capturedRequest = ((EnvelopeRequest.Builder)argumentCaptor.getValue()).build(ApiKeys.ENVELOPE.latestVersion());
        byte[] utf8_bytes = capturedRequest.requestPrincipal();
        Object var8_8 = null;
        Assertions.assertEquals((Object)userPrincipal, (Object)SecurityUtils.parseKafkaPrincipal((String)new String(utf8_bytes, StandardCharsets.UTF_8)));
    }

    @Test
    public void testTopicCreationWithMetadataContextWhenPrincipalSerdeNotDefined() {
        String topicName = "topic";
        RequestContext requestContext = this.initializeRequestContext(topicName, KafkaPrincipal.ANONYMOUS, Optional.empty());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, (Option)new Some((Object)requestContext)));
    }

    @Test
    public void testTopicCreationWithMetadataContextNoRetryUponUnsupportedVersion() {
        String topicName = "topic";
        KafkaPrincipalSerde principalSerde = new KafkaPrincipalSerde(null){

            public byte[] serialize(KafkaPrincipal principal) {
                return principal.toString().getBytes(StandardCharsets.UTF_8);
            }

            public KafkaPrincipal deserialize(byte[] bytes) {
                return SecurityUtils.parseKafkaPrincipal((String)new String(bytes, StandardCharsets.UTF_8));
            }
        };
        RequestContext requestContext = this.initializeRequestContext(topicName, KafkaPrincipal.ANONYMOUS, Optional.of(principalSerde));
        this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, (Option)new Some((Object)requestContext));
        this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, (Option)new Some((Object)requestContext));
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(AbstractRequest.Builder.class), (ControllerRequestCompletionHandler)argumentCaptor.capture());
        RequestHeader header = new RequestHeader(ApiKeys.ENVELOPE, 0, "client", 1);
        EnvelopeResponse response = new EnvelopeResponse(ByteBuffer.allocate(0), Errors.UNSUPPORTED_VERSION);
        ClientResponse clientResponse = new ClientResponse(header, null, null, 0L, 0L, false, null, null, (AbstractResponse)response);
        ((RequestCompletionHandler)argumentCaptor.getValue()).onComplete(clientResponse);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)1))).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(AbstractRequest.Builder.class), (ControllerRequestCompletionHandler)argumentCaptor.capture());
        this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, (Option)new Some((Object)requestContext));
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(AbstractRequest.Builder.class), (ControllerRequestCompletionHandler)argumentCaptor.capture());
    }

    private RequestContext initializeRequestContext(String topicName, KafkaPrincipal kafkaPrincipal, Optional<KafkaPrincipalSerde> principalSerde) {
        this.autoTopicCreationManager_$eq((AutoTopicCreationManager)new DefaultAutoTopicCreationManager(this.config(), (Option)new Some((Object)this.brokerToController()), (Option)new Some((Object)this.adminManager()), (Option)new Some((Object)this.controller()), this.groupCoordinator(), this.transactionCoordinator()));
        new CreateTopicsRequestData.CreatableTopicCollection().add((ImplicitLinkedHashCollection.Element)this.getNewTopic(topicName, 1, (short)1, new Properties()));
        ApiVersionsResponseData.ApiVersion createTopicApiVersion = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.CREATE_TOPICS.id).setMinVersion((short)0).setMaxVersion((short)0);
        Mockito.when((Object)this.brokerToController().controllerApiVersions()).thenReturn((Object)new Some((Object)NodeApiVersions.create(Collections.singleton(createTopicApiVersion))));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        RequestHeader requestHeader = new RequestHeader(ApiKeys.METADATA, ApiKeys.METADATA.latestVersion(), "clientId", 0);
        return new RequestContext(requestHeader, "1", InetAddress.getLocalHost(), kafkaPrincipal, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, null, false, principalSerde);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void testErrorWithCreationInZk(Errors error, String topicName, boolean isInternal, Option<Errors> expectedError) {
        CreateTopicsRequestData.CreatableTopic creatableTopic;
        block5: {
            block4: {
                this.autoTopicCreationManager_$eq((AutoTopicCreationManager)new DefaultAutoTopicCreationManager(this.config(), (Option)None$.MODULE$, (Option)new Some((Object)this.adminManager()), (Option)new Some((Object)this.controller()), this.groupCoordinator(), this.transactionCoordinator()));
                Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
                if (!isInternal) break block4;
                switch (topicName == null ? 0 : topicName.hashCode()) {
                    case -970371369: {
                        if (!"__consumer_offsets".equals(topicName)) break;
                        creatableTopic = this.getNewTopic(topicName, Predef$.MODULE$.Integer2int(this.config().offsetsTopicPartitions()), Predef$.MODULE$.Short2short(this.config().offsetsTopicReplicationFactor()), new Properties());
                        break block5;
                    }
                    case -253293552: {
                        if (!"__transaction_state".equals(topicName)) break;
                        creatableTopic = this.getNewTopic(topicName, Predef$.MODULE$.Integer2int(this.config().transactionTopicPartitions()), Predef$.MODULE$.Short2short(this.config().transactionTopicReplicationFactor()), new Properties());
                        break block5;
                    }
                }
                throw new MatchError((Object)topicName);
            }
            creatableTopic = this.getNewTopic(topicName, 1, (short)1, new Properties());
        }
        CreateTopicsRequestData.CreatableTopic newTopic = creatableTopic;
        Errors errors = error;
        Errors errors2 = Errors.UNKNOWN_TOPIC_OR_PARTITION;
        Map topicErrors = !(errors != null ? !errors.equals(errors2) : errors2 != null) ? null : (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)new ApiError(error))}));
        this.adminManager().createTopics(ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((boolean)false), (Map)ArgumentMatchers.eq((Object)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)newTopic)}))), (Map)ArgumentMatchers.eq((Object)Map$.MODULE$.empty()), (ControllerMutationQuota)ArgumentMatchers.any(ControllerMutationQuota.class), (Option)ArgumentMatchers.any(Option.class), (Function1)ArgumentMatchers.any(Function1.class));
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> {
            AutoTopicCreationManagerTest.$anonfun$testErrorWithCreationInZk$1(topicErrors, invocation);
            return BoxedUnit.UNIT;
        });
        this.createTopicAndVerifyResult((Errors)expectedError.getOrElse((Function0 & Serializable)() -> error), topicName, isInternal, (Option<RequestContext>)None$.MODULE$);
    }

    private Option<Errors> testErrorWithCreationInZk$default$4() {
        return None$.MODULE$;
    }

    private void createTopicAndVerifyResult(Errors error, String topicName, boolean isInternal, Option<RequestContext> metadataContext) {
        Seq topicResponses = this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, metadataContext);
        Assertions.assertEquals((Object)new .colon.colon((Object)new MetadataResponseData.MetadataResponseTopic().setErrorCode(error.code()).setIsInternal(isInternal).setName(topicName), (List)Nil$.MODULE$), (Object)topicResponses);
    }

    private Option<RequestContext> createTopicAndVerifyResult$default$4() {
        return None$.MODULE$;
    }

    private CreateTopicsRequestData.CreatableTopic getNewTopic(String topicName, int numPartitions, short replicationFactor, Properties topicConfigs) {
        return new CreateTopicsRequestData.CreatableTopic().setName(topicName).setNumPartitions(numPartitions).setReplicationFactor(replicationFactor).setConfigs(AutoTopicCreationManager$.MODULE$.convertToTopicConfigCollections(topicConfigs));
    }

    private int getNewTopic$default$2() {
        return 1;
    }

    private short getNewTopic$default$3() {
        return 1;
    }

    private Properties getNewTopic$default$4() {
        return new Properties();
    }

    public static final /* synthetic */ void $anonfun$testErrorWithCreationInZk$1(Map topicErrors$1, InvocationOnMock invocation) {
        ((Function1)invocation.getArgument(6)).apply((Object)topicErrors$1);
    }

    public AutoTopicCreationManagerTest() {
        this.requestTimeout = 100;
        this.internalTopicPartitions = 2;
    }
}

