/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.server.AlterPartitionManager;
import kafka.server.AlterPartitionManagerTest$;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.DefaultAlterPartitionManager;
import kafka.server.ZkAlterPartitionManager;
import kafka.utils.MockTime;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.InvalidUpdateVersionException;
import org.apache.kafka.common.errors.OperationNotAttemptedException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.AlterPartitionResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\ree\u0001B A\u0001\u0015CQ\u0001\u0014\u0001\u0005\u00025Cq\u0001\u0015\u0001C\u0002\u0013\u0005\u0011\u000b\u0003\u0004[\u0001\u0001\u0006IA\u0015\u0005\b7\u0002\u0011\r\u0011\"\u0001]\u0011\u0019A\u0007\u0001)A\u0005;\"9\u0011\u000e\u0001b\u0001\n\u0003Q\u0007BB9\u0001A\u0003%1\u000eC\u0004s\u0001\t\u0007I\u0011A:\t\re\u0004\u0001\u0015!\u0003u\u0011\u001dQ\bA1A\u0005\u0002mDaa \u0001!\u0002\u0013a\bbCA\u0001\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0007A1\"a\u0003\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u000e!Y\u0011\u0011\u0004\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0003\u0011%\tY\u0002\u0001b\u0001\n\u0003\ti\u0002\u0003\u0005\u0002&\u0001\u0001\u000b\u0011BA\u0010\u0011%\t9\u0003\u0001b\u0001\n\u0003\ti\u0002\u0003\u0005\u0002*\u0001\u0001\u000b\u0011BA\u0010\u0011%\tY\u0003\u0001b\u0001\n\u0003\ti\u0002\u0003\u0005\u0002.\u0001\u0001\u000b\u0011BA\u0010\u0011\u001d\ty\u0003\u0001C\u0001\u0003cAq!!\u0013\u0001\t\u0003\tY\u0005C\u0004\u0002\u0002\u0002!\t!a!\t\u000f\u00055\u0005\u0001\"\u0001\u0002\u0010\"9\u0011Q\u0016\u0001\u0005\u0002\u0005=\u0006bBA]\u0001\u0011\u0005\u00111\u0018\u0005\b\u0003\u000b\u0004A\u0011AA\u0019\u0011\u001d\ty\r\u0001C\u0001\u0003cAq!a5\u0001\t\u0003\t\t\u0004C\u0004\u0002X\u0002!\t!!\r\t\u000f\u0005m\u0007\u0001\"\u0001\u00022!9\u0011q\u001c\u0001\u0005\u0002\u0005E\u0002bBAr\u0001\u0011%\u0011Q\u001d\u0005\b\u0003o\u0004A\u0011BA}\u0011\u001d\u0011Y\u0001\u0001C\u0001\u0003cAqAa\u0004\u0001\t\u0003\t\t\u0004C\u0004\u0003\u0014\u0001!\t!!\r\t\u000f\t]\u0001\u0001\"\u0001\u00022!9!1\u0004\u0001\u0005\n\tu\u0001b\u0002B\u0011\u0001\u0011%!1\u0005\u0005\b\u0005c\u0001A\u0011\u0001B\u001a\u0011\u001d\u0011i\u0004\u0001C\u0001\u0005\u007fAqA!\u0013\u0001\t\u0003\u0011Y\u0005C\u0004\u0003V\u0001!IAa\u0016\t\u000f\tu\u0005\u0001\"\u0003\u0003 \"9!\u0011\u001b\u0001\u0005\n\tM\u0007b\u0002Bq\u0001\u0011%!1\u001d\u0005\b\u0007\u001f\u0001A\u0011BB\t\u0011\u001d\u0019I\u0002\u0001C\u0001\u0003cAqa!\b\u0001\t\u0003\u0019y\u0002C\u0004\u0004*\u0001!Iaa\u000b\t\u0013\r\u001d\u0003!%A\u0005\n\r%\u0003\"CB0\u0001E\u0005I\u0011BB1\u0011%\u0019)\u0007AI\u0001\n\u0013\u00199\u0007C\u0005\u0004l\u0001\t\n\u0011\"\u0003\u0004h!I1Q\u000e\u0001\u0012\u0002\u0013%1q\r\u0005\n\u0007_\u0002\u0011\u0013!C\u0005\u0007c:qa!\u001eA\u0011\u0003\u00199H\u0002\u0004@\u0001\"\u00051\u0011\u0010\u0005\u0007\u0019n\"\taa\u001f\t\u000f\u0005U4\b\"\u0001\u0004~!9\u0011\u0011V\u001e\u0005\u0002\r=%!G!mi\u0016\u0014\b+\u0019:uSRLwN\\'b]\u0006<WM\u001d+fgRT!!\u0011\"\u0002\rM,'O^3s\u0015\u0005\u0019\u0015!B6bM.\f7\u0001A\n\u0003\u0001\u0019\u0003\"a\u0012&\u000e\u0003!S\u0011!S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0017\"\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001O!\ty\u0005!D\u0001A\u0003\u0015!x\u000e]5d+\u0005\u0011\u0006CA*Y\u001b\u0005!&BA+W\u0003\u0011a\u0017M\\4\u000b\u0003]\u000bAA[1wC&\u0011\u0011\f\u0016\u0002\u0007'R\u0014\u0018N\\4\u0002\rQ|\u0007/[2!\u0003\u001d!x\u000e]5d\u0013\u0012,\u0012!\u0018\t\u0003=\u001al\u0011a\u0018\u0006\u0003A\u0006\faaY8n[>t'BA\"c\u0015\t\u0019G-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0006\u0019qN]4\n\u0005\u001d|&\u0001B+vS\u0012\f\u0001\u0002^8qS\u000eLE\rI\u0001\u0005i&lW-F\u0001l!\taw.D\u0001n\u0015\tq')A\u0003vi&d7/\u0003\u0002q[\nAQj\\2l)&lW-A\u0003uS6,\u0007%A\u0004nKR\u0014\u0018nY:\u0016\u0003Q\u0004\"!^<\u000e\u0003YT!A]0\n\u0005a4(aB'fiJL7m]\u0001\t[\u0016$(/[2tA\u0005A!M]8lKJLE-F\u0001}!\t9U0\u0003\u0002\u007f\u0011\n\u0019\u0011J\u001c;\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0013A\u00052s_.,'\u000fV8D_:$(o\u001c7mKJ,\"!!\u0002\u0011\u0007=\u000b9!C\u0002\u0002\n\u0001\u0013\u0001E\u0011:pW\u0016\u0014Hk\\\"p]R\u0014x\u000e\u001c7fe\u000eC\u0017M\u001c8fY6\u000bg.Y4fe\u00061\"M]8lKJ$vnQ8oiJ|G\u000e\\3s?\u0012*\u0017\u000f\u0006\u0003\u0002\u0010\u0005U\u0001cA$\u0002\u0012%\u0019\u00111\u0003%\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003/i\u0011\u0011!a\u0001\u0003\u000b\t1\u0001\u001f\u00132\u0003M\u0011'o\\6feR{7i\u001c8ue>dG.\u001a:!\u0003\r!\b\u000fM\u000b\u0003\u0003?\u00012AXA\u0011\u0013\r\t\u0019c\u0018\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\fA\u0001\u001e91A\u0005\u0019A\u000f]\u0019\u0002\tQ\u0004\u0018\u0007I\u0001\u0004iB\u0014\u0014\u0001\u0002;qe\u0001\nQa]3ukB$\"!a\u0004)\u0007U\t)\u0004\u0005\u0003\u00028\u0005\u0015SBAA\u001d\u0015\u0011\tY$!\u0010\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002@\u0005\u0005\u0013a\u00026va&$XM\u001d\u0006\u0004\u0003\u0007\"\u0017!\u00026v]&$\u0018\u0002BA$\u0003s\u0011!BQ3g_J,W)Y2i\u0003%!Xm\u001d;CCNL7\r\u0006\u0003\u0002\u0010\u00055\u0003bBA(-\u0001\u0007\u0011\u0011K\u0001\u0010[\u0016$\u0018\rZ1uCZ+'o]5p]B!\u00111KA-\u001b\t\t)FC\u0002a\u0003/R!!Q1\n\t\u0005m\u0013Q\u000b\u0002\u0010\u001b\u0016$\u0018\rZ1uCZ+'o]5p]\":a#a\u0018\u0002p\u0005E\u0004\u0003BA1\u0003Wj!!a\u0019\u000b\t\u0005\u0015\u0014qM\u0001\taJ|g/\u001b3fe*!\u0011\u0011NA\u001f\u0003\u0019\u0001\u0018M]1ng&!\u0011QNA2\u00051iU\r\u001e5pIN{WO]2f\u0003\u00151\u0018\r\\;fY\t\t\u0019(\t\u0002\u0002v\u00059\u0002O]8wS\u0012,W*\u001a;bI\u0006$\u0018MV3sg&|gn\u001d\u0015\u0004-\u0005e\u0004\u0003BA>\u0003{j!!a\u001a\n\t\u0005}\u0014q\r\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u0007;fgR\u0014\u0015m]5d/&$\bN\u0011:pW\u0016\u0014X\t]8dQR!\u0011qBAC\u0011\u001d\tye\u0006a\u0001\u0003#BsaFA0\u0003_\nI\t\f\u0002\u0002t!\u001aq#!\u001f\u0002AQ,7\u000f\u001e\"bg&\u001c7+\u001a8u\u0019\u0016\fG-\u001a:SK\u000e|g/\u001a:z'R\fG/\u001a\u000b\u0007\u0003\u001f\t\t*a%\t\u000f\u0005=\u0003\u00041\u0001\u0002R!9\u0011Q\u0013\rA\u0002\u0005]\u0015a\u00057fC\u0012,'OU3d_Z,'/_*uCR,\u0007\u0003BAM\u0003?k!!a'\u000b\u0007\u0005u\u0015-\u0001\u0005nKR\fG-\u0019;b\u0013\u0011\t\t+a'\u0003'1+\u0017\rZ3s%\u0016\u001cwN^3ssN#\u0018\r^3)\u000fa\ty&a\u001c\u0002&2\u0012\u0011qU\u0011\u0003\u0003S\u000b!\u0004\u001d:pm&$W\rT3bI\u0016\u0014(+Z2pm\u0016\u0014\u0018p\u0015;bi\u0016D3\u0001GA=\u0003a!Xm\u001d;Pm\u0016\u0014xO]5uK^KG\u000f[5o\u0005\u0006$8\r\u001b\u000b\u0005\u0003\u001f\t\t\fC\u0004\u0002Pe\u0001\r!!\u0015)\u000fe\ty&a\u001c\u000262\u0012\u00111\u000f\u0015\u00043\u0005e\u0014a\u0004;fgR\u001c\u0016N\\4mK\n\u000bGo\u00195\u0015\t\u0005=\u0011Q\u0018\u0005\b\u0003\u001fR\u0002\u0019AA)Q\u001dQ\u0012qLA8\u0003\u0003d#!a\u001d)\u0007i\tI(\u0001\fuKN$8+\u001e2nSR4%o\\7DC2d'-Y2lQ\rY\u0012\u0011\u001a\t\u0005\u0003o\tY-\u0003\u0003\u0002N\u0006e\"\u0001\u0002+fgR\fq\u0003^3ti\u0006+H\u000f[8sSj\fG/[8o\r\u0006LG.\u001a3)\u0007q\tI-\u0001\u000buKN$8\u000b^1mK\n\u0013xn[3s\u000bB|7\r\u001b\u0015\u0004;\u0005%\u0017!\u0005;fgR,fn\u001b8po:\u001cVM\u001d<fe\"\u001aa$!3\u0002AQ,7\u000f\u001e*fiJLxJ\\!vi\",g\u000e^5dCRLwN\u001c$bS2,(/\u001a\u0015\u0004?\u0005%\u0017A\t;fgR\u0014V\r\u001e:z\u001f:,fn];qa>\u0014H/\u001a3WKJ\u001c\u0018n\u001c8FeJ|'\u000fK\u0002!\u0003\u0013\f\u0001\u0004^3tiJ+GO]=P]R{\u0007\u000fT3wK2,%O]8s)\u0011\ty!a:\t\u000f\u0005%\u0018\u00051\u0001\u0002l\u0006)QM\u001d:peB!\u0011Q^Az\u001b\t\tyOC\u0002\u0002r~\u000b\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003k\fyO\u0001\u0004FeJ|'o]\u0001\u0019i\u0016\u001cHOU3uef|e.\u0012:s_J\u0014Vm\u001d9p]N,G\u0003BA\b\u0003wDq!!@#\u0001\u0004\ty0\u0001\u0005sKN\u0004xN\\:f!\u0011\u0011\tAa\u0002\u000e\u0005\t\r!b\u0001B\u0003C\u000691\r\\5f]R\u001c\u0018\u0002\u0002B\u0005\u0005\u0007\u0011ab\u00117jK:$(+Z:q_:\u001cX-\u0001\ruKN$\u0018J\u001c<bY&$W\u000b\u001d3bi\u00164VM]:j_:D3aIAe\u0003e!Xm\u001d;V].twn\u001e8U_BL7\rU1si&$\u0018n\u001c8)\u0007\u0011\nI-A\fuKN$hj\u001c;MK\u0006$WM](s\r>dGn\\<fe\"\u001aQ%!3\u0002%Q,7\u000f^%om\u0006d\u0017\u000e\u001a*fcV,7\u000f\u001e\u0015\u0004M\u0005%\u0017aE2iK\u000e\\\u0007+\u0019:uSRLwN\\#se>\u0014H\u0003BA\b\u0005?Aq!!;(\u0001\u0004\tY/\u0001\nuKN$\b+\u0019:uSRLwN\\#se>\u0014HC\u0002B\u0013\u0005W\u0011y\u0003E\u0002P\u0005OI1A!\u000bA\u0005U\tE\u000e^3s!\u0006\u0014H/\u001b;j_:l\u0015M\\1hKJDqA!\f)\u0001\u0004\ty\"\u0001\u0002ua\"9\u0011\u0011\u001e\u0015A\u0002\u0005-\u0018a\u0004;fgR|e.Z%o\r2Lw\r\u001b;\u0015\t\u0005=!Q\u0007\u0005\b\u0003\u001fJ\u0003\u0019AA)Q\u001dI\u0013qLA8\u0005sa#!a\u001d)\u0007%\nI(\u0001\u0010uKN$\b+\u0019:uSRLwN\\'jgNLgnZ%o%\u0016\u001c\bo\u001c8tKR!\u0011q\u0002B!\u0011\u001d\tyE\u000ba\u0001\u0003#BsAKA0\u0003_\u0012)\u0005\f\u0002\u0002t!\u001a!&!\u001f\u0002'Q,7\u000f\u001e)beRL\u0017\r\u001c+pa&\u001c\u0017\nZ:\u0015\t\u0005=!Q\n\u0005\b\u0003\u001fZ\u0003\u0019AA)Q\u001dY\u0013qLA8\u0005#b#!a\u001d)\u0007-\nI(A\twKJLg-_*f]\u0012\u0014V-];fgR$bA!\u0017\u0003`\t\u0005\u0004cA(\u0003\\%\u0019!Q\f!\u0003E\r{g\u000e\u001e:pY2,'OU3rk\u0016\u001cHoQ8na2,G/[8o\u0011\u0006tG\r\\3s\u0011\u001d\t\t\u0001\fa\u0001\u0003\u000bAqAa\u0019-\u0001\u0004\u0011)'A\bfqB,7\r^3e%\u0016\fX/Z:u!\u0019\u00119G!\u001c\u0003r5\u0011!\u0011\u000e\u0006\u0004\u0005W\"\u0017aB7pG.LGo\\\u0005\u0005\u0005_\u0012IGA\bBe\u001e,X.\u001a8u\u001b\u0006$8\r[3sa\u0011\u0011\u0019Ha#\u0011\r\tU$\u0011\u0011BD\u001d\u0011\u00119H! \u000e\u0005\te$b\u0001B>?\u0006A!/Z9vKN$8/\u0003\u0003\u0003\u0000\te\u0014aD!cgR\u0014\u0018m\u0019;SKF,Xm\u001d;\n\t\t\r%Q\u0011\u0002\b\u0005VLG\u000eZ3s\u0015\u0011\u0011yH!\u001f\u0011\t\t%%1\u0012\u0007\u0001\t1\u0011iI!\u0019\u0002\u0002\u0003\u0005)\u0011\u0001BH\u0005\ryFEM\t\u0005\u0005#\u00139\nE\u0002H\u0005'K1A!&I\u0005\u001dqu\u000e\u001e5j]\u001e\u0004BAa\u001e\u0003\u001a&!!1\u0014B=\u0005=\t%m\u001d;sC\u000e$(+Z9vKN$\u0018\u0001H1mi\u0016\u0014\b+\u0019:uSRLwN\u001c*fcV,7\u000f^'bi\u000eDWM\u001d\u000b\u0007\u0005C\u0013iKa2\u0011\r\t\u001d$Q\u000eBRa\u0011\u0011)K!+\u0011\r\tU$\u0011\u0011BT!\u0011\u0011II!+\u0005\u0017\t-V&!A\u0001\u0002\u000b\u0005!q\u0012\u0002\u0004?\u0012\u001a\u0004b\u0002BX[\u0001\u0007!\u0011W\u0001\u0018Kb\u0004Xm\u0019;fIR{\u0007/[2QCJ$\u0018\u000e^5p]N\u0004bAa-\u0003B\u0006}a\u0002\u0002B[\u0005{\u00032Aa.I\u001b\t\u0011ILC\u0002\u0003<\u0012\u000ba\u0001\u0010:p_Rt\u0014b\u0001B`\u0011\u00061\u0001K]3eK\u001aLAAa1\u0003F\n\u00191+\u001a;\u000b\u0007\t}\u0006\nC\u0004\u0003J6\u0002\rAa3\u0002\u001f\u0015D\b/Z2uK\u00124VM]:j_:\u00042a\u0012Bg\u0013\r\u0011y\r\u0013\u0002\u0006'\"|'\u000f^\u0001\u0013[\u0006\\Wm\u00117jK:$(+Z:q_:\u001cX\r\u0006\u0004\u0002\u0000\nU'Q\u001c\u0005\b\u0003{t\u0003\u0019\u0001Bl!\u0011\u00119H!7\n\t\tm'\u0011\u0010\u0002\u0017\u00032$XM\u001d)beRLG/[8o%\u0016\u001c\bo\u001c8tK\"9!q\u001c\u0018A\u0002\t-\u0017a\u0002<feNLwN\\\u0001\u0013[\u0006\\W-\u00117uKJ\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0003\u0003X\n\u0015\bb\u0002Bt_\u0001\u0007!\u0011^\u0001\u0007i>\u0004\u0018nY:\u0011\r\t-(Q\u001fB~\u001d\u0011\u0011iO!=\u000f\t\t]&q^\u0005\u0002\u0013&\u0019!1\u001f%\u0002\u000fA\f7m[1hK&!!q\u001fB}\u0005\r\u0019V-\u001d\u0006\u0004\u0005gD\u0005\u0003\u0002B\u007f\u0007\u0013qAAa@\u0004\u00065\u00111\u0011\u0001\u0006\u0004\u0007\u0007y\u0016aB7fgN\fw-Z\u0005\u0005\u0007\u000f\u0019\t!\u0001\u000eBYR,'\u000fU1si&$\u0018n\u001c8SKN\u0004xN\\:f\t\u0006$\u0018-\u0003\u0003\u0004\f\r5!!\u0003+pa&\u001cG)\u0019;b\u0015\u0011\u00199a!\u0001\u000275\f7.Z!mi\u0016\u0014\b+\u0019:uSRLwN\u001c+pa&\u001cG)\u0019;b)\u0019\u0011Ypa\u0005\u0004\u0018!91Q\u0003\u0019A\u0002\u0005}\u0011\u0001\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8o\u0011\u001d\tI\u000f\ra\u0001\u0003W\f1\u0002^3tij[')Y:jG\"\u001a\u0011'!3\u00023Q,7\u000f^\"b]N+(-\\5u\rJ|WnQ1mY\n\f7m\u001b\u000b\u0005\u0003\u001f\u0019\t\u0003C\u0004\u0002PI\u0002\r!!\u0015)\u000fI\ny&a\u001c\u0004&1\u0012\u00111\u000f\u0015\u0004e\u0005e\u0014!\u00059beRLG/[8o%\u0016\u001c\bo\u001c8tKRq!q[B\u0017\u0007_\u0019\td!\u000e\u0004:\ru\u0002\"\u0003B\u0017gA\u0005\t\u0019AA\u0010\u0011%\tIo\rI\u0001\u0002\u0004\tY\u000f\u0003\u0005\u00044M\u0002\n\u00111\u0001}\u00039\u0001\u0018M\u001d;ji&|g.\u00129pG\"D\u0001ba\u000e4!\u0003\u0005\r\u0001`\u0001\tY\u0016\fG-\u001a:JI\"A11H\u001a\u0011\u0002\u0003\u0007A0A\u0006mK\u0006$WM]#q_\u000eD\u0007\"CB gA\u0005\t\u0019AB!\u0003\rI7O\u001d\t\u0006\u0005W\u001c\u0019\u0005`\u0005\u0005\u0007\u000b\u0012IP\u0001\u0003MSN$\u0018a\u00079beRLG/[8o%\u0016\u001c\bo\u001c8tK\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004L)\"\u0011qDB'W\t\u0019y\u0005\u0005\u0003\u0004R\rmSBAB*\u0015\u0011\u0019)fa\u0016\u0002\u0013Ut7\r[3dW\u0016$'bAB-\u0011\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\ru31\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u00079beRLG/[8o%\u0016\u001c\bo\u001c8tK\u0012\"WMZ1vYR$#'\u0006\u0002\u0004d)\"\u00111^B'\u0003m\u0001\u0018M\u001d;ji&|gNU3ta>t7/\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u00111\u0011\u000e\u0016\u0004y\u000e5\u0013a\u00079beRLG/[8o%\u0016\u001c\bo\u001c8tK\u0012\"WMZ1vYR$C'A\u000eqCJ$\u0018\u000e^5p]J+7\u000f]8og\u0016$C-\u001a4bk2$H%N\u0001\u001ca\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9p]N,G\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\rM$\u0006BB!\u0007\u001b\n\u0011$\u00117uKJ\u0004\u0016M\u001d;ji&|g.T1oC\u001e,'\u000fV3tiB\u0011qjO\n\u0003w\u0019#\"aa\u001e\u0015\u0005\r}\u0004CBBA\u0007\u0017\u000b\t&\u0004\u0002\u0004\u0004*!1QQBD\u0003\u0019\u0019HO]3b[*\u00191\u0011\u0012,\u0002\tU$\u0018\u000e\\\u0005\u0005\u0007\u001b\u001b\u0019I\u0001\u0004TiJ,\u0017-\u001c\u000b\u0003\u0007#\u0003ba!!\u0004\f\u000eM\u0005\u0003BA1\u0007+KAaa&\u0002d\tI\u0011I]4v[\u0016tGo\u001d")
public class AlterPartitionManagerTest {
    private final String topic;
    private final Uuid topicId = Uuid.randomUuid();
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final int brokerId;
    private BrokerToControllerChannelManager brokerToController;
    private final TopicIdPartition tp0 = new TopicIdPartition(this.topicId(), 0, this.topic());
    private final TopicIdPartition tp1 = new TopicIdPartition(this.topicId(), 1, this.topic());
    private final TopicIdPartition tp2 = new TopicIdPartition(this.topicId(), 2, this.topic());

    public static Stream<Arguments> provideLeaderRecoveryState() {
        return AlterPartitionManagerTest$.MODULE$.provideLeaderRecoveryState();
    }

    public static Stream<MetadataVersion> provideMetadataVersions() {
        return AlterPartitionManagerTest$.MODULE$.provideMetadataVersions();
    }

    public String topic() {
        return this.topic;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public BrokerToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    public void brokerToController_$eq(BrokerToControllerChannelManager x$1) {
        this.brokerToController = x$1;
    }

    public TopicIdPartition tp0() {
        return this.tp0;
    }

    public TopicIdPartition tp1() {
        return this.tp1;
    }

    public TopicIdPartition tp2() {
        return this.tp2;
    }

    @BeforeEach
    public void setup() {
        this.brokerToController_$eq((BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class));
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testBasic(MetadataVersion metadataVersion) {
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        alterPartitionManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testBasicWithBrokerEpoch(MetadataVersion metadataVersion) {
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 101L, (Function0 & Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        ListBuffer isrWithBrokerEpoch = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 3).foreach((Function1 & Serializable)ii -> AlterPartitionManagerTest.$anonfun$testBasicWithBrokerEpoch$3(isrWithBrokerEpoch, BoxesRunTime.unboxToInt((Object)ii)));
        alterPartitionManager.submit(this.tp0(), new LeaderAndIsr(1, 1, LeaderRecoveryState.RECOVERED, isrWithBrokerEpoch.toList(), 10, (Option)None$.MODULE$), 0, false);
        AlterPartitionRequestData expectedAlterPartitionData = new AlterPartitionRequestData().setBrokerId(this.brokerId()).setBrokerEpoch(101L);
        AlterPartitionRequestData.TopicData topicData = new AlterPartitionRequestData.TopicData().setTopicName(this.topic()).setTopicId(this.topicId());
        if (metadataVersion.isTopicIdsSupported()) {
            ListBuffer newIsrWithBrokerEpoch = new ListBuffer();
            newIsrWithBrokerEpoch.append((Object)new AlterPartitionRequestData.BrokerState().setBrokerId(1).setBrokerEpoch(101L));
            newIsrWithBrokerEpoch.append((Object)new AlterPartitionRequestData.BrokerState().setBrokerId(2).setBrokerEpoch(102L));
            newIsrWithBrokerEpoch.append((Object)new AlterPartitionRequestData.BrokerState().setBrokerId(3).setBrokerEpoch(103L));
            topicData.partitions().add(new AlterPartitionRequestData.PartitionData().setPartitionIndex(0).setLeaderEpoch(1).setPartitionEpoch(10).setNewIsrWithEpochs(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)newIsrWithBrokerEpoch.toList()).asJava()));
        } else {
            topicData.partitions().add(new AlterPartitionRequestData.PartitionData().setPartitionIndex(0).setLeaderEpoch(1).setPartitionEpoch(10).setNewIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()));
        }
        expectedAlterPartitionData.topics().add(topicData);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ArgumentCaptor captor = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)captor.capture(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
        Assertions.assertEquals((Object)expectedAlterPartitionData, (Object)((AlterPartitionRequest)((AlterPartitionRequest.Builder)captor.getValue()).build()).data());
    }

    @ParameterizedTest
    @MethodSource(value={"provideLeaderRecoveryState"})
    public void testBasicSentLeaderRecoveryState(MetadataVersion metadataVersion, LeaderRecoveryState leaderRecoveryState) {
        ArgumentCaptor requestCapture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        alterPartitionManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), leaderRecoveryState, 10, (Option)None$.MODULE$), 0, false);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)requestCapture.capture(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)requestCapture.getValue()).build();
        LeaderRecoveryState expectedLeaderRecoveryState = metadataVersion.isAtLeast(MetadataVersion.IBP_3_2_IV0) ? leaderRecoveryState : LeaderRecoveryState.RECOVERED;
        AlterPartitionRequestData.PartitionData partitionReq = (AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0);
        Assertions.assertEquals((byte)expectedLeaderRecoveryState.value(), (byte)partitionReq.leaderRecoveryState());
        LeaderRecoveryState leaderRecoveryState2 = leaderRecoveryState;
        LeaderRecoveryState leaderRecoveryState3 = LeaderRecoveryState.RECOVERING;
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((!(leaderRecoveryState2 != null ? !leaderRecoveryState2.equals(leaderRecoveryState3) : leaderRecoveryState3 != null) ? 1 : 0) != 0), (Object)BoxesRunTime.boxToBoolean((boolean)partitionReq.isUnclean()));
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testOverwriteWithinBatch(MetadataVersion metadataVersion) {
        boolean canUseTopicIds = metadataVersion.isAtLeast(MetadataVersion.IBP_2_8_IV0);
        ArgumentCaptor capture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        Assertions.assertFalse((boolean)alterPartitionManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false).isDone());
        CompletableFuture failedSubmitFuture = alterPartitionManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        Assertions.assertTrue((boolean)failedSubmitFuture.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)failedSubmitFuture, OperationNotAttemptedException.class);
        AlterPartitionResponse alterPartitionResp = this.partitionResponse(this.tp0(), Errors.NONE, 0, 0, 0, this.partitionResponse$default$6());
        ClientResponse resp = this.makeClientResponse(alterPartitionResp, canUseTopicIds ? ApiKeys.ALTER_PARTITION.latestVersion() : (short)1);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        Assertions.assertFalse((boolean)alterPartitionManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false).isDone());
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)request.data().topics().size(), (int)1);
        if (request.version() < 3) {
            Assertions.assertEquals((int)((AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).newIsr().size(), (int)1);
            return;
        }
        Assertions.assertEquals((int)((AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).newIsrWithEpochs().size(), (int)1);
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testSingleBatch(MetadataVersion metadataVersion) {
        ArgumentCaptor capture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        alterPartitionManager.submit(new TopicIdPartition(this.topicId(), 0, this.topic()), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 9).foreach((Function1 & Serializable)i -> alterPartitionManager.submit(new TopicIdPartition(this.topicId(), BoxesRunTime.unboxToInt((Object)i), this.topic()), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false));
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData());
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterPartitionResp);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)request.data().topics().size(), (int)1);
        Assertions.assertEquals((int)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().size(), (int)10);
    }

    @Test
    public void testSubmitFromCallback() {
        AlterPartitionResponse alterPartitionRespWithPartitionError = this.partitionResponse(this.tp0(), Errors.UNKNOWN_SERVER_ERROR, 0, 0, 0, this.partitionResponse$default$6());
        ClientResponse errorResponse = this.makeClientResponse(alterPartitionRespWithPartitionError, ApiKeys.ALTER_PARTITION.latestVersion());
        int leaderId = 1;
        int leaderEpoch = 1;
        int partitionEpoch = 10;
        List isr = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(leaderId, leaderEpoch, isr, LeaderRecoveryState.RECOVERED, partitionEpoch, (Option)None$.MODULE$);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> MetadataVersion.IBP_3_2_IV0);
        alterPartitionManager.start();
        CompletableFuture future = alterPartitionManager.submit(this.tp0(), leaderAndIsr, 0, false);
        CompletableFuture finalFuture = new CompletableFuture();
        future.whenComplete((x$2, e2) -> {
            if (e2 != null) {
                alterPartitionManager.submit(this.tp0(), leaderAndIsr, 0, false).whenComplete((result, e) -> {
                    if (e != null) {
                        finalFuture.completeExceptionally((Throwable)e);
                        return;
                    }
                    finalFuture.complete(result);
                });
                return;
            }
            finalFuture.completeExceptionally((Throwable)((Object)new AssertionError((Object)"Expected the future to be failed")));
        });
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(errorResponse);
        AlterPartitionResponse retryAlterPartitionResponse = this.partitionResponse(this.tp0(), Errors.NONE, partitionEpoch, leaderId, leaderEpoch, (List<Object>)isr);
        ClientResponse retryResponse = this.makeClientResponse(retryAlterPartitionResponse, ApiKeys.ALTER_PARTITION.latestVersion());
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(retryResponse);
        Assertions.assertEquals((Object)leaderAndIsr, finalFuture.get(200L, TimeUnit.MILLISECONDS));
        Assertions.assertFalse((boolean)alterPartitionManager.unsentIsrUpdates().containsKey(this.tp0().topicPartition()));
    }

    @Test
    public void testAuthorizationFailed() {
        this.testRetryOnTopLevelError(Errors.CLUSTER_AUTHORIZATION_FAILED);
    }

    @Test
    public void testStaleBrokerEpoch() {
        this.testRetryOnTopLevelError(Errors.STALE_BROKER_EPOCH);
    }

    @Test
    public void testUnknownServer() {
        this.testRetryOnTopLevelError(Errors.UNKNOWN_SERVER_ERROR);
    }

    @Test
    public void testRetryOnAuthenticationFailure() {
        this.testRetryOnErrorResponse(new ClientResponse(null, null, "", 0L, 0L, false, null, new AuthenticationException("authentication failed"), null));
    }

    @Test
    public void testRetryOnUnsupportedVersionError() {
        this.testRetryOnErrorResponse(new ClientResponse(null, null, "", 0L, 0L, false, new UnsupportedVersionException("unsupported version"), null, null));
    }

    private void testRetryOnTopLevelError(Errors error) {
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData().setErrorCode(error.code()));
        ClientResponse response = this.makeClientResponse(alterPartitionResp, ApiKeys.ALTER_PARTITION.latestVersion());
        this.testRetryOnErrorResponse(response);
    }

    private void testRetryOnErrorResponse(ClientResponse response) {
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> MetadataVersion.IBP_3_2_IV0);
        alterPartitionManager.start();
        alterPartitionManager.submit(this.tp0(), leaderAndIsr, 0, false);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(response);
        Assertions.assertTrue((boolean)alterPartitionManager.unsentIsrUpdates().containsKey(this.tp0().topicPartition()));
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        this.time().sleep(100L);
        scheduler.tick();
        AlterPartitionResponse retryAlterPartitionResponse = this.partitionResponse(this.tp0(), Errors.NONE, 0, 0, 0, this.partitionResponse$default$6());
        ClientResponse retryResponse = this.makeClientResponse(retryAlterPartitionResponse, ApiKeys.ALTER_PARTITION.latestVersion());
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(retryResponse);
        Assertions.assertFalse((boolean)alterPartitionManager.unsentIsrUpdates().containsKey(this.tp0().topicPartition()));
    }

    @Test
    public void testInvalidUpdateVersion() {
        this.checkPartitionError(Errors.INVALID_UPDATE_VERSION);
    }

    @Test
    public void testUnknownTopicPartition() {
        this.checkPartitionError(Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    @Test
    public void testNotLeaderOrFollower() {
        this.checkPartitionError(Errors.NOT_LEADER_OR_FOLLOWER);
    }

    @Test
    public void testInvalidRequest() {
        this.checkPartitionError(Errors.INVALID_REQUEST);
    }

    private void checkPartitionError(Errors error) {
        Assertions.assertFalse((boolean)this.testPartitionError(this.tp0(), error).submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false).isDone());
    }

    private AlterPartitionManager testPartitionError(TopicIdPartition tp, Errors error) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> MetadataVersion.IBP_3_2_IV0);
        alterPartitionManager.start();
        CompletableFuture future = alterPartitionManager.submit(tp, LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        AlterPartitionResponse alterPartitionResp = this.partitionResponse(tp, error, 0, 0, 0, this.partitionResponse$default$6());
        ClientResponse resp = this.makeClientResponse(alterPartitionResp, ApiKeys.ALTER_PARTITION.latestVersion());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future, (Class)error.exception().getClass());
        return alterPartitionManager;
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testOneInFlight(MetadataVersion metadataVersion) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        alterPartitionManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        alterPartitionManager.submit(this.tp1(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        alterPartitionManager.submit(this.tp2(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData());
        ClientResponse resp = this.makeClientResponse(alterPartitionResp, ApiKeys.ALTER_PARTITION.latestVersion());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testPartitionMissingInResponse(MetadataVersion metadataVersion) {
        short expectedVersion = metadataVersion.isTopicIdsSupported() ? ApiKeys.ALTER_PARTITION.latestVersion() : (short)1;
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$);
        int controlledEpoch = 0;
        int brokerEpoch = 2;
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        BrokerToControllerChannelManager brokerToController = (BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class);
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(brokerToController, (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> brokerEpoch, (Function0 & Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        CompletableFuture future1 = alterPartitionManager.submit(this.tp0(), leaderAndIsr, controlledEpoch, false);
        ControllerRequestCompletionHandler callback1 = this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp0()}))), expectedVersion));
        CompletableFuture future2 = alterPartitionManager.submit(this.tp1(), leaderAndIsr, controlledEpoch, false);
        CompletableFuture future3 = alterPartitionManager.submit(this.tp2(), leaderAndIsr, controlledEpoch, false);
        callback1.onComplete(this.makeClientResponse(this.partitionResponse(this.tp0(), Errors.UNKNOWN_SERVER_ERROR, 0, 0, 0, this.partitionResponse$default$6()), expectedVersion));
        TestUtils.assertFutureThrows((Future)future1, UnknownServerException.class);
        Assertions.assertFalse((boolean)future2.isDone());
        Assertions.assertFalse((boolean)future3.isDone());
        this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp1(), this.tp2()}))), expectedVersion)).onComplete(this.makeClientResponse(this.partitionResponse(this.tp2(), Errors.UNKNOWN_SERVER_ERROR, 0, 0, 0, this.partitionResponse$default$6()), expectedVersion));
        TestUtils.assertFutureThrows((Future)future3, UnknownServerException.class);
        Assertions.assertFalse((boolean)future2.isDone());
        this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp1()}))), expectedVersion)).onComplete(this.makeClientResponse(this.partitionResponse(this.tp1(), Errors.UNKNOWN_SERVER_ERROR, 0, 0, 0, this.partitionResponse$default$6()), expectedVersion));
        TestUtils.assertFutureThrows((Future)future2, UnknownServerException.class);
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testPartialTopicIds(MetadataVersion metadataVersion) {
        boolean canUseTopicIds = metadataVersion.isAtLeast(MetadataVersion.IBP_2_8_IV0);
        TopicIdPartition foo = new TopicIdPartition(Uuid.ZERO_UUID, 0, "foo");
        TopicIdPartition bar = new TopicIdPartition(Uuid.randomUuid(), 0, "bar");
        TopicIdPartition zar = new TopicIdPartition(Uuid.randomUuid(), 0, "zar");
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$);
        int controlledEpoch = 0;
        int brokerEpoch = 2;
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        BrokerToControllerChannelManager brokerToController = (BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class);
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(brokerToController, (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> brokerEpoch, (Function0 & Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        CompletableFuture future1 = alterPartitionManager.submit(zar, leaderAndIsr, controlledEpoch, false);
        ControllerRequestCompletionHandler callback1 = this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{zar}))), canUseTopicIds ? ApiKeys.ALTER_PARTITION.latestVersion() : (short)1));
        CompletableFuture future2 = alterPartitionManager.submit(foo, leaderAndIsr, controlledEpoch, false);
        CompletableFuture future3 = alterPartitionManager.submit(bar, leaderAndIsr, controlledEpoch, false);
        callback1.onComplete(this.makeClientResponse(this.makeAlterPartition((scala.collection.immutable.Seq<AlterPartitionResponseData.TopicData>)new .colon.colon((Object)this.makeAlterPartitionTopicData(zar, Errors.NONE), (List)Nil$.MODULE$)), canUseTopicIds ? ApiKeys.ALTER_PARTITION.latestVersion() : (short)1));
        Assertions.assertTrue((boolean)future1.isDone());
        Assertions.assertFalse((boolean)future2.isDone());
        Assertions.assertFalse((boolean)future3.isDone());
        this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo, bar}))), (short)1)).onComplete(this.makeClientResponse(this.makeAlterPartition((scala.collection.immutable.Seq<AlterPartitionResponseData.TopicData>)new .colon.colon((Object)this.makeAlterPartitionTopicData(foo, Errors.NONE), (List)new .colon.colon((Object)this.makeAlterPartitionTopicData(bar, Errors.NONE), (List)Nil$.MODULE$))), (short)1));
        Assertions.assertTrue((boolean)future1.isDone());
        Assertions.assertTrue((boolean)future2.isDone());
        Assertions.assertTrue((boolean)future3.isDone());
    }

    private ControllerRequestCompletionHandler verifySendRequest(BrokerToControllerChannelManager brokerToController, ArgumentMatcher<AbstractRequest.Builder<? extends AbstractRequest>> expectedRequest) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)brokerToController)).sendRequest((AbstractRequest.Builder)ArgumentMatchers.argThat(expectedRequest), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{brokerToController});
        return (ControllerRequestCompletionHandler)callbackCapture.getValue();
    }

    private ArgumentMatcher<AbstractRequest.Builder<? extends AbstractRequest>> alterPartitionRequestMatcher(Set<TopicIdPartition> expectedTopicPartitions, short expectedVersion) {
        return request -> {
            Assertions.assertEquals((Object)ApiKeys.ALTER_PARTITION, (Object)request.apiKey());
            AlterPartitionRequest alterPartitionRequest = (AlterPartitionRequest)((AlterPartitionRequest.Builder)request).build();
            Assertions.assertEquals((short)expectedVersion, (short)alterPartitionRequest.version());
            Set requestTopicPartitions = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(alterPartitionRequest.data().topics()).asScala().flatMap((Function1 & Serializable)topicData -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(topicData.partitions()).asScala().map((Function1 & Serializable)partitionData -> new TopicIdPartition(topicData.topicId(), partitionData.partitionIndex(), topicData.topicName())))).toSet();
            Set set = expectedTopicPartitions;
            return !(set != null ? !set.equals(requestTopicPartitions) : requestTopicPartitions != null);
        };
    }

    private ClientResponse makeClientResponse(AlterPartitionResponse response, short version) {
        return new ClientResponse(new RequestHeader(response.apiKey(), version, "", 0), null, "", 0L, 0L, false, null, null, (AbstractResponse)AlterPartitionResponse.parse((ByteBuffer)MessageUtil.toByteBuffer((Message)response.data(), (short)version), (short)version, (MessageContext)MessageContext.IDENTITY));
    }

    private AlterPartitionResponse makeAlterPartition(scala.collection.immutable.Seq<AlterPartitionResponseData.TopicData> topics) {
        return new AlterPartitionResponse(new AlterPartitionResponseData().setTopics(CollectionConverters$.MODULE$.SeqHasAsJava(topics).asJava()));
    }

    private AlterPartitionResponseData.TopicData makeAlterPartitionTopicData(TopicIdPartition topicIdPartition, Errors error) {
        return new AlterPartitionResponseData.TopicData().setTopicName(topicIdPartition.topic()).setTopicId(topicIdPartition.topicId()).setPartitions(Collections.singletonList(new AlterPartitionResponseData.PartitionData().setPartitionIndex(topicIdPartition.partition()).setErrorCode(error.code())));
    }

    @Test
    public void testZkBasic() {
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        scheduler.startup();
        KafkaZkClient kafkaZkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        ((KafkaZkClient)Mockito.doAnswer(x$3 -> new Tuple2.mcZI.sp(true, 2)).when((Object)kafkaZkClient)).conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)1), (Option)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.doAnswer(x$4 -> new Tuple2.mcZI.sp(false, 2)).when((Object)kafkaZkClient)).conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)3), (Option)ArgumentMatchers.any());
        ZkAlterPartitionManager zkIsrManager = new ZkAlterPartitionManager((Scheduler)scheduler, (Time)this.time(), kafkaZkClient);
        zkIsrManager.start();
        CompletableFuture future1 = zkIsrManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 1, (Option)None$.MODULE$), 0, false);
        Assertions.assertTrue((boolean)future1.isDone());
        Assertions.assertEquals((Object)LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 2, (Option)None$.MODULE$), future1.get());
        CompletableFuture future2 = zkIsrManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 3, (Option)None$.MODULE$), 0, false);
        Assertions.assertTrue((boolean)future2.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future2, InvalidUpdateVersionException.class);
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testCanSubmitFromCallback(MetadataVersion metadataVersion) {
        ArgumentCaptor capture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterIsrManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> metadataVersion);
        alterIsrManager.start();
        CompletableFuture future = this.submitAndVerify$1((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), alterIsrManager);
        future.whenComplete((x$5, x$6) -> this.submitAndVerify$1((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), alterIsrManager));
        AlterPartitionResponse alterPartitionResponse = this.partitionResponse(this.tp0(), Errors.NONE, 0, 0, 0, this.partitionResponse$default$6());
        ClientResponse resp = this.makeClientResponse(alterPartitionResponse, ApiKeys.ALTER_PARTITION.latestVersion());
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        Assertions.assertTrue((boolean)future.isDone());
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)1, (int)request.data().topics().size());
        if (request.version() < 3) {
            Assertions.assertEquals((int)((AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).newIsr().size(), (int)1);
            return;
        }
        Assertions.assertEquals((int)((AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).newIsrWithEpochs().size(), (int)1);
    }

    private AlterPartitionResponse partitionResponse(TopicIdPartition tp, Errors error, int partitionEpoch, int leaderId, int leaderEpoch, List<Object> isr) {
        return new AlterPartitionResponse(new AlterPartitionResponseData().setTopics(Collections.singletonList(new AlterPartitionResponseData.TopicData().setTopicName(tp.topic()).setTopicId(tp.topicId()).setPartitions(Collections.singletonList(new AlterPartitionResponseData.PartitionData().setPartitionIndex(tp.partition()).setPartitionEpoch(partitionEpoch).setLeaderEpoch(leaderEpoch).setLeaderId(leaderId).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)isr.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setErrorCode(error.code()))))));
    }

    private TopicIdPartition partitionResponse$default$1() {
        return this.tp0();
    }

    private Errors partitionResponse$default$2() {
        return Errors.NONE;
    }

    private int partitionResponse$default$3() {
        return 0;
    }

    private int partitionResponse$default$4() {
        return 0;
    }

    private int partitionResponse$default$5() {
        return 0;
    }

    private List<Object> partitionResponse$default$6() {
        return package$.MODULE$.List().empty();
    }

    public static final /* synthetic */ ListBuffer $anonfun$testBasicWithBrokerEpoch$3(ListBuffer isrWithBrokerEpoch$1, int ii) {
        return (ListBuffer)isrWithBrokerEpoch$1.$plus$eq((Object)new AlterPartitionRequestData.BrokerState().setBrokerId(ii).setBrokerEpoch((long)(100 + ii)));
    }

    private final CompletableFuture submitAndVerify$1(List isr, DefaultAlterPartitionManager alterIsrManager$1) {
        CompletableFuture future = alterIsrManager$1.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, isr, LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        Assertions.assertFalse((boolean)future.isDone());
        return future;
    }

    public AlterPartitionManagerTest() {
        this.topic = "test-topic";
        this.brokerId = 1;
    }
}

