/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.cluster.BrokerEndPoint;
import kafka.server.AbstractFetcherThreadTest;
import kafka.server.BrokerTopicStats$;
import kafka.server.FailedPartitions;
import kafka.server.FetcherMetrics$;
import kafka.server.Fetching$;
import kafka.server.InitialFetchState;
import kafka.server.MockFetcherThread;
import kafka.server.MockFetcherThread$;
import kafka.server.MockLeaderEndPoint;
import kafka.server.MockLeaderEndPoint$;
import kafka.server.MockTierStateMachine;
import kafka.server.MockTierStateMachine$;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.PartitionState;
import kafka.server.PartitionState$;
import kafka.server.Truncating$;
import kafka.utils.DelayedItem;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.UnknownLeaderEpochException;
import org.apache.kafka.common.errors.UnknownTopicIdException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t}b\u0001B\u001c9\u0001uBQ\u0001\u0012\u0001\u0005\u0002\u0015Cq\u0001\u0013\u0001C\u0002\u0013\u0005\u0011\n\u0003\u0004N\u0001\u0001\u0006IA\u0013\u0005\b\u001d\u0002\u0011\r\u0011\"\u0001P\u0011\u0019I\u0007\u0001)A\u0005!\"9!\u000e\u0001b\u0001\n\u0003Y\u0007BB8\u0001A\u0003%A\u000eC\u0004q\u0001\t\u0007I\u0011B9\t\rU\u0004\u0001\u0015!\u0003s\u0011\u001d1\bA1A\u0005\nEDaa\u001e\u0001!\u0002\u0013\u0011\bb\u0002=\u0001\u0005\u0004%I!\u001f\u0005\u0007{\u0002\u0001\u000b\u0011\u0002>\t\u000by\u0004A\u0011A@\t\u000f\u0005u\u0001\u0001\"\u0003\u0002 !9\u00111\b\u0001\u0005\n\u0005u\u0002bBA8\u0001\u0011%\u0011\u0011\u000f\u0005\u0007\u0003\u0013\u0003A\u0011A@\t\r\u0005M\u0005\u0001\"\u0001\u0000\u0011\u0019\t9\n\u0001C\u0001\u007f\"1\u00111\u0014\u0001\u0005\u0002}Da!a(\u0001\t\u0003y\bBBAR\u0001\u0011\u0005q\u0010\u0003\u0004\u0002(\u0002!\ta \u0005\u0007\u0003W\u0003A\u0011A@\t\r\u0005=\u0006\u0001\"\u0001\u0000\u0011\u0019\t\u0019\f\u0001C\u0001\u007f\"1\u0011q\u0017\u0001\u0005\u0002}Da!a/\u0001\t\u0003y\bBBA`\u0001\u0011\u0005q\u0010\u0003\u0004\u0002D\u0002!\ta \u0005\u0007\u0003\u000f\u0004A\u0011A@\t\r\u0005-\u0007\u0001\"\u0001\u0000\u0011\u0019\ty\r\u0001C\u0001\u007f\"1\u00111\u001b\u0001\u0005\u0002}Da!a6\u0001\t\u0003y\bBBAn\u0001\u0011\u0005q\u0010\u0003\u0004\u0002`\u0002!\ta \u0005\u0007\u0003c\u0004A\u0011A@\t\r\u0005U\b\u0001\"\u0001\u0000\u0011\u0019\tI\u0010\u0001C\u0001\u007f\"1\u0011Q \u0001\u0005\u0002}DaA!\u0001\u0001\t\u0003y\bB\u0002B\u0003\u0001\u0011\u0005q\u0010\u0003\u0004\u0003\n\u0001!\ta \u0005\b\u0005\u001b\u0001A\u0011\u0002B\b\u0011\u0019\u0011)\u0002\u0001C\u0001\u007f\"1!\u0011\u0004\u0001\u0005\u0002}DaA!\b\u0001\t\u0003y\bB\u0002B\u0011\u0001\u0011\u0005q\u0010C\u0004\u0003&\u0001!IAa\n\t\r\tM\u0002\u0001\"\u0001\u0000\u0011\u0019\u00119\u0004\u0001C\u0001\u007f\"1!1\b\u0001\u0005\u0002}\u0014\u0011$\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG\rV3ti*\u0011\u0011HO\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003m\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001}A\u0011qHQ\u0007\u0002\u0001*\t\u0011)A\u0003tG\u0006d\u0017-\u0003\u0002D\u0001\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001$\u0011\u0005\u001d\u0003Q\"\u0001\u001d\u0002\u001fQ\u0014XO\\2bi\u0016|eNR3uG\",\u0012A\u0013\t\u0003\u007f-K!\u0001\u0014!\u0003\u000f\t{w\u000e\\3b]\u0006\u0001BO];oG\u0006$Xm\u00148GKR\u001c\u0007\u000eI\u0001\ti>\u0004\u0018nY%egV\t\u0001\u000b\u0005\u0003R)ZsV\"\u0001*\u000b\u0005M\u0003\u0015AC2pY2,7\r^5p]&\u0011QK\u0015\u0002\u0004\u001b\u0006\u0004\bCA,]\u001b\u0005A&BA-[\u0003\u0011a\u0017M\\4\u000b\u0003m\u000bAA[1wC&\u0011Q\f\u0017\u0002\u0007'R\u0014\u0018N\\4\u0011\u0005};W\"\u00011\u000b\u0005\u0005\u0014\u0017AB2p[6|gN\u0003\u0002<G*\u0011A-Z\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\f1a\u001c:h\u0013\tA\u0007M\u0001\u0003Vk&$\u0017!\u0003;pa&\u001c\u0017\nZ:!\u0003\u001d1XM]:j_:,\u0012\u0001\u001c\t\u0003\u007f5L!A\u001c!\u0003\u000bMCwN\u001d;\u0002\u0011Y,'o]5p]\u0002\n!\u0002]1si&$\u0018n\u001c82+\u0005\u0011\bCA0t\u0013\t!\bM\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u0017A\f'\u000f^5uS>t\u0017\u0007I\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0014\u0014a\u00039beRLG/[8oe\u0001\n\u0001CZ1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0016\u0003i\u0004\"aR>\n\u0005qD$\u0001\u0005$bS2,G\rU1si&$\u0018n\u001c8t\u0003E1\u0017-\u001b7fIB\u000b'\u000f^5uS>t7\u000fI\u0001\u0014G2,\u0017M\\'fiJL7MU3hSN$(/\u001f\u000b\u0003\u0003\u0003\u00012aPA\u0002\u0013\r\t)\u0001\u0011\u0002\u0005+:LG\u000fK\u0002\u000f\u0003\u0013\u0001B!a\u0003\u0002\u001a5\u0011\u0011Q\u0002\u0006\u0005\u0003\u001f\t\t\"A\u0002ba&TA!a\u0005\u0002\u0016\u00059!.\u001e9ji\u0016\u0014(bAA\fK\u0006)!.\u001e8ji&!\u00111DA\u0007\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u0010C2dW*\u001a;sS\u000e\u001ch*Y7fgV\u0011\u0011\u0011\u0005\t\u0006#\u0006\r\u0012qE\u0005\u0004\u0003K\u0011&aA*fiB!\u0011\u0011FA\u001c\u001d\u0011\tY#a\r\u0011\u0007\u00055\u0002)\u0004\u0002\u00020)\u0019\u0011\u0011\u0007\u001f\u0002\rq\u0012xn\u001c;?\u0013\r\t)\u0004Q\u0001\u0007!J,G-\u001a4\n\u0007u\u000bIDC\u0002\u00026\u0001\u000bq!\\6CCR\u001c\u0007\u000e\u0006\u0005\u0002@\u0005-\u0013QKA0!\u0011\t\t%a\u0012\u000e\u0005\u0005\r#bAA#A\u00061!/Z2pe\u0012LA!!\u0013\u0002D\tY!+Z2pe\u0012\u0014\u0015\r^2i\u0011\u001d\ti\u0005\u0005a\u0001\u0003\u001f\n!BY1tK>3gm]3u!\ry\u0014\u0011K\u0005\u0004\u0003'\u0002%\u0001\u0002'p]\u001eDq!a\u0016\u0011\u0001\u0004\tI&A\u0006mK\u0006$WM]#q_\u000eD\u0007cA \u0002\\%\u0019\u0011Q\f!\u0003\u0007%sG\u000fC\u0004\u0002bA\u0001\r!a\u0019\u0002\u000fI,7m\u001c:egB)q(!\u001a\u0002j%\u0019\u0011q\r!\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u0005\u0003\u0002B\u0005-\u0014\u0002BA7\u0003\u0007\u0012AbU5na2,'+Z2pe\u0012\f\u0011#\u001b8ji&\fGNR3uG\"\u001cF/\u0019;f)!\t\u0019(!\u001f\u0002\u0004\u0006\u001d\u0005cA$\u0002v%\u0019\u0011q\u000f\u001d\u0003#%s\u0017\u000e^5bY\u001a+Go\u00195Ti\u0006$X\rC\u0004\u0002|E\u0001\r!! \u0002\u000fQ|\u0007/[2JIB!q(a _\u0013\r\t\t\t\u0011\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005\u0015\u0015\u00031\u0001\u0002P\u0005Ya-\u001a;dQ>3gm]3u\u0011\u001d\t9&\u0005a\u0001\u00033\nA\u0004^3ti6+GO]5dgJ+Wn\u001c<fI>s7\u000b[;uI><h\u000eK\u0002\u0013\u0003\u001b\u0003B!a\u0003\u0002\u0010&!\u0011\u0011SA\u0007\u0005\u0011!Vm\u001d;\u0002GQ,7\u000f^\"p]N,X.\u001a:MC\u001e\u0014V-\\8wK\u0012<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]\"\u001a1#!$\u0002\u001fQ,7\u000f^*j[BdWMR3uG\"D3\u0001FAG\u0003Y!Xm\u001d;FqB|g.\u001a8uS\u0006d')Y2l_\u001a4\u0007fA\u000b\u0002\u000e\u0006\u0019B/Z:u\u0007>t7\u000f^1oi\n\u000b7m[8gM\"\u001aa#!$\u0002\u0017Q,7\u000f\u001e(p\t\u0016d\u0017-\u001f\u0015\u0004/\u00055\u0015A\b;fgR\u0014\u0015mY6pM\u001a$U\r\\1z%\u0016\u001cX\r^(o'V\u001c7-Z:tQ\rA\u0012QR\u0001\ni\u0016\u001cH\u000fR3mCfD3!GAG\u0003U!Xm\u001d;QCJ$\u0018\u000e^5p]NLe.\u0012:s_JD3AGAG\u0003Q!Xm\u001d;GK:\u001cW\r\u001a+sk:\u001c\u0017\r^5p]\"\u001a1$!$\u0002\u001fQ,7\u000f\u001e$f]\u000e,GMR3uG\"D3\u0001HAG\u0003\t\"Xm\u001d;V].twn\u001e8MK\u0006$WM]#q_\u000eD\u0017J\u001c+sk:\u001c\u0017\r^5p]\"\u001aQ$!$\u0002GQ,7\u000f^+oW:|wO\u001c'fC\u0012,'/\u00129pG\"<\u0006.\u001b7f\r\u0016$8\r[5oO\"\u001aa$!$\u0002\u001dQ,7\u000f\u001e+sk:\u001c\u0017\r^5p]\"\u001aq$!$\u0002wQ,7\u000f\u001e+sk:\u001c\u0017\r^3U_\"Kw\r[,bi\u0016\u0014X.\u0019:l\u0013\u001adU-\u00193fe\u0016\u0003xn\u00195SKF,Xm\u001d;O_R\u001cV\u000f\u001d9peR,G\rK\u0002!\u0003\u001b\u000b\u0001\b^3tiR\u0013XO\\2bi\u0016$v\u000eS5hQ^\u000bG/\u001a:nCJ\\\u0017J\u001a'fC\u0012,'/\u00129pG\"LeNZ8O_R\fe/Y5mC\ndW\rK\u0002\"\u0003\u001b\u000b\u0011\u0007^3tiR\u0013XO\\2bi\u0016$v\u000eS5hQ^\u000bG/\u001a:nCJ\\G)\u001e:j]\u001e\u0014V-\\8wKB\u000b'\u000f^5uS>t7\u000fK\u0002#\u0003\u001b\u000bA\u0005^3tiR\u0013XO\\2bi&|gnU6jaB,G-\u00134O_\u0016\u0003xn\u00195DQ\u0006tw-\u001a\u0015\u0004G\u00055\u0015A\f;fgR$&/\u001e8dCRLwN\\(o\r\u0016$8\r[*lSB\u0004X\rZ%g!\u0006\u0014H/\u001b;j_:\u0014V-\\8wK\u0012D3\u0001JAG\u0003}!Xm\u001d;G_2dwn^3s\r\u0016$8\r[(vi>3'+\u00198hK\"Kw\r\u001b\u0015\u0004K\u00055\u0015a\t;fgR4u\u000e\u001c7po\u0016\u0014h)\u001a;dQ6{g/\u001a3U_RKWM]3e'R|'/\u001a\u0015\bM\u0005\r\u0018\u0011^Av!\u0011\tY!!:\n\t\u0005\u001d\u0018Q\u0002\u0002\t\t&\u001c\u0018M\u00197fI\u0006)a/\u00197vK\u0006\u0012\u0011Q^\u0001v+:$\u0018\u000e\u001c\u0011xK\u00022\u0017nZ;sK\u0002zW\u000f\u001e\u0011xQ\u0016$\b.\u001a:!i>\u0004\u0013\rZ1qi\u0002z'\u000f\t3s_B\u0004C\u000f[5tAQ,7\u000f\u001e\u0018!\u0015&\u0013\u0016I\u000f\u0011iiR\u00048OO\u00180G>tg\r\\;f]RLgn\u0019\u0018bi2\f7o]5b]:rW\r^\u0018ce><8/Z\u0018L'R{%+Q$F[IB\u0004'\u000e\u0015\u0004M\u00055\u0015a\u000b;fgR4UM\\2fI>3gm]3u%\u0016\u001cX\r^!gi\u0016\u0014Xj\u001c<fIR{'+Z7pi\u0016$\u0016.\u001a:)\u0007\u001d\ni)\u0001\u0013uKN$h)\u001a8dK\u0012|eMZ:fiJ+7/\u001a;BMR,'oT;u\u001f\u001a\u0014\u0016M\\4fQ\rA\u0013QR\u0001\u001fi\u0016\u001cHOR8mY><XM\u001d$fi\u000eDw*\u001e;PMJ\u000bgnZ3M_^D3!KAG\u0003M\"Xm\u001d;SKR\u0014\u00180\u00114uKJ,fn\u001b8po:dU-\u00193fe\u0016\u0003xn\u00195J]2\u000bG/Z:u\u001f\u001a47/\u001a;GKR\u001c\u0007\u000eK\u0002+\u0003\u001b\u000b!\u0003^3ti\u000e{'O];qi6+7o]1hK\"\u001a1&!$\u0002mQ,7\u000f\u001e'fC\u0012,'/\u00129pG\"\u001c\u0005.\u00198hK\u0012+(/\u001b8h\r\u0016t7-\u001a3GKR\u001c\u0007.\u00129pG\"\u001chI]8n\u0019\u0016\fG-\u001a:)\u00071\ni)\u0001\u001euKN$H*Z1eKJ,\u0005o\\2i\u0007\"\fgnZ3EkJLgnZ*vG\u000e,7o\u001d4vY\u001a+Go\u00195Fa>\u001c\u0007n\u001d$s_6dU-\u00193fe\"\u001aQ&!$\u0002aQ,7\u000f\u001e'fC\u0012,'/\u00129pG\"\u001c\u0005.\u00198hK\u0012+(/\u001b8h\r\u0016$8\r[#q_\u000eD7O\u0012:p[2+\u0017\rZ3s)\u0011\t\tA!\u0005\t\u000f\tMa\u00061\u0001\u0002Z\u0005\u0019B.Z1eKJ,\u0005o\\2i\u001f:dU-\u00193fe\u0006\u0019D/Z:u)J,hnY1uKR{W\t]8dQ\u0016sGm\u00144gg\u0016$8\u000fR;sS:<'+Z7pm\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004_\u00055\u0015a\u0014;fgR$&/\u001e8dCRLwN\u001c+ie><8/\u0012=dKB$\u0018n\u001c8JM2+\u0017\rZ3s%\u0016$XO\u001d8t!\u0006\u0014H/\u001b;j_:\u001chj\u001c;SKF,Xm\u001d;fI&sg)\u001a;dQ\u0016\u0003xn\u00195tQ\r\u0001\u0014QR\u00019i\u0016\u001cHOR3uG\",'\u000f\u00165sK\u0006$\u0007*\u00198eY&tw\rU1si&$\u0018n\u001c8GC&dWO]3EkJLgnZ!qa\u0016tG-\u001b8hQ\r\t\u0014QR\u0001:i\u0016\u001cHOR3uG\",'\u000f\u00165sK\u0006$\u0007*\u00198eY&tw\rU1si&$\u0018n\u001c8GC&dWO]3EkJLgn\u001a+sk:\u001c\u0017\r^5p]\"\u001a!'!$\u0002WY,'/\u001b4z\r\u0016$8\r[3s)\"\u0014X-\u00193IC:$G.\u001b8h!\u0006\u0014H/\u001b;j_:4\u0015-\u001b7ve\u0016$B!!\u0001\u0003*!9!1F\u001aA\u0002\t5\u0012a\u00024fi\u000eDWM\u001d\t\u0004\u000f\n=\u0012b\u0001B\u0019q\t\tRj\\2l\r\u0016$8\r[3s)\"\u0014X-\u00193\u0002'Q,7\u000f\u001e#jm\u0016\u0014x-\u001b8h\u000bB|7\r[:)\u0007Q\ni)\u0001\u0018uKN$HK];oG\u0006$Xm\u00148GKR\u001c\u0007\u000eR8fg:{G\u000f\u0015:pG\u0016\u001c8\u000fU1si&$\u0018n\u001c8ECR\f\u0007fA\u001b\u0002\u000e\u00069B/Z:u\u001b\u0006L(-Z+qI\u0006$X\rV8qS\u000eLEm\u001d\u0015\u0004m\u00055\u0005")
public class AbstractFetcherThreadTest {
    private final boolean truncateOnFetch;
    private final Map<String, Uuid> topicIds = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic1"), (Object)Uuid.randomUuid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic2"), (Object)Uuid.randomUuid())}));
    private final short version = ApiKeys.FETCH.latestVersion();
    private final TopicPartition kafka$server$AbstractFetcherThreadTest$$partition1 = new TopicPartition("topic1", 0);
    private final TopicPartition kafka$server$AbstractFetcherThreadTest$$partition2 = new TopicPartition("topic2", 0);
    private final FailedPartitions kafka$server$AbstractFetcherThreadTest$$failedPartitions = new FailedPartitions();

    public boolean truncateOnFetch() {
        return this.truncateOnFetch;
    }

    public Map<String, Uuid> topicIds() {
        return this.topicIds;
    }

    public short version() {
        return this.version;
    }

    public TopicPartition kafka$server$AbstractFetcherThreadTest$$partition1() {
        return this.kafka$server$AbstractFetcherThreadTest$$partition1;
    }

    public TopicPartition kafka$server$AbstractFetcherThreadTest$$partition2() {
        return this.kafka$server$AbstractFetcherThreadTest$$partition2;
    }

    public FailedPartitions kafka$server$AbstractFetcherThreadTest$$failedPartitions() {
        return this.kafka$server$AbstractFetcherThreadTest$$failedPartitions;
    }

    @BeforeEach
    public void cleanMetricRegistry() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    private Set<String> allMetricsNames() {
        return (Set)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().keySet().map((Function1 & Serializable)x$1 -> x$1.getName());
    }

    /*
     * WARNING - void declaration
     */
    private RecordBatch mkBatch(long baseOffset, int leaderEpoch, Seq<SimpleRecord> records) {
        void withRecords_records;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType withRecords_compressionType = CompressionType.NONE;
        Object var5_5 = null;
        simpleRecordArray = null;
        return (RecordBatch)CollectionConverters$.MODULE$.IterableHasAsScala(MemoryRecords.withRecords((byte)2, (long)baseOffset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)leaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records).batches()).asScala().head();
    }

    private InitialFetchState initialFetchState(Option<Uuid> topicId, long fetchOffset, int leaderEpoch) {
        BrokerEndPoint x$2 = new BrokerEndPoint(0, "localhost", 9092);
        return new InitialFetchState(topicId, x$2, leaderEpoch, fetchOffset);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMetricsRemovedOnShutdown() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$22 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$22);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), new FailedPartitions());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 0))})));
        fetcher.mockLeader().setLeaderState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.start();
        scala.collection.immutable.Set brokerTopicStatsMetrics = (scala.collection.immutable.Set)fetcher.brokerTopicStats().allTopicsStats().metricMap().keySet().$plus((Object)BrokerTopicStats$.MODULE$.LogFetchLatencyP999()).$plus((Object)BrokerTopicStats$.MODULE$.LogAppendLatencyP999()).$plus((Object)BrokerTopicStats$.MODULE$.TierLogFetchLatencyP999()).$plus((Object)BrokerTopicStats$.MODULE$.TierLogFetchLatencyP99());
        Set fetcherMetrics = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{FetcherMetrics$.MODULE$.BytesPerSec(), FetcherMetrics$.MODULE$.RequestsPerSec(), FetcherMetrics$.MODULE$.ConsumerLag()}));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractFetcherThreadTest.$anonfun$testMetricsRemovedOnShutdown$3(this, brokerTopicStatsMetrics, fetcherMetrics)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed waiting for all fetcher metrics to be registered");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        fetcher.shutdown();
        scala.collection.immutable.Set metricNames = ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().keySet().map((Function1 & Serializable)x$2 -> x$2.getName())).toSet();
        Assertions.assertTrue((boolean)metricNames.intersect(fetcherMetrics).isEmpty());
        Assertions.assertEquals((Object)brokerTopicStatsMetrics, (Object)metricNames.intersect((Set)brokerTopicStatsMetrics));
    }

    @Test
    public void testConsumerLagRemovedWithPartition() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), new FailedPartitions());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 0))})));
        fetcher.mockLeader().setLeaderState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.doWork();
        Assertions.assertTrue((boolean)this.allMetricsNames().apply((Object)FetcherMetrics$.MODULE$.ConsumerLag()), (String)"Failed waiting for consumer lag metric");
        fetcher.removePartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})));
        Assertions.assertFalse((boolean)this.allMetricsNames().apply((Object)FetcherMetrics$.MODULE$.ConsumerLag()));
    }

    @Test
    public void testSimpleFetch() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), new FailedPartitions());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 0))})));
        RecordBatch batch = this.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 0, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.doWork();
        PartitionState replicaState = fetcher.replicaPartitionState(partition);
        Assertions.assertEquals((long)2L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)2L, (long)replicaState.highWatermark());
    }

    @Test
    public void testExponentialBackoff() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(this){

            public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
                throw new UnknownTopicIdException("Topic ID was unknown as expected for this test");
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }
        };
        ExponentialBackoff customExponentialBackoff = new ExponentialBackoff(100L, 2, 1000L, 0.0);
        public class Kafka_server_AbstractFetcherThreadTest$ErrorMockFetcherThread$1
        extends MockFetcherThread {
            public Kafka_server_AbstractFetcherThreadTest$ErrorMockFetcherThread$1(AbstractFetcherThreadTest $outer, MockLeaderEndPoint mockLeaderEndpoint$1, ExponentialBackoff customExponentialBackoff$1) {
                MockTierStateMachine x$2 = new MockTierStateMachine(mockLeaderEndpoint$1, customExponentialBackoff$1);
                int x$4 = 0;
                int x$5 = 1;
                FailedPartitions x$6 = new FailedPartitions();
                super(mockLeaderEndpoint$1, x$2, x$4, x$5, customExponentialBackoff$1, x$6);
            }
        }
        Kafka_server_AbstractFetcherThreadTest$ErrorMockFetcherThread$1 fetcher = new Kafka_server_AbstractFetcherThreadTest$ErrorMockFetcherThread$1(null, mockLeaderEndpoint, customExponentialBackoff);
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)Uuid.randomUuid()), 0L, 0))})));
        RecordBatch batch = this.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 0, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            AbstractFetcherThreadTest.$anonfun$testExponentialBackoff$2(fetcher, topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        long timeBeforeFirst = System.currentTimeMillis();
        fetcher.doWork();
        long firstWorkDuration = System.currentTimeMillis() - timeBeforeFirst;
        long timeBeforeSecond = System.currentTimeMillis();
        fetcher.doWork();
        long secondWorkDuration = System.currentTimeMillis() - timeBeforeSecond;
        Assertions.assertTrue((firstWorkDuration < secondWorkDuration ? 1 : 0) != 0);
        Assertions.assertTrue((100L <= secondWorkDuration ? 1 : 0) != 0, (String)new StringBuilder(68).append("secondWorkDuration: ").append(secondWorkDuration).append(" was not greater than or equal to backOffMs: 100").toString());
        fetcher.doWork();
        fetcher.doWork();
        long timeBeforeThird = System.currentTimeMillis();
        fetcher.doWork();
        long thirdWorkDuration = System.currentTimeMillis() - timeBeforeThird;
        Assertions.assertTrue((secondWorkDuration < thirdWorkDuration ? 1 : 0) != 0);
        Assertions.assertTrue((200L <= thirdWorkDuration ? 1 : 0) != 0, (String)new StringBuilder(68).append("secondWorkDuration: ").append(thirdWorkDuration).append(" was not greater than or equal to backOffMs: 200").toString());
    }

    @Test
    public void testConstantBackoff() {
        MockLeaderEndPoint leader = new MockLeaderEndPoint(this){
            private final /* synthetic */ AbstractFetcherThreadTest $outer;

            public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
                Map<TopicPartition, FetchResponseData.PartitionData> fetchData = super.fetch(fetchRequest);
                FetchResponseData.PartitionData partition1Data = new FetchResponseData.PartitionData().setPartitionIndex(this.$outer.kafka$server$AbstractFetcherThreadTest$$partition1().partition()).setErrorCode(Errors.NOT_LEADER_OR_FOLLOWER.code());
                return (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.kafka$server$AbstractFetcherThreadTest$$partition1()), (Object)partition1Data), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.kafka$server$AbstractFetcherThreadTest$$partition2()), fetchData.get((Object)this.$outer.kafka$server$AbstractFetcherThreadTest$$partition2()).get())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }
        };
        ExponentialBackoff customExponentialBackoff = new ExponentialBackoff(100L, 2, 100L, 0.0);
        public class Kafka_server_AbstractFetcherThreadTest$ErrorMockFetcherThread$2
        extends MockFetcherThread {
            public Kafka_server_AbstractFetcherThreadTest$ErrorMockFetcherThread$2(AbstractFetcherThreadTest $outer, MockLeaderEndPoint leader$1, ExponentialBackoff customExponentialBackoff$2) {
                MockTierStateMachine x$2 = new MockTierStateMachine(leader$1, customExponentialBackoff$2);
                int x$4 = 0;
                int x$5 = 1;
                FailedPartitions x$6 = new FailedPartitions();
                super(leader$1, x$2, x$4, x$5, customExponentialBackoff$2, x$6);
            }
        }
        Kafka_server_AbstractFetcherThreadTest$ErrorMockFetcherThread$2 fetcher = new Kafka_server_AbstractFetcherThreadTest$ErrorMockFetcherThread$2(null, leader, customExponentialBackoff);
        fetcher.setReplicaState(this.kafka$server$AbstractFetcherThreadTest$$partition1(), PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$AbstractFetcherThreadTest$$partition1()), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)this.kafka$server$AbstractFetcherThreadTest$$partition1().topic()), 0L, 0))}))), true);
        RecordBatch batch = this.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())}));
        fetcher.mockLeader().setLeaderState(this.kafka$server$AbstractFetcherThreadTest$$partition1(), PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 0, 2L, false));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            AbstractFetcherThreadTest.$anonfun$testConstantBackoff$2(fetcher, topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.setReplicaState(this.kafka$server$AbstractFetcherThreadTest$$partition2(), PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$AbstractFetcherThreadTest$$partition2()), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)this.kafka$server$AbstractFetcherThreadTest$$partition2().topic()), 0L, 0))}))), true);
        fetcher.mockLeader().setLeaderState(this.kafka$server$AbstractFetcherThreadTest$$partition2(), PartitionState$.MODULE$.apply(0));
        fetcher.doWork();
        Assertions.assertEquals((long)100L, (long)((DelayedItem)((PartitionFetchState)fetcher.fetchState(this.kafka$server$AbstractFetcherThreadTest$$partition1()).get()).delay().get()).delayMs());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)((PartitionFetchState)fetcher.fetchState(this.kafka$server$AbstractFetcherThreadTest$$partition2()).get()).delay());
        Thread.sleep(100L);
        fetcher.doWork();
        Assertions.assertEquals((long)100L, (long)((DelayedItem)((PartitionFetchState)fetcher.fetchState(this.kafka$server$AbstractFetcherThreadTest$$partition1()).get()).delay().get()).delayMs());
    }

    @Test
    public void testNoDelay() {
        MockLeaderEndPoint leader = new MockLeaderEndPoint(this){
            private final /* synthetic */ AbstractFetcherThreadTest $outer;

            public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
                Map<TopicPartition, FetchResponseData.PartitionData> fetchData = super.fetch(fetchRequest);
                FetchResponseData.PartitionData partition1Data = new FetchResponseData.PartitionData().setPartitionIndex(this.$outer.kafka$server$AbstractFetcherThreadTest$$partition1().partition()).setErrorCode(Errors.NOT_LEADER_OR_FOLLOWER.code());
                return (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.kafka$server$AbstractFetcherThreadTest$$partition1()), (Object)partition1Data), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.kafka$server$AbstractFetcherThreadTest$$partition2()), fetchData.get((Object)this.$outer.kafka$server$AbstractFetcherThreadTest$$partition2()).get())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }
        };
        ExponentialBackoff customExponentialBackoff = new ExponentialBackoff(0L, 2, 0L, 0.0);
        public class Kafka_server_AbstractFetcherThreadTest$ErrorMockFetcherThread$3
        extends MockFetcherThread {
            public Kafka_server_AbstractFetcherThreadTest$ErrorMockFetcherThread$3(AbstractFetcherThreadTest $outer, MockLeaderEndPoint leader$2, ExponentialBackoff customExponentialBackoff$3) {
                MockTierStateMachine x$2 = new MockTierStateMachine(leader$2, customExponentialBackoff$3);
                int x$4 = 0;
                int x$5 = 1;
                FailedPartitions x$6 = new FailedPartitions();
                super(leader$2, x$2, x$4, x$5, customExponentialBackoff$3, x$6);
            }
        }
        Kafka_server_AbstractFetcherThreadTest$ErrorMockFetcherThread$3 fetcher = new Kafka_server_AbstractFetcherThreadTest$ErrorMockFetcherThread$3(null, leader, customExponentialBackoff);
        fetcher.setReplicaState(this.kafka$server$AbstractFetcherThreadTest$$partition1(), PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$AbstractFetcherThreadTest$$partition1()), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)this.kafka$server$AbstractFetcherThreadTest$$partition1().topic()), 0L, 0))}))), true);
        RecordBatch batch = this.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())}));
        fetcher.mockLeader().setLeaderState(this.kafka$server$AbstractFetcherThreadTest$$partition1(), PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 0, 2L, false));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            AbstractFetcherThreadTest.$anonfun$testNoDelay$2(fetcher, topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.setReplicaState(this.kafka$server$AbstractFetcherThreadTest$$partition2(), PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$AbstractFetcherThreadTest$$partition2()), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)this.kafka$server$AbstractFetcherThreadTest$$partition2().topic()), 0L, 0))}))), true);
        fetcher.mockLeader().setLeaderState(this.kafka$server$AbstractFetcherThreadTest$$partition2(), PartitionState$.MODULE$.apply(0));
        fetcher.doWork();
        Assertions.assertEquals((long)0L, (long)((DelayedItem)((PartitionFetchState)fetcher.fetchState(this.kafka$server$AbstractFetcherThreadTest$$partition1()).get()).delay().get()).delayMs());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)((PartitionFetchState)fetcher.fetchState(this.kafka$server$AbstractFetcherThreadTest$$partition2()).get()).delay());
        fetcher.doWork();
        Assertions.assertEquals((long)0L, (long)((DelayedItem)((PartitionFetchState)fetcher.fetchState(this.kafka$server$AbstractFetcherThreadTest$$partition1()).get()).delay().get()).delayMs());
    }

    @Test
    public void testBackoffDelayResetOnSuccess() {
        MockLeaderEndPoint leader = new MockLeaderEndPoint(this){
            private int attempts;
            private final /* synthetic */ AbstractFetcherThreadTest $outer;

            public int attempts() {
                return this.attempts;
            }

            public void attempts_$eq(int x$1) {
                this.attempts = x$1;
            }

            public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
                Map<TopicPartition, FetchResponseData.PartitionData> fetchData = super.fetch(fetchRequest);
                FetchResponseData.PartitionData partition1Data = new FetchResponseData.PartitionData().setPartitionIndex(this.$outer.kafka$server$AbstractFetcherThreadTest$$partition1().partition()).setErrorCode(Errors.NOT_LEADER_OR_FOLLOWER.code());
                if (this.attempts() == 2) {
                    return fetchData;
                }
                this.attempts_$eq(this.attempts() + 1);
                return (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.kafka$server$AbstractFetcherThreadTest$$partition1()), (Object)partition1Data), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.kafka$server$AbstractFetcherThreadTest$$partition2()), fetchData.get((Object)this.$outer.kafka$server$AbstractFetcherThreadTest$$partition2()).get())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
                this.attempts = 0;
            }
        };
        ExponentialBackoff customExponentialBackoff = new ExponentialBackoff(100L, 2, 1000L, 0.0);
        public class Kafka_server_AbstractFetcherThreadTest$ErrorMockFetcherThread$4
        extends MockFetcherThread {
            public Kafka_server_AbstractFetcherThreadTest$ErrorMockFetcherThread$4(AbstractFetcherThreadTest $outer, MockLeaderEndPoint leader$3, ExponentialBackoff customExponentialBackoff$4) {
                MockTierStateMachine x$2 = new MockTierStateMachine(leader$3, customExponentialBackoff$4);
                int x$4 = 0;
                int x$5 = 1;
                FailedPartitions x$6 = new FailedPartitions();
                super(leader$3, x$2, x$4, x$5, customExponentialBackoff$4, x$6);
            }
        }
        Kafka_server_AbstractFetcherThreadTest$ErrorMockFetcherThread$4 fetcher = new Kafka_server_AbstractFetcherThreadTest$ErrorMockFetcherThread$4(null, leader, customExponentialBackoff);
        fetcher.setReplicaState(this.kafka$server$AbstractFetcherThreadTest$$partition1(), PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$AbstractFetcherThreadTest$$partition1()), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)this.kafka$server$AbstractFetcherThreadTest$$partition1().topic()), 0L, 0))}))), true);
        RecordBatch batch = this.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())}));
        fetcher.mockLeader().setLeaderState(this.kafka$server$AbstractFetcherThreadTest$$partition1(), PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 0, 2L, false));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            AbstractFetcherThreadTest.$anonfun$testBackoffDelayResetOnSuccess$2(fetcher, topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.setReplicaState(this.kafka$server$AbstractFetcherThreadTest$$partition2(), PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$AbstractFetcherThreadTest$$partition2()), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)this.kafka$server$AbstractFetcherThreadTest$$partition2().topic()), 0L, 0))}))), true);
        fetcher.mockLeader().setLeaderState(this.kafka$server$AbstractFetcherThreadTest$$partition2(), PartitionState$.MODULE$.apply(0));
        fetcher.doWork();
        Assertions.assertEquals((long)100L, (long)((DelayedItem)((PartitionFetchState)fetcher.fetchState(this.kafka$server$AbstractFetcherThreadTest$$partition1()).get()).delay().get()).delayMs());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)((PartitionFetchState)fetcher.fetchState(this.kafka$server$AbstractFetcherThreadTest$$partition2()).get()).delay());
        Thread.sleep(100L);
        fetcher.doWork();
        Assertions.assertEquals((long)200L, (long)((DelayedItem)((PartitionFetchState)fetcher.fetchState(this.kafka$server$AbstractFetcherThreadTest$$partition1()).get()).delay().get()).delayMs());
        Thread.sleep(200L);
        fetcher.doWork();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)((PartitionFetchState)fetcher.fetchState(this.kafka$server$AbstractFetcherThreadTest$$partition1()).get()).delay());
    }

    @Test
    public void testDelay() {
        TopicPartition partition = new TopicPartition("topic", 0);
        int fetchBackoffMs = 250;
        MockLeaderEndPoint leader = new MockLeaderEndPoint(this){

            public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
                throw new UnknownTopicIdException("Topic ID was unknown as expected for this test");
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }
        };
        ExponentialBackoff customExponentialBackoff = new ExponentialBackoff((long)fetchBackoffMs, 2, 1000L, 0.0);
        MockTierStateMachine x$2 = new MockTierStateMachine(leader, customExponentialBackoff);
        int x$4 = 0;
        int x$5 = 1;
        FailedPartitions x$6 = new FailedPartitions();
        MockFetcherThread fetcher = new MockFetcherThread(leader, x$2, x$4, x$5, customExponentialBackoff, x$6);
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)Uuid.randomUuid()), 0L, 0))})));
        RecordBatch batch = this.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 0, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        long timeBeforeFirst = System.currentTimeMillis();
        fetcher.doWork();
        long firstWorkDuration = System.currentTimeMillis() - timeBeforeFirst;
        long timeBeforeSecond = System.currentTimeMillis();
        fetcher.doWork();
        long secondWorkDuration = System.currentTimeMillis() - timeBeforeSecond;
        Assertions.assertTrue((firstWorkDuration < secondWorkDuration ? 1 : 0) != 0);
        Assertions.assertTrue(((long)fetchBackoffMs <= secondWorkDuration ? 1 : 0) != 0, (String)new StringBuilder(70).append("secondWorkDuration: ").append(secondWorkDuration).append(" was not greater than or equal to fetchBackoffMs: ").append(fetchBackoffMs).toString());
    }

    @Test
    public void testPartitionsInError() {
        TopicPartition partition1 = new TopicPartition("topic1", 0);
        TopicPartition partition2 = new TopicPartition("topic2", 0);
        TopicPartition partition3 = new TopicPartition("topic3", 0);
        int fetchBackOffMs = 250;
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(this, partition1, partition2, partition3){
            private final TopicPartition partition1$1;
            private final TopicPartition partition2$1;
            private final TopicPartition partition3$1;

            public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
                return (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition1$1), (Object)new FetchResponseData.PartitionData().setErrorCode(Errors.UNKNOWN_TOPIC_ID.code())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition2$1), (Object)new FetchResponseData.PartitionData().setErrorCode(Errors.INCONSISTENT_TOPIC_ID.code())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition3$1), (Object)new FetchResponseData.PartitionData().setErrorCode(Errors.NONE.code()))}));
            }
            {
                this.partition1$1 = partition1$1;
                this.partition2$1 = partition2$1;
                this.partition3$1 = partition3$1;
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }
        };
        ExponentialBackoff customExponentialBackoff = new ExponentialBackoff((long)fetchBackOffMs, 2, 1000L, 0.0);
        MockTierStateMachine x$2 = new MockTierStateMachine(mockLeaderEndpoint, customExponentialBackoff);
        int x$4 = 0;
        int x$5 = 1;
        FailedPartitions x$6 = new FailedPartitions();
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, x$2, x$4, x$5, customExponentialBackoff, x$6);
        fetcher.setReplicaState(partition1, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition1), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)Uuid.randomUuid()), 0L, 0))})));
        fetcher.setReplicaState(partition2, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition2), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)Uuid.randomUuid()), 0L, 0))})));
        fetcher.setReplicaState(partition3, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition3), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)Uuid.randomUuid()), 0L, 0))})));
        RecordBatch batch = this.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 0, 2L, false);
        fetcher.mockLeader().setLeaderState(partition1, leaderState);
        fetcher.mockLeader().setLeaderState(partition2, leaderState);
        fetcher.mockLeader().setLeaderState(partition3, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.doWork();
        Option partition1FetchState = fetcher.fetchState(partition1);
        Option partition2FetchState = fetcher.fetchState(partition2);
        Option partition3FetchState = fetcher.fetchState(partition3);
        Assertions.assertTrue((boolean)partition1FetchState.isDefined());
        Assertions.assertTrue((boolean)partition2FetchState.isDefined());
        Assertions.assertTrue((boolean)partition3FetchState.isDefined());
        Assertions.assertTrue((boolean)((PartitionFetchState)partition1FetchState.get()).isDelayed());
        Assertions.assertTrue((boolean)((PartitionFetchState)partition2FetchState.get()).isDelayed());
        Assertions.assertFalse((boolean)((PartitionFetchState)partition3FetchState.get()).isDelayed());
    }

    @Test
    public void testFencedTruncation() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1(), true, ApiKeys.FETCH.latestVersion());
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
        FailedPartitions x$3 = this.kafka$server$AbstractFetcherThreadTest$$failedPartitions();
        int x$4 = 0;
        int x$5 = 1;
        ExponentialBackoff x$6 = MockFetcherThread$.MODULE$.$lessinit$greater$default$5();
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, x$4, x$5, x$6, x$3);
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 0))})));
        RecordBatch batch = this.mkBatch(0L, 1, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 1, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.doWork();
        PartitionState replicaState = fetcher.replicaPartitionState(partition);
        Assertions.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)0L, (long)replicaState.highWatermark());
        Assertions.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
        Assertions.assertTrue((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(partition));
    }

    @Test
    public void testFencedFetch() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1(), true, ApiKeys.FETCH.latestVersion());
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
        FailedPartitions x$3 = this.kafka$server$AbstractFetcherThreadTest$$failedPartitions();
        int x$4 = 0;
        int x$5 = 1;
        ExponentialBackoff x$6 = MockFetcherThread$.MODULE$.$lessinit$greater$default$5();
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, x$4, x$5, x$6, x$3);
        PartitionState replicaState = PartitionState$.MODULE$.apply(0);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 0))})));
        RecordBatch batch = this.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 0, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.doWork();
        Assertions.assertEquals((long)2L, (long)replicaState.logEndOffset());
        PartitionState partitionState = fetcher.mockLeader().leaderPartitionState(partition);
        partitionState.leaderEpoch_$eq(partitionState.leaderEpoch() + 1);
        fetcher.doWork();
        Assertions.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
        Assertions.assertTrue((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(partition));
    }

    @Test
    public void testUnknownLeaderEpochInTruncation() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$32 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$32, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), new FailedPartitions());
        PartitionState replicaState = PartitionState$.MODULE$.apply(1);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 1))}))), true);
        RecordBatch batch = this.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 0, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.doWork();
        Assertions.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((Object)new Some((Object)Truncating$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$3 -> x$3.state()));
        PartitionState partitionState = fetcher.mockLeader().leaderPartitionState(partition);
        partitionState.leaderEpoch_$eq(partitionState.leaderEpoch() + 1);
        fetcher.doWork();
        Assertions.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$4 -> x$4.state()));
    }

    @Test
    public void testUnknownLeaderEpochWhileFetching() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), new FailedPartitions());
        PartitionState replicaState = PartitionState$.MODULE$.apply(1);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 1))})));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)this.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(1L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)Nil$.MODULE$)), 1, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.doWork();
        Assertions.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$5 -> x$5.state()));
        fetcher.mockLeader().leaderPartitionState(partition).leaderEpoch_$eq(0);
        fetcher.doWork();
        Assertions.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$6 -> x$6.state()));
        fetcher.mockLeader().leaderPartitionState(partition).leaderEpoch_$eq(1);
        fetcher.doWork();
        Assertions.assertEquals((long)2L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$7 -> x$7.state()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTruncation() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), new FailedPartitions());
        .colon.colon replicaLog = new .colon.colon((Object)this.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, 0L, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, 5))})));
        .colon.colon leaderLog = new .colon.colon((Object)this.mkBatch(0L, 1, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(1L, 3, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(2L, 5, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 5, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractFetcherThreadTest.$anonfun$testTruncation$3(fetcher, partition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to reconcile leader and follower logs");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)leaderState.logStartOffset(), (long)replicaState.logStartOffset());
        Assertions.assertEquals((long)leaderState.logEndOffset(), (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)leaderState.highWatermark(), (long)replicaState.highWatermark());
    }

    @Test
    public void testTruncateToHighWatermarkIfLeaderEpochRequestNotSupported() {
        long highWatermark = 2L;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockLeaderEndPoint mockLeaderEndPoint = new MockLeaderEndPoint(this){
            private final boolean isTruncationOnFetchSupported;

            public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
                throw new UnsupportedOperationException();
            }

            public boolean isTruncationOnFetchSupported() {
                return this.isTruncationOnFetchSupported;
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
                this.isTruncationOnFetchSupported = false;
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndPoint, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
        MockFetcherThread fetcher = new MockFetcherThread(null, mockLeaderEndPoint, mockTierStateMachine, highWatermark){
            private final boolean isOffsetForLeaderEpochSupported;
            private final long highWatermark$1;

            public boolean truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                Assertions.assertEquals((long)this.highWatermark$1, (long)truncationState.offset());
                Assertions.assertTrue((boolean)truncationState.truncationCompleted());
                return super.truncate(topicPartition, truncationState);
            }

            public boolean isOffsetForLeaderEpochSupported() {
                return this.isOffsetForLeaderEpochSupported;
            }
            {
                this.highWatermark$1 = highWatermark$1;
                super(mockLeaderEndPoint$1, mockTierStateMachine$1, 0, 1, MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), new FailedPartitions());
                this.isOffsetForLeaderEpochSupported = false;
            }
        };
        .colon.colon replicaLog = new .colon.colon((Object)this.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, highWatermark, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), highWatermark, 5))})));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.doWork();
        Assertions.assertEquals((long)highWatermark, (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)highWatermark, (long)((PartitionFetchState)fetcher.fetchState(partition).get()).fetchOffset());
        Assertions.assertTrue((boolean)((PartitionFetchState)fetcher.fetchState(partition).get()).isReadyForFetch());
    }

    @Test
    public void testTruncateToHighWatermarkIfLeaderEpochInfoNotAvailable() {
        long highWatermark = 2L;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockLeaderEndPoint mockLeaderEndPoint = new MockLeaderEndPoint(this){

            public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
                throw new UnsupportedOperationException();
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndPoint, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
        MockFetcherThread fetcher = new MockFetcherThread(null, mockLeaderEndPoint, mockTierStateMachine, highWatermark){
            private final long highWatermark$2;

            public boolean truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                Assertions.assertEquals((long)this.highWatermark$2, (long)truncationState.offset());
                Assertions.assertTrue((boolean)truncationState.truncationCompleted());
                return super.truncate(topicPartition, truncationState);
            }

            public Option<Object> latestEpoch(TopicPartition topicPartition) {
                return None$.MODULE$;
            }
            {
                this.highWatermark$2 = highWatermark$2;
                super(mockLeaderEndPoint$2, mockTierStateMachine$2, 0, 1, MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), new FailedPartitions());
            }
        };
        .colon.colon replicaLog = new .colon.colon((Object)this.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, highWatermark, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), highWatermark, 5))})));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.doWork();
        Assertions.assertEquals((long)highWatermark, (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)highWatermark, (long)((PartitionFetchState)fetcher.fetchState(partition).get()).fetchOffset());
        Assertions.assertTrue((boolean)((PartitionFetchState)fetcher.fetchState(partition).get()).isReadyForFetch());
    }

    @Test
    public void testTruncateToHighWatermarkDuringRemovePartitions() {
        long highWatermark = 2L;
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
        MockFetcherThread fetcher = new MockFetcherThread(null, mockLeaderEndpoint, mockTierStateMachine, partition){
            private final TopicPartition partition$2;

            public void truncateToHighWatermark(Set<TopicPartition> partitions) {
                this.removePartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition$2})));
                super.truncateToHighWatermark(partitions);
            }

            public Option<Object> latestEpoch(TopicPartition topicPartition) {
                return None$.MODULE$;
            }
            {
                this.partition$2 = partition$2;
                super(mockLeaderEndpoint$2, mockTierStateMachine$3, 0, 1, MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), new FailedPartitions());
            }
        };
        .colon.colon replicaLog = new .colon.colon((Object)this.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, highWatermark, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), highWatermark, 5))})));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.doWork();
        Assertions.assertEquals((long)((RecordBatch)replicaLog.last()).nextOffset(), (long)replicaState.logEndOffset());
        Assertions.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
    }

    @Test
    public void testTruncationSkippedIfNoEpochChange() {
        TopicPartition partition = new TopicPartition("topic", 0);
        IntRef truncations = IntRef.create((int)0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
        MockFetcherThread fetcher = new MockFetcherThread(null, mockLeaderEndpoint, mockTierStateMachine, truncations){
            private final IntRef truncations$1;

            public boolean truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                ++this.truncations$1.elem;
                return super.truncate(topicPartition, truncationState);
            }
            {
                this.truncations$1 = truncations$1;
                super(mockLeaderEndpoint$3, mockTierStateMachine$4, 0, 1, MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), new FailedPartitions());
            }
        };
        PartitionState replicaState = PartitionState$.MODULE$.apply(5);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 5))}))), true);
        .colon.colon leaderLog = new .colon.colon((Object)this.mkBatch(0L, 1, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(1L, 3, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(2L, 5, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 5, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.doWork();
        Assertions.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((int)1, (int)truncations.elem);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, 5))})));
        fetcher.doWork();
        Assertions.assertEquals((int)1, (int)truncations.elem);
        Assertions.assertEquals((long)2L, (long)replicaState.logEndOffset());
    }

    @Test
    public void testTruncationOnFetchSkippedIfPartitionRemoved() {
        Assumptions.assumeTrue((boolean)this.truncateOnFetch());
        TopicPartition partition = new TopicPartition("topic", 0);
        IntRef truncations = IntRef.create((int)0);
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1(), true, ApiKeys.FETCH.latestVersion());
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
        MockFetcherThread fetcher = new MockFetcherThread(null, mockLeaderEndpoint, mockTierStateMachine, truncations){
            private final IntRef truncations$2;

            public boolean truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                ++this.truncations$2.elem;
                return super.truncate(topicPartition, truncationState);
            }
            {
                this.truncations$2 = truncations$2;
                super(mockLeaderEndpoint$4, mockTierStateMachine$5, 0, 1, MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), new FailedPartitions());
            }
        };
        .colon.colon replicaLog = new .colon.colon((Object)this.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, 2L, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)Uuid.randomUuid()), 6L, 4))})));
        OffsetForLeaderEpochResponseData.EpochEndOffset endOffset = new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partition.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(4).setEndOffset(3L);
        fetcher.truncateOnFetchResponse((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)endOffset)})));
        Assertions.assertEquals((int)1, (int)truncations.elem);
        Map offsets = fetcher.removePartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})));
        Assertions.assertEquals((Object)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})), (Object)offsets.keySet());
        Assertions.assertEquals((long)3L, (long)((PartitionFetchState)offsets.apply((Object)partition)).fetchOffset());
        OffsetForLeaderEpochResponseData.EpochEndOffset newEndOffset = new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partition.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(4).setEndOffset(2L);
        fetcher.truncateOnFetchResponse((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)newEndOffset)})));
        Assertions.assertEquals((int)1, (int)truncations.elem);
    }

    @Test
    public void testFollowerFetchOutOfRangeHigh() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), new FailedPartitions());
        .colon.colon replicaLog = new .colon.colon((Object)this.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 4, 0L, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, 4))})));
        .colon.colon leaderLog = new .colon.colon((Object)this.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 4, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.doWork();
        Assertions.assertEquals((long)3L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$8 -> x$8.state()));
        leaderState.log().clear();
        leaderState.logEndOffset_$eq(0L);
        leaderState.logStartOffset_$eq(0L);
        leaderState.highWatermark_$eq(0L);
        fetcher.doWork();
        Assertions.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)0L, (long)replicaState.logStartOffset());
        Assertions.assertEquals((long)0L, (long)replicaState.highWatermark());
    }

    @Test
    @Disabled(value="Until we figure out whether to adapt or drop this test. JIRA: https://confluentinc.atlassian.net/browse/KSTORAGE-2805")
    public void testFollowerFetchMovedToTieredStore() {
        TopicPartition partition = new TopicPartition("topic", 0);
        .colon.colon replicaLog = new .colon.colon((Object)this.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, 0L, true);
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1(), true, ApiKeys.FETCH.latestVersion());
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), new FailedPartitions());
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, 5))})));
        .colon.colon leaderLog = new .colon.colon((Object)this.mkBatch(5L, 5, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("f".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(6L, 5, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("g".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(7L, 5, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("h".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(8L, 5, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("i".getBytes())})), (List)Nil$.MODULE$))));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 5, 8L, true);
        leaderState.logStartOffset_$eq(0L);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        Assertions.assertEquals((long)3L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((Object)(this.truncateOnFetch() ? Option$.MODULE$.apply((Object)Fetching$.MODULE$) : Option$.MODULE$.apply((Object)Truncating$.MODULE$)), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$9 -> x$9.state()));
        fetcher.doWork();
        Assertions.assertEquals((long)0L, (long)replicaState.logStartOffset());
        Assertions.assertEquals((long)5L, (long)replicaState.localLogStartOffset());
        Assertions.assertEquals((long)5L, (long)replicaState.highWatermark());
        Assertions.assertEquals((long)5L, (long)replicaState.logEndOffset());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$10 -> fetcher.doWork());
        Assertions.assertEquals((int)4, (int)replicaState.log().size());
        Assertions.assertEquals((long)0L, (long)replicaState.logStartOffset());
        Assertions.assertEquals((long)5L, (long)replicaState.localLogStartOffset());
        Assertions.assertEquals((long)8L, (long)replicaState.highWatermark());
        Assertions.assertEquals((long)9L, (long)replicaState.logEndOffset());
    }

    @Test
    public void testFencedOffsetResetAfterMovedToRemoteTier() {
        TopicPartition partition = new TopicPartition("topic", 0);
        BooleanRef isErrorHandled = BooleanRef.create((boolean)false);
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1(), true, ApiKeys.FETCH.latestVersion());
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(null, mockLeaderEndpoint, isErrorHandled){
            private final BooleanRef isErrorHandled$1;

            public PartitionFetchState start(TopicPartition topicPartition, PartitionFetchState currentFetchState, FetchResponseData.PartitionData fetchPartitionData) {
                this.isErrorHandled$1.elem = true;
                throw new FencedLeaderEpochException(new StringBuilder(16).append("Epoch ").append(currentFetchState.currentLeaderEpoch()).append(" is fenced").toString());
            }
            {
                this.isErrorHandled$1 = isErrorHandled$1;
                super(mockLeaderEndpoint$5, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
            }
        };
        FailedPartitions x$3 = this.kafka$server$AbstractFetcherThreadTest$$failedPartitions();
        int x$4 = 0;
        int x$5 = 1;
        ExponentialBackoff x$6 = MockFetcherThread$.MODULE$.$lessinit$greater$default$5();
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, x$4, x$5, x$6, x$3);
        .colon.colon replicaLog = new .colon.colon((Object)this.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, 2L, true);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 5))})));
        .colon.colon leaderLog = new .colon.colon((Object)this.mkBatch(5L, 5, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(6L, 5, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 5, 6L, true);
        leaderState.logStartOffset_$eq(0L);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((long)3L, (long)replicaState.logEndOffset());
        Assertions.assertTrue((boolean)isErrorHandled.elem);
        Assertions.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
        Assertions.assertTrue((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(partition));
    }

    @Test
    public void testFencedOffsetResetAfterOutOfRange() {
        TopicPartition partition = new TopicPartition("topic", 0);
        BooleanRef fetchedEarliestOffset = BooleanRef.create((boolean)false);
        MockLeaderEndPoint leader = new MockLeaderEndPoint(this, fetchedEarliestOffset){
            private final BooleanRef fetchedEarliestOffset$1;

            public OffsetAndEpoch fetchEarliestOffset(TopicPartition topicPartition, int leaderEpoch) {
                this.fetchedEarliestOffset$1.elem = true;
                throw new FencedLeaderEpochException(new StringBuilder(16).append("Epoch ").append(leaderEpoch).append(" is fenced").toString());
            }

            public OffsetAndEpoch fetchEarliestLocalOffset(TopicPartition topicPartition, int leaderEpoch) {
                this.fetchedEarliestOffset$1.elem = true;
                throw new FencedLeaderEpochException(new StringBuilder(16).append("Epoch ").append(leaderEpoch).append(" is fenced").toString());
            }
            {
                this.fetchedEarliestOffset$1 = fetchedEarliestOffset$1;
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }
        };
        MockTierStateMachine x$2 = new MockTierStateMachine(leader, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
        FailedPartitions x$3 = this.kafka$server$AbstractFetcherThreadTest$$failedPartitions();
        int x$4 = 0;
        int x$5 = 1;
        ExponentialBackoff x$6 = MockFetcherThread$.MODULE$.$lessinit$greater$default$5();
        MockFetcherThread fetcher = new MockFetcherThread(leader, x$2, x$4, x$5, x$6, x$3);
        Nil$ replicaLog = Nil$.MODULE$;
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 4, 0L, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 4))})));
        .colon.colon leaderLog = new .colon.colon((Object)this.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 4, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.doWork();
        Assertions.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assertions.assertTrue((boolean)fetchedEarliestOffset.elem);
        Assertions.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
        Assertions.assertTrue((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(partition));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFollowerFetchOutOfRangeLow() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), new FailedPartitions());
        .colon.colon replicaLog = new .colon.colon((Object)this.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)Nil$.MODULE$);
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 0, 0L, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, 0))})));
        .colon.colon leaderLog = new .colon.colon((Object)this.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$);
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 0, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.doWork();
        if (this.truncateOnFetch()) {
            fetcher.doWork();
        }
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$11 -> x$11.state()));
        Assertions.assertEquals((long)2L, (long)replicaState.logStartOffset());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)replicaState.log().toList());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractFetcherThreadTest.$anonfun$testFollowerFetchOutOfRangeLow$4(fetcher, partition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to reconcile leader and follower logs");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)leaderState.logStartOffset(), (long)replicaState.logStartOffset());
        Assertions.assertEquals((long)leaderState.logEndOffset(), (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)leaderState.highWatermark(), (long)replicaState.highWatermark());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRetryAfterUnknownLeaderEpochInLatestOffsetFetch() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockLeaderEndPoint mockLeaderEndPoint = new MockLeaderEndPoint(this){
            private final AtomicInteger tries;

            public AtomicInteger tries() {
                return this.tries;
            }

            public OffsetAndEpoch fetchLatestOffset(TopicPartition topicPartition, int leaderEpoch) {
                if (this.tries().getAndIncrement() == 0) {
                    throw new UnknownLeaderEpochException("Unexpected leader epoch");
                }
                return super.fetchLatestOffset(topicPartition, leaderEpoch);
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
                this.tries = new AtomicInteger(0);
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndPoint, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndPoint, mockTierStateMachine, 0, 1, MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), new FailedPartitions());
        .colon.colon replicaLog = new .colon.colon((Object)this.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)Nil$.MODULE$);
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 0, 0L, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, 0))})));
        .colon.colon leaderLog = new .colon.colon((Object)this.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$);
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 0, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.doWork();
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$12 -> x$12.state()));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractFetcherThreadTest.$anonfun$testRetryAfterUnknownLeaderEpochInLatestOffsetFetch$4(fetcher, partition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to reconcile leader and follower logs");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)leaderState.logStartOffset(), (long)replicaState.logStartOffset());
        Assertions.assertEquals((long)leaderState.logEndOffset(), (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)leaderState.highWatermark(), (long)replicaState.highWatermark());
    }

    @Test
    public void testCorruptMessage() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockLeaderEndPoint mockLeaderEndPoint = new MockLeaderEndPoint(this){
            private boolean fetchedOnce;

            public boolean fetchedOnce() {
                return this.fetchedOnce;
            }

            public void fetchedOnce_$eq(boolean x$1) {
                this.fetchedOnce = x$1;
            }

            public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
                Map<TopicPartition, FetchResponseData.PartitionData> fetchedData = super.fetch(fetchRequest);
                if (!this.fetchedOnce()) {
                    ByteBuffer buffer = ((MemoryRecords)((FetchResponseData.PartitionData)((Tuple2)fetchedData.head())._2()).records()).buffer();
                    buffer.putInt(15, buffer.getInt(15) ^ 0x5B7E);
                    buffer.putInt(30, buffer.getInt(30) ^ 0x16C3A);
                    this.fetchedOnce_$eq(true);
                }
                return fetchedData;
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
                this.fetchedOnce = false;
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndPoint, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndPoint, mockTierStateMachine, 0, 1, MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), new FailedPartitions());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 0))})));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        RecordBatch batch = this.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 0, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        fetcher.doWork();
        PartitionState replicaState = fetcher.replicaPartitionState(partition);
        Assertions.assertEquals((long)2L, (long)replicaState.logEndOffset());
    }

    @Test
    public void testLeaderEpochChangeDuringFencedFetchEpochsFromLeader() {
        this.testLeaderEpochChangeDuringFetchEpochsFromLeader(1);
    }

    @Test
    public void testLeaderEpochChangeDuringSuccessfulFetchEpochsFromLeader() {
        this.testLeaderEpochChangeDuringFetchEpochsFromLeader(0);
    }

    private void testLeaderEpochChangeDuringFetchEpochsFromLeader(int leaderEpochOnLeader) {
        TopicPartition partition = new TopicPartition("topic", 1);
        int initialLeaderEpochOnFollower = 0;
        int nextLeaderEpochOnFollower = initialLeaderEpochOnFollower + 1;
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(this){
            private boolean fetchEpochsFromLeaderOnce;

            public boolean fetchEpochsFromLeaderOnce() {
                return this.fetchEpochsFromLeaderOnce;
            }

            public void fetchEpochsFromLeaderOnce_$eq(boolean x$1) {
                this.fetchEpochsFromLeaderOnce = x$1;
            }

            public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
                Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchedEpochs = super.fetchEpochEndOffsets(partitions);
                if (!this.fetchEpochsFromLeaderOnce()) {
                    this.responseCallback().apply$mcV$sp();
                    this.fetchEpochsFromLeaderOnce_$eq(true);
                }
                return fetchedEpochs;
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
                this.fetchEpochsFromLeaderOnce = false;
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), new FailedPartitions());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(initialLeaderEpochOnFollower));
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, initialLeaderEpochOnFollower))}))), true);
        .colon.colon leaderLog = new .colon.colon((Object)this.mkBatch(0L, initialLeaderEpochOnFollower, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$);
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, leaderEpochOnLeader, 0L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setResponseCallback((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.changeLeaderEpochWhileFetchEpoch$1(fetcher, partition, nextLeaderEpochOnFollower));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.doWork();
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Truncating$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$13 -> x$13.state()));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)nextLeaderEpochOnFollower)), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.currentLeaderEpoch())));
        if (leaderEpochOnLeader < nextLeaderEpochOnFollower) {
            fetcher.mockLeader().setLeaderState(partition, PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, nextLeaderEpochOnFollower, 0L, false));
        }
        fetcher.doWork();
        Assertions.assertEquals(fetcher.mockLeader().leaderPartitionState(partition).log(), fetcher.replicaPartitionState(partition).log());
    }

    @Test
    public void testTruncateToEpochEndOffsetsDuringRemovePartitions() {
        TopicPartition partition = new TopicPartition("topic", 0);
        int leaderEpochOnLeader = 0;
        int initialLeaderEpochOnFollower = 0;
        int nextLeaderEpochOnFollower = initialLeaderEpochOnFollower + 1;
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(this){

            public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
                Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchedEpochs = super.fetchEpochEndOffsets(partitions);
                this.responseCallback().apply$mcV$sp();
                return fetchedEpochs;
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), new FailedPartitions());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(initialLeaderEpochOnFollower));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, initialLeaderEpochOnFollower))})));
        .colon.colon leaderLog = new .colon.colon((Object)this.mkBatch(0L, initialLeaderEpochOnFollower, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$);
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, leaderEpochOnLeader, 0L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setResponseCallback((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> AbstractFetcherThreadTest.changeLeaderEpochDuringFetchEpoch$1(fetcher, partition, nextLeaderEpochOnFollower));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.doWork();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$15 -> x$15.state()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToInteger((int)x$16.currentLeaderEpoch())));
        fetcher.mockLeader().setLeaderState(partition, PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, nextLeaderEpochOnFollower, 0L, false));
        fetcher.doWork();
        Assertions.assertEquals((Object)ArrayBuffer$.MODULE$.empty(), fetcher.replicaPartitionState(partition).log());
    }

    @Test
    public void testTruncationThrowsExceptionIfLeaderReturnsPartitionsNotRequestedInFetchEpochs() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockLeaderEndPoint mockLeaderEndPoint = new MockLeaderEndPoint(this){

            public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
                TopicPartition unrequestedTp = new TopicPartition("topic2", 0);
                return (Map)super.fetchEpochEndOffsets(partitions).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unrequestedTp), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(unrequestedTp.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(0).setEndOffset(0L)));
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndPoint, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndPoint, mockTierStateMachine, 0, 1, MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), new FailedPartitions());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 0))}))), true);
        fetcher.mockLeader().setLeaderState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        Assertions.assertThrows(IllegalStateException.class, () -> fetcher.doWork());
    }

    @Test
    public void testFetcherThreadHandlingPartitionFailureDuringAppending() {
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
        MockFetcherThread fetcherForAppend = new MockFetcherThread(this, mockLeaderEndpoint, mockTierStateMachine){
            private final /* synthetic */ AbstractFetcherThreadTest $outer;

            public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
                TopicPartition topicPartition2 = topicPartition;
                TopicPartition topicPartition3 = this.$outer.kafka$server$AbstractFetcherThreadTest$$partition1();
                if (!(topicPartition2 != null ? !topicPartition2.equals(topicPartition3) : topicPartition3 != null)) {
                    throw new KafkaException();
                }
                return super.processPartitionData(topicPartition, fetchOffset, partitionData);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                FailedPartitions x$3 = $outer.kafka$server$AbstractFetcherThreadTest$$failedPartitions();
                int x$4 = 0;
                int x$5 = 1;
                ExponentialBackoff x$6 = MockFetcherThread$.MODULE$.$lessinit$greater$default$5();
                super(mockLeaderEndpoint$6, mockTierStateMachine$6, x$4, x$5, x$6, x$3);
            }
        };
        this.verifyFetcherThreadHandlingPartitionFailure(fetcherForAppend);
    }

    @Test
    public void testFetcherThreadHandlingPartitionFailureDuringTruncation() {
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
        MockFetcherThread fetcherForTruncation = new MockFetcherThread(this, mockLeaderEndpoint, mockTierStateMachine){
            private final /* synthetic */ AbstractFetcherThreadTest $outer;

            public boolean truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                TopicPartition topicPartition2 = topicPartition;
                TopicPartition topicPartition3 = this.$outer.kafka$server$AbstractFetcherThreadTest$$partition1();
                if (!(topicPartition2 != null ? !topicPartition2.equals(topicPartition3) : topicPartition3 != null)) {
                    throw new Exception();
                }
                return super.truncate(topicPartition, truncationState);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                FailedPartitions x$3 = $outer.kafka$server$AbstractFetcherThreadTest$$failedPartitions();
                int x$4 = 0;
                int x$5 = 1;
                ExponentialBackoff x$6 = MockFetcherThread$.MODULE$.$lessinit$greater$default$5();
                super(mockLeaderEndpoint$7, mockTierStateMachine$7, x$4, x$5, x$6, x$3);
            }
        };
        this.verifyFetcherThreadHandlingPartitionFailure(fetcherForTruncation);
    }

    private void verifyFetcherThreadHandlingPartitionFailure(MockFetcherThread fetcher) {
        fetcher.setReplicaState(this.kafka$server$AbstractFetcherThreadTest$$partition1(), PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$AbstractFetcherThreadTest$$partition1()), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)this.kafka$server$AbstractFetcherThreadTest$$partition1().topic()), 0L, 0))}))), true);
        fetcher.mockLeader().setLeaderState(this.kafka$server$AbstractFetcherThreadTest$$partition1(), PartitionState$.MODULE$.apply(0));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.setReplicaState(this.kafka$server$AbstractFetcherThreadTest$$partition2(), PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$AbstractFetcherThreadTest$$partition2()), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)this.kafka$server$AbstractFetcherThreadTest$$partition2().topic()), 0L, 0))}))), true);
        fetcher.mockLeader().setLeaderState(this.kafka$server$AbstractFetcherThreadTest$$partition2(), PartitionState$.MODULE$.apply(0));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertTrue((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(this.kafka$server$AbstractFetcherThreadTest$$partition1()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)fetcher.fetchState(this.kafka$server$AbstractFetcherThreadTest$$partition1()));
        fetcher.doWork();
        Assertions.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(this.kafka$server$AbstractFetcherThreadTest$$partition2()).map((Function1 & Serializable)x$17 -> x$17.state()));
        Assertions.assertFalse((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(this.kafka$server$AbstractFetcherThreadTest$$partition2()));
        fetcher.removePartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.kafka$server$AbstractFetcherThreadTest$$partition1()})));
        this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().removeAll((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.kafka$server$AbstractFetcherThreadTest$$partition1()})));
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$AbstractFetcherThreadTest$$partition1()), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)this.kafka$server$AbstractFetcherThreadTest$$partition1().topic()), 0L, 1))}))), true);
        Assertions.assertEquals((Object)new Some((Object)Truncating$.MODULE$), (Object)fetcher.fetchState(this.kafka$server$AbstractFetcherThreadTest$$partition1()).map((Function1 & Serializable)x$18 -> x$18.state()));
        Assertions.assertFalse((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(this.kafka$server$AbstractFetcherThreadTest$$partition1()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDivergingEpochs() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), new FailedPartitions());
        .colon.colon replicaLog = new .colon.colon((Object)this.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, 0L, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, 5))})));
        Assertions.assertEquals((long)3L, (long)replicaState.logEndOffset());
        fetcher.verifyLastFetchedEpoch(partition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)4)));
        .colon.colon leaderLog = new .colon.colon((Object)this.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(2L, 5, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("d".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 5, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.doWork();
        fetcher.verifyLastFetchedEpoch(partition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractFetcherThreadTest.$anonfun$testDivergingEpochs$3(fetcher, partition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to reconcile leader and follower logs");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        fetcher.verifyLastFetchedEpoch(partition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTruncateOnFetchDoesNotProcessPartitionData() {
        Assumptions.assumeTrue((boolean)this.truncateOnFetch());
        TopicPartition partition = new TopicPartition("topic", 0);
        IntRef truncateCalls = IntRef.create((int)0);
        IntRef processPartitionDataCalls = IntRef.create((int)0);
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1(), true, ApiKeys.FETCH.latestVersion());
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
        MockFetcherThread fetcher = new MockFetcherThread(null, mockLeaderEndpoint, mockTierStateMachine, processPartitionDataCalls, truncateCalls){
            private final IntRef processPartitionDataCalls$1;
            private final IntRef truncateCalls$1;

            public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
                ++this.processPartitionDataCalls$1.elem;
                return super.processPartitionData(topicPartition, fetchOffset, partitionData);
            }

            public boolean truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                ++this.truncateCalls$1.elem;
                return super.truncate(topicPartition, truncationState);
            }
            {
                this.processPartitionDataCalls$1 = processPartitionDataCalls$1;
                this.truncateCalls$1 = truncateCalls$1;
                super(mockLeaderEndpoint$8, mockTierStateMachine$8, 0, 1, MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), new FailedPartitions());
            }
        };
        .colon.colon replicaLog = new .colon.colon((Object)this.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(1L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(2L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(3L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("d".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(4L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("e".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(5L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("f".getBytes())})), (List)Nil$.MODULE$))))));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, 1L, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, 5))})));
        Assertions.assertEquals((long)6L, (long)replicaState.logEndOffset());
        fetcher.verifyLastFetchedEpoch(partition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)4)));
        .colon.colon leaderLog = new .colon.colon((Object)this.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(1L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(2L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(3L, 5, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("g".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(4L, 5, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("h".getBytes())})), (List)Nil$.MODULE$)))));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 5, 4L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((int)1, (int)truncateCalls.elem);
        Assertions.assertEquals((int)0, (int)processPartitionDataCalls.elem);
        Assertions.assertEquals((long)3L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)1L, (long)replicaState.highWatermark());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractFetcherThreadTest.$anonfun$testTruncateOnFetchDoesNotProcessPartitionData$2(fetcher, partition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to reconcile leader and follower logs");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        fetcher.verifyLastFetchedEpoch(partition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Assertions.assertEquals((int)1, (int)truncateCalls.elem);
        Assertions.assertTrue((processPartitionDataCalls.elem >= 1 ? 1 : 0) != 0);
        Assertions.assertEquals((long)5L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)4L, (long)replicaState.highWatermark());
    }

    @Test
    public void testMaybeUpdateTopicIds() {
        TopicPartition partition = new TopicPartition("topic1", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), new FailedPartitions());
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)None$.MODULE$, 0L, 0))})));
        AbstractFetcherThreadTest.verifyFetchState$1(fetcher.fetchState(partition), (Option)None$.MODULE$);
        fetcher.maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})), (Function1 & Serializable)topicName -> this.topicIds().get(topicName));
        AbstractFetcherThreadTest.verifyFetchState$1(fetcher.fetchState(partition), this.topicIds().get((Object)partition.topic()));
        TopicPartition unknownPartition = new TopicPartition("unknown", 0);
        fetcher.maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition})), (Function1 & Serializable)topicName -> this.topicIds().get(topicName));
        Assertions.assertTrue((boolean)fetcher.fetchState(unknownPartition).isEmpty());
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsRemovedOnShutdown$3(AbstractFetcherThreadTest $this, scala.collection.immutable.Set brokerTopicStatsMetrics$1, Set fetcherMetrics$1) {
        Set<String> set = $this.allMetricsNames();
        SetOps setOps = brokerTopicStatsMetrics$1.$plus$plus((IterableOnce)fetcherMetrics$1);
        return !(set != null ? !set.equals((Object)setOps) : setOps != null);
    }

    public static final /* synthetic */ String $anonfun$testMetricsRemovedOnShutdown$4() {
        return "Failed waiting for all fetcher metrics to be registered";
    }

    public static final /* synthetic */ void $anonfun$testExponentialBackoff$2(ErrorMockFetcherThread.1 fetcher$4, TopicPartition topicPartition, long proposedLocalLogStart) {
        fetcher$4.restoreTierState(topicPartition, proposedLocalLogStart);
    }

    public static final /* synthetic */ void $anonfun$testConstantBackoff$2(ErrorMockFetcherThread.2 fetcher$5, TopicPartition topicPartition, long proposedLocalLogStart) {
        fetcher$5.restoreTierState(topicPartition, proposedLocalLogStart);
    }

    public static final /* synthetic */ void $anonfun$testNoDelay$2(ErrorMockFetcherThread.3 fetcher$6, TopicPartition topicPartition, long proposedLocalLogStart) {
        fetcher$6.restoreTierState(topicPartition, proposedLocalLogStart);
    }

    public static final /* synthetic */ void $anonfun$testBackoffDelayResetOnSuccess$2(ErrorMockFetcherThread.4 fetcher$7, TopicPartition topicPartition, long proposedLocalLogStart) {
        fetcher$7.restoreTierState(topicPartition, proposedLocalLogStart);
    }

    public static final /* synthetic */ boolean $anonfun$testTruncation$3(MockFetcherThread fetcher$14, TopicPartition partition$1) {
        fetcher$14.doWork();
        Buffer<RecordBatch> buffer = fetcher$14.replicaPartitionState(partition$1).log();
        Buffer<RecordBatch> buffer2 = fetcher$14.mockLeader().leaderPartitionState(partition$1).log();
        return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
    }

    public static final /* synthetic */ String $anonfun$testTruncation$4() {
        return "Failed to reconcile leader and follower logs";
    }

    public static final /* synthetic */ boolean $anonfun$testFollowerFetchOutOfRangeLow$4(MockFetcherThread fetcher$24, TopicPartition partition$3) {
        fetcher$24.doWork();
        Buffer<RecordBatch> buffer = fetcher$24.replicaPartitionState(partition$3).log();
        Buffer<RecordBatch> buffer2 = fetcher$24.mockLeader().leaderPartitionState(partition$3).log();
        return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
    }

    public static final /* synthetic */ String $anonfun$testFollowerFetchOutOfRangeLow$5() {
        return "Failed to reconcile leader and follower logs";
    }

    public static final /* synthetic */ boolean $anonfun$testRetryAfterUnknownLeaderEpochInLatestOffsetFetch$4(MockFetcherThread fetcher$25, TopicPartition partition$4) {
        fetcher$25.doWork();
        Buffer<RecordBatch> buffer = fetcher$25.replicaPartitionState(partition$4).log();
        Buffer<RecordBatch> buffer2 = fetcher$25.mockLeader().leaderPartitionState(partition$4).log();
        return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
    }

    public static final /* synthetic */ String $anonfun$testRetryAfterUnknownLeaderEpochInLatestOffsetFetch$5() {
        return "Failed to reconcile leader and follower logs";
    }

    private final void changeLeaderEpochWhileFetchEpoch$1(MockFetcherThread fetcher$27, TopicPartition partition$5, int nextLeaderEpochOnFollower$1) {
        fetcher$27.removePartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition$5})));
        fetcher$27.setReplicaState(partition$5, PartitionState$.MODULE$.apply(nextLeaderEpochOnFollower$1));
        fetcher$27.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition$5), (Object)this.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition$5.topic()), 0L, nextLeaderEpochOnFollower$1))}))), true);
    }

    private static final void changeLeaderEpochDuringFetchEpoch$1(MockFetcherThread fetcher$28, TopicPartition partition$6, int nextLeaderEpochOnFollower$2) {
        fetcher$28.removePartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition$6})));
        fetcher$28.setReplicaState(partition$6, PartitionState$.MODULE$.apply(nextLeaderEpochOnFollower$2));
    }

    public static final /* synthetic */ boolean $anonfun$testDivergingEpochs$3(MockFetcherThread fetcher$31, TopicPartition partition$7) {
        fetcher$31.doWork();
        Buffer<RecordBatch> buffer = fetcher$31.replicaPartitionState(partition$7).log();
        Buffer<RecordBatch> buffer2 = fetcher$31.mockLeader().leaderPartitionState(partition$7).log();
        return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
    }

    public static final /* synthetic */ String $anonfun$testDivergingEpochs$4() {
        return "Failed to reconcile leader and follower logs";
    }

    public static final /* synthetic */ boolean $anonfun$testTruncateOnFetchDoesNotProcessPartitionData$2(MockFetcherThread fetcher$32, TopicPartition partition$8) {
        fetcher$32.doWork();
        Buffer<RecordBatch> buffer = fetcher$32.replicaPartitionState(partition$8).log();
        Buffer<RecordBatch> buffer2 = fetcher$32.mockLeader().leaderPartitionState(partition$8).log();
        return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
    }

    public static final /* synthetic */ String $anonfun$testTruncateOnFetchDoesNotProcessPartitionData$3() {
        return "Failed to reconcile leader and follower logs";
    }

    private static final void verifyFetchState$1(Option fetchState, Option expectedTopicId) {
        Assertions.assertTrue((boolean)fetchState.isDefined());
        Assertions.assertEquals((Object)expectedTopicId, (Object)((PartitionFetchState)fetchState.get()).topicId());
    }

    public AbstractFetcherThreadTest() {
        this.truncateOnFetch = true;
    }
}

