/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.util.Optional;
import kafka.cluster.BrokerEndPoint;
import kafka.common.ClientIdAndBroker;
import kafka.server.AbstractFetcherManager;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerTopicStats;
import kafka.server.ClientIdTopicPartition;
import kafka.server.FailedPartitions;
import kafka.server.FetchConnectionsMode;
import kafka.server.FetcherLagMetrics;
import kafka.server.FetcherLagStats;
import kafka.server.FetcherPool;
import kafka.server.FetcherStats;
import kafka.server.FetcherTag;
import kafka.server.InitialFetchState;
import kafka.server.LeaderEndPoint;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaState;
import kafka.server.TierOffsetInfo;
import kafka.server.TierStateMachine;
import kafka.server.Truncating$;
import kafka.utils.Implicits;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r\rd\u0001\u0002\u001e<\u0001\u0001CQa\u0012\u0001\u0005\u0002!Cqa\u0013\u0001C\u0002\u0013\u0005A\n\u0003\u0004Q\u0001\u0001\u0006I!\u0014\u0005\b#\u0002\u0011\r\u0011\"\u0001S\u0011\u00191\u0006\u0001)A\u0005'\"9q\u000b\u0001b\u0001\n\u0003A\u0006BB0\u0001A\u0003%\u0011\fC\u0003a\u0001\u0011\u0005\u0011\rC\u0003s\u0001\u0011%1\u000f\u0003\u0004\u0002\n\u0001!\t!\u0019\u0005\u0007\u0003'\u0001A\u0011A1\t\r\u0005]\u0001\u0001\"\u0001b\u0011\u0019\tY\u0002\u0001C\u0001C\"1\u0011q\u0004\u0001\u0005\u0002\u0005Da!a\t\u0001\t\u0003\t\u0007BBA\u0014\u0001\u0011\u0005\u0011\r\u0003\u0004\u0002,\u0001!\t!\u0019\u0005\u0007\u0003_\u0001A\u0011A1\t\u000f\u0005M\u0002\u0001\"\u0003\u00026!I\u00111\t\u0001\u0012\u0002\u0013%\u0011Q\t\u0005\b\u00037\u0002A\u0011BA/\u0011%\tI\tAI\u0001\n\u0013\tY\tC\u0004\u0002\u0010\u0002!I!!%\u0007\r\u0005e\u0005\u0001BAN\u0011%\t\u0019\u000b\u0007B\u0001B\u0003%\u0011\f\u0003\u0004H1\u0011\u0005\u0011Q\u0015\u0005\u0007\u0003[CB\u0011I1\t\r\u0005=\u0006\u0004\"\u0011b\u0011\u00199\u0006\u0004\"\u0011\u00022\"9\u00111\u0017\r\u0005B\u0005U\u0006bBAu1\u0011\u0005\u00131\u001e\u0005\b\u0003kDB\u0011IA|\u0011\u001d\u0011i\u0001\u0007C!\u0005\u001fAqA!\u0006\u0019\t\u0003\u00129\u0002C\u0004\u0003Pa!\tE!\u0015\t\u000f\tu\u0003\u0004\"\u0011\u0003`!I!\u0011\u0011\rC\u0002\u0013\u0005#1\u0011\u0005\t\u0005\u000bC\u0002\u0015!\u0003\u0002n\"9!q\u0011\r\u0005B\t%eA\u0002BH\u0001\u0011\u0011\t\n\u0003\u0004HQ\u0011\u0005!\u0011\u0016\u0005\b\u0005[CC\u0011\tBX\u0011\u001d\u0011I\r\u000bC!\u0005\u00174aA!8\u0001\t\t}\u0007B\u0003BtY\t\u0005\t\u0015!\u0003\u0002(\"Q!\u0011\u001e\u0017\u0003\u0002\u0003\u0006IAa;\t\u0015\tEHF!A!\u0002\u0013\u0011\u0019\u000b\u0003\u0004HY\u0011\u0005!1\u001f\u0005\b\u0005{dC\u0011\u000bB\u0000\u0011\u001d\u0019)\u0003\fC)\u0007OAqa!\u000e-\t#\u001a9\u0004C\u0004\u0004@1\"\tf!\u0011\t\u000f\r\u001dC\u0006\"\u0015\u0004J!91Q\n\u0017\u0005R\r=\u0003bBB*Y\u0011E3Q\u000b\u0005\n\u0007?b#\u0019!C)\u0005\u0007C\u0001b!\u0019-A\u0003%\u0011Q\u001e\u0002\u001b\u0003\n\u001cHO]1di\u001a+Go\u00195fe6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003yu\naa]3sm\u0016\u0014(\"\u0001 \u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005I\u0005C\u0001&\u0001\u001b\u0005Y\u0014a\u00034fi\u000eDwJ\u001a4tKR,\u0012!\u0014\t\u0003\u0005:K!aT\"\u0003\t1{gnZ\u0001\rM\u0016$8\r[(gMN,G\u000fI\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007.F\u0001T!\t\u0011E+\u0003\u0002V\u0007\n\u0019\u0011J\u001c;\u0002\u00191,\u0017\rZ3s\u000bB|7\r\u001b\u0011\u0002\u001d\t\u0014xn[3s\u000b:$\u0007k\\5oiV\t\u0011\f\u0005\u0002[;6\t1L\u0003\u0002]{\u000591\r\\;ti\u0016\u0014\u0018B\u00010\\\u00059\u0011%o\\6fe\u0016sG\rU8j]R\fqB\u0019:pW\u0016\u0014XI\u001c3Q_&tG\u000fI\u0001\u0014G2,\u0017M\\'fiJL7MU3hSN$(/\u001f\u000b\u0002EB\u0011!iY\u0005\u0003I\u000e\u0013A!\u00168ji\"\u0012\u0001B\u001a\t\u0003OBl\u0011\u0001\u001b\u0006\u0003S*\f1!\u00199j\u0015\tYG.A\u0004kkBLG/\u001a:\u000b\u00055t\u0017!\u00026v]&$(\"A8\u0002\u0007=\u0014x-\u0003\u0002rQ\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u001d\u001d,G/T3ue&\u001cg+\u00197vKR\u0011Ao\u001e\t\u0003\u0005VL!A^\"\u0003\u0007\u0005s\u0017\u0010C\u0003y\u0013\u0001\u0007\u00110\u0001\u0003oC6,\u0007c\u0001>\u0002\u00049\u00111p \t\u0003y\u000ek\u0011! \u0006\u0003}~\na\u0001\u0010:p_Rt\u0014bAA\u0001\u0007\u00061\u0001K]3eK\u001aLA!!\u0002\u0002\b\t11\u000b\u001e:j]\u001eT1!!\u0001D\u0003e!Xm\u001d;BI\u0012\fe\u000e\u001a*f[>4X\rU1si&$\u0018n\u001c8)\u0007)\ti\u0001E\u0002h\u0003\u001fI1!!\u0005i\u0005\u0011!Vm\u001d;\u0002=Q,7\u000f^'fiJL7MR1jY\u0016$\u0007+\u0019:uSRLwN\\\"pk:$\bfA\u0006\u0002\u000e\u0005IB/Z:u\t\u0016\fG\r\u00165sK\u0006$7i\\;oi6+GO]5dQ\ra\u0011QB\u0001\u0014i\u0016\u001cHOR3uG\"\u0014\u0016\r^3NKR\u0014\u0018n\u0019\u0015\u0004\u001b\u00055\u0011A\u0005;fgR$v\u000e^1m\u0019\u0006<W*\u001a;sS\u000eD3ADA\u0007\u0003m!Xm\u001d;NS\u001e\u0014\u0018\r^3J]NKhn\u0019)beRLG/[8og\"\u001aq\"!\u0004\u0002/Q,7\u000f^'bs\n,W\u000b\u001d3bi\u0016$v\u000e]5d\u0013\u0012\u001c\bf\u0001\t\u0002\u000e\u0005!B/Z:u\u000bb\u0004\u0018M\u001c3UQJ,\u0017\r\u001a)p_2D3!EA\u0007\u0003Q!Xm\u001d;TQJLgn\u001b+ie\u0016\fG\rU8pY\"\u001a!#!\u0004\u0002)Q,7\u000f\u001e*fg&TX\r\u00165sK\u0006$\u0007k\\8m)\u001d\u0011\u0017qGA\u001e\u0003\u007fAa!!\u000f\u0014\u0001\u0004\u0019\u0016AE2veJ,g\u000e\u001e$fi\u000eDWM]*ju\u0016Da!!\u0010\u0014\u0001\u0004\u0019\u0016A\u00048fo\u001a+Go\u00195feNK'0\u001a\u0005\t\u0003\u0003\u001a\u0002\u0013!a\u0001'\u0006I!M]8lKJtU/\\\u0001\u001fi\u0016\u001cHOU3tSj,G\u000b\u001b:fC\u0012\u0004vn\u001c7%I\u00164\u0017-\u001e7uIM*\"!a\u0012+\u0007M\u000bIe\u000b\u0002\u0002LA!\u0011QJA,\u001b\t\tyE\u0003\u0003\u0002R\u0005M\u0013!C;oG\",7m[3e\u0015\r\t)fQ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA-\u0003\u001f\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003Ii\u0017m[3U_BL7\rU1si&$\u0018n\u001c8\u0015\u0011\u0005}\u0013QPAA\u0003\u000b\u0003b!!\u0019\u0002h\u0005-TBAA2\u0015\r\t)gQ\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA5\u0003G\u00121aU3u!\u0011\ti'!\u001f\u000e\u0005\u0005=$\u0002BA9\u0003g\naaY8n[>t'b\u0001 \u0002v)\u0019\u0011q\u000f8\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\tY(a\u001c\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"1\u0011qP\u000bA\u0002M\u000b\u0001\u0002^8qS\u000etU/\u001c\u0005\u0007\u0003\u0007+\u0002\u0019A*\u0002\u0019A\f'\u000f^5uS>tg*^7\t\u0011\u0005\u001dU\u0003%AA\u0002e\f1\u0002^8qS\u000e\u0004&/\u001a4jq\u0006aR.Y6f)>\u0004\u0018n\u0019)beRLG/[8oI\u0011,g-Y;mi\u0012\u001aTCAAGU\rI\u0018\u0011J\u0001\fO\u0016$(I]8lKJLE\rF\u0003T\u0003'\u000b9\nC\u0004\u0002\u0016^\u0001\r!a\u001b\u0002\u0005Q\u0004\bBBA!/\u0001\u00071KA\u0010N_\u000e\\'+Z:ju\u00164U\r^2iKJdU-\u00193fe\u0016sG\rU8j]R\u001cB\u0001G!\u0002\u001eB\u0019!*a(\n\u0007\u0005\u00056H\u0001\bMK\u0006$WM]#oIB{\u0017N\u001c;\u0002\u0019M|WO]2f\u0005J|7.\u001a:\u0015\t\u0005\u001d\u00161\u0016\t\u0004\u0003SCR\"\u0001\u0001\t\r\u0005\r&\u00041\u0001Z\u00035Ig.\u001b;jCR,7\t\\8tK\u0006)1\r\\8tKR\t\u0011,\u0001\u0006ck&dGMR3uG\"$B!a.\u0002ZB1\u0011\u0011XAd\u0003\u001btA!a/\u0002D:!\u0011QXAa\u001d\ra\u0018qX\u0005\u0002}%\u0011A(P\u0005\u0004\u0003\u000b\\\u0014!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ\u0005\u0005\u0003\u0013\fYM\u0001\u000bSKN,H\u000e^,ji\"\u0004\u0016M\u001d;ji&|gn\u001d\u0006\u0004\u0003\u000b\\\u0004#\u0002\"\u0002P\u0006M\u0017bAAi\u0007\n1q\n\u001d;j_:\u0004B!!/\u0002V&!\u0011q[Af\u00051\u0011V\r\u001d7jG\u00064U\r^2i\u0011\u001d\tYN\ba\u0001\u0003;\fA\u0002]1si&$\u0018n\u001c8NCB\u0004\u0002\"!\u0019\u0002`\u0006-\u00141]\u0005\u0005\u0003C\f\u0019GA\u0002NCB\u00042ASAs\u0013\r\t9o\u000f\u0002\u0014!\u0006\u0014H/\u001b;j_:4U\r^2i'R\fG/Z\u0001\u0010SN\u0014V-\u00193z\r>\u0014h)\u001a;dQR!\u0011Q^Az!\r\u0011\u0015q^\u0005\u0004\u0003c\u001c%a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003+{\u0002\u0019AA6\u0003M1W\r^2i\u000b\u0006\u0014H.[3ti>3gm]3u)\u0019\tIP!\u0002\u0003\nA!\u00111 B\u0001\u001b\t\tiP\u0003\u0003\u0002r\u0005}(b\u0001\u001f\u0002t%!!1AA\u007f\u00059yeMZ:fi\u0006sG-\u00129pG\"DqAa\u0002!\u0001\u0004\tY'\u0001\bu_BL7\rU1si&$\u0018n\u001c8\t\r\t-\u0001\u00051\u0001T\u0003I\u0019WO\u001d:f]RdU-\u00193fe\u0016\u0003xn\u00195\u0002#\u0019,Go\u00195MCR,7\u000f^(gMN,G\u000f\u0006\u0004\u0002z\nE!1\u0003\u0005\b\u0005\u000f\t\u0003\u0019AA6\u0011\u0019\u0011Y!\ta\u0001'\u0006!b-\u001a;dQ\u0016\u0003xn\u00195F]\u0012|eMZ:fiN$BA!\u0007\u0003BAA\u0011\u0011MAp\u0003W\u0012Y\u0002\u0005\u0003\u0003\u001e\tmb\u0002\u0002B\u0010\u0005kqAA!\t\u000329!!1\u0005B\u0018\u001d\u0011\u0011)C!\f\u000f\t\t\u001d\"1\u0006\b\u0004y\n%\u0012\"A8\n\u0007\u0005]d.C\u0002?\u0003kJA!!\u001d\u0002t%!!1GA8\u0003\u001diWm]:bO\u0016LAAa\u000e\u0003:\u0005\u0001sJ\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"\u0014Vm\u001d9p]N,G)\u0019;b\u0015\u0011\u0011\u0019$a\u001c\n\t\tu\"q\b\u0002\u000f\u000bB|7\r[#oI>3gm]3u\u0015\u0011\u00119D!\u000f\t\u000f\t\r#\u00051\u0001\u0003F\u0005Q\u0001/\u0019:uSRLwN\\:\u0011\u0011\u0005\u0005\u0014q\\A6\u0005\u000f\u0002BA!\u0013\u0003L5\t\u0001$\u0003\u0003\u0003N\u0005}%!C#q_\u000eDG)\u0019;b\u0003y1W\r^2i)&,'/T1uKJL\u0017\r\\5{CRLwN\u001c+be\u001e,G\u000f\u0006\u0004\u0003T\te#1\f\t\u0004\u0015\nU\u0013b\u0001B,w\tqA+[3s\u001f\u001a47/\u001a;J]\u001a|\u0007b\u0002B\u0004G\u0001\u0007\u00111\u000e\u0005\u0007\u0005\u0017\u0019\u0003\u0019A*\u0002\u000b\u0019,Go\u00195\u0015\t\t\u0005$\u0011\u000e\t\t\u0003C\ny.a\u001b\u0003dA!!\u0011\nB3\u0013\u0011\u00119'a(\u0003\u0013\u0019+Go\u00195ECR\f\u0007b\u0002B6I\u0001\u0007!QN\u0001\rM\u0016$8\r\u001b*fcV,7\u000f\u001e\t\u0005\u0005_\u0012YH\u0004\u0003\u0003r\t]TB\u0001B:\u0015\u0011\u0011)(a\u001c\u0002\u0011I,\u0017/^3tiNLAA!\u001f\u0003t\u0005aa)\u001a;dQJ+\u0017/^3ti&!!Q\u0010B@\u0005\u001d\u0011U/\u001b7eKJTAA!\u001f\u0003t\u0005a\u0012n\u001d+sk:\u001c\u0017\r^5p]>sg)\u001a;dQN+\b\u000f]8si\u0016$WCAAw\u0003uI7\u000f\u0016:v]\u000e\fG/[8o\u001f:4U\r^2i'V\u0004\bo\u001c:uK\u0012\u0004\u0013\u0001\u00074fi\u000eDW)\u0019:mS\u0016\u001cH\u000fT8dC2|eMZ:fiR1\u0011\u0011 BF\u0005\u001bCqAa\u0002(\u0001\u0004\tY\u0007\u0003\u0004\u0003\f\u001d\u0002\ra\u0015\u0002\"\u001b>\u001c7NU3tSj,g)\u001a;dQ\u0016\u0014H+[3s'R\fG/Z'bG\"Lg.Z\n\u0006Q\tM%1\u0015\t\u0005\u0005+\u0013y*\u0004\u0002\u0003\u0018*!!\u0011\u0014BN\u0003\u0011a\u0017M\\4\u000b\u0005\tu\u0015\u0001\u00026bm\u0006LAA!)\u0003\u0018\n1qJ\u00196fGR\u00042A\u0013BS\u0013\r\u00119k\u000f\u0002\u0011)&,'o\u0015;bi\u0016l\u0015m\u00195j]\u0016$\"Aa+\u0011\u0007\u0005%\u0006&A\u0003ti\u0006\u0014H\u000f\u0006\u0005\u0002d\nE&1\u0017B\\\u0011\u001d\u00119A\u000ba\u0001\u0003WBqA!.+\u0001\u0004\t\u0019/A\tdkJ\u0014XM\u001c;GKR\u001c\u0007n\u0015;bi\u0016DqA!/+\u0001\u0004\u0011Y,\u0001\ngKR\u001c\u0007\u000eU1si&$\u0018n\u001c8ECR\f\u0007\u0003\u0002B_\u0005\u0007tAAa\b\u0003@&!!\u0011\u0019B\u001d\u0003E1U\r^2i%\u0016\u001c\bo\u001c8tK\u0012\u000bG/Y\u0005\u0005\u0005\u000b\u00149MA\u0007QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u0006\u0005\u0005\u0003\u0014I$A\tnCf\u0014W-\u00113wC:\u001cWm\u0015;bi\u0016$bA!4\u0003Z\nm\u0007C\u0002Bh\u0005+\f\u0019/\u0004\u0002\u0003R*!!1\u001bBN\u0003\u0011)H/\u001b7\n\t\t]'\u0011\u001b\u0002\t\u001fB$\u0018n\u001c8bY\"9\u0011QS\u0016A\u0002\u0005-\u0004b\u0002B[W\u0001\u0007\u00111\u001d\u0002\u0018)\u0016\u001cHOU3tSj,g)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\u001c2\u0001\fBq!\rQ%1]\u0005\u0004\u0005K\\$!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ\u0001\u0007Y\u0016\fG-\u001a:\u0002!\u0019\f\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001c\bc\u0001&\u0003n&\u0019!q^\u001e\u0003!\u0019\u000b\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001c\u0018!\u00064fi\u000eDG+[3s'R\fG/Z'bG\"Lg.\u001a\u000b\t\u0005k\u00149P!?\u0003|B\u0019\u0011\u0011\u0016\u0017\t\u000f\t\u001d\b\u00071\u0001\u0002(\"9!\u0011\u001e\u0019A\u0002\t-\bb\u0002Bya\u0001\u0007!1U\u0001\u0015aJ|7-Z:t!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0015\u0011\r\u00051qCB\r\u00077\u0001RAQAh\u0007\u0007\u0001Ba!\u0002\u0004\u00145\u00111q\u0001\u0006\u0005\u0007\u0013\u0019Y!A\u0002m_\u001eTAa!\u0004\u0004\u0010\u0005I\u0011N\u001c;fe:\fGn\u001d\u0006\u0005\u0007#\t\u0019(A\u0004ti>\u0014\u0018mZ3\n\t\rU1q\u0001\u0002\u000e\u0019><\u0017\t\u001d9f]\u0012LeNZ8\t\u000f\t\u001d\u0011\u00071\u0001\u0002l!)1*\ra\u0001\u001b\"91QD\u0019A\u0002\r}\u0011!\u00049beRLG/[8o\t\u0006$\u0018\r\u0005\u0003\u0004\"\r\rR\"\u0001\u0017\n\t\t\u001d$1]\u0001\tiJ,hnY1uKR1\u0011Q^B\u0015\u0007WAqAa\u00023\u0001\u0004\tY\u0007C\u0004\u0004.I\u0002\raa\f\u0002\u001fQ\u0014XO\\2bi&|gn\u0015;bi\u0016\u00042ASB\u0019\u0013\r\u0019\u0019d\u000f\u0002\u0016\u001f\u001a47/\u001a;UeVt7-\u0019;j_:\u001cF/\u0019;f\u0003]!(/\u001e8dCR,g)\u001e7ms\u0006sGm\u0015;beR\fE\u000fF\u0003c\u0007s\u0019Y\u0004C\u0004\u0003\bM\u0002\r!a\u001b\t\r\ru2\u00071\u0001N\u0003\u0019ygMZ:fi\u0006YA.\u0019;fgR,\u0005o\\2i)\u0011\u0019\u0019e!\u0012\u0011\t\t\u000bym\u0015\u0005\b\u0005\u000f!\u0004\u0019AA6\u00039awnZ*uCJ$xJ\u001a4tKR$2!TB&\u0011\u001d\u00119!\u000ea\u0001\u0003W\nA\u0002\\8h\u000b:$wJ\u001a4tKR$2!TB)\u0011\u001d\u00119A\u000ea\u0001\u0003W\n\u0011#\u001a8e\u001f\u001a47/\u001a;G_J,\u0005o\\2i)\u0019\u00199f!\u0017\u0004\\A)!)a4\u0002z\"9!qA\u001cA\u0002\u0005-\u0004BBB/o\u0001\u00071+A\u0003fa>\u001c\u0007.A\u0010jg>3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i'V\u0004\bo\u001c:uK\u0012\f\u0001%[:PM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s\u000bB|7\r[*vaB|'\u000f^3eA\u0001")
public class AbstractFetcherManagerTest {
    private final long fetchOffset;
    private final int leaderEpoch;
    private final BrokerEndPoint brokerEndPoint = new BrokerEndPoint(0, "localhost", 9092);

    public long fetchOffset() {
        return this.fetchOffset;
    }

    public int leaderEpoch() {
        return this.leaderEpoch;
    }

    public BrokerEndPoint brokerEndPoint() {
        return this.brokerEndPoint;
    }

    @BeforeEach
    public void cleanMetricRegistry() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    private Object getMetricValue(String name) {
        return ((Gauge)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$getMetricValue$1(name, x0$1)))).values().headOption().get()).value();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAddAndRemovePartition() {
        void apply_failedAttempts;
        void apply_lastFetchedEpoch;
        void apply_state;
        void apply_currentLeaderEpoch;
        void apply_lag;
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        LeaderEndPoint leader = (LeaderEndPoint)Mockito.mock(LeaderEndPoint.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$1;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                return this.fetcher$1;
            }
            {
                this.fetcher$1 = fetcher$1;
                super("fetcher-manager", "fetcher-manager", 2, (FetchConnectionsMode)FetchConnectionsMode.Combined$.MODULE$, (Option)None$.MODULE$, (Map)Map$.MODULE$.empty());
            }
        };
        TopicPartition tp = new TopicPartition("topic", 0);
        Some topicId = new Some((Object)Uuid.randomUuid());
        InitialFetchState initialFetchState = new InitialFetchState((Option)topicId, this.brokerEndPoint(), this.leaderEpoch(), this.fetchOffset());
        Mockito.when((Object)leader.brokerEndPoint()).thenReturn((Object)new BrokerEndPoint(0, "localhost", 9092));
        Mockito.when((Object)fetcher.leader()).thenReturn((Object)leader);
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        boolean bl = false;
        None$ none$ = None$.MODULE$;
        Truncating$ truncating$ = Truncating$.MODULE$;
        int n = this.leaderEpoch();
        None$ none$2 = None$.MODULE$;
        long apply_offset = this.fetchOffset();
        none$2 = null;
        truncating$ = null;
        none$ = null;
        Mockito.when((Object)fetcher.fetchState(tp)).thenReturn((Object)new Some((Object)new PartitionFetchState((Option)topicId, apply_offset, (Option)apply_lag, (int)apply_currentLeaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state, (Option)apply_lastFetchedEpoch, (int)apply_failedAttempts))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)fetcher.removePartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})))).thenReturn(Map$.MODULE$.empty());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        Assertions.assertEquals((Object)new Some((Object)fetcher), (Object)fetcherManager.getFetcher(tp));
        fetcherManager.removeFetcherForPartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)fetcherManager.getFetcher(tp));
        ((Thread)Mockito.verify((Object)fetcher)).start();
    }

    @Test
    public void testMetricFailedPartitionCount() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$2;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                return this.fetcher$2;
            }
            {
                this.fetcher$2 = fetcher$2;
                super("fetcher-manager", "fetcher-manager", 2, (FetchConnectionsMode)FetchConnectionsMode.Combined$.MODULE$, (Option)None$.MODULE$, (Map)Map$.MODULE$.empty());
            }
        };
        TopicPartition tp = new TopicPartition("topic", 0);
        String metricName = "FailedPartitionsCount";
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)this.getMetricValue(metricName));
        fetcherManager.failedPartitions().add(tp);
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)this.getMetricValue(metricName));
        fetcherManager.removeFetcherForPartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)this.getMetricValue(metricName));
    }

    @Test
    public void testDeadThreadCountMetric() {
        AbstractFetcherThread fetcher1 = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        LeaderEndPoint leader1 = (LeaderEndPoint)Mockito.mock(LeaderEndPoint.class);
        AbstractFetcherThread fetcher2 = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        LeaderEndPoint leader2 = (LeaderEndPoint)Mockito.mock(LeaderEndPoint.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher1, fetcher2){
            private final AbstractFetcherThread fetcher1$1;
            private final AbstractFetcherThread fetcher2$1;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                FetcherPool fetcherPool2 = fetcherPool;
                FetcherPool.Default$ default$ = FetcherPool.Default$.MODULE$;
                if (fetcherPool2 != null && fetcherPool2.equals(default$)) {
                    return this.fetcher1$1;
                }
                return this.fetcher2$1;
            }
            {
                this.fetcher1$1 = fetcher1$1;
                this.fetcher2$1 = fetcher2$1;
                super("fetcher-manager", "fetcher-manager", 2, (FetchConnectionsMode)FetchConnectionsMode.Isolated$.MODULE$, (Option)None$.MODULE$, (Map)Map$.MODULE$.empty());
            }
        };
        TopicPartition tp = new TopicPartition("topic", 0);
        Some topicId = new Some((Object)Uuid.randomUuid());
        InitialFetchState initialFetchState = new InitialFetchState((Option)topicId, this.brokerEndPoint(), this.leaderEpoch(), this.fetchOffset());
        Mockito.when((Object)fetcher1.leader()).thenReturn((Object)leader1);
        Mockito.when((Object)leader1.brokerEndPoint()).thenReturn((Object)new BrokerEndPoint(0, "localhost", 9092));
        Mockito.when((Object)fetcher1.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fetcher1.isThreadFailed())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)fetcher2.leader()).thenReturn((Object)leader2);
        Mockito.when((Object)fetcher2.leader().brokerEndPoint()).thenReturn((Object)new BrokerEndPoint(0, "localhost", 9092));
        Mockito.when((Object)fetcher2.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fetcher2.isThreadFailed())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.InSync$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        Assertions.assertEquals((int)2, (int)fetcherManager.deadThreadCount());
        ((Thread)Mockito.verify((Object)fetcher1)).start();
        ((Thread)Mockito.verify((Object)fetcher2)).start();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fetcher1.isThreadFailed())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fetcher2.isThreadFailed())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true), ScalaRunTime$.MODULE$.toObjectArray((Object)new boolean[]{false}));
        Assertions.assertEquals((int)1, (int)fetcherManager.deadThreadCount());
        Assertions.assertEquals((int)0, (int)fetcherManager.deadThreadCount());
    }

    @Test
    public void testFetchRateMetric() {
        AbstractFetcherThread fetcher1 = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        LeaderEndPoint leader1 = (LeaderEndPoint)Mockito.mock(LeaderEndPoint.class);
        Mockito.when((Object)leader1.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        AbstractFetcherThread fetcher2 = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        LeaderEndPoint leader2 = (LeaderEndPoint)Mockito.mock(LeaderEndPoint.class);
        Mockito.when((Object)leader2.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher1, fetcher2){
            private final AbstractFetcherThread fetcher1$2;
            private final AbstractFetcherThread fetcher2$2;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                FetcherPool fetcherPool2 = fetcherPool;
                FetcherPool.Default$ default$ = FetcherPool.Default$.MODULE$;
                if (fetcherPool2 != null && fetcherPool2.equals(default$)) {
                    return this.fetcher1$2;
                }
                return this.fetcher2$2;
            }
            {
                this.fetcher1$2 = fetcher1$2;
                this.fetcher2$2 = fetcher2$2;
                super("fetcher-manager", "fetcher-manager", 2, (FetchConnectionsMode)FetchConnectionsMode.Isolated$.MODULE$, (Option)None$.MODULE$, (Map)Map$.MODULE$.empty());
            }
        };
        TopicPartition tp = new TopicPartition("topic", 0);
        InitialFetchState initialFetchState = new InitialFetchState((Option)new Some((Object)Uuid.randomUuid()), this.brokerEndPoint(), this.leaderEpoch(), this.fetchOffset());
        Meter requestRate1 = (Meter)Mockito.mock(Meter.class);
        Meter requestRate2 = (Meter)Mockito.mock(Meter.class);
        Mockito.when((Object)BoxesRunTime.boxToDouble((double)requestRate1.oneMinuteRate())).thenReturn((Object)BoxesRunTime.boxToDouble((double)10.0));
        Mockito.when((Object)BoxesRunTime.boxToDouble((double)requestRate2.oneMinuteRate())).thenReturn((Object)BoxesRunTime.boxToDouble((double)5.0));
        FetcherStats fetcherStats1 = (FetcherStats)Mockito.mock(FetcherStats.class);
        FetcherStats fetcherStats2 = (FetcherStats)Mockito.mock(FetcherStats.class);
        Mockito.when((Object)fetcherStats1.requestRate()).thenReturn((Object)requestRate1);
        Mockito.when((Object)fetcherStats2.requestRate()).thenReturn((Object)requestRate2);
        Mockito.when((Object)fetcher1.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Mockito.when((Object)fetcher1.leader()).thenReturn((Object)leader1);
        Mockito.when((Object)fetcher1.fetcherStats()).thenReturn((Object)fetcherStats1);
        Mockito.when((Object)fetcher2.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Mockito.when((Object)fetcher2.leader()).thenReturn((Object)leader2);
        Mockito.when((Object)fetcher2.fetcherStats()).thenReturn((Object)fetcherStats2);
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.InSync$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.InSync$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        Assertions.assertEquals((double)5.0, (double)BoxesRunTime.unboxToDouble((Object)((Gauge)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$testFetchRateMetric$1(x0$1)))).values().headOption().get()).value()));
        Assertions.assertEquals((int)0, (int)((IterableOnceOps)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$testFetchRateMetric$2(x0$2)))).keys().filter((Function1 & Serializable)k -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$testFetchRateMetric$3(k)))).size());
        Assertions.assertEquals((double)15.0, (double)BoxesRunTime.unboxToDouble((Object)((Gauge)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$testFetchRateMetric$4(x0$3)))).values().headOption().get()).value()));
        fetcherManager.createSeparateFetcherMetrics();
        Assertions.assertEquals((double)10.0, (double)BoxesRunTime.unboxToDouble((Object)((Gauge)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$testFetchRateMetric$5(x0$4)))).values().headOption().get()).value()));
        Assertions.assertEquals((double)5.0, (double)BoxesRunTime.unboxToDouble((Object)((Gauge)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$testFetchRateMetric$6(x0$5)))).values().headOption().get()).value()));
        ((Thread)Mockito.verify((Object)fetcher1)).start();
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher1, (VerificationMode)Mockito.times((int)2))).addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})));
        ((Thread)Mockito.verify((Object)fetcher2)).start();
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher2, (VerificationMode)Mockito.times((int)2))).addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})));
    }

    @Test
    public void testTotalLagMetric() {
        AbstractFetcherThread fetcher1 = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherThread fetcher2 = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher1, fetcher2){
            private final AbstractFetcherThread fetcher1$3;
            private final AbstractFetcherThread fetcher2$3;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                FetcherPool fetcherPool2 = fetcherPool;
                FetcherPool.Default$ default$ = FetcherPool.Default$.MODULE$;
                if (fetcherPool2 != null && fetcherPool2.equals(default$)) {
                    return this.fetcher1$3;
                }
                return this.fetcher2$3;
            }
            {
                this.fetcher1$3 = fetcher1$3;
                this.fetcher2$3 = fetcher2$3;
                super("fetcher-manager", "fetcher-manager", 1, (FetchConnectionsMode)FetchConnectionsMode.Isolated$.MODULE$, (Option)None$.MODULE$, (Map)Map$.MODULE$.empty());
            }
        };
        IndexedSeq tps = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)i -> AbstractFetcherManagerTest.$anonfun$testTotalLagMetric$1(BoxesRunTime.unboxToInt((Object)i)));
        IndexedSeq fetcher1Partitions = (IndexedSeq)tps.slice(0, 2);
        IndexedSeq fetcher2Partitions = (IndexedSeq)tps.slice(2, 4);
        InitialFetchState initialFetchState = new InitialFetchState((Option)new Some((Object)Uuid.randomUuid()), this.brokerEndPoint(), this.leaderEpoch(), this.fetchOffset());
        scala.collection.immutable.Map fetcher1FetchState = ((IterableOnceOps)fetcher1Partitions.map((Function1 & Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)initialFetchState))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map fetcher2FetchState = ((IterableOnceOps)fetcher2Partitions.map((Function1 & Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)initialFetchState))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        ClientIdAndBroker metricId = new ClientIdAndBroker("0", "localhost", 9092);
        FetcherLagStats fetcherLagStats1 = (FetcherLagStats)Mockito.mock(FetcherLagStats.class);
        Function1 & Serializable valueFactory = (Function1 & Serializable)k -> new FetcherLagMetrics(new ClientIdTopicPartition(metricId.clientId(), k), (Map)Map$.MODULE$.empty());
        Pool lagStats1 = new Pool((Option)new Some((Object)valueFactory));
        ((FetcherLagMetrics)lagStats1.getAndMaybePut(fetcher1Partitions.apply(0))).lag_$eq(0L);
        ((FetcherLagMetrics)lagStats1.getAndMaybePut(fetcher1Partitions.apply(1))).lag_$eq(2L);
        Pool lagStats2 = new Pool((Option)new Some((Object)valueFactory));
        ((FetcherLagMetrics)lagStats2.getAndMaybePut(fetcher2Partitions.apply(0))).lag_$eq(1L);
        ((FetcherLagMetrics)lagStats2.getAndMaybePut(fetcher2Partitions.apply(1))).lag_$eq(3L);
        FetcherLagStats fetcherLagStats2 = (FetcherLagStats)Mockito.mock(FetcherLagStats.class);
        Mockito.when((Object)fetcherLagStats1.stats()).thenReturn((Object)lagStats1);
        Mockito.when((Object)fetcherLagStats2.stats()).thenReturn((Object)lagStats2);
        Mockito.when((Object)fetcher1.addPartitions((Map)fetcher1FetchState)).thenReturn((Object)fetcher1Partitions.toSet());
        Mockito.when((Object)fetcher1.fetcherLagStats()).thenReturn((Object)fetcherLagStats1);
        Mockito.when((Object)fetcher2.addPartitions((Map)fetcher2FetchState)).thenReturn((Object)fetcher2Partitions.toSet());
        Mockito.when((Object)fetcher2.fetcherLagStats()).thenReturn((Object)fetcherLagStats2);
        fetcherManager.addFetcherForPartitions((Map)fetcher1FetchState, (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)2L), (Object)this.getMetricValue("TotalLag"));
        fetcherManager.addFetcherForPartitions((Map)fetcher2FetchState, (FetcherPool)FetcherPool.InSync$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)6L), (Object)this.getMetricValue("TotalLag"));
        ((Thread)Mockito.verify((Object)fetcher1)).start();
        ((Thread)Mockito.verify((Object)fetcher2)).start();
    }

    @Test
    public void testMigrateInSyncPartitions() {
        MockTime time = new MockTime();
        AbstractFetcherThread fetcher1 = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        LeaderEndPoint leader1 = (LeaderEndPoint)Mockito.mock(LeaderEndPoint.class);
        Mockito.when((Object)leader1.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        AbstractFetcherThread fetcher2 = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        LeaderEndPoint leader2 = (LeaderEndPoint)Mockito.mock(LeaderEndPoint.class);
        Mockito.when((Object)leader2.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, time, fetcher1, fetcher2){
            private final AbstractFetcherThread fetcher1$4;
            private final AbstractFetcherThread fetcher2$4;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                FetcherPool fetcherPool2 = fetcherPool;
                FetcherPool.Default$ default$ = FetcherPool.Default$.MODULE$;
                if (fetcherPool2 != null && fetcherPool2.equals(default$)) {
                    return this.fetcher1$4;
                }
                return this.fetcher2$4;
            }
            {
                this.fetcher1$4 = fetcher1$4;
                this.fetcher2$4 = fetcher2$4;
                super("fetcher-manager", "fetcher-manager", 1, (FetchConnectionsMode)FetchConnectionsMode.Isolated$.MODULE$, (Option)new Some((Object)time$1.scheduler()), (Map)Map$.MODULE$.empty());
            }
        };
        TopicPartition tp_0 = new TopicPartition("topic", 0);
        TopicPartition tp_1 = new TopicPartition("topic", 1);
        Some topicId = new Some((Object)Uuid.randomUuid());
        InitialFetchState initialFetchState_0 = new InitialFetchState((Option)topicId, this.brokerEndPoint(), this.leaderEpoch(), this.fetchOffset());
        InitialFetchState initialFetchState_1 = new InitialFetchState((Option)topicId, this.brokerEndPoint(), this.leaderEpoch(), this.fetchOffset());
        PartitionFetchState partitionFetchState_0 = new PartitionFetchState((Option)topicId, this.fetchOffset(), Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L)), this.leaderEpoch(), (Option)None$.MODULE$, (ReplicaState)Mockito.mock(ReplicaState.class), (Option)None$.MODULE$, 0);
        Function1 & Serializable valueFactory = arg_0 -> AbstractFetcherManagerTest.$anonfun$testMigrateInSyncPartitions$1(new ClientIdAndBroker("0", "localhost", 9092), arg_0);
        Pool lagStats = new Pool((Option)new Some((Object)valueFactory));
        ((FetcherLagMetrics)lagStats.getAndMaybePut((Object)tp_0)).lag_$eq(0L);
        ((FetcherLagMetrics)lagStats.getAndMaybePut((Object)tp_1)).lag_$eq(1L);
        FetcherLagStats fetcherLagStats = (FetcherLagStats)Mockito.mock(FetcherLagStats.class);
        Mockito.when((Object)fetcherLagStats.stats()).thenReturn((Object)lagStats);
        Mockito.when((Object)fetcher1.leader()).thenReturn((Object)leader1);
        Mockito.when((Object)fetcher1.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp_0), (Object)initialFetchState_0)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp_0})));
        Mockito.when((Object)fetcher1.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp_1), (Object)initialFetchState_1)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp_1})));
        Mockito.when((Object)fetcher1.fetcherLagStats()).thenReturn((Object)fetcherLagStats);
        Mockito.when((Object)fetcher1.removePartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp_0})))).thenReturn(Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp_0), (Object)partitionFetchState_0)})));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)fetcher1.partitionCount())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
        Mockito.when((Object)fetcher2.leader()).thenReturn((Object)leader2);
        Mockito.when((Object)fetcher2.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp_0), (Object)initialFetchState_1)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp_0})));
        Mockito.when((Object)fetcher2.fetcherLagStats()).thenReturn((Object)fetcherLagStats);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)fetcher2.partitionCount())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
        Mockito.when((Object)fetcher2.fetchState(tp_0)).thenReturn((Object)new Some((Object)partitionFetchState_0));
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp_0), (Object)initialFetchState_0)})), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp_1), (Object)initialFetchState_1)})), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        Assertions.assertEquals((int)1, (int)fetcherManager.fetcherThreadMap().size());
        Assertions.assertTrue((boolean)fetcherManager.fetcherThreadMap().contains((Object)new FetcherTag(0, 0, (FetcherPool)FetcherPool.Default$.MODULE$)));
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher2, tp_0, (Option)topicId);
        time.sleep(1001L);
        Assertions.assertEquals((int)2, (int)fetcherManager.fetcherThreadMap().size());
        Assertions.assertEquals((Object)fetcher1, (Object)fetcherManager.fetcherThreadMap().apply((Object)new FetcherTag(0, 0, (FetcherPool)FetcherPool.Default$.MODULE$)));
        Assertions.assertEquals((Object)fetcher2, (Object)fetcherManager.fetcherThreadMap().apply((Object)new FetcherTag(0, 0, (FetcherPool)FetcherPool.InSync$.MODULE$)));
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher2, tp_0, (Option)topicId);
        ((Thread)Mockito.verify((Object)fetcher1)).start();
        ((Thread)Mockito.verify((Object)fetcher2)).start();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaybeUpdateTopicIds() {
        void apply_failedAttempts;
        void apply_lastFetchedEpoch;
        void apply_state;
        void apply_failedAttempts2;
        void apply_lastFetchedEpoch2;
        void apply_state2;
        void apply_lag;
        void apply_failedAttempts3;
        void apply_lastFetchedEpoch3;
        void apply_state3;
        void apply_failedAttempts4;
        void apply_lastFetchedEpoch4;
        void apply_state4;
        void apply_lag2;
        MockTime time = new MockTime();
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        LeaderEndPoint leader = (LeaderEndPoint)Mockito.mock(LeaderEndPoint.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, time, fetcher){
            private final AbstractFetcherThread fetcher$3;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                return this.fetcher$3;
            }
            {
                this.fetcher$3 = fetcher$3;
                super("fetcher-manager", "fetcher-manager", 2, (FetchConnectionsMode)FetchConnectionsMode.Isolated$.MODULE$, (Option)new Some((Object)time$2.scheduler()), (Map)Map$.MODULE$.empty());
            }
        };
        long fetchOffset = 10L;
        int leaderEpoch = 15;
        TopicPartition tp1 = new TopicPartition("topic1", 0);
        TopicPartition tp2 = new TopicPartition("topic2", 0);
        TopicPartition unknownTp = new TopicPartition("topic2", 1);
        Some topicId1 = new Some((Object)Uuid.randomUuid());
        Some topicId2 = new Some((Object)Uuid.randomUuid());
        InitialFetchState initialFetchState1 = new InitialFetchState((Option)None$.MODULE$, new BrokerEndPoint(0, "localhost", 9092), leaderEpoch, fetchOffset);
        InitialFetchState initialFetchState2 = new InitialFetchState((Option)None$.MODULE$, new BrokerEndPoint(1, "localhost", 9092), leaderEpoch, fetchOffset);
        Mockito.when((Object)fetcher.leader()).thenReturn((Object)leader);
        Mockito.when((Object)leader.brokerEndPoint()).thenReturn((Object)new BrokerEndPoint(0, "localhost", 9092));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)initialFetchState1)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1})));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)initialFetchState2)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp2})));
        boolean bl = false;
        None$ none$ = None$.MODULE$;
        Truncating$ truncating$ = Truncating$.MODULE$;
        None$ none$2 = None$.MODULE$;
        None$ apply_topicId = None$.MODULE$;
        Object var18_18 = null;
        none$2 = null;
        truncating$ = null;
        none$ = null;
        boolean bl2 = false;
        None$ none$3 = None$.MODULE$;
        Truncating$ truncating$2 = Truncating$.MODULE$;
        None$ apply_lag3 = None$.MODULE$;
        Object var23_22 = null;
        truncating$2 = null;
        none$3 = null;
        Mockito.when((Object)fetcher.fetchState(tp1)).thenReturn((Object)new Some((Object)new PartitionFetchState((Option)apply_topicId, fetchOffset, (Option)apply_lag2, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state4, (Option)apply_lastFetchedEpoch4, (int)apply_failedAttempts4))).thenReturn((Object)new Some((Object)new PartitionFetchState((Option)topicId1, fetchOffset, (Option)apply_lag3, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state3, (Option)apply_lastFetchedEpoch3, (int)apply_failedAttempts3)));
        boolean bl3 = false;
        None$ none$4 = None$.MODULE$;
        Truncating$ truncating$3 = Truncating$.MODULE$;
        None$ none$5 = None$.MODULE$;
        None$ apply_topicId2 = None$.MODULE$;
        Object var27_27 = null;
        none$5 = null;
        truncating$3 = null;
        none$4 = null;
        boolean bl4 = false;
        None$ none$6 = None$.MODULE$;
        Truncating$ truncating$4 = Truncating$.MODULE$;
        None$ apply_lag4 = None$.MODULE$;
        Object var32_31 = null;
        truncating$4 = null;
        none$6 = null;
        Mockito.when((Object)fetcher.fetchState(tp2)).thenReturn((Object)new Some((Object)new PartitionFetchState((Option)apply_topicId2, fetchOffset, (Option)apply_lag, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state2, (Option)apply_lastFetchedEpoch2, (int)apply_failedAttempts2))).thenReturn((Object)new Some((Object)new PartitionFetchState((Option)topicId2, fetchOffset, (Option)apply_lag4, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state, (Option)apply_lastFetchedEpoch, (int)apply_failedAttempts)));
        Map topicIds = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1.topic()), (Object)topicId1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2.topic()), (Object)topicId2)}));
        Mockito.when((Object)fetcher.fetchState(unknownTp)).thenReturn((Object)None$.MODULE$);
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)initialFetchState1)})), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)initialFetchState2)})), (FetcherPool)FetcherPool.InSync$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        AbstractFetcherManagerTest.verifyFetchState$2(fetcher.fetchState(tp1), (Option)None$.MODULE$);
        AbstractFetcherManagerTest.verifyFetchState$2(fetcher.fetchState(tp2), (Option)None$.MODULE$);
        Map partitionsToUpdate = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToInteger((int)initialFetchState1.leader().id())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToInteger((int)initialFetchState2.leader().id()))}));
        fetcherManager.maybeUpdateTopicIds(partitionsToUpdate, (Function1)topicIds);
        AbstractFetcherManagerTest.verifyFetchState$2(fetcher.fetchState(tp1), (Option)topicId1);
        AbstractFetcherManagerTest.verifyFetchState$2(fetcher.fetchState(tp2), (Option)topicId2);
        Map invalidPartitionsToUpdate = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unknownTp), (Object)BoxesRunTime.boxToInteger((int)initialFetchState1.leader().id()))}));
        fetcherManager.maybeUpdateTopicIds(invalidPartitionsToUpdate, (Function1)topicIds);
        Assertions.assertTrue((boolean)fetcher.fetchState(unknownTp).isEmpty());
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher)).maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownTp})), (Function1)topicIds);
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher)).maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1})), (Function1)topicIds);
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher)).maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp2})), (Function1)topicIds);
    }

    @Test
    public void testExpandThreadPool() {
        this.testResizeThreadPool(10, 50, 6);
    }

    @Test
    public void testShrinkThreadPool() {
        this.testResizeThreadPool(50, 10, 6);
    }

    private void testResizeThreadPool(int currentFetcherSize, int newFetcherSize, int brokerNum) {
        Set<TopicPartition> fetchingTopicPartitions = this.makeTopicPartition(10, 100, "topic_");
        Set<TopicPartition> failedTopicPartitions = this.makeTopicPartition(2, 5, "topic_failed");
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(this, currentFetcherSize){
            private final /* synthetic */ AbstractFetcherManagerTest $outer;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                return this.$outer.new TestResizeFetcherThread(new MockResizeFetcherLeaderEndPoint(this.$outer, sourceBroker), this.failedPartitions(), this.$outer.new MockResizeFetcherTierStateMachine());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super("fetcher-manager", "fetcher-manager", currentFetcherSize$1, (FetchConnectionsMode)FetchConnectionsMode.Isolated$.MODULE$, (Option)None$.MODULE$, (Map)Map$.MODULE$.empty());
            }
        };
        try {
            fetcherManager.addFetcherForPartitions((Map)((IterableOnceOps)fetchingTopicPartitions.map((Function1 & Serializable)tp -> {
                int brokerId = this.getBrokerId((TopicPartition)tp, brokerNum);
                BrokerEndPoint brokerEndPoint = new BrokerEndPoint(brokerId, new StringBuilder(11).append("kafka-host-").append(brokerId).toString(), 9092);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)new InitialFetchState((Option)None$.MODULE$, brokerEndPoint, 0, 0L));
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
            ((IterableOnceOps)fetchingTopicPartitions.take(20)).foreach(arg_0 -> AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$2$adapted((AbstractFetcherManager)fetcherManager, arg_0));
            failedTopicPartitions.foreach(arg_0 -> AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$3$adapted((AbstractFetcherManager)fetcherManager, arg_0));
            fetcherManager.resizeThreadPool(newFetcherSize);
            scala.collection.mutable.Set ownedPartitions = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.empty();
            fetcherManager.fetcherThreadMap().foreachEntry((arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((arg_0, arg_1) -> AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$4$adapted(this, ownedPartitions, (AbstractFetcherManager)fetcherManager, brokerNum, arg_0, arg_1), arg_0, arg_1));
            Assertions.assertEquals(fetchingTopicPartitions, (Object)ownedPartitions);
            Assertions.assertEquals(failedTopicPartitions, (Object)fetcherManager.failedPartitions().partitions());
        }
        finally {
            fetcherManager.closeAllFetchers();
        }
    }

    private int testResizeThreadPool$default$3() {
        return 6;
    }

    private Set<TopicPartition> makeTopicPartition(int topicNum, int partitionNum, String topicPrefix) {
        scala.collection.mutable.Set res = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), topicNum - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            String topic = new StringBuilder(0).append(topicPrefix).append(i).toString();
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), partitionNum - 1).foreach((Function1 & Serializable)j -> AbstractFetcherManagerTest.$anonfun$makeTopicPartition$2(res, topic, BoxesRunTime.unboxToInt((Object)j)));
        });
        return res.toSet();
    }

    private String makeTopicPartition$default$3() {
        return "topic_";
    }

    private int getBrokerId(TopicPartition tp, int brokerNum) {
        return Utils.abs((int)tp.hashCode()) % brokerNum;
    }

    public static final /* synthetic */ boolean $anonfun$getMetricValue$1(String name$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String string = ((MetricName)x0$1._1()).getName();
            return !(string != null ? !string.equals(name$1) : name$1 != null);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRateMetric$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            String string = ((MetricName)x0$1._1()).getName();
            String string2 = "MinFetchRate";
            return string != null && string.equals(string2);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRateMetric$2(Tuple2 x0$2) {
        if (x0$2 != null) {
            String string = ((MetricName)x0$2._1()).getName();
            String string2 = "MinFetchRate";
            return string != null && string.equals(string2);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRateMetric$3(MetricName k) {
        return k.getMBeanName().contains(FetcherPool.Default$.MODULE$.name()) || k.getMBeanName().contains(FetcherPool.InSync$.MODULE$.name());
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRateMetric$4(Tuple2 x0$3) {
        if (x0$3 != null) {
            String string = ((MetricName)x0$3._1()).getName();
            String string2 = "TotalFetchRate";
            return string != null && string.equals(string2);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRateMetric$5(Tuple2 x0$4) {
        if (x0$4 != null) {
            MetricName k = (MetricName)x0$4._1();
            String string = k.getName();
            String string2 = "MinFetchRate";
            return string != null && string.equals(string2) && k.getMBeanName().contains(FetcherPool.Default$.MODULE$.name());
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRateMetric$6(Tuple2 x0$5) {
        if (x0$5 != null) {
            MetricName k = (MetricName)x0$5._1();
            String string = k.getName();
            String string2 = "MinFetchRate";
            return string != null && string.equals(string2) && k.getMBeanName().contains(FetcherPool.InSync$.MODULE$.name());
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ TopicPartition $anonfun$testTotalLagMetric$1(int i) {
        return new TopicPartition("topic", i);
    }

    public static final /* synthetic */ FetcherLagMetrics $anonfun$testMigrateInSyncPartitions$1(ClientIdAndBroker metricId$2, TopicPartition k) {
        return new FetcherLagMetrics(new ClientIdTopicPartition(metricId$2.clientId(), k), (Map)Map$.MODULE$.empty());
    }

    private static final void verifyFetchState$1(AbstractFetcherThread fetcher, TopicPartition tp, Option expectedTopicId) {
        Option fetchState = fetcher.fetchState(tp);
        Assertions.assertTrue((boolean)fetchState.isDefined());
        Assertions.assertEquals((Object)expectedTopicId, (Object)((PartitionFetchState)fetchState.get()).topicId());
    }

    private static final void verifyFetchState$2(Option fetchState, Option expectedTopicId) {
        Assertions.assertTrue((boolean)fetchState.isDefined());
        Assertions.assertEquals((Object)expectedTopicId, (Object)((PartitionFetchState)fetchState.get()).topicId());
    }

    public static final /* synthetic */ void $anonfun$testResizeThreadPool$5(AbstractFetcherManagerTest $this, scala.collection.mutable.Set ownedPartitions$1, AbstractFetcherManager fetcherManager$1, int fetcherId$1, int brokerNum$1, int brokerId$1, TopicPartition tp) {
        ownedPartitions$1.$plus$eq((Object)tp);
        Assertions.assertEquals((int)fetcherManager$1.getFetcherId(tp), (int)fetcherId$1);
        Assertions.assertEquals((int)$this.getBrokerId(tp, brokerNum$1), (int)brokerId$1);
    }

    public static final /* synthetic */ void $anonfun$testResizeThreadPool$4(AbstractFetcherManagerTest $this, scala.collection.mutable.Set ownedPartitions$1, AbstractFetcherManager fetcherManager$1, int brokerNum$1, FetcherTag brokerIdAndFetcherId, AbstractFetcherThread fetcherThread) {
        int fetcherId = brokerIdAndFetcherId.fetcherId();
        int brokerId = brokerIdAndFetcherId.brokerId();
        fetcherThread.partitions().foreach((Function1 & Serializable)tp -> {
            AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$5($this, ownedPartitions$1, fetcherManager$1, fetcherId, brokerNum$1, brokerId, tp);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ scala.collection.mutable.Set $anonfun$makeTopicPartition$2(scala.collection.mutable.Set res$1, String topic$1, int j) {
        return (scala.collection.mutable.Set)res$1.$plus$eq((Object)new TopicPartition(topic$1, j));
    }

    public AbstractFetcherManagerTest() {
        this.fetchOffset = 10L;
        this.leaderEpoch = 15;
    }

    public static final /* synthetic */ Object $anonfun$testResizeThreadPool$2$adapted(AbstractFetcherManager fetcherManager$1, TopicPartition topicPartition) {
        fetcherManager$1.addFailedPartition(topicPartition);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testResizeThreadPool$3$adapted(AbstractFetcherManager fetcherManager$1, TopicPartition topicPartition) {
        fetcherManager$1.addFailedPartition(topicPartition);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testResizeThreadPool$4$adapted(AbstractFetcherManagerTest $this, scala.collection.mutable.Set ownedPartitions$1, AbstractFetcherManager fetcherManager$1, int brokerNum$1, FetcherTag brokerIdAndFetcherId, AbstractFetcherThread fetcherThread) {
        AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$4($this, ownedPartitions$1, fetcherManager$1, brokerNum$1, brokerIdAndFetcherId, fetcherThread);
        return BoxedUnit.UNIT;
    }

    private class MockResizeFetcherLeaderEndPoint
    implements LeaderEndPoint {
        private final BrokerEndPoint sourceBroker;
        private final boolean isTruncationOnFetchSupported;
        public final /* synthetic */ AbstractFetcherManagerTest $outer;

        public void initiateClose() {
        }

        public void close() {
        }

        public BrokerEndPoint brokerEndPoint() {
            return this.sourceBroker;
        }

        public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
            return new AbstractFetcherThread.ResultWithPartitions((Object)None$.MODULE$, (Map)Map$.MODULE$.empty());
        }

        public boolean isReadyForFetch(TopicPartition tp) {
            return true;
        }

        public OffsetAndEpoch fetchEarliestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
            return new OffsetAndEpoch(1L, 0);
        }

        public OffsetAndEpoch fetchLatestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
            return new OffsetAndEpoch(1L, 0);
        }

        public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
            return (Map)Map$.MODULE$.empty();
        }

        public TierOffsetInfo fetchTierMaterializationTarget(TopicPartition topicPartition, int currentLeaderEpoch) {
            throw new UnsupportedOperationException("fetchTierMaterializationTargetFromLeader is not supported in this test");
        }

        public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
            return (Map)Map$.MODULE$.empty();
        }

        public boolean isTruncationOnFetchSupported() {
            return this.isTruncationOnFetchSupported;
        }

        public OffsetAndEpoch fetchEarliestLocalOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
            return new OffsetAndEpoch(1L, 0);
        }

        public /* synthetic */ AbstractFetcherManagerTest kafka$server$AbstractFetcherManagerTest$MockResizeFetcherLeaderEndPoint$$$outer() {
            return this.$outer;
        }

        public MockResizeFetcherLeaderEndPoint(AbstractFetcherManagerTest $outer, BrokerEndPoint sourceBroker) {
            this.sourceBroker = sourceBroker;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.isTruncationOnFetchSupported = false;
        }
    }

    private class MockResizeFetcherTierStateMachine
    implements TierStateMachine {
        public PartitionFetchState start(TopicPartition topicPartition, PartitionFetchState currentFetchState, FetchResponseData.PartitionData fetchPartitionData) {
            throw new UnsupportedOperationException("Materializing tier state is not supported in this test.");
        }

        public Optional<PartitionFetchState> maybeAdvanceState(TopicPartition tp, PartitionFetchState currentFetchState) {
            return Optional.empty();
        }

        public /* synthetic */ AbstractFetcherManagerTest kafka$server$AbstractFetcherManagerTest$MockResizeFetcherTierStateMachine$$$outer() {
            return AbstractFetcherManagerTest.this;
        }

        public MockResizeFetcherTierStateMachine() {
            if (AbstractFetcherManagerTest.this == null) {
                throw null;
            }
        }
    }

    private class TestResizeFetcherThread
    extends AbstractFetcherThread {
        private final boolean isOffsetForLeaderEpochSupported;

        public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
            return None$.MODULE$;
        }

        public boolean truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
            return true;
        }

        public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        }

        public Option<Object> latestEpoch(TopicPartition topicPartition) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)0));
        }

        public long logStartOffset(TopicPartition topicPartition) {
            return 1L;
        }

        public long logEndOffset(TopicPartition topicPartition) {
            return 1L;
        }

        public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
            return new Some((Object)new OffsetAndEpoch(1L, 0));
        }

        public boolean isOffsetForLeaderEpochSupported() {
            return this.isOffsetForLeaderEpochSupported;
        }

        public /* synthetic */ AbstractFetcherManagerTest kafka$server$AbstractFetcherManagerTest$TestResizeFetcherThread$$$outer() {
            return AbstractFetcherManagerTest.this;
        }

        public TestResizeFetcherThread(MockResizeFetcherLeaderEndPoint leader, FailedPartitions failedPartitions, TierStateMachine fetchTierStateMachine) {
            if (AbstractFetcherManagerTest.this == null) {
                throw null;
            }
            ExponentialBackoff x$6 = new ExponentialBackoff(0L, 2, 1000L, 0.0);
            BrokerTopicStats x$7 = new BrokerTopicStats();
            boolean x$8 = true;
            Map x$9 = (Map)Map$.MODULE$.empty();
            super("test-resize-fetcher", "mock-fetcher", (LeaderEndPoint)leader, failedPartitions, x$6, fetchTierStateMachine, x$8, x$7, x$9);
            this.isOffsetForLeaderEpochSupported = false;
        }
    }
}

