/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.snapshot;

import java.util.Optional;
import kafka.restore.RestoreMetricsManager;
import kafka.restore.snapshot.SnapshotObjectStoreUtils;
import kafka.tier.store.TierObjectStore;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SnapshotObjectStoreUtilsTest {
    RestoreMetricsManager metricsManager = new RestoreMetricsManager(new Metrics(), "");

    @Test
    public void testParseTierPartitionSnapshotFilename() {
        String fileName = "4/Ho4CKf5fSIuleTlaONHlAw/0/6868b48b-48df-4b2a-9fe4-aae38955dea9_1663896002174_1_0_0_00000000000000000000.tierstate.snapshot.adler_v0.tier-partition-state-metadata-snapshot";
        SnapshotObjectStoreUtils util = new SnapshotObjectStoreUtils(null, null, null, "", (Time)new MockTime(), this.metricsManager);
        Optional meta = util.parseTierPartitionSnapshotFilename("test", fileName);
        Assertions.assertTrue((boolean)meta.isPresent());
        Assertions.assertEquals((Object)((TierObjectStore.TierPartitionStateSnapshotMetadata)meta.get()).topicIdPartition().kafkaTopicId().toString(), (Object)"Ho4CKf5fSIuleTlaONHlAw");
        Assertions.assertEquals((long)((TierObjectStore.TierPartitionStateSnapshotMetadata)meta.get()).snapshotObject().snapshotTimestampMs(), (long)Long.parseLong("1663896002174"));
    }
}

