/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.schedulers;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kafka.restore.configmap.NodeConfig;
import kafka.restore.schedulers.SchedulerUtil;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.util.EntityUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SchedulerUtilTest {
    @Test
    public void buildKafkaHttpRequest() throws IOException, URISyntaxException {
        Map<String, String> attributes = Stream.of({"topic_name", "test-topic"}, {"partition", "0"}).collect(Collectors.toMap(d -> d[0], d -> d[1]));
        NodeConfig broker = new NodeConfig(0, "kafka-0.kafka", 9080);
        HttpPost postReq = SchedulerUtil.buildKafkaHttpRequest((NodeConfig)broker, (String)"/v1/restore/ftps", attributes);
        Assertions.assertEquals((Object)"http://kafka-0.kafka:9080/v1/restore/ftps", (Object)postReq.getURI().toString());
        String content = EntityUtils.toString((HttpEntity)postReq.getEntity());
        Assertions.assertEquals((Object)"{\"partition\": \"0\",\"topic_name\": \"test-topic\"}", (Object)content);
    }
}

