/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore;

import java.util.Properties;
import kafka.restore.RestoreConfig;
import kafka.restore.RestoreMetricsManager;
import kafka.restore.RestoreMetricsUtil;
import kafka.restore.RestoreOrchestrator;
import kafka.restore.TestObjectsBuilder;
import kafka.restore.db.Job;
import kafka.restore.db.PartitionRestoreContext;
import kafka.restore.db.RestoreDB;
import kafka.restore.messages.KafkaFenceResponse;
import kafka.restore.messages.MessageRequest;
import kafka.restore.messages.MessageResponse;
import kafka.restore.messages.MessageResult;
import kafka.restore.messages.MessageStatusCode;
import kafka.restore.schedulers.AsyncTaskScheduler;
import kafka.restore.schedulers.KafkaManager;
import kafka.restore.schedulers.ObjectStoreManager;
import kafka.restore.statemachine.StateMachineController;
import kafka.restore.statemachine.api.FiniteStateMachine;
import kafka.restore.statemachine.api.State;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreOrchestratorTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestoreOrchestratorTest.class);

    @Test
    public void testOnePartitionTransitToFailed() throws Exception {
        Properties config = new Properties();
        config.setProperty(KafkaConfig.TierFeatureProp(), "true");
        config.setProperty(KafkaConfig.TierBackendProp(), "mock");
        RestoreConfig.getInstance().loadAdditionalProps(config);
        RestoreDB restoreDB = TestObjectsBuilder.buildRestoreDBWithOnePartition();
        Metrics metrics = RestoreMetricsUtil.initializeMetrics((KafkaConfig)RestoreConfig.kafkaConfig(), (Time)new MockTime(), (String)"pkc-test");
        RestoreMetricsManager restoreMetricsManager = new RestoreMetricsManager(metrics, "pkc-test");
        RestoreOrchestrator restoreOrchestrator = new RestoreOrchestrator(restoreMetricsManager, Time.SYSTEM);
        this.setAsyncServiceSchedulers(restoreOrchestrator);
        KafkaFenceResponse response = new KafkaFenceResponse(0, TestObjectsBuilder.topic, TestObjectsBuilder.partition, 0, null, MessageStatusCode.OBJECT_NOT_FOUND, MessageResult.FAILURE);
        restoreOrchestrator.startUp();
        restoreOrchestrator.runRestoreJob((Job)restoreDB.getJobs().get(restoreDB.getJobs().size() - 1));
        Thread.sleep(1000L);
        StateMachineController controller = restoreOrchestrator.stateMachineController();
        restoreOrchestrator.reportServiceSchedulerResponse((MessageResponse)response);
        Thread.sleep(1000L);
        Assertions.assertTrue((boolean)controller.isAllTasksDone());
        FiniteStateMachine fsm = controller.getFiniteStateMachineByTopicPartition(TestObjectsBuilder.buildTopicPartition());
        Assertions.assertNotNull((Object)fsm);
        Assertions.assertEquals((Object)State.FAILED, (Object)fsm.currentState());
        PartitionRestoreContext pctx = (PartitionRestoreContext)fsm.getMetadata("partition_restore_context");
        Assertions.assertNotNull((Object)pctx);
        Assertions.assertEquals((Object)PartitionRestoreContext.RestoreStatus.FAILED, (Object)pctx.status);
    }

    private void setAsyncServiceSchedulers(RestoreOrchestrator restoreOrchestrator) {
        KafkaManager kafkaManager = (KafkaManager)Mockito.mock(KafkaManager.class);
        restoreOrchestrator.setKafkaManager(kafkaManager);
        Mockito.when((Object)kafkaManager.startUp()).thenReturn((Object)true);
        Mockito.when((Object)kafkaManager.shutdown()).thenReturn((Object)true);
        Mockito.when((Object)kafkaManager.submitRequest((MessageRequest)Mockito.any())).thenReturn((Object)MessageStatusCode.SCHEDULED);
        AsyncTaskScheduler asyncTaskScheduler = (AsyncTaskScheduler)Mockito.mock(AsyncTaskScheduler.class);
        restoreOrchestrator.setAsyncTaskScheduler(asyncTaskScheduler);
        Mockito.when((Object)asyncTaskScheduler.startUp()).thenReturn((Object)true);
        Mockito.when((Object)asyncTaskScheduler.shutdown()).thenReturn((Object)true);
        Mockito.when((Object)asyncTaskScheduler.submitRequest((MessageRequest)Mockito.any())).thenReturn((Object)MessageStatusCode.SCHEDULED);
        ObjectStoreManager objectStoreManager = (ObjectStoreManager)Mockito.mock(ObjectStoreManager.class);
        restoreOrchestrator.setObjectStoreManager(objectStoreManager);
        Mockito.when((Object)objectStoreManager.startUp()).thenReturn((Object)true);
        Mockito.when((Object)objectStoreManager.shutdown()).thenReturn((Object)true);
        Mockito.when((Object)objectStoreManager.submitRequest((MessageRequest)Mockito.any())).thenReturn((Object)MessageStatusCode.SCHEDULED);
    }
}

