/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLSession;
import javax.security.auth.login.Configuration;
import javax.security.sasl.SaslServer;
import kafka.cluster.EndPoint;
import kafka.network.LinkComponents;
import kafka.network.RequestChannel;
import kafka.network.SocketServer;
import kafka.network.TestInterceptor;
import kafka.network.TestInterceptor$;
import kafka.network.TestPrincipal;
import kafka.network.TooManyConnectionsException;
import kafka.security.CredentialProvider;
import kafka.server.ActionQueue;
import kafka.server.ApiVersionManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.SimpleApiVersionManager;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.Logging;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.ReverseConnectionRequestData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ByteBufferSend;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.RequestCallback;
import org.apache.kafka.common.network.ReverseChannel;
import org.apache.kafka.common.network.ReverseNode;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.requests.ReverseConnectionRequest;
import org.apache.kafka.common.requests.ReverseConnectionResponse;
import org.apache.kafka.common.security.DefaultRequestCallbackManager;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.ConfluentPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.PlaintextAuthenticationContext;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.auth.SslAuthenticationContext;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.authenticator.LoginManager;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.security.scram.internals.ScramFormatter;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.server.audit.NoOpAuditLogProvider;
import org.apache.kafka.server.common.Features;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.test.TestUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0011Ee\u0001\u0002(P\u0001QCQa\u0017\u0001\u0005\u0002qCqa\u0018\u0001C\u0002\u0013%\u0001\r\u0003\u0004h\u0001\u0001\u0006I!\u0019\u0005\bQ\u0002\u0011\r\u0011\"\u0003j\u0011\u00199\b\u0001)A\u0005U\"9\u0001\u0010\u0001b\u0001\n\u0013I\bbBA\u0006\u0001\u0001\u0006IA\u001f\u0005\n\u0003\u001b\u0001!\u0019!C\u0005\u0003\u001fA\u0001\"a\f\u0001A\u0003%\u0011\u0011\u0003\u0005\n\u0003c\u0001!\u0019!C\u0005\u0003gA\u0001\"!\u0012\u0001A\u0003%\u0011Q\u0007\u0005\n\u0003\u000f\u0002!\u0019!C\u0005\u0003\u0013B\u0001\"a\u0016\u0001A\u0003%\u00111\n\u0005\n\u00033\u0002!\u0019!C\u0005\u00037B\u0001\"a\u0019\u0001A\u0003%\u0011Q\f\u0005\n\u0003K\u0002!\u0019!C\u0005\u0003OB\u0001\"!!\u0001A\u0003%\u0011\u0011\u000e\u0005\n\u0003\u0007\u0003!\u0019!C\u0005\u0003OB\u0001\"!\"\u0001A\u0003%\u0011\u0011\u000e\u0005\b\u0003\u000f\u0003A\u0011AAE\u0011\u001d\t9\u000b\u0001C\u0001\u0003\u0013Cq!!-\u0001\t\u0003\tI\tC\u0004\u0002<\u0002!\t!!#\t\u000f\u0005}\u0006\u0001\"\u0001\u0002\n\"9\u00111\u0019\u0001\u0005\u0002\u0005%\u0005bBAd\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u0003\u0017\u0004A\u0011AAE\u0011\u001d\ty\r\u0001C\u0001\u0003\u0013Cq!a5\u0001\t\u0003\tI\tC\u0004\u0002X\u0002!\t!!#\t\u000f\u0005m\u0007\u0001\"\u0001\u0002\n\"9\u0011q\u001c\u0001\u0005\u0002\u0005%\u0005bBAr\u0001\u0011%\u0011Q\u001d\u0005\b\u0003c\u0004A\u0011AAE\u0011\u001d\t)\u0010\u0001C\u0001\u0003\u0013Cq!!?\u0001\t\u0003\tI\tC\u0004\u0002~\u0002!\t!!#\t\u000f\t\u0005\u0001\u0001\"\u0001\u0002\n\"9!Q\u0001\u0001\u0005\n\t\u001d\u0001b\u0002B\u0003\u0001\u0011%!Q\u0004\u0005\b\u0005O\u0001A\u0011\u0002B\u0015\u0011\u001d\u0011y\u0003\u0001C\u0005\u0005cAqA!\u000e\u0001\t\u0013\u00119\u0004C\u0004\u0003\u0006\u0001!IA!\u0012\t\u0013\t=\u0004!%A\u0005\n\tE\u0004\"\u0003BD\u0001E\u0005I\u0011\u0002BE\u0011\u001d\u0011i\t\u0001C\u0005\u0005\u001fCqAa(\u0001\t\u0013\u0011\t\u000bC\u0004\u0003(\u0002!IA!+\t\u0013\t\u0005\b!%A\u0005\n\t\r\b\"\u0003Bt\u0001E\u0005I\u0011\u0002Bu\u0011\u001d\u0011i\u000f\u0001C\u0005\u0005_DqAa=\u0001\t\u0013\u0011)\u0010C\u0004\u0003z\u0002!IAa?\t\u000f\r\r\u0001\u0001\"\u0003\u0004\u0006!911\u0003\u0001\u0005\n\rU\u0001bBB\u0013\u0001\u0011%1q\u0005\u0005\b\u0007W\u0001A\u0011BB\u0017\u0011\u001d\u0019)\t\u0001C\u0005\u0007\u000fC\u0011b!*\u0001#\u0003%Iaa*\t\u000f\r-\u0006\u0001\"\u0003\u0004.\"I11\u0019\u0001\u0012\u0002\u0013%!\u0011\u000f\u0005\b\u0007\u000b\u0004A\u0011BBd\u0011\u001d\u0019)\u000e\u0001C\u0005\u0007/Dqa!9\u0001\t\u0013\u0019\u0019\u000fC\u0004\u0004v\u0002!Iaa>\t\u000f\u0011%\u0001\u0001\"\u0003\u0005\f!9A1\u0003\u0001\u0005\n\u0011U\u0001b\u0002C\u0012\u0001\u0011%AQ\u0005\u0005\n\t{\u0001\u0011\u0013!C\u0005\t\u007fA\u0011\u0002b\u0013\u0001#\u0003%IA!\u001d\t\u000f\u00115\u0003\u0001\"\u0003\u0005P!9A\u0011\r\u0001\u0005\n\u0011\r\u0004b\u0002C:\u0001\u0011%AQ\u000f\u0005\b\ts\u0002A\u0011\u0002C>\u0011\u001d!)\t\u0001C\u0005\t\u000fCq\u0001b#\u0001\t\u0013!iIA\u000bSKZ,'o]3D_:tWm\u0019;j_:$Vm\u001d;\u000b\u0005A\u000b\u0016a\u00028fi^|'o\u001b\u0006\u0002%\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001V!\t1\u0016,D\u0001X\u0015\u0005A\u0016!B:dC2\f\u0017B\u0001.X\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u0018\t\u0003=\u0002i\u0011aT\u0001\u0013GJ,G-\u001a8uS\u0006d\u0007K]8wS\u0012,'/F\u0001b!\t\u0011W-D\u0001d\u0015\t!\u0017+\u0001\u0005tK\u000e,(/\u001b;z\u0013\t17M\u0001\nDe\u0016$WM\u001c;jC2\u0004&o\u001c<jI\u0016\u0014\u0018aE2sK\u0012,g\u000e^5bYB\u0013xN^5eKJ\u0004\u0013\u0001\u0002;j[\u0016,\u0012A\u001b\t\u0003WVl\u0011\u0001\u001c\u0006\u0003[:\fQ!\u001e;jYNT!a\u001c9\u0002\r\r|W.\\8o\u0015\t\u0011\u0016O\u0003\u0002sg\u00061\u0011\r]1dQ\u0016T\u0011\u0001^\u0001\u0004_J<\u0017B\u0001<m\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u000fM,'O^3sgV\t!\u0010E\u0003|\u0003\u0003\t)!D\u0001}\u0015\tih0A\u0004nkR\f'\r\\3\u000b\u0005}<\u0016AC2pY2,7\r^5p]&\u0019\u00111\u0001?\u0003\r\t+hMZ3s!\rq\u0016qA\u0005\u0004\u0003\u0013y%\u0001D*pG.,GoU3sm\u0016\u0014\u0018\u0001C:feZ,'o\u001d\u0011\u0002\u001d9,Go^8sW\u000ec\u0017.\u001a8ugV\u0011\u0011\u0011\u0003\t\bw\u0006M\u0011qCA\u0012\u0013\r\t)\u0002 \u0002\u0004\u001b\u0006\u0004\b\u0003BA\r\u0003?i!!a\u0007\u000b\u0007\u0005u\u0001/A\u0004dY&,g\u000e^:\n\t\u0005\u0005\u00121\u0004\u0002\u000e\u001d\u0016$xo\u001c:l\u00072LWM\u001c;\u0011\t\u0005\u0015\u00121F\u0007\u0003\u0003OQ1!!\u000bo\u0003\u001diW\r\u001e:jGNLA!!\f\u0002(\t9Q*\u001a;sS\u000e\u001c\u0018a\u00048fi^|'o[\"mS\u0016tGo\u001d\u0011\u0002\u000b1Lgn[:\u0016\u0005\u0005U\u0002cB>\u0002\u0014\u0005]\u0012q\b\t\u0005\u0003s\tY$D\u0001o\u0013\r\tiD\u001c\u0002\u0005+VLG\rE\u0002_\u0003\u0003J1!a\u0011P\u00059a\u0015N\\6D_6\u0004xN\\3oiN\fa\u0001\\5oWN\u0004\u0013aC6bM.\fGj\\4hKJ,\"!a\u0013\u0011\t\u00055\u00131K\u0007\u0003\u0003\u001fR1!!\u0015r\u0003\u0015awn\u001a\u001bk\u0013\u0011\t)&a\u0014\u0003\r1{wmZ3s\u00031Y\u0017MZ6b\u0019><w-\u001a:!\u0003Eawn\u001a'fm\u0016dGk\u001c*fgR|'/Z\u000b\u0003\u0003;\u0002B!!\u0014\u0002`%!\u0011\u0011MA(\u0005\u0015aUM^3m\u0003Iawn\u001a'fm\u0016dGk\u001c*fgR|'/\u001a\u0011\u0002=\u0005\u001cG/\u001b<f'>,(oY3SKZ,'o]3D_:tWm\u0019;j_:\u001cXCAA5!\u0011\tY'! \u000e\u0005\u00055$\u0002BA8\u0003c\na!\u0019;p[&\u001c'\u0002BA:\u0003k\n!bY8oGV\u0014(/\u001a8u\u0015\u0011\t9(!\u001f\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003w\nAA[1wC&!\u0011qPA7\u00055\tEo\\7jG&sG/Z4fe\u0006y\u0012m\u0019;jm\u0016\u001cv.\u001e:dKJ+g/\u001a:tK\u000e{gN\\3di&|gn\u001d\u0011\u00029\u0005\u001cG/\u001b<f\t\u0016\u001cHOU3wKJ\u001cXmQ8o]\u0016\u001cG/[8og\u0006i\u0012m\u0019;jm\u0016$Um\u001d;SKZ,'o]3D_:tWm\u0019;j_:\u001c\b%A\u0003tKR,\u0006\u000f\u0006\u0002\u0002\fB\u0019a+!$\n\u0007\u0005=uK\u0001\u0003V]&$\bf\u0001\u000b\u0002\u0014B!\u0011QSAR\u001b\t\t9J\u0003\u0003\u0002\u001a\u0006m\u0015aA1qS*!\u0011QTAP\u0003\u001dQW\u000f]5uKJT1!!)t\u0003\u0015QWO\\5u\u0013\u0011\t)+a&\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\r)\u00121\u0016\t\u0005\u0003+\u000bi+\u0003\u0003\u00020\u0006]%!C!gi\u0016\u0014X)Y2i\u0003E!Xm\u001d;OKR<xN]6DY&,g\u000e\u001e\u0015\u0004-\u0005U\u0006\u0003BAK\u0003oKA!!/\u0002\u0018\n!A+Z:u\u0003y!Xm\u001d;SKZ,'o]3QY\u0006Lg\u000e^3yi\u000e{gN\\3di&|g\u000eK\u0002\u0018\u0003k\u000b\u0001\u0004^3tiJ+g/\u001a:tKN\u001bHnQ8o]\u0016\u001cG/[8oQ\rA\u0012QW\u0001#i\u0016\u001cHOU3wKJ\u001cXmU1tYBc\u0017-\u001b8uKb$8i\u001c8oK\u000e$\u0018n\u001c8)\u0007e\t),\u0001\u000fuKN$(+\u001a<feN,7+Y:m'Nd7i\u001c8oK\u000e$\u0018n\u001c8)\u0007i\t),A\u0016uKN$(+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8XSRD7i\u001c8gYV,g\u000e\u001e)sS:\u001c\u0017\u000e]1mQ\rY\u0012QW\u00010i\u0016\u001cHOU3wKJ\u001cXmQ8o]\u0016\u001cG/[8o/&$\b\u000e\u00157bS:$X\r\u001f;T_V\u00148-Z*tY\u0012+7\u000f\u001e\u0015\u00049\u0005U\u0016\u0001\r;fgR\u0014VM^3sg\u0016\u001cuN\u001c8fGRLwN\\,ji\"$\u0015N\u001a4fe\u0016tGoU1tY6+7\r[1oSNl7\u000fK\u0002\u001e\u0003k\u000b\u0011\u0004^3ti\u0006+H\u000f[3oi&\u001c\u0017\r^5p]\u001a\u000b\u0017\u000e\\;sK\"\u001aa$!.\u0002]Q,7\u000f^*pkJ\u001cWM\u0011:pW\u0016\u0014\u0018J\u001c;fe\u000e,\u0007\u000f^8s/&$\bnU3sm\u0016\u00148+\u001b3f\u00072|7/\u001a\u0015\u0004?\u0005U\u0016A\f;fgR\u001cv.\u001e:dK\n\u0013xn[3s\u0013:$XM]2faR|'oV5uQ\u000ec\u0017.\u001a8u'&$Wm\u00117pg\u0016D3\u0001IA[\u0003u1XM]5gsN{WO]2f\u0005J|7.\u001a:J]R,'oY3qi>\u0014H\u0003BAF\u0003ODq!!;\"\u0001\u0004\tY/A\bdY>\u001cXmU3sm\u0016\u00148+\u001b3f!\r1\u0016Q^\u0005\u0004\u0003_<&a\u0002\"p_2,\u0017M\\\u0001!i\u0016\u001cH\u000fR3ti&t\u0017\r^5p]\n\u0013xn[3s\u0013:$XM]2faR|'\u000fK\u0002#\u0003k\u000bq\u0005^3tiJ+g/\u001a:tK\u000e{gN\\3di&|gn\u001d+p\u001bVdG/\u001b9mKN+'O^3sg\"\u001a1%!.\u0002SQ,7\u000f\u001e*fm\u0016\u00148/Z\"p]:,7\r^5p]N4%o\\7Nk2$\u0018\u000e\u001d7f'\u0016\u0014h/\u001a:tQ\r!\u0013QW\u00011i\u0016\u001cH/T;mi&\u0004H.\u001a*fm\u0016\u00148/Z\"p]:,7\r^5p]N\u0014U\r^<fK:\u001c\u0016-\\3TKJ4XM]:)\u0007\u0015\n),A\nuKN$8i\u001c8oK\u000e$\u0018n\u001c8MS6LG\u000fK\u0002'\u0003k\u000bqC^3sS\u001aL(+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8\u0015\r\u0005-%\u0011\u0002B\r\u0011\u001d\u0011Ya\na\u0001\u0005\u001b\t!c]8ve\u000e,7+\u001a:wKJ\u001cuN\u001c4jOB!!q\u0002B\u000b\u001b\t\u0011\tBC\u0002\u0003\u0014E\u000baa]3sm\u0016\u0014\u0018\u0002\u0002B\f\u0005#\u00111bS1gW\u0006\u001cuN\u001c4jO\"9!1D\u0014A\u0002\t5\u0011\u0001\u00053fgR\u001cVM\u001d<fe\u000e{gNZ5h)!\tYIa\b\u0003\"\t\r\u0002b\u0002B\u0006Q\u0001\u0007!Q\u0002\u0005\b\u00057A\u0003\u0019\u0001B\u0007\u0011\u001d\u0011)\u0003\u000ba\u0001\u0003W\f\u0001c\u00197pg\u0016\u001cE.[3oi\u001aK'o\u001d;\u0002MY,'/\u001b4z\u00072|7/Z\"mS\u0016tGoU5eKJ+g/\u001a:tK\u000e{gN\\3di&|g\u000e\u0006\u0003\u0002\f\n-\u0002b\u0002B\u0017S\u0001\u0007\u0011qH\u0001\u0005Y&t7.\u0001\u0014wKJLg-_\"m_N,7+\u001a:wKJ\u001c\u0016\u000eZ3SKZ,'o]3D_:tWm\u0019;j_:$B!a#\u00034!9!Q\u0006\u0016A\u0002\u0005}\u0012!E2sK\u0006$X\rT5oW\u000ec\u0017.\u001a8ugRA\u0011q\bB\u001d\u0005{\u0011\t\u0005C\u0004\u0003<-\u0002\r!a\u000e\u0002\r1Lgn[%e\u0011\u001d\u0011yd\u000ba\u0001\u0003\u000b\tAb]8ve\u000e,7+\u001a:wKJDqAa\u0011,\u0001\u0004\t)!\u0001\u0006eKN$8+\u001a:wKJ$B\"a\u0010\u0003H\t%#1\nB'\u0005KBqAa\u000f-\u0001\u0004\t9\u0004C\u0004\u0003@1\u0002\r!!\u0002\t\u000f\t\rC\u00061\u0001\u0002\u0006!I!q\n\u0017\u0011\u0002\u0003\u0007!\u0011K\u0001\raJLgnY5qC2|\u0005\u000f\u001e\t\u0006-\nM#qK\u0005\u0004\u0005+:&AB(qi&|g\u000e\u0005\u0003\u0003Z\t\u0005TB\u0001B.\u0015\u0011\u0011iFa\u0018\u0002\t\u0005,H\u000f\u001b\u0006\u0003I:LAAa\u0019\u0003\\\tq1*\u00194lCB\u0013\u0018N\\2ja\u0006d\u0007\"\u0003B4YA\u0005\t\u0019\u0001B5\u0003-qW/\u001c*fcV,7\u000f^:\u0011\u0007Y\u0013Y'C\u0002\u0003n]\u00131!\u00138u\u0003\u00052XM]5gsJ+g/\u001a:tK\u000e{gN\\3di&|g\u000e\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011\u0019H\u000b\u0003\u0003R\tU4F\u0001B<!\u0011\u0011IHa!\u000e\u0005\tm$\u0002\u0002B?\u0005\u007f\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u0005u+\u0001\u0006b]:|G/\u0019;j_:LAA!\"\u0003|\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002CY,'/\u001b4z%\u00164XM]:f\u0007>tg.Z2uS>tG\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\t-%\u0006\u0002B5\u0005k\nAd^1ji\u001a{'oQ8o]\u0016\u001cG/[8o\u0007>,h\u000e^'fiJL7\r\u0006\u0004\u0002\f\nE%Q\u0013\u0005\b\u0005'{\u0003\u0019AA\u0003\u00031\u0019xnY6fiN+'O^3s\u0011\u001d\u00119j\fa\u0001\u00053\u000bQ\"\u001a=qK\u000e$X\r\u001a,bYV,\u0007c\u0001,\u0003\u001c&\u0019!QT,\u0003\t1{gnZ\u0001#o\u0006LGOR8s\u0007&\u0004\b.\u001a:D_:tWm\u0019;j_:\u001cu.\u001e8u\u001b\u0016$(/[2\u0015\r\u0005-%1\u0015BS\u0011\u001d\u0011\u0019\n\ra\u0001\u0003\u000bAqAa&1\u0001\u0004\u0011I*A\u0006lC\u001a\\\u0017mQ8oM&<GC\u0003B\u0007\u0005W\u0013yK!/\u0003V\"9!QV\u0019A\u0002\t%\u0014\u0001\u00032s_.,'/\u00133\t\u000f\tE\u0016\u00071\u0001\u00034\u0006\u00012/Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\t\u0005\u00053\u0012),\u0003\u0003\u00038\nm#\u0001E*fGV\u0014\u0018\u000e^=Qe>$xnY8m\u0011%\u0011Y,\rI\u0001\u0002\u0004\u0011i,A\u0007tCNdW*Z2iC:L7/\u001c\t\u0006-\nM#q\u0018\t\u0005\u0005\u0003\u0014yM\u0004\u0003\u0003D\n-\u0007c\u0001Bc/6\u0011!q\u0019\u0006\u0004\u0005\u0013\u001c\u0016A\u0002\u001fs_>$h(C\u0002\u0003N^\u000ba\u0001\u0015:fI\u00164\u0017\u0002\u0002Bi\u0005'\u0014aa\u0015;sS:<'b\u0001Bg/\"I!q[\u0019\u0011\u0002\u0003\u0007!\u0011\\\u0001\u000bKb$(/\u0019)s_B\u001c\b\u0003\u0002Bn\u0005;l!!!\u001e\n\t\t}\u0017Q\u000f\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!F6bM.\f7i\u001c8gS\u001e$C-\u001a4bk2$HeM\u000b\u0003\u0005KTCA!0\u0003v\u0005)2.\u00194lC\u000e{gNZ5hI\u0011,g-Y;mi\u0012\"TC\u0001BvU\u0011\u0011IN!\u001e\u0002)Ad\u0017-\u001b8uKb$8+\u001a:wKJ\u0004&o\u001c9t)\u0011\u0011IN!=\t\u000f\t5F\u00071\u0001\u0003j\u0005q1o\u001d7TKJ4XM\u001d)s_B\u001cH\u0003\u0002Bm\u0005oDqA!,6\u0001\u0004\u0011I'A\btCNd7+\u001a:wKJ\u0004&o\u001c9t)!\u0011IN!@\u0003\u0000\u000e\u0005\u0001b\u0002BWm\u0001\u0007!\u0011\u000e\u0005\b\u0005c3\u0004\u0019\u0001BZ\u0011\u001d\u0011YL\u000ea\u0001\u0005{\u000bA\"\u00193e'\u000e\u0014\u0018-\\+tKJ$\u0002\"a#\u0004\b\r-1q\u0002\u0005\b\u0007\u00139\u0004\u0019\u0001B`\u0003%iWm\u00195b]&\u001cX\u000eC\u0004\u0004\u000e]\u0002\rAa0\u0002\u0011U\u001cXM\u001d8b[\u0016Dqa!\u00058\u0001\u0004\u0011y,\u0001\u0005qCN\u001cxo\u001c:e\u00031a\u0017n\u001d;f]\u0016\u0014h*Y7f)\u0011\u00199b!\t\u0011\t\re1QD\u0007\u0003\u00077Q!\u0001\u00158\n\t\r}11\u0004\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.\u001a\u0005\b\u0007GA\u0004\u0019\u0001B\u0007\u0003\u0019\u0019wN\u001c4jO\u0006ya.Z<T_\u000e\\W\r^*feZ,'\u000f\u0006\u0003\u0002\u0006\r%\u0002bBB\u0012s\u0001\u0007!QB\u0001\u0011]\u0016<8\t\\5f]R\u0014V-];fgR$\"ba\f\u00046\re2QHB7!\u0011\tIb!\r\n\t\rM\u00121\u0004\u0002\u000e\u00072LWM\u001c;SKF,Xm\u001d;\t\u000f\r]\"\b1\u0001\u0002\u0018\u0005ia.\u001a;x_J\\7\t\\5f]RDqaa\u000f;\u0001\u0004\u0011y,\u0001\u0004o_\u0012,\u0017\n\u001a\u0005\b\u0007\u007fQ\u0004\u0019AB!\u0003\u001d\u0011W/\u001b7eKJ\u0004Daa\u0011\u0004\\A11QIB)\u0007/rAaa\u0012\u0004N5\u00111\u0011\n\u0006\u0004\u0007\u0017r\u0017\u0001\u0003:fcV,7\u000f^:\n\t\r=3\u0011J\u0001\u0010\u0003\n\u001cHO]1diJ+\u0017/^3ti&!11KB+\u0005\u001d\u0011U/\u001b7eKJTAaa\u0014\u0004JA!1\u0011LB.\u0019\u0001!Ab!\u0018\u0004>\u0005\u0005\t\u0011!B\u0001\u0007?\u00121a\u0018\u00132#\u0011\u0019\tga\u001a\u0011\u0007Y\u001b\u0019'C\u0002\u0004f]\u0013qAT8uQ&tw\rE\u0002W\u0007SJ1aa\u001bX\u0005\r\te.\u001f\u0005\b\u0007_R\u0004\u0019AB9\u0003\u00191W\u000f^;sKB111OB;\u0007sj!!!\u001d\n\t\r]\u0014\u0011\u000f\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007\u0003BB>\u0007\u0003k!a! \u000b\t\r}\u0014\u0011P\u0001\u0005Y\u0006tw-\u0003\u0003\u0004\u0004\u000eu$\u0001\u0002,pS\u0012\faB]3dK&4XMU3rk\u0016\u001cH\u000f\u0006\u0004\u0004\n\u000e]5\u0011\u0015\t\u0005\u0007\u0017\u001b\tJD\u0002_\u0007\u001bK1aa$P\u00039\u0011V-];fgR\u001c\u0005.\u00198oK2LAaa%\u0004\u0016\n9!+Z9vKN$(bABH\u001f\"91\u0011T\u001eA\u0002\rm\u0015aB2iC:tW\r\u001c\t\u0004=\u000eu\u0015bABP\u001f\nq!+Z9vKN$8\t[1o]\u0016d\u0007\"CBRwA\u0005\t\u0019\u0001BM\u0003\u001d!\u0018.\\3pkR\f\u0001D]3dK&4XMU3rk\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019IK\u000b\u0003\u0003\u001a\nU\u0014A\u00059s_\u000e,7o\u001d(fqR\u0014V-];fgR$\"\"a#\u00040\u000eE6QWB`\u0011\u001d\u0011\u0019\"\u0010a\u0001\u0003\u000bAqaa->\u0001\u0004\t9\"\u0001\u0004dY&,g\u000e\u001e\u0005\b\u0007ok\u0004\u0019AB]\u0003\u0011qw\u000eZ3\u0011\t\u0005e21X\u0005\u0004\u0007{s'\u0001\u0002(pI\u0016D\u0011b!1>!\u0003\u0005\rA!\u0015\u0002#\u0015D\b/Z2uK\u0012\u0004&/\u001b8dSB\fG.\u0001\u000fqe>\u001cWm]:OKb$(+Z9vKN$H\u0005Z3gCVdG\u000f\n\u001b\u0002-5,G/\u00193bi\u0006\u0014V-];fgR\u0014U/\u001b7eKJ,\"a!3\u0011\t\r-7\u0011\u001b\b\u0005\u0007\u000f\u001ai-\u0003\u0003\u0004P\u000e%\u0013aD'fi\u0006$\u0017\r^1SKF,Xm\u001d;\n\t\rM31\u001b\u0006\u0005\u0007\u001f\u001cI%A\bnKR\fG-\u0019;b+B$\u0017\r^3s)\u0011\u0019Ina8\u0011\t\u0005e11\\\u0005\u0005\u0007;\fYBA\u000bNC:,\u0018\r\\'fi\u0006$\u0017\r^1Va\u0012\fG/\u001a:\t\u000f\r]\u0006\t1\u0001\u0004:\u0006\u0001b.Z<OKR<xN]6DY&,g\u000e\u001e\u000b\t\u0003/\u0019)o!;\u0004n\"91q]!A\u0002\u0005\u0015\u0011\u0001\u0004:f[>$XmU3sm\u0016\u0014\bbBBv\u0003\u0002\u0007\u0011QA\u0001\fY>\u001c\u0017\r\\*feZ,'\u000fC\u0004\u0004V\u0006\u0003\raa<\u0011\t\u0005e1\u0011_\u0005\u0005\u0007g\fYBA\bNKR\fG-\u0019;b+B$\u0017\r^3s\u000359\u0018-\u001b;G_J\u001cE.[3oiRA\u00111RB}\u0007w$)\u0001C\u0004\u00044\n\u0003\r!a\u0006\t\u000f\ru(\t1\u0001\u0004\u0000\u0006I\u0001O]3eS\u000e\fG/\u001a\t\b-\u0012\u0005\u0011qCAv\u0013\r!\u0019a\u0016\u0002\n\rVt7\r^5p]FBq\u0001b\u0002C\u0001\u0004\u0011y,\u0001\u0007feJ|'/T3tg\u0006<W-\u0001\u0007xC&$hi\u001c:SK\u0006$\u0017\u0010\u0006\u0005\u0002\f\u00125Aq\u0002C\t\u0011\u001d\u0019\u0019l\u0011a\u0001\u0003/AqAa\u0005D\u0001\u0004\t)\u0001C\u0004\u00048\u000e\u0003\ra!/\u0002\u001f]\f\u0017\u000e\u001e$peJ+g/\u001a:tC2$\u0002\"a#\u0005\u0018\u0011eA1\u0004\u0005\b\u0007g#\u0005\u0019AA\f\u0011\u001d\u0011\u0019\u0002\u0012a\u0001\u0003\u000bAqaa.E\u0001\u0004!i\u0002\u0005\u0003\u0004\u001a\u0011}\u0011\u0002\u0002C\u0011\u00077\u00111BU3wKJ\u001cXMT8eK\u0006q1/\u001a8e\u0003:$'+Z2fSZ,G\u0003DAF\tO!I\u0003b\u000b\u0005.\u0011m\u0002bBBZ\u000b\u0002\u0007\u0011q\u0003\u0005\b\u0005')\u0005\u0019AA\u0003\u0011\u001d\u00199,\u0012a\u0001\u0007sC\u0011\u0002b\fF!\u0003\u0005\r\u0001\"\r\u0002\u001dI,\u0017/^3ti\n+\u0018\u000e\u001c3feB\"A1\u0007C\u001c!\u0019\u0019)e!\u0015\u00056A!1\u0011\fC\u001c\t1!I\u0004\"\f\u0002\u0002\u0003\u0005)\u0011AB0\u0005\ryFE\r\u0005\n\u0007\u0003,\u0005\u0013!a\u0001\u0005#\n\u0001d]3oI\u0006sGMU3dK&4X\r\n3fM\u0006,H\u000e\u001e\u00135+\t!\t\u0005\r\u0003\u0005D\u0011%#\u0006\u0002C#\u0005k\u0002ba!\u0012\u0004R\u0011\u001d\u0003\u0003BB-\t\u0013\"1\u0002\"\u000fG\u0003\u0003\u0005\tQ!\u0001\u0004`\u0005A2/\u001a8e\u0003:$'+Z2fSZ,G\u0005Z3gCVdG\u000fJ\u001b\u0002\u0019I,g/\u001a:tC2$\u0015\r^1\u0015\r\u0011ECQ\fC0!\u0011!\u0019\u0006\"\u0017\u000e\u0005\u0011U#b\u0001C,]\u00069Q.Z:tC\u001e,\u0017\u0002\u0002C.\t+\u0012ADU3wKJ\u001cXmQ8o]\u0016\u001cG/[8o%\u0016\fX/Z:u\t\u0006$\u0018\rC\u0004\u0003<!\u0003\r!a\u000e\t\u000f\t}\u0002\n1\u0001\u0002\u0006\u0005IrN\u001c*fm\u0016\u00148/Z\"mS\u0016tGoQ8o]\u0016\u001cG/[8o)\u0019\tY\t\"\u001a\u0005p!9AqM%A\u0002\u0011%\u0014!D:pkJ\u001cWm\u00115b]:,G\u000e\u0005\u0003\u0004\u001a\u0011-\u0014\u0002\u0002C7\u00077\u0011AbS1gW\u0006\u001c\u0005.\u00198oK2Dq\u0001\"\u001dJ\u0001\u0004!i\"A\u0006sKZ,'o]3O_\u0012,\u0017!\u00039sS:\u001c\u0017\u000e]1m)\u0011\u00119\u0006b\u001e\t\u000f\tM!\n1\u0001\u0002\u0006\u0005)\u0012-\u001e;iK:$\u0018nY1uS>t7i\u001c8uKb$H\u0003\u0002C?\t\u0007\u0003BA!\u0017\u0005\u0000%!A\u0011\u0011B.\u0005U\tU\u000f\u001e5f]RL7-\u0019;j_:\u001cuN\u001c;fqRDqAa\u0005L\u0001\u0004\t)!\u0001\rtQV$Hm\\<o'\u0016\u0014h/\u001a:B]\u0012lU\r\u001e:jGN$B!a#\u0005\n\"9!1\u0003'A\u0002\u0005\u0015\u0011\u0001\u0007<fe&4\u0017PT3uo>\u00148n\u00117jK:$X)\u001c9usR!\u00111\u0012CH\u0011\u001d\u0019\u0019,\u0014a\u0001\u0003/\u0001")
public class ReverseConnectionTest {
    private final CredentialProvider credentialProvider = new CredentialProvider(ScramMechanism.mechanismNames(), null);
    private final Time time = Time.SYSTEM;
    private final Buffer<SocketServer> servers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final scala.collection.mutable.Map<NetworkClient, Metrics> networkClients = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final scala.collection.mutable.Map<Uuid, LinkComponents> kafka$network$ReverseConnectionTest$$links = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final Logger kafkaLogger = LogManager.getLogger((String)"kafka");
    private final Level logLevelToRestore = this.kafkaLogger().getLevel();
    private final AtomicInteger activeSourceReverseConnections = new AtomicInteger();
    private final AtomicInteger kafka$network$ReverseConnectionTest$$activeDestReverseConnections = new AtomicInteger();

    private CredentialProvider credentialProvider() {
        return this.credentialProvider;
    }

    private Time time() {
        return this.time;
    }

    private Buffer<SocketServer> servers() {
        return this.servers;
    }

    private scala.collection.mutable.Map<NetworkClient, Metrics> networkClients() {
        return this.networkClients;
    }

    public scala.collection.mutable.Map<Uuid, LinkComponents> kafka$network$ReverseConnectionTest$$links() {
        return this.kafka$network$ReverseConnectionTest$$links;
    }

    private Logger kafkaLogger() {
        return this.kafkaLogger;
    }

    private Level logLevelToRestore() {
        return this.logLevelToRestore;
    }

    private AtomicInteger activeSourceReverseConnections() {
        return this.activeSourceReverseConnections;
    }

    public AtomicInteger kafka$network$ReverseConnectionTest$$activeDestReverseConnections() {
        return this.kafka$network$ReverseConnectionTest$$activeDestReverseConnections;
    }

    @BeforeEach
    public void setUp() {
        TestUtils$.MODULE$.clearYammerMetrics();
        this.kafkaLogger().setLevel(Level.TRACE);
    }

    @AfterEach
    public void tearDown() {
        this.networkClients().foreach((Function1 & Serializable)x0$1 -> {
            ReverseConnectionTest.$anonfun$tearDown$1(x0$1);
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable)server -> {
            this.shutdownServerAndMetrics(server);
            return BoxedUnit.UNIT;
        });
        this.kafkaLogger().setLevel(this.logLevelToRestore());
        LoginManager.closeAll();
        Configuration.setConfiguration(null);
    }

    @Test
    public void testNetworkClient() {
        int nodeId = 1;
        KafkaConfig config = this.kafkaConfig(nodeId, SecurityProtocol.SASL_SSL, (Option<String>)None$.MODULE$, new Properties());
        SocketServer server = this.newSocketServer(config);
        Node node = new Node(nodeId, "localhost", server.boundPort(this.listenerName(config)));
        NetworkClient client = this.newNetworkClient(server, server, (MetadataUpdater)this.metadataUpdater(node));
        client.enableClusterLinkRequests(Uuid.randomUuid(), null, null);
        this.waitForReady(client, server, node);
        this.sendAndReceive(client, server, node, this.sendAndReceive$default$4(), (Option<KafkaPrincipal>)None$.MODULE$);
        client.close(Integer.toString(nodeId));
        this.verifyNetworkClientEmpty(client);
    }

    @Test
    public void testReversePlaintextConnection() {
        KafkaConfig sourceConfig = this.kafkaConfig(1, SecurityProtocol.PLAINTEXT, (Option<String>)None$.MODULE$, new Properties());
        KafkaConfig destConfig = this.kafkaConfig(2, SecurityProtocol.PLAINTEXT, (Option<String>)None$.MODULE$, new Properties());
        this.verifyReverseConnection(sourceConfig, destConfig);
    }

    @Test
    public void testReverseSslConnection() {
        KafkaConfig sourceConfig = this.kafkaConfig(1, SecurityProtocol.SSL, (Option<String>)None$.MODULE$, new Properties());
        KafkaConfig destConfig = this.kafkaConfig(2, SecurityProtocol.SSL, (Option<String>)None$.MODULE$, new Properties());
        this.verifyReverseConnection(sourceConfig, destConfig);
    }

    @Test
    public void testReverseSaslPlaintextConnection() {
        KafkaConfig sourceConfig = this.kafkaConfig(1, SecurityProtocol.SASL_PLAINTEXT, (Option<String>)None$.MODULE$, new Properties());
        KafkaConfig destConfig = this.kafkaConfig(2, SecurityProtocol.SASL_PLAINTEXT, (Option<String>)None$.MODULE$, new Properties());
        this.verifyReverseConnection(sourceConfig, destConfig);
    }

    @Test
    public void testReverseSaslSslConnection() {
        KafkaConfig sourceConfig = this.kafkaConfig(1, SecurityProtocol.SASL_SSL, (Option<String>)None$.MODULE$, new Properties());
        KafkaConfig destConfig = this.kafkaConfig(2, SecurityProtocol.SASL_SSL, (Option<String>)None$.MODULE$, new Properties());
        this.verifyReverseConnection(sourceConfig, destConfig);
    }

    @Test
    public void testReverseConnectionWithConfluentPrincipal() {
        KafkaConfig sourceConfig = this.kafkaConfig(1, SecurityProtocol.SASL_SSL, (Option<String>)new Some((Object)"PLAIN"), new Properties());
        KafkaConfig destConfig = this.kafkaConfig(2, SecurityProtocol.SASL_SSL, (Option<String>)new Some((Object)"PLAIN"), new Properties());
        this.verifyReverseConnection(sourceConfig, destConfig);
    }

    @Test
    public void testReverseConnectionWithPlaintextSourceSslDest() {
        KafkaConfig sourceConfig = this.kafkaConfig(1, SecurityProtocol.PLAINTEXT, (Option<String>)None$.MODULE$, new Properties());
        KafkaConfig destConfig = this.kafkaConfig(2, SecurityProtocol.SSL, (Option<String>)None$.MODULE$, new Properties());
        this.verifyReverseConnection(sourceConfig, destConfig);
    }

    @Test
    public void testReverseConnectionWithDifferentSaslMechanisms() {
        KafkaConfig sourceConfig = this.kafkaConfig(1, SecurityProtocol.SASL_PLAINTEXT, (Option<String>)new Some((Object)"PLAIN"), new Properties());
        KafkaConfig destConfig = this.kafkaConfig(2, SecurityProtocol.SASL_PLAINTEXT, (Option<String>)new Some((Object)"SCRAM-SHA-256"), new Properties());
        this.verifyReverseConnection(sourceConfig, destConfig);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAuthenticationFailure() {
        KafkaConfig sourceConfig = this.kafkaConfig(1, SecurityProtocol.SASL_PLAINTEXT, (Option<String>)new Some((Object)"PLAIN"), new Properties());
        KafkaConfig destConfig = this.kafkaConfig(2, SecurityProtocol.SASL_PLAINTEXT, (Option<String>)new Some((Object)"SCRAM-SHA-256"), new Properties());
        SocketServer sourceServer = this.newSocketServer(sourceConfig);
        SocketServer destServer = this.newSocketServer(destConfig);
        this.credentialProvider().credentialCache().cache("SCRAM-SHA-256", ScramCredential.class).remove(JaasTestUtils$.MODULE$.KafkaScramUser());
        this.credentialProvider().credentialCache().cache("SCRAM-SHA-256", ScramCredential.class).remove(JaasTestUtils$.MODULE$.KafkaScramUser2());
        LinkComponents link = this.createLinkClients(Uuid.randomUuid(), sourceServer, destServer);
        ListenerName sourceListenerName = ((EndPoint)sourceServer.config().effectiveAdvertisedListeners().head()).listenerName();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 3).foreach((Function1 & Serializable)i -> ReverseConnectionTest.$anonfun$testAuthenticationFailure$1(this, link, destServer, sourceListenerName, sourceServer, BoxesRunTime.unboxToInt((Object)i)));
        long l = 15000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ReverseConnectionTest.$anonfun$testAuthenticationFailure$2(this, link);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var13_12 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
    }

    @Test
    public void testSourceBrokerInterceptorWithServerSideClose() {
        this.verifySourceBrokerInterceptor(true);
    }

    @Test
    public void testSourceBrokerInterceptorWithClientSideClose() {
        this.verifySourceBrokerInterceptor(false);
    }

    /*
     * WARNING - void declaration
     */
    private void verifySourceBrokerInterceptor(boolean closeServerSide) {
        Tuple2 tuple2;
        Properties extraProps = new Properties();
        TestInterceptor$.MODULE$.reset();
        extraProps.setProperty(KafkaConfig$.MODULE$.BrokerInterceptorClassProp(), TestInterceptor.class.getName());
        None$ x$4 = None$.MODULE$;
        KafkaConfig sourceConfig = this.kafkaConfig(1, SecurityProtocol.SASL_SSL, (Option<String>)x$4, extraProps);
        KafkaConfig destConfig = this.kafkaConfig(2, SecurityProtocol.SASL_SSL, (Option<String>)None$.MODULE$, new Properties());
        SocketServer sourceServer = this.newSocketServer(sourceConfig);
        SocketServer destServer = this.newSocketServer(destConfig);
        int numRequests = 10;
        TestPrincipal testPrincipal = new TestPrincipal(this.principal(sourceServer));
        LinkComponents link = this.verifyReverseConnection(Uuid.randomUuid(), sourceServer, destServer, (Option<KafkaPrincipal>)new Some((Object)testPrincipal), numRequests);
        this.waitForConnectionCountMetric(link.sourceServer(), 1L);
        this.waitForConnectionCountMetric(link.destServer(), 0L);
        this.waitForCipherConnectionCountMetric(link.sourceServer(), 1L);
        this.waitForCipherConnectionCountMetric(link.destServer(), 0L);
        TestInterceptor$.MODULE$.verifySource(link, numRequests + 1, testPrincipal);
        if (closeServerSide) {
            this.verifyCloseServerSideReverseConnection(link);
        } else {
            this.verifyCloseClientSideReverseConnection(link);
        }
        this.waitForConnectionCountMetric(link.sourceServer(), 0L);
        this.waitForCipherConnectionCountMetric(link.sourceServer(), 0L);
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            int n = ReverseConnectionTest.$anonfun$verifySourceBrokerInterceptor$1();
            Integer computeUntilTrue_result = BoxesRunTime.boxToInteger((int)n);
            if (ReverseConnectionTest.$anonfun$verifySourceBrokerInterceptor$2(n)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var17_14 = null;
        Assertions.assertEquals((int)1, (int)tuple2._1$mcI$sp());
    }

    @Test
    public void testDestinationBrokerInterceptor() {
        Properties extraProps = new Properties();
        TestInterceptor$.MODULE$.reset();
        extraProps.setProperty(KafkaConfig$.MODULE$.BrokerInterceptorClassProp(), TestInterceptor.class.getName());
        KafkaConfig sourceConfig = this.kafkaConfig(1, SecurityProtocol.SASL_SSL, (Option<String>)None$.MODULE$, new Properties());
        None$ x$4 = None$.MODULE$;
        KafkaConfig destConfig = this.kafkaConfig(2, SecurityProtocol.SASL_SSL, (Option<String>)x$4, extraProps);
        SocketServer sourceServer = this.newSocketServer(sourceConfig);
        SocketServer destServer = this.newSocketServer(destConfig);
        int numRequests = 10;
        TestPrincipal testPrincipal = new TestPrincipal(this.principal(sourceServer));
        LinkComponents link = this.verifyReverseConnection(Uuid.randomUuid(), sourceServer, destServer, (Option<KafkaPrincipal>)new Some((Object)testPrincipal), numRequests);
        this.waitForConnectionCountMetric(link.sourceServer(), 1L);
        this.waitForConnectionCountMetric(link.destServer(), 0L);
        this.waitForCipherConnectionCountMetric(link.sourceServer(), 1L);
        this.waitForCipherConnectionCountMetric(link.destServer(), 0L);
        int expectedRequests = 2;
        KafkaPrincipal expectedPrincipal = new KafkaPrincipal("User", JaasTestUtils$.MODULE$.KafkaScramUser2());
        TestInterceptor$.MODULE$.verifyDestination(link, expectedRequests, expectedPrincipal);
        this.verifyCloseClientSideReverseConnection(link);
        this.waitForConnectionCountMetric(link.sourceServer(), 0L);
        this.waitForCipherConnectionCountMetric(link.sourceServer(), 0L);
        Assertions.assertEquals((int)1, (int)TestInterceptor$.MODULE$.authenticatedDisconnections().get());
    }

    @Test
    public void testReverseConnectionsToMultipleServers() {
        KafkaConfig sourceConfig = this.kafkaConfig(1, SecurityProtocol.SASL_PLAINTEXT, (Option<String>)None$.MODULE$, new Properties());
        KafkaConfig destConfig1 = this.kafkaConfig(2, SecurityProtocol.SASL_SSL, (Option<String>)None$.MODULE$, new Properties());
        KafkaConfig destConfig2 = this.kafkaConfig(3, SecurityProtocol.SSL, (Option<String>)None$.MODULE$, new Properties());
        SocketServer sourceServer = this.newSocketServer(sourceConfig);
        SocketServer destServer1 = this.newSocketServer(destConfig1);
        SocketServer destServer2 = this.newSocketServer(destConfig2);
        this.verifyReverseConnection(Uuid.randomUuid(), sourceServer, destServer1, (Option<KafkaPrincipal>)None$.MODULE$, 5);
        this.verifyReverseConnection(Uuid.randomUuid(), sourceServer, destServer2, (Option<KafkaPrincipal>)None$.MODULE$, 5);
    }

    @Test
    public void testReverseConnectionsFromMultipleServers() {
        KafkaConfig config1 = this.kafkaConfig(1, SecurityProtocol.SASL_PLAINTEXT, (Option<String>)None$.MODULE$, new Properties());
        KafkaConfig config2 = this.kafkaConfig(2, SecurityProtocol.SASL_SSL, (Option<String>)None$.MODULE$, new Properties());
        KafkaConfig config3 = this.kafkaConfig(3, SecurityProtocol.SSL, (Option<String>)None$.MODULE$, new Properties());
        SocketServer server1 = this.newSocketServer(config1);
        SocketServer server2 = this.newSocketServer(config2);
        SocketServer server3 = this.newSocketServer(config3);
        this.verifyReverseConnection(Uuid.randomUuid(), server1, server2, (Option<KafkaPrincipal>)None$.MODULE$, 5);
        this.verifyReverseConnection(Uuid.randomUuid(), server3, server2, (Option<KafkaPrincipal>)None$.MODULE$, 5);
        this.verifyReverseConnection(Uuid.randomUuid(), server3, server1, (Option<KafkaPrincipal>)None$.MODULE$, 5);
    }

    @Test
    public void testMultipleReverseConnectionsBetweenSameServers() {
        KafkaConfig sourceConfig = this.kafkaConfig(1, SecurityProtocol.SASL_PLAINTEXT, (Option<String>)None$.MODULE$, new Properties());
        KafkaConfig destConfig = this.kafkaConfig(2, SecurityProtocol.SASL_SSL, (Option<String>)None$.MODULE$, new Properties());
        SocketServer sourceServer = this.newSocketServer(sourceConfig);
        SocketServer destServer = this.newSocketServer(destConfig);
        this.verifyReverseConnection(Uuid.randomUuid(), sourceServer, destServer, (Option<KafkaPrincipal>)None$.MODULE$, 5);
        this.verifyReverseConnection(Uuid.randomUuid(), sourceServer, destServer, (Option<KafkaPrincipal>)None$.MODULE$, 5);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConnectionLimit() {
        Properties extraProps = new Properties();
        extraProps.put(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "1");
        None$ x$4 = None$.MODULE$;
        KafkaConfig sourceConfig = this.kafkaConfig(1, SecurityProtocol.PLAINTEXT, (Option<String>)x$4, extraProps);
        SocketServer sourceServer = this.newSocketServer(sourceConfig);
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        try (Socket socket = new Socket("localhost", sourceServer.boundPort(listenerName), null, 0);){
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ReverseConnectionTest.$anonfun$testConnectionLimit$1(sourceServer)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Connection not created");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            KafkaChannel channel = (KafkaChannel)Mockito.mock(KafkaChannel.class);
            Mockito.when((Object)channel.socketAddress()).thenReturn((Object)InetAddress.getLoopbackAddress());
            Mockito.when((Object)channel.socketDescription()).thenReturn((Object)"socket description");
            ReverseNode reverseNode = new ReverseNode(1, 1, "localhost", 0, Uuid.randomUuid(), -1, listenerName, KafkaPrincipal.ANONYMOUS, Optional.empty(), null);
            this.activeSourceReverseConnections().incrementAndGet();
            Assertions.assertThrows(TooManyConnectionsException.class, () -> sourceServer.reverseAndAdd(listenerName, new ReverseChannel(channel, reverseNode, x$2 -> this.activeSourceReverseConnections().decrementAndGet())));
            Assertions.assertEquals((int)0, (int)this.activeSourceReverseConnections().get());
        }
    }

    private void verifyReverseConnection(KafkaConfig sourceServerConfig, KafkaConfig destServerConfig) {
        this.verifyReverseConnection(sourceServerConfig, destServerConfig, true);
        this.verifyReverseConnection(sourceServerConfig, destServerConfig, false);
        Assertions.assertEquals((int)0, (int)this.activeSourceReverseConnections().get());
        Assertions.assertEquals((int)0, (int)this.kafka$network$ReverseConnectionTest$$activeDestReverseConnections().get());
    }

    private void verifyReverseConnection(KafkaConfig sourceServerConfig, KafkaConfig destServerConfig, boolean closeClientFirst) {
        SocketServer sourceServer = this.newSocketServer(sourceServerConfig);
        SocketServer destServer = this.newSocketServer(destServerConfig);
        LinkComponents link = this.verifyReverseConnection(Uuid.randomUuid(), sourceServer, destServer, (Option<KafkaPrincipal>)None$.MODULE$, 5);
        Assertions.assertEquals((int)1, (int)sourceServer.connectionCount(InetAddress.getLoopbackAddress()));
        Assertions.assertEquals((int)0, (int)destServer.connectionCount(InetAddress.getLoopbackAddress()));
        this.waitForConnectionCountMetric(sourceServer, 1L);
        this.waitForConnectionCountMetric(destServer, 0L);
        if (closeClientFirst) {
            this.verifyCloseClientSideReverseConnection(link);
        } else {
            this.verifyCloseServerSideReverseConnection(link);
        }
        this.waitForConnectionCountMetric(sourceServer, 0L);
    }

    /*
     * WARNING - void declaration
     */
    private void verifyCloseClientSideReverseConnection(LinkComponents link) {
        this.verifyNetworkClientEmpty(link.clientFromSource());
        link.clientFromDest().close(link.clientFromDest().leastLoadedNode(this.time().milliseconds()).idString());
        this.verifyNetworkClientEmpty(link.clientFromDest());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReverseConnectionTest.$anonfun$verifyCloseClientSideReverseConnection$1(link)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Source server-side connection not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void verifyCloseServerSideReverseConnection(LinkComponents link) {
        Assertions.assertTrue((boolean)link.reverseSourceChannels().forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.maybeClose())), (String)"Reverse channels could not be closed");
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReverseConnectionTest.$anonfun$verifyCloseServerSideReverseConnection$2(link)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Reverse connection not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.verifyNetworkClientEmpty(link.clientFromSource());
        long l2 = 15000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l3 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                this.verifyNetworkClientEmpty(link.clientFromDest());
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l3).append(", and then retrying.").toString();
                    Object var14_10 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l3);
                l3 += package$.MODULE$.min(l3, 1000L);
                continue;
            }
            break;
        }
    }

    private LinkComponents createLinkClients(Uuid linkId, SocketServer sourceServer, SocketServer destServer) {
        Node sourceNode = new Node(sourceServer.config().brokerId(), "localhost", sourceServer.boundPort(this.listenerName(sourceServer.config())));
        Node destNode = new Node(destServer.config().brokerId(), "localhost", destServer.boundPort(this.listenerName(destServer.config())));
        NetworkClient clientFromSource = this.newNetworkClient(destServer, sourceServer, (MetadataUpdater)this.metadataUpdater(destNode));
        clientFromSource.enableClusterLinkReverseConnectionAdmin(linkId, null, this.reversalData(linkId, sourceServer), (sourceChannel, reverseNode) -> this.onReverseClientConnection(sourceChannel, reverseNode));
        NetworkClient clientFromDest = this.newNetworkClient(sourceServer, destServer, (MetadataUpdater)this.metadataUpdater(sourceNode));
        clientFromDest.enableClusterLinkRequests(linkId, null, x$4 -> {});
        LinkComponents linkComponents = new LinkComponents(sourceServer, destServer, clientFromSource, clientFromDest);
        this.kafka$network$ReverseConnectionTest$$links().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkId), (Object)linkComponents));
        return linkComponents;
    }

    /*
     * WARNING - void declaration
     */
    private LinkComponents verifyReverseConnection(Uuid linkId, SocketServer sourceServer, SocketServer destServer, Option<KafkaPrincipal> principalOpt, int numRequests) {
        LinkComponents link = this.createLinkClients(linkId, sourceServer, destServer);
        KafkaPrincipal sourcePrincipal = (KafkaPrincipal)principalOpt.getOrElse((Function0 & Serializable)() -> this.principal(sourceServer));
        ListenerName sourceListenerName = ((EndPoint)sourceServer.config().effectiveAdvertisedListeners().head()).listenerName();
        ReverseNode reverseDestNode = link.clientFromSource().reverseConnectionManager().createReversibleConnection(123, destServer.config().brokerId(), sourceListenerName, sourcePrincipal, Optional.empty(), this.authenticationContext(sourceServer), this.time().milliseconds());
        Node sourceNode = new Node(sourceServer.config().brokerId(), "localhost", sourceServer.boundPort(this.listenerName(sourceServer.config())));
        this.waitForReversal(link.clientFromSource(), destServer, reverseDestNode);
        String string = "Reversed node did not send ApiVersions request in destination client";
        NetworkClient waitForClient_client = link.clientFromDest();
        long l = 100L;
        long waitForClient_waitUntilTrue_waitTimeMs = 15000L;
        long waitForClient_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitForClient_waitUntilTrue_pause;
            waitForClient_client.poll(1000L, this.time().milliseconds());
            if (ReverseConnectionTest.$anonfun$verifyReverseConnection$2(link, sourceNode, waitForClient_client)) break;
            if (System.currentTimeMillis() > waitForClient_waitUntilTrue_startTime + waitForClient_waitUntilTrue_waitTimeMs) {
                void waitForClient_errorMessage;
                Assertions.fail((String)waitForClient_errorMessage);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitForClient_waitUntilTrue_waitTimeMs), (long)waitForClient_waitUntilTrue_pause));
        }
        Object var11_12 = null;
        string = null;
        this.processNextRequest(sourceServer, link.clientFromDest(), sourceNode, (Option<KafkaPrincipal>)new Some((Object)sourcePrincipal));
        String string2 = "Reversed node not ready in destination client";
        NetworkClient waitForClient_client2 = link.clientFromDest();
        long l2 = 100L;
        long waitForClient_waitUntilTrue_waitTimeMs2 = 15000L;
        long waitForClient_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void waitForClient_waitUntilTrue_pause;
            waitForClient_client2.poll(1000L, this.time().milliseconds());
            if (ReverseConnectionTest.$anonfun$verifyReverseConnection$3(link, sourceNode, waitForClient_client2)) break;
            if (System.currentTimeMillis() > waitForClient_waitUntilTrue_startTime2 + waitForClient_waitUntilTrue_waitTimeMs2) {
                void waitForClient_errorMessage;
                Assertions.fail((String)waitForClient_errorMessage);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitForClient_waitUntilTrue_waitTimeMs2), (long)waitForClient_waitUntilTrue_pause));
        }
        Object var19_17 = null;
        string2 = null;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRequests).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$7 -> {
            NetworkClient x$1 = link.clientFromDest();
            Some x$4 = new Some((Object)sourcePrincipal);
            AbstractRequest.Builder<?> x$5 = this.sendAndReceive$default$4();
            this.sendAndReceive(x$1, sourceServer, sourceNode, x$5, (Option<KafkaPrincipal>)x$4);
        });
        return link;
    }

    private Option<KafkaPrincipal> verifyReverseConnection$default$4() {
        return None$.MODULE$;
    }

    private int verifyReverseConnection$default$5() {
        return 5;
    }

    /*
     * WARNING - void declaration
     */
    private void waitForConnectionCountMetric(SocketServer socketServer, long expectedValue) {
        void var5_9;
        Tuple2 tuple2;
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            long l2 = TestUtils$.MODULE$.totalMetricValue(socketServer.metrics(), "connection-count");
            Long computeUntilTrue_result = BoxesRunTime.boxToLong((long)l2);
            if (ReverseConnectionTest.$anonfun$waitForConnectionCountMetric$2(expectedValue, l2)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var13_6 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        long value = tuple22._1$mcJ$sp();
        Assertions.assertEquals((long)expectedValue, (long)var5_9);
    }

    /*
     * WARNING - void declaration
     */
    private void waitForCipherConnectionCountMetric(SocketServer socketServer, long expectedValue) {
        void var5_9;
        Tuple2 tuple2;
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            long l2 = ReverseConnectionTest.totalMetricValue$1(socketServer);
            Long computeUntilTrue_result = BoxesRunTime.boxToLong((long)l2);
            if (ReverseConnectionTest.$anonfun$waitForCipherConnectionCountMetric$4(expectedValue, l2)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var13_6 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        long value = tuple22._1$mcJ$sp();
        Assertions.assertEquals((long)expectedValue, (long)var5_9);
    }

    private KafkaConfig kafkaConfig(int brokerId, SecurityProtocol securityProtocol, Option<String> saslMechanism, Properties extraProps) {
        Properties properties;
        if (SecurityProtocol.PLAINTEXT.equals(securityProtocol)) {
            properties = this.plaintextServerProps(brokerId);
        } else if (SecurityProtocol.SSL.equals(securityProtocol)) {
            properties = this.sslServerProps(brokerId);
        } else if (SecurityProtocol.SASL_PLAINTEXT.equals(securityProtocol) ? true : SecurityProtocol.SASL_SSL.equals(securityProtocol)) {
            properties = this.saslServerProps(brokerId, securityProtocol, saslMechanism);
        } else {
            throw new MatchError((Object)securityProtocol);
        }
        Properties props = properties;
        props.setProperty(KafkaConfig$.MODULE$.NumNetworkThreadsProp(), "1");
        props.setProperty(KafkaConfig$.MODULE$.QueuedMaxRequestsProp(), "50");
        props.setProperty(KafkaConfig$.MODULE$.SocketRequestMaxBytesProp(), "1000");
        props.setProperty(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "5");
        props.setProperty(KafkaConfig$.MODULE$.ConnectionsMaxIdleMsProp(), "60000");
        props.putAll((java.util.Map<?, ?>)extraProps);
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    private Option<String> kafkaConfig$default$3() {
        return None$.MODULE$;
    }

    private Properties kafkaConfig$default$4() {
        return new Properties();
    }

    private Properties plaintextServerProps(int brokerId) {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var21_10 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var22_13 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var23_16 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        return TestUtils$.MODULE$.createBrokerConfig(brokerId, x$2, x$4, x$5, 0, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
    }

    private Properties sslServerProps(int brokerId) {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        Some x$3 = new Some((Object)SecurityProtocol.SSL);
        Some x$4 = new Some((Object)trustStoreFile);
        boolean x$7 = true;
        boolean x$8 = true;
        TestUtils$ createBrokerConfig$default$5_this = TestUtils$.MODULE$;
        Object var21_8 = null;
        int x$9 = createBrokerConfig$default$5_this.RandomPort();
        None$ x$10 = None$.MODULE$;
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var22_12 = null;
        int x$12 = createBrokerConfig$default$11_this.RandomPort();
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var23_14 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var24_17 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        return TestUtils$.MODULE$.createBrokerConfig(brokerId, x$2, x$7, x$8, x$9, (Option<SecurityProtocol>)x$3, (Option<File>)x$4, (Option<Properties>)x$10, false, x$11, x$12, true, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
    }

    private Properties saslServerProps(int brokerId, SecurityProtocol securityProtocol, Option<String> saslMechanism) {
        String mechanism = (String)saslMechanism.getOrElse((Function0 & Serializable)() -> "SCRAM-SHA-256");
        Properties saslProps = JaasTestUtils$.MODULE$.saslConfigs((Option<Properties>)None$.MODULE$);
        saslProps.setProperty(KafkaConfig$.MODULE$.SaslMechanismInterBrokerProtocolProp(), mechanism);
        saslProps.setProperty("sasl.enabled.mechanisms", mechanism);
        saslProps.setProperty(new StringBuilder(16).append(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).saslMechanismConfigPrefix(mechanism)).append("sasl.jaas.config").toString(), ((JaasTestUtils.JaasModule)JaasTestUtils$.MODULE$.kafkaServerSection("KafkaServer", (Seq<String>)new .colon.colon((Object)mechanism, (List)Nil$.MODULE$), (Option<File>)None$.MODULE$).modules().head()).toString());
        if (ScramMechanism.isScram((String)mechanism)) {
            this.addScramUser(mechanism, JaasTestUtils$.MODULE$.KafkaScramUser(), JaasTestUtils$.MODULE$.KafkaScramPassword());
            this.addScramUser(mechanism, JaasTestUtils$.MODULE$.KafkaScramUser2(), JaasTestUtils$.MODULE$.KafkaScramPassword2());
            this.addScramUser(mechanism, JaasTestUtils$.MODULE$.KafkaScramAdmin(), JaasTestUtils$.MODULE$.KafkaScramAdminPassword());
        }
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        Some x$3 = new Some((Object)securityProtocol);
        SecurityProtocol securityProtocol2 = securityProtocol;
        SecurityProtocol securityProtocol3 = SecurityProtocol.SASL_SSL;
        None$ x$4 = !(securityProtocol2 != null ? !securityProtocol2.equals(securityProtocol3) : securityProtocol3 != null) ? new Some((Object)File.createTempFile("truststore", ".jks")) : None$.MODULE$;
        Some x$5 = new Some((Object)saslProps);
        SecurityProtocol securityProtocol4 = securityProtocol;
        SecurityProtocol securityProtocol5 = SecurityProtocol.SASL_PLAINTEXT;
        boolean x$7 = !(securityProtocol4 != null ? !securityProtocol4.equals(securityProtocol5) : securityProtocol5 != null);
        SecurityProtocol securityProtocol6 = securityProtocol;
        SecurityProtocol securityProtocol7 = SecurityProtocol.SASL_SSL;
        boolean x$8 = !(securityProtocol6 != null ? !securityProtocol6.equals(securityProtocol7) : securityProtocol7 != null);
        boolean x$9 = true;
        boolean x$10 = true;
        TestUtils$ createBrokerConfig$default$5_this = TestUtils$.MODULE$;
        Object var28_17 = null;
        int x$11 = createBrokerConfig$default$5_this.RandomPort();
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var29_19 = null;
        int x$12 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var30_22 = null;
        int x$14 = createBrokerConfig$default$13_this.RandomPort();
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var31_24 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        return TestUtils$.MODULE$.createBrokerConfig(brokerId, x$2, x$9, x$10, x$11, (Option<SecurityProtocol>)x$3, (Option<File>)x$4, (Option<Properties>)x$5, false, x$7, x$12, x$13, x$14, x$8, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
    }

    private void addScramUser(String mechanism, String username, String password) {
        if (this.credentialProvider().credentialCache().cache(mechanism, ScramCredential.class) == null) {
            ScramCredentialUtils.createCache((CredentialCache)this.credentialProvider().credentialCache(), Collections.singletonList(mechanism));
        }
        ScramMechanism scramMechanism = ScramMechanism.forMechanismName((String)mechanism);
        ScramCredential credential = new ScramFormatter(scramMechanism).generateCredential(password, 4096);
        this.credentialProvider().credentialCache().cache(scramMechanism.mechanismName(), ScramCredential.class).put(username, (Object)credential);
    }

    private ListenerName listenerName(KafkaConfig config) {
        return ((EndPoint)config.listeners().head()).listenerName();
    }

    private SocketServer newSocketServer(KafkaConfig config) {
        ReverseNode.ReverseCallback reverseCallback = new ReverseNode.ReverseCallback(this){
            private final /* synthetic */ ReverseConnectionTest $outer;

            public void onReverseConnection(KafkaChannel channel, ReverseNode reverseNode) {
                this.$outer.kafka$network$ReverseConnectionTest$$activeDestReverseConnections().incrementAndGet();
                ((LinkComponents)this.$outer.kafka$network$ReverseConnectionTest$$links().apply((Object)reverseNode.linkId())).clientFromDest().reverseAndAdd(new ReverseChannel(channel, reverseNode, x$10 -> $this.$outer.kafka$network$ReverseConnectionTest$$activeDestReverseConnections().decrementAndGet()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        SimpleApiVersionManager apiVersionManager = new SimpleApiVersionManager(ApiMessageType.ListenerType.BROKER, false, false, (Function0 & Serializable)() -> Features.fromKRaftVersion((MetadataVersion)MetadataVersion.latest()));
        Metrics x$2 = new Metrics();
        Time x$3 = this.time();
        CredentialProvider x$4 = this.credentialProvider();
        ActionQueue x$6 = new ActionQueue();
        Some x$7 = new Some((Object)reverseCallback);
        DefaultRequestCallbackManager x$8 = new DefaultRequestCallbackManager();
        NoOpAuditLogProvider x$9 = NoOpAuditLogProvider.INSTANCE;
        None$ x$10 = None$.MODULE$;
        SocketServer server = new SocketServer(config, x$2, x$3, x$4, (ApiVersionManager)apiVersionManager, x$6, (RequestCallback)x$8, (AuditLogProvider)x$9, (Option)x$7, (Option)x$10);
        server.enableRequestProcessing((Map)Predef$.MODULE$.Map().empty());
        this.servers().$plus$eq((Object)server);
        return server;
    }

    private ClientRequest newClientRequest(NetworkClient networkClient, String nodeId, AbstractRequest.Builder<?> builder, CompletableFuture<Void> future) {
        RequestCompletionHandler handler = new RequestCompletionHandler(null, future){
            private final CompletableFuture future$1;

            public void onComplete(ClientResponse response) {
                this.future$1.complete(null);
            }
            {
                this.future$1 = future$1;
            }
        };
        return networkClient.newClientRequest(nodeId, builder, this.time().milliseconds(), true, 10000, handler);
    }

    private RequestChannel.Request receiveRequest(RequestChannel channel, long timeout) {
        RequestChannel.BaseRequest baseRequest = channel.receiveRequest(timeout);
        if (baseRequest instanceof RequestChannel.Request) {
            return (RequestChannel.Request)baseRequest;
        }
        if (RequestChannel.ShutdownRequest$.MODULE$.equals(baseRequest)) {
            throw Assertions$.MODULE$.fail("Unexpected shutdown received", new Position("ReverseConnectionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 545));
        }
        if (baseRequest == null) {
            throw Assertions$.MODULE$.fail("receiveRequest timed out", new Position("ReverseConnectionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 546));
        }
        throw new MatchError((Object)baseRequest);
    }

    private long receiveRequest$default$2() {
        return 2000L;
    }

    /*
     * WARNING - void declaration
     */
    private void processNextRequest(SocketServer server, NetworkClient client, Node node, Option<KafkaPrincipal> expectedPrincipal) {
        void var11_16;
        void var10_15;
        None$ none$;
        ApiVersionsResponse apiVersionsResponse;
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReverseConnectionTest.$anonfun$processNextRequest$1(this, client, node, server)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Request did not arrive on server");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        RequestChannel.Request request = this.receiveRequest(server.dataPlaneRequestChannel(), 2000L);
        expectedPrincipal.foreach((Function1 & Serializable)principal -> {
            ReverseConnectionTest.$anonfun$processNextRequest$3(request, principal);
            return BoxedUnit.UNIT;
        });
        ApiKeys apiKeys = request.header().apiKey();
        if (ApiKeys.API_VERSIONS.equals(apiKeys)) {
            ApiMessageType.ListenerType defaultApiVersionsResponse_listenerType = ApiMessageType.ListenerType.ZK_BROKER;
            apiVersionsResponse = TestUtils.defaultApiVersionsResponse((int)0, (ApiMessageType.ListenerType)defaultApiVersionsResponse_listenerType, (boolean)true);
            Object var21_10 = null;
            none$ = None$.MODULE$;
        } else if (ApiKeys.METADATA.equals(apiKeys)) {
            MetadataResponseData data = new MetadataResponseData().setClusterId("clusterId").setControllerId(0).setTopics(new MetadataResponseData.MetadataResponseTopicCollection()).setBrokers(new MetadataResponseData.MetadataResponseBrokerCollection());
            apiVersionsResponse = new MetadataResponse(data, 0);
            none$ = None$.MODULE$;
        } else if (ApiKeys.REVERSE_CONNECTION.equals(apiKeys)) {
            ReverseConnectionRequestData data = ((ReverseConnectionRequest)request.body(ClassTag$.MODULE$.apply(ReverseConnectionRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()))).data();
            ReverseNode node2 = new ReverseNode(data.sourceBrokerId(), data.sourceBrokerId(), data.sourceHost(), data.sourcePort(), data.clusterLinkId(), data.initiateRequestId(), request.context().listenerName, request.context().principal, request.context().principalSerde, request.context().authenticationContext);
            apiVersionsResponse = new ReverseConnectionResponse(Errors.NONE, null, 0);
            none$ = new Some((Object)node2);
        } else {
            throw new IllegalArgumentException(new StringBuilder(14).append(apiKeys).append(" not supported").toString());
        }
        None$ none$2 = none$;
        AbstractResponse response = (AbstractResponse)apiVersionsResponse;
        Option reverseNode = (Option)none$2;
        ByteBuffer byteBuffer = RequestTestUtils.serializeResponseWithHeader((AbstractResponse)var10_15, (short)request.header().apiVersion(), (int)request.header().correlationId());
        byteBuffer.rewind();
        NetworkSend send = new NetworkSend(request.context().connectionId, (Send)ByteBufferSend.sizePrefixed((ByteBuffer)byteBuffer));
        RequestChannel.SendResponse responseData = var11_16.isEmpty() ? new RequestChannel.SendResponse(request, (Send)send, (Option)None$.MODULE$) : new RequestChannel.SendResponseAndReverse(request, (Send)send, (Option)None$.MODULE$, (ReverseNode)var11_16.get());
        server.dataPlaneRequestChannel().sendResponse((RequestChannel.Response)responseData);
    }

    private Option<KafkaPrincipal> processNextRequest$default$4() {
        return None$.MODULE$;
    }

    private MetadataRequest.Builder metadataRequestBuilder() {
        return MetadataRequest.Builder.allTopics((boolean)false);
    }

    private ManualMetadataUpdater metadataUpdater(Node node) {
        ManualMetadataUpdater metadataUpdater = new ManualMetadataUpdater();
        metadataUpdater.setNodes(Collections.singletonList(node));
        return metadataUpdater;
    }

    /*
     * WARNING - void declaration
     */
    private NetworkClient newNetworkClient(SocketServer remoteServer, SocketServer localServer, MetadataUpdater metadataUpdater) {
        void clientChannelBuilder_saslHandshakeRequestEnable;
        void clientChannelBuilder_time;
        void clientChannelBuilder_clientSaslMechanism;
        SecurityProtocol securityProtocol;
        HashMap<String, String> clientProps;
        String clientId;
        LogContext logContext;
        block3: {
            KafkaConfig serverConfig;
            block2: {
                logContext = new LogContext();
                serverConfig = remoteServer.config();
                clientId = new StringBuilder(8).append("client-").append(localServer.config().brokerId()).append("-").append(this.networkClients().size()).toString();
                clientProps = new HashMap<String, String>();
                serverConfig.originals().forEach((k, v) -> clientProps.put((String)k, (String)v));
                EndPoint endpoint = (EndPoint)serverConfig.listeners().head();
                securityProtocol = endpoint.securityProtocol();
                clientProps.put("bootstrap.servers", endpoint.connectionString());
                clientProps.put("security.protocol", securityProtocol.name);
                if (securityProtocol.equals(SecurityProtocol.SASL_PLAINTEXT)) break block2;
                SecurityProtocol securityProtocol2 = securityProtocol;
                SecurityProtocol securityProtocol3 = SecurityProtocol.SASL_SSL;
                if (securityProtocol2 != null ? !securityProtocol2.equals(securityProtocol3) : securityProtocol3 != null) break block3;
            }
            String saslMechanism = serverConfig.saslMechanismInterBrokerProtocol();
            clientProps.put("sasl.mechanism", saslMechanism);
            clientProps.put("sasl.jaas.config", ((JaasTestUtils.JaasModule)JaasTestUtils$.MODULE$.kafkaClientSection((Option<String>)new Some((Object)saslMechanism), (Option<File>)None$.MODULE$).modules().head()).toString());
        }
        AdminClientConfig clientConfig = new AdminClientConfig(clientProps);
        boolean bl = true;
        Time time = this.time();
        String string = clientConfig.getString("sasl.mechanism");
        JaasContext.Type clientChannelBuilder_contextType = JaasContext.Type.CLIENT;
        Object var17_16 = null;
        string = null;
        time = null;
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)securityProtocol, (JaasContext.Type)clientChannelBuilder_contextType, (AbstractConfig)clientConfig, null, (String)clientChannelBuilder_clientSaslMechanism, (Time)clientChannelBuilder_time, (boolean)clientChannelBuilder_saslHandshakeRequestEnable, (LogContext)logContext, null, null);
        Metrics metrics = new Metrics();
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(clientConfig.getLong("connections.max.idle.ms")), metrics, this.time(), clientId, Collections.emptyMap(), false, channelBuilder, logContext);
        NetworkClient networkClient = new NetworkClient(metadataUpdater, null, (Selectable)selector, clientId, 1, 50L, 50L, -1, Predef$.MODULE$.Integer2int(clientConfig.getInt("receive.buffer.bytes")), Predef$.MODULE$.Integer2int(clientConfig.getInt("request.timeout.ms")), Predef$.MODULE$.Long2long(clientConfig.getLong("socket.connection.setup.timeout.ms")), Predef$.MODULE$.Long2long(clientConfig.getLong("socket.connection.setup.timeout.max.ms")), this.time(), true, new ApiVersions(), null, new LogContext());
        this.networkClients().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)networkClient), (Object)metrics));
        return networkClient;
    }

    /*
     * WARNING - void declaration
     */
    private void waitForClient(NetworkClient client, Function1<NetworkClient, Object> predicate, String errorMessage) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            client.poll(1000L, this.time().milliseconds());
            if (BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)client))) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)errorMessage);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void waitForReady(NetworkClient client, SocketServer server, Node node) {
        Assertions.assertFalse((boolean)client.ready(node, this.time().milliseconds()), (String)"Client ready before poll");
        this.processNextRequest(server, client, node, (Option<KafkaPrincipal>)None$.MODULE$);
        String waitForClient_errorMessage = "Node not ready";
        long l = 100L;
        long waitForClient_waitUntilTrue_waitTimeMs = 15000L;
        long waitForClient_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitForClient_waitUntilTrue_pause;
            client.poll(1000L, this.time().milliseconds());
            if (client.ready(node, this.time().milliseconds())) break;
            if (System.currentTimeMillis() > waitForClient_waitUntilTrue_startTime + waitForClient_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)waitForClient_errorMessage);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitForClient_waitUntilTrue_waitTimeMs), (long)waitForClient_waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void waitForReversal(NetworkClient client, SocketServer server, ReverseNode node) {
        Assertions.assertFalse((boolean)client.ready((Node)node, this.time().milliseconds()), (String)"Client ready before poll");
        this.processNextRequest(server, client, (Node)node, (Option<KafkaPrincipal>)None$.MODULE$);
        this.processNextRequest(server, client, (Node)node, (Option<KafkaPrincipal>)None$.MODULE$);
        CompletableFuture future = node.future();
        String waitForClient_errorMessage = "Reversal not complete";
        long l = 100L;
        long waitForClient_waitUntilTrue_waitTimeMs = 15000L;
        long waitForClient_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitForClient_waitUntilTrue_pause;
            client.poll(1000L, this.time().milliseconds());
            if (future.isDone()) break;
            if (System.currentTimeMillis() > waitForClient_waitUntilTrue_startTime + waitForClient_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)waitForClient_errorMessage);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitForClient_waitUntilTrue_waitTimeMs), (long)waitForClient_waitUntilTrue_pause));
        }
        Object var5_5 = null;
        future.get();
    }

    /*
     * WARNING - void declaration
     */
    private void sendAndReceive(NetworkClient client, SocketServer server, Node node, AbstractRequest.Builder<?> requestBuilder, Option<KafkaPrincipal> expectedPrincipal) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        ClientRequest request = this.newClientRequest(client, node.idString(), requestBuilder, future);
        client.send(request, this.time().milliseconds());
        this.processNextRequest(server, client, node, expectedPrincipal);
        String waitForClient_errorMessage = "Response not processed";
        long l = 100L;
        long waitForClient_waitUntilTrue_waitTimeMs = 15000L;
        long waitForClient_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitForClient_waitUntilTrue_pause;
            client.poll(1000L, this.time().milliseconds());
            if (future.isDone()) break;
            if (System.currentTimeMillis() > waitForClient_waitUntilTrue_startTime + waitForClient_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)waitForClient_errorMessage);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitForClient_waitUntilTrue_waitTimeMs), (long)waitForClient_waitUntilTrue_pause));
        }
    }

    private AbstractRequest.Builder<?> sendAndReceive$default$4() {
        return MetadataRequest.Builder.allTopics((boolean)false);
    }

    private Option<KafkaPrincipal> sendAndReceive$default$5() {
        return None$.MODULE$;
    }

    private ReverseConnectionRequestData reversalData(Uuid linkId, SocketServer sourceServer) {
        EndPoint endpoint = (EndPoint)sourceServer.config().listeners().head();
        return new ReverseConnectionRequestData().setClusterLinkId(linkId).setTargetClusterId("destClusterId").setSourceClusterId("sourceClusterId").setSourceBrokerId(sourceServer.config().brokerId()).setSourceHost(endpoint.host()).setSourcePort(endpoint.port());
    }

    private void onReverseClientConnection(KafkaChannel sourceChannel, ReverseNode reverseNode) {
        ReverseChannel reverseChannel = new ReverseChannel(sourceChannel, reverseNode, x$15 -> this.activeSourceReverseConnections().decrementAndGet());
        this.activeSourceReverseConnections().incrementAndGet();
        ((LinkComponents)this.kafka$network$ReverseConnectionTest$$links().apply((Object)reverseNode.linkId())).sourceServer().reverseAndAdd(reverseNode.localListenerName(), reverseChannel);
        ((LinkComponents)this.kafka$network$ReverseConnectionTest$$links().apply((Object)reverseNode.linkId())).reverseSourceChannels().$plus$eq((Object)reverseChannel);
    }

    private KafkaPrincipal principal(SocketServer server) {
        SecurityProtocol securityProtocol = ((EndPoint)server.config().listeners().head()).securityProtocol();
        if (SecurityProtocol.PLAINTEXT.equals(securityProtocol)) {
            return KafkaPrincipal.ANONYMOUS;
        }
        if (SecurityProtocol.SSL.equals(securityProtocol)) {
            return new KafkaPrincipal("User", "CN=test");
        }
        String string = server.config().saslMechanismInterBrokerProtocol();
        String string2 = "PLAIN";
        if (string != null && string.equals(string2)) {
            return new ConfluentPrincipal("TenantUser", JaasTestUtils$.MODULE$.KafkaPlainUser(), new StringBuilder(7).append(JaasTestUtils$.MODULE$.KafkaPlainUser()).append("-apikey").toString());
        }
        return new KafkaPrincipal("User", JaasTestUtils$.MODULE$.KafkaScramUser());
    }

    private AuthenticationContext authenticationContext(SocketServer server) {
        String listenerName = ((EndPoint)server.config().listeners().head()).listenerName().value();
        InetAddress clientAddress = InetAddress.getLoopbackAddress();
        SecurityProtocol securityProtocol = ((EndPoint)server.config().listeners().head()).securityProtocol();
        if (SecurityProtocol.PLAINTEXT.equals(securityProtocol)) {
            return new PlaintextAuthenticationContext(clientAddress, listenerName);
        }
        if (SecurityProtocol.SSL.equals(securityProtocol)) {
            return new SslAuthenticationContext((SSLSession)Mockito.mock(SSLSession.class), clientAddress, listenerName);
        }
        SaslServer saslServer = (SaslServer)Mockito.mock(SaslServer.class);
        Mockito.when((Object)saslServer.getMechanismName()).thenReturn((Object)server.config().saslMechanismInterBrokerProtocol());
        return new SaslAuthenticationContext(saslServer, securityProtocol, clientAddress, listenerName);
    }

    private void shutdownServerAndMetrics(SocketServer server) {
        server.shutdown();
        server.metrics().close();
    }

    private void verifyNetworkClientEmpty(NetworkClient client) {
        client.poll(0L, this.time().milliseconds());
        TestUtils.verifyEmptyFields((Object)client, (int)1, (String[])new String[]{"metadataUpdater"});
        TestUtils.verifyEmptyFields((Object)((Selectable)TestUtils.fieldValue((Object)client, NetworkClient.class, (String)"selector")), (int)1, (String[])new String[0]);
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            NetworkClient client = (NetworkClient)x0$1._1();
            Metrics metrics = (Metrics)x0$1._2();
            client.close();
            metrics.close();
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ ReverseNode $anonfun$testAuthenticationFailure$1(ReverseConnectionTest $this, LinkComponents link$1, SocketServer destServer$1, ListenerName sourceListenerName$1, SocketServer sourceServer$1, int i) {
        return link$1.clientFromSource().reverseConnectionManager().createReversibleConnection(i, destServer$1.config().brokerId(), sourceListenerName$1, $this.principal(sourceServer$1), Optional.empty(), null, $this.time().milliseconds());
    }

    public static final /* synthetic */ void $anonfun$testAuthenticationFailure$2(ReverseConnectionTest $this, LinkComponents link$1) {
        link$1.clientFromSource().poll(1L, $this.time().milliseconds());
        $this.verifyNetworkClientEmpty(link$1.clientFromSource());
    }

    public static final /* synthetic */ int $anonfun$verifySourceBrokerInterceptor$1() {
        return TestInterceptor$.MODULE$.authenticatedDisconnections().get();
    }

    public static final /* synthetic */ boolean $anonfun$verifySourceBrokerInterceptor$2(int x$1) {
        return x$1 == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testConnectionLimit$1(SocketServer sourceServer$2) {
        return sourceServer$2.connectionCount(InetAddress.getLoopbackAddress()) > 0;
    }

    public static final /* synthetic */ String $anonfun$testConnectionLimit$2() {
        return "Connection not created";
    }

    public static final /* synthetic */ boolean $anonfun$verifyCloseClientSideReverseConnection$1(LinkComponents link$2) {
        return link$2.sourceServer().connectionCount(InetAddress.getLoopbackAddress()) == 0;
    }

    public static final /* synthetic */ String $anonfun$verifyCloseClientSideReverseConnection$2() {
        return "Source server-side connection not closed";
    }

    public static final /* synthetic */ boolean $anonfun$verifyCloseServerSideReverseConnection$2(LinkComponents link$3) {
        return link$3.sourceServer().connectionCount(InetAddress.getLoopbackAddress()) == 0;
    }

    public static final /* synthetic */ String $anonfun$verifyCloseServerSideReverseConnection$3() {
        return "Reverse connection not closed";
    }

    public static final /* synthetic */ boolean $anonfun$verifyReverseConnection$2(LinkComponents link$4, Node sourceNode$1, NetworkClient x$5) {
        return link$4.clientFromDest().inFlightRequestCount(sourceNode$1.idString()) > 0;
    }

    public static final /* synthetic */ boolean $anonfun$verifyReverseConnection$3(LinkComponents link$4, Node sourceNode$1, NetworkClient x$6) {
        return link$4.clientFromDest().isReady(sourceNode$1, System.currentTimeMillis());
    }

    public static final /* synthetic */ boolean $anonfun$waitForConnectionCountMetric$2(long expectedValue$1, long x$8) {
        return x$8 == expectedValue$1;
    }

    public static final /* synthetic */ boolean $anonfun$waitForCipherConnectionCountMetric$1(KafkaMetric m) {
        String string = m.metricName().name();
        String string2 = "connections";
        return string != null && string.equals(string2) && m.metricName().tags().containsKey("cipher");
    }

    public static final /* synthetic */ int $anonfun$waitForCipherConnectionCountMetric$2(int total, KafkaMetric metric) {
        return total + Predef$.MODULE$.Integer2int((Integer)metric.metricValue());
    }

    private static final long totalMetricValue$1(SocketServer socketServer$2) {
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(socketServer$2.metrics().metrics().values()).asScala().filter((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)ReverseConnectionTest.$anonfun$waitForCipherConnectionCountMetric$1(m)))).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(total, metric) -> BoxesRunTime.boxToInteger((int)ReverseConnectionTest.$anonfun$waitForCipherConnectionCountMetric$2(BoxesRunTime.unboxToInt((Object)total), metric))));
    }

    public static final /* synthetic */ long $anonfun$waitForCipherConnectionCountMetric$3(SocketServer socketServer$2) {
        return ReverseConnectionTest.totalMetricValue$1(socketServer$2);
    }

    public static final /* synthetic */ boolean $anonfun$waitForCipherConnectionCountMetric$4(long expectedValue$2, long x$9) {
        return x$9 == expectedValue$2;
    }

    public static final /* synthetic */ boolean $anonfun$processNextRequest$1(ReverseConnectionTest $this, NetworkClient client$1, Node node$1, SocketServer server$1) {
        client$1.poll(1L, $this.time().milliseconds());
        Assertions.assertNull((Object)client$1.authenticationException(node$1));
        return server$1.dataPlaneRequestChannel().requestQueueSize() > 0;
    }

    public static final /* synthetic */ String $anonfun$processNextRequest$2() {
        return "Request did not arrive on server";
    }

    public static final /* synthetic */ void $anonfun$processNextRequest$3(RequestChannel.Request request$1, KafkaPrincipal principal) {
        Assertions.assertEquals((Object)principal, (Object)request$1.session().principal());
    }

    public static final /* synthetic */ boolean $anonfun$waitForClient$1(ReverseConnectionTest $this, NetworkClient client$2, Function1 predicate$1) {
        client$2.poll(1000L, $this.time().milliseconds());
        return BoxesRunTime.unboxToBoolean((Object)predicate$1.apply((Object)client$2));
    }

    public static final /* synthetic */ String $anonfun$waitForClient$2(String errorMessage$1) {
        return errorMessage$1;
    }

    public static final /* synthetic */ Object $anonfun$verifyReverseConnection$2$adapted(LinkComponents link$4, Node sourceNode$1, NetworkClient x$5) {
        return BoxesRunTime.boxToBoolean((boolean)ReverseConnectionTest.$anonfun$verifyReverseConnection$2(link$4, sourceNode$1, x$5));
    }

    public static final /* synthetic */ Object $anonfun$verifyReverseConnection$3$adapted(LinkComponents link$4, Node sourceNode$1, NetworkClient x$6) {
        return BoxesRunTime.boxToBoolean((boolean)ReverseConnectionTest.$anonfun$verifyReverseConnection$3(link$4, sourceNode$1, x$6));
    }

    public static final /* synthetic */ Object $anonfun$waitForReady$1$adapted(ReverseConnectionTest $this, Node node$2, NetworkClient x$12) {
        return BoxesRunTime.boxToBoolean((boolean)x$12.ready(node$2, $this.time().milliseconds()));
    }

    public static final /* synthetic */ Object $anonfun$waitForReversal$1$adapted(CompletableFuture future$2, NetworkClient x$13) {
        return BoxesRunTime.boxToBoolean((boolean)future$2.isDone());
    }

    public static final /* synthetic */ Object $anonfun$sendAndReceive$1$adapted(CompletableFuture future$3, NetworkClient x$14) {
        return BoxesRunTime.boxToBoolean((boolean)future$3.isDone());
    }
}

