/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.core.MetricPredicate;
import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import kafka.controller.PartitionSLOMetrics$;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogManager;
import kafka.metrics.LinuxIoMetricsCollector;
import kafka.server.BrokerTopicStats$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestInfoUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Timeout(value=120L)
@ScalaSignature(bytes="\u0006\u0005\tMc\u0001\u0002\u0013&\u0001)BQa\u000e\u0001\u0005\u0002aB\u0011b\u000f\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u001f\t\u000f!\u0003!\u0019!C\u0001\u0013\"1\u0001\u000b\u0001Q\u0001\n)Cq!\u0015\u0001C\u0002\u0013\u0005\u0011\n\u0003\u0004S\u0001\u0001\u0006IA\u0013\u0005\b'\u0002\u0011\r\u0011\"\u0001U\u0011\u0019i\u0006\u0001)A\u0005+\")a\f\u0001C\u0001?\")a\r\u0001C!O\"9A\u000f\u0001b\u0001\n\u0003I\u0005BB;\u0001A\u0003%!\nC\u0003w\u0001\u0011\u0005s\u000fC\u0004\u0002\u0004\u0001!\t!!\u0002\t\u000f\u00055\u0003\u0001\"\u0001\u0002P!9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0003bBA3\u0001\u0011\u0005\u0011q\r\u0005\b\u0003c\u0002A\u0011AA:\u0011\u001d\ti\b\u0001C\u0001\u0003\u007fBq!!#\u0001\t\u0003\tY\tC\u0004\u0002\u0016\u0002!\t!a&\t\u000f\u0005\u0005\u0006\u0001\"\u0001\u0002$\"9\u0011Q\u0016\u0001\u0005\u0002\u0005=\u0006bBA]\u0001\u0011\u0005\u00111\u0018\u0005\b\u0003\u000b\u0004A\u0011AAd\u0011\u001d\t\t\u000e\u0001C\u0001\u0003'Dq!!8\u0001\t\u0003\ty\u000eC\u0004\u0002j\u0002!\t!a;\t\u000f\u0005U\b\u0001\"\u0001\u0002x\"9!\u0011\u0001\u0001\u0005\u0002\t\r\u0001b\u0002B\u0007\u0001\u0011\u0005!q\u0002\u0005\b\u00053\u0001A\u0011\u0001B\u000e\u0011\u001d\u0011)\u0003\u0001C\u0005\u0005OAqA!\u000f\u0001\t\u0013\u0011Y\u0004C\u0004\u0003@\u0001!IA!\u0011\u0003\u00175+GO]5dgR+7\u000f\u001e\u0006\u0003M\u001d\nq!\\3ue&\u001c7OC\u0001)\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\u00162!\tas&D\u0001.\u0015\tqs%A\u0006j]R,wM]1uS>t\u0017B\u0001\u0019.\u0005YY\u0015MZ6b'\u0016\u0014h/\u001a:UKN$\b*\u0019:oKN\u001c\bC\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b(\u0003\u0015)H/\u001b7t\u0013\t14GA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005I\u0004C\u0001\u001e\u0001\u001b\u0005)\u0013!C0uKN$\u0018J\u001c4p!\tid)D\u0001?\u0015\ty\u0004)A\u0002ba&T!!\u0011\"\u0002\u000f),\b/\u001b;fe*\u00111\tR\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u000b\u0006\u0019qN]4\n\u0005\u001ds$\u0001\u0003+fgRLeNZ8\u0002\u00119,XNT8eKN,\u0012A\u0013\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0002\u001b\u0006)1oY1mC&\u0011q\n\u0014\u0002\u0004\u0013:$\u0018!\u00038v[:{G-Z:!\u0003!qW/\u001c)beR\u001c\u0018!\u00038v[B\u000b'\u000f^:!\u0003e\u0011X-];je\u0016$7*\u00194lCN+'O^3s!J,g-\u001b=\u0016\u0003U\u0003\"AV.\u000e\u0003]S!\u0001W-\u0002\t1\fgn\u001a\u0006\u00025\u0006!!.\u0019<b\u0013\tavK\u0001\u0004TiJLgnZ\u0001\u001be\u0016\fX/\u001b:fI.\u000bgm[1TKJ4XM\u001d)sK\u001aL\u0007\u0010I\u0001\u0010_Z,'O]5eS:<\u0007K]8qgV\t\u0001\r\u0005\u0002bI6\t!M\u0003\u0002d3\u0006!Q\u000f^5m\u0013\t)'M\u0001\u0006Qe>\u0004XM\u001d;jKN\fqbZ3oKJ\fG/Z\"p]\u001aLwm]\u000b\u0002QB\u0019\u0011\u000e\u001c8\u000e\u0003)T!a\u001b'\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002nU\n\u00191+Z9\u0011\u0005=\u0014X\"\u00019\u000b\u0005E<\u0013AB:feZ,'/\u0003\u0002ta\nY1*\u00194lC\u000e{gNZ5h\u0003%qW*Z:tC\u001e,7/\u0001\u0006o\u001b\u0016\u001c8/Y4fg\u0002\nQa]3u+B$\"\u0001_>\u0011\u0005-K\u0018B\u0001>M\u0005\u0011)f.\u001b;\t\u000bql\u0001\u0019\u0001\u001f\u0002\u0011Q,7\u000f^%oM>D#!\u0004@\u0011\u0005uz\u0018bAA\u0001}\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002KQ,7\u000f^'fiJL7m\u001d*fa>\u0014H/\u001a:BMR,'\u000fR3mKRLgn\u001a+pa&\u001cGc\u0001=\u0002\b!9\u0011\u0011\u0002\bA\u0002\u0005-\u0011AB9v_J,X\u000e\u0005\u0003\u0002\u000e\u0005ma\u0002BA\b\u0003/\u00012!!\u0005M\u001b\t\t\u0019BC\u0002\u0002\u0016%\na\u0001\u0010:p_Rt\u0014bAA\r\u0019\u00061\u0001K]3eK\u001aL1\u0001XA\u000f\u0015\r\tI\u0002\u0014\u0015\b\u001d\u0005\u0005\u0012\u0011GA\u001a!\u0011\t\u0019#!\f\u000e\u0005\u0005\u0015\"\u0002BA\u0014\u0003S\t\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0004\u0003W\u0001\u0015A\u00029be\u0006l7/\u0003\u0003\u00020\u0005\u0015\"a\u0003,bYV,7k\\;sG\u0016\fqa\u001d;sS:<7\u000f\f\u0003\u00026\u0005e\u0012EAA\u001c\u0003\tQ8.\t\u0002\u0002<\u0005)1N]1gi\":a\"a\u0010\u0002H\u0005%\u0003\u0003BA!\u0003\u0007j!!!\u000b\n\t\u0005\u0015\u0013\u0011\u0006\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u00028b[\u0016\f#!a\u0013\u00021m$\u0017n\u001d9mCft\u0015-\\3~]E,xN];n{m\u0004T0\u0001\u001buKN$(I]8lKJ$v\u000e]5d\u001b\u0016$(/[2t+:\u0014XmZ5ti\u0016\u0014X\rZ!gi\u0016\u0014H)\u001a7fi&tw\rV8qS\u000e$2\u0001_A)\u0011\u001d\tIa\u0004a\u0001\u0003\u0017AsaDA\u0011\u0003c\t)\u0006\f\u0003\u00026\u0005e\u0002fB\b\u0002@\u0005\u001d\u0013\u0011J\u0001\u0014i\u0016\u001cHo\u00117vgR,'/\u00133NKR\u0014\u0018n\u0019\u000b\u0004q\u0006u\u0003bBA\u0005!\u0001\u0007\u00111\u0002\u0015\b!\u0005\u0005\u0012\u0011GA1Y\u0011\t)$!\u000f)\u000fA\ty$a\u0012\u0002J\u0005)B/Z:u\u0005J|7.\u001a:Ti\u0006$X-T3ue&\u001cGc\u0001=\u0002j!9\u0011\u0011B\tA\u0002\u0005-\u0001fB\t\u0002\"\u0005E\u0012Q\u000e\u0017\u0005\u0003k\tI\u0004K\u0004\u0012\u0003\u007f\t9%!\u0013\u00029Q,7\u000f^-b[6,'/T3ue&\u001c7oQ8v]RlU\r\u001e:jGR\u0019\u00010!\u001e\t\u000f\u0005%!\u00031\u0001\u0002\f!:!#!\t\u00022\u0005eD\u0006BA\u001b\u0003sAsAEA \u0003\u000f\nI%\u0001\nuKN$H*\u001b8vq&{W*\u001a;sS\u000e\u001cHc\u0001=\u0002\u0002\"9\u0011\u0011B\nA\u0002\u0005-\u0001fB\n\u0002\"\u0005E\u0012Q\u0011\u0017\u0005\u0003k\tI\u0004K\u0004\u0014\u0003\u007f\t9%!\u0013\u0002\u001bQ,7\u000f\u001e&N1\u001aKG\u000e^3s)\rA\u0018Q\u0012\u0005\b\u0003\u0013!\u0002\u0019AA\u0006Q\u001d!\u0012\u0011EA\u0019\u0003#cC!!\u000e\u0002:!:A#a\u0010\u0002H\u0005%\u0013a\u0005;fgR,\u0006\u000fZ1uK*k\u0005LR5mi\u0016\u0014Hc\u0001=\u0002\u001a\"9\u0011\u0011B\u000bA\u0002\u0005-\u0001fB\u000b\u0002\"\u0005E\u0012Q\u0014\u0017\u0005\u0003k\tI\u0004K\u0004\u0016\u0003\u007f\t9%!\u0013\u0002eQ,7\u000f^$f]\u0016\u0014\u0018\r\u001c\"s_.,'\u000fV8qS\u000elU\r\u001e:jGN\f%/Z$sK\u0016$\u0017\u000e\\=SK\u001eL7\u000f^3sK\u0012$2\u0001_AS\u0011\u001d\tIA\u0006a\u0001\u0003\u0017AsAFA\u0011\u0003c\tI\u000b\f\u0003\u00026\u0005e\u0002f\u0002\f\u0002@\u0005\u001d\u0013\u0011J\u0001\u0019i\u0016\u001cHoV5oI><8o\u0015;zY\u0016$\u0016m\u001a(b[\u0016\u001cHc\u0001=\u00022\"9\u0011\u0011B\fA\u0002\u0005-\u0001fB\f\u0002\"\u0005E\u0012Q\u0017\u0017\u0005\u0003k\tI\u0004K\u0004\u0018\u0003\u007f\t9%!\u0013\u0002AQ,7\u000f\u001e\"s_.,'\u000fV8qS\u000elU\r\u001e:jGN\u0014\u0015\u0010^3t\u0013:|U\u000f\u001e\u000b\u0004q\u0006u\u0006bBA\u00051\u0001\u0007\u00111\u0002\u0015\b1\u0005\u0005\u0012\u0011GAaY\u0011\t)$!\u000f)\u000fa\ty$a\u0012\u0002J\u00051C/Z:u\u0005J|7.\u001a:U_BL7-T3ue&\u001c7oQ8na\u0006\u001cG/\u001a3CsR,7/\u00138\u0015\u0007a\fI\rC\u0004\u0002\ne\u0001\r!a\u0003)\u000fe\t\t#!\r\u0002N2\"\u0011QGA\u001dQ\u001dI\u0012qHA$\u0003\u0013\na\u0007^3ti\n\u0013xn[3s)>\u0004\u0018nY'fiJL7m\u001d(p\u0017\u0016L8i\\7qC\u000e$X\r\u001a+pa&\u001c'+Z2pe\u0012\u001cHj\\4hK\u0012$2\u0001_Ak\u0011\u001d\tIA\u0007a\u0001\u0003\u0017AsAGA\u0011\u0003c\tI\u000e\f\u0003\u00026\u0005e\u0002f\u0002\u000e\u0002@\u0005\u001d\u0013\u0011J\u0001\u0018i\u0016\u001cHOW6D_:$(o\u001c7mKJlU\r\u001e:jGN$2\u0001_Aq\u0011\u001d\tIa\u0007a\u0001\u0003\u0017AsaGA\u0011\u0003c\t)\u000f\f\u0002\u00026!:1$a\u0010\u0002H\u0005%\u0013A\u0007;fgR\\%+\u00194u\u0007>tGO]8mY\u0016\u0014X*\u001a;sS\u000e\u001cHc\u0001=\u0002n\"9\u0011\u0011\u0002\u000fA\u0002\u0005-\u0001f\u0002\u000f\u0002\"\u0005E\u0012\u0011\u001f\u0017\u0003\u0003sAs\u0001HA \u0003\u000f\nI%A\u0013uKN$\u0018iZ4sK\u001e\fG/\u001a*fG>\u0014H-T3ue&\u001c7/\u00138ji&\fG.\u001b>fIR\u0019\u00010!?\t\u000f\u0005%Q\u00041\u0001\u0002\f!:Q$!\t\u00022\u0005uH\u0006BA\u001b\u0003sAs!HA \u0003\u000f\nI%\u0001\u0012uKN$(I]8lKJ$v\u000e]5d\u001b\u0016$(/[2t'\u0016<W.\u001a8u%\u0016\fGm\u001d\u000b\u0004q\n\u0015\u0001bBA\u0005=\u0001\u0007\u00111\u0002\u0015\b=\u0005\u0005\u0012\u0011\u0007B\u0005Y\t\t)\u0004K\u0004\u001f\u0003\u007f\t9%!\u0013\u0002AQ,7\u000f^*fgNLwN\\#ya&\u0014X\rT5ti\u0016tWM]'fiJL7m\u001d\u000b\u0004q\nE\u0001bBA\u0005?\u0001\u0007\u00111\u0002\u0015\b?\u0005\u0005\u0012\u0011\u0007B\u000bY\u0011\t)$!\u000f)\u000f}\ty$a\u0012\u0002J\u0005\u0011B/Z:u\u0019>\fG\rT8hg6+GO]5d)\rA(Q\u0004\u0005\b\u0003\u0013\u0001\u0003\u0019AA\u0006Q\u001d\u0001\u0013\u0011EA\u0019\u0005CaC!!\u000e\u0002:!:\u0001%a\u0010\u0002H\u0005%\u0013\u0001\u0004;pa&\u001cW*\u001a;sS\u000e\u001cH\u0003\u0002B\u0015\u0005_\u0001R!\u001bB\u0016\u0003\u0017I1A!\fk\u0005\r\u0019V\r\u001e\u0005\b\u0005c\t\u0003\u0019\u0001B\u001a\u0003\u0015!x\u000e]5d!\u0015Y%QGA\u0006\u0013\r\u00119\u0004\u0014\u0002\u0007\u001fB$\u0018n\u001c8\u0002#Q|\u0007/[2NKR\u0014\u0018nY$s_V\u00048\u000f\u0006\u0003\u0003*\tu\u0002b\u0002B\u0019E\u0001\u0007\u00111B\u0001\u0019M&dG/\u001a:CsR{\u0007/[2NKR\u0014\u0018n\u0019*fO\u0016DHC\u0002B\u0015\u0005\u0007\u0012)\u0005\u0003\u0004'G\u0001\u0007!\u0011\u0006\u0005\b\u0005c\u0019\u0003\u0019\u0001B\u001aQ\u001d\u0001!\u0011\nB(\u0005#\u00022!\u0010B&\u0013\r\u0011iE\u0010\u0002\b)&lWm\\;u\u0003\u00151\u0018\r\\;f=\u0005A\b")
public class MetricsTest
extends KafkaServerTestHarness {
    private TestInfo _testInfo;
    private final int numNodes;
    private final int numParts;
    private final String requiredKafkaServerPrefix;
    private final int nMessages;

    public int numNodes() {
        return this.numNodes;
    }

    public int numParts() {
        return this.numParts;
    }

    public String requiredKafkaServerPrefix() {
        return this.requiredKafkaServerPrefix;
    }

    public Properties overridingProps() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.NumPartitionsProp(), Integer.toString(this.numParts()));
        props.put("metrics.jmx.exclude", new StringBuilder(10).append(this.requiredKafkaServerPrefix()).append("=ClusterId").toString());
        if (TestInfoUtils$.MODULE$.isKRaft(this._testInfo)) {
            props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        }
        return props;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numNodes(), this.zkConnectOrNull(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)x$2 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$2, fromProps_overrides, true);
        });
    }

    public int nMessages() {
        return this.nMessages;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this._testInfo = testInfo;
        super.setUp(testInfo);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testMetricsReporterAfterDeletingTopic(String quorum) {
        String topic = "test-topic-metric";
        this.createTopic(topic, 1, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.deleteTopic(topic, this.deleteTopic$default$2());
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), topic, 1, this.brokers());
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic), (String)"Topic metrics exists after deleteTopic");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testBrokerTopicMetricsUnregisteredAfterDeletingTopic(String quorum) {
        String topic = "test-broker-topic-metric";
        this.createTopic(topic, 2, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, this.nMessages(), -1);
        Assertions.assertTrue((boolean)this.topicMetricGroups(topic).nonEmpty(), (String)"Topic metrics don't exist");
        this.brokers().foreach((Function1 & Serializable)b -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsUnregisteredAfterDeletingTopic$1(topic, b);
            return BoxedUnit.UNIT;
        });
        this.deleteTopic(topic, this.deleteTopic$default$2());
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), topic, 1, this.brokers());
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic), (String)"Topic metrics exists after deleteTopic");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testClusterIdMetric(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testClusterIdMetric$1(this, x$3))), (int)1);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testBrokerStateMetric(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testBrokerStateMetric$1(this, x$4))), (int)1);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testYammerMetricsCountMetric(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testYammerMetricsCountMetric$1(this, x$5))), (int)1);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testLinuxIoMetrics(String quorum) {
        int expectedCount = new LinuxIoMetricsCollector("/proc", Time.SYSTEM, this.logger().underlying()).usable() ? 1 : 0;
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        ((IterableOnceOps)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"linux-disk-read-bytes", "linux-disk-write-bytes"}))).foreach((Function1 & Serializable)name -> {
            MetricsTest.$anonfun$testLinuxIoMetrics$1(this, expectedCount, metrics, name);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testJMXFilter(String quorum) {
        Assertions.assertTrue((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName("kafka.controller:type=KafkaController,name=ActiveControllerCount")));
        Assertions.assertFalse((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName(new StringBuilder(10).append(this.requiredKafkaServerPrefix()).append("=ClusterId").toString())));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testUpdateJMXFilter(String quorum) {
        this.brokers().foreach((Function1 & Serializable)broker -> {
            MetricsTest.$anonfun$testUpdateJMXFilter$1(broker);
            return BoxedUnit.UNIT;
        });
        Assertions.assertFalse((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName("kafka.controller:type=KafkaController,name=ActiveControllerCount")));
        Assertions.assertTrue((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName(new StringBuilder(10).append(this.requiredKafkaServerPrefix()).append("=ClusterId").toString())));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testGeneralBrokerTopicMetricsAreGreedilyRegistered(String quorum) {
        String topic = "test-broker-topic-metric";
        this.createTopic(topic, 2, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        Assertions.assertTrue((boolean)this.topicMetrics((Option<String>)None$.MODULE$).nonEmpty(), (String)"General topic metrics don't exist");
        ((KafkaBroker)this.brokers().head()).brokerTopicStats().allTopicsStats().logAppendLatencyMs();
        ((KafkaBroker)this.brokers().head()).brokerTopicStats().allTopicsStats().logAppendDataSizeInBytes();
        ((KafkaBroker)this.brokers().head()).brokerTopicStats().allTopicsStats().localLogFetchLatencyMs();
        ((KafkaBroker)this.brokers().head()).brokerTopicStats().allTopicsStats().tierLogFetchLatencyMs();
        ((KafkaBroker)this.brokers().head()).brokerTopicStats().allTopicsStats().logFetchDataSizeInBytes();
        ((KafkaBroker)this.brokers().head()).brokerTopicStats().allTopicsStats().consumerFetchLagTimeMs();
        Assertions.assertEquals((int)(((KafkaBroker)this.brokers().head()).brokerTopicStats().allTopicsStats().metricMap().size() + 10), (int)this.topicMetrics((Option<String>)None$.MODULE$).size());
        Assertions.assertTrue((boolean)this.topicMetricGroups(topic).isEmpty(), (String)"Topic metrics aren't lazily registered");
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, this.nMessages(), -1);
        Assertions.assertTrue((boolean)this.topicMetricGroups(topic).nonEmpty(), (String)"Topic metrics aren't registered");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testWindowsStyleTagNames(String quorum) {
        String path = "C:\\windows-path\\kafka-logs";
        Map tags = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dir"), (Object)path)}));
        String expectedMBeanName = ((IterableOnceOps)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)tags.keySet().head(), ObjectName.quote(path)}))).mkString("=");
        com.yammer.metrics.core.MetricName metric = new KafkaMetricsGroup(this.getClass()).metricName("test-metric", CollectionConverters$.MODULE$.MapHasAsJava(tags).asJava());
        Predef$.MODULE$.assert(metric.getMBeanName().endsWith(expectedMBeanName));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testBrokerTopicMetricsBytesInOut(String quorum) {
        String topic = "test-bytes-in-out";
        String replicationBytesIn = BrokerTopicStats$.MODULE$.ReplicationBytesInPerSec();
        String replicationBytesOut = BrokerTopicStats$.MODULE$.ReplicationBytesOutPerSec();
        String bytesIn = new StringBuilder(7).append(BrokerTopicStats$.MODULE$.BytesInPerSec()).append(",topic=").append(topic).toString();
        String bytesOut = new StringBuilder(7).append(BrokerTopicStats$.MODULE$.BytesOutPerSec()).append(",topic=").append(topic).toString();
        Properties topicConfig = new Properties();
        topicConfig.setProperty("min.insync.replicas", "2");
        this.createTopic(topic, 1, this.numNodes(), topicConfig, this.createTopic$default$5(), this.createTopic$default$6());
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, this.nMessages(), -1);
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.brokers().foreach((Function1 & Serializable)broker -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsBytesInOut$1(topicPartition, broker);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.consumeTopicRecords(this.brokers(), topic, this.nMessages(), "group", SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, 15000L, (String)null);
        long initialReplicationBytesIn = TestUtils$.MODULE$.meterCount(replicationBytesIn);
        long initialReplicationBytesOut = TestUtils$.MODULE$.meterCount(replicationBytesOut);
        long initialBytesIn = TestUtils$.MODULE$.meterCount(bytesIn);
        long initialBytesOut = TestUtils$.MODULE$.meterCount(bytesOut);
        Assertions.assertEquals((long)initialBytesOut, (long)TestUtils$.MODULE$.meterCount(bytesOut));
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, this.nMessages(), -1);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(replicationBytesIn) > initialReplicationBytesIn ? 1 : 0) != 0);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(replicationBytesOut) > initialReplicationBytesOut ? 1 : 0) != 0);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(bytesIn) > initialBytesIn ? 1 : 0) != 0);
        TestUtils$.MODULE$.consumeTopicRecords(this.brokers(), topic, this.nMessages(), "group", SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, 15000L, (String)null);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(bytesOut) > initialBytesOut ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testBrokerTopicMetricsCompactedBytesIn(String quorum) {
        String topicCompacted = "test-bytes-in-compacted-topic";
        String topicNotCompacted = "test-bytes-in-not-compacted-topic";
        .colon.colon topics = new .colon.colon((Object)topicCompacted, (List)new .colon.colon((Object)topicNotCompacted, (List)Nil$.MODULE$));
        String bytesInCompactedTopic = new StringBuilder(7).append(BrokerTopicStats$.MODULE$.BytesInPerSec()).append(",topic=").append(topicCompacted).toString();
        String bytesInNotCompactedTopic = new StringBuilder(7).append(BrokerTopicStats$.MODULE$.BytesInPerSec()).append(",topic=").append(topicNotCompacted).toString();
        String totalBytesIn = BrokerTopicStats$.MODULE$.BytesInPerSec();
        String totalCompactedBytesIn = BrokerTopicStats$.MODULE$.CompactedTopicsBytesInPerSec();
        Properties topicConfigCompacted = new Properties();
        topicConfigCompacted.setProperty("min.insync.replicas", "2");
        topicConfigCompacted.setProperty("cleanup.policy", "compact");
        this.createTopic(topicCompacted, 1, this.numNodes(), topicConfigCompacted, this.createTopic$default$5(), this.createTopic$default$6());
        Properties topicConfigNotCompacted = new Properties();
        topicConfigNotCompacted.setProperty("min.insync.replicas", "2");
        topicConfigNotCompacted.setProperty("cleanup.policy", "delete");
        this.createTopic(topicNotCompacted, 1, this.numNodes(), topicConfigNotCompacted, this.createTopic$default$5(), this.createTopic$default$6());
        topics.foreach((Function1 & Serializable)topic -> TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), (String)topic, this.nMessages(), -1));
        topics.foreach((Function1 & Serializable)topic -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsCompactedBytesIn$2(this, topic);
            return BoxedUnit.UNIT;
        });
        long initialCompactedTopicBytesIn = TestUtils$.MODULE$.meterCount(bytesInCompactedTopic);
        long initialNotCompactedTopicBytesIn = TestUtils$.MODULE$.meterCount(bytesInNotCompactedTopic);
        long initialTotalBytesIn = TestUtils$.MODULE$.meterCount(totalBytesIn);
        long initialTotalCompactedBytesIn = TestUtils$.MODULE$.meterCount(totalCompactedBytesIn);
        Assertions.assertEquals((long)initialCompactedTopicBytesIn, (long)initialNotCompactedTopicBytesIn);
        Assertions.assertEquals((long)(initialCompactedTopicBytesIn + initialNotCompactedTopicBytesIn), (long)initialTotalBytesIn);
        Assertions.assertEquals((long)initialCompactedTopicBytesIn, (long)initialTotalCompactedBytesIn);
        topics.foreach((Function1 & Serializable)topic -> TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), (String)topic, this.nMessages(), -1));
        long finalCompactedTopicBytesIn = TestUtils$.MODULE$.meterCount(bytesInCompactedTopic);
        long finalNotCompactedTopicBytesIn = TestUtils$.MODULE$.meterCount(bytesInNotCompactedTopic);
        long finalTotalBytesIn = TestUtils$.MODULE$.meterCount(totalBytesIn);
        long finalTotalCompactedBytesIn = TestUtils$.MODULE$.meterCount(totalCompactedBytesIn);
        Assertions.assertEquals((long)finalCompactedTopicBytesIn, (long)finalNotCompactedTopicBytesIn);
        Assertions.assertEquals((long)(finalCompactedTopicBytesIn + finalNotCompactedTopicBytesIn), (long)finalTotalBytesIn);
        Assertions.assertEquals((long)finalCompactedTopicBytesIn, (long)finalTotalCompactedBytesIn);
        Assertions.assertTrue((finalCompactedTopicBytesIn > initialCompactedTopicBytesIn ? 1 : 0) != 0);
        Assertions.assertTrue((finalNotCompactedTopicBytesIn > initialNotCompactedTopicBytesIn ? 1 : 0) != 0);
        Assertions.assertTrue((finalTotalBytesIn > initialTotalBytesIn ? 1 : 0) != 0);
        Assertions.assertTrue((finalTotalCompactedBytesIn > initialTotalCompactedBytesIn ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testBrokerTopicMetricsNoKeyCompactedTopicRecordsLogged(String quorum) {
        String topic = "test-compacted-topic-record-no-key";
        Properties topicConfig = new Properties();
        topicConfig.setProperty("cleanup.policy", "compact");
        this.createTopic(topic, 1, this.numNodes(), topicConfig, this.createTopic$default$5(), this.createTopic$default$6());
        try {
            TestUtils$.MODULE$.produceMessages(this.brokers(), (Seq<ProducerRecord<byte[], byte[]>>)new .colon.colon((Object)new ProducerRecord(topic, (Object)"test".getBytes()), (List)Nil$.MODULE$), -1);
            Assertions.fail((String)"Exception should have been thrown since a compacted topic cannot accept a message without keys");
        }
        catch (Exception exception) {}
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().count((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testBrokerTopicMetricsNoKeyCompactedTopicRecordsLogged$1(x$11))));
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount("name=NoKeyCompactedTopicRecordsPerSec") > 0L ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testZkControllerMetrics(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$1(x$12))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$2(x$13))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$3(x$14))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$4(x$15))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$5(x$16))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$6(x$17))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$7(x$18))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$8(x$19))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$9(x$20))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$10(x$21))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$11(x$22))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$12(x$23))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$13(x$24))), (int)1);
        PartitionSLOMetrics$.MODULE$.onControllerChange(0, true, true);
        PartitionSLOMetrics$.MODULE$.updateTenantPartitionMetrics("lkc-123_test", 0, 0, 0);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$14(x$25))), (int)1);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testKRaftControllerMetrics(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        ((IterableOnceOps)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"kafka.controller:type=KafkaController,name=ActiveControllerCount", "kafka.controller:type=KafkaController,name=GlobalPartitionCount", "kafka.controller:type=KafkaController,name=GlobalTopicCount", "kafka.controller:type=KafkaController,name=LastAppliedRecordLagMs", "kafka.controller:type=KafkaController,name=LastAppliedRecordOffset", "kafka.controller:type=KafkaController,name=LastAppliedRecordTimestamp", "kafka.controller:type=KafkaController,name=LastCommittedRecordOffset", "kafka.controller:type=KafkaController,name=MetadataErrorCount", "kafka.controller:type=KafkaController,name=OfflinePartitionsCount", "kafka.controller:type=KafkaController,name=PreferredReplicaImbalanceCount"}))).foreach((Function1 & Serializable)expected -> {
            MetricsTest.$anonfun$testKRaftControllerMetrics$1(metrics, expected);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAggregateRecordMetricsInitialized(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testAggregateRecordMetricsInitialized$1(x$27))));
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testAggregateRecordMetricsInitialized$2(x$28))));
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testAggregateRecordMetricsInitialized$3(x$29))));
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testAggregateRecordMetricsInitialized$4(x$30))));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testBrokerTopicMetricsSegmentReads(String quorum) {
        String topic = "test-segment-reads";
        String segmentReads = BrokerTopicStats$.MODULE$.SegmentReadsPerSec();
        String segmentSpeculativePrefetches = BrokerTopicStats$.MODULE$.SegmentSpeculativePrefetchesPerSec();
        Properties topicConfig = new Properties();
        topicConfig.setProperty("confluent.segment.speculative.prefetch.enable", "true");
        topicConfig.setProperty("segment.bytes", "128");
        this.createTopic(topic, 1, this.numNodes(), topicConfig, this.createTopic$default$5(), this.createTopic$default$6());
        Assertions.assertEquals((long)0L, (long)TestUtils$.MODULE$.meterCount(segmentReads));
        Assertions.assertEquals((long)0L, (long)TestUtils$.MODULE$.meterCount(segmentSpeculativePrefetches));
        MetricsTest.testTopicMetricFails$1(segmentReads, topic);
        MetricsTest.testTopicMetricFails$1(segmentSpeculativePrefetches, topic);
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, 1, -1);
        TestUtils$.MODULE$.consumeTopicRecords(this.brokers(), topic, 1, "group", SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, 15000L, (String)null);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(segmentReads) > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((long)0L, (long)TestUtils$.MODULE$.meterCount(segmentSpeculativePrefetches));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 32).foreach((Function1 & Serializable)x$31 -> TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, 1, -1));
        TestUtils$.MODULE$.consumeTopicRecords(this.brokers(), topic, 32, "group", SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, 15000L, (String)null);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(segmentReads) > 1L ? 1 : 0) != 0);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(segmentSpeculativePrefetches) > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(segmentReads) - 1L > TestUtils$.MODULE$.meterCount(segmentSpeculativePrefetches) ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSessionExpireListenerMetrics(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        int expectedNumMetrics = this.isKRaftTest() ? 0 : 1;
        Assertions.assertEquals((int)expectedNumMetrics, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testSessionExpireListenerMetrics$1(x$32))));
        Assertions.assertEquals((int)expectedNumMetrics, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testSessionExpireListenerMetrics$2(x$33))));
        Assertions.assertEquals((int)expectedNumMetrics, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$34 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testSessionExpireListenerMetrics$3(x$34))));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testLoadLogsMetric(String quorum) {
        String topic = "test-load-logs-metric";
        this.createTopic(topic, 1, this.numNodes(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, 1, -1);
        this.brokers().foreach((Function1 & Serializable)broker -> {
            MetricsTest.$anonfun$testLoadLogsMetric$1(broker);
            return BoxedUnit.UNIT;
        });
    }

    private Set<String> topicMetrics(Option<String> topic) {
        scala.collection.mutable.Set metricNames = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().map((Function1 & Serializable)x$35 -> x$35.getMBeanName());
        return this.filterByTopicMetricRegex((Set<String>)metricNames, topic);
    }

    private Set<String> topicMetricGroups(String topic) {
        scala.collection.mutable.Set metricGroups = CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().groupedMetrics(MetricPredicate.ALL).keySet()).asScala();
        return this.filterByTopicMetricRegex((Set<String>)metricGroups, (Option<String>)new Some((Object)topic));
    }

    private Set<String> filterByTopicMetricRegex(Set<String> metrics, Option<String> topic) {
        Pattern pattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new StringBuilder(22).append(".*BrokerTopicMetrics.*").append(topic.map((Function1 & Serializable)t -> new StringBuilder(3).append("(").append((String)t).append(")$").toString()).getOrElse((Function0 & Serializable)() -> "")).toString())).pattern();
        return (Set)metrics.filter((Function1 & Serializable)x$36 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$filterByTopicMetricRegex$3(pattern, x$36)));
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsUnregisteredAfterDeletingTopic$1(String topic$1, KafkaBroker b) {
        Assertions.assertNotNull((Object)b.brokerTopicStats().topicStats(topic$1));
    }

    public static final /* synthetic */ boolean $anonfun$testClusterIdMetric$1(MetricsTest $this, com.yammer.metrics.core.MetricName x$3) {
        String string = x$3.getMBeanName();
        String string2 = new StringBuilder(10).append($this.requiredKafkaServerPrefix()).append("=ClusterId").toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerStateMetric$1(MetricsTest $this, com.yammer.metrics.core.MetricName x$4) {
        String string = x$4.getMBeanName();
        String string2 = new StringBuilder(12).append($this.requiredKafkaServerPrefix()).append("=BrokerState").toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testYammerMetricsCountMetric$1(MetricsTest $this, com.yammer.metrics.core.MetricName x$5) {
        String string = x$5.getMBeanName();
        String string2 = new StringBuilder(21).append($this.requiredKafkaServerPrefix()).append("=yammer-metrics-count").toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testLinuxIoMetrics$2(MetricsTest $this, String name$1, com.yammer.metrics.core.MetricName x$6) {
        String string = x$6.getMBeanName();
        String string2 = new StringBuilder(1).append($this.requiredKafkaServerPrefix()).append("=").append(name$1).toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testLinuxIoMetrics$1(MetricsTest $this, int expectedCount$1, java.util.Map metrics$1, String name) {
        Assertions.assertEquals((int)expectedCount$1, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics$1.keySet()).asScala().count((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testLinuxIoMetrics$2($this, name, x$6))));
    }

    public static final /* synthetic */ void $anonfun$testUpdateJMXFilter$1(KafkaBroker broker) {
        broker.kafkaYammerMetrics().reconfigure(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metrics.jmx.exclude"), (Object)"kafka.controller:type=KafkaController,name=ActiveControllerCount")}))).asJava());
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsBytesInOut$1(TopicPartition topicPartition$1, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(topicPartition$1, x$2);
        int brokerId = broker.config().brokerId();
        Option logSize = log.map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.size()));
        Assertions.assertTrue((boolean)logSize.exists((Function1)(JFunction1.mcZJ.sp & Serializable)x$8 -> x$8 > 0L), (String)new StringBuilder(64).append("Expected broker ").append(brokerId).append(" to have a Log for ").append(topicPartition$1).append(" with positive size, actual: ").append(logSize).toString());
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsCompactedBytesIn$3(TopicPartition topicPartition$2, KafkaBroker server) {
        LogManager qual$1 = server.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(topicPartition$2, x$2);
        int brokerId = server.config().brokerId();
        Option logSize = log.map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.size()));
        Assertions.assertTrue((boolean)logSize.exists((Function1)(JFunction1.mcZJ.sp & Serializable)x$10 -> x$10 > 0L), (String)new StringBuilder(64).append("Expected broker ").append(brokerId).append(" to have a Log for ").append(topicPartition$2).append(" with positive size, actual: ").append(logSize).toString());
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsCompactedBytesIn$2(MetricsTest $this, String topic) {
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        $this.brokers().foreach((Function1 & Serializable)server -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsCompactedBytesIn$3(topicPartition, server);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerTopicMetricsNoKeyCompactedTopicRecordsLogged$1(com.yammer.metrics.core.MetricName x$11) {
        return x$11.getMBeanName().endsWith("name=NoKeyCompactedTopicRecordsPerSec");
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$1(com.yammer.metrics.core.MetricName x$12) {
        String string = x$12.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ActiveControllerCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$2(com.yammer.metrics.core.MetricName x$13) {
        String string = x$13.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=PreferredReplicaImbalanceCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$3(com.yammer.metrics.core.MetricName x$14) {
        String string = x$14.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=GlobalTopicCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$4(com.yammer.metrics.core.MetricName x$15) {
        String string = x$15.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=TopicsToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$5(com.yammer.metrics.core.MetricName x$16) {
        String string = x$16.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ReplicasToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$6(com.yammer.metrics.core.MetricName x$17) {
        String string = x$17.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=TopicsIneligibleToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$7(com.yammer.metrics.core.MetricName x$18) {
        String string = x$18.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ReplicasIneligibleToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$8(com.yammer.metrics.core.MetricName x$19) {
        String string = x$19.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ActiveBrokerCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$9(com.yammer.metrics.core.MetricName x$20) {
        String string = x$20.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=FencedBrokerCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$10(com.yammer.metrics.core.MetricName x$21) {
        String string = x$21.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=OfflinePartitionsCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$11(com.yammer.metrics.core.MetricName x$22) {
        String string = x$22.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=GlobalPartitionCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$12(com.yammer.metrics.core.MetricName x$23) {
        String string = x$23.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=GlobalUnderMinIsrPartitionCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$13(com.yammer.metrics.core.MetricName x$24) {
        String string = x$24.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=PartitionAvailability";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$14(com.yammer.metrics.core.MetricName x$25) {
        String string = x$25.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=TenantPartitionAvailability,tenant=lkc-123";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testKRaftControllerMetrics$2(String expected$1, com.yammer.metrics.core.MetricName x$26) {
        return x$26.getMBeanName().equals(expected$1);
    }

    public static final /* synthetic */ void $anonfun$testKRaftControllerMetrics$1(java.util.Map metrics$2, String expected) {
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics$2.keySet()).asScala().count((Function1 & Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testKRaftControllerMetrics$2(expected, x$26))), (String)new StringBuilder(15).append("Unable to find ").append(expected).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testAggregateRecordMetricsInitialized$1(com.yammer.metrics.core.MetricName x$27) {
        return x$27.getMBeanName().startsWith("kafka.server:type=BrokerTopicMetrics,name=NoKeyCompactedTopicRecordsPerSec");
    }

    public static final /* synthetic */ boolean $anonfun$testAggregateRecordMetricsInitialized$2(com.yammer.metrics.core.MetricName x$28) {
        return x$28.getMBeanName().startsWith("kafka.server:type=BrokerTopicMetrics,name=InvalidMagicNumberRecordsPerSec");
    }

    public static final /* synthetic */ boolean $anonfun$testAggregateRecordMetricsInitialized$3(com.yammer.metrics.core.MetricName x$29) {
        return x$29.getMBeanName().startsWith("kafka.server:type=BrokerTopicMetrics,name=InvalidMessageCrcRecordsPerSec");
    }

    public static final /* synthetic */ boolean $anonfun$testAggregateRecordMetricsInitialized$4(com.yammer.metrics.core.MetricName x$30) {
        return x$30.getMBeanName().startsWith("kafka.server:type=BrokerTopicMetrics,name=NonIncreasingOffsetRecordsPerSec");
    }

    private static final void testTopicMetricFails$1(String metric, String topic$2) {
        Assertions.assertThrows(Throwable.class, () -> TestUtils$.MODULE$.meterCount(new StringBuilder(7).append(metric).append(",topic=").append(topic$2).toString()));
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpireListenerMetrics$1(com.yammer.metrics.core.MetricName x$32) {
        String string = x$32.getMBeanName();
        String string2 = "kafka.server:type=SessionExpireListener,name=SessionState";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpireListenerMetrics$2(com.yammer.metrics.core.MetricName x$33) {
        String string = x$33.getMBeanName();
        String string2 = "kafka.server:type=SessionExpireListener,name=ZooKeeperExpiresPerSec";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpireListenerMetrics$3(com.yammer.metrics.core.MetricName x$34) {
        String string = x$34.getMBeanName();
        String string2 = "kafka.server:type=SessionExpireListener,name=ZooKeeperDisconnectsPerSec";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$testLoadLogsMetric$1(KafkaBroker broker) {
        broker.shutdown();
        broker.startup();
        MetricName loadLogsTimeAvgMetric = broker.metrics().metricName("load-logs-time-avg", "log-manager-metrics");
        MetricName loadLogsTimeMaxMetric = broker.metrics().metricName("load-logs-time-max", "log-manager-metrics");
        Assertions.assertTrue((boolean)broker.metrics().metrics().containsKey(loadLogsTimeAvgMetric));
        Assertions.assertTrue((boolean)broker.metrics().metrics().containsKey(loadLogsTimeMaxMetric));
        Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)((KafkaMetric)broker.metrics().metrics().get(loadLogsTimeAvgMetric)).metricValue()) > 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)((KafkaMetric)broker.metrics().metrics().get(loadLogsTimeMaxMetric)).metricValue()) > 0.0 ? 1 : 0) != 0);
    }

    public static final /* synthetic */ boolean $anonfun$filterByTopicMetricRegex$3(Pattern pattern$1, String x$36) {
        return pattern$1.matcher(x$36).matches();
    }

    public MetricsTest() {
        this.numNodes = 2;
        this.numParts = 2;
        this.requiredKafkaServerPrefix = "kafka.server:type=KafkaServer,name";
        this.nMessages = 2;
    }
}

