/*
 * Decompiled with CFR 0.152.
 */
package kafka.log.remote;

import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import kafka.log.MergedLog$;
import kafka.log.remote.RemoteIndexCache;
import kafka.utils.MockTime;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteStorageManager;
import org.apache.kafka.storage.internals.log.OffsetIndex;
import org.apache.kafka.storage.internals.log.OffsetPosition;
import org.apache.kafka.storage.internals.log.TimeIndex;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Disabled
@ScalaSignature(bytes="\u0006\u0005\t5a\u0001B\u0014)\u0001=BQA\u000e\u0001\u0005\u0002]BqA\u000f\u0001C\u0002\u0013\u00051\b\u0003\u0004C\u0001\u0001\u0006I\u0001\u0010\u0005\b\u0007\u0002\u0011\r\u0011\"\u0001E\u0011\u0019\u0001\u0006\u0001)A\u0005\u000b\"9\u0011\u000b\u0001b\u0001\n\u0003\u0011\u0006B\u0002,\u0001A\u0003%1\u000bC\u0004X\u0001\t\u0007I\u0011\u0001-\t\r\u0005\u0004\u0001\u0015!\u0003Z\u0011\u001d\u0011\u0007A1A\u0005\u0002aCaa\u0019\u0001!\u0002\u0013I\u0006b\u00023\u0001\u0005\u0004%\t!\u001a\u0005\u0007S\u0002\u0001\u000b\u0011\u00024\t\u000f)\u0004!\u0019!C\u0001W\"1q\u000e\u0001Q\u0001\n1Dq\u0001\u001d\u0001C\u0002\u0013\u00051\u000e\u0003\u0004r\u0001\u0001\u0006I\u0001\u001c\u0005\be\u0002\u0011\r\u0011\"\u0001f\u0011\u0019\u0019\b\u0001)A\u0005M\"9A\u000f\u0001b\u0001\n\u0003)\bbBA\u0001\u0001\u0001\u0006IA\u001e\u0005\n\u0003\u0007\u0001!\u0019!C\u0001\u0003\u000bA\u0001\"!\u0004\u0001A\u0003%\u0011q\u0001\u0005\n\u0003\u001f\u0001!\u0019!C\u0001\u0003#A\u0001\"!\u0007\u0001A\u0003%\u00111\u0003\u0005\n\u00037\u0001!\u0019!C\u0001\u0003;A\u0001\"!\n\u0001A\u0003%\u0011q\u0004\u0005\b\u0003O\u0001A\u0011AA\u0015\u0011\u001d\t9\u0005\u0001C\u0001\u0003SAq!!\u0015\u0001\t\u0003\tI\u0003C\u0004\u0002\\\u0001!\t!!\u000b\t\u000f\u0005}\u0003\u0001\"\u0001\u0002*!9\u00111\r\u0001\u0005\u0002\u0005%\u0002bBA4\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003W\u0002A\u0011BA7\u0011%\tI\fAI\u0001\n\u0013\tY\fC\u0004\u0002R\u0002!I!a5\t\u000f\u0005\r\b\u0001\"\u0003\u0002f\n!\"+Z7pi\u0016Le\u000eZ3y\u0007\u0006\u001c\u0007.\u001a+fgRT!!\u000b\u0016\u0002\rI,Wn\u001c;f\u0015\tYC&A\u0002m_\u001eT\u0011!L\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0007\u0005\u00022i5\t!GC\u00014\u0003\u0015\u00198-\u00197b\u0013\t)$G\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003a\u0002\"!\u000f\u0001\u000e\u0003!\nA\u0001^5nKV\tA\b\u0005\u0002>\u00016\taH\u0003\u0002@Y\u0005)Q\u000f^5mg&\u0011\u0011I\u0010\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005I\u0001/\u0019:uSRLwN\\\u000b\u0002\u000bB\u0011aIT\u0007\u0002\u000f*\u0011\u0001*S\u0001\u0007G>lWn\u001c8\u000b\u00055R%BA&M\u0003\u0019\t\u0007/Y2iK*\tQ*A\u0002pe\u001eL!aT$\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006Q\u0001/\u0019:uSRLwN\u001c\u0011\u0002\u0017%$\u0007+\u0019:uSRLwN\\\u000b\u0002'B\u0011a\tV\u0005\u0003+\u001e\u0013\u0001\u0003V8qS\u000eLE\rU1si&$\u0018n\u001c8\u0002\u0019%$\u0007+\u0019:uSRLwN\u001c\u0011\u0002\r1|w\rR5s+\u0005I\u0006C\u0001.`\u001b\u0005Y&B\u0001/^\u0003\tIwNC\u0001_\u0003\u0011Q\u0017M^1\n\u0005\u0001\\&\u0001\u0002$jY\u0016\fq\u0001\\8h\t&\u0014\b%A\u0003ua\u0012K'/\u0001\u0004ua\u0012K'\u000fI\u0001\tEJ|7.\u001a:JIV\ta\r\u0005\u00022O&\u0011\u0001N\r\u0002\u0004\u0013:$\u0018!\u00032s_.,'/\u00133!\u0003)\u0011\u0017m]3PM\u001a\u001cX\r^\u000b\u0002YB\u0011\u0011'\\\u0005\u0003]J\u0012A\u0001T8oO\u0006Y!-Y:f\u001f\u001a47/\u001a;!\u0003)a\u0017m\u001d;PM\u001a\u001cX\r^\u0001\fY\u0006\u001cHo\u00144gg\u0016$\b%A\u0006tK\u001elWM\u001c;TSj,\u0017\u0001D:fO6,g\u000e^*ju\u0016\u0004\u0013a\u0001:t[V\ta\u000f\u0005\u0002x}6\t\u0001P\u0003\u0002zu\u000691\u000f^8sC\u001e,'BA\u0015|\u0015\tYCP\u0003\u0002~\u0013\u000611/\u001a:wKJL!a =\u0003)I+Wn\u001c;f'R|'/Y4f\u001b\u0006t\u0017mZ3s\u0003\u0011\u00118/\u001c\u0011\u0002\u000b\r\f7\r[3\u0016\u0005\u0005\u001d\u0001cA\u001d\u0002\n%\u0019\u00111\u0002\u0015\u0003!I+Wn\u001c;f\u0013:$W\r_\"bG\",\u0017AB2bG\",\u0007%\u0001\nsK6|G/\u001a'pON+w-\\3oi&#WCAA\n!\r9\u0018QC\u0005\u0004\u0003/A(A\u0005*f[>$X\rT8h'\u0016<W.\u001a8u\u0013\u0012\f1C]3n_R,Gj\\4TK\u001elWM\u001c;JI\u0002\n1B\u001d7t\u001b\u0016$\u0018\rZ1uCV\u0011\u0011q\u0004\t\u0004o\u0006\u0005\u0012bAA\u0012q\nA\"+Z7pi\u0016dunZ*fO6,g\u000e^'fi\u0006$\u0017\r^1\u0002\u0019Id7/T3uC\u0012\fG/\u0019\u0011\u0002\u000bM,G/\u001e9\u0015\u0005\u0005-\u0002cA\u0019\u0002.%\u0019\u0011q\u0006\u001a\u0003\tUs\u0017\u000e\u001e\u0015\u00049\u0005M\u0002\u0003BA\u001b\u0003\u0007j!!a\u000e\u000b\t\u0005e\u00121H\u0001\u0004CBL'\u0002BA\u001f\u0003\u007f\tqA[;qSR,'OC\u0002\u0002B1\u000bQA[;oSRLA!!\u0012\u00028\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u000f\rdW-\u00198va\"\u001aQ$a\u0013\u0011\t\u0005U\u0012QJ\u0005\u0005\u0003\u001f\n9DA\u0005BMR,'/R1dQ\u0006yB/Z:u\r\u0016$8\r[%oI\u0016DhI]8n%\u0016lw\u000e^3Ti>\u0014\u0018mZ3)\u0007y\t)\u0006\u0005\u0003\u00026\u0005]\u0013\u0002BA-\u0003o\u0011A\u0001V3ti\u0006\u0001D/Z:u!>\u001c\u0018\u000e^5p]\u001a{'OT8o\u000bbL7\u000f^5oO&sG-\u001a=Ge>l'+Z7pi\u0016\u001cFo\u001c:bO\u0016D3aHA+\u0003Q!Xm\u001d;DC\u000eDW-\u00128uef,\u0005\u0010]5ss\"\u001a\u0001%!\u0016\u00027Q,7\u000f^$fi&sG-\u001a=BMR,'oQ1dQ\u0016\u001cEn\\:fQ\r\t\u0013QK\u0001\u001ai\u0016\u001cHOU3m_\u0006$7)Y2iK\u00063G/\u001a:DY>\u001cX\rK\u0002#\u0003+\n!D^3sS\u001aLh)\u001a;dQ&sG-\u001a=J]Z|7-\u0019;j_:$b!a\u000b\u0002p\u0005M\u0004BBA9G\u0001\u0007a-A\u0003d_VtG\u000fC\u0005\u0002v\r\u0002\n\u00111\u0001\u0002x\u0005Q\u0011N\u001c3fqRK\b/Z:\u0011\r\u0005e\u0014\u0011RAH\u001d\u0011\tY(!\"\u000f\t\u0005u\u00141Q\u0007\u0003\u0003\u007fR1!!!/\u0003\u0019a$o\\8u}%\t1'C\u0002\u0002\bJ\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\f\u00065%aA*fc*\u0019\u0011q\u0011\u001a\u0011\t\u0005E\u00151\u0017\b\u0005\u0003'\u000byK\u0004\u0003\u0002\u0016\u00065f\u0002BAL\u0003WsA!!'\u0002*:!\u00111TAT\u001d\u0011\ti*!*\u000f\t\u0005}\u00151\u0015\b\u0005\u0003{\n\t+C\u0001N\u0013\tYE*\u0003\u0002.\u0015&\u0011Q0S\u0005\u0003WqL!!K>\n\u0005eT\u0018bAAYq\u0006!\"+Z7pi\u0016\u001cFo\u001c:bO\u0016l\u0015M\\1hKJLA!!.\u00028\nI\u0011J\u001c3fqRK\b/\u001a\u0006\u0004\u0003cC\u0018\u0001\n<fe&4\u0017PR3uG\"Le\u000eZ3y\u0013:4xnY1uS>tG\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005u&\u0006BA<\u0003\u007f[#!!1\u0011\t\u0005\r\u0017QZ\u0007\u0003\u0003\u000bTA!a2\u0002J\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0017\u0014\u0014AC1o]>$\u0018\r^5p]&!\u0011qZAc\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001!O\u0016tWM]1uKJ+Wn\u001c;f\u0019><7+Z4nK:$X*\u001a;bI\u0006$\u0018\r\u0006\u0004\u0002V\u0006m\u0017q\u001c\t\u0007\u0003s\n9.a\b\n\t\u0005e\u0017Q\u0012\u0002\u0005\u0019&\u001cH\u000f\u0003\u0004\u0002^\u0016\u0002\rAZ\u0001\u0005g&TX\r\u0003\u0004\u0002b\u0016\u0002\raU\u0001\u0005iBLE-A\fnCf\u0014W-\u00119qK:$\u0017J\u001c3fq\u0016sGO]5fgR1\u00111FAt\u0003wDq!!;'\u0001\u0004\tY/A\u0006pM\u001a\u001cX\r^%oI\u0016D\b\u0003BAw\u0003ol!!a<\u000b\u0007-\n\tP\u0003\u0003\u0002t\u0006U\u0018!C5oi\u0016\u0014h.\u00197t\u0015\tI\u0018*\u0003\u0003\u0002z\u0006=(aC(gMN,G/\u00138eKbDq!!@'\u0001\u0004\ty0A\u0005uS6,\u0017J\u001c3fqB!\u0011Q\u001eB\u0001\u0013\u0011\u0011\u0019!a<\u0003\u0013QKW.Z%oI\u0016D\bf\u0001\u0001\u0003\bA!\u0011Q\u0007B\u0005\u0013\u0011\u0011Y!a\u000e\u0003\u0011\u0011K7/\u00192mK\u0012\u0004")
public class RemoteIndexCacheTest {
    private final MockTime time = new MockTime();
    private final TopicPartition partition = new TopicPartition("foo", 0);
    private final TopicIdPartition idPartition = new TopicIdPartition(Uuid.randomUuid(), this.partition());
    private final File logDir;
    private final File tpDir;
    private final int brokerId;
    private final long baseOffset;
    private final long lastOffset;
    private final int segmentSize;
    private final RemoteStorageManager rsm;
    private final RemoteIndexCache cache;
    private final RemoteLogSegmentId remoteLogSegmentId;
    private final RemoteLogSegmentMetadata rlsMetadata;

    public MockTime time() {
        return this.time;
    }

    public TopicPartition partition() {
        return this.partition;
    }

    public TopicIdPartition idPartition() {
        return this.idPartition;
    }

    public File logDir() {
        return this.logDir;
    }

    public File tpDir() {
        return this.tpDir;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public long lastOffset() {
        return this.lastOffset;
    }

    public int segmentSize() {
        return this.segmentSize;
    }

    public RemoteStorageManager rsm() {
        return this.rsm;
    }

    public RemoteIndexCache cache() {
        return this.cache;
    }

    public RemoteLogSegmentId remoteLogSegmentId() {
        return this.remoteLogSegmentId;
    }

    public RemoteLogSegmentMetadata rlsMetadata() {
        return this.rlsMetadata;
    }

    @BeforeEach
    public void setup() {
        Files.createDirectory(this.tpDir().toPath(), new FileAttribute[0]);
        File txnIdxFile = new File(this.tpDir(), new StringBuilder(9).append("txn-index").append(MergedLog$.MODULE$.TxnIndexFileSuffix()).toString());
        txnIdxFile.createNewFile();
        Mockito.when((Object)this.rsm().fetchIndex((RemoteLogSegmentMetadata)ArgumentMatchers.any(RemoteLogSegmentMetadata.class), (RemoteStorageManager.IndexType)ArgumentMatchers.any(RemoteStorageManager.IndexType.class))).thenAnswer(ans -> {
            RemoteLogSegmentMetadata metadata = (RemoteLogSegmentMetadata)ans.getArgument(0);
            RemoteStorageManager.IndexType indexType = (RemoteStorageManager.IndexType)ans.getArgument(1);
            int maxEntries = (int)(metadata.endOffset() - metadata.startOffset());
            OffsetIndex offsetIdx = new OffsetIndex(new File(this.tpDir(), new StringBuilder(0).append(String.valueOf(metadata.startOffset())).append(MergedLog$.MODULE$.IndexFileSuffix()).toString()), metadata.startOffset(), maxEntries * 8);
            TimeIndex timeIdx = new TimeIndex(new File(this.tpDir(), new StringBuilder(0).append(String.valueOf(metadata.startOffset())).append(MergedLog$.MODULE$.TimeIndexFileSuffix()).toString()), metadata.startOffset(), maxEntries * 12);
            this.maybeAppendIndexEntries(offsetIdx, timeIdx);
            if (RemoteStorageManager.IndexType.OFFSET.equals(indexType)) {
                return new FileInputStream(offsetIdx.file());
            }
            if (RemoteStorageManager.IndexType.TIMESTAMP.equals(indexType)) {
                return new FileInputStream(timeIdx.file());
            }
            if (RemoteStorageManager.IndexType.TRANSACTION.equals(indexType)) {
                return new FileInputStream(txnIdxFile);
            }
            if (RemoteStorageManager.IndexType.LEADER_EPOCH.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            if (RemoteStorageManager.IndexType.PRODUCER_SNAPSHOT.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)indexType);
        });
    }

    @AfterEach
    public void cleanup() {
        Mockito.reset((Object[])new RemoteStorageManager[]{this.rsm()});
        this.cache().entries().forEach((x$1, v) -> v.cleanup());
        this.cache().close();
    }

    @Test
    public void testFetchIndexFromRemoteStorage() {
        OffsetIndex offsetIndex = this.cache().getIndexEntry(this.rlsMetadata()).offsetIndex();
        OffsetPosition offsetPosition1 = offsetIndex.entry(1);
        int resultPosition = this.cache().lookupOffset(this.rlsMetadata(), offsetPosition1.offset);
        Assertions.assertEquals((int)offsetPosition1.position, (int)resultPosition);
        this.verifyFetchIndexInvocation(1, (Seq<RemoteStorageManager.IndexType>)new .colon.colon((Object)RemoteStorageManager.IndexType.OFFSET, (List)new .colon.colon((Object)RemoteStorageManager.IndexType.TIMESTAMP, (List)Nil$.MODULE$)));
        Mockito.reset((Object[])new RemoteStorageManager[]{this.rsm()});
        OffsetPosition offsetPosition2 = offsetIndex.entry(2);
        int resultPosition2 = this.cache().lookupOffset(this.rlsMetadata(), offsetPosition2.offset);
        Assertions.assertEquals((int)offsetPosition2.position, (int)resultPosition2);
        Assertions.assertNotNull((Object)this.cache().getIndexEntry(this.rlsMetadata()));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.rsm()});
    }

    @Test
    public void testPositionForNonExistingIndexFromRemoteStorage() {
        OffsetIndex offsetIndex = this.cache().getIndexEntry(this.rlsMetadata()).offsetIndex();
        int lastOffsetPosition = this.cache().lookupOffset(this.rlsMetadata(), offsetIndex.lastOffset());
        long greaterOffsetThanLastOffset = offsetIndex.lastOffset() + 1L;
        Assertions.assertEquals((int)lastOffsetPosition, (int)this.cache().lookupOffset(this.rlsMetadata(), greaterOffsetThanLastOffset));
        OffsetPosition nonExistentOffsetPosition = new OffsetPosition(this.baseOffset(), 0);
        long lowerOffsetThanBaseOffset = offsetIndex.baseOffset() - 1L;
        Assertions.assertEquals((int)nonExistentOffsetPosition.position, (int)this.cache().lookupOffset(this.rlsMetadata(), lowerOffsetThanBaseOffset));
    }

    @Test
    public void testCacheEntryExpiry() {
        RemoteIndexCache cache = new RemoteIndexCache(2, this.rsm(), this.logDir().toString());
        TopicIdPartition tpId = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        List<RemoteLogSegmentMetadata> metadataList = this.generateRemoteLogSegmentMetadata(3, tpId);
        Assertions.assertEquals((int)0, (int)cache.entries().size());
        cache.getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        Assertions.assertEquals((int)1, (int)cache.entries().size());
        cache.getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        Assertions.assertEquals((int)1, (int)cache.entries().size());
        this.verifyFetchIndexInvocation(1, this.verifyFetchIndexInvocation$default$2());
        cache.getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        cache.getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(1));
        Assertions.assertEquals((int)2, (int)cache.entries().size());
        this.verifyFetchIndexInvocation(2, this.verifyFetchIndexInvocation$default$2());
        cache.getIndexEntry((RemoteLogSegmentMetadata)metadataList.last());
        cache.getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(1));
        Assertions.assertEquals((int)2, (int)cache.entries().size());
        Assertions.assertTrue((boolean)cache.entries().containsKey(((RemoteLogSegmentMetadata)metadataList.last()).remoteLogSegmentId().id()));
        Assertions.assertTrue((boolean)cache.entries().containsKey(((RemoteLogSegmentMetadata)metadataList.apply(1)).remoteLogSegmentId().id()));
        this.verifyFetchIndexInvocation(3, this.verifyFetchIndexInvocation$default$2());
        cache.getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(1));
        cache.getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        Assertions.assertEquals((int)2, (int)cache.entries().size());
        Assertions.assertFalse((boolean)cache.entries().containsKey(((RemoteLogSegmentMetadata)metadataList.last()).remoteLogSegmentId().id()));
        this.verifyFetchIndexInvocation(4, this.verifyFetchIndexInvocation$default$2());
    }

    @Test
    public void testGetIndexAfterCacheClose() {
        RemoteIndexCache cache = new RemoteIndexCache(2, this.rsm(), this.logDir().toString());
        TopicIdPartition tpId = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        List<RemoteLogSegmentMetadata> metadataList = this.generateRemoteLogSegmentMetadata(3, tpId);
        Assertions.assertEquals((int)0, (int)cache.entries().size());
        cache.getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        Assertions.assertEquals((int)1, (int)cache.entries().size());
        this.verifyFetchIndexInvocation(1, this.verifyFetchIndexInvocation$default$2());
        cache.close();
        Assertions.assertThrows(IllegalStateException.class, () -> cache.getIndexEntry((RemoteLogSegmentMetadata)metadataList.head()));
    }

    @Test
    public void testReloadCacheAfterClose() {
        RemoteIndexCache cache = new RemoteIndexCache(2, this.rsm(), this.logDir().toString());
        TopicIdPartition tpId = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        List<RemoteLogSegmentMetadata> metadataList = this.generateRemoteLogSegmentMetadata(3, tpId);
        Assertions.assertEquals((int)0, (int)cache.entries().size());
        cache.getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        Assertions.assertEquals((int)1, (int)cache.entries().size());
        cache.getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        Assertions.assertEquals((int)1, (int)cache.entries().size());
        this.verifyFetchIndexInvocation(1, this.verifyFetchIndexInvocation$default$2());
        cache.getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(1));
        Assertions.assertEquals((int)2, (int)cache.entries().size());
        cache.getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(1));
        Assertions.assertEquals((int)2, (int)cache.entries().size());
        this.verifyFetchIndexInvocation(2, this.verifyFetchIndexInvocation$default$2());
        cache.getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(2));
        Assertions.assertEquals((int)2, (int)cache.entries().size());
        cache.getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(2));
        Assertions.assertEquals((int)2, (int)cache.entries().size());
        this.verifyFetchIndexInvocation(3, this.verifyFetchIndexInvocation$default$2());
        cache.close();
        RemoteIndexCache reloadedCache = new RemoteIndexCache(2, this.rsm(), this.logDir().toString());
        Assertions.assertEquals((int)2, (int)reloadedCache.entries().size());
        reloadedCache.close();
    }

    private void verifyFetchIndexInvocation(int count, Seq<RemoteStorageManager.IndexType> indexTypes) {
        indexTypes.foreach((Function1 & Serializable)indexType -> ((RemoteStorageManager)Mockito.verify((Object)this.rsm(), (VerificationMode)Mockito.times((int)count))).fetchIndex((RemoteLogSegmentMetadata)ArgumentMatchers.any(RemoteLogSegmentMetadata.class), (RemoteStorageManager.IndexType)ArgumentMatchers.eq((Object)indexType)));
    }

    private Seq<RemoteStorageManager.IndexType> verifyFetchIndexInvocation$default$2() {
        return new .colon.colon((Object)RemoteStorageManager.IndexType.OFFSET, (List)new .colon.colon((Object)RemoteStorageManager.IndexType.TIMESTAMP, (List)new .colon.colon((Object)RemoteStorageManager.IndexType.TRANSACTION, (List)Nil$.MODULE$)));
    }

    private List<RemoteLogSegmentMetadata> generateRemoteLogSegmentMetadata(int size, TopicIdPartition tpId) {
        Buffer metadataList = (Buffer)Buffer$.MODULE$.empty();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), size).foreach((Function1 & Serializable)i -> metadataList.append((Object)new RemoteLogSegmentMetadata(new RemoteLogSegmentId(tpId, Uuid.randomUuid()), this.baseOffset() * (long)BoxesRunTime.unboxToInt((Object)i), this.baseOffset() * (long)BoxesRunTime.unboxToInt((Object)i) + 10L, this.time().milliseconds(), this.brokerId(), this.time().milliseconds(), this.segmentSize(), Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(0L)))));
        return metadataList.toList();
    }

    private void maybeAppendIndexEntries(OffsetIndex offsetIndex, TimeIndex timeIndex) {
        if (!offsetIndex.isFull()) {
            long curTime = this.time().milliseconds();
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), offsetIndex.maxEntries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                long offset = offsetIndex.baseOffset() + (long)i;
                offsetIndex.append(offset, i);
                timeIndex.maybeAppend(curTime + (long)i, offset, true);
            });
            offsetIndex.flush();
            timeIndex.flush();
            return;
        }
    }

    public RemoteIndexCacheTest() {
        String tempDirectory_prefix = "kafka-logs";
        Object var4_1 = null;
        this.logDir = TestUtils.tempDirectory(null, (String)tempDirectory_prefix);
        this.tpDir = new File(this.logDir(), this.partition().toString());
        this.brokerId = 1;
        this.baseOffset = 45L;
        this.lastOffset = 75L;
        this.segmentSize = 1024;
        this.rsm = (RemoteStorageManager)Mockito.mock(RemoteStorageManager.class);
        RemoteStorageManager x$1 = this.rsm();
        String x$2 = this.logDir().toString();
        int x$3 = 1024;
        this.cache = new RemoteIndexCache(x$3, x$1, x$2);
        this.remoteLogSegmentId = new RemoteLogSegmentId(this.idPartition(), Uuid.randomUuid());
        this.rlsMetadata = new RemoteLogSegmentMetadata(this.remoteLogSegmentId(), this.baseOffset(), this.lastOffset(), this.time().milliseconds(), this.brokerId(), this.time().milliseconds(), this.segmentSize(), Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(0L)));
    }
}

