/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.Collections;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.CorruptIndexException;
import org.apache.kafka.storage.internals.log.TransactionIndex;
import org.apache.kafka.storage.internals.log.TxnIndexSearchResult;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005q4AAF\f\u00019!)1\u0005\u0001C\u0001I!Iq\u0005\u0001a\u0001\u0002\u0004%\t\u0001\u000b\u0005\nc\u0001\u0001\r\u00111A\u0005\u0002IB\u0011\u0002\u000f\u0001A\u0002\u0003\u0005\u000b\u0015B\u0015\t\u0013e\u0002\u0001\u0019!a\u0001\n\u0003Q\u0004\"C%\u0001\u0001\u0004\u0005\r\u0011\"\u0001K\u0011%a\u0005\u00011A\u0001B\u0003&1\bC\u0004N\u0001\t\u0007I\u0011\u0001(\t\rI\u0003\u0001\u0015!\u0003P\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u0015\u0001\u0007\u0001\"\u0001U\u0011\u0015)\u0007\u0001\"\u0001U\u0011\u0015Q\u0007\u0001\"\u0001U\u0011\u0015a\u0007\u0001\"\u0001U\u0011\u0015q\u0007\u0001\"\u0001U\u0011\u0015\u0001\b\u0001\"\u0001U\u0011\u0015\u0011\b\u0001\"\u0001U\u0011\u0015!\b\u0001\"\u0001U\u0011\u00151\b\u0001\"\u0001U\u0011\u0015A\b\u0001\"\u0001U\u0011\u0015Q\b\u0001\"\u0001U\u0005Q!&/\u00198tC\u000e$\u0018n\u001c8J]\u0012,\u0007\u0010V3ti*\u0011\u0001$G\u0001\u0004Y><'\"\u0001\u000e\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\b\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005)\u0003C\u0001\u0014\u0001\u001b\u00059\u0012\u0001\u00024jY\u0016,\u0012!\u000b\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\n!![8\u000b\u00039\nAA[1wC&\u0011\u0001g\u000b\u0002\u0005\r&dW-\u0001\u0005gS2,w\fJ3r)\t\u0019d\u0007\u0005\u0002\u001fi%\u0011Qg\b\u0002\u0005+:LG\u000fC\u00048\u0007\u0005\u0005\t\u0019A\u0015\u0002\u0007a$\u0013'A\u0003gS2,\u0007%A\u0003j]\u0012,\u00070F\u0001<!\tat)D\u0001>\u0015\tAbH\u0003\u0002@\u0001\u0006I\u0011N\u001c;fe:\fGn\u001d\u0006\u0003\u0003\n\u000bqa\u001d;pe\u0006<WM\u0003\u0002\u001b\u0007*\u0011A)R\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\u000b1a\u001c:h\u0013\tAUH\u0001\tUe\u0006t7/Y2uS>t\u0017J\u001c3fq\u0006I\u0011N\u001c3fq~#S-\u001d\u000b\u0003g-Cqa\u000e\u0004\u0002\u0002\u0003\u00071(\u0001\u0004j]\u0012,\u0007\u0010I\u0001\u0007_\u001a47/\u001a;\u0016\u0003=\u0003\"A\b)\n\u0005E{\"\u0001\u0002'p]\u001e\fqa\u001c4gg\u0016$\b%A\u0003tKR,\b\u000fF\u00014Q\tQa\u000b\u0005\u0002X=6\t\u0001L\u0003\u0002Z5\u0006\u0019\u0011\r]5\u000b\u0005mc\u0016a\u00026va&$XM\u001d\u0006\u0003;\u0016\u000bQA[;oSRL!a\u0018-\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hm\\<oQ\tY!\r\u0005\u0002XG&\u0011A\r\u0017\u0002\n\u0003\u001a$XM]#bG\"\f!\u0005^3tiB{7/\u001b;j_:\u001cV\r^\"peJ,7\r\u001e7z/\",gn\u00149f]\u0016$\u0007F\u0001\u0007h!\t9\u0006.\u0003\u0002j1\n!A+Z:u\u0003\r\"Xm\u001d;SK>\u0004XM\u001c$bS2<\u0006.\u001a8GS2,\u0017\t\u001c:fC\u0012LX\t_5tiND#!D4\u0002\u001fQ,7\u000f^*b]&$\u0018p\u00115fG.D#AD4\u00025Q,7\u000f\u001e'bgR|eMZ:fi6+8\u000f^%oGJ,\u0017m]3)\u0005=9\u0017\u0001\b;fgRd\u0015m\u001d;PM\u001a\u001cX\r^\"b]:|G\u000fR3de\u0016\f7/\u001a\u0015\u0003!\u001d\fa\u0004^3ti\u000e{G\u000e\\3di\u0006\u0013wN\u001d;fIR\u0013\u0018M\\:bGRLwN\\:)\u0005E9\u0017\u0001\u0004;fgR$&/\u001e8dCR,\u0007F\u0001\nh\u0003M!Xm\u001d;BE>\u0014H/\u001a3Uq:\u001cVM\u001d3fQ\t\u0019r-A\buKN$(+\u001a8b[\u0016Le\u000eZ3yQ\t!r-A\nuKN$X\u000b\u001d3bi\u0016\u0004\u0016M]3oi\u0012K'\u000f\u000b\u0002\u0016O\u0002")
public class TransactionIndexTest {
    private File file;
    private TransactionIndex index;
    private final long offset;

    public File file() {
        return this.file;
    }

    public void file_$eq(File x$1) {
        this.file = x$1;
    }

    public TransactionIndex index() {
        return this.index;
    }

    public void index_$eq(TransactionIndex x$1) {
        this.index = x$1;
    }

    public long offset() {
        return this.offset;
    }

    @BeforeEach
    public void setup() {
        this.file_$eq(TestUtils.tempFile((String)"kafka", (String)".tmp"));
        this.index_$eq(new TransactionIndex(this.offset(), this.file()));
    }

    @AfterEach
    public void teardown() {
        this.index().close();
    }

    @Test
    public void testPositionSetCorrectlyWhenOpened() {
        .colon.colon abortedTxns = new .colon.colon((Object)new AbortedTxn(0L, 0L, 10L, 11L), (List)new .colon.colon((Object)new AbortedTxn(1L, 5L, 15L, 13L), (List)new .colon.colon((Object)new AbortedTxn(2L, 18L, 35L, 25L), (List)new .colon.colon((Object)new AbortedTxn(3L, 32L, 50L, 40L), (List)Nil$.MODULE$))));
        abortedTxns.foreach(arg_0 -> TransactionIndexTest.$anonfun$testPositionSetCorrectlyWhenOpened$1$adapted(this.index(), arg_0));
        this.index().close();
        TransactionIndex reopenedIndex = new TransactionIndex(0L, this.file(), true);
        AbortedTxn anotherAbortedTxn = new AbortedTxn(3L, 50L, 60L, 55L);
        reopenedIndex.append(anotherAbortedTxn);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)abortedTxns.$plus$plus((IterableOnce)new .colon.colon((Object)anotherAbortedTxn, (List)Nil$.MODULE$))).asJava(), (Object)reopenedIndex.allAbortedTxns());
    }

    @Test
    public void testReopenFailWhenFileAlreadyExists() {
        this.index().append(new AbortedTxn(0L, 0L, 10L, 11L));
        this.index().close();
        Assertions.assertThrows(IllegalStateException.class, () -> new TransactionIndex(0L, this.file()));
        this.index_$eq(new TransactionIndex(this.offset(), this.file(), true));
    }

    @Test
    public void testSanityCheck() {
        new .colon.colon((Object)new AbortedTxn(0L, 0L, 10L, 11L), (List)new .colon.colon((Object)new AbortedTxn(1L, 5L, 15L, 13L), (List)new .colon.colon((Object)new AbortedTxn(2L, 18L, 35L, 25L), (List)new .colon.colon((Object)new AbortedTxn(3L, 32L, 50L, 40L), (List)Nil$.MODULE$)))).foreach(arg_0 -> TransactionIndexTest.$anonfun$testSanityCheck$1$adapted(this.index(), arg_0));
        this.index().close();
        TransactionIndex reopenedIndex = new TransactionIndex(100L, this.file(), true);
        Assertions.assertThrows(CorruptIndexException.class, () -> reopenedIndex.sanityCheck());
    }

    @Test
    public void testLastOffsetMustIncrease() {
        this.index().append(new AbortedTxn(1L, 5L, 15L, 13L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.index().append(new AbortedTxn(0L, 0L, 15L, 11L)));
    }

    @Test
    public void testLastOffsetCannotDecrease() {
        this.index().append(new AbortedTxn(1L, 5L, 15L, 13L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.index().append(new AbortedTxn(0L, 0L, 10L, 11L)));
    }

    @Test
    public void testCollectAbortedTransactions() {
        .colon.colon abortedTransactions = new .colon.colon((Object)new AbortedTxn(0L, 0L, 10L, 11L), (List)new .colon.colon((Object)new AbortedTxn(1L, 5L, 15L, 13L), (List)new .colon.colon((Object)new AbortedTxn(2L, 18L, 35L, 25L), (List)new .colon.colon((Object)new AbortedTxn(3L, 32L, 50L, 40L), (List)Nil$.MODULE$))));
        abortedTransactions.foreach(arg_0 -> TransactionIndexTest.$anonfun$testCollectAbortedTransactions$1$adapted(this.index(), arg_0));
        TxnIndexSearchResult result = this.index().collectAbortedTxns(0L, 100L);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)abortedTransactions).asJava(), (Object)result.abortedTransactions);
        Assertions.assertFalse((boolean)result.isComplete);
        result = this.index().collectAbortedTxns(0L, 32L);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)abortedTransactions.take(3)).asJava(), (Object)result.abortedTransactions);
        Assertions.assertTrue((boolean)result.isComplete);
        result = this.index().collectAbortedTxns(0L, 35L);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)abortedTransactions).asJava(), (Object)result.abortedTransactions);
        Assertions.assertTrue((boolean)result.isComplete);
        result = this.index().collectAbortedTxns(10L, 35L);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)abortedTransactions).asJava(), (Object)result.abortedTransactions);
        Assertions.assertTrue((boolean)result.isComplete);
        result = this.index().collectAbortedTxns(11L, 35L);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)abortedTransactions.slice(1, 4)).asJava(), (Object)result.abortedTransactions);
        Assertions.assertTrue((boolean)result.isComplete);
        result = this.index().collectAbortedTxns(20L, 41L);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)abortedTransactions.slice(2, 4)).asJava(), (Object)result.abortedTransactions);
        Assertions.assertFalse((boolean)result.isComplete);
    }

    @Test
    public void testTruncate() {
        .colon.colon abortedTransactions = new .colon.colon((Object)new AbortedTxn(0L, 0L, 10L, 2L), (List)new .colon.colon((Object)new AbortedTxn(1L, 5L, 15L, 16L), (List)new .colon.colon((Object)new AbortedTxn(2L, 18L, 35L, 25L), (List)new .colon.colon((Object)new AbortedTxn(3L, 32L, 50L, 40L), (List)Nil$.MODULE$))));
        abortedTransactions.foreach(arg_0 -> TransactionIndexTest.$anonfun$testTruncate$1$adapted(this.index(), arg_0));
        this.index().truncateTo(51L);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)abortedTransactions).asJava(), (Object)this.index().collectAbortedTxns((long)0L, (long)100L).abortedTransactions);
        this.index().truncateTo(50L);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)abortedTransactions.take(3)).asJava(), (Object)this.index().collectAbortedTxns((long)0L, (long)100L).abortedTransactions);
        this.index().reset();
        Assertions.assertEquals(Collections.emptyList(), (Object)this.index().collectAbortedTxns((long)0L, (long)100L).abortedTransactions);
    }

    @Test
    public void testAbortedTxnSerde() {
        long pid = 983493L;
        long firstOffset = 137L;
        long lastOffset = 299L;
        long lastStableOffset = 200L;
        AbortedTxn abortedTxn = new AbortedTxn(pid, firstOffset, lastOffset, lastStableOffset);
        Assertions.assertEquals((short)0, (short)abortedTxn.version());
        Assertions.assertEquals((long)pid, (long)abortedTxn.producerId());
        Assertions.assertEquals((long)firstOffset, (long)abortedTxn.firstOffset());
        Assertions.assertEquals((long)lastOffset, (long)abortedTxn.lastOffset());
        Assertions.assertEquals((long)lastStableOffset, (long)abortedTxn.lastStableOffset());
    }

    @Test
    public void testRenameIndex() {
        File renamed = TestUtils.tempFile((String)"kafka", (String)".tmp");
        this.index().append(new AbortedTxn(0L, 0L, 10L, 2L));
        this.index().renameTo(renamed);
        this.index().append(new AbortedTxn(1L, 5L, 15L, 16L));
        java.util.List abortedTxns = this.index().collectAbortedTxns((long)0L, (long)100L).abortedTransactions;
        Assertions.assertEquals((int)2, (int)abortedTxns.size());
        Assertions.assertEquals((long)0L, (long)((AbortedTxn)abortedTxns.get(0)).firstOffset());
        Assertions.assertEquals((long)5L, (long)((AbortedTxn)abortedTxns.get(1)).firstOffset());
    }

    @Test
    public void testUpdateParentDir() {
        File tmpParentDir = new File(TestUtils.tempDirectory(null, null), "parent");
        tmpParentDir.mkdir();
        Assertions.assertNotEquals((Object)tmpParentDir, (Object)this.index().file().getParentFile());
        this.index().updateParentDir(tmpParentDir);
        Assertions.assertEquals((Object)tmpParentDir, (Object)this.index().file().getParentFile());
    }

    public TransactionIndexTest() {
        this.offset = 0L;
    }

    public static final /* synthetic */ Object $anonfun$testPositionSetCorrectlyWhenOpened$1$adapted(TransactionIndex eta$0$1$1, AbortedTxn x$1) {
        eta$0$1$1.append(x$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSanityCheck$1$adapted(TransactionIndex eta$0$1$2, AbortedTxn x$1) {
        eta$0$1$2.append(x$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCollectAbortedTransactions$1$adapted(TransactionIndex eta$0$1$3, AbortedTxn x$1) {
        eta$0$1$3.append(x$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncate$1$adapted(TransactionIndex eta$0$1$4, AbortedTxn x$1) {
        eta$0$1$4.append(x$1);
        return BoxedUnit.UNIT;
    }
}

