/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import kafka.log.AbstractLog;
import kafka.log.HarnessParams;
import kafka.log.LocalLog$;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.MergedLog;
import kafka.log.MergedLogHarness;
import kafka.log.MergedLogHarness$;
import kafka.log.MergedLogHarnessHelpers$;
import kafka.log.RecordState;
import kafka.log.TierLogSegment;
import kafka.log.ValidateLogResult$;
import kafka.server.RequestLocal;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Uf\u0001B\u0013'\u0001-BQA\r\u0001\u0005\u0002MB\u0011B\u000e\u0001A\u0002\u0003\u0007I\u0011A\u001c\t\u0013m\u0002\u0001\u0019!a\u0001\n\u0003a\u0004\"\u0003\"\u0001\u0001\u0004\u0005\t\u0015)\u00039\u0011%\u0019\u0005\u00011AA\u0002\u0013\u0005A\tC\u0005N\u0001\u0001\u0007\t\u0019!C\u0001\u001d\"I\u0001\u000b\u0001a\u0001\u0002\u0003\u0006K!\u0012\u0005\n#\u0002\u0001\r\u00111A\u0005\u0002IC\u0011B\u0018\u0001A\u0002\u0003\u0007I\u0011A0\t\u0013\u0005\u0004\u0001\u0019!A!B\u0013\u0019\u0006\"\u00022\u0001\t\u0003\u0019\u0007\"B8\u0001\t\u0003\u0019\u0007\"\u0002;\u0001\t\u0003\u0019\u0007\"B=\u0001\t\u0003\u0019\u0007\"B>\u0001\t\u0003\u0019\u0007\"B?\u0001\t\u0003\u0019\u0007\"B@\u0001\t\u0003\u0019\u0007BBA\u0002\u0001\u0011\u00051\r\u0003\u0004\u0002\b\u0001!\ta\u0019\u0005\u0007\u0003\u0017\u0001A\u0011A2\t\r\u0005=\u0001\u0001\"\u0001d\u0011\u0019\t\u0019\u0002\u0001C\u0001G\"1\u0011q\u0003\u0001\u0005\u0002\rDq!a\u0007\u0001\t\u0013\ti\u0002\u0003\u0004\u0002*\u0001!\ta\u0019\u0005\u0007\u0003[\u0001A\u0011A2\t\r\u0005E\u0002\u0001\"\u0001d\u0011\u0019\t)\u0004\u0001C\u0001G\"1\u0011\u0011\b\u0001\u0005\u0002\rDa!!\u0010\u0001\t\u0003\u0019\u0007bBA!\u0001\u0011%\u00111\t\u0005\n\u0003\u0007\u0003\u0011\u0013!C\u0005\u0003\u000bC\u0011\"a'\u0001#\u0003%I!!(\t\u0013\u0005\u0005\u0006!%A\u0005\n\u0005\r\u0006\"CAT\u0001E\u0005I\u0011BAR\u0011\u001d\tI\u000b\u0001C\u0005\u0003W\u0013!\u0003V5fe\u000e{W\u000e]1di2{w\rV3ti*\u0011q\u0005K\u0001\u0004Y><'\"A\u0015\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\f\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005!\u0004CA\u001b\u0001\u001b\u00051\u0013a\u00025be:,7o]\u000b\u0002qA\u0011Q'O\u0005\u0003u\u0019\u0012\u0001#T3sO\u0016$Gj\\4ICJtWm]:\u0002\u0017!\f'O\\3tg~#S-\u001d\u000b\u0003{\u0001\u0003\"!\f \n\u0005}r#\u0001B+oSRDq!Q\u0002\u0002\u0002\u0003\u0007\u0001(A\u0002yIE\n\u0001\u0002[1s]\u0016\u001c8\u000fI\u0001\u0007Y><G)\u001b:\u0016\u0003\u0015\u0003\"AR&\u000e\u0003\u001dS!\u0001S%\u0002\u0005%|'\"\u0001&\u0002\t)\fg/Y\u0005\u0003\u0019\u001e\u0013AAR5mK\u0006QAn\\4ESJ|F%Z9\u0015\u0005uz\u0005bB!\u0007\u0003\u0003\u0005\r!R\u0001\bY><G)\u001b:!\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:,\u0012a\u0015\t\u0003)rk\u0011!\u0016\u0006\u0003-^\u000baaY8n[>t'BA\u0015Y\u0015\tI&,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00027\u0006\u0019qN]4\n\u0005u+&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0013i>\u0004\u0018n\u0019)beRLG/[8o?\u0012*\u0017\u000f\u0006\u0002>A\"9\u0011)CA\u0001\u0002\u0004\u0019\u0016a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0011\u0002\u000bM,G/\u00169\u0015\u0003uB#aC3\u0011\u0005\u0019lW\"A4\u000b\u0005!L\u0017aA1qS*\u0011!n[\u0001\bUV\u0004\u0018\u000e^3s\u0015\ta',A\u0003kk:LG/\u0003\u0002oO\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D#\u0001D9\u0011\u0005\u0019\u0014\u0018BA:h\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\u001duKN$8i\\7qY\u0016$X\r\\=EK2,G/\u001a3D_6\u0004\u0018m\u0019;fIB\u000b'\u000f^5uS>tG)\u001a7fi\u0016\u001c\u0018\t\u001c7TK\u001elWM\u001c;tQ\tia\u000f\u0005\u0002go&\u0011\u0001p\u001a\u0002\u0005)\u0016\u001cH/A\u0011uKN$(,\u001a:p'&TX\rZ*fO6,g\u000e^%t\u001d>$\u0018I]2iSZ,G\r\u000b\u0002\u000fm\u00069D/Z:u%\u0016\fGMT3yi>3gm]3u)J\f7m[3e\u0007>\u0014(/Z2uYf4uN]\"p[B\f7\r^3e!\u0006\u0014H/\u001b;j_:D#a\u0004<\u00025Q,7\u000f^$s_^\f'\r\\3D_6\u0004\u0018m\u0019;Ck\u001a4WM]:)\u0005A1\u0018\u0001\u0004;fgR$\u0006N]8ui2,\u0007FA\tw\u0003\u0005\"Xm\u001d;O_\u0006\u0013wN\u001d;fIR\u0013\u0018M\\:bGRLwN\\:SKR\f\u0017N\\3eQ\t\u0011b/\u0001\u0015uKN$8i\\7qY\u0016$X\rZ!c_J$X\r\u001a+sC:\u001c\u0018m\u0019;j_:\u001c(+\u001a;bS:,G\r\u000b\u0002\u0014m\u00061C/Z:u\u001f:<w.\u001b8h\u0003\n|'\u000f^3e)J\fgn]1di&|gn\u001d*fi\u0006Lg.\u001a3)\u0005Q1\u0018A\r;fgR\u001cu.\u001c9mKR,G-\u00118e\u001f:<w.\u001b8h\u0003\n|'\u000f^3e)J\fgn]1di&|gn\u001d*fi\u0006Lg.\u001a3)\u0005U1\u0018a\f;fgRl\u0015N\\\"p[B\f7\r^5p]2\u000bw-\u00128bE2,GmV5uQ\u001a+H/\u001e:f)&lWm\u001d;b[B\u001c\bF\u0001\fw\u0003A\"Xm\u001d;NS:\u001cu.\u001c9bGRLwN\u001c'bO\u0012K7/\u00192mK\u0012<\u0016\u000e\u001e5GkR,(/\u001a+j[\u0016\u001cH/Y7qg\"\u0012qC^\u0001)i\u0016\u001cH/T5o\u0007>l\u0007/Y2uS>tG*Y4XSRDg)\u001e;ve\u0016$\u0016.\\3ti\u0006l\u0007o\u001d\u000b\u0004{\u0005}\u0001bBA\u00111\u0001\u0007\u00111E\u0001\u0018[&t7i\\7qC\u000e$\u0018n\u001c8MC\u001e,e.\u00192mK\u0012\u00042!LA\u0013\u0013\r\t9C\f\u0002\b\u0005>|G.Z1o\u0003Q!Xm\u001d;D_6\u0004\u0018m\u0019;B]\u0012$U\r\\3uK\"\u0012\u0011D^\u0001\u001ai\u0016\u001cHOU3uK:$\u0018n\u001c8Q_2L7-_\"iC:<W\r\u000b\u0002\u001bm\u0006YC/Z:u\u0011>$8/\u001a;TSj,'+\u001a;f]RLwN\u001c$pe\u000e{W\u000e]1di\u0016$7+Z4nK:$8\u000f\u000b\u0002\u001cm\u00069C/Z:u\u0011>$8/\u001a;SKR,g\u000e^5p]\u001a{'oQ8na\u0006\u001cG/\u001a3TK\u001elWM\u001c;tQ\tab/\u0001\u000fuKN$H)^1m\u0007>l\u0007/Y2uS>tg+\u00197jI\u0006$\u0018n\u001c8)\u0005u1\u0018A\f;fgR$U/\u00197D_6\u0004\u0018m\u0019;j_:4\u0016\r\\5eCRLwN\\0ES\u001a4wJ\u001a4tKRl\u0015\r\u001d$vY2D#A\b<\u0002\rI,7m\u001c:e)A\t)%a\u0014\u0002`\u0005\r\u0014QNA9\u0003w\ny\b\u0005\u0003\u0002H\u0005-SBAA%\u0015\r\t\t%V\u0005\u0005\u0003\u001b\nIEA\u0007NK6|'/\u001f*fG>\u0014Hm\u001d\u0005\b\u0003#z\u0002\u0019AA*\u0003\rYW-\u001f\t\u0006[\u0005U\u0013\u0011L\u0005\u0004\u0003/r#AB(qi&|g\u000eE\u0002.\u00037J1!!\u0018/\u0005\rIe\u000e\u001e\u0005\b\u0003Cz\u0002\u0019AA*\u0003\u00151\u0018\r\\;f\u0011\u001d\t)g\ba\u0001\u0003O\n\u0011\u0002^5nKN$\u0018-\u001c9\u0011\u00075\nI'C\u0002\u0002l9\u0012A\u0001T8oO\"I\u0011qN\u0010\u0011\u0002\u0003\u0007\u0011qM\u0001\u000baJ|G-^2fe&#\u0007\"CA:?A\u0005\t\u0019AA;\u00035\u0001(o\u001c3vG\u0016\u0014X\t]8dQB\u0019Q&a\u001e\n\u0007\u0005edFA\u0003TQ>\u0014H\u000fC\u0005\u0002~}\u0001\n\u00111\u0001\u0002Z\u0005A1/Z9vK:\u001cW\rC\u0005\u0002\u0002~\u0001\n\u00111\u0001\u0002Z\u0005!\u0002/\u0019:uSRLwN\u001c'fC\u0012,'/\u00129pG\"\f\u0001C]3d_J$G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005\u001d%\u0006BA4\u0003\u0013[#!a#\u0011\t\u00055\u0015qS\u0007\u0003\u0003\u001fSA!!%\u0002\u0014\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003+s\u0013AC1o]>$\u0018\r^5p]&!\u0011\u0011TAH\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0011e\u0016\u001cwN\u001d3%I\u00164\u0017-\u001e7uIU*\"!a(+\t\u0005U\u0014\u0011R\u0001\u0011e\u0016\u001cwN\u001d3%I\u00164\u0017-\u001e7uIY*\"!!*+\t\u0005e\u0013\u0011R\u0001\u0011e\u0016\u001cwN\u001d3%I\u00164\u0017-\u001e7uI]\n1\"\u00192peRl\u0015M]6feRQ\u0011QIAW\u0003_\u000b\t,a-\t\u000f\u0005\u0015D\u00051\u0001\u0002h!9\u0011q\u000e\u0013A\u0002\u0005\u001d\u0004bBA:I\u0001\u0007\u0011Q\u000f\u0005\b\u0003\u0003#\u0003\u0019AA-\u0001")
public class TierCompactLogTest {
    private MergedLogHarness harness;
    private File logDir;
    private TopicPartition topicPartition;

    public MergedLogHarness harness() {
        return this.harness;
    }

    public void harness_$eq(MergedLogHarness x$1) {
        this.harness = x$1;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public void topicPartition_$eq(TopicPartition x$1) {
        this.topicPartition = x$1;
    }

    @BeforeEach
    public void setUp() {
        File tmpDir = TestUtils.tempDirectory(null, null);
        this.logDir_$eq(TestUtils$.MODULE$.randomPartitionLogDir(tmpDir));
    }

    @AfterEach
    public void tearDown() {
        this.harness().destroy();
        this.harness_$eq(null);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCompletelyDeletedCompactedPartitionDeletesAllSegments() {
        void var35_33;
        void var34_32;
        File parseTopicPartitionName_dir = this.logDir();
        Object var36_1 = null;
        this.topicPartition_$eq(LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, 1L, 100, 86400000L, 0L, true, true, "compact", 0x10000C, 4096, 0xA00000, -1L, false, 0L);
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, Double.MAX_VALUE, 0xA00000, 1);
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        MergedLog qual$1 = this.harness().log();
        MemoryRecords x$1 = this.record((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), 0L, -1L, (short)-1, -1, -1);
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, 0, AppendOrigin.CLIENT, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        Option x$6 = qual$2.roll$default$1();
        long x$7 = qual$2.roll$default$2();
        qual$2.roll(x$6, x$7);
        Assertions.assertFalse((boolean)this.harness().maybeTierSegment(), (String)"shouldn't have been tiered as hwm is too low");
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$3 = this.harness().log();
        MemoryRecords x$8 = this.record((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option<Object>)None$.MODULE$, 1L, -1L, (short)-1, -1, -1);
        MetadataVersion x$11 = qual$3.appendAsLeader$default$4();
        RequestLocal x$12 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$8, 0, AppendOrigin.CLIENT, x$11, x$12);
        MergedLog qual$4 = this.harness().log();
        Option x$13 = qual$4.roll$default$1();
        long x$14 = qual$4.roll$default$2();
        qual$4.roll(x$13, x$14);
        Assertions.assertFalse((boolean)this.harness().maybeTierSegment(), (String)"shouldn't have been tiered as hwm is too low");
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        this.harness().advanceClock(10L);
        this.harness().log().flush(false);
        Assertions.assertTrue((this.harness().log().deleteOldSegments() > 0 ? 1 : 0) != 0);
        MergedLogHarness qual$5 = this.harness();
        Enumeration.Value x$15 = qual$5.maybeClean$default$1();
        qual$5.maybeClean(x$15);
        MergedLog qual$6 = this.harness().log();
        MemoryRecords x$16 = this.record((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option<Object>)None$.MODULE$, 2L, -1L, (short)-1, -1, -1);
        MetadataVersion x$19 = qual$6.appendAsLeader$default$4();
        RequestLocal x$20 = qual$6.appendAsLeader$default$5();
        qual$6.appendAsLeader(x$16, 0, AppendOrigin.CLIENT, x$19, x$20);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        MergedLog qual$7 = this.harness().log();
        Option x$21 = qual$7.roll$default$1();
        long x$22 = qual$7.roll$default$2();
        qual$7.roll(x$21, x$22);
        this.harness().log().flush(false);
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((this.harness().log().deleteOldSegments() > 0 ? 1 : 0) != 0);
        MergedLogHarness qual$8 = this.harness();
        Enumeration.Value x$23 = qual$8.maybeClean$default$1();
        qual$8.maybeClean(x$23);
        Assertions.assertTrue((boolean)this.harness().takeStateSnapshot().tieredSegments().isEmpty());
        MergedLogHarness qual$9 = this.harness();
        boolean x$24 = qual$9.readKeysAndOffsets$default$1();
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = qual$9.readKeysAndOffsets(x$24);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        HashMap offsetMap = (HashMap)tuple2._1();
        ListBuffer recordRead = (ListBuffer)tuple2._2();
        Assertions.assertTrue((boolean)var34_32.isEmpty());
        Assertions.assertTrue((boolean)var35_33.isEmpty());
        Assertions.assertFalse((boolean)this.harness().log().tierPartitionState().compactedSegments().isEmpty(), (String)"there should be compacted segments ready for deletion");
        Assertions.assertTrue((this.harness().tierRetention() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)this.harness().log().tierPartitionState().compactedSegments().isEmpty(), (String)"compacted segments should now be deleted");
    }

    @Test
    public void testZeroSizedSegmentIsNotArchived() {
        File parseTopicPartitionName_dir = this.logDir();
        Object var29_1 = null;
        this.topicPartition_$eq(LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, 1L, 100, 86400000L, 0L, false, true, "compact", 0x10000C, 4096, 0xA00000, -1L, false, 0L);
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, Double.MAX_VALUE, 0xA00000, 1);
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        MergedLog qual$1 = this.harness().log();
        MemoryRecords x$1 = this.record((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), 0L, -1L, (short)-1, -1, -1);
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, 0, AppendOrigin.CLIENT, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        Option x$6 = qual$2.roll$default$1();
        long x$7 = qual$2.roll$default$2();
        qual$2.roll(x$6, x$7);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertFalse((boolean)this.harness().log().localLog().segments().values().exists((Function1 & Serializable)seg -> BoxesRunTime.boxToBoolean((boolean)TierCompactLogTest.$anonfun$testZeroSizedSegmentIsNotArchived$1(seg))));
        Assertions.assertFalse((boolean)this.harness().maybeTierSegment(), (String)"shouldn't have been tiered as tiered storage is disabled");
        MergedLog qual$3 = this.harness().log();
        MemoryRecords x$8 = this.record((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option<Object>)None$.MODULE$, 1L, -1L, (short)-1, -1, -1);
        MetadataVersion x$11 = qual$3.appendAsLeader$default$4();
        RequestLocal x$12 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$8, 0, AppendOrigin.CLIENT, x$11, x$12);
        MergedLog qual$4 = this.harness().log();
        Option x$13 = qual$4.roll$default$1();
        long x$14 = qual$4.roll$default$2();
        qual$4.roll(x$13, x$14);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertFalse((boolean)this.harness().maybeTierSegment(), (String)"shouldn't have been tiered as tiered storage is disabled");
        this.harness().advanceClock(10L);
        MergedLogHarness qual$5 = this.harness();
        Enumeration.Value x$15 = qual$5.maybeClean$default$1();
        qual$5.maybeClean(x$15);
        Assertions.assertFalse((boolean)this.harness().log().localLog().segments().values().exists((Function1 & Serializable)seg -> BoxesRunTime.boxToBoolean((boolean)TierCompactLogTest.$anonfun$testZeroSizedSegmentIsNotArchived$2(seg))));
        Assertions.assertEquals((long)0L, (long)this.harness().log().size());
        this.harness().updateConfig("confluent.tier.enable", "true");
        MergedLog qual$6 = this.harness().log();
        MemoryRecords x$16 = this.record((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)3)), 2L, -1L, (short)-1, -1, -1);
        MetadataVersion x$19 = qual$6.appendAsLeader$default$4();
        RequestLocal x$20 = qual$6.appendAsLeader$default$5();
        qual$6.appendAsLeader(x$16, 0, AppendOrigin.CLIENT, x$19, x$20);
        MergedLog qual$7 = this.harness().log();
        Option x$21 = qual$7.roll$default$1();
        long x$22 = qual$7.roll$default$2();
        qual$7.roll(x$21, x$22);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertEquals((int)1, (int)this.harness().log().tierPartitionState().numSegments());
        Assertions.assertEquals((long)2L, (long)((TierLogSegment)this.harness().log().tierPartitionState().segments().next()).baseOffset());
        Assertions.assertEquals((long)2L, (long)((TierLogSegment)this.harness().log().tierPartitionState().segments().next()).endOffset());
        Assertions.assertTrue((((TierLogSegment)this.harness().log().tierPartitionState().segments().next()).size() > 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReadNextOffsetTrackedCorrectlyForCompactedPartition() {
        void withIdempotentRecords_records;
        void withIdempotentRecords_partitionLeaderEpoch;
        void withIdempotentRecords_baseSequence;
        void withIdempotentRecords_producerEpoch;
        void withIdempotentRecords_producerId;
        void withIdempotentRecords_records2;
        void withIdempotentRecords_partitionLeaderEpoch2;
        void withIdempotentRecords_baseSequence2;
        void withIdempotentRecords_producerEpoch2;
        void withIdempotentRecords_producerId2;
        File parseTopicPartitionName_dir = this.logDir();
        Object var26_1 = null;
        this.topicPartition_$eq(LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, 1L, 100, 86400000L, 0L, false, true, "compact", 0x10000C, 4096, 0xA00000, -1L, false, 0L);
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, Double.MAX_VALUE, 0xA00000, 1);
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        MergedLog qual$1 = this.harness().log();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())};
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        long l = -1L;
        CompressionType withIdempotentRecords_compressionType = CompressionType.NONE;
        Object var27_10 = null;
        simpleRecordArray = null;
        MemoryRecords x$1 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId2, (short)withIdempotentRecords_producerEpoch2, (int)withIdempotentRecords_baseSequence2, (int)withIdempotentRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withIdempotentRecords_records2);
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, 0, AppendOrigin.CLIENT, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        Option x$6 = qual$2.roll$default$1();
        long x$7 = qual$2.roll$default$2();
        qual$2.roll(x$6, x$7);
        MergedLog qual$3 = this.harness().log();
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())};
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        long l2 = -1L;
        CompressionType withIdempotentRecords_compressionType2 = CompressionType.NONE;
        Object var34_23 = null;
        simpleRecordArray2 = null;
        MemoryRecords x$8 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId, (short)withIdempotentRecords_producerEpoch, (int)withIdempotentRecords_baseSequence, (int)withIdempotentRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withIdempotentRecords_records);
        MetadataVersion x$11 = qual$3.appendAsLeader$default$4();
        RequestLocal x$12 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$8, 0, AppendOrigin.CLIENT, x$11, x$12);
        MergedLog qual$4 = this.harness().log();
        Option x$13 = qual$4.roll$default$1();
        long x$14 = qual$4.roll$default$2();
        qual$4.roll(x$13, x$14);
        this.harness().advanceClock(10L);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        MergedLogHarness qual$5 = this.harness();
        Enumeration.Value x$15 = qual$5.maybeClean$default$1();
        qual$5.maybeClean(x$15);
        Assertions.assertEquals((long)2L, (long)((LogSegment)this.harness().log().localLog().segments().values().head()).readNextOffset());
        MergedLogHarness qual$6 = this.harness();
        boolean x$16 = qual$6.readKeysAndOffsets$default$1();
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> read = qual$6.readKeysAndOffsets(x$16);
        this.harness().updateConfig("confluent.tier.enable", "true");
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((this.harness().log().deleteOldSegments() > 0 ? 1 : 0) != 0);
        MergedLogHarness qual$7 = this.harness();
        boolean x$17 = qual$7.readKeysAndOffsets$default$1();
        Assertions.assertEquals(qual$7.readKeysAndOffsets(x$17), read);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGrowableCompactBuffers() {
        void var31_48;
        void withIdempotentRecords_records;
        void withIdempotentRecords_partitionLeaderEpoch;
        void withIdempotentRecords_baseSequence;
        void withIdempotentRecords_producerEpoch;
        void withIdempotentRecords_producerId;
        void withIdempotentRecords_records2;
        void withIdempotentRecords_partitionLeaderEpoch2;
        void withIdempotentRecords_baseSequence2;
        void withIdempotentRecords_producerEpoch2;
        void withIdempotentRecords_producerId2;
        void withIdempotentRecords_records3;
        void withIdempotentRecords_partitionLeaderEpoch3;
        void withIdempotentRecords_baseSequence3;
        void withIdempotentRecords_producerEpoch3;
        void withIdempotentRecords_producerId3;
        File parseTopicPartitionName_dir = this.logDir();
        Object var32_1 = null;
        this.topicPartition_$eq(LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, 1L, 2000, 86400000L, 0L, true, true, "compact", 2000, 4096, 0xA00000, -1L, false, 0L);
        int initialCompactBufferSize = 100;
        int maxCompactBufferSize = 10000;
        HarnessParams params = new HarnessParams(10000, -1, initialCompactBufferSize, maxCompactBufferSize, Double.MAX_VALUE, 0xA00000, 1);
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        String longKey = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("f"), 1000);
        MergedLog qual$1 = this.harness().log();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(1L, longKey.getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())};
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        long l = -1L;
        CompressionType withIdempotentRecords_compressionType = CompressionType.NONE;
        Object var33_13 = null;
        simpleRecordArray = null;
        MemoryRecords x$1 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId3, (short)withIdempotentRecords_producerEpoch3, (int)withIdempotentRecords_baseSequence3, (int)withIdempotentRecords_partitionLeaderEpoch3, (boolean)false, (SimpleRecord[])withIdempotentRecords_records3);
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$52 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, 0, AppendOrigin.CLIENT, x$4, x$52);
        MergedLog qual$2 = this.harness().log();
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(1L, longKey.getBytes(), Integer.toString(2).getBytes())};
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        long l2 = -1L;
        CompressionType withIdempotentRecords_compressionType2 = CompressionType.NONE;
        Object var40_23 = null;
        simpleRecordArray2 = null;
        MemoryRecords x$6 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId2, (short)withIdempotentRecords_producerEpoch2, (int)withIdempotentRecords_baseSequence2, (int)withIdempotentRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withIdempotentRecords_records2);
        MetadataVersion x$9 = qual$2.appendAsLeader$default$4();
        RequestLocal x$10 = qual$2.appendAsLeader$default$5();
        qual$2.appendAsLeader(x$6, 0, AppendOrigin.CLIENT, x$9, x$10);
        MergedLog qual$3 = this.harness().log();
        Option x$11 = qual$3.roll$default$1();
        long x$12 = qual$3.roll$default$2();
        qual$3.roll(x$11, x$12);
        MergedLog qual$4 = this.harness().log();
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())};
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        long l3 = -1L;
        CompressionType withIdempotentRecords_compressionType3 = CompressionType.NONE;
        Object var47_36 = null;
        simpleRecordArray3 = null;
        MemoryRecords x$13 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType3, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId, (short)withIdempotentRecords_producerEpoch, (int)withIdempotentRecords_baseSequence, (int)withIdempotentRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withIdempotentRecords_records);
        MetadataVersion x$16 = qual$4.appendAsLeader$default$4();
        RequestLocal x$17 = qual$4.appendAsLeader$default$5();
        qual$4.appendAsLeader(x$13, 0, AppendOrigin.CLIENT, x$16, x$17);
        MergedLog qual$5 = this.harness().log();
        Option x$18 = qual$5.roll$default$1();
        long x$19 = qual$5.roll$default$2();
        qual$5.roll(x$18, x$19);
        this.harness().advanceClock(10L);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((this.harness().log().deleteOldSegments() > 0 ? 1 : 0) != 0);
        MergedLogHarness qual$6 = this.harness();
        Enumeration.Value x$20 = qual$6.maybeClean$default$1();
        qual$6.maybeClean(x$20);
        MergedLogHarness qual$7 = this.harness();
        boolean x$21 = qual$7.readKeysAndOffsets$default$1();
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = qual$7.readKeysAndOffsets(x$21);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ListBuffer records = (ListBuffer)tuple2._2();
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)var31_48.map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.offset())));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testThrottle() {
        void withIdempotentRecords_records;
        void withIdempotentRecords_partitionLeaderEpoch;
        void withIdempotentRecords_baseSequence;
        void withIdempotentRecords_producerEpoch;
        void withIdempotentRecords_producerId;
        void withIdempotentRecords_records2;
        void withIdempotentRecords_partitionLeaderEpoch2;
        void withIdempotentRecords_baseSequence2;
        void withIdempotentRecords_producerEpoch2;
        void withIdempotentRecords_producerId2;
        void withIdempotentRecords_records3;
        void withIdempotentRecords_partitionLeaderEpoch3;
        void withIdempotentRecords_baseSequence3;
        void withIdempotentRecords_producerEpoch3;
        void withIdempotentRecords_producerId3;
        File parseTopicPartitionName_dir = this.logDir();
        Object var41_1 = null;
        this.topicPartition_$eq(LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, 1L, 100, 86400000L, 0L, true, true, "compact", 0x10000C, 4096, 0xA00000, -1L, false, 0L);
        int throttleRateBytesPerSec = 100;
        double x$5 = throttleRateBytesPerSec;
        int x$7 = 0xA00000;
        HarnessParams params = new HarnessParams(10000, -1, 10000, 10000, x$5, x$7, -1);
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        MergedLog qual$1 = this.harness().log();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())};
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        long l = -1L;
        CompressionType withIdempotentRecords_compressionType = CompressionType.NONE;
        Object var42_13 = null;
        simpleRecordArray = null;
        MemoryRecords x$8 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId3, (short)withIdempotentRecords_producerEpoch3, (int)withIdempotentRecords_baseSequence3, (int)withIdempotentRecords_partitionLeaderEpoch3, (boolean)false, (SimpleRecord[])withIdempotentRecords_records3);
        MetadataVersion x$11 = qual$1.appendAsLeader$default$4();
        RequestLocal x$12 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$8, 0, AppendOrigin.CLIENT, x$11, x$12);
        MergedLog qual$2 = this.harness().log();
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(0).getBytes(), Integer.toString(2).getBytes())};
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        long l2 = -1L;
        CompressionType withIdempotentRecords_compressionType2 = CompressionType.NONE;
        Object var49_23 = null;
        simpleRecordArray2 = null;
        MemoryRecords x$13 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId2, (short)withIdempotentRecords_producerEpoch2, (int)withIdempotentRecords_baseSequence2, (int)withIdempotentRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withIdempotentRecords_records2);
        MetadataVersion x$16 = qual$2.appendAsLeader$default$4();
        RequestLocal x$17 = qual$2.appendAsLeader$default$5();
        qual$2.appendAsLeader(x$13, 0, AppendOrigin.CLIENT, x$16, x$17);
        MergedLog qual$3 = this.harness().log();
        Option x$18 = qual$3.roll$default$1();
        long x$19 = qual$3.roll$default$2();
        qual$3.roll(x$18, x$19);
        MergedLog qual$4 = this.harness().log();
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())};
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        long l3 = -1L;
        CompressionType withIdempotentRecords_compressionType3 = CompressionType.NONE;
        Object var56_36 = null;
        simpleRecordArray3 = null;
        MemoryRecords x$20 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType3, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId, (short)withIdempotentRecords_producerEpoch, (int)withIdempotentRecords_baseSequence, (int)withIdempotentRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withIdempotentRecords_records);
        MetadataVersion x$23 = qual$4.appendAsLeader$default$4();
        RequestLocal x$24 = qual$4.appendAsLeader$default$5();
        qual$4.appendAsLeader(x$20, 0, AppendOrigin.CLIENT, x$23, x$24);
        MergedLog qual$5 = this.harness().log();
        Option x$25 = qual$5.roll$default$1();
        long x$26 = qual$5.roll$default$2();
        qual$5.roll(x$25, x$26);
        this.harness().advanceClock(10L);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((this.harness().log().deleteOldSegments() > 0 ? 1 : 0) != 0);
        long bytesToRead = this.harness().log().tierPartitionState().totalSize() * 2L;
        long beforeTime = this.harness().log().localLog().time().milliseconds();
        MergedLogHarness qual$6 = this.harness();
        Enumeration.Value x$27 = qual$6.maybeClean$default$1();
        qual$6.maybeClean(x$27);
        long wroteBytes = this.harness().log().tierPartitionState().totalSize();
        long afterTime = this.harness().log().localLog().time().milliseconds();
        long shouldTake = (bytesToRead + wroteBytes) * 1000L / (long)throttleRateBytesPerSec;
        long took = afterTime - beforeTime;
        Assertions.assertTrue(((double)Math.abs(shouldTake - took) / (double)took < 0.01 ? 1 : 0) != 0, (String)"should have throttled within 1% ");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNoAbortedTransactionsRetained() {
        void var45_69;
        void var46_70;
        void withTransactionalRecords_records;
        void withTransactionalRecords_partitionLeaderEpoch;
        void withTransactionalRecords_baseSequence;
        void withTransactionalRecords_producerId;
        void withTransactionalRecords_records2;
        void withTransactionalRecords_partitionLeaderEpoch2;
        void withTransactionalRecords_baseSequence2;
        void withTransactionalRecords_producerId2;
        void withTransactionalRecords_records3;
        void withTransactionalRecords_partitionLeaderEpoch3;
        void withTransactionalRecords_baseSequence3;
        void withTransactionalRecords_producerId3;
        void withTransactionalRecords_records4;
        void withTransactionalRecords_partitionLeaderEpoch4;
        void withTransactionalRecords_baseSequence4;
        void withTransactionalRecords_producerId4;
        void withTransactionalRecords_records5;
        void withTransactionalRecords_partitionLeaderEpoch5;
        void withTransactionalRecords_baseSequence5;
        void withTransactionalRecords_producerId5;
        File parseTopicPartitionName_dir = this.logDir();
        Object var47_1 = null;
        this.topicPartition_$eq(LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, 1L, 1000, 86400000L, 86400000L, true, true, "compact", 0x10000C, 4096, 0xA00000, -1L, false, 0L);
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, Double.MAX_VALUE, 0xA00000, 1);
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        short producerEpoch = 0;
        MergedLog qual$1 = this.harness().log();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(0L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())};
        int n = -1;
        boolean bl = false;
        long l = 1L;
        CompressionType withTransactionalRecords_compressionType = CompressionType.NONE;
        Object var48_10 = null;
        simpleRecordArray = null;
        MemoryRecords x$1 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)withTransactionalRecords_producerId5, (short)producerEpoch, (int)withTransactionalRecords_baseSequence5, (int)withTransactionalRecords_partitionLeaderEpoch5, (boolean)true, (SimpleRecord[])withTransactionalRecords_records5);
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, 0, AppendOrigin.CLIENT, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(2L, Integer.toString(2).getBytes(), Integer.toString(2).getBytes()), new SimpleRecord(3L, Integer.toString(3).getBytes(), Integer.toString(3).getBytes())};
        int n2 = -1;
        int n3 = 2;
        long l2 = 1L;
        CompressionType withTransactionalRecords_compressionType2 = CompressionType.NONE;
        Object var54_19 = null;
        simpleRecordArray2 = null;
        MemoryRecords x$6 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)withTransactionalRecords_producerId4, (short)producerEpoch, (int)withTransactionalRecords_baseSequence4, (int)withTransactionalRecords_partitionLeaderEpoch4, (boolean)true, (SimpleRecord[])withTransactionalRecords_records4);
        MetadataVersion x$9 = qual$2.appendAsLeader$default$4();
        RequestLocal x$10 = qual$2.appendAsLeader$default$5();
        qual$2.appendAsLeader(x$6, 0, AppendOrigin.CLIENT, x$9, x$10);
        MergedLog qual$3 = this.harness().log();
        Option x$11 = qual$3.roll$default$1();
        long x$12 = qual$3.roll$default$2();
        qual$3.roll(x$11, x$12);
        MergedLog qual$4 = this.harness().log();
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{new SimpleRecord(4L, Integer.toString(4).getBytes(), Integer.toString(4).getBytes()), new SimpleRecord(5L, Integer.toString(5).getBytes(), Integer.toString(5).getBytes())};
        int n4 = -1;
        int n5 = 4;
        long l3 = 1L;
        CompressionType withTransactionalRecords_compressionType3 = CompressionType.NONE;
        Object var60_31 = null;
        simpleRecordArray3 = null;
        MemoryRecords x$13 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType3, (TimestampType)TimestampType.CREATE_TIME, (long)withTransactionalRecords_producerId3, (short)producerEpoch, (int)withTransactionalRecords_baseSequence3, (int)withTransactionalRecords_partitionLeaderEpoch3, (boolean)true, (SimpleRecord[])withTransactionalRecords_records3);
        MetadataVersion x$16 = qual$4.appendAsLeader$default$4();
        RequestLocal x$17 = qual$4.appendAsLeader$default$5();
        qual$4.appendAsLeader(x$13, 0, AppendOrigin.CLIENT, x$16, x$17);
        MergedLog qual$5 = this.harness().log();
        MemoryRecords x$18 = this.abortMarker(6L, 1L, (short)0, -1);
        MetadataVersion x$21 = qual$5.appendAsLeader$default$4();
        RequestLocal x$22 = qual$5.appendAsLeader$default$5();
        qual$5.appendAsLeader(x$18, 0, AppendOrigin.COORDINATOR, x$21, x$22);
        MergedLog qual$6 = this.harness().log();
        SimpleRecord[] simpleRecordArray4 = new SimpleRecord[]{new SimpleRecord(7L, Integer.toString(7).getBytes(), Integer.toString(7).getBytes()), new SimpleRecord(8L, Integer.toString(8).getBytes(), Integer.toString(8).getBytes())};
        int n6 = -1;
        int n7 = 6;
        long l4 = 1L;
        CompressionType withTransactionalRecords_compressionType4 = CompressionType.NONE;
        Object var66_44 = null;
        simpleRecordArray4 = null;
        MemoryRecords x$23 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType4, (TimestampType)TimestampType.CREATE_TIME, (long)withTransactionalRecords_producerId2, (short)producerEpoch, (int)withTransactionalRecords_baseSequence2, (int)withTransactionalRecords_partitionLeaderEpoch2, (boolean)true, (SimpleRecord[])withTransactionalRecords_records2);
        MetadataVersion x$26 = qual$6.appendAsLeader$default$4();
        RequestLocal x$27 = qual$6.appendAsLeader$default$5();
        qual$6.appendAsLeader(x$23, 0, AppendOrigin.CLIENT, x$26, x$27);
        MergedLog qual$7 = this.harness().log();
        Option x$28 = qual$7.roll$default$1();
        long x$29 = qual$7.roll$default$2();
        qual$7.roll(x$28, x$29);
        MergedLog qual$8 = this.harness().log();
        SimpleRecord[] simpleRecordArray5 = new SimpleRecord[]{new SimpleRecord(9L, Integer.toString(9).getBytes(), Integer.toString(9).getBytes()), new SimpleRecord(10L, Integer.toString(10).getBytes(), Integer.toString(10).getBytes())};
        int n8 = -1;
        int n9 = 8;
        long l5 = 1L;
        CompressionType withTransactionalRecords_compressionType5 = CompressionType.NONE;
        Object var72_56 = null;
        simpleRecordArray5 = null;
        MemoryRecords x$30 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType5, (TimestampType)TimestampType.CREATE_TIME, (long)withTransactionalRecords_producerId, (short)producerEpoch, (int)withTransactionalRecords_baseSequence, (int)withTransactionalRecords_partitionLeaderEpoch, (boolean)true, (SimpleRecord[])withTransactionalRecords_records);
        MetadataVersion x$33 = qual$8.appendAsLeader$default$4();
        RequestLocal x$34 = qual$8.appendAsLeader$default$5();
        qual$8.appendAsLeader(x$30, 0, AppendOrigin.CLIENT, x$33, x$34);
        MergedLog qual$9 = this.harness().log();
        MemoryRecords x$35 = this.abortMarker(11L, 1L, (short)0, -1);
        MetadataVersion x$38 = qual$9.appendAsLeader$default$4();
        RequestLocal x$39 = qual$9.appendAsLeader$default$5();
        qual$9.appendAsLeader(x$35, 0, AppendOrigin.COORDINATOR, x$38, x$39);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((this.harness().log().deleteOldSegments() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)this.harness().log().tieredLogSegments().size());
        Assertions.assertEquals((int)1, (int)this.harness().log().localLogSegments().size());
        MergedLogHarness qual$10 = this.harness();
        Enumeration.Value x$40 = qual$10.maybeClean$default$1();
        qual$10.maybeClean(x$40);
        Assertions.assertEquals((int)1, (int)this.harness().log().tieredLogSegments().size());
        Assertions.assertEquals((int)1, (int)this.harness().log().localLogSegments().size());
        MergedLogHarness qual$11 = this.harness();
        boolean x$41 = qual$11.readKeysAndOffsets$default$1();
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = qual$11.readKeysAndOffsets(x$41);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        HashMap offsetMap = (HashMap)tuple2._1();
        ListBuffer records = (ListBuffer)tuple2._2();
        Assertions.assertEquals((int)4, (int)var46_70.size());
        Assertions.assertTrue((var46_70.count((Function1 & Serializable)rec -> BoxesRunTime.boxToBoolean((boolean)TierCompactLogTest.$anonfun$testNoAbortedTransactionsRetained$1(rec))) == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((var46_70.count((Function1 & Serializable)rec -> BoxesRunTime.boxToBoolean((boolean)TierCompactLogTest.$anonfun$testNoAbortedTransactionsRetained$2(rec))) == 1 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)var45_69.size());
        Assertions.assertEquals((long)9L, (long)BoxesRunTime.unboxToLong(var45_69.get(new Some((Object)Integer.toString(9)))));
        Assertions.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong(var45_69.get(new Some((Object)Integer.toString(10)))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCompletedAbortedTransactionsRetained() {
        void var25_35;
        void var26_36;
        void withTransactionalRecords_records;
        void withTransactionalRecords_partitionLeaderEpoch;
        void withTransactionalRecords_baseSequence;
        void withTransactionalRecords_producerId;
        void withTransactionalRecords_records2;
        void withTransactionalRecords_partitionLeaderEpoch2;
        void withTransactionalRecords_baseSequence2;
        void withTransactionalRecords_producerId2;
        File parseTopicPartitionName_dir = this.logDir();
        Object var27_1 = null;
        this.topicPartition_$eq(LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, 0L, 1000, 86400000L, 86400000L, true, true, "compact", 0x10000C, 4096, 0xA00000, -1L, false, 0L);
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, Double.MAX_VALUE, 0xA00000, 1);
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        short producerEpoch = 0;
        MergedLog qual$1 = this.harness().log();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(0L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())};
        int n = -1;
        boolean bl = false;
        long l = 1L;
        CompressionType withTransactionalRecords_compressionType = CompressionType.NONE;
        Object var28_10 = null;
        simpleRecordArray = null;
        MemoryRecords x$1 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)withTransactionalRecords_producerId2, (short)producerEpoch, (int)withTransactionalRecords_baseSequence2, (int)withTransactionalRecords_partitionLeaderEpoch2, (boolean)true, (SimpleRecord[])withTransactionalRecords_records2);
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, 0, AppendOrigin.CLIENT, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(2L, Integer.toString(2).getBytes(), Integer.toString(2).getBytes()), new SimpleRecord(3L, Integer.toString(3).getBytes(), Integer.toString(3).getBytes())};
        int n2 = -1;
        int n3 = 2;
        long l2 = 1L;
        CompressionType withTransactionalRecords_compressionType2 = CompressionType.NONE;
        Object var34_19 = null;
        simpleRecordArray2 = null;
        MemoryRecords x$6 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)withTransactionalRecords_producerId, (short)producerEpoch, (int)withTransactionalRecords_baseSequence, (int)withTransactionalRecords_partitionLeaderEpoch, (boolean)true, (SimpleRecord[])withTransactionalRecords_records);
        MetadataVersion x$9 = qual$2.appendAsLeader$default$4();
        RequestLocal x$10 = qual$2.appendAsLeader$default$5();
        qual$2.appendAsLeader(x$6, 0, AppendOrigin.CLIENT, x$9, x$10);
        MergedLog qual$3 = this.harness().log();
        MemoryRecords x$11 = this.abortMarker(4L, 1L, (short)0, -1);
        MetadataVersion x$14 = qual$3.appendAsLeader$default$4();
        RequestLocal x$15 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$11, 0, AppendOrigin.COORDINATOR, x$14, x$15);
        MergedLog qual$4 = this.harness().log();
        Option x$16 = qual$4.roll$default$1();
        long x$17 = qual$4.roll$default$2();
        qual$4.roll(x$16, x$17);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((this.harness().log().deleteOldSegments() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)1, (int)this.harness().log().tieredLogSegments().size());
        Assertions.assertEquals((int)1, (int)this.harness().log().localLogSegments().size());
        MergedLogHarness qual$5 = this.harness();
        Enumeration.Value x$18 = qual$5.maybeClean$default$1();
        qual$5.maybeClean(x$18);
        Assertions.assertEquals((int)1, (int)this.harness().log().tieredLogSegments().size());
        Assertions.assertEquals((int)1, (int)this.harness().log().localLogSegments().size());
        MergedLogHarness qual$6 = this.harness();
        boolean x$19 = qual$6.readKeysAndOffsets$default$1();
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = qual$6.readKeysAndOffsets(x$19);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        HashMap offsetMap = (HashMap)tuple2._1();
        ListBuffer records = (ListBuffer)tuple2._2();
        Assertions.assertEquals((int)1, (int)var26_36.size());
        Assertions.assertTrue((var26_36.count((Function1 & Serializable)rec -> BoxesRunTime.boxToBoolean((boolean)TierCompactLogTest.$anonfun$testCompletedAbortedTransactionsRetained$1(rec))) == 1 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)var25_35.size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOngoingAbortedTransactionsRetained() {
        void var29_38;
        void var30_39;
        void withTransactionalRecords_records;
        void withTransactionalRecords_partitionLeaderEpoch;
        void withTransactionalRecords_baseSequence;
        void withTransactionalRecords_producerId;
        void withTransactionalRecords_records2;
        void withTransactionalRecords_partitionLeaderEpoch2;
        void withTransactionalRecords_baseSequence2;
        void withTransactionalRecords_producerId2;
        File parseTopicPartitionName_dir = this.logDir();
        Object var31_1 = null;
        this.topicPartition_$eq(LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, 0L, 1000, 86400000L, 86400000L, true, true, "compact", 0x10000C, 4096, 0xA00000, -1L, false, 0L);
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, Double.MAX_VALUE, 0xA00000, 1);
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        short producerEpoch = 0;
        MergedLog qual$1 = this.harness().log();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(0L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())};
        int n = -1;
        boolean bl = false;
        long l = 1L;
        CompressionType withTransactionalRecords_compressionType = CompressionType.NONE;
        Object var32_10 = null;
        simpleRecordArray = null;
        MemoryRecords x$1 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)withTransactionalRecords_producerId2, (short)producerEpoch, (int)withTransactionalRecords_baseSequence2, (int)withTransactionalRecords_partitionLeaderEpoch2, (boolean)true, (SimpleRecord[])withTransactionalRecords_records2);
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, 0, AppendOrigin.CLIENT, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(2L, Integer.toString(2).getBytes(), Integer.toString(2).getBytes()), new SimpleRecord(3L, Integer.toString(3).getBytes(), Integer.toString(3).getBytes())};
        int n2 = -1;
        int n3 = 2;
        long l2 = 1L;
        CompressionType withTransactionalRecords_compressionType2 = CompressionType.NONE;
        Object var38_19 = null;
        simpleRecordArray2 = null;
        MemoryRecords x$6 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)withTransactionalRecords_producerId, (short)producerEpoch, (int)withTransactionalRecords_baseSequence, (int)withTransactionalRecords_partitionLeaderEpoch, (boolean)true, (SimpleRecord[])withTransactionalRecords_records);
        MetadataVersion x$9 = qual$2.appendAsLeader$default$4();
        RequestLocal x$10 = qual$2.appendAsLeader$default$5();
        qual$2.appendAsLeader(x$6, 0, AppendOrigin.CLIENT, x$9, x$10);
        MergedLog qual$3 = this.harness().log();
        Option x$11 = qual$3.roll$default$1();
        long x$12 = qual$3.roll$default$2();
        qual$3.roll(x$11, x$12);
        MergedLog qual$4 = this.harness().log();
        MemoryRecords x$13 = this.abortMarker(4L, 1L, (short)0, -1);
        MetadataVersion x$16 = qual$4.appendAsLeader$default$4();
        RequestLocal x$17 = qual$4.appendAsLeader$default$5();
        qual$4.appendAsLeader(x$13, 0, AppendOrigin.COORDINATOR, x$16, x$17);
        MergedLog qual$5 = this.harness().log();
        Option x$18 = qual$5.roll$default$1();
        long x$19 = qual$5.roll$default$2();
        qual$5.roll(x$18, x$19);
        this.harness().log().maybeUpdateHighWatermarkAndRecoveryPoint(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((this.harness().log().deleteOldSegments() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)this.harness().log().tieredLogSegments().size());
        Assertions.assertEquals((int)1, (int)this.harness().log().localLogSegments().size());
        MergedLogHarness qual$6 = this.harness();
        Enumeration.Value x$20 = qual$6.maybeClean$default$1();
        qual$6.maybeClean(x$20);
        Assertions.assertEquals((int)1, (int)this.harness().log().tieredLogSegments().size());
        Assertions.assertEquals((int)1, (int)this.harness().log().localLogSegments().size());
        MergedLogHarness qual$7 = this.harness();
        boolean x$21 = qual$7.readKeysAndOffsets$default$1();
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = qual$7.readKeysAndOffsets(x$21);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        HashMap offsetMap = (HashMap)tuple2._1();
        ListBuffer records = (ListBuffer)tuple2._2();
        Assertions.assertEquals((int)1, (int)var30_39.size());
        Assertions.assertTrue((var30_39.count((Function1 & Serializable)rec -> BoxesRunTime.boxToBoolean((boolean)TierCompactLogTest.$anonfun$testOngoingAbortedTransactionsRetained$1(rec))) == 1 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)var29_38.size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCompletedAndOngoingAbortedTransactionsRetained() {
        void var45_70;
        void var46_71;
        void withTransactionalRecords_records;
        void withTransactionalRecords_partitionLeaderEpoch;
        void withTransactionalRecords_baseSequence;
        void withTransactionalRecords_producerId;
        void withTransactionalRecords_records2;
        void withTransactionalRecords_partitionLeaderEpoch2;
        void withTransactionalRecords_baseSequence2;
        void withTransactionalRecords_producerId2;
        void withTransactionalRecords_records3;
        void withTransactionalRecords_partitionLeaderEpoch3;
        void withTransactionalRecords_baseSequence3;
        void withTransactionalRecords_producerId3;
        void withTransactionalRecords_records4;
        void withTransactionalRecords_partitionLeaderEpoch4;
        void withTransactionalRecords_baseSequence4;
        void withTransactionalRecords_producerId4;
        void withTransactionalRecords_records5;
        void withTransactionalRecords_partitionLeaderEpoch5;
        void withTransactionalRecords_baseSequence5;
        void withTransactionalRecords_producerId5;
        File parseTopicPartitionName_dir = this.logDir();
        Object var47_1 = null;
        this.topicPartition_$eq(LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, 1L, 1000, 86400000L, 86400000L, true, true, "compact", 0x10000C, 4096, 0xA00000, -1L, false, 0L);
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, Double.MAX_VALUE, 0xA00000, 1);
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        short producerEpoch = 0;
        MergedLog qual$1 = this.harness().log();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(0L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())};
        int n = -1;
        boolean bl = false;
        long l = 1L;
        CompressionType withTransactionalRecords_compressionType = CompressionType.NONE;
        Object var48_10 = null;
        simpleRecordArray = null;
        MemoryRecords x$1 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)withTransactionalRecords_producerId5, (short)producerEpoch, (int)withTransactionalRecords_baseSequence5, (int)withTransactionalRecords_partitionLeaderEpoch5, (boolean)true, (SimpleRecord[])withTransactionalRecords_records5);
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, 0, AppendOrigin.CLIENT, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(2L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(3L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())};
        int n2 = -1;
        boolean bl2 = false;
        long l2 = 2L;
        CompressionType withTransactionalRecords_compressionType2 = CompressionType.NONE;
        Object var54_19 = null;
        simpleRecordArray2 = null;
        MemoryRecords x$6 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)withTransactionalRecords_producerId4, (short)producerEpoch, (int)withTransactionalRecords_baseSequence4, (int)withTransactionalRecords_partitionLeaderEpoch4, (boolean)true, (SimpleRecord[])withTransactionalRecords_records4);
        MetadataVersion x$9 = qual$2.appendAsLeader$default$4();
        RequestLocal x$10 = qual$2.appendAsLeader$default$5();
        qual$2.appendAsLeader(x$6, 0, AppendOrigin.CLIENT, x$9, x$10);
        MergedLog qual$3 = this.harness().log();
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{new SimpleRecord(4L, Integer.toString(2).getBytes(), Integer.toString(2).getBytes()), new SimpleRecord(5L, Integer.toString(3).getBytes(), Integer.toString(3).getBytes())};
        int n3 = -1;
        int n4 = 2;
        long l3 = 2L;
        CompressionType withTransactionalRecords_compressionType3 = CompressionType.NONE;
        Object var60_28 = null;
        simpleRecordArray3 = null;
        MemoryRecords x$11 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType3, (TimestampType)TimestampType.CREATE_TIME, (long)withTransactionalRecords_producerId3, (short)producerEpoch, (int)withTransactionalRecords_baseSequence3, (int)withTransactionalRecords_partitionLeaderEpoch3, (boolean)true, (SimpleRecord[])withTransactionalRecords_records3);
        MetadataVersion x$14 = qual$3.appendAsLeader$default$4();
        RequestLocal x$15 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$11, 0, AppendOrigin.CLIENT, x$14, x$15);
        MergedLog qual$4 = this.harness().log();
        SimpleRecord[] simpleRecordArray4 = new SimpleRecord[]{new SimpleRecord(6L, Integer.toString(2).getBytes(), Integer.toString(2).getBytes()), new SimpleRecord(7L, Integer.toString(3).getBytes(), Integer.toString(3).getBytes())};
        int n5 = -1;
        int n6 = 2;
        long l4 = 1L;
        CompressionType withTransactionalRecords_compressionType4 = CompressionType.NONE;
        Object var66_37 = null;
        simpleRecordArray4 = null;
        MemoryRecords x$16 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType4, (TimestampType)TimestampType.CREATE_TIME, (long)withTransactionalRecords_producerId2, (short)producerEpoch, (int)withTransactionalRecords_baseSequence2, (int)withTransactionalRecords_partitionLeaderEpoch2, (boolean)true, (SimpleRecord[])withTransactionalRecords_records2);
        MetadataVersion x$19 = qual$4.appendAsLeader$default$4();
        RequestLocal x$20 = qual$4.appendAsLeader$default$5();
        qual$4.appendAsLeader(x$16, 0, AppendOrigin.CLIENT, x$19, x$20);
        MergedLog qual$5 = this.harness().log();
        MemoryRecords x$21 = this.abortMarker(8L, 2L, (short)0, -1);
        MetadataVersion x$24 = qual$5.appendAsLeader$default$4();
        RequestLocal x$25 = qual$5.appendAsLeader$default$5();
        qual$5.appendAsLeader(x$21, 0, AppendOrigin.COORDINATOR, x$24, x$25);
        MergedLog qual$6 = this.harness().log();
        SimpleRecord[] simpleRecordArray5 = new SimpleRecord[]{new SimpleRecord(9L, Integer.toString(4).getBytes(), Integer.toString(4).getBytes()), new SimpleRecord(10L, Integer.toString(5).getBytes(), Integer.toString(5).getBytes())};
        int n7 = -1;
        boolean bl3 = false;
        long l5 = 3L;
        CompressionType withTransactionalRecords_compressionType5 = CompressionType.NONE;
        Object var72_50 = null;
        simpleRecordArray5 = null;
        MemoryRecords x$26 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType5, (TimestampType)TimestampType.CREATE_TIME, (long)withTransactionalRecords_producerId, (short)producerEpoch, (int)withTransactionalRecords_baseSequence, (int)withTransactionalRecords_partitionLeaderEpoch, (boolean)true, (SimpleRecord[])withTransactionalRecords_records);
        MetadataVersion x$29 = qual$6.appendAsLeader$default$4();
        RequestLocal x$30 = qual$6.appendAsLeader$default$5();
        qual$6.appendAsLeader(x$26, 0, AppendOrigin.CLIENT, x$29, x$30);
        MergedLog qual$7 = this.harness().log();
        Option x$31 = qual$7.roll$default$1();
        long x$32 = qual$7.roll$default$2();
        qual$7.roll(x$31, x$32);
        MergedLog qual$8 = this.harness().log();
        MemoryRecords x$33 = this.abortMarker(8L, 3L, (short)0, -1);
        MetadataVersion x$36 = qual$8.appendAsLeader$default$4();
        RequestLocal x$37 = qual$8.appendAsLeader$default$5();
        qual$8.appendAsLeader(x$33, 0, AppendOrigin.COORDINATOR, x$36, x$37);
        MergedLog qual$9 = this.harness().log();
        MemoryRecords x$38 = this.abortMarker(8L, 1L, (short)0, -1);
        MetadataVersion x$41 = qual$9.appendAsLeader$default$4();
        RequestLocal x$42 = qual$9.appendAsLeader$default$5();
        qual$9.appendAsLeader(x$38, 0, AppendOrigin.COORDINATOR, x$41, x$42);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((this.harness().log().deleteOldSegments() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)1, (int)this.harness().log().tieredLogSegments().size());
        Assertions.assertEquals((int)1, (int)this.harness().log().localLogSegments().size());
        MergedLogHarness qual$10 = this.harness();
        Enumeration.Value x$43 = qual$10.maybeClean$default$1();
        qual$10.maybeClean(x$43);
        Assertions.assertEquals((int)1, (int)this.harness().log().tieredLogSegments().size());
        Assertions.assertEquals((int)1, (int)this.harness().log().localLogSegments().size());
        MergedLogHarness qual$11 = this.harness();
        boolean x$44 = qual$11.readKeysAndOffsets$default$1();
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = qual$11.readKeysAndOffsets(x$44);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        HashMap offsetMap = (HashMap)tuple2._1();
        ListBuffer records = (ListBuffer)tuple2._2();
        Assertions.assertEquals((int)3, (int)var46_71.size());
        Assertions.assertTrue((var46_71.count((Function1 & Serializable)rec -> BoxesRunTime.boxToBoolean((boolean)TierCompactLogTest.$anonfun$testCompletedAndOngoingAbortedTransactionsRetained$1(rec))) == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((var46_71.count((Function1 & Serializable)rec -> BoxesRunTime.boxToBoolean((boolean)TierCompactLogTest.$anonfun$testCompletedAndOngoingAbortedTransactionsRetained$2(rec))) == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((var46_71.count((Function1 & Serializable)rec -> BoxesRunTime.boxToBoolean((boolean)TierCompactLogTest.$anonfun$testCompletedAndOngoingAbortedTransactionsRetained$3(rec))) == 1 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)var45_70.size());
    }

    @Test
    public void testMinCompactionLagEnabledWithFutureTimestamps() {
        this.testMinCompactionLagWithFutureTimestamps(true);
    }

    @Test
    public void testMinCompactionLagDisabledWithFutureTimestamps() {
        this.testMinCompactionLagWithFutureTimestamps(false);
    }

    /*
     * WARNING - void declaration
     */
    private void testMinCompactionLagWithFutureTimestamps(boolean minCompactionLagEnabled) {
        void var45_59;
        void withIdempotentRecords_records;
        void withIdempotentRecords_partitionLeaderEpoch;
        void withIdempotentRecords_baseSequence;
        void withIdempotentRecords_producerEpoch;
        void withIdempotentRecords_producerId;
        void withIdempotentRecords_records2;
        void withIdempotentRecords_partitionLeaderEpoch2;
        void withIdempotentRecords_baseSequence2;
        void withIdempotentRecords_producerEpoch2;
        void withIdempotentRecords_producerId2;
        void withIdempotentRecords_records3;
        void withIdempotentRecords_partitionLeaderEpoch3;
        void withIdempotentRecords_baseSequence3;
        void withIdempotentRecords_producerEpoch3;
        void withIdempotentRecords_producerId3;
        File parseTopicPartitionName_dir = this.logDir();
        Object var46_2 = null;
        this.topicPartition_$eq(LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir));
        long x$112 = minCompactionLagEnabled ? 1 : 0;
        int x$122 = 0x10000C;
        int x$132 = 4096;
        int x$14 = 0xA00000;
        long x$15 = -1L;
        boolean x$16 = false;
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, 0L, 100, 86400000L, 0L, true, true, "compact", x$122, x$132, x$14, x$15, x$16, x$112);
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, Double.MAX_VALUE, 0xA00000, 1);
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        MergedLog qual$1 = this.harness().log();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(10L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(10L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())};
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        long l = -1L;
        CompressionType withIdempotentRecords_compressionType = CompressionType.NONE;
        Object var47_17 = null;
        simpleRecordArray = null;
        MemoryRecords x$17 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId3, (short)withIdempotentRecords_producerEpoch3, (int)withIdempotentRecords_baseSequence3, (int)withIdempotentRecords_partitionLeaderEpoch3, (boolean)false, (SimpleRecord[])withIdempotentRecords_records3);
        MetadataVersion x$20 = qual$1.appendAsLeader$default$4();
        RequestLocal x$21 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$17, 0, AppendOrigin.CLIENT, x$20, x$21);
        MergedLog qual$2 = this.harness().log();
        Option x$22 = qual$2.roll$default$1();
        long x$23 = qual$2.roll$default$2();
        qual$2.roll(x$22, x$23);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$3 = this.harness().log();
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(20L, Integer.toString(1).getBytes(), Integer.toString(10).getBytes()), new SimpleRecord(20L, Integer.toString(2).getBytes(), Integer.toString(20).getBytes())};
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        long l2 = -1L;
        CompressionType withIdempotentRecords_compressionType2 = CompressionType.NONE;
        Object var54_30 = null;
        simpleRecordArray2 = null;
        MemoryRecords x$24 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId2, (short)withIdempotentRecords_producerEpoch2, (int)withIdempotentRecords_baseSequence2, (int)withIdempotentRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withIdempotentRecords_records2);
        MetadataVersion x$27 = qual$3.appendAsLeader$default$4();
        RequestLocal x$28 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$24, 0, AppendOrigin.CLIENT, x$27, x$28);
        MergedLog qual$4 = this.harness().log();
        Option x$29 = qual$4.roll$default$1();
        long x$30 = qual$4.roll$default$2();
        qual$4.roll(x$29, x$30);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$5 = this.harness().log();
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{new SimpleRecord(30L, Integer.toString(2).getBytes(), Integer.toString(200).getBytes()), new SimpleRecord(30L, Integer.toString(3).getBytes(), Integer.toString(300).getBytes())};
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        long l3 = -1L;
        CompressionType withIdempotentRecords_compressionType3 = CompressionType.NONE;
        Object var61_43 = null;
        simpleRecordArray3 = null;
        MemoryRecords x$31 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType3, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId, (short)withIdempotentRecords_producerEpoch, (int)withIdempotentRecords_baseSequence, (int)withIdempotentRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withIdempotentRecords_records);
        MetadataVersion x$34 = qual$5.appendAsLeader$default$4();
        RequestLocal x$35 = qual$5.appendAsLeader$default$5();
        qual$5.appendAsLeader(x$31, 0, AppendOrigin.CLIENT, x$34, x$35);
        MergedLog qual$6 = this.harness().log();
        Option x$36 = qual$6.roll$default$1();
        long x$37 = qual$6.roll$default$2();
        qual$6.roll(x$36, x$37);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((this.harness().log().deleteOldSegments() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)3, (int)this.harness().log().tierPartitionState().numSegments());
        Assertions.assertEquals((int)1, (int)this.harness().log().localLogSegments().size());
        this.harness().advanceClock(25L);
        MergedLogHarness qual$7 = this.harness();
        Enumeration.Value x$38 = qual$7.maybeClean$default$1();
        qual$7.maybeClean(x$38);
        if (minCompactionLagEnabled) {
            void var41_55;
            Assertions.assertEquals((int)2, (int)this.harness().log().tierPartitionState().numSegments());
            MergedLogHarness qual$8 = this.harness();
            boolean x$39 = qual$8.readKeysAndOffsets$default$1();
            Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = qual$8.readKeysAndOffsets(x$39);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            ListBuffer records = (ListBuffer)tuple2._2();
            Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"0", "1", "2", "2", "3"})), (Object)var41_55.map((Function1 & Serializable)x$10 -> (String)x$10.key().get()));
            Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"0", "10", "20", "200", "300"})), (Object)var41_55.map((Function1 & Serializable)x$11 -> (String)x$11.value().get()));
            return;
        }
        Assertions.assertEquals((int)1, (int)this.harness().log().tierPartitionState().numSegments());
        MergedLogHarness qual$9 = this.harness();
        boolean x$40 = qual$9.readKeysAndOffsets$default$1();
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = qual$9.readKeysAndOffsets(x$40);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ListBuffer records = (ListBuffer)tuple2._2();
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"0", "1", "2", "3"})), (Object)var45_59.map((Function1 & Serializable)x$12 -> (String)x$12.key().get()));
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"0", "10", "200", "300"})), (Object)var45_59.map((Function1 & Serializable)x$13 -> (String)x$13.value().get()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCompactAndDelete() {
        void var32_48;
        void withIdempotentRecords_records;
        void withIdempotentRecords_partitionLeaderEpoch;
        void withIdempotentRecords_baseSequence;
        void withIdempotentRecords_producerEpoch;
        void withIdempotentRecords_producerId;
        void withIdempotentRecords_records2;
        void withIdempotentRecords_partitionLeaderEpoch2;
        void withIdempotentRecords_baseSequence2;
        void withIdempotentRecords_producerEpoch2;
        void withIdempotentRecords_producerId2;
        void withIdempotentRecords_records3;
        void withIdempotentRecords_partitionLeaderEpoch3;
        void withIdempotentRecords_baseSequence3;
        void withIdempotentRecords_producerEpoch3;
        void withIdempotentRecords_producerId3;
        File parseTopicPartitionName_dir = this.logDir();
        Object var33_1 = null;
        this.topicPartition_$eq(LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(2L, 1L, -1L, 1L, 100, 86400000L, 0L, true, true, "compact,delete", 0x10000C, 4096, 0xA00000, -1L, false, 0L);
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, Double.MAX_VALUE, 0xA00000, 1);
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        MergedLog qual$1 = this.harness().log();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())};
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        long l = -1L;
        CompressionType withIdempotentRecords_compressionType = CompressionType.NONE;
        Object var34_10 = null;
        simpleRecordArray = null;
        MemoryRecords x$1 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId3, (short)withIdempotentRecords_producerEpoch3, (int)withIdempotentRecords_baseSequence3, (int)withIdempotentRecords_partitionLeaderEpoch3, (boolean)false, (SimpleRecord[])withIdempotentRecords_records3);
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, 0, AppendOrigin.CLIENT, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        Option x$6 = qual$2.roll$default$1();
        long x$7 = qual$2.roll$default$2();
        qual$2.roll(x$6, x$7);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$3 = this.harness().log();
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(2L, Integer.toString(1).getBytes(), Integer.toString(10).getBytes()), new SimpleRecord(2L, Integer.toString(2).getBytes(), Integer.toString(20).getBytes())};
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        long l2 = -1L;
        CompressionType withIdempotentRecords_compressionType2 = CompressionType.NONE;
        Object var41_23 = null;
        simpleRecordArray2 = null;
        MemoryRecords x$8 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId2, (short)withIdempotentRecords_producerEpoch2, (int)withIdempotentRecords_baseSequence2, (int)withIdempotentRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withIdempotentRecords_records2);
        MetadataVersion x$11 = qual$3.appendAsLeader$default$4();
        RequestLocal x$12 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$8, 0, AppendOrigin.CLIENT, x$11, x$12);
        MergedLog qual$4 = this.harness().log();
        Option x$13 = qual$4.roll$default$1();
        long x$142 = qual$4.roll$default$2();
        qual$4.roll(x$13, x$142);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$5 = this.harness().log();
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{new SimpleRecord(3L, Integer.toString(2).getBytes(), Integer.toString(200).getBytes()), new SimpleRecord(3L, Integer.toString(3).getBytes(), Integer.toString(300).getBytes())};
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        long l3 = -1L;
        CompressionType withIdempotentRecords_compressionType3 = CompressionType.NONE;
        Object var48_36 = null;
        simpleRecordArray3 = null;
        MemoryRecords x$152 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType3, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId, (short)withIdempotentRecords_producerEpoch, (int)withIdempotentRecords_baseSequence, (int)withIdempotentRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withIdempotentRecords_records);
        MetadataVersion x$18 = qual$5.appendAsLeader$default$4();
        RequestLocal x$19 = qual$5.appendAsLeader$default$5();
        qual$5.appendAsLeader(x$152, 0, AppendOrigin.CLIENT, x$18, x$19);
        MergedLog qual$6 = this.harness().log();
        Option x$20 = qual$6.roll$default$1();
        long x$21 = qual$6.roll$default$2();
        qual$6.roll(x$20, x$21);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertEquals((int)3, (int)this.harness().log().tierPartitionState().numSegments());
        this.harness().advanceClock(4L);
        this.harness().tierRetention();
        Assertions.assertEquals((int)2, (int)this.harness().log().tierPartitionState().numSegments());
        MergedLogHarness qual$7 = this.harness();
        Enumeration.Value x$22 = qual$7.maybeClean$default$1();
        qual$7.maybeClean(x$22);
        Assertions.assertEquals((int)1, (int)this.harness().log().tierPartitionState().numSegments());
        this.harness().log().deleteOldSegments();
        MergedLogHarness qual$8 = this.harness();
        boolean x$23 = qual$8.readKeysAndOffsets$default$1();
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = qual$8.readKeysAndOffsets(x$23);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ListBuffer records = (ListBuffer)tuple2._2();
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2", "3"})), (Object)var32_48.map((Function1 & Serializable)x$14 -> (String)x$14.key().get()));
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"10", "200", "300"})), (Object)var32_48.map((Function1 & Serializable)x$15 -> (String)x$15.value().get()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRetentionPolicyChange() {
        void var34_50;
        void withIdempotentRecords_records;
        void withIdempotentRecords_partitionLeaderEpoch;
        void withIdempotentRecords_baseSequence;
        void withIdempotentRecords_producerEpoch;
        void withIdempotentRecords_producerId;
        void withIdempotentRecords_records2;
        void withIdempotentRecords_partitionLeaderEpoch2;
        void withIdempotentRecords_baseSequence2;
        void withIdempotentRecords_producerEpoch2;
        void withIdempotentRecords_producerId2;
        void withIdempotentRecords_records3;
        void withIdempotentRecords_partitionLeaderEpoch3;
        void withIdempotentRecords_baseSequence3;
        void withIdempotentRecords_producerEpoch3;
        void withIdempotentRecords_producerId3;
        File parseTopicPartitionName_dir = this.logDir();
        Object var35_1 = null;
        this.topicPartition_$eq(LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(2L, 1L, -1L, 1L, 100, 86400000L, 0L, true, true, "delete", 0x10000C, 4096, 0xA00000, -1L, false, 0L);
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, Double.MAX_VALUE, 0xA00000, 1);
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        MergedLog qual$1 = this.harness().log();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())};
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        long l = -1L;
        CompressionType withIdempotentRecords_compressionType = CompressionType.NONE;
        Object var36_10 = null;
        simpleRecordArray = null;
        MemoryRecords x$1 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId3, (short)withIdempotentRecords_producerEpoch3, (int)withIdempotentRecords_baseSequence3, (int)withIdempotentRecords_partitionLeaderEpoch3, (boolean)false, (SimpleRecord[])withIdempotentRecords_records3);
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, 0, AppendOrigin.CLIENT, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        Option x$6 = qual$2.roll$default$1();
        long x$7 = qual$2.roll$default$2();
        qual$2.roll(x$6, x$7);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$3 = this.harness().log();
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(2L, Integer.toString(1).getBytes(), Integer.toString(10).getBytes()), new SimpleRecord(2L, Integer.toString(2).getBytes(), Integer.toString(20).getBytes())};
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        long l2 = -1L;
        CompressionType withIdempotentRecords_compressionType2 = CompressionType.NONE;
        Object var43_23 = null;
        simpleRecordArray2 = null;
        MemoryRecords x$8 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId2, (short)withIdempotentRecords_producerEpoch2, (int)withIdempotentRecords_baseSequence2, (int)withIdempotentRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withIdempotentRecords_records2);
        MetadataVersion x$11 = qual$3.appendAsLeader$default$4();
        RequestLocal x$12 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$8, 0, AppendOrigin.CLIENT, x$11, x$12);
        MergedLog qual$4 = this.harness().log();
        Option x$13 = qual$4.roll$default$1();
        long x$14 = qual$4.roll$default$2();
        qual$4.roll(x$13, x$14);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$5 = this.harness().log();
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{new SimpleRecord(3L, Integer.toString(2).getBytes(), Integer.toString(200).getBytes()), new SimpleRecord(3L, Integer.toString(3).getBytes(), Integer.toString(300).getBytes())};
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        long l3 = -1L;
        CompressionType withIdempotentRecords_compressionType3 = CompressionType.NONE;
        Object var50_36 = null;
        simpleRecordArray3 = null;
        MemoryRecords x$15 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType3, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId, (short)withIdempotentRecords_producerEpoch, (int)withIdempotentRecords_baseSequence, (int)withIdempotentRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withIdempotentRecords_records);
        MetadataVersion x$18 = qual$5.appendAsLeader$default$4();
        RequestLocal x$19 = qual$5.appendAsLeader$default$5();
        qual$5.appendAsLeader(x$15, 0, AppendOrigin.CLIENT, x$18, x$19);
        MergedLog qual$6 = this.harness().log();
        Option x$20 = qual$6.roll$default$1();
        long x$21 = qual$6.roll$default$2();
        qual$6.roll(x$20, x$21);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertEquals((int)3, (int)this.harness().log().tierPartitionState().numSegments());
        this.harness().advanceClock(4L);
        this.harness().tierRetention();
        Assertions.assertEquals((int)2, (int)this.harness().log().tierPartitionState().numSegments());
        MergedLogHarness qual$7 = this.harness();
        Enumeration.Value x$22 = qual$7.maybeClean$default$1();
        qual$7.maybeClean(x$22);
        Assertions.assertEquals((int)2, (int)this.harness().log().tierPartitionState().numSegments());
        this.harness().updateConfig("cleanup.policy", "delete,compact");
        MergedLogHarness qual$8 = this.harness();
        Enumeration.Value x$23 = qual$8.maybeClean$default$1();
        qual$8.maybeClean(x$23);
        this.harness().log().deleteOldSegments();
        MergedLogHarness qual$9 = this.harness();
        boolean x$24 = qual$9.readKeysAndOffsets$default$1();
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = qual$9.readKeysAndOffsets(x$24);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ListBuffer records = (ListBuffer)tuple2._2();
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2", "3"})), (Object)var34_50.map((Function1 & Serializable)x$16 -> (String)x$16.key().get()));
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"10", "200", "300"})), (Object)var34_50.map((Function1 & Serializable)x$17 -> (String)x$17.value().get()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHotsetSizeRetentionForCompactedSegments() {
        void var32_48;
        void withIdempotentRecords_records;
        void withIdempotentRecords_partitionLeaderEpoch;
        void withIdempotentRecords_baseSequence;
        void withIdempotentRecords_producerEpoch;
        void withIdempotentRecords_producerId;
        void withIdempotentRecords_records2;
        void withIdempotentRecords_partitionLeaderEpoch2;
        void withIdempotentRecords_baseSequence2;
        void withIdempotentRecords_producerEpoch2;
        void withIdempotentRecords_producerId2;
        void withIdempotentRecords_records3;
        void withIdempotentRecords_partitionLeaderEpoch3;
        void withIdempotentRecords_baseSequence3;
        void withIdempotentRecords_producerEpoch3;
        void withIdempotentRecords_producerId3;
        File parseTopicPartitionName_dir = this.logDir();
        Object var33_1 = null;
        this.topicPartition_$eq(LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, -1L, -1L, 1L, 100, 86400000L, 0L, true, true, "compact", 0x10000C, 4096, 0xA00000, -1L, false, 0L);
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, Double.MAX_VALUE, 0xA00000, 1);
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        MergedLog qual$1 = this.harness().log();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(0).getBytes(), Integer.toString(1).getBytes())};
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        long l = -1L;
        CompressionType withIdempotentRecords_compressionType = CompressionType.NONE;
        Object var34_10 = null;
        simpleRecordArray = null;
        MemoryRecords x$1 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId3, (short)withIdempotentRecords_producerEpoch3, (int)withIdempotentRecords_baseSequence3, (int)withIdempotentRecords_partitionLeaderEpoch3, (boolean)false, (SimpleRecord[])withIdempotentRecords_records3);
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, 0, AppendOrigin.CLIENT, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        Option x$6 = qual$2.roll$default$1();
        long x$7 = qual$2.roll$default$2();
        qual$2.roll(x$6, x$7);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$3 = this.harness().log();
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(2L, Integer.toString(0).getBytes(), Integer.toString(10).getBytes()), new SimpleRecord(2L, Integer.toString(0).getBytes(), Integer.toString(20).getBytes())};
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        long l2 = -1L;
        CompressionType withIdempotentRecords_compressionType2 = CompressionType.NONE;
        Object var41_23 = null;
        simpleRecordArray2 = null;
        MemoryRecords x$8 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId2, (short)withIdempotentRecords_producerEpoch2, (int)withIdempotentRecords_baseSequence2, (int)withIdempotentRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withIdempotentRecords_records2);
        MetadataVersion x$11 = qual$3.appendAsLeader$default$4();
        RequestLocal x$12 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$8, 0, AppendOrigin.CLIENT, x$11, x$12);
        MergedLog qual$4 = this.harness().log();
        Option x$13 = qual$4.roll$default$1();
        long x$14 = qual$4.roll$default$2();
        qual$4.roll(x$13, x$14);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$5 = this.harness().log();
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{new SimpleRecord(3L, Integer.toString(0).getBytes(), Integer.toString(200).getBytes()), new SimpleRecord(3L, Integer.toString(0).getBytes(), Integer.toString(300).getBytes())};
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        long l3 = -1L;
        CompressionType withIdempotentRecords_compressionType3 = CompressionType.NONE;
        Object var48_36 = null;
        simpleRecordArray3 = null;
        MemoryRecords x$15 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType3, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId, (short)withIdempotentRecords_producerEpoch, (int)withIdempotentRecords_baseSequence, (int)withIdempotentRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withIdempotentRecords_records);
        MetadataVersion x$182 = qual$5.appendAsLeader$default$4();
        RequestLocal x$192 = qual$5.appendAsLeader$default$5();
        qual$5.appendAsLeader(x$15, 0, AppendOrigin.CLIENT, x$182, x$192);
        MergedLog qual$6 = this.harness().log();
        Option x$20 = qual$6.roll$default$1();
        long x$21 = qual$6.roll$default$2();
        qual$6.roll(x$20, x$21);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLogHarness qual$7 = this.harness();
        Enumeration.Value x$22 = qual$7.maybeClean$default$1();
        qual$7.maybeClean(x$22);
        Assertions.assertEquals((int)4, (int)this.harness().log().localLogSegments().size());
        this.harness().log().deleteOldSegments();
        Assertions.assertEquals((int)1, (int)this.harness().log().localLogSegments().size());
        Assertions.assertEquals((int)1, (int)this.harness().log().tierPartitionState().numSegments());
        MergedLogHarness qual$8 = this.harness();
        boolean x$23 = qual$8.readKeysAndOffsets$default$1();
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = qual$8.readKeysAndOffsets(x$23);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ListBuffer records = (ListBuffer)tuple2._2();
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"0"})), (Object)var32_48.map((Function1 & Serializable)x$18 -> (String)x$18.key().get()));
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"300"})), (Object)var32_48.map((Function1 & Serializable)x$19 -> (String)x$19.value().get()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHotsetRetentionForCompactedSegments() {
        void var32_48;
        void withIdempotentRecords_records;
        void withIdempotentRecords_partitionLeaderEpoch;
        void withIdempotentRecords_baseSequence;
        void withIdempotentRecords_producerEpoch;
        void withIdempotentRecords_producerId;
        void withIdempotentRecords_records2;
        void withIdempotentRecords_partitionLeaderEpoch2;
        void withIdempotentRecords_baseSequence2;
        void withIdempotentRecords_producerEpoch2;
        void withIdempotentRecords_producerId2;
        void withIdempotentRecords_records3;
        void withIdempotentRecords_partitionLeaderEpoch3;
        void withIdempotentRecords_baseSequence3;
        void withIdempotentRecords_producerEpoch3;
        void withIdempotentRecords_producerId3;
        File parseTopicPartitionName_dir = this.logDir();
        Object var33_1 = null;
        this.topicPartition_$eq(LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, -1L, 100, 86400000L, 0L, true, true, "compact", 0x10000C, 4096, 0xA00000, -1L, false, 0L);
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, Double.MAX_VALUE, 0xA00000, 1);
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        MergedLog qual$1 = this.harness().log();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())};
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        long l = -1L;
        CompressionType withIdempotentRecords_compressionType = CompressionType.NONE;
        Object var34_10 = null;
        simpleRecordArray = null;
        MemoryRecords x$1 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId3, (short)withIdempotentRecords_producerEpoch3, (int)withIdempotentRecords_baseSequence3, (int)withIdempotentRecords_partitionLeaderEpoch3, (boolean)false, (SimpleRecord[])withIdempotentRecords_records3);
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, 0, AppendOrigin.CLIENT, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        Option x$6 = qual$2.roll$default$1();
        long x$7 = qual$2.roll$default$2();
        qual$2.roll(x$6, x$7);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$3 = this.harness().log();
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(2L, Integer.toString(1).getBytes(), Integer.toString(10).getBytes()), new SimpleRecord(2L, Integer.toString(2).getBytes(), Integer.toString(20).getBytes())};
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        long l2 = -1L;
        CompressionType withIdempotentRecords_compressionType2 = CompressionType.NONE;
        Object var41_23 = null;
        simpleRecordArray2 = null;
        MemoryRecords x$8 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId2, (short)withIdempotentRecords_producerEpoch2, (int)withIdempotentRecords_baseSequence2, (int)withIdempotentRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withIdempotentRecords_records2);
        MetadataVersion x$11 = qual$3.appendAsLeader$default$4();
        RequestLocal x$12 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$8, 0, AppendOrigin.CLIENT, x$11, x$12);
        MergedLog qual$4 = this.harness().log();
        Option x$13 = qual$4.roll$default$1();
        long x$14 = qual$4.roll$default$2();
        qual$4.roll(x$13, x$14);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$5 = this.harness().log();
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{new SimpleRecord(3L, Integer.toString(2).getBytes(), Integer.toString(200).getBytes()), new SimpleRecord(3L, Integer.toString(3).getBytes(), Integer.toString(300).getBytes())};
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        long l3 = -1L;
        CompressionType withIdempotentRecords_compressionType3 = CompressionType.NONE;
        Object var48_36 = null;
        simpleRecordArray3 = null;
        MemoryRecords x$15 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType3, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId, (short)withIdempotentRecords_producerEpoch, (int)withIdempotentRecords_baseSequence, (int)withIdempotentRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withIdempotentRecords_records);
        MetadataVersion x$18 = qual$5.appendAsLeader$default$4();
        RequestLocal x$19 = qual$5.appendAsLeader$default$5();
        qual$5.appendAsLeader(x$15, 0, AppendOrigin.CLIENT, x$18, x$19);
        MergedLog qual$6 = this.harness().log();
        Option x$202 = qual$6.roll$default$1();
        long x$212 = qual$6.roll$default$2();
        qual$6.roll(x$202, x$212);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertEquals((int)3, (int)this.harness().log().tierPartitionState().numSegments());
        Assertions.assertEquals((int)4, (int)this.harness().log().localLogSegments().size());
        this.harness().advanceClock(3L);
        Assertions.assertEquals((int)1, (int)this.harness().log().deleteOldSegments());
        Assertions.assertEquals((int)3, (int)this.harness().log().localLogSegments().size());
        MergedLogHarness qual$7 = this.harness();
        Enumeration.Value x$22 = qual$7.maybeClean$default$1();
        qual$7.maybeClean(x$22);
        Assertions.assertEquals((int)2, (int)this.harness().log().deleteOldSegments());
        Assertions.assertEquals((int)1, (int)this.harness().log().tierPartitionState().numSegments());
        MergedLogHarness qual$8 = this.harness();
        boolean x$23 = qual$8.readKeysAndOffsets$default$1();
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = qual$8.readKeysAndOffsets(x$23);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ListBuffer records = (ListBuffer)tuple2._2();
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"0", "1", "2", "3"})), (Object)var32_48.map((Function1 & Serializable)x$20 -> (String)x$20.key().get()));
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"0", "10", "200", "300"})), (Object)var32_48.map((Function1 & Serializable)x$21 -> (String)x$21.value().get()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDualCompactionValidation() {
        void withIdempotentRecords_records;
        void withIdempotentRecords_partitionLeaderEpoch;
        void withIdempotentRecords_baseSequence;
        void withIdempotentRecords_producerEpoch;
        void withIdempotentRecords_producerId;
        void withIdempotentRecords_records2;
        void withIdempotentRecords_partitionLeaderEpoch2;
        void withIdempotentRecords_baseSequence2;
        void withIdempotentRecords_producerEpoch2;
        void withIdempotentRecords_producerId2;
        void withIdempotentRecords_records3;
        void withIdempotentRecords_partitionLeaderEpoch3;
        void withIdempotentRecords_baseSequence3;
        void withIdempotentRecords_producerEpoch3;
        void withIdempotentRecords_producerId3;
        void withIdempotentRecords_records4;
        void withIdempotentRecords_partitionLeaderEpoch4;
        void withIdempotentRecords_baseSequence4;
        void withIdempotentRecords_producerEpoch4;
        void withIdempotentRecords_producerId4;
        File parseTopicPartitionName_dir = this.logDir();
        Object var49_1 = null;
        this.topicPartition_$eq(LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir));
        int x$12 = 0x10000C;
        int x$13 = 4096;
        int x$14 = 0xA00000;
        long x$15 = -1L;
        long x$16 = 0L;
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, -1L, 100, 86400000L, 0L, true, true, "compact", x$12, x$13, x$14, x$15, true, x$16);
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, Double.MAX_VALUE, 0xA00000, 1);
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        MergedLog qual$1 = this.harness().log();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())};
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        long l = -1L;
        CompressionType withIdempotentRecords_compressionType = CompressionType.NONE;
        Object var50_15 = null;
        simpleRecordArray = null;
        MemoryRecords x$17 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId4, (short)withIdempotentRecords_producerEpoch4, (int)withIdempotentRecords_baseSequence4, (int)withIdempotentRecords_partitionLeaderEpoch4, (boolean)false, (SimpleRecord[])withIdempotentRecords_records4);
        MetadataVersion x$20 = qual$1.appendAsLeader$default$4();
        RequestLocal x$21 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$17, 0, AppendOrigin.CLIENT, x$20, x$21);
        MergedLog qual$2 = this.harness().log();
        Option x$22 = qual$2.roll$default$1();
        long x$23 = qual$2.roll$default$2();
        qual$2.roll(x$22, x$23);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$3 = this.harness().log();
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(2L, Integer.toString(1).getBytes(), Integer.toString(10).getBytes()), new SimpleRecord(2L, Integer.toString(2).getBytes(), Integer.toString(20).getBytes())};
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        long l2 = -1L;
        CompressionType withIdempotentRecords_compressionType2 = CompressionType.NONE;
        Object var57_28 = null;
        simpleRecordArray2 = null;
        MemoryRecords x$24 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId3, (short)withIdempotentRecords_producerEpoch3, (int)withIdempotentRecords_baseSequence3, (int)withIdempotentRecords_partitionLeaderEpoch3, (boolean)false, (SimpleRecord[])withIdempotentRecords_records3);
        MetadataVersion x$27 = qual$3.appendAsLeader$default$4();
        RequestLocal x$28 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$24, 0, AppendOrigin.CLIENT, x$27, x$28);
        MergedLog qual$4 = this.harness().log();
        Option x$29 = qual$4.roll$default$1();
        long x$30 = qual$4.roll$default$2();
        qual$4.roll(x$29, x$30);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$5 = this.harness().log();
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{new SimpleRecord(3L, Integer.toString(2).getBytes(), Integer.toString(200).getBytes()), new SimpleRecord(3L, Integer.toString(3).getBytes(), Integer.toString(300).getBytes())};
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        long l3 = -1L;
        CompressionType withIdempotentRecords_compressionType3 = CompressionType.NONE;
        Object var64_41 = null;
        simpleRecordArray3 = null;
        MemoryRecords x$31 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType3, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId2, (short)withIdempotentRecords_producerEpoch2, (int)withIdempotentRecords_baseSequence2, (int)withIdempotentRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withIdempotentRecords_records2);
        MetadataVersion x$34 = qual$5.appendAsLeader$default$4();
        RequestLocal x$35 = qual$5.appendAsLeader$default$5();
        qual$5.appendAsLeader(x$31, 0, AppendOrigin.CLIENT, x$34, x$35);
        MergedLog qual$6 = this.harness().log();
        Option x$36 = qual$6.roll$default$1();
        long x$37 = qual$6.roll$default$2();
        qual$6.roll(x$36, x$37);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertEquals((int)2, (int)this.harness().log().tierPartitionState().numSegments());
        Assertions.assertEquals((int)4, (int)this.harness().log().localLogSegments().size());
        this.harness().advanceClock(3L);
        Assertions.assertEquals((int)0, (int)this.harness().log().deleteOldSegments());
        Assertions.assertEquals((int)4, (int)this.harness().log().localLogSegments().size());
        MergedLogHarness qual$7 = this.harness();
        Enumeration.Value x$38 = qual$7.maybeClean$default$1();
        qual$7.maybeClean(x$38);
        Assertions.assertEquals((double)0.0, (double)this.harness().compactionTask().tierCompactionMetrics().cleanerMetrics().validationPassedPerSec().meanRate());
        Assertions.assertEquals((double)0.0, (double)this.harness().compactionTask().tierCompactionMetrics().cleanerMetrics().validationFailedPerSec().meanRate());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        LogToClean logToClean = new LogToClean(this.topicPartition(), (AbstractLog)this.harness().log(), 0L, this.harness().log().tierPartitionState().committedEndOffset() + 1L, false);
        Assertions.assertEquals((long)0L, (long)logToClean.cleanBytes());
        Assertions.assertEquals((long)this.harness().log().tierPartitionState().totalSize(), (long)logToClean.cleanableBytes());
        Assertions.assertEquals((long)this.harness().log().sizeDetails().localSize(), (long)(logToClean.cleanBytes() + logToClean.cleanableBytes() + logToClean.uncleanableBytes()));
        MergedLogHarness qual$8 = this.harness();
        Enumeration.Value x$39 = qual$8.maybeClean$default$1();
        Tuple2<Object, Object> dirtyOffsets = qual$8.maybeClean(x$39);
        Assertions.assertTrue((this.harness().compactionTask().tierCompactionMetrics().cleanerMetrics().validationPassedPerSec().meanRate() > 0.0 ? 1 : 0) != 0);
        Assertions.assertEquals((double)0.0, (double)this.harness().compactionTask().tierCompactionMetrics().cleanerMetrics().validationFailedPerSec().meanRate());
        MergedLog qual$9 = this.harness().log();
        SimpleRecord[] simpleRecordArray4 = new SimpleRecord[]{new SimpleRecord(4L, Integer.toString(3).getBytes(), Integer.toString(3000).getBytes()), new SimpleRecord(4L, Integer.toString(4).getBytes(), Integer.toString(4000).getBytes())};
        int n10 = -1;
        int n11 = -1;
        int n12 = -1;
        long l4 = -1L;
        CompressionType withIdempotentRecords_compressionType4 = CompressionType.NONE;
        Object var71_60 = null;
        simpleRecordArray4 = null;
        MemoryRecords x$40 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType4, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId, (short)withIdempotentRecords_producerEpoch, (int)withIdempotentRecords_baseSequence, (int)withIdempotentRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withIdempotentRecords_records);
        MetadataVersion x$43 = qual$9.appendAsLeader$default$4();
        RequestLocal x$44 = qual$9.appendAsLeader$default$5();
        qual$9.appendAsLeader(x$40, 0, AppendOrigin.CLIENT, x$43, x$44);
        MergedLog qual$10 = this.harness().log();
        Option x$45 = qual$10.roll$default$1();
        long x$46 = qual$10.roll$default$2();
        qual$10.roll(x$45, x$46);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        this.harness().simulateDataLoss();
        LogToClean logToClean2 = new LogToClean(this.topicPartition(), (AbstractLog)this.harness().log(), dirtyOffsets._1$mcJ$sp(), this.harness().log().tierPartitionState().committedEndOffset() + 1L, false);
        Assertions.assertEquals((long)this.harness().log().sizeDetails().localSize(), (long)(logToClean2.cleanBytes() + logToClean2.cleanableBytes() + logToClean2.uncleanableBytes()));
        this.harness().maybeClean(ValidateLogResult$.MODULE$.Failed());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDualCompactionValidation_DiffOffsetMapFull() {
        void withIdempotentRecords_records;
        void withIdempotentRecords_partitionLeaderEpoch;
        void withIdempotentRecords_baseSequence;
        void withIdempotentRecords_producerEpoch;
        void withIdempotentRecords_producerId;
        void withIdempotentRecords_records2;
        void withIdempotentRecords_partitionLeaderEpoch2;
        void withIdempotentRecords_baseSequence2;
        void withIdempotentRecords_producerEpoch2;
        void withIdempotentRecords_producerId2;
        void withIdempotentRecords_records3;
        void withIdempotentRecords_partitionLeaderEpoch3;
        void withIdempotentRecords_baseSequence3;
        void withIdempotentRecords_producerEpoch3;
        void withIdempotentRecords_producerId3;
        File parseTopicPartitionName_dir = this.logDir();
        Object var37_1 = null;
        this.topicPartition_$eq(LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir));
        int x$12 = 0x10000C;
        int x$13 = 4096;
        int x$14 = 0xA00000;
        long x$15 = -1L;
        long x$16 = 0L;
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, -1L, 100, 86400000L, 0L, true, true, "compact", x$12, x$13, x$14, x$15, true, x$16);
        double x$22 = Double.MAX_VALUE;
        int x$23 = 1;
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, x$22, 72, x$23);
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        MergedLog qual$1 = this.harness().log();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())};
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        long l = -1L;
        CompressionType withIdempotentRecords_compressionType = CompressionType.NONE;
        Object var38_17 = null;
        simpleRecordArray = null;
        MemoryRecords x$24 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId3, (short)withIdempotentRecords_producerEpoch3, (int)withIdempotentRecords_baseSequence3, (int)withIdempotentRecords_partitionLeaderEpoch3, (boolean)false, (SimpleRecord[])withIdempotentRecords_records3);
        MetadataVersion x$27 = qual$1.appendAsLeader$default$4();
        RequestLocal x$28 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$24, 0, AppendOrigin.CLIENT, x$27, x$28);
        MergedLog qual$2 = this.harness().log();
        Option x$29 = qual$2.roll$default$1();
        long x$30 = qual$2.roll$default$2();
        qual$2.roll(x$29, x$30);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$3 = this.harness().log();
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(2L, Integer.toString(1).getBytes(), null), new SimpleRecord(2L, Integer.toString(2).getBytes(), Integer.toString(20).getBytes())};
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        long l2 = -1L;
        CompressionType withIdempotentRecords_compressionType2 = CompressionType.NONE;
        Object var45_30 = null;
        simpleRecordArray2 = null;
        MemoryRecords x$31 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId2, (short)withIdempotentRecords_producerEpoch2, (int)withIdempotentRecords_baseSequence2, (int)withIdempotentRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withIdempotentRecords_records2);
        MetadataVersion x$34 = qual$3.appendAsLeader$default$4();
        RequestLocal x$35 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$31, 0, AppendOrigin.CLIENT, x$34, x$35);
        MergedLog qual$4 = this.harness().log();
        Option x$36 = qual$4.roll$default$1();
        long x$37 = qual$4.roll$default$2();
        qual$4.roll(x$36, x$37);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$5 = this.harness().log();
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{new SimpleRecord(3L, Integer.toString(2).getBytes(), null), new SimpleRecord(3L, Integer.toString(3).getBytes(), Integer.toString(300).getBytes())};
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        long l3 = -1L;
        CompressionType withIdempotentRecords_compressionType3 = CompressionType.NONE;
        Object var52_43 = null;
        simpleRecordArray3 = null;
        MemoryRecords x$38 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType3, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId, (short)withIdempotentRecords_producerEpoch, (int)withIdempotentRecords_baseSequence, (int)withIdempotentRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withIdempotentRecords_records);
        MetadataVersion x$41 = qual$5.appendAsLeader$default$4();
        RequestLocal x$42 = qual$5.appendAsLeader$default$5();
        qual$5.appendAsLeader(x$38, 0, AppendOrigin.CLIENT, x$41, x$42);
        MergedLog qual$6 = this.harness().log();
        Option x$43 = qual$6.roll$default$1();
        long x$44 = qual$6.roll$default$2();
        qual$6.roll(x$43, x$44);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertEquals((int)3, (int)this.harness().log().tierPartitionState().numSegments());
        Assertions.assertEquals((int)4, (int)this.harness().log().localLogSegments().size());
        this.harness().advanceClock(3L);
        this.harness().maybeClean(ValidateLogResult$.MODULE$.Aborted());
    }

    private MemoryRecords record(Option<Object> key, Option<Object> value, long timestamp, long producerId, short producerEpoch, int sequence, int partitionLeaderEpoch) {
        SimpleRecord[] withIdempotentRecords_records = new SimpleRecord[]{new SimpleRecord(timestamp, (byte[])key.map((Function1 & Serializable)x$22 -> TierCompactLogTest.$anonfun$record$1(BoxesRunTime.unboxToInt((Object)x$22))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (byte[])value.map((Function1 & Serializable)x$23 -> TierCompactLogTest.$anonfun$record$2(BoxesRunTime.unboxToInt((Object)x$23))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()))};
        return MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)producerId, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withIdempotentRecords_records);
    }

    private long record$default$4() {
        return -1L;
    }

    private short record$default$5() {
        return -1;
    }

    private int record$default$6() {
        return -1;
    }

    private int record$default$7() {
        return -1;
    }

    private MemoryRecords abortMarker(long timestamp, long producerId, short producerEpoch, int partitionLeaderEpoch) {
        EndTransactionMarker marker = new EndTransactionMarker(ControlRecordType.ABORT, 0);
        return MemoryRecords.withEndTransactionMarker((long)0L, (long)timestamp, (int)partitionLeaderEpoch, (long)producerId, (short)producerEpoch, (EndTransactionMarker)marker);
    }

    public static final /* synthetic */ boolean $anonfun$testZeroSizedSegmentIsNotArchived$1(LogSegment seg) {
        return seg.scanNextOffset() != seg.readNextOffset();
    }

    public static final /* synthetic */ boolean $anonfun$testZeroSizedSegmentIsNotArchived$2(LogSegment seg) {
        return seg.scanNextOffset() != seg.readNextOffset();
    }

    public static final /* synthetic */ boolean $anonfun$testNoAbortedTransactionsRetained$1(RecordState rec) {
        return rec.isControlBatch() && rec.offset() == 6L;
    }

    public static final /* synthetic */ boolean $anonfun$testNoAbortedTransactionsRetained$2(RecordState rec) {
        return rec.isControlBatch() && rec.offset() == 11L;
    }

    public static final /* synthetic */ boolean $anonfun$testCompletedAbortedTransactionsRetained$1(RecordState rec) {
        return rec.isControlBatch() && rec.offset() == 4L;
    }

    public static final /* synthetic */ boolean $anonfun$testOngoingAbortedTransactionsRetained$1(RecordState rec) {
        return rec.isControlBatch() && rec.offset() == 4L;
    }

    public static final /* synthetic */ boolean $anonfun$testCompletedAndOngoingAbortedTransactionsRetained$1(RecordState rec) {
        return rec.isControlBatch() && rec.offset() == 8L && rec.producerId() == 2L;
    }

    public static final /* synthetic */ boolean $anonfun$testCompletedAndOngoingAbortedTransactionsRetained$2(RecordState rec) {
        return rec.isControlBatch() && rec.offset() == 11L && rec.producerId() == 3L;
    }

    public static final /* synthetic */ boolean $anonfun$testCompletedAndOngoingAbortedTransactionsRetained$3(RecordState rec) {
        return rec.isControlBatch() && rec.offset() == 12L && rec.producerId() == 1L;
    }

    public static final /* synthetic */ byte[] $anonfun$record$1(int x$22) {
        return Integer.toString(x$22).getBytes();
    }

    public static final /* synthetic */ byte[] $anonfun$record$2(int x$23) {
        return Integer.toString(x$23).getBytes();
    }
}

