/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.log.MergedLogState;
import kafka.log.MergedLogStateSnapshot;
import kafka.log.RecordState;
import kafka.log.SegmentFields;
import kafka.tier.state.TierPartitionStatus;
import kafka.utils.Logging;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

public final class SpecValidator$
implements Logging {
    public static final SpecValidator$ MODULE$ = new SpecValidator$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$((Logging)this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public String logIdent() {
        return logIdent;
    }

    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public boolean validateSameTxnStates(MergedLogStateSnapshot beforeSnapshot, MergedLogStateSnapshot afterSnapshot, String check) {
        List beforeProducerList = ((List)beforeSnapshot.activeProducers().values().toList().sortBy((Function1 & Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.producerId()), (Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable)entry -> new Tuple3((Object)BoxesRunTime.boxToLong((long)entry.producerId()), (Object)BoxesRunTime.boxToShort((short)entry.producerEpoch()), (Object)entry.currentTxnFirstOffset()));
        List afterProducerList = ((List)afterSnapshot.activeProducers().values().toList().sortBy((Function1 & Serializable)x$15 -> BoxesRunTime.boxToLong((long)x$15.producerId()), (Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable)entry -> new Tuple3((Object)BoxesRunTime.boxToLong((long)entry.producerId()), (Object)BoxesRunTime.boxToShort((short)entry.producerEpoch()), (Object)entry.currentTxnFirstOffset()));
        List list = beforeProducerList;
        if (list == null ? afterProducerList != null : !list.equals(afterProducerList)) {
            if (this.logger().underlying().isErrorEnabled()) {
                String msgWithLogIdent_msg = SpecValidator$.$anonfun$validateSameTxnStates$5(check, beforeProducerList, afterProducerList);
                Object var8_6 = null;
                this.logger().underlying().error(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
            }
            return false;
        }
        List beforeOngoingTxns = (List)beforeSnapshot.ongoingTxns().values().toList().map((Function1 & Serializable)txn -> new Tuple2.mcJJ.sp(txn.firstOffset.messageOffset, txn.producerId)).sortBy((Function1 & Serializable)x$16 -> BoxesRunTime.boxToLong((long)x$16._1$mcJ$sp()), (Ordering)Ordering.Long$.MODULE$);
        List afterOngoingTxns = (List)afterSnapshot.ongoingTxns().values().toList().map((Function1 & Serializable)txn -> new Tuple2.mcJJ.sp(txn.firstOffset.messageOffset, txn.producerId)).sortBy((Function1 & Serializable)x$17 -> BoxesRunTime.boxToLong((long)x$17._1$mcJ$sp()), (Ordering)Ordering.Long$.MODULE$);
        List list2 = beforeOngoingTxns;
        if (list2 == null ? afterOngoingTxns != null : !list2.equals(afterOngoingTxns)) {
            if (this.logger().underlying().isErrorEnabled()) {
                String msgWithLogIdent_msg = SpecValidator$.$anonfun$validateSameTxnStates$10(check, beforeOngoingTxns, afterOngoingTxns);
                Object var9_9 = null;
                this.logger().underlying().error(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
            }
            return false;
        }
        return true;
    }

    public Option<String> validate(MergedLogState state, MergedLogStateSnapshot snapshot, String check) {
        Some failure;
        Object object;
        Predef$.MODULE$.assert(state.currentTimeMs() == snapshot.time(), (Function0 & Serializable)() -> new StringBuilder(27).append("times should match ").append(state.currentTimeMs()).append(" vs ").append(snapshot.time()).append(". ").append(state).append(", ").append(MODULE$).toString());
        long maxLegalStartOffsetRetentionBytes = BoxesRunTime.unboxToLong((Object)((IterableOps)((IterableOnceOps)state.appendedBatches().reverse()).foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable)(batches, batch) -> {
            if (!(BoxesRunTime.unboxToLong((Object)state.latestDeleteRecordsOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)) > batch.endOffset() || state.config().delete() && (long)BoxesRunTime.unboxToInt((Object)batches.map((Function1 & Serializable)x$18 -> BoxesRunTime.boxToInteger((int)x$18.size())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) >= state$1.config().retentionSize && state$1.config().retentionSize != -1L)) {
                return (List)batches.$colon$plus(batch);
            }
            return batches;
        })).lastOption().map((Function1 & Serializable)x$19 -> BoxesRunTime.boxToLong((long)x$19.startOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        long deleteRecordsBound = BoxesRunTime.unboxToLong((Object)state.latestDeleteRecordsOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        long deleteRecordsAndRetentionBytesBound = Math.max(deleteRecordsBound, maxLegalStartOffsetRetentionBytes);
        scala.collection.immutable.Set worstCaseOffsets = state.everCompacted() ? state.cleanedRecords(deleteRecordsAndRetentionBytesBound).map((Function1 & Serializable)x$20 -> BoxesRunTime.boxToLong((long)x$20.offset())).toSet() : state.records().map((Function1 & Serializable)x$21 -> BoxesRunTime.boxToLong((long)x$21.offset())).toSet();
        long maxLegalStartOffsetRetentionMs = BoxesRunTime.unboxToLong((Object)state.records().takeWhile((Function1 & Serializable)record -> BoxesRunTime.boxToBoolean((boolean)SpecValidator$.$anonfun$validate$10(deleteRecordsAndRetentionBytesBound, worstCaseOffsets, state, record))).lastOption().map((Function1 & Serializable)x$22 -> BoxesRunTime.boxToLong((long)SpecValidator$.$anonfun$validate$11(x$22))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        long maxLegalStartOffset = Math.min(RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(maxLegalStartOffsetRetentionMs), maxLegalStartOffsetRetentionBytes)), deleteRecordsBound), snapshot.highWatermark());
        if (snapshot.logStartOffset() > maxLegalStartOffset) {
            object = new Some((Object)new StringBuilder(233).append("records should have bounded retention to a lower point, maxLegalStartOffset ").append(maxLegalStartOffset).append(" vs actual logStartOffset ").append(snapshot.logStartOffset()).append(".").append(" Start offset was composed of retention.ms bound: ").append(maxLegalStartOffsetRetentionMs).append(" for ").append(state.config().retentionMs).append("ms, retention.bytes bound: ").append(maxLegalStartOffsetRetentionBytes).append(" for ").append(state.config().retentionSize).append(" bytes,").append(" delete records bound ").append(state.latestDeleteRecordsOffset()).append(", this state ").append(this.toString()).append(".").toString());
        } else if (snapshot.localLogStartOffset() != Math.max(((SegmentFields)snapshot.localLogSegments().head()).baseOffset(), snapshot.logStartOffset())) {
            object = new Some((Object)new StringBuilder(108).append("localLogStartOffset (").append(snapshot.localLogStartOffset()).append(") should match local log segments base offset (").append(((SegmentFields)snapshot.localLogSegments().head()).baseOffset()).append(") and log start offset (").append(snapshot).append(".logStartOffset)").toString());
        } else if (snapshot.highWatermark() != state.highWatermark()) {
            object = new Some((Object)new StringBuilder(57).append("log highwatermark ").append(snapshot.highWatermark()).append(" should match model highwatermark ").append(state.highWatermark()).append(" ").append(state).append(" vs ").append(this).toString());
        } else if (snapshot.logEndOffset() != state.logEndOffset()) {
            object = new Some((Object)new StringBuilder(65).append("incorrect logEndOffset (snapshot ").append(snapshot).append(") vs model logEndOffset (state ").append(state).append(")").toString());
        } else {
            TierPartitionStatus tierPartitionStatus = snapshot.tierStateStatus();
            TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ERROR;
            if (!(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null)) {
                object = new Some((Object)new StringBuilder(32).append("TierPartitionState is in ").append(snapshot.tierStateStatus()).append(" status").toString());
            } else if (state.everCompacted()) {
                scala.collection.immutable.Set actual;
                Map reverseOffsetMap = (Map)CollectionConverters$.MODULE$.MapHasAsScala(snapshot.offsetMap()).asScala().map((Function1 & Serializable)x0$1 -> {
                    if (x0$1 != null) {
                        Option k = (Option)x0$1._1();
                        long offset = x0$1._2$mcJ$sp();
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)offset), (Object)k);
                    }
                    throw new MatchError(null);
                });
                ListBuffer cleanedReadRecords = (ListBuffer)snapshot.records().filter((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)SpecValidator$.$anonfun$validate$14(reverseOffsetMap, maxLegalStartOffset, r)));
                scala.collection.immutable.Set modeled = state.cleanedRecords(maxLegalStartOffset).filter((Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)SpecValidator$.$anonfun$validate$15(x$23))).toSet();
                object = !modeled.equals((Object)(actual = ((IterableOnceOps)cleanedReadRecords.filter((Function1 & Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)SpecValidator$.$anonfun$validate$16(x$24)))).toSet())) ? new Some((Object)new StringBuilder(97).append("compaction resulted in different offsets remaining than expected, records diff: ").append(modeled.diff((Set)actual)).append("\nmodel: ").append(modeled).append("\nactual: ").append(actual).toString()) : None$.MODULE$;
            } else {
                object = failure = None$.MODULE$;
            }
        }
        if (failure.isDefined()) {
            if (this.logger().underlying().isErrorEnabled()) {
                String msgWithLogIdent_msg = SpecValidator$.$anonfun$validate$17(check, (Option)failure, state, snapshot);
                Object var21_16 = null;
                this.logger().underlying().error(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
            }
        } else if (this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = SpecValidator$.$anonfun$validate$18(check, state);
            Object var22_17 = null;
            this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg));
        }
        return failure;
    }

    public static final /* synthetic */ String $anonfun$validateSameTxnStates$5(String check$1, List beforeProducerList$1, List afterProducerList$1) {
        return new StringBuilder(66).append(check$1).append(" falsified: not the same active producer states. before: ").append(beforeProducerList$1).append(", after: ").append(afterProducerList$1).toString();
    }

    public static final /* synthetic */ String $anonfun$validateSameTxnStates$10(String check$1, List beforeOngoingTxns$1, List afterOngoingTxns$1) {
        return new StringBuilder(70).append(check$1).append(" falsified: not the same ongoing transaction states. before: ").append(beforeOngoingTxns$1).append(", after: ").append(afterOngoingTxns$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$validate$10(long deleteRecordsAndRetentionBytesBound$1, scala.collection.immutable.Set worstCaseOffsets$1, MergedLogState state$1, RecordState record) {
        return record.offset() < deleteRecordsAndRetentionBytesBound$1 || !worstCaseOffsets$1.contains((Object)BoxesRunTime.boxToLong((long)record.offset())) || record.isTombstone() && state$1.everCompacted() || state$1.config().delete() && state$1.config().retentionMs != -1L && record.timestamp() < state$1.currentTimeMs() - state$1.config().retentionMs;
    }

    public static final /* synthetic */ long $anonfun$validate$11(RecordState x$22) {
        return x$22.offset() + 1L;
    }

    public static final /* synthetic */ boolean $anonfun$validate$14(Map reverseOffsetMap$2, long maxLegalStartOffset$1, RecordState r) {
        return reverseOffsetMap$2.contains((Object)BoxesRunTime.boxToLong((long)r.offset())) && r.offset() >= maxLegalStartOffset$1;
    }

    public static final /* synthetic */ boolean $anonfun$validate$15(RecordState x$23) {
        return !x$23.isTombstone();
    }

    public static final /* synthetic */ boolean $anonfun$validate$16(RecordState x$24) {
        return !x$24.isTombstone();
    }

    public static final /* synthetic */ String $anonfun$validate$17(String check$2, Option failure$1, MergedLogState state$1, MergedLogStateSnapshot snapshot$1) {
        return new StringBuilder(40).append(check$2).append(" falsified:\nreason: ").append(failure$1.get()).append("\nstate: ").append(state$1).append("\nSUT state:\n").append(snapshot$1).toString();
    }

    public static final /* synthetic */ String $anonfun$validate$18(String check$2, MergedLogState state$1) {
        return new StringBuilder(27).append(check$2).append(" passed\nstate: ").append(state$1).append("\nSUT state:\n").append(MODULE$).toString();
    }

    private SpecValidator$() {
    }
}

