/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.log.MergedLog$;
import kafka.server.Defaults$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidProducerEpochException;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.CompletedTxn;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.ProducerAppendInfo;
import org.apache.kafka.storage.internals.log.ProducerStateEntry;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.SnapshotFile;
import org.apache.kafka.storage.internals.log.TxnMetadata;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r]c\u0001B+W\u0001mCQA\u0019\u0001\u0005\u0002\rD\u0011B\u001a\u0001A\u0002\u0003\u0007I\u0011B4\t\u0013A\u0004\u0001\u0019!a\u0001\n\u0013\t\b\"C<\u0001\u0001\u0004\u0005\t\u0015)\u0003i\u0011%A\b\u00011AA\u0002\u0013%\u0011\u0010C\u0006\u0002\u0012\u0001\u0001\r\u00111A\u0005\n\u0005M\u0001BCA\f\u0001\u0001\u0007\t\u0011)Q\u0005u\"I\u0011\u0011\u0004\u0001C\u0002\u0013%\u00111\u0004\u0005\t\u0003S\u0001\u0001\u0015!\u0003\u0002\u001e!I\u00111\u0006\u0001C\u0002\u0013%\u0011Q\u0006\u0005\t\u0003k\u0001\u0001\u0015!\u0003\u00020!I\u0011q\u0007\u0001C\u0002\u0013%\u0011\u0011\b\u0005\t\u0003\u0003\u0002\u0001\u0015!\u0003\u0002<!I\u00111\t\u0001C\u0002\u0013%\u0011Q\t\u0005\t\u0003\u001b\u0002\u0001\u0015!\u0003\u0002H!I\u0011q\n\u0001C\u0002\u0013%\u0011Q\u0006\u0005\t\u0003#\u0002\u0001\u0015!\u0003\u00020!I\u00111\u000b\u0001C\u0002\u0013%\u0011Q\u000b\u0005\t\u0003G\u0002\u0001\u0015!\u0003\u0002X!9\u0011Q\r\u0001\u0005\u0002\u0005\u001d\u0004bBA@\u0001\u0011\u0005\u0011q\r\u0005\b\u0003\u0013\u0003A\u0011AA4\u0011\u001d\t\u0019\n\u0001C\u0001\u0003OBq!a&\u0001\t\u0003\t9\u0007C\u0004\u0002\u001c\u0002!\t!a\u001a\t\u000f\u0005}\u0005\u0001\"\u0001\u0002h!9\u00111\u0015\u0001\u0005\u0002\u0005\u001d\u0004bBAT\u0001\u0011\u0005\u0011q\r\u0005\b\u0003W\u0003A\u0011AA4\u0011\u001d\ty\u000b\u0001C\u0001\u0003OBq!a-\u0001\t\u0003\t9\u0007C\u0004\u00028\u0002!\t!!/\t\u000f\u0005]\u0006\u0001\"\u0001\u0002V\"9\u00111\u001c\u0001\u0005\u0002\u0005\u001d\u0004bBAp\u0001\u0011\u0005\u0011q\r\u0005\b\u0003G\u0004A\u0011AA4\u0011\u001d\t9\u000f\u0001C\u0001\u0003OBq!a;\u0001\t\u0003\t9\u0007C\u0004\u0002p\u0002!\t!a\u001a\t\u000f\u0005M\b\u0001\"\u0001\u0002h!9\u0011q\u001f\u0001\u0005\u0002\u0005\u001d\u0004bBA~\u0001\u0011\u0005\u0011q\r\u0005\b\u0003\u007f\u0004A\u0011AA4\u0011\u001d\u0011\u0019\u0001\u0001C\u0001\u0003OBqAa\u0002\u0001\t\u0003\t9\u0007C\u0004\u0003\f\u0001!\t!a\u001a\t\u000f\t=\u0001\u0001\"\u0001\u0002h!9!1\u0003\u0001\u0005\u0002\u0005\u001d\u0004b\u0002B\f\u0001\u0011\u0005\u0011q\r\u0005\b\u00057\u0001A\u0011AA4\u0011\u001d\u0011y\u0002\u0001C\u0001\u0003OBqAa\t\u0001\t\u0003\t9\u0007C\u0004\u0003(\u0001!\t!a\u001a\t\u000f\t-\u0002\u0001\"\u0001\u0002h!9!q\u0006\u0001\u0005\u0002\u0005\u001d\u0004b\u0002B\u001a\u0001\u0011\u0005\u0011q\r\u0005\b\u0005o\u0001A\u0011AA4\u0011\u001d\u0011Y\u0004\u0001C\u0001\u0003OBqAa\u0010\u0001\t\u0003\t9\u0007C\u0004\u0003D\u0001!\t!a\u001a\t\u000f\t\u001d\u0003\u0001\"\u0001\u0002h!9!1\n\u0001\u0005\u0002\u0005\u001d\u0004b\u0002B(\u0001\u0011\u0005\u0011q\r\u0005\b\u0005'\u0002A\u0011AA4\u0011\u001d\u00119\u0006\u0001C\u0001\u0003OBqAa\u0017\u0001\t\u0003\t9\u0007C\u0004\u0003`\u0001!\t!a\u001a\t\u000f\t\r\u0004\u0001\"\u0001\u0002h!9!q\r\u0001\u0005\u0002\u0005\u001d\u0004b\u0002B6\u0001\u0011\u0005\u0011q\r\u0005\b\u0005_\u0002A\u0011AA4\u0011\u001d\u0011\t\b\u0001C\u0001\u0003OBqA!\u001e\u0001\t\u0003\t9\u0007C\u0004\u0003z\u0001!\t!a\u001a\t\u000f\tu\u0004\u0001\"\u0003\u0003\u0000!9!1\u0014\u0001\u0005\n\tu\u0005\"\u0003Bl\u0001E\u0005I\u0011\u0002Bm\u0011%\u0011y\u000fAI\u0001\n\u0013\u0011\t\u0010C\u0004\u0003v\u0002!IAa>\t\u0013\rm\u0001!%A\u0005\n\tE\b\"CB\u000f\u0001E\u0005I\u0011BB\u0010\u0011%\u0019\u0019\u0003AI\u0001\n\u0013\u0019)\u0003C\u0004\u0003v\u0002!Ia!\u000b\t\u000f\ru\u0002\u0001\"\u0003\u0004@\tA\u0002K]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJ$Vm\u001d;\u000b\u0005]C\u0016a\u00017pO*\t\u0011,A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001a\u0006CA/a\u001b\u0005q&\"A0\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005t&AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002IB\u0011Q\rA\u0007\u0002-\u00061An\\4ESJ,\u0012\u0001\u001b\t\u0003S:l\u0011A\u001b\u0006\u0003W2\f!![8\u000b\u00035\fAA[1wC&\u0011qN\u001b\u0002\u0005\r&dW-\u0001\u0006m_\u001e$\u0015N]0%KF$\"A];\u0011\u0005u\u001b\u0018B\u0001;_\u0005\u0011)f.\u001b;\t\u000fY\u001c\u0011\u0011!a\u0001Q\u0006\u0019\u0001\u0010J\u0019\u0002\u000f1|w\rR5sA\u0005a1\u000f^1uK6\u000bg.Y4feV\t!\u0010E\u0002|\u0003\u001bi\u0011\u0001 \u0006\u0003/vT!A`@\u0002\u0013%tG/\u001a:oC2\u001c(\u0002BA\u0001\u0003\u0007\tqa\u001d;pe\u0006<WMC\u0002Z\u0003\u000bQA!a\u0002\u0002\n\u00051\u0011\r]1dQ\u0016T!!a\u0003\u0002\u0007=\u0014x-C\u0002\u0002\u0010q\u0014A\u0003\u0015:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u0014\u0018\u0001E:uCR,W*\u00198bO\u0016\u0014x\fJ3r)\r\u0011\u0018Q\u0003\u0005\bm\u001a\t\t\u00111\u0001{\u00035\u0019H/\u0019;f\u001b\u0006t\u0017mZ3sA\u0005I\u0001/\u0019:uSRLwN\\\u000b\u0003\u0003;\u0001B!a\b\u0002&5\u0011\u0011\u0011\u0005\u0006\u0005\u0003G\t\u0019!\u0001\u0004d_6lwN\\\u0005\u0005\u0003O\t\tC\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u0015A\f'\u000f^5uS>t\u0007%\u0001\u0006qe>$WoY3s\u0013\u0012,\"!a\f\u0011\u0007u\u000b\t$C\u0002\u00024y\u0013A\u0001T8oO\u0006Y\u0001O]8ek\u000e,'/\u00133!\u0003]i\u0017\r\u001f+sC:\u001c\u0018m\u0019;j_:$\u0016.\\3pkRl5/\u0006\u0002\u0002<A\u0019Q,!\u0010\n\u0007\u0005}bLA\u0002J]R\f\u0001$\\1y)J\fgn]1di&|g\u000eV5nK>,H/T:!\u0003i\u0001(o\u001c3vG\u0016\u00148\u000b^1uK6\u000bg.Y4fe\u000e{gNZ5h+\t\t9\u0005E\u0002|\u0003\u0013J1!a\u0013}\u0005i\u0001&o\u001c3vG\u0016\u00148\u000b^1uK6\u000bg.Y4fe\u000e{gNZ5h\u0003m\u0001(o\u001c3vG\u0016\u00148\u000b^1uK6\u000bg.Y4fe\u000e{gNZ5hA\u0005AB.\u0019;f)J\fgn]1di&|g\u000eV5nK>,H/T:\u000231\fG/\u001a+sC:\u001c\u0018m\u0019;j_:$\u0016.\\3pkRl5\u000fI\u0001\u0005i&lW-\u0006\u0002\u0002XA!\u0011\u0011LA0\u001b\t\tYF\u0003\u0003\u0002^\u0005\u0005\u0012!B;uS2\u001c\u0018\u0002BA1\u00037\u0012\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002e\"\u001aA#a\u001b\u0011\t\u00055\u00141P\u0007\u0003\u0003_RA!!\u001d\u0002t\u0005\u0019\u0011\r]5\u000b\t\u0005U\u0014qO\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\tI(!\u0003\u0002\u000b),h.\u001b;\n\t\u0005u\u0014q\u000e\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u0007U\t\u0019\t\u0005\u0003\u0002n\u0005\u0015\u0015\u0002BAD\u0003_\u0012\u0011\"\u00114uKJ,\u0015m\u00195\u0002%Q,7\u000f\u001e\"bg&\u001c\u0017\nZ'baBLgn\u001a\u0015\u0004-\u00055\u0005\u0003BA7\u0003\u001fKA!!%\u0002p\t!A+Z:u\u0003\u0019\"Xm\u001d;BaB,g\u000e\u001a+y]6\u000b'o[3s/&$\bNT8Qe>$WoY3s'R\fG/\u001a\u0015\u0004/\u00055\u0015A\b;fgR\u0004&o\u001c3vG\u0016\u00148+Z9vK:\u001cWm\u0016:ba\u0006\u0013x.\u001e8eQ\rA\u0012QR\u0001.i\u0016\u001cH\u000f\u0015:pIV\u001cWM]*fcV,gnY3XSRDwK]1q\u0003J|WO\u001c3CCR\u001c\u0007NU3d_J$\u0007fA\r\u0002\u000e\u0006)C/Z:u!J|G-^2feN+\u0017/^3oG\u0016LeN^1mS\u0012<&/\u00199Be>,h\u000e\u001a\u0015\u00045\u00055\u0015A\u000b;fgRtuNV1mS\u0012\fG/[8o\u001f:4\u0015N]:u\u000b:$(/_,iK:du.\u00193j]\u001edun\u001a\u0015\u00047\u00055\u0015a\t;fgR\u001cuN\u001c;s_2\u0014VmY8sI\n+X\u000e]:Qe>$WoY3s\u000bB|7\r\u001b\u0015\u00049\u00055\u0015\u0001\t;fgR$\u0006P\u001c$jeN$xJ\u001a4tKRlU\r^1eCR\f7)Y2iK\u0012D3!HAG\u0003M!Xm\u001d;Mg>\u0014\u0015\r^2i\u0003B\u0004XM\u001c3tQ\rq\u0012QR\u0001\u001ai\u0016\u001cHoU6ja\u0016k\u0007\u000f^=Ue\u0006t7/Y2uS>t7\u000fK\u0002 \u0003\u001b\u000bq#Y:tKJ$H\u000b\u001f8NKR\fG-\u0019;b\u000bF,\u0018\r\\:\u0015\u000bI\fY,!5\t\u000f\u0005u\u0006\u00051\u0001\u0002@\u0006AQ\r\u001f9fGR,G\r\u0005\u0004\u0002B\u0006\u001d\u00171Z\u0007\u0003\u0003\u0007T1!!2m\u0003\u0011)H/\u001b7\n\t\u0005%\u00171\u0019\u0002\u0005\u0019&\u001cH\u000fE\u0002|\u0003\u001bL1!a4}\u0005-!\u0006P\\'fi\u0006$\u0017\r^1\t\u000f\u0005M\u0007\u00051\u0001\u0002@\u00061\u0011m\u0019;vC2$RA]Al\u00033Dq!!0\"\u0001\u0004\tY\rC\u0004\u0002T\u0006\u0002\r!a3\u0002-Q,7\u000f\u001e%bg2\u000bG/\u001a+sC:\u001c\u0018m\u0019;j_:D3AIAG\u00031\"Xm\u001d;ICNd\u0015\r^3Ue\u0006t7/Y2uS>t\u0017J\\5uS\u0006d\u0017N_3e\u0003\u001a$XM\u001d*fY>\fG\rK\u0002$\u0003\u001b\u000b1\u0007^3ti\"\u000b7\u000fT1uKR\u0013\u0018M\\:bGRLwN\\+qI\u0006$X\rZ!gi\u0016\u0014\b+\u0019:uS\u0006dGK];oG\u0006$\u0018n\u001c8)\u0007\u0011\ni)\u0001\u0019uKN$\b*Y:MCR,GK]1og\u0006\u001cG/[8o+B$\u0017\r^3e\u0003\u001a$XM\u001d$vY2$&/\u001e8dCRLwN\u001c\u0015\u0004K\u00055\u0015\u0001\t;fgRd\u0015m\u001d;Ti\u0006\u0014G.Z(gMN,GoQ8na2,G/\u001a3Uq:D3AJAG\u0003y!Xm\u001d;Qe\u0016\u0004\u0018M]3Va\u0012\fG/\u001a#pKNtu\u000e^'vi\u0006$X\rK\u0002(\u0003\u001b\u000ba$\u001e9eCR,\u0007K]8ek\u000e,'\u000f\u0016:b]N\f7\r^5p]N#\u0018\r^3)\u0007!\ni)\u0001\u0017uKN$x*\u001e;PMN+\u0017/^3oG\u0016\fe\r^3s\u0007>tGO]8m%\u0016\u001cwN\u001d3Fa>\u001c\u0007NQ;na\"\u001a\u0011&!$\u0002aQ,7\u000f\u001e(p]R\u0013\u0018M\\:bGRLwN\\1m\u0003B\u0004XM\u001c3XSRDwJ\\4pS:<GK]1og\u0006\u001cG/[8oQ\rQ\u0013QR\u00010i\u0016\u001cH\u000f\u0016:v]\u000e\fG/Z!oIJ+Gn\\1e%\u0016lwN^3t\u001fV$xJ\u001a*b]\u001e,7K\\1qg\"|Go\u001d\u0015\u0004W\u00055\u0015\u0001\u0005;fgR$\u0016m[3T]\u0006\u00048\u000f[8uQ\ra\u0013QR\u0001-i\u0016\u001cHOU3d_Z,'O\u0012:p[Ns\u0017\r]:i_R,fNZ5oSNDW\r\u001a+sC:\u001c\u0018m\u0019;j_:D3!LAG\u0003)\"Xm\u001d;SK\u000e|g/\u001a:Ge>l7K\\1qg\"|GOR5oSNDW\r\u001a+sC:\u001c\u0018m\u0019;j_:D3ALAG\u0003\u001d\"Xm\u001d;SK\u000e|g/\u001a:Ge>l7K\\1qg\"|G/R7qif$&/\u00198tC\u000e$\u0018n\u001c8)\u0007=\ni)\u0001\u0015uKN$\bK]8ek\u000e,'o\u0015;bi\u0016\fe\r^3s\r\u0016t7-\u001b8h\u0003\n|'\u000f^'be.,'\u000fK\u00021\u0003\u001b\u000bQ\u0004^3tiJ+Wn\u001c<f\u000bb\u0004\u0018N]3e!&$7o\u00148SK2|\u0017\r\u001a\u0015\u0004c\u00055\u0015!\f;fgR\f5mY3qi\u0006\u0003\b/\u001a8e/&$\bn\\;u!J|G-^2feN#\u0018\r^3P]J+\u0007\u000f\\5dC\"\u001a!'!$\u0002SQ,7\u000f^!dG\u0016\u0004H/\u00119qK:$w+\u001b;i'\u0016\fX/\u001a8dK\u001e\u000b\u0007o](o%\u0016\u0004H.[2bQ\r\u0019\u0014QR\u0001\u001ai\u0016\u001cH\u000fR3mKR,7K\\1qg\"|Go\u001d\"fM>\u0014X\rK\u00025\u0003\u001b\u000b1\u0004^3tiR\u0013XO\\2bi\u00164U\u000f\u001c7z\u0003:$7\u000b^1si\u0006#\bfA\u001b\u0002\u000e\u0006\u0019B/Z:u%\u0016dw.\u00193T]\u0006\u00048\u000f[8ug\"\u001aa'!$\u0002MQ,7\u000f\u001e$jeN$XK\\:uC\ndWm\u00144gg\u0016$\u0018I\u001a;feR\u0013XO\\2bi&|g\u000eK\u00028\u0003\u001b\u000ba\u0006^3ti2{\u0017\r\u001a$s_6\u001cf.\u00199tQ>$(+\u001a;bS:\u001chj\u001c8FqBL'/\u001a3Qe>$WoY3sg\"\u001a\u0001(!$\u0002CQ,7\u000f^*lSB\u001cf.\u00199tQ>$\u0018JZ(gMN,G/\u00168dQ\u0006tw-\u001a3)\u0007e\ni)\u0001\ruKN$\b+\u001b3FqBL'/\u0019;j_:$\u0016.\\3pkRD3AOAG\u0003]!Xm\u001d;GSJ\u001cH/\u00168ti\u0006\u0014G.Z(gMN,G\u000fK\u0002<\u0003\u001b\u000ba\u0006^3tiB\u0013x\u000eZ;dKJ\u001cx+\u001b;i\u001f:<w.\u001b8h)J\fgn]1di&|gn\u001d#p]R,\u0005\u0010]5sK\"\u001aA(!$\u0002[Q,7\u000f^*fcV,gnY3O_R4\u0016\r\\5eCR,GMR8s\u000fJ|W\u000f]'fi\u0006$\u0017\r^1U_BL7\rK\u0002>\u0003\u001b\u000bA\u0004^3ti>cG-\u00129pG\"4uN]\"p]R\u0014x\u000e\u001c*fG>\u0014H\rK\u0002?\u0003\u001b\u000ba\u0003^3ti\u000e{wN\u001d3j]\u0006$xN\u001d$f]\u000eLgn\u001a\u0015\u0004\u007f\u00055\u0015\u0001\t;fgR\u001cun\u001c:eS:\fGo\u001c:GK:\u001cW\rZ!gi\u0016\u0014(+\u001a7pC\u0012D3\u0001QAG\u0003u!Xm\u001d;M_\u0006$gI]8n\u000b6\u0004H/_*oCB\u001c\bn\u001c;GS2,\u0007fA!\u0002\u000e\u0006\tC/Z:u\u0019>\fGM\u0012:p[R\u0013XO\\2bi\u0016$7K\\1qg\"|GOR5mK\"\u001a!)!$\u0002?Q,7\u000f\u001e'pC\u00124%o\\7D_J\u0014X\u000f\u001d;T]\u0006\u00048\u000f[8u\r&dW\rK\u0002D\u0003\u001b\u000b1\u0004^3ti\u0006\u0003\b/\u001a8e\u000b6\u0004H/_\"p]R\u0014x\u000e\u001c\"bi\u000eD\u0007f\u0001#\u0002\u000e\u0006aB/Z:u%\u0016dw.\u00193Ge>lG+[3sK\u0012\u001cf.\u00199tQ>$\bfA#\u0002\u000e\u0006IB/Z:u':\f\u0007o\u001d5pi\u001aKG.\u001a$pe>3gm]3uQ\r1\u0015QR\u00012i\u0016\u001cHOU3n_Z,7\u000b\u001e:bsNs\u0017\r]:i_R\u001c8*Z3q\u00072,\u0017M\\*ikR$wn\u001e8T]\u0006\u00048\u000f[8u\u0003m!Xm\u001d;SK6|g/Z!mYN#(/Y=T]\u0006\u00048\u000f[8ug\"\u001a\u0001*!$\u0002IQ,7\u000f\u001e*f[>4X-\u00118e\u001b\u0006\u00148n\u00158baNDw\u000e\u001e$pe\u0012+G.\u001a;j_:D3!SAG\u0003I\"Xm\u001d;SK6|g/Z!oI6\u000b'o[*oCB\u001c\bn\u001c;G_J$U\r\\3uS>t\u0017\t\u001c:fC\u0012LH)\u001a7fi\u0016$\u0007f\u0001&\u0002\u000e\u0006YB/Z:u\u0019>\fGM\u0012:p[\u000e{'O];qiNs\u0017\r]:i_R$2A\u001dBA\u0011\u001d\u0011\u0019i\u0013a\u0001\u0005\u000b\u000bq\"\\1lK\u001aKG.Z\"peJ,\b\u000f\u001e\t\u0007;\n\u001d%1\u0012:\n\u0007\t%eLA\u0005Gk:\u001cG/[8ocA!!Q\u0012BL\u001b\t\u0011yI\u0003\u0003\u0003\u0012\nM\u0015\u0001C2iC:tW\r\\:\u000b\u0007\tUE.A\u0002oS>LAA!'\u0003\u0010\nYa)\u001b7f\u0007\"\fgN\\3m\u0003I\t\u0007\u000f]3oI\u0016sG\r\u0016=o\u001b\u0006\u00148.\u001a:\u0015!\t}%1\u0016BX\u0005c\u0013YLa3\u0003P\nM\u0007#B/\u0003\"\n\u0015\u0016b\u0001BR=\n1q\n\u001d;j_:\u00042a\u001fBT\u0013\r\u0011I\u000b \u0002\r\u0007>l\u0007\u000f\\3uK\u0012$\u0006P\u001c\u0005\u0007\u0005[c\u0005\u0019\u0001>\u0002\u000f5\f\u0007\u000f]5oO\"9\u00111\u0006'A\u0002\u0005=\u0002b\u0002BZ\u0019\u0002\u0007!QW\u0001\u000eaJ|G-^2fe\u0016\u0003xn\u00195\u0011\u0007u\u00139,C\u0002\u0003:z\u0013Qa\u00155peRDqA!0M\u0001\u0004\u0011y,A\u0006d_:$(o\u001c7UsB,\u0007\u0003\u0002Ba\u0005\u000fl!Aa1\u000b\t\t\u0015\u0017\u0011E\u0001\u0007e\u0016\u001cwN\u001d3\n\t\t%'1\u0019\u0002\u0012\u0007>tGO]8m%\u0016\u001cwN\u001d3UsB,\u0007b\u0002Bg\u0019\u0002\u0007\u0011qF\u0001\u0007_\u001a47/\u001a;\t\u0013\tEG\n%AA\u0002\u0005m\u0012\u0001E2p_J$\u0017N\\1u_J,\u0005o\\2i\u0011%\u0011)\u000e\u0014I\u0001\u0002\u0004\ty#A\u0005uS6,7\u000f^1na\u0006a\u0012\r\u001d9f]\u0012,e\u000e\u001a+y]6\u000b'o[3sI\u0011,g-Y;mi\u00122TC\u0001BnU\u0011\tYD!8,\u0005\t}\u0007\u0003\u0002Bq\u0005Wl!Aa9\u000b\t\t\u0015(q]\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!;_\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005[\u0014\u0019OA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fA$\u00199qK:$WI\u001c3Uq:l\u0015M]6fe\u0012\"WMZ1vYR$s'\u0006\u0002\u0003t*\"\u0011q\u0006Bo\u0003\u0019\t\u0007\u000f]3oIR\t\"O!?\u0003|\nu(q`B\u0002\u0007\u000b\u00199a!\u0005\t\u000ba|\u0005\u0019\u0001>\t\u000f\u0005-r\n1\u0001\u00020!9!1W(A\u0002\tU\u0006bBB\u0001\u001f\u0002\u0007\u00111H\u0001\u0004g\u0016\f\bb\u0002Bg\u001f\u0002\u0007\u0011q\u0006\u0005\n\u0005+|\u0005\u0013!a\u0001\u0003_A\u0011b!\u0003P!\u0003\u0005\raa\u0003\u0002\u001f%\u001cHK]1og\u0006\u001cG/[8oC2\u00042!XB\u0007\u0013\r\u0019yA\u0018\u0002\b\u0005>|G.Z1o\u0011%\u0019\u0019b\u0014I\u0001\u0002\u0004\u0019)\"\u0001\u0004pe&<\u0017N\u001c\t\u0004w\u000e]\u0011bAB\ry\na\u0011\t\u001d9f]\u0012|%/[4j]\u0006\u0001\u0012\r\u001d9f]\u0012$C-\u001a4bk2$HEN\u0001\u0011CB\u0004XM\u001c3%I\u00164\u0017-\u001e7uI]*\"a!\t+\t\r-!Q\\\u0001\u0011CB\u0004XM\u001c3%I\u00164\u0017-\u001e7uIa*\"aa\n+\t\rU!Q\u001c\u000b\fe\u000e-2QFB\u0018\u0007c\u0019Y\u0004C\u0003y'\u0002\u0007!\u0010C\u0004\u0002,M\u0003\r!a\f\t\u000f\t57\u000b1\u0001\u00020!911G*A\u0002\rU\u0012!\u00022bi\u000eD\u0007\u0003\u0002Ba\u0007oIAa!\u000f\u0003D\nY!+Z2pe\u0012\u0014\u0015\r^2i\u0011\u001d\u0019\u0019b\u0015a\u0001\u0007+\tacY;se\u0016tGo\u00158baNDw\u000e^(gMN,Go]\u000b\u0003\u0007\u0003\u0002baa\u0011\u0004R\u0005=b\u0002BB#\u0007\u001b\u00022aa\u0012_\u001b\t\u0019IEC\u0002\u0004Li\u000ba\u0001\u0010:p_Rt\u0014bAB(=\u00061\u0001K]3eK\u001aLAaa\u0015\u0004V\t\u00191+\u001a;\u000b\u0007\r=c\f")
public class ProducerStateManagerTest {
    private File logDir;
    private ProducerStateManager stateManager;
    private final TopicPartition partition = new TopicPartition("test", 0);
    private final long producerId;
    private final int maxTransactionTimeoutMs;
    private final ProducerStateManagerConfig producerStateManagerConfig = new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs());
    private final long lateTransactionTimeoutMs = (long)this.maxTransactionTimeoutMs() + 300000L;
    private final MockTime time = new MockTime();

    private File logDir() {
        return this.logDir;
    }

    private void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    private ProducerStateManager stateManager() {
        return this.stateManager;
    }

    private void stateManager_$eq(ProducerStateManager x$1) {
        this.stateManager = x$1;
    }

    private TopicPartition partition() {
        return this.partition;
    }

    private long producerId() {
        return this.producerId;
    }

    private int maxTransactionTimeoutMs() {
        return this.maxTransactionTimeoutMs;
    }

    private ProducerStateManagerConfig producerStateManagerConfig() {
        return this.producerStateManagerConfig;
    }

    private long lateTransactionTimeoutMs() {
        return this.lateTransactionTimeoutMs;
    }

    private MockTime time() {
        return this.time;
    }

    @BeforeEach
    public void setUp() {
        this.logDir_$eq(TestUtils.tempDirectory(null, null));
        this.stateManager_$eq(new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty()));
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.logDir(), (boolean)false);
    }

    @Test
    public void testBasicIdMapping() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, false, AppendOrigin.CLIENT);
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, false, AppendOrigin.CLIENT));
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 5, 0L, 2L, false, AppendOrigin.CLIENT));
        this.append(this.stateManager(), this.producerId(), (short)(epoch + 1), 0, 0L, 3L, false, AppendOrigin.CLIENT);
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 4L, false, AppendOrigin.CLIENT));
    }

    @Test
    public void testAppendTxnMarkerWithNoProducerState() {
        short producerEpoch = (short)2;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 27L, 0, this.appendEndTxnMarker$default$7());
        ProducerStateEntry firstEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).orElseThrow(() -> new RuntimeException("Expected last entry to be defined"));
        Assertions.assertEquals((short)producerEpoch, (short)firstEntry.producerEpoch());
        Assertions.assertEquals((long)this.producerId(), (long)firstEntry.producerId());
        Assertions.assertEquals((int)-1, (int)firstEntry.lastSeq());
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.append(this.stateManager(), this.producerId(), (short)0, 0, 0L, 4L, false, AppendOrigin.CLIENT));
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), producerEpoch, 17, 0L, 4L, false, AppendOrigin.CLIENT));
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, 39L, 4L, false, AppendOrigin.CLIENT);
        ProducerStateEntry secondEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).orElseThrow(() -> new RuntimeException("Expected last entry to be defined"));
        Assertions.assertEquals((short)producerEpoch, (short)secondEntry.producerEpoch());
        Assertions.assertEquals((long)this.producerId(), (long)secondEntry.producerId());
        Assertions.assertEquals((int)0, (int)secondEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        boolean x$8 = false;
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, AppendOrigin.REPLICATION);
        this.append(this.stateManager(), this.producerId(), epoch, 0, offset + 500L, this.append$default$6(), false, AppendOrigin.CLIENT);
        Optional maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isPresent());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)epoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)0, (int)lastEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWithWrapAroundBatchRecord() {
        short epoch = (short)15;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.REPLICATION, this.time().milliseconds());
        appendInfo.appendDataBatch(epoch, 0x7FFFFFF5, 9, this.time().milliseconds(), new LogOffsetMetadata(2000L), 2020L, false);
        Assertions.assertEquals(Optional.empty(), (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isPresent());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0x7FFFFFF5, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)9, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)2000L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)2020L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void testProducerSequenceInvalidWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        boolean x$8 = false;
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, AppendOrigin.REPLICATION);
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 1, offset + 500L, this.append$default$6(), false, AppendOrigin.CLIENT));
    }

    @Test
    public void testNoValidationOnFirstEntryWhenLoadingLog() {
        short epoch = (short)5;
        int sequence = 16;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        boolean x$8 = false;
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, AppendOrigin.REPLICATION);
        Optional maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isPresent());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)epoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)sequence, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)sequence, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)offset, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((long)offset, (long)lastEntry.firstDataOffset());
    }

    @Test
    public void testControlRecordBumpsProducerEpoch() {
        short producerEpoch = (short)0;
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        short bumpedProducerEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedProducerEpoch, ControlRecordType.ABORT, 1L, 0, this.appendEndTxnMarker$default$7());
        Optional maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isPresent());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)bumpedProducerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((int)-1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)-1, (int)lastEntry.lastSeq());
        this.append(this.stateManager(), this.producerId(), bumpedProducerEpoch, 0, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)0L)), this.stateManager().lastEntry(this.producerId()).map(x$3 -> BoxesRunTime.boxToLong((long)x$3.firstSeq())));
    }

    @Test
    public void testTxnFirstOffsetMetadataCached() {
        short producerEpoch = (short)0;
        long offset = 992342L;
        int seq = 0;
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), this.producerId(), ProducerStateEntry.empty((long)this.producerId()), AppendOrigin.CLIENT, this.time().milliseconds());
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(offset, 990000L, 234224);
        producerAppendInfo.appendDataBatch(producerEpoch, seq, seq, this.time().milliseconds(), firstOffsetMetadata, offset, true);
        this.stateManager().update(producerAppendInfo);
        Assertions.assertEquals(Optional.of(firstOffsetMetadata), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testLsoBatchAppends() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 27;
        AtomicInteger seq = new AtomicInteger(0);
        ProducerAppendInfo append = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.CLIENT, this.time().milliseconds());
        this.appendData$1(24L, 27L, append, producerEpoch, seq);
        Option firstTxnAbort = this.appendEndTxn$1(ControlRecordType.ABORT, 28L, append, coordinatorEpoch, producerEpoch);
        this.appendData$1(29L, 31L, append, producerEpoch, seq);
        Option secondTxnComplete = this.appendEndTxn$1(ControlRecordType.COMMIT, 32L, append, coordinatorEpoch, producerEpoch);
        ProducerAppendInfo appendDiffProdId = this.stateManager().prepareUpdate(2L, AppendOrigin.CLIENT, this.time().milliseconds());
        this.appendData$1(33L, 34L, appendDiffProdId, producerEpoch, seq);
        Option thirdTxnComplete = this.appendEndTxn$1(ControlRecordType.COMMIT, 35L, appendDiffProdId, coordinatorEpoch, producerEpoch);
        this.stateManager().update(append);
        this.stateManager().update(appendDiffProdId);
        Assertions.assertEquals((long)((CompletedTxn)secondTxnComplete.get()).firstOffset, (long)this.stateManager().proposedLastStableOffset((CompletedTxn)firstTxnAbort.get()));
        this.stateManager().completeTxn((CompletedTxn)firstTxnAbort.get());
        Assertions.assertEquals((long)((CompletedTxn)thirdTxnComplete.get()).firstOffset, (long)this.stateManager().proposedLastStableOffset((CompletedTxn)secondTxnComplete.get()));
        this.stateManager().completeTxn((CompletedTxn)secondTxnComplete.get());
        this.stateManager().onHighWatermarkUpdated(35L);
        Assertions.assertEquals(Optional.of(new LogOffsetMetadata(33L)), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testSkipEmptyTransactions() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 27;
        AtomicInteger seq = new AtomicInteger(0);
        long firstAppendTimeMs = this.time().milliseconds();
        ProducerAppendInfo firstAppend = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.CLIENT, firstAppendTimeMs);
        this.appendData$2(16L, 20L, firstAppend, producerEpoch, seq);
        this.assertTxnMetadataEquals(new TxnMetadata(this.producerId(), 16L, firstAppendTimeMs), (TxnMetadata)firstAppend.startedTransactions().get(0));
        this.stateManager().update(firstAppend);
        this.stateManager().onHighWatermarkUpdated(21L);
        Assertions.assertEquals(Optional.of(new LogOffsetMetadata(16L)), (Object)this.stateManager().firstUnstableOffset());
        long secondAppendTimeMs = this.time().milliseconds();
        ProducerAppendInfo secondAppend = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.CLIENT, secondAppendTimeMs);
        Option firstCompletedTxn = this.appendEndTxn$2(ControlRecordType.COMMIT, 21L, secondAppend, coordinatorEpoch, producerEpoch);
        Assertions.assertEquals((Object)new Some((Object)new CompletedTxn(this.producerId(), 16L, 21L, false)), (Object)firstCompletedTxn);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$2(ControlRecordType.COMMIT, 22L, secondAppend, coordinatorEpoch, producerEpoch));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$2(ControlRecordType.ABORT, 23L, secondAppend, coordinatorEpoch, producerEpoch));
        this.appendData$2(24L, 27L, secondAppend, producerEpoch, seq);
        Option secondCompletedTxn = this.appendEndTxn$2(ControlRecordType.ABORT, 28L, secondAppend, coordinatorEpoch, producerEpoch);
        Assertions.assertTrue((boolean)secondCompletedTxn.isDefined());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$2(ControlRecordType.ABORT, 29L, secondAppend, coordinatorEpoch, producerEpoch));
        this.appendData$2(30L, 31L, secondAppend, producerEpoch, seq);
        int size = secondAppend.startedTransactions().size();
        Assertions.assertEquals((int)2, (int)size);
        this.assertTxnMetadataEquals(new TxnMetadata(this.producerId(), new LogOffsetMetadata(24L), secondAppendTimeMs), (TxnMetadata)secondAppend.startedTransactions().get(0));
        this.assertTxnMetadataEquals(new TxnMetadata(this.producerId(), new LogOffsetMetadata(30L), secondAppendTimeMs), (TxnMetadata)secondAppend.startedTransactions().get(size - 1));
        this.stateManager().update(secondAppend);
        this.stateManager().completeTxn((CompletedTxn)firstCompletedTxn.get());
        this.stateManager().completeTxn((CompletedTxn)secondCompletedTxn.get());
        this.stateManager().onHighWatermarkUpdated(32L);
        Assertions.assertEquals(Optional.of(new LogOffsetMetadata(30L)), (Object)this.stateManager().firstUnstableOffset());
    }

    public void assertTxnMetadataEquals(List<TxnMetadata> expected, List<TxnMetadata> actual) {
        Iterator<TxnMetadata> expectedIter = expected.iterator();
        Iterator<TxnMetadata> actualIter = actual.iterator();
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        while (expectedIter.hasNext() && actualIter.hasNext()) {
            this.assertTxnMetadataEquals(expectedIter.next(), actualIter.next());
        }
    }

    public void assertTxnMetadataEquals(TxnMetadata expected, TxnMetadata actual) {
        Assertions.assertEquals((long)expected.producerId, (long)actual.producerId);
        Assertions.assertEquals((Object)expected.firstOffset, (Object)actual.firstOffset);
        Assertions.assertEquals((Object)expected.lastOffset, (Object)actual.lastOffset);
    }

    @Test
    public void testHasLateTransaction() {
        long producerId1 = 39L;
        short epoch1 = (short)2;
        long producerId2 = 57L;
        short epoch2 = (short)9;
        ProducerStateManager x$1 = this.stateManager();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, producerId1, epoch1, 0, 100L, x$7, true, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(500L);
        ProducerStateManager x$9 = this.stateManager();
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = AppendOrigin.CLIENT;
        this.append(x$9, producerId2, epoch2, 0, 150L, x$15, true, x$16);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(this.lateTransactionTimeoutMs() - 500L + 1L);
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(500L);
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.appendEndTxnMarker(this.stateManager(), producerId1, epoch1, ControlRecordType.COMMIT, 200L, 0, this.appendEndTxnMarker$default$7());
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.appendEndTxnMarker(this.stateManager(), producerId2, epoch2, ControlRecordType.COMMIT, 250L, 0, this.appendEndTxnMarker$default$7());
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testHasLateTransactionInitializedAfterReload() {
        long producerId1 = 39L;
        short epoch1 = (short)2;
        long producerId2 = 57L;
        short epoch2 = (short)9;
        ProducerStateManager x$1 = this.stateManager();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, producerId1, epoch1, 0, 100L, x$7, true, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(500L);
        ProducerStateManager x$9 = this.stateManager();
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = AppendOrigin.CLIENT;
        this.append(x$9, producerId2, epoch2, 0, 150L, x$15, true, x$16);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.stateManager().takeSnapshot();
        this.time().sleep(this.lateTransactionTimeoutMs() - 500L + 1L);
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        ProducerStateManager reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty());
        long loadTimeMs = this.time().milliseconds();
        reloadedStateManager.truncateAndReload(0L, this.stateManager().mapEndOffset(), loadTimeMs);
        Assertions.assertFalse((boolean)reloadedStateManager.hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(this.lateTransactionTimeoutMs());
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testHasLateTransactionUpdatedAfterPartialTruncation() {
        long producerId = 39L;
        short epoch = (short)2;
        ProducerStateManager x$1 = this.stateManager();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, producerId, epoch, 0, 100L, x$7, true, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(this.lateTransactionTimeoutMs() + 1L);
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.stateManager().truncateAndReload(0L, 80L, this.time().milliseconds());
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testHasLateTransactionUpdatedAfterFullTruncation() {
        long producerId = 39L;
        short epoch = (short)2;
        ProducerStateManager x$1 = this.stateManager();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, producerId, epoch, 0, 100L, x$7, true, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(this.lateTransactionTimeoutMs() + 1L);
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.stateManager().truncateFullyAndStartAt(150L);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testLastStableOffsetCompletedTxn() {
        short producerEpoch = (short)0;
        long segmentBaseOffset = 990000L;
        long producerId1 = this.producerId();
        long startOffset1 = 992342L;
        this.beginTxn$1(producerId1, startOffset1, segmentBaseOffset, producerEpoch);
        long producerId2 = this.producerId() + 1L;
        long startOffset2 = startOffset1 + 25L;
        this.beginTxn$1(producerId2, startOffset2, segmentBaseOffset, producerEpoch);
        long producerId3 = this.producerId() + 2L;
        long startOffset3 = startOffset1 + 57L;
        this.beginTxn$1(producerId3, startOffset3, segmentBaseOffset, producerEpoch);
        long lastOffset1 = startOffset3 + 15L;
        CompletedTxn completedTxn1 = new CompletedTxn(producerId1, startOffset1, lastOffset1, false);
        Assertions.assertEquals((long)startOffset2, (long)this.stateManager().proposedLastStableOffset(completedTxn1));
        this.stateManager().completeTxn(completedTxn1);
        this.stateManager().onHighWatermarkUpdated(lastOffset1 + 1L);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)startOffset2)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        long lastOffset3 = lastOffset1 + 20L;
        CompletedTxn completedTxn3 = new CompletedTxn(producerId3, startOffset3, lastOffset3, false);
        Assertions.assertEquals((long)startOffset2, (long)this.stateManager().proposedLastStableOffset(completedTxn3));
        this.stateManager().completeTxn(completedTxn3);
        this.stateManager().onHighWatermarkUpdated(lastOffset3 + 1L);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)startOffset2)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        long lastOffset2 = lastOffset3 + 78L;
        CompletedTxn completedTxn2 = new CompletedTxn(producerId2, startOffset2, lastOffset2, false);
        Assertions.assertEquals((long)(lastOffset2 + 1L), (long)this.stateManager().proposedLastStableOffset(completedTxn2));
        this.stateManager().completeTxn(completedTxn2);
        this.stateManager().onHighWatermarkUpdated(lastOffset2 + 1L);
        Assertions.assertEquals(Optional.empty(), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testPrepareUpdateDoesNotMutate() {
        short producerEpoch = (short)0;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.CLIENT, this.time().milliseconds());
        appendInfo.appendDataBatch(producerEpoch, 0, 5, this.time().milliseconds(), new LogOffsetMetadata(15L), 20L, false);
        Assertions.assertEquals(Optional.empty(), (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isPresent());
        ProducerAppendInfo nextAppendInfo = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.CLIENT, this.time().milliseconds());
        nextAppendInfo.appendDataBatch(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L), 30L, false);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isPresent());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)5, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        this.stateManager().update(nextAppendInfo);
        lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void updateProducerTransactionState() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 15;
        long offset = 9L;
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, offset, this.append$default$6(), false, AppendOrigin.CLIENT);
        long appendTimeMs = this.time().milliseconds();
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.CLIENT, appendTimeMs);
        appendInfo.appendDataBatch(producerEpoch, 1, 5, this.time().milliseconds(), new LogOffsetMetadata(16L), 20L, true);
        ProducerStateEntry lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)5, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((Object)OptionalLong.of(16L), (Object)lastEntry.currentTxnFirstOffset());
        this.assertTxnMetadataEquals(Arrays.asList(new TxnMetadata(this.producerId(), 16L, appendTimeMs)), appendInfo.startedTransactions());
        appendInfo.appendDataBatch(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L), 30L, true);
        lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((Object)OptionalLong.of(16L), (Object)lastEntry.currentTxnFirstOffset());
        this.assertTxnMetadataEquals(Arrays.asList(new TxnMetadata(this.producerId(), 16L, appendTimeMs)), appendInfo.startedTransactions());
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, coordinatorEpoch);
        Optional completedTxnOpt = appendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, 40L, this.time().milliseconds());
        Assertions.assertTrue((boolean)completedTxnOpt.isPresent());
        CompletedTxn completedTxn = (CompletedTxn)completedTxnOpt.get();
        Assertions.assertEquals((long)this.producerId(), (long)completedTxn.producerId);
        Assertions.assertEquals((long)16L, (long)completedTxn.firstOffset);
        Assertions.assertEquals((long)40L, (long)completedTxn.lastOffset);
        Assertions.assertFalse((boolean)completedTxn.isAborted);
        lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((int)coordinatorEpoch, (int)lastEntry.coordinatorEpoch());
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)lastEntry.currentTxnFirstOffset());
        this.assertTxnMetadataEquals(Arrays.asList(new TxnMetadata(this.producerId(), 16L, appendTimeMs)), appendInfo.startedTransactions());
    }

    @Test
    public void testOutOfSequenceAfterControlRecordEpochBump() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = AppendOrigin.CLIENT;
        this.append(x$9, x$10, epoch, 1, 1L, x$15, true, x$16);
        short bumpedEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, 0, this.appendEndTxnMarker$default$7());
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$17 = this.stateManager();
            long x$18 = this.producerId();
            long x$23 = this.append$default$6();
            AppendOrigin x$24 = AppendOrigin.CLIENT;
            this.append(x$17, x$18, bumpedEpoch, 2, 2L, x$23, true, x$24);
        });
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$25 = this.stateManager();
            long x$26 = this.producerId();
            short x$27 = (short)(bumpedEpoch + 1);
            long x$31 = this.append$default$6();
            AppendOrigin x$32 = AppendOrigin.CLIENT;
            this.append(x$25, x$26, x$27, 2, 2L, x$31, true, x$32);
        });
        ProducerStateManager x$33 = this.stateManager();
        long x$34 = this.producerId();
        long x$39 = this.append$default$6();
        AppendOrigin x$40 = AppendOrigin.CLIENT;
        this.append(x$33, x$34, bumpedEpoch, 0, 0L, x$39, true, x$40);
        Assertions.assertEquals((short)bumpedEpoch, (short)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).producerEpoch());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastSeq());
    }

    @Test
    public void testNonTransactionalAppendWithOngoingTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, x$8);
        Assertions.assertThrows(InvalidTxnStateException.class, () -> {
            ProducerStateManager x$9 = this.stateManager();
            long x$10 = this.producerId();
            long x$15 = this.append$default$6();
            AppendOrigin x$16 = AppendOrigin.CLIENT;
            this.append(x$9, x$10, epoch, 1, 1L, x$15, false, x$16);
        });
    }

    @Test
    public void testTruncateAndReloadRemovesOutOfRangeSnapshots() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 3, 3L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 4, 4L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.stateManager().truncateAndReload(1L, 3L, this.time().milliseconds());
        Assertions.assertEquals((Object)OptionalLong.of(2L), (Object)this.stateManager().oldestSnapshotOffset());
        Assertions.assertEquals((Object)OptionalLong.of(3L), (Object)this.stateManager().latestSnapshotOffset());
    }

    @Test
    public void testTakeSnapshot() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().list().length, (String)"Directory doesn't contain a single file as expected");
        Assertions.assertTrue((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().list())))), (String)"Snapshot file is empty");
        Optional snapshotFileOpt = this.stateManager().snapshotFileForOffset(2L);
        Assertions.assertTrue((boolean)snapshotFileOpt.isPresent());
        Assertions.assertTrue((boolean)((SnapshotFile)snapshotFileOpt.get()).isOpenForWrite());
    }

    @Test
    public void testRecoverFromSnapshotUnfinishedTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = AppendOrigin.CLIENT;
        this.append(x$9, x$10, epoch, 1, 1L, x$15, true, x$16);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        Optional loadedEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).firstSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).lastSeq());
        Assertions.assertEquals((Object)OptionalLong.of(0L), (Object)((ProducerStateEntry)loadedEntry.get()).currentTxnFirstOffset());
        long x$18 = this.producerId();
        long x$23 = this.append$default$6();
        AppendOrigin x$24 = AppendOrigin.CLIENT;
        this.append(recoveredMapping, x$18, epoch, 2, 2L, x$23, true, x$24);
    }

    @Test
    public void testRecoverFromSnapshotFinishedTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = AppendOrigin.CLIENT;
        this.append(x$9, x$10, epoch, 1, 1L, x$15, true, x$16);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.ABORT, 2L, 0, this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        Optional loadedEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).firstSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).lastSeq());
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)((ProducerStateEntry)loadedEntry.get()).currentTxnFirstOffset());
    }

    @Test
    public void testRecoverFromSnapshotEmptyTransaction() {
        short epoch = (short)0;
        long appendTimestamp = this.time().milliseconds();
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$7 = 0;
        this.appendEndTxnMarker(x$1, x$2, epoch, ControlRecordType.ABORT, 0L, x$7, appendTimestamp);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty());
        recoveredMapping.truncateAndReload(0L, 1L, this.time().milliseconds());
        Optional lastEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertTrue((boolean)lastEntry.isPresent());
        Assertions.assertEquals((long)appendTimestamp, (long)((ProducerStateEntry)lastEntry.get()).lastTimestamp());
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)((ProducerStateEntry)lastEntry.get()).currentTxnFirstOffset());
    }

    @Test
    public void testProducerStateAfterFencingAbortMarker() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)(epoch + 1), ControlRecordType.ABORT, 1L, 0, this.appendEndTxnMarker$default$7());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((long)-1L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((long)-1L, (long)lastEntry.firstDataOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isPresent());
    }

    @Test
    public void testRemoveExpiredPidsOnReload() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        this.append(recoveredMapping, this.producerId(), epoch, 2, 2L, 70001L, false, AppendOrigin.CLIENT);
        Assertions.assertEquals((int)1, (int)recoveredMapping.activeProducers().size());
        Assertions.assertEquals((int)2, (int)((ProducerStateEntry)recoveredMapping.activeProducers().values().iterator().next()).lastSeq());
        Assertions.assertEquals((long)3L, (long)recoveredMapping.mapEndOffset());
    }

    @Test
    public void testAcceptAppendWithoutProducerStateOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        int sequence = 2;
        Assertions.assertFalse((boolean)recoveredMapping.activeProducers().containsKey(BoxesRunTime.boxToLong((long)this.producerId())));
        long x$2 = this.producerId();
        boolean x$8 = false;
        this.append(recoveredMapping, x$2, epoch, sequence, 2L, 70001L, x$8, AppendOrigin.REPLICATION);
        Assertions.assertTrue((boolean)recoveredMapping.activeProducers().containsKey(BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)recoveredMapping.activeProducers().get(BoxesRunTime.boxToLong((long)this.producerId()));
        Assertions.assertEquals((short)epoch, (short)producerStateEntry.producerEpoch());
        Assertions.assertEquals((int)sequence, (int)producerStateEntry.firstSeq());
        Assertions.assertEquals((int)sequence, (int)producerStateEntry.lastSeq());
    }

    @Test
    public void testAcceptAppendWithSequenceGapsOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, AppendOrigin.CLIENT);
        int outOfOrderSequence = 3;
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$1 = this.stateManager();
            long x$2 = this.producerId();
            boolean x$8 = false;
            this.append(x$1, x$2, epoch, outOfOrderSequence, 1L, 1L, x$8, AppendOrigin.CLIENT);
        });
        Assertions.assertTrue((boolean)this.stateManager().activeProducers().containsKey(BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)this.stateManager().activeProducers().get(BoxesRunTime.boxToLong((long)this.producerId()));
        Assertions.assertNotNull((Object)producerStateEntry);
        Assertions.assertEquals((long)0L, (long)producerStateEntry.lastSeq());
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        boolean x$16 = false;
        this.append(x$9, x$10, epoch, outOfOrderSequence, 1L, 1L, x$16, AppendOrigin.REPLICATION);
        ProducerStateEntry producerStateEntryForReplication = (ProducerStateEntry)this.stateManager().activeProducers().get(BoxesRunTime.boxToLong((long)this.producerId()));
        Assertions.assertNotNull((Object)producerStateEntryForReplication);
        Assertions.assertEquals((int)outOfOrderSequence, (int)producerStateEntryForReplication.lastSeq());
    }

    @Test
    public void testDeleteSnapshotsBefore() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        Map snapshots = ((IterableOnceOps)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3}))).map((Function1 & Serializable)offset -> ProducerStateManagerTest.$anonfun$testDeleteSnapshotsBefore$1(this, BoxesRunTime.unboxToInt((Object)offset)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.stateManager().deleteSnapshotsBefore(3L);
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})), this.currentSnapshotOffsets());
        Assertions.assertFalse((boolean)((SnapshotFile)snapshots.apply((Object)BoxesRunTime.boxToInteger((int)2))).isOpenForWrite());
        Assertions.assertTrue((boolean)((SnapshotFile)snapshots.apply((Object)BoxesRunTime.boxToInteger((int)3))).isOpenForWrite());
        this.stateManager().deleteSnapshotsBefore(4L);
        Assertions.assertEquals((int)0, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
        snapshots.values().foreach((Function1 & Serializable)s -> {
            ProducerStateManagerTest.$anonfun$testDeleteSnapshotsBefore$2(s);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testTruncateFullyAndStartAt() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().truncateFullyAndStartAt(0L);
        Assertions.assertEquals((int)0, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testReloadSnapshots() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Object[] pathAndDataList = (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles()), (Function1 & Serializable)file -> new Tuple2((Object)file.toPath(), (Object)Files.readAllBytes(file.toPath())), ClassTag$.MODULE$.apply(Tuple2.class));
        this.append(this.stateManager(), this.producerId(), epoch, 3, 3L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 4, 4L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 5})), this.currentSnapshotOffsets());
        this.stateManager().truncateAndReload(3L, 5L, this.time().milliseconds());
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5})), this.currentSnapshotOffsets());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(pathAndDataList), (Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Path path = (Path)x0$1._1();
                byte[] data = (byte[])x0$1._2();
                return Files.write(path, data, new OpenOption[0]);
            }
            throw new MatchError(null);
        });
        this.stateManager().truncateFullyAndReloadSnapshots();
        Assertions.assertEquals((Object)OptionalLong.of(3L), (Object)this.stateManager().latestSnapshotOffset());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})), this.currentSnapshotOffsets());
    }

    @Test
    public void testFirstUnstableOffsetAfterTruncation() {
        short epoch = (short)0;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, x$8);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)99L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.stateManager().takeSnapshot();
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 105L, 0, this.appendEndTxnMarker$default$7());
        this.stateManager().onHighWatermarkUpdated(106L);
        Assertions.assertEquals(Optional.empty(), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 106L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().truncateAndReload(0L, 106L, this.time().milliseconds());
        Assertions.assertEquals(Optional.empty(), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.stateManager().truncateAndReload(0L, 100L, this.time().milliseconds());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)99L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
    }

    @Test
    public void testLoadFromSnapshotRetainsNonExpiredProducers() {
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        this.append(this.stateManager(), pid1, epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), pid2, epoch, 0, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.stateManager().activeProducers().size());
        this.stateManager().truncateAndReload(1L, 2L, this.time().milliseconds());
        Assertions.assertEquals((int)2, (int)this.stateManager().activeProducers().size());
        Optional entry1 = this.stateManager().lastEntry(pid1);
        Assertions.assertTrue((boolean)entry1.isPresent());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)entry1.get()).lastSeq());
        Assertions.assertEquals((long)0L, (long)((ProducerStateEntry)entry1.get()).lastDataOffset());
        Optional entry2 = this.stateManager().lastEntry(pid2);
        Assertions.assertTrue((boolean)entry2.isPresent());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)entry2.get()).lastSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)entry2.get()).lastDataOffset());
    }

    @Test
    public void testSkipSnapshotIfOffsetUnchanged() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testPidExpirationTimeout() {
        short epoch = (short)5;
        int sequence = 37;
        this.append(this.stateManager(), this.producerId(), epoch, sequence, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.time().sleep((long)(this.producerStateManagerConfig().producerIdExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        Assertions.assertEquals((int)1, (int)this.stateManager().activeProducers().size());
        Assertions.assertEquals((int)(sequence + 1), (int)((ProducerStateEntry)this.stateManager().activeProducers().values().iterator().next()).lastSeq());
        Assertions.assertEquals((long)3L, (long)this.stateManager().mapEndOffset());
    }

    @Test
    public void testFirstUnstableOffset() {
        short epoch = (short)5;
        int sequence = 0;
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, x$8);
        Assertions.assertEquals((Object)OptionalLong.of(99L), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)99L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        long anotherPid = 2L;
        ProducerStateManager x$9 = this.stateManager();
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = AppendOrigin.CLIENT;
        this.append(x$9, anotherPid, epoch, sequence, 105L, x$15, true, x$16);
        Assertions.assertEquals((Object)OptionalLong.of(99L), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)99L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 109L, 0, this.appendEndTxnMarker$default$7());
        Assertions.assertEquals((Object)OptionalLong.of(105L), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)99L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.stateManager().onHighWatermarkUpdated(100L);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)99L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.stateManager().onHighWatermarkUpdated(110L);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)105L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.appendEndTxnMarker(this.stateManager(), anotherPid, epoch, ControlRecordType.ABORT, 112L, 0, this.appendEndTxnMarker$default$7());
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)105L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.stateManager().onHighWatermarkUpdated(113L);
        Assertions.assertEquals(Optional.empty(), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
    }

    @Test
    public void testProducersWithOngoingTransactionsDontExpire() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, x$8);
        Assertions.assertEquals((Object)OptionalLong.of(99L), (Object)this.stateManager().firstUndecidedOffset());
        this.time().sleep((long)(this.producerStateManagerConfig().producerIdExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isPresent());
        Assertions.assertEquals((Object)OptionalLong.of(99L), (Object)this.stateManager().firstUndecidedOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isPresent());
    }

    @Test
    public void testSequenceNotValidatedForGroupMetadataTopic() {
        TopicPartition partition = new TopicPartition("__consumer_offsets", 0);
        ProducerStateManager stateManager = new ProducerStateManager(partition, this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty());
        short epoch = (short)0;
        long x$2 = this.producerId();
        long x$8 = this.append$default$6();
        this.append(stateManager, x$2, epoch, -1, 99L, x$8, true, AppendOrigin.COORDINATOR);
        long x$10 = this.producerId();
        long x$16 = this.append$default$6();
        this.append(stateManager, x$10, epoch, -1, 100L, x$16, true, AppendOrigin.COORDINATOR);
    }

    @Test
    public void testOldEpochForControlRecord() {
        short epoch = (short)5;
        int sequence = 0;
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, x$8);
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)3, ControlRecordType.COMMIT, 100L, 0, this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testCoordinatorFencing() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        Optional lastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)1)), lastEntry.map(x -> BoxesRunTime.boxToInteger((int)x.coordinatorEpoch())));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 101L, 1, this.appendEndTxnMarker$default$7());
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 102L, 2, this.appendEndTxnMarker$default$7());
        Assertions.assertThrows(TransactionCoordinatorFencedException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 103L, 1, this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testCoordinatorFencedAfterReload() {
        short producerEpoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, producerEpoch, 0, 99L, x$7, true, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty()).truncateAndReload(0L, 2L, 70000L);
        Assertions.assertThrows(TransactionCoordinatorFencedException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 0, this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testLoadFromEmptySnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        OptionalLong testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)OptionalLong.of(2L), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)testLoadFromCorruptSnapshot_latestSnapshotOffset.getAsLong());
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            testLoadFromCorruptSnapshot_channel.truncate(0L);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().get(BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertNotNull((Object)testLoadFromCorruptSnapshot_loadedProducerState);
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testLoadFromTruncatedSnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        OptionalLong testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)OptionalLong.of(2L), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)testLoadFromCorruptSnapshot_latestSnapshotOffset.getAsLong());
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            ProducerStateManagerTest.$anonfun$testLoadFromTruncatedSnapshotFile$1(testLoadFromCorruptSnapshot_channel);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().get(BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertNotNull((Object)testLoadFromCorruptSnapshot_loadedProducerState);
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testLoadFromCorruptSnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        OptionalLong testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)OptionalLong.of(2L), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)testLoadFromCorruptSnapshot_latestSnapshotOffset.getAsLong());
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            ProducerStateManagerTest.$anonfun$testLoadFromCorruptSnapshotFile$1(testLoadFromCorruptSnapshot_channel);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().get(BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertNotNull((Object)testLoadFromCorruptSnapshot_loadedProducerState);
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testAppendEmptyControlBatch() {
        long producerId = 23423L;
        int baseOffset = 15;
        RecordBatch batch = (RecordBatch)Mockito.mock(RecordBatch.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)batch.iterator()).thenReturn(Collections.emptyIterator());
        this.append(this.stateManager(), producerId, baseOffset, batch, AppendOrigin.CLIENT);
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)((ProducerStateEntry)this.stateManager().lastEntry(producerId).get()).currentTxnFirstOffset());
    }

    @Test
    public void testReloadFromTieredSnapshot() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Option maybeFile = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.stateManager().snapshotFileForOffset(3L))).map((Function1 & Serializable)x$4 -> x$4.file());
        Assertions.assertTrue((boolean)maybeFile.isDefined(), (String)"expected to find snapshot file at offset 3");
        File snapshotFile = (File)maybeFile.get();
        ByteBuffer buf = ByteBuffer.allocate((int)snapshotFile.length());
        try (FileChannel fc = FileChannel.open(snapshotFile.toPath(), new OpenOption[0]);){
            Utils.readFully((FileChannel)fc, (ByteBuffer)buf, (long)0L);
        }
        buf.flip();
        long originalLastDataOffset = ((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastDataOffset();
        int originalLastOffsetDelta = ((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastOffsetDelta();
        int originalLastSeq = ((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastSeq();
        long originalLastTimestamp = ((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastTimestamp();
        this.append(this.stateManager(), this.producerId(), epoch, 3, 3L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 4, 4L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().truncateFullyAndStartAt(0L);
        this.stateManager().reloadFromTieredSnapshot(this.time().milliseconds(), buf, 3L);
        this.stateManager().takeSnapshot();
        Assertions.assertTrue((boolean)this.stateManager().snapshotFileForOffset(3L).isPresent(), (String)"expected a snapshot file to exist for the restored snapshot");
        Assertions.assertEquals((int)this.logDir().listFiles().length, (int)1, (String)"expected all other snapshot files to be cleared, leaving only the restored snapshot file");
        ProducerStateEntry reloadedLastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((long)originalLastDataOffset, (long)reloadedLastEntry.lastDataOffset(), (String)"expected lastDataOffset to be restored");
        Assertions.assertEquals((int)originalLastOffsetDelta, (int)reloadedLastEntry.lastOffsetDelta(), (String)"expected lastOffsetDelta to be restored");
        Assertions.assertEquals((int)originalLastSeq, (int)reloadedLastEntry.lastSeq(), (String)"expected lastSeq to be restored");
        Assertions.assertEquals((long)originalLastTimestamp, (long)reloadedLastEntry.lastTimestamp(), (String)"expected lastTimestamp to be restored");
    }

    @Test
    public void testSnapshotFileForOffset() {
        Assertions.assertTrue((boolean)Paths.get(this.logDir().getAbsolutePath(), "00000000000000000020.snapshot").toFile().createNewFile());
        TopicPartition tp = new TopicPartition("test_topic", 0);
        ProducerStateManager producerStateManager = new ProducerStateManager(tp, this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty());
        File foundFile = ((SnapshotFile)producerStateManager.snapshotFileForOffset(20L).get()).file();
        Assertions.assertEquals((Object)"00000000000000000020.snapshot", (Object)foundFile.getName());
        Assertions.assertTrue((boolean)foundFile.exists());
        Assertions.assertFalse((boolean)producerStateManager.snapshotFileForOffset(19L).isPresent());
    }

    public void testRemoveStraySnapshotsKeepCleanShutdownSnapshot() {
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)5L).toPath(), new FileAttribute[0]);
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)2L).toPath(), new FileAttribute[0]);
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)42L).toPath(), new FileAttribute[0]);
        this.stateManager().removeStraySnapshots(Collections.singletonList(Predef$.MODULE$.long2Long(5L)));
        Assertions.assertEquals((Object)OptionalLong.of(42L), (Object)this.stateManager().latestSnapshotOffset());
        Assertions.assertEquals((Object)OptionalLong.of(5L), (Object)this.stateManager().oldestSnapshotOffset());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{5L, 42L})), (Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(ProducerStateManager.listSnapshotFiles((File)this.logDir())).asScala().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.offset))).sorted((Ordering)Ordering.Long$.MODULE$));
    }

    @Test
    public void testRemoveAllStraySnapshots() {
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)5L).toPath(), new FileAttribute[0]);
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)2L).toPath(), new FileAttribute[0]);
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)42L).toPath(), new FileAttribute[0]);
        this.stateManager().removeStraySnapshots(Collections.singletonList(Predef$.MODULE$.long2Long(42L)));
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{42L})), (Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(ProducerStateManager.listSnapshotFiles((File)this.logDir())).asScala().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.offset))).sorted((Ordering)Ordering.Long$.MODULE$));
    }

    @Test
    public void testRemoveAndMarkSnapshotForDeletion() {
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)5L).toPath(), new FileAttribute[0]);
        ProducerStateManager manager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty());
        Assertions.assertTrue((boolean)manager.latestSnapshotOffset().isPresent());
        Assertions.assertTrue((boolean)((Object)((SnapshotFile)manager.removeAndMarkSnapshotForDeletion(5L).get()).file().toPath()).toString().endsWith(".deleted"));
        Assertions.assertTrue((!manager.latestSnapshotOffset().isPresent() ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveAndMarkSnapshotForDeletionAlreadyDeleted() {
        File file = LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)5L);
        Files.createFile(file.toPath(), new FileAttribute[0]);
        ProducerStateManager manager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty());
        Assertions.assertTrue((boolean)manager.latestSnapshotOffset().isPresent());
        Files.delete(file.toPath());
        Assertions.assertTrue((!manager.removeAndMarkSnapshotForDeletion(5L).isPresent() ? 1 : 0) != 0);
        Assertions.assertTrue((!manager.latestSnapshotOffset().isPresent() ? 1 : 0) != 0);
    }

    private void testLoadFromCorruptSnapshot(Function1<FileChannel, BoxedUnit> makeFileCorrupt) {
        short epoch = (short)0;
        long producerId = 1L;
        this.append(this.stateManager(), producerId, epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), producerId, epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        OptionalLong latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)OptionalLong.of(2L), (Object)latestSnapshotOffset);
        File snapshotToTruncate = LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)latestSnapshotOffset.getAsLong());
        try (FileChannel channel = FileChannel.open(snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            makeFileCorrupt.apply((Object)channel);
        }
        ProducerStateManager reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty());
        reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)snapshotToTruncate.exists());
        ProducerStateEntry loadedProducerState = (ProducerStateEntry)reloadedStateManager.activeProducers().get(BoxesRunTime.boxToLong((long)producerId));
        Assertions.assertNotNull((Object)loadedProducerState);
        Assertions.assertEquals((long)0L, (long)loadedProducerState.lastDataOffset());
    }

    private Option<CompletedTxn> appendEndTxnMarker(ProducerStateManager mapping, long producerId, short producerEpoch, ControlRecordType controlType, long offset, int coordinatorEpoch, long timestamp) {
        long appendTimeMs = this.time().milliseconds();
        ProducerAppendInfo producerAppendInfo = this.stateManager().prepareUpdate(producerId, AppendOrigin.COORDINATOR, appendTimeMs);
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlType, coordinatorEpoch);
        Option completedTxnOpt = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(producerAppendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, offset, timestamp)));
        mapping.update(producerAppendInfo);
        completedTxnOpt.foreach((Function1 & Serializable)x$1 -> {
            mapping.completeTxn(x$1);
            return BoxedUnit.UNIT;
        });
        mapping.updateMapEndOffset(offset + 1L);
        return completedTxnOpt;
    }

    private void append(ProducerStateManager stateManager, long producerId, short producerEpoch, int seq, long offset, long timestamp, boolean isTransactional, AppendOrigin origin) {
        long appendTimeMs = this.time().milliseconds();
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, origin, appendTimeMs);
        producerAppendInfo.appendDataBatch(producerEpoch, seq, seq, timestamp, new LogOffsetMetadata(offset), offset, isTransactional);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private void append(ProducerStateManager stateManager, long producerId, long offset, RecordBatch batch, AppendOrigin origin) {
        long appendTimeMs = this.time().milliseconds();
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, origin, appendTimeMs);
        producerAppendInfo.append(batch, Optional.empty());
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private int appendEndTxnMarker$default$6() {
        return 0;
    }

    private long appendEndTxnMarker$default$7() {
        return this.time().milliseconds();
    }

    private long append$default$6() {
        return this.time().milliseconds();
    }

    private boolean append$default$7() {
        return false;
    }

    private AppendOrigin append$default$8() {
        return AppendOrigin.CLIENT;
    }

    private Set<Object> currentSnapshotOffsets() {
        return Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToLong((long)MergedLog$.MODULE$.offsetFromFile(file)), (ClassTag)ClassTag$.MODULE$.Long())).toSet();
    }

    private final Option appendEndTxn$1(ControlRecordType recordType, long offset, ProducerAppendInfo appendInfo, int coordinatorEpoch$1, short producerEpoch$2) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(appendInfo.appendEndTxnMarker(new EndTransactionMarker(recordType, coordinatorEpoch$1), producerEpoch$2, offset, this.time().milliseconds())));
    }

    private final void appendData$1(long startOffset, long endOffset, ProducerAppendInfo appendInfo, short producerEpoch$2, AtomicInteger seq$1) {
        int count = (int)(endOffset - startOffset);
        appendInfo.appendDataBatch(producerEpoch$2, seq$1.get(), seq$1.addAndGet(count), this.time().milliseconds(), new LogOffsetMetadata(startOffset), endOffset, true);
        seq$1.incrementAndGet();
    }

    private final Option appendEndTxn$2(ControlRecordType recordType, long offset, ProducerAppendInfo appendInfo, int coordinatorEpoch$2, short producerEpoch$3) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(appendInfo.appendEndTxnMarker(new EndTransactionMarker(recordType, coordinatorEpoch$2), producerEpoch$3, offset, this.time().milliseconds())));
    }

    private final void appendData$2(long startOffset, long endOffset, ProducerAppendInfo appendInfo, short producerEpoch$3, AtomicInteger seq$2) {
        int count = (int)(endOffset - startOffset);
        appendInfo.appendDataBatch(producerEpoch$3, seq$2.get(), seq$2.addAndGet(count), this.time().milliseconds(), new LogOffsetMetadata(startOffset), endOffset, true);
        seq$2.incrementAndGet();
    }

    private final void beginTxn$1(long producerId, long startOffset, long segmentBaseOffset$1, short producerEpoch$4) {
        int relativeOffset = (int)(startOffset - segmentBaseOffset$1);
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), producerId, ProducerStateEntry.empty((long)producerId), AppendOrigin.CLIENT, this.time().milliseconds());
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(startOffset, segmentBaseOffset$1, 50 * relativeOffset);
        producerAppendInfo.appendDataBatch(producerEpoch$4, 0, 0, this.time().milliseconds(), firstOffsetMetadata, startOffset, true);
        this.stateManager().update(producerAppendInfo);
    }

    public static final /* synthetic */ Tuple2 $anonfun$testDeleteSnapshotsBefore$1(ProducerStateManagerTest $this, int offset) {
        SnapshotFile snapshot = (SnapshotFile)$this.stateManager().snapshotFileForOffset((long)offset).get();
        Assertions.assertTrue((boolean)snapshot.isOpenForWrite());
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)offset)), (Object)snapshot);
    }

    public static final /* synthetic */ void $anonfun$testDeleteSnapshotsBefore$2(SnapshotFile s) {
        Assertions.assertFalse((boolean)s.isOpenForWrite());
    }

    public static final /* synthetic */ void $anonfun$testLoadFromTruncatedSnapshotFile$1(FileChannel file) {
        Assertions.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.truncate(file.size() / 2L);
    }

    public static final /* synthetic */ void $anonfun$testLoadFromCorruptSnapshotFile$1(FileChannel file) {
        Assertions.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.write(ByteBuffer.wrap(new byte[]{37}), file.size() / 2L);
    }

    public ProducerStateManagerTest() {
        this.producerId = 1L;
        this.maxTransactionTimeoutMs = 300000;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromEmptySnapshotFile$1$adapted(FileChannel file) {
        file.truncate(0L);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromTruncatedSnapshotFile$1$adapted(FileChannel file) {
        ProducerStateManagerTest.$anonfun$testLoadFromTruncatedSnapshotFile$1(file);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromCorruptSnapshotFile$1$adapted(FileChannel file) {
        ProducerStateManagerTest.$anonfun$testLoadFromCorruptSnapshotFile$1(file);
        return BoxedUnit.UNIT;
    }
}

