/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kafka.log.AbstractLog;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.log.TierLogSegment;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.RequestLocal;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.SegmentState;
import kafka.tier.store.TierObjectStore;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LazyIndex;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.TransactionIndex;
import org.apache.kafka.test.InterceptorUtils;
import org.junit.jupiter.api.Assertions;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;

public final class LogTestUtils$ {
    public static final LogTestUtils$ MODULE$ = new LogTestUtils$();

    /*
     * WARNING - void declaration
     */
    public LogSegment createSegment(long offset, File logDir, int indexIntervalBytes, Time time, boolean fileAlreadyExists) {
        void open_preallocate;
        void open_initFileSize;
        String logFile_suffix = "";
        Object var11_6 = null;
        boolean bl = false;
        boolean bl2 = false;
        File open_file = LogFileUtils.logFile((File)logDir, (long)offset, (String)logFile_suffix);
        Object var12_9 = null;
        FileRecords ms = FileRecords.open((File)open_file, (boolean)true, (boolean)fileAlreadyExists, (int)open_initFileSize, (boolean)open_preallocate);
        String offsetIndexFile_suffix = "";
        Object var15_11 = null;
        LazyIndex idx = LazyIndex.forOffset((File)LogFileUtils.offsetIndexFile((File)logDir, (long)offset, (String)offsetIndexFile_suffix), (boolean)fileAlreadyExists, (long)offset, (int)1000);
        String timeIndexFile_suffix = "";
        Object var16_13 = null;
        LazyIndex timeIdx = LazyIndex.forTime((File)LogFileUtils.timeIndexFile((File)logDir, (long)offset, (String)timeIndexFile_suffix), (boolean)fileAlreadyExists, (long)offset, (int)1500);
        String transactionIndexFile_suffix = "";
        Object var17_15 = null;
        TransactionIndex txnIndex = new TransactionIndex(offset, LogFileUtils.transactionIndexFile((File)logDir, (long)offset, (String)transactionIndexFile_suffix), fileAlreadyExists);
        return new LogSegment(ms, idx, timeIdx, txnIndex, offset, indexIntervalBytes, 0L, time);
    }

    public int createSegment$default$3() {
        return 10;
    }

    public Time createSegment$default$4() {
        return Time.SYSTEM;
    }

    public boolean createSegment$default$5() {
        return false;
    }

    public LogSegment createLocalLogSegment(long startOffset, long endOffset, File logDir, int indexIntervalBytes, Time time, long maxTimestamp) {
        LogSegment segment = this.createSegment(startOffset, logDir, indexIntervalBytes, time, false);
        List dummyData = (List)package$.MODULE$.List().fill((int)(endOffset - startOffset + 1L), (Function0 & Serializable)() -> "dummy_data");
        MemoryRecords recordList = this.records(startOffset, (Seq<String>)dummyData);
        segment.append(endOffset, recordList);
        return segment;
    }

    public int createLocalLogSegment$default$4() {
        return 10;
    }

    public Time createLocalLogSegment$default$5() {
        return Time.SYSTEM;
    }

    public long createLocalLogSegment$default$6() {
        return -1L;
    }

    /*
     * WARNING - void declaration
     */
    public MemoryRecords records(long offset, Seq<String> records) {
        void withRecords_records;
        void withRecords_timestampType;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])((IterableOnceOps)records.map((Function1 & Serializable)s -> new SimpleRecord(offset * 10L, s.getBytes()))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        TimestampType timestampType = TimestampType.CREATE_TIME;
        CompressionType withRecords_compressionType = CompressionType.NONE;
        return MemoryRecords.withRecords((byte)1, (long)offset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
    }

    public TierLogSegment createTierLogSegment(TopicIdPartition topicIdPartition, long startOffset, long endOffset, TierObjectStore objectStore, TierObjectMetadata.State state, long maxTimestamp, long firstBatchTimestamp, TierObjectMetadata.State stateBeforeDeletion, TierUploadType uploadType) {
        int segmentSize = (int)(endOffset - startOffset + 1L);
        SegmentState tierMetadata = new SegmentState(0, UUID.randomUUID(), startOffset, startOffset, endOffset, maxTimestamp, firstBatchTimestamp, segmentSize, state, false, false, false, uploadType, TierObjectStore.OpaqueData.ZEROED, stateBeforeDeletion, -1L);
        return new TierLogSegment(topicIdPartition, tierMetadata);
    }

    public TierObjectMetadata.State createTierLogSegment$default$5() {
        return TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE;
    }

    public long createTierLogSegment$default$6() {
        return 1L;
    }

    public long createTierLogSegment$default$7() {
        return 1L;
    }

    public TierObjectMetadata.State createTierLogSegment$default$8() {
        return TierObjectMetadata.State.INVALID;
    }

    public TierUploadType createTierLogSegment$default$9() {
        return TierUploadType.Archive;
    }

    public LogConfig createLogConfig(long segmentMs, int segmentBytes, long retentionMs, long retentionBytes, long segmentJitterMs, String cleanupPolicy, int maxMessageBytes, int indexIntervalBytes, int segmentIndexBytes, String messageFormatVersion, long fileDeleteDelayMs, boolean tierEnable, long tierLocalHotsetBytes, long tierLocalHotsetMs, int tierSegmentHotsetRollMinBytes, long preferTierFetchMs, boolean tierCleanerEnable, long minSegmentMs) {
        Properties logProps = new Properties();
        logProps.put("segment.ms", Predef$.MODULE$.long2Long(segmentMs));
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(segmentBytes));
        logProps.put("retention.ms", Predef$.MODULE$.long2Long(retentionMs));
        logProps.put("retention.bytes", Predef$.MODULE$.long2Long(retentionBytes));
        logProps.put("segment.jitter.ms", Predef$.MODULE$.long2Long(segmentJitterMs));
        logProps.put("cleanup.policy", cleanupPolicy);
        logProps.put("max.message.bytes", Predef$.MODULE$.int2Integer(maxMessageBytes));
        logProps.put("index.interval.bytes", Predef$.MODULE$.int2Integer(indexIntervalBytes));
        logProps.put("segment.index.bytes", Predef$.MODULE$.int2Integer(segmentIndexBytes));
        logProps.put("message.format.version", messageFormatVersion);
        logProps.put("file.delete.delay.ms", Predef$.MODULE$.long2Long(fileDeleteDelayMs));
        logProps.put("confluent.tier.enable", Predef$.MODULE$.boolean2Boolean(tierEnable));
        logProps.put("confluent.tier.local.hotset.bytes", Predef$.MODULE$.long2Long(tierLocalHotsetBytes));
        logProps.put("confluent.tier.local.hotset.ms", Predef$.MODULE$.long2Long(tierLocalHotsetMs));
        logProps.put("confluent.append.record.interceptor.classes", InterceptorUtils.MockRecordInterceptor.class.getName());
        logProps.put("confluent.tier.segment.hotset.roll.min.bytes", Predef$.MODULE$.int2Integer(tierSegmentHotsetRollMinBytes));
        logProps.put("confluent.prefer.tier.fetch.ms", Predef$.MODULE$.long2Long(preferTierFetchMs));
        logProps.put("confluent.tier.cleaner.enable", Predef$.MODULE$.boolean2Boolean(tierCleanerEnable));
        logProps.put("confluent.min.segment.ms", Predef$.MODULE$.long2Long(minSegmentMs));
        return new LogConfig((Map)logProps);
    }

    public MergedLog createLog(File dir, LogConfig config, BrokerTopicStats brokerTopicStats, Scheduler scheduler, Time time, long logStartOffset, long recoveryPoint, int maxTransactionTimeoutMs, ProducerStateManagerConfig producerStateManagerConfig, int producerIdExpirationCheckIntervalMs, TierLogComponents tierLogComponents, LogDirFailureChannel logDirFailureChannel, LogOffsetsListener logOffsetsListener, boolean lastShutdownClean, Option<Uuid> topicId, boolean keepPartitionMetadataFile, ConcurrentMap<String, Object> numRemainingSegments) {
        Metrics metrics = new Metrics();
        LogManager$.MODULE$.createProducerStateSensors(metrics);
        None$ x$18 = None$.MODULE$;
        None$ x$20 = None$.MODULE$;
        return MergedLog$.MODULE$.apply(dir, config, logStartOffset, recoveryPoint, scheduler, brokerTopicStats, metrics, time, maxTransactionTimeoutMs, producerStateManagerConfig, producerIdExpirationCheckIntervalMs, (Option)x$20, logDirFailureChannel, tierLogComponents, lastShutdownClean, topicId, keepPartitionMetadataFile, logOffsetsListener, (Option)x$18, numRemainingSegments);
    }

    public long createLogConfig$default$1() {
        return 604800000L;
    }

    public int createLogConfig$default$2() {
        return 0x40000000;
    }

    public long createLogConfig$default$3() {
        return 604800000L;
    }

    public long createLogConfig$default$4() {
        return -1L;
    }

    public long createLogConfig$default$5() {
        return 0L;
    }

    public String createLogConfig$default$6() {
        return "delete";
    }

    public int createLogConfig$default$7() {
        return 0x10000C;
    }

    public int createLogConfig$default$8() {
        return 4096;
    }

    public int createLogConfig$default$9() {
        return 0xA00000;
    }

    public String createLogConfig$default$10() {
        return LogConfig.DEFAULT_MESSAGE_FORMAT_VERSION;
    }

    public long createLogConfig$default$11() {
        return 60000L;
    }

    public boolean createLogConfig$default$12() {
        return false;
    }

    public long createLogConfig$default$13() {
        return -1L;
    }

    public long createLogConfig$default$14() {
        return 86400000L;
    }

    public int createLogConfig$default$15() {
        return 0x6400000;
    }

    public long createLogConfig$default$16() {
        return -1L;
    }

    public boolean createLogConfig$default$17() {
        return true;
    }

    public long createLogConfig$default$18() {
        return 1L;
    }

    public long createLog$default$6() {
        return 0L;
    }

    public long createLog$default$7() {
        return 0L;
    }

    public int createLog$default$8() {
        return 300000;
    }

    public ProducerStateManagerConfig createLog$default$9() {
        return new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs());
    }

    public int createLog$default$10() {
        return Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
    }

    public TierLogComponents createLog$default$11() {
        return TierLogComponents$.MODULE$.EMPTY();
    }

    public LogDirFailureChannel createLog$default$12() {
        return new LogDirFailureChannel(10);
    }

    public LogOffsetsListener createLog$default$13() {
        return LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
    }

    public boolean createLog$default$14() {
        return true;
    }

    public Option<Uuid> createLog$default$15() {
        return None$.MODULE$;
    }

    public boolean createLog$default$16() {
        return true;
    }

    public ConcurrentMap<String, Object> createLog$default$17() {
        return new ConcurrentHashMap<String, Object>();
    }

    public boolean hasOffsetOverflow(AbstractLog log) {
        return this.firstOverflowSegment(log).isDefined();
    }

    public Option<LogSegment> firstOverflowSegment(AbstractLog log) {
        Object object = new Object();
        try {
            log.localLogSegments().foreach((Function1 & Serializable)segment -> {
                LogTestUtils$.$anonfun$firstOverflowSegment$1(object, segment);
                return BoxedUnit.UNIT;
            });
            return None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (Option)ex.value();
            }
            throw ex;
        }
    }

    public FileRecords rawSegment(File logDir, long baseOffset) {
        String logFile_suffix = "";
        Object var4_3 = null;
        File open_file = LogFileUtils.logFile((File)logDir, (long)baseOffset, (String)logFile_suffix);
        boolean open_mutable = true;
        return FileRecords.open((File)open_file, (boolean)open_mutable, (boolean)false, (int)0, (boolean)false);
    }

    public void initializeLogDirWithOverflowedSegment(File logDir) {
        long nextOffset = 0L;
        nextOffset = this.writeNormalSegment$1(nextOffset, logDir);
        nextOffset = this.writeOverflowSegment$1(nextOffset, logDir);
        this.writeNormalSegment$1(nextOffset, logDir);
    }

    public Iterable<Object> keysInLog(AbstractLog log) {
        return (Iterable)log.localLogSegments().flatMap((Function1 & Serializable)logSegment -> (Iterable)CollectionConverters$.MODULE$.IterableHasAsScala(logSegment.log().batches()).asScala().withFilter((Function1 & Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)LogTestUtils$.$anonfun$keysInLog$2(batch))).flatMap((Function1 & Serializable)batch -> (Iterable)CollectionConverters$.MODULE$.IterableHasAsScala((java.lang.Iterable)batch).asScala().withFilter((Function1 & Serializable)record -> BoxesRunTime.boxToBoolean((boolean)record.hasKey())).map((Function1 & Serializable)record -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2())))))));
    }

    public int totalKeyBytesInLogSegments(Iterable<LogSegment> segments) {
        IntRef totalKeyBytes = IntRef.create((int)0);
        segments.foreach((Function1 & Serializable)logSegment -> {
            LogTestUtils$.$anonfun$totalKeyBytesInLogSegments$1(totalKeyBytes, logSegment);
            return BoxedUnit.UNIT;
        });
        return totalKeyBytes.elem;
    }

    public AbstractLog recoverAndCheck(File logDir, LogConfig config, Iterable<Object> expectedKeys, BrokerTopicStats brokerTopicStats, Time time, Scheduler scheduler) {
        long x$7 = 0L;
        long x$8 = 0L;
        int x$9 = 300000;
        ProducerStateManagerConfig x$10 = this.createLog$default$9();
        int x$11 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        TierLogComponents x$12 = TierLogComponents$.MODULE$.EMPTY();
        LogDirFailureChannel x$13 = new LogDirFailureChannel(10);
        LogOffsetsListener x$14 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        None$ x$15 = None$.MODULE$;
        boolean x$16 = true;
        ConcurrentHashMap<String, Object> x$17 = new ConcurrentHashMap<String, Object>();
        MergedLog recoveredLog = this.createLog(logDir, config, brokerTopicStats, scheduler, time, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, false, (Option<Uuid>)x$15, x$16, x$17);
        time.sleep(config.fileDeleteDelayMs + 1L);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])logDir.listFiles()), (Function1 & Serializable)file -> {
            LogTestUtils$.$anonfun$recoverAndCheck$1(file);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals(expectedKeys, this.keysInLog((AbstractLog)recoveredLog));
        Assertions.assertFalse((boolean)this.hasOffsetOverflow((AbstractLog)recoveredLog));
        return recoveredLog;
    }

    public LogAppendInfo appendEndTxnMarkerAsLeader(AbstractLog log, long producerId, short producerEpoch, ControlRecordType controlType, long timestamp, int coordinatorEpoch, int leaderEpoch) {
        long x$6 = 0L;
        int x$7 = 0;
        MemoryRecords records = this.endTxnRecords(controlType, producerId, producerEpoch, x$6, coordinatorEpoch, x$7, timestamp);
        MetadataVersion x$11 = log.appendAsLeader$default$4();
        RequestLocal x$12 = log.appendAsLeader$default$5();
        return log.appendAsLeader(records, leaderEpoch, AppendOrigin.COORDINATOR, x$11, x$12);
    }

    public int appendEndTxnMarkerAsLeader$default$6() {
        return 0;
    }

    public int appendEndTxnMarkerAsLeader$default$7() {
        return 0;
    }

    private MemoryRecords endTxnRecords(ControlRecordType controlRecordType, long producerId, short epoch, long offset, int coordinatorEpoch, int partitionLeaderEpoch, long timestamp) {
        EndTransactionMarker marker = new EndTransactionMarker(controlRecordType, coordinatorEpoch);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)partitionLeaderEpoch, (long)producerId, (short)epoch, (EndTransactionMarker)marker);
    }

    private long endTxnRecords$default$4() {
        return 0L;
    }

    private int endTxnRecords$default$6() {
        return 0;
    }

    public FetchDataInfo readLog(AbstractLog log, long startOffset, int maxLength, FetchIsolation isolation, boolean minOneMessage) {
        return (FetchDataInfo)log.read(startOffset, maxLength, isolation, minOneMessage, false);
    }

    public FetchIsolation readLog$default$4() {
        return FetchIsolation.LOG_END;
    }

    public boolean readLog$default$5() {
        return true;
    }

    public Iterable<AbortedTxn> allAbortedTransactions(AbstractLog log) {
        return (Iterable)log.localLogSegments().flatMap((Function1 & Serializable)x$1 -> CollectionConverters$.MODULE$.ListHasAsScala(x$1.txnIndex().allAbortedTxns()).asScala());
    }

    public void deleteProducerSnapshotFiles(File logDir) {
        Object[] files = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])logDir.listFiles()), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)LogTestUtils$.$anonfun$deleteProducerSnapshotFiles$1(f)));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(files), (Function1 & Serializable)x$1 -> {
            LogTestUtils$.$anonfun$deleteProducerSnapshotFiles$2(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<Object> listProducerSnapshotOffsets(File logDir) {
        return ((IterableOnceOps)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(ProducerStateManager.listSnapshotFiles((File)logDir)).asScala().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.offset))).sorted((Ordering)Ordering.Long$.MODULE$)).toSeq();
    }

    public void assertLeaderEpochCacheEmpty(AbstractLog log) {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)log.leaderEpochCache());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)log.latestEpoch());
        File newFile_dir = log.dir();
        Object var2_2 = null;
        Assertions.assertFalse((boolean)new File(newFile_dir, "leader-epoch-checkpoint").exists());
    }

    /*
     * WARNING - void declaration
     */
    public void appendNonTransactionalAsLeader(AbstractLog log, int numRecords) {
        void withRecords_records;
        void withRecords_timestampType;
        IndexedSeq simpleRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)seq -> LogTestUtils$.$anonfun$appendNonTransactionalAsLeader$1(BoxesRunTime.unboxToInt((Object)seq)));
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var5_5 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    public Function1<Object, BoxedUnit> appendTransactionalAsLeader(AbstractLog log, long producerId, short producerEpoch, Time time) {
        return arg_0 -> LogTestUtils$.$anonfun$appendTransactionalAsLeader$1(IntRef.create((int)0), time, producerId, producerEpoch, log, arg_0);
    }

    private static final boolean hasOverflow$1(long baseOffset, RecordBatch batch) {
        return batch.lastOffset() > baseOffset + Integer.MAX_VALUE || batch.baseOffset() < baseOffset;
    }

    public static final /* synthetic */ void $anonfun$firstOverflowSegment$1(Object nonLocalReturnKey1$1, LogSegment segment) {
        if (CollectionConverters$.MODULE$.IterableHasAsScala(segment.log().batches()).asScala().find((Function1 & Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)LogTestUtils$.hasOverflow$1(segment.baseOffset(), (RecordBatch)batch))).isDefined()) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)segment));
        }
    }

    private static final SimpleRecord record$1(long offset) {
        byte[] data = Long.toString(offset).getBytes();
        return new SimpleRecord(data, data);
    }

    /*
     * WARNING - void declaration
     */
    private static final long writeSampleBatches$1(long baseOffset, FileRecords segment, File logDir$1) {
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        void withRecords_compressionType;
        void withRecords_records2;
        void withRecords_partitionLeaderEpoch2;
        void withRecords_compressionType2;
        void withRecords_records3;
        void withRecords_partitionLeaderEpoch3;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{LogTestUtils$.record$1(baseOffset)};
        boolean bl = false;
        CompressionType withRecords_compressionType3 = CompressionType.NONE;
        Object var4_5 = null;
        simpleRecordArray = null;
        segment.append(MemoryRecords.withRecords((byte)2, (long)baseOffset, (CompressionType)withRecords_compressionType3, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch3, (boolean)false, (SimpleRecord[])withRecords_records3));
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{LogTestUtils$.record$1(baseOffset + 1L), LogTestUtils$.record$1(baseOffset + 2L)};
        boolean bl2 = false;
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = baseOffset + 1L;
        compressionType = null;
        simpleRecordArray2 = null;
        segment.append(MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withRecords_records2));
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{LogTestUtils$.record$1(baseOffset + Integer.MAX_VALUE - 1L)};
        boolean bl3 = false;
        CompressionType compressionType2 = CompressionType.NONE;
        long withRecords_initialOffset2 = baseOffset + Integer.MAX_VALUE - 1L;
        compressionType2 = null;
        simpleRecordArray3 = null;
        segment.append(MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset2, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records));
        String offsetIndexFile_suffix = "";
        Object var17_14 = null;
        LogFileUtils.offsetIndexFile((File)logDir$1, (long)baseOffset, (String)offsetIndexFile_suffix).createNewFile();
        String timeIndexFile_suffix = "";
        Object var18_15 = null;
        LogFileUtils.timeIndexFile((File)logDir$1, (long)baseOffset, (String)timeIndexFile_suffix).createNewFile();
        return baseOffset + Integer.MAX_VALUE;
    }

    private final long writeNormalSegment$1(long baseOffset, File logDir$1) {
        long l;
        try (FileRecords segment = this.rawSegment(logDir$1, baseOffset);){
            l = LogTestUtils$.writeSampleBatches$1(baseOffset, segment, logDir$1);
        }
        return l;
    }

    private final long writeOverflowSegment$1(long baseOffset, File logDir$1) {
        long l;
        try (FileRecords segment = this.rawSegment(logDir$1, baseOffset);){
            l = LogTestUtils$.writeSampleBatches$1(LogTestUtils$.writeSampleBatches$1(baseOffset, segment, logDir$1), segment, logDir$1);
        }
        return l;
    }

    public static final /* synthetic */ boolean $anonfun$keysInLog$2(FileLogInputStream.FileChannelRecordBatch batch) {
        return !batch.isControlBatch();
    }

    public static final /* synthetic */ boolean $anonfun$totalKeyBytesInLogSegments$2(FileLogInputStream.FileChannelRecordBatch batch) {
        return !batch.isControlBatch();
    }

    public static final /* synthetic */ void $anonfun$totalKeyBytesInLogSegments$5(IntRef totalKeyBytes$1, Record record) {
        totalKeyBytes$1.elem += record.keySize();
    }

    public static final /* synthetic */ void $anonfun$totalKeyBytesInLogSegments$3(IntRef totalKeyBytes$1, FileLogInputStream.FileChannelRecordBatch batch) {
        CollectionConverters$.MODULE$.IterableHasAsScala((java.lang.Iterable)batch).asScala().withFilter((Function1 & Serializable)record -> BoxesRunTime.boxToBoolean((boolean)record.hasKey())).foreach((Function1 & Serializable)record -> {
            LogTestUtils$.$anonfun$totalKeyBytesInLogSegments$5(totalKeyBytes$1, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$totalKeyBytesInLogSegments$1(IntRef totalKeyBytes$1, LogSegment logSegment) {
        CollectionConverters$.MODULE$.IterableHasAsScala(logSegment.log().batches()).asScala().withFilter((Function1 & Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)LogTestUtils$.$anonfun$totalKeyBytesInLogSegments$2(batch))).foreach((Function1 & Serializable)batch -> {
            LogTestUtils$.$anonfun$totalKeyBytesInLogSegments$3(totalKeyBytes$1, batch);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$recoverAndCheck$1(File file) {
        Assertions.assertFalse((boolean)file.getName().endsWith(".deleted"), (String)"Unexpected .deleted file after recovery");
        Assertions.assertFalse((boolean)file.getName().endsWith(MergedLog$.MODULE$.CleanedFileSuffix()), (String)"Unexpected .cleaned file after recovery");
        Assertions.assertFalse((boolean)file.getName().endsWith(MergedLog$.MODULE$.SwapFileSuffix()), (String)"Unexpected .swap file after recovery");
    }

    public static final /* synthetic */ boolean $anonfun$deleteProducerSnapshotFiles$1(File f) {
        return f.isFile() && f.getName().endsWith(".snapshot");
    }

    public static final /* synthetic */ void $anonfun$deleteProducerSnapshotFiles$2(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ SimpleRecord $anonfun$appendNonTransactionalAsLeader$1(int seq) {
        return new SimpleRecord(String.valueOf(BoxesRunTime.boxToInteger((int)seq)).getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$appendTransactionalAsLeader$2(Time time$1, int seq) {
        return new SimpleRecord(time$1.milliseconds(), String.valueOf(BoxesRunTime.boxToInteger((int)seq)).getBytes());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$appendTransactionalAsLeader$1(IntRef sequence$1, Time time$1, long producerId$1, short producerEpoch$1, AbstractLog log$1, int numRecords) {
        void withTransactionalRecords_records;
        void withTransactionalRecords_baseSequence;
        IndexedSeq simpleRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(sequence$1.elem), sequence$1.elem + numRecords).map((Function1 & Serializable)seq -> LogTestUtils$.$anonfun$appendTransactionalAsLeader$2(time$1, BoxesRunTime.unboxToInt((Object)seq)));
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        int n = sequence$1.elem;
        CompressionType withTransactionalRecords_compressionType = CompressionType.NONE;
        Object var9_9 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)producerId$1, (short)producerEpoch$1, (int)withTransactionalRecords_baseSequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records);
        log$1.appendAsLeader(records, 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4(), log$1.appendAsLeader$default$5());
        sequence$1.elem += numRecords;
    }

    private LogTestUtils$() {
    }
}

