/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicLong;
import kafka.common.FetchedTimestampAndOffset;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.log.LogTestUtils$;
import kafka.server.Defaults$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.TransferableChannel;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpoint;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.BatchMetadata;
import org.apache.kafka.storage.internals.log.EpochEntry;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.storage.internals.log.ProducerStateEntry;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.RollParams;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tEc\u0001\u0002\u00192\u0001YBQ!\u0010\u0001\u0005\u0002yBq!\u0011\u0001C\u0002\u0013%!\t\u0003\u0004O\u0001\u0001\u0006Ia\u0011\u0005\b\u001f\u0002\u0011\r\u0011\"\u0003Q\u0011\u0019a\u0006\u0001)A\u0005#\"IQ\f\u0001a\u0001\u0002\u0004%IA\u0018\u0005\nO\u0002\u0001\r\u00111A\u0005\n!D\u0011B\u001c\u0001A\u0002\u0003\u0005\u000b\u0015B0\t\u000b=\u0004A\u0011\u00019\t\u0013\u0005E\u0001!%A\u0005\u0002\u0005M\u0001\"CA\u0015\u0001E\u0005I\u0011AA\u0016\u0011%\ty\u0003AI\u0001\n\u0003\t\t\u0004C\u0004\u00026\u0001!\t!a\u000e\t\u000f\u0005\u0015\u0004\u0001\"\u0001\u0002h!9\u0011q\u0010\u0001\u0005\u0002\u0005\u001d\u0004bBAE\u0001\u0011\u0005\u0011q\r\u0005\b\u0003'\u0003A\u0011AA4\u0011\u001d\t9\n\u0001C\u0001\u0003OBq!a'\u0001\t\u0003\t9\u0007C\u0004\u0002 \u0002!\t!a\u001a\t\u000f\u0005\r\u0006\u0001\"\u0001\u0002h!9\u0011q\u0015\u0001\u0005\u0002\u0005\u001d\u0004bBAV\u0001\u0011\u0005\u0011q\r\u0005\b\u0003_\u0003A\u0011AA4\u0011\u001d\t\u0019\f\u0001C\u0001\u0003OBq!a.\u0001\t\u0003\t9\u0007C\u0004\u0002<\u0002!\t!a\u001a\t\u000f\u0005}\u0006\u0001\"\u0001\u0002h!9\u00111\u0019\u0001\u0005\u0002\u0005\u001d\u0004bBAd\u0001\u0011%\u0011\u0011\u001a\u0005\n\u0003c\u0004\u0011\u0013!C\u0005\u0003'A\u0011\"a=\u0001#\u0003%I!a\u0005\t\u0013\u0005U\b!%A\u0005\n\u0005]\bbBA~\u0001\u0011\u0005\u0011q\r\u0005\b\u0003\u007f\u0004A\u0011AA4\u0011\u001d\u0011\u0019\u0001\u0001C\u0001\u0003OBqAa\u0002\u0001\t\u0003\t9\u0007C\u0004\u0003\f\u0001!\t!a\u001a\t\r=\u0004A\u0011\u0002B\b\u0011\u001d\u0011y\u0002\u0001C\u0001\u0003OBqAa\t\u0001\t\u0003\t9\u0007C\u0004\u0003(\u0001!\t!a\u001a\t\u000f\t-\u0002\u0001\"\u0001\u0002h!9!q\u0006\u0001\u0005\u0002\u0005\u001d\u0004b\u0002B\u001a\u0001\u0011\u0005\u0011q\r\u0005\b\u0005o\u0001A\u0011AA4\u0011\u001d\u0011Y\u0004\u0001C\u0005\u0005{\u0011a\u0002T8h'\u0016<W.\u001a8u)\u0016\u001cHO\u0003\u00023g\u0005\u0019An\\4\u000b\u0003Q\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001oA\u0011\u0001hO\u0007\u0002s)\t!(A\u0003tG\u0006d\u0017-\u0003\u0002=s\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A \u0011\u0005\u0001\u0003Q\"A\u0019\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\t1\t\u0005\u0002E\u00196\tQI\u0003\u0002G\u000f\u000611m\\7n_:T!\u0001\u000e%\u000b\u0005%S\u0015AB1qC\u000eDWMC\u0001L\u0003\ry'oZ\u0005\u0003\u001b\u0016\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\bu_BL7\rU1si&$\u0018n\u001c8!\u0003!\u0019XmZ7f]R\u001cX#A)\u0011\u0007I;\u0016,D\u0001T\u0015\t!V+A\u0004nkR\f'\r\\3\u000b\u0005YK\u0014AC2pY2,7\r^5p]&\u0011\u0001l\u0015\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\u0005\u0002A5&\u00111,\r\u0002\u000b\u0019><7+Z4nK:$\u0018!C:fO6,g\u000e^:!\u0003\u0019awn\u001a#jeV\tq\f\u0005\u0002aK6\t\u0011M\u0003\u0002cG\u0006\u0011\u0011n\u001c\u0006\u0002I\u0006!!.\u0019<b\u0013\t1\u0017M\u0001\u0003GS2,\u0017A\u00037pO\u0012K'o\u0018\u0013fcR\u0011\u0011\u000e\u001c\t\u0003q)L!a[\u001d\u0003\tUs\u0017\u000e\u001e\u0005\b[\u001e\t\t\u00111\u0001`\u0003\rAH%M\u0001\bY><G)\u001b:!\u00035\u0019'/Z1uKN+w-\\3oiR1\u0011,\u001d<|\u0003\u000fAQA]\u0005A\u0002M\faa\u001c4gg\u0016$\bC\u0001\u001du\u0013\t)\u0018H\u0001\u0003M_:<\u0007bB<\n!\u0003\u0005\r\u0001_\u0001\u0013S:$W\r_%oi\u0016\u0014h/\u00197CsR,7\u000f\u0005\u00029s&\u0011!0\u000f\u0002\u0004\u0013:$\bb\u0002?\n!\u0003\u0005\r!`\u0001\u0005i&lW\rE\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u0003)\u0015!B;uS2\u001c\u0018bAA\u0003\u007f\n!A+[7f\u0011%\tI!\u0003I\u0001\u0002\u0004\tY!A\tgS2,\u0017\t\u001c:fC\u0012LX\t_5tiN\u00042\u0001OA\u0007\u0013\r\ty!\u000f\u0002\b\u0005>|G.Z1o\u0003]\u0019'/Z1uKN+w-\\3oi\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u0016)\u001a\u00010a\u0006,\u0005\u0005e\u0001\u0003BA\u000e\u0003Ki!!!\b\u000b\t\u0005}\u0011\u0011E\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\t:\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003O\tiBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fqc\u0019:fCR,7+Z4nK:$H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u00055\"fA?\u0002\u0018\u000592M]3bi\u0016\u001cVmZ7f]R$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003gQC!a\u0003\u0002\u0018\u00059!/Z2pe\u0012\u001cHCBA\u001d\u0003\u000b\n9\u0005\u0005\u0003\u0002<\u0005\u0005SBAA\u001f\u0015\r\ty$R\u0001\u0007e\u0016\u001cwN\u001d3\n\t\u0005\r\u0013Q\b\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\u000bIl\u0001\u0019A:\t\u000f\u0005UR\u00021\u0001\u0002JA)\u0001(a\u0013\u0002P%\u0019\u0011QJ\u001d\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u0005\u0003\u0002R\u0005}c\u0002BA*\u00037\u00022!!\u0016:\u001b\t\t9FC\u0002\u0002ZU\na\u0001\u0010:p_Rt\u0014bAA/s\u00051\u0001K]3eK\u001aLA!!\u0019\u0002d\t11\u000b\u001e:j]\u001eT1!!\u0018:\u0003\u0015\u0019X\r^;q)\u0005I\u0007f\u0001\b\u0002lA!\u0011QNA>\u001b\t\tyG\u0003\u0003\u0002r\u0005M\u0014aA1qS*!\u0011QOA<\u0003\u001dQW\u000f]5uKJT1!!\u001fK\u0003\u0015QWO\\5u\u0013\u0011\ti(a\u001c\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hm\\<oQ\ry\u00111\u0011\t\u0005\u0003[\n))\u0003\u0003\u0002\b\u0006=$!C!gi\u0016\u0014X)Y2i\u0003Y!Xm\u001d;SK\u0006$wJ\\#naRL8+Z4nK:$\bf\u0001\t\u0002\u000eB!\u0011QNAH\u0013\u0011\t\t*a\u001c\u0003\tQ+7\u000f^\u0001\u001ai\u0016\u001cHOU3bI\n+gm\u001c:f\r&\u00148\u000f^(gMN,G\u000fK\u0002\u0012\u0003\u001b\u000b\u0011\u0003^3tiJ+\u0017\rZ!gi\u0016\u0014H*Y:uQ\r\u0011\u0012QR\u0001\u0010i\u0016\u001cHOU3bI\u001a\u0013x.\\$ba\"\u001a1#!$\u0002\u0019Q,7\u000f\u001e+sk:\u001c\u0017\r^3)\u0007Q\ti)\u0001\ruKN$HK];oG\u0006$X-R7qif\u001cVmZ7f]RD3!FAG\u0003Y\"Xm\u001d;SK2|\u0017\r\u001a'be\u001e,7\u000f\u001e+j[\u0016\u001cH/Y7q\u0003:$g*\u001a=u\u001f\u001a47/\u001a;BMR,'\u000f\u0016:v]\u000e\fG/[8oQ\r1\u0012QR\u0001\u0011i\u0016\u001cH\u000f\u0016:v]\u000e\fG/\u001a$vY2D3aFAG\u0003e!Xm\u001d;GS:$wJ\u001a4tKR\u0014\u0015\u0010V5nKN$\u0018-\u001c9)\u0007a\ti)A\ruKN$h*\u001a=u\u001f\u001a47/\u001a;DC2\u001cW\u000f\\1uS>t\u0007fA\r\u0002\u000e\u00061B/Z:u\u0007\"\fgnZ3GS2,7+\u001e4gSb,7\u000fK\u0002\u001b\u0003\u001b\u000bQ\u0004^3tiJ+7m\u001c<fef4\u0015\u000e_3t\u0007>\u0014(/\u001e9u\u0013:$W\r\u001f\u0015\u00047\u00055\u0015a\u0007;fgR\u0014VmY8wKJ$&/\u00198tC\u000e$\u0018n\u001c8J]\u0012,\u0007\u0010K\u0002\u001d\u0003\u001b\u000ba\u0004^3tiJ+7m\u001c<fef\u0014VMY;jY\u0012\u001cX\t]8dQ\u000e\u000b7\r[3)\u0007u\ti)A\u0007f]\u0012$\u0006P\u001c*fG>\u0014Hm\u001d\u000b\u0011\u0003s\tY-!6\u0002Z\u0006\r\u0018Q]Au\u0003[Dq!!4\u001f\u0001\u0004\ty-A\td_:$(o\u001c7SK\u000e|'\u000f\u001a+za\u0016\u0004B!a\u000f\u0002R&!\u00111[A\u001f\u0005E\u0019uN\u001c;s_2\u0014VmY8sIRK\b/\u001a\u0005\u0007\u0003/t\u0002\u0019A:\u0002\u0015A\u0014x\u000eZ;dKJLE\rC\u0004\u0002\\z\u0001\r!!8\u0002\u001bA\u0014x\u000eZ;dKJ,\u0005o\\2i!\rA\u0014q\\\u0005\u0004\u0003CL$!B*i_J$\b\"\u0002:\u001f\u0001\u0004\u0019\b\u0002CAt=A\u0005\t\u0019\u0001=\u0002)A\f'\u000f^5uS>tG*Z1eKJ,\u0005o\\2i\u0011!\tYO\bI\u0001\u0002\u0004A\u0018\u0001E2p_J$\u0017N\\1u_J,\u0005o\\2i\u0011!\tyO\bI\u0001\u0002\u0004\u0019\u0018!\u0003;j[\u0016\u001cH/Y7q\u0003])g\u000e\u001a+y]J+7m\u001c:eg\u0012\"WMZ1vYR$S'A\ff]\u0012$\u0006P\u001c*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%m\u00059RM\u001c3Uq:\u0014VmY8sIN$C-\u001a4bk2$HeN\u000b\u0003\u0003sT3a]A\f\u0003\u0005\"Xm\u001d;SK\u000e|g/\u001a:z\r&DXm]\"peJ,\b\u000f\u001e+j[\u0016Le\u000eZ3yQ\r\u0011\u0013QR\u0001\u001fi\u0016\u001cHOU3d_Z,'/_,ji\"\u001cuN\u001d:vaRlUm]:bO\u0016D3aIAG\u0003\u0015\"Xm\u001d;J]\u0012,\u0007p\u00159beNLG/_'vYRL\u0007\u000f\\3CCR\u001c\u0007.\u00119qK:$7\u000fK\u0002%\u0003\u001b\u000b!\u0006^3tiJ+7m\u001c<fef\fe\r^3s\r&dG.\u001a3J]\u0012,\u00070\u0011<pS\u0012\u001cxJ^3sM2|w\u000fK\u0002&\u0003\u001b\u000bq\u0004^3tiB\u0013Xm]3sm\u0016$G*Y:u\u001f\u001a47/\u001a;IC:$G.\u001b8hQ\r1\u0013Q\u0012\u000b\n3\nE!Q\u0003B\f\u00057AaAa\u0005(\u0001\u0004\u0019\u0018A\u00032bg\u0016|eMZ:fi\"9\u0011\u0011B\u0014A\u0002\u0005-\u0001B\u0002B\rO\u0001\u0007\u00010\u0001\u0007j]&$h)\u001b7f'&TX\rC\u0004\u0003\u001e\u001d\u0002\r!a\u0003\u0002\u0017A\u0014X-\u00197m_\u000e\fG/Z\u0001(i\u0016\u001cHo\u0011:fCR,w+\u001b;i\u0013:LGOR5mKNK'0Z!qa\u0016tG-T3tg\u0006<W\rK\u0002)\u0003\u001b\u000bq\u0005^3ti\u000e\u0013X-\u0019;f/&$\b.\u00138ji\u001aKG.Z*ju\u0016\u001cE.Z1s'\",H\u000fZ8x]\"\u001a\u0011&!$\u0002]MDw.\u001e7e)J,hnY1uK\u00163XM\\%g\u001f\u001a47/\u001a;Q_&tGo\u001d+p\u0003\u001e\u000b\u0007/\u00138UQ\u0016dun\u001a\u0015\u0004U\u00055\u0015A\u0005;fgR\f\u0005\u000f]3oI\u001a\u0013x.\u001c$jY\u0016D3aKAG\u0003i!Xm\u001d;MCN$8+Z4nK:$xJ\u001a4tKR\u001c\u0015m\u00195fQ\ra\u0013QR\u0001.i\u0016\u001cHOR1jY&3WK\\3ya\u0016\u001cG/\u001a3O_:,U\u000e\u001d;z\r&dW-\u00117sK\u0006$\u00170\u0012=jgR\u001c\bfA\u0017\u0002\u000e\u0006)B/Z:u\u0019\u0006\u001cHO\u00127vg\",G\rV5nK6\u001b\bf\u0001\u0018\u0002\u000e\u00069b.Z<Qe>$WoY3s'R\fG/Z'b]\u0006<WM\u001d\u000b\u0003\u0005\u007f\u0001BA!\u0011\u0003N5\u0011!1\t\u0006\u0004e\t\u0015#\u0002\u0002B$\u0005\u0013\n\u0011\"\u001b8uKJt\u0017\r\\:\u000b\u0007\t-s)A\u0004ti>\u0014\u0018mZ3\n\t\t=#1\t\u0002\u0015!J|G-^2feN#\u0018\r^3NC:\fw-\u001a:")
public class LogSegmentTest {
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final ArrayBuffer<LogSegment> segments = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private File logDir;

    private TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private ArrayBuffer<LogSegment> segments() {
        return this.segments;
    }

    private File logDir() {
        return this.logDir;
    }

    private void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogSegment createSegment(long offset, int indexIntervalBytes, Time time, boolean fileAlreadyExists) {
        LogSegment seg = LogTestUtils$.MODULE$.createSegment(offset, this.logDir(), indexIntervalBytes, time, fileAlreadyExists);
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    /*
     * WARNING - void declaration
     */
    public MemoryRecords records(long offset, scala.collection.immutable.Seq<String> records) {
        void withRecords_records;
        void withRecords_timestampType;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])((IterableOnceOps)records.map((Function1 & Serializable)s -> new SimpleRecord(offset * 10L, s.getBytes()))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        TimestampType timestampType = TimestampType.CREATE_TIME;
        CompressionType withRecords_compressionType = CompressionType.NONE;
        return MemoryRecords.withRecords((byte)1, (long)offset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
    }

    @BeforeEach
    public void setup() {
        this.logDir_$eq(TestUtils.tempDirectory(null, null));
    }

    @AfterEach
    public void teardown() {
        this.segments().foreach((Function1 & Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.logDir(), (boolean)false);
    }

    @Test
    public void testReadOnEmptySegment() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        Assertions.assertNull((Object)seg.read(40L, 300, seg.read$default$3(), seg.read$default$4()), (String)"Read beyond the last offset in the segment should be null");
    }

    @Test
    public void testReadBeforeFirstOffset() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        MemoryRecords ms = LogTestUtils$.MODULE$.records(50L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "little", "bee"}));
        seg.append(53L, ms);
        Records read = seg.read((long)41L, (int)300, (long)seg.read$default$3(), (boolean)seg.read$default$4()).records;
        TestUtils$.MODULE$.checkEquals(ms.records().iterator(), read.records().iterator());
    }

    @Test
    public void testReadAfterLast() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        MemoryRecords ms = LogTestUtils$.MODULE$.records(50L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, ms);
        Assertions.assertNull((Object)seg.read(52L, 200, seg.read$default$3(), seg.read$default$4()), (String)"Read beyond the last offset in the segment should give null");
    }

    @Test
    public void testReadFromGap() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        MemoryRecords ms = LogTestUtils$.MODULE$.records(50L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, ms);
        MemoryRecords ms2 = LogTestUtils$.MODULE$.records(60L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, ms2);
        FetchDataInfo read = seg.read(55L, 200, seg.read$default$3(), seg.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records.records().iterator());
    }

    @Test
    public void testTruncate() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        IntRef offset = IntRef.create((int)40);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 30).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> {
            MemoryRecords ms1 = LogTestUtils$.MODULE$.records(offset$2.elem, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
            seg.append((long)offset$2.elem, ms1);
            MemoryRecords ms2 = LogTestUtils$.MODULE$.records(offset$2.elem + 1, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
            seg.append((long)(offset$2.elem + 1), ms2);
            FetchDataInfo read = seg.read((long)offset$2.elem, 10000, seg.read$default$3(), seg.read$default$4());
            Assertions.assertEquals((Object)new .colon.colon((Object)((Record)ms1.records().iterator().next()), (List)new .colon.colon((Object)((Record)ms2.records().iterator().next()), (List)Nil$.MODULE$)), (Object)CollectionConverters$.MODULE$.IterableHasAsScala(read.records.records()).asScala().toList());
            seg.truncateTo((long)(offset$2.elem + 1));
            FetchDataInfo read2 = seg.read((long)offset$2.elem, 10000, seg.read$default$3(), seg.read$default$4());
            Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(read2.records.records()).asScala().size());
            TestUtils$.MODULE$.checkEquals(ms1.records().iterator(), read2.records.records().iterator());
            ++offset$2.elem;
        });
    }

    @Test
    public void testTruncateEmptySegment() {
        int maxSegmentMs = 300000;
        MockTime time = new MockTime();
        int x$3 = this.createSegment$default$2();
        boolean x$4 = this.createSegment$default$4();
        LogSegment seg = this.createSegment(0L, x$3, (Time)time, x$4);
        seg.timeIndex();
        seg.offsetIndex();
        seg.close();
        int x$7 = this.createSegment$default$2();
        boolean x$8 = this.createSegment$default$4();
        LogSegment reopened = this.createSegment(0L, x$7, (Time)time, x$8);
        Assertions.assertEquals((int)0, (int)seg.timeIndex().sizeInBytes());
        Assertions.assertEquals((int)0, (int)seg.offsetIndex().sizeInBytes());
        time.sleep(500L);
        reopened.truncateTo(57L);
        Assertions.assertEquals((long)0L, (long)reopened.timeWaitedForRoll(time.milliseconds(), -1L));
        Assertions.assertFalse((boolean)reopened.timeIndex().isFull());
        Assertions.assertFalse((boolean)reopened.offsetIndex().isFull());
        RollParams rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, 100L, 1024, time.milliseconds());
        Assertions.assertFalse((boolean)reopened.shouldRoll(rollParams));
        time.sleep((long)(maxSegmentMs + 1));
        Assertions.assertEquals((long)(maxSegmentMs + 1), (long)reopened.timeWaitedForRoll(time.milliseconds(), -1L));
        rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, 100L, 1024, time.milliseconds());
        Assertions.assertFalse((boolean)reopened.shouldRoll(rollParams));
        rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, (long)Integer.MAX_VALUE + 200L, 1024, time.milliseconds());
        Assertions.assertTrue((boolean)reopened.shouldRoll(rollParams));
    }

    @Test
    public void testReloadLargestTimestampAndNextOffsetAfterTruncation() {
        int numMessages = 30;
        LogSegment seg = this.createSegment(40L, 2 * LogTestUtils$.MODULE$.records(0L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})).sizeInBytes() - 1, this.createSegment$default$3(), this.createSegment$default$4());
        IntRef offset = IntRef.create((int)40);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> {
            seg.append((long)offset$3.elem, LogTestUtils$.MODULE$.records(offset$3.elem, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})));
            ++offset$3.elem;
        });
        Assertions.assertEquals((long)offset.elem, (long)seg.readNextOffset());
        int expectedNumEntries = numMessages / 2 - 1;
        Assertions.assertEquals((int)expectedNumEntries, (int)seg.timeIndex().entries(), (String)new StringBuilder(25).append("Should have ").append(expectedNumEntries).append(" time indexes").toString());
        seg.truncateTo(41L);
        Assertions.assertEquals((int)0, (int)seg.timeIndex().entries(), (String)"Should have 0 time indexes");
        Assertions.assertEquals((long)400L, (long)seg.largestTimestamp(), (String)"Largest timestamp should be 400");
        Assertions.assertEquals((long)41L, (long)seg.readNextOffset());
    }

    @Test
    public void testTruncateFull() {
        MockTime time = new MockTime(0L, 0L, 0L);
        int x$3 = this.createSegment$default$2();
        boolean x$4 = this.createSegment$default$4();
        LogSegment seg = this.createSegment(40L, x$3, (Time)time, x$4);
        time.sleep(400L);
        MemoryRecords records = LogTestUtils$.MODULE$.records(40L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(41L, records);
        time.sleep(500L);
        Assertions.assertEquals((long)500L, (long)seg.timeWaitedForRoll(time.milliseconds(), 900L));
        seg.truncateTo(0L);
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)seg.getFirstBatchTimestamp());
        Assertions.assertEquals((long)0L, (long)seg.timeWaitedForRoll(time.milliseconds(), -1L));
        Assertions.assertFalse((boolean)seg.timeIndex().isFull());
        Assertions.assertFalse((boolean)seg.offsetIndex().isFull());
        Assertions.assertNull((Object)seg.read(0L, 1024, seg.read$default$3(), seg.read$default$4()), (String)"Segment should be empty.");
        seg.append(41L, LogTestUtils$.MODULE$.records(40L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
    }

    @Test
    public void testFindOffsetByTimestamp() {
        int messageSize = LogTestUtils$.MODULE$.records(0L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"msg00"})).sizeInBytes();
        LogSegment seg = this.createSegment(40L, messageSize * 2 - 1, this.createSegment$default$3(), this.createSegment$default$4());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(40), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> seg.append((long)i, LogTestUtils$.MODULE$.records(i, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(3).append("msg").append(i).toString()}))));
        Assertions.assertEquals((long)490L, (long)seg.largestTimestamp());
        Assertions.assertEquals((long)42L, (long)((FetchedTimestampAndOffset)seg.findOffsetByTimestamp(420L, seg.findOffsetByTimestamp$default$2()).get()).offset());
        Assertions.assertEquals((long)43L, (long)((FetchedTimestampAndOffset)seg.findOffsetByTimestamp(421L, seg.findOffsetByTimestamp$default$2()).get()).offset());
        Assertions.assertEquals((long)43L, (long)((FetchedTimestampAndOffset)seg.findOffsetByTimestamp(430L, seg.findOffsetByTimestamp$default$2()).get()).offset());
        Assertions.assertEquals((long)44L, (long)((FetchedTimestampAndOffset)seg.findOffsetByTimestamp(431L, seg.findOffsetByTimestamp$default$2()).get()).offset());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)seg.findOffsetByTimestamp(491L, seg.findOffsetByTimestamp$default$2()));
        Assertions.assertEquals((long)41L, (long)((FetchedTimestampAndOffset)seg.findOffsetByTimestamp(401L, seg.findOffsetByTimestamp$default$2()).get()).offset());
        Assertions.assertEquals((long)40L, (long)((FetchedTimestampAndOffset)seg.findOffsetByTimestamp(399L, seg.findOffsetByTimestamp$default$2()).get()).offset());
    }

    @Test
    public void testNextOffsetCalculation() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        Assertions.assertEquals((long)40L, (long)seg.readNextOffset());
        seg.append(52L, LogTestUtils$.MODULE$.records(50L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "you"})));
        Assertions.assertEquals((long)53L, (long)seg.readNextOffset());
    }

    @Test
    public void testChangeFileSuffixes() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        File logFile = seg.log().file();
        File indexFile = seg.lazyOffsetIndex().file();
        File timeIndexFile = seg.lazyTimeIndex().file();
        Assertions.assertFalse((boolean)seg.lazyOffsetIndex().file().exists());
        Assertions.assertFalse((boolean)seg.lazyTimeIndex().file().exists());
        seg.changeFileSuffixes("", ".deleted");
        Assertions.assertFalse((boolean)seg.lazyOffsetIndex().file().exists());
        Assertions.assertFalse((boolean)seg.lazyTimeIndex().file().exists());
        Assertions.assertEquals((Object)new StringBuilder(8).append(logFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.log().file().getAbsolutePath());
        Assertions.assertEquals((Object)new StringBuilder(8).append(indexFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.lazyOffsetIndex().file().getAbsolutePath());
        Assertions.assertEquals((Object)new StringBuilder(8).append(timeIndexFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.lazyTimeIndex().file().getAbsolutePath());
        Assertions.assertTrue((boolean)seg.log().file().exists());
        seg.lazyOffsetIndex().get();
        Assertions.assertTrue((boolean)seg.lazyOffsetIndex().file().exists());
        seg.lazyTimeIndex().get();
        Assertions.assertTrue((boolean)seg.lazyTimeIndex().file().exists());
    }

    @Test
    public void testRecoveryFixesCorruptIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> seg.append((long)i, LogTestUtils$.MODULE$.records(i, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Integer.toString(i)}))));
        File indexFile = seg.lazyOffsetIndex().file();
        TestUtils$.MODULE$.writeNonsenseToFile(indexFile, 5L, (int)indexFile.length());
        seg.recover(this.newProducerStateManager(), seg.recover$default$2());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            long x$1 = i;
            long x$4 = seg.read$default$3();
            Iterable records = seg$4.read((long)x$1, (int)1, (long)x$4, (boolean)true).records.records();
            Assertions.assertEquals((long)i, (long)((Record)records.iterator().next()).offset());
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoverTransactionIndex() {
        void withRecords_records;
        void withRecords_compressionType;
        void withTransactionalRecords_records;
        void withTransactionalRecords_compressionType;
        void withTransactionalRecords_records2;
        void withTransactionalRecords_compressionType2;
        MockTime time = new MockTime();
        LogSegment segment = this.createSegment(100L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        short producerEpoch = (short)0;
        int partitionLeaderEpoch = 15;
        int sequence = 100;
        long pid1 = 5L;
        long pid2 = 10L;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        CompressionType compressionType = CompressionType.NONE;
        long withTransactionalRecords_initialOffset = 100L;
        compressionType = null;
        simpleRecordArray = null;
        segment.append(101L, MemoryRecords.withRecords((byte)2, (long)withTransactionalRecords_initialOffset, (CompressionType)withTransactionalRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)pid1, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (boolean)true, (SimpleRecord[])withTransactionalRecords_records2));
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        CompressionType compressionType2 = CompressionType.NONE;
        long withTransactionalRecords_initialOffset2 = 102L;
        compressionType2 = null;
        simpleRecordArray2 = null;
        segment.append(103L, MemoryRecords.withRecords((byte)2, (long)withTransactionalRecords_initialOffset2, (CompressionType)withTransactionalRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)pid2, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (boolean)true, (SimpleRecord[])withTransactionalRecords_records));
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        CompressionType compressionType3 = CompressionType.NONE;
        long withRecords_initialOffset = 104L;
        compressionType3 = null;
        simpleRecordArray3 = null;
        segment.append(105L, MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records));
        segment.append(106L, this.endTxnRecords(ControlRecordType.ABORT, pid2, producerEpoch, 106L, 0, 0, -1L));
        segment.append(107L, this.endTxnRecords(ControlRecordType.COMMIT, pid1, producerEpoch, 107L, 0, 0, -1L));
        ProducerStateManager stateManager = this.newProducerStateManager();
        segment.recover(stateManager, segment.recover$default$2());
        Assertions.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        java.util.List abortedTxns = segment.txnIndex().allAbortedTxns();
        Assertions.assertEquals((int)1, (int)abortedTxns.size());
        AbortedTxn abortedTxn = (AbortedTxn)abortedTxns.get(0);
        Assertions.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assertions.assertEquals((long)102L, (long)abortedTxn.firstOffset());
        Assertions.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assertions.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
        stateManager = this.newProducerStateManager();
        long loadTimeMs = time.milliseconds();
        stateManager.loadProducerEntry(new ProducerStateEntry(pid2, producerEpoch, 0, -1L, OptionalLong.of(75L), Optional.of(new BatchMetadata(10, 10L, 5, -1L))), loadTimeMs);
        segment.recover(stateManager, segment.recover$default$2());
        Assertions.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        abortedTxns = segment.txnIndex().allAbortedTxns();
        Assertions.assertEquals((int)1, (int)abortedTxns.size());
        abortedTxn = (AbortedTxn)abortedTxns.get(0);
        Assertions.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assertions.assertEquals((long)75L, (long)abortedTxn.firstOffset());
        Assertions.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assertions.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryRebuildsEpochCache() {
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        void withRecords_compressionType;
        void withRecords_records2;
        void withRecords_partitionLeaderEpoch2;
        void withRecords_compressionType2;
        void withRecords_records3;
        void withRecords_partitionLeaderEpoch3;
        void withRecords_compressionType3;
        void withRecords_records4;
        void withRecords_partitionLeaderEpoch4;
        void withRecords_compressionType4;
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        LeaderEpochCheckpoint checkpoint = new LeaderEpochCheckpoint(null){
            private Seq<EpochEntry> epochs;
            private final File file;

            private Seq<EpochEntry> epochs() {
                return this.epochs;
            }

            private void epochs_$eq(Seq<EpochEntry> x$1) {
                this.epochs = x$1;
            }

            public void write(Collection<EpochEntry> epochs) {
                this.epochs_$eq((Seq<EpochEntry>)CollectionConverters$.MODULE$.CollectionHasAsScala(epochs).asScala().toSeq());
            }

            public java.util.List<EpochEntry> read() {
                return CollectionConverters$.MODULE$.SeqHasAsJava(this.epochs()).asJava();
            }

            public File file() {
                return this.file;
            }

            public byte[] toByteArray(java.util.List<EpochEntry> epochs) {
                throw new UnsupportedOperationException("toByteArray is currently unused and is not implemented for the test checkpoint implementation");
            }
            {
                this.epochs = (Seq)Seq$.MODULE$.empty();
                this.file = TestUtils.tempFile((String)"kafka", (String)".tmp");
            }
        };
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.topicPartition(), checkpoint);
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        boolean bl = false;
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = 104L;
        compressionType = null;
        simpleRecordArray = null;
        seg.append(105L, MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType4, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch4, (boolean)false, (SimpleRecord[])withRecords_records4));
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        boolean bl2 = true;
        CompressionType compressionType2 = CompressionType.NONE;
        long withRecords_initialOffset2 = 106L;
        compressionType2 = null;
        simpleRecordArray2 = null;
        seg.append(107L, MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset2, (CompressionType)withRecords_compressionType3, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch3, (boolean)false, (SimpleRecord[])withRecords_records3));
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        boolean bl3 = true;
        CompressionType compressionType3 = CompressionType.NONE;
        long withRecords_initialOffset3 = 108L;
        compressionType3 = null;
        simpleRecordArray3 = null;
        seg.append(109L, MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset3, (CompressionType)withRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withRecords_records2));
        SimpleRecord[] simpleRecordArray4 = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        int n = 2;
        CompressionType compressionType4 = CompressionType.NONE;
        long withRecords_initialOffset4 = 110L;
        compressionType4 = null;
        simpleRecordArray4 = null;
        seg.append(111L, MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset4, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records));
        seg.recover(this.newProducerStateManager(), (Option)new Some((Object)cache));
        Assertions.assertEquals(Arrays.asList(new EpochEntry(0, 104L), new EpochEntry(1, 106L), new EpochEntry(2, 110L)), (Object)cache.epochEntries());
    }

    private MemoryRecords endTxnRecords(ControlRecordType controlRecordType, long producerId, short producerEpoch, long offset, int partitionLeaderEpoch, int coordinatorEpoch, long timestamp) {
        EndTransactionMarker marker = new EndTransactionMarker(controlRecordType, coordinatorEpoch);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)partitionLeaderEpoch, (long)producerId, (short)producerEpoch, (EndTransactionMarker)marker);
    }

    private int endTxnRecords$default$5() {
        return 0;
    }

    private int endTxnRecords$default$6() {
        return 0;
    }

    private long endTxnRecords$default$7() {
        return -1L;
    }

    @Test
    public void testRecoveryFixesCorruptTimeIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> seg.append((long)i, LogTestUtils$.MODULE$.records(i, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Integer.toString(i)}))));
        File timeIndexFile = seg.lazyTimeIndex().file();
        TestUtils$.MODULE$.writeNonsenseToFile(timeIndexFile, 5L, (int)timeIndexFile.length());
        seg.recover(this.newProducerStateManager(), seg.recover$default$2());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Assertions.assertEquals((long)i, (long)((FetchedTimestampAndOffset)seg.findOffsetByTimestamp((long)(i * 10), seg.findOffsetByTimestamp$default$2()).get()).offset());
            if (i < 99) {
                Assertions.assertEquals((long)(i + 1), (long)((FetchedTimestampAndOffset)seg.findOffsetByTimestamp((long)(i * 10 + 1), seg.findOffsetByTimestamp$default$2()).get()).offset());
                return;
            }
        });
    }

    @Test
    public void testRecoveryWithCorruptMessage() {
        int messagesAppended = 20;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> {
            LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), messagesAppended).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> seg.append((long)i, LogTestUtils$.MODULE$.records(i, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Integer.toString(i)}))));
            int offsetToBeginCorruption = TestUtils$.MODULE$.random().nextInt(messagesAppended);
            int position = seg.log().searchForOffsetWithSize((long)((long)offsetToBeginCorruption), (int)0).position + TestUtils$.MODULE$.random().nextInt(15);
            TestUtils$.MODULE$.writeNonsenseToFile(seg.log().file(), position, (int)(seg.log().file().length() - (long)position));
            seg.recover(this.newProducerStateManager(), seg.recover$default$2());
            Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), offsetToBeginCorruption).toList(), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(seg.log().batches()).asScala().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.lastOffset()))).toList(), (String)"Should have truncated off bad messages.");
            seg.deleteIfExists();
        });
    }

    @Test
    public void testIndexSparsityMultipleBatchAppends() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        ByteBufferChannel channel = new ByteBufferChannel(100000L);
        int numBatches = 100;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numBatches).foreach((Function1)(JFunction1.mcJI.sp & Serializable)i -> {
            void withRecords_records;
            void withRecords_compressionType;
            void withRecords_initialOffset;
            SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("foo".getBytes())};
            CompressionType compressionType = CompressionType.NONE;
            long l = i;
            byte withRecords_magic = 2;
            TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
            Object var8_6 = null;
            compressionType = null;
            simpleRecordArray = null;
            MemoryRecords memoryBatch = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
            return memoryBatch.writeTo((TransferableChannel)channel, 0L, memoryBatch.sizeInBytes());
        });
        ByteBuffer buf = channel.buffer();
        buf.flip();
        MemoryRecords appendable = new MemoryRecords(buf);
        seg.append((long)numBatches, appendable);
        Assertions.assertEquals((int)(numBatches - 1), (int)seg.offsetIndex().entries(), (String)"every batch should have its own offset index entry aside from the last one");
    }

    @Test
    public void testRecoveryAfterFilledIndexAvoidsOverflow() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        ByteBufferChannel channel = new ByteBufferChannel(100000L);
        int numBatches = 200;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numBatches).foreach((Function1)(JFunction1.mcJI.sp & Serializable)i -> {
            void withRecords_records;
            void withRecords_compressionType;
            void withRecords_initialOffset;
            SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("foo".getBytes())};
            CompressionType compressionType = CompressionType.NONE;
            long l = i;
            byte withRecords_magic = 2;
            TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
            Object var8_6 = null;
            compressionType = null;
            simpleRecordArray = null;
            MemoryRecords memoryBatch = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
            return memoryBatch.writeTo((TransferableChannel)channel, 0L, memoryBatch.sizeInBytes());
        });
        ByteBuffer buf = channel.buffer();
        buf.flip();
        MemoryRecords appendable = new MemoryRecords(buf);
        seg.append((long)numBatches, appendable);
        Assertions.assertTrue((boolean)seg.offsetIndex().isFull(), (String)"batch index should have been filled from single append of many batches");
        seg.close();
        this.segments().remove(0);
        int x$3 = this.createSegment$default$2();
        Time x$4 = this.createSegment$default$3();
        LogSegment recovered = this.createSegment(0L, x$3, x$4, true);
        recovered.recover(this.newProducerStateManager(), recovered.recover$default$2());
    }

    @Test
    public void testPreservedLastOffsetHandling() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        seg.append(0L, LogTestUtils$.MODULE$.records(0L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"text"})));
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        ByteBufferOutputStream out = new ByteBufferOutputStream(buffer);
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(out, 2, CompressionType.NONE, TimestampType.CREATE_TIME, 1L, 0L, 0L, 0, 0, false, false, 0, out.limit());
        builder.append(new SimpleRecord("foo".getBytes()));
        builder.overrideLastOffset(3L);
        builder.close();
        buffer.flip();
        seg.append(1L, new MemoryRecords(buffer));
        Assertions.assertEquals((long)3L, (long)seg.offsetIndex().lastOffset());
        Assertions.assertEquals((long)4L, (long)seg.readNextOffset());
    }

    private LogSegment createSegment(long baseOffset, boolean fileAlreadyExists, int initFileSize, boolean preallocate) {
        File tempDir = TestUtils.tempDirectory(null, null);
        LogConfig logConfig = new LogConfig(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index.interval.bytes"), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.index.bytes"), (Object)BoxesRunTime.boxToInteger((int)1000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.jitter.ms"), (Object)BoxesRunTime.boxToInteger((int)0))}))).asJava());
        LogSegment seg = LogSegment$.MODULE$.open(tempDir, baseOffset, logConfig, Time.SYSTEM, fileAlreadyExists, initFileSize, preallocate, "");
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public int createSegment$default$2() {
        return 10;
    }

    public Time createSegment$default$3() {
        return Time.SYSTEM;
    }

    public boolean createSegment$default$4() {
        return false;
    }

    @Test
    public void testCreateWithInitFileSizeAppendMessage() {
        LogSegment seg = this.createSegment(40L, false, 0x20000000, true);
        MemoryRecords ms = LogTestUtils$.MODULE$.records(50L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, ms);
        MemoryRecords ms2 = LogTestUtils$.MODULE$.records(60L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, ms2);
        FetchDataInfo read = seg.read(55L, 200, seg.read$default$3(), seg.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records.records().iterator());
    }

    @Test
    public void testCreateWithInitFileSizeClearShutdown() {
        File tempDir = TestUtils.tempDirectory(null, null);
        LogConfig logConfig = new LogConfig(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index.interval.bytes"), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.index.bytes"), (Object)BoxesRunTime.boxToInteger((int)1000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.jitter.ms"), (Object)BoxesRunTime.boxToInteger((int)0))}))).asJava());
        Time x$4 = Time.SYSTEM;
        boolean x$7 = false;
        String x$8 = "";
        LogSegment seg = LogSegment$.MODULE$.open(tempDir, 40L, logConfig, x$4, x$7, 0x20000000, true, x$8);
        MemoryRecords ms = LogTestUtils$.MODULE$.records(50L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, ms);
        MemoryRecords ms2 = LogTestUtils$.MODULE$.records(60L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, ms2);
        FetchDataInfo read = seg.read(55L, 200, seg.read$default$3(), seg.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records.records().iterator());
        int oldSize = seg.log().sizeInBytes();
        long oldPosition = seg.log().channel().position();
        long oldFileSize = seg.log().file().length();
        Assertions.assertEquals((long)0x20000000L, (long)oldFileSize);
        seg.close();
        Assertions.assertEquals((long)oldSize, (long)seg.log().file().length());
        LogSegment segReopen = LogSegment$.MODULE$.open(tempDir, 40L, logConfig, Time.SYSTEM, true, 0x20000000, true, "");
        this.segments().$plus$eq((Object)segReopen);
        FetchDataInfo readAgain = segReopen.read(55L, 200, segReopen.read$default$3(), segReopen.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), readAgain.records.records().iterator());
        int size = segReopen.log().sizeInBytes();
        long position = segReopen.log().channel().position();
        long fileSize = segReopen.log().file().length();
        Assertions.assertEquals((long)oldPosition, (long)position);
        Assertions.assertEquals((int)oldSize, (int)size);
        Assertions.assertEquals((long)size, (long)fileSize);
    }

    @Test
    public void shouldTruncateEvenIfOffsetPointsToAGapInTheLog() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        int offset = 40;
        MemoryRecords ms1 = LogSegmentTest.records$1(offset, "first message");
        seg.append((long)offset, ms1);
        MemoryRecords ms2 = LogSegmentTest.records$1(offset + 3, "message after gap");
        seg.append((long)(offset + 3), ms2);
        seg.truncateTo((long)(offset + 1));
        FetchDataInfo log = seg.read((long)offset, 10000, seg.read$default$3(), seg.read$default$4());
        Assertions.assertEquals((long)offset, (long)((RecordBatch)log.records.batches().iterator().next()).baseOffset());
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(log.records.batches()).asScala().size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAppendFromFile() {
        void logFile_suffix;
        File tempDir = TestUtils.tempDirectory(null, null);
        String string = "";
        long logFile_offset = 0L;
        string = null;
        File open_file = LogFileUtils.logFile((File)tempDir, (long)logFile_offset, (String)logFile_suffix);
        boolean open_mutable = true;
        Object var12_4 = null;
        FileRecords fileRecords = FileRecords.open((File)open_file, (boolean)open_mutable, (boolean)false, (int)0, (boolean)false);
        fileRecords.append(LogSegmentTest.records$2(0L, 1024));
        fileRecords.append(LogSegmentTest.records$2(500L, 0x100001));
        int sizeBeforeOverflow = fileRecords.sizeInBytes();
        fileRecords.append(LogSegmentTest.records$2(0x80000004L, 1024));
        int sizeAfterOverflow = fileRecords.sizeInBytes();
        LogSegment segment = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        int bytesAppended = segment.appendFromFile(fileRecords, 0);
        Assertions.assertEquals((int)sizeBeforeOverflow, (int)bytesAppended);
        Assertions.assertEquals((int)sizeBeforeOverflow, (int)segment.size());
        LogSegment overflowSegment = this.createSegment(Integer.MAX_VALUE, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        int overflowBytesAppended = overflowSegment.appendFromFile(fileRecords, sizeBeforeOverflow);
        Assertions.assertEquals((int)(sizeAfterOverflow - sizeBeforeOverflow), (int)overflowBytesAppended);
        Assertions.assertEquals((int)overflowBytesAppended, (int)overflowSegment.size());
        Utils.delete((File)tempDir, (boolean)false);
    }

    @Test
    public void testLastSegmentOffsetCache() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        seg.append(2L, LogTestUtils$.MODULE$.records(0L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "you"})));
        Field field = LogSegment.class.getDeclaredField("lastSegmentOffset");
        field.setAccessible(true);
        Assertions.assertEquals((long)3L, (long)seg.readNextOffset());
        Assertions.assertEquals((long)2L, (long)LogSegmentTest.reflectLastSegmentOffset$1(field, seg));
        seg.truncateTo(3L);
        Assertions.assertEquals((long)-1L, (long)LogSegmentTest.reflectLastSegmentOffset$1(field, seg));
        Assertions.assertEquals((long)3L, (long)seg.readNextOffset());
        Assertions.assertEquals((long)2L, (long)LogSegmentTest.reflectLastSegmentOffset$1(field, seg));
        seg.append(5L, LogTestUtils$.MODULE$.records(3L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "you"})));
        Assertions.assertEquals((long)6L, (long)seg.readNextOffset());
        Assertions.assertEquals((long)5L, (long)LogSegmentTest.reflectLastSegmentOffset$1(field, seg));
    }

    @Test
    public void testFailIfUnexpectedNonEmptyFileAlreadyExists() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4());
        seg.append(0L, LogTestUtils$.MODULE$.records(0L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})));
        seg.close();
        this.segments().remove(0);
        Assertions.assertThrows(IllegalStateException.class, () -> this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3(), this.createSegment$default$4()));
        int x$3 = this.createSegment$default$2();
        Time x$4 = this.createSegment$default$3();
        this.createSegment(0L, x$3, x$4, true);
    }

    @Test
    public void testLastFlushedTimeMs() {
        MockTime time = new MockTime(0L, 1000L, 1000000000L);
        int x$3 = this.createSegment$default$2();
        boolean x$4 = this.createSegment$default$4();
        LogSegment seg = this.createSegment(40L, x$3, (Time)time, x$4);
        MemoryRecords records = LogTestUtils$.MODULE$.records(40L, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(41L, records);
        seg.lastModified_$eq(time.milliseconds());
        Assertions.assertTrue((boolean)seg.lastFlushedTimeMs().isEmpty());
        time.sleep(2000L);
        seg.flush();
        Assertions.assertEquals((long)time.milliseconds(), (long)BoxesRunTime.unboxToLong((Object)seg.lastFlushedTimeMs().get()), (String)"flush time of segment was not correctly set");
    }

    private ProducerStateManager newProducerStateManager() {
        return new ProducerStateManager(this.topicPartition(), this.logDir(), 300000, new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs()), (Time)new MockTime(), Optional.empty());
    }

    /*
     * WARNING - void declaration
     */
    private static final MemoryRecords records$1(long offset, String record) {
        void withRecords_records;
        void withRecords_timestampType;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(offset * 1000L, record.getBytes())};
        TimestampType timestampType = TimestampType.CREATE_TIME;
        CompressionType withRecords_compressionType = CompressionType.NONE;
        return MemoryRecords.withRecords((byte)2, (long)offset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
    }

    /*
     * WARNING - void declaration
     */
    private static final MemoryRecords records$2(long offset, int size) {
        void withRecords_records;
        void withRecords_timestampType;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(new byte[size])};
        TimestampType timestampType = TimestampType.CREATE_TIME;
        CompressionType withRecords_compressionType = CompressionType.NONE;
        return MemoryRecords.withRecords((byte)2, (long)offset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
    }

    private static final long reflectLastSegmentOffset$1(Field field$1, LogSegment seg$7) {
        return ((AtomicLong)field$1.get(seg$7)).get();
    }
}

