/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.ThrottledReplicaListValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005ub\u0001B\u000e\u001d\u0001\u0005BQ\u0001\u000b\u0001\u0005\u0002%BQ\u0001\f\u0001\u0005\u00025BQA\u0010\u0001\u0005\u00025BQ\u0001\u0011\u0001\u0005\u00025BQA\u0011\u0001\u0005\u00025BQ\u0001\u0012\u0001\u0005\u00025BQA\u0012\u0001\u0005\u00025BQ\u0001\u0013\u0001\u0005\u00025BQA\u0013\u0001\u0005\u00025BQ\u0001\u0014\u0001\u0005\u00025BQA\u0014\u0001\u0005\u00025BQ\u0001\u0015\u0001\u0005\u00025BQA\u0015\u0001\u0005\u00025BQ\u0001\u0016\u0001\u0005\u00025BQA\u0016\u0001\u0005\u00025BQ\u0001\u0017\u0001\u0005\u00025BQA\u0017\u0001\u0005\u00025BQ\u0001\u0018\u0001\u0005\nuCQA\u001c\u0001\u0005\n=DQa\u001e\u0001\u0005\u00025BQ!\u001f\u0001\u0005\u00025BQa\u001f\u0001\u0005\u00025BQ! \u0001\u0005\u00025BQa \u0001\u0005\u00025Ba!a\u0001\u0001\t\u0003i\u0003bBA\u0004\u0001\u0011%\u0011\u0011\u0002\u0002\u000e\u0019><7i\u001c8gS\u001e$Vm\u001d;\u000b\u0005uq\u0012a\u00017pO*\tq$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0011\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002UA\u00111\u0006A\u0007\u00029\u0005YSM\\:ve\u0016tun\u0015;bi&\u001c\u0017J\\5uS\u0006d\u0017N_1uS>twJ\u001d3fe\u0012+\u0007/\u001a8eK:\u001c\u0017\u0010F\u0001/!\t\u0019s&\u0003\u00021I\t!QK\\5uQ\t\u0011!\u0007\u0005\u00024y5\tAG\u0003\u00026m\u0005\u0019\u0011\r]5\u000b\u0005]B\u0014a\u00026va&$XM\u001d\u0006\u0003si\nQA[;oSRT\u0011aO\u0001\u0004_J<\u0017BA\u001f5\u0005\u0011!Vm\u001d;\u0002-Q,7\u000f^&bM.\f7i\u001c8gS\u001e$v\u000e\u0015:paND#a\u0001\u001a\u0002eQ,7\u000f^#oC\ndWmU2iK6\fg+\u00197jI\u0006$\u0018n\u001c8XSRDw.\u001e;TG\",W.\u0019*fO&\u001cHO]=Ve2D#\u0001\u0002\u001a\u0002_Q,7\u000f^#oC\ndWmU2iK6\fg+\u00197jI\u0006$\u0018n\u001c8XSRD7k\u00195f[\u0006\u0014VmZ5tiJLXK\u001d7)\u0005\u0015\u0011\u0014!\r;fgR,e.\u00192mKN\u001b\u0007.Z7b-\u0006d\u0017\u000eZ1uS>tw+\u001b;i_V$\u0018J\u001c;fe\u000e,\u0007\u000f^8s\u00072\f7o\u001d\u0015\u0003\rI\nA\u0007^3ti\u0016s\u0017M\u00197f'\u000eDW-\\1WC2LG-\u0019;j_:<\u0016\u000e\u001e5DkN$x.\\%oi\u0016\u00148-\u001a9u_J\u001cE.Y:tQ\t9!'\u0001\nuKN$hI]8n!J|\u0007o]#naRL\bF\u0001\u00053\u0003Q!Xm\u001d;Ge>l\u0007K]8qg&sg/\u00197jI\"\u0012\u0011BM\u0001\u001fi\u0016\u001cH/\u00138wC2LGmQ8na\u0006\u001cG/[8o\u0019\u0006<7i\u001c8gS\u001eD#A\u0003\u001a\u0002KMDw.\u001e7e-\u0006d\u0017\u000eZ1uKRC'o\u001c;uY\u0016$'+\u001a9mS\u000e\f7oQ8oM&<\u0007FA\u00063\u0003=!Xm\u001d;U_\"#X\u000e\u001c+bE2,\u0007F\u0001\u00073\u0003)!Xm\u001d;U_\"#X\u000e\u001c\u0015\u0003\u001bI\n\u0011\u0003^3tiR{WI\u001c:jG\",GMU:uQ\tq!'A\u0005uKN$Hk\u001c*ti\"\u0012qBM\u0001\u0013i\u0016\u001cHoR3u\u0007>tg-[4WC2,X\r\u000b\u0002\u0011e\u0005)C/Z:u\u001fZ,'O]5eI\u0016t7i\u001c8gS\u001e\u001c\u0018i\u001d'pO\u001e\f'\r\\3TiJLgn\u001a\u0015\u0003#I\nq![:WC2LG\r\u0006\u0002_CB\u00111eX\u0005\u0003A\u0012\u0012qAQ8pY\u0016\fg\u000eC\u0003c%\u0001\u00071-A\u0006d_:4\u0017n\u001a,bYV,\u0007C\u00013l\u001d\t)\u0017\u000e\u0005\u0002gI5\tqM\u0003\u0002iA\u00051AH]8pizJ!A\u001b\u0013\u0002\rA\u0013X\rZ3g\u0013\taWN\u0001\u0004TiJLgn\u001a\u0006\u0003U\u0012\nQ#Y:tKJ$\bK]8qKJ$\u00180\u00138wC2LG\rF\u0002/aJDQ!]\nA\u0002\r\fAA\\1nK\")1o\u0005a\u0001i\u00061a/\u00197vKN\u00042aI;#\u0013\t1HE\u0001\u0006=e\u0016\u0004X-\u0019;fIz\n\u0011\u0005^3ti2{7-\u00197M_\u001e\u0014V\r^3oi&|g\u000eR3sSZ,G\r\u0015:paND#\u0001\u0006\u001a\u0002QQ,7\u000f\u001e'pG\u0006dGj\\4SKR,g\u000e^5p]\u0012+'/\u001b<fI\u0012+g-Y;miB\u0013x\u000e]:)\u0005U\u0011\u0014A\u0007;fgRdunY1m\u0019><'+\u001a;f]RLwN\u001c)s_B\u001c\bF\u0001\f3\u0003\u0005\"Xm\u001d;J]Z\fG.\u001b3M_\u000e\fG\u000eT8h%\u0016$XM\u001c;j_:\u0004&o\u001c9tQ\t9\"'\u0001\u000euKN$\bK]3gKJ$\u0016.\u001a:GKR\u001c\u0007.T:Qe>\u00048\u000f\u000b\u0002\u0019e\u0005\u0001B/Z:u\u001b\u0006D8+Z4nK:$Xj\u001d\u0015\u00033I\n1\u0005Z8UKN$\u0018J\u001c<bY&$Gj\\2bY2{wMU3uK:$\u0018n\u001c8Qe>\u00048\u000f\u0006\u0006\u0002\f\u0005\u0005\u00121FA\u001b\u0003s\u0001B!!\u0004\u0002\u001e5\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"\u0001\u0004d_:4\u0017n\u001a\u0006\u0005\u0003+\t9\"\u0001\u0004d_6lwN\u001c\u0006\u0004?\u0005e!bAA\u000eu\u00051\u0011\r]1dQ\u0016LA!a\b\u0002\u0010\ty1i\u001c8gS\u001e,\u0005pY3qi&|g\u000eC\u0004\u0002$i\u0001\r!!\n\u0002!1|7-\u00197SKR,g\u000e^5p]6\u001b\bcA\u0012\u0002(%\u0019\u0011\u0011\u0006\u0013\u0003\t1{gn\u001a\u0005\b\u0003[Q\u0002\u0019AA\u0018\u0003MawnY1m%\u0016$XM\u001c;j_:\u0014\u0015\u0010^3t!\r\u0019\u0013\u0011G\u0005\u0004\u0003g!#aA%oi\"9\u0011q\u0007\u000eA\u0002\u0005=\u0012A\u0004:fi\u0016tG/[8o\u0005f$Xm\u001d\u0005\b\u0003wQ\u0002\u0019AA\u0013\u0003-\u0011X\r^3oi&|g.T:")
public class LogConfigTest {
    @Test
    public void ensureNoStaticInitializationOrderDependency() {
        Assertions.assertNotNull((Object)KafkaConfig$.MODULE$.LogRetentionTimeMillisProp());
        Assertions.assertTrue((boolean)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(LogConfig.configNames()).asScala().filter((Function1 & Serializable)config -> BoxesRunTime.boxToBoolean((boolean)LogConfigTest.$anonfun$ensureNoStaticInitializationOrderDependency$1(config)))).forall((Function1 & Serializable)config -> BoxesRunTime.boxToBoolean((boolean)LogConfigTest.$anonfun$ensureNoStaticInitializationOrderDependency$2(config))));
    }

    @Test
    public void testKafkaConfigToProps() {
        long millisInHour = 3600000L;
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeJitterHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRetentionTimeHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), "0.11.0");
        Map logProps = KafkaConfig$.MODULE$.fromProps(kafkaProps).extractLogConfigMap();
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get("segment.ms"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get("segment.jitter.ms"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get("retention.ms"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_0_IV1.version(), logProps.get("message.format.version"));
    }

    @Test
    public void testEnableSchemaValidationWithoutSchemaRegistryUrl() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        Map logProps = KafkaConfig$.MODULE$.fromProps(kafkaProps).extractLogConfigMap();
        new .colon.colon((Object)"confluent.value.schema.validation", (List)new .colon.colon((Object)"confluent.key.schema.validation", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)cfg -> {
            logProps.put(cfg, "true");
            return (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> new LogConfig(logProps).instantiateInterceptors(Optional.empty(), Optional.empty()));
        });
    }

    @Test
    public void testEnableSchemaValidationWithSchemaRegistryUrl() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        kafkaProps.put("confluent.schema.registry.url", "bogus");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Map logProps = kafkaConfig.extractLogConfigMap();
        KafkaServer$.MODULE$.augmentWithKafkaConfig(logProps, kafkaConfig);
        new .colon.colon((Object)"confluent.value.schema.validation", (List)new .colon.colon((Object)"confluent.key.schema.validation", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)cfg -> {
            LogConfigTest.$anonfun$testEnableSchemaValidationWithSchemaRegistryUrl$1(logProps, cfg);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testEnableSchemaValidationWithoutInterceptorClass() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        kafkaProps.put("confluent.schema.registry.url", "bogus");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Map logProps = kafkaConfig.extractLogConfigMap();
        KafkaServer$.MODULE$.augmentWithKafkaConfig(logProps, kafkaConfig);
        logProps.remove("confluent.schema.validator.interceptor.class");
        new .colon.colon((Object)"confluent.value.schema.validation", (List)new .colon.colon((Object)"confluent.key.schema.validation", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)cfg -> {
            LogConfigTest.$anonfun$testEnableSchemaValidationWithoutInterceptorClass$1(logProps, cfg);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testEnableSchemaValidationWithCustomInterceptorClass() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        kafkaProps.put("confluent.schema.validator.interceptor.class", "non.existing.interceptor");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Map logProps = kafkaConfig.extractLogConfigMap();
        KafkaServer$.MODULE$.augmentWithKafkaConfig(logProps, kafkaConfig);
        new .colon.colon((Object)"confluent.value.schema.validation", (List)new .colon.colon((Object)"confluent.key.schema.validation", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)cfg -> {
            LogConfigTest.$anonfun$testEnableSchemaValidationWithCustomInterceptorClass$1(logProps, cfg);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testFromPropsEmpty() {
        Properties p = new Properties();
        LogConfig config = new LogConfig((Map)p);
        Assertions.assertEquals((Object)new LogConfig((Map)new Properties()), (Object)config);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)CollectionConverters$.MODULE$.MapHasAsScala(config.values()).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LogConfigTest.$anonfun$testFromPropsEmpty$1(x$1))));
        Assertions.assertEquals((Object)"io.confluent.kafka.serializers.subject.TopicNameStrategy", config.values().get("confluent.value.subject.name.strategy"));
        Assertions.assertEquals((Object)"io.confluent.kafka.serializers.subject.TopicNameStrategy", config.values().get("confluent.key.subject.name.strategy"));
    }

    @Test
    public void testFromPropsInvalid() {
        LogConfig.configNames().forEach(name -> {
            switch (name == null ? 0 : name.hashCode()) {
                case -2117707887: {
                    if (!"confluent.tier.local.hotset.bytes".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                    return;
                }
                case -2092945296: {
                    if (!"confluent.tier.cleaner.min.cleanable.ratio".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                    return;
                }
                case -1351059593: {
                    if (!"confluent.tier.cleaner.enable".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_boolean"}));
                    return;
                }
                case -1339220362: {
                    if (!"retention.ms".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
                    return;
                }
                case -1272818176: {
                    if (!"confluent.tier.segment.hotset.roll.min.bytes".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                    return;
                }
                case -1238246365: {
                    if (!"confluent.compacted.topic.prefer.tier.fetch.ms".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                    return;
                }
                case -772457061: {
                    if (!"retention.bytes".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
                    return;
                }
                case -555256924: {
                    if (!"confluent.tier.cleaner.compact.min.efficiency".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                    return;
                }
                case -554982824: {
                    if (!"confluent.prefer.tier.fetch.ms".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                    return;
                }
                case -537988164: {
                    if (!"cleanup.policy".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"true", "foobar"}));
                    return;
                }
                case -497316924: {
                    if (!"confluent.append.record.interceptor.classes".equals(name)) break;
                    return;
                }
                case -151975715: {
                    if (!"confluent.placement.constraints".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"json only", "null"}));
                    return;
                }
                case -119762923: {
                    if (!"confluent.key.subject.name.strategy".equals(name)) break;
                    return;
                }
                case -6022648: {
                    if (!"min.cleanable.dirty.ratio".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                    return;
                }
                case 67637273: {
                    if (!"local.retention.ms".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-3"}));
                    return;
                }
                case 268940301: {
                    if (!"min.insync.replicas".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "0", "-1"}));
                    return;
                }
                case 297509630: {
                    if (!"remote.storage.enable".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_boolean"}));
                    return;
                }
                case 632472856: {
                    if (!"local.retention.bytes".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-3"}));
                    return;
                }
                case 674282919: {
                    if (!"confluent.value.subject.name.strategy".equals(name)) break;
                    return;
                }
                case 1016887921: {
                    if (!"unclean.leader.election.enable".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not a boolean"}));
                    return;
                }
                case 1125464128: {
                    if (!"confluent.tier.local.hotset.ms".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                    return;
                }
                case 1698068565: {
                    if (!"confluent.tier.cleaner.compact.segment.min.bytes".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
                    return;
                }
                case 1709573955: {
                    if (!"confluent.tier.cleaner.dual.compaction".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_boolean"}));
                    return;
                }
                case 2114610856: {
                    if (!"message.format.version".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{""}));
                    return;
                }
            }
            this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-1"}));
        });
    }

    @Test
    public void testInvalidCompactionLagConfig() {
        Properties props = new Properties();
        props.setProperty("max.compaction.lag.ms", "100");
        props.setProperty("min.compaction.lag.ms", "200");
        Assertions.assertThrows(Exception.class, () -> LogConfig.validate((Properties)props));
    }

    @Test
    public void shouldValidateThrottledReplicasConfig() {
        Assertions.assertTrue((boolean)this.isValid("*"));
        Assertions.assertTrue((boolean)this.isValid("* "));
        Assertions.assertTrue((boolean)this.isValid(""));
        Assertions.assertTrue((boolean)this.isValid(" "));
        Assertions.assertTrue((boolean)this.isValid("100:10"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10,15:1"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10,15:1  "));
        Assertions.assertTrue((boolean)this.isValid("100:0,"));
        Assertions.assertFalse((boolean)this.isValid("100"));
        Assertions.assertFalse((boolean)this.isValid("100:"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10:"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100 :0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100: 0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100:0,10 :   "));
        Assertions.assertFalse((boolean)this.isValid("*,100:10"));
        Assertions.assertFalse((boolean)this.isValid("* ,100:10"));
    }

    @Test
    public void testToHtmlTable() {
        String html = LogConfig.configDefCopy().toHtmlTable();
        String expectedConfig = "<td>file.delete.delay.ms</td>";
        Assertions.assertTrue((boolean)html.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(html).toString());
    }

    @Test
    public void testToHtml() {
        String html = LogConfig.configDefCopy().toHtml(4, key -> new StringBuilder(7).append("prefix_").append((String)key).toString(), Collections.emptyMap());
        String expectedConfig = "<h4><a id=\"file.delete.delay.ms\"></a><a id=\"prefix_file.delete.delay.ms\" href=\"#prefix_file.delete.delay.ms\">file.delete.delay.ms</a></h4>";
        Assertions.assertTrue((boolean)html.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(html).toString());
    }

    @Test
    public void testToEnrichedRst() {
        String rst = LogConfig.configDefCopy().toEnrichedRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assertions.assertTrue((boolean)rst.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(rst).toString());
    }

    @Test
    public void testToRst() {
        String rst = LogConfig.configDefCopy().toRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assertions.assertTrue((boolean)rst.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(rst).toString());
    }

    @Test
    public void testGetConfigValue() {
        LogConfig.LogConfigDef configDef = LogConfig.configDefCopy();
        String configNameWithNoServerMapping = "log.foo";
        configDef.define(configNameWithNoServerMapping, ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)1), ConfigDef.Importance.MEDIUM, new StringBuilder(4).append(configNameWithNoServerMapping).append(" doc").toString());
        ConfigDef.ConfigKey deleteDelayKey = (ConfigDef.ConfigKey)configDef.configKeys().get("file.delete.delay.ms");
        String deleteDelayServerDefault = configDef.getConfigValue(deleteDelayKey, "Server Default Property");
        Assertions.assertEquals((Object)KafkaConfig$.MODULE$.LogDeleteDelayMsProp(), (Object)deleteDelayServerDefault);
        ConfigDef.ConfigKey keyWithNoServerMapping = (ConfigDef.ConfigKey)configDef.configKeys().get(configNameWithNoServerMapping);
        Assertions.assertNull((Object)configDef.getConfigValue(keyWithNoServerMapping, "Server Default Property"));
    }

    @Test
    public void testOverriddenConfigsAsLoggableString() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        kafkaProps.put("unknown.broker.password.config", "aaaaa");
        kafkaProps.put(KafkaConfig$.MODULE$.SslKeyPasswordProp(), "somekeypassword");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "50");
        kafkaProps.put("confluent.ssl.keystore.password", "akeypassword");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties topicOverrides = new Properties();
        topicOverrides.setProperty("min.insync.replicas", "2");
        topicOverrides.setProperty("retention.bytes", "100");
        topicOverrides.setProperty(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "sometrustpasswrd");
        topicOverrides.setProperty("unknown.topic.password.config", "bbbb");
        topicOverrides.setProperty("confluent.ssl.truststore.password", "sometrustpasswrd");
        LogConfig logConfig = LogConfig.fromProps((Map)kafkaConfig.extractLogConfigMap(), (Properties)topicOverrides);
        Assertions.assertEquals((Object)"{confluent.ssl.truststore.password=(redacted), min.insync.replicas=2, retention.bytes=100, ssl.truststore.password=(redacted), unknown.topic.password.config=(redacted)}", (Object)logConfig.overriddenConfigsAsLoggableString());
    }

    private boolean isValid(String configValue) {
        try {
            ThrottledReplicaListValidator.ensureValidString((String)"", (String)configValue);
            return true;
        }
        catch (ConfigException configException) {
            return false;
        }
    }

    private void assertPropertyInvalid(String name, Seq<Object> values) {
        values.foreach((Function1 & Serializable)value -> {
            Properties props = new Properties();
            props.setProperty(name, value.toString());
            return (Exception)Assertions.assertThrows(Exception.class, () -> new LogConfig((Map)props));
        });
    }

    @Test
    public void testLocalLogRetentionDerivedProps() {
        Properties props = new Properties();
        int retentionBytes = 1024;
        long retentionMs = 1000L;
        props.put("retention.bytes", Integer.toString(retentionBytes));
        props.put("retention.ms", Long.toString(retentionMs));
        LogConfig logConfig = new LogConfig((Map)props);
        Assertions.assertEquals((long)retentionMs, (long)logConfig.remoteLogConfig.localRetentionMs);
        Assertions.assertEquals((long)retentionBytes, (long)logConfig.remoteLogConfig.localRetentionBytes);
    }

    @Test
    public void testLocalLogRetentionDerivedDefaultProps() {
        LogConfig logConfig = new LogConfig((Map)new Properties());
        Assertions.assertEquals((long)604800000L, (long)logConfig.remoteLogConfig.localRetentionMs);
        Assertions.assertEquals((long)-1L, (long)logConfig.remoteLogConfig.localRetentionBytes);
    }

    @Test
    public void testLocalLogRetentionProps() {
        Properties props = new Properties();
        int localRetentionMs = 500;
        int localRetentionBytes = 1000;
        props.put("retention.bytes", Integer.toString(2000));
        props.put("retention.ms", Integer.toString(1000));
        props.put("local.retention.ms", Integer.toString(localRetentionMs));
        props.put("local.retention.bytes", Integer.toString(localRetentionBytes));
        LogConfig logConfig = new LogConfig((Map)props);
        Assertions.assertEquals((long)localRetentionMs, (long)logConfig.remoteLogConfig.localRetentionMs);
        Assertions.assertEquals((long)localRetentionBytes, (long)logConfig.remoteLogConfig.localRetentionBytes);
    }

    @Test
    public void testInvalidLocalLogRetentionProps() {
        this.doTestInvalidLocalLogRetentionProps(-3L, 10, 2, 500L);
        this.doTestInvalidLocalLogRetentionProps(500L, -3, 2, 1000L);
        this.doTestInvalidLocalLogRetentionProps(2000L, 2, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(500L, 200, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(-1L, 200, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(2000L, -1, 100, 1000L);
    }

    @Test
    public void testPreferTierFetchMsProps() {
        Properties props = new Properties();
        props.put("confluent.prefer.tier.fetch.ms", "100");
        props.put("confluent.compacted.topic.prefer.tier.fetch.ms", "200");
        LogConfig logConfig = new LogConfig((Map)props);
        Assertions.assertEquals((long)100L, (long)logConfig.confluentLogConfig().preferTierFetchMs);
        props.put("cleanup.policy", "compact");
        LogConfig logConfig2 = new LogConfig((Map)props);
        Assertions.assertEquals((long)200L, (long)logConfig2.confluentLogConfig().preferTierFetchMs);
    }

    @Test
    public void testMaxSegmentMs() {
        Properties props1 = new Properties();
        props1.put("segment.ms", "100");
        LogConfig logConfig1 = new LogConfig((Map)props1);
        Assertions.assertEquals((long)100L, (long)logConfig1.maxSegmentMs());
        Properties props2 = new Properties();
        props2.put("segment.ms", "100");
        props2.put("confluent.min.segment.ms", "200");
        LogConfig logConfig2 = new LogConfig((Map)props2);
        Assertions.assertEquals((long)200L, (long)logConfig2.maxSegmentMs());
        Properties props3 = new Properties();
        props3.put("segment.ms", "300");
        props3.put("confluent.min.segment.ms", "200");
        LogConfig logConfig3 = new LogConfig((Map)props3);
        Assertions.assertEquals((long)300L, (long)logConfig3.maxSegmentMs());
    }

    private ConfigException doTestInvalidLocalLogRetentionProps(long localRetentionMs, int localRetentionBytes, int retentionBytes, long retentionMs) {
        Properties props = new Properties();
        props.put("retention.bytes", Integer.toString(retentionBytes));
        props.put("retention.ms", Long.toString(retentionMs));
        props.put("local.retention.ms", Long.toString(localRetentionMs));
        props.put("local.retention.bytes", Integer.toString(localRetentionBytes));
        return (ConfigException)Assertions.assertThrows(ConfigException.class, () -> new LogConfig((Map)props));
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoStaticInitializationOrderDependency$1(String config) {
        return !LogConfig.CONFIGS_WITH_NO_SERVER_DEFAULTS.contains(config);
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoStaticInitializationOrderDependency$2(String config) {
        Optional serverConfigOpt = LogConfig.serverConfigName((String)config);
        return serverConfigOpt.isPresent() && serverConfigOpt.get() != null;
    }

    public static final /* synthetic */ void $anonfun$testEnableSchemaValidationWithSchemaRegistryUrl$1(Map logProps$2, String cfg) {
        logProps$2.put(cfg, "true");
        KafkaException e = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> new LogConfig(logProps$2).instantiateInterceptors(Optional.empty(), Optional.empty()));
        Assertions.assertEquals((Object)"Class io.confluent.kafka.schemaregistry.validator.RecordSchemaValidator cannot be found", (Object)e.getMessage());
    }

    public static final /* synthetic */ void $anonfun$testEnableSchemaValidationWithoutInterceptorClass$1(Map logProps$3, String cfg) {
        logProps$3.put(cfg, "true");
        KafkaException e = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> new LogConfig(logProps$3).instantiateInterceptors(Optional.empty(), Optional.empty()));
        Assertions.assertEquals((Object)"Class io.confluent.kafka.schemaregistry.validator.RecordSchemaValidator cannot be found", (Object)e.getMessage());
    }

    public static final /* synthetic */ void $anonfun$testEnableSchemaValidationWithCustomInterceptorClass$1(Map logProps$4, String cfg) {
        logProps$4.put(cfg, "true");
        KafkaException e = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> new LogConfig(logProps$4).instantiateInterceptors(Optional.empty(), Optional.empty()));
        Assertions.assertEquals((Object)"Class non.existing.interceptor cannot be found", (Object)e.getMessage());
    }

    public static final /* synthetic */ boolean $anonfun$testFromPropsEmpty$1(Tuple2 x$1) {
        return x$1._2() == null;
    }
}

