/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbstractLog;
import kafka.log.LocalLog;
import kafka.log.LocalLog$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningException;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused;
import kafka.log.LogCleaningState;
import kafka.log.LogLoader;
import kafka.log.LogSegment;
import kafka.log.LogSegments;
import kafka.log.LogToClean;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.OffsetsToClean;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.topic.TierTopicConsumer;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.LoadedLogOffsets;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r]e\u0001B,Y\u0001uCQA\u001b\u0001\u0005\u0002-DqA\u001c\u0001C\u0002\u0013\u0005q\u000e\u0003\u0004y\u0001\u0001\u0006I\u0001\u001d\u0005\bs\u0002\u0011\r\u0011\"\u0001p\u0011\u0019Q\b\u0001)A\u0005a\"91\u0010\u0001b\u0001\n\u0003y\u0007B\u0002?\u0001A\u0003%\u0001\u000fC\u0004~\u0001\t\u0007I\u0011A8\t\ry\u0004\u0001\u0015!\u0003q\u0011!y\bA1A\u0005\u0002\u0005\u0005\u0001\u0002CA\r\u0001\u0001\u0006I!a\u0001\t\u0013\u0005m\u0001A1A\u0005\u0002\u0005\u0005\u0001\u0002CA\u000f\u0001\u0001\u0006I!a\u0001\t\u0013\u0005}\u0001A1A\u0005\u0002\u0005\u0005\u0002\u0002CA\u0018\u0001\u0001\u0006I!a\t\t\u0013\u0005E\u0002A1A\u0005\u0002\u0005M\u0002\u0002CA$\u0001\u0001\u0006I!!\u000e\t\u0013\u0005%\u0003A1A\u0005\u0002\u0005-\u0003\u0002CA*\u0001\u0001\u0006I!!\u0014\t\u0013\u0005U\u0003A1A\u0005\u0002\u0005]\u0003\u0002CA0\u0001\u0001\u0006I!!\u0017\t\u0013\u0005\u0005\u0004A1A\u0005\u0002\u0005\r\u0004\u0002CA6\u0001\u0001\u0006I!!\u001a\t\u0013\u00055\u0004A1A\u0005\u0002\u0005=\u0004\u0002CAD\u0001\u0001\u0006I!!\u001d\u0007\r\u0005%\u0005\u0001AAF\u00111\t\u0019J\u0007B\u0001B\u0003%\u0011QSAW\u00111\tyK\u0007B\u0001B\u0003%\u0011\u0011WA_\u00111\tyL\u0007B\u0001B\u0003%\u0011\u0011YAd\u0011\u0019Q'\u0004\"\u0001\u0002J\"9\u0011Q\u001b\u000e\u0005B\u0005]\u0007bBAt5\u0011\u0005\u0013\u0011\u001e\u0005\n\u0005\u0017Q\u0012\u0013!C\u0001\u0005\u001bA\u0011Ba\t\u001b#\u0003%\tA!\n\t\u000f\t%\u0002\u0001\"\u0001\u0003,!9!1\t\u0001\u0005\n\t\u0015\u0003b\u0002B+\u0001\u0011\u0005!1\u0006\u0005\b\u0005?\u0002A\u0011\u0001B\u0016\u0011\u001d\u0011\u0019\u0007\u0001C\u0001\u0005WAqAa\u001a\u0001\t\u0003\u0011Y\u0003C\u0004\u0003l\u0001!\tAa\u000b\t\u000f\t=\u0004\u0001\"\u0001\u0003,!9!1\u000f\u0001\u0005\u0002\t-\u0002b\u0002B<\u0001\u0011\u0005!1\u0006\u0005\b\u0005w\u0002A\u0011\u0001B\u0016\u0011\u001d\u0011y\b\u0001C\u0001\u0005WAqAa!\u0001\t\u0003\u0011Y\u0003C\u0004\u0003\b\u0002!\tAa\u000b\t\u000f\t-\u0005\u0001\"\u0001\u0003,!9!q\u0012\u0001\u0005\u0002\t-\u0002b\u0002BJ\u0001\u0011\u0005!1\u0006\u0005\b\u0005/\u0003A\u0011\u0001B\u0016\u0011\u001d\u0011Y\n\u0001C\u0001\u0005WAqAa(\u0001\t\u0003\u0011Y\u0003C\u0004\u0003$\u0002!\tAa\u000b\t\u000f\t\u001d\u0006\u0001\"\u0001\u0003,!9!1\u0016\u0001\u0005\u0002\t-\u0002b\u0002BX\u0001\u0011\u0005!1\u0006\u0005\b\u0005g\u0003A\u0011\u0001B\u0016\u0011\u001d\u00119\f\u0001C\u0001\u0005WAqAa/\u0001\t\u0003\u0011Y\u0003C\u0004\u0003@\u0002!\tAa\u000b\t\u000f\t\r\u0007\u0001\"\u0001\u0003,!9!q\u0019\u0001\u0005\u0002\t-\u0002b\u0002Bf\u0001\u0011\u0005!1\u0006\u0005\b\u0005\u001f\u0004A\u0011\u0001B\u0016\u0011\u001d\u0011\u0019\u000e\u0001C\u0001\u0005WAqAa6\u0001\t\u0003\u0011Y\u0003C\u0004\u0003\\\u0002!\tAa\u000b\t\u000f\t}\u0007\u0001\"\u0001\u0003,!9!1\u001d\u0001\u0005\u0002\t-\u0002b\u0002Bt\u0001\u0011\u0005!1\u0006\u0005\b\u0005W\u0004A\u0011\u0002Bw\u0011\u001d\u0011Y\u000f\u0001C\u0005\u0005cDqAa?\u0001\t\u0013\u0011i\u0010C\u0004\u0004\u0004\u0001!Ia!\u0002\t\u0013\re\u0001!%A\u0005\n\rm\u0001\"CB\u0010\u0001E\u0005I\u0011BB\u0011\u0011\u001d\u0019)\u0003\u0001C\u0005\u0007OA\u0011b!\u0010\u0001#\u0003%Iaa\u0010\t\u000f\r\r\u0003\u0001\"\u0003\u0004F!91Q\u000b\u0001\u0005\n\r]\u0003bBB0\u0001\u0011%1\u0011\r\u0005\n\u0007c\u0002\u0011\u0013!C\u0005\u0007CAqaa\u001d\u0001\t\u0013\u0019)\bC\u0004\u0004\u0010\u0002!Ia!%\u0003+1{wm\u00117fC:,'/T1oC\u001e,'\u000fV3ti*\u0011\u0011LW\u0001\u0004Y><'\"A.\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001A\u00183\u0011\u0005}\u0013W\"\u00011\u000b\u0003\u0005\fQa]2bY\u0006L!a\u00191\u0003\r\u0005s\u0017PU3g!\t)\u0007.D\u0001g\u0015\t9',A\u0003vi&d7/\u0003\u0002jM\n9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001m!\ti\u0007!D\u0001Y\u0003\u0019!X\u000e\u001d#jeV\t\u0001\u000f\u0005\u0002rm6\t!O\u0003\u0002ti\u0006\u0011\u0011n\u001c\u0006\u0002k\u0006!!.\u0019<b\u0013\t9(O\u0001\u0003GS2,\u0017a\u0002;na\u0012K'\u000fI\u0001\bi6\u0004H)\u001b:3\u0003!!X\u000e\u001d#jeJ\u0002\u0013A\u00027pO\u0012K'/A\u0004m_\u001e$\u0015N\u001d\u0011\u0002\u000f1|w\rR5se\u0005AAn\\4ESJ\u0014\u0004%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0005\u0005\r\u0001\u0003BA\u0003\u0003+i!!a\u0002\u000b\t\u0005%\u00111B\u0001\u0007G>lWn\u001c8\u000b\u0007m\u000biA\u0003\u0003\u0002\u0010\u0005E\u0011AB1qC\u000eDWM\u0003\u0002\u0002\u0014\u0005\u0019qN]4\n\t\u0005]\u0011q\u0001\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u001a\u0002!Q|\u0007/[2QCJ$\u0018\u000e^5p]J\u0002\u0013\u0001\u00037pOB\u0013x\u000e]:\u0016\u0005\u0005\r\u0002\u0003BA\u0013\u0003Wi!!a\n\u000b\u0007\u0005%B/\u0001\u0003vi&d\u0017\u0002BA\u0017\u0003O\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0003%awn\u001a)s_B\u001c\b%A\u0005m_\u001e\u001cuN\u001c4jOV\u0011\u0011Q\u0007\t\u0005\u0003o\t\u0019%\u0004\u0002\u0002:)\u0019\u0011,a\u000f\u000b\t\u0005u\u0012qH\u0001\nS:$XM\u001d8bYNTA!!\u0011\u0002\f\u000591\u000f^8sC\u001e,\u0017\u0002BA#\u0003s\u0011\u0011\u0002T8h\u0007>tg-[4\u0002\u00151|wmQ8oM&<\u0007%\u0001\u0003uS6,WCAA'!\r)\u0017qJ\u0005\u0004\u0003#2'\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\r=4gm]3u+\t\tI\u0006E\u0002`\u00037J1!!\u0018a\u0005\rIe\u000e^\u0001\b_\u001a47/\u001a;!\u0003i\u0001(o\u001c3vG\u0016\u00148\u000b^1uK6\u000bg.Y4fe\u000e{gNZ5h+\t\t)\u0007\u0005\u0003\u00028\u0005\u001d\u0014\u0002BA5\u0003s\u0011!\u0004\u0015:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u00148i\u001c8gS\u001e\f1\u0004\u001d:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u00148i\u001c8gS\u001e\u0004\u0013AE2mK\u0006tWM]\"iK\u000e\\\u0007o\\5oiN,\"!!\u001d\u0011\u0011\u0005M\u0014QPA\u0002\u0003\u0003k!!!\u001e\u000b\t\u0005]\u0014\u0011P\u0001\b[V$\u0018M\u00197f\u0015\r\tY\bY\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA@\u0003k\u00121!T1q!\ry\u00161Q\u0005\u0004\u0003\u000b\u0003'\u0001\u0002'p]\u001e\f1c\u00197fC:,'o\u00115fG.\u0004x.\u001b8ug\u0002\u0012Q\u0003T8h\u00072,\u0017M\\3s\u001b\u0006t\u0017mZ3s\u001b>\u001c7nE\u0002\u001b\u0003\u001b\u00032!\\AH\u0013\r\t\t\n\u0017\u0002\u0012\u0019><7\t\\3b]\u0016\u0014X*\u00198bO\u0016\u0014\u0018a\u00027pO\u0012K'o\u001d\t\u0006\u0003/\u000b9\u000b\u001d\b\u0005\u00033\u000b\u0019K\u0004\u0003\u0002\u001c\u0006\u0005VBAAO\u0015\r\ty\nX\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005L1!!*a\u0003\u001d\u0001\u0018mY6bO\u0016LA!!+\u0002,\n\u00191+Z9\u000b\u0007\u0005\u0015\u0006-\u0003\u0003\u0002\u0014\u0006=\u0015\u0001\u00027pON\u0004r!ZAZ\u0003\u0007\t9,C\u0002\u00026\u001a\u0014A\u0001U8pYB\u0019Q.!/\n\u0007\u0005m\u0006LA\u0006BEN$(/Y2u\u0019><\u0017\u0002BAX\u0003\u001f\u000bA\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0007\u0003BA\u001c\u0003\u0007LA!!2\u0002:\t!Bj\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2LA!a0\u0002\u0010RA\u00111ZAh\u0003#\f\u0019\u000eE\u0002\u0002Nji\u0011\u0001\u0001\u0005\b\u0003's\u0002\u0019AAK\u0011\u001d\tyK\ba\u0001\u0003cCq!a0\u001f\u0001\u0004\t\t-A\u000bbY2\u001cE.Z1oKJ\u001c\u0005.Z2la>Lg\u000e^:\u0016\u0005\u0005e\u0007\u0003CAn\u0003G\f\u0019!!!\u000f\t\u0005u\u0017q\u001c\t\u0004\u00037\u0003\u0017bAAqA\u00061\u0001K]3eK\u001aLA!a \u0002f*\u0019\u0011\u0011\u001d1\u0002#U\u0004H-\u0019;f\u0007\",7m\u001b9pS:$8\u000f\u0006\u0005\u0002l\u0006E\u0018Q\u001fB\u0003!\ry\u0016Q^\u0005\u0004\u0003_\u0004'\u0001B+oSRDa!a=!\u0001\u0004\u0001\u0018a\u00023bi\u0006$\u0015N\u001d\u0005\n\u0003o\u0004\u0003\u0013!a\u0001\u0003s\fa\u0003]1si&$\u0018n\u001c8U_V\u0003H-\u0019;f\u001fJ\fE\r\u001a\t\u0006?\u0006m\u0018q`\u0005\u0004\u0003{\u0004'AB(qi&|g\u000eE\u0004`\u0005\u0003\t\u0019!!!\n\u0007\t\r\u0001M\u0001\u0004UkBdWM\r\u0005\n\u0005\u000f\u0001\u0003\u0013!a\u0001\u0005\u0013\t\u0011\u0003]1si&$\u0018n\u001c8U_J+Wn\u001c<f!\u0015y\u00161`A\u0002\u0003m)\b\u000fZ1uK\u000eCWmY6q_&tGo\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\u0002\u0016\u0005\u0003s\u0014\tb\u000b\u0002\u0003\u0014A!!Q\u0003B\u0010\u001b\t\u00119B\u0003\u0003\u0003\u001a\tm\u0011!C;oG\",7m[3e\u0015\r\u0011i\u0002Y\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0011\u0005/\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m)\b\u000fZ1uK\u000eCWmY6q_&tGo\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!q\u0005\u0016\u0005\u0005\u0013\u0011\t\"\u0001\u0005uK\u0006\u0014Hi\\<o)\t\tY\u000fK\u0002$\u0005_\u0001BA!\r\u0003@5\u0011!1\u0007\u0006\u0005\u0005k\u00119$A\u0002ba&TAA!\u000f\u0003<\u00059!.\u001e9ji\u0016\u0014(\u0002\u0002B\u001f\u0003#\tQA[;oSRLAA!\u0011\u00034\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u001cg\u0016$X\u000f]%oGJ,\u0017m]5oO2Lh)\u001b7uQfdunZ:\u0015\u0011\u0005E&q\tB'\u0005#BqA!\u0013%\u0001\u0004\u0011Y%\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004b!a&\u0002(\u0006\r\u0001b\u0002B(I\u0001\u0007\u0011\u0011L\u0001\u0010gR\f'\u000f\u001e(v[\n\u000bGo\u00195fg\"9!1\u000b\u0013A\u0002\u0005e\u0013A\u00042bi\u000eD\u0017J\\2sK6,g\u000e^\u0001;i\u0016\u001cHo\u00115fG.\u001cE.Z1oS:<\u0017IY8si\u0016$7\t[3dWN4uN\u001d$s_j,g\u000eT8h'R\f'\u000f^(gMN,Go\u0015;bi\u0016D3!\nB-!\u0011\u0011\tDa\u0017\n\t\tu#1\u0007\u0002\u0005)\u0016\u001cH/A\u0019uKN$\u0018I^8jI6\u000b\u0007pQ8na\u0006\u001cG/[8o\t\u0016d\u0017-_\"bY\u000e,H.\u0019;j_:d\u0015mZ'bqZ\u000bG.^3)\u0007\u0019\u0012I&\u0001\u0012uKN$X*\u0019=D_6\u0004\u0018m\u0019;j_:d\u0015m\u001a$pe\u000e,7\u000fT8h\u00072,\u0017M\u001c\u0015\u0004O\te\u0013\u0001\f;fgR<%/\u00192GS2$\b.[3ti\u000e{W\u000e]1di\u0016$Gj\\4UQJ|wo]#yG\u0016\u0004H/[8oQ\rA#\u0011L\u0001;i\u0016\u001cHo\u0012:bE\u001aKG\u000e\u001e5jKN$8i\\7qC\u000e$X\r\u001a'pO^KG\u000f\u001b+jKJ\u001cu.\u001c9bGR4U-\u0019;ve\u0016,e.\u00192mK\u0012D3!\u000bB-\u0003a\"Xm\u001d;He\u0006\u0014g)\u001b7uQ&,7\u000f^\"p[B\f7\r^3e\u0019><'+\u001a;ve:\u001cHj\\4XSRDG)\u001b:uS\u0016\u001cHOU1uS>D3A\u000bB-\u0003e\"Xm\u001d;He\u0006\u0014g)\u001b7uQ&,7\u000f^\"p[B\f7\r^3e\u0019><\u0017j\u001a8pe\u0016\u001cXK\\2mK\u0006t\u0017M\u00197f!\u0006\u0014H/\u001b;j_:\u001c\bfA\u0016\u0003Z\u0005AD/Z:u\u000fJ\f'MR5mi\"LWm\u001d;D_6\u0004\u0018m\u0019;fI2{w-S4o_J,7/\u00138Qe><'/Z:t!\u0006\u0014H/\u001b;j_:\u001c\bf\u0001\u0017\u0003Z\u0005!F/Z:u\u000fJ\f'MR5mi\"LWm\u001d;D_6\u0004\u0018m\u0019;fI2{w-S4o_J,7OQ8uQ&s\u0007K]8he\u0016\u001c8\u000fU1si&$\u0018n\u001c8t\u0003:$WK\\2mK\u0006t\u0017M\u00197f!\u0006\u0014H/\u001b;j_:\u001c\bfA\u0017\u0003Z\u0005IC/Z:u\t&\u0014H/_(gMN,GOU3tKRLe\rT1sO\u0016\u0014H\u000b[1o\u000b:$wJ\u001a4tKRD3A\fB-\u00031\"Xm\u001d;ESJ$\u0018p\u00144gg\u0016$(+Z:fi&37+\\1mY\u0016\u0014H\u000b[1o'R\f'\u000f^(gMN,G\u000fK\u00020\u00053\n1\u0007^3ti2{wm\u0015;beR|eMZ:fi2\u000b'oZ3s)\"\fg.Q2uSZ,7+Z4nK:$()Y:f\u001f\u001a47/\u001a;)\u0007A\u0012I&\u0001\u0019uKN$H)\u001b:us>3gm]3u\u0019\u0006\u0014x-\u001a:UQ\u0006t\u0017i\u0019;jm\u0016\u001cVmZ7f]R\u0014\u0015m]3PM\u001a\u001cX\r\u001e\u0015\u0004c\te\u0013\u0001\u0012;fgRdunZ:XSRD7+Z4nK:$8\u000fV8EK2,G/Z*i_VdGMT8u\u0007>t7/\u001b3fe\u000ecW-\u00198vaB{G.[2z\t\u0016dW\r^3M_\u001e\u001c\bf\u0001\u001a\u0003Z\u0005AE/Z:u\u0019><7oV5uQN+w-\\3oiN$v\u000eR3mKR,7\u000b[8vY\u0012\u001cuN\\:jI\u0016\u00148\t\\3b]V\u0004\bk\u001c7jGf\u001cu.\u001c9bGR$U\r\\3uK2{wm\u001d\u0015\u0004g\te\u0013A\u0011;fgRdunZ:XSRD7+Z4nK:$8\u000fV8EK2,G/Z*i_VdGmQ8og&$WM]\"mK\u0006tW\u000f\u001d)pY&\u001c\u0017pQ8na\u0006\u001cG\u000fT8hg\"\u001aAG!\u0017\u0002WQ,7\u000f\u001e'pON,f\u000eZ3s\u00072,\u0017M\\;q\u0013:,G.[4jE2,gi\u001c:D_6\u0004\u0018m\u0019;j_:D3!\u000eB-\u0003=\"Xm\u001d;Va\u0012\fG/Z\"iK\u000e\\\u0007o\\5oiN\u001c\u0006n\\;mI\u0006#Gm\u00144gg\u0016$Hk\u001c)beRLG/[8oQ\r1$\u0011L\u0001/i\u0016\u001cH/\u00169eCR,7\t[3dWB|\u0017N\u001c;t'\"|W\u000f\u001c3SK6|g/\u001a)beRLG/[8o\t\u0006$\u0018\rK\u00028\u00053\nQ\u0006^3ti\"\u000bg\u000e\u001a7f\u0019><G)\u001b:GC&dWO]3TQ>,H\u000e\u001a*f[>4X\rR5s\u0003:$G)\u0019;bQ\rA$\u0011L\u0001.i\u0016\u001cH/T1zE\u0016$&/\u001e8dCR,7\t[3dWB|\u0017N\u001c;TQ>,H\u000e\u001a+sk:\u001c\u0017\r^3ECR\f\u0007fA\u001d\u0003Z\u0005aD/Z:u\u00032$XM]\"iK\u000e\\\u0007o\\5oi\u0012K'o\u00155pk2$'+Z7pm\u0016$\u0015\r^1J]N\u00138\rR5s\u0003:$\u0017\t\u001a3J]:+w\u000fR5sQ\rQ$\u0011L\u0001)i\u0016\u001cHoQ8oGV\u0014(/\u001a8u\u0019><7\t\\3b]V\u0004\u0018I\u001c3M_\u001e$&/\u001e8dCRLwN\u001c\u0015\u0004w\te\u0013\u0001\u000b;fgR\u001cuN\\2veJ,g\u000e\u001e'pO\u000ecW-\u00198va\u0006sG\rV8qS\u000e$U\r\\3uS>t\u0007f\u0001\u001f\u0003Z\u0005\u0011E/Z:u\u0019><7oV5uQN+w-\\3oiN$v\u000eR3mKR,7\u000b[8vY\u0012tu\u000e^\"p]NLG-\u001a:V]\u000edW-\u00198bE2,\u0007+\u0019:uSRLwN\\:)\u0007u\u0012I&\u0001\ruKN$8i\\7qC\u000e$X\r\u001a\"zi\u0016\u001cX*\u001a;sS\u000eD3A\u0010B-\u0003m!Xm\u001d;DY\u0016\fg.\u00192mK>3gm]3ug\u001a{'OT8oK\"\u001aqH!\u0017\u0002CQ,7\u000f^\"mK\u0006t\u0017M\u00197f\u001f\u001a47/\u001a;t\u0003\u000e$\u0018N^3TK\u001elWM\u001c;)\u0007\u0001\u0013I&A\u000euKN$8\t\\3b]\u0006\u0014G.Z(gMN,Go\u001d$peRKW.\u001a\u0015\u0004\u0003\ne\u0013\u0001\t;fgR\u001cE.Z1oC\ndWm\u00144gg\u0016$8OR8s'\"|'\u000f\u001e+j[\u0016D3A\u0011B-\u0003!\"Xm\u001d;DY\u0016\fg.\u00192mK>3gm]3ug:+W\rZ:DQ\u0016\u001c7\u000e]8j]R\u0014Vm]3uQ\r\u0019%\u0011L\u0001+i\u0016\u001cH/\u00168eK\u000eLG-\u001a3Ue\u0006t7/Y2uS>t\u0017\r\u001c#bi\u0006tu\u000e^\"mK\u0006t\u0017M\u00197fQ\r!%\u0011L\u0001\u0011i\u0016\u001cH\u000fR8oK\u000ecW-\u00198j]\u001eD3!\u0012B-\u0003A!Xm\u001d;E_:,G)\u001a7fi&tw\rK\u0002G\u00053\nq\u0006^3ti\u000eCWmY6q_&tG/\u00169eCR,GMR8s\u0013:4\u0018\r\\5e\u001f\u001a47/\u001a;O_\u000ecW-\u00198j]\u001eD3a\u0012B-\u0003A\"Xm\u001d;DQ\u0016\u001c7\u000e]8j]R,\u0006\u000fZ1uK\u00124uN]%om\u0006d\u0017\u000eZ(gMN,GOT8u'\u0016dWm\u0019;fI\"\u001a\u0001J!\u0017\u0002)\r\u0014X-\u0019;f\u00072,\u0017M\\3s\u001b\u0006t\u0017mZ3s)\u0011\tiIa<\t\reK\u0005\u0019AA\\)\u0011\tiIa=\t\u000f\u0005=&\n1\u0001\u0003vB1\u00111\u001cB|\u0003oKAA!?\u0002f\n\u00191+\u001a;\u00021\r\u0014X-\u0019;f\u00072,\u0017M\\3s\u001b\u0006t\u0017mZ3s\u001b>\u001c7\u000e\u0006\u0003\u0002L\n}\bbBB\u0001\u0017\u0002\u0007\u0011\u0011W\u0001\u0005a>|G.A\u0005de\u0016\fG/\u001a'pORQ\u0011qWB\u0004\u0007\u0017\u0019)ba\u0006\t\u000f\r%A\n1\u0001\u0002Z\u0005Y1/Z4nK:$8+\u001b>f\u0011\u001d\u0019i\u0001\u0014a\u0001\u0007\u001f\tQb\u00197fC:,\b\u000fU8mS\u000eL\b\u0003BAn\u0007#IAaa\u0005\u0002f\n11\u000b\u001e:j]\u001eD\u0001b '\u0011\u0002\u0003\u0007\u00111\u0001\u0005\bw2\u0003\n\u00111\u0001q\u0003M\u0019'/Z1uK2{w\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019iB\u000b\u0003\u0002\u0004\tE\u0011aE2sK\u0006$X\rT8hI\u0011,g-Y;mi\u0012\"TCAB\u0012U\r\u0001(\u0011C\u0001\u001cGJ,\u0017\r^3M_^\u0014V\r^3oi&|g\u000eT8h\u0007>tg-[4\u0015\u0015\u0005U2\u0011FB\u0016\u0007[\u00199\u0004C\u0004\u0004\n=\u0003\r!!\u0017\t\u000f\r5q\n1\u0001\u0004\u0010!91qF(A\u0002\rE\u0012A\u0003;jKJ,e.\u00192mKB\u0019qla\r\n\u0007\rU\u0002MA\u0004C_>dW-\u00198\t\u0013\rer\n%AA\u0002\rm\u0012AE7bq\u000e{W\u000e]1di&|g\u000eT1h\u001bN\u0004RaXA~\u0003\u0003\u000bQe\u0019:fCR,Gj\\<SKR,g\u000e^5p]2{wmQ8oM&<G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r\u0005#\u0006BB\u001e\u0005#\tAb\u001e:ji\u0016\u0014VmY8sIN$\"\"a;\u0004H\r%3QJB)\u0011\u0019I\u0016\u000b1\u0001\u00028\"911J)A\u0002\u0005e\u0013A\u00038v[\n\u000bGo\u00195fg\"91qJ)A\u0002\u0005e\u0013a\u0004:fG>\u0014Hm\u001d)fe\n\u000bGo\u00195\t\u000f\rM\u0013\u000b1\u0001\u0002Z\u0005\t\"-\u0019;dQ\u0016\u001c\b+\u001a:TK\u001elWM\u001c;\u0002\u001b\u0005\u0004\b/\u001a8e%\u0016\u001cwN\u001d3t)\u0019\tYo!\u0017\u0004\\!1\u0011L\u0015a\u0001\u0003oCqa!\u0018S\u0001\u0004\tI&\u0001\u0006ok6\u0014VmY8sIN\fq!\\1lK2{w\r\u0006\u0004\u0004d\r%4Q\u000e\t\u0004[\u000e\u0015\u0014bAB41\nIQ*\u001a:hK\u0012dun\u001a\u0005\t\u0007W\u001a\u0006\u0013!a\u0001a\u0006\u0019A-\u001b:\t\u000f\r=4\u000b1\u0001\u00026\u000511m\u001c8gS\u001e\f\u0011#\\1lK2{w\r\n3fM\u0006,H\u000e\u001e\u00132\u0003\u001d\u0011XmY8sIN$\u0002ba\u001e\u0004\u0004\u000e\u001d51\u0012\t\u0005\u0007s\u001ay(\u0004\u0002\u0004|)!1QPA\u0004\u0003\u0019\u0011XmY8sI&!1\u0011QB>\u00055iU-\\8ssJ+7m\u001c:eg\"91QQ+A\u0002\u0005e\u0013aA6fs\"91\u0011R+A\u0002\u0005e\u0013!\u0002<bYV,\u0007bBBG+\u0002\u0007\u0011\u0011Q\u0001\ni&lWm\u001d;b[B\fQB^3sS\u001aLX*\u001a;sS\u000e\u001cH\u0003BAv\u0007'Cqa!&W\u0001\u0004\ti)\u0001\bdY\u0016\fg.\u001a:NC:\fw-\u001a:")
public class LogCleanerManagerTest
implements Logging {
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File tmpDir2 = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final File logDir2 = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final TopicPartition topicPartition = new TopicPartition("log", 0);
    private final TopicPartition topicPartition2 = new TopicPartition("log2", 0);
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private final MockTime time;
    private final int offset;
    private final ProducerStateManagerConfig producerStateManagerConfig;
    private final scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File tmpDir2() {
        return this.tmpDir2;
    }

    public File logDir() {
        return this.logDir;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public TopicPartition topicPartition2() {
        return this.topicPartition2;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public int offset() {
        return this.offset;
    }

    public ProducerStateManagerConfig producerStateManagerConfig() {
        return this.producerStateManagerConfig;
    }

    public scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints() {
        return this.cleanerCheckpoints;
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.tmpDir(), (boolean)false);
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    private Pool<TopicPartition, AbstractLog> setupIncreasinglyFilthyLogs(scala.collection.immutable.Seq<TopicPartition> partitions, int startNumBatches, int batchIncrement) {
        Pool logs = new Pool((Option)None$.MODULE$);
        IntRef numBatches = IntRef.create((int)startNumBatches);
        partitions.foreach((Function1 & Serializable)tp -> {
            LogCleanerManagerTest.$anonfun$setupIncreasinglyFilthyLogs$1(this, logs, numBatches, batchIncrement, tp);
            return BoxedUnit.UNIT;
        });
        return logs;
    }

    @Test
    public void testCheckCleaningAbortedChecksForFrozenLogStartOffsetState() {
        TopicPartition tp = new TopicPartition("test-topic", 0);
        MergedLog mockLog = (MergedLog)Mockito.mock(MergedLog.class);
        Pool logsPool = new Pool((Option)None$.MODULE$);
        logsPool.put((Object)tp, (Object)mockLog);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, AbstractLog>)logsPool);
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mockLog.isFrozenLogStartOffsetState())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        cleanerManager.checkCleaningAborted(tp);
        Object object = cleanerManager.cleaningState(tp).get();
        LogCleaningInProgress$ logCleaningInProgress$ = LogCleaningInProgress$.MODULE$;
        Assertions.assertTrue((object != null && object.equals(logCleaningInProgress$) ? 1 : 0) != 0);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mockLog.isFrozenLogStartOffsetState())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Assertions.assertThrows(LogCleaningAbortedException.class, () -> cleanerManager.checkCleaningAborted(tp));
    }

    @Test
    public void testAvoidMaxCompactionDelayCalculationLagMaxValue() {
        TopicPartition tp = new TopicPartition("A", 1);
        int logSegmentSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2).sizeInBytes() * 10;
        int logSegmentsCount = 2;
        File tpDir = new File(this.logDir(), "A-1");
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Integer.toString(logSegmentSize));
        logProps.put("retention.ms", "1");
        logProps.put("cleanup.policy", "compact");
        logProps.put("max.compaction.lag.ms", Long.toString(Long.MAX_VALUE));
        LogConfig config = new LogConfig((Map)logProps);
        int maxTransactionTimeoutMs = 300000;
        int producerIdExpirationCheckIntervalMs = 600000;
        Files.createDirectories(tpDir.toPath(), new FileAttribute[0]);
        LogSegments segments = new LogSegments(tp);
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
        Option leaderEpochCache = MergedLog$.MODULE$.maybeCreateLeaderEpochCache(tpDir, tp, logDirFailureChannel, config.messageFormatVersion.highestSupportedRecordVersion(), "");
        ProducerStateManager producerStateManager = new ProducerStateManager(tp, tpDir, maxTransactionTimeoutMs, this.producerStateManagerConfig(), (Time)this.time(), Optional.empty());
        Metrics metrics = new Metrics();
        LoadedLogOffsets offsets = new LogLoader(tpDir, tp, config, (Scheduler)this.time().scheduler(), (Time)this.time(), logDirFailureChannel, true, segments, 0L, 0L, leaderEpochCache, producerStateManager, new ConcurrentHashMap()).load();
        LocalLog localLog = new LocalLog(tpDir, config, segments, offsets.recoveryPoint, offsets.nextOffsetMetadata, (Scheduler)this.time().scheduler(), (Time)this.time(), tp, logDirFailureChannel, brokerTopicStats, LogOffsetsListener.NO_OP_OFFSETS_LISTENER);
        TierPartitionState tierPartitionState = TierLogComponents$.MODULE$.EMPTY().partitionStateFactory().initState(this.logDir(), this.topicPartition(), localLog.config(), logDirFailureChannel, (Scheduler)this.time().scheduler(), (Time)this.time());
        MergedLog log = new MergedLog(null, localLog, metrics, leaderEpochCache, producerIdExpirationCheckIntervalMs, producerStateManager, tierPartitionState){

            public Iterable<Object> getFirstBatchTimestampForSegments(Iterable<LogSegment> logSegments) {
                throw new IllegalStateException("Error!");
            }
        };
        this.writeRecords((AbstractLog)log, logSegmentsCount * 2, 10, 2);
        Pool logsPool = new Pool((Option)None$.MODULE$);
        logsPool.put((Object)tp, (Object)log);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, AbstractLog>)logsPool);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)1L));
        Assertions.assertFalse((boolean)((LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get()).needCompactionNow());
        this.verifyMetrics(cleanerManager);
    }

    @Test
    public void testMaxCompactionLagForcesLogClean() {
        TopicPartition tp = new TopicPartition("A", 1);
        int logSegmentSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2).sizeInBytes() * 10;
        int logSegmentsCount = 2;
        File tpDir = new File(this.logDir(), "A-1");
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Integer.toString(logSegmentSize));
        logProps.put("cleanup.policy", "compact");
        logProps.put("max.compaction.lag.ms", "10");
        logProps.put("min.cleanable.dirty.ratio", "1.00");
        LogConfig config = new LogConfig((Map)logProps);
        int maxTransactionTimeoutMs = 300000;
        int producerIdExpirationCheckIntervalMs = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        Files.createDirectories(tpDir.toPath(), new FileAttribute[0]);
        LogSegments segments = new LogSegments(tp);
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
        Metrics metrics = new Metrics();
        Option leaderEpochCache = MergedLog$.MODULE$.maybeCreateLeaderEpochCache(tpDir, tp, logDirFailureChannel, config.messageFormatVersion.highestSupportedRecordVersion(), "");
        ProducerStateManager producerStateManager = new ProducerStateManager(tp, tpDir, maxTransactionTimeoutMs, this.producerStateManagerConfig(), (Time)this.time(), Optional.empty());
        LoadedLogOffsets offsets = new LogLoader(tpDir, tp, config, (Scheduler)this.time().scheduler(), (Time)this.time(), logDirFailureChannel, true, segments, 0L, 0L, leaderEpochCache, producerStateManager, new ConcurrentHashMap()).load();
        LocalLog localLog = new LocalLog(tpDir, config, segments, offsets.recoveryPoint, offsets.nextOffsetMetadata, (Scheduler)this.time().scheduler(), (Time)this.time(), tp, logDirFailureChannel, brokerTopicStats, LogOffsetsListener.NO_OP_OFFSETS_LISTENER);
        TierPartitionState tierPartitionState = TierLogComponents$.MODULE$.EMPTY().partitionStateFactory().initState(this.logDir(), this.topicPartition(), localLog.config(), logDirFailureChannel, (Scheduler)this.time().scheduler(), (Time)this.time());
        MergedLog log = new MergedLog(localLog, 0L, true, metrics, leaderEpochCache, producerIdExpirationCheckIntervalMs, producerStateManager, (Option)None$.MODULE$, true, tierPartitionState, TierLogComponents$.MODULE$.EMPTY(), (Option)None$.MODULE$);
        this.writeRecords((AbstractLog)log, logSegmentsCount * 2, 10, 2);
        Pool logsPool = new Pool((Option)None$.MODULE$);
        logsPool.put((Object)tp, (Object)log);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, AbstractLog>)logsPool);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)1L));
        Assertions.assertTrue((boolean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).isEmpty());
        this.verifyMetrics(cleanerManager);
        this.time().sleep(11L);
        Assertions.assertTrue((boolean)((LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get()).needCompactionNow());
        this.verifyMetrics(cleanerManager);
    }

    @Test
    public void testGrabFilthiestCompactedLogThrowsException() {
        TopicPartition tp = new TopicPartition("A", 1);
        int logSegmentSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2).sizeInBytes() * 10;
        int logSegmentsCount = 2;
        File tpDir = new File(this.logDir(), "A-1");
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        LogConfig config = this.createLowRetentionLogConfig(logSegmentSize, "compact", false, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1000L)));
        int maxTransactionTimeoutMs = 300000;
        int producerIdExpirationCheckIntervalMs = 600000;
        Files.createDirectories(tpDir.toPath(), new FileAttribute[0]);
        LogSegments segments = new LogSegments(tp);
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
        Metrics metrics = new Metrics();
        Option leaderEpochCache = MergedLog$.MODULE$.maybeCreateLeaderEpochCache(tpDir, tp, logDirFailureChannel, config.messageFormatVersion.highestSupportedRecordVersion(), "");
        ProducerStateManager producerStateManager = new ProducerStateManager(tp, tpDir, maxTransactionTimeoutMs, this.producerStateManagerConfig(), (Time)this.time(), Optional.empty());
        LoadedLogOffsets offsets = new LogLoader(tpDir, tp, config, (Scheduler)this.time().scheduler(), (Time)this.time(), logDirFailureChannel, true, segments, 0L, 0L, leaderEpochCache, producerStateManager, new ConcurrentHashMap()).load();
        LocalLog localLog = new LocalLog(tpDir, config, segments, offsets.recoveryPoint, offsets.nextOffsetMetadata, (Scheduler)this.time().scheduler(), (Time)this.time(), tp, logDirFailureChannel, brokerTopicStats, LogOffsetsListener.NO_OP_OFFSETS_LISTENER);
        TierPartitionState tierPartitionState = TierLogComponents$.MODULE$.EMPTY().partitionStateFactory().initState(this.logDir(), this.topicPartition(), localLog.config(), logDirFailureChannel, (Scheduler)this.time().scheduler(), (Time)this.time());
        MergedLog log = new MergedLog(null, localLog, metrics, leaderEpochCache, producerIdExpirationCheckIntervalMs, producerStateManager, tierPartitionState){

            public Iterable<Object> getFirstBatchTimestampForSegments(Iterable<LogSegment> segments) {
                throw new IllegalStateException("Error!");
            }
        };
        this.writeRecords((AbstractLog)log, logSegmentsCount * 2, 10, 2);
        Pool logsPool = new Pool((Option)None$.MODULE$);
        logsPool.put((Object)tp, (Object)log);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, AbstractLog>)logsPool);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)1L));
        LogCleaningException thrownException = (LogCleaningException)Assertions.assertThrows(LogCleaningException.class, () -> cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get());
        Assertions.assertEquals((Object)log, (Object)thrownException.log());
        Assertions.assertTrue((boolean)(thrownException.getCause() instanceof IllegalStateException));
    }

    @Test
    public void testGrabFilthiestCompactedLogWithTierCompactFeatureEnabled() {
        TopicPartition tp = new TopicPartition("A", 1);
        int logSegmentSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2).sizeInBytes() * 10;
        int logSegmentsCount = 2;
        File tpDir = new File(this.logDir(), "A-1");
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        LogConfig config = this.createLowRetentionLogConfig(logSegmentSize, "compact", true, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1000L)));
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)Mockito.mock(TierTopicConsumer.class);
        MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore((Time)this.time(), new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1)));
        boolean tierCleanerFeatureEnabled = true;
        TierLogComponents tierLogComponents = new TierLogComponents((Option)new Some((Object)tierTopicConsumer), (Option)new Some((Object)tierObjectStore), new TierPartitionStateFactory(true, false, tierCleanerFeatureEnabled, TierPartitionStateCleanupConfig.EMPTY, false, -1), (Option)None$.MODULE$);
        MergedLog log = MergedLog$.MODULE$.apply(tpDir, config, 0L, 0L, (Scheduler)this.time().scheduler(), new BrokerTopicStats(), new Metrics(), (Time)this.time(), 300000, this.producerStateManagerConfig(), 600000, (Option)None$.MODULE$, logDirFailureChannel, tierLogComponents, true, (Option)None$.MODULE$, true, LogOffsetsListener.NO_OP_OFFSETS_LISTENER, (Option)None$.MODULE$, new ConcurrentHashMap());
        log.assignTopicId(Uuid.randomUuid(), 1);
        this.writeRecords((AbstractLog)log, logSegmentsCount * 2, 10, 2);
        Pool logsPool = new Pool((Option)None$.MODULE$);
        logsPool.put((Object)tp, (Object)log);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, AbstractLog>)logsPool);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)1L));
        Assertions.assertTrue((boolean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).isEmpty());
    }

    @Test
    public void testGrabFilthiestCompactedLogReturnsLogWithDirtiestRatio() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp2, (Object)filthiestLog.topicPartition());
        Assertions.assertEquals((Object)tp2, (Object)filthiestLog.log().topicPartition());
        this.verifyMetrics(cleanerManager);
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresUncleanablePartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.markPartitionUncleanable(((AbstractLog)logs.get((Object)tp2)).dir().getParent(), tp2);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition());
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.log().topicPartition());
        this.verifyMetrics(cleanerManager);
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresInProgressPartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition());
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.log().topicPartition());
        this.verifyMetrics(cleanerManager);
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresBothInProgressPartitionsAndUncleanablePartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.markPartitionUncleanable(((AbstractLog)logs.get((Object)tp1)).dir().getParent(), tp1);
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
    }

    @Test
    public void testDirtyOffsetResetIfLargerThanEndOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)200L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((long)0L, (long)filthiestLog.firstDirtyOffset());
        this.verifyMetrics(cleanerManager);
    }

    @Test
    public void testDirtyOffsetResetIfSmallerThanStartOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        ((AbstractLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(10L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)0L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((long)10L, (long)filthiestLog.firstDirtyOffset());
        this.verifyMetrics(cleanerManager);
    }

    @Test
    public void testLogStartOffsetLargerThanActiveSegmentBaseOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        AbstractLog log = this.createLog(2048, "compact", tp, this.logDir());
        Pool logs = new Pool((Option)None$.MODULE$);
        logs.put((Object)tp, (Object)log);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        Assertions.assertEquals((int)1, (int)log.localLogSegments().size());
        log.maybeIncrementLogStartOffset(2L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, AbstractLog>)logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)0L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
        this.verifyMetrics(cleanerManager);
    }

    @Test
    public void testDirtyOffsetLargerThanActiveSegmentBaseOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool logs = new Pool((Option)None$.MODULE$);
        AbstractLog log = this.createLog(2048, "compact", tp, this.logDir());
        logs.put((Object)tp, (Object)log);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        Assertions.assertEquals((int)1, (int)log.localLogSegments().size());
        Assertions.assertEquals((long)0L, (long)log.activeSegment().baseOffset());
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, AbstractLog>)logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)3L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
        this.verifyMetrics(cleanerManager);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderCleanupPolicyDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, "delete", this.createLog$default$3(), this.logDir());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assertions.assertEquals((int)0, (int)readyToDelete, (String)"should have 0 logs ready to be deleted");
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, "compact,delete", this.createLog$default$3(), this.logDir());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assertions.assertEquals((int)1, (int)readyToDelete, (String)"should have 1 logs ready to be deleted");
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3(), this.logDir());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assertions.assertEquals((int)1, (int)readyToDelete, (String)"should have 1 logs ready to be deleted");
    }

    @Test
    public void testLogsUnderCleanupIneligibleForCompaction() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, "delete", this.createLog$default$3(), this.logDir());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1(), log.roll$default$2());
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.updateHighWatermark(2L);
        Iterable deletableLog = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assertions.assertEquals((int)1, (int)deletableLog.size(), (String)"should have 1 logs ready to be deleted");
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(log.config().segmentSize));
        logProps.put("retention.ms", Predef$.MODULE$.long2Long(log.config().retentionMs));
        logProps.put("cleanup.policy", "compact");
        logProps.put("min.cleanable.dirty.ratio", Predef$.MODULE$.int2Integer(0));
        LogConfig config = new LogConfig((Map)logProps);
        log.updateConfig(config);
        Option cleanable = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((int)0, (int)Option$.MODULE$.option2Iterable(cleanable).size(), (String)"should have 0 logs ready to be compacted");
        this.verifyMetrics(cleanerManager);
        cleanerManager.resumeCleaning((Iterable)deletableLog.map((Function1 & Serializable)x$2 -> (TopicPartition)x$2._1()));
        Option cleanable2 = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((int)1, (int)Option$.MODULE$.option2Iterable(cleanable2).size(), (String)"should have 1 logs ready to be compacted");
        this.verifyMetrics(cleanerManager);
        logProps.put("cleanup.policy", "delete");
        LogConfig config2 = new LogConfig((Map)logProps);
        log.updateConfig(config2);
        Iterable deletableLog2 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assertions.assertEquals((int)0, (int)deletableLog2.size(), (String)"should have 0 logs ready to be deleted");
        cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)((LogToClean)cleanable2.get()).topicPartition(), (List)Nil$.MODULE$));
        Iterable deletableLog3 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assertions.assertEquals((int)1, (int)deletableLog3.size(), (String)"should have 1 logs ready to be deleted");
    }

    @Test
    public void testUpdateCheckpointsShouldAddOffsetToPartition() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3(), this.logDir());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Assertions.assertNotEquals((Object)BoxesRunTime.boxToInteger((int)this.offset()), (Object)cleanerManager.allCleanerCheckpoints().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
    }

    @Test
    public void testUpdateCheckpointsShouldRemovePartitionData() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3(), this.logDir());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        File x$1 = this.logDir();
        Option x$2 = Option$.MODULE$.apply((Object)this.topicPartition());
        Option x$3 = cleanerManager.updateCheckpoints$default$2();
        cleanerManager.updateCheckpoints(x$1, x$3, x$2);
        Assertions.assertFalse((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
    }

    @Test
    public void testHandleLogDirFailureShouldRemoveDirAndData() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3(), this.logDir());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        cleanerManager.updateCheckpoints(this.logDir2(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition2(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition2())));
        cleanerManager.handleLogDirFailure(this.logDir().getAbsolutePath());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition2())));
        Assertions.assertFalse((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
    }

    @Test
    public void testMaybeTruncateCheckpointShouldTruncateData() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3(), this.logDir());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        long lowerOffset = 1L;
        long higherOffset = 1000L;
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.maybeTruncateCheckpoint(this.logDir(), this.topicPartition(), higherOffset);
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.maybeTruncateCheckpoint(this.logDir(), this.topicPartition(), lowerOffset);
        Assertions.assertEquals((long)lowerOffset, (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
    }

    @Test
    public void testAlterCheckpointDirShouldRemoveDataInSrcDirAndAddInNewDir() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3(), this.logDir());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.alterCheckpointDir(this.topicPartition(), this.logDir(), this.logDir2());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.handleLogDirFailure(this.logDir2().getAbsolutePath());
        Assertions.assertFalse((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
    }

    @Test
    public void testConcurrentLogCleanupAndLogTruncation() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, "delete", this.createLog$default$3(), this.logDir());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortAndPauseCleaning(log.topicPartition());
        cleanerManager.resumeCleaning((Iterable)new .colon.colon((Object)log.topicPartition(), (List)Nil$.MODULE$));
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1 & Serializable)x$3 -> (TopicPartition)x$3._1()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testConcurrentLogCleanupAndTopicDeletion() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, "delete", this.createLog$default$3(), this.logDir());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortCleaning(log.topicPartition());
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1 & Serializable)x$4 -> (TopicPartition)x$4._1()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderUncleanablePartitions() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3(), this.logDir());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.markPartitionUncleanable(log.dir().getParent(), this.topicPartition());
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assertions.assertEquals((int)0, (int)readyToDelete, (String)"should have 0 logs ready to be deleted");
    }

    @Test
    public void testCompactedBytesMetric() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        AbstractLog log_1 = this.createLog(records.sizeInBytes() * 5, "compact", new TopicPartition("topic-1", 0), this.logDir());
        AbstractLog log_2 = this.createLog(records.sizeInBytes() * 5, "compact,delete", new TopicPartition("topic-2", 2), this.logDir());
        AbstractLog log_3 = this.createLog(records.sizeInBytes() * 5, "compact", new TopicPartition("topic-2", 5), this.logDir());
        AbstractLog log_4 = this.createLog(records.sizeInBytes() * 5, "compact", new TopicPartition("topic-2", 10), this.logDir2());
        AbstractLog log_5 = this.createLog(records.sizeInBytes() * 5, "compact,delete", new TopicPartition("topic-1", 2), this.logDir2());
        AbstractLog log_6 = this.createLog(records.sizeInBytes() * 5, "delete", new TopicPartition("topic-3", 2), this.logDir());
        AbstractLog log_7 = this.createLog(records.sizeInBytes() * 5, "delete", new TopicPartition("topic-4", 2), this.logDir2());
        Set logs = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractLog[]{log_1, log_2, log_3, log_4, log_5, log_6, log_7}));
        IntRef numBatches = IntRef.create((int)5);
        logs.foreach((Function1 & Serializable)log -> {
            LogCleanerManagerTest.$anonfun$testCompactedBytesMetric$1(this, numBatches, log);
            return BoxedUnit.UNIT;
        });
        this.createCleanerManager((Set<AbstractLog>)logs);
        long logDirSize = log_1.size() + log_2.size() + log_3.size();
        long logDir2Size = log_4.size() + log_5.size();
        Assertions.assertTrue((logDirSize > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((logDir2Size > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((logDirSize != logDir2Size ? 1 : 0) != 0);
        logs.foreach((Function1 & Serializable)log -> {
            LogCleanerManagerTest.$anonfun$testCompactedBytesMetric$4(log);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)logDirSize, (long)BoxesRunTime.unboxToLong((Object)LogCleanerManagerTest.getGauge$1("compacted-partition-bytes", this.logDir().getAbsolutePath()).value()));
        Assertions.assertEquals((long)logDirSize, (long)BoxesRunTime.unboxToLong((Object)LogCleanerManagerTest.getGauge$1("compacted-partition-local-bytes", this.logDir().getAbsolutePath()).value()));
        Assertions.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)LogCleanerManagerTest.getGauge$1("compacted-partition-tiered-bytes", this.logDir().getAbsolutePath()).value()));
        Assertions.assertEquals((long)logDir2Size, (long)BoxesRunTime.unboxToLong((Object)LogCleanerManagerTest.getGauge$1("compacted-partition-bytes", this.logDir2().getAbsolutePath()).value()));
        Assertions.assertEquals((long)logDir2Size, (long)BoxesRunTime.unboxToLong((Object)LogCleanerManagerTest.getGauge$1("compacted-partition-local-bytes", this.logDir2().getAbsolutePath()).value()));
        Assertions.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)LogCleanerManagerTest.getGauge$1("compacted-partition-tiered-bytes", this.logDir2().getAbsolutePath()).value()));
    }

    @Test
    public void testCleanableOffsetsForNone() {
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig.fromProps((Map)this.logConfig().originals(), (Properties)logProps);
        File x$2 = this.logDir();
        MergedLog log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        log.updateHighWatermark(50L);
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log, (Option)lastCleanOffset, this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)log.highWatermark(), (long)log.lastStableOffset(), (String)"The high watermark equals the last stable offset as no transactions are in progress");
        Assertions.assertEquals((long)log.lastStableOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset is bounded by the last stable offset.");
    }

    @Test
    public void testCleanableOffsetsActiveSegment() {
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig.fromProps((Map)this.logConfig().originals(), (Properties)logProps);
        File x$2 = this.logDir();
        MergedLog log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        log.updateHighWatermark(log.logEndOffset());
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log, (Option)lastCleanOffset, this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)log.activeSegment().baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset begins with the active segment.");
    }

    @Test
    public void testCleanableOffsetsForTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        logProps.put("min.compaction.lag.ms", Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig.fromProps((Map)this.logConfig().originals(), (Properties)logProps);
        File x$2 = this.logDir();
        MergedLog log = this.makeLog(x$2, x$1);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        LogSegment activeSegAtT0 = log.activeSegment();
        this.time().sleep(compactionLag + 1);
        long t1 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        log.updateHighWatermark(log.logEndOffset());
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log, (Option)lastCleanOffset, this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)activeSegAtT0.baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset begins with the second block of log entries.");
    }

    @Test
    public void testCleanableOffsetsForShortTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        logProps.put("min.compaction.lag.ms", Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig.fromProps((Map)this.logConfig().originals(), (Properties)logProps);
        File x$2 = this.logDir();
        MergedLog log = this.makeLog(x$2, x$1);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        log.updateHighWatermark(log.logEndOffset());
        this.time().sleep(compactionLag + 1);
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log, (Option)lastCleanOffset, this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)log.activeSegment().baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset begins with active segment.");
    }

    @Test
    public void testCleanableOffsetsNeedsCheckpointReset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        ((AbstractLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(10L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)15L));
        Assertions.assertFalse((boolean)LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds()).forceUpdateCheckpoint(), (String)"Checkpoint offset should not be reset if valid");
        ((AbstractLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(20L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        Assertions.assertTrue((boolean)LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds()).forceUpdateCheckpoint(), (String)"Checkpoint offset needs to be reset if less than log start offset");
        lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)25L));
        Assertions.assertTrue((boolean)LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds()).forceUpdateCheckpoint(), (String)"Checkpoint offset needs to be reset if greater than log end offset");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUndecidedTransactionalDataNotCleanable() {
        void withEndTransactionMarker_marker;
        void withTransactionalRecords_records;
        void withTransactionalRecords_baseSequence;
        void withTransactionalRecords_records2;
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        logProps.put("min.compaction.lag.ms", Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig.fromProps((Map)this.logConfig().originals(), (Properties)logProps);
        File x$2 = this.logDir();
        MergedLog log = this.makeLog(x$2, x$1);
        long producerId = 15L;
        short producerEpoch = (short)0;
        int sequence = 0;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "1".getBytes(), "a".getBytes()), new SimpleRecord(this.time().milliseconds(), "2".getBytes(), "b".getBytes())};
        CompressionType withTransactionalRecords_compressionType = CompressionType.NONE;
        Object var11_10 = null;
        simpleRecordArray = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)producerId, (short)producerEpoch, (int)sequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "3".getBytes(), "c".getBytes())};
        int n = sequence + 2;
        CompressionType withTransactionalRecords_compressionType2 = CompressionType.NONE;
        Object var13_13 = null;
        simpleRecordArray2 = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)producerId, (short)producerEpoch, (int)withTransactionalRecords_baseSequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1(), log.roll$default$2());
        log.updateHighWatermark(3L);
        this.time().sleep(compactionLag + 1);
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
        EndTransactionMarker endTransactionMarker = new EndTransactionMarker(ControlRecordType.ABORT, 15);
        long withEndTransactionMarker_timestamp = this.time().milliseconds();
        endTransactionMarker = null;
        log.appendAsLeader(MemoryRecords.withEndTransactionMarker((long)0L, (long)withEndTransactionMarker_timestamp, (int)-1, (long)producerId, (short)producerEpoch, (EndTransactionMarker)withEndTransactionMarker_marker), 0, AppendOrigin.COORDINATOR, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1(), log.roll$default$2());
        log.updateHighWatermark(4L);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assertions.assertEquals((long)3L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
        this.time().sleep(compactionLag + 1);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assertions.assertEquals((long)4L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
    }

    @Test
    public void testDoneCleaning() {
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig.fromProps((Map)this.logConfig().originals(), (Properties)logProps);
        File x$2 = this.logDir();
        MergedLog log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        LogCleanerManager cleanerManager = this.createCleanerManager((AbstractLog)log);
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)new LogCleaningPaused(1));
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningInProgress$.MODULE$);
        long endOffset = 1L;
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), endOffset);
        Assertions.assertTrue((boolean)cleanerManager.cleaningState(this.topicPartition()).isEmpty());
        Assertions.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)), (Object)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), endOffset);
        Assertions.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(this.topicPartition()).get());
        Assertions.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
    }

    @Test
    public void testDoneDeleting() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        AbstractLog log = this.createLog(records.sizeInBytes() * 5, "compact,delete", this.createLog$default$3(), this.logDir());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        TopicPartition tp = new TopicPartition("log", 0);
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$)));
        cleanerManager.setCleaningState(tp, (LogCleaningState)new LogCleaningPaused(1));
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$)));
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$));
        Assertions.assertTrue((boolean)cleanerManager.cleaningState(tp).isEmpty());
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$));
        Assertions.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(tp).get());
    }

    @Test
    public void testCheckpointUpdatedForInvalidOffsetNoCleaning() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        ((AbstractLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(20L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)15L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog, (String)"Log should not be selected for cleaning");
        Assertions.assertEquals((long)20L, (long)BoxesRunTime.unboxToLong((Object)this.cleanerCheckpoints().apply((Object)tp)), (String)"Unselected log should have checkpoint offset updated");
        this.verifyMetrics(cleanerManager);
    }

    @Test
    public void testCheckpointUpdatedForInvalidOffsetNotSelected() {
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)Nil$.MODULE$));
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)partitions, 20, 5);
        ((AbstractLog)logs.get((Object)tp0)).maybeIncrementLogStartOffset(15L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp0, (Object)BoxesRunTime.boxToLong((long)10L));
        this.cleanerCheckpoints().put((Object)tp1, (Object)BoxesRunTime.boxToLong((long)5L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition(), (String)"Dirtier log should be selected");
        Assertions.assertEquals((long)15L, (long)BoxesRunTime.unboxToLong((Object)this.cleanerCheckpoints().apply((Object)tp0)), (String)"Unselected log should have checkpoint offset updated");
        this.verifyMetrics(cleanerManager);
    }

    private LogCleanerManager createCleanerManager(AbstractLog log) {
        Pool logs = new Pool((Option)None$.MODULE$);
        logs.put((Object)this.topicPartition(), (Object)log);
        return new LogCleanerManager((Seq)new .colon.colon((Object)this.logDir(), (List)new .colon.colon((Object)this.logDir2(), (List)Nil$.MODULE$)), logs, null);
    }

    private LogCleanerManager createCleanerManager(Set<AbstractLog> logs) {
        Pool compactedLogs = new Pool((Option)None$.MODULE$);
        logs.foreach((Function1 & Serializable)log -> (AbstractLog)compactedLogs.put((Object)log.topicPartition(), log));
        return new LogCleanerManager((Seq)new .colon.colon((Object)this.logDir(), (List)new .colon.colon((Object)this.logDir2(), (List)Nil$.MODULE$)), compactedLogs, null);
    }

    private LogCleanerManagerMock createCleanerManagerMock(Pool<TopicPartition, AbstractLog> pool) {
        return new LogCleanerManagerMock((scala.collection.immutable.Seq<File>)new .colon.colon((Object)this.logDir(), (List)Nil$.MODULE$), pool, null);
    }

    private AbstractLog createLog(int segmentSize, String cleanupPolicy, TopicPartition topicPartition, File logDir) {
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put("retention.ms", Predef$.MODULE$.int2Integer(1));
        logProps.put("cleanup.policy", cleanupPolicy);
        logProps.put("min.cleanable.dirty.ratio", Predef$.MODULE$.double2Double(0.05));
        LogConfig config = this.createLowRetentionLogConfig(segmentSize, cleanupPolicy, false, (Option<Object>)None$.MODULE$);
        File partitionDir = new File(logDir, LocalLog$.MODULE$.logDirName(topicPartition));
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        Metrics x$8 = new Metrics();
        ProducerStateManagerConfig x$10 = this.producerStateManagerConfig();
        int x$11 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$12 = new LogDirFailureChannel(10);
        TierLogComponents x$13 = TierLogComponents$.MODULE$.EMPTY();
        None$ x$15 = None$.MODULE$;
        None$ x$17 = None$.MODULE$;
        LogOffsetsListener x$18 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        None$ x$19 = None$.MODULE$;
        ConcurrentHashMap x$20 = new ConcurrentHashMap();
        return MergedLog$.MODULE$.apply(partitionDir, config, 0L, 0L, (Scheduler)x$5, x$7, x$8, (Time)x$6, 300000, x$10, x$11, (Option)x$17, x$12, x$13, true, (Option)x$15, true, x$18, (Option)x$19, x$20);
    }

    private TopicPartition createLog$default$3() {
        return new TopicPartition("log", 0);
    }

    private File createLog$default$4() {
        return this.logDir();
    }

    private LogConfig createLowRetentionLogConfig(int segmentSize, String cleanupPolicy, boolean tierEnable, Option<Object> maxCompactionLagMs) {
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put("retention.ms", Predef$.MODULE$.int2Integer(1));
        logProps.put("cleanup.policy", cleanupPolicy);
        logProps.put("min.cleanable.dirty.ratio", Predef$.MODULE$.double2Double(0.05));
        logProps.put("confluent.tier.enable", Boolean.toString(tierEnable));
        logProps.put("confluent.tier.cleaner.enable", "true");
        maxCompactionLagMs.foreach((Function1 & Serializable)lag -> logProps.put("max.compaction.lag.ms", Long.toString(BoxesRunTime.unboxToLong((Object)lag))));
        return new LogConfig((Map)logProps);
    }

    private Option<Object> createLowRetentionLogConfig$default$4() {
        return None$.MODULE$;
    }

    private void writeRecords(AbstractLog log, int numBatches, int recordsPerBatch, int batchesPerSegment) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numBatches).foreach((Function1 & Serializable)i -> LogCleanerManagerTest.$anonfun$writeRecords$1(this, log, recordsPerBatch, batchesPerSegment, BoxesRunTime.unboxToInt((Object)i)));
        log.roll(log.roll$default$1(), log.roll$default$2());
    }

    /*
     * WARNING - void declaration
     */
    private void appendRecords(AbstractLog log, int numRecords) {
        void withRecords_records;
        void withRecords_timestampType;
        long startOffset = log.logEndOffset();
        long endOffset = startOffset + (long)numRecords;
        LongRef lastTimestamp = LongRef.create((long)0L);
        IndexedSeq records = (IndexedSeq)new RichLong(Predef$.MODULE$.longWrapper(startOffset)).until((Object)BoxesRunTime.boxToLong((long)endOffset)).map((Function1 & Serializable)offset -> LogCleanerManagerTest.$anonfun$appendRecords$1(this, endOffset, lastTimestamp, BoxesRunTime.unboxToLong((Object)offset)));
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var9_8 = null;
        simpleRecordArray = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records), 1, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.maybeIncrementHighWatermark(log.logEndOffsetMetadata());
    }

    private MergedLog makeLog(File dir, LogConfig config) {
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        Metrics x$8 = new Metrics();
        ProducerStateManagerConfig x$10 = this.producerStateManagerConfig();
        int x$11 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$12 = new LogDirFailureChannel(10);
        None$ x$13 = None$.MODULE$;
        TierLogComponents x$14 = TierLogComponents$.MODULE$.EMPTY();
        None$ x$17 = None$.MODULE$;
        LogOffsetsListener x$18 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        None$ x$19 = None$.MODULE$;
        ConcurrentHashMap x$20 = new ConcurrentHashMap();
        return MergedLog$.MODULE$.apply(dir, config, 0L, 0L, (Scheduler)x$5, x$7, x$8, (Time)x$6, 300000, x$10, x$11, (Option)x$17, x$12, x$14, true, (Option)x$13, true, x$18, (Option)x$19, x$20);
    }

    private File makeLog$default$1() {
        return this.logDir();
    }

    /*
     * WARNING - void declaration
     */
    private MemoryRecords records(int key, int value, long timestamp) {
        void withRecords_records;
        void withRecords_timestampType;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(timestamp, Integer.toString(key).getBytes(), Integer.toString(value).getBytes())};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        return MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
    }

    private void verifyMetrics(LogCleanerManager cleanerManager) {
        long cleanBytes = cleanerManager.cleanBytesLast().get();
        long cleanableBytes = cleanerManager.cleanableBytesLast().get();
        long uncleanableBytes = cleanerManager.uncleanableBytesLast().get();
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)((IterableOnceOps)cleanerManager.logs().map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToLong((long)LogCleanerManagerTest.$anonfun$verifyMetrics$1(cleanerManager, x0$1)))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), (long)(cleanBytes + cleanableBytes + uncleanableBytes));
    }

    public static final /* synthetic */ void $anonfun$setupIncreasinglyFilthyLogs$1(LogCleanerManagerTest $this, Pool logs$1, IntRef numBatches$1, int batchIncrement$1, TopicPartition tp) {
        AbstractLog log = $this.createLog(2048, "compact", tp, $this.logDir());
        logs$1.put((Object)tp, (Object)log);
        $this.writeRecords(log, numBatches$1.elem, 1, 5);
        numBatches$1.elem += batchIncrement$1;
    }

    public static final /* synthetic */ void $anonfun$testCompactedBytesMetric$1(LogCleanerManagerTest $this, IntRef numBatches$2, AbstractLog log) {
        $this.writeRecords(log, numBatches$2.elem, 1, 5);
        numBatches$2.elem += 10;
    }

    public static final /* synthetic */ boolean $anonfun$testCompactedBytesMetric$2(Function1 filter$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName k = (MetricName)x0$1._1();
            return BoxesRunTime.unboxToBoolean((Object)filter$1.apply((Object)k));
        }
        throw new MatchError(null);
    }

    private static final Metric getMetric$1(Function1 filter) {
        return (Metric)((Tuple2)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManagerTest.$anonfun$testCompactedBytesMetric$2(filter, x0$1)))).head())._2();
    }

    public static final /* synthetic */ boolean $anonfun$testCompactedBytesMetric$3(String metricName$1, String metricScope$1, MetricName k) {
        return k.getName().endsWith(metricName$1) && k.getScope().endsWith(metricScope$1);
    }

    private static final Gauge getGauge$1(String metricName, String metricScope) {
        Function1 & Serializable getMetric$1_filter = (Function1 & Serializable)k -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManagerTest.$anonfun$testCompactedBytesMetric$3(metricName, metricScope, k));
        return (Gauge)((Metric)((Tuple2)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManagerTest.$anonfun$testCompactedBytesMetric$2(filter, x0$1)))).head())._2());
    }

    public static final /* synthetic */ void $anonfun$testCompactedBytesMetric$4(AbstractLog log) {
        ((MergedLog)log).computeLogSizeDetails().cancel(true);
        ((MergedLog)log).updateSizeDetails();
    }

    public static final /* synthetic */ Object $anonfun$writeRecords$1(LogCleanerManagerTest $this, AbstractLog log$2, int recordsPerBatch$1, int batchesPerSegment$1, int i) {
        $this.appendRecords(log$2, recordsPerBatch$1);
        if (i % batchesPerSegment$1 == 0) {
            return log$2.roll(log$2.roll$default$1(), log$2.roll$default$2());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ SimpleRecord $anonfun$appendRecords$1(LogCleanerManagerTest $this, long endOffset$1, LongRef lastTimestamp$1, long offset) {
        long currentTimestamp = $this.time().milliseconds();
        if (offset == endOffset$1 - 1L) {
            lastTimestamp$1.elem = currentTimestamp;
        }
        return new SimpleRecord(currentTimestamp, new StringBuilder(4).append("key-").append(offset).toString().getBytes(), new StringBuilder(6).append("value-").append(offset).toString().getBytes());
    }

    public static final /* synthetic */ long $anonfun$verifyMetrics$1(LogCleanerManager cleanerManager$5, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            AbstractLog log = (AbstractLog)x0$1._2();
            if (cleanerManager$5.isUncleanablePartition(log, topicPartition)) {
                return 0L;
            }
            return log.size();
        }
        throw new MatchError(null);
    }

    public LogCleanerManagerTest() {
        this.logProps().put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        this.logProps().put("segment.index.bytes", Predef$.MODULE$.int2Integer(1024));
        this.logProps().put("cleanup.policy", "compact");
        this.logConfig = new LogConfig((Map)this.logProps());
        this.time = new MockTime(1400000000000L, 1000L);
        this.offset = 999;
        this.producerStateManagerConfig = new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs());
        this.cleanerCheckpoints = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    }

    public class LogCleanerManagerMock
    extends LogCleanerManager {
        public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
            return this.kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer().cleanerCheckpoints().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        /*
         * WARNING - void declaration
         */
        public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Object>> partitionToUpdateOrAdd, Option<TopicPartition> partitionToRemove) {
            void var5_5;
            Predef$.MODULE$.assert(partitionToRemove.isEmpty(), (Function0 & Serializable)() -> "partitionToRemove argument with value not yet handled");
            Tuple2 tuple2 = (Tuple2)partitionToUpdateOrAdd.getOrElse((Function0 & Serializable)() -> {
                throw new IllegalArgumentException("partitionToUpdateOrAdd==None argument not yet handled");
            });
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long l = tuple2._2$mcJ$sp();
            this.kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer().cleanerCheckpoints().put((Object)var5_5, (Object)BoxesRunTime.boxToLong((long)l));
        }

        public Option<Tuple2<TopicPartition, Object>> updateCheckpoints$default$2() {
            return None$.MODULE$;
        }

        public Option<TopicPartition> updateCheckpoints$default$3() {
            return None$.MODULE$;
        }

        public /* synthetic */ LogCleanerManagerTest kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer() {
            return LogCleanerManagerTest.this;
        }

        public LogCleanerManagerMock(scala.collection.immutable.Seq<File> logDirs, Pool<TopicPartition, AbstractLog> logs, LogDirFailureChannel logDirFailureChannel) {
            if (LogCleanerManagerTest.this == null) {
                throw null;
            }
            super(logDirs, logs, logDirFailureChannel);
        }
    }
}

