/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Properties;
import kafka.log.AbstractLog;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerManager$;
import kafka.log.LogSegment;
import kafka.log.MergedLog;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import kafka.utils.ThreadsCpuMeter;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArraySeq;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ef\u0001B\u000b\u0017\u0001mAQ\u0001\t\u0001\u0005\u0002\u0005Bqa\t\u0001C\u0002\u0013\u0005A\u0005\u0003\u00043\u0001\u0001\u0006I!\n\u0005\bg\u0001\u0011\r\u0011\"\u00015\u0011\u0019Y\u0004\u0001)A\u0005k!9A\b\u0001b\u0001\n\u0003i\u0004B\u0002%\u0001A\u0003%a\bC\u0003J\u0001\u0011\u0005!\nC\u0003Z\u0001\u0011\u0005!\nC\u0003_\u0001\u0011%q\fC\u0003x\u0001\u0011%\u0001\u0010\u0003\u0004x\u0001\u0011%\u00111\u0006\u0005\b\u0003w\u0001A\u0011BA\u001f\u0011\u001d\tI\u0005\u0001C\u0005\u0003\u0017Ba!!\u0016\u0001\t\u0003Q\u0005BBA-\u0001\u0011\u0005!\n\u0003\u0004\u0002^\u0001!\tA\u0013\u0005\b\u0003C\u0002A\u0011BA2\u0011\u001d\t)\t\u0001C\u0005\u0003\u000fCa!!,\u0001\t\u0003Q%!\u0007'pO\u000ecW-\u00198fe&sG/Z4sCRLwN\u001c+fgRT!a\u0006\r\u0002\u00071|wMC\u0001\u001a\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u000f\u0011\u0005uqR\"\u0001\f\n\u0005}1\"!I!cgR\u0014\u0018m\u0019;M_\u001e\u001cE.Z1oKJLe\u000e^3he\u0006$\u0018n\u001c8UKN$\u0018A\u0002\u001fj]&$h\bF\u0001#!\ti\u0002!A\u0003d_\u0012,7-F\u0001&!\t1\u0003'D\u0001(\u0015\tA\u0013&\u0001\u0004sK\u000e|'\u000f\u001a\u0006\u0003U-\naaY8n[>t'BA\r-\u0015\tic&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002_\u0005\u0019qN]4\n\u0005E:#aD\"p[B\u0014Xm]:j_:$\u0016\u0010]3\u0002\r\r|G-Z2!\u0003\u0011!\u0018.\\3\u0016\u0003U\u0002\"AN\u001d\u000e\u0003]R!\u0001\u000f\r\u0002\u000bU$\u0018\u000e\\:\n\u0005i:$\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N,\u0012A\u0010\t\u0004\u007f\t#U\"\u0001!\u000b\u0003\u0005\u000bQa]2bY\u0006L!a\u0011!\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u00153U\"A\u0015\n\u0005\u001dK#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0011i>\u0004\u0018n\u0019)beRLG/[8og\u0002\nqa\u00197fC:,\b\u000fF\u0001L!\tyD*\u0003\u0002N\u0001\n!QK\\5uQ\tAq\n\u0005\u0002Q/6\t\u0011K\u0003\u0002S'\u0006\u0019\u0011\r]5\u000b\u0005Q+\u0016a\u00026va&$XM\u001d\u0006\u0003-:\nQA[;oSRL!\u0001W)\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\u000f;fgRl\u0015M]6t!\u0006\u0014H/\u001b;j_:\u001c\u0018i](gM2Lg.Z!oIB{\u0007/\u001e7bi\u0016\u001cXK\\2mK\u0006t\u0017M\u00197f\u001b\u0016$(/[2tQ\tI1\f\u0005\u0002Q9&\u0011Q,\u0015\u0002\u0005)\u0016\u001cH/A\u0005hKRlU\r\u001e:jGR\u0011\u0001\r\u001c\t\u0003C*l\u0011A\u0019\u0006\u0003G\u0012\fAaY8sK*\u0011QMZ\u0001\b[\u0016$(/[2t\u0015\t9\u0007.\u0001\u0004zC6lWM\u001d\u0006\u0002S\u0006\u00191m\\7\n\u0005-\u0014'AB'fiJL7\rC\u0003n\u0015\u0001\u0007a.\u0001\u0004gS2$XM\u001d\t\u0005\u007f=\fH/\u0003\u0002q\u0001\nIa)\u001e8di&|g.\r\t\u0003CJL!a\u001d2\u0003\u00155+GO]5d\u001d\u0006lW\r\u0005\u0002@k&\u0011a\u000f\u0011\u0002\b\u0005>|G.Z1o\u0003!9W\r^$bk\u001e,WCA=\u0000)\rQ\u0018\u0011\u0003\t\u0004Cnl\u0018B\u0001?c\u0005\u00159\u0015-^4f!\tqx\u0010\u0004\u0001\u0005\u000f\u0005\u00051B1\u0001\u0002\u0004\t\tA+\u0005\u0003\u0002\u0006\u0005-\u0001cA \u0002\b%\u0019\u0011\u0011\u0002!\u0003\u000f9{G\u000f[5oOB\u0019q(!\u0004\n\u0007\u0005=\u0001IA\u0002B]fDq!a\u0005\f\u0001\u0004\t)\"\u0001\u0006nKR\u0014\u0018n\u0019(b[\u0016\u0004B!a\u0006\u0002&9!\u0011\u0011DA\u0011!\r\tY\u0002Q\u0007\u0003\u0003;Q1!a\b\u001b\u0003\u0019a$o\\8u}%\u0019\u00111\u0005!\u0002\rA\u0013X\rZ3g\u0013\u0011\t9#!\u000b\u0003\rM#(/\u001b8h\u0015\r\t\u0019\u0003Q\u000b\u0005\u0003[\t\u0019\u0004\u0006\u0004\u00020\u0005U\u0012q\u0007\t\u0005Cn\f\t\u0004E\u0002\u007f\u0003g!q!!\u0001\r\u0005\u0004\t\u0019\u0001C\u0004\u0002\u00141\u0001\r!!\u0006\t\u000f\u0005eB\u00021\u0001\u0002\u0016\u0005YQ.\u001a;sS\u000e\u001c6m\u001c9f\u0003!9W\r^'fi\u0016\u0014HCBA \u0003\u000b\n9\u0005E\u0002b\u0003\u0003J1!a\u0011c\u0005\u0015iU\r^3s\u0011\u001d\t\u0019\"\u0004a\u0001\u0003+Aq!!\u000f\u000e\u0001\u0004\t)\"\u0001\u0007hKRD\u0015n\u001d;pOJ\fW\u000e\u0006\u0003\u0002N\u0005M\u0003cA1\u0002P%\u0019\u0011\u0011\u000b2\u0003\u0013!K7\u000f^8he\u0006l\u0007bBA\n\u001d\u0001\u0007\u0011QC\u0001'i\u0016\u001cHoQ8na\u0006\u001cG/[8o)\"\u0014X-\u00193t\u0007B,X*\u001a;fe\n+gn\u00195nCJ\\\u0007FA\b\\\u0003]!Xm\u001d;NCbdunZ\"p[B\f7\r^5p]2\u000bw\r\u000b\u0002\u00117\u0006)B/Z:u\u0007>l\u0007/Y2uS>tW*\u001a;sS\u000e\u001c\bFA\t\\\u0003-\u0011X-\u00193Ge>lGj\\4\u0015\t\u0005\u0015\u0014Q\u0010\t\u0007\u0003O\ni'!\u001d\u000e\u0005\u0005%$bAA6\u0001\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005=\u0014\u0011\u000e\u0002\t\u0013R,'/\u00192mKB9q(a\u001d\u0002x\u0005]\u0014bAA;\u0001\n1A+\u001e9mKJ\u00022aPA=\u0013\r\tY\b\u0011\u0002\u0004\u0013:$\bBB\f\u0013\u0001\u0004\ty\bE\u0002\u001e\u0003\u0003K1!a!\u0017\u0005-\t%m\u001d;sC\u000e$Hj\\4\u0002\u0019]\u0014\u0018\u000e^3LKf$U\u000f]:\u0015!\u0005%\u0015qRAJ\u0003/\u000bI*a'\u0002&\u0006%\u0006CBA4\u0003\u0017\u000b\t(\u0003\u0003\u0002\u000e\u0006%$aA*fc\"9\u0011\u0011S\nA\u0002\u0005]\u0014a\u00028v[.+\u0017p\u001d\u0005\b\u0003+\u001b\u0002\u0019AA<\u0003\u001dqW/\u001c#vaNDaaF\nA\u0002\u0005}\u0004\"B\u0012\u0014\u0001\u0004)\u0003bBAO'\u0001\u0007\u0011qT\u0001\ni&lWm\u001d;b[B\u00042aPAQ\u0013\r\t\u0019\u000b\u0011\u0002\u0005\u0019>tw\rC\u0004\u0002(N\u0001\r!a\u001e\u0002\u0015M$\u0018M\u001d;WC2,X\rC\u0004\u0002,N\u0001\r!a\u001e\u0002\tM$X\r]\u0001\u0013i\u0016\u001cH/S:UQJ,\u0017\r\u001a$bS2,G\r\u000b\u0002\u00157\u0002")
public class LogCleanerIntegrationTest
extends AbstractLogCleanerIntegrationTest {
    private final CompressionType codec = CompressionType.LZ4;
    private final MockTime time = new MockTime();
    private final TopicPartition[] topicPartitions = new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)};

    public CompressionType codec() {
        return this.codec;
    }

    @Override
    public MockTime time() {
        return this.time;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    @AfterEach
    public void cleanup() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics() {
        void var3_3;
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2, this.codec());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        int maxMessageSize = var3_3.sizeInBytes();
        ArraySeq.ofRef x$12 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        int x$122 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$12, x$4, x$5, 100L, maxMessageSize, x$6, x$7, x$8, x$9, x$10, x$11, x$122));
        this.breakPartitionLog$1(this.topicPartitions()[0]);
        this.breakPartitionLog$1(this.topicPartitions()[1]);
        this.cleaner().startup();
        AbstractLog log = (AbstractLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        AbstractLog log2 = (AbstractLog)this.cleaner().logs().get((Object)this.topicPartitions()[1]);
        this.cleaner().logs().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> {
            LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$2(x$1);
            return BoxedUnit.UNIT;
        });
        String uncleanableDirectory = log.dir().getParent();
        Gauge uncleanablePartitionsCountGauge = this.getGauge("uncleanable-partitions-count", uncleanableDirectory);
        Gauge uncleanableBytesGauge = this.getGauge("uncleanable-bytes", uncleanableDirectory);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 2000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$3(uncleanablePartitionsCountGauge)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"There should be 2 uncleanable partitions");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long expectedTotalUncleanableBytes = LogCleanerManager$.MODULE$.calculateCleanableBytes(log, 0L, ((LogSegment)log.localLogSegments().last()).baseOffset())._2$mcJ$sp() + LogCleanerManager$.MODULE$.calculateCleanableBytes(log2, 0L, ((LogSegment)log2.localLogSegments().last()).baseOffset())._2$mcJ$sp();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 1000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$5(uncleanableBytesGauge, expectedTotalUncleanableBytes)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$6(expectedTotalUncleanableBytes));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Set uncleanablePartitions = this.cleaner().cleanerManager().uncleanablePartitions(uncleanableDirectory);
        Gauge compactedPartitionBytes = this.getGauge("compacted-partition-bytes", uncleanableDirectory);
        Assertions.assertTrue((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[0]));
        Assertions.assertTrue((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[1]));
        Assertions.assertFalse((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[2]));
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.cleaner().logs().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$7(x$2)))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), (long)BoxesRunTime.unboxToLong((Object)compactedPartitionBytes.value()));
        this.cleaner().logs().remove((Object)this.topicPartitions()[0]);
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 2000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$8(this, uncleanablePartitionsCountGauge)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"There should be 1 uncleanable partitions");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        Set uncleanablePartitions2 = this.cleaner().cleanerManager().uncleanablePartitions(uncleanableDirectory);
        Gauge compactedPartitionBytes2 = this.getGauge("compacted-partition-bytes", uncleanableDirectory);
        Assertions.assertFalse((boolean)uncleanablePartitions2.contains((Object)this.topicPartitions()[0]));
        Assertions.assertTrue((boolean)uncleanablePartitions2.contains((Object)this.topicPartitions()[1]));
        Assertions.assertFalse((boolean)uncleanablePartitions2.contains((Object)this.topicPartitions()[2]));
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.cleaner().logs().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$10(x$3)))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), (long)BoxesRunTime.unboxToLong((Object)compactedPartitionBytes2.value()));
    }

    private Metric getMetric(Function1<MetricName, Object> filter) {
        return (Metric)((Tuple2)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getMetric$1(filter, x0$1)))).headOption().getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2();
    }

    private <T> Gauge<T> getGauge(String metricName) {
        Function1 & Serializable getMetric_filter = (Function1 & Serializable)mName -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getGauge$1(metricName, mName));
        return (Gauge)((Metric)((Tuple2)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getMetric$1(filter, x0$1)))).headOption().getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2());
    }

    private <T> Gauge<T> getGauge(String metricName, String metricScope) {
        Function1 & Serializable getMetric_filter = (Function1 & Serializable)k -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getGauge$2(metricName, metricScope, k));
        return (Gauge)((Metric)((Tuple2)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getMetric$1(filter, x0$1)))).headOption().getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2());
    }

    private Meter getMeter(String metricName, String metricScope) {
        Function1 & Serializable getMetric_filter = (Function1 & Serializable)k -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getMeter$1(metricName, metricScope, k));
        return (Meter)((Metric)((Tuple2)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getMetric$1(filter, x0$1)))).headOption().getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2());
    }

    private Histogram getHistogram(String metricName) {
        Function1 & Serializable getMetric_filter = (Function1 & Serializable)k -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getHistogram$1(metricName, k));
        return (Histogram)((Metric)((Tuple2)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getMetric$1(filter, x0$1)))).headOption().getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2());
    }

    @Test
    public void testCompactionThreadsCpuMeterBenchmark() {
        int msPerHour = 3600000;
        int minCompactionLagMs = 1 * msPerHour;
        int maxCompactionLagMs = 6 * msPerHour;
        long cleanerBackOffMs = 200L;
        int segmentSize = 512;
        Object[] topicPartitions = new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)};
        float minCleanableDirtyRatio = 1.0f;
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray(topicPartitions);
        long x$3 = minCompactionLagMs;
        long x$5 = maxCompactionLagMs;
        int x$7 = this.makeCleaner$default$3();
        int x$8 = this.makeCleaner$default$5();
        int x$9 = this.makeCleaner$default$7();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        int x$12 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, minCleanableDirtyRatio, x$7, cleanerBackOffMs, x$8, x$3, x$9, segmentSize, x$5, x$10, x$11, x$12));
        this.cleaner().startup();
        new ThreadsCpuMeter(((IterableOnceOps)this.cleaner().cleaners().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.getId()))).toSeq()).runCpuUtilizationBenchmark();
    }

    @Test
    public void testMaxLogCompactionLag() {
        int msPerHour = 3600000;
        int minCompactionLagMs = 1 * msPerHour;
        int maxCompactionLagMs = 6 * msPerHour;
        long cleanerBackOffMs = 200L;
        int segmentSize = 512;
        Object[] topicPartitions = new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)};
        float minCleanableDirtyRatio = 1.0f;
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray(topicPartitions);
        long x$3 = minCompactionLagMs;
        long x$5 = maxCompactionLagMs;
        int x$7 = this.makeCleaner$default$3();
        int x$8 = this.makeCleaner$default$5();
        int x$9 = this.makeCleaner$default$7();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        int x$12 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, minCleanableDirtyRatio, x$7, cleanerBackOffMs, x$8, x$3, x$9, segmentSize, x$5, x$10, x$11, x$12));
        AbstractLog log = (AbstractLog)this.cleaner().logs().get(topicPartitions[0]);
        long T0 = this.time().milliseconds();
        this.writeKeyDups(100, 3, log, CompressionType.NONE, T0, 0, 1);
        long startSizeBlock0 = log.size();
        LogSegment activeSegAtT0 = log.activeSegment();
        this.cleaner().startup();
        Assertions.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)this.getGauge("compaction-cpu-utilization-percent").value()), (String)"The first call to CPU stats should return 0 as we do not have reference values");
        this.time().sleep(maxCompactionLagMs / 2);
        Thread.sleep(5L * cleanerBackOffMs);
        Assertions.assertEquals((long)startSizeBlock0, (long)log.size(), (String)"There should be no cleaning until the max compaction lag has passed");
        this.time().sleep(maxCompactionLagMs / 2 + 1);
        long T1 = this.time().milliseconds();
        Seq<Tuple2<Object, Object>> appends1 = this.writeKeyDups(100, 1, log, CompressionType.NONE, T1, 0, 0);
        log.roll(log.roll$default$1(), log.roll$default$2());
        LogSegment activeSegAtT1 = log.activeSegment();
        long firstBlockCleanableSegmentOffset = activeSegAtT0.baseOffset();
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$13 = new TopicPartition("log", 0);
        long x$15 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$13, firstBlockCleanableSegmentOffset, x$15);
        Iterable<Tuple2<Object, Object>> read1 = this.readFromLog(log);
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        Assertions.assertTrue((lastCleaned >= firstBlockCleanableSegmentOffset ? 1 : 0) != 0, (String)new StringBuilder(71).append("log cleaner should have processed at least to offset ").append(firstBlockCleanableSegmentOffset).append(", but lastCleaned=").append(lastCleaned).toString());
        Assertions.assertNotEquals(appends1, read1, (String)"log should still contain non-zero keys");
        this.getGauge("compaction-cpu-utilization-percent").value();
        this.time().sleep(maxCompactionLagMs + 1);
        LogCleaner qual$2 = this.cleaner();
        TopicPartition x$16 = new TopicPartition("log", 0);
        long x$17 = activeSegAtT1.baseOffset();
        long x$18 = qual$2.awaitCleaned$default$3();
        qual$2.awaitCleaned(x$16, x$17, x$18);
        Iterable<Tuple2<Object, Object>> read2 = this.readFromLog(log);
        Assertions.assertEquals(appends1, read2, (String)"log should only contains zero keys now");
        long lastCleaned2 = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        long secondBlockCleanableSegmentOffset = activeSegAtT1.baseOffset();
        Assertions.assertTrue((lastCleaned2 >= secondBlockCleanableSegmentOffset ? 1 : 0) != 0, (String)new StringBuilder(71).append("log cleaner should have processed at least to offset ").append(secondBlockCleanableSegmentOffset).append(", but lastCleaned=").append(lastCleaned2).toString());
        Assertions.assertNotEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)this.getGauge("compaction-cpu-utilization-percent").value()), (String)"The subsequents calls to CPU stats metric after some valid cleanup should return a non-zero value");
    }

    @Test
    public void testCompactionMetrics() {
        double eps = 1.0E-6;
        int msPerHour = 3600000;
        int minCompactionLagMs = 1 * msPerHour;
        int maxCompactionLagMs = 6 * msPerHour;
        long cleanerBackOffMs = 200L;
        int segmentSize = 512;
        Object[] topicPartitions = new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)};
        float minCleanableDirtyRatio = 1.0f;
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray(topicPartitions);
        long x$3 = minCompactionLagMs;
        long x$5 = maxCompactionLagMs;
        int x$7 = this.makeCleaner$default$3();
        int x$8 = this.makeCleaner$default$5();
        int x$9 = this.makeCleaner$default$7();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        int x$12 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, minCleanableDirtyRatio, x$7, cleanerBackOffMs, x$8, x$3, x$9, segmentSize, x$5, x$10, x$11, x$12));
        AbstractLog log = (AbstractLog)this.cleaner().logs().get(topicPartitions[0]);
        this.writeKeyDups(100, 3, log, CompressionType.NONE, this.time().milliseconds(), 0, 1);
        long startSizeBlock0 = log.size();
        LogSegment activeSeg = log.activeSegment();
        this.cleaner().startup();
        Meter readBytesPerSec = this.getMeter("CompactionThroughputBytesPerSec", "op.read");
        Meter writeBytesPerSec = this.getMeter("CompactionThroughputBytesPerSec", "op.write");
        Histogram achievedCleaningRatio = this.getHistogram("AchievedCleaningRatio");
        Assertions.assertEquals((long)0L, (long)readBytesPerSec.count(), (String)"log cleaner should have read 0 bytes");
        Assertions.assertEquals((long)0L, (long)writeBytesPerSec.count(), (String)"log cleaner should have written 0 bytes");
        Assertions.assertEquals((double)0.0, (double)achievedCleaningRatio.mean(), (double)eps, (String)"achieved cleaning ratio should be 0");
        this.time().sleep(maxCompactionLagMs / 2);
        Thread.sleep(5L * cleanerBackOffMs);
        Assertions.assertEquals((long)startSizeBlock0, (long)log.size(), (String)"There should be no cleaning until the max compaction lag has passed");
        Assertions.assertEquals((long)0L, (long)readBytesPerSec.count(), (String)"log cleaner should have read 0 bytes");
        Assertions.assertEquals((long)0L, (long)writeBytesPerSec.count(), (String)"log cleaner should have written 0 bytes");
        Assertions.assertEquals((double)0.0, (double)achievedCleaningRatio.mean(), (double)eps, (String)"achieved cleaning ratio should be 0");
        this.writeKeyDups(100, 1, log, CompressionType.NONE, this.time().milliseconds(), 0, 0);
        long expectedReadBytes = log.size();
        log.roll(log.roll$default$1(), log.roll$default$2());
        long blockCleanableSegmentOffset = activeSeg.baseOffset();
        this.time().sleep(maxCompactionLagMs);
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$13 = new TopicPartition("log", 0);
        long x$15 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$13, blockCleanableSegmentOffset, x$15);
        Assertions.assertEquals((long)expectedReadBytes, (long)readBytesPerSec.count(), (String)new StringBuilder(35).append("log cleaner should have read ").append(expectedReadBytes).append(" bytes").toString());
        Assertions.assertEquals((long)log.size(), (long)writeBytesPerSec.count(), (String)new StringBuilder(8).append("a ").append(log.size()).append(" bytes").toString());
        Assertions.assertEquals((double)100.0, (double)achievedCleaningRatio.mean(), (double)eps, (String)"achieved cleaning ratio should be 0");
        Meter readBytesPerSecForLocal = this.getMeter("CompactionThroughputBytesPerSec", "op.read");
        Meter writeBytesPerSecForLocal = this.getMeter("CompactionThroughputBytesPerSec", "op.write");
        Assertions.assertEquals((long)readBytesPerSec.count(), (long)readBytesPerSecForLocal.count());
        Assertions.assertEquals((long)writeBytesPerSec.count(), (long)writeBytesPerSecForLocal.count());
        log.size();
        this.writeKeyDups(75, 1, log, CompressionType.NONE, this.time().milliseconds(), 0, 1);
        activeSeg = log.activeSegment();
        log.roll(log.roll$default$1(), log.roll$default$2());
        blockCleanableSegmentOffset = activeSeg.baseOffset();
        this.time().sleep(maxCompactionLagMs * 2);
        LogCleaner qual$2 = this.cleaner();
        TopicPartition x$16 = new TopicPartition("log", 0);
        long x$18 = qual$2.awaitCleaned$default$3();
        qual$2.awaitCleaned(x$16, blockCleanableSegmentOffset, x$18);
        Assertions.assertTrue((achievedCleaningRatio.mean() < (double)100 ? 1 : 0) != 0, (String)"achieved cleaning ratio should be less than 100");
    }

    private Iterable<Tuple2<Object, Object>> readFromLog(AbstractLog log) {
        return (Iterable)log.localLogSegments().flatMap((Function1 & Serializable)segment -> (Iterable)CollectionConverters$.MODULE$.IterableHasAsScala(segment.log().records()).asScala().map((Function1 & Serializable)record -> {
            int key = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2())));
            int value = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2())));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)BoxesRunTime.boxToInteger((int)value));
        }));
    }

    private Seq<Tuple2<Object, Object>> writeKeyDups(int numKeys, int numDups, AbstractLog log, CompressionType codec, long timestamp, int startValue, int step) {
        IntRef valCounter = IntRef.create((int)startValue);
        return (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable)x$5 -> LogCleanerIntegrationTest.$anonfun$writeKeyDups$1(numKeys, valCounter, log, codec, timestamp, step, BoxesRunTime.unboxToInt((Object)x$5)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIsThreadFailed() {
        String metricName = "DeadThreadCount";
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        long x$62 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        int x$12 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, 100L, 100000, x$62, x$7, x$8, x$9, x$10, x$11, x$12));
        this.cleaner().startup();
        Assertions.assertEquals((int)0, (int)this.cleaner().deadThreadCount());
        this.cleaner().cleaners().foreach((Function1 & Serializable)x$6 -> {
            x$6.interrupt();
            return BoxedUnit.UNIT;
        });
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testIsThreadFailed$2(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Threads didn't terminate unexpectedly");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)this.cleaner().cleaners().size(), (int)BoxesRunTime.unboxToInt((Object)this.getGauge(metricName).value()));
        Assertions.assertEquals((int)this.cleaner().cleaners().size(), (int)this.cleaner().deadThreadCount());
    }

    private final void breakPartitionLog$1(TopicPartition tp) {
        AbstractLog log = (AbstractLog)this.cleaner().logs().get((Object)tp);
        this.writeDups(20, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
        File partitionFile = log.activeSegment().log().file();
        PrintWriter writer = new PrintWriter(partitionFile);
        writer.write("jogeajgoea");
        writer.close();
        this.writeDups(20, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$1(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$2(Tuple2 x$1) {
        if (x$1 != null) {
            AbstractLog log = (AbstractLog)x$1._2();
            ((MergedLog)log).computeLogSizeDetails().cancel(true);
            ((MergedLog)log).updateSizeDetails();
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$3(Gauge uncleanablePartitionsCountGauge$1) {
        return BoxesRunTime.unboxToInt((Object)uncleanablePartitionsCountGauge$1.value()) == 2;
    }

    public static final /* synthetic */ String $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$4() {
        return "There should be 2 uncleanable partitions";
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$5(Gauge uncleanableBytesGauge$1, long expectedTotalUncleanableBytes$1) {
        return BoxesRunTime.unboxToLong((Object)uncleanableBytesGauge$1.value()) == expectedTotalUncleanableBytes$1;
    }

    public static final /* synthetic */ String $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$6(long expectedTotalUncleanableBytes$1) {
        return new StringBuilder(34).append("There should be ").append(expectedTotalUncleanableBytes$1).append(" uncleanable bytes").toString();
    }

    public static final /* synthetic */ long $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$7(Tuple2 x$2) {
        return ((AbstractLog)x$2._2()).size();
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$8(LogCleanerIntegrationTest $this, Gauge uncleanablePartitionsCountGauge$1) {
        $this.time().sleep(1000L);
        return BoxesRunTime.unboxToInt((Object)uncleanablePartitionsCountGauge$1.value()) == 1;
    }

    public static final /* synthetic */ String $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$9() {
        return "There should be 1 uncleanable partitions";
    }

    public static final /* synthetic */ long $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$10(Tuple2 x$3) {
        return ((AbstractLog)x$3._2()).size();
    }

    public static final /* synthetic */ boolean $anonfun$getMetric$1(Function1 filter$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName k = (MetricName)x0$1._1();
            return BoxesRunTime.unboxToBoolean((Object)filter$1.apply((Object)k));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$1(String metricName$1, MetricName mName) {
        return mName.getName().endsWith(metricName$1) && mName.getScope() == null;
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$2(String metricName$2, String metricScope$1, MetricName k) {
        return k.getName().endsWith(metricName$2) && k.getScope().endsWith(metricScope$1);
    }

    public static final /* synthetic */ boolean $anonfun$getMeter$1(String metricName$3, String metricScope$2, MetricName k) {
        return k.getName().endsWith(metricName$3) && k.getScope().endsWith(metricScope$2);
    }

    public static final /* synthetic */ boolean $anonfun$getHistogram$1(String metricName$4, MetricName k) {
        return k.getName().endsWith(metricName$4) && k.getScope() == null;
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeKeyDups$2(IntRef valCounter$1, AbstractLog log$1, CompressionType codec$1, long timestamp$1, int step$1, int key) {
        int curValue = valCounter$1.elem;
        byte[] x$1 = Integer.toString(curValue).getBytes();
        byte[] x$3 = Integer.toString(key).getBytes();
        byte x$5 = 2;
        log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, x$3, codec$1, timestamp$1, x$5), 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4(), log$1.appendAsLeader$default$5());
        log$1.updateHighWatermark(log$1.logEndOffset());
        valCounter$1.elem += step$1;
        return new Tuple2.mcII.sp(key, curValue);
    }

    public static final /* synthetic */ IterableOnce $anonfun$writeKeyDups$1(int numKeys$1, IntRef valCounter$1, AbstractLog log$1, CompressionType codec$1, long timestamp$1, int step$1, int x$5) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numKeys$1).map((Function1 & Serializable)key -> LogCleanerIntegrationTest.$anonfun$writeKeyDups$2(valCounter$1, log$1, codec$1, timestamp$1, step$1, BoxesRunTime.unboxToInt((Object)key)));
    }

    public static final /* synthetic */ boolean $anonfun$testIsThreadFailed$3(boolean result, LogCleaner.CleanerThread thread) {
        return thread.isThreadFailed() && result;
    }

    public static final /* synthetic */ boolean $anonfun$testIsThreadFailed$2(LogCleanerIntegrationTest $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.cleaner().cleaners().foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable)(result, thread) -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$testIsThreadFailed$3(BoxesRunTime.unboxToBoolean((Object)result), thread))));
    }

    public static final /* synthetic */ String $anonfun$testIsThreadFailed$4() {
        return "Threads didn't terminate unexpectedly";
    }
}

