/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.Serializable;
import java.util.Properties;
import kafka.link.ClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkConfigDefaults$;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.SetOps;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\u0005Eb\u0001\u0002\u0007\u000e\u0001IAQa\u0006\u0001\u0005\u0002aAQA\u0007\u0001\u0005\u0002mAQa\u0014\u0001\u0005\u0002ACQA\u0016\u0001\u0005\u0002]CQ!\u0018\u0001\u0005\u0002yCQ\u0001\u001a\u0001\u0005\u0002\u0015DQa\u001b\u0001\u0005\u00021DQA\u001d\u0001\u0005\u0002MDq!!\u0002\u0001\t\u0003\t9\u0001C\u0004\u0002\u0014\u0001!\t!!\u0006\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002$\t\u00113k\\;sG\u0016Le.\u001b;jCR,G\rT5oW&sG/Z4sCRLwN\u001c+fgRT!AD\b\u0002\t1Lgn\u001b\u0006\u0002!\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0014!\t!R#D\u0001\u000e\u0013\t1RB\u0001\u000eDYV\u001cH/\u001a:MS:\\\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u00023A\u0011A\u0003A\u0001+i\u0016\u001cHoQ8oiJ|G\u000e\\3s\u0007\"\fgnZ3XSRD'+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8t)\ra\"e\f\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0005+:LG\u000fC\u0003$\u0005\u0001\u0007A%\u0001\u0004rk>\u0014X/\u001c\t\u0003K1r!A\n\u0016\u0011\u0005\u001drR\"\u0001\u0015\u000b\u0005%\n\u0012A\u0002\u001fs_>$h(\u0003\u0002,=\u00051\u0001K]3eK\u001aL!!\f\u0018\u0003\rM#(/\u001b8h\u0015\tYc\u0004C\u00031\u0005\u0001\u0007\u0011'A\u0006d_>\u0014H-\u001b8bi>\u0014\bCA\u000f3\u0013\t\u0019dDA\u0004C_>dW-\u00198)\t\t)4\t\u0012\t\u0003m\u0005k\u0011a\u000e\u0006\u0003qe\n\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0003um\na\u0001]1sC6\u001c(B\u0001\u001f>\u0003\u001dQW\u000f]5uKJT!AP \u0002\u000b),h.\u001b;\u000b\u0003\u0001\u000b1a\u001c:h\u0013\t\u0011uG\u0001\u0007NKRDw\u000eZ*pkJ\u001cW-A\u0003wC2,X\rL\u0001FC\u00051\u0015aD1mY\u000e{WNY5oCRLwN\\:)\t\tAE*\u0014\t\u0003\u0013*k\u0011!O\u0005\u0003\u0017f\u0012\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u00039\u000b\u0001f\u001f3jgBd\u0017-\u001f(b[\u0016lh&];peVlWh\u001f\u0019~]\r|wN\u001d3j]\u0006$xN]\u001f|cu\f\u0001\u0004^3tiR{\u0007/[2D_:4\u0017nZ*z]\u000e\u0014V\u000f\\3t)\ra\u0012K\u0015\u0005\u0006G\r\u0001\r\u0001\n\u0005\u0006a\r\u0001\r!\r\u0015\u0005\u0007U\u001aE\u000bL\u0001FQ\u0011\u0019\u0001\nT'\u00021Q,7\u000f^*pkJ\u001cWm\u00117vgR,'OU3ti\u0006\u0014H\u000fF\u0002\u001d1fCQa\t\u0003A\u0002\u0011BQ\u0001\r\u0003A\u0002EBC\u0001B\u001bD72\nQ\t\u000b\u0003\u0005\u00112k\u0015\u0001\u0007;fgR$Um\u001d;D_:$(o\u001c7mKJ\u001c\u0005.\u00198hKR\u0019Ad\u00181\t\u000b\r*\u0001\u0019\u0001\u0013\t\u000bA*\u0001\u0019A\u0019)\t\u0015)4I\u0019\u0017\u0002\u000b\"\"Q\u0001\u0013'N\u0003e!Xm\u001d;M_\u000e\fG\u000eT5ti\u0016tWM](wKJ\u0014\u0018\u000eZ3\u0015\u0007q1w\rC\u0003$\r\u0001\u0007A\u0005C\u00031\r\u0001\u0007\u0011\u0007\u000b\u0003\u0007k\rKG&A#)\t\u0019AE*T\u0001)i\u0016\u001cH\u000fT5oWZ\u000bG.\u001b3bi&|gNR1jYV\u0014Xm\u00148T_V\u00148-Z\"mkN$XM\u001d\u000b\u000495t\u0007\"B\u0012\b\u0001\u0004!\u0003\"\u0002\u0019\b\u0001\u0004\t\u0004\u0006B\u00046\u0007Bd\u0013!\u0012\u0015\u0005\u000f!cU*\u0001\ruKN$H)\u001a7fi\u0016\u001cv.\u001e:dKNKG-\u001a'j].$2\u0001\b;v\u0011\u0015\u0019\u0003\u00021\u0001%\u0011\u0015\u0001\u0004\u00021\u00012Q\u0011AqoQ?\u0011\u0005a\\X\"A=\u000b\u0005i\\\u0014aA1qS&\u0011A0\u001f\u0002\t\t&\u001c\u0018M\u00197fI\u0006\na0A\fL\u000f2{%)\u0011'.c]\"$\u0007\t$mC.L\b\u0005^3ti\"*\u0001\"N\"\u0002\u00021\nQ\t\u000b\u0003\t\u00112k\u0015\u0001\t;fgR$Um]2sS\n,7k\\;sG\u0016\u001c\u0016\u000eZ3MS:\\7i\u001c8gS\u001e$R\u0001HA\u0005\u0003\u0017AQaI\u0005A\u0002\u0011BQ\u0001M\u0005A\u0002EBS!C\u001bD\u0003\u001fa\u0013!\u0012\u0015\u0005\u0013!cU*A\u0017uKN$8k\\;sG\u0016\u001c\u0016\u000eZ3MS:\\WK\\1wC&d\u0017M\u00197f-\u0006\u0014\u0018n\\;t'\u000e,g.\u0019:j_N$R\u0001HA\f\u00033AQa\t\u0006A\u0002\u0011BQ\u0001\r\u0006A\u0002EBSAC\u001bD\u0003;a\u0013!\u0012\u0015\u0005\u0015!cU*\u0001\nsKN$\u0018M\u001d;EKN$(I]8lKJ\u001cH#\u0001\u000f)\r\u0001\t9cQA\u0017!\rA\u0018\u0011F\u0005\u0004\u0003WI(a\u0001+bO\u0006\u0012\u0011qF\u0001\fS:$Xm\u001a:bi&|g\u000e")
public class SourceInitiatedLinkIntegrationTest
extends ClusterLinkIntegrationTest {
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testControllerChangeWithReverseConnections(String quorum, boolean coordinator) {
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        this.produceToSourceCluster(10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyReverseConnectionMetrics(this.linkName(), this.sourceLinkMode(), this.destinationLinkMode(), this.sourceCluster(), this.destCluster());
        KafkaBroker destCoordinator = this.destCluster().linkCoordinator(this.linkName());
        this.destCluster().killBroker(this.destCluster().brokers().indexOf((Object)destCoordinator));
        this.produceToSourceCluster(10);
        this.waitForMirror((Seq<KafkaBroker>)this.destCluster().aliveServers(), this.waitForMirror$default$2());
        KafkaBroker sourceCoordinator = this.sourceCluster().linkCoordinator(this.linkName());
        this.sourceCluster().killBroker(this.sourceCluster().brokers().indexOf((Object)sourceCoordinator));
        this.produceToSourceCluster(10);
        this.waitForMirror((Seq<KafkaBroker>)this.destCluster().aliveServers(), this.waitForMirror$default$2());
        this.verifyReverseConnectionMetrics(this.linkName(), this.sourceLinkMode(), this.destinationLinkMode(), this.sourceCluster(), this.destCluster());
        String x$12 = this.topic();
        scala.collection.immutable.Seq<KafkaBroker> x$13 = this.destCluster().aliveServers();
        boolean x$15 = this.verifyMirror$default$3();
        this.verifyMirror(x$12, (Seq<KafkaBroker>)x$13, x$15, false);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testTopicConfigSyncRules(String quorum, boolean coordinator) {
        String topicConfigSyncIncludeOverride = ((SetOps)CollectionConverters$.MODULE$.ListHasAsScala(ClusterLinkConfigDefaults$.MODULE$.TopicConfigSyncIncludeDefault()).asScala().toSet().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"min.compaction.lag.ms", "compression.type"})))).$minus$minus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"max.compaction.lag.ms"}))).mkString(",");
        Map linkConfigsToUpdate = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp()), (Object)topicConfigSyncIncludeOverride), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicConfigSyncMsProp()), (Object)"100")}));
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = new Properties(null){
            {
                this.put("min.compaction.lag.ms", "142857");
                this.put("compression.type", "snappy");
            }
        };
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.linkName();
        scala.collection.immutable.Seq<KafkaBroker> x$9 = qual$2.alterClusterLink$default$3();
        Set<String> x$10 = qual$2.alterClusterLink$default$4();
        boolean x$11 = qual$2.alterClusterLink$default$5();
        qual$2.alterClusterLink(x$7, (Map<String, String>)linkConfigsToUpdate, x$9, x$10, x$11);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = this.topic();
        short x$13 = this.replicationFactor();
        String x$14 = this.linkName();
        Map<String, String> x$15 = qual$3.linkTopic$default$4();
        String x$16 = qual$3.linkTopic$default$5();
        qual$3.linkTopic(x$12, x$13, x$14, x$15, x$16);
        this.produceToSourceCluster(10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyReverseConnectionMetrics(this.linkName(), this.sourceLinkMode(), this.destinationLinkMode(), this.sourceCluster(), this.destCluster());
        Map expect = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min.compaction.lag.ms"), (Object)"142857"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compression.type"), (Object)"snappy"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max.compaction.lag.ms"), (Object)Long.toString(Long.MAX_VALUE))}));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!SourceInitiatedLinkIntegrationTest.$anonfun$testTopicConfigSyncRules$1(this, expect)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"min.compaction.lag.ms, compression.type should sync, max.compaction.lag.ms shouldn't sync");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testSourceClusterRestart(String quorum, boolean coordinator) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, 2, x$4, x$5, x$6);
        this.produceToSourceCluster(100);
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, (short)2, x$9, x$10, x$11);
        this.shutdownSource$1();
        this.restartSource$1();
        this.destCluster().deleteTopic(this.topic(), true);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = this.topic();
        String x$14 = this.linkName();
        Map<String, String> x$15 = qual$3.linkTopic$default$4();
        String x$16 = qual$3.linkTopic$default$5();
        qual$3.linkTopic(x$12, (short)2, x$14, x$15, x$16);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testDestControllerChange(String quorum, boolean coordinator) {
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.destCluster().changeController();
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        this.produceToSourceCluster(10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testLocalListenerOverride(String quorum, boolean coordinator) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$12 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$12, x$2, x$3, x$4, x$5, x$6);
        this.produceToSourceCluster(20);
        Properties sourceProps = (Properties)this.sourceLinkProps(this.sourceLinkProps$default$1()).get();
        ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(sourceProps.stringPropertyNames()).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("local.")))).foreach((Function1 & Serializable)x$1 -> sourceProps.remove(x$1));
        sourceProps.setProperty(ClusterLinkConfig$.MODULE$.LocalListenerNameProp(), this.sourceCluster().interBrokerListenerName().value());
        sourceProps.setProperty(new StringBuilder(23).append("local.").append("security.protocol").toString(), this.sourceCluster().interBrokerSecurityProtocol().name);
        String x$7 = this.linkName();
        Some x$8 = new Some((Object)sourceProps);
        Properties x$9 = this.createClusterLink$default$2();
        boolean x$10 = this.createClusterLink$default$4();
        boolean x$11 = this.createClusterLink$default$5();
        this.createClusterLink(x$7, x$9, (Option<Properties>)x$8, x$10, x$11);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$122 = this.topic();
        short x$13 = this.replicationFactor();
        String x$14 = this.linkName();
        Map<String, String> x$15 = qual$2.linkTopic$default$4();
        String x$16 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$122, x$13, x$14, x$15, x$16);
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3(), this.verifyMirror$default$4());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testLinkValidationFailureOnSourceCluster(String quorum, boolean coordinator) {
        this.useBidirectionalLink_$eq(false);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        Properties sourceProps = (Properties)this.sourceLinkProps(this.sourceLinkProps$default$1()).get();
        sourceProps.setProperty(ClusterLinkConfig$.MODULE$.AclSyncEnableProp(), "true");
        sourceProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), "true");
        sourceProps.setProperty(ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp(), "true");
        sourceProps.setProperty(ClusterLinkConfig$.MODULE$.TopicFiltersProp(), this.topicFilter());
        String link2Name = "testLink2";
        String x$7 = this.linkName();
        Some x$8 = new Some((Object)sourceProps);
        Properties x$9 = this.createClusterLink$default$2();
        boolean x$10 = this.createClusterLink$default$4();
        boolean x$11 = this.createClusterLink$default$5();
        this.createClusterLink(x$7, x$9, (Option<Properties>)x$8, x$10, x$11);
        Some x$13 = new Some((Object)sourceProps);
        Properties x$14 = this.createClusterLink$default$2();
        boolean x$15 = this.createClusterLink$default$4();
        boolean x$16 = this.createClusterLink$default$5();
        this.createClusterLink(link2Name, x$14, (Option<Properties>)x$13, x$15, x$16);
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        String x$17 = this.linkName();
        Map x$18 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"false")}));
        scala.collection.immutable.Seq<KafkaBroker> x$19 = qual$2.alterClusterLink$default$3();
        Set<String> x$20 = qual$2.alterClusterLink$default$4();
        boolean x$21 = qual$2.alterClusterLink$default$5();
        qual$2.alterClusterLink(x$17, (Map<String, String>)x$18, x$19, x$20, x$21);
        ClusterLinkTestHarness qual$3 = this.sourceCluster();
        String x$22 = this.linkName();
        Map x$23 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"true")}));
        scala.collection.immutable.Seq<KafkaBroker> x$24 = qual$3.alterClusterLink$default$3();
        Set<String> x$25 = qual$3.alterClusterLink$default$4();
        boolean x$26 = qual$3.alterClusterLink$default$5();
        qual$3.alterClusterLink(x$22, (Map<String, String>)x$23, x$24, x$25, x$26);
        ClusterLinkTestHarness qual$4 = this.sourceCluster();
        String x$27 = this.linkName();
        Map x$28 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"false")}));
        scala.collection.immutable.Seq<KafkaBroker> x$29 = qual$4.alterClusterLink$default$3();
        Set<String> x$30 = qual$4.alterClusterLink$default$4();
        boolean x$31 = qual$4.alterClusterLink$default$5();
        qual$4.alterClusterLink(x$27, (Map<String, String>)x$28, x$29, x$30, x$31);
        ClusterLinkTestHarness qual$5 = this.sourceCluster();
        String x$32 = this.linkName();
        Map x$33 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true")}));
        scala.collection.immutable.Seq<KafkaBroker> x$34 = qual$5.alterClusterLink$default$3();
        Set<String> x$35 = qual$5.alterClusterLink$default$4();
        boolean x$36 = qual$5.alterClusterLink$default$5();
        qual$5.alterClusterLink(x$32, (Map<String, String>)x$33, x$34, x$35, x$36);
        ClusterLinkTestHarness qual$6 = this.sourceCluster();
        String x$37 = this.linkName();
        Map x$38 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()), (Object)"false")}));
        scala.collection.immutable.Seq<KafkaBroker> x$39 = qual$6.alterClusterLink$default$3();
        Set<String> x$40 = qual$6.alterClusterLink$default$4();
        boolean x$41 = qual$6.alterClusterLink$default$5();
        qual$6.alterClusterLink(x$37, (Map<String, String>)x$38, x$39, x$40, x$41);
        ClusterLinkTestHarness qual$7 = this.sourceCluster();
        String x$42 = this.linkName();
        Map x$43 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()), (Object)"true")}));
        scala.collection.immutable.Seq<KafkaBroker> x$44 = qual$7.alterClusterLink$default$3();
        Set<String> x$45 = qual$7.alterClusterLink$default$4();
        boolean x$46 = qual$7.alterClusterLink$default$5();
        qual$7.alterClusterLink(x$42, (Map<String, String>)x$43, x$44, x$45, x$46);
        ClusterLinkTestHarness qual$8 = this.sourceCluster();
        Map x$48 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"false")}));
        scala.collection.immutable.Seq<KafkaBroker> x$49 = qual$8.alterClusterLink$default$3();
        Set<String> x$50 = qual$8.alterClusterLink$default$4();
        boolean x$51 = qual$8.alterClusterLink$default$5();
        qual$8.alterClusterLink(link2Name, (Map<String, String>)x$48, x$49, x$50, x$51);
        ClusterLinkTestHarness qual$9 = this.sourceCluster();
        Map x$53 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"true")}));
        scala.collection.immutable.Seq<KafkaBroker> x$54 = qual$9.alterClusterLink$default$3();
        Set<String> x$55 = qual$9.alterClusterLink$default$4();
        boolean x$56 = qual$9.alterClusterLink$default$5();
        qual$9.alterClusterLink(link2Name, (Map<String, String>)x$53, x$54, x$55, x$56);
        ClusterLinkTestHarness qual$10 = this.sourceCluster();
        Map x$58 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"false")}));
        scala.collection.immutable.Seq<KafkaBroker> x$59 = qual$10.alterClusterLink$default$3();
        Set<String> x$60 = qual$10.alterClusterLink$default$4();
        boolean x$61 = qual$10.alterClusterLink$default$5();
        qual$10.alterClusterLink(link2Name, (Map<String, String>)x$58, x$59, x$60, x$61);
        ClusterLinkTestHarness qual$11 = this.sourceCluster();
        Map x$63 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true")}));
        scala.collection.immutable.Seq<KafkaBroker> x$64 = qual$11.alterClusterLink$default$3();
        Set<String> x$65 = qual$11.alterClusterLink$default$4();
        boolean x$66 = qual$11.alterClusterLink$default$5();
        qual$11.alterClusterLink(link2Name, (Map<String, String>)x$63, x$64, x$65, x$66);
        ClusterLinkTestHarness qual$12 = this.sourceCluster();
        Map x$68 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()), (Object)"false")}));
        scala.collection.immutable.Seq<KafkaBroker> x$69 = qual$12.alterClusterLink$default$3();
        Set<String> x$70 = qual$12.alterClusterLink$default$4();
        boolean x$71 = qual$12.alterClusterLink$default$5();
        qual$12.alterClusterLink(link2Name, (Map<String, String>)x$68, x$69, x$70, x$71);
        ClusterLinkTestHarness qual$13 = this.sourceCluster();
        Map x$73 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()), (Object)"true")}));
        scala.collection.immutable.Seq<KafkaBroker> x$74 = qual$13.alterClusterLink$default$3();
        Set<String> x$75 = qual$13.alterClusterLink$default$4();
        boolean x$76 = qual$13.alterClusterLink$default$5();
        qual$13.alterClusterLink(link2Name, (Map<String, String>)x$73, x$74, x$75, x$76);
        ClusterLinkTestHarness qual$14 = this.destCluster();
        boolean x$77 = qual$14.listClusterLinks$default$1();
        Option<String> x$78 = qual$14.listClusterLinks$default$2();
        qual$14.listClusterLinks(x$77, x$78).foreach((Function1 & Serializable)link -> {
            SourceInitiatedLinkIntegrationTest.$anonfun$testLinkValidationFailureOnSourceCluster$1(link);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    @Disabled(value="KGLOBAL-1742 Flaky test")
    public void testDeleteSourceSideLink(String quorum, boolean coordinator) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.produceToSourceCluster(20);
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        scala.collection.immutable.Map offsetsByPartition = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions()).map((Function1 & Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))), (Object)BoxesRunTime.boxToLong((long)this.nextOffset(BoxesRunTime.unboxToInt((Object)i))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        ClusterLinkTestHarness qual$3 = this.sourceCluster();
        String x$12 = this.linkName();
        boolean x$13 = qual$3.deleteClusterLink$default$2();
        scala.collection.immutable.Seq<KafkaBroker> x$14 = qual$3.deleteClusterLink$default$3();
        qual$3.deleteClusterLink(x$12, x$13, x$14);
        this.produceToSourceCluster(10);
        Thread.sleep(1000L);
        this.verifyMirrorOffsets((Map<Object, Object>)offsetsByPartition);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testDescribeSourceSideLinkConfig(String quorum, boolean coordinator) {
        Map sourcePropOverrides = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.credential"), (Object)"secret"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"local.custom.credential"), (Object)"secret")}));
        String x$1 = this.linkName();
        Option<Properties> x$2 = this.sourceLinkProps((Map<String, String>)sourcePropOverrides);
        Properties x$3 = this.createClusterLink$default$2();
        boolean x$4 = this.createClusterLink$default$4();
        boolean x$5 = this.createClusterLink$default$5();
        this.createClusterLink(x$1, x$3, x$2, x$4, x$5);
        Config linkConfig = this.sourceCluster().describeClusterLink(this.linkName());
        ((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sasl.jaas.config", "ssl.keystore.password", "ssl.key.password", "ssl.keystore.key", "ssl.keystore.certificate.chain", "ssl.truststore.certificates", "ssl.truststore.password", "custom.credential"}))).foreach((Function1 & Serializable)config -> {
            SourceInitiatedLinkIntegrationTest.$anonfun$testDescribeSourceSideLinkConfig$1(linkConfig, config);
            return BoxedUnit.UNIT;
        });
        new .colon.colon((Object)"ssl.truststore.type", (List)new .colon.colon((Object)"security.protocol", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)config -> {
            SourceInitiatedLinkIntegrationTest.$anonfun$testDescribeSourceSideLinkConfig$2(linkConfig, config);
            return BoxedUnit.UNIT;
        });
        linkConfig.entries().forEach(entry -> {
            if (ClusterLinkConfig$.MODULE$.configKeys().get((Object)entry.name()).forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SourceInitiatedLinkIntegrationTest.$anonfun$testDescribeSourceSideLinkConfig$4(x$2)))) {
                SourceInitiatedLinkIntegrationTest.verifySensitive$1(entry.name(), linkConfig);
                return;
            }
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testSourceSideLinkUnavailableVariousScenarios(String quorum, boolean coordinator) {
        Properties sourceProps = (Properties)this.sourceLinkProps(this.sourceLinkProps$default$1()).get();
        sourceProps.setProperty("metadata.max.age.ms", "100");
        sourceProps.setProperty("request.timeout.ms", "1000");
        sourceProps.setProperty("default.api.timeout.ms", "1000");
        sourceProps.setProperty(ClusterLinkConfig$.MODULE$.ReverseConnectionSetupTimeoutMsProp(), "1000");
        sourceProps.setProperty(ClusterLinkConfig$.MODULE$.RetryTimeoutMsProp(), "1000");
        sourceProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp(), "100");
        sourceProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckConsecutiveFailureThresholdProp(), "1");
        Assumptions.assumeFalse((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())));
        String x$1 = this.linkName();
        Some x$2 = new Some((Object)sourceProps);
        Properties x$3 = this.createClusterLink$default$2();
        boolean x$4 = this.createClusterLink$default$4();
        boolean x$5 = this.createClusterLink$default$5();
        this.createClusterLink(x$1, x$3, (Option<Properties>)x$2, x$4, x$5);
        this.waitForLinkStateOnDest(this.linkName(), ClusterLinkDescription.LinkState.ACTIVE, this.waitForLinkStateOnDest$default$3());
        this.waitForLinkStateOnSource(this.linkName(), ClusterLinkDescription.LinkState.ACTIVE, this.waitForLinkStateOnSource$default$3());
        this.verifyListAndDescribeBehaviorOnDest(ClusterLinkError.NO_ERROR);
        this.verifyListAndDescribeBehaviorOnSource(ClusterLinkError.NO_ERROR);
        String validCreds = sourceProps.getProperty("sasl.jaas.config");
        String invalidCreds = this.generateInvalidCredentials(this.destCluster());
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$6 = this.linkName();
        Map x$7 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)invalidCreds)}));
        scala.collection.immutable.Seq<KafkaBroker> x$8 = qual$1.alterClusterLink$default$3();
        Set<String> x$9 = qual$1.alterClusterLink$default$4();
        boolean x$10 = qual$1.alterClusterLink$default$5();
        qual$1.alterClusterLink(x$6, (Map<String, String>)x$7, x$8, x$9, x$10);
        this.waitForLinkStateOnSource(this.linkName(), ClusterLinkDescription.LinkState.UNAVAILABLE, this.waitForLinkStateOnSource$default$3());
        this.verifyListAndDescribeBehaviorOnSource(ClusterLinkError.AUTHENTICATION_ERROR);
        this.waitForUnavailableLinkCountMetric(this.sourceLinkMode(), "authentication", this.sourceCluster());
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        String x$11 = this.linkName();
        Map x$12 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)validCreds)}));
        scala.collection.immutable.Seq<KafkaBroker> x$13 = qual$2.alterClusterLink$default$3();
        Set<String> x$14 = qual$2.alterClusterLink$default$4();
        boolean x$15 = qual$2.alterClusterLink$default$5();
        qual$2.alterClusterLink(x$11, (Map<String, String>)x$12, x$13, x$14, x$15);
        this.waitForLinkStateOnSource(this.linkName(), ClusterLinkDescription.LinkState.ACTIVE, this.waitForLinkStateOnSource$default$3());
        this.verifyListAndDescribeBehaviorOnSource(ClusterLinkError.NO_ERROR);
        this.destCluster().killAllBrokers();
        this.waitForLinkStateOnSource(this.linkName(), ClusterLinkDescription.LinkState.UNAVAILABLE, this.waitForLinkStateOnSource$default$3());
        this.verifyListAndDescribeBehaviorOnSource(ClusterLinkError.BOOTSTRAP_TCP_CONNECTION_FAILED_ERROR);
        this.waitForUnavailableLinkCountMetric(this.sourceLinkMode(), "bootstrap_tcp_connection_failed", this.sourceCluster());
        this.restartDestBrokers();
        this.waitForLinkStateOnSource(this.linkName(), ClusterLinkDescription.LinkState.ACTIVE, this.waitForLinkStateOnSource$default$3());
        this.verifyListAndDescribeBehaviorOnSource(ClusterLinkError.NO_ERROR);
    }

    public void restartDestBrokers() {
        ClusterLinkTestHarness qual$1 = this.destCluster();
        boolean x$1 = qual$1.restartDeadBrokers$default$1();
        qual$1.restartDeadBrokers(x$1);
        this.destCluster().updateBootstrapServers();
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        String x$3 = this.linkName();
        Object[] objectArray = new Tuple2[1];
        ClusterLinkTestHarness qual$3 = this.destCluster();
        ListenerName x$2 = qual$3.bootstrapServers$default$1();
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)qual$3.bootstrapServers(x$2));
        Map x$4 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        scala.collection.immutable.Seq<KafkaBroker> x$5 = qual$2.alterClusterLink$default$3();
        Set<String> x$6 = qual$2.alterClusterLink$default$4();
        boolean x$7 = qual$2.alterClusterLink$default$5();
        qual$2.alterClusterLink(x$3, (Map<String, String>)x$4, x$5, x$6, x$7);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicConfigSyncRules$1(SourceInitiatedLinkIntegrationTest $this, Map expect$1) {
        return $this.destCluster().describeTopicConfigEquals($this.topic(), (Map<String, String>)expect$1);
    }

    public static final /* synthetic */ String $anonfun$testTopicConfigSyncRules$2() {
        return "min.compaction.lag.ms, compression.type should sync, max.compaction.lag.ms shouldn't sync";
    }

    private final void shutdownSource$1() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.sourceCluster().brokers().length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.sourceCluster().killBroker(i - this.sourceCluster().firstBrokerId()));
    }

    private final void restartSource$1() {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        boolean x$1 = qual$1.restartDeadBrokers$default$1();
        qual$1.restartDeadBrokers(x$1);
        this.sourceCluster().updateBootstrapServers();
    }

    public static final /* synthetic */ void $anonfun$testLinkValidationFailureOnSourceCluster$1(ClusterLinkListing link) {
        Assertions.assertTrue((boolean)link.available());
    }

    private static final void verifySensitive$1(String configName, Config linkConfig$1) {
        ConfigEntry configEntry = linkConfig$1.get(configName);
        Assertions.assertNotNull((Object)configEntry, (String)new StringBuilder(17).append("Config not found ").append(configName).toString());
        Assertions.assertNull((Object)configEntry.value(), (String)new StringBuilder(26).append("Sensitive config ").append(configName).append(" returned").toString());
        Assertions.assertTrue((boolean)configEntry.isSensitive(), (String)new StringBuilder(41).append("Sensitive config ").append(configName).append(" not marked as sensitive").toString());
    }

    private static final void verifyNotSensitive$1(String configName, Config linkConfig$1) {
        ConfigEntry configEntry = linkConfig$1.get(configName);
        Assertions.assertNotNull((Object)configEntry, (String)new StringBuilder(17).append("Config not found ").append(configName).toString());
        Assertions.assertNotNull((Object)configEntry.value(), (String)new StringBuilder(48).append("Config ").append(configName).append(" returned null, even though not sensitive").toString());
        Assertions.assertFalse((boolean)configEntry.isSensitive(), (String)new StringBuilder(36).append("Config ").append(configName).append(" marked sensitive incorrectly").toString());
    }

    public static final /* synthetic */ void $anonfun$testDescribeSourceSideLinkConfig$1(Config linkConfig$1, String config) {
        SourceInitiatedLinkIntegrationTest.verifySensitive$1(config, linkConfig$1);
        SourceInitiatedLinkIntegrationTest.verifySensitive$1(new StringBuilder(0).append(ClusterLinkConfig$.MODULE$.LocalPrefix()).append(config).toString(), linkConfig$1);
    }

    public static final /* synthetic */ void $anonfun$testDescribeSourceSideLinkConfig$2(Config linkConfig$1, String config) {
        SourceInitiatedLinkIntegrationTest.verifyNotSensitive$1(config, linkConfig$1);
        SourceInitiatedLinkIntegrationTest.verifyNotSensitive$1(new StringBuilder(0).append(ClusterLinkConfig$.MODULE$.LocalPrefix()).append(config).toString(), linkConfig$1);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeSourceSideLinkConfig$4(ConfigDef.ConfigKey x$2) {
        ConfigDef.Type type = x$2.type;
        ConfigDef.Type type2 = ConfigDef.Type.PASSWORD;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    public SourceInitiatedLinkIntegrationTest() {
        this.useSourceInitiatedLink_$eq(true);
        this.sourceCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_SSL, (Option<SecurityProtocol>)new Some((Object)SecurityProtocol.PLAINTEXT), 0, 2));
        this.destCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_PLAINTEXT, (Option<SecurityProtocol>)new Some((Object)SecurityProtocol.PLAINTEXT), 100, 2));
    }
}

