/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.Serializable;
import java.util.Properties;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.tier.state.TierPartitionState;
import kafka.utils.TestInfoUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\u0005Md\u0001\u0002\b\u0010\u0001QAQ!\u0007\u0001\u0005\u0002iA\u0011\u0002\b\u0001A\u0002\u0003\u0005\u000b\u0015B\u000f\t\u000b%\u0002A\u0011\t\u0016\t\u000b]\u0002A\u0011\u0001\u001d\t\u000b\u0001\u0004A\u0011A1\t\u000b\u001d\u0004A\u0011\u00025\t\u000bU\u0004A\u0011\u0002<\t\u000b)\u0004A\u0011\u0002@\t\u000b}\u0004A\u0011\u0002@\t\u000f\u0005\u0005\u0001\u0001\"\u0003\u0002\u0004!9\u0011\u0011\u0006\u0001\u0005\n\u0005-\u0002bBA&\u0001\u0011%\u0011Q\n\u0005\b\u0003#\u0002A\u0011BA*\u0005y\u0019E.^:uKJd\u0015N\\6US\u0016\u0014\u0018J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u0002\u0011#\u0005!A.\u001b8l\u0015\u0005\u0011\u0012!B6bM.\f7\u0001A\n\u0003\u0001U\u0001\"AF\f\u000e\u0003=I!\u0001G\b\u0003E\u0005\u00137\u000f\u001e:bGR\u001cE.^:uKJd\u0015N\\6J]R,wM]1uS>tG+Z:u\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u0017\u0001\u0005Iq\f^3ti&sgm\u001c\t\u0003=\u001dj\u0011a\b\u0006\u0003A\u0005\n1!\u00199j\u0015\t\u00113%A\u0004kkBLG/\u001a:\u000b\u0005\u0011*\u0013!\u00026v]&$(\"\u0001\u0014\u0002\u0007=\u0014x-\u0003\u0002)?\tAA+Z:u\u0013:4w.A\u0003tKR,\u0006\u000f\u0006\u0002,cA\u0011AfL\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\t!QK\\5u\u0011\u0015\u00114\u00011\u0001\u001e\u0003!!Xm\u001d;J]\u001a|\u0007FA\u00025!\tqR'\u0003\u00027?\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002OQ,7\u000f^'jeJ|'/\u001b8h/&$\b\u000eV5fe&tw-\u00128bE2,Gm\u00148T_V\u00148-\u001a\u000b\u0004We2\u0005\"\u0002\u001e\u0005\u0001\u0004Y\u0014AB9v_J,X\u000e\u0005\u0002=\u0007:\u0011Q(\u0011\t\u0003}5j\u0011a\u0010\u0006\u0003\u0001N\ta\u0001\u0010:p_Rt\u0014B\u0001\".\u0003\u0019\u0001&/\u001a3fM&\u0011A)\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\tk\u0003\"B$\u0005\u0001\u0004A\u0015aC2p_J$\u0017N\\1u_J\u0004\"\u0001L%\n\u0005)k#a\u0002\"p_2,\u0017M\u001c\u0015\u0005\t1#V\u000b\u0005\u0002N%6\taJ\u0003\u0002P!\u0006A\u0001O]8wS\u0012,'O\u0003\u0002RC\u00051\u0001/\u0019:b[NL!a\u0015(\u0003\u00195+G\u000f[8e'>,(oY3\u0002\u000bY\fG.^3-\u0003Y\u000b\u0013aV\u0001\u0010C2d7i\\7cS:\fG/[8og\"\"A!W/_!\tQ6,D\u0001Q\u0013\ta\u0006KA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fAA\\1nK\u0006\nq,\u0001\u0015|I&\u001c\b\u000f\\1z\u001d\u0006lW- \u0018rk>\u0014X/\\\u001f|aut3m\\8sI&t\u0017\r^8s{m\fT0\u0001\u0018uKN$X*\u001b:s_JLgnZ,ji\"$\u0016.\u001a:j]\u001e,e.\u00192mK\u0012|enU8ve\u000e,\u0017I\u001c3EKN$HcA\u0016cG\")!(\u0002a\u0001w!)q)\u0002a\u0001\u0011\"\"Q\u0001\u0014+fY\u00051\u0006\u0006B\u0003Z;z\u000b\u0011E^3sS\u001aLX*\u001b:s_JLgnZ,ji\"$\u0016.\u001a:j]\u001e,e.\u00192mK\u0012$2aK5t\u0011\u0015Qg\u00011\u0001l\u0003A\u0019x.\u001e:dKR{\u0007/[2Qe>\u00048\u000f\u0005\u0002mc6\tQN\u0003\u0002o_\u0006!Q\u000f^5m\u0015\u0005\u0001\u0018\u0001\u00026bm\u0006L!A]7\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0003u\r\u0001\u00071.\u0001\beKN$Hk\u001c9jGB\u0013x\u000e]:\u0002\u001b\u0015t\u0017M\u00197f)&,'/\u001b8h)\rYs\u000f \u0005\u0006q\u001e\u0001\r!_\u0001\bG2,8\u000f^3s!\t1\"0\u0003\u0002|\u001f\t12\t\\;ti\u0016\u0014H*\u001b8l)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003~\u000f\u0001\u00071(\u0001\u0004ck\u000e\\W\r^\u000b\u0002W\u0006IA/[3s!J|\u0007o]\u0001\u001caJ|G-^2f\u0003:$7+[7vY\u0006$XMU3uK:$\u0018n\u001c8\u0015\u0007-\n)\u0001C\u0004\u0002\b)\u0001\r!!\u0003\u0002\u0011A\u0014x\u000eZ;dKJ\u0004\u0002\"a\u0003\u0002\u001a\u0005u\u0011QD\u0007\u0003\u0003\u001bQA!a\u0002\u0002\u0010)!\u0011\u0011CA\n\u0003\u001d\u0019G.[3oiNT1AEA\u000b\u0015\r\t9\"J\u0001\u0007CB\f7\r[3\n\t\u0005m\u0011Q\u0002\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\u0011\u000b1\ny\"a\t\n\u0007\u0005\u0005RFA\u0003BeJ\f\u0017\u0010E\u0002-\u0003KI1!a\n.\u0005\u0011\u0011\u0015\u0010^3\u0002/]\f\u0017\u000e^+oi&d7+Z4nK:$8\u000fV5fe\u0016$G#B\u0016\u0002.\u0005=\u0002\"\u0002=\f\u0001\u0004I\bbBA\u0019\u0017\u0001\u0007\u00111G\u0001\u000f[&tg*^7TK\u001elWM\u001c;t!\u001da\u0014QGA\u001d\u0003\u000bJ1!a\u000eF\u0005\ri\u0015\r\u001d\t\u0005\u0003w\t\t%\u0004\u0002\u0002>)!\u0011qHA\n\u0003\u0019\u0019w.\\7p]&!\u00111IA\u001f\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u00042\u0001LA$\u0013\r\tI%\f\u0002\u0004\u0013:$\u0018!E:j[Vd\u0017\r^3SKR,g\u000e^5p]R\u00191&a\u0014\t\u000bad\u0001\u0019A=\u0002\u00131,\u0017\rZ3s\u0019><GCBA+\u0003C\n\u0019\u0007\u0005\u0003\u0002X\u0005uSBAA-\u0015\r\tY&E\u0001\u0004Y><\u0017\u0002BA0\u00033\u00121\"\u00112tiJ\f7\r\u001e'pO\")\u00010\u0004a\u0001s\"9\u0011QM\u0007A\u0002\u0005e\u0012A\u0001;qQ\u0019\u0001\u0011\u0011\u000e+\u0002pA\u0019a$a\u001b\n\u0007\u00055tDA\u0002UC\u001e\f#!!\u001d\u0002\u0017%tG/Z4sCRLwN\u001c")
public class ClusterLinkTierIntegrationTest
extends AbstractClusterLinkIntegrationTest {
    private TestInfo _testInfo;

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this._testInfo = testInfo;
        if (TestInfoUtils$.MODULE$.isKRaft(this._testInfo) && this.sourceCluster() == null && this.destCluster() == null) {
            None$ x$3 = None$.MODULE$;
            int x$4 = 2;
            this.sourceCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.PLAINTEXT, (Option<SecurityProtocol>)x$3, 0, x$4));
            None$ x$7 = None$.MODULE$;
            int x$8 = 2;
            this.destCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.PLAINTEXT, (Option<SecurityProtocol>)x$7, 100, x$8));
            return;
        }
        if (this.sourceCluster() == null && this.destCluster() == null) {
            None$ x$11 = None$.MODULE$;
            int x$12 = 2;
            this.sourceCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_SSL, (Option<SecurityProtocol>)x$11, 0, x$12));
            None$ x$15 = None$.MODULE$;
            int x$16 = 2;
            this.destCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_PLAINTEXT, (Option<SecurityProtocol>)x$15, 100, x$16));
            return;
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testMirroringWithTieringEnabledOnSource(String quorum, boolean coordinator) {
        this.enableTiering(this.sourceCluster(), "sourceBucket");
        super.setUp(this._testInfo);
        this.verifyMirroringWithTieringEnabled(this.sourceTopicProps(), new Properties());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testMirroringWithTieringEnabledOnSourceAndDest(String quorum, boolean coordinator) {
        this.enableTiering(this.sourceCluster(), "sourceBucket");
        this.enableTiering(this.destCluster(), "destBucket");
        super.setUp(this._testInfo);
        this.verifyMirroringWithTieringEnabled(this.sourceTopicProps(), this.tierProps());
    }

    private void verifyMirroringWithTieringEnabled(Properties sourceTopicProps, Properties destTopicProps) {
        this.numPartitions_$eq(2);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, sourceTopicProps, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        ByteArraySerializer x$7 = qual$2.createProducer$default$1();
        ByteArraySerializer x$8 = qual$2.createProducer$default$2();
        Properties x$9 = qual$2.createProducer$default$3();
        KafkaProducer producer = qual$2.createProducer(x$7, x$8, x$9);
        this.produceAndSimulateRetention(producer);
        this.consume(this.sourceCluster(), this.consume$default$2());
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$10 = this.linkName();
        ClusterLinkTestHarness x$11 = this.sourceCluster();
        long x$12 = qual$3.createDestClusterLink$default$3();
        long x$13 = qual$3.createDestClusterLink$default$4();
        long x$14 = qual$3.createDestClusterLink$default$5();
        Properties x$15 = qual$3.createDestClusterLink$default$6();
        qual$3.createDestClusterLink(x$10, x$11, x$12, x$13, x$14, x$15);
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$16 = this.topic();
        short x$17 = this.replicationFactor();
        String x$18 = this.linkName();
        scala.collection.mutable.Map x$19 = CollectionConverters$.MODULE$.PropertiesHasAsScala(destTopicProps).asScala();
        String x$20 = qual$4.linkTopic$default$5();
        qual$4.linkTopic(x$16, x$17, x$18, (Map<String, String>)x$19, x$20);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.produceAndSimulateRetention(producer);
        String x$21 = this.topic();
        Seq<KafkaBroker> x$23 = this.verifyMirror$default$2();
        boolean x$24 = this.verifyMirror$default$3();
        this.verifyMirror(x$21, x$23, x$24, false);
    }

    private void enableTiering(ClusterLinkTestHarness cluster, String bucket) {
        cluster.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "5");
        cluster.serverConfig().put(KafkaConfig$.MODULE$.TierEnableProp(), "false");
        cluster.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        cluster.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
        cluster.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "2");
        cluster.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        cluster.serverConfig().put(KafkaConfig$.MODULE$.TierFetcherMemoryPoolSizeBytesProp(), Integer.toString(0x100000));
        cluster.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        cluster.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), bucket);
        cluster.serverConfig().put(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), Integer.toString(Integer.MAX_VALUE));
    }

    private Properties sourceTopicProps() {
        Properties props = new Properties();
        props.putAll((java.util.Map<?, ?>)this.tierProps());
        props.put("segment.bytes", "2000");
        props.put("retention.bytes", "-1");
        return props;
    }

    private Properties tierProps() {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("confluent.tier.local.hotset.bytes", "1000");
        return props;
    }

    private void produceAndSimulateRetention(KafkaProducer<byte[], byte[]> producer) {
        scala.collection.immutable.Map minTiered = ((IterableOnceOps)this.partitions(this.partitions$default$1(), this.partitions$default$2(), this.partitions$default$3()).map((Function1 & Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)BoxesRunTime.boxToInteger((int)(this.leaderLog(this.sourceCluster(), (TopicPartition)tp).tierPartitionState().numSegments() + 3))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> this.produceRecords(producer, this.topic(), 50, this.produceRecords$default$4(), this.produceRecords$default$5()));
        this.waitUntilSegmentsTiered(this.sourceCluster(), (scala.collection.immutable.Map<TopicPartition, Object>)minTiered);
        this.simulateRetention(this.sourceCluster());
    }

    private void waitUntilSegmentsTiered(ClusterLinkTestHarness cluster, scala.collection.immutable.Map<TopicPartition, Object> minNumSegments) {
        this.partitions(this.partitions$default$1(), this.partitions$default$2(), this.partitions$default$3()).foreach((Function1 & Serializable)tp -> {
            ClusterLinkTierIntegrationTest.$anonfun$waitUntilSegmentsTiered$1(this, cluster, minNumSegments, tp);
            return BoxedUnit.UNIT;
        });
    }

    private void simulateRetention(ClusterLinkTestHarness cluster) {
        this.partitions(this.partitions$default$1(), this.partitions$default$2(), this.partitions$default$3()).foreach((Function1 & Serializable)tp -> {
            ClusterLinkTierIntegrationTest.$anonfun$simulateRetention$1(this, cluster, tp);
            return BoxedUnit.UNIT;
        });
    }

    private AbstractLog leaderLog(ClusterLinkTestHarness cluster, TopicPartition tp) {
        LogManager qual$1 = cluster.partitionLeader(tp).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        return (AbstractLog)qual$1.getLog(tp, x$2).get();
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilSegmentsTiered$2(TierPartitionState tierState$1, int minSegments$1) {
        return tierState$1.numSegments() >= minSegments$1 && tierState$1.endOffset() == tierState$1.committedEndOffset();
    }

    public static final /* synthetic */ String $anonfun$waitUntilSegmentsTiered$3(scala.collection.immutable.Map minNumSegments$1) {
        return new StringBuilder(54).append("Timed out waiting for ").append(minNumSegments$1).append(" to be archived and materialized").toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$waitUntilSegmentsTiered$1(ClusterLinkTierIntegrationTest $this, ClusterLinkTestHarness cluster$1, scala.collection.immutable.Map minNumSegments$1, TopicPartition tp) {
        TierPartitionState tierState = $this.leaderLog(cluster$1, tp).tierPartitionState();
        int minSegments = BoxesRunTime.unboxToInt((Object)minNumSegments$1.apply((Object)tp));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 30000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkTierIntegrationTest.$anonfun$waitUntilSegmentsTiered$2(tierState, minSegments)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkTierIntegrationTest.$anonfun$waitUntilSegmentsTiered$3(minNumSegments$1));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$simulateRetention$2(ClusterLinkTierIntegrationTest $this, ClusterLinkTestHarness cluster$2, TopicPartition tp$1) {
        return $this.leaderLog(cluster$2, tp$1).deleteOldSegments() > 0;
    }

    public static final /* synthetic */ String $anonfun$simulateRetention$3() {
        return "tiered segments should have been deleted";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$simulateRetention$1(ClusterLinkTierIntegrationTest $this, ClusterLinkTestHarness cluster$2, TopicPartition tp) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkTierIntegrationTest.$anonfun$simulateRetention$2($this, cluster$2, tp)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"tiered segments should have been deleted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }
}

