/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.server.ConfigType$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.SecureLinkConfigEncoder;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.test.TestSslUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\u0005\rd\u0001\u0002\b\u0010\u0001QAQ!\u0007\u0001\u0005\u0002iA\u0011\u0002\b\u0001A\u0002\u0003\u0005\u000b\u0015B\u000f\t\u000b%\u0002A\u0011\t\u0016\t\u000b]\u0002A\u0011\u0001\u001d\t\u000b\u0001\u0004A\u0011A1\t\u000b%\u0004A\u0011\u00026\t\u000fU\u0004\u0011\u0013!C\u0005m\"9\u00111\u0001\u0001\u0005\n\u0005\u0015\u0001bBA\u0004\u0001\u0011%\u0011\u0011\u0002\u0005\b\u0003/\u0001A\u0011BA\r\u0011\u001d\tI\u0003\u0001C\u0005\u0003WAq!a\u0012\u0001\t\u0013\tI\u0005C\u0004\u0002N\u0001!I!a\u0014\u0003%\rcWo\u001d;fe2Kgn[*tYR+7\u000f\u001e\u0006\u0003!E\tA\u0001\\5oW*\t!#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001)\u0002C\u0001\f\u0018\u001b\u0005y\u0011B\u0001\r\u0010\u0005\t\n%m\u001d;sC\u000e$8\t\\;ti\u0016\u0014H*\u001b8l\u0013:$Xm\u001a:bi&|g\u000eV3ti\u00061A(\u001b8jiz\"\u0012a\u0007\t\u0003-\u0001\t\u0011b\u0018;fgRLeNZ8\u0011\u0005y9S\"A\u0010\u000b\u0005\u0001\n\u0013aA1qS*\u0011!eI\u0001\bUV\u0004\u0018\u000e^3s\u0015\t!S%A\u0003kk:LGOC\u0001'\u0003\ry'oZ\u0005\u0003Q}\u0011\u0001\u0002V3ti&sgm\\\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003WE\u0002\"\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\u0012A!\u00168ji\")!g\u0001a\u0001;\u0005AA/Z:u\u0013:4w\u000e\u000b\u0002\u0004iA\u0011a$N\u0005\u0003m}\u0011!BQ3g_J,W)Y2i\u0003}!Xm\u001d;DYV\u001cH/\u001a:MS:\\w+\u001b;i!\u0016l7k\u001d7Ti>\u0014Xm\u001d\u000b\u0004We2\u0005\"\u0002\u001e\u0005\u0001\u0004Y\u0014AB9v_J,X\u000e\u0005\u0002=\u0007:\u0011Q(\u0011\t\u0003}5j\u0011a\u0010\u0006\u0003\u0001N\ta\u0001\u0010:p_Rt\u0014B\u0001\".\u0003\u0019\u0001&/\u001a3fM&\u0011A)\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\tk\u0003\"B$\u0005\u0001\u0004A\u0015aC2p_J$\u0017N\\1u_J\u0004\"\u0001L%\n\u0005)k#a\u0002\"p_2,\u0017M\u001c\u0015\u0005\t1#V\u000b\u0005\u0002N%6\taJ\u0003\u0002P!\u0006A\u0001O]8wS\u0012,'O\u0003\u0002RC\u00051\u0001/\u0019:b[NL!a\u0015(\u0003\u00195+G\u000f[8e'>,(oY3\u0002\u000bY\fG.^3-\u0003Y\u000b\u0013aV\u0001\u0010C2d7i\\7cS:\fG/[8og\"\"A!W/_!\tQ6,D\u0001Q\u0013\ta\u0006KA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fAA\\1nK\u0006\nq,\u0001\u0015|I&\u001c\b\u000f\\1z\u001d\u0006lW- \u0018rk>\u0014X/\\\u001f|aut3m\\8sI&t\u0017\r^8s{m\fT0\u0001\u000fuKN$XI\\2ssB$\u0018n\u001c8TK\u000e\u0014X\r\u001e*pi\u0006$\u0018n\u001c8\u0015\u0007-\u00127\rC\u0003;\u000b\u0001\u00071\bC\u0003H\u000b\u0001\u0007\u0001\n\u000b\u0003\u0006\u0019R+G&\u00014\"\u0003\u001d\faB_6D_6\u0014\u0017N\\1uS>t7\u000f\u000b\u0003\u00063vs\u0016\u0001D:tY2Kgn\u001b)s_B\u001cHCA6t!\ta\u0017/D\u0001n\u0015\tqw.\u0001\u0003vi&d'\"\u00019\u0002\t)\fg/Y\u0005\u0003e6\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d!h\u0001%AA\u0002-\fQb\u001c<feJLG-\u001a)s_B\u001c\u0018AF:tY2Kgn\u001b)s_B\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003]T#a\u001b=,\u0003e\u0004\"A_@\u000e\u0003mT!\u0001`?\u0002\u0013Ut7\r[3dW\u0016$'B\u0001@.\u0003)\tgN\\8uCRLwN\\\u0005\u0004\u0003\u0003Y(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Qa/\u001a:jMfd\u0015N\\6\u0015\u0003-\n1B\u0019:pW\u0016\u0014\bK]8qgV\u0011\u00111\u0002\t\u0007Y\u000651(!\u0005\n\u0007\u0005=QNA\u0004ICNDW*\u00199\u0011\u00071\n\u0019\"C\u0002\u0002\u00165\u0012a!\u00118z%\u00164\u0017\u0001F3oG>$WM],ji\"|E\u000eZ*fGJ,G/\u0006\u0002\u0002\u001cA!\u0011QDA\u0013\u001b\t\tyBC\u0002\u0011\u0003CQ1!a\t\u0012\u0003\u0019\u0019XM\u001d<fe&!\u0011qEA\u0010\u0005]\u0019VmY;sK2Kgn[\"p]\u001aLw-\u00128d_\u0012,'/\u0001\teK\u000e|G-\u001a'j].\u001cuN\u001c4jOR)1&!\f\u00022!9\u0011qF\u0006A\u0002\u0005m\u0011aB3oG>$WM\u001d\u0005\b\u0003gY\u0001\u0019AA\u001b\u0003\u0019a\u0017N\\6JIB!\u0011qGA\"\u001b\t\tID\u0003\u0003\u0002<\u0005u\u0012AB2p[6|gNC\u0002\u0013\u0003\u007fQ1!!\u0011&\u0003\u0019\t\u0007/Y2iK&!\u0011QIA\u001d\u0005\u0011)V/\u001b3\u0002-]\f\u0017\u000e\u001e$pe>cGmU3de\u0016$H)\u001a7fi\u0016$2aKA&\u0011\u001d\t\u0019\u0004\u0004a\u0001\u0003k\t\u0001D^3sS\u001aL8i\u001c8gS\u001e\fe\r^3s%\u0016\u001cH/\u0019:u)\u0015Y\u0013\u0011KA*\u0011\u001d\t\u0019$\u0004a\u0001\u0003kAa!!\u0016\u000e\u0001\u0004A\u0015!C3ya\u0016\u001cGo\u00147eQ\u0019\u0001\u0011\u0011\f+\u0002`A\u0019a$a\u0017\n\u0007\u0005usDA\u0002UC\u001e\f#!!\u0019\u0002\u0017%tG/Z4sCRLwN\u001c")
public class ClusterLinkSslTest
extends AbstractClusterLinkIntegrationTest {
    private TestInfo _testInfo;

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.destCluster().serverConfig().put(KafkaConfig$.MODULE$.PasswordEncoderOldSecretProp(), "password-encoder-old-secret");
        this._testInfo = testInfo;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testClusterLinkWithPemSslStores(String quorum, boolean coordinator) {
        super.setUp(this._testInfo);
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = this.linkName();
        Properties x$2 = this.sslLinkProps(new Properties());
        Some x$3 = new Some((Object)((KafkaBroker)this.sourceCluster().brokers().head()).clusterId());
        boolean x$4 = qual$1.createClusterLink$default$4();
        Uuid linkId = qual$1.createClusterLink(x$1, x$2, (Option<String>)x$3, x$4);
        this.decodeLinkConfig(this.encoderWithOldSecret(), linkId);
        Config linkConfig = this.destCluster().describeClusterLink(this.linkName());
        scala.collection.immutable.Map linkProps = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(linkConfig.entries()).asScala().map((Function1 & Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.name()), (Object)e.value()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Assertions.assertEquals((Object)"PEM", (Object)linkProps.apply((Object)"ssl.keystore.type"));
        Assertions.assertEquals((Object)"PEM", (Object)linkProps.apply((Object)"ssl.truststore.type"));
        this.verifyConfigAfterRestart(linkId, true);
        this.verifyLink();
        Properties overrideProps = new Properties();
        overrideProps.setProperty("ssl.truststore.location", this.destCluster().clientSecurityProps(this.linkName()).getProperty("ssl.truststore.location"));
        Properties invalidLinkProps = this.sslLinkProps(overrideProps);
        this.verifyValidateLinkFailure(invalidLinkProps, InvalidConfigurationException.class, "SSL handshake failed");
        invalidLinkProps.remove("ssl.truststore.certificates");
        invalidLinkProps.setProperty("ssl.truststore.location", "nonexistent.pem");
        this.verifyValidateLinkFailure(invalidLinkProps, InvalidConfigurationException.class, "Unable to create client using provided properties when validating the cluster link: Failed to load PEM SSL keystore nonexistent.pem, root cause: java.nio.file.NoSuchFileException: nonexistent.pem");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"zkCombinations"})
    public void testEncryptionSecretRotation(String quorum, boolean coordinator) {
        this.destCluster().serverConfig().put(KafkaConfig$.MODULE$.PasswordEncoderOldSecretProp(), "password-encoder-old-secret");
        this.destCluster().serverConfig().put("confluent.password.encoder.old.secret.ttl.ms", "1000");
        super.setUp(this._testInfo);
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = this.linkName();
        Properties x$2 = this.sslLinkProps(new Properties());
        Some x$3 = new Some((Object)((KafkaBroker)this.sourceCluster().brokers().head()).clusterId());
        boolean x$4 = qual$1.createClusterLink$default$4();
        Uuid linkId = qual$1.createClusterLink(x$1, x$2, (Option<String>)x$3, x$4);
        this.waitForOldSecretDelete(linkId);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        Properties x$6 = this.sslLinkProps(new Properties());
        None$ x$7 = None$.MODULE$;
        boolean x$8 = qual$2.createClusterLink$default$4();
        this.waitForOldSecretDelete(qual$2.createClusterLink("anotherLink", x$6, (Option<String>)x$7, x$8));
        HashMap<String, Object> encoderProps = this.brokerProps();
        encoderProps.remove("confluent.password.encoder.old.secret.ttl.ms");
        SecureLinkConfigEncoder encoder = new SecureLinkConfigEncoder(new KafkaConfig(encoderProps));
        Properties linkProps = this.destCluster().adminZkClient().fetchClusterLinkConfig(linkId);
        this.destCluster().adminZkClient().changeClusterLinkConfig(linkId, (Properties)encoder.maybeReencode(linkProps).get());
        this.decodeLinkConfig(this.encoderWithOldSecret(), linkId);
        this.verifyConfigAfterRestart(linkId, false);
        this.verifyLink();
    }

    private Properties sslLinkProps(Properties overrideProps) {
        Properties props = new Properties();
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        ListenerName x$1 = qual$1.bootstrapServers$default$1();
        props.put("bootstrap.servers", qual$1.bootstrapServers(x$1));
        new Implicits.PropertiesOps(props).$plus$plus$eq(this.sourceCluster().clientSecurityProps(this.linkName()));
        new Implicits.PropertiesOps(props).$plus$plus$eq(overrideProps);
        TestSslUtils.convertToPemWithoutFiles((Properties)props);
        Assertions.assertNull((Object)props.get("ssl.keystore.location"));
        Assertions.assertNull((Object)props.get("ssl.truststore.location"));
        return props;
    }

    private Properties sslLinkProps$default$1() {
        return new Properties();
    }

    private void verifyLink() {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        this.produceToSourceCluster(20);
        String x$12 = this.topic();
        Seq<KafkaBroker> x$14 = this.verifyMirror$default$2();
        boolean x$15 = this.verifyMirror$default$3();
        this.verifyMirror(x$12, x$14, x$15, false);
    }

    private HashMap<String, Object> brokerProps() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.putAll(((KafkaBroker)this.destCluster().brokers().head()).config().originals());
        return props;
    }

    private SecureLinkConfigEncoder encoderWithOldSecret() {
        HashMap<String, Object> oldEncoderProps = this.brokerProps();
        oldEncoderProps.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), oldEncoderProps.remove(KafkaConfig$.MODULE$.PasswordEncoderOldSecretProp()));
        return new SecureLinkConfigEncoder(new KafkaConfig(oldEncoderProps));
    }

    private void decodeLinkConfig(SecureLinkConfigEncoder encoder, Uuid linkId) {
        if (!this.isKraftTest()) {
            Properties props = this.destCluster().zkClient().getEntityConfigs(ConfigType$.MODULE$.ClusterLink(), CoreUtils$.MODULE$.toJavaUUID(linkId).toString());
            encoder.clusterLinkConfig(props);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void waitForOldSecretDelete(Uuid linkId) {
        SecureLinkConfigEncoder oldEncoder = this.encoderWithOldSecret();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkSslTest.$anonfun$waitForOldSecretDelete$1(this, oldEncoder, linkId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Configs encrypted with old secret not deleted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void verifyConfigAfterRestart(Uuid linkId, boolean expectOld) {
        int brokerId = ((KafkaBroker)this.destCluster().brokers().head()).config().brokerId();
        this.destCluster().shutdownBroker(brokerId);
        this.destCluster().startBroker(brokerId);
        if (expectOld) {
            this.decodeLinkConfig(this.encoderWithOldSecret(), linkId);
            return;
        }
        this.waitForOldSecretDelete(linkId);
    }

    public static final /* synthetic */ boolean $anonfun$waitForOldSecretDelete$1(ClusterLinkSslTest $this, SecureLinkConfigEncoder oldEncoder$1, Uuid linkId$1) {
        try {
            $this.decodeLinkConfig(oldEncoder$1, linkId$1);
            return false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static final /* synthetic */ String $anonfun$waitForOldSecretDelete$2() {
        return "Configs encrypted with old secret not deleted";
    }

    public ClusterLinkSslTest() {
        None$ x$3 = None$.MODULE$;
        int x$4 = 2;
        this.sourceCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SSL, (Option<SecurityProtocol>)x$3, 0, x$4));
        None$ x$7 = None$.MODULE$;
        int x$8 = 2;
        this.destCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SSL, (Option<SecurityProtocol>)x$7, 100, x$8));
    }
}

