/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.link.MockPolicy;
import kafka.server.KafkaConfig$;
import kafka.utils.TestInfoUtils$;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.HashMap$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\u0005ed\u0001\u0002\u000e\u001c\u0001\u0001BQ!\n\u0001\u0005\u0002\u0019Bq\u0001\u000b\u0001C\u0002\u0013\u0005\u0013\u0006\u0003\u00041\u0001\u0001\u0006IA\u000b\u0005\bc\u0001\u0011\r\u0011\"\u00013\u0011\u0019Y\u0004\u0001)A\u0005g!9A\b\u0001b\u0001\n\u0003i\u0004B\u0002#\u0001A\u0003%a\bC\u0004F\u0001\t\u0007I\u0011A\u001f\t\r\u0019\u0003\u0001\u0015!\u0003?\u0011\u001d9\u0005A1A\u0005\u0002uBa\u0001\u0013\u0001!\u0002\u0013q\u0004bB%\u0001\u0005\u0004%\t!\u0010\u0005\u0007\u0015\u0002\u0001\u000b\u0011\u0002 \t\u0013-\u0003\u0001\u0019!A!B\u0013a\u0005\"\u0002-\u0001\t\u0003J\u0006\"B2\u0001\t\u0013!\u0007bB=\u0001#\u0003%IA\u001f\u0005\n\u0003\u0017\u0001\u0011\u0013!C\u0005\u0003\u001bAq!!\u0005\u0001\t\u0003\t\u0019\u0002C\u0004\u0002H\u0001!\t!!\u0013\t\u000f\u0005U\u0003\u0001\"\u0001\u0002X!9\u00111\r\u0001\u0005\n\u0005\u0015\u0004bBA4\u0001\u0011%\u0011Q\r\u0005\b\u0003S\u0002A\u0011BA3\u0011\u001d\tY\u0007\u0001C\u0005\u0003K\u0012Qc\u00117vgR,'\u000fT5oWB{G.[2z)\u0016\u001cHO\u0003\u0002\u001d;\u0005!A.\u001b8l\u0015\u0005q\u0012!B6bM.\f7\u0001A\n\u0003\u0001\u0005\u0002\"AI\u0012\u000e\u0003mI!\u0001J\u000e\u0003E\u0005\u00137\u000f\u001e:bGR\u001cE.^:uKJd\u0015N\\6J]R,wM]1uS>tG+Z:u\u0003\u0019a\u0014N\\5u}Q\tq\u0005\u0005\u0002#\u0001\u0005\t\"/\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:\u0016\u0003)\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012Qa\u00155peR\f!C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8sA\u0005\u0019Bo\u001c9jGNKhnY%oi\u0016\u0014h/\u00197NgV\t1\u0007\u0005\u00025s5\tQG\u0003\u00027o\u0005!A.\u00198h\u0015\u0005A\u0014\u0001\u00026bm\u0006L!AO\u001b\u0003\rM#(/\u001b8h\u0003Q!x\u000e]5d'ft7-\u00138uKJ4\u0018\r\\'tA\u0005Ib/[8mCRLgnZ!mo\u0006L8oU=oG\u000e{gNZ5h+\u0005q\u0004CA C\u001b\u0005\u0001%BA!8\u0003\u0011)H/\u001b7\n\u0005\r\u0003%A\u0003)s_B,'\u000f^5fg\u0006Qb/[8mCRLgnZ!mo\u0006L8oU=oG\u000e{gNZ5hA\u0005)b/\u00197jI\u0006cw/Y=t'ft7mQ8oM&<\u0017A\u0006<bY&$\u0017\t\\<bsN\u001c\u0016P\\2D_:4\u0017n\u001a\u0011\u00021YLw\u000e\\1uS:<g*\u001a<feNKhnY\"p]\u001aLw-A\rwS>d\u0017\r^5oO:+g/\u001a:Ts:\u001c7i\u001c8gS\u001e\u0004\u0013\u0001\u0006<bY&$g*\u001a<feNKhnY\"p]\u001aLw-A\u000bwC2LGMT3wKJ\u001c\u0016P\\2D_:4\u0017n\u001a\u0011\u0002\u0013}#Xm\u001d;J]\u001a|\u0007CA'W\u001b\u0005q%BA(Q\u0003\r\t\u0007/\u001b\u0006\u0003#J\u000bqA[;qSR,'O\u0003\u0002T)\u0006)!.\u001e8ji*\tQ+A\u0002pe\u001eL!a\u0016(\u0003\u0011Q+7\u000f^%oM>\fQa]3u+B$\"AW/\u0011\u0005-Z\u0016B\u0001/-\u0005\u0011)f.\u001b;\t\u000by{\u0001\u0019\u0001'\u0002\u0011Q,7\u000f^%oM>D#a\u00041\u0011\u00055\u000b\u0017B\u00012O\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u000eg\u0016$X\u000b]\"mkN$XM]:\u0015\u0007i+'\u000eC\u0004g!A\u0005\t\u0019A4\u0002;=4XM\u001d:jI\u00164\u0016n\u001c7bi&twmS1gW\u0006$UMZ1vYR\u0004\"a\u000b5\n\u0005%d#a\u0002\"p_2,\u0017M\u001c\u0005\bWB\u0001\n\u00111\u0001m\u0003Y\u0019x.\u001e:dK\u000ecWo\u001d;fe>3XM\u001d:jI\u0016\u001c\b\u0003B7uo^t!A\u001c:\u0011\u0005=dS\"\u00019\u000b\u0005E|\u0012A\u0002\u001fs_>$h(\u0003\u0002tY\u00051\u0001K]3eK\u001aL!!\u001e<\u0003\u00075\u000b\u0007O\u0003\u0002tYA\u0011Q\u000e_\u0005\u0003uY\fqc]3u+B\u001cE.^:uKJ\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003mT#a\u001a?,\u0003u\u00042A`A\u0004\u001b\u0005y(\u0002BA\u0001\u0003\u0007\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015A&\u0001\u0006b]:|G/\u0019;j_:L1!!\u0003\u0000\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0018g\u0016$X\u000b]\"mkN$XM]:%I\u00164\u0017-\u001e7uII*\"!a\u0004+\u00051d\u0018!\u0011;fgRl\u0015N\u001d:peR{\u0007/[2De\u0016\fG/[8o\u0007>tg-[4Q_2L7-_*pkJ\u001cWm\u00117vgR,'oV5uQZ\u000bG.\u001b3EK\u001a\fW\u000f\u001c;t)\u0015Q\u0016QCA\r\u0011\u0019\t9b\u0005a\u0001o\u00061\u0011/^8sk6Da!a\u0007\u0014\u0001\u00049\u0017aC2p_J$\u0017N\\1u_JDsaEA\u0010\u0003_\t\t\u0004\u0005\u0003\u0002\"\u0005-RBAA\u0012\u0015\u0011\t)#a\n\u0002\u0011A\u0014xN^5eKJT1!!\u000bQ\u0003\u0019\u0001\u0018M]1ng&!\u0011QFA\u0012\u00051iU\r\u001e5pIN{WO]2f\u0003\u00151\u0018\r\\;fY\t\t\u0019$\t\u0002\u00026\u0005y\u0011\r\u001c7D_6\u0014\u0017N\\1uS>t7\u000fK\u0004\u0014\u0003s\t\t%a\u0011\u0011\t\u0005m\u0012QH\u0007\u0003\u0003OIA!a\u0010\u0002(\t\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u0003\u0003\u000b\n\u0001f\u001f3jgBd\u0017-\u001f(b[\u0016lh&];peVlWh\u001f\u0019~]\r|wN\u001d3j]\u0006$xN]\u001f|cu\fQ\t^3ti\u000e\u0013X-\u0019;f\u001b&\u0014(o\u001c:T_V\u00148-Z!mo\u0006L8oU=oG\u000e{gNZ5h\u00072,8\u000f^3s\u0019\u00164X\r\\(wKJ\u0014\u0018\u000e\u001a3f]ZKw\u000e\\1uS>tG#\u0002.\u0002L\u00055\u0003BBA\f)\u0001\u0007q\u000f\u0003\u0004\u0002\u001cQ\u0001\ra\u001a\u0015\b)\u0005}\u0011qFA)Y\t\t\u0019\u0004K\u0004\u0015\u0003s\t\t%a\u0011\u0002\u007fQ,7\u000f^\"sK\u0006$X-T5se>\u00148k\\;sG\u0016\fEn^1zgNKhnY\"p]\u001aLw\rS1sI\u000e{G-\u001a3EK\u001a\fW\u000f\u001c;WS>d\u0017\r^5p]R)!,!\u0017\u0002\\!1\u0011qC\u000bA\u0002]Da!a\u0007\u0016\u0001\u00049\u0007fB\u000b\u0002 \u0005=\u0012q\f\u0017\u0003\u0003gAs!FA\u001d\u0003\u0003\n\u0019%\u0001\u001fwKJLg-_\"sK\u0006$X-T5se>\u00148k\\;sG\u0016\fEn^1zgNKhnY\"p]\u001aLw\rV8qS\u000edUM^3m\u001fZ,'O]5eI\u0016tG#\u0001.\u0002wY,'/\u001b4z\u0007J,\u0017\r^3NSJ\u0014xN]*pkJ\u001cWMT3wKJ\u001c\u0016P\\2D_:4\u0017n\u001a+pa&\u001cG*\u001a<fY>3XM\u001d:jI\u0012,g.\u0001\u0015wKJLg-_\"sK\u0006$X-T5se>\u0014\b+Y:tS:<g+[8mCRLgnZ\"p]\u001aLw-A\u0017wKJLg-\u001f*v]RLW.\u001a#fgRLg.\u0019;j_:\u001cuN\u001c4jO\u000eC\u0017M\\4f-&|G.\u0019;j_:Ds\u0001AA8\u0003_\t)\bE\u0002N\u0003cJ1!a\u001dO\u0005\r!\u0016mZ\u0011\u0003\u0003o\n1\"\u001b8uK\u001e\u0014\u0018\r^5p]\u0002")
public class ClusterLinkPolicyTest
extends AbstractClusterLinkIntegrationTest {
    private final short replicationFactor;
    private final String topicSyncIntervalMs;
    private final Properties violatingAlwaysSyncConfig;
    private final Properties validAlwaysSyncConfig;
    private final Properties violatingNeverSyncConfig;
    private final Properties validNeverSyncConfig;
    private TestInfo _testInfo;

    @Override
    public short replicationFactor() {
        return this.replicationFactor;
    }

    public String topicSyncIntervalMs() {
        return this.topicSyncIntervalMs;
    }

    public Properties violatingAlwaysSyncConfig() {
        return this.violatingAlwaysSyncConfig;
    }

    public Properties validAlwaysSyncConfig() {
        return this.validAlwaysSyncConfig;
    }

    public Properties violatingNeverSyncConfig() {
        return this.violatingNeverSyncConfig;
    }

    public Properties validNeverSyncConfig() {
        return this.validNeverSyncConfig;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this._testInfo = testInfo;
    }

    private void setUpClusters(boolean overrideViolatingKafkaDefault, scala.collection.immutable.Map<String, String> sourceClusterOverrides) {
        if (TestInfoUtils$.MODULE$.isKRaft(this._testInfo) && this.sourceCluster() == null && this.destCluster() == null) {
            None$ x$4 = None$.MODULE$;
            this.sourceCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.PLAINTEXT, (Option<SecurityProtocol>)x$4, 0, 2));
            None$ x$8 = None$.MODULE$;
            this.destCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.PLAINTEXT, (Option<SecurityProtocol>)x$8, 100, 2));
            this.destCluster().controllerConfigOverrides().setProperty(KafkaConfig$.MODULE$.CreateTopicPolicyClassNameProp(), MockPolicy.MockCreateTopicPolicy.class.getName());
            this.destCluster().controllerConfigOverrides().setProperty(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), MockPolicy.MockAlterTopicPolicy.class.getName());
        } else if (this.sourceCluster() == null && this.destCluster() == null) {
            None$ x$12 = None$.MODULE$;
            this.sourceCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_SSL, (Option<SecurityProtocol>)x$12, 0, 2));
            None$ x$16 = None$.MODULE$;
            this.destCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_PLAINTEXT, (Option<SecurityProtocol>)x$16, 100, 2));
            this.destCluster().serverConfig().setProperty(KafkaConfig$.MODULE$.CreateTopicPolicyClassNameProp(), MockPolicy.MockCreateTopicPolicy.class.getName());
            this.destCluster().serverConfig().setProperty(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), MockPolicy.MockAlterTopicPolicy.class.getName());
        }
        if (sourceClusterOverrides.nonEmpty()) {
            sourceClusterOverrides.foreach((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    String k = (String)x0$1._1();
                    String v = (String)x0$1._2();
                    return this.sourceCluster().serverConfig().setProperty(k, v);
                }
                throw new MatchError(null);
            });
        }
        if (overrideViolatingKafkaDefault) {
            this.sourceCluster().serverConfig().setProperty(KafkaConfig$.MODULE$.LogCleanerMaxCompactionLagMsProp(), "500");
        }
        super.setUp(this._testInfo);
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
    }

    private boolean setUpClusters$default$1() {
        return true;
    }

    private scala.collection.immutable.Map<String, String> setUpClusters$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testMirrorTopicCreationConfigPolicySourceClusterWithValidDefaults(String quorum, boolean coordinator) {
        this.setUpClusters(true, this.setUpClusters$default$2());
        this.verifyCreateMirrorSourceAlwaysSyncConfigTopicLevelOverridden();
        this.verifyCreateMirrorSourceNeverSyncConfigTopicLevelOverridden();
        this.verifyCreateMirrorPassingViolatingConfig();
        this.verifyRuntimeDestinationConfigChangeViolation();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testCreateMirrorSourceAlwaysSyncConfigClusterLevelOverriddenViolation(String quorum, boolean coordinator) {
        this.setUpClusters(false, (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogCleanerMaxCompactionLagMsProp()), (Object)"2000")}))));
        String topic = UUID.randomUUID().toString();
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        short x$2 = this.replicationFactor();
        int x$3 = qual$1.createTopic$default$3();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(topic, x$2, x$3, x$4, x$5, x$6);
        Assertions.assertThrows(PolicyViolationException.class, (Executable)new Executable(this, topic){
            private final /* synthetic */ ClusterLinkPolicyTest $outer;
            private final String topic$1;

            public void execute() {
                ClusterLinkTestHarness qual$1 = this.$outer.destCluster();
                String x$1 = this.topic$1;
                short x$2 = this.$outer.replicationFactor();
                String x$3 = this.$outer.linkName();
                Map<String, String> x$4 = qual$1.linkTopic$default$4();
                String x$5 = qual$1.linkTopic$default$5();
                qual$1.linkTopic(x$1, x$2, x$3, x$4, x$5);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        }, (String)new StringBuilder(87).append("Mirror should fail with ").append(PolicyViolationException.class).append(" because ").append("source cluster defaults violate the destination policy").toString());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testCreateMirrorSourceAlwaysSyncConfigHardCodedDefaultViolation(String quorum, boolean coordinator) {
        this.setUpClusters(false, this.setUpClusters$default$2());
        String topic = UUID.randomUUID().toString();
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        short x$2 = this.replicationFactor();
        int x$3 = qual$1.createTopic$default$3();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(topic, x$2, x$3, x$4, x$5, x$6);
        Assertions.assertThrows(PolicyViolationException.class, (Executable)new Executable(this, topic){
            private final /* synthetic */ ClusterLinkPolicyTest $outer;
            private final String topic$2;

            public void execute() {
                ClusterLinkTestHarness qual$1 = this.$outer.destCluster();
                String x$1 = this.topic$2;
                short x$2 = this.$outer.replicationFactor();
                String x$3 = this.$outer.linkName();
                Map<String, String> x$4 = qual$1.linkTopic$default$4();
                String x$5 = qual$1.linkTopic$default$5();
                qual$1.linkTopic(x$1, x$2, x$3, x$4, x$5);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$2 = topic$2;
            }
        }, (String)new StringBuilder(98).append("Mirror should fail with ").append(PolicyViolationException.class).append(" because ").append("source cluster hard-coded defaults violate the destination policy").toString());
    }

    private void verifyCreateMirrorSourceAlwaysSyncConfigTopicLevelOverridden() {
        String topicWithViolatingAlwaysSyncConfig = UUID.randomUUID().toString();
        String topicWithValidAlwaysSyncConfig = UUID.randomUUID().toString();
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = this.violatingAlwaysSyncConfig();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(topicWithViolatingAlwaysSyncConfig, x$2, x$3, x$4, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        int x$8 = this.numPartitions();
        short x$9 = this.replicationFactor();
        Properties x$10 = this.validAlwaysSyncConfig();
        ListenerName x$11 = qual$2.createTopic$default$5();
        Properties x$12 = qual$2.createTopic$default$6();
        qual$2.createTopic(topicWithValidAlwaysSyncConfig, x$8, x$9, x$10, x$11, x$12);
        Assertions.assertThrows(PolicyViolationException.class, (Executable)new Executable(this, topicWithViolatingAlwaysSyncConfig){
            private final /* synthetic */ ClusterLinkPolicyTest $outer;
            private final String topicWithViolatingAlwaysSyncConfig$1;

            public void execute() {
                ClusterLinkTestHarness qual$1 = this.$outer.destCluster();
                String x$1 = this.topicWithViolatingAlwaysSyncConfig$1;
                short x$2 = this.$outer.replicationFactor();
                String x$3 = this.$outer.linkName();
                Map<String, String> x$4 = qual$1.linkTopic$default$4();
                String x$5 = qual$1.linkTopic$default$5();
                qual$1.linkTopic(x$1, x$2, x$3, x$4, x$5);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicWithViolatingAlwaysSyncConfig$1 = topicWithViolatingAlwaysSyncConfig$1;
            }
        }, (String)new StringBuilder(95).append("Mirror should fail with ").append(PolicyViolationException.class).append(" because ").append("source topic config overridden violates the destination policy").toString());
        Assertions.assertDoesNotThrow(() -> {
            ClusterLinkTestHarness qual$3 = this.destCluster();
            short x$14 = this.replicationFactor();
            String x$15 = this.linkName();
            Map<String, String> x$16 = qual$3.linkTopic$default$4();
            String x$17 = qual$3.linkTopic$default$5();
            return qual$3.linkTopic(topicWithValidAlwaysSyncConfig, x$14, x$15, x$16, x$17);
        }, (String)"Mirror should not fail");
    }

    private void verifyCreateMirrorSourceNeverSyncConfigTopicLevelOverridden() {
        String topicWithViolatingNeverSyncConfig = UUID.randomUUID().toString();
        String topicWithValidNeverSyncConfig = UUID.randomUUID().toString();
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = this.violatingNeverSyncConfig();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(topicWithViolatingNeverSyncConfig, x$2, x$3, x$4, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        int x$8 = this.numPartitions();
        short x$9 = this.replicationFactor();
        Properties x$10 = this.validNeverSyncConfig();
        ListenerName x$11 = qual$2.createTopic$default$5();
        Properties x$12 = qual$2.createTopic$default$6();
        qual$2.createTopic(topicWithValidNeverSyncConfig, x$8, x$9, x$10, x$11, x$12);
        Assertions.assertDoesNotThrow(() -> {
            ClusterLinkTestHarness qual$3 = this.destCluster();
            short x$14 = this.replicationFactor();
            String x$15 = this.linkName();
            Map<String, String> x$16 = qual$3.linkTopic$default$4();
            String x$17 = qual$3.linkTopic$default$5();
            qual$3.linkTopic(topicWithViolatingNeverSyncConfig, x$14, x$15, x$16, x$17);
            ClusterLinkTestHarness qual$4 = this.destCluster();
            short x$19 = this.replicationFactor();
            String x$20 = this.linkName();
            Map<String, String> x$21 = qual$4.linkTopic$default$4();
            String x$22 = qual$4.linkTopic$default$5();
            return qual$4.linkTopic(topicWithValidNeverSyncConfig, x$19, x$20, x$21, x$22);
        }, (String)"Mirror should not fail");
    }

    private void verifyCreateMirrorPassingViolatingConfig() {
        String topic = UUID.randomUUID().toString();
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        short x$2 = this.replicationFactor();
        int x$3 = qual$1.createTopic$default$3();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(topic, x$2, x$3, x$4, x$5, x$6);
        Assertions.assertThrows(InvalidConfigurationException.class, (Executable)new Executable(this, topic){
            private final /* synthetic */ ClusterLinkPolicyTest $outer;
            private final String topic$3;

            public void execute() {
                ClusterLinkTestHarness qual$1 = this.$outer.destCluster();
                String x$1 = this.topic$3;
                short x$2 = this.$outer.replicationFactor();
                String x$3 = this.$outer.linkName();
                HashMap x$4 = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max.compaction.lag.ms"), (Object)"900")}));
                String x$5 = qual$1.linkTopic$default$5();
                qual$1.linkTopic(x$1, x$2, x$3, (Map<String, String>)x$4, x$5);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$3 = topic$3;
            }
        }, (String)new StringBuilder(124).append("Mirror should fail with ").append(InvalidConfigurationException.class).append(" because ").append("the config overridden passed by user during mirror creation violates the destination policy").toString());
    }

    private void verifyRuntimeDestinationConfigChangeViolation() {
        String topicWithValidAlwaysSyncConfig = UUID.randomUUID().toString();
        String topicWithValidNeverSyncConfig = UUID.randomUUID().toString();
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = this.validAlwaysSyncConfig();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(topicWithValidAlwaysSyncConfig, x$2, x$3, x$4, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        int x$8 = this.numPartitions();
        short x$9 = this.replicationFactor();
        Properties x$10 = this.validNeverSyncConfig();
        ListenerName x$11 = qual$2.createTopic$default$5();
        Properties x$12 = qual$2.createTopic$default$6();
        qual$2.createTopic(topicWithValidNeverSyncConfig, x$8, x$9, x$10, x$11, x$12);
        Assertions.assertDoesNotThrow(() -> {
            ClusterLinkTestHarness qual$3 = this.destCluster();
            short x$14 = this.replicationFactor();
            String x$15 = this.linkName();
            Map<String, String> x$16 = qual$3.linkTopic$default$4();
            String x$17 = qual$3.linkTopic$default$5();
            qual$3.linkTopic(topicWithValidAlwaysSyncConfig, x$14, x$15, x$16, x$17);
            ClusterLinkTestHarness qual$4 = this.destCluster();
            short x$19 = this.replicationFactor();
            String x$20 = this.linkName();
            Map<String, String> x$21 = qual$4.linkTopic$default$4();
            String x$22 = qual$4.linkTopic$default$5();
            return qual$4.linkTopic(topicWithValidNeverSyncConfig, x$19, x$20, x$21, x$22);
        }, (String)"Mirror should not fail");
        Assertions.assertThrows(InvalidConfigurationException.class, (Executable)new Executable(this, topicWithValidAlwaysSyncConfig){
            private final /* synthetic */ ClusterLinkPolicyTest $outer;
            private final String topicWithValidAlwaysSyncConfig$2;

            public void execute() {
                this.$outer.destCluster().alterTopic(this.topicWithValidAlwaysSyncConfig$2, (Map<String, String>)((Map)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max.compaction.lag.ms"), (Object)"950")}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicWithValidAlwaysSyncConfig$2 = topicWithValidAlwaysSyncConfig$2;
            }
        }, (String)new StringBuilder(103).append("Alter config should fail with ").append(InvalidConfigurationException.class).append(" because ").append("we don't allow alternation on always-sync configs on destination").toString());
        Assertions.assertThrows(PolicyViolationException.class, (Executable)new Executable(this, topicWithValidAlwaysSyncConfig){
            private final /* synthetic */ ClusterLinkPolicyTest $outer;
            private final String topicWithValidAlwaysSyncConfig$2;

            public void execute() {
                this.$outer.destCluster().alterTopic(this.topicWithValidAlwaysSyncConfig$2, (Map<String, String>)((Map)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.ms"), (Object)"2400")}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicWithValidAlwaysSyncConfig$2 = topicWithValidAlwaysSyncConfig$2;
            }
        }, (String)new StringBuilder(79).append("Alter config should fail with ").append(PolicyViolationException.class).append(" because ").append("the config value is violating the policy").toString());
        Assertions.assertDoesNotThrow((Executable)new Executable(this, topicWithValidAlwaysSyncConfig){
            private final /* synthetic */ ClusterLinkPolicyTest $outer;
            private final String topicWithValidAlwaysSyncConfig$2;

            public void execute() {
                this.$outer.destCluster().alterTopic(this.topicWithValidAlwaysSyncConfig$2, (Map<String, String>)((Map)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.ms"), (Object)"1600")}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicWithValidAlwaysSyncConfig$2 = topicWithValidAlwaysSyncConfig$2;
            }
        }, (String)"Alter config should not fail");
    }

    public ClusterLinkPolicyTest() {
        this.replicationFactor = 1;
        this.numPartitions_$eq(1);
        this.topicSyncIntervalMs = "1000";
        this.violatingAlwaysSyncConfig = new Properties(null){
            {
                this.put("max.compaction.lag.ms", "1050");
            }
        };
        this.validAlwaysSyncConfig = new Properties(null){
            {
                this.put("max.compaction.lag.ms", "950");
            }
        };
        this.violatingNeverSyncConfig = new Properties(null){
            {
                this.put("segment.ms", "500");
            }
        };
        this.validNeverSyncConfig = new Properties(null){
            {
                this.put("segment.ms", "1500");
            }
        };
    }
}

