/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kafka.cluster.Partition;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.link.FailureType;
import kafka.link.FailureType$;
import kafka.link.FailureType$CircularMirror$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\u0005Ex!\u0002\u0012$\u0011\u0003Ac!\u0002\u0016$\u0011\u0003Y\u0003\"\u0002\u001a\u0002\t\u0003\u0019\u0004b\u0002\u001b\u0002\u0005\u0004%)!\u000e\u0005\u0007s\u0005\u0001\u000bQ\u0002\u001c\u0007\t)\u001a\u0003A\u000f\u0005\u0006e\u0015!\tA\u0010\u0005\b\u0001\u0016\u0011\r\u0011\"\u0011B\u0011\u0019)U\u0001)A\u0005\u0005\"Ia)\u0002a\u0001\u0002\u0003\u0006Ka\u0012\u0005\u0006'\u0016!\t\u0005\u0016\u0005\u0006=\u0016!\ta\u0018\u0005\u0006I\u0016!\ta\u0018\u0005\u0006M\u0016!\ta\u0018\u0005\u0006Q\u0016!\ta\u0018\u0005\u0006U\u0016!\ta\u0018\u0005\u0006Y\u0016!\ta\u0018\u0005\u0006]\u0016!\ta\u001c\u0005\b\u0003#)A\u0011AA\n\u0011\u001d\ti\"\u0002C\u0001\u0003?Aa!!\u000b\u0006\t\u0003y\u0006BBA\u0017\u000b\u0011\u0005q\fC\u0004\u00022\u0015!I!a\r\t\u0013\u0005\u0005S!%A\u0005\n\u0005\r\u0003bBA-\u000b\u0011%\u00111\f\u0005\b\u0003K*A\u0011BA4\u0011\u001d\tY'\u0002C\u0005\u0003[Ba!a\u001f\u0006\t\u0003y\u0006bBA@\u000b\u0011\u0005\u0011\u0011\u0011\u0005\b\u0003o+A\u0011AA]\u0011\u001d\t)-\u0002C\u0005\u0003\u000fD\u0011\"a6\u0006#\u0003%I!!7\t\u0013\u0005uW!%A\u0005\n\u0005e\u0007bBAp\u000b\u0011%\u0011\u0011]\u0001\u0015\u00072,8\u000f^3s\u0019&t7.\u00132qeY\"Vm\u001d;\u000b\u0005\u0011*\u0013\u0001\u00027j].T\u0011AJ\u0001\u0006W\u000647.Y\u0002\u0001!\tI\u0013!D\u0001$\u0005Q\u0019E.^:uKJd\u0015N\\6JEB\u0014d\u0007V3tiN\u0011\u0011\u0001\f\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005A\u0013!\b+fgR<\u0016\u000e\u001e5QCJ\fW.\u001a;fe&TX\r\u001a+pa&\u001c\u0017\nZ:\u0016\u0003Yz\u0011aN\u0011\u0002q\u0005i2\u0010Z5ta2\f\u0017PT1nKvtSo]3U_BL7-\u00133t{m\u0004T0\u0001\u0010UKN$x+\u001b;i!\u0006\u0014\u0018-\\3uKJL'0\u001a3U_BL7-\u00133tAM\u0011Qa\u000f\t\u0003SqJ!!P\u0012\u0003E\u0005\u00137\u000f\u001e:bGR\u001cE.^:uKJd\u0015N\\6J]R,wM]1uS>tG+Z:u)\u0005y\u0004CA\u0015\u0006\u0003E\u0011X\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN]\u000b\u0002\u0005B\u0011QfQ\u0005\u0003\t:\u0012Qa\u00155peR\f!C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8sA\u0005Iq\f^3ti&sgm\u001c\t\u0003\u0011Fk\u0011!\u0013\u0006\u0003\u0015.\u000b1!\u00199j\u0015\taU*A\u0004kkBLG/\u001a:\u000b\u00059{\u0015!\u00026v]&$(\"\u0001)\u0002\u0007=\u0014x-\u0003\u0002S\u0013\nAA+Z:u\u0013:4w.A\u0003tKR,\u0006\u000f\u0006\u0002V1B\u0011QFV\u0005\u0003/:\u0012A!\u00168ji\")\u0011L\u0003a\u0001\u000f\u0006AA/Z:u\u0013:4w\u000e\u000b\u0002\u000b7B\u0011\u0001\nX\u0005\u0003;&\u0013!BQ3g_J,W)Y2i\u0003m!Xm\u001d;T_V\u00148-Z\"iC:<W\r\u0015:pa\u0006<\u0017\r^5p]R\tQ\u000b\u000b\u0002\fCB\u0011\u0001JY\u0005\u0003G&\u0013A\u0001V3ti\u0006\tD/Z:u+:\u001cG.Z1o'>,(oY3MK\u0006$WM]#mK\u000e$\u0018n\u001c8XSRDG)Z:u\u000bB|7\r[!iK\u0006$\u0007F\u0001\u0007b\u0003m\"Xm\u001d;O_R\u0013XO\\2bi&|gNQ3m_^D\u0015n\u001a5XCR,'/\\1sW^KG\u000f[#naRLH*Z1eKJ,\u0005o\\2i\u0007\u0006\u001c\u0007.\u001a\u0015\u0003\u001b\u0005\f!\u0006^3ti6K'O]8s/&$\bnU8ve\u000e,g)Y5mkJ,7oV5uQ>cG\rR3ti&\u0003(\r\u000b\u0002\u000fC\u0006aC/Z:u\u001b&\u0014(o\u001c:XSRD7k\\;sG\u00164\u0015-\u001b7ve\u0016\u001cx+\u001b;i\u001f2$7k\\;sG\u0016L\u0005O\u0019\u0015\u0003\u001f\u0005\f!\u0005^3ti:{g.T8o_R|g.[2T_V\u00148-\u001a'fC\u0012,'/\u00129pG\"\u001c\bF\u0001\tb\u0003I\"Xm\u001d;T_V\u00148-\u001a+pa&\u001c'+Z2sK\u0006$X\rR3uK\u000e$X\rZ,ji\"TVM]8T_V\u00148-Z#q_\u000eDGCA+q\u0011\u0015\t\u0018\u00031\u0001s\u0003-)8/\u001a+pa&\u001c\u0017\nZ:\u0011\u00055\u001a\u0018B\u0001;/\u0005\u001d\u0011un\u001c7fC:DC!\u0005<\u007f\u007fB\u0011q\u000f`\u0007\u0002q*\u0011\u0011P_\u0001\taJ|g/\u001b3fe*\u00111pS\u0001\u0007a\u0006\u0014\u0018-\\:\n\u0005uD(a\u0003,bYV,7k\\;sG\u0016\f\u0001BY8pY\u0016\fgn\u001d\u0017\u0005\u0003\u0003\t\u0019!G\u0001\u00023\u0005\u0001\u0001FB\t\u0002\b\u0005=q\u0007\u0005\u0003\u0002\n\u0005-Q\"\u0001>\n\u0007\u00055!PA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fAA\\1nK\u0006\u0001D/Z:u'>,(oY3U_BL7MU3de\u0016\fG/\u001a#fi\u0016\u001cG/\u001a3XSRD')Y2lo\u0006\u0014H-\u00129pG\"$2!VA\u000b\u0011\u0015\t(\u00031\u0001sQ\u0015\u0011bO`A\rY\u0011\t\t!a\u0001)\rI\t9!a\u00048\u0003Q\"Xm\u001d;T_V\u00148-\u001a+pa&\u001c'+Z2sK\u0006$X\rR3uK\u000e$X\rZ,ji\"LenY8og&\u001cH/\u001a8u\u000bB|7\r\u001b\u000b\u0004+\u0006\u0005\u0002\"B9\u0014\u0001\u0004\u0011\b&B\nw}\u0006\u0015B\u0006BA\u0001\u0003\u0007AcaEA\u0004\u0003\u001f9\u0014a\u000b;fgR\u001cv.\u001e:dKR{\u0007/[2SK\u000e\u0014X-\u0019;f\t\u0016$Xm\u0019;fI^KG\u000f\u001b+pa&\u001c\u0017\nZ:)\u0005Q\t\u0017!\r;fgR\u001cv.\u001e:dKR{\u0007/[2SK\u000e\u0014X-\u0019;f\u001d>$H)\u001a;fGR,GmV5uQ>,H\u000fV8qS\u000eLEm\u001d\u0015\u0003+\u0005\fAd]3u+B\u001cv.\u001e:dKR{\u0007/[2EK2,G/[8o)\u0016\u001cH\u000fF\u0003V\u0003k\t9\u0004C\u0003r-\u0001\u0007!\u000fC\u0005\u0002:Y\u0001\n\u00111\u0001\u0002<\u0005Qa.^7SK\u000e|'\u000fZ:\u0011\u00075\ni$C\u0002\u0002@9\u00121!\u00138u\u0003\u0019\u001aX\r^+q'>,(oY3U_BL7\rR3mKRLwN\u001c+fgR$C-\u001a4bk2$HEM\u000b\u0003\u0003\u000bRC!a\u000f\u0002H-\u0012\u0011\u0011\n\t\u0005\u0003\u0017\n)&\u0004\u0002\u0002N)!\u0011qJA)\u0003%)hn\u00195fG.,GMC\u0002\u0002T9\n!\"\u00198o_R\fG/[8o\u0013\u0011\t9&!\u0014\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\nqCV\u001cXm\u0014:V]B\fWo]3MS:\\G#B+\u0002^\u0005\u0005\u0004BBA01\u0001\u0007!/A\u0003qCV\u001cX\rC\u0004\u0002da\u0001\r!a\u000f\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t\u00035\u0011Xm\u0019:fCR,Gk\u001c9jGR\u0019Q+!\u001b\t\u000f\u0005e\u0012\u00041\u0001\u0002<\u0005\u0019c/\u001a:jMf4\u0015-\u001b7fIN#\u0018\r^3BMR,'\u000fV8qS\u000e\u0014Vm\u0019:fCR,G#B+\u0002p\u0005E\u0004\"B9\u001b\u0001\u0004\u0011\bbBA:5\u0001\u0007\u0011QO\u0001\u001bM\u0006LG.\u001e:f)f\u0004XmV5uQ>,H\u000fV8qS\u000eLEm\u001d\t\u0004S\u0005]\u0014bAA=G\tYa)Y5mkJ,G+\u001f9f\u0003I!Xm\u001d;DSJ\u001cW\u000f\\1s\u001b&\u0014(o\u001c:)\u0005m\t\u0017a\u0006;fgRl\u0015N\u001d:pe2+w-Y2z%\u0016\u001cwN\u001d3t)\u0015)\u00161QAO\u0011\u001d\t)\t\ba\u0001\u0003\u000f\u000ba!];peVl\u0007\u0003BAE\u0003/sA!a#\u0002\u0014B\u0019\u0011Q\u0012\u0018\u000e\u0005\u0005=%bAAIO\u00051AH]8pizJ1!!&/\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011TAN\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0013\u0018\t\r\u0005}E\u00041\u0001s\u0003-\u0019wn\u001c:eS:\fGo\u001c:)\u000fq\t\u0019+!+\u0002,B\u0019q/!*\n\u0007\u0005\u001d\u0006P\u0001\u0007NKRDw\u000eZ*pkJ\u001cW-A\u0003wC2,X\r\f\u0002\u0002.\u0006\u0012\u0011qV\u0001\u000fu.\u001cu.\u001c2j]\u0006$\u0018n\u001c8tQ\u001da\u0012qAA\b\u0003g\u000b#!!.\u0002Qm$\u0017n\u001d9mCft\u0015-\\3~]E,xN];n{m\u0004TPL2p_J$\u0017N\\1u_Jl40M?\u0002gQ,7\u000f^'jeJ|'\u000fT3hC\u000eL(+Z2pe\u0012\u001cH\u000b\u001b:poNtu.\u0012=dKB$\u0018n\u001c8XQ\u0016t\u0017\t\u001c7po\u0016$G#B+\u0002<\u0006u\u0006bBAC;\u0001\u0007\u0011q\u0011\u0005\u0007\u0003?k\u0002\u0019\u0001:)\u000fu\t\u0019+!+\u0002B2\u0012\u0011Q\u0016\u0015\b;\u0005\u001d\u0011qBAZ\u00035\u0019X\r^+q\u00072,8\u000f^3sgR)Q+!3\u0002T\"I\u00111\u001a\u0010\u0011\u0002\u0003\u0007\u0011QZ\u0001\bI\u0016\u001cH/\u00132q!\u0015i\u0013qZAD\u0013\r\t\tN\f\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u0005Ug\u0004%AA\u0002\u00055\u0017!C:pkJ\u001cW-\u00132q\u0003]\u0019X\r^+q\u00072,8\u000f^3sg\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\\*\"\u0011QZA$\u0003]\u0019X\r^+q\u00072,8\u000f^3sg\u0012\"WMZ1vYR$#'A\u0013tKR,\u0006o\u00117vgR,'o]!mY><H*Z4bGflUm]:bO\u00164uN]7biR\u0019Q+a9\t\u000f\u0005U\u0017\u00051\u0001\u0002N\":Q!a:\u0002*\u00065\bc\u0001%\u0002j&\u0019\u00111^%\u0003\u0007Q\u000bw-\t\u0002\u0002p\u0006Y\u0011N\u001c;fOJ\fG/[8o\u0001")
public class ClusterLinkIbp26Test
extends AbstractClusterLinkIntegrationTest {
    private final short replicationFactor;
    private TestInfo _testInfo;

    public static String TestWithParameterizedTopicIds() {
        return "{displayName}.useTopicIds={0}";
    }

    @Override
    public short replicationFactor() {
        return this.replicationFactor;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this._testInfo = testInfo;
    }

    @Test
    public void testSourceChangePropagation() {
        this.setUpClusters((Option<String>)new Some((Object)"2.6"), (Option<String>)None$.MODULE$);
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = this.linkName();
        ClusterLinkTestHarness x$2 = this.sourceCluster();
        long x$4 = qual$1.createDestClusterLink$default$3();
        long x$5 = qual$1.createDestClusterLink$default$5();
        Properties x$6 = qual$1.createDestClusterLink$default$6();
        qual$1.createDestClusterLink(x$1, x$2, x$4, 10000L, x$5, x$6);
        this.verifyMirrorWithSourceEpochChanges(false);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        this.sourceCluster().deleteTopic(this.topic(), false);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.FAILED);
    }

    @Test
    public void testUncleanSourceLeaderElectionWithDestEpochAhead() {
        this.setUpClusters((Option<String>)new Some((Object)"2.6"), (Option<String>)None$.MODULE$);
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = this.linkName();
        ClusterLinkTestHarness x$2 = this.sourceCluster();
        long x$3 = qual$1.createDestClusterLink$default$3();
        long x$4 = qual$1.createDestClusterLink$default$4();
        long x$5 = qual$1.createDestClusterLink$default$5();
        Properties x$6 = qual$1.createDestClusterLink$default$6();
        qual$1.createDestClusterLink(x$1, x$2, x$3, x$4, x$5, x$6);
        this.verifyMirrorWithSourceEpochChanges(true);
        this.verifyLinkedLeaderChangeMetrics();
        String x$7 = this.topic();
        Seq<KafkaBroker> x$9 = this.verifyMirror$default$2();
        boolean x$10 = this.verifyMirror$default$3();
        this.verifyMirror(x$7, x$9, x$10, false);
    }

    @Test
    public void testNoTruncationBelowHighWatermarkWithEmptyLeaderEpochCache() {
        Some x$1 = new Some((Object)"2.6");
        None$ x$2 = None$.MODULE$;
        this.setUpClusters((Option<String>)x$2, (Option<String>)x$1);
        this.verifyNoTruncationBelowHighWatermarkWithEmptyLeaderEpochCache();
    }

    @Test
    public void testMirrorWithSourceFailuresWithOldDestIpb() {
        this.setUpClusters((Option<String>)new Some((Object)"2.6"), (Option<String>)None$.MODULE$);
        String sourceClusterId = ((KafkaBroker)this.sourceCluster().aliveBrokers().head()).clusterId();
        int recordsBeforeSourceFailure = 10;
        Properties x$22 = this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$1();
        int x$3 = this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$3();
        this.createLinkAndMirrorWithPartialReplicationAndShutdownSource(x$22, recordsBeforeSourceFailure, x$3);
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        KafkaBroker destLeader = this.destCluster().partitionLeader(tp);
        this.waitForMirror((Seq<KafkaBroker>)new .colon.colon((Object)destLeader, (List)Nil$.MODULE$), this.waitForMirror$default$2());
        ((IterableOnceOps)this.destCluster().brokers().filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIbp26Test.$anonfun$testMirrorWithSourceFailuresWithOldDestIpb$1(destLeader, x$2)))).foreach((Function1 & Serializable)follower -> {
            ClusterLinkIbp26Test.$anonfun$testMirrorWithSourceFailuresWithOldDestIpb$2(this, recordsBeforeSourceFailure, tp, follower);
            return BoxedUnit.UNIT;
        });
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$4 = this.topic();
        String x$5 = this.linkName();
        boolean x$8 = qual$1.unlinkTopic$default$3();
        int x$9 = qual$1.unlinkTopic$default$6();
        qual$1.unlinkTopic(x$4, x$5, x$8, false, false, x$9);
        InvalidRequestException e = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> {
            ClusterLinkTestHarness qual$2 = this.destCluster();
            Properties x$11 = this.destLinkProps((Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.LinkModeProp()), (Object)"BIDIRECTIONAL")}))));
            Some x$12 = new Some((Object)sourceClusterId);
            boolean x$13 = qual$2.createClusterLink$default$4();
            qual$2.createClusterLink("someLink", x$11, (Option<String>)x$12, x$13);
        });
        Assertions.assertTrue((boolean)e.getMessage().contains("Bi-directional links are supported only with IBP 3.1-IV0 and above"), (String)e.getMessage());
    }

    @Test
    public void testMirrorWithSourceFailuresWithOldSourceIpb() {
        Some x$1 = new Some((Object)"2.4");
        None$ x$2 = None$.MODULE$;
        this.setUpClusters((Option<String>)x$2, (Option<String>)x$1);
        Properties topicConfig = new Properties();
        this.createLinkAndMirrorWithPartialReplicationAndShutdownSource(topicConfig, this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$2(), this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$3());
        String x$3 = this.topic();
        Seq<KafkaBroker> x$6 = this.verifyMirror$default$2();
        this.verifyMirror(x$3, x$6, false, false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNonMonotonicSourceLeaderEpochs() {
        void var11_11;
        Some x$1 = new Some((Object)"2.6");
        None$ x$2 = None$.MODULE$;
        this.setUpClusters((Option<String>)x$2, (Option<String>)x$1);
        this.numPartitions_$eq(1);
        Properties topicConfigs = new Properties();
        topicConfigs.setProperty("min.insync.replicas", "1");
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$3 = this.topic();
        int x$4 = this.numPartitions();
        ListenerName x$7 = qual$1.createTopic$default$5();
        Properties x$8 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$3, x$4, 1, topicConfigs, x$7, x$8);
        TopicPartition tp = (TopicPartition)this.partitions(this.partitions$default$1(), this.partitions$default$2(), this.partitions$default$3()).head();
        this.produceToSourceCluster(10);
        Tuple2<Object, Object> tuple2 = this.sourceCluster().shutdownLeader(tp);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int leader = tuple2._1$mcI$sp();
        this.sourceCluster().startBroker((int)var11_11);
        this.produceToSourceCluster(10);
        int sourceEpoch = this.sourceCluster().leaderEpoch(tp);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$9 = this.linkName();
        ClusterLinkTestHarness x$10 = this.sourceCluster();
        long x$12 = qual$2.createDestClusterLink$default$3();
        long x$13 = qual$2.createDestClusterLink$default$5();
        Properties x$14 = qual$2.createDestClusterLink$default$6();
        qual$2.createDestClusterLink(x$9, x$10, x$12, 10000L, x$13, x$14);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$15 = this.topic();
        String x$17 = this.linkName();
        Map<String, String> x$18 = qual$3.linkTopic$default$4();
        String x$19 = qual$3.linkTopic$default$5();
        qual$3.linkTopic(x$15, (short)3, x$17, x$18, x$19);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        Partition sourcePartition = this.sourceCluster().partitionLeader(tp).replicaManager().getPartitionOrException(tp);
        TestUtils.setFieldValue((Object)sourcePartition, (String)"leaderEpoch", (Object)BoxesRunTime.boxToInteger((int)0));
        this.produceToSourceCluster(10);
        TestUtils.setFieldValue((Object)sourcePartition, (String)"leaderEpoch", (Object)BoxesRunTime.boxToInteger((int)sourceEpoch));
        this.sourceCluster().consumerConfig().setProperty("auto.offset.reset", "earliest");
        ClusterLinkTestHarness qual$4 = this.sourceCluster();
        ByteArrayDeserializer x$20 = qual$4.createConsumer$default$1();
        ByteArrayDeserializer x$21 = qual$4.createConsumer$default$2();
        Properties x$22 = qual$4.createConsumer$default$3();
        List<String> x$23 = qual$4.createConsumer$default$4();
        KafkaConsumer sourceConsumer = qual$4.createConsumer(x$20, x$21, x$22, x$23);
        sourceConsumer.assign(Collections.singleton(tp));
        Seq sourceRecords = TestUtils$.MODULE$.consumeRecords(sourceConsumer, 30, 15000L);
        ((IterableOnceOps)sourceRecords.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            ClusterLinkIbp26Test.$anonfun$testNonMonotonicSourceLeaderEpochs$1(sourceEpoch, sourceRecords, x0$1);
            return BoxedUnit.UNIT;
        });
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.FAILED);
        Partition destPartition = this.destCluster().partitionLeader(tp).replicaManager().getPartitionOrException(tp);
        Assertions.assertTrue((destPartition.getLeaderEpoch() >= sourceEpoch ? 1 : 0) != 0, (String)new StringBuilder(29).append("Unexpected dest leader epoch ").append(destPartition.getLeaderEpoch()).toString());
        Assertions.assertEquals((long)20L, (long)destPartition.localLogOrException().logEndOffset());
        ClusterLinkTestHarness qual$5 = this.destCluster();
        Properties x$24 = qual$5.createConfluentAdminClient$default$1();
        this.waitForFailure(qual$5.createConfluentAdminClient(x$24), FailureType$.MODULE$.NonMonotonicLogAppendEpoch(), this.waitForFailure$default$3());
    }

    @ParameterizedTest(name="{displayName}.useTopicIds={0}")
    @ValueSource(booleans={true, false})
    public void testSourceTopicRecreateDetectedWithZeroSourceEpoch(boolean useTopicIds) {
        this.setUpSourceTopicDeletionTest(useTopicIds, 20);
        this.recreateTopic(5);
        this.verifyFailedStateAfterTopicRecreate(useTopicIds, FailureType$.MODULE$.UnexpectedTruncation());
    }

    @ParameterizedTest(name="{displayName}.useTopicIds={0}")
    @ValueSource(booleans={true, false})
    public void testSourceTopicRecreateDetectedWithBackwardEpoch(boolean useTopicIds) {
        this.setUpSourceTopicDeletionTest(useTopicIds, 20);
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        this.sourceCluster().changeLeader(tp);
        this.produceToSourceCluster(20);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.recreateTopic(5);
        this.verifyFailedStateAfterTopicRecreate(useTopicIds, FailureType$.MODULE$.SourceTopicMayBeDeleted());
    }

    @ParameterizedTest(name="{displayName}.useTopicIds={0}")
    @ValueSource(booleans={true, false})
    public void testSourceTopicRecreateDetectedWithInconsistentEpoch(boolean useTopicIds) {
        this.setUpSourceTopicDeletionTest(useTopicIds, 10);
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        this.sourceCluster().changeLeader(tp);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> this.produceToSourceCluster(10));
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        int numRecordsMirrored = this.producedRecords().size();
        this.pauseOrUnpauseLink(true, 1);
        this.recreateTopic(10);
        this.produceToSourceCluster(10);
        this.sourceCluster().changeLeader(tp);
        this.produceToSourceCluster(10);
        this.sourceCluster().changeLeader(tp);
        this.produceToSourceCluster(10);
        this.pauseOrUnpauseLink(false, 1);
        this.truncate(this.producedRecords().size() - numRecordsMirrored);
        this.verifyFailedStateAfterTopicRecreate(useTopicIds, FailureType$.MODULE$.UnexpectedTruncation());
    }

    @Test
    public void testSourceTopicRecreateDetectedWithTopicIds() {
        this.setUpSourceTopicDeletionTest(true, 10);
        this.produceToSourceCluster(20);
        int numRecordsRetained = this.producedRecords().size();
        this.pauseOrUnpauseLink(true, 1);
        this.recreateTopic(10);
        this.sourceCluster().changeLeader(new TopicPartition(this.topic(), 0));
        this.produceToSourceCluster(10);
        this.pauseOrUnpauseLink(false, 1);
        this.truncate(this.producedRecords().size() - numRecordsRetained);
        this.verifyFailedStateAfterTopicRecreate(true, FailureType$.MODULE$.SourceTopicIdChanged());
    }

    @Test
    public void testSourceTopicRecreateNotDetectedWithoutTopicIds() {
        this.setUpSourceTopicDeletionTest(false, 10);
        this.produceToSourceCluster(20);
        this.truncate(20);
        this.pauseOrUnpauseLink(true, 1);
        this.recreateTopic(10);
        this.sourceCluster().changeLeader(new TopicPartition(this.topic(), 0));
        this.produceToSourceCluster(10);
        this.pauseOrUnpauseLink(false, 1);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
    }

    private void setUpSourceTopicDeletionTest(boolean useTopicIds, int numRecords) {
        this.numPartitions_$eq(1);
        None$ ibp = useTopicIds ? None$.MODULE$ : new Some((Object)"2.6");
        this.setUpClusters((Option<String>)ibp, (Option<String>)ibp);
        int retryMs = useTopicIds ? 60000 : 1000;
        this.setupLinkAndMirrorForFailureTest(20000L, retryMs, "testGroup", this.setupLinkAndMirrorForFailureTest$default$4());
        this.produceToSourceCluster(numRecords);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
    }

    private int setUpSourceTopicDeletionTest$default$2() {
        return 20;
    }

    private void pauseOrUnpauseLink(boolean pause, int numPartitions) {
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)Boolean.toString(pause))}))));
        if (pause) {
            this.destCluster().waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PAUSED, this.topic(), numPartitions);
            return;
        }
    }

    private void recreateTopic(int numRecords) {
        this.sourceCluster().deleteTopic(this.topic(), true);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.produceToSourceCluster(numRecords);
        this.truncate(numRecords);
    }

    private void verifyFailedStateAfterTopicRecreate(boolean useTopicIds, FailureType failureTypeWithoutTopicIds) {
        FailureType failureType = useTopicIds ? FailureType$.MODULE$.SourceTopicIdChanged() : failureTypeWithoutTopicIds;
        ClusterLinkTestHarness qual$1 = this.destCluster();
        Properties x$1 = qual$1.createConfluentAdminClient$default$1();
        this.waitForFailure(qual$1.createConfluentAdminClient(x$1), failureType, this.waitForFailure$default$3());
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.destCluster().killAllBrokers();
        ConfluentAdmin destAdmin = (ConfluentAdmin)this.restartCluster(this.destCluster(), !this.useSourceInitiatedLink()).get();
        this.waitForFailure(destAdmin, failureType, this.topic());
        String x$2 = this.topic();
        Seq<KafkaBroker> x$5 = this.verifyMirror$default$2();
        this.verifyMirror(x$2, x$5, false, false);
    }

    @Test
    public void testCircularMirror() {
        Some x$1 = new Some((Object)"2.6");
        None$ x$2 = None$.MODULE$;
        this.setUpClusters((Option<String>)x$2, (Option<String>)x$1);
        this.numPartitions_$eq(1);
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        Properties linkPropOverrides = new Properties();
        linkPropOverrides.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp(), "100");
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$3 = this.linkName();
        ClusterLinkTestHarness x$4 = this.sourceCluster();
        long x$6 = qual$1.createDestClusterLink$default$3();
        long x$7 = qual$1.createDestClusterLink$default$4();
        long x$8 = qual$1.createDestClusterLink$default$5();
        Uuid linkId = qual$1.createDestClusterLink(x$3, x$4, x$6, x$7, x$8, linkPropOverrides);
        Properties linkProps = new Properties();
        ClusterLinkTestHarness qual$2 = this.destCluster();
        ListenerName x$9 = qual$2.bootstrapServers$default$1();
        linkProps.put("bootstrap.servers", qual$2.bootstrapServers(x$9));
        linkProps.putAll((java.util.Map<?, ?>)this.destCluster().clientSecurityProps(this.linkName()));
        linkProps.put("sasl.jaas.config", this.createLinkCredentials(this.linkName(), this.destCluster(), this.createLinkCredentials$default$3()));
        ClusterLinkTestHarness qual$3 = this.sourceCluster();
        String x$10 = this.linkName();
        ClusterLinkTestHarness x$11 = this.destCluster();
        long x$13 = qual$3.createDestClusterLink$default$3();
        long x$14 = qual$3.createDestClusterLink$default$4();
        long x$15 = qual$3.createDestClusterLink$default$5();
        Uuid sourceLinkId = qual$3.createDestClusterLink(x$10, x$11, x$13, x$14, x$15, linkPropOverrides);
        ClusterLinkTestHarness qual$4 = this.sourceCluster();
        String x$16 = this.topic();
        int x$17 = this.numPartitions();
        short x$18 = this.replicationFactor();
        Properties x$19 = qual$4.createTopic$default$4();
        ListenerName x$20 = qual$4.createTopic$default$5();
        Properties x$21 = qual$4.createTopic$default$6();
        qual$4.createTopic(x$16, x$17, x$18, x$19, x$20, x$21);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$22 = this.topic();
        short x$23 = this.replicationFactor();
        String x$24 = this.linkName();
        Map<String, String> x$25 = qual$5.linkTopic$default$4();
        String x$26 = qual$5.linkTopic$default$5();
        qual$5.linkTopic(x$22, x$23, x$24, x$25, x$26);
        this.sourceCluster().deleteTopic(this.topic(), true);
        ClusterLinkTestHarness qual$6 = this.sourceCluster();
        String x$27 = this.topic();
        short x$28 = this.replicationFactor();
        String x$29 = this.linkName();
        Map<String, String> x$30 = qual$6.linkTopic$default$4();
        String x$31 = qual$6.linkTopic$default$5();
        qual$6.linkTopic(x$27, x$28, x$29, x$30, x$31);
        ClusterLinkTestHarness qual$7 = this.sourceCluster();
        Properties x$32 = qual$7.createConfluentAdminClient$default$1();
        ConfluentAdmin sourceAdmin = qual$7.createConfluentAdminClient(x$32);
        ClusterLinkTestHarness qual$8 = this.destCluster();
        Properties x$33 = qual$8.createConfluentAdminClient$default$1();
        ConfluentAdmin destAdmin = qual$8.createConfluentAdminClient(x$33);
        this.waitForReplicaState$1(sourceAdmin, FailureType$CircularMirror$.MODULE$.replicaStatusStates());
        this.waitForReplicaState$1(destAdmin, FailureType$CircularMirror$.MODULE$.replicaStatusStates());
        this.waitForBlockedPartition$1(sourceLinkId, linkId, tp);
        ClusterLinkTestHarness qual$9 = this.destCluster();
        String x$34 = this.topic();
        String x$35 = this.linkName();
        int x$37 = this.numPartitions();
        boolean x$38 = qual$9.unlinkTopic$default$3();
        boolean x$39 = qual$9.unlinkTopic$default$5();
        qual$9.unlinkTopic(x$34, x$35, x$38, false, x$39, x$37);
        this.destCluster().verifyTopicWritable(this.topic(), this.numPartitions());
        ClusterLinkTestHarness qual$10 = this.destCluster();
        ByteArraySerializer x$40 = qual$10.createProducer$default$1();
        ByteArraySerializer x$41 = qual$10.createProducer$default$2();
        Properties x$42 = qual$10.createProducer$default$3();
        KafkaProducer producer = qual$10.createProducer(x$40, x$41, x$42);
        this.produceRecords(producer, this.topic(), 20, this.produceRecords$default$4(), this.produceRecords$default$5());
        producer.close();
        this.waitForMirror((Seq<KafkaBroker>)this.sourceCluster().brokers(), this.waitForMirror$default$2());
        this.waitForReplicaState$1(sourceAdmin, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ReplicaStatus.MirrorInfo.State[]{ReplicaStatus.MirrorInfo.State.ACTIVE})));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"zkCombinations"})
    public void testMirrorLegacyRecords(String quorum, boolean coordinator) {
        Some x$1 = new Some((Object)"2.6");
        None$ x$2 = None$.MODULE$;
        this.setUpClusters((Option<String>)x$2, (Option<String>)x$1);
        this.sourceCluster().producerConfig().setProperty("enable.idempotence", "false");
        this.createClusterLink(this.linkName(), this.destLinkProps(this.destLinkProps$default$1()), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        ByteArraySerializer x$3 = qual$1.createProducer$default$1();
        ByteArraySerializer x$4 = qual$1.createProducer$default$2();
        Properties x$5 = qual$1.createProducer$default$3();
        KafkaProducer sourceProducer = qual$1.createProducer(x$3, x$4, x$5);
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        ByteArrayDeserializer x$6 = qual$2.createConsumer$default$1();
        ByteArrayDeserializer x$7 = qual$2.createConsumer$default$2();
        Properties x$8 = qual$2.createConsumer$default$3();
        List<String> x$9 = qual$2.createConsumer$default$4();
        KafkaConsumer sourceConsumer = qual$2.createConsumer(x$6, x$7, x$8, x$9);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        Properties x$10 = qual$3.createConfluentAdminClient$default$1();
        ConfluentAdmin destAdmin = qual$3.createConfluentAdminClient(x$10);
        this.verifyMessageFormat$1("topicv0", "0.9.0", sourceProducer, sourceConsumer, destAdmin);
        this.verifyMessageFormat$1("topicv1", "0.10.0", sourceProducer, sourceConsumer, destAdmin);
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$11 = this.linkName();
        boolean x$12 = qual$4.deleteClusterLink$default$2();
        scala.collection.immutable.Seq<KafkaBroker> x$13 = qual$4.deleteClusterLink$default$3();
        qual$4.deleteClusterLink(x$11, x$12, x$13);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"zkCombinations"})
    public void testMirrorLegacyRecordsThrowsNoExceptionWhenAllowed(String quorum, boolean coordinator) {
        this.setUpClustersAllowLegacyMessageFormat((Option<String>)new Some((Object)"2.6"));
        this.sourceCluster().producerConfig().setProperty("enable.idempotence", "false");
        this.createClusterLink(this.linkName(), this.destLinkProps(this.destLinkProps$default$1()), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        ByteArraySerializer x$1 = qual$1.createProducer$default$1();
        ByteArraySerializer x$2 = qual$1.createProducer$default$2();
        Properties x$3 = qual$1.createProducer$default$3();
        KafkaProducer sourceProducer = qual$1.createProducer(x$1, x$2, x$3);
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        ByteArrayDeserializer x$4 = qual$2.createConsumer$default$1();
        ByteArrayDeserializer x$5 = qual$2.createConsumer$default$2();
        Properties x$6 = qual$2.createConsumer$default$3();
        List<String> x$7 = qual$2.createConsumer$default$4();
        KafkaConsumer sourceConsumer = qual$2.createConsumer(x$4, x$5, x$6, x$7);
        this.verifyMessageFormat$2("topicv0", "0.9.0", sourceProducer, sourceConsumer);
        this.verifyMessageFormat$2("topicv1", "0.10.0", sourceProducer, sourceConsumer);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$8 = this.linkName();
        boolean x$9 = qual$3.deleteClusterLink$default$2();
        scala.collection.immutable.Seq<KafkaBroker> x$10 = qual$3.deleteClusterLink$default$3();
        qual$3.deleteClusterLink(x$8, x$9, x$10);
    }

    private void setUpClusters(Option<String> destIbp, Option<String> sourceIbp) {
        destIbp.foreach((Function1 & Serializable)ibp -> this.destCluster().serverConfig().setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), (String)ibp));
        sourceIbp.foreach((Function1 & Serializable)ibp -> this.sourceCluster().serverConfig().setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), (String)ibp));
        super.setUp(this._testInfo);
    }

    private Option<String> setUpClusters$default$1() {
        return None$.MODULE$;
    }

    private Option<String> setUpClusters$default$2() {
        return None$.MODULE$;
    }

    private void setUpClustersAllowLegacyMessageFormat(Option<String> sourceIbp) {
        this.destCluster().serverConfig().setProperty("confluent.cluster.link.allow.legacy.message.format", "true");
        sourceIbp.foreach((Function1 & Serializable)ibp -> this.sourceCluster().serverConfig().setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), (String)ibp));
        super.setUp(this._testInfo);
    }

    public static final /* synthetic */ boolean $anonfun$testMirrorWithSourceFailuresWithOldDestIpb$1(KafkaBroker destLeader$1, KafkaBroker x$2) {
        KafkaBroker kafkaBroker = x$2;
        return !(kafkaBroker != null ? !kafkaBroker.equals(destLeader$1) : destLeader$1 != null);
    }

    public static final /* synthetic */ void $anonfun$testMirrorWithSourceFailuresWithOldDestIpb$2(ClusterLinkIbp26Test $this, int recordsBeforeSourceFailure$1, TopicPartition tp$1, KafkaBroker follower) {
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)recordsBeforeSourceFailure$1)), $this.logEndOffset(follower, tp$1));
    }

    public static final /* synthetic */ void $anonfun$testNonMonotonicSourceLeaderEpochs$1(int sourceEpoch$1, Seq sourceRecords$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ConsumerRecord record = (ConsumerRecord)x0$1._1();
            int index = x0$1._2$mcI$sp();
            Integer leaderEpoch = (Integer)record.leaderEpoch().get();
            Assertions.assertEquals((int)(index >= 10 && index < 20 ? sourceEpoch$1 : 0), (Integer)leaderEpoch, (String)new StringBuilder(35).append("Unexpected epoch at index ").append(index).append(", epochs=").append(sourceRecords$1.map((Function1 & Serializable)x$3 -> x$3.leaderEpoch())).toString());
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    private final void waitForReplicaState$1(ConfluentAdmin admin, scala.collection.immutable.Set expectedStates) {
        void var4_8;
        Tuple2 tuple2;
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            scala.collection.immutable.Set computeUntilTrue_result;
            if ((computeUntilTrue_result = this.mirrorPartitionStates(admin, this.mirrorPartitionStates$default$2())).subsetOf((Set)expectedStates)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var11_6 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set actualStates = (scala.collection.immutable.Set)tuple22._1();
        Assertions.assertTrue((boolean)var4_8.subsetOf((Set)expectedStates), (String)new StringBuilder(25).append("Expected subset of ").append(expectedStates).append(", got ").append(var4_8).toString());
    }

    private static final ConcurrentHashMap waitingPartitions$1(ClusterLinkTestHarness cluster, Uuid linkId, TopicPartition tp$2) {
        return (ConcurrentHashMap)TestUtils.fieldValue((Object)cluster.partitionLeader(tp$2).clusterLinkManager().fetcherManager(linkId).get(), ClusterLinkFetcherManager.class, (String)"waitingPartitions");
    }

    public static final /* synthetic */ boolean $anonfun$testCircularMirror$3(ConcurrentHashMap sourceWaitingPartitions$1, TopicPartition tp$2, ConcurrentHashMap destWaitingPartitions$1) {
        return sourceWaitingPartitions$1.containsKey(tp$2) || destWaitingPartitions$1.containsKey(tp$2);
    }

    public static final /* synthetic */ String $anonfun$testCircularMirror$4() {
        return "Partition not blocked after consecutive epoch bumps";
    }

    /*
     * WARNING - void declaration
     */
    private final void waitForBlockedPartition$1(Uuid sourceLinkId$1, Uuid linkId$1, TopicPartition tp$2) {
        ConcurrentHashMap sourceWaitingPartitions = ClusterLinkIbp26Test.waitingPartitions$1(this.sourceCluster(), sourceLinkId$1, tp$2);
        ConcurrentHashMap destWaitingPartitions = ClusterLinkIbp26Test.waitingPartitions$1(this.destCluster(), linkId$1, tp$2);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIbp26Test.$anonfun$testCircularMirror$3(sourceWaitingPartitions, tp$2, destWaitingPartitions)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Partition not blocked after consecutive epoch bumps");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private final void verifyMessageFormat$1(String topic, String messageFormat, KafkaProducer sourceProducer$1, KafkaConsumer sourceConsumer$1, ConfluentAdmin destAdmin$1) {
        int numRecords = 20;
        Properties topicProps = new Properties();
        topicProps.setProperty("message.format.version", messageFormat);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(topic, x$2, x$3, topicProps, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(topic, x$8, x$9, x$10, x$11);
        this.producedRecords().clear();
        this.produceRecords((KafkaProducer<byte[], byte[]>)sourceProducer$1, topic, numRecords, this.produceRecords$default$4(), this.produceRecords$default$5());
        sourceConsumer$1.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava(this.partitions("", topic, this.partitions$default$3())).asJava());
        String x$14 = this.consumeRecords$default$2();
        this.consumeRecords((KafkaConsumer<byte[], byte[]>)sourceConsumer$1, x$14, topic);
        this.waitForFailure(destAdmin$1, FailureType$.MODULE$.UnsupportedMessageFormat(), topic);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        ListenerName x$16 = qual$3.deleteTopic$default$2();
        qual$3.deleteTopic(topic, x$16);
        ClusterLinkTestHarness qual$4 = this.sourceCluster();
        ListenerName x$18 = qual$4.deleteTopic$default$2();
        qual$4.deleteTopic(topic, x$18);
    }

    private final void verifyMessageFormat$2(String topic, String messageFormat, KafkaProducer sourceProducer$2, KafkaConsumer sourceConsumer$2) {
        int numRecords = 20;
        Properties topicProps = new Properties();
        topicProps.setProperty("message.format.version", messageFormat);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(topic, x$2, x$3, topicProps, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(topic, x$8, x$9, x$10, x$11);
        this.producedRecords().clear();
        this.produceRecords((KafkaProducer<byte[], byte[]>)sourceProducer$2, topic, numRecords, this.produceRecords$default$4(), this.produceRecords$default$5());
        sourceConsumer$2.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava(this.partitions("", topic, this.partitions$default$3())).asJava());
        String x$14 = this.consumeRecords$default$2();
        this.consumeRecords((KafkaConsumer<byte[], byte[]>)sourceConsumer$2, x$14, topic);
        MirrorTopicDescription destTopic = this.destCluster().describeMirrorTopic(topic);
        Assertions.assertEquals((Object)MirrorTopicDescription.State.ACTIVE, (Object)destTopic.state());
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)destTopic.mirrorTopicError());
        ClusterLinkTestHarness qual$3 = this.destCluster();
        ListenerName x$16 = qual$3.deleteTopic$default$2();
        qual$3.deleteTopic(topic, x$16);
        ClusterLinkTestHarness qual$4 = this.sourceCluster();
        ListenerName x$18 = qual$4.deleteTopic$default$2();
        qual$4.deleteTopic(topic, x$18);
    }

    public ClusterLinkIbp26Test() {
        None$ x$4 = None$.MODULE$;
        this.sourceCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_SSL, (Option<SecurityProtocol>)x$4, 0, 3));
        None$ x$8 = None$.MODULE$;
        this.destCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_PLAINTEXT, (Option<SecurityProtocol>)x$8, 100, 3));
        this.replicationFactor = (short)3;
    }

    public static final /* synthetic */ Object $anonfun$testCircularMirror$2$adapted(scala.collection.immutable.Set expectedStates$1, scala.collection.immutable.Set x$5) {
        return BoxesRunTime.boxToBoolean((boolean)x$5.subsetOf((Set)expectedStates$1));
    }
}

