/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.IntegrationTestHarness;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.audit.manager.BrokerAuditManager;
import kafka.durability.audit.request.RetentionConfigChangeRequest;
import kafka.durability.audit.request.StartOffsetChangeRequest;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.PartitionState;
import kafka.durability.events.broker.RetentionType$;
import kafka.durability.materialization.BrokerDurabilityEventsMaterialize;
import kafka.durability.materialization.validation.BrokerValidator;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.network.Processor;
import kafka.server.HostedPartition;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.scalactic.Fail;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@Disabled(value="KDATA-504/505 Thread leak and flakiness")
@ScalaSignature(bytes="\u0006\u0005\t%h\u0001\u0002\u001d:\u0001yBQ!\u0012\u0001\u0005\u0002\u0019CQ!\u0013\u0001\u0005R)Cq!\u0015\u0001C\u0002\u0013%!\u000b\u0003\u0004`\u0001\u0001\u0006Ia\u0015\u0005\bA\u0002\u0011\r\u0011\"\u0003b\u0011\u0019A\u0007\u0001)A\u0005E\"9\u0011\u000e\u0001b\u0001\n\u0013Q\u0005B\u00026\u0001A\u0003%1\nC\u0004l\u0001\t\u0007I\u0011\u0002&\t\r1\u0004\u0001\u0015!\u0003L\u0011\u001di\u0007A1A\u0005\n9DaA\u001f\u0001!\u0002\u0013y\u0007bB>\u0001\u0005\u0004%I\u0001 \u0005\b\u0003\u0007\u0001\u0001\u0015!\u0003~\u0011!\t)\u0001\u0001b\u0001\n\u0013Q\u0005bBA\u0004\u0001\u0001\u0006Ia\u0013\u0005\f\u0003\u0013\u0001\u0001\u0019!a\u0001\n\u0013\tY\u0001C\u0006\u0002\u001a\u0001\u0001\r\u00111A\u0005\n\u0005m\u0001bCA\u0014\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u001bA1\"!\u000b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002,!Y\u0011\u0011\t\u0001A\u0002\u0003\u0007I\u0011BA\"\u0011-\t9\u0005\u0001a\u0001\u0002\u0003\u0006K!!\f\t\u0017\u0005%\u0003\u00011AA\u0002\u0013%\u00111\n\u0005\f\u0003/\u0002\u0001\u0019!a\u0001\n\u0013\tI\u0006C\u0006\u0002^\u0001\u0001\r\u0011!Q!\n\u00055\u0003\"CA0\u0001\t\u0007I\u0011AA1\u0011!\ty\u0007\u0001Q\u0001\n\u0005\r\u0004\"CA9\u0001\t\u0007I\u0011AA:\u0011!\tY\b\u0001Q\u0001\n\u0005U\u0004\"CA?\u0001\t\u0007I\u0011AA1\u0011!\ty\b\u0001Q\u0001\n\u0005\r\u0004\"CAA\u0001\t\u0007I\u0011AA1\u0011!\t\u0019\t\u0001Q\u0001\n\u0005\r\u0004bBAC\u0001\u0011%\u0011q\u0011\u0005\b\u0003\u0013\u0003A\u0011IAF\u0011\u001d\tY\u000b\u0001C!\u0003\u000fCq!!.\u0001\t\u0013\t9\tC\u0004\u00028\u0002!I!!/\t\u000f\u0005}\u0006\u0001\"\u0003\u0002B\"9\u0011Q\u001c\u0001\u0005\n\u0005}\u0007\"CAv\u0001E\u0005I\u0011BAw\u0011\u001d\u0011\u0019\u0001\u0001C\u0005\u0005\u000bA\u0011Ba\u0003\u0001#\u0003%I!!<\t\u000f\t5\u0001\u0001\"\u0003\u0003\u0010!9!Q\u0006\u0001\u0005\u0002\t=\u0002b\u0002B2\u0001\u0011\u0005!Q\r\u0005\b\u0005_\u0002A\u0011\u0001B9\u0011\u001d\u0011Y\b\u0001C\u0001\u0005{BqAa\"\u0001\t\u0003\u0011I\tC\u0004\u0003\u0014\u0002!\tA!&\t\u000f\t}\u0005\u0001\"\u0001\u0003\"\"9!1\u0016\u0001\u0005\u0002\t5\u0006b\u0002B\\\u0001\u0011\u0005!\u0011\u0018\u0005\b\u0005\u0007\u0004A\u0011\u0001Bc\u0011\u001d\u0011y\r\u0001C\u0001\u0005#\u0014a\u0004R;sC\nLG.\u001b;z\u0003V$\u0017\u000e^%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005iZ\u0014aC5oi\u0016<'/\u0019;j_:T\u0011\u0001P\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\b\u0005\u0002A\u00076\t\u0011I\u0003\u0002Cw\u0005\u0019\u0011\r]5\n\u0005\u0011\u000b%AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u00059\u0005C\u0001%\u0001\u001b\u0005I\u0014a\u00032s_.,'oQ8v]R,\u0012a\u0013\t\u0003\u0019>k\u0011!\u0014\u0006\u0002\u001d\u0006)1oY1mC&\u0011\u0001+\u0014\u0002\u0004\u0013:$\u0018AB3ySR,G-F\u0001T!\t!V,D\u0001V\u0015\t1v+\u0001\u0004bi>l\u0017n\u0019\u0006\u00031f\u000b!bY8oGV\u0014(/\u001a8u\u0015\tQ6,\u0001\u0003vi&d'\"\u0001/\u0002\t)\fg/Y\u0005\u0003=V\u0013Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017aB3ySR,G\rI\u0001\u0006i>\u0004\u0018nY\u000b\u0002EB\u00111MZ\u0007\u0002I*\u0011QmW\u0001\u0005Y\u0006tw-\u0003\u0002hI\n11\u000b\u001e:j]\u001e\fa\u0001^8qS\u000e\u0004\u0013A\u00039beRLG/[8og\u0006Y\u0001/\u0019:uSRLwN\\:!\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\u0002\u0019A\f'\u000f^5uS>t\u0017\n\u001a\u0011\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\tq\u000e\u0005\u0002qq6\t\u0011O\u0003\u0002sg\u000611m\\7n_:T!\u0001\u0010;\u000b\u0005U4\u0018AB1qC\u000eDWMC\u0001x\u0003\ry'oZ\u0005\u0003sF\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\bu_BL7\rU1si&$\u0018n\u001c8!\u0003I!x\u000e]5d!\u0006\u0014H/\u001b;j_:d\u0015n\u001d;\u0016\u0003u\u00042A`@p\u001b\u0005I\u0016bAA\u00013\n!A*[:u\u0003M!x\u000e]5d!\u0006\u0014H/\u001b;j_:d\u0015n\u001d;!\u0003!\u0011'o\\6fe&#\u0017!\u00032s_.,'/\u00133!\u0003\u0019\u0011'o\\6feV\u0011\u0011Q\u0002\t\u0005\u0003\u001f\t)\"\u0004\u0002\u0002\u0012)\u0019\u00111C\u001e\u0002\rM,'O^3s\u0013\u0011\t9\"!\u0005\u0003\u0017-\u000bgm[1Ce>\\WM]\u0001\u000bEJ|7.\u001a:`I\u0015\fH\u0003BA\u000f\u0003G\u00012\u0001TA\u0010\u0013\r\t\t#\u0014\u0002\u0005+:LG\u000fC\u0005\u0002&I\t\t\u00111\u0001\u0002\u000e\u0005\u0019\u0001\u0010J\u0019\u0002\u000f\t\u0014xn[3sA\u0005a\u0011-\u001e3ji6\u000bg.Y4feV\u0011\u0011Q\u0006\t\u0005\u0003_\ti$\u0004\u0002\u00022)!\u00111GA\u001b\u0003\u001di\u0017M\\1hKJTA!a\u000e\u0002:\u0005)\u0011-\u001e3ji*\u0019\u00111H\u001e\u0002\u0015\u0011,(/\u00192jY&$\u00180\u0003\u0003\u0002@\u0005E\"A\u0005\"s_.,'/Q;eSRl\u0015M\\1hKJ\f\u0001#Y;eSRl\u0015M\\1hKJ|F%Z9\u0015\t\u0005u\u0011Q\t\u0005\n\u0003K)\u0012\u0011!a\u0001\u0003[\tQ\"Y;eSRl\u0015M\\1hKJ\u0004\u0013a\u00017pOV\u0011\u0011Q\n\t\u0005\u0003\u001f\n\u0019&\u0004\u0002\u0002R)\u0019\u0011\u0011J\u001e\n\t\u0005U\u0013\u0011\u000b\u0002\f\u0003\n\u001cHO]1di2{w-A\u0004m_\u001e|F%Z9\u0015\t\u0005u\u00111\f\u0005\n\u0003KA\u0012\u0011!a\u0001\u0003\u001b\nA\u0001\\8hA\u00051b.\u001a;x_J\\\u0007K]8dKN\u001cxN\u001d'pO\u001e,'/\u0006\u0002\u0002dA!\u0011QMA6\u001b\t\t9GC\u0002\u0002jQ\fQ\u0001\\8hi)LA!!\u001c\u0002h\t1Aj\\4hKJ\fqC\\3uo>\u00148\u000e\u0015:pG\u0016\u001c8o\u001c:M_\u001e<WM\u001d\u0011\u0002'9;\u0006K]8dKN\u001cxN\u001d'pO2+g/\u001a7\u0016\u0005\u0005U\u0004\u0003BA3\u0003oJA!!\u001f\u0002h\t)A*\u001a<fY\u0006!bj\u0016)s_\u000e,7o]8s\u0019><G*\u001a<fY\u0002\nq\"\\1uKJL\u0017\r\\5{CRLwN\\\u0001\u0011[\u0006$XM]5bY&T\u0018\r^5p]\u0002\n\u0011B^1mS\u0012\fGo\u001c:\u0002\u0015Y\fG.\u001b3bi>\u0014\b%A\u0007d_:4\u0017nZ;sK6{7m\u001b\u000b\u0003\u0003;\tQa]3u+B$B!!\b\u0002\u000e\"9\u0011qR\u0012A\u0002\u0005E\u0015\u0001\u0003;fgRLeNZ8\u0011\t\u0005M\u0015qT\u0007\u0003\u0003+S1AQAL\u0015\u0011\tI*a'\u0002\u000f),\b/\u001b;fe*\u0019\u0011Q\u0014<\u0002\u000b),h.\u001b;\n\t\u0005\u0005\u0016Q\u0013\u0002\t)\u0016\u001cH/\u00138g_\"\u001a1%!*\u0011\t\u0005M\u0015qU\u0005\u0005\u0003S\u000b)J\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004I\u0005=\u0006\u0003BAJ\u0003cKA!a-\u0002\u0016\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001.o\u0006LG/\u00168uS2\fE\u000e\u001c)f]\u0012Lgn\u001a#ve\u0006\u0014\u0017\u000e\\5us\u00163XM\u001c;t\u0003J,g\t\\;tQ\u0016$\u0017a\u00049s_\u0012,8-Z'fgN\fw-Z:\u0015\t\u0005u\u00111\u0018\u0005\u0007\u0003{3\u0003\u0019A&\u0002\u00179,X.T3tg\u0006<Wm]\u0001\u0013G>t7/^7f\u00032dW*Z:tC\u001e,7\u000f\u0006\u0003\u0002D\u0006m\u0007CBAc\u0003\u0017\fy-\u0004\u0002\u0002H*\u0019\u0011\u0011Z'\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002N\u0006\u001d'aA*fcB)A*!5\u0002V&\u0019\u00111['\u0003\u000b\u0005\u0013(/Y=\u0011\u00071\u000b9.C\u0002\u0002Z6\u0013AAQ=uK\"1\u0011QX\u0014A\u0002-\u000b!\"\u001b8ji&\fG.\u001b>f)\u0011\ti\"!9\t\u0013\u0005\r\b\u0006%AA\u0002\u0005\u0015\u0018aD2sK\u0006$X\rV8qS\u000e4E.Y4\u0011\u00071\u000b9/C\u0002\u0002j6\u0013qAQ8pY\u0016\fg.\u0001\u000bj]&$\u0018.\u00197ju\u0016$C-\u001a4bk2$H%M\u000b\u0003\u0003_TC!!:\u0002r.\u0012\u00111\u001f\t\u0005\u0003k\fy0\u0004\u0002\u0002x*!\u0011\u0011`A~\u0003%)hn\u00195fG.,GMC\u0002\u0002~6\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\t!a>\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bqe\u0016\u0004\u0018M]3US\u0016\u0014Hj\\4\u0015\t\u0005u!q\u0001\u0005\n\u0005\u0013Q\u0003\u0013!a\u0001\u0003K\f\u0011c]5{KJ+G/\u001a8uS>tG+Z:u\u0003a\u0001(/\u001a9be\u0016$\u0016.\u001a:M_\u001e$C-\u001a4bk2$H%M\u0001\u0012C2$XM\u001d\"s_.,'oQ8oM&<GCBA\u000f\u0005#\u0011I\u0003C\u0004\u0003\u00141\u0002\rA!\u0006\u0002\u000fA\u0014x\u000e]&fsB!!q\u0003B\u0013\u001d\u0011\u0011IB!\t\u0011\u0007\tmQ*\u0004\u0002\u0003\u001e)\u0019!qD\u001f\u0002\rq\u0012xn\u001c;?\u0013\r\u0011\u0019#T\u0001\u0007!J,G-\u001a4\n\u0007\u001d\u00149CC\u0002\u0003$5CqAa\u000b-\u0001\u0004\u0011)\"A\u0005qe>\u0004h+\u00197vK\u0006yB/Z:u\tV\u0014\u0018MY5mSRL\u0018)\u001e3jiR{\u0007/[2D_:4\u0017nZ:\u0015\t\u0005u!\u0011\u0007\u0005\b\u0005gi\u0003\u0019\u0001B\u000b\u0003\u0019\tXo\u001c:v[\":QFa\u000e\u0003H\t%\u0003\u0003\u0002B\u001d\u0005\u0007j!Aa\u000f\u000b\t\tu\"qH\u0001\taJ|g/\u001b3fe*!!\u0011IAL\u0003\u0019\u0001\u0018M]1ng&!!Q\tB\u001e\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\"!1\nB(C\t\u0011i%\u0001\u0002{W\u0006\u0012!\u0011K\u0001\u0006WJ\fg\r\u001e\u0015\b[\tU#Q\fB0!\u0011\u00119F!\u0017\u000e\u0005\t}\u0012\u0002\u0002B.\u0005\u007f\u0011\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u0005\t\u0005\u0014\u0001G>eSN\u0004H.Y=OC6,WPL9v_J,X.P>1{\u0006aC/Z:u'&l\u0007\u000f\\3EkJ\f'-\u001b7jif\fU\u000fZ5u\u0011\u0006tG\r\\3t\t\u0016dW\r^3SK\u000e|'\u000f\u001a\u000b\u0005\u0003;\u00119\u0007C\u0004\u000349\u0002\rA!\u0006)\u000f9\u00129Da\u0012\u0003l1\"!1\nB(Q\u001dq#Q\u000bB/\u0005?\n!\u0006^3tiNKW\u000e\u001d7f\tV\u0014\u0018MY5mSRL\u0018)\u001e3jiRKWM\u001d#fY\u0016$\u0018n\u001c8MCB\u001cX\r\u0006\u0003\u0002\u001e\tM\u0004b\u0002B\u001a_\u0001\u0007!Q\u0003\u0015\b_\t]\"q\tB<Y\u0011\u0011YEa\u0014)\u000f=\u0012)F!\u0018\u0003`\u0005aC/Z:u\tV\u0014\u0018MY5mSRL\u0018)\u001e3jiRKWM\u001d#fY\u0016$\u0018n\u001c8Ek\u0016$vn\u0015>Ce\u0016\f7\r\u001b\u000b\u0005\u0003;\u0011y\bC\u0004\u00034A\u0002\rA!\u0006)\u000fA\u00129Da\u0012\u0003\u00042\"!1\nB(Q\u001d\u0001$Q\u000bB/\u0005?\nq\u0005^3tiJ+G/\u001a8uS>t7\t[1oO\u0016,e/\u001a8u\tV\u0014\u0018MY5mSRL\u0018)\u001e3jiR!\u0011Q\u0004BF\u0011\u001d\u0011\u0019$\ra\u0001\u0005+As!\rB\u001c\u0005\u000f\u0012y\t\f\u0003\u0003L\t=\u0003fB\u0019\u0003V\tu#qL\u00011i\u0016\u001cH\u000fR;sC\nLG.\u001b;z\u0003V$\u0017\u000e\u001e%jO\"<\u0016\r^3s\u001b\u0006\u00148.\u00129pG\"\u001c\u0005.\u00198hK\u00163XM\u001c;\u0015\t\u0005u!q\u0013\u0005\b\u0005g\u0011\u0004\u0019\u0001B\u000bQ\u001d\u0011$q\u0007B$\u00057cCAa\u0013\u0003P!:!G!\u0016\u0003^\t}\u0013a\n;fgR$UO]1cS2LG/_!vI&$H)\u001a7fi\u0016\u0004\u0016M\u001d;ji&|g.\u0012<f]R$B!!\b\u0003$\"9!1G\u001aA\u0002\tU\u0001fB\u001a\u00038\t\u001d#q\u0015\u0017\u0005\u0005\u0017\u0012y\u0005K\u00044\u0005+\u0012iFa\u0018\u0002OQ,7\u000f\u001e#ve\u0006\u0014\u0017\u000e\\5usN#\u0018M\u001d;PM\u001a\u001cX\r\u001e'baN,Gk\u001c7fe\u0006t7-\u001a\u000b\u0005\u0003;\u0011y\u000bC\u0004\u00034Q\u0002\rA!\u0006)\u000fQ\u00129Da\u0012\u000342\"!1\nB(Q\u001d!$Q\u000bB/\u0005?\nA\t^3ti\u0012+(/\u00192jY&$\u00180Q;eSR\u001c\u0015\r^2iS:<\u0007*[4i/\u0006$XM]'be.d\u0015\r]:f\u0013:,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:$B!!\b\u0003<\"9!1G\u001bA\u0002\tU\u0001fB\u001b\u00038\t\u001d#q\u0018\u0017\u0005\u0005\u0017\u0012y\u0005K\u00046\u0005+\u0012iFa\u0018\u0002WQ,7\u000f\u001e#ve\u0006\u0014\u0017\u000e\\5us\u0006+H-\u001b;DCR\u001c\u0007.\u001b8h'R\f'\u000f^(gMN,G\u000fT1qg\u0016$B!!\b\u0003H\"9!1\u0007\u001cA\u0002\tU\u0001f\u0002\u001c\u00038\t\u001d#1\u001a\u0017\u0005\u0005\u0017\u0012y\u0005K\u00047\u0005+\u0012iFa\u0018\u0002MQ,7\u000f\u001e#ve\u0006\u0014\u0017\u000e\\5us\u0006+H-\u001b;IC:$G.Z:EK2,G/\u001a*fG>\u0014H\r\u0006\u0003\u0002\u001e\tM\u0007b\u0002B\u001ao\u0001\u0007!Q\u0003\u0015\bo\t]\"q\tBlY\u0011\u0011YEa\u0014)\u000f]\u0012)F!\u0018\u0003`!:\u0001A!8\u0003d\n\u0015\b\u0003BAJ\u0005?LAA!9\u0002\u0016\nAA)[:bE2,G-A\u0003wC2,X-\t\u0002\u0003h\u000693\nR!U\u00036*\u0004\u0007N\u00186aU\u0002C\u000b\u001b:fC\u0012\u0004C.Z1lA\u0005tG\r\t4mC.Lg.Z:t\u0001")
public class DurabilityAuditIntegrationTest
extends IntegrationTestHarness {
    private final AtomicBoolean exited = new AtomicBoolean(false);
    private final String topic = new StringBuilder(10).append("test_topic").append(new Random().nextLong()).toString();
    private final int partitions;
    private final int partitionId;
    private final TopicPartition topicPartition = new TopicPartition(this.topic(), this.partitionId());
    private final java.util.List<TopicPartition> topicPartitionList = Collections.singletonList(this.topicPartition());
    private final int brokerId;
    private KafkaBroker broker;
    private BrokerAuditManager auditManager;
    private AbstractLog log;
    private final Logger networkProcessorLogger = Logger.getLogger(Processor.class);
    private final Level NWProcessorLogLevel = this.networkProcessorLogger().getLevel();
    private final Logger materialization = Logger.getLogger(BrokerDurabilityEventsMaterialize.class);
    private final Logger validator = Logger.getLogger(BrokerValidator.class);

    @Override
    public int brokerCount() {
        return 1;
    }

    private AtomicBoolean exited() {
        return this.exited;
    }

    private String topic() {
        return this.topic;
    }

    private int partitions() {
        return this.partitions;
    }

    private int partitionId() {
        return this.partitionId;
    }

    private TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private java.util.List<TopicPartition> topicPartitionList() {
        return this.topicPartitionList;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private KafkaBroker broker() {
        return this.broker;
    }

    private void broker_$eq(KafkaBroker x$1) {
        this.broker = x$1;
    }

    private BrokerAuditManager auditManager() {
        return this.auditManager;
    }

    private void auditManager_$eq(BrokerAuditManager x$1) {
        this.auditManager = x$1;
    }

    private AbstractLog log() {
        return this.log;
    }

    private void log_$eq(AbstractLog x$1) {
        this.log = x$1;
    }

    public Logger networkProcessorLogger() {
        return this.networkProcessorLogger;
    }

    public Level NWProcessorLogLevel() {
        return this.NWProcessorLogLevel;
    }

    public Logger materialization() {
        return this.materialization;
    }

    public Logger validator() {
        return this.validator;
    }

    private void configureMock() {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierEnableProp(), Boolean.toString(true));
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), Boolean.toString(true));
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierS3BucketProp(), "my-bucket");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "5");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierFetcherMemoryPoolSizeBytesProp(), Integer.toString(0x100000));
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierPartitionStateCleanupEnableProp(), Boolean.toString(true));
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierPartitionStateCleanupIntervalMsProp(), "0");
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        Exit.setExitProcedure((x$4, x$5) -> this.exited().set(true));
        super.setUp(testInfo);
        this.networkProcessorLogger().setLevel(Level.FATAL);
        this.materialization().setLevel(Level.ERROR);
        this.validator().setLevel(Level.ERROR);
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.networkProcessorLogger().setLevel(this.NWProcessorLogLevel());
        super.tearDown();
        Assertions.assertFalse((boolean)this.exited().get());
    }

    private void waitUntilAllPendingDurabilityEventsAreFlushed() {
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$waitUntilAllPendingDurabilityEventsAreFlushed$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to flush all the events from durability audit queue.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), waitUntilTrue_pause));
        }
    }

    private void produceMessages(int numMessages) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> TestUtils$.MODULE$.produceMessage(new .colon.colon((Object)this.broker(), (List)Nil$.MODULE$), this.topic(), "message", (Long)null, 30000, 20000));
    }

    private Seq<byte[]> consumeAllMessages(int numMessages) {
        Seq seq;
        try (KafkaConsumer resource_resource = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());){
            seq = DurabilityAuditIntegrationTest.$anonfun$consumeAllMessages$1(this, numMessages, resource_resource);
        }
        return seq;
    }

    /*
     * WARNING - void declaration
     */
    private void initialize(boolean createTopicFlag) {
        if (createTopicFlag) {
            try (Admin resource_resource = this.createAdminClient(this.listenerName(), this.adminClientConfig());){
                DurabilityAuditIntegrationTest.$anonfun$initialize$1(this, resource_resource);
            }
            Object var5_2 = null;
            this.waitUntilLogCreatedOnBrokers(this.topicPartition());
        }
        this.broker_$eq((KafkaBroker)this.brokerForId(this.brokerId()).get());
        this.auditManager_$eq((BrokerAuditManager)this.broker().auditManager().get());
        this.waitUntilAllPendingDurabilityEventsAreFlushed();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$initialize$2(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Log not ready");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        LogManager qual$2 = this.broker().replicaManager().logManager();
        TopicPartition x$10 = this.topicPartition();
        boolean x$11 = qual$2.getLog$default$2();
        this.log_$eq((AbstractLog)qual$2.getLog(x$10, x$11).get());
    }

    private boolean initialize$default$1() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void prepareTierLog(boolean sizeRetentionTest) {
        this.initialize(true);
        this.produceMessages(50);
        if (!sizeRetentionTest) {
            Assertions.assertEquals((int)50, (int)this.consumeAllMessages(50).length());
        }
        this.waitUntilAllPendingDurabilityEventsAreFlushed();
        this.auditManager().auditRequestsQueue().offer(new RetentionConfigChangeRequest(new TopicIdPartition((Uuid)this.log().topicId().getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID), this.log().topicPartition()), BoxesRunTime.unboxToInt((Object)this.log().latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1)), this.log().config().retentionSize, this.log().config().retentionMs, this.log().config().compact()));
        AbstractLog qual$1 = this.log();
        Option x$1 = qual$1.roll$default$1();
        long x$2 = qual$1.roll$default$2();
        qual$1.roll(x$1, x$2);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$prepareTierLog$3(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"failed waiting for archiving");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$prepareTierLog$5(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"hot set reduction did not kick in");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        this.waitUntilAllPendingDurabilityEventsAreFlushed();
        Assertions.assertEquals((long)this.auditManager().metricsManager().totalLostMessages(), (long)0L);
        HostedPartition hostedPartition = this.broker().replicaManager().getPartition(this.log().topicPartition());
        if (hostedPartition instanceof HostedPartition.Online) {
            ((HostedPartition.Online)hostedPartition).partition().deleteRecordsOnLeader(1L);
        } else {
            new Fail((Object)new StringBuilder(32).append("Not able to find partition for ").append(this.broker()).append(" ").append(this.log().topicPartition()).toString());
        }
        Assertions.assertTrue((this.log().logStartOffset() > 0L ? 1 : 0) != 0);
    }

    private boolean prepareTierLog$default$1() {
        return false;
    }

    private void alterBrokerConfig(String propKey, String propValue) {
        AlterConfigOp alterConfigOp = new AlterConfigOp(new ConfigEntry(propKey, propValue), AlterConfigOp.OpType.SET);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.BROKER, "0"), Collections.singletonList(alterConfigOp));
        try (ConfluentAdmin resource_resource = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());){
            DurabilityAuditIntegrationTest.$anonfun$alterBrokerConfig$1(configs, resource_resource);
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDurabilityAuditTopicConfigs(String quorum) {
        this.waitUntilLogCreatedOnBrokers(new TopicPartition(DurabilityAuditConstants$.MODULE$.TOPIC_NAME(), 0));
        try (ConfluentAdmin resource_resource = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());){
            DurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditTopicConfigs$1(resource_resource);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSimpleDurabilityAuditHandlesDeleteRecord(String quorum) {
        this.prepareTierLog(false);
        HostedPartition hostedPartition = this.broker().replicaManager().getPartition(this.log().topicPartition());
        if (hostedPartition instanceof HostedPartition.Online) {
            ((HostedPartition.Online)hostedPartition).partition().deleteRecordsOnLeader(this.log().localLogStartOffset());
        } else {
            new Fail((Object)new StringBuilder(32).append("Not able to find partition for ").append(this.broker()).append(" ").append(this.log().topicPartition()).toString());
        }
        this.waitUntilAllPendingDurabilityEventsAreFlushed();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$testSimpleDurabilityAuditHandlesDeleteRecord$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed tier segment deletion");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)this.log().localLogStartOffset(), (long)this.log().logStartOffset());
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$testSimpleDurabilityAuditHandlesDeleteRecord$3(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Timeout waiting for durability event materialization");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)0L, (long)this.auditManager().metricsManager().totalLostMessages());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSimpleDurabilityAuditTierDeletionLapse(String quorum) {
        this.prepareTierLog(false);
        this.log().maybeIncrementLogStartOffset(this.log().localLogStartOffset(), LogStartOffsetIncrementReason.LeaderOffsetIncremented);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$testSimpleDurabilityAuditTierDeletionLapse$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed tier segment deletion");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)this.log().localLogStartOffset(), (long)this.log().logStartOffset());
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$testSimpleDurabilityAuditTierDeletionLapse$3(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Timeout waiting for durability event materialization");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((this.auditManager().metricsManager().totalLostMessages() > 0L ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDurabilityAuditTierDeletionDueToSzBreach(String quorum) {
        this.alterBrokerConfig(KafkaConfig$.MODULE$.LogSegmentBytesProp(), "1000");
        this.alterBrokerConfig(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "1000");
        this.prepareTierLog(true);
        Assertions.assertTrue((this.log().logStartOffset() > 0L ? 1 : 0) != 0);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditTierDeletionDueToSzBreach$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed retention based tier deletion");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditTierDeletionDueToSzBreach$3(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"not deleted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        long offset = this.log().logStartOffset();
        this.produceMessages(50);
        this.waitUntilAllPendingDurabilityEventsAreFlushed();
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditTierDeletionDueToSzBreach$7(this, offset)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Failed retention based tier deletion");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)0L, (long)this.auditManager().metricsManager().totalLostMessages());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testRetentionChangeEventDurabilityAudit(String quorum) {
        void var3_19;
        Tuple2 tuple2;
        this.alterBrokerConfig(KafkaConfig$.MODULE$.LogSegmentBytesProp(), "1000");
        this.alterBrokerConfig(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "1073741824");
        this.prepareTierLog(false);
        Assertions.assertTrue((this.log().logStartOffset() > 0L ? 1 : 0) != 0);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$testRetentionChangeEventDurabilityAudit$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$testRetentionChangeEventDurabilityAudit$3(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Failed retention based tier deletion");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        long l3 = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            long l4 = DurabilityAuditIntegrationTest.$anonfun$testRetentionChangeEventDurabilityAudit$5(this);
            Long computeUntilTrue_result = BoxesRunTime.boxToLong((long)l4);
            if (DurabilityAuditIntegrationTest.$anonfun$testRetentionChangeEventDurabilityAudit$8(l4)) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var23_11 = null;
        long l5 = 100L;
        long computeUntilTrue_waitTime2 = 15000L;
        long computeUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            long l6 = DurabilityAuditIntegrationTest.$anonfun$testRetentionChangeEventDurabilityAudit$9(this);
            Long computeUntilTrue_result = BoxesRunTime.boxToLong((long)l6);
            if (DurabilityAuditIntegrationTest.$anonfun$testRetentionChangeEventDurabilityAudit$10(l6)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime2 + computeUntilTrue_waitTime2) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime2), (long)computeUntilTrue_pause));
        }
        Object var30_17 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        long lapseCount = tuple22._1$mcJ$sp();
        Assertions.assertTrue((var3_19 > 0L ? 1 : 0) != 0);
        this.auditManager().auditRequestsQueue().offer(new RetentionConfigChangeRequest(new TopicIdPartition((Uuid)this.log().topicId().getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID), this.log().topicPartition()), BoxesRunTime.unboxToInt((Object)this.log().latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1)), 1000L, -1L, this.log().config().compact()));
        this.waitUntilAllPendingDurabilityEventsAreFlushed();
        long l7 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$testRetentionChangeEventDurabilityAudit$13(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Retention event not propagated");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        long l8 = 100L;
        long waitUntilTrue_waitTimeMs4 = 15000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$testRetentionChangeEventDurabilityAudit$15(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        long l9 = 100L;
        long waitUntilTrue_waitTimeMs5 = 15000L;
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$testRetentionChangeEventDurabilityAudit$17(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)"Failed retention based tier deletion");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
        }
        long l10 = 100L;
        long computeUntilTrue_waitTime3 = 15000L;
        long computeUntilTrue_startTime3 = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            long l11 = DurabilityAuditIntegrationTest.$anonfun$testRetentionChangeEventDurabilityAudit$19(this);
            Long computeUntilTrue_result = BoxesRunTime.boxToLong((long)l11);
            if (DurabilityAuditIntegrationTest.$anonfun$testRetentionChangeEventDurabilityAudit$22(l11)) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime3 + computeUntilTrue_waitTime3) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime3), (long)computeUntilTrue_pause));
        }
        Object var55_32 = null;
        Assertions.assertEquals((long)var3_19, (long)this.auditManager().metricsManager().totalLostMessages());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDurabilityAuditHighWaterMarkEpochChangeEvent(String quorum) {
        void var5_15;
        Tuple2 tuple2;
        this.prepareTierLog(false);
        long end = this.log().highWatermark();
        this.waitUntilAllPendingDurabilityEventsAreFlushed();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditHighWaterMarkEpochChangeEvent$1(this, end)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"HWM not set");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.log().truncateTo(end - 5L);
        this.auditManager().auditRequestsQueue().offer(new StartOffsetChangeRequest(new TopicIdPartition((Uuid)this.log().topicId().getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID), this.log().topicPartition()), 0, this.log().highWatermark(), this.log().logStartOffset(), RetentionType$.MODULE$.Other(), -1L, -1L));
        this.waitUntilAllPendingDurabilityEventsAreFlushed();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditHighWaterMarkEpochChangeEvent$4(this, end)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"HWM not updated");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        long l3 = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            long l4 = DurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditHighWaterMarkEpochChangeEvent$6(this);
            Long computeUntilTrue_result = BoxesRunTime.boxToLong((long)l4);
            if (DurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditHighWaterMarkEpochChangeEvent$7(l4)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var25_12 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        long lapse = tuple22._1$mcJ$sp();
        Assertions.assertTrue((var5_15 > 0L ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDurabilityAuditDeletePartitionEvent(String quorum) {
        this.prepareTierLog(false);
        long end = this.log().highWatermark();
        this.waitUntilAllPendingDurabilityEventsAreFlushed();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditDeletePartitionEvent$1(this, end)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"HWM not set");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditDeletePartitionEvent$3(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Partition record does not exists");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        HostedPartition hostedPartition = this.broker().replicaManager().getPartition(this.log().topicPartition());
        if (hostedPartition instanceof HostedPartition.Online) {
            ((HostedPartition.Online)hostedPartition).partition().delete();
        } else {
            new Fail((Object)new StringBuilder(32).append("Not able to find partition for ").append(this.broker()).append(" ").append(this.log().topicPartition()).toString());
        }
        this.waitUntilAllPendingDurabilityEventsAreFlushed();
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditDeletePartitionEvent$5(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Partition record still exists");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDurabilityStartOffsetLapseTolerance(String quorum) {
        this.alterBrokerConfig(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "-1");
        this.alterBrokerConfig(KafkaConfig$.MODULE$.LogRetentionTimeMillisProp(), "-1");
        this.prepareTierLog(false);
        long offset = this.log().tierPartitionState().endOffset();
        HostedPartition hostedPartition = this.broker().replicaManager().getPartition(this.log().topicPartition());
        if (hostedPartition instanceof HostedPartition.Online) {
            ((HostedPartition.Online)hostedPartition).partition().deleteRecordsOnLeader(offset);
        } else {
            new Fail((Object)new StringBuilder(32).append("Not able to find partition for ").append(this.broker()).append(" ").append(this.log().topicPartition()).toString());
        }
        this.waitUntilAllPendingDurabilityEventsAreFlushed();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$testDurabilityStartOffsetLapseTolerance$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.produceMessages(20);
        Assertions.assertEquals((int)21, (int)this.consumeAllMessages(21).length());
        this.waitUntilAllPendingDurabilityEventsAreFlushed();
        AbstractLog qual$1 = this.log();
        Option x$1 = qual$1.roll$default$1();
        long x$2 = qual$1.roll$default$2();
        qual$1.roll(x$1, x$2);
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$testDurabilityStartOffsetLapseTolerance$3(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"failed waiting for archiving");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        this.log().maybeIncrementLogStartOffset(offset + 5L, LogStartOffsetIncrementReason.LeaderOffsetIncremented);
        this.waitUntilAllPendingDurabilityEventsAreFlushed();
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$testDurabilityStartOffsetLapseTolerance$5(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs4 = 15000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$testDurabilityStartOffsetLapseTolerance$7(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"events not processed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        HostedPartition hostedPartition2 = this.broker().replicaManager().getPartition(this.log().topicPartition());
        if (hostedPartition2 instanceof HostedPartition.Online) {
            ((HostedPartition.Online)hostedPartition2).partition().deleteRecordsOnLeader(offset + 5L);
        } else {
            new Fail((Object)new StringBuilder(32).append("Not able to find partition for ").append(this.broker()).append(" ").append(this.log().topicPartition()).toString());
        }
        this.waitUntilAllPendingDurabilityEventsAreFlushed();
        long l5 = 100L;
        long waitUntilTrue_waitTimeMs5 = 15000L;
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$testDurabilityStartOffsetLapseTolerance$9(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)"events not processed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
        }
        long l6 = 100L;
        long waitUntilTrue_waitTimeMs6 = 15000L;
        long waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$testDurabilityStartOffsetLapseTolerance$11(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime6 + waitUntilTrue_waitTimeMs6) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs6), (long)waitUntilTrue_pause));
        }
        long l7 = 100L;
        long waitUntilTrue_waitTimeMs7 = 15000L;
        long waitUntilTrue_startTime7 = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$testDurabilityStartOffsetLapseTolerance$13(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime7 + waitUntilTrue_waitTimeMs7) {
                Assertions.fail((String)"lapse message found");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs7), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDurabilityAuditCatchingHighWaterMarkLapseInUncleanLeaderElection(String quorum) {
        this.initialize(true);
        this.produceMessages(5);
        Assertions.assertEquals((int)5, (int)this.consumeAllMessages(5).length());
        this.waitUntilAllPendingDurabilityEventsAreFlushed();
        this.log().truncateTo(3L);
        this.waitUntilAllPendingDurabilityEventsAreFlushed();
        boolean x$2 = this.recreateBrokers$default$1();
        this.recreateBrokers(x$2, true);
        this.initialize(false);
        this.waitUntilAllPendingDurabilityEventsAreFlushed();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditCatchingHighWaterMarkLapseInUncleanLeaderElection$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Not able to get log instance on restart");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        LogManager qual$2 = this.broker().replicaManager().logManager();
        TopicPartition x$5 = this.topicPartition();
        boolean x$6 = qual$2.getLog$default$2();
        this.log_$eq((AbstractLog)qual$2.getLog(x$5, x$6).get());
        this.auditManager_$eq((BrokerAuditManager)this.broker().auditManager().get());
        DurabilityDB db = this.auditManager().db();
        long l2 = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            long l3 = this.isEpochChangeEventMaterialized$1(db);
            Long computeUntilTrue_result = BoxesRunTime.boxToLong((long)l3);
            if (DurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditCatchingHighWaterMarkLapseInUncleanLeaderElection$4(l3)) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var19_13 = null;
        long l4 = 100L;
        long computeUntilTrue_waitTime2 = 15000L;
        long computeUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            long l5 = DurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditCatchingHighWaterMarkLapseInUncleanLeaderElection$5(this);
            Long computeUntilTrue_result = BoxesRunTime.boxToLong((long)l5);
            if (DurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditCatchingHighWaterMarkLapseInUncleanLeaderElection$6(l5)) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                return;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime2 + computeUntilTrue_waitTime2) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                return;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime2), (long)computeUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDurabilityAuditCatchingStartOffsetLapse(String quorum) {
        this.alterBrokerConfig(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "1000");
        this.alterBrokerConfig("retention.bytes", "-1");
        this.initialize(true);
        this.produceMessages(51);
        Assertions.assertEquals((int)51, (int)this.consumeAllMessages(51).length());
        this.waitUntilAllPendingDurabilityEventsAreFlushed();
        AbstractLog qual$1 = this.log();
        Option x$1 = qual$1.roll$default$1();
        long x$2 = qual$1.roll$default$2();
        qual$1.roll(x$1, x$2);
        this.produceMessages(51);
        Assertions.assertEquals((int)102, (int)this.consumeAllMessages(102).length());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditCatchingStartOffsetLapse$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"failed waiting for archiving");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitUntilAllPendingDurabilityEventsAreFlushed();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditCatchingStartOffsetLapse$3(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"failed waiting for audit manager to contain partition state");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        long l3 = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            long l4 = DurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditCatchingStartOffsetLapse$5(this);
            Long computeUntilTrue_result = BoxesRunTime.boxToLong((long)l4);
            if (DurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditCatchingStartOffsetLapse$6(l4)) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var24_15 = null;
        this.log().maybeIncrementLogStartOffset(55L, LogStartOffsetIncrementReason.LeaderOffsetIncremented);
        this.log().deleteOldSegments();
        this.waitUntilAllPendingDurabilityEventsAreFlushed();
        long l5 = 100L;
        long computeUntilTrue_waitTime2 = 15000L;
        long computeUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            long l6 = DurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditCatchingStartOffsetLapse$7(this);
            Long computeUntilTrue_result = BoxesRunTime.boxToLong((long)l6);
            if (DurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditCatchingStartOffsetLapse$8(l6)) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime2 + computeUntilTrue_waitTime2) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime2), (long)computeUntilTrue_pause));
        }
        Object var31_20 = null;
        long l7 = 100L;
        long computeUntilTrue_waitTime3 = 15000L;
        long computeUntilTrue_startTime3 = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            long l8 = DurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditCatchingStartOffsetLapse$9(this);
            Long computeUntilTrue_result = BoxesRunTime.boxToLong((long)l8);
            if (DurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditCatchingStartOffsetLapse$10(l8)) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                return;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime3 + computeUntilTrue_waitTime3) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                return;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime3), (long)computeUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDurabilityAuditHandlesDeleteRecord(String quorum) {
        this.alterBrokerConfig(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "1000");
        this.alterBrokerConfig("retention.bytes", "-1");
        this.initialize(true);
        this.produceMessages(50);
        Assertions.assertEquals((int)50, (int)this.consumeAllMessages(50).length());
        this.waitUntilAllPendingDurabilityEventsAreFlushed();
        AbstractLog qual$1 = this.log();
        Option x$1 = qual$1.roll$default$1();
        long x$2 = qual$1.roll$default$2();
        qual$1.roll(x$1, x$2);
        this.produceMessages(50);
        Assertions.assertEquals((int)100, (int)this.consumeAllMessages(100).length());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditHandlesDeleteRecord$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"failed waiting for archiving");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitUntilAllPendingDurabilityEventsAreFlushed();
        long l2 = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            long l3 = DurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditHandlesDeleteRecord$3(this);
            Long computeUntilTrue_result = BoxesRunTime.boxToLong((long)l3);
            if (DurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditHandlesDeleteRecord$4(l3)) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var19_12 = null;
        HostedPartition hostedPartition = this.broker().replicaManager().getPartition(this.log().topicPartition());
        if (hostedPartition instanceof HostedPartition.Online) {
            ((HostedPartition.Online)hostedPartition).partition().deleteRecordsOnLeader(50L);
        } else {
            new Fail((Object)new StringBuilder(32).append("Not able to find partition for ").append(this.broker()).append(" ").append(this.log().topicPartition()).toString());
        }
        this.waitUntilAllPendingDurabilityEventsAreFlushed();
        this.produceMessages(50);
        Assertions.assertEquals((int)100, (int)this.consumeAllMessages(100).length());
        this.waitUntilAllPendingDurabilityEventsAreFlushed();
        Assertions.assertEquals((long)50L, (long)this.log().logStartOffset());
        long l4 = 100L;
        long computeUntilTrue_waitTime2 = 15000L;
        long computeUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            long l5 = DurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditHandlesDeleteRecord$5(this);
            Long computeUntilTrue_result = BoxesRunTime.boxToLong((long)l5);
            if (DurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditHandlesDeleteRecord$6(l5)) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime2 + computeUntilTrue_waitTime2) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime2), (long)computeUntilTrue_pause));
        }
        Object var26_18 = null;
        long l6 = 100L;
        long computeUntilTrue_waitTime3 = 15000L;
        long computeUntilTrue_startTime3 = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            long l7 = DurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditHandlesDeleteRecord$7(this);
            Long computeUntilTrue_result = BoxesRunTime.boxToLong((long)l7);
            if (DurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditHandlesDeleteRecord$8(l7)) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                return;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime3 + computeUntilTrue_waitTime3) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                return;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime3), (long)computeUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilAllPendingDurabilityEventsAreFlushed$1(DurabilityAuditIntegrationTest $this) {
        Tuple2 tuple2 = $this.auditManager().getQueuedEvents();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(0, 0);
        return tuple2 != null && tuple2.equals(sp2);
    }

    public static final /* synthetic */ String $anonfun$waitUntilAllPendingDurabilityEventsAreFlushed$2() {
        return "Failed to flush all the events from durability audit queue.";
    }

    public static final /* synthetic */ Seq $anonfun$consumeAllMessages$1(DurabilityAuditIntegrationTest $this, int numMessages$1, KafkaConsumer consumer) {
        consumer.assign($this.topicPartitionList());
        consumer.seekToBeginning($this.topicPartitionList());
        return (Seq)TestUtils$.MODULE$.consumeRecords(consumer, numMessages$1, 15000L).map((Function1 & Serializable)x$7 -> (byte[])x$7.value());
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$initialize$1(DurabilityAuditIntegrationTest $this, Admin admin) {
        String x$2 = $this.topic();
        int x$3 = $this.partitions();
        Buffer<KafkaBroker> x$4 = $this.brokers();
        int x$5 = 1;
        Map x$6 = (Map)Map$.MODULE$.empty();
        Properties x$7 = new Properties();
        return TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$4, x$3, x$5, (Map<Object, Seq<Object>>)x$6, x$7);
    }

    public static final /* synthetic */ boolean $anonfun$initialize$2(DurabilityAuditIntegrationTest $this) {
        LogManager qual$1 = $this.broker().replicaManager().logManager();
        TopicPartition x$8 = $this.topicPartition();
        boolean x$9 = qual$1.getLog$default$2();
        return qual$1.getLog(x$8, x$9).isDefined();
    }

    public static final /* synthetic */ String $anonfun$initialize$3() {
        return "Log not ready";
    }

    public static final /* synthetic */ boolean $anonfun$prepareTierLog$3(DurabilityAuditIntegrationTest $this) {
        return $this.log().tierPartitionState().totalSize() > 0L;
    }

    public static final /* synthetic */ String $anonfun$prepareTierLog$4() {
        return "failed waiting for archiving";
    }

    public static final /* synthetic */ boolean $anonfun$prepareTierLog$5(DurabilityAuditIntegrationTest $this) {
        $this.log().deleteOldSegments();
        return $this.log().localLogStartOffset() > 0L;
    }

    public static final /* synthetic */ String $anonfun$prepareTierLog$6() {
        return "hot set reduction did not kick in";
    }

    public static final /* synthetic */ Void $anonfun$alterBrokerConfig$1(HashMap configs$1, ConfluentAdmin adminClient) {
        return (Void)adminClient.incrementalAlterConfigs((java.util.Map)configs$1).all().get(5L, TimeUnit.SECONDS);
    }

    public static final /* synthetic */ void $anonfun$testDurabilityAuditTopicConfigs$1(ConfluentAdmin adminClient) {
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, DurabilityAuditConstants$.MODULE$.TOPIC_NAME());
        Config topicConfig = (Config)((KafkaFuture)adminClient.describeConfigs(Collections.singletonList(resource)).values().get(resource)).get();
        Assertions.assertEquals((Object)"delete", (Object)topicConfig.get("cleanup.policy").value());
        Assertions.assertEquals((Object)Long.toString(DurabilityAuditConstants$.MODULE$.DURABILITY_TOPIC_RETENTION_MS()), (Object)topicConfig.get("retention.ms").value());
        Assertions.assertEquals((Object)Long.toString(-1L), (Object)topicConfig.get("retention.bytes").value());
    }

    public static final /* synthetic */ boolean $anonfun$testSimpleDurabilityAuditHandlesDeleteRecord$1(DurabilityAuditIntegrationTest $this) {
        return $this.log().tieredLogSegments().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testSimpleDurabilityAuditHandlesDeleteRecord$2() {
        return "Failed tier segment deletion";
    }

    public static final /* synthetic */ boolean $anonfun$testSimpleDurabilityAuditHandlesDeleteRecord$3(DurabilityAuditIntegrationTest $this) {
        return ((PartitionState)$this.auditManager().db().fetchPartitionState($this.log().topicPartition()).get()).startOffset() == $this.log().localLogStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testSimpleDurabilityAuditHandlesDeleteRecord$4() {
        return "Timeout waiting for durability event materialization";
    }

    public static final /* synthetic */ boolean $anonfun$testSimpleDurabilityAuditTierDeletionLapse$1(DurabilityAuditIntegrationTest $this) {
        return $this.log().tieredLogSegments().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testSimpleDurabilityAuditTierDeletionLapse$2() {
        return "Failed tier segment deletion";
    }

    public static final /* synthetic */ boolean $anonfun$testSimpleDurabilityAuditTierDeletionLapse$3(DurabilityAuditIntegrationTest $this) {
        return ((PartitionState)$this.auditManager().db().fetchPartitionState($this.log().topicPartition()).get()).startOffset() == $this.log().localLogStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testSimpleDurabilityAuditTierDeletionLapse$4() {
        return "Timeout waiting for durability event materialization";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditTierDeletionDueToSzBreach$1(DurabilityAuditIntegrationTest $this) {
        return $this.log().logStartOffset() > 1L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditTierDeletionDueToSzBreach$2() {
        return "Failed retention based tier deletion";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditTierDeletionDueToSzBreach$3(DurabilityAuditIntegrationTest $this) {
        return BoxesRunTime.unboxToLong((Object)$this.log().tieredLogSegments().toList().headOption().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.baseOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)) > 0L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditTierDeletionDueToSzBreach$6() {
        return "not deleted";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditTierDeletionDueToSzBreach$7(DurabilityAuditIntegrationTest $this, long offset$1) {
        return $this.log().logStartOffset() > offset$1;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditTierDeletionDueToSzBreach$8() {
        return "Failed retention based tier deletion";
    }

    public static final /* synthetic */ boolean $anonfun$testRetentionChangeEventDurabilityAudit$1(DurabilityAuditIntegrationTest $this) {
        return $this.log().maybeIncrementLogStartOffset(10L, LogStartOffsetIncrementReason.LeaderOffsetIncremented);
    }

    public static final /* synthetic */ String $anonfun$testRetentionChangeEventDurabilityAudit$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$testRetentionChangeEventDurabilityAudit$3(DurabilityAuditIntegrationTest $this) {
        return $this.log().logStartOffset() == 10L;
    }

    public static final /* synthetic */ String $anonfun$testRetentionChangeEventDurabilityAudit$4() {
        return "Failed retention based tier deletion";
    }

    public static final /* synthetic */ long $anonfun$testRetentionChangeEventDurabilityAudit$5(DurabilityAuditIntegrationTest $this) {
        return BoxesRunTime.unboxToLong((Object)$this.log().tieredLogSegments().toList().headOption().map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.baseOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
    }

    public static final /* synthetic */ boolean $anonfun$testRetentionChangeEventDurabilityAudit$8(long x$10) {
        return x$10 > 0L;
    }

    public static final /* synthetic */ long $anonfun$testRetentionChangeEventDurabilityAudit$9(DurabilityAuditIntegrationTest $this) {
        return $this.auditManager().metricsManager().totalLostMessages();
    }

    public static final /* synthetic */ boolean $anonfun$testRetentionChangeEventDurabilityAudit$10(long x$11) {
        return x$11 > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$testRetentionChangeEventDurabilityAudit$13(DurabilityAuditIntegrationTest $this) {
        return ((PartitionState)$this.auditManager().db().fetchPartitionState($this.log().topicPartition()).get()).retentionSz() == 1000L;
    }

    public static final /* synthetic */ String $anonfun$testRetentionChangeEventDurabilityAudit$14() {
        return "Retention event not propagated";
    }

    public static final /* synthetic */ boolean $anonfun$testRetentionChangeEventDurabilityAudit$15(DurabilityAuditIntegrationTest $this) {
        return $this.log().maybeIncrementLogStartOffset(20L, LogStartOffsetIncrementReason.LeaderOffsetIncremented);
    }

    public static final /* synthetic */ String $anonfun$testRetentionChangeEventDurabilityAudit$16() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$testRetentionChangeEventDurabilityAudit$17(DurabilityAuditIntegrationTest $this) {
        return $this.log().logStartOffset() >= 20L;
    }

    public static final /* synthetic */ String $anonfun$testRetentionChangeEventDurabilityAudit$18() {
        return "Failed retention based tier deletion";
    }

    public static final /* synthetic */ long $anonfun$testRetentionChangeEventDurabilityAudit$19(DurabilityAuditIntegrationTest $this) {
        return BoxesRunTime.unboxToLong((Object)$this.log().tieredLogSegments().toList().headOption().map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.baseOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
    }

    public static final /* synthetic */ boolean $anonfun$testRetentionChangeEventDurabilityAudit$22(long x$13) {
        return x$13 >= 20L;
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditHighWaterMarkEpochChangeEvent$1(DurabilityAuditIntegrationTest $this, long end$1) {
        return ((PartitionState)$this.auditManager().db().fetchPartitionState($this.log().topicPartition()).get()).highWatermark() == end$1;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditHighWaterMarkEpochChangeEvent$2() {
        return "HWM not set";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditHighWaterMarkEpochChangeEvent$4(DurabilityAuditIntegrationTest $this, long end$1) {
        return ((PartitionState)$this.auditManager().db().fetchPartitionState($this.log().topicPartition()).get()).highWatermark() == end$1 - 5L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditHighWaterMarkEpochChangeEvent$5() {
        return "HWM not updated";
    }

    public static final /* synthetic */ long $anonfun$testDurabilityAuditHighWaterMarkEpochChangeEvent$6(DurabilityAuditIntegrationTest $this) {
        return $this.auditManager().metricsManager().totalLostMessages();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditHighWaterMarkEpochChangeEvent$7(long x$14) {
        return x$14 > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditDeletePartitionEvent$1(DurabilityAuditIntegrationTest $this, long end$2) {
        return ((PartitionState)$this.auditManager().db().fetchPartitionState($this.log().topicPartition()).get()).highWatermark() == end$2;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditDeletePartitionEvent$2() {
        return "HWM not set";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditDeletePartitionEvent$3(DurabilityAuditIntegrationTest $this) {
        return $this.auditManager().db().fetchPartitionState($this.log().topicPartition()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditDeletePartitionEvent$4() {
        return "Partition record does not exists";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditDeletePartitionEvent$5(DurabilityAuditIntegrationTest $this) {
        return $this.auditManager().db().fetchPartitionState($this.log().topicPartition()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditDeletePartitionEvent$6() {
        return "Partition record still exists";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityStartOffsetLapseTolerance$1(DurabilityAuditIntegrationTest $this) {
        return $this.auditManager().metricsManager().totalLostMessages() == 0L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityStartOffsetLapseTolerance$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityStartOffsetLapseTolerance$3(DurabilityAuditIntegrationTest $this) {
        return $this.log().tierPartitionState().totalSize() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityStartOffsetLapseTolerance$4() {
        return "failed waiting for archiving";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityStartOffsetLapseTolerance$5(DurabilityAuditIntegrationTest $this) {
        return ((PartitionState)$this.auditManager().db().fetchPartitionState($this.log().topicPartition()).get()).startOffset() == $this.log().logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testDurabilityStartOffsetLapseTolerance$6() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityStartOffsetLapseTolerance$7(DurabilityAuditIntegrationTest $this) {
        return ((PartitionState)$this.auditManager().db().fetchPartitionState($this.log().topicPartition()).get()).lapseWatchStartTime() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityStartOffsetLapseTolerance$8() {
        return "events not processed";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityStartOffsetLapseTolerance$9(DurabilityAuditIntegrationTest $this) {
        return ((PartitionState)$this.auditManager().db().fetchPartitionState($this.log().topicPartition()).get()).lapseWatchStartTime() == 0L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityStartOffsetLapseTolerance$10() {
        return "events not processed";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityStartOffsetLapseTolerance$11(DurabilityAuditIntegrationTest $this) {
        return ((PartitionState)$this.auditManager().db().fetchPartitionState($this.log().topicPartition()).get()).startOffset() == $this.log().logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testDurabilityStartOffsetLapseTolerance$12() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityStartOffsetLapseTolerance$13(DurabilityAuditIntegrationTest $this) {
        return $this.auditManager().metricsManager().totalLostMessages() == 0L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityStartOffsetLapseTolerance$14() {
        return "lapse message found";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditCatchingHighWaterMarkLapseInUncleanLeaderElection$1(DurabilityAuditIntegrationTest $this) {
        LogManager qual$1 = $this.broker().replicaManager().logManager();
        TopicPartition x$3 = $this.topicPartition();
        boolean x$4 = qual$1.getLog$default$2();
        return qual$1.getLog(x$3, x$4).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditCatchingHighWaterMarkLapseInUncleanLeaderElection$2() {
        return "Not able to get log instance on restart";
    }

    private final long isEpochChangeEventMaterialized$1(DurabilityDB db$1) {
        PartitionState state = (PartitionState)db$1.fetchPartitionState(this.log().topicPartition()).get();
        return BoxesRunTime.unboxToLong((Object)state.epochChain().apply((Object)BoxesRunTime.boxToInteger((int)state.latestEpoch())));
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditCatchingHighWaterMarkLapseInUncleanLeaderElection$4(long x$15) {
        return x$15 == 3L;
    }

    public static final /* synthetic */ long $anonfun$testDurabilityAuditCatchingHighWaterMarkLapseInUncleanLeaderElection$5(DurabilityAuditIntegrationTest $this) {
        return $this.auditManager().metricsManager().totalLostMessages();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditCatchingHighWaterMarkLapseInUncleanLeaderElection$6(long x$16) {
        return x$16 == 5L;
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditCatchingStartOffsetLapse$1(DurabilityAuditIntegrationTest $this) {
        return $this.log().tierPartitionState().totalSize() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditCatchingStartOffsetLapse$2() {
        return "failed waiting for archiving";
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditCatchingStartOffsetLapse$3(DurabilityAuditIntegrationTest $this) {
        return $this.auditManager().db().fetchPartitionState($this.log().topicPartition()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditCatchingStartOffsetLapse$4() {
        return "failed waiting for audit manager to contain partition state";
    }

    public static final /* synthetic */ long $anonfun$testDurabilityAuditCatchingStartOffsetLapse$5(DurabilityAuditIntegrationTest $this) {
        return ((PartitionState)$this.auditManager().db().fetchPartitionState($this.log().topicPartition()).get()).highWatermark();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditCatchingStartOffsetLapse$6(long x$17) {
        return x$17 == 102L;
    }

    public static final /* synthetic */ long $anonfun$testDurabilityAuditCatchingStartOffsetLapse$7(DurabilityAuditIntegrationTest $this) {
        return ((PartitionState)$this.auditManager().db().fetchPartitionState($this.log().topicPartition()).get()).startOffset();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditCatchingStartOffsetLapse$8(long x$18) {
        return x$18 == 55L;
    }

    public static final /* synthetic */ long $anonfun$testDurabilityAuditCatchingStartOffsetLapse$9(DurabilityAuditIntegrationTest $this) {
        return $this.auditManager().metricsManager().totalLostMessages();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditCatchingStartOffsetLapse$10(long x$19) {
        return x$19 > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditHandlesDeleteRecord$1(DurabilityAuditIntegrationTest $this) {
        return $this.log().tierPartitionState().totalSize() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testDurabilityAuditHandlesDeleteRecord$2() {
        return "failed waiting for archiving";
    }

    public static final /* synthetic */ long $anonfun$testDurabilityAuditHandlesDeleteRecord$3(DurabilityAuditIntegrationTest $this) {
        return $this.auditManager().metricsManager().totalLostMessages();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditHandlesDeleteRecord$4(long x$20) {
        return x$20 == 0L;
    }

    public static final /* synthetic */ long $anonfun$testDurabilityAuditHandlesDeleteRecord$5(DurabilityAuditIntegrationTest $this) {
        return ((PartitionState)$this.auditManager().db().fetchPartitionState($this.log().topicPartition()).get()).highWatermark();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditHandlesDeleteRecord$6(long x$21) {
        return x$21 == 150L;
    }

    public static final /* synthetic */ long $anonfun$testDurabilityAuditHandlesDeleteRecord$7(DurabilityAuditIntegrationTest $this) {
        return $this.auditManager().metricsManager().totalLostMessages();
    }

    public static final /* synthetic */ boolean $anonfun$testDurabilityAuditHandlesDeleteRecord$8(long x$22) {
        return x$22 == 0L;
    }

    public DurabilityAuditIntegrationTest() {
        this.partitions = 1;
        this.partitionId = 0;
        this.brokerId = 0;
        this.serverConfig().setProperty("confluent.durability.audit.enable", Boolean.toString(true));
        this.serverConfig().setProperty("confluent.durability.topic.replication.factor", "1");
        this.serverConfig().setProperty("confluent.durability.topic.partition.count", "1");
        this.serverConfig().setProperty("confluent.durability.audit.batch.flush.frequency.ms", "1500");
        this.serverConfig().setProperty("confluent.durability.events.allowed", "OffsetChangeType,EpochChangeType,IsrExpandType,DeleteRecordsType,RetentionChangeType,StartOffsetChangeType,DeletePartitionType,HealthCheckType");
        this.serverConfig().setProperty("confluent.durability.audit.idempotent.producer", Boolean.toString(false));
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), Boolean.toString(true));
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownMaxRetriesProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownRetryBackoffMsProp(), "1000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), Boolean.toString(true));
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp(), "10");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), "1");
        this.configureMock();
    }

    public static final /* synthetic */ Object $anonfun$testDurabilityAuditTopicConfigs$1$adapted(ConfluentAdmin adminClient) {
        DurabilityAuditIntegrationTest.$anonfun$testDurabilityAuditTopicConfigs$1(adminClient);
        return BoxedUnit.UNIT;
    }
}

